PROMPT Creating Trigger 'BUR_TPKA_RNKASA'
CREATE OR REPLACE TRIGGER BUR_TPKA_RNKASA
 BEFORE UPDATE
 ON TPKA_RNKASA
 FOR EACH ROW
BEGIN
  :NEW.datum := TRUNC (:NEW.datum);
  IF :NEW.datum > TRUNC (SYSDATE) THEN -- IRN 1845
    -- Datum RNK #0 ne moe biti vei od tekueg #1!
    pra_pka_zaj.vrati_poruku (-20104, :NEW.rbr, TO_CHAR (SYSDATE, 'DD.MM.RRRR'));
  END IF;
  pra_pka.zabrani_izmjenu_dokumenta (:OLD.oznaka);
  pra_tpka_rnkasa.provjeri_pkaobr (:OLD.id, :NEW.oznaka);
  pra_tpka_rnkasa.provjeri_arc (:OLD.id, :NEW.rac_id, :NEW.pkarac_id);
  pra_pka.provjeri_vapldok (:NEW.pkarac_id);
  pra_tpka_rnkasa.provjeri_pkarnk_ara (:NEW.recara_id);

  IF :NEW.ozn_unosa <> :OLD.ozn_unosa THEN -- IRN 1878
    -- Promjena oznake unosa RNK nije doputena!
    pra_pka_zaj.vrati_poruku (-20117);
  END IF;

  -- 22.11.2007. G.J.
  IF :NEW.zmpojr_id <> :OLD.zmpojr_id THEN
    pra_pka_zaj.vrati_poruku (-20096);
  END IF;

  -- 22.11.2007. G.J.
  IF :NEW.ozn_izvorni = -1
    AND (:NEW.ozn_izvorni <> :OLD.ozn_izvorni
      OR :NEW.god_poslovna <> :OLD.god_poslovna
      OR :NEW.gmpkas_id <> :OLD.gmpkas_id
      OR :NEW.rbr <> :OLD.rbr)
  THEN
    :NEW.god_poslovna_izvor := :NEW.god_poslovna;
    :NEW.gmpkas_id_izvor := :NEW.gmpkas_id;
    :NEW.rbr_izvor := :NEW.rbr;
  ELSIF :NEW.ozn_izvorni = 0
    AND :NEW.ozn_izvorni <> :OLD.ozn_izvorni
  THEN
    :NEW.god_poslovna_izvor := TO_CHAR (NULL);
    :NEW.gmpkas_id_izvor := NULL;
    :NEW.rbr_izvor := TO_CHAR (NULL);
  END IF;

  /*
  Zaraunat ili obraunat interni POS raun ne moe se mijenjati.
  Mora se dopustiti nuliranje rac_id i pkarac_id jer se to radi kod
  ponitavanja REC i PKA rauna.
  */
  IF (:OLD.rac_id IS NOT NULL
      AND pra_rec_s.rac_pripada_rp (:OLD.rac_id) = 0
      AND :NEW.rac_id IS NOT NULL)
    OR (:OLD.pkarac_id IS NOT NULL AND :NEW.pkarac_id IS NOT NULL)
    OR pra_rec_s.obracunato (:OLD.id) = -1
  THEN
    IF :NEW.id <> :OLD.id
      OR :NEW.gmpkas_id <> :OLD.gmpkas_id
      -- IRN 2872 -- OR :NEW.vplaval_id <> :OLD.vplaval_id
      OR NVL (:NEW.gost_id, -1) <> NVL (:OLD.gost_id, -1)
      OR NVL (:NEW.age_id, -1) <> NVL (:OLD.age_id, -1)
      OR NVL (:NEW.pkaadr_id, -1) <> NVL (:OLD.pkaadr_id, -1)
      OR NVL (:NEW.gostp_id, -1) <> NVL (:OLD.gostp_id, -1)
      OR NVL (:NEW.agep_id, -1) <> NVL (:OLD.agep_id, -1)
      OR NVL (:NEW.pkaadrp_id, -1) <> NVL (:OLD.pkaadrp_id, -1)
      OR NVL (:NEW.rac_id, -1) <> NVL (:OLD.rac_id, -1)
      OR NVL (:NEW.pkarac_id, -1) <> NVL (:OLD.pkarac_id, -1)
      OR :NEW.god_poslovna <> :OLD.god_poslovna
      OR :NEW.rbr <> :OLD.rbr
      OR :NEW.oznaka <> :OLD.oznaka
      OR :NEW.ozn_unosa <> :OLD.ozn_unosa
      OR :NEW.datum <> :OLD.datum
      OR :NEW.izn_placanja <> :OLD.izn_placanja
      OR :NEW.izn_ppot <> :OLD.izn_ppot
      -- opis1
      -- opis2
      OR NVL (:NEW.recara_id, 0) <> NVL (:OLD.recara_id, 0)
      OR NVL (:NEW.vpdog_id, 0) <> NVL (:OLD.vpdog_id, 0)
      -- zmpojr_id -- ve je zabranjeno mijenjati
      -- 22.11.2007. G.J.
      OR :NEW.ozn_izvorni <> :OLD.ozn_izvorni
      OR NVL (:NEW.god_poslovna_izvor, 0) <> NVL (:OLD.god_poslovna_izvor, 0)
      OR NVL (:NEW.gmpkas_id_izvor, 0) <> NVL (:OLD.gmpkas_id_izvor, 0)
      OR NVL (:NEW.rbr_izvor, 0) <> NVL (:OLD.rbr_izvor, 0)
      -- IRN 1845
      OR NVL (:NEW.nac_id, 0) <> NVL (:OLD.nac_id, 0)
      OR :NEW.stopa_ppot <> :OLD.stopa_ppot
      OR :NEW.izn_osnovice_ppot <> :OLD.izn_osnovice_ppot
      -- br_transakcije
      -- br_autorizacije
      -- pkakar_id
      OR NVL (:NEW.izn_popusta, 0) <> NVL (:OLD.izn_popusta, 0) -- IRN 4015
      -- IRN 2872
      OR :NEW.domval_id <> :OLD.domval_id
      OR :NEW.vpla_id <> :OLD.vpla_id
      OR NVL (:NEW.vpla2_id, 0) <> NVL (:OLD.vpla2_id, 0)
      OR NVL (:NEW.izn_placanja2, 0) <> NVL (:OLD.izn_placanja2, 0)
      -- IRN 3784
      OR NVL (:NEW.izn_pnaknade, 0) <> NVL (:OLD.izn_pnaknade, 0)
      OR NVL (:NEW.vpla_napojnice_id, 0) <> NVL (:OLD.vpla_napojnice_id, 0)
      OR NVL (:NEW.izn_napojnice, 0) <> NVL (:OLD.izn_napojnice, 0)
      OR NVL (:NEW.oib_operatera, 0) <> NVL (:OLD.oib_operatera, 0)
      OR NVL (:NEW.naz_operatera, 0) <> NVL (:OLD.naz_operatera, 0)
      OR NVL (TO_CHAR (:NEW.dat_fnapojnice), 0) <> NVL (TO_CHAR (:OLD.dat_fnapojnice), 0)
      OR NVL (:NEW.izn_popusta2, 0) <> NVL (:OLD.izn_popusta2, 0) -- IRN 4015
    THEN
      -- Zaraunat ili obraunat interni POS raun ne moe se mijenjati.
      pra_pka_zaj.vrati_poruku (-20056);
    END IF;
  END IF;

  pra_tpka_rnkasa.provjeri_pkaadr_rbr_vpla_sifra (:NEW.pkaadr_id, :NEW.vpla_id);  -- IRN 1886, IRN 2872
  pra_tpka_rnkasa.provjeri_pkaadr_rbr_vpla_sifra (:NEW.pkaadr_id, :NEW.vpla2_id); -- IRN 2872

  pra_tpka_rnkasa.provjeri_vpla2_id (:NEW.vpla_id, :NEW.vpla2_id, :NEW.vpla_napojnice_id, :NEW.gostp_id, :NEW.agep_id, :NEW.pkaadrp_id); -- IRN 2872, IRN 3784

  pra_tpka_rnkasa.provjeri_vplaval (:NEW.datum, :NEW.gmpkas_id, :NEW.vpla_id, :NEW.domval_id); -- IRN 2872, 3545
  pra_tpka_rnkasa.provjeri_vplaval (:NEW.datum, :NEW.gmpkas_id, :NEW.vpla2_id, :NEW.domval_id); -- IRN 2872, 3545
  pra_tpka_rnkasa.provjeri_vplaval (:NEW.datum, :NEW.gmpkas_id, :NEW.vpla_napojnice_id, :NEW.domval_id); -- IRN 3784

  pra_pka_zaj.puni_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIR_TPKA_RNKASA'
CREATE OR REPLACE TRIGGER BIR_TPKA_RNKASA
 BEFORE INSERT
 ON TPKA_RNKASA
 FOR EACH ROW
DECLARE

  br_redaka_l NUMBER;
BEGIN

  -- IRN 2888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN; -- izlaz iz trigera
  END IF;

  :NEW.id := pra_zmp_zaj.i3_sekvenca (:NEW.id);
  :NEW.datum := TRUNC (:NEW.datum);
  IF :NEW.datum > TRUNC (SYSDATE) THEN -- IRN 1845
    -- Datum RNK #0 ne moe biti vei od tekueg #1!
    pra_pka_zaj.vrati_poruku (-20104, :NEW.rbr, TO_CHAR (SYSDATE, 'DD.MM.RRRR'));
  END IF;
  :NEW.god_poslovna := pra_pka_zaj.poslovna_godina (:NEW.god_poslovna);

  IF :NEW.zmpojr_id IS NULL THEN
    :NEW.zmpojr_id := pra_zmp_s.gmpkas_zmpojr_id (:NEW.gmpkas_id);
  END IF;

  IF :NEW.ozn_izvorni = -1 THEN
    :NEW.god_poslovna_izvor := :NEW.god_poslovna;
    :NEW.gmpkas_id_izvor := :NEW.gmpkas_id;
    :NEW.rbr_izvor := :NEW.rbr;
  END IF;

  pra_tpka_rnkasa.provjeri_arc (:NEW.id, :NEW.rac_id, :NEW.pkarac_id);
  pra_pka.provjeri_vapldok (:NEW.pkarac_id);
  pra_tpka_rnkasa.provjeri_pkarnk_ara (:NEW.recara_id);

  -- IRN 1878
  SELECT COUNT (1) INTO br_redaka_l
    FROM mgmp_kase
   WHERE :NEW.ozn_unosa = 'A'
     AND id = :NEW.gmpkas_id
     AND metapl_sifra = 'KAG';
  IF br_redaka_l > 0 THEN
    -- Automatsko knjienje rauna sa kasa vrste KAG nije doputeno!
    pra_pka_zaj.vrati_poruku (-20116);
  END IF;

  pra_tpka_rnkasa.provjeri_pkaadr_rbr_vpla_sifra (:NEW.pkaadr_id, :NEW.vpla_id);  -- IRN 1886, IRN 2872
  pra_tpka_rnkasa.provjeri_pkaadr_rbr_vpla_sifra (:NEW.pkaadr_id, :NEW.vpla2_id); -- IRN 2872

  pra_tpka_rnkasa.provjeri_vpla2_id (:NEW.vpla_id, :NEW.vpla2_id, :NEW.vpla_napojnice_id, :NEW.gostp_id, :NEW.agep_id, :NEW.pkaadrp_id); -- IRN 2872, IRN 3784

  pra_tpka_rnkasa.provjeri_vplaval (:NEW.datum, :NEW.gmpkas_id, :NEW.vpla_id, :NEW.domval_id); -- IRN 2872, 03545
  pra_tpka_rnkasa.provjeri_vplaval (:NEW.datum, :NEW.gmpkas_id, :NEW.vpla2_id, :NEW.domval_id); -- IRN 2872, 03545
  pra_tpka_rnkasa.provjeri_vplaval (:NEW.datum, :NEW.gmpkas_id, :NEW.vpla_napojnice_id, :NEW.domval_id); -- IRN 3784

  pra_pka_zaj.puni_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BDR_TPKA_RNKASA'
CREATE OR REPLACE TRIGGER BDR_TPKA_RNKASA
 BEFORE DELETE
 ON TPKA_RNKASA
 FOR EACH ROW
BEGIN
  pra_tpka_racuni.provjeri_pkarac_oznaka (:OLD.pkarac_id);
END;
/
SHOW ERROR
