PROMPT Creating Trigger 'BIR_TPKA_RNK_ISP'
CREATE OR REPLACE TRIGGER BIR_TPKA_RNK_ISP
 BEFORE INSERT
 ON TPKA_RNK_ISP
 FOR EACH ROW
BEGIN
  -- IRN 2888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN; -- izlaz iz trigera
  END IF;

  :NEW.id := pra_zmp_zaj.i3_sekvenca (:NEW.id);
  pra_zmp_s2.provjeri_kpd (:NEW.kpd_id); -- IRN 4103

  pra_pka_zaj.puni_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat); 
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUR_TPKA_RNK_ISP'
CREATE OR REPLACE TRIGGER BUR_TPKA_RNK_ISP
 BEFORE UPDATE
 ON TPKA_RNK_ISP
 FOR EACH ROW
BEGIN
  pra_zmp_s2.provjeri_kpd (:NEW.kpd_id); -- IRN 4103
  pra_pka_zaj.puni_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat); 
END;
/
SHOW ERROR
