-- C:\Radni\tpka_racuni.trg
--
-- Generated for Oracle 10g on Fri Oct 03  09:30:03 2025 by Server Generator 6.5.96.5.6
 























PROMPT Creating Trigger 'AUS_TPKA_RACUNI'
CREATE OR REPLACE TRIGGER AUS_TPKA_RACUNI
 AFTER UPDATE
 ON TPKA_RACUNI
DECLARE

  zapis_l tab_tpka_racuni.pkarac_rec_type;
BEGIN
  tab_tpka_racuni.postavi_iterator;
  WHILE tab_tpka_racuni.ima_jos LOOP
    zapis_l := tab_tpka_racuni.sljedeci_red;
    pra_tpka_racuni.zabrani_ponistavanje ( -- IRN 2026
      zapis_l.id,
      zapis_l.oznaka_nova);
    pra_tpka_racuni.provjeri_predujam ( -- IRN 2026
      zapis_l.id,
      zapis_l.pkaracd_id);

    IF zapis_l.oznaka_nova = 'P' AND zapis_l.oznaka_stara = 'V' THEN
      IF pra_pka_domval.vrijednost_pkaprod ('REC_PKARAC_PRED') = 1 THEN
      -- posebno ponaanje ako je u tijeku prelazak na novu domau valutu
        NULL;
      ELSE
        pra_tpka_racuni.ponisti_racun (zapis_l.id);
      END IF;
    END IF;

  END LOOP;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUR_TPKA_RACUNI'
CREATE OR REPLACE TRIGGER BUR_TPKA_RACUNI
 BEFORE UPDATE
 ON TPKA_RACUNI
 FOR EACH ROW
DECLARE

  zapis_l tab_tpka_racuni.pkarac_rec_type;
BEGIN
  :NEW.datum := TRUNC (:NEW.datum);
  pra_tpka_racuni.provjeri_pkarac_datum (:OLD.vapldok_id, :NEW.datum, :OLD.datum); -- IRN 1847

  :NEW.datum_za_n := TRUNC (:NEW.datum_za_n);
  -- :NEW.god_poslovna_za_n := TO_CHAR (:NEW.datum_za_n, 'RRRR'); -- IRN 1887

  :NEW.dat_nobveze := TRUNC (:NEW.dat_nobveze);
  :NEW.dat_dospijeca := TRUNC (:NEW.dat_dospijeca);
  
  IF :OLD.oznaka <> :NEW.oznaka THEN -- IRN 3561 
    pra_pka_s.provjeri_dat_zabranjen (:NEW.oj_id, 'TPKA_RACUNI', :OLD.datum);
    pra_pka_s.provjeri_dat_zabranjen (:NEW.oj_id, 'TPKA_RACUNI', :NEW.datum);
  END IF;

  IF :NEW.datum <> :OLD.datum THEN
    -- 23.10.2007. G.J.
    IF pra_zmp.vapldok_oznaka (:NEW.vapldok_id) NOT IN ('BP', 'GP') THEN
      pra_pka_s.provjeri_pkadne_datum (:NEW.oj_id, :NEW.datum);
      pra_tpka_racuni.provjeri_zmpsizv_razdoblje (:NEW.id, :NEW.datum);
    END IF;
  END IF;

  -- Zabrani izmjenu UK
  IF :NEW.god_poslovna <> :OLD.god_poslovna
    OR :NEW.oj_id <> :OLD.oj_id
    OR :NEW.vapldok_id <> :OLD.vapldok_id
    OR :NEW.rbr <> :OLD.rbr
  THEN
    pra_pka_zaj.vrati_poruku (-20027);
  END IF;
  pra_tpka_racuni.zabrani_izmjenu_pkarac (:OLD.oznaka); -- IRN 1847

  IF pra_pka_domval.vrijednost_pkaprod ('REC_PKARAC_PRED') = 1 THEN
    -- posebno ponaanje ako je u tijeku prelazak
    NULL;
  ELSE
    -- standardna provjera
    pra_tpka_racuni.provjeri_pkaobr (:OLD.id, :NEW.oznaka);
  END IF;

  -- Zabrani izmjenu UK za iskoriteni predujam i prevezivanje predujma za djel. ponitavanje na drugi predujam
  IF NVL (:NEW.pkaracd_id, 0) <> NVL (:OLD.pkaracd_id, 0)
     OR NVL (:NEW.raci_id, 0) <> NVL (:OLD.raci_id, 0)
     OR NVL (:NEW.pkaraci_id, 0) <> NVL (:OLD.pkaraci_id, 0)
  THEN
    -- Poniteni predujam ne moete prevezati na drugi raun.
    pra_pka_zaj.vrati_poruku (-20119);
  END IF;

  -- 13.10.2006. G.J.
  IF NVL (:NEW.gmpkom_id, -1) <> NVL (:OLD.gmpkom_id, -1) THEN
    :NEW.poziv_na_broj := pra_tpka_racuni.poziv_na_broj (
      :NEW.oj_id,
      :NEW.vapldok_id,
      :NEW.gmpkom_id,
      :NEW.god_poslovna,
      :NEW.rbr);
  END IF;

  -- puni PL/SQL tablicu
  -- za ponitavanje rauna i provjeru predujma
  zapis_l.id := :NEW.id;
  zapis_l.pkaracd_id := :NEW.pkaracd_id; -- IRN 2026
  zapis_l.oznaka_nova := :NEW.oznaka;
  zapis_l.oznaka_stara := :OLD.oznaka;
  zapis_l.finpred_id := :NEW.finpred_id;
  zapis_l.finpred_uk := :NEW.finpred_uk;
  tab_tpka_racuni.puni_tablicu (zapis_l);

  pra_pka_zaj.puni_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'AIS_TPKA_RACUNI'
CREATE OR REPLACE TRIGGER AIS_TPKA_RACUNI
 AFTER INSERT
 ON TPKA_RACUNI
DECLARE

  zapis_l tab_tpka_racuni.pkarac_rec_type;
BEGIN
  tab_tpka_racuni.postavi_iterator;
  WHILE tab_tpka_racuni.ima_jos LOOP
    zapis_l := tab_tpka_racuni.sljedeci_red;
    pra_tpka_racuni.provjeri_predujam ( -- IRN 2026
      zapis_l.id,
      zapis_l.pkaracd_id);
    pra_tpka_racuni.provjeri_iskoristeni_predujam (
      zapis_l.pkaracd_id,
      zapis_l.raci_id,
      zapis_l.pkaraci_id);
  END LOOP;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUS_TPKA_RACUNI'
CREATE OR REPLACE TRIGGER BUS_TPKA_RACUNI
 BEFORE UPDATE
 ON TPKA_RACUNI
BEGIN
  tab_tpka_racuni.brisi_tablicu;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIS_TPKA_RACUNI'
CREATE OR REPLACE TRIGGER BIS_TPKA_RACUNI
 BEFORE INSERT
 ON TPKA_RACUNI
BEGIN
  tab_tpka_racuni.brisi_tablicu;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIR_TPKA_RACUNI'
CREATE OR REPLACE TRIGGER BIR_TPKA_RACUNI
 BEFORE INSERT
 ON TPKA_RACUNI
 FOR EACH ROW
DECLARE

  zapis_l tab_tpka_racuni.pkarac_rec_type;
  finpred_id_l tpka_racuni.finpred_id%TYPE;
  finpred_uk_l tpka_racuni.finpred_uk%TYPE;     
  dat_erac_obveze_l DATE := pra_zmp_s.dat_erac_obveze; -- IRN 4098
  vapldok_oznaka_l s_vapldok.oznaka%TYPE; -- IRN 4098
BEGIN
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN;
  END IF;

  :NEW.id := pra_pka_zaj.sekvenca (:NEW.id);
  :NEW.datum := TRUNC (:NEW.datum);

  IF pra_pka_domval.vrijednost_pkaprod ('REC_PKARAC_PRED') = 1 THEN
    -- posebno ponaanje ako je u tijeku prelazak na novu domau valutu
    NULL;
  ELSE
    pra_tpka_racuni.provjeri_pkarac_datum (:NEW.vapldok_id, :NEW.datum, NULL); -- IRN 1847
  END IF;

  -- IRN 3565; Datum dokumenta na arhivskoj shemi mora biti manji od datuma primjene domae valute.
  pra_pka_domval.provjeri_arh_datum (:NEW.datum);

  :NEW.dat_nobveze := TRUNC (:NEW.dat_nobveze);
  :NEW.dat_dospijeca := TRUNC (:NEW.dat_dospijeca);
  pra_pka_zaj.puni_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat); -- IRN 4098
  :NEW.god_poslovna := TO_CHAR (:NEW.unos_dat, 'RRRR');  -- IRN 4098
  :NEW.datum_za_n := TRUNC (:NEW.datum_za_n);
  -- :NEW.god_poslovna_za_n := TO_CHAR (:NEW.datum_za_n, 'RRRR'); -- IRN 1887
  pra_zmp.vrati_vdok (:NEW.vapldok_id, :NEW.unos_dat, :NEW.vdok_id, :NEW.vdok_sifra2N, dat_erac_obveze_l);  -- IRN 2439, IRN 4098
  :NEW.oj_sifra := pra_zmp.oj_sifra (:NEW.oj_id);
  :NEW.guid := pra_zmp_zaj.formatted_guid (:NEW.guid);

  pra_pka_s.provjeri_dat_zabranjen (:NEW.oj_id, 'TPKA_RACUNI', :NEW.datum);
  
  vapldok_oznaka_l := pra_zmp.vapldok_oznaka (:NEW.vapldok_id);
  
  IF vapldok_oznaka_l IN ('BP', 'GP') -- raun za predujam, IRN 4098
    AND pra_zmp.je_vdok_isporuka (:NEW.vdok_id) <> -1
  THEN
    /*
    vdok rauna za predujam nije jednak vdok rauna za isporuku, odnosno
    brojevi rauna za predujmove nisu u zajednikom nizu s brojevima rauna za isporuke
    */
    pra_pka.izracunaj_redni_broj (
      'TPKA_RACUNI',
      :NEW.god_poslovna,
      :NEW.oj_id,
      :NEW.vdok_id,  -- IRN 2439
      6,
      :NEW.rbr);
  ELSE
    pra_pka_s.provjeri_pkadne_datum (:NEW.oj_id, :NEW.datum); -- 23.10.2007. G.J.
    pra_rec.izracunaj_redni_broj (
      'T_RACUNI',
      :NEW.god_poslovna,
      :NEW.oj_id,
      :NEW.vdok_id,  -- IRN 2439
      6,
      :NEW.rbr);
    :NEW.poziv_na_broj := pra_tpka_racuni.poziv_na_broj (
      :NEW.oj_sifra,
      :NEW.vdok_sifra2n,
      :NEW.gmpkom_id,
      :NEW.god_poslovna,
      :NEW.rbr);
  END IF;

  -- Bezgotovinski predujmovi se preuzimaju iz FIN pa se upisuje veza u FIN
  IF UPPER (pra_pka_zaj.vrijednost_parametra ('1034')) = 'DA' THEN
    IF pra_pka_domval.vrijednost_pkaprod ('REC_PKARAC_PRED') = 1 THEN
      -- posebno ponaanje ako je u tijeku prelazak na novu domau valutu
      NULL;
    ELSE
      IF NVL (SUBSTR (:NEW.napomena, 1, 3), '***')  NOT IN ('*< ', ' *>')
      -- IRN 2521 - osim ako se ne radi o prebacivanju predujma u PKA upisuje brojsadokumeta u fin
      THEN
        pra_tpka_racuni.vrati_info_u_fin (vapldok_oznaka_l, :NEW.vdok_sifra2n, :NEW.rbr, :NEW.god_poslovna, 
                                          :NEW.oj_sifra, :NEW.finpred_id, :NEW.datum, dat_erac_obveze_l); -- IRN 4098
      ELSIF :NEW.finpred_id_ponisteni IS NOT NULL AND :NEW.finpred_id IS NULL THEN
        -- IRN 2606 ako se radi o prebacivanju treba kreirati predujam u possusu
        pra_tpka_racuni.upisi_pred_u_fin
          (finpred_id_izvorni_p => :NEW.finpred_id_ponisteni
          ,pkarac_id_p => :NEW.id
          ,oj_id_p => :NEW.oj_id
          ,vdok_sifra2n_p => :NEW.vdok_sifra2n
          ,oj_sifra_p => :NEW.oj_sifra
          ,god_poslovna_p => :NEW.god_poslovna
          ,rbr_p => :NEW.rbr
          ,datum_p => :NEW.datum
          ,iznos_p => :NEW.iznos
          ,val_id_p => :NEW.val_id
          ,vtec_id_p => :NEW.vtec_id
          ,izn_tecaja_p => :NEW.izn_tecaja
          ,gmpkom_id_p => :NEW.gmpkom_id
          ,naz_platitelja_p => :NEW.naz_platitelja
          ,dat_erac_obveze_p => dat_erac_obveze_l     -- IRN 4098
          ,finpred_id_p => finpred_id_l
          ,finpred_uk_p => finpred_uk_l
          );
        :NEW.finpred_id := finpred_id_l;
        :NEW.finpred_uk := finpred_uk_l;
      END IF;
    END IF;  -- pra_pka_domval.vrijednost_pkaprod ('REC_PKARAC_PRED') = 1
  END IF;  -- UPPER (pra_pka_zaj.vrijednost_parametra ('1034')) = 'DA'

  -- puni PL/SQL tablicu
  -- za provjeru iskoritenog predujma i provjeru predujma
  zapis_l.id := :NEW.id; -- IRN 2026
  zapis_l.pkaracd_id := :NEW.pkaracd_id;
  zapis_l.raci_id := :NEW.raci_id;
  zapis_l.pkaraci_id := :NEW.pkaraci_id;
  tab_tpka_racuni.puni_tablicu (zapis_l);

END;
/
SHOW ERROR











