PROMPT Creating Trigger 'BDR_T_TROSKOVI'
CREATE OR REPLACE TRIGGER BDR_T_TROSKOVI
 BEFORE DELETE
 ON T_TROSKOVI
 FOR EACH ROW
DECLARE

  old_tro_rec_l t_troskovi%ROWTYPE;
  dat_storna_l  l_troskovi.dat_storna%TYPE;
  domval_id_l   s_valute.id%TYPE;
BEGIN
  -- 23.04.2003. G.J.
  IF :OLD.rac_id IS NOT NULL
    AND pra_rec_s.rac_pripada_rp (:OLD.rac_id) = 0
  THEN
    -- Brisanje zaraunatog troka nije doputeno
    pra_rec_zaj.vrati_poruku (-20403);
  END IF;

  -- urnal
  -- posebno ponaanje ako je u tijeku prelazak na novu domau valutu 
  IF pra_pka_domval.vrijednost_pkaprod ('REC_PREBACI_TRO') = 1
    AND :OLD.domval_id = pra_zmp_s2.domval_id (pra_pka_domval.dat_primjene_domval - 1) -- dodatna kontrola
  THEN
    dat_storna_l := pra_pka_domval.dat_primjene_domval - 1;   -- upis na prethodni dan
    -- pra_rec.provjeri_na_dat_zurnala (dat_storna_l, :OLD.so_id);  -- urnal je izraunat za taj dan 
  ELSE -- standardno ponaanje
    -- provjeri domval i provjeri da val nije prethodna domaa
    --   to bi trebalo sprijeiti brisanje usluga prije prelaska i brisanje na HRK shemi
    domval_id_l := :OLD.domval_id;
    pra_zmp_s2.provjeri_domval_val (
      domval_id_p => domval_id_l,  -- ne moe se ovdje koristiti :OLD.domval_id jer je domval_id_p IN OUT varijabla
      val_id_p    => :OLD.val_id,
      datum_p     => NULL);
    dat_storna_l := TRUNC (SYSDATE);
    pra_rec.provjeri_na_dat_zurnala (dat_storna_l, :OLD.so_id); 
  END IF;

  -- prenose se stare vrijednosti zbog upisa u L_TROSKOVI
  old_tro_rec_l.id := :OLD.id;
  old_tro_rec_l.so_id := :OLD.so_id;
  old_tro_rec_l.soc_id := :OLD.soc_id;
  old_tro_rec_l.usl_id := :OLD.usl_id;
  old_tro_rec_l.sas_id := :OLD.sas_id;
  old_tro_rec_l.gost_id := :OLD.gost_id;
  old_tro_rec_l.age_id := :OLD.age_id;
  old_tro_rec_l.pkaadr_id := :OLD.pkaadr_id;
  old_tro_rec_l.cje_id := :OLD.cje_id;
  old_tro_rec_l.vsj_id := :OLD.vsj_id;
  old_tro_rec_l.val_id := :OLD.val_id;
  old_tro_rec_l.ms_id := :OLD.ms_id;
  old_tro_rec_l.gostp_id := :OLD.gostp_id;
  old_tro_rec_l.agep_id := :OLD.agep_id;
  old_tro_rec_l.pkaadrp_id := :OLD.pkaadrp_id;
  old_tro_rec_l.vpispp_id := :OLD.vpispp_id;
  old_tro_rec_l.tcoraz_id := :OLD.tcoraz_id;
  old_tro_rec_l.ptvtro_id := :OLD.ptvtro_id;
  old_tro_rec_l.id1 := :OLD.id1;
  old_tro_rec_l.ltro_id1 := :OLD.ltro_id1;
  old_tro_rec_l.id1_prvi := :OLD.id1_prvi;
  old_tro_rec_l.dat_poc := :OLD.dat_poc;
  old_tro_rec_l.dat_zav := :OLD.dat_zav;
  old_tro_rec_l.kol_usluge := :OLD.kol_usluge;
  old_tro_rec_l.cijena_usluge := :OLD.cijena_usluge;
  old_tro_rec_l.ozn_cijene := :OLD.ozn_cijene;
  old_tro_rec_l.stopa_placanja := :OLD.stopa_placanja;
  old_tro_rec_l.br_uputnice := :OLD.br_uputnice;
  old_tro_rec_l.ozn_smjesta := :OLD.ozn_smjesta;
  old_tro_rec_l.izn_prihoda := :OLD.izn_prihoda;
  old_tro_rec_l.izn_pdv_poc := :OLD.izn_pdv_poc;
  old_tro_rec_l.stopa_pdv_poc := :OLD.stopa_pdv_poc;
  old_tro_rec_l.dat_upisa := :OLD.dat_upisa;
  old_tro_rec_l.obr_zdana_poc := :OLD.obr_zdana_poc;
  old_tro_rec_l.unos_korisnik := :OLD.unos_korisnik;
  old_tro_rec_l.unos_dat := :OLD.unos_dat;
  old_tro_rec_l.recara_id := :OLD.recara_id;
  old_tro_rec_l.izn_prihoda_prvidan := :OLD.izn_prihoda_prvidan;
  old_tro_rec_l.izn_pdv_prvidan := :OLD.izn_pdv_prvidan;
  -- 09.10.2008 MK
  old_tro_rec_l.obr_po_danu_poc := :OLD.obr_po_danu_poc;  
  old_tro_rec_l.ponso_id := :OLD.ponso_id;
  old_tro_rec_l.usl_id1 := :OLD.usl_id1;
  old_tro_rec_l.vpispp_id1 := :OLD.vpispp_id1;
  old_tro_rec_l.izn_pdv_poc1 := :OLD.izn_pdv_poc1;
  old_tro_rec_l.stopa_pdv_poc1 := :OLD.stopa_pdv_poc1;
  old_tro_rec_l.izn_pdv_prvidan1 := :OLD.izn_pdv_prvidan1;
  old_tro_rec_l.recrez2pros_id := :OLD.recrez2pros_id;  
  old_tro_rec_l.recrez2opr_id := :OLD.recrez2opr_id;
  old_tro_rec_l.zak_id := :OLD.zak_id;
  old_tro_rec_l.izn_odbitka_poc := :OLD.izn_odbitka_poc;
  old_tro_rec_l.izn_odbitka_pdv_poc := :OLD.izn_odbitka_pdv_poc;  
  old_tro_rec_l.izn_odbitka_pdv_poc1 := :OLD.izn_odbitka_pdv_poc1;
  old_tro_rec_l.recvpro_id := :OLD.recvpro_id;
  old_tro_rec_l.dat_poc1 := :OLD.dat_poc1;      
  old_tro_rec_l.dat_zav1 := :OLD.dat_zav1;        
  old_tro_rec_l.domval_id := :OLD.domval_id;        

  pra_t_troskovi.puni_l_troskove (old_tro_rec_l, dat_storna_l);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIR_T_TROSKOVI'
CREATE OR REPLACE TRIGGER BIR_T_TROSKOVI
 BEFORE INSERT
 ON T_TROSKOVI
 FOR EACH ROW
DECLARE

  stopa_odbitka_poc_l NUMBER;
  ozn_puni_polja_poc_l NUMBER := -1;
BEGIN
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN;  -- izlaz iz trigera
  END IF;

  :NEW.id := pra_rec_zaj.sekvenca (:NEW.id);
  :NEW.id1 := pra_zmp_zaj.i3_sekvenca (:NEW.id1);
  :NEW.dat_poc := TRUNC (:NEW.dat_poc);
  :NEW.dat_zav := TRUNC (:NEW.dat_zav);
  IF :NEW.id1_prvi IS NULL THEN
    :NEW.id1_prvi := :NEW.id1;
  END IF;
  :NEW.dat_poc1 := TRUNC (:NEW.dat_poc1);
  :NEW.dat_zav1 := TRUNC (:NEW.dat_zav1);

  pra_rec_s5.provjeri_recsousl (:NEW.so_id, :NEW.usl_id); -- IRN 4118
  pra_rec3.provjeri_sastojak_poc (:NEW.usl_id, :NEW.sas_id);
  pra_t_troskovi.provjeri_valjanost_tro_pon (:NEW.ponso_id, :NEW.rac_id);

  -- puni/provjeri domval i provjeri da val nije prethodna domaa
  pra_zmp_s2.provjeri_domval_val (
    domval_id_p => :NEW.domval_id,
    val_id_p    => :NEW.val_id,
    datum_p     => NULL);

  -- posebno ponaanje ako je u tijeku prelazak na novu domau valutu
  IF pra_pka_domval.vrijednost_pkaprod ('REC_PREBACI_TRO') = 1 THEN
    :NEW.dat_upisa := pra_pka_domval.dat_primjene_domval - 1;   -- upis na prethodni dan
    ozn_puni_polja_poc_l := 0;
    -- pra_rec.provjeri_na_dat_zurnala (:NEW.dat_upisa, :NEW.so_id);  -- urnal je izraunat za taj dan
  ELSE -- standardno ponaanje
    :NEW.dat_upisa := TRUNC (SYSDATE);
    pra_rec.provjeri_na_dat_zurnala (:NEW.dat_upisa, :NEW.so_id);
  END IF;

  pra_t_troskovi.provjeri_razdoblje (:NEW.dat_poc, :NEW.dat_zav, :NEW.dat_upisa);
  -- tu se provjerava razdoblje1 koje je popunjeno runo
  -- ako se razdoblje bude popunjavalo u puni_polja_poc popunit e se samo ako proe provjeri_razdoblje
  pra_t_troskovi.provjeri_razdoblje (:NEW.dat_poc1, :NEW.dat_zav1, :NEW.dat_upisa);
  pra_rec_s2.provjeri_usl_ara (:NEW.usl_id, :NEW.recara_id);

  /*
  samo trokovi za N raune imaju popunjen rac_id, za njih se poetne vrijednosti prepisuju iz P rauna
  kod upisa tro kod prelaska na novu valutu se takoer prepisuju poetne vrijednosti iz brisanih tro (iznosi konvertirani)
  */
  IF :NEW.rac_id IS NULL AND ozn_puni_polja_poc_l = -1 THEN
    pra_t_troskovi.puni_polja_poc (
      usl_id_p => :NEW.usl_id,
      ponso_id_p => :NEW.ponso_id,
      gost_id_p => :NEW.gost_id,
      gostp_id_p => :NEW.gostp_id,
      vpispp_id_p  => :NEW.vpispp_id,
      stopa_pdv_poc_p  => :NEW.stopa_pdv_poc,
      obr_zdana_poc_p => :NEW.obr_zdana_poc,
      obr_po_danu_poc_p => :NEW.obr_po_danu_poc,
      usl_id1_p => :NEW.usl_id1,
      vpispp_id1_p => :NEW.vpispp_id1,
      stopa_pdv_poc1_p => :NEW.stopa_pdv_poc1,
      stopa_odbitka_poc_p => stopa_odbitka_poc_l,
      dat_upisa_p => :NEW.dat_upisa,     -- treba za provjeri_razdoblje
      dat_poc_p => :NEW.dat_poc,
      dat_zav_p => :NEW.dat_zav,
      dat_poc1_p => :NEW.dat_poc1,
      dat_zav1_p => :NEW.dat_zav1,
      soc_id_p => :NEW.soc_id,
      vsj_id_p => :NEW.vsj_id);

    :NEW.izn_prihoda := pra_t_troskovi.izn_prihoda (
      :NEW.cijena_usluge,
      :NEW.stopa_placanja,
      :NEW.kol_usluge,
      :NEW.val_id,
      :NEW.dat_upisa,
      :NEW.obr_po_danu_poc,
      :NEW.obr_zdana_poc,
      :NEW.dat_poc,
      :NEW.dat_zav);

    :NEW.izn_pdv_poc := pra_rec2.izn_pdv ('B', :NEW.izn_prihoda, :NEW.stopa_pdv_poc);
    :NEW.izn_pdv_poc1 := pra_rec2.izn_pdv ('B', :NEW.izn_prihoda, :NEW.stopa_pdv_poc1);
    :NEW.izn_odbitka_poc :=  :NEW.izn_prihoda * stopa_odbitka_poc_l;
    :NEW.izn_odbitka_pdv_poc := pra_rec2.izn_pdv ('B', :NEW.izn_odbitka_poc, :NEW.stopa_pdv_poc);
    :NEW.izn_odbitka_pdv_poc1 := pra_rec2.izn_pdv ('B', :NEW.izn_odbitka_poc, :NEW.stopa_pdv_poc1);

    IF UPPER (pra_rec_zaj.vrijednost_parametra ('1108')) <> 'NE' THEN -- odnosno = Da (default)
      :NEW.izn_prihoda_prvidan := :NEW.izn_prihoda;
      :NEW.izn_pdv_prvidan := :NEW.izn_pdv_poc;
      :NEW.izn_pdv_prvidan1 := :NEW.izn_pdv_poc1;
    ELSE -- prvi dan se knjii prihod umanjen za sastojke zadnjeg dana
      :NEW.izn_prihoda_prvidan := :NEW.izn_prihoda
        - pra_t_troskovi.izn_sas_zadnjidan (:NEW.so_id, :NEW.usl_id, :NEW.sas_id, :NEW.ms_id, :NEW.kol_usluge, :NEW.dat_zav);
      :NEW.izn_pdv_prvidan := pra_rec2.izn_pdv ('B', :NEW.izn_prihoda_prvidan, :NEW.stopa_pdv_poc);
      :NEW.izn_pdv_prvidan1 := pra_rec2.izn_pdv ('B', :NEW.izn_prihoda_prvidan, :NEW.stopa_pdv_poc1);
    END IF;

  END IF;

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUR_T_TROSKOVI'
CREATE OR REPLACE TRIGGER BUR_T_TROSKOVI
 BEFORE UPDATE
 ON T_TROSKOVI
 FOR EACH ROW
DECLARE

  ozn_upisa_ltro_l NUMBER := 0;
  old_tro_rec_l t_troskovi%ROWTYPE;
  new_tro_rec_l t_troskovi%ROWTYPE;
  vpispp_id_l t_troskovi.vpispp_id%TYPE;
  stopa_pdv_poc_l t_troskovi.stopa_pdv_poc%TYPE;
  obr_zdana_poc_l t_troskovi.obr_zdana_poc%TYPE;
  obr_po_danu_poc_l t_troskovi.obr_po_danu_poc%TYPE;
  vpispp_id1_l t_troskovi.vpispp_id1%TYPE;
  stopa_pdv_poc1_l t_troskovi.stopa_pdv_poc1%TYPE;
  dat_upisa_l t_troskovi.dat_upisa%TYPE;
  stopa_odbitka_poc_l NUMBER;
BEGIN
  -- 23.04.2003. G.J.
  IF :OLD.rac_id IS NOT NULL
    AND pra_rec_s.rac_pripada_rp (:OLD.rac_id) = 0
    AND :OLD.rac_id <> NVL (:NEW.rac_id, 0)
  THEN
    -- Zaraunatom troku nije doputeno promijeniti roditelja
    pra_rec_zaj.vrati_poruku (-20403);
  END IF;

  IF :OLD.domval_id <> :NEW.domval_id THEN
    -- Neodgovarajua domaa valuta.
    pra_zmp_zaj.vrati_poruku (-20141);
  END IF;
  -- provjeri domval i provjeri da val nije prethodna domaa
  IF pra_pka_domval.vrijednost_pkaprod ('REC_PREBACI_TRO') = 1 THEN
    -- posebno ponaanje ako je u tijeku prelazak na novu domau valutu
    NULL;
  ELSE
    -- standardna provjera
    pra_zmp_s2.provjeri_domval_val (
      domval_id_p => :NEW.domval_id,
      val_id_p    => :NEW.val_id,
      datum_p     => NULL);
  END IF;

  :NEW.dat_poc := TRUNC (:NEW.dat_poc);
  :NEW.dat_zav := TRUNC (:NEW.dat_zav);
  :NEW.dat_poc1 := TRUNC (:NEW.dat_poc1);
  :NEW.dat_zav1 := TRUNC (:NEW.dat_zav1);

  -- IRN 4118
  IF :NEW.so_id <> :OLD.so_id
    OR :NEW.usl_id <> :OLD.usl_id
  THEN
    pra_rec_s5.provjeri_recsousl (:NEW.so_id, :NEW.usl_id);
  END IF;

  pra_rec3.provjeri_sastojak_poc (:NEW.usl_id, :NEW.sas_id);
  pra_t_troskovi.provjeri_valjanost_tro_pon (:NEW.ponso_id, :NEW.rac_id);
  pra_rec_s2.provjeri_usl_ara (:NEW.usl_id, :NEW.recara_id);
  pra_t_troskovi.provjeri_rac_zak_id (:NEW.rac_id, :NEW.zak_id); -- IRN 1861

  pra_t_troskovi.provjeri_razdoblje (:NEW.dat_poc, :NEW.dat_zav, :NEW.dat_upisa);
  pra_t_troskovi.provjeri_razdoblje (:NEW.dat_poc1, :NEW.dat_zav1, :NEW.dat_upisa);

  dat_upisa_l := TRUNC (SYSDATE);
  /* urnal */
  pra_t_troskovi.puni_polja_poc (
    usl_id_p => :NEW.usl_id,
    ponso_id_p => :NEW.ponso_id,
    gost_id_p => :NEW.gost_id,
    gostp_id_p => :NEW.gostp_id,
    vpispp_id_p  => vpispp_id_l,
    stopa_pdv_poc_p  => stopa_pdv_poc_l,
    obr_zdana_poc_p => obr_zdana_poc_l,
    obr_po_danu_poc_p => obr_po_danu_poc_l,
    usl_id1_p => :NEW.usl_id1,
    vpispp_id1_p => vpispp_id1_l,
    stopa_pdv_poc1_p => stopa_pdv_poc1_l,
    stopa_odbitka_poc_p => stopa_odbitka_poc_l,
    dat_upisa_p => :NEW.dat_upisa,     -- treba za provjeri_razdoblje
    dat_poc_p => :NEW.dat_poc,
    dat_zav_p => :NEW.dat_zav,
    dat_poc1_p => :NEW.dat_poc1,
    dat_zav1_p => :NEW.dat_zav1,
    soc_id_p => :NEW.soc_id,
    vsj_id_p => :NEW.vsj_id);

  /*
  prenose se stare vrijednosti zbog upisa u L_TROSKOVI
  */
  old_tro_rec_l.id := :OLD.id;
  old_tro_rec_l.so_id := :OLD.so_id;
  old_tro_rec_l.soc_id := :OLD.soc_id;
  old_tro_rec_l.usl_id := :OLD.usl_id;
  old_tro_rec_l.sas_id := :OLD.sas_id;
  old_tro_rec_l.gost_id := :OLD.gost_id;
  old_tro_rec_l.age_id := :OLD.age_id;
  old_tro_rec_l.pkaadr_id := :OLD.pkaadr_id;
  old_tro_rec_l.cje_id := :OLD.cje_id;
  old_tro_rec_l.vsj_id := :OLD.vsj_id;
  old_tro_rec_l.val_id := :OLD.val_id;
  old_tro_rec_l.ms_id := :OLD.ms_id;
  old_tro_rec_l.gostp_id := :OLD.gostp_id;
  old_tro_rec_l.agep_id := :OLD.agep_id;
  old_tro_rec_l.pkaadrp_id := :OLD.pkaadrp_id;
  old_tro_rec_l.vpispp_id := :OLD.vpispp_id;
  old_tro_rec_l.tcoraz_id := :OLD.tcoraz_id;
  old_tro_rec_l.ptvtro_id := :OLD.ptvtro_id;
  old_tro_rec_l.id1 := :OLD.id1;
  old_tro_rec_l.ltro_id1 := :OLD.ltro_id1;
  old_tro_rec_l.id1_prvi := :OLD.id1_prvi;
  old_tro_rec_l.dat_poc := :OLD.dat_poc;
  old_tro_rec_l.dat_zav := :OLD.dat_zav;
  old_tro_rec_l.kol_usluge := :OLD.kol_usluge;
  old_tro_rec_l.cijena_usluge := :OLD.cijena_usluge;
  old_tro_rec_l.ozn_cijene := :OLD.ozn_cijene;
  old_tro_rec_l.stopa_placanja := :OLD.stopa_placanja;
  old_tro_rec_l.br_uputnice := :OLD.br_uputnice;
  old_tro_rec_l.ozn_smjesta := :OLD.ozn_smjesta;
  old_tro_rec_l.izn_prihoda := :OLD.izn_prihoda;
  old_tro_rec_l.izn_pdv_poc := :OLD.izn_pdv_poc;
  old_tro_rec_l.stopa_pdv_poc := :OLD.stopa_pdv_poc;
  old_tro_rec_l.dat_upisa := :OLD.dat_upisa;
  old_tro_rec_l.obr_zdana_poc := :OLD.obr_zdana_poc;
  old_tro_rec_l.unos_korisnik := :OLD.unos_korisnik;
  old_tro_rec_l.unos_dat := :OLD.unos_dat;
  old_tro_rec_l.recara_id := :OLD.recara_id;
  old_tro_rec_l.izn_prihoda_prvidan := :OLD.izn_prihoda_prvidan;
  old_tro_rec_l.izn_pdv_prvidan := :OLD.izn_pdv_prvidan;
  -- 16.01.2008. M.P.
  old_tro_rec_l.ozn_rac_rp := :OLD.ozn_rac_rp;
  -- 09.10.2008 MK
  old_tro_rec_l.obr_po_danu_poc := :OLD.obr_po_danu_poc;
  old_tro_rec_l.ponso_id := :OLD.ponso_id;
  old_tro_rec_l.usl_id1 := :OLD.usl_id1;
  old_tro_rec_l.vpispp_id1 := :OLD.vpispp_id1;
  old_tro_rec_l.izn_pdv_poc1 := :OLD.izn_pdv_poc1;
  old_tro_rec_l.stopa_pdv_poc1 := :OLD.stopa_pdv_poc1;
  old_tro_rec_l.izn_pdv_prvidan1 := :OLD.izn_pdv_prvidan1;
  old_tro_rec_l.recrez2pros_id := :OLD.recrez2pros_id;
  old_tro_rec_l.recrez2opr_id := :OLD.recrez2opr_id;
  old_tro_rec_l.zak_id := :OLD.zak_id;
  old_tro_rec_l.izn_odbitka_poc := :OLD.izn_odbitka_poc;
  old_tro_rec_l.izn_odbitka_pdv_poc := :OLD.izn_odbitka_pdv_poc;
  old_tro_rec_l.izn_odbitka_pdv_poc1 := :OLD.izn_odbitka_pdv_poc1;
  old_tro_rec_l.recvpro_id := :OLD.recvpro_id;
  old_tro_rec_l.dat_poc1 := :OLD.dat_poc1;
  old_tro_rec_l.dat_zav1 := :OLD.dat_zav1;
  old_tro_rec_l.domval_id := :OLD.domval_id;

  /*
  prenose se nove vrijednosti zbog odluke da li ide upis u L_TROSKOVI
  */
  new_tro_rec_l.so_id := :NEW.so_id;
  new_tro_rec_l.soc_id := :NEW.soc_id;
  new_tro_rec_l.usl_id := :NEW.usl_id;
  new_tro_rec_l.sas_id := :NEW.sas_id;
  -- gost_id, age_id, pkaadr_id
  new_tro_rec_l.cje_id := :NEW.cje_id;
  new_tro_rec_l.vsj_id := :NEW.vsj_id;
  new_tro_rec_l.val_id := :NEW.val_id;
  new_tro_rec_l.ms_id := :NEW.ms_id;
  new_tro_rec_l.gostp_id := :NEW.gostp_id;
  new_tro_rec_l.agep_id := :NEW.agep_id;
  new_tro_rec_l.pkaadrp_id := :NEW.pkaadrp_id;
  new_tro_rec_l.vpispp_id := vpispp_id_l;
  new_tro_rec_l.tcoraz_id := :NEW.tcoraz_id;
  new_tro_rec_l.ptvtro_id := :NEW.ptvtro_id;
  -- id1, ltro_id1, id1_prvi
  new_tro_rec_l.dat_poc := :NEW.dat_poc;
  new_tro_rec_l.dat_zav := :NEW.dat_zav;
  new_tro_rec_l.kol_usluge := :NEW.kol_usluge;
  new_tro_rec_l.cijena_usluge := :NEW.cijena_usluge;
  new_tro_rec_l.ozn_cijene := :NEW.ozn_cijene;
  new_tro_rec_l.stopa_placanja := :NEW.stopa_placanja;
  -- br_uputnice
  new_tro_rec_l.ozn_smjesta := :NEW.ozn_smjesta; -- IRN 3989
  -- izn_prihoda, izn_pdv_poc
  new_tro_rec_l.stopa_pdv_poc := stopa_pdv_poc_l;
  new_tro_rec_l.dat_upisa := dat_upisa_l;
  new_tro_rec_l.obr_zdana_poc := obr_zdana_poc_l;
  -- unos_korisnik, unos_dat
  new_tro_rec_l.recara_id := :NEW.recara_id;
  -- izn_prihoda_prvidan, izn_pdv_prvidan, ozn_rac_rp
  -- 09.10.2008 MK
  new_tro_rec_l.obr_po_danu_poc := :NEW.obr_po_danu_poc;
  new_tro_rec_l.ponso_id := :NEW.ponso_id;
  new_tro_rec_l.usl_id1 := :NEW.usl_id1;
  new_tro_rec_l.vpispp_id1 := :NEW.vpispp_id1;
  new_tro_rec_l.stopa_pdv_poc1 := :NEW.stopa_pdv_poc1;
  -- izn_pdv_prvidan1, recrez2pros_id, recrez2opr_id, zak_id
  -- izn_odbitka_poc, izn_odbitka_pdv_poc, izn_odbitka_pdv_poc1
  new_tro_rec_l.recvpro_id := :NEW.recvpro_id;
  new_tro_rec_l.dat_poc1 := :NEW.dat_poc1;
  new_tro_rec_l.dat_zav1 := :NEW.dat_zav1;
  -- domval_id

  pra_t_troskovi.puni_l_troskove_bur (
    old_tro_rec_l,
    new_tro_rec_l,
    ozn_upisa_ltro_l);
  IF ozn_upisa_ltro_l = -1 THEN
    /*
    ako je upisan l_trosak mogu se mijenjati
    (redundantni) podaci za urnal
    */
    :NEW.ltro_id1 := :OLD.id1;
    :NEW.id1 := pra_zmp_zaj.i3_sekvenca (NULL);
    :NEW.dat_upisa := dat_upisa_l;
    :NEW.vpispp_id := vpispp_id_l;
    :NEW.stopa_pdv_poc := stopa_pdv_poc_l;
    :NEW.obr_zdana_poc := obr_zdana_poc_l;
    :NEW.obr_po_danu_poc := obr_po_danu_poc_l;
    :NEW.vpispp_id1 := vpispp_id1_l;
    :NEW.stopa_pdv_poc1 := stopa_pdv_poc1_l;
    :NEW.izn_prihoda := pra_t_troskovi.izn_prihoda (
      :NEW.cijena_usluge,
      :NEW.stopa_placanja,
      :NEW.kol_usluge,
      :NEW.val_id,
      :NEW.dat_upisa,
      :NEW.obr_po_danu_poc,
      :NEW.obr_zdana_poc,
      :NEW.dat_poc,
      :NEW.dat_zav);

    :NEW.izn_pdv_poc := pra_rec2.izn_pdv ('B', :NEW.izn_prihoda, :NEW.stopa_pdv_poc);
    :NEW.izn_pdv_poc1 := pra_rec2.izn_pdv ('B', :NEW.izn_prihoda, :NEW.stopa_pdv_poc1);
    :NEW.izn_odbitka_poc :=  :NEW.izn_prihoda * stopa_odbitka_poc_l;
    :NEW.izn_odbitka_pdv_poc := pra_rec2.izn_pdv ('B', :NEW.izn_odbitka_poc, :NEW.stopa_pdv_poc);
    :NEW.izn_odbitka_pdv_poc1 := pra_rec2.izn_pdv ('B', :NEW.izn_odbitka_poc, :NEW.stopa_pdv_poc1);

    IF UPPER (pra_rec_zaj.vrijednost_parametra ('1108')) <> 'NE' THEN -- odnosno = Da (default)
      :NEW.izn_prihoda_prvidan := :NEW.izn_prihoda;
      :NEW.izn_pdv_prvidan := :NEW.izn_pdv_poc;
      :NEW.izn_pdv_prvidan1 := :NEW.izn_pdv_poc1;
    ELSE -- prvi dan se knjii prihod umanjen za sastojke zadnjeg dana
      :NEW.izn_prihoda_prvidan := :NEW.izn_prihoda
        - pra_t_troskovi.izn_sas_zadnjidan (:NEW.so_id, :NEW.usl_id, :NEW.sas_id, :NEW.ms_id, :NEW.kol_usluge, :NEW.dat_zav);
      :NEW.izn_pdv_prvidan := pra_rec2.izn_pdv ('B', :NEW.izn_prihoda_prvidan, :NEW.stopa_pdv_poc);
      :NEW.izn_pdv_prvidan1 := pra_rec2.izn_pdv ('B', :NEW.izn_prihoda_prvidan, :NEW.stopa_pdv_poc1);
    END IF;
  ELSE
    /*
    ti podaci se ne bi smjeli mijenjati
    30.10.2008 MK ni usluga se ne bi smjela mijenjati ako elimo zadrati urnal
    12.12.2010 MK niti razdoblje1 jer se preko njega rauna prihod1
    */
    :NEW.usl_id := :OLD.usl_id;
    :NEW.dat_upisa := :OLD.dat_upisa;
    :NEW.vpispp_id := :OLD.vpispp_id;
    :NEW.stopa_pdv_poc := :OLD.stopa_pdv_poc;
    :NEW.obr_zdana_poc := :OLD.obr_zdana_poc;
    :NEW.obr_po_danu_poc := :OLD.obr_po_danu_poc;
    :NEW.usl_id1 := :OLD.usl_id1;
    :NEW.vpispp_id1 := :OLD.vpispp_id1;
    :NEW.stopa_pdv_poc1 := :OLD.stopa_pdv_poc1;
    :NEW.izn_prihoda := :OLD.izn_prihoda;
    :NEW.izn_pdv_poc := :OLD.izn_pdv_poc;
    :NEW.izn_prihoda_prvidan := :OLD.izn_prihoda_prvidan;
    :NEW.izn_pdv_prvidan := :OLD.izn_pdv_prvidan;
    :NEW.izn_pdv_poc1 := :OLD.izn_pdv_poc1;
    :NEW.izn_pdv_prvidan1 := :OLD.izn_pdv_prvidan1;
    :NEW.izn_odbitka_poc := :OLD.izn_odbitka_poc;
    :NEW.izn_odbitka_pdv_poc := :OLD.izn_odbitka_pdv_poc;
    :NEW.izn_odbitka_pdv_poc1 := :OLD.izn_odbitka_pdv_poc1;
    :NEW.dat_poc1 := :OLD.dat_poc1;
    :NEW.dat_zav1 := :OLD.dat_zav1;
  END IF;

  -- MP 27.07.2011
  IF :NEW.rac_id IS NOT NULL AND
    pra_rec_s.rac_pripada_rp (:NEW.rac_id) = -1
  THEN
    :NEW.ozn_rac_rp := -1;
  ELSE
    :NEW.ozn_rac_rp := NULL;
  END IF;

  -- 23.04.2003. G.J.; Provjeri promjenu zaraunatog troka
  -- IRN 3693; preseljeno na kraj trigera
  IF :OLD.rac_id IS NOT NULL
    AND :OLD.ozn_rac_rp IS NULL
  THEN

    -- puni stare vrijednosti
    old_tro_rec_l.id := :OLD.id;
    old_tro_rec_l.so_id := :OLD.so_id;
    old_tro_rec_l.soc_id := :OLD.soc_id;
    old_tro_rec_l.usl_id := :OLD.usl_id;
    old_tro_rec_l.sas_id := :OLD.sas_id;
    old_tro_rec_l.gost_id := :OLD.gost_id;
    old_tro_rec_l.age_id := :OLD.age_id;
    old_tro_rec_l.pkaadr_id := :OLD.pkaadr_id;
    old_tro_rec_l.cje_id := :OLD.cje_id;
    old_tro_rec_l.vsj_id := :OLD.vsj_id;
    old_tro_rec_l.val_id := :OLD.val_id;
    old_tro_rec_l.ms_id := :OLD.ms_id;
    old_tro_rec_l.gostp_id := :OLD.gostp_id;
    old_tro_rec_l.agep_id := :OLD.agep_id;
    old_tro_rec_l.pkaadrp_id := :OLD.pkaadrp_id;
    old_tro_rec_l.vpispp_id := :OLD.vpispp_id;
    old_tro_rec_l.vpispz_id := :OLD.vpispz_id;
    old_tro_rec_l.rac_id := :OLD.rac_id;
    old_tro_rec_l.tcoraz_id := :OLD.tcoraz_id;
    old_tro_rec_l.ptvtro_id := :OLD.ptvtro_id;
    -- id1
    -- ltro_id1
    -- id1_prvi
    old_tro_rec_l.dat_poc := :OLD.dat_poc;
    old_tro_rec_l.dat_zav := :OLD.dat_zav;
    old_tro_rec_l.kol_usluge := :OLD.kol_usluge;
    old_tro_rec_l.cijena_usluge := :OLD.cijena_usluge;
    old_tro_rec_l.ozn_cijene := :OLD.ozn_cijene;
    old_tro_rec_l.stopa_placanja := :OLD.stopa_placanja;
    old_tro_rec_l.br_uputnice := :OLD.br_uputnice;
    old_tro_rec_l.ozn_smjesta := :OLD.ozn_smjesta;
    old_tro_rec_l.izn_prihoda := :OLD.izn_prihoda;
    old_tro_rec_l.izn_pdv_poc := :OLD.izn_pdv_poc;
    old_tro_rec_l.stopa_pdv_poc := :OLD.stopa_pdv_poc;
    old_tro_rec_l.dat_upisa := :OLD.dat_upisa;
    old_tro_rec_l.obr_zdana_poc := :OLD.obr_zdana_poc;
    old_tro_rec_l.obr_zdana := :OLD.obr_zdana;
    old_tro_rec_l.obr_smjesta := :OLD.obr_smjesta;
    old_tro_rec_l.obr_popusta1 := :OLD.obr_popusta1;
    old_tro_rec_l.obr_popusta4 := :OLD.obr_popusta4;
    old_tro_rec_l.izn_tecaja := :OLD.izn_tecaja;
    old_tro_rec_l.izn_odbitka := :OLD.izn_odbitka;
    old_tro_rec_l.stopa_pdv := :OLD.stopa_pdv;
    old_tro_rec_l.izn_pdv := :OLD.izn_pdv;
    old_tro_rec_l.iznos := :OLD.iznos;
    old_tro_rec_l.unos_korisnik := :OLD.unos_korisnik;
    old_tro_rec_l.unos_dat := :OLD.unos_dat;
    -- izmjena_korisnik
    -- izmjena_dat
    old_tro_rec_l.recara_id := :OLD.recara_id;
    old_tro_rec_l.obr_popusta2 := :OLD.obr_popusta2;
    old_tro_rec_l.obr_popusta3 := :OLD.obr_popusta3;
    old_tro_rec_l.zmppop1_id := :OLD.zmppop1_id;
    old_tro_rec_l.zmppop2_id := :OLD.zmppop2_id;
    old_tro_rec_l.zmppop3_id := :OLD.zmppop3_id;
    old_tro_rec_l.zmppop4_id := :OLD.zmppop4_id;
    old_tro_rec_l.stopa_popusta1 := :OLD.stopa_popusta1;
    old_tro_rec_l.stopa_popusta2 := :OLD.stopa_popusta2;
    old_tro_rec_l.stopa_popusta3 := :OLD.stopa_popusta3;
    old_tro_rec_l.stopa_popusta4 := :OLD.stopa_popusta4;
    old_tro_rec_l.izn_prihoda_prvidan := :OLD.izn_prihoda_prvidan;
    old_tro_rec_l.izn_pdv_prvidan := :OLD.izn_pdv_prvidan;
    old_tro_rec_l.ozn_rac_rp := :OLD.ozn_rac_rp;
    old_tro_rec_l.obr_po_danu_poc := :OLD.obr_po_danu_poc;
    old_tro_rec_l.obr_po_danu := :OLD.obr_po_danu;
    old_tro_rec_l.ponso_id := :OLD.ponso_id;
    old_tro_rec_l.usl_id1 := :OLD.usl_id1;
    old_tro_rec_l.vpispp_id1 := :OLD.vpispp_id1;
    old_tro_rec_l.vpispz_id1 := :OLD.vpispz_id1;
    old_tro_rec_l.izn_pdv_poc1 := :OLD.izn_pdv_poc1;
    old_tro_rec_l.stopa_pdv_poc1 := :OLD.stopa_pdv_poc1;
    old_tro_rec_l.stopa_pdv1 := :OLD.stopa_pdv1;
    old_tro_rec_l.izn_pdv1 := :OLD.izn_pdv1;
    old_tro_rec_l.izn_pdv_prvidan1 := :OLD.izn_pdv_prvidan1;
    old_tro_rec_l.recrez2pros_id := :OLD.recrez2pros_id;
    old_tro_rec_l.recrez2opr_id := :OLD.recrez2opr_id;
    old_tro_rec_l.zak_id := :OLD.zak_id;
    old_tro_rec_l.izn_odbitka_poc := :OLD.izn_odbitka_poc;
    old_tro_rec_l.izn_odbitka_pdv_poc := :OLD.izn_odbitka_pdv_poc;
    old_tro_rec_l.izn_odbitka_pdv_poc1 := :OLD.izn_odbitka_pdv_poc1;
    old_tro_rec_l.recvpro_id := :OLD.recvpro_id;
    old_tro_rec_l.dat_poc1 := :OLD.dat_poc1;
    old_tro_rec_l.dat_zav1 := :OLD.dat_zav1;
    old_tro_rec_l.obr_provizije := :OLD.obr_provizije;
    -- domval_id

    -- puni nove vrijednosti
    new_tro_rec_l.id := :NEW.id;
    new_tro_rec_l.so_id := :NEW.so_id;
    new_tro_rec_l.soc_id := :NEW.soc_id;
    new_tro_rec_l.usl_id := :NEW.usl_id;
    new_tro_rec_l.sas_id := :NEW.sas_id;
    new_tro_rec_l.gost_id := :NEW.gost_id;
    new_tro_rec_l.age_id := :NEW.age_id;
    new_tro_rec_l.pkaadr_id := :NEW.pkaadr_id;
    new_tro_rec_l.cje_id := :NEW.cje_id;
    new_tro_rec_l.vsj_id := :NEW.vsj_id;
    new_tro_rec_l.val_id := :NEW.val_id;
    new_tro_rec_l.ms_id := :NEW.ms_id;
    new_tro_rec_l.gostp_id := :NEW.gostp_id;
    new_tro_rec_l.agep_id := :NEW.agep_id;
    new_tro_rec_l.pkaadrp_id := :NEW.pkaadrp_id;
    new_tro_rec_l.vpispp_id := :NEW.vpispp_id;
    new_tro_rec_l.vpispz_id := :NEW.vpispz_id;
    new_tro_rec_l.rac_id := :NEW.rac_id;
    new_tro_rec_l.tcoraz_id := :NEW.tcoraz_id;
    new_tro_rec_l.ptvtro_id := :NEW.ptvtro_id;
    -- id1
    -- ltro_id1
    -- id1_prvi
    new_tro_rec_l.dat_poc := :NEW.dat_poc;
    new_tro_rec_l.dat_zav := :NEW.dat_zav;
    new_tro_rec_l.kol_usluge := :NEW.kol_usluge;
    new_tro_rec_l.cijena_usluge := :NEW.cijena_usluge;
    new_tro_rec_l.ozn_cijene := :NEW.ozn_cijene;
    new_tro_rec_l.stopa_placanja := :NEW.stopa_placanja;
    new_tro_rec_l.br_uputnice := :NEW.br_uputnice;
    new_tro_rec_l.ozn_smjesta := :NEW.ozn_smjesta;
    new_tro_rec_l.izn_prihoda := :NEW.izn_prihoda;
    new_tro_rec_l.izn_pdv_poc := :NEW.izn_pdv_poc;
    new_tro_rec_l.stopa_pdv_poc := :NEW.stopa_pdv_poc;
    new_tro_rec_l.dat_upisa := :NEW.dat_upisa;
    new_tro_rec_l.obr_zdana_poc := :NEW.obr_zdana_poc;
    new_tro_rec_l.obr_zdana := :NEW.obr_zdana;
    new_tro_rec_l.obr_smjesta := :NEW.obr_smjesta;
    new_tro_rec_l.obr_popusta1 := :NEW.obr_popusta1;
    new_tro_rec_l.obr_popusta4 := :NEW.obr_popusta4;
    new_tro_rec_l.izn_tecaja := :NEW.izn_tecaja;
    new_tro_rec_l.izn_odbitka := :NEW.izn_odbitka;
    new_tro_rec_l.stopa_pdv := :NEW.stopa_pdv;
    new_tro_rec_l.izn_pdv := :NEW.izn_pdv;
    new_tro_rec_l.iznos := :NEW.iznos;
    new_tro_rec_l.unos_korisnik := :NEW.unos_korisnik;
    new_tro_rec_l.unos_dat := :NEW.unos_dat;
    -- izmjena_korisnik
    -- izmjena_dat
    new_tro_rec_l.recara_id := :NEW.recara_id;
    new_tro_rec_l.obr_popusta2 := :NEW.obr_popusta2;
    new_tro_rec_l.obr_popusta3 := :NEW.obr_popusta3;
    new_tro_rec_l.zmppop1_id := :NEW.zmppop1_id;
    new_tro_rec_l.zmppop2_id := :NEW.zmppop2_id;
    new_tro_rec_l.zmppop3_id := :NEW.zmppop3_id;
    new_tro_rec_l.zmppop4_id := :NEW.zmppop4_id;
    new_tro_rec_l.stopa_popusta1 := :NEW.stopa_popusta1;
    new_tro_rec_l.stopa_popusta2 := :NEW.stopa_popusta2;
    new_tro_rec_l.stopa_popusta3 := :NEW.stopa_popusta3;
    new_tro_rec_l.stopa_popusta4 := :NEW.stopa_popusta4;
    new_tro_rec_l.izn_prihoda_prvidan := :NEW.izn_prihoda_prvidan;
    new_tro_rec_l.izn_pdv_prvidan := :NEW.izn_pdv_prvidan;
    new_tro_rec_l.ozn_rac_rp := :NEW.ozn_rac_rp;
    new_tro_rec_l.obr_po_danu_poc := :NEW.obr_po_danu_poc;
    new_tro_rec_l.obr_po_danu := :NEW.obr_po_danu;
    new_tro_rec_l.ponso_id := :NEW.ponso_id;
    new_tro_rec_l.usl_id1 := :NEW.usl_id1;
    new_tro_rec_l.vpispp_id1 := :NEW.vpispp_id1;
    new_tro_rec_l.vpispz_id1 := :NEW.vpispz_id1;
    new_tro_rec_l.izn_pdv_poc1 := :NEW.izn_pdv_poc1;
    new_tro_rec_l.stopa_pdv_poc1 := :NEW.stopa_pdv_poc1;
    new_tro_rec_l.stopa_pdv1 := :NEW.stopa_pdv1;
    new_tro_rec_l.izn_pdv1 := :NEW.izn_pdv1;
    new_tro_rec_l.izn_pdv_prvidan1 := :NEW.izn_pdv_prvidan1;
    new_tro_rec_l.recrez2pros_id := :NEW.recrez2pros_id;
    new_tro_rec_l.recrez2opr_id := :NEW.recrez2opr_id;
    new_tro_rec_l.zak_id := :NEW.zak_id;
    new_tro_rec_l.izn_odbitka_poc := :NEW.izn_odbitka_poc;
    new_tro_rec_l.izn_odbitka_pdv_poc := :NEW.izn_odbitka_pdv_poc;
    new_tro_rec_l.izn_odbitka_pdv_poc1 := :NEW.izn_odbitka_pdv_poc1;
    new_tro_rec_l.recvpro_id := :NEW.recvpro_id;
    new_tro_rec_l.dat_poc1 := :NEW.dat_poc1;
    new_tro_rec_l.dat_zav1 := :NEW.dat_zav1;
    new_tro_rec_l.obr_provizije := :NEW.obr_provizije;
    -- domval_id

    pra_t_troskovi.provjeri_tro_rac_id (
      old_tro_rec_l,
      new_tro_rec_l);

  END IF;

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);

END;
/
SHOW ERROR
