-- C:\Radni\t_rezervacije.trg
--
-- Generated for Oracle 10g on Tue May 06  13:59:24 2025 by Server Generator 6.5.96.5.6
 
PROMPT Creating Trigger 'AIS_T_REZERVACIJE'
CREATE OR REPLACE TRIGGER AIS_T_REZERVACIJE
 AFTER INSERT
 ON T_REZERVACIJE
DECLARE

  zapis_l      tab_t_rezervacije.rez_rec_type;
  zapis_flex_l tab_t_rezervacije_flex.rez_rec_type; -- IRN 3977
BEGIN
  tab_t_rezervacije.postavi_iterator;
  WHILE tab_t_rezervacije.ima_jos LOOP
    zapis_l := tab_t_rezervacije.sljedeci_red;
    pra_t_rezervacije.provjeri_razdoblje (
      zapis_l.id,
      zapis_l.recagost_id,
      TRUNC (zapis_l.dat_dolaska),
      TRUNC (zapis_l.dat_odlaska));
    pra_t_rez_gost.provjeri_rez_recagost (
      zapis_l.recagost_id, zapis_l.id, NULL, zapis_l.dat_dolaska, zapis_l.dat_odlaska);
  END LOOP;

  -- IRN 3977
  tab_t_rezervacije_flex.postavi_iterator;
  WHILE tab_t_rezervacije_flex.ima_jos LOOP
    zapis_flex_l := tab_t_rezervacije_flex.sljedeci_red;
    pra_t_rezervacije.puni_pkaoba (zapis_flex_l);
  END LOOP;

END;
/
SHOW ERROR


PROMPT Creating Trigger 'ARL_T_REZERVACIJE'
CREATE OR REPLACE TRIGGER ARL_T_REZERVACIJE
 AFTER DELETE OR INSERT OR UPDATE
 ON T_REZERVACIJE
 FOR EACH ROW
BEGIN
  -- IRN 2888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN; -- izlaz iz trigera
  END IF;

  replikacija.napuni_tab (:OLD.id, :NEW.id);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'ASL_T_REZERVACIJE'
CREATE OR REPLACE TRIGGER ASL_T_REZERVACIJE
 AFTER DELETE OR INSERT OR UPDATE
 ON T_REZERVACIJE
BEGIN
  replikacija.upisi_u_log (
    aplikacija_p => 'REC',
    tablica_p    => 'T_REZERVACIJE');
END;
/
SHOW ERROR


PROMPT Creating Trigger 'AUS_T_REZERVACIJE'
CREATE OR REPLACE TRIGGER AUS_T_REZERVACIJE
 AFTER UPDATE
 ON T_REZERVACIJE
DECLARE

  zapis_l      tab_t_rezervacije.rez_rec_type;
  zapis_flex_l tab_t_rezervacije_flex.rez_rec_type;
  zapis_dom_l  tab_t_rezervacije_dom.rez_rec_type;
BEGIN
  tab_t_rezervacije.postavi_iterator;
  WHILE tab_t_rezervacije.ima_jos LOOP
    zapis_l := tab_t_rezervacije.sljedeci_red;
    pra_t_rezervacije.provjeri_razdoblje (
      zapis_l.id,
      zapis_l.recagost_id,
      TRUNC (zapis_l.dat_dolaska),
      TRUNC (zapis_l.dat_odlaska));
    pra_t_rez_gost.provjeri_rez_recagost (
      zapis_l.recagost_id, zapis_l.id, NULL, zapis_l.dat_dolaska, zapis_l.dat_odlaska);
    pra_t_rezervacije.provjeri_rezgost_pristupni_kod ( -- IRN 3200
      zapis_l.id, zapis_l.pristupni_kod);
  END LOOP;

  -- IRN 3625
  tab_t_rezervacije_flex.postavi_iterator;
  WHILE tab_t_rezervacije_flex.ima_jos LOOP
    zapis_flex_l := tab_t_rezervacije_flex.sljedeci_red;
    pra_flexkeeping.post_booking_rez (zapis_flex_l);
    pra_t_rezervacije.puni_pkaoba (zapis_flex_l); -- IRN 3977
  END LOOP;

  -- IRN 3860
  tab_t_rezervacije_dom.postavi_iterator;
  WHILE tab_t_rezervacije_dom.ima_jos LOOP
    zapis_dom_l := tab_t_rezervacije_dom.sljedeci_red;
    pra_dom_api.dom_post_booking_rez (zapis_dom_l);
  END LOOP;

END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIR_T_REZERVACIJE'
CREATE OR REPLACE TRIGGER BIR_T_REZERVACIJE
 BEFORE INSERT
 ON T_REZERVACIJE
 FOR EACH ROW
DECLARE

  zapis_l      tab_t_rezervacije.rez_rec_type;
  zapis_flex_l tab_t_rezervacije_flex.rez_rec_type; -- IRN 3977
BEGIN
  -- IRN 2888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN; -- izlaz iz trigera
  END IF;

  :NEW.id := pra_rec_zaj.sekvenca (:NEW.id);

  :NEW.datum := TRUNC (:NEW.datum);
  :NEW.dat_dolaska := TRUNC (:NEW.dat_dolaska);
  :NEW.dat_odlaska := TRUNC (:NEW.dat_odlaska);
  :NEW.dat_opcije := TRUNC (:NEW.dat_opcije);
  :NEW.dat_kartice := TRUNC (:NEW.dat_kartice);
  :NEW.ozn_valjanosti := UPPER (:NEW.ozn_valjanosti);
  :NEW.oznaka := UPPER (:NEW.oznaka);
  pra_zmp_zaj.oblikuj_slovo_upp_broj_all (:NEW.ozn_vip, 1);
  :NEW.god_poslovna := pra_rec_zaj.poslovna_godina (:NEW.god_poslovna);
  :NEW.dat_pretplate := TRUNC (:NEW.dat_pretplate); -- IRN 2165
  pra_zmp_zaj.oblikuj_slovo_upp_broj (:NEW.reg_vozila); -- IRN 2165

  pra_rec.provjeri_regiju (:NEW.reg_id, :NEW.zem_id);
  pra_rec.provjeri_postu (:NEW.pos_id, :NEW.zem_id);
  pra_rec.provjeri_agenciju (:NEW.ms_id, :NEW.age_id);

  pra_rec3.provjeri_recagost_oznaka (:NEW.recagost_id);
  pra_t_rezervacije.provjeri_rez_pon ( -- IRN 669
    :NEW.ponso_id,
    :NEW.age_id,
    :NEW.ms_id,
    :NEW.so_id,
    :NEW.oznaka,
    :NEW.ozn_vstorna,
    :NEW.ozn_B,
    :NEW.ozn_F);

  pra_rec.izracunaj_redni_broj (
    'T_REZERVACIJE',
    :NEW.god_poslovna,
    :NEW.so_id,
     NULL,
     5,
    :NEW.rbr);

  IF :NEW.ozn_valjanosti IS NULL THEN
    :NEW.ozn_valjanosti := 'P';
  END IF;

  -- 07.02.2007. G.J.
  zapis_l.id := :NEW.id;
  zapis_l.recagost_id := :NEW.recagost_id;
  zapis_l.dat_dolaska := :NEW.dat_dolaska;
  zapis_l.dat_odlaska := :NEW.dat_odlaska;
  tab_t_rezervacije.puni_tablicu (zapis_l);

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);

  -- IRN 3977
  zapis_flex_l.rez_row_new.oznaka := :NEW.oznaka;
  zapis_flex_l.rez_row_new.ozn_vstorna := :NEW.ozn_vstorna;
  zapis_flex_l.rez_row_new.god_poslovna := :NEW.god_poslovna;
  zapis_flex_l.rez_row_new.rbr := :NEW.rbr;
  zapis_flex_l.rez_row_new.dat_dolaska := :NEW.dat_dolaska;
  zapis_flex_l.rez_row_new.prezime := :NEW.prezime;
  zapis_flex_l.rez_row_new.unos_korisnik := :NEW.unos_korisnik;
  tab_t_rezervacije_flex.puni_tablicu (zapis_flex_l);
  -- KRAJ IRN 3977

END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIS_T_REZERVACIJE'
CREATE OR REPLACE TRIGGER BIS_T_REZERVACIJE
 BEFORE INSERT
 ON T_REZERVACIJE
BEGIN
  tab_t_rezervacije.brisi_tablicu;
  tab_t_rezervacije_flex.brisi_tablicu; -- IRN 3977
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BSL_T_REZERVACIJE'
CREATE OR REPLACE TRIGGER BSL_T_REZERVACIJE
 BEFORE DELETE OR INSERT OR UPDATE
 ON T_REZERVACIJE
BEGIN
  replikacija.brisi_tab;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUR_T_REZERVACIJE'
CREATE OR REPLACE TRIGGER BUR_T_REZERVACIJE
 BEFORE UPDATE
 ON T_REZERVACIJE
 FOR EACH ROW
DECLARE

  zapis_l      tab_t_rezervacije.rez_rec_type;
  zapis_flex_l tab_t_rezervacije_flex.rez_rec_type;
  zapis_dom_l  tab_t_rezervacije_dom.rez_rec_type;
BEGIN
  -- IRN 2906
  IF pra_pka_anonim.anonim_u_tijeku ('T_REZERVACIJE', :OLD.id) = -1 THEN
    pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
    RETURN; -- izlaz iz trigera
  END IF;

  :NEW.datum := TRUNC (:NEW.datum);
  :NEW.dat_dolaska := TRUNC (:NEW.dat_dolaska);
  :NEW.dat_odlaska := TRUNC (:NEW.dat_odlaska);
  :NEW.dat_opcije := TRUNC (:NEW.dat_opcije);
  :NEW.dat_kartice := TRUNC (:NEW.dat_kartice);
  :NEW.ozn_valjanosti := UPPER (:NEW.ozn_valjanosti);
  :NEW.oznaka := UPPER (:NEW.oznaka);
  pra_zmp_zaj.oblikuj_slovo_upp_broj_all (:NEW.ozn_vip, 1);
  :NEW.dat_pretplate := TRUNC (:NEW.dat_pretplate); -- IRN 2165
  pra_zmp_zaj.oblikuj_slovo_upp_broj (:NEW.reg_vozila); -- IRN 2165
  -- Zabrani izmjenu UK
  IF :NEW.god_poslovna <> :OLD.god_poslovna
    OR :NEW.so_id <> :OLD.so_id
    OR :NEW.rbr <> :OLD.rbr
  THEN
    pra_rec_zaj.vrati_poruku (-20100);
  END IF;

  -- pra_rec.zabrani_izmjenu_dokumenta (:OLD.oznaka); -- MK 23.12.2011
  pra_t_rezervacije.zabrani_izmjenu_rezervacije (:OLD.oznaka, :OLD.ozn_vstorna);
  pra_rec.provjeri_regiju (:NEW.reg_id, :NEW.zem_id);
  pra_rec.provjeri_postu (:NEW.pos_id, :NEW.zem_id);
  pra_rec.provjeri_agenciju (:NEW.ms_id, :NEW.age_id);
  pra_t_rezervacije.provjeri_rez_pon (
    :NEW.ponso_id,
    :NEW.age_id,
    :NEW.ms_id,
    :NEW.so_id,
    :NEW.oznaka,
    :NEW.ozn_vstorna,
    :NEW.ozn_B,
    :NEW.ozn_F);
  pra_t_rezervacije.provjeri_dopustenu_tranziciju (:NEW.id, :NEW.oznaka, :OLD.oznaka, :NEW.ozn_vstorna, :OLD.ozn_vstorna);

  IF NVL (:OLD.recagost_id, 0) <> NVL (:NEW.recagost_id, 0) THEN
    pra_rec3.provjeri_recagost_oznaka (:NEW.recagost_id);
    -- pra_t_rezervacije.provjeri_rezgost_recagost (:NEW.id, :NEW.recagost_id);
  END IF;

  pra_t_rezervacije.provjeri_sj_rez_zakupljena (
    :NEW.id,
    :OLD.dat_dolaska, :OLD.dat_odlaska,
    :NEW.dat_dolaska, :NEW.dat_odlaska,
    :NEW.oznaka, :NEW.ozn_vstorna);

  pra_t_rezervacije.provjeri_stsj_rez
   (:NEW.id,
    :NEW.oznaka, :NEW.ozn_vstorna,
    :OLD.dat_dolaska, :OLD.dat_odlaska,
    :NEW.dat_dolaska, :NEW.dat_odlaska);

  IF :NEW.dat_odlaska <> :OLD.dat_odlaska THEN
    pra_t_rezervacije.provjeri_vsj (:NEW.id, :NEW.so_id, :NEW.dat_dolaska, :NEW.dat_odlaska - 1);
  END IF;

  -- 07.02.2007. G.J.
  zapis_l.id := :OLD.id;
  IF :NEW.recagost_id IS NOT NULL
    AND :NEW.recagost_id <> NVL (:OLD.recagost_id, 0)
  THEN
    zapis_l.recagost_id := :NEW.recagost_id;
    zapis_l.dat_dolaska := :NEW.dat_dolaska;
    zapis_l.dat_odlaska := :NEW.dat_odlaska;
  END IF;
  IF NVL (:NEW.pristupni_kod, '') <> NVL (:OLD.pristupni_kod, '') THEN -- IRN 3200
    zapis_l.pristupni_kod := :NEW.pristupni_kod;
  END IF;
  tab_t_rezervacije.puni_tablicu (zapis_l);

  -- auriraj booking
  IF :OLD.oznaka <> :NEW.oznaka
    OR NVL (:OLD.ozn_vstorna, 0) <> NVL (:NEW.ozn_vstorna, 0)
    OR :OLD.ms_id <> :NEW.ms_id
    OR NVL (:OLD.age_id, 0) <> NVL (:NEW.age_id, 0)
    OR :OLD.dat_dolaska <> :NEW.dat_dolaska
    OR :OLD.dat_odlaska <> :NEW.dat_odlaska
    OR :OLD.ozn_B <> :NEW.ozn_B
    OR :OLD.ozn_F <> :NEW.ozn_F
    OR NVL (:OLD.ponso_id, 0) <> NVL (:NEW.ponso_id, 0)
    OR NVL (:OLD.recvpro_id, 0) <> NVL (:NEW.recvpro_id, 0)
  THEN
    pra_t_rezervacije.azuriraj_book_rez (
      :OLD.id,
      :OLD.oznaka,
      :OLD.ozn_vstorna,
      :OLD.so_id,
      :OLD.ms_id,
      :OLD.age_id,
      :OLD.ponso_id,
      :OLD.recvpro_id,
      :OLD.dat_dolaska,
      :OLD.dat_odlaska,
      :OLD.ozn_B,
      :OLD.ozn_F,
      -1);
    pra_t_rezervacije.azuriraj_book_rez (
      :OLD.id,
      :NEW.oznaka,
      :NEW.ozn_vstorna,
      :NEW.so_id,
      :NEW.ms_id,
      :NEW.age_id,
      :NEW.ponso_id,
      :NEW.recvpro_id,
      :NEW.dat_dolaska,
      :NEW.dat_odlaska,
      :NEW.ozn_B,
      :NEW.ozn_F,
      1);
  END IF;

  -- auriraj status SJ
  IF :OLD.oznaka <> :NEW.oznaka
    OR NVL (:OLD.ozn_vstorna, 0) <> NVL (:NEW.ozn_vstorna, 0)
    OR :OLD.dat_dolaska <> :NEW.dat_dolaska
    OR :OLD.dat_odlaska <> :NEW.dat_odlaska
    OR :OLD.ozn_F <> :NEW.ozn_F
  THEN
    pra_t_rezervacije.oduzmi_statusSJ (
      :OLD.id,
      :OLD.oznaka,
      :OLD.ozn_vstorna,
      :OLD.dat_dolaska,
      :OLD.dat_odlaska);
    pra_t_rezervacije.dodaj_statusSJ (
      :OLD.id,
      :NEW.oznaka,
      :NEW.ozn_vstorna,
      :NEW.dat_dolaska,
      :NEW.dat_odlaska,
      :NEW.ozn_F);
  END IF;

  IF :OLD.oznaka <> :NEW.oznaka
    OR :OLD.dat_dolaska <> :NEW.dat_dolaska
  THEN
    -- Otkai najavu prema Key Card sustavu
    pra_rec_kc_iud.puni_kczah_rez (:OLD.id, :OLD.oznaka, :OLD.ozn_vstorna, 32, :OLD.dat_dolaska);
    -- Najavi dolazak prema Key Card sustavu
    pra_rec_kc_iud.puni_kczah_rez (:OLD.id, :NEW.oznaka, :OLD.ozn_vstorna, 31, :NEW.dat_dolaska);
  END IF;

  -- IRN 2804
  IF :OLD.oznaka <> :NEW.oznaka
    AND :OLD.ga_id IS NOT NULL
    AND :OLD.priga_id IS NOT NULL
  THEN
    -- rezervacija je ponitena nakon to je preuzeta za Google Analytics
    :NEW.priga_id := -1; -- treba je ponovo preuzeti za GA "refund"
  END IF;

  IF (:NEW.oznaka = 'P' OR (:NEW.oznaka = 'V' AND :NEW.ozn_vstorna IN (1, 2, 3))) AND :OLD.dat_storna IS NULL THEN
    :NEW.dat_storna := TRUNC (NVL (:NEW.dat_storna, SYSDATE));
    :NEW.storno_dat := SYSDATE;
    :NEW.storno_korisnik := zmp_zaj.korisnik (-1); -- IRN 3456
  END IF;

  IF :NEW.dat_storna IS NOT NULL THEN
    pra_t_rezervacije.provjeri_dat_storna (:NEW.dat_storna, :NEW.datum);
  END IF;

  IF NVL (:OLD.ozn_vstorna, 0) <> NVL (:NEW.ozn_vstorna, 0) THEN
    IF :NEW.ozn_vstorna = 3 OR (:NEW.ozn_vstorna = 1 AND :NEW.recpotk_oznaka IS NOT NULL) THEN
      pra_rec_iud4.puni_recrezns (:OLD.id, :NEW.ozn_vstorna);
    END IF;
  END IF;

  -- IRN 3810
  IF :OLD.token_status IS NOT NULL THEN
    IF NVL (:OLD.br_uputnice, '') <> NVL (:NEW.br_uputnice, '')
      OR NVL (:OLD.creator_id, '') <> NVL (:NEW.creator_id, '')
    THEN
      -- Podatke Reservation ID i Creator ID nije doputeno promijeniti nakon slanja zahtjeva za tokenizaciju.
      pra_rec_zaj.vrati_poruku (-20662);
    END IF;
  END IF;
  -- KRAJ IRN 3810

  -- IRN 3860
  -- nove vrijednosti
  zapis_dom_l.rez_row_new.id := :NEW.id;
  zapis_dom_l.rez_row_new.oznaka := :NEW.oznaka;
  zapis_dom_l.rez_row_new.ozn_vstorna := :NEW.ozn_vstorna;
  zapis_dom_l.rez_row_new.so_id := :NEW.so_id;
  zapis_dom_l.rez_row_new.god_poslovna := :NEW.god_poslovna;
  zapis_dom_l.rez_row_new.rbr := :NEW.rbr;
  zapis_dom_l.rez_row_new.dat_dolaska := :NEW.dat_dolaska;
  zapis_dom_l.rez_row_new.dat_odlaska := :NEW.dat_odlaska;
  zapis_dom_l.rez_row_new.ime := :NEW.ime;
  zapis_dom_l.rez_row_new.prezime := :NEW.prezime;
  zapis_dom_l.rez_row_new.zem_id := :NEW.zem_id;
  zapis_dom_l.rez_row_new.zemd_id := :NEW.zemd_id;
  zapis_dom_l.rez_row_new.ozn_vip := :NEW.ozn_vip;
  zapis_dom_l.rez_row_new.napomena := :NEW.napomena;   
  zapis_dom_l.rez_row_new.age_id := :NEW.age_id; -- IRN 4030
  zapis_dom_l.rez_row_new.ponso_id := :NEW.ponso_id; -- IRN 4030

  -- stare vrijednosti
  -- id
  zapis_dom_l.rez_row_old.oznaka := :OLD.oznaka;
  zapis_dom_l.rez_row_old.ozn_vstorna := :OLD.ozn_vstorna;
  -- so_id
  -- god_poslovna
  -- rbr
  zapis_dom_l.rez_row_old.dat_dolaska := :OLD.dat_dolaska;
  zapis_dom_l.rez_row_old.dat_odlaska := :OLD.dat_odlaska;
  zapis_dom_l.rez_row_old.ime := :OLD.ime;
  zapis_dom_l.rez_row_old.prezime := :OLD.prezime;
  zapis_dom_l.rez_row_old.zem_id := :OLD.zem_id;
  zapis_dom_l.rez_row_old.zemd_id := :OLD.zemd_id;
  zapis_dom_l.rez_row_old.ozn_vip := :OLD.ozn_vip;
  zapis_dom_l.rez_row_old.napomena := :OLD.napomena;
  tab_t_rezervacije_dom.puni_tablicu (zapis_dom_l);
  -- KRAJ IRN 3860

  /*
  IRN 3977; preseljeno prije tab_t_rezervacije_flex.puni_tablicu
  jer se u zapis_flex_l puni unos_korisnik i izmjena_korisnik
  */
  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);

  -- IRN 3625
  -- nove vrijednosti
  zapis_flex_l.rez_row_new.id := :NEW.id;
  zapis_flex_l.rez_row_new.oznaka := :NEW.oznaka;
  zapis_flex_l.rez_row_new.ozn_vstorna := :NEW.ozn_vstorna;
  zapis_flex_l.rez_row_new.so_id := :NEW.so_id;
  zapis_flex_l.rez_row_new.god_poslovna := :NEW.god_poslovna;
  zapis_flex_l.rez_row_new.rbr := :NEW.rbr;
  zapis_flex_l.rez_row_new.dat_dolaska := :NEW.dat_dolaska;
  zapis_flex_l.rez_row_new.dat_odlaska := :NEW.dat_odlaska;
  zapis_flex_l.rez_row_new.ime := :NEW.ime;
  zapis_flex_l.rez_row_new.prezime := :NEW.prezime;
  zapis_flex_l.rez_row_new.zem_id := :NEW.zem_id;
  zapis_flex_l.rez_row_new.zemd_id := :NEW.zemd_id;
  zapis_flex_l.rez_row_new.ozn_vip := :NEW.ozn_vip;
  zapis_flex_l.rez_row_new.napomena := :NEW.napomena;
  zapis_flex_l.rez_row_new.unos_korisnik := :NEW.unos_korisnik; -- IRN 3977
  zapis_flex_l.rez_row_new.izmjena_korisnik := :NEW.izmjena_korisnik; -- IRN 3977
  -- stare vrijednosti
  -- id
  zapis_flex_l.rez_row_old.oznaka := :OLD.oznaka;
  zapis_flex_l.rez_row_old.ozn_vstorna := :OLD.ozn_vstorna;
  -- so_id
  -- god_poslovna
  -- rbr
  zapis_flex_l.rez_row_old.dat_dolaska := :OLD.dat_dolaska;
  zapis_flex_l.rez_row_old.dat_odlaska := :OLD.dat_odlaska;
  zapis_flex_l.rez_row_old.ime := :OLD.ime;
  zapis_flex_l.rez_row_old.prezime := :OLD.prezime;
  zapis_flex_l.rez_row_old.zem_id := :OLD.zem_id;
  zapis_flex_l.rez_row_old.zemd_id := :OLD.zemd_id;
  zapis_flex_l.rez_row_old.ozn_vip := :OLD.ozn_vip;
  zapis_flex_l.rez_row_old.napomena := :OLD.napomena;
  tab_t_rezervacije_flex.puni_tablicu (zapis_flex_l);
  -- KRAJ IRN 3625

END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUS_T_REZERVACIJE'
CREATE OR REPLACE TRIGGER BUS_T_REZERVACIJE
 BEFORE UPDATE
 ON T_REZERVACIJE
BEGIN
  tab_t_rezervacije.brisi_tablicu;
  tab_t_rezervacije_flex.brisi_tablicu;
  tab_t_rezervacije_dom.brisi_tablicu;
END;
/
SHOW ERROR
