PROMPT Creating Trigger 'ARL_T_REZ_GUSL'
CREATE OR REPLACE TRIGGER ARL_T_REZ_GUSL
 AFTER DELETE OR INSERT OR UPDATE
 ON T_REZ_GUSL
 FOR EACH ROW
BEGIN
  -- IRN 2888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN;  -- izlaz iz trigera
  END IF;

  replikacija5.napuni_tab (:OLD.id, :NEW.id);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'ASL_T_REZ_GUSL'
CREATE OR REPLACE TRIGGER ASL_T_REZ_GUSL
 AFTER DELETE OR INSERT OR UPDATE
 ON T_REZ_GUSL
BEGIN
  replikacija5.upisi_u_log (
    aplikacija_p => 'REC',
    tablica_p    => 'T_REZ_GUSL');
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIR_T_REZ_GUSL'
CREATE OR REPLACE TRIGGER BIR_T_REZ_GUSL
 BEFORE INSERT
 ON T_REZ_GUSL
 FOR EACH ROW
BEGIN
  -- IRN 2888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN;  -- izlaz iz trigera
  END IF;

  :NEW.id := pra_zmp_zaj.i3_sekvenca (:NEW.id);

  :NEW.dat_poc := TRUNC (:NEW.dat_poc);
  :NEW.dat_zav := TRUNC (:NEW.dat_zav);

  FOR rez_c IN ( -- IRN 3332
    SELECT rez.dat_dolaska, rez.dat_odlaska, rez.ponso_id, rez.so_id
      FROM t_rez_gost rezgost,
           t_rez_vsj rezvsj,
           t_rezervacije rez
     WHERE rezgost.id = :NEW.rezgost_id
       AND rezgost.rezvsj_id = rezvsj.id
       AND rezvsj.rez_id = rez.id)
  LOOP
    IF :NEW.dat_poc IS NOT NULL
      AND :NEW.dat_poc NOT BETWEEN rez_c.dat_dolaska AND rez_c.dat_odlaska
    THEN
      -- Poetak usluge ne moe biti izvan razdoblja boravka.
      pra_rec_zaj.vrati_poruku (-20030);
    END IF;
    IF :NEW.dat_zav IS NOT NULL
      AND :NEW.dat_zav NOT BETWEEN rez_c.dat_dolaska AND rez_c.dat_odlaska
    THEN
      -- Zavretak usluge ne moe biti izvan razdoblja boravka.
      pra_rec_zaj.vrati_poruku (-20031);
    END IF;
    IF :NEW.ozn_ugo IN (-1)
      AND pra_rec_s4.usl_je_ponudena (rez_c.ponso_id, :NEW.usl_id) = 0
    THEN
      -- Usluga nije vezana za rezerviranu ponudu/ugovor.
      pra_rec_zaj.vrati_poruku (-20655);
    END IF;
    pra_rec_s5.provjeri_recsousl (rez_c.so_id, :NEW.usl_id); -- IRN 4118
  END LOOP;

  pra_rec.provjeri_sastojak (:NEW.usl_id, :NEW.sas_id);
  pra_rec_s2.provjeri_usl_ara (:NEW.usl_id, :NEW.recara_id);

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BSL_T_REZ_GUSL'
CREATE OR REPLACE TRIGGER BSL_T_REZ_GUSL
 BEFORE DELETE OR INSERT OR UPDATE
 ON T_REZ_GUSL
BEGIN
  replikacija5.brisi_tab;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUR_T_REZ_GUSL'
CREATE OR REPLACE TRIGGER BUR_T_REZ_GUSL
 BEFORE UPDATE
 ON T_REZ_GUSL
 FOR EACH ROW
BEGIN
  :NEW.dat_poc := TRUNC (:NEW.dat_poc);
  :NEW.dat_zav := TRUNC (:NEW.dat_zav);

  IF :NEW.rezgost_id <> :OLD.rezgost_id THEN 
    pra_rec_zaj.vrati_poruku (-20096);
  END IF;

  FOR rez_c IN ( -- IRN 3332
    SELECT rez.dat_dolaska, rez.dat_odlaska, rez.ponso_id, rez.so_id
      FROM t_rez_gost rezgost,
           t_rez_vsj rezvsj,
           t_rezervacije rez
     WHERE rezgost.id = :NEW.rezgost_id
       AND rezgost.rezvsj_id = rezvsj.id
       AND rezvsj.rez_id = rez.id)
  LOOP
    IF :NEW.dat_poc IS NOT NULL
      AND :NEW.dat_poc NOT BETWEEN rez_c.dat_dolaska AND rez_c.dat_odlaska
    THEN
      -- Poetak usluge ne moe biti izvan razdoblja boravka.
      pra_rec_zaj.vrati_poruku (-20030);
    END IF;
    IF :NEW.dat_zav IS NOT NULL
      AND :NEW.dat_zav NOT BETWEEN rez_c.dat_dolaska AND rez_c.dat_odlaska
    THEN
      -- Zavretak usluge ne moe biti izvan razdoblja boravka.
      pra_rec_zaj.vrati_poruku (-20031);
    END IF;
    IF :NEW.ozn_ugo IN (-1)
      AND pra_rec_s4.usl_je_ponudena (rez_c.ponso_id, :NEW.usl_id) = 0
    THEN
      -- Usluga nije vezana za rezerviranu ponudu/ugovor.
      pra_rec_zaj.vrati_poruku (-20655);
    END IF;
    -- IRN 4118
    IF :NEW.usl_id <> :OLD.usl_id THEN 
      pra_rec_s5.provjeri_recsousl (rez_c.so_id, :NEW.usl_id);
    END IF;
  END LOOP;

  pra_rec.provjeri_sastojak (:NEW.usl_id, :NEW.sas_id);
  pra_rec_s2.provjeri_usl_ara (:NEW.usl_id, :NEW.recara_id);

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR
