-- C:\Radni\t_kgostiju.trg
--
-- Generated for Oracle 10g on Tue May 06  14:14:28 2025 by Server Generator 6.5.96.5.6
 























PROMPT Creating Trigger 'AIS_T_KGOSTIJU'
CREATE OR REPLACE TRIGGER AIS_T_KGOSTIJU
 AFTER INSERT
 ON T_KGOSTIJU
DECLARE


  zapis_l tab_t_kgostiju.kgost_rec_type;
BEGIN
  tab_t_kgostiju.postavi_iterator;
  WHILE tab_t_kgostiju.ima_jos LOOP
    zapis_l := tab_t_kgostiju.slijedeci_red;
    pra_t_kgostiju.provjeri_gost_fiktivni (zapis_l.kgost_rec_new.gost_id);
    pra_t_kgostiju.provjeri_datum_rodjenja (zapis_l.kgost_rec_new.gost_id, zapis_l.kgost_rec_new.dat_rodjenja);
    pra_t_kgostiju.provjeri_datum_ulaska (zapis_l.kgost_rec_new.gost_id, zapis_l.kgost_rec_new.dat_ulaska);
    pra_t_kgostiju.provjeri_datum_boravka (zapis_l.kgost_rec_new.gost_id, zapis_l.kgost_rec_new.dat_boravka);
    pra_t_kgostiju.provjeri_vknjiga_zemlju (zapis_l.kgost_rec_new.gost_id, zapis_l.kgost_rec_new.ozn_vknjiga);
    pra_t_kgostiju.provjeri_zemd_vpisp (zapis_l.kgost_rec_new.gost_id, zapis_l.kgost_rec_new.vpisp_id); -- IRN 3387
    pra_t_kgostiju.provjeri_kgost (zapis_l.kgost_rec_new.id, zapis_l.kgost_rec_new.gost_id);
    pra_t_kgostiju.promijeni_troskove_vplabp (zapis_l.kgost_rec_new.gost_id, NULL, zapis_l.kgost_rec_new.vplabp_id);
    pra_t_kgostiju.promijeni_troskove_uslusl (zapis_l.kgost_rec_new.gost_id, NULL, zapis_l.kgost_rec_new.dat_rodjenja);
    -- IRN 2847
    pra_flexkeeping.post_booking_kgost (zapis_l.kgost_rec_new.gost_id, NULL, zapis_l.kgost_rec_new.dat_rodjenja, NULL);
    -- IRN 3860
    pra_dom_api.dom_post_booking_kgost (
	  zapis_l.kgost_rec_new.gost_id,
	  NULL,
	  zapis_l.kgost_rec_new.dat_rodjenja,
	  NULL,
	  zapis_l.kgost_rec_new.ozn_spola,  -- IRN 4030
	  zapis_l.kgost_rec_new.reg_vozila); -- IRN 4030
  END LOOP;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'AUS_T_KGOSTIJU'
CREATE OR REPLACE TRIGGER AUS_T_KGOSTIJU
 AFTER UPDATE
 ON T_KGOSTIJU
DECLARE

  zapis_l tab_t_kgostiju.kgost_rec_type;
  dat_null_l DATE := TO_DATE ('01.01.1800', 'DD.MM.RRRR'); -- IRN 3991
BEGIN
  tab_t_kgostiju.postavi_iterator;
  WHILE tab_t_kgostiju.ima_jos LOOP
    zapis_l := tab_t_kgostiju.slijedeci_red;
    IF zapis_l.kgost_rec_new.oznaka = 'V' THEN

      /* Provjeri datum roenja - datum dolaska */
      IF zapis_l.kgost_rec_new.gost_id <> zapis_l.kgost_rec_old.gost_id
        OR NVL (zapis_l.kgost_rec_new.dat_rodjenja, dat_null_l) <> 
           NVL (zapis_l.kgost_rec_old.dat_rodjenja, dat_null_l)
      THEN
        pra_t_kgostiju.provjeri_datum_rodjenja (
          zapis_l.kgost_rec_new.gost_id, zapis_l.kgost_rec_new.dat_rodjenja);
      END IF;

      /* Provjeri datum ulaska - datum dolaska */
      IF zapis_l.kgost_rec_new.gost_id <> zapis_l.kgost_rec_old.gost_id
        OR NVL (zapis_l.kgost_rec_new.dat_ulaska, dat_null_l) <> 
           NVL (zapis_l.kgost_rec_old.dat_ulaska, dat_null_l)
      THEN
        pra_t_kgostiju.provjeri_datum_ulaska (
          zapis_l.kgost_rec_new.gost_id, zapis_l.kgost_rec_new.dat_ulaska);
      END IF;

      /* Provjeri datum boravka - datum odlaska */
      IF zapis_l.kgost_rec_new.gost_id <> zapis_l.kgost_rec_old.gost_id
        OR NVL (zapis_l.kgost_rec_new.dat_boravka, dat_null_l) <> 
           NVL (zapis_l.kgost_rec_old.dat_boravka, dat_null_l)
      THEN
        pra_t_kgostiju.provjeri_datum_boravka (
          zapis_l.kgost_rec_new.gost_id, zapis_l.kgost_rec_new.dat_boravka);
      END IF;

      -- IRN 3387; Provjeri dravljanstvo i vrstu putnih isprava
      IF zapis_l.kgost_rec_new.gost_id <> zapis_l.kgost_rec_old.gost_id
        OR zapis_l.kgost_rec_new.vpisp_id <> zapis_l.kgost_rec_old.vpisp_id
      THEN
        pra_t_kgostiju.provjeri_zemd_vpisp (
          zapis_l.kgost_rec_new.gost_id, zapis_l.kgost_rec_new.vpisp_id);
      END IF;

      /* Provjeri koliinu valjanih prijava */
      IF zapis_l.kgost_rec_new.gost_id <> zapis_l.kgost_rec_old.gost_id THEN
        pra_t_kgostiju.provjeri_kgost (
          zapis_l.kgost_rec_new.id, zapis_l.kgost_rec_new.gost_id);
      END IF;

    END IF;

    /*
    Zabrani izmjenu ponitenog retka i prijavu za odjavljenog gosta. 
    Ne moe se koristiti procedura pra_rec.zabrani_izmjenu_dokumenta (:OLD.oznaka)
    koja zabranjuje kompletan UPDATE jer se mora dopustiti izmjenu nekih podataka.
    Mora biti u AUS jer ita gosta a izmjena je moda pokrenuta iz izmjene gosta.
    */
    pra_t_kgostiju.zabrani_izmjenu_kgostiju (zapis_l.kgost_rec_old, zapis_l.kgost_rec_new);

    pra_t_kgostiju.promijeni_troskove_vplabp (
      zapis_l.kgost_rec_new.gost_id, zapis_l.kgost_rec_old.vplabp_id, zapis_l.kgost_rec_new.vplabp_id);
    pra_t_kgostiju.promijeni_troskove_uslusl (
      zapis_l.kgost_rec_new.gost_id, zapis_l.kgost_rec_old.dat_rodjenja, zapis_l.kgost_rec_new.dat_rodjenja);

    -- IRN 2847
    pra_flexkeeping.post_booking_kgost (
      zapis_l.kgost_rec_new.gost_id,
      zapis_l.kgost_rec_old.gost_id,
      zapis_l.kgost_rec_new.dat_rodjenja,
      zapis_l.kgost_rec_old.dat_rodjenja);

    -- IRN 3860
    pra_dom_api.dom_post_booking_kgost (
      zapis_l.kgost_rec_new.gost_id,
      zapis_l.kgost_rec_old.gost_id,
      zapis_l.kgost_rec_new.dat_rodjenja,
      zapis_l.kgost_rec_old.dat_rodjenja,
      zapis_l.kgost_rec_new.ozn_spola, -- IRN 4030
      zapis_l.kgost_rec_new.reg_vozila); -- IRN 4030

  END LOOP;

END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIR_T_KGOSTIJU'
CREATE OR REPLACE TRIGGER BIR_T_KGOSTIJU
 BEFORE INSERT
 ON T_KGOSTIJU
 FOR EACH ROW
DECLARE

  kgost_rec_l  tab_t_kgostiju.kgost_rec_type;
BEGIN
  -- IRN 02888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN;  -- izlaz iz trigera
  END IF;

  :NEW.id := pra_zmp_zaj.i3_sekvenca (:NEW.id);

  :NEW.dat_rodjenja := TRUNC (:NEW.dat_rodjenja);
  :NEW.dat_ulaska := TRUNC (:NEW.dat_ulaska);
  :NEW.dat_boravka := TRUNC (:NEW.dat_boravka);
  :NEW.oznaka := UPPER (:NEW.oznaka);
  :NEW.ozn_datrodj := UPPER (:NEW.ozn_datrodj);
  :NEW.ozn_spola := UPPER (:NEW.ozn_spola);
  :NEW.god_poslovna := pra_rec_zaj.poslovna_godina (:NEW.god_poslovna);
  :NEW.pritz_id_p := NULL;
  :NEW.pritz_id_o := NULL;
  :NEW.tzid := pra_zmp_zaj.formatted_guid (:NEW.tzid); -- IRN 2436
  :NEW.pritz2p_id := NULL; -- IRN 2436
  :NEW.pritz2o_id := NULL; -- IRN 2436
  :NEW.pritz2i_id := NULL; -- IRN 2436
  :NEW.recprimup1_id := NULL;
  :NEW.recprimup2_id := NULL;
  pra_zmp_zaj.oblikuj_slovo_upp_broj (:NEW.reg_vozila); -- IRN 2165

  pra_rec.provjeri_regiju (:NEW.reg_id, :NEW.zem_id);
  pra_rec.provjeri_postu (:NEW.pos_id, :NEW.zem_id);
  pra_t_kgostiju.provjeri_zemlju_rodjenja (:NEW.zemr_id, :NEW.posr_id);

  pra_rec.izracunaj_redni_broj (
    'T_KGOSTIJU',
    :NEW.god_poslovna,
    :NEW.knjm_id,
    :NEW.ozn_vknjiga,
    6,
    :NEW.rbr);

  kgost_rec_l.kgost_rec_new.id := :NEW.id;
  kgost_rec_l.kgost_rec_new.gost_id := :NEW.gost_id;
  kgost_rec_l.kgost_rec_new.vplabp_id := :NEW.vplabp_id;
  kgost_rec_l.kgost_rec_new.vpisp_id := :NEW.vpisp_id; -- IRN 3387
  kgost_rec_l.kgost_rec_new.ozn_vknjiga := :NEW.ozn_vknjiga;
  kgost_rec_l.kgost_rec_new.oznaka := :NEW.oznaka;
  kgost_rec_l.kgost_rec_new.dat_rodjenja := :NEW.dat_rodjenja;
  kgost_rec_l.kgost_rec_new.dat_ulaska := :NEW.dat_ulaska;
  kgost_rec_l.kgost_rec_new.dat_boravka := :NEW.dat_boravka;  
  kgost_rec_l.kgost_rec_new.ozn_spola := :NEW.ozn_spola; -- IRN 4030
  kgost_rec_l.kgost_rec_new.reg_vozila := :NEW.reg_vozila; -- IRN 4030
  tab_t_kgostiju.puni_tablicu (kgost_rec_l);

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIS_T_KGOSTIJU'
CREATE OR REPLACE TRIGGER BIS_T_KGOSTIJU
 BEFORE INSERT
 ON T_KGOSTIJU
BEGIN
  tab_t_kgostiju.brisi_tablicu;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUR_T_KGOSTIJU'
CREATE OR REPLACE TRIGGER BUR_T_KGOSTIJU
 BEFORE UPDATE
 ON T_KGOSTIJU
 FOR EACH ROW
DECLARE

  kgost_rec_l tab_t_kgostiju.kgost_rec_type;
  dat_null_l DATE := TO_DATE ('01.01.1800', 'DD.MM.RRRR');
  naz_null_l VARCHAR2(1) := '';
  domzem_l szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0002');  -- IRN 2785
BEGIN
  -- IRN 2906
  IF pra_pka_anonim.anonim_u_tijeku ('T_KGOSTIJU', :OLD.id) = -1 THEN
    pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
    RETURN; -- izlaz iz trigera
  END IF;

  :NEW.dat_rodjenja := TRUNC (:NEW.dat_rodjenja);
  :NEW.dat_ulaska := TRUNC (:NEW.dat_ulaska);
  :NEW.dat_boravka := TRUNC (:NEW.dat_boravka);
  :NEW.oznaka := UPPER (:NEW.oznaka);
  :NEW.ozn_datrodj := UPPER (:NEW.ozn_datrodj);
  :NEW.ozn_spola := UPPER (:NEW.ozn_spola);
  pra_zmp_zaj.oblikuj_slovo_upp_broj (:NEW.reg_vozila); -- IRN 2165

  -- Zabrani izmjenu UK
  IF :NEW.god_poslovna <> :OLD.god_poslovna
    OR :NEW.knjm_id <> :OLD.knjm_id
    OR :NEW.ozn_vknjiga <> :OLD.ozn_vknjiga
    OR :NEW.rbr <> :OLD.rbr
  THEN
    pra_rec_zaj.vrati_poruku (-20100);
  END IF;

  -- prijavljenim gostima se ne smije mijenjati TZID, sat_dolaska
  IF :OLD.pritz2p_id IS NOT NULL AND
    (NVL (:NEW.tzid, naz_null_l) <> NVL (:OLD.tzid, naz_null_l)
    OR NVL (:NEW.sat_dolaska, dat_null_l) <> NVL (:OLD.sat_dolaska, dat_null_l)
    ) THEN
    pra_rec_zaj.vrati_poruku (-20590);
  END IF;

  pra_rec.provjeri_regiju (:NEW.reg_id, :NEW.zem_id);
  pra_rec.provjeri_postu (:NEW.pos_id, :NEW.zem_id);
  pra_t_kgostiju.provjeri_zemlju_rodjenja (:NEW.zemr_id, :NEW.posr_id);

  pra_rec.provjeri_dopustenu_tranziciju (:NEW.oznaka, :OLD.oznaka);

  -- pamti stare vrijednosti
  kgost_rec_l.kgost_rec_old.id := :OLD.id;
  kgost_rec_l.kgost_rec_old.gost_id := :OLD.gost_id;
  kgost_rec_l.kgost_rec_old.vpisp_id := :OLD.vpisp_id;
  kgost_rec_l.kgost_rec_old.posr_id := :OLD.posr_id;
  kgost_rec_l.kgost_rec_old.zemr_id := :OLD.zemr_id;
  kgost_rec_l.kgost_rec_old.vplabp_id := :OLD.vplabp_id;
  kgost_rec_l.kgost_rec_old.gpri_id := :OLD.gpri_id;
  kgost_rec_l.kgost_rec_old.vviz_id := :OLD.vviz_id;
  kgost_rec_l.kgost_rec_old.pos_id := :OLD.pos_id;
  kgost_rec_l.kgost_rec_old.reg_id := :OLD.reg_id;
  kgost_rec_l.kgost_rec_old.zem_id := :OLD.zem_id;
  -- pritz_id_p
  -- pritz_id_o
  -- recprimup1_id
  -- recprimup2_id
  -- god_poslovna UK
  -- ozn_vknjiga  UK
  -- rbr          UK
  kgost_rec_l.kgost_rec_old.oznaka := :OLD.oznaka;
  kgost_rec_l.kgost_rec_old.br_pisprave := :OLD.br_pisprave;
  kgost_rec_l.kgost_rec_old.naz_mjpisp := :OLD.naz_mjpisp;
  kgost_rec_l.kgost_rec_old.ozn_datrodj := :OLD.ozn_datrodj;
  kgost_rec_l.kgost_rec_old.dat_rodjenja := :OLD.dat_rodjenja;
  kgost_rec_l.kgost_rec_old.naz_mjrodj := :OLD.naz_mjrodj;
  kgost_rec_l.kgost_rec_old.ozn_spola := :OLD.ozn_spola;
  kgost_rec_l.kgost_rec_old.dat_ulaska := :OLD.dat_ulaska;
  kgost_rec_l.kgost_rec_old.dat_boravka := :OLD.dat_boravka;
  kgost_rec_l.kgost_rec_old.naz_ulice := :OLD.naz_ulice;
  kgost_rec_l.kgost_rec_old.naz_mjesta := :OLD.naz_mjesta;
  kgost_rec_l.kgost_rec_old.naz_regije := :OLD.naz_regije;
  kgost_rec_l.kgost_rec_old.br_vize := :OLD.br_vize;
  kgost_rec_l.kgost_rec_old.naz_mjvize := :OLD.naz_mjvize;
  kgost_rec_l.kgost_rec_old.naz_pboravista := :OLD.naz_pboravista;
  kgost_rec_l.kgost_rec_old.reg_vozila := :OLD.reg_vozila;
  kgost_rec_l.kgost_rec_old.br_telefona := :OLD.br_telefona;
  kgost_rec_l.kgost_rec_old.br_telefaksa := :OLD.br_telefaksa;
  kgost_rec_l.kgost_rec_old.email := :OLD.email;
  kgost_rec_l.kgost_rec_old.www := :OLD.www;
  kgost_rec_l.kgost_rec_old.naz_poduzeca := :OLD.naz_poduzeca;
  kgost_rec_l.kgost_rec_old.ozn_kontakt := :OLD.ozn_kontakt;
  kgost_rec_l.kgost_rec_old.napomena := :OLD.napomena;
  kgost_rec_l.kgost_rec_old.ozn_kontakt_telefon := :OLD.ozn_kontakt_telefon;
  kgost_rec_l.kgost_rec_old.ozn_kontakt_telefaks := :OLD.ozn_kontakt_telefaks;
  kgost_rec_l.kgost_rec_old.ozn_kontakt_email := :OLD.ozn_kontakt_email;
  kgost_rec_l.kgost_rec_old.pritz2p_id := :OLD.pritz2p_id;
  kgost_rec_l.kgost_rec_old.pritz2o_id := :OLD.pritz2o_id;
  -- pritz2i_id
  -- kgost_rec_l.kgost_rec_old.tzid := :OLD.tzid;
  -- dob
  kgost_rec_l.kgost_rec_old.ozn_recagost := :OLD.ozn_recagost;
  kgost_rec_l.kgost_rec_old.ozn_brisano := :OLD.ozn_brisano;
  -- kgost_rec_l.kgost_rec_old.sat_dolaska := :OLD.sat_dolaska;
  kgost_rec_l.kgost_rec_old.sat_dolaska := :OLD.sat_dolaska; -- IRN 2785
  kgost_rec_l.kgost_rec_old.sat_odlaska := :OLD.sat_odlaska;

  -- pamti nove vrijednosti
  kgost_rec_l.kgost_rec_new.id := :NEW.id;
  kgost_rec_l.kgost_rec_new.gost_id := :NEW.gost_id;
  kgost_rec_l.kgost_rec_new.vpisp_id := :NEW.vpisp_id;
  kgost_rec_l.kgost_rec_new.posr_id := :NEW.posr_id;
  kgost_rec_l.kgost_rec_new.zemr_id := :NEW.zemr_id;
  kgost_rec_l.kgost_rec_new.vplabp_id := :NEW.vplabp_id;
  kgost_rec_l.kgost_rec_new.gpri_id := :NEW.gpri_id;
  kgost_rec_l.kgost_rec_new.vviz_id := :NEW.vviz_id;
  kgost_rec_l.kgost_rec_new.pos_id := :NEW.pos_id;
  kgost_rec_l.kgost_rec_new.reg_id := :NEW.reg_id;
  kgost_rec_l.kgost_rec_new.zem_id := :NEW.zem_id;
  -- pritz_id_p
  -- pritz_id_o
  -- recprimup1_id
  -- recprimup2_id
  -- god_poslovna UK
  -- ozn_vknjiga  UK
  -- rbr          UK
  kgost_rec_l.kgost_rec_new.oznaka := :NEW.oznaka;
  kgost_rec_l.kgost_rec_new.br_pisprave := :NEW.br_pisprave;
  kgost_rec_l.kgost_rec_new.naz_mjpisp := :NEW.naz_mjpisp;
  kgost_rec_l.kgost_rec_new.ozn_datrodj := :NEW.ozn_datrodj;
  kgost_rec_l.kgost_rec_new.dat_rodjenja := :NEW.dat_rodjenja;
  kgost_rec_l.kgost_rec_new.naz_mjrodj := :NEW.naz_mjrodj;
  kgost_rec_l.kgost_rec_new.ozn_spola := :NEW.ozn_spola;
  kgost_rec_l.kgost_rec_new.dat_ulaska := :NEW.dat_ulaska;
  kgost_rec_l.kgost_rec_new.dat_boravka := :NEW.dat_boravka;
  kgost_rec_l.kgost_rec_new.naz_ulice := :NEW.naz_ulice;
  kgost_rec_l.kgost_rec_new.naz_mjesta := :NEW.naz_mjesta;
  kgost_rec_l.kgost_rec_new.naz_regije := :NEW.naz_regije;
  kgost_rec_l.kgost_rec_new.br_vize := :NEW.br_vize;
  kgost_rec_l.kgost_rec_new.naz_mjvize := :NEW.naz_mjvize;
  kgost_rec_l.kgost_rec_new.naz_pboravista := :NEW.naz_pboravista;
  kgost_rec_l.kgost_rec_new.reg_vozila := :NEW.reg_vozila;
  kgost_rec_l.kgost_rec_new.br_telefona := :NEW.br_telefona;
  kgost_rec_l.kgost_rec_new.br_telefaksa := :NEW.br_telefaksa;
  kgost_rec_l.kgost_rec_new.email := :NEW.email;
  kgost_rec_l.kgost_rec_new.www := :NEW.www;
  kgost_rec_l.kgost_rec_new.naz_poduzeca := :NEW.naz_poduzeca;
  kgost_rec_l.kgost_rec_new.ozn_kontakt := :NEW.ozn_kontakt;
  kgost_rec_l.kgost_rec_new.napomena := :NEW.napomena;

  kgost_rec_l.kgost_rec_new.ozn_kontakt_telefon := :NEW.ozn_kontakt_telefon;
  kgost_rec_l.kgost_rec_new.ozn_kontakt_telefaks := :NEW.ozn_kontakt_telefaks;
  kgost_rec_l.kgost_rec_new.ozn_kontakt_email := :NEW.ozn_kontakt_email;
  kgost_rec_l.kgost_rec_new.pritz2p_id := :NEW.pritz2p_id;
  kgost_rec_l.kgost_rec_new.pritz2o_id := :NEW.pritz2o_id;
  -- pritz2i_id
  -- kgost_rec_l.kgost_rec_new.tzid := :NEW.tzid;
  -- dob
  kgost_rec_l.kgost_rec_new.ozn_recagost := :NEW.ozn_recagost;
  kgost_rec_l.kgost_rec_new.ozn_brisano := :NEW.ozn_brisano;
  -- kgost_rec_l.kgost_rec_new.sat_dolaska := :NEW.sat_dolaska;
  kgost_rec_l.kgost_rec_new.sat_dolaska := :NEW.sat_dolaska; -- IRN 2785
  kgost_rec_l.kgost_rec_new.sat_odlaska := :NEW.sat_odlaska;

  -- puni tablicu
  tab_t_kgostiju.puni_tablicu (kgost_rec_l);

  IF :NEW.pritz_id_p IS NOT NULL THEN
    IF :NEW.vplabp_id <> :OLD.vplabp_id
      OR :NEW.vpisp_id <> :OLD.vpisp_id
      OR :NEW.br_pisprave <> :OLD.br_pisprave
      OR NVL (:NEW.dat_rodjenja, dat_null_l) <> NVL (:OLD.dat_rodjenja, dat_null_l)
    THEN
      :NEW.pritz_id_p := NULL;
    END IF;
  END IF;

  IF :OLD.pritz2i_id IS NOT NULL AND (domzem_l = 'HR' AND :OLD.pritz2o_id IS NULL OR domzem_l = 'SI') THEN
    IF NVL (:NEW.vpisp_id, 0) <> NVL (:OLD.vpisp_id, 0)
      OR NVL (:NEW.vplabp_id, 0) <> NVL (:OLD.vplabp_id, 0)
      OR NVL (:NEW.br_pisprave, naz_null_l) <> NVL (:OLD.br_pisprave, naz_null_l)
      OR NVL (:NEW.dat_rodjenja, dat_null_l) <> NVL (:OLD.dat_rodjenja, dat_null_l)
      OR NVL (:NEW.ozn_spola, naz_null_l) <> NVL (:OLD.ozn_spola, naz_null_l)
      OR NVL (:NEW.sat_odlaska, dat_null_l) <> NVL (:OLD.sat_odlaska, dat_null_l)
      OR (domzem_l = 'HR' AND -- IRN 2785
          (NVL (:NEW.posr_id, 0) <> NVL (:OLD.posr_id, 0) OR
           NVL (:NEW.zemr_id, 0) <> NVL (:OLD.zemr_id, 0) OR
           NVL (:NEW.pos_id, 0) <> NVL (:OLD.pos_id, 0) OR
           -- NVL (:NEW.reg_id, 0) <> NVL (:OLD.reg_id, 0) OR
           NVL (:NEW.zem_id, 0) <> NVL (:OLD.zem_id, 0) OR
           -- NVL (:NEW.ozn_datrodj, naz_null_l) <> NVL (:OLD.ozn_datrodj, naz_null_l) OR
           NVL (:NEW.naz_mjrodj, naz_null_l) <> NVL (:OLD.naz_mjrodj, naz_null_l) OR
           NVL (:NEW.naz_ulice, naz_null_l) <> NVL (:OLD.naz_ulice, naz_null_l) OR
           NVL (:NEW.naz_mjesta, naz_null_l) <> NVL (:OLD.naz_mjesta, naz_null_l) OR
           -- NVL (:NEW.naz_regije, naz_null_l) <> NVL (:OLD.naz_regije, naz_null_l) OR
           NVL (:NEW.naz_pboravista, naz_null_l) <> NVL (:OLD.naz_pboravista, naz_null_l)))
      OR (domzem_l = 'SI' AND -- IRN 2785
          (NVL (:NEW.sat_dolaska, dat_null_l) <> NVL (:OLD.sat_dolaska, dat_null_l) OR
           :NEW.oznaka <> :OLD.oznaka))
    THEN
      :NEW.pritz2i_id := NULL; -- izmjena za eVisitor
    END IF;
  END IF;

  -- Upii eventualnu promjenu datuma rodjenja u promjene
  pra_t_kgostiju.upisi_promjenu_dat_rodjenja (:NEW.gost_id, :OLD.dat_rodjenja, :NEW.dat_rodjenja);

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUS_T_KGOSTIJU'
CREATE OR REPLACE TRIGGER BUS_T_KGOSTIJU
 BEFORE UPDATE
 ON T_KGOSTIJU
BEGIN
  tab_t_kgostiju.brisi_tablicu;
END;
/
SHOW ERROR





