PROMPT Creating Trigger 'AIS_T_GOSTI'
CREATE OR REPLACE TRIGGER AIS_T_GOSTI
 AFTER INSERT
 ON T_GOSTI
DECLARE

  zapis_l      tab_t_gosti.gost_rec_type;
  zapis_stsj_l tab_t_gosti_stsj.gost_stsj_rec_type;
BEGIN
  tab_t_gosti.postavi_iterator;
  WHILE tab_t_gosti.ima_jos LOOP
    zapis_l := tab_t_gosti.sljedeci_red;
    pra_t_gosti.provjeri_fiktivni_u_sj (
      zapis_l.gost_id,
      zapis_l.dat_dolaska_new,
      zapis_l.dat_odlaska_new,
      zapis_l.sj_id_new,
      zapis_l.ozn_fiktivni);
    -- 31.05.2007. G.J.
    pra_t_gosti.azuriraj_recgost2_share_flag (zapis_l);
    -- Izradi zahtjeve prema vanjskim sustavima (TCO, IP, PTV)
    pra_t_gosti.izradi_vszah (zapis_l);
    -- Puni Key Card zahtjeve vrste 21 Prijavi korisnika kartice
    pra_rec_kc_iud.puni_kczah_gost21 (
      zapis_l.gost_id,
      zapis_l.sj_id_new,
      zapis_l.dat_dolaska_new,
      zapis_l.dat_odlaska_new,
      zapis_l.sat_odlaska_new, -- IRN 1700
      zapis_l.ime_new,
      zapis_l.prezime_new,
      zapis_l.br_kartice);
    -- Auriraj kartice Key Card sustava
    pra_rec_kc_iud.azuriraj_kckar_gost (
      zapis_l.gost_id,
      zapis_l.sj_id_new,
      zapis_l.dat_dolaska_new,
      zapis_l.dat_odlaska_new,
      zapis_l.sat_odlaska_new, -- IRN 1700
      zapis_l.ime_new,
      zapis_l.prezime_new,
      zapis_l.ozn_prisutnosti_new,
      zapis_l.br_kartice,
      zapis_l.rezgost_id); -- IRN 2931
    -- Upii boravak gosta
    pra_t_gosti.insert_recgostbor (
      zapis_l.gost_id,
      zapis_l.sj_id_new,
      zapis_l.dat_dolaska_new,
      zapis_l.dat_odlaska_new);
    -- 07.02.2007. G.J.
    -- Provjeri razdoblje boravka gosta iz arhive
    pra_t_gosti.provjeri_razdoblje (
      zapis_l.gost_id,
      zapis_l.recagost_id_new,
      zapis_l.dat_dolaska_new,
      zapis_l.dat_odlaska_new);
    -- IRN 3275; Provjeri razdoblje boravka gosta korisnika ugovora o zakupu
    pra_t_gosti.provjeri_razdoblje_zakkor (
      zapis_l.gost_id,
      zapis_l.zakkor_id,
      zapis_l.dat_dolaska_new,
      zapis_l.dat_odlaska_new);
    -- IRN 2847
    pra_flexkeeping.post_booking_gost (zapis_l);
    -- IRN 3860
    pra_dom_api.dom_post_booking_gost (zapis_l);
  END LOOP;

  /*
  Auriraj kol_sjZ i br_osobaZ u T_REZ_VSJ,
  booking za stupanj prodaje O i status SJ.
  */
  tab_t_gosti_stsj.postavi_iterator;
  WHILE tab_t_gosti_stsj.ima_jos LOOP
    zapis_stsj_l := tab_t_gosti_stsj.slijedeci_red;

    pra_t_gosti.dodaj_booking_y_kolsjz (
      zapis_stsj_l.gost_id,
      zapis_stsj_l.rezvsj_id,
      zapis_stsj_l.recrezsj_id,
      zapis_stsj_l.new_sj_id);
    pra_t_gosti.dodaj_booking_statussj (
      zapis_stsj_l.new_ms_id,
      zapis_stsj_l.new_age_id,
      zapis_stsj_l.new_ponso_id,
      zapis_stsj_l.new_recvpro_id,
      'O',
      zapis_stsj_l.new_dat_dolaska_u_sj,
      zapis_stsj_l.new_dat_odlaska,
      zapis_stsj_l.new_sj_id,
      zapis_stsj_l.gost_id,
      zapis_stsj_l.rezvsj_id);
  END LOOP;

END;
/
SHOW ERROR


PROMPT Creating Trigger 'AUS_T_GOSTI'
CREATE OR REPLACE TRIGGER AUS_T_GOSTI
 AFTER UPDATE
 ON T_GOSTI
DECLARE

  zapis_stsj_l tab_t_gosti_stsj.gost_stsj_rec_type;
  zapis_l      tab_t_gosti.gost_rec_type;
  domzem_l     szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0002');  -- IRN 2785
BEGIN

  -- Auriraj booking i status SJ
  -- IRN 3977; preseljeno na poetak, prije poziva procedure pra_rec_iud4.puni_pkaoba_overbooking
  tab_t_gosti_stsj.postavi_iterator;
  WHILE tab_t_gosti_stsj.ima_jos LOOP
    zapis_stsj_l := tab_t_gosti_stsj.slijedeci_red;
    pra_t_gosti.azuriraj_booking_statussj (
      zapis_stsj_l.gost_id,
      zapis_stsj_l.rezvsj_id,
      zapis_stsj_l.old_sj_id,
      zapis_stsj_l.old_dat_dolaska_u_sj,
      zapis_stsj_l.old_dat_odlaska,
      zapis_stsj_l.old_ms_id,
      zapis_stsj_l.old_age_id,
      zapis_stsj_l.old_ponso_id,
      zapis_stsj_l.old_recvpro_id,
      zapis_stsj_l.new_sj_id,
      zapis_stsj_l.new_dat_dolaska_u_sj,
      zapis_stsj_l.new_dat_odlaska,
      zapis_stsj_l.new_ms_id,
      zapis_stsj_l.new_age_id,
      zapis_stsj_l.new_ponso_id,
      zapis_stsj_l.new_recvpro_id);
  END LOOP;

  tab_t_gosti.postavi_iterator;
  WHILE tab_t_gosti.ima_jos LOOP
    zapis_l := tab_t_gosti.sljedeci_red;
    pra_t_gosti.provjeri_fiktivni_u_sj (
      zapis_l.gost_id,
      zapis_l.dat_dolaska_new,
      zapis_l.dat_odlaska_new,
      zapis_l.sj_id_new,
      zapis_l.ozn_fiktivni);
    -- Izradi zahtjeve prema vanjskim sustavima (TCO, IP, PTV)
    pra_t_gosti.izradi_vszah (zapis_l);
    -- Puni Key Card zahtjeve
    pra_rec_kc_iud.puni_kczah_gost_aus (
      zapis_l.gost_id,
      zapis_l.sj_id_old,
      zapis_l.dat_dolaska_old,
      zapis_l.dat_odlaska_old,
      zapis_l.sat_odlaska_old, -- IRN 1700
      zapis_l.ime_old,
      zapis_l.prezime_old,
      zapis_l.ozn_prisutnosti_old,
      zapis_l.sj_id_new,
      zapis_l.dat_dolaska_new,
      zapis_l.dat_odlaska_new,
      zapis_l.sat_odlaska_new, -- IRN 1700
      zapis_l.ime_new,
      zapis_l.prezime_new,
      zapis_l.ozn_prisutnosti_new);
    -- Auriraj kartice Key Card sustava
    pra_rec_kc_iud.azuriraj_kckar_gost_aus (
      zapis_l.gost_id,
      zapis_l.sj_id_old,
      zapis_l.dat_dolaska_old,
      zapis_l.dat_odlaska_old,
      zapis_l.sat_odlaska_old, -- IRN 1700
      zapis_l.ime_old,
      zapis_l.prezime_old,
      zapis_l.ozn_prisutnosti_old,
      zapis_l.sj_id_new,
      zapis_l.dat_dolaska_new,
      zapis_l.dat_odlaska_new,
      zapis_l.sat_odlaska_new, -- IRN 1700
      zapis_l.ime_new,
      zapis_l.prezime_new,
      zapis_l.ozn_prisutnosti_new);
    -- Auriraj boravke gosta
    pra_t_gosti.azuriraj_recgostbor (
      zapis_l.gost_id,
      zapis_l.sj_id_old,
      zapis_l.sj_id_new,
      zapis_l.dat_dolaska_old,
      zapis_l.dat_dolaska_new,
      zapis_l.dat_dolaska_u_sj_new,
      zapis_l.dat_odlaska_old,
      zapis_l.dat_odlaska_new);
    -- Provjeri razdoblje boravka gosta iz arhive
    pra_t_gosti.provjeri_razdoblje (
      zapis_l.gost_id,
      zapis_l.recagost_id_new,
      zapis_l.dat_dolaska_new,
      zapis_l.dat_odlaska_new);
    -- IRN 3275; Provjeri razdoblje boravka gosta korisnika ugovora o zakupu
    pra_t_gosti.provjeri_razdoblje_zakkor (
      zapis_l.gost_id,
      zapis_l.zakkor_id,
      zapis_l.dat_dolaska_new,
      zapis_l.dat_odlaska_new);
    -- IRN 2847
    pra_flexkeeping.post_booking_gost (zapis_l);
    -- IRN 3860
    pra_dom_api.dom_post_booking_gost (zapis_l);

    -- IRN 2997; auriraj nain potronje i stopu popusta u PayCard
    IF zapis_l.ozn_prisutnosti_new = 'P'
      AND (
        NVL (zapis_l.ponso_id_new, 0) <> NVL (zapis_l.ponso_id_old, 0)
        OR
        NVL (zapis_l.recagost_id_new, 0) <> NVL (zapis_l.recagost_id_old, 0)
        OR
        NVL (zapis_l.ms_id_new, 0) <> NVL (zapis_l.ms_id_old, 0) -- IRN 3105
        )
    THEN
      pra_tpka_kartice.azuriraj_pkakar (
        zapis_l.gost_id,
        zapis_l.ponso_id_new,
        zapis_l.recagost_id_new,
        zapis_l.ms_id_new, -- IRN 3105
        zapis_l.sj_id_new,
        zapis_l.dat_dolaska_new,
        zapis_l.dat_odlaska_new);
    END IF;

    -- IRN 3977; izradi obavijesti o overbokingu
    pra_rec_iud4.puni_pkaoba_overbooking (
      zapis_l.sj_id_old,
      zapis_l.sj_id_new,
      zapis_l.rbr,
      zapis_l.god_poslovna,
      zapis_l.prezime_new,
      zapis_l.dat_dolaska_new,
      zapis_l.dat_odlaska_new,
      zapis_l.gost_id);

    -- Brii pritz_id
    IF zapis_l.zem_id_new <> zapis_l.zem_id_old
      OR zapis_l.ime_new <> zapis_l.ime_old
      OR zapis_l.prezime_new <> zapis_l.prezime_old
      OR zapis_l.dat_dolaska_new <> zapis_l.dat_dolaska_old
      OR zapis_l.dat_odlaska_new <> zapis_l.dat_odlaska_old
      OR (zapis_l.age_id_new IS NULL AND zapis_l.age_id_old IS NOT NULL)
      OR (zapis_l.age_id_new IS NOT NULL AND zapis_l.age_id_old IS NULL)
    THEN
      pra_t_gosti.azuriraj_kgost_pritz_id_p (zapis_l.gost_id);
    END IF;

    IF zapis_l.zem_id_new <> zapis_l.zem_id_old
      OR zapis_l.ime_new <> zapis_l.ime_old
      OR zapis_l.prezime_new <> zapis_l.prezime_old
      OR zapis_l.dat_odlaska_new <> zapis_l.dat_odlaska_old
      OR (domzem_l = 'HR' AND  -- u Hrvatskoj prijavi izmjenu agencije
          (zapis_l.age_id_new IS NULL AND zapis_l.age_id_old IS NOT NULL OR
           zapis_l.age_id_new IS NOT NULL AND zapis_l.age_id_old IS NULL))
      OR (domzem_l = 'SI' AND  -- IRN 2785: u Sloveniji prijavi promjenu datuma dolaska, doputenu unutar iste godine
           (zapis_l.dat_dolaska_new <> zapis_l.dat_dolaska_old AND
            TO_CHAR (zapis_l.dat_dolaska_new, 'rrrr') = TO_CHAR (zapis_l.dat_dolaska_old, 'rrrr')
            OR
            zapis_l.ozn_prisutnosti_new <> zapis_l.ozn_prisutnosti_old))
    THEN
      pra_t_gosti.azuriraj_kgost_pritz2i_id (zapis_l.gost_id); -- IRN 2436
    END IF;

    -- Brii recprimup2_id
    IF zapis_l.dat_odlaska_new <> zapis_l.dat_odlaska_old THEN
      pra_t_gosti.azuriraj_kgost_recprimup2_id (zapis_l.gost_id);

      IF zapis_l.dat_odlaska_new = zapis_l.dat_dolaska_new THEN
        pra_t_gosti.azuriraj_kgost_sat_odlaska (zapis_l.gost_id);
      END IF;

    END IF;

    IF NVL (zapis_l.ozn_brisano_new, 0) = -1 AND
      NVL (zapis_l.ozn_brisano_new, 0) <> NVL (zapis_l.ozn_brisano_old, 0)
    THEN
      pra_t_gosti.ponisti_kgost_brisano (zapis_l.gost_id);
    END IF;

    /* IRN 3523
    IF domzem_l = 'SI' THEN
      pra_t_gosti.azuriraj_kgost_pritz2o_id (zapis_l.gost_id);
    END IF;
    */
    -- IRN 3773 -- Prilikom odjave gosta poniti povezani Pay Card
    IF zapis_l.ozn_prisutnosti_old = 'P'
      AND zapis_l.ozn_prisutnosti_new = 'O'
    THEN
      UPDATE tpka_kartice SET oznaka = 'P' WHERE oznaka = 'V' AND gost_id = zapis_l.gost_id;
    END IF;

  END LOOP;

END;
/
SHOW ERROR


PROMPT Creating Trigger 'BDR_T_GOSTI'
CREATE OR REPLACE TRIGGER BDR_T_GOSTI
 BEFORE DELETE
 ON T_GOSTI
 FOR EACH ROW
BEGIN
  IF :OLD.dat_dolaska <> :OLD.dat_odlaska THEN
    -- Gost se moe brisati samo ako je datum dolaska jednak datumu odlaska.
    pra_rec_zaj.vrati_poruku (-20217);
  END IF;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIR_T_GOSTI'
CREATE OR REPLACE TRIGGER BIR_T_GOSTI
 BEFORE INSERT
 ON T_GOSTI
 FOR EACH ROW
DECLARE

  zapis_l      tab_t_gosti.gost_rec_type;
  zapis_stsj_l tab_t_gosti_stsj.gost_stsj_rec_type;
BEGIN
  -- IRN 2888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN; -- izlaz iz trigera
  END IF;

  :NEW.id := pra_rec_zaj.sekvenca (:NEW.id);
  :NEW.dat_dolaska := TRUNC (:NEW.dat_dolaska);
  :NEW.dat_dolaska_u_sj := TRUNC (:NEW.dat_dolaska);
  :NEW.dat_odlaska := TRUNC (:NEW.dat_odlaska);
  :NEW.ozn_valjanosti := UPPER (:NEW.ozn_valjanosti);
  :NEW.ozn_prisutnosti := UPPER (:NEW.ozn_prisutnosti);
  :NEW.god_poslovna := pra_rec_zaj.poslovna_godina (:NEW.god_poslovna);
  -- 15.10.2001. G.J.
  :NEW.jez_id := pra_t_gosti.jez_id (:NEW.zem_id, :NEW.jez_id);
  pra_zmp_zaj.oblikuj_slovo_upp_broj_all (:NEW.ozn_vip, 1);

  -- 10.05.2007. G.J.
  pra_t_gosti.provjeri_rezgost_rezvsj (:NEW.rezgost_id, :NEW.rezvsj_id);
  pra_t_gosti.provjeri_recrezsj_rezvsj (:NEW.recrezsj_id, :NEW.rezvsj_id);

  pra_t_gosti.provjeri_gosti_rez (:NEW.rezvsj_id, :NEW.age_id, :NEW.ms_id);
  pra_t_gosti.provjeri_zasticenu_sj (:NEW.sj_id, :NEW.rezvsj_id, :NEW.dat_dolaska, :NEW.dat_odlaska); -- IRN 3678
  pra_t_gosti.provjeri_broj_restorana (:NEW.sj_id, :NEW.br_restorana);
  pra_t_gosti.provjeri_valjanost_rezervacije (NULL, :NEW.rezvsj_id);

  -- IRN 3387
  IF :NEW.recagost_id IS NOT NULL
    AND (NVL (:NEW.ozn_brisano, 0) = -1 OR :NEW.ozn_fiktivni = -1)
  THEN
    :NEW.recagost_id := NULL;
  END IF;

  pra_rec3.provjeri_recagost_oznaka (:NEW.recagost_id);

  pra_rec.izracunaj_redni_broj (
    'T_GOSTI',
    :NEW.god_poslovna,
     NULL,
     NULL,
     6,
    :NEW.rbr);

  -- upis datuma odjave ako se upie odjavljeni gost to ne bi trebalo ali nije zabranjeno
  IF :NEW.ozn_prisutnosti = 'O' THEN
    :NEW.sat_odjave := SYSDATE;
    :NEW.korisnik_odjave := zmp_zaj.korisnik (-1); -- IRN 3456
  END IF;

  /*
  Zahtjevi prema vanjskim sustavima (TCO, PTV, KC, IP) i Boravci.
  AIS puni Pay-TV i Key Card zahtjeve bez provjere old vrijednosti,
  pa ne treba puniti sva polja zapis_l.
  */
  zapis_l.gost_id := :NEW.id;
  zapis_l.sj_id_new := :NEW.sj_id;
  zapis_l.sj_id_old := NULL;
  zapis_l.ozn_prisutnosti_new := :NEW.ozn_prisutnosti;
  zapis_l.ozn_prisutnosti_old := NULL;
  -- 18.03.2004. G.J.
  zapis_l.dat_dolaska_new := :NEW.dat_dolaska;
  zapis_l.dat_odlaska_new := :NEW.dat_odlaska;
  zapis_l.sat_odlaska_new := :NEW.sat_odlaska; -- IRN 1700
  zapis_l.ime_new := :NEW.ime;
  zapis_l.prezime_new := :NEW.prezime;
  -- 07.02.2007. G.J.
  zapis_l.recagost_id_new := :NEW.recagost_id;
  -- 25.04.2007. D.B.
  zapis_l.br_kartice := :NEW.br_kartice;
  zapis_l.ozn_fiktivni := NVL (:NEW.ozn_fiktivni, 0);
  -- IRN 2847
  zapis_l.zem_id_new := :NEW.zem_id;
  zapis_l.god_poslovna := :NEW.god_poslovna;
  zapis_l.rbr := :NEW.rbr;
  zapis_l.unos_dat := NVL (:NEW.unos_dat, SYSDATE);
  zapis_l.sat_odjave := :NEW.sat_odjave;
  zapis_l.ozn_vip_new := :NEW.ozn_vip;
  zapis_l.rezgost_id := :NEW.rezgost_id; -- IRN 2931
  zapis_l.zakkor_id := :NEW.zakkor_id; -- IRN 3275
  zapis_l.rezvsj_id := :NEW.rezvsj_id; -- IRN 3941
  tab_t_gosti.puni_tablicu (zapis_l);

  /*
  - priprema za auriranje bookinga F i rezvsj.kol_sjZ u AIS
  - priprema za auriranje bookinga O i statusa SJ u AIS
  (AIS uvijek poziva dodaj_booking_stsj, pa ne treba puniti old_vrijednosti)
  */
  zapis_stsj_l.gost_id := :NEW.id;
  zapis_stsj_l.rezvsj_id := :NEW.rezvsj_id;
  zapis_stsj_l.new_sj_id := :NEW.sj_id;
  zapis_stsj_l.new_dat_dolaska_u_sj := :NEW.dat_dolaska_u_sj;
  zapis_stsj_l.new_dat_odlaska := :NEW.dat_odlaska;
  zapis_stsj_l.new_ms_id := :NEW.ms_id;
  zapis_stsj_l.new_age_id := :NEW.age_id;
  zapis_stsj_l.new_ponso_id := :NEW.ponso_id;
  zapis_stsj_l.new_recvpro_id := :NEW.recvpro_id;
  zapis_stsj_l.recrezsj_id := :NEW.recrezsj_id; -- 10.05.2007. G.J.
  tab_t_gosti_stsj.puni_tablicu (zapis_stsj_l);

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIS_T_GOSTI'
CREATE OR REPLACE TRIGGER BIS_T_GOSTI
 BEFORE INSERT
 ON T_GOSTI
BEGIN
  tab_t_gosti.brisi_tablicu;
  tab_t_gosti_stsj.brisi_tablicu;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUR_T_GOSTI'
CREATE OR REPLACE TRIGGER BUR_T_GOSTI
 BEFORE UPDATE
 ON T_GOSTI
 FOR EACH ROW
DECLARE

  zapis_l        tab_t_gosti.gost_rec_type;
  zapis_stsj_l   tab_t_gosti_stsj.gost_stsj_rec_type;
  gost_row_old_l t_gosti%ROWTYPE;
  gost_row_new_l t_gosti%ROWTYPE;
BEGIN
  -- IRN 2906
  IF pra_pka_anonim.anonim_u_tijeku ('T_GOSTI', :OLD.id) = -1 THEN
    pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
    RETURN; -- izlaz iz trigera
  END IF;

  :NEW.dat_dolaska := TRUNC (:NEW.dat_dolaska);
  :NEW.dat_odlaska := TRUNC (:NEW.dat_odlaska);
  :NEW.ozn_valjanosti := UPPER (:NEW.ozn_valjanosti);
  :NEW.ozn_prisutnosti := UPPER (:NEW.ozn_prisutnosti);
  pra_zmp_zaj.oblikuj_slovo_upp_broj_all (:NEW.ozn_vip, 1);
  IF :OLD.sj_id = :NEW.sj_id
    AND :OLD.dat_dolaska = :OLD.dat_dolaska_u_sj
  THEN
    :NEW.dat_dolaska_u_sj := TRUNC (:NEW.dat_dolaska);
  ELSIF :NEW.dat_dolaska_u_sj < :NEW.dat_dolaska THEN
    :NEW.dat_dolaska_u_sj := TRUNC (:NEW.dat_dolaska);
  ELSE
    :NEW.dat_dolaska_u_sj := TRUNC (:NEW.dat_dolaska_u_sj);
  END IF;

  -- upis datuma odjave, oznaka se moe promijeniti samo iz P u O, nakon O vie nema izmjene
  IF :OLD.ozn_prisutnosti <> :NEW.ozn_prisutnosti THEN
    :NEW.sat_odjave := SYSDATE;
    :NEW.korisnik_odjave := zmp_zaj.korisnik (-1);
  END IF;

  -- Zabrani izmjenu UK
  IF :NEW.god_poslovna <> :OLD.god_poslovna
    OR :NEW.rbr <> :OLD.rbr
  THEN
    pra_rec_zaj.vrati_poruku (-20100);
  END IF;

  pra_t_gosti.provjeri_rezgost_rezvsj (:NEW.rezgost_id, :NEW.rezvsj_id);
  pra_t_gosti.provjeri_recrezsj_rezvsj (:NEW.recrezsj_id, :NEW.rezvsj_id);

  -- IRN 3678
  IF :NEW.sj_id <> :OLD.sj_id
    OR NVL (:NEW.rezvsj_id, 0) <> NVL (:OLD.rezvsj_id, 0)
    OR :NEW.dat_odlaska > :OLD.dat_odlaska -- IRN 3713
  THEN
    pra_t_gosti.provjeri_zasticenu_sj (:NEW.sj_id, :NEW.rezvsj_id, :NEW.dat_dolaska, :NEW.dat_odlaska);
  END IF;

  pra_t_gosti.provjeri_datum_dolaska (:NEW.id, :NEW.dat_dolaska, :OLD.dat_dolaska); -- IRN 2486
  pra_t_gosti.provjeri_datum_odlaska (:NEW.id, :NEW.dat_odlaska);
  pra_t_gosti.provjeri_vknjiga_zem_gost (:NEW.id, :NEW.zem_id);

  pra_t_gosti.provjeri_broj_restorana (:NEW.sj_id, :NEW.br_restorana);
  pra_t_gosti.provjeri_valjanost_rezervacije (:OLD.rezvsj_id, :NEW.rezvsj_id);

  -- IRN 3387
  IF :NEW.recagost_id IS NOT NULL
    AND (NVL (:NEW.ozn_brisano, 0) = -1 OR :NEW.ozn_fiktivni = -1)
  THEN
    :NEW.recagost_id := NULL;
  END IF;

  IF NVL (:OLD.recagost_id, 0) <> NVL (:NEW.recagost_id, 0) THEN
    pra_rec3.provjeri_recagost_oznaka (:NEW.recagost_id);
  END IF;

  -- Priprema za izradu TCO, Pay-TV, Key Card, PayCard i IP zahtjeva
  zapis_l.gost_id := :NEW.id;
  zapis_l.recagost_id_new := :NEW.recagost_id;
  zapis_l.recagost_id_old := :OLD.recagost_id;
  zapis_l.sj_id_new := :NEW.sj_id;
  zapis_l.sj_id_old := :OLD.sj_id;
  zapis_l.ozn_prisutnosti_new := :NEW.ozn_prisutnosti;
  zapis_l.ozn_prisutnosti_old := :OLD.ozn_prisutnosti;
  zapis_l.jez_id_new := :NEW.jez_id;
  zapis_l.jez_id_old := :OLD.jez_id;
  zapis_l.ptvvprog_id_new := :NEW.ptvvprog_id;
  zapis_l.ptvvprog_id_old := :OLD.ptvvprog_id;
  zapis_l.ime_new := :NEW.ime;
  zapis_l.ime_old := :OLD.ime;
  zapis_l.prezime_new := :NEW.prezime;
  zapis_l.prezime_old := :OLD.prezime;
  zapis_l.ozn_ptv1_new := :NEW.ozn_ptv1;
  zapis_l.ozn_ptv1_old := :OLD.ozn_ptv1;
  zapis_l.ozn_ptv2_new := :NEW.ozn_ptv2;
  zapis_l.ozn_ptv2_old := :OLD.ozn_ptv2;
  zapis_l.dat_dolaska_new := :NEW.dat_dolaska;
  zapis_l.dat_dolaska_old := :OLD.dat_dolaska;
  zapis_l.dat_odlaska_new := :NEW.dat_odlaska;
  zapis_l.dat_odlaska_old := :OLD.dat_odlaska;
  zapis_l.sat_odlaska_new := :NEW.sat_odlaska; -- IRN 1700
  zapis_l.sat_odlaska_old := :OLD.sat_odlaska; -- IRN 1700
  zapis_l.dat_dolaska_u_sj_new := :NEW.dat_dolaska_u_sj;
  zapis_l.zem_id_new := :NEW.zem_id;
  zapis_l.zem_id_old := :OLD.zem_id;
  zapis_l.age_id_new := :NEW.age_id;
  zapis_l.age_id_old := :OLD.age_id;
  zapis_l.ozn_brisano_new := :NEW.ozn_brisano;
  zapis_l.ozn_brisano_old := :OLD.ozn_brisano;
  zapis_l.ozn_fiktivni := :NEW.ozn_fiktivni;
  -- IRN 2847
  zapis_l.god_poslovna := :NEW.god_poslovna;
  zapis_l.rbr := :NEW.rbr;
  zapis_l.unos_dat := :NEW.unos_dat;
  zapis_l.sat_odjave := :NEW.sat_odjave;
  zapis_l.ozn_vip_new := :NEW.ozn_vip;
  zapis_l.ozn_vip_old := :OLD.ozn_vip;
  zapis_l.ponso_id_new := :NEW.ponso_id; -- IRN 2997
  zapis_l.ponso_id_old := :OLD.ponso_id; -- IRN 2997
  zapis_l.ms_id_new := :NEW.ms_id; -- IRN 3105
  zapis_l.ms_id_old := :OLD.ms_id; -- IRN 3105
  zapis_l.zakkor_id := :NEW.zakkor_id; -- IRN 3275
  -- IRN  3941
  zapis_l.rezvsj_id := :NEW.rezvsj_id;
  tab_t_gosti.puni_tablicu (zapis_l);

  -- priprema za provjeru izmjene odjavljenog gosta
  gost_row_old_l.id := :OLD.id;
  gost_row_old_l.sj_id := :OLD.sj_id;
  gost_row_old_l.zem_id := :OLD.zem_id;
  gost_row_old_l.ms_id := :OLD.ms_id;
  gost_row_old_l.age_id := :OLD.age_id;
  gost_row_old_l.rezvsj_id := :OLD.rezvsj_id;
  gost_row_old_l.rezgost_id := :OLD.rezgost_id;
  gost_row_old_l.recagost_id := :OLD.recagost_id;
  gost_row_old_l.cje_id := :OLD.cje_id;
  gost_row_old_l.vsj_id := :OLD.vsj_id;
  gost_row_old_l.jez_id := :OLD.jez_id;
  gost_row_old_l.ptvvprog_id := :OLD.ptvvprog_id;
  gost_row_old_l.recvpro_id := :OLD.recvpro_id;
  -- god_poslovna
  -- rbr
  gost_row_old_l.ozn_valjanosti := :OLD.ozn_valjanosti;
  gost_row_old_l.ozn_prisutnosti := :OLD.ozn_prisutnosti;
  gost_row_old_l.titula := :OLD.titula;
  gost_row_old_l.ime := :OLD.ime;
  gost_row_old_l.prezime := :OLD.prezime;
  gost_row_old_l.dat_dolaska := :OLD.dat_dolaska;
  gost_row_old_l.dat_odlaska := :OLD.dat_odlaska;
  gost_row_old_l.dat_dolaska_u_sj := :OLD.dat_dolaska_u_sj;
  -- br_uputnice
  gost_row_old_l.ozn_platitelj := :OLD.ozn_platitelj;
  gost_row_old_l.ozn_gratis := :OLD.ozn_gratis;
  gost_row_old_l.br_restorana := :OLD.br_restorana;
  gost_row_old_l.ozn_dprivole := :OLD.ozn_dprivole; -- IRN 3275
  gost_row_old_l.zakkor_id  := :OLD.zakkor_id;      -- IRN 3275
  gost_row_old_l.ozn_rnk := :OLD.ozn_rnk;
  gost_row_old_l.br_kartice := :OLD.br_kartice;
  gost_row_old_l.ozn_ptv1 := :OLD.ozn_ptv1;
  gost_row_old_l.ozn_ptv2 := :OLD.ozn_ptv2;
  gost_row_old_l.ozn_ptv3 := :OLD.ozn_ptv3;
  gost_row_old_l.napomena := :OLD.napomena;
  gost_row_old_l.recrezsj_id := :OLD.recrezsj_id;
  gost_row_old_l.ozn_vip := :OLD.ozn_vip;
  gost_row_old_l.izn_kreditnog_limita := :OLD.izn_kreditnog_limita;
  gost_row_old_l.ponso_id := :OLD.ponso_id;
  gost_row_old_l.sat_odjave := :OLD.sat_odjave;
  gost_row_old_l.korisnik_odjave := :OLD.korisnik_odjave;
  -- IRN 3928
  gost_row_old_l.sat_odlaska := :OLD.sat_odlaska;
  gost_row_old_l.barcode := :OLD.barcode;
  gost_row_old_l.ozn_brisano := :OLD.ozn_brisano;
  gost_row_old_l.ozn_fiktivni := :OLD.ozn_fiktivni;
  gost_row_old_l.napomena2 := :OLD.napomena2;

  gost_row_new_l.id := :NEW.id;
  gost_row_new_l.sj_id := :NEW.sj_id;
  gost_row_new_l.zem_id := :NEW.zem_id;
  gost_row_new_l.ms_id := :NEW.ms_id;
  gost_row_new_l.age_id := :NEW.age_id;
  gost_row_new_l.rezvsj_id := :NEW.rezvsj_id;
  gost_row_new_l.rezgost_id := :NEW.rezgost_id;
  gost_row_new_l.recagost_id := :NEW.recagost_id;
  gost_row_new_l.cje_id := :NEW.cje_id;
  gost_row_new_l.vsj_id := :NEW.vsj_id;
  gost_row_new_l.jez_id := :NEW.jez_id;
  gost_row_new_l.ptvvprog_id := :NEW.ptvvprog_id;
  gost_row_new_l.recvpro_id := :NEW.recvpro_id;
  -- god_poslovna
  -- rbr
  gost_row_new_l.ozn_valjanosti := :NEW.ozn_valjanosti;
  gost_row_new_l.ozn_prisutnosti := :NEW.ozn_prisutnosti;
  gost_row_new_l.titula := :NEW.titula;
  gost_row_new_l.ime := :NEW.ime;
  gost_row_new_l.prezime := :NEW.prezime;
  gost_row_new_l.dat_dolaska := :NEW.dat_dolaska;
  gost_row_new_l.dat_odlaska := :NEW.dat_odlaska;
  gost_row_new_l.dat_dolaska_u_sj := :NEW.dat_dolaska_u_sj;
  -- br_uputnice
  gost_row_new_l.ozn_platitelj := :NEW.ozn_platitelj;
  gost_row_new_l.ozn_gratis := :NEW.ozn_gratis;
  gost_row_new_l.br_restorana := :NEW.br_restorana;
  gost_row_new_l.ozn_dprivole := :NEW.ozn_dprivole; -- IRN 3275
  gost_row_new_l.zakkor_id  := :NEW.zakkor_id;      -- IRN 3275
  gost_row_new_l.ozn_rnk := :NEW.ozn_rnk;
  gost_row_new_l.br_kartice := :NEW.br_kartice;
  gost_row_new_l.ozn_ptv1 := :NEW.ozn_ptv1;
  gost_row_new_l.ozn_ptv2 := :NEW.ozn_ptv2;
  gost_row_new_l.ozn_ptv3 := :NEW.ozn_ptv3;
  gost_row_new_l.napomena := :NEW.napomena;
  gost_row_new_l.recrezsj_id := :NEW.recrezsj_id;
  gost_row_new_l.ozn_vip := :NEW.ozn_vip;
  gost_row_new_l.izn_kreditnog_limita := :NEW.izn_kreditnog_limita;
  gost_row_new_l.ponso_id := :NEW.ponso_id;
  gost_row_new_l.sat_odjave := :NEW.sat_odjave;
  gost_row_new_l.korisnik_odjave := :NEW.korisnik_odjave;
  -- IRN 3928
  gost_row_new_l.sat_odlaska := :NEW.sat_odlaska;
  gost_row_new_l.barcode := :NEW.barcode;
  gost_row_new_l.ozn_brisano := :NEW.ozn_brisano;
  gost_row_new_l.ozn_fiktivni := :NEW.ozn_fiktivni;
  gost_row_new_l.napomena2 := :NEW.napomena2;
  -- zabrani izmjenu odjavljenog gosta
  pra_t_gosti.zabrani_izmjenu_gosta (gost_row_old_l, gost_row_new_l);

  -- Upii eventualnu selidbu u promjene
  pra_t_gosti.upisi_selidbu (
    :NEW.god_poslovna, :NEW.rbr,
    :NEW.prezime, :NEW.ime,
    :OLD.sj_id, :NEW.sj_id);

  -- Upii eventualnu promjenu datuma dolaska u promjene
  pra_t_gosti.upisi_promjenu_dat_dolaska (
    :NEW.god_poslovna, :NEW.rbr,
    :NEW.prezime, :NEW.ime,
    :OLD.dat_dolaska, :NEW.dat_dolaska);

  -- Upii eventualnu promjenu datuma odlaska u promjene
  pra_t_gosti.upisi_promjenu_dat_odlaska (
    :NEW.god_poslovna, :NEW.rbr,
    :NEW.prezime, :NEW.ime,
    :OLD.dat_odlaska, :NEW.dat_odlaska);

  -- Upii eventualnu promjenu drzavljanstva u promjene
  pra_t_gosti.upisi_promjenu_drzavljanstva (:NEW.god_poslovna, :NEW.rbr, :OLD.zem_id, :NEW.zem_id);

  -- IRN 2997; Upii eventualnu promjenu recagost_id u promjene
  pra_t_gosti.upisi_promjenu_recagost_id (
    :NEW.god_poslovna, :NEW.rbr, :NEW.ime, :NEW.prezime, :OLD.recagost_id, :NEW.recagost_id);

  /*
  Puni PL/SQL tablicu za auriranje bookinga O i statusa SJ.
  Stupac rezvsj_id se ne puni jer se kod izmjene gosta T_REZ_VSJ ne aurira.
  Stupac recrezsj_id se ne puni jer se kod izmjene gosta TREC_REZ_SJ ne aurira.
  */
  zapis_stsj_l.gost_id := :OLD.id;
  zapis_stsj_l.rezvsj_id := :OLD.rezvsj_id;
  zapis_stsj_l.old_sj_id := :OLD.sj_id;
  zapis_stsj_l.old_dat_dolaska_u_sj := :OLD.dat_dolaska_u_sj;
  zapis_stsj_l.old_dat_odlaska := :OLD.dat_odlaska;
  zapis_stsj_l.old_ms_id := :OLD.ms_id;
  zapis_stsj_l.old_age_id := :OLD.age_id;
  zapis_stsj_l.old_ponso_id := :OLD.ponso_id;
  zapis_stsj_l.old_recvpro_id := :OLD.recvpro_id;
  zapis_stsj_l.new_sj_id := :NEW.sj_id;
  zapis_stsj_l.new_dat_dolaska_u_sj := :NEW.dat_dolaska_u_sj;
  zapis_stsj_l.new_dat_odlaska := :NEW.dat_odlaska;
  zapis_stsj_l.new_ms_id := :NEW.ms_id;
  zapis_stsj_l.new_age_id := :NEW.age_id;
  zapis_stsj_l.new_ponso_id := :NEW.ponso_id;
  zapis_stsj_l.new_recvpro_id := :NEW.recvpro_id;
  tab_t_gosti_stsj.puni_tablicu (zapis_stsj_l);

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUS_T_GOSTI'
CREATE OR REPLACE TRIGGER BUS_T_GOSTI
 BEFORE UPDATE
 ON T_GOSTI
BEGIN
  tab_t_gosti.brisi_tablicu;
  tab_t_gosti_stsj.brisi_tablicu;
END;
/
SHOW ERROR
