PROMPT Creating Trigger 'AR_S_USLUGE'
CREATE OR REPLACE TRIGGER AR_S_USLUGE
 AFTER DELETE OR INSERT OR UPDATE
 ON S_USLUGE
 FOR EACH ROW
BEGIN
  replikacija.napuni_tab (:OLD.id, :NEW.id);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUR_S_USLUGE'
CREATE OR REPLACE TRIGGER BUR_S_USLUGE
 BEFORE UPDATE
 ON S_USLUGE
 FOR EACH ROW
BEGIN
  pra_zmp_zaj.oblikuj_podatak ('SIFRA', 'S_USLUGE', :NEW.sifra);
  :NEW.dat_valjan := TRUNC (:NEW.dat_valjan);
  :NEW.dat_ponisten := TRUNC (:NEW.dat_ponisten);

  pra_zmp.provjeri_szurnala (:NEW.szur_id, :OLD.szur_id, 'U');
  pra_zmp_s2.provjeri_kpd (:NEW.kpd_id); -- IRN 4081

  pra_zmp_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIR_S_USLUGE'
CREATE OR REPLACE TRIGGER BIR_S_USLUGE
 BEFORE INSERT
 ON S_USLUGE
 FOR EACH ROW
BEGIN
  -- IRN 2888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN;  -- izlaz iz trigera
  END IF;

  :NEW.id := pra_zmp_zaj.sekvenca (:NEW.id);
  pra_zmp_zaj.oblikuj_podatak ('SIFRA', 'S_USLUGE', :NEW.sifra);
  :NEW.dat_valjan := TRUNC (:NEW.dat_valjan);
  :NEW.dat_ponisten := TRUNC (:NEW.dat_ponisten);

  pra_zmp.provjeri_szurnala (:NEW.szur_id, NULL, 'U');
  pra_zmp_s2.provjeri_kpd (:NEW.kpd_id); -- IRN 4081

  pra_zmp_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'AS_S_USLUGE'
CREATE OR REPLACE TRIGGER AS_S_USLUGE
 AFTER DELETE OR INSERT OR UPDATE
 ON S_USLUGE
BEGIN
  replikacija.azuriraj_retke (
    aplikacija_p => 'ZMP',
    tablica_p    => 'S_USLUGE');
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BS_S_USLUGE'
CREATE OR REPLACE TRIGGER BS_S_USLUGE
 BEFORE DELETE OR INSERT OR UPDATE
 ON S_USLUGE
BEGIN
  replikacija.brisi_tab;
END;
/
SHOW ERROR
