PROMPT Creating Package Body 'PRA_ZMP_S2'
CREATE OR REPLACE PACKAGE BODY PRA_ZMP_S2 IS

FUNCTION PROVJERI_KOROJ
 (KORISNIK_P IN VARCHAR2
 )
 RETURN NUMBER
 IS
/*
Korisnik nema(0)/ima(-1) zapis(ogranicenja) za OJ
*/

  CURSOR koroj_c IS
    SELECT 1 FROM m_kor_oj WHERE UPPER (kor_naziv) = UPPER (korisnik_p);

  br_redaka_l NUMBER(1);
BEGIN
  OPEN koroj_c;
  FETCH koroj_c INTO br_redaka_l;
  CLOSE koroj_c;

  IF br_redaka_l = 1 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;
END;
PROCEDURE PROVJERI_OJ
 (KORISNIK_P IN VARCHAR2
 ,OJ_ID_P IN m_oj.id%TYPE
 )
 IS
/*
Provjerava da li korisnik ima ovlasti za traenu OJ
*/

  br_redaka_l NUMBER;
BEGIN
  IF oj_id_p IS NULL
  THEN
    RETURN;
  END IF;
  SELECT COUNT (*)
    INTO br_redaka_l
    FROM m_oj oj
   WHERE oj.id = oj_id_p
     AND (EXISTS (SELECT NULL
                    FROM m_kor_oj koroj
                   WHERE UPPER (koroj.kor_naziv) = UPPER (korisnik_p)
                     AND (oj.id = koroj.oj_id OR
                          pra_zmp.oj_pripada_oj (oj.id, koroj.oj_id) = -1))
                      OR provjeri_koroj (korisnik_p) = 0);

  IF br_redaka_l = 0
  THEN
    -- Nemate doputenje za rad s odabranom OJ.
    pra_zmp_zaj.vrati_poruku (-20140);
  END IF;
END;
FUNCTION DOPUSTENA_OJ
 (KORISNIK_P IN VARCHAR2
 ,OJ_ID_P IN m_oj.id%TYPE
 )
 RETURN NUMBER
 IS
--
  br_redaka_l NUMBER(1);
BEGIN
  IF oj_id_p IS NULL
  THEN
    RETURN (0);
  END IF;
  /*
  Korisnik nema(0)/ima(-1) zapis(ogranicenja) za OJ
  */
  IF provjeri_koroj (korisnik_p) = 0 THEN
    RETURN (-1);
  END IF;
  /*
  Provjerava da li korisnik ima ovlasti za traenu OJ
  */
  SELECT COUNT(*)
    INTO br_redaka_l
    FROM m_oj oj
   WHERE oj.id = oj_id_p
     AND EXISTS (SELECT NULL
                   FROM m_kor_oj koroj
                  WHERE UPPER (koroj.kor_naziv) = UPPER (korisnik_p)
                    AND (oj.id = koroj.oj_id OR
                          pra_zmp.oj_pripada_oj (oj.id, koroj.oj_id) = -1));
  IF br_redaka_l = 0
  THEN
    RETURN (0);
  ELSE
    RETURN (-1);
  END IF;
END;
FUNCTION DOMVAL_ID
 (DATUM_P IN s_vlasnik.dat_primjene_domval%TYPE := NULL
 )
 RETURN NUMBER
 IS
-- id domae valute iz vlasnika ovisno o poslanom datumu. Ako datum nije poslan za SYSDATE.
  domval_id_l s_vlasnik.domval_id%TYPE;
BEGIN
  SELECT (CASE WHEN NVL (datum_p, TRUNC (SYSDATE)) >= dat_primjene_domval THEN  domval_id ELSE domval0_id END)
    INTO domval_id_l
    FROM s_vlasnik;
  RETURN domval_id_l;
END;
PROCEDURE PROVJERI_DOMVAL
 (VAL_ID_P IN s_valute.id%TYPE
 ,DATUM_P IN s_vlasnik.dat_primjene_domval%TYPE := NULL
 )
 IS
-- Provjerava je li poslana valuta na poslani datum domaa
  domval_id_l s_vlasnik.domval_id%TYPE;
BEGIN
  IF val_id_p IS NULL THEN
    RETURN;
  END IF;

  SELECT (CASE WHEN NVL (datum_p, TRUNC (SYSDATE)) >= dat_primjene_domval THEN  domval_id ELSE domval0_id END)
    INTO domval_id_l
    FROM s_vlasnik;
  IF val_id_p <>  NVL (domval_id_l, 0) THEN
    -- Neodgovarajua domaa valuta.
    pra_zmp_zaj.vrati_poruku (-20141);
  END IF;

END;
PROCEDURE PROVJERI_DOMVAL_VAL
 (DOMVAL_ID_P IN OUT s_valute.id%TYPE
 ,VAL_ID_P IN s_valute.id%TYPE
 ,DATUM_P IN s_vlasnik.dat_primjene_domval%TYPE := NULL
 )
 IS
-- puni/provjeri domval i provjeri da val nije prethodna domaa:
-- ako je NVL (datum, sysdate) >= dat_primjene_domval a val = prethodna javi greku
-- ako domval nije null i nije na poslani datum domaa, javi greku
-- ako je domval = null puni se sa domval na poslani datum odnosno sysdate
-- takoer javi greku ako domval nije jednaka ZMP param 0001
--    (time se sprijei naknadni unos na prethodnoj shemi, unos prije prelaska na novoj shemi)

  vla_row_l s_vlasnik%ROWTYPE;
  param_domval_id_l szmp_parametri.vrijednost%TYPE;
  domval_id_l s_vlasnik.domval_id%TYPE;
BEGIN

  SELECT * INTO vla_row_l FROM s_vlasnik;
  SELECT MIN (id) INTO param_domval_id_l FROM s_valute
   WHERE sifra_3a = pra_zmp_zaj.vrijednost_parametra ('0001');

  IF NVL (datum_p, TRUNC (SYSDATE)) >= vla_row_l.dat_primjene_domval THEN
    IF val_id_p IS NOT NULL AND val_id_p = NVL (vla_row_l.domval0_id, 0) THEN
      -- Neodgovarajua (domaa) valuta.
      pra_zmp_zaj.vrati_poruku (-20141);
    END IF;
    domval_id_l := NVL (domval_id_p, vla_row_l.domval_id);
  ELSE
    domval_id_l := NVL (domval_id_p, vla_row_l.domval0_id);
  END IF;

  IF domval_id_l <> param_domval_id_l THEN
    -- Neodgovarajua (domaa) valuta.
    pra_zmp_zaj.vrati_poruku (-20141);
  END IF;

  IF domval_id_p IS NULL THEN
    domval_id_p := domval_id_l;
  END IF;

END;
FUNCTION CIKLUS_KPD
 (ID_P IN s_kpd.id%TYPE
 ,KPD_ID_P IN s_kpd.kpd_id%TYPE
 )
 RETURN NUMBER
 IS
-- IRN 4081
  nasao_l NUMBER := 0;
  kpd_id_l s_kpd.id%TYPE;
BEGIN
  IF (id_p = kpd_id_p) THEN
    nasao_l := -1;
  ELSE
    kpd_id_l := kpd_id_p;
    WHILE nasao_l = 0 AND kpd_id_l IS NOT NULL
    LOOP
      SELECT kpd_id INTO kpd_id_l
        FROM s_kpd
       WHERE id = kpd_id_l;
      IF kpd_id_l = id_p THEN
        nasao_l := -1;
      END IF;
    END LOOP;
  END IF;
  RETURN nasao_l;
END;
PROCEDURE PROVJERI_CIKLUS_KPD
 (ID_P IN s_kpd.id%TYPE
 ,KPD_ID_P IN s_kpd.kpd_id%TYPE
 )
 IS
-- IRN 4081; zabrani ciklus u hijerahiji
  kpd_id_l s_kpd.id%TYPE;
BEGIN
  IF id_p IS NULL OR kpd_id_p IS NULL THEN
    RETURN;
  END IF;
  IF (id_p = kpd_id_p) THEN
    -- ifra nadreenog zapisa treba biti razliita od ifre podreenog zapisa.
    pra_zmp_zaj.vrati_poruku (-20148);
  ELSE
    kpd_id_l := kpd_id_p;
    WHILE kpd_id_l IS NOT NULL
    LOOP
      SELECT kpd_id INTO kpd_id_l
        FROM s_kpd
       WHERE id = kpd_id_l;
      IF kpd_id_l = id_p THEN
        -- Postoji ciklus u hijerarhiji.
        pra_zmp_zaj.vrati_poruku (-20149);
      END IF;
    END LOOP;
  END IF;
END;
PROCEDURE PROVJERI_KPD
 (KPD_ID_P IN s_kpd.id%TYPE
 )
 IS
-- IRN 4081
  br_redaka_l NUMBER;
BEGIN
  IF kpd_id_p IS NULL THEN
    RETURN;
  END IF;

  SELECT COUNT (1) INTO br_redaka_l
    FROM s_kpd
   WHERE kpd_id = kpd_id_p;
  IF br_redaka_l > 0 THEN
    -- Odaberite najniu razinu KPD.
    pra_zmp_zaj.vrati_poruku (-20150);
  END IF;
END;

END PRA_ZMP_S2;
/
SHOW ERROR

