-- C:\Users\dgajic\Desktop\IRN 4106\des\pra_zmp_s\v4\pra_zmp_s.pkb
--
-- Generated for Oracle 10g on Wed Nov 12  18:47:49 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'PRA_ZMP_S'
CREATE OR REPLACE PACKAGE BODY PRA_ZMP_S IS

FUNCTION TCOKLA_PRIPADA_TCOVTC
 (TCOKLA_ID_P IN STCO_KLASE.ID%TYPE
 )
 RETURN NUMBER
 IS
/*
13.10.2003. G.J.
Klasa telefona pripada vrsti telefonskih centrala iz ZMP parametra 0007
*/
  br_redaka_l NUMBER;
BEGIN
  IF tcokla_id_p IS NULL THEN
    RETURN (-1);
  END IF;
  SELECT COUNT (tcovtckla.ROWID) INTO br_redaka_l
    FROM stco_vtc_kla tcovtckla,
         stco_vtc tcovtc
   WHERE tcovtckla.tcokla_id = tcokla_id_p
     AND tcovtckla.tcovtc_id = tcovtc.id
     AND tcovtc.sifra = pra_zmp_zaj.vrijednost_parametra ('0007');
  IF br_redaka_l = 1 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;
END;
FUNCTION TCOVPOR_PRIPADA_TCOVTC
 (TCOVPOR_ID_P IN STCO_VPORUKA.ID%TYPE
 )
 RETURN NUMBER
 IS
/*
13.10.2003. G.J.
Vrsta poruka pripada vrsti telefonskih centrala iz ZMP parametra 0007
*/
  br_redaka_l NUMBER;
BEGIN
  IF tcovpor_id_p IS NULL THEN
    RETURN (-1);
  END IF;
  SELECT COUNT (tcovtcvpor.ROWID) INTO br_redaka_l
    FROM stco_vtc_vpor tcovtcvpor,
         stco_vtc tcovtc
   WHERE tcovtcvpor.tcovpor_id = tcovpor_id_p
     AND tcovtcvpor.tcovtc_id = tcovtc.id
     AND tcovtc.sifra = pra_zmp_zaj.vrijednost_parametra ('0007');
  IF br_redaka_l = 1 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;
END;
FUNCTION HIJOJ_PRIPADA_VOJ
 (ZMPHIJOJ_ID_P IN MZMP_HIJ_OJ.ID%TYPE
 ,ZMPVOJ_ID_P IN MZMP_VOJ.ID%TYPE
 )
 RETURN NUMBER
 IS
-- Barem jedna od nadreenih hijoj za zadanu hijoj je vrste voj
  br_redaka_l NUMBER;
BEGIN
  SELECT COUNT (ROWID) INTO br_redaka_l
    FROM mzmp_hij_oj
   WHERE zmpvoj_id = zmpvoj_id_p
   START WITH id = zmphijoj_id_p
   CONNECT BY PRIOR zmphijoj_id = id;
  IF br_redaka_l >= 1 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;
END;
FUNCTION HIJOJ_PRIPADA_HIJOJ
 (ZMPHIJOJ_ID_P IN MZMP_HIJ_OJ.ID%TYPE
 ,ZMPHIJOJ1_ID_P IN MZMP_HIJ_OJ.ID%TYPE
 )
 RETURN NUMBER
 IS
-- Hijoj pripada hijoj1
  br_redaka_l NUMBER;
BEGIN
  IF zmphijoj_id_p = zmphijoj1_id_p THEN
    br_redaka_l := 1;
  ELSE
    /*
    -- varijanta 1. Nadreena hijoj za promatranu hijoj mora biti jedna od podreenih od hijoj1
    SELECT COUNT (ROWID) INTO br_redaka_l
      FROM mzmp_hij_oj
     WHERE mzmp_hij_oj.id = zmphijoj_id_p
       AND mzmp_hij_oj.zmphijoj_id IN (
           SELECT id
             FROM mzmp_hij_oj
            START WITH id = zmphijoj1_id_p
          CONNECT BY PRIOR id = zmphijoj_id);
    */
    -- varijanta 2. Hijoj1 mora biti jedna od nadreenih za hijoj
    SELECT COUNT (ROWID) INTO br_redaka_l
      FROM mzmp_hij_oj
     WHERE mzmp_hij_oj.id = zmphijoj_id_p
       AND zmphijoj1_id_p IN (
           SELECT id
             FROM mzmp_hij_oj
            START WITH id = zmphijoj_id_p
          CONNECT BY PRIOR zmphijoj_id = id);
  END IF;
  IF br_redaka_l = 1 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;
END;
FUNCTION HIJOJNAD_ROJ
 (ZMPHIJOJ_ID_P IN MZMP_HIJ_OJ.ID%TYPE
 ,ZMPROJ_ID_P IN MZMP_RAZINE_OJ.ID%TYPE
 )
 RETURN NUMBER
 IS
-- Funkcija vraa prvu nadreenu hijoj navedene razine ili NULL
  zmphijoj_id_l mzmp_hij_oj.id%TYPE;
  CURSOR hijoj_c IS
    SELECT id
      FROM mzmp_hij_oj
     WHERE zmproj_id = zmproj_id_p
     START WITH id = zmphijoj_id_p
     CONNECT BY PRIOR zmphijoj_id = id;
BEGIN
  IF zmphijoj_id_p IS NULL OR zmproj_id_p IS NULL THEN
    zmphijoj_id_l := NULL;
  ELSE
    OPEN hijoj_c;
    FETCH hijoj_c INTO zmphijoj_id_l;
    IF hijoj_c%NOTFOUND THEN
       zmphijoj_id_l := NULL;
    END IF;
    CLOSE hijoj_c;
  END IF;
  RETURN (zmphijoj_id_l);
END;
FUNCTION DAT_POCETNI_0036
 RETURN DATE
 IS
-- Poetni datum se ita iz ZMP parametra 0036 ili se uzima '01.01.1999'
  dat_pocetni_l DATE;
BEGIN
  dat_pocetni_l := TO_DATE (pra_zmp_zaj.vrijednost_parametra ('0036'), 'DD.MM.RRRR');
  RETURN (dat_pocetni_l);
EXCEPTION
  WHEN OTHERS THEN
    dat_pocetni_l := TO_DATE ('01.01.1999', 'DD.MM.RRRR');
    RETURN (dat_pocetni_l);
END;
PROCEDURE PROVJERI_DAT_POCETNI_0036
 (DATUM_P IN DATE
 )
 IS
BEGIN
  -- Datum izrauna ne moe biti manji od poetnog datuma rada sa aplikacijom (ZMP parametar 0036).
  IF datum_p < pra_zmp_s.dat_pocetni_0036 THEN
    pra_zmp_zaj.vrati_poruku (-20066, TO_CHAR (pra_zmp_s.dat_pocetni_0036, 'DD.MM.RRRR'));
  END IF;
END;
FUNCTION VMS_ID_MSVMS
 (MS_ID_P IN MZMP_MS_VMS.MS_ID%TYPE
 ,SSO_ID_P IN MZMP_MS_VMS.SSO_ID%TYPE
 )
 RETURN NUMBER
 IS
-- vms_id iz mzmp_ms_vms
  vms_id_l mzmp_ms_vms.vms_id%TYPE;
BEGIN
  SELECT vms_id INTO vms_id_l
    FROM mzmp_ms_vms
   WHERE ms_id = ms_id_p
     AND sso_id = sso_id_p;
  RETURN vms_id_l;
EXCEPTION
  WHEN NO_DATA_FOUND THEN
    RETURN NULL;
END;
FUNCTION VMS_MSVMS
 (MS_ID_P IN MZMP_MS_VMS.MS_ID%TYPE
 ,SSO_ID_P IN MZMP_MS_VMS.SSO_ID%TYPE
 ,SIFRA_P IN VARCHAR2
 ,NAZIV_P IN VARCHAR2
 )
 RETURN VARCHAR2
 IS
--
  vms_id_l mzmp_ms_vms.vms_id%TYPE;
  vms_sifra_l s_vmsegmenata.sifra%TYPE;
  vms_naziv_l s_vmsegmenata.naziv%TYPE;
  naziv_l VARCHAR2(45);
BEGIN
  -- sifra, naziv ili sifra i naziv vms iz mzmp_ms_vms
  BEGIN
    SELECT vms_id INTO vms_id_l
      FROM mzmp_ms_vms
     WHERE ms_id = ms_id_p AND sso_id = sso_id_p;
    SELECT sifra, naziv INTO vms_sifra_l, vms_naziv_l
      FROM s_vmsegmenata
     WHERE id = vms_id_l;
    IF sifra_p = 1 AND naziv_p = 1 THEN
      naziv_l := vms_sifra_l || ' ' || vms_naziv_l;
    ELSIF sifra_p = 1 AND naziv_p = 0 THEN
      naziv_l := vms_sifra_l;
    ELSIF sifra_p = 0 AND naziv_p = 1 THEN
      naziv_l := vms_naziv_l;
    END IF;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      naziv_l := '*';
  END;
  RETURN naziv_l;
END;
PROCEDURE PROVJERI_ZMPSPKNJ
 (ZMPSPISP_SIFRA_P IN SZMP_SPISPORUKA.SIFRA%TYPE
 ,ZMPSPKNJ_ID_P IN SZMP_SPKNJIGA.ID%TYPE
 )
 IS
/*
Provjeri vezu izmeu skupina poreznih isporuka i stupaca poreznih knjiga.
Npr. skupina 13 "osloboeno poreza - ostalo" mora pripadati stupcu 10 "ne podlijee oporezivanju".
*/
  br_redaka_l NUMBER;
BEGIN
  IF zmpspisp_sifra_p IS NULL
    OR zmpspknj_id_p IS NULL
  THEN
    RETURN;
  END IF;

  SELECT COUNT (ROWID) INTO br_redaka_l
    FROM szmp_spknjiga
   WHERE id = zmpspknj_id_p
     AND sifra = ROUND (TO_NUMBER (zmpspisp_sifra_p), -1);
  IF br_redaka_l = 0 THEN
    -- Skupina poreznih isporuka #0 mora pripadati stupcu poreznih knjiga #1.
    pra_zmp_zaj.vrati_poruku (-20079, zmpspisp_sifra_p, ROUND (TO_NUMBER (zmpspisp_sifra_p), -1));
  END IF;
END;
FUNCTION KONTO
 (VDOK_ID_P IN M_PKNJIZENJA.VDOK_ID%TYPE
 ,GKAGE_ID_P IN M_PKNJIZENJA.GKAGE_ID%TYPE
 ,GKAGEP_ID_P IN M_PKNJIZENJA.GKAGEP_ID%TYPE
 ,VPDOG_ID_P IN M_PKNJIZENJA.VPDOG_ID%TYPE
 ,VAL_ID_P IN S_VALUTE.ID%TYPE
 )
 RETURN mzmp_konta.sifra%TYPE
 IS
-- Konto je odreen preko pravila u m_pknjizenja
  konto_l mzmp_konta.sifra%TYPE;
  konto_devize_l mzmp_konta.sifra%TYPE;
  val_sifra_3a_l s_valute.sifra_3a%TYPE;
BEGIN
  IF vdok_id_p IS NULL
   -- OR gkage_id_p IS NULL
    OR val_id_p IS NULL
  THEN
    RETURN (NULL);
  END IF;

  IF gkagep_id_p IS NULL THEN
    -- posrednika nema
    SELECT zmpkon.sifra, zmpkond.sifra
      INTO konto_l, konto_devize_l
      FROM m_pknjizenja pknj, mzmp_konta zmpkon, mzmp_konta zmpkond
     WHERE pknj.vdok_id = vdok_id_p
       AND NVL (pknj.gkage_id,0) = NVL (gkage_id_p,0) 
       AND pknj.gkagep_id IS NULL
       AND NVL (pknj.vpdog_id, 0) = NVL (vpdog_id_p, 0)
       AND pknj.zmpkon_id = zmpkon.id
       AND pknj.zmpkond_id = zmpkond.id (+);
  ELSE
    -- posrednik postoji
    SELECT zmpkon.sifra, zmpkond.sifra
      INTO konto_l, konto_devize_l
      FROM m_pknjizenja pknj, mzmp_konta zmpkon, mzmp_konta zmpkond
     WHERE pknj.vdok_id = vdok_id_p
       AND NVL (pknj.gkage_id,0) = NVL (gkage_id_p,0)
       AND pknj.gkagep_id = gkagep_id_p
       AND NVL (pknj.vpdog_id, 0) = NVL (vpdog_id_p, 0)
       AND pknj.zmpkon_id = zmpkon.id
       AND pknj.zmpkond_id = zmpkond.id (+);
  END IF;
  SELECT sifra_3a
    INTO val_sifra_3a_l
    FROM s_valute
   WHERE id = val_id_p;
  IF val_sifra_3a_l = pra_rec_zaj.vrijednost_parametra ('0001') THEN
    RETURN (konto_l);
  ELSE
    RETURN (konto_devize_l);
  END IF;
EXCEPTION
  WHEN OTHERS THEN
    RETURN (NULL);
END;
FUNCTION KONTO_OB
 (GKAGE_ID_P IN M_PKNJIZENJA.GKAGE_ID%TYPE
 ,VAL_ID_P IN S_VALUTE.ID%TYPE
 )
 RETURN mzmp_konta.sifra%TYPE
 IS
-- Konto za obraune odreen je preko pravila u m_pknjizenja
  konto_l mzmp_konta.sifra%TYPE;
  konto_devize_l mzmp_konta.sifra%TYPE;
  val_sifra_3a_l s_valute.sifra_3a%TYPE;
BEGIN
  IF gkage_id_p IS NULL
    OR val_id_p IS NULL
  THEN
    RETURN (NULL);
  END IF;

  SELECT zmpkon.sifra, zmpkond.sifra
    INTO konto_l, konto_devize_l
    FROM m_pknjizenja pknj, mzmp_konta zmpkon, mzmp_konta zmpkond
   WHERE pknj.vdok_id = (SELECT vdok_id FROM s_vapldok WHERE metapl_sifra = 'PKA' AND oznaka = 'OB')
     AND pknj.gkage_id = gkage_id_p
     AND pknj.gkagep_id IS NULL
     AND pknj.vpdog_id IS NULL
     AND pknj.zmpkon_id = zmpkon.id
     AND pknj.zmpkond_id = zmpkond.id (+);

  SELECT sifra_3a
    INTO val_sifra_3a_l
    FROM s_valute
   WHERE id = val_id_p;
  IF val_sifra_3a_l = pra_rec_zaj.vrijednost_parametra ('0001') THEN
    RETURN (konto_l);
  ELSE
    RETURN (konto_devize_l);
  END IF;
EXCEPTION
  WHEN OTHERS THEN
    RETURN (NULL);
END;
PROCEDURE VRATI_VPISPZ
 (USL_ID_P IN s_usluge.id%TYPE
 ,DATUM_P IN DATE := TRUNC (SYSDATE)
 ,VPDOG_ID_P IN s_vpdogadjaja.id%TYPE
 ,VPISPZ_ID_P IN OUT s_vpisporukaz.id%TYPE
 ,STOPA_PDV_P IN OUT s_vpisporukaz.stopa%TYPE
 ,OBR_ZDANA_P IN OUT s_usluge.obr_zdana%TYPE
 )
 IS
/*
procedura vraa zavrnu poreznu isporuku (+ stopu i obr_zdana)
za promatranu uslugu i porezni dogaaj
*/
  CURSOR usl_c IS
    SELECT obr_zdana
      FROM s_usluge
     WHERE id = usl_id_p;
  obr_zdana_l s_usluge.obr_zdana%TYPE;

  vpispp_id_l s_vpisporukap.id%TYPE; -- IRN 2613

  CURSOR vpispdog_c (vpispp_id_k s_vpisp_dog.vpispp_id%TYPE) IS
    SELECT vpispz_id
      FROM s_vpisp_dog
     WHERE vpispp_id = vpispp_id_k
       AND vpdog_id = vpdog_id_p;

  CURSOR vpispp_c (vpispp_id_k s_vpisporukap.id%TYPE) IS
    SELECT vpispz_id
      FROM s_vpisporukap
     WHERE id = vpispp_id_k;
  vpispz_id_l s_vpisporukaz.id%TYPE;

  CURSOR vpispz_c (vpispz_id_k s_vpisporukaz.id%TYPE) IS
    SELECT stopa
      FROM s_vpisporukaz
     WHERE id = vpispz_id_k;
  stopa_pdv_l s_vpisporukaz.stopa%TYPE;
BEGIN
  IF usl_id_p IS NULL THEN
    RETURN;
  END IF;

  OPEN usl_c;
  FETCH usl_c INTO obr_zdana_l;
  CLOSE usl_c;

  vpispp_id_l := pra_szmp_usl_raz.vpispp_id (usl_id_p, datum_p); -- IRN 2613

  IF vpdog_id_p IS NOT NULL THEN
    OPEN vpispdog_c (vpispp_id_l);
    FETCH vpispdog_c INTO vpispz_id_l;
    CLOSE vpispdog_c;
  END IF;

  IF vpdog_id_p IS NULL OR vpispz_id_l IS NULL THEN
    OPEN vpispp_c (vpispp_id_l);
    FETCH vpispp_c INTO vpispz_id_l;
    CLOSE vpispp_c;
  END IF;

  OPEN vpispz_c (vpispz_id_l);
  FETCH vpispz_c INTO stopa_pdv_l;
  CLOSE vpispz_c;

  vpispz_id_p := vpispz_id_l;
  stopa_pdv_p := stopa_pdv_l;
  obr_zdana_p := obr_zdana_l;
END;
FUNCTION KASA_PRIPADA_ZMPOJR
 (GMPKAS_ID_P IN MGMP_KASE.ID%TYPE
 ,DAT_POC_P IN MZMP_OJR.DAT_VALJAN%TYPE
 ,DAT_ZAV_P IN MZMP_OJR.DAT_PONISTEN%TYPE
 )
 RETURN NUMBER
 IS
/*
Kasa pripada (valjanoj) ZMP OJR na tekuem voru
*/
  br_redaka_l NUMBER;
BEGIN
  IF gmpkas_id_p IS NULL THEN
    RETURN (-1);
  END IF;
  SELECT COUNT (ROWID) INTO br_redaka_l
    FROM mgmp_kase
   WHERE id = gmpkas_id_p
     AND zmpojr_id IN (
         SELECT id
           FROM mzmp_ojr zmpojr,
                s_vlasnik vla
          WHERE zmpojr.metcvor_sifra = vla.sifra_tekuceg_cvora
            AND zmpojr.dat_valjan <= NVL (dat_poc_p, TO_DATE ('31.12.9999', 'DD.MM.RRRR'))
            AND NVL (zmpojr.dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) > NVL (dat_zav_p, TO_DATE ('01.01.0001', 'DD.MM.RRRR'))
         );
  IF br_redaka_l = 1 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;
END;
FUNCTION OJ_PRIPADA_ZMPOJR
 (OJ_ID_P IN M_OJ.ID%TYPE
 ,DAT_POC_P IN MZMP_OJR.DAT_VALJAN%TYPE
 ,DAT_ZAV_P IN MZMP_OJR.DAT_PONISTEN%TYPE
 )
 RETURN NUMBER
 IS
-- barem jedna od OJR na tekuem voru je nadreena OJ
  br_redaka_l NUMBER;
BEGIN
  IF oj_id_p IS NULL THEN
    RETURN (-1);
  END IF;
  SELECT COUNT (ROWID) INTO br_redaka_l
    FROM m_oj
   WHERE m_oj.id IN 
         (
         SELECT id FROM mzmp_ojr zmpojr, s_vlasnik vla
          WHERE zmpojr.metcvor_sifra = vla.sifra_tekuceg_cvora
            AND zmpojr.dat_valjan <= NVL (dat_poc_p, TO_DATE ('31.12.9999', 'DD.MM.RRRR'))
            AND NVL (zmpojr.dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) >
                NVL (dat_zav_p, TO_DATE ('01.01.0001', 'DD.MM.RRRR'))
         )
   START WITH id = oj_id_p
  CONNECT BY PRIOR oj_id = id;
  IF br_redaka_l > 0 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;
END;
FUNCTION ZMPOJR_ID
 (DAT_POC_P IN MZMP_OJR.DAT_VALJAN%TYPE
 ,DAT_ZAV_P IN MZMP_OJR.DAT_PONISTEN%TYPE
 )
 RETURN mzmp_ojr.id%TYPE
 IS
-- Prva (valjana) OJR na tekuem voru poredano po ifri
  CURSOR zmpojr_c IS
    SELECT zmpojr.id
      FROM mzmp_ojr zmpojr,
           m_oj oj,
           s_vlasnik vla
     WHERE zmpojr.id = oj.id
       AND zmpojr.metcvor_sifra = vla.sifra_tekuceg_cvora
       AND zmpojr.dat_valjan <= NVL (dat_poc_p, TO_DATE ('31.12.9999', 'DD.MM.RRRR'))
       AND NVL (zmpojr.dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) >
           NVL (dat_zav_p, TO_DATE ('01.01.0001', 'DD.MM.RRRR'))
     ORDER BY oj.sifra;
  zmpojr_id_l mzmp_ojr.id%TYPE;
BEGIN
  OPEN zmpojr_c;
  FETCH zmpojr_c INTO zmpojr_id_l;
  CLOSE zmpojr_c;
  RETURN (zmpojr_id_l);
END;
FUNCTION METCVOR_SIFRA_OJR
 (ZMPOJR_ID_P IN MZMP_OJR.ID%TYPE
 )
 RETURN VARCHAR2
 IS
--
  CURSOR zmpojr IS (
    SELECT metcvor_sifra
      FROM mzmp_ojr
     WHERE id = zmpojr_id_p);

  metcvor_sifra_l mzmp_ojr.metcvor_sifra%TYPE;
BEGIN
  IF zmpojr_id_p IS NULL THEN
    RETURN metcvor_sifra_l;
  END IF;
   
  OPEN zmpojr;
  FETCH zmpojr INTO metcvor_sifra_l;
  CLOSE zmpojr;

  RETURN metcvor_sifra_l;
END;
FUNCTION GMPKAS_ZMPOJR_ID
 (GMPKAS_ID_P IN MGMP_KASE.ID%TYPE
 )
 RETURN mgmp_kase.zmpojr_id%TYPE
 IS
--
  CURSOR gmpkas_c IS
    SELECT zmpojr_id
      FROM mgmp_kase
     WHERE id = gmpkas_id_p;
  zmpojr_id_l mgmp_kase.zmpojr_id%TYPE;
BEGIN
  OPEN gmpkas_c;
  FETCH gmpkas_c INTO zmpojr_id_l;
  CLOSE gmpkas_c;
  RETURN (zmpojr_id_l);
END;
PROCEDURE PROVJERI_POPUSTE
 (ZMPPOP1_ID_P IN NUMBER := NULL
 ,ZMPPOP2_ID_P IN NUMBER := NULL
 ,ZMPPOP3_ID_P IN NUMBER := NULL
 ,ZMPPOP4_ID_P IN NUMBER := NULL
 )
 IS
--
  CURSOR zmppoppop_c IS
    SELECT COUNT(1), (DECODE (zmppop1_id_p, NULL, 0, 1) + DECODE (zmppop2_id_p, NULL, 0, 1)
            +  DECODE (zmppop3_id_p, NULL, 0, 1) + DECODE (zmppop4_id_p, NULL, 0, 1))
      FROM mzmp_pop_pop
     WHERE (NVL (zmppop1_id_p, 0) = zmppop1_id AND 
            (zmppop2_id = zmppop2_id_p OR zmppop2_id = zmppop3_id_p OR zmppop2_id = zmppop4_id_p))
        OR (NVL (zmppop2_id_p, 0) = zmppop1_id AND
            (zmppop2_id = zmppop3_id_p OR zmppop2_id = zmppop4_id_p))
        OR (NVL (zmppop3_id_p, 0) = zmppop1_id AND
            (zmppop2_id = zmppop4_id_p));

  broj_kombinacija_l NUMBER;
  broj_potrebnih_kombinacija_l NUMBER;
BEGIN
  OPEN zmppoppop_c;
  FETCH zmppoppop_c INTO broj_kombinacija_l, broj_potrebnih_kombinacija_l;
  CLOSE zmppoppop_c;

  broj_potrebnih_kombinacija_l := broj_potrebnih_kombinacija_l * (broj_potrebnih_kombinacija_l - 1) / 2;
  -- Kombinacija popusta nije dozvoljena.
  IF broj_kombinacija_l <> broj_potrebnih_kombinacija_l THEN
    pra_zmp_zaj.vrati_poruku (-20083);
  END IF;
END;
FUNCTION ZMPOJR_TEKUCEG_CVORA
 (ZMPOJR_ID_P IN mzmp_ojr.id%TYPE
 )
 RETURN BOOLEAN
 IS
--
  br_redaka_l NUMBER;
BEGIN
  SELECT COUNT (zmpojr.id) INTO br_redaka_l
    FROM mzmp_ojr zmpojr, s_vlasnik vla
   WHERE zmpojr.id = zmpojr_id_p
     AND zmpojr.metcvor_sifra = vla.sifra_tekuceg_cvora;

  RETURN br_redaka_l > 0;
END;
FUNCTION OJ_ZMPOJR_ID
 (OJ_ID_P IN M_OJ.ID%TYPE
 ,DAT_POC_P IN date := NULL
 ,DAT_ZAV_P IN date := NULL
 ,METAPL_SIFRA_P IN VARCHAR2 := NULL
 )
 RETURN MZMP_OJR.ID%TYPE
 IS
-- funkcija vraa prvu odgovarajuu OJR za poslanu OJ
-- ako datumi nisu poslani ne uzima u obzir dat_valjan i poniten inae vraa OJR valjanu u poslanom razdoblju
-- (za trenutno valjane knjige poslati sysdate u datume)
-- ako je metapl_sifra_p = NULL onda moe biti upisan ili REC ili GAS vor inae mora biti upisan odgovarajui

  CURSOR zmpojr_c (oj_id_p NUMBER) IS
    SELECT zmpojr.id
      FROM m_oj oj,
           (
           SELECT id FROM mzmp_ojr zmpojr
            WHERE
              (metapl_sifra_p IS NULL AND (metcvor_sifra IS NOT NULL OR metcvor_sifra_gas IS NOT NULL)
              OR metapl_sifra_p = 'REC' AND metcvor_sifra IS NOT NULL
              OR metapl_sifra_p = 'GAS' AND metcvor_sifra_gas IS NOT NULL
              )
              AND zmpojr.dat_valjan <= NVL (dat_poc_p, TO_DATE ('31.12.9999', 'DD.MM.RRRR'))
              AND NVL (zmpojr.dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) >
                  NVL (dat_zav_p, TO_DATE ('01.01.0001', 'DD.MM.RRRR'))
           ) zmpojr
     WHERE oj.id = zmpojr.id (+)
     START WITH oj.id = oj_id_p
   CONNECT BY PRIOR oj_id = oj.id;
  zmpojr_id_l mzmp_ojr.id%TYPE;
BEGIN
  OPEN zmpojr_c (oj_id_p);
  FETCH zmpojr_c INTO zmpojr_id_l;
  WHILE zmpojr_id_l IS NULL AND zmpojr_c%FOUND
  LOOP
    FETCH zmpojr_c INTO zmpojr_id_l;
  END LOOP;
  CLOSE zmpojr_c;
  RETURN (zmpojr_id_l);
END;
FUNCTION AT_CENTAR
 RETURN VARCHAR2
 IS
--
  metcvor_sifra_centar_l smet_cvorovi.sifra%TYPE := LOWER (pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0018'));
  metcvor_sifra_tekuci_l smet_cvorovi.sifra%TYPE := LOWER (pra_zmp_zaj.tekuci_cvor);
BEGIN
  IF metcvor_sifra_centar_l = 'nebitno'
    OR metcvor_sifra_centar_l = metcvor_sifra_tekuci_l
  THEN
    RETURN ('');
  ELSE
    RETURN ('@' || metcvor_sifra_centar_l);
  END IF;
END;
FUNCTION SAS_ID
 (USL_ID_P IN s_usluge.id%TYPE
 )
 RETURN s_sastojci.id%TYPE
 IS
-- uobiajeni poetni sastojak
  CURSOR uslsaspz_c IS
    SELECT uslsas.sas_id
      FROM s_usl_sas uslsas,
           s_usl_saspz uslsaspz,
           s_sastojci sas
     WHERE uslsaspz.uslsasp_id = uslsas.id
       AND uslsas.usl_id = usl_id_p
       AND uslsas.sas_id = sas.id
     ORDER BY uslsaspz.ozn_uobicajen_sasp, sas.rbr, uslsas.sas_id; -- IRN 2986, dodan sas.rbr

  CURSOR uslsas_c IS
    SELECT sas_id
      FROM s_usl_sas
     WHERE usl_id = usl_id_p;

  sas_id_l s_sastojci.id%TYPE;
BEGIN
  IF usl_id_p IS NULL THEN
    RETURN (NULL);
  END IF;

  -- poetni sastojak
  OPEN uslsaspz_c;
  FETCH uslsaspz_c INTO sas_id_l;
  CLOSE uslsaspz_c;
  IF sas_id_l IS NULL THEN
    -- sastojak
    OPEN uslsas_c;
    FETCH uslsas_c INTO sas_id_l;
    CLOSE uslsas_c;
  END IF;

  RETURN (sas_id_l);
END;
FUNCTION OZNAKA
 (DP1_P IN VARCHAR2
 ,OJ_SIFRA_P IN m_oj.sifra%TYPE := NULL
 )
 RETURN NUMBER
 IS
-- IRN 1450
  CURSOR c IS
    SELECT TO_DATE (zmp_zaj2.desifriranje (p2), 'DD.MM.RRRR')
      FROM s_nebitno2
     WHERE UPPER (zmp_zaj2.desifriranje (p1)) = dp1_p || oj_sifra_p; -- IRN 3016 
  datum_l DATE;
BEGIN

  OPEN c;
  FETCH c INTO datum_l;
  CLOSE c;

  IF datum_l IS NULL OR datum_l < SYSDATE THEN
    -- Ako je datum NULL ili je manji od tekueg onda jedinica nije aktivna
    RETURN (0);
  END IF;

  RETURN (-1);

END;
FUNCTION OZNAKA1
 (DP1_P IN VARCHAR2
 ,OJ_SIFRA_P IN m_oj.sifra%TYPE
 )
 RETURN NUMBER
 IS
-- oznaka jedinice: -1 = aktivna ili 0 = nije aktivna

  -- IRN 3169
  CURSOR c_oj IS
    SELECT oj.sifra
      FROM sgas_vlasnik vl, m_oj oj
     WHERE oj.id = vl.oj_id;
  -- IRN 2921
  CURSOR c (oj_sifra_p VARCHAR2) IS
    SELECT TO_DATE (zmp_zaj2.desifriranje (p2), 'DD.MM.RRRR')
      FROM s_nebitno2
     WHERE (UPPER (zmp_zaj2.desifriranje (p1)) = dp1_p || oj_sifra_p
        OR (pra_zmp.oj_pripada_oj ((SELECT id FROM m_oj WHERE m_oj.sifra = oj_sifra_p), -- IRN 3043
                                   (SELECT id FROM m_oj WHERE m_oj.sifra = zmp_zaj2.desifriranje(p5))) = -1
        AND UPPER (zmp_zaj2.desifriranje (p1)) LIKE dp1_p ||'%'
        AND p5 IS NOT NULL));

  datum_l DATE;
  oj_sifra_l m_oj.sifra%TYPE;
BEGIN
  -- IRN 3169 - ako je parametar oj_sifra_p null uzima ifru oj iz vlasnika
  IF oj_sifra_p IS NULL THEN
    OPEN c_oj;
    FETCH c_oj INTO oj_sifra_l;
    CLOSE c_oj;
  ELSE
    oj_sifra_l := oj_sifra_p;
  END IF;

  OPEN c (oj_sifra_l);
  FETCH c INTO datum_l;
  CLOSE c;

  IF datum_l IS NULL OR datum_l < SYSDATE THEN
    -- Ako je datum NULL ili je manji od tekueg onda jedinica nije aktivna
    RETURN (0);
  END IF;

  RETURN (-1);

END;
FUNCTION RV_MEANING
 (RV_DOMAIN_P IN cg_ref_codes.rv_domain%TYPE
 ,RV_LOW_VALUE_P IN cg_ref_codes.rv_low_value%TYPE
 )
 RETURN cg_ref_codes.rv_meaning%TYPE
 IS
-- IRN 1361
  sifra_jez_l s_jezici.sifra_3a%TYPE;
  rv_meaning_l cg_ref_codes.rv_meaning%TYPE;
BEGIN
  IF rv_domain_p IS NULL OR rv_low_value_p IS NULL THEN
    RETURN (NULL);
  END IF;

  BEGIN
    SELECT NVL (sifra_jez, pra_zmp_zaj.vrijednost_parametra ('0014')) INTO sifra_jez_l
      FROM m_korisnici
     WHERE naziv = USER;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      sifra_jez_l := '';
  END;

  SELECT MAX (NVL (rcjez.rv_meaning, rc.rv_meaning)) INTO rv_meaning_l
    FROM cg_ref_codes rc,
         (
         SELECT rv_domain, rv_low_value, rv_meaning
           FROM cg_ref_codes_jez
          WHERE rv_domain = rv_domain_p
            AND rv_low_value = rv_low_value_p
            AND sifra_jez = sifra_jez_l
         ) rcjez
   WHERE rc.rv_domain = rv_domain_p
     AND rc.rv_low_value = rv_low_value_p
     AND rc.rv_domain = rcjez.rv_domain (+)
     AND rc.rv_low_value = rcjez.rv_low_value (+);

  RETURN (rv_meaning_l);
END;
PROCEDURE PROVJERI_RECPOPRAZD
 (ZMPPOP_ID_P IN MZMP_POPUSTI.ID%TYPE
 )
 IS
-- Procedura koja se poziva prilikom unosa u MZMP_POP_USL kako bi provjerila da nema redaka u TREC_POP_RAZD 
  br_redaka_l NUMBER;
BEGIN
  SELECT COUNT(rowid) INTO br_redaka_l
    FROM trec_pop_razd
   WHERE zmppop_id = zmppop_id_p;
    
  IF br_redaka_l > 1 THEN
    -- Ne mogu se definirati popusti po uslugama ako su ve upisani po razdobljima.
    pra_zmp_zaj.vrati_poruku (-20096); -- IRN 2474 nekad -20576
  END IF;
END;
FUNCTION BROJ_NEFISKALIZIRANIH_RAC
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,METAPL_SIFRA_P IN SMET_APLIKACIJE.SIFRA%TYPE
 ,RECEPCIONER_P IN SMET_APLIKACIJE.UNOS_KORISNIK%TYPE
 )
 RETURN INTEGER
 IS
-- vraa broj nefiskaliziranih rauna u aplikaciji PKA ili REC (ili jedno i drugo)
-- sa cvora metcvor_sifra_p
  cvor_l VARCHAR2(41);
  naredba_l VARCHAR2(2000);
  br_rec_l NUMBER := 0;
  br_pka_l NUMBER := 0;
BEGIN

  IF metcvor_sifra_p IS NULL OR metcvor_sifra_p = pra_zmp_zaj.tekuci_cvor THEN
    cvor_l := '';
  ELSE
    cvor_l := '@' || metcvor_sifra_p;
  END IF;

  IF metapl_sifra_p IS NULL OR metapl_sifra_p = 'REC' THEN
    naredba_l :=
      'SELECT COUNT (1)
         FROM t_racuni' || cvor_l || ' rac,
              s_vapldok' || cvor_l || ' vapldok,
              s_vlasnik' || cvor_l || ' vlas,
              m_agencije' || cvor_l || ' age
        WHERE vlas.ozn_fsustava IN (''HR'', ''SI'')
          AND rac.datum >= vlas.dat_primjene
          AND (UPPER (rac.unos_korisnik) = UPPER (:recepcioner_p) OR :recepcioner_p IS NULL)
          AND (vapldok.oznaka = ''GI'' OR (TRUNC(rac.datum) >= pra_zmp_s.dat_erac_obveze AND vapldok.oznaka = ''BI'' AND age.ozn_vfisk = ''F1''))
          AND rac.vapldok_id = vapldok.id
          AND rac.jir IS NULL
          AND rac.age_id = age.id(+)';

    EXECUTE IMMEDIATE naredba_l INTO br_rec_l USING recepcioner_p, recepcioner_p;
  END IF;

  IF metapl_sifra_p IS NULL OR metapl_sifra_p = 'PKA' THEN
    naredba_l :=
      'SELECT COUNT (1)
         FROM tpka_racuni' || cvor_l || ' rac,
              s_vapldok' || cvor_l || ' vapldok,
              s_vlasnik' || cvor_l || ' vlas, 
              mgmp_komitenti' || cvor_l || ' gmpkom
        WHERE vlas.ozn_fsustava IN (''HR'', ''SI'')
          AND rac.datum >= vlas.dat_primjene
          AND (UPPER (rac.unos_korisnik) = UPPER (:recepcioner_p) OR :recepcioner_p IS NULL)
          AND (vapldok.oznaka IN (''GI'', ''GP'') OR (TRUNC(rac.datum) >= pra_zmp_s.dat_erac_obveze AND vapldok.oznaka IN (''BI'', ''BP'') AND DECODE (rac.pkaadr_id, NULL, gmpkom.ozn_vfisk, ''F1'') = ''F1''))
          AND rac.vapldok_id = vapldok.id
          AND rac.jir IS NULL
          AND rac.gmpkom_id = gmpkom.id(+)';

    EXECUTE IMMEDIATE naredba_l INTO br_pka_l USING recepcioner_p, recepcioner_p;
  END IF;

  RETURN (br_rec_l + br_pka_l);

EXCEPTION
  WHEN OTHERS THEN
    RETURN (NULL); -- ako vor nije dostupan e vratiti NULL
END;
PROCEDURE PROVJERI_GMPKAS_LOYULA
 (ZMPOJR_ID_P IN mgmp_kase.zmpojr_id%TYPE
 ,GMPKAS_ID_P IN mgmp_kase.id%TYPE
 )
 IS
-- IRN 2474
  br_redaka_l NUMBER;
BEGIN
  IF zmpojr_id_p IS NULL OR gmpkas_id_p IS NULL THEN
    RETURN;
  END IF;

  SELECT COUNT(id) INTO br_redaka_l
    FROM c_tloy_ulaz
   WHERE cenojr_id = zmpojr_id_p
     AND gmpkas_id = gmpkas_id_p;
  IF br_redaka_l > 0 THEN
    -- Izmjena knjige rauna nije doputena jer postoje prometni podaci (bodovi programa vjernosti).
    pra_zmp_zaj.vrati_poruku (-20108);
  END IF;   
END;
PROCEDURE PROVJERI_OJ_PODR_OJ1
 (OJ_ID_P IN m_oj.id%TYPE
 ,OJ1_ID_P IN m_oj.id%TYPE
 )
 IS
-- Provjeri da oj pripada oj1
  nebitno_l NUMBER;
BEGIN
  SELECT pra_zmp.oj_pripada_oj (oj_id_p, oj1_id_p) INTO nebitno_l FROM dual;
  IF nebitno_l = 0 THEN
    -- OJ #0 mora biti podreena OJ #1.
    pra_zmp_zaj.vrati_poruku (-20117, pra_zmp_zaj.poruka ('ZMP', 'ZMP0128'), pra_zmp_zaj.poruka ('ZMP', 'ZMP_ZMPOJR')); -- IRN 2986
  END IF;
END;
PROCEDURE PROVJERI_OJ_ZMPOJR
 (OJ_ID_P IN M_OJ.ID%TYPE
 ,DAT_POC_P IN DATE
 ,DAT_ZAV_P IN DATE
 )
 IS
-- Provjeri da oj pripada barem jednoj OJR (neovisno o voru).
  zmpojr_id_l mzmp_ojr.id%TYPE;
BEGIN
  IF oj_id_p is NULL THEN
    RETURN;
  END IF;
  SELECT pra_zmp_s.oj_zmpojr_id (oj_id_p, dat_poc_p, dat_zav_p) INTO zmpojr_id_l FROM dual;
  IF zmpojr_id_l IS NULL THEN
    -- #0 mora pripadati Knjizi rauna.
    pra_zmp_zaj.vrati_poruku (-20112, pra_zmp_zaj.poruka ('ZMP', 'ZMP0128'));
  END IF;
END;
PROCEDURE PROVJERI_OJR_OJRP
 (ZMPOJR_ID_P IN MZMP_OJR.ID%TYPE
 ,OZNAKA_P IN VARCHAR2
 ,DAT_POC_P IN DATE := NULL
 ,DAT_ZAV_P IN DATE := NULL
 ,METAPL_SIFRA_P IN VARCHAR2 := NULL
 )
 IS
-- provjeriti ovisno o oznaci da li je zmpojr ili Knjiga rauna ili Poslovni prostor
  CURSOR zmpojr_c  IS
    SELECT id FROM mzmp_ojr zmpojr
    WHERE
      id = zmpojr_id_p
      AND
      (oznaka_p = 'OJR'
        AND
        (metapl_sifra_p IS NULL AND (metcvor_sifra IS NOT NULL OR metcvor_sifra_gas IS NOT NULL)
        OR metapl_sifra_p = 'REC' AND metcvor_sifra IS NOT NULL
        OR metapl_sifra_p = 'GAS' AND metcvor_sifra_gas IS NOT NULL
        )
        OR
        oznaka_p = 'OJRP'
        AND ozn_samo_pp = -1
      )
      AND zmpojr.dat_valjan <= NVL (dat_poc_p, TO_DATE ('31.12.9999', 'DD.MM.RRRR'))
      AND NVL (zmpojr.dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) >
             NVL (dat_zav_p, TO_DATE ('01.01.0001', 'DD.MM.RRRR'))
      ;

  zmpojr_id_l mzmp_ojr.id%TYPE;
  oj_sifra_l m_oj.sifra%TYPE;
BEGIN
  IF zmpojr_id_p IS NULL OR oznaka_p NOT IN ('OJR','OJRP') THEN
    RETURN;
  END IF;
  OPEN zmpojr_c;
  FETCH zmpojr_c INTO zmpojr_id_l;
  IF zmpojr_c%NOTFOUND THEN
    CLOSE zmpojr_c;
    SELECT sifra INTO oj_sifra_l FROM m_oj WHERE id = zmpojr_id_p;
    IF oznaka_p IN ('OJR') THEN
      pra_zmp_zaj.vrati_poruku (-20113, oj_sifra_l); -- #0 nije Knjiga rauna.
    ELSE
      pra_zmp_zaj.vrati_poruku (-20114, oj_sifra_l); -- #0 nije samo poslovni prostor.
    END IF;
  END IF;
END;
PROCEDURE PROVJERI_PODREDJENE_OJRP
 (ZMPOJR_ID_P IN MZMP_OJR.ID%TYPE
 )
 IS
-- za svaku podredjenu OJRP provjeri da ima nadredjenu OJR.
  CURSOR pp_c IS -- podreene pp
    SELECT zmpojr.id, zmpojr.dat_valjan, zmpojr.dat_ponisten
      FROM
          (SELECT id FROM m_oj oj WHERE oj.id <> zmpojr_id_p
             START WITH oj.id = zmpojr_id_p
             CONNECT BY PRIOR oj.id = oj.oj_id) oj,  -- podreene oj
          (SELECT id, dat_valjan, dat_ponisten FROM mzmp_ojr zmpojr
            WHERE ozn_samo_pp = -1
           ) zmpojr   -- p
      WHERE oj.id = zmpojr.id;

  zmpojrp_id_l mzmp_ojr.id%TYPE;
  dat_valjan_l mzmp_ojr.dat_valjan%TYPE;
  dat_ponisten_l mzmp_ojr.dat_ponisten%TYPE;
BEGIN
  OPEN pp_c;
  LOOP
    FETCH pp_c INTO zmpojrp_id_l, dat_valjan_l, dat_ponisten_l;
    EXIT WHEN pp_c%NOTFOUND;
    pra_zmp_s.provjeri_oj_zmpojr (zmpojrp_id_l, dat_valjan_l, dat_ponisten_l);
  END LOOP;
  CLOSE pp_c;
END;
PROCEDURE PROVJERI_ZMPOJR_GMPKAS
 (ZMPOJR_ID_P IN mzmp_ojr.id%TYPE
 ,OZNAKA_P IN VARCHAR2
 )
 IS
--
  CURSOR gmpkas_c IS
    SELECT id
      FROM mgmp_kase
     WHERE (oznaka_p = 'OJR' AND zmpojr_id = zmpojr_id_p)
        OR (oznaka_p = 'OJRP' AND zmpojrp_id = zmpojr_id_p);

  gmpkas_id_l mgmp_kase.id%TYPE;
BEGIN
  IF zmpojr_id_p IS NULL OR oznaka_p NOT IN ('OJR', 'OJRP') THEN
    RETURN;
  END IF;
  OPEN gmpkas_c;
  FETCH gmpkas_c INTO gmpkas_id_l;
  IF gmpkas_c%FOUND THEN
    CLOSE gmpkas_c; -- IRN 2986
    IF oznaka_p IN ('OJR') THEN
      -- Knjigu rauna ne moete promijeniti u (samo) poslovni prostor jer su na nju vezane kase.
      pra_zmp_zaj.vrati_poruku (-20115);
    ELSE
      -- Poslovni prostor ne moete promijeniti u Knjigu rauna jer su na njega vezane kase.
      pra_zmp_zaj.vrati_poruku (-20116);
    END IF;
  END IF;
  CLOSE gmpkas_c;
END;
PROCEDURE PROVJERI_HR_OIB
 (OIB_P IN VARCHAR2
 )
 IS
-- IRN 2648
  ostatak_l NUMBER(2);
BEGIN
  IF oib_p IS NULL THEN
    RETURN;
  END IF;

  IF LENGTH (oib_p) <> 11 THEN
    -- Podatak OIB treba imati 11 znakova.
    pra_zmp_zaj.vrati_poruku (-20128);
  END IF;

  IF TRANSLATE (oib_p, '0123456789', '0000000000') <> '00000000000' THEN
    -- Svi uneseni znakovi podatka OIB moraju biti brojke.
    pra_zmp_zaj.vrati_poruku (-20130);
  END IF;

  FOR i IN 1..10 LOOP
    IF i = 1 THEN
      ostatak_l := MOD (SUBSTR (oib_p, i, 1) + 10, 10);
    ELSE
      ostatak_l := MOD (SUBSTR (oib_p, i, 1) + ostatak_l, 10);
    END IF;
    IF ostatak_l = 0 THEN
      ostatak_l := 10;
    END IF;
    ostatak_l := MOD (ostatak_l * 2, 11);
  END LOOP;
  IF (11 - ostatak_l) = SUBSTR (oib_p, 11, 1)
    OR ((11 - ostatak_l) = 10 AND SUBSTR (oib_p, 11, 1) = 0)
  THEN
    NULL;
  ELSE
    -- Neispravan OIB.
    pra_zmp_zaj.vrati_poruku (-20129);
  END IF;

END;
FUNCTION KOL_SJ_VSJS
 (VSJS_ID_P IN s_vsj.id%TYPE
 )
 RETURN NUMBER
 IS
-- kol_sj za sastavljenu VSJ
  kol_sj_ukupno_l NUMBER;
BEGIN
  IF vsjs_id_p IS NULL THEN
    RETURN (NULL);
  END IF;
  -- ukupan broj SJ i osoba za tu vsjs
  SELECT SUM (vsjvsj.kol_sj) INTO kol_sj_ukupno_l
    FROM s_vsj_vsj vsjvsj
   WHERE vsjvsj.vsjs_id = vsjs_id_p;

  RETURN (kol_sj_ukupno_l);
END;
FUNCTION BR_OSOBA_VSJUS
 (VSJS_ID_P IN s_vsj.id%TYPE
 ,BR_OSOBA_P IN NUMBER
 ,VSJUS_ID_P IN s_vsj.id%TYPE
 )
 RETURN NUMBER
 IS
/*
broj osoba koji pripada vsj u sustavu ako je broj osoba za sastavljenu vsj = br_osoba_p
*/
  -- broj postelja i kol_sj za vsjus
  CURSOR vsjus_c IS
    SELECT vsj.br_postelja * vsjvsj.kol_sj, vsjvsj.kol_sj
      FROM s_vsj_vsj vsjvsj, s_vsj vsj
     WHERE vsjvsj.vsjs_id = vsjs_id_p AND vsjvsj.vsjus_id = vsj.id AND vsjvsj.vsjus_id = vsjus_id_p;
  -- sastav od glavne nadalje
  CURSOR vsjvsj_c IS
    SELECT vsjvsj.kol_sj * vsj.br_postelja, vsj.id, vsjvsj.kol_sj, vsjvsj.vsjus_id
      FROM s_vsj_vsj vsjvsj, s_vsj vsj  -- prva dohvaena sj mora biti glavna pa treba biti select usklaen sa onim u funkciji vsjs_glavna
     WHERE vsjvsj.vsjs_id = vsjs_id_p AND vsjvsj.vsjus_id = vsj.id
     ORDER BY 1 DESC, 2;
  kol_sj_ukupno_l NUMBER;
  br_osoba_ukupno_l NUMBER;
  nebitno1_vsjvsj_l NUMBER;
  nebitno2_vsjvsj_l NUMBER;
  vsjus_id_vsjvsj_l NUMBER;
  kol_sj_vsjvsj_l NUMBER;
  br_osoba_pom_l NUMBER;
  kol_sj_vsjus_l NUMBER;
  br_osoba_vsjus_l NUMBER;
  vsjus_id_glavna_l s_vsj.id%TYPE;
BEGIN
  IF vsjs_id_p IS NULL OR vsjUS_id_p IS NULL OR br_osoba_p IS NULL THEN
    RETURN (NULL);
  END IF;
  -- ukupan broj SJ i osoba za tu vsjs
  SELECT SUM (vsjvsj.kol_sj), SUM (vsjvsj.kol_sj * vsj.br_postelja) INTO kol_sj_ukupno_l, br_osoba_ukupno_l
    FROM s_vsj_vsj vsjvsj, s_vsj vsj
   WHERE vsjvsj.vsjs_id = vsjs_id_p AND vsjvsj.vsjus_id = vsj.id;
  -- glavna vsjus = ona sa najvie postelja, prva po unosu. Na nju e ii  ostatak postelja
  vsjus_id_glavna_l := pra_zmp_s.vsjus_glavna (vsjs_id_p);
  -- vsjus_id_p
  OPEN vsjus_c;
  FETCH vsjus_c INTO br_osoba_vsjus_l, kol_sj_vsjus_l;
  CLOSE vsjUS_c;
  IF br_osoba_p < kol_sj_ukupno_l THEN
    -- ako je osoba manje od broja SJ treba rasporediti tako da to vie SJ dobije po jednu osobu
    br_osoba_pom_l := br_osoba_p;
    OPEN vsjvsj_c;
    LOOP
      FETCH vsjvsj_c INTO nebitno1_vsjvsj_l, nebitno2_vsjvsj_l, kol_sj_vsjvsj_l, vsjus_id_vsjvsj_l;
      IF vsjvsj_c%FOUND THEN
        IF br_osoba_pom_l <= kol_sj_vsjvsj_l THEN -- osoba je manje nego sj te vsj, sve osobe idu na tu vsj
          br_osoba_vsjus_l := br_osoba_pom_l;
          br_osoba_pom_l := 0;
        ELSE -- osoba je vie nego sj te vsj pa ostatak ide dalje
          br_osoba_vsjus_l := kol_sj_vsjvsj_l;
          br_osoba_pom_l := br_osoba_pom_l - kol_sj_vsjvsj_l;
        END IF;
      END IF;
      EXIT WHEN vsjvsj_c%NOTFOUND OR vsjus_id_p = vsjus_id_vsjvsj_l; -- izlazi se kada naie na vsjus_id_p
    END LOOP;
    CLOSE vsjvsj_c;
  ELSIF br_osoba_p = kol_sj_ukupno_l THEN
    br_osoba_vsjus_l := kol_sj_vsjus_l;
  ELSIF br_osoba_p < br_osoba_ukupno_l THEN
    IF vsjus_id_p = vsjus_id_glavna_l THEN
      br_osoba_vsjus_l := kol_sj_vsjus_l + (br_osoba_p - kol_sj_ukupno_l);
    ELSE
      br_osoba_vsjus_l := kol_sj_vsjus_l;
    END IF;
  ELSIF  br_osoba_p = br_osoba_ukupno_l THEN
       br_osoba_vsjus_l := br_osoba_vsjus_l;
  ELSIF  br_osoba_p > br_osoba_ukupno_l THEN
    IF vsjus_id_p = vsjus_id_glavna_l THEN
      br_osoba_vsjus_l := br_osoba_vsjus_l + (br_osoba_p - br_osoba_ukupno_l);
    ELSE
      br_osoba_vsjus_l := br_osoba_vsjus_l;
    END IF;
  END IF;
  RETURN (br_osoba_vsjus_l);
END;
FUNCTION VSJ_JE_SASTAVLJENA
 (VSJ_ID_P IN s_vsj.id%TYPE
 ,OZN_ZAVRSEN_SASTAV_P IN NUMBER := -1
 )
 RETURN NUMBER
 IS
/*
VSJ je sastavljena

ozn_zavrsen_sastav_p = -1 (default) => vsj je sastavljena ako je postavljena ozn_sastavljena na da
inae = vsj je sastavljena ako postoji redak u sastavu (jaa kontrola, koristi se za provjeru vsj u SJ)
*/
  CURSOR vsjS_c IS
    SELECT ozn_sastavljena FROM S_VSJ WHERE id = vsj_id_p;
  CURSOR vsjvsj_c IS
    SELECT 1 FROM s_vsj_vsj WHERE vsjs_id = vsj_id_p;
  ozn_sastavljena_l NUMBER;
  nebitno_l NUMBER;
BEGIN
  IF vsj_id_p IS NULL THEN
    RETURN (0);
  END IF;
  IF ozn_zavrsen_sastav_p = -1 THEN
    OPEN vsjS_c;
    FETCH vsjS_c INTO ozn_sastavljena_l;
    CLOSE vsjS_c;
  ELSE
    OPEN vsjvsj_c;
    FETCH vsjvsj_c INTO nebitno_l;
    IF vsjvsj_c%FOUND THEN
      ozn_sastavljena_l := -1;
    ELSE
      ozn_sastavljena_l := 0;
    END IF;
    CLOSE vsjvsj_c;
  END IF;
  RETURN (ozn_sastavljena_l);
END;
PROCEDURE PROVJERI_VSJ_SASTAVLJENA
 (VSJ_ID_P IN s_vsj.id%TYPE
 ,OZN_SASTAVLJENA_P IN s_vsj.ozn_sastavljena%TYPE
 )
 IS
-- Procedura koja se poziva prilikom postavljanja ozn_sastavljena na -1 kako bi provjerila da postoji sastav
  nebitno_l NUMBER;
BEGIN
  IF vsj_id_p IS NULL OR ozn_sastavljena_p <> -1 THEN
    RETURN;
  END IF;
  SELECT COUNT (ROWID) INTO nebitno_l FROM s_vsj_vsj WHERE vsjs_id = vsj_id_p;
  IF nebitno_l = 0 THEN
    -- Ne moete oznaiti VSJ kao sastavljenu ako nema upisan sastav.
    pra_zmp_zaj.vrati_poruku (-20131);
  END IF;
END;
PROCEDURE PROVJERI_VSJS_NIJE_VSJUS
 (VSJVSJ_ID_P IN s_vsj_vsj.id%TYPE
 ,VSJ_ID_P IN s_vsj.id%TYPE
 )
 IS
--
  nebitno_l NUMBER;
BEGIN
  IF vsj_id_p IS NULL THEN
    RETURN;
  END IF;
  SELECT COUNT (ROWID) INTO nebitno_l FROM s_vsj_vsj vsjvsj 
   WHERE vsjvsj.vsjus_id = vsj_id_p AND vsjvsj.id <> NVL (vsjvsj_id_p, 0);
  IF nebitno_l > 0 THEN
    -- VSJ koja se nalazi u sastavu druge VSJ ne moe biti sastavljena.
    pra_zmp_zaj.vrati_poruku (-20135);
  END IF;
END;
PROCEDURE PROVJERI_VSJS_SJ
 (VSJ_ID_P IN s_vsj.id%TYPE
 ,OZN_SASTAVLJENA_OLD_P IN s_vsj.ozn_sastavljena%TYPE
 ,OZN_SASTAVLJENA_NEW_P IN s_vsj.ozn_sastavljena%TYPE
 )
 IS
-- Procedura koja se poziva prilikom postavljanja ozn_sastavljena na -1 kako bi provjerila da postoji sastav
-- SJ ne moe biti vrste koja je oznaena kao sastavljena (= ne moe se ozn_sastavljena postaviti na -1 ako postoji SJ te vrste.)
-- SJS ne moe biti vrste koja je oznaena kao nesastavljena (= ne moe se ozn_sastavljena postaviti na 0 ako postoji SJS te vrste.)

  nebitno_l NUMBER;
BEGIN
  IF vsj_id_p IS NULL OR ozn_sastavljena_old_p = ozn_sastavljena_new_p THEN
    RETURN;
  END IF;
  IF pra_zmp_zaj.centar = -1 AND replikacija.potrebni_cvorovi_u_mrezi ('ZMP', 'S_VSJ') = 0 THEN
    -- Ne moete promijeniti oznaku sastavljena ako nisu svi vorovi u mrei.
    pra_zmp_zaj.vrati_poruku (-20134);
  END IF;
  
  IF ozn_sastavljena_new_p = -1 THEN
    SELECT COUNT (ROWID) INTO nebitno_l FROM m_sj WHERE vsj_id = vsj_id_p;
    IF nebitno_l > 0 THEN
      -- Ne moete oznaiti VSJ kao sastavljenu ako postoje SJ te vrste.
      pra_zmp_zaj.vrati_poruku (-20132);
    END IF;
  END IF;
  IF ozn_sastavljena_new_p = 0 THEN
    SELECT COUNT (ROWID) INTO nebitno_l FROM m_sj WHERE vsjs_id = vsj_id_p;
    IF nebitno_l > 0 THEN
      -- Ne moete promijeniti oznaku za VSJ za koju postoje sastavljene SJ.
      pra_zmp_zaj.vrati_poruku (-20133);
    END IF;
  END IF;
END;
FUNCTION VSJUS_GLAVNA
 (VSJS_ID_P IN s_vsj.id%TYPE
 )
 RETURN NUMBER
 IS
/*
glavna vsjus = ona sa najvie postelja, prva po unosu.
*/
  CURSOR vsjus_glavna_c IS
    SELECT vsjvsj.kol_sj * vsj.br_postelja, vsj.id
      FROM s_vsj_vsj vsjvsj, s_vsj vsj
     WHERE vsjvsj.vsjs_id = vsjs_id_p AND vsjvsj.vsjus_id =  vsj.id
     ORDER BY 1 DESC, 2;

  vsjus_id_glavna_l s_vsj.id%TYPE;
  nebitno_l NUMBER;
BEGIN
  IF vsjs_id_p IS NULL THEN
    RETURN (NULL);
  END IF;

  OPEN vsjus_glavna_c;
  FETCH vsjus_glavna_c INTO nebitno_l, vsjus_id_glavna_l;
  CLOSE vsjus_glavna_c;
  RETURN (vsjus_id_glavna_l);
END;
FUNCTION ZMPPAR_MIN_DANA
 (ZMPSUS_SIFRA_P IN SZMP_SUSTAVI.SIFRA%TYPE
 ,ZMPPAR_SIFRA_P IN SZMP_PARAMETRI.SIFRA%TYPE
 ,TEKUCI_CVOR_P IN SMET_CVOROVI.SIFRA%TYPE
 ,OZN_SVI_CVOROVI_P IN NUMBER
 )
 RETURN NUMBER
 IS
-- vraa najmanji broj dana po svim cvorovima za koji se mogu dobiti podaci u view-ima
   naredba_l VARCHAR2(1000);
   broj_dana_char_l VARCHAR2(10);
   broj_dana_l NUMBER;
   min_dana_l NUMBER;
   greska_l NUMBER;
   cvor_l smet_cvorovi.sifra%TYPE;
BEGIN

   naredba_l :=
     'SELECT vrijednost FROM szmp_parametri<CVOR> WHERE zmpsus_id = (' ||
     'SELECT id FROM szmp_sustavi<CVOR> WHERE sifra = :zmpsus_sifra_p) AND sifra = :zmppar_sifra_p'; -- IRN 2986

   -- tekuci cvor (centar ili objekt)
   BEGIN
      EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', '')
         INTO broj_dana_char_l
        USING zmpsus_sifra_p, zmppar_sifra_p; -- IRN 2986
      broj_dana_l := TO_NUMBER (broj_dana_char_l);
      min_dana_l := broj_dana_l;
   EXCEPTION
      WHEN OTHERS THEN
         greska_l := -1;
   END;

   -- samo na centru ako je ozn_svi_cvorovi_p = -1 (podaci su unija svih vorova)
   IF ozn_svi_cvorovi_p = -1 AND pra_zmp_zaj.centar = -1 THEN
      FOR cvorovi_c IN (SELECT sifra FROM smet_cvorovi WHERE ozn_u_mrezi = -1 AND sifra <> tekuci_cvor_p) LOOP
         broj_dana_l := NULL;
         cvor_l := cvorovi_c.sifra;
         BEGIN
            EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', '@' || cvor_l)
               INTO broj_dana_char_l
              USING zmpsus_sifra_p, zmppar_sifra_p;
            broj_dana_l := TO_NUMBER (broj_dana_char_l);
         EXCEPTION
            WHEN OTHERS THEN
               greska_l := -1;
         END;
         IF broj_dana_l IS NOT NULL THEN
            IF broj_dana_l < NVL (min_dana_l, 9999) THEN
               min_dana_l := broj_dana_l;
            END IF;
         END IF;
      END LOOP;
   END IF;

   IF greska_l = -1 OR min_dana_l IS NULL THEN
      RETURN (-1);
   ELSE
      RETURN (min_dana_l);
   END IF;

END;
FUNCTION BROJ_NEFISKALIZIRANIH_PD
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,RECEPCIONER_P IN SMET_APLIKACIJE.UNOS_KORISNIK%TYPE
 )
 RETURN NUMBER
 IS
-- vraa broj nefiskaliziranih prateih dokumenata s cvora metcvor_sifra_p
  cvor_l VARCHAR2(21);
  naredba_l VARCHAR2(2000);
  br_l NUMBER := 0;
BEGIN
  IF metcvor_sifra_p IS NULL OR metcvor_sifra_p = pra_zmp_zaj.tekuci_cvor THEN
    cvor_l := '';
  ELSE
    cvor_l := '@' || metcvor_sifra_p;
  END IF;
  -- IRN 4058; dodano itanje tablice s_vlasnik i tpka_pdokumenti.datum
  -- IRN 4079; dodano itanje funkcije pra_zmp_s.dat_prestanka_pd
  naredba_l :=
    'SELECT COUNT (1)
       FROM tpka_pdokumenti<CVOR> pkapd, s_vlasnik<CVOR> vlas
      WHERE pkapd.ozn_vlastiti = -1
        AND vlas.ozn_fsustava IN (''HR'')
        AND pkapd.datum >= vlas.dat_primjene
        AND pkapd.datum < pra_zmp_s.dat_prestanka_pd<CVOR>
        AND pkapd.jir IS NULL
        AND (UPPER (pkapd.unos_korisnik) = UPPER (:recepcioner_p) OR :recepcioner_p IS NULL)';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_l) INTO br_l USING recepcioner_p, recepcioner_p;
  RETURN (br_l);
EXCEPTION
  WHEN OTHERS THEN
    RETURN (NULL); -- ako vor nije dostupan vraa NULL
END;
PROCEDURE PROVJERI_P2
 (HEADER_P IN VARCHAR2
 ,NAZIV_P OUT VARCHAR2
 ,VLASNIKPODATKA_P OUT NUMBER
 )
 IS
--
  c         SYS_REFCURSOR;
  nebitno_l NUMBER(1);
  select_l  VARCHAR2(200);
BEGIN

  SELECT COUNT (*)
    INTO nebitno_l
    FROM user_tab_columns
   WHERE table_name = 'S_NEBITNO3'
     AND column_name = 'VLASNIKPODATKA';

  IF nebitno_l = 0 THEN
    select_l :=
      'SELECT naziv, NULL
         FROM s_nebitno3
        WHERE p2 = ''' || header_p || '''';
  ELSE
    select_l :=
      'SELECT naziv, vlasnikpodatka
         FROM s_nebitno3
        WHERE p2 = ''' || header_p || '''';
  END IF;

  OPEN c FOR select_l;
  FETCH c INTO naziv_p, vlasnikpodatka_p;
  CLOSE c;

END;
FUNCTION VLAS_OIB
 RETURN s_vlasnik.oib%TYPE
 IS
-- IRN 3371
  vlas_oib_l s_vlasnik.oib%TYPE;
BEGIN
  SELECT MIN (oib) INTO vlas_oib_l FROM s_vlasnik;
  RETURN (vlas_oib_l);
END;
FUNCTION DAT_PRESTANKA_PD
 RETURN DATE
 IS
/*
IRN 4079
Datum prestanka slanja prateih dokumenata na fiskalizaciju
ita se iz ZMP parametra 0909 ili se uzima 01.09.2025
*/
  datum_l DATE;
BEGIN
  datum_l := TO_DATE (pra_zmp_zaj.vrijednost_parametra ('0909'), 'DD.MM.RRRR');
  RETURN (datum_l);
EXCEPTION
  WHEN OTHERS THEN
    datum_l := TO_DATE ('01.09.2025', 'DD.MM.RRRR');
    RETURN (datum_l);
END;
FUNCTION DAT_ERAC_OBVEZE
 RETURN DATE
 IS
/*
IRN 4096
Datum uvoenja obveze izdavanja i zaprimanja eRauna.
ita se iz ZMP parametra 0910 ili se uzima 01.01.2026
*/
  datum_l DATE;
BEGIN
  datum_l := TO_DATE (pra_zmp_zaj.vrijednost_parametra ('0910'), 'DD.MM.RRRR');
  RETURN (datum_l);
EXCEPTION
  WHEN OTHERS THEN
    datum_l := TO_DATE ('01.01.2026', 'DD.MM.RRRR');
    RETURN (datum_l);
END;

END PRA_ZMP_S;
/
SHOW ERROR

