-- C:\Radni\pra_zmp.pkb
--
-- Generated for Oracle 10g on Mon Oct 13  15:02:29 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'PRA_ZMP'
CREATE OR REPLACE PACKAGE BODY PRA_ZMP IS

/* pra_zmp */
PROCEDURE PROVJERI_SZURNALA
 (SZUR_ID_NEW_P IN S_SZURNALA.ID%TYPE
 ,SZUR_ID_OLD_P IN S_SZURNALA.ID%TYPE
 ,TYPE_P IN S_SZURNALA.TYPE%TYPE
 )
 IS
--
  br_redaka_l NUMBER := 0;
  type_l s_szurnala.type%TYPE;
BEGIN
  IF szur_id_new_p IS NULL
    OR NVL (szur_id_new_p, 0) = NVL (szur_id_old_p, 0)
  THEN
    RETURN;
  END IF;
  SELECT COUNT (ROWID) INTO br_redaka_l
    FROM s_szurnala
   WHERE szur_id = szur_id_new_p;
  IF br_redaka_l > 0 THEN
    -- Nije doputeno knjienje na sumarnu stavku urnala.
    pra_zmp_zaj.vrati_poruku (-20010);
  END IF;
  SELECT type INTO type_l
    FROM s_szurnala
   WHERE id = szur_id_new_p;
  IF type_l <> type_p THEN
    -- Nije doputeno knjienje na stavku urnala vrste #0.
    pra_zmp_zaj.vrati_poruku (-20027, type_l);
  END IF;
END;
/* PRA_ZMP */
PROCEDURE PROVJERI_REGIJU
 (REG_ID_P IN M_REGIJE.ID%TYPE
 ,ZEM_ID_P IN S_ZEMLJE.ID%TYPE
 )
 IS

ZEM_ID_L S_ZEMLJE.ID%TYPE;
/*
Ako je upisana regija npr. komitenta onda zemlja
regije mora biti jednaka zemlji komitenta.
*/
BEGIN
   IF reg_id_p IS NULL OR zem_id_p IS NULL THEN
      RETURN;
   END IF;
  
   SELECT zem_id INTO zem_id_l
      FROM m_regije
      WHERE id = reg_id_p;

   IF zem_id_p <> zem_id_l THEN
      pra_zmp_zaj.vrati_poruku (-20045);
   END IF;
  
END;
/* PRA_ZMP */
PROCEDURE PROVJERI_POSTU
 (POS_ID_P IN M_POSTE.ID%TYPE
 ,ZEM_ID_P IN S_ZEMLJE.ID%TYPE
 )
 IS

ZEM_ID_L S_ZEMLJE.ID%TYPE;
/*
Ako je upisana pota npr. komitenta onda zemlja pote
mora biti jednaka zemlji komitenta.
*/
BEGIN
   IF pos_id_p IS NULL OR zem_id_p IS NULL THEN
      RETURN;
   END IF;

   SELECT zem_id INTO zem_id_l
      FROM m_poste
      WHERE id = pos_id_p;

   IF zem_id_p <> zem_id_l THEN
      pra_zmp_zaj.vrati_poruku (-20046);
   END IF;
  
END;
/* pra_zmp */
FUNCTION KASA_PRIPADA_OJ
 (GMPKAS_ID_P IN MGMP_KASE.ID%TYPE
 ,OJ_ID_P IN M_OJ.ID%TYPE
 )
 RETURN NUMBER
 IS
/*
Kasa pripada OJ ili nekoj od njoj podreenih OJ
*/
  CURSOR gmpkas_c IS
    SELECT 1
      FROM mgmp_kase
     WHERE id = gmpkas_id_p
       AND zmpojr_id IN (
           SELECT id
             FROM m_oj
            START WITH id = oj_id_p
          CONNECT BY PRIOR id = oj_id);
  br_redaka_l NUMBER(1);
BEGIN
  OPEN gmpkas_c;
  FETCH gmpkas_c INTO br_redaka_l;
  CLOSE gmpkas_c;
  IF br_redaka_l = 1 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;
END;
/* pra_zmp */
FUNCTION VPLAVAL_PRIPADA_IRN
 (VPLAVAL_ID_P IN m_vpla_val.id%TYPE
 )
 RETURN NUMBER
 IS
-- Doputena vrsta plaanja pripada internim raunima
  br_redaka_l NUMBER(1);
BEGIN
  SELECT COUNT (1) 
    INTO br_redaka_l
    FROM m_vpla_val, s_vplacanja
   WHERE m_vpla_val.id = vplaval_id_p
     AND m_vpla_val.vpla_id = s_vplacanja.id
     AND s_vplacanja.ozn_irn IS NOT NULL;
  IF br_redaka_l = 1 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;
END;
/* PRA_ZMP */
PROCEDURE PROVJERI_REGIJU_DOM
 (REG_ID_P IN M_REGIJE.ID%TYPE
 )
 IS

ZEM_ID_L S_ZEMLJE.ID%TYPE;
/*
Regija mora pripadati domaoj zemlji (iz parametra)
*/
BEGIN
  IF reg_id_p IS NULL THEN
    RETURN;
  END IF;
   
  SELECT zem_id INTO zem_id_l 
    FROM m_regije
   WHERE id = reg_id_p;

  IF zem_id_l <> pra_zmp_zaj.domaca_zemlja THEN
    pra_zmp_zaj.vrati_poruku (-20048);
  END IF;
END;
/* PRA_ZMP */
PROCEDURE PROVJERI_POSTU_DOM
 (POS_ID_P IN M_POSTE.ID%TYPE
 )
 IS

ZEM_ID_L S_ZEMLJE.ID%TYPE;
/*
Pota mora pripadati domaoj zemlji (iz parametra)
*/
BEGIN
  IF pos_id_p IS NULL THEN
    RETURN;
  END IF;
   
  SELECT zem_id INTO zem_id_l 
    FROM m_poste
   WHERE id = pos_id_p;

  IF zem_id_l <> pra_zmp_zaj.domaca_zemlja THEN
    pra_zmp_zaj.vrati_poruku (-20049);
  END IF;
END;
/* pra_zmp */
FUNCTION OJ_PRIPADA_OJ
 (OJ_ID_P IN M_OJ.ID%TYPE
 ,OJ1_ID_P IN M_OJ.ID%TYPE
 )
 RETURN NUMBER
 IS

BR_REDAKA_L NUMBER(1);
/*
OJ = OJ1 ili OJ1 je nadreena OJ
*/
BEGIN
  IF oj_id_p = oj1_id_p THEN
		  br_redaka_l := 1;
  ELSE
    /*
    --OJ = OJ1 ili nekoj od njoj podreenih OJ
    SELECT COUNT (ROWID) INTO br_redaka_l
      FROM m_oj
     WHERE m_oj.id = oj_id_p
		  	  AND m_oj.oj_id IN (
                        SELECT id
                          FROM m_oj
                         START WITH id = oj1_id_p
                         CONNECT BY PRIOR id = oj_id);
    */
    SELECT COUNT (ROWID) INTO br_redaka_l
      FROM m_oj
     WHERE m_oj.id = oj1_id_p
     START WITH id = oj_id_p
    CONNECT BY PRIOR oj_id = id;

  END IF;
  
  IF br_redaka_l = 1 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;
END;
/* PRA_ZMP */
PROCEDURE PROVJERI_ZMPSIZV_RAZDOBLJE
 (ZMPSIZV_ID_P IN MZMP_SIZV_SIZV.ZMPSIZV_ID%TYPE
 ,ZMPSIZV1_ID_P IN MZMP_SIZV_SIZV.ZMPSIZV1_ID%TYPE
 )
 IS
/*
Razdoblje vaenja stavke izvjetaja koja slui za izraun (izvorne stavke)
mora biti vee ili jednako razdoblju vaenja stavke izvjetaja koja se
rauna (izvedene stavke).
*/
  CURSOR zmpsizv_c (zmpsizv_id_k mzmp_sizvjestaja.id%TYPE) IS
    SELECT dat_valjan, dat_ponisten
      FROM mzmp_sizvjestaja
     WHERE id = zmpsizv_id_k;
  zmpsizv_c_l    zmpsizv_c%ROWTYPE;
  zmpsizv1_c_l   zmpsizv_c%ROWTYPE;
  dat_poc_null_l DATE := TO_DATE ('01.01.1850', 'DD.MM.RRRR');
  dat_zav_null_l DATE := TO_DATE ('31.12.9999', 'DD.MM.RRRR');
BEGIN
  IF zmpsizv_id_p IS NULL
    OR zmpsizv1_id_p IS NULL
  THEN
    RETURN;
  END IF;
  -- razdoblje vaenja izvedene stavke
  OPEN zmpsizv_c (zmpsizv_id_p);
  FETCH zmpsizv_c INTO zmpsizv_c_l;
  CLOSE zmpsizv_c;
  -- razdoblje vaenja izvorne stavke
  OPEN zmpsizv_c (zmpsizv1_id_p);
  FETCH zmpsizv_c INTO zmpsizv1_c_l;
  CLOSE zmpsizv_c;

  IF NVL (zmpsizv1_c_l.dat_valjan, dat_poc_null_l) > NVL (zmpsizv_c_l.dat_valjan, dat_poc_null_l)
    OR NVL (zmpsizv1_c_l.dat_ponisten, dat_zav_null_l) < NVL (zmpsizv_c_l.dat_ponisten, dat_zav_null_l)
  THEN
    pra_zmp_zaj.vrati_poruku (-20057);
  END IF;
END;
/* PRA_ZMP */
PROCEDURE PROVJERI_ZMPSIZV_OZN_IZVEDENA
 (ZMPSIZV_ID_P IN MZMP_SIZV_SIZV.ZMPSIZV_ID%TYPE
 ,ZMPSIZV_OZN_IZVEDENA_P IN MZMP_SIZVJESTAJA.OZN_IZVEDENA%TYPE
 )
 IS

BR_REDAKA_L NUMBER;
/*
Pravila izrauna mogu se unositi samo za izvedene stavke izvjetaja.
Stavka izvjetaja (u pravilima knjienja) mora biti izvorna.
*/
BEGIN
  IF zmpsizv_id_p IS NULL
    OR zmpsizv_ozn_izvedena_p IS NULL
  THEN
    RETURN;
  END IF;

  SELECT COUNT(ROWID) INTO br_redaka_l
    FROM mzmp_sizvjestaja
   WHERE id = zmpsizv_id_p
     AND ozn_izvedena = zmpsizv_ozn_izvedena_p;
  IF br_redaka_l = 0 THEN
    IF zmpsizv_ozn_izvedena_p IN (-1) THEN
      -- Pravila izrauna mogu se unositi samo za izvedene stavke izvjetaja.
      pra_zmp_zaj.vrati_poruku (-20058);
    ELSIF zmpsizv_ozn_izvedena_p IN (0) THEN
      -- Stavka izvjetaja (u pravilima knjienja) mora biti izvorna.
      pra_zmp_zaj.vrati_poruku (-20059);
    ELSE
      -- Pogrena oznaka stavke izvjetaja.
      pra_zmp_zaj.vrati_poruku (-20060);
    END IF;
  END IF;
END;
/* PRA_ZMP */
PROCEDURE PROVJERI_ZMPSIZV_RAZDOBLJE
 (ZMPSIZV_ID_P IN MZMP_SIZVJESTAJA.ID%TYPE
 ,DATUM_P IN MZMP_SIZVJESTAJA.DAT_PONISTEN%TYPE
 )
 IS
/*
Stavka izvjetaja mora biti valjana.
Datum od kada je stavka izvjetaja valjana mora biti manji ili jednak od datuma npr. plana.
Datum od kada je stavka izvjetaja ponitena, ako je unesen, mora biti vei od datuma npr. plana.
*/
  CURSOR zmpsizv_c IS
    SELECT sifra, dat_valjan, dat_ponisten
      FROM mzmp_sizvjestaja
     WHERE id = zmpsizv_id_p;
  zmpsizv_c_l zmpsizv_c%ROWTYPE;
  dat_zav_null_l DATE := TO_DATE ('31.12.9999', 'DD.MM.RRRR');
BEGIN
  IF zmpsizv_id_p IS NULL
    OR datum_p IS NULL
  THEN
    RETURN;
  END IF;

  OPEN zmpsizv_c;
  FETCH zmpsizv_c INTO zmpsizv_c_l;
  CLOSE zmpsizv_c;

  IF zmpsizv_c_l.sifra IS NOT NULL THEN
    IF datum_p BETWEEN zmpsizv_c_l.dat_valjan AND (NVL (zmpsizv_c_l.dat_ponisten, dat_zav_null_l) - 1)
    THEN
      NULL;
    ELSE
      -- Stavka izvjetaja (#0) valjana je u razdoblju od #1 do #2.
      pra_zmp_zaj.vrati_poruku (
        -20062,
        zmpsizv_c_l.sifra,
        TO_CHAR (zmpsizv_c_l.dat_valjan, 'DD.MM.RRRR'),
        TO_CHAR (NVL (zmpsizv_c_l.dat_ponisten, dat_zav_null_l), 'DD.MM.RRRR'));
    END IF;
  END IF;

END;
PROCEDURE PROVJERI_OZN_IZNOSA_SZUR
 (OZN_IZNOSA_P IN MZMP_SZUR_SIZV.OZN_IZNOSA%TYPE
 ,SZUR_ID_P IN MZMP_SZUR_SIZV.SZUR_ID%TYPE
 )
 IS

BR_REDAKA_L INTEGER;
TYPE_L S_SZURNALA.TYPE%TYPE;
BEGIN
  IF szur_id_p IS NULL OR ozn_iznosa_p IS NULL 
  THEN
     RETURN;
  END IF;
  SELECT COUNT (ROWID) INTO br_redaka_l
    FROM s_szurnala
   WHERE id = szur_id_p;
  IF br_redaka_l = 1 THEN
    SELECT TYPE INTO type_l
      FROM s_szurnala
     WHERE id = szur_id_p;
    IF (type_l = 'N' AND ozn_iznosa_p NOT IN ('1'))
       OR (type_l = 'U' AND ozn_iznosa_p NOT IN ('1', '2', '3'))
    THEN
      pra_zmp_zaj.vrati_poruku (-20063);
    END IF;
  END IF;
END;
/* PRA_ZMP */
FUNCTION VAPLDOK_OZNAKA
 (VAPLDOK_ID_P IN S_VAPLDOK.ID%TYPE
 )
 RETURN s_vapldok.oznaka%TYPE
 IS
CURSOR vapldok_c IS
    SELECT oznaka
      FROM s_vapldok
     WHERE id = vapldok_id_p;
  vapldok_c_l vapldok_c%ROWTYPE;
BEGIN
  OPEN vapldok_c;
  FETCH vapldok_c INTO vapldok_c_l;
  CLOSE vapldok_c;
  RETURN (vapldok_c_l.oznaka);
END;
/* PRA_ZMP */
FUNCTION VDOK_ID
 (VAPLDOK_ID_P IN S_VAPLDOK.ID%TYPE
 )
 RETURN s_vapldok.vdok_id%TYPE
 IS
CURSOR vapldok_c IS
    SELECT vdok_id
      FROM s_vapldok
     WHERE id = vapldok_id_p;
  vapldok_c_l vapldok_c%ROWTYPE;
BEGIN
  OPEN vapldok_c;
  FETCH vapldok_c INTO vapldok_c_l;
  CLOSE vapldok_c;
  RETURN (vapldok_c_l.vdok_id);
END;
PROCEDURE PROVJERI_USLSASPZ_OZN
 (USLSAS_ID_P IN S_USL_SAS.ID%TYPE
 )
 IS
-- Samo jedan poetni sastojak usluge moe biti uobiajen.
   br_redaka_l NUMBER;
BEGIN
  SELECT COUNT(uslsaspz.id) INTO br_redaka_l
    FROM s_usl_sas uslsas,
         s_usl_saspz uslsaspz,
         -- usluga iz poetnog sastojka koji provjeravamo
         (SELECT usl_id FROM s_usl_sas WHERE id = uslsas_id_p) usl
   WHERE uslsaspz.uslsasp_id = uslsas.id
     AND uslsas.usl_id = usl.usl_id
     AND ozn_uobicajen_sasp = -1;

  IF br_redaka_l > 1 THEN
     pra_zmp_zaj.vrati_poruku (-20082);
  END IF;
END;
/* pra_zmp */
PROCEDURE PROVJERI_ZMPPROS_VALJANOST
 (ZMPPROS_ID_P IN mzmp_prostori.id%TYPE
 ,DAT_POC_P IN mzmp_prostori.dat_valjan%TYPE
 ,DAT_ZAV_P IN mzmp_prostori.dat_ponisten%TYPE
 )
 IS
BEGIN
  IF zmppros_id_p IS NULL
    OR dat_poc_p IS NULL
    OR dat_zav_p IS NULL
  THEN
    RETURN;
  END IF;

  FOR c IN (
    SELECT sifra, naziv, dat_valjan, dat_ponisten
      FROM mzmp_prostori
     WHERE id IN (
           -- promatrani prostor i njemu nadreeni prostori
           SELECT id FROM mzmp_prostori START WITH id = zmppros_id_p CONNECT BY PRIOR zmppros_id = id
           )
     ORDER BY zmppros_id, sifra)
  LOOP
    IF NOT (c.dat_valjan <= dat_poc_p AND NVL (c.dat_ponisten, pra_zmp.dat_max_c) > dat_zav_p) THEN
      IF c.dat_ponisten IS NOT NULL THEN
        -- Prostor #0 #1 valjan je od #2 do #3!
        pra_zmp_zaj.vrati_poruku (-20086, c.sifra, c.naziv, TO_CHAR (c.dat_valjan, 'DD.MM.RRRR'), TO_CHAR (c.dat_ponisten, 'DD.MM.RRRR'));
      ELSE
        -- Prostor #0 #1 valjan je od #2!
        pra_zmp_zaj.vrati_poruku (-20090, c.sifra, c.naziv, TO_CHAR (c.dat_valjan, 'DD.MM.RRRR'));
      END IF;
    END IF;
  END LOOP;

END;
/* pra_zmp */
PROCEDURE PROVJERI_ZMPOPR_VALJANOST
 (ZMPOPR_ID_P IN mzmp_oprema.id%TYPE
 ,DAT_POC_P IN mzmp_oprema.dat_valjan%TYPE
 ,DAT_ZAV_P IN mzmp_oprema.dat_ponisten%TYPE
 )
 IS
BEGIN
  IF zmpopr_id_p IS NULL
    OR dat_poc_p IS NULL
    OR dat_zav_p IS NULL
  THEN
    RETURN;
  END IF;

  FOR c IN ( -- jedan redak
    SELECT sifra, naziv, dat_valjan, dat_ponisten
      FROM mzmp_oprema
     WHERE id = zmpopr_id_p)
  LOOP
    IF NOT (c.dat_valjan <= dat_poc_p AND NVL (c.dat_ponisten, pra_zmp.dat_max_c) > dat_zav_p) THEN
      IF c.dat_ponisten IS NOT NULL THEN
        -- Oprema #0 #1 valjana je od #2 do #3!
        pra_zmp_zaj.vrati_poruku (-20091, c.sifra, c.naziv, TO_CHAR (c.dat_valjan, 'DD.MM.RRRR'), TO_CHAR (c.dat_ponisten, 'DD.MM.RRRR'));
      ELSE
        -- Oprema #0 #1 valjana je od #2!
        pra_zmp_zaj.vrati_poruku (-20092, c.sifra, c.naziv, TO_CHAR (c.dat_valjan, 'DD.MM.RRRR'));
      END IF;
    END IF;
  END LOOP;

END;
/* pra_zmp */
PROCEDURE PROVJERI_SLOBODAN_ZMPPROS
 (ZMPPROS_ID_P IN mzmp_prostori.id%TYPE
 ,DAT_VALJAN_P IN mzmp_prostori.dat_valjan%TYPE
 ,DAT_PONISTEN_P IN mzmp_prostori.dat_ponisten%TYPE
 )
 IS
--
  CURSOR recrez2_c IS
    SELECT recrez2.rbr || '-' || oj.sifra || '-' || recrez2.god_poslovna
      FROM trec_rez2_pros recrez2, m_oj oj
     WHERE recrez2.zmpojr_id = oj.id
       AND recrez2.oznaka = 'V'
       AND recrez2.zmppros_id IN (
           -- promatrani prostor i njemu podreeni prostori
           SELECT id FROM mzmp_prostori START WITH id = zmppros_id_p CONNECT BY PRIOR id = zmppros_id)
       AND NOT (recrez2.sat_poc >= dat_valjan_p AND recrez2.sat_zav < NVL (dat_ponisten_p, pra_zmp.dat_max_c))
     ORDER BY recrez2.god_poslovna DESC, oj.sifra, recrez2.rbr DESC;

  CURSOR ponpros_c IS
    SELECT pon.rbr || '-' || pon.god_poslovna
      FROM t_pon_pros ponpros, t_pon_ojr ponojr, t_ponude pon
     WHERE ponpros.ponojr_id = ponojr.id
       AND ponojr.pon_id = pon.id
       AND pon.oznaka NOT IN ('P')
       AND ponpros.zmppros_id IN (
           -- promatrani prostor i njemu podreeni prostori
           SELECT id FROM mzmp_prostori START WITH id = zmppros_id_p CONNECT BY PRIOR id = zmppros_id)
       AND NOT (ponpros.sat_poc >= dat_valjan_p AND ponpros.sat_zav < NVL (dat_ponisten_p, pra_zmp.dat_max_c))
     ORDER BY pon.god_poslovna DESC, pon.rbr DESC;

  CURSOR recodr_c IS
    SELECT TO_CHAR (dat_poc, 'DD.MM.RRRR') || '-' || TO_CHAR (dat_zav, 'DD.MM.RRRR')
      FROM trec_odrzavanje
     WHERE oznaka = 'V' -- IRN 1793
       AND zmppros_id IN (
           -- promatrani prostor i njemu podreeni prostori
           SELECT id FROM mzmp_prostori START WITH id = zmppros_id_p CONNECT BY PRIOR id = zmppros_id)
       AND NOT (dat_poc >= dat_valjan_p AND dat_zav < NVL (dat_ponisten_p, pra_zmp.dat_max_c))
     ORDER BY dat_poc;

  opis_l VARCHAR2(40);
BEGIN

  IF zmppros_id_p IS NULL
    OR dat_valjan_p IS NULL
    -- OR dat_ponisten_p IS NULL
  THEN
    RETURN;
  END IF;

  OPEN recrez2_c;
  FETCH recrez2_c INTO opis_l;
  IF recrez2_c%FOUND THEN
    CLOSE recrez2_c;
    -- Prostor nije slobodan (#0 #1)!
    pra_zmp_zaj.vrati_poruku (-20087, pra_zmp_zaj.poruka ('REC', 'REC_RECREZ2'), opis_l);
  END IF;
  CLOSE recrez2_c;

  OPEN ponpros_c;
  FETCH ponpros_c INTO opis_l;
  IF ponpros_c%FOUND THEN
    CLOSE ponpros_c;
    -- Prostor nije slobodan (#0 #1)!
    pra_zmp_zaj.vrati_poruku (-20087, pra_zmp_zaj.poruka ('REC', 'REC_PON'), opis_l);
  END IF;
  CLOSE ponpros_c;

  OPEN recodr_c;
  FETCH recodr_c INTO opis_l;
  IF recodr_c%FOUND THEN
    CLOSE recodr_c;
    -- Prostor nije slobodan (#0 #1)!
    pra_zmp_zaj.vrati_poruku (-20087, pra_zmp_zaj.poruka ('REC', 'REC_RECODR'), opis_l);
  END IF;
  CLOSE recodr_c;

END;
/* pra_zmp */
PROCEDURE PROVJERI_SLOBODNA_ZMPOPR
 (ZMPOPR_ID_P IN mzmp_oprema.id%TYPE
 ,DAT_VALJAN_P IN mzmp_oprema.dat_valjan%TYPE
 ,DAT_PONISTEN_P IN mzmp_oprema.dat_ponisten%TYPE
 )
 IS
--
  CURSOR recrez2_c IS
    SELECT recrez2.rbr || '-' || oj.sifra || '-' || recrez2.god_poslovna
      FROM trec_rez2_opr recrez2, m_oj oj
     WHERE recrez2.zmpojr_id = oj.id
       AND recrez2.oznaka = 'V'
       AND recrez2.zmpopr_id = zmpopr_id_p
       AND NOT (recrez2.sat_poc >= dat_valjan_p AND recrez2.sat_zav < NVL (dat_ponisten_p, pra_zmp.dat_max_c))
     ORDER BY recrez2.god_poslovna DESC, oj.sifra, recrez2.rbr DESC;

  CURSOR ponopr_c IS
    SELECT pon.rbr || '-' || pon.god_poslovna
      FROM t_pon_opr ponopr, t_pon_ojr ponojr, t_ponude pon
     WHERE ponopr.ponojr_id = ponojr.id
       AND ponojr.pon_id = pon.id
       AND pon.oznaka NOT IN ('P')
       AND ponopr.zmpopr_id = zmpopr_id_p
       AND NOT (ponopr.sat_poc >= dat_valjan_p AND ponopr.sat_zav < NVL (dat_ponisten_p, pra_zmp.dat_max_c))
     ORDER BY pon.god_poslovna DESC, pon.rbr DESC;

  opis_l VARCHAR2(40);
BEGIN

  IF zmpopr_id_p IS NULL
    OR dat_valjan_p IS NULL
    -- OR dat_ponisten_p IS NULL
  THEN
    RETURN;
  END IF;

  OPEN recrez2_c;
  FETCH recrez2_c INTO opis_l;
  IF recrez2_c%FOUND THEN
    CLOSE recrez2_c;
    -- Oprema nije slobodna (#0 #1)!
    pra_zmp_zaj.vrati_poruku (-20088, pra_zmp_zaj.poruka ('REC', 'REC_RECREZ2'), opis_l);
  END IF;
  CLOSE recrez2_c;

  OPEN ponopr_c;
  FETCH ponopr_c INTO opis_l;
  IF ponopr_c%FOUND THEN
    CLOSE ponopr_c;
    -- Oprema nije slobodna (#0 #1)!
    pra_zmp_zaj.vrati_poruku (-20088, pra_zmp_zaj.poruka ('REC', 'REC_PON'), opis_l);
  END IF;
  CLOSE ponopr_c;

END;
/* pra_zmp */
PROCEDURE PROVJERI_CIKLUS_ZMPPROS
 (ID_P IN mzmp_prostori.id%TYPE
 ,ZMPPROS_ID_P IN mzmp_prostori.zmppros_id%TYPE
 )
 IS
--
  zmppros_id_l mzmp_prostori.zmppros_id%TYPE;
BEGIN
  IF id_p IS NULL OR zmppros_id_p IS NULL THEN
    RETURN;
  END IF;
  IF (id_p = zmppros_id_p) THEN
    pra_zmp_zaj.vrati_poruku (-20089);
  ELSE
    zmppros_id_l := zmppros_id_p;
    WHILE zmppros_id_l IS NOT NULL
    LOOP
      SELECT zmppros_id INTO zmppros_id_l
        FROM mzmp_prostori
       WHERE id = zmppros_id_l;
      IF zmppros_id_l = id_p THEN
        pra_zmp_zaj.vrati_poruku (-20089);
      END IF;
    END LOOP;
  END IF;
END;
/* pra_zmp */
FUNCTION CIKLUS_ZMPPROS
 (ID_P IN mzmp_prostori.id%TYPE
 ,ZMPPROS_ID_P IN mzmp_prostori.zmppros_id%TYPE
 )
 RETURN NUMBER
 IS
--
  zmppros_id_l mzmp_prostori.zmppros_id%TYPE;
  nasao_l NUMBER := 0;
BEGIN
  IF (id_p = zmppros_id_p) THEN
    nasao_l := -1;
  ELSE
    zmppros_id_l := zmppros_id_p;
    WHILE nasao_l = 0 AND zmppros_id_l IS NOT NULL
    LOOP
      SELECT zmppros_id INTO zmppros_id_l
        FROM mzmp_prostori
       WHERE id = zmppros_id_l;
      IF zmppros_id_l = id_p THEN
        nasao_l := -1;
      END IF;
    END LOOP;
  END IF;
  RETURN nasao_l;
END;
/* zmp_zaj */
PROCEDURE SALJI_SIMPLE_EMAIL
 (PRIMATELJ_P IN S_PARAMETRI_PRIJEPISA.STAZA%TYPE
 ,PORUKA_P IN VARCHAR2
 ,POSILJATELJ_P IN VARCHAR2 := NULL
 ,SUBJECT_P IN VARCHAR2 := NULL
 )
 IS
smtp_host_l VARCHAR2(80) := pra_zmp_zaj.zmppar_vrijednost('ZMP', '0069');
  smtp_port_l VARCHAR2(5) := pra_zmp_zaj.zmppar_vrijednost('ZMP', '0070');

  c UTL_SMTP.CONNECTION;

  email_l VARCHAR2(50);
  email_string_l VARCHAR2(500) := primatelj_p;
  kraj_l  NUMBER(4);   
  To_string_l VARCHAR2(2000);
  Sender_l VARCHAR2(50);
  
  PROCEDURE send_header (name_p IN VARCHAR2, header_p IN VARCHAR2) IS
    red_l VARCHAR2(2000);
  BEGIN
    red_l := name_p || ': ' || header_p;
    UTL_SMTP.write_raw_data (c, UTL_RAW.cast_to_raw(red_l) );
    UTL_SMTP.write_data( c, UTL_TCP.CRLF);
  END SEND_HEADER;
BEGIN                          
    
  c := UTL_SMTP.open_connection (smtp_host_l, smtp_port_l);
  UTL_SMTP.helo (c, UTL_INADDR.get_host_name);
--  UTL_SMTP.mail (c, NVL(posiljatelj_p, primatelj_p));
  
  kraj_l := LENGTH (email_string_l) + 1;
  WHILE LENGTH (email_string_l) > 0 LOOP
    IF INSTR(email_string_l, ',', 1) > 0 THEN
      kraj_l := INSTR(email_string_l, ',', 1);
    END IF;
    IF INSTR(email_string_l, ';', 1) > 0 THEN
      kraj_l := LEAST(kraj_l, INSTR(email_string_l, ';', 1));
    END IF;
    IF INSTR(email_string_l, ' ', 1) > 0 THEN
      kraj_l := LEAST(kraj_l, INSTR(email_string_l, ' ', 1));
    END IF;
     
    email_l := SUBSTR (email_string_l, 1, kraj_l - 1);

    IF LENGTH(email_l) > 0 AND INSTR(email_l, '@') > 0 THEN
      IF Sender_l IS NULL THEN
        Sender_l := email_l;
        UTL_SMTP.mail (c, NVL(posiljatelj_p, Sender_l));
      END IF;
      UTL_SMTP.rcpt (c, email_l);
      To_string_l := To_string_l || ' ' || email_l;
    END IF;  

    email_string_l := SUBSTR (email_string_l, kraj_l + 1, LENGTH (email_string_l) - kraj_l);
    kraj_l := LENGTH (email_string_l) + 1;
  END LOOP;

  UTL_SMTP.open_data (c);

  -- send_header ('From', NVL(posiljatelj_p, primatelj_p) || ' <' || NVL(posiljatelj_p, primatelj_p) || '>');
  -- send_header ('To', primatelj_p || ' <' || primatelj_p || '>');
  send_header ('From', NVL(posiljatelj_p, Sender_l));
  -- send_header ('To', To_string_l);
  send_header ('Date', to_char(systimestamp, 'Dy, dd Mon yyyy hh24:mi:ss tzhtzm','NLS_DATE_LANGUAGE=American'));
  send_header ('Subject', subject_p);

  UTL_SMTP.write_data(c, UTL_TCP.crlf || poruka_p);
  
  UTL_SMTP.close_data(c);
  UTL_SMTP.quit(c);

EXCEPTION
  WHEN UTL_SMTP.transient_error OR UTL_SMTP.permanent_error THEN
    BEGIN
      UTL_SMTP.quit(c);
    EXCEPTION
      WHEN UTL_SMTP.transient_error OR UTL_SMTP.permanent_error THEN
        NULL; -- Kada nema konekcije na SMTP, quit ce javiti greku koja se ignorira
    END;
    pra_rec_zaj.vrati_poruku(-20519,substr(SQLERRM,1,900));
END;
/* zmp_zaj */
FUNCTION ISKLJUCEN_NEDOSTUP_CVOROVA
 RETURN NUMBER
 IS
br_cvorova_l NUMBER(3);
  cvor_l smet_cvorovi.sifra%TYPE;
  naredba_l VARCHAR2(200);
  mail_adrs_l s_parametri_prijepisa.staza%TYPE;
  isk_cvorovi_l VARCHAR2(500);
BEGIN
  SELECT COUNT(*) 
    INTO br_cvorova_l
    FROM smet_cvorovi;
  IF pra_zmp_zaj.centar = -1 AND br_cvorova_l > 1 THEN
    br_cvorova_l := 0;
    FOR cvor_c IN (
      SELECT sifra
        FROM smet_cvorovi
       WHERE UPPER(sifra) NOT IN ('BKCENTAR', 'PUNTIZELA', 'LULUNA')
         AND UPPER(sifra) <> UPPER(pra_zmp_zaj.tekuci_cvor))
    LOOP
      BEGIN
        naredba_l := 'SELECT sifra_tekuceg_cvora FROM s_vlasnik@' || cvor_c.sifra;
        EXECUTE IMMEDIATE naredba_l INTO cvor_l;
      EXCEPTION
        WHEN OTHERS THEN
          UPDATE smet_cvorovi
             SET ozn_u_mrezi = 0
           WHERE sifra = cvor_c.sifra;
          COMMIT; 
          isk_cvorovi_l := isk_cvorovi_l || ',' || chr(13) || cvor_c.sifra || ' - ' || TO_CHAR(SYSDATE, 'hh24:mi:ss');
          br_cvorova_l := br_cvorova_l + 1;
      END;
    END LOOP;
    IF isk_cvorovi_l IS NOT NULL THEN
      -- send mail
      isk_cvorovi_l := SUBSTR (isk_cvorovi_l, 2, LENGTH (isk_cvorovi_l));
      FOR slu_c IN (
        SELECT DISTINCT email email
          FROM mzmp_sluzbe
         WHERE email IS NOT NULL
           AND ozn_dog = -1)
      LOOP
        salji_simple_email (slu_c.email, 
                            isk_cvorovi_l,
                            slu_c.email, 
                            pra_zmp_zaj.poruka('ZMP', 'ZMP0103'));  -- Nedostupni vorovi iskljueni iz mree
      END LOOP;
    END IF;
  ELSE
    br_cvorova_l := NULL;      
  END IF; 
  
  pra_rec_gen.osvjezi_views;

  RETURN br_cvorova_l;
END;
/* pra_zmp */
PROCEDURE VRATI_VDOK
 (VAPLDOK_ID_P IN S_VAPLDOK.ID%TYPE
 ,DATUM_P IN DATE
 ,VDOK_ID_P IN OUT S_VDOKUMENATA.ID%TYPE
 ,VDOK_SIFRA2N_P IN OUT VARCHAR2
 ,DAT_ERAC_OBVEZE_P IN DATE
 )
 IS
/*
procedura vraa id i sifra2N iz s_vdokumenata za promatrani vapldok_id 
*/
 CURSOR vdok_c IS
  SELECT vapldok.vdok_id, vdok.sifra2N 
    FROM s_vapldok vapldok, s_vdokumenata vdok
   WHERE vapldok.id = vapldok_id_p
     AND vapldok.vdok_id = vdok.id;
     
  vdok_id_l s_vapldok.vdok_id%TYPE;
  vdok_sifra2N_l t_racuni.vdok_sifra2N%TYPE;
BEGIN
  IF vapldok_id_p IS NULL THEN
    RETURN;
  END IF;

  OPEN vdok_c;
  FETCH vdok_c INTO vdok_id_l, vdok_sifra2N_l;
  CLOSE vdok_c;     
  
  -- IRN 4098, Fiskalizacija 2.0
  IF pra_zmp.vapldok_oznaka (vapldok_id_p) IN ('BI', 'BP', 'GI', 'GP') THEN
    IF TRUNC (datum_p) >= dat_erac_obveze_p THEN
       vdok_sifra2N_l := vdok_sifra2N_l||SUBSTR (TO_CHAR (datum_p, 'RRRR'), 3, 2);
    END IF;
  END IF;

  vdok_id_p := vdok_id_l;
  vdok_sifra2N_p := vdok_sifra2N_l;
END;
/* pra_zmp */
FUNCTION OJ_SIFRA
 (OJ_ID_P IN M_OJ.ID%TYPE
 )
 RETURN m_oj.sifra%TYPE
 IS
-- funkcija vraa ifru oj za zadani id
  CURSOR oj_c IS
    SELECT sifra
      FROM m_oj
     WHERE id = oj_id_p;
  oj_sifra_l m_oj.sifra%TYPE;
BEGIN
  IF oj_id_p IS NULL THEN
    RETURN (NULL);
  END IF;
  OPEN oj_c;
  FETCH oj_c INTO oj_sifra_l;
  CLOSE oj_c;
  RETURN (oj_sifra_l);
END;
/* PRA_ZMP */
FUNCTION JE_VDOK_ISPORUKA
 (VDOK_ID_P IN S_VDOKUMENATA.ID%TYPE
 )
 RETURN NUMBER
 IS
-- vraa -1 ako je poslani vdok jednak barem jednom od vdok za isporuke (BI, GI), inae vraa 0
CURSOR vapldok_c IS
    SELECT 1
      FROM s_vapldok
     WHERE oznaka in ('BI', 'GI') AND vdok_id = vdok_id_p;
  nebitno_l VARCHAR2 (1);
  je_vdok_isporuka_l NUMBER;
BEGIN
  OPEN vapldok_c;
  FETCH vapldok_c INTO nebitno_l;
  IF  vapldok_c%FOUND THEN
    je_vdok_isporuka_l := -1;
  ELSE
    je_vdok_isporuka_l := 0;  
  END IF;    
  CLOSE vapldok_c;
  RETURN (je_vdok_isporuka_l);
END;
/* pra_zmp */
FUNCTION VPLA_PRIPADA_IRN
 (VPLA_ID_P IN s_vplacanja.id%TYPE
 )
 RETURN NUMBER
 IS
-- IRN 2872; Vrsta plaanja pripada internim raunima
  br_redaka_l NUMBER(1);
BEGIN
  SELECT COUNT (1) 
    INTO br_redaka_l
    FROM s_vplacanja
   WHERE id = vpla_id_p
     AND ozn_irn IS NOT NULL;
  IF br_redaka_l = 1 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;
END;

END PRA_ZMP;
/
SHOW ERROR

