PROMPT Creating Package Body 'PRA_WSPAY'
CREATE OR REPLACE PACKAGE BODY PRA_WSPAY IS

UNOS_KORISNIK_M CONSTANT VARCHAR2(30) := 'IT_API';

DATA_M CLOB;
ODGOVOR_M CLOB;

PROCEDURE ZAJ_POST
 (RAC_RBR_P IN VARCHAR2
 );


FUNCTION GETSHA512
 (INPUT_P IN VARCHAR2
 )
 RETURN VARCHAR2
 IS
--
  retval_l VARCHAR2(4000);
BEGIN

  EXECUTE IMMEDIATE 'SELECT standard_hash (:string, ''SHA512'') FROM dual' INTO retval_l USING input_p;

  RETURN retval_l;
END;
PROCEDURE ZAJ_POST
 (RAC_RBR_P IN VARCHAR2
 )
 IS
  req_l UTL_HTTP.req;
  res_l UTL_HTTP.resp;
  line_l CLOB;
--
  url_l szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.zmppar_vrijednost('WSPAY', '1001');
BEGIN

  odgovor_m := NULL;

  IF LOWER (url_l) = 'nebitno' THEN
    RETURN;
  END IF;

  pra_pka2.clob_to_table ('[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' || url_l || CHR(10), rac_rbr_p, NULL, 'WSPAY');
  pra_pka2.clob_to_table (CHR(10) || data_m || CHR(10), rac_rbr_p, NULL, 'WSPAY');

  UTL_HTTP.set_detailed_excp_support (enable => true);
  UTL_HTTP.set_body_charset (charset => 'UTF-8');

  req_l := UTL_HTTP.begin_request (url => url_l, method => 'POST', http_version => 'HTTP/1.1');

  UTL_HTTP.set_header (r => req_l, name => 'Content-Type', value => 'application/json; charset=utf-8');
  UTL_HTTP.set_header (req_l, 'Content-Length', pra_pka2.clob_length (data_m));

  UTL_HTTP.write_text (req_l, data_m);

  res_l := UTL_HTTP.get_response (req_l);

  IF res_l.status_code = UTL_HTTP.HTTP_OK THEN
    odgovor_m := NULL;
  ELSE
    pra_zmp_zaj.vrati_poruku (-20000, res_l.status_code || ': ' || res_l.reason_phrase); -- IRN 3322
  END IF;

  BEGIN
    LOOP
      UTL_HTTP.read_line (res_l, line_l);
      odgovor_m := odgovor_m || line_l;
    END LOOP;
    UTL_HTTP.end_response (res_l);
  EXCEPTION
    WHEN UTL_HTTP.end_of_body THEN
      UTL_HTTP.end_response (res_l);
  END;

  pra_pka2.clob_to_table (CHR(10) || odgovor_m || CHR(10), rac_rbr_p, NULL, 'WSPAY');

EXCEPTION
  WHEN OTHERS THEN
    UTL_HTTP.end_response (res_l);
    RAISE; -- IRN 3322
END;
FUNCTION LINK_ZA_PLACANJE
 (RAC_ID_P IN T_RACUNI.ID%TYPE
 )
 RETURN VARCHAR2
 IS
--
  CURSOR data_c IS
    SELECT rac.id             rac_id,
           rac.so_id          rac_so_id,
           so.sifra           rac_so_sifra,
           gost.ime           gost_ime,
           gost.prezime       gost_prezime,
           kgost.email        kgost_email,
           ROUND (rac.iznos * rac.izn_tecaja, 2) AS rac_iznos,
           kgost.br_telefona  kgost_br_telefona,
           kgost.naz_ulice    naz_ulice,
           kgost.naz_mjesta   naz_mjesta,
           zem.naziv          zem_naziv,
           rac.god_poslovna || '-' || rac.rbr || '-' || rac.oj_sifra || '-' || rac.vdok_sifra2n rac_rbr
      FROM t_racuni rac,
           m_so so,
           t_gosti gost,
           t_kgostiju kgost,
           s_zemlje zem
     WHERE rac.id = rac_id_p
       AND so.id = rac.so_id
       AND gost.id = rac.gost_id
       AND kgost.gost_id = gost.id
       AND kgost.oznaka = 'V'
       AND zem.id = kgost.zem_id;
  data_r_l data_c%ROWTYPE;

  orgcode_l mrec_so_sus.sifra%TYPE;
  secretkey_l mrec_auth_sus.sus_username%TYPE;

  blind_iznos_l VARCHAR2 (30);
BEGIN

  OPEN data_c;
  FETCH data_c INTO data_r_l;
  IF data_c%NOTFOUND THEN
    CLOSE data_c;
    RETURN NULL;
  END IF;
  CLOSE data_c;

  IF pra_zmp_s.oznaka ('P0037', data_r_l.rac_so_sifra) = 0 THEN
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  SELECT sifra
    INTO orgcode_l
    FROM mrec_so_sus
   WHERE so_id = data_r_l.rac_so_id
     AND zmpsus_id = (SELECT id
                        FROM szmp_sustavi
                       WHERE sifra = 'WSPAY');

  SELECT sus_password
    INTO secretkey_l
    FROM mrec_auth_sus
   WHERE so_id = data_r_l.rac_so_id
     AND zmpsus_id = (SELECT id
                        FROM szmp_sustavi
                       WHERE sifra = 'WSPAY');

  blind_iznos_l := TRIM (TO_CHAR (data_r_l.rac_iznos * 100, '9999999999999999999999'));

  APEX_JSON.initialize_clob_output;
  APEX_JSON.open_array (); -- [
  APEX_JSON.open_object (); -- {

  APEX_JSON.write ('OrganizationCode', orgcode_l);
  APEX_JSON.write ('ShoppingCartId', data_r_l.rac_id);
  APEX_JSON.write ('Amount', ROUND (data_r_l.rac_iznos, 2)); -- u domaoj valuti
  APEX_JSON.write ('Signature', getSHA512 (secretkey_l || data_r_l.rac_id || data_r_l.rac_id || secretkey_l || blind_iznos_l || secretkey_l));
  APEX_JSON.write ('ValidUntil', TO_CHAR (TRUNC (SYSDATE + 1), 'rrrr-mm-dd hh24:mi:ss'));
  APEX_JSON.write ('AgentCode', '1');
  APEX_JSON.write ('TypeTransaction', '0');
  APEX_JSON.write ('PreferedLanguage', '2');
  APEX_JSON.write ('FirstName', data_r_l.gost_ime);
  APEX_JSON.write ('LastName', data_r_l.gost_prezime);
  APEX_JSON.write ('Email', data_r_l.kgost_email);

  APEX_JSON.write ('Phone', data_r_l.kgost_br_telefona);
  APEX_JSON.write ('Address', data_r_l.naz_ulice);
  APEX_JSON.write ('City', data_r_l.naz_mjesta);
  APEX_JSON.write ('Country', data_r_l.zem_naziv);

  APEX_JSON.write ('Subject', 'Raun za ');

  APEX_JSON.close_object (); -- }
  APEX_JSON.close_array (); -- ]

  data_m := APEX_JSON.get_clob_output;
  APEX_JSON.free_output;

  -- dbms_output.put_line (data_m);

  /*
  [
    {
     "ShoppingCartId": "12346789",
     "LoginUrl": "url za logiranje korisnika"
     "Status": "OK"
    }
  ]
  -- IRN 3322; primjer odgovora od 27.10.2021.
  [
    {
      "Status": 0,
      "ShoppingCartId": "121823199",
      "PaymentUrl": "https://testaminess.wspay.info/EN/OrdinaryUser/PayItem?scid=121823199...",
      "Token": null,
      "TokenNumber": null
    }
  ]
  */

  zaj_post (data_r_l.rac_rbr);

  APEX_JSON.parse (odgovor_m);

  IF APEX_JSON.get_varchar2 (p_path => '[%d].ShoppingCartId', p0 => 1) = TO_CHAR (data_r_l.rac_id) THEN

    IF APEX_JSON.get_number (p_path => '[%d].Status', p0 => 1) = 0 THEN
      -- IRN 3322; -- RETURN APEX_JSON.get_varchar2 (p_path => '[%d].LoginUrl', p0 => 1);
      RETURN APEX_JSON.get_varchar2 (p_path => '[%d].PaymentUrl', p0 => 1); -- IRN 3322

    ELSIF APEX_JSON.get_number (p_path => '[%d].Status', p0 => 1) = 7 THEN
      -- ExistingOrderHasNotExpired
      RETURN '-1';  -- eventualno rekonstruirati url iz loga
    END IF;
  ELSE
    RETURN NULL;
  END IF;

END;
FUNCTION IZNOS_RAC
 (RAC_ID_P IN T_RACUNI.ID%TYPE
 )
 RETURN NUMBER
 IS
--
  CURSOR rac_c IS
    SELECT so.sifra so_sifra,
           ROUND (rac.iznos * rac.izn_tecaja, 2) AS rac_iznos
      FROM t_racuni rac,
           m_so so
     WHERE rac.id = rac_id_p
       AND so.id = rac.so_id;
  rac_r_l rac_c%ROWTYPE;

  retval_l t_racuni.iznos%TYPE;
BEGIN
  OPEN rac_c;
  FETCH rac_c INTO rac_r_l;
  IF rac_c%NOTFOUND THEN
    retval_l := 0;
  ELSE
    retval_l := rac_r_l.rac_iznos;
  END IF;
  CLOSE rac_c;

  IF pra_zmp_s.oznaka ('P0037', rac_r_l.so_sifra) = 0 THEN
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  RETURN retval_l;
END;
PROCEDURE POTVRDI_RAC_CVOR
 (RAC_ID_P IN T_RACUNI.ID%TYPE
 ,PAYTYPE_P IN MZMP_VPLA_SUS.SIFRA%TYPE
 ,IZN_PLACANJA_P IN T_RAC_NAP.IZN_PLACANJA%TYPE
 ,PORUKA_P IN OUT VARCHAR2
 )
 IS
--
  NEPOSTOJECI_RACUN EXCEPTION;
  NEPOSTOJECA_VPLA EXCEPTION;

  CURSOR rac_c IS
    SELECT so.sifra,
           rac.oj_id,
           pkapd.id
      FROM t_racuni rac,
           m_so so,
           (SELECT id, rac_id
              FROM tpka_pdokumenti
             WHERE rac_id = rac_id_p -- tpka_pdokumenti.rac_id je id rauna u pripremi
               AND TRUNC (SYSDATE) < pra_zmp_s.dat_prestanka_pd -- IRN 4079
           ) pkapd
     WHERE rac.id = rac_id_p
       AND so.id = rac.so_id
       AND rac.vapldok_id = (SELECT id
                               FROM s_vapldok
                              WHERE metapl_sifra = 'REC'
                                AND oznaka = 'RP')
       AND pkapd.rac_id (+) = rac.id;

  so_sifra_l m_so.sifra%TYPE;
  oj_id_l    t_racuni.oj_id%TYPE;
  pkapd_id_l tpka_pdokumenti.id%TYPE;

  CURSOR vapldok_c IS
    SELECT id
      FROM s_vapldok
     WHERE metapl_sifra = 'REC'
       AND oznaka = 'GI';
  vapldok_id_l s_vapldok.id%TYPE;

  CURSOR zmpvplasus_c (susvpla_sifra_k mzmp_vpla_sus.sifra%TYPE, oj_id_k m_oj.id%TYPE) IS
    SELECT vplaval.vpla_id, vplaval.val_id -- IRN 3544
      FROM mzmp_vpla_sus zmpvplasus, m_vpla_val vplaval, s_vplacanja vpla
     WHERE zmpvplasus.zmpsus_id = (SELECT id FROM szmp_sustavi WHERE sifra = 'WSPAY')
       AND zmpvplasus.sifra = susvpla_sifra_k
       AND vplaval.vpla_id = zmpvplasus.vpla_id
       AND vplaval.val_id = zmpvplasus.val_id
       AND vplaval.oj_id = oj_id_k
       AND vplaval.val_id = (SELECT id FROM s_valute WHERE sifra_3a = pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0001'))
       AND vpla.id = vplaval.vpla_id
       AND vpla.ozn_got = -1
       AND vpla.ozn_rec = -1; -- IRN 3544
  vpla_id_l m_vpla_val.vpla_id%TYPE;
  val_id_l m_vpla_val.val_id%TYPE;
BEGIN

  OPEN rac_c;
  FETCH rac_c INTO so_sifra_l, oj_id_l, pkapd_id_l;
  IF rac_c%NOTFOUND THEN
    CLOSE rac_c;
    RAISE NEPOSTOJECI_RACUN;
  END IF;
  CLOSE rac_c;

  IF pra_zmp_s.oznaka ('P0037', so_sifra_l) = 0 THEN
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;
  
  OPEN zmpvplasus_c (payType_p, oj_id_l);
  FETCH zmpvplasus_c INTO vpla_id_l, val_id_l; -- IRN 3544
  CLOSE zmpvplasus_c;

  IF vpla_id_l IS NOT NULL AND val_id_l IS NOT NULL THEN

    OPEN vapldok_c;
    FETCH vapldok_c INTO vapldok_id_l;
    CLOSE vapldok_c;

    UPDATE t_racuni
       SET vapldok_id = vapldok_id_l,
           datum = TRUNC (SYSDATE),
           unos_korisnik = unos_korisnik_m,
           unos_dat = SYSDATE,
           pkapd_id = pkapd_id_l
     WHERE id = rac_id_p;

    INSERT INTO t_rac_nap (rac_id, vpla_id, val_id, izn_placanja, izn_tecajat, izn_tecaja) -- IRN 3544
      VALUES (rac_id_p, vpla_id_l, val_id_l, izn_placanja_p, 1, 1); -- IRN 3544

  ELSE
    RAISE NEPOSTOJECA_VPLA;
  END IF;

  poruka_p := 'OK';

EXCEPTION

  WHEN NEPOSTOJECI_RACUN THEN
    poruka_p := 'ne postoji nenaplaeni raun ' || rac_id_p;

  WHEN NEPOSTOJECA_VPLA THEN
    poruka_p := 'ne postoji vrsta plaanja ' || paytype_p;

  WHEN OTHERS THEN
    poruka_p := SQLERRM;

END;
PROCEDURE POTVRDI_RAC
 (METCVOR_SIFRA_P IN VARCHAR2
 ,RAC_ID_P IN T_RACUNI.ID%TYPE
 ,PAYTYPE_P IN MZMP_VPLA_SUS.SIFRA%TYPE
 ,IZN_PLACANJA_P IN T_RAC_NAP.IZN_PLACANJA%TYPE
 ,PORUKA_P IN OUT VARCHAR2
 )
 IS
--
  metcvor_sifra_l m_so.metcvor_sifra%TYPE;
BEGIN

  IF metcvor_sifra_p = pra_zmp_zaj.tekuci_cvor THEN
    metcvor_sifra_l := '';
  ELSE
    metcvor_sifra_l := '@' || metcvor_sifra_p;
  END IF;

  EXECUTE IMMEDIATE 'BEGIN pra_wspay.potvrdi_rac_cvor' || metcvor_sifra_l || ' (:rac_id, :susvpla, :iznos, :poruka); END;'
    USING IN rac_id_p,
          IN PayType_p,
          IN izn_placanja_p,
          IN OUT poruka_p;

  EXECUTE IMMEDIATE 'BEGIN pra_pka_i3fiskal.i3fiskal_rec_racun' || metcvor_sifra_l || ' (:rac_id); END;'
    USING IN rac_id_p;

  COMMIT;

END;

END PRA_WSPAY;
/
SHOW ERROR

