-- C:\Radni\pra_tpka_racuni.pkb
--
-- Generated for Oracle 10g on Fri Dec 19  11:25:17 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'PRA_TPKA_RACUNI'
CREATE OR REPLACE PACKAGE BODY PRA_TPKA_RACUNI IS

PROCEDURE PUNI_IPKA_RAC_PDV
 (PKARAC_ID_P IN TPKA_RACUNI.ID%TYPE
 )
 IS
/*
Upis u izvedenu tablicu ipka_rac_pdv na temelju
redaka u tablicama tpka_rac_isp i tpka_rnk_pdv i tpka_rac_gasizldok.
Upis radi kao da mogu postojati sve tablice stavaka za isti raun.
Odbitke rauna samo na tpka_rac_isp.
IRN 3305
Upis u izvedenu tablicu ipka_rac_pdvg na temelju redaka u tablici tgas_izlazdok_art.
*/
  brojac_l         NUMBER;
  izn_ppot_l       ipka_rac_pdv.izn_domval%TYPE;
  iznos_l          ipka_rac_pdv.iznos%TYPE;
  izn_isp_l        tpka_racuni.iznos%TYPE;
  izn_popusta_l    tpka_racuni.izn_popusta%TYPE;
  izn_provizije_l  tpka_racuni.izn_provizije%TYPE;
  izn_smjesta_l    tpka_racuni.izn_smjesta%TYPE;
  stopa_odbitka_l  NUMBER;
  pkarac_rec_l     tpka_racuni%ROWTYPE;
  stopa_pdv_l      s_vpisporukaz.stopa%TYPE;
  izn_domval_l     ipka_rac_pdv.izn_domval%TYPE;
  izn_racval_l     ipka_rac_pdv.izn_racval%TYPE;
  izn_domval_max_l ipka_rac_pdv.izn_domval%TYPE;
  izn_pkaracpred_l ipka_rac_pdv.izn_domval%TYPE;
  izn_razlike_domval_l ipka_rac_pdv.izn_domval%TYPE;
  izn_razlike_racval_l ipka_rac_pdv.izn_racval%TYPE;
  vpispz_id_l      s_vpisporukaz.id%TYPE;
  izn_pnaknade_l   tpka_rnkasa.izn_pnaknade%TYPE;
  CURSOR pkaracpdv_izn_c (iznos_k ipka_rac_pdv.izn_domval%TYPE) IS
    SELECT vpispz_id
      FROM ipka_rac_pdv
     WHERE pkarac_id = pkarac_id_p
       AND izn_domval = iznos_k;
BEGIN
  IF pkarac_id_p IS NULL THEN
    RETURN;
  END IF;

  SELECT * INTO pkarac_rec_l FROM tpka_racuni WHERE id = pkarac_id_p;

  -- Ako raun ima stavaka u ipka_rac_pdv treba ih obrisati i ponovo kreirati
  SELECT COUNT (1) INTO brojac_l FROM ipka_rac_pdv WHERE pkarac_id = pkarac_id_p;
  IF brojac_l <> 0 THEN
    DELETE FROM ipka_rac_pdv WHERE pkarac_id = pkarac_id_p;
  END IF;

  -- IRN 3305; Ako raun ima stavaka u ipka_rac_pdvg treba ih obrisati i ponovo kreirati
  SELECT COUNT (1) INTO brojac_l FROM ipka_rac_pdvg WHERE pkarac_id = pkarac_id_p;
  IF brojac_l <> 0 THEN
    DELETE FROM ipka_rac_pdvg WHERE pkarac_id = pkarac_id_p;
  END IF;

  -- izraunaj odbitke
  izn_smjesta_l := NVL (pkarac_rec_l.izn_smjesta, 0); -- 31.10.2007. G.J. prebacila na poetak
  SELECT SUM (kolicina * cijena) iznos
    INTO izn_isp_l
    FROM tpka_rac_isp
   WHERE pkarac_id = pkarac_id_p;
  IF pkarac_rec_l.stopa_popusta IS NULL THEN
    izn_popusta_l := NVL (pkarac_rec_l.izn_popusta, 0);
  ELSE
    izn_popusta_l := (izn_isp_l - izn_smjesta_l) * pkarac_rec_l.stopa_popusta / 100;
  END IF;
  IF pkarac_rec_l.stopa_provizije IS NULL THEN
    izn_provizije_l := NVL (pkarac_rec_l.izn_provizije, 0);
  ELSE
    izn_provizije_l := (izn_isp_l - izn_smjesta_l - izn_popusta_l) * pkarac_rec_l.stopa_provizije / 100;
  END IF;
  IF NVL (izn_isp_l, 0) <> 0 THEN
    stopa_odbitka_l := (izn_smjesta_l + izn_popusta_l + izn_provizije_l) / izn_isp_l;
  ELSE
    stopa_odbitka_l := 0;
  END IF;

  -- kreiraj ipka_rac_pdv prema tpka_rac_isp
  FOR pkaracisp_c IN (
    SELECT SUM (kolicina * cijena * pkarac_rec_l.izn_tecaja * (1 - stopa_odbitka_l)) izn_domval,
           SUM (kolicina * cijena * (1 - stopa_odbitka_l)) izn_racval,
           vpispz_id vpispz_id
      FROM tpka_rac_isp
     WHERE pkarac_id = pkarac_id_p
     GROUP BY vpispz_id)
  LOOP
    SELECT stopa INTO stopa_pdv_l
      FROM s_vpisporukaz
     WHERE id = pkaracisp_c.vpispz_id;

    iznos_l := pkaracisp_c.izn_domval * 100 / (100 + stopa_pdv_l);

    INSERT INTO ipka_rac_pdv (
        pkarac_id,
        vpispz_id,
        iznos,
        stopa_pdv,
        izn_domval,
        izn_racval)
      VALUES (
        pkarac_id_p,
        pkaracisp_c.vpispz_id,
        iznos_l,
        stopa_pdv_l,
        ROUND (pkaracisp_c.izn_domval, 2),
        ROUND (pkaracisp_c.izn_racval, 2));
  END LOOP;

  -- auriraj ipka_rac_pdv prema ipka_rnk_pdv
  FOR rnkpdv_c IN (
    SELECT SUM (pkarnkpdv.izn_osnovice) AS iznos_rnk,
           SUM (pkarnkpdv.izn_pdv) AS izn_pdv_rnk,
           pkarnkpdv.vpispz_id AS vpispz_id,
           pkarnkpdv.stopa_pdv AS stopa_pdv
      FROM ipka_rnk_pdv pkarnkpdv,
           tpka_rnkasa pkarnk
     WHERE pkarnkpdv.pkarnk_id = pkarnk.id
       AND pkarnk.pkarac_id = pkarac_id_p
     GROUP BY pkarnkpdv.vpispz_id, pkarnkpdv.stopa_pdv)
  LOOP

    SELECT COUNT (1) INTO brojac_l
      FROM ipka_rac_pdv
     WHERE pkarac_id = pkarac_id_p
       AND vpispz_id = rnkpdv_c.vpispz_id
       AND stopa_pdv = rnkpdv_c.stopa_pdv;

    IF brojac_l = 0 THEN
      INSERT INTO ipka_rac_pdv (
          pkarac_id,
          vpispz_id,
          iznos,
          stopa_pdv,
          izn_domval,
          izn_racval)
        VALUES (
          pkarac_id_p,
          rnkpdv_c.vpispz_id,
          rnkpdv_c.iznos_rnk,
          rnkpdv_c.stopa_pdv,
          rnkpdv_c.iznos_rnk + rnkpdv_c.izn_pdv_rnk,
          ROUND ((rnkpdv_c.iznos_rnk + rnkpdv_c.izn_pdv_rnk) / pkarac_rec_l.izn_tecaja, 2));
    ELSE
      UPDATE ipka_rac_pdv
         SET iznos = iznos + rnkpdv_c.iznos_rnk,
             izn_domval = izn_domval + rnkpdv_c.iznos_rnk + rnkpdv_c.izn_pdv_rnk,
             izn_racval = izn_racval + ROUND ((rnkpdv_c.iznos_rnk + rnkpdv_c.izn_pdv_rnk) / pkarac_rec_l.izn_tecaja, 2)
       WHERE pkarac_id = pkarac_id_p
         AND vpispz_id = rnkpdv_c.vpispz_id;
    END IF;
  END LOOP;

  -- IRN 3305; auriraj ipka_rac_pdvg prema tpka_rac_gasizldok odnosno tgas_izlazdok_art
  FOR pkaracgas_c IN (
    SELECT SUM (gasizldokart.prod_cijena * gasizldokart.kolicina * (1 - gasizldokart.rabat / 100)) AS izn_osnovice,
           gasizldokart.vpispz_id AS vpispz_id,
           gasizldokart.pdv AS stopa_pdv
      FROM tgas_izlazdok_art gasizldokart,
           tpka_rac_gasizldok pkaracgas
     WHERE gasizldokart.gasizldok_id = pkaracgas.gasizldok_id
       AND pkaracgas.pkarac_id = pkarac_id_p
     GROUP BY gasizldokart.vpispz_id, gasizldokart.pdv)
  LOOP

    INSERT INTO ipka_rac_pdvg (
        pkarac_id,
        vpispz_id,
        stopa_pdv,
        izn_osnovice,
        izn_pdv)
      VALUES (
        pkarac_id_p,
        pkaracgas_c.vpispz_id,
        pkaracgas_c.stopa_pdv,
        pkaracgas_c.izn_osnovice,
        ROUND (pkaracgas_c.izn_osnovice * pkaracgas_c.stopa_pdv / 100, 2));

  END LOOP;

  -- IRN 3305; auriraj ipka_rac_pdv prema ipka_rac_pdvg
  FOR racpdvg_c IN (
    SELECT SUM (izn_osnovice) AS iznos_g,
           SUM (izn_pdv) AS izn_pdv_g,
           vpispz_id AS vpispz_id,
           stopa_pdv AS stopa_pdv
      FROM ipka_rac_pdvg
     WHERE pkarac_id = pkarac_id_p
     GROUP BY vpispz_id, stopa_pdv)
  LOOP

    SELECT COUNT (1) INTO brojac_l
      FROM ipka_rac_pdv
     WHERE pkarac_id = pkarac_id_p
       AND vpispz_id = racpdvg_c.vpispz_id
       AND stopa_pdv = racpdvg_c.stopa_pdv;

    IF brojac_l = 0 THEN
      INSERT INTO ipka_rac_pdv (
          pkarac_id,
          vpispz_id,
          iznos,
          stopa_pdv,
          izn_domval,
          izn_racval)
        VALUES (
          pkarac_id_p,
          racpdvg_c.vpispz_id,
          racpdvg_c.iznos_g,
          racpdvg_c.stopa_pdv,
          racpdvg_c.iznos_g + racpdvg_c.izn_pdv_g,
          ROUND ((racpdvg_c.iznos_g + racpdvg_c.izn_pdv_g) / pkarac_rec_l.izn_tecaja, 2));
    ELSE
      UPDATE ipka_rac_pdv
         SET iznos = iznos + racpdvg_c.iznos_g,
             izn_domval = izn_domval + racpdvg_c.iznos_g + racpdvg_c.izn_pdv_g,
             izn_racval = izn_racval + ROUND ((racpdvg_c.iznos_g + racpdvg_c.izn_pdv_g) / pkarac_rec_l.izn_tecaja, 2)
       WHERE pkarac_id = pkarac_id_p
         AND vpispz_id = racpdvg_c.vpispz_id;
    END IF;
  END LOOP;

   -- izraunaj razliku i dodaj je stavci s najveim iznosom
   SELECT SUM (izn_domval), SUM (izn_racval), MAX (izn_domval)
     INTO izn_domval_l, izn_racval_l, izn_domval_max_l
     FROM ipka_rac_pdv
    WHERE pkarac_id = pkarac_id_p;

  SELECT NVL (SUM (izn_ppot), 0), NVL (SUM (izn_pnaknade), 0) INTO izn_ppot_l, izn_pnaknade_l FROM tpka_rnkasa WHERE pkarac_id = pkarac_id_p;

  SELECT NVL (SUM (ROUND (tpka_rac_pred.iznos * tpka_rac_pred.izn_tecaja / pkarac_rec_l.izn_tecaja, 2)), 0)
    INTO izn_pkaracpred_l
    FROM tpka_rac_pred
   WHERE pkarac_id = pkarac_id_p;

  izn_razlike_domval_l :=
    ROUND ((pkarac_rec_l.iznos + izn_pkaracpred_l) * pkarac_rec_l.izn_tecaja, 2) - (izn_domval_l + izn_ppot_l + izn_pnaknade_l);
  izn_razlike_racval_l :=
    (pkarac_rec_l.iznos + izn_pkaracpred_l) - (izn_racval_l + ROUND (izn_ppot_l / pkarac_rec_l.izn_tecaja, 2) + ROUND (izn_pnaknade_l / pkarac_rec_l.izn_tecaja, 2));

  IF izn_razlike_domval_l <> 0
    OR izn_razlike_racval_l <> 0
  THEN
    OPEN pkaracpdv_izn_c (izn_domval_max_l);
    FETCH pkaracpdv_izn_c INTO vpispz_id_l;
    CLOSE pkaracpdv_izn_c;
    UPDATE ipka_rac_pdv
       SET izn_domval = izn_domval + izn_razlike_domval_l,
           izn_racval = izn_racval + izn_razlike_racval_l,
           iznos = (izn_domval + izn_razlike_domval_l) * 100 / (100 + stopa_pdv)
     WHERE pkarac_id = pkarac_id_p
       AND vpispz_id = vpispz_id_l;
  END IF;
END;
PROCEDURE PONISTI_RACUN
 (PKARAC_ID_P IN TPKA_RACUNI.ID%TYPE
 ,FINPRED_ID_P IN NUMBER := NULL
 ,FINPRED_UK_P IN VARCHAR2 := NULL
 )
 IS
-- Poniti PKA raun
  pkarac_p_rec_l tpka_racuni%ROWTYPE;
  pkarac_id_l  tpka_racuni.id%TYPE;
  pkarnk_id_l  tpka_rnkasa.id%TYPE;
  -- IRN 1361
  pkarac_n_rec_l tpka_racuni%ROWTYPE;
  pkaracisp_n_rec_l tpka_rac_isp%ROWTYPE;
  pkaracgas_n_rec_l tpka_rac_gasizldok%ROWTYPE;
  pkarnk_p_rec_l tpka_rnkasa%ROWTYPE;
  pkarnkpdv_p_rec_l ipka_rnk_pdv%ROWTYPE;
  pkarnkisp_p_rec_l tpka_rnk_isp%ROWTYPE;
  pkarnk_n_rec_l tpka_rnkasa%ROWTYPE;
  pkarnkpdv_n_rec_l ipka_rnk_pdv%ROWTYPE;
  pkarnkisp_n_rec_l tpka_rnk_isp%ROWTYPE;
  pkaracpdv_n_rec_l ipka_rac_pdv%ROWTYPE;
  pkaracpdvg_n_rec_l ipka_rac_pdvg%ROWTYPE; -- IRN 3305
  pkaracnap_n_rec_l tpka_rac_nap%ROWTYPE;
  pkaracpred_n_rec_l tpka_rac_pred%ROWTYPE;
BEGIN
  IF pkarac_id_p IS NULL THEN
    RETURN;
  END IF;

  SELECT * INTO pkarac_p_rec_l
    FROM tpka_racuni
   WHERE id = pkarac_id_p;

  -- Trai ID novog rauna sa negativnim stavkama
  pkarac_id_l := pra_pka_zaj.sekvenca (NULL);

  -- Kreiraj raun s oznakom N
  pkarac_n_rec_l := pkarac_p_rec_l;
  pkarac_n_rec_l.id := pkarac_id_l; -- id novog rauna
  pkarac_n_rec_l.pkarac_id := pkarac_id_p; -- id ponitenog rauna
  -- pkarac_n_rec_l.god_poslovna := NVL (pkarac_p_rec_l.god_poslovna_za_n, NULL); -- god_poslovna iz parametra
  pkarac_n_rec_l.god_poslovna := NULL; -- god_poslovna iz datuma
  pkarac_n_rec_l.rbr := NULL; -- novi raun ima novi rbr
  pkarac_n_rec_l.oznaka := 'N';
  pkarac_n_rec_l.datum := NVL (pkarac_p_rec_l.datum_za_n, SYSDATE);
  pkarac_n_rec_l.iznos := pkarac_p_rec_l.iznos * -1; -- mnoi se s -1
  pkarac_n_rec_l.izn_popusta := pkarac_p_rec_l.izn_popusta * -1; -- mnoi se s -1
  pkarac_n_rec_l.izn_provizije := pkarac_p_rec_l.izn_provizije * -1; -- mnoi se s -1
  pkarac_n_rec_l.izn_smjesta := pkarac_p_rec_l.izn_smjesta * -1; -- mnoi se s -1
  pkarac_n_rec_l.finpred_id := finpred_id_p; -- id predujma u fin
  pkarac_n_rec_l.finpred_uk := finpred_uk_p; -- uk predujma u fin
  pkarac_n_rec_l.finpred_id_ponisteni := pkarac_p_rec_l.finpred_id; -- finpred_id_ponisteni - fin id ponitenog predujma
  pkarac_n_rec_l.unos_korisnik := NULL;
  pkarac_n_rec_l.unos_dat := NULL;
  pkarac_n_rec_l.izmjena_korisnik := NULL;
  pkarac_n_rec_l.izmjena_dat := NULL;
  pkarac_n_rec_l.zki := NULL; -- IRN 1847
  pkarac_n_rec_l.jir := NULL;
  /*  IRN 2439
  Ako se radi o SI fiskalizaciji onda kod ponitavanja rauna pretpostavljamo
  da to nije naknadni unos ponitavanja sprovedenog preko paragon bloka i prilikom kreiranja
  N rauna praznimo podatke iz vezane knjige rauna (paragon_*)
  */
  IF pra_pka_i3fiskal.vlas_u_fsus_si (pkarac_n_rec_l.datum) = -1 THEN
    pkarac_n_rec_l.paragon := NULL;
    pkarac_n_rec_l.paragon_set := NULL;
    pkarac_n_rec_l.paragon_serija := NULL;
  END IF;
  pkarac_n_rec_l.vdok_id := NULL;
  pkarac_n_rec_l.oj_sifra := NULL;
  pkarac_n_rec_l.vdok_sifra2N := NULL;
  pkarac_n_rec_l.guid := NULL;

  -- Pratei dokument - zadrava se veza na isti PD
  -- Ako je PD = RNK treba imati na umu da e biti N raun preko PD povezan na izvorni RNK, a da taj RNK nije dijete rauna
  -- (za N raun kreiraju novi retci za RNK; za njih ne postoji PD)
  pkarac_n_rec_l.pkapd_id := pkarac_p_rec_l.pkapd_id;

  INSERT INTO tpka_racuni VALUES pkarac_n_rec_l;

  FOR pkaracisp_c IN (
    SELECT * FROM tpka_rac_isp WHERE pkarac_id = pkarac_id_p)
  LOOP
    -- Kreiraj negativne isporuke rauna sa oznakom N
    pkaracisp_n_rec_l := pkaracisp_c;
    pkaracisp_n_rec_l.id := NULL;
    pkaracisp_n_rec_l.pkarac_id := pkarac_id_l;
    pkaracisp_n_rec_l.kolicina := pkaracisp_c.kolicina * -1; -- mnoi se s -1
    pkaracisp_n_rec_l.unos_korisnik := NULL;
    pkaracisp_n_rec_l.unos_dat := NULL;
    pkaracisp_n_rec_l.izmjena_korisnik := NULL;
    pkaracisp_n_rec_l.izmjena_dat := NULL;
    INSERT INTO tpka_rac_isp VALUES pkaracisp_n_rec_l;
  END LOOP;

  -- Zaraunate otpremnice
  FOR pkaracgas_c IN (
    SELECT * FROM tpka_rac_gasizldok WHERE pkarac_id = pkarac_id_p)
  LOOP
    -- Kreiraj negativne stavke rauna sa oznakom N
    pkaracgas_n_rec_l := pkaracgas_c;
    pkaracgas_n_rec_l.id := NULL;
    pkaracgas_n_rec_l.pkarac_id := pkarac_id_l;
    pkaracgas_n_rec_l.iznos := pkaracgas_c.iznos * -1; -- mnoi se s -1
    pkaracgas_n_rec_l.unos_korisnik := NULL;
    pkaracgas_n_rec_l.unos_dat := NULL;
    pkaracgas_n_rec_l.izmjena_korisnik := NULL;
    pkaracgas_n_rec_l.izmjena_dat := NULL;
    INSERT INTO tpka_rac_gasizldok VALUES pkaracgas_n_rec_l;
  END LOOP;

  -- Interni POS rauni
  FOR pkarnk_c IN (
    SELECT * FROM tpka_rnkasa WHERE pkarac_id = pkarac_id_p)
  LOOP

    -- Skini vezu na poniteni raun
    UPDATE tpka_rnkasa
       SET pkarac_id = NULL
     WHERE id = pkarnk_c.id;

    -- Kreiraj kopije RNK (i njihove stavke) sa vezom na poniteni PKA raun
    pkarnk_id_l := pra_pka_zaj.sekvenca (NULL);

    pkarnk_p_rec_l := pkarnk_c;
    pkarnk_p_rec_l.id := pkarnk_id_l;
    -- pkarnk_p_rec_l.pkarac_id := pkarnk_c.pkarac_id; -- poniteni PKA raun
    pkarnk_p_rec_l.ozn_izvorni := 0;
    pkarnk_p_rec_l.god_poslovna_izvor := TO_CHAR (NULL);
    pkarnk_p_rec_l.gmpkas_id_izvor := NULL;
    pkarnk_p_rec_l.rbr_izvor := TO_CHAR (NULL);
    pkarnk_p_rec_l.unos_korisnik := NULL;
    pkarnk_p_rec_l.unos_dat := NULL;
    pkarnk_p_rec_l.izmjena_korisnik := NULL;
    pkarnk_p_rec_l.izmjena_dat := NULL;
    INSERT INTO tpka_rnkasa VALUES pkarnk_p_rec_l;

    -- stavke poreza RNK
    FOR pkarnkpdv_c IN (
      SELECT * FROM ipka_rnk_pdv WHERE pkarnk_id = pkarnk_c.id)
    LOOP
      pkarnkpdv_p_rec_l := pkarnkpdv_c;
      pkarnkpdv_p_rec_l.id := NULL;
      pkarnkpdv_p_rec_l.pkarnk_id := pkarnk_id_l; -- RNK za koji se kreiraju stavke
      pkarnkpdv_p_rec_l.unos_korisnik := NULL;
      pkarnkpdv_p_rec_l.unos_dat := NULL;
      pkarnkpdv_p_rec_l.izmjena_korisnik := NULL;
      pkarnkpdv_p_rec_l.izmjena_dat := NULL;
      INSERT INTO ipka_rnk_pdv VALUES pkarnkpdv_p_rec_l;
    END LOOP;

    -- stavke isporuka RNK
    FOR pkarnkisp_c IN (
      SELECT * FROM tpka_rnk_isp WHERE pkarnk_id = pkarnk_c.id)
    LOOP
      pkarnkisp_p_rec_l := pkarnkisp_c;
      pkarnkisp_p_rec_l.id := NULL;
      pkarnkisp_p_rec_l.pkarnk_id := pkarnk_id_l; -- RNK za koji se kreiraju stavke
      pkarnkisp_p_rec_l.unos_korisnik := NULL;
      pkarnkisp_p_rec_l.unos_dat := NULL;
      pkarnkisp_p_rec_l.izmjena_korisnik := NULL;
      pkarnkisp_p_rec_l.izmjena_dat := NULL;
      INSERT INTO tpka_rnk_isp VALUES pkarnkisp_p_rec_l;
    END LOOP;

    -- Kreiraj kopije RNK (i njihove stavke) vezane na N raun
    pkarnk_id_l := pra_pka_zaj.sekvenca (NULL);

    pkarnk_n_rec_l := pkarnk_c;
    pkarnk_n_rec_l.id := pkarnk_id_l;
    pkarnk_n_rec_l.pkarac_id := pkarac_id_l; -- negativni PKA raun za koji se kreiraju stavke
    pkarnk_n_rec_l.izn_placanja := pkarnk_c.izn_placanja * -1; -- mnoi se s -1
    pkarnk_n_rec_l.izn_ppot := pkarnk_c.izn_ppot * -1; -- mnoi se s -1
    pkarnk_n_rec_l.ozn_izvorni := 0;
    pkarnk_n_rec_l.god_poslovna_izvor := TO_CHAR (NULL);
    pkarnk_n_rec_l.gmpkas_id_izvor := NULL;
    pkarnk_n_rec_l.rbr_izvor := TO_CHAR (NULL);
    pkarnk_n_rec_l.unos_korisnik := NULL;
    pkarnk_n_rec_l.unos_dat := NULL;
    pkarnk_n_rec_l.izmjena_korisnik := NULL;
    pkarnk_n_rec_l.izmjena_dat := NULL;
    pkarnk_n_rec_l.izn_osnovice_ppot := pkarnk_c.izn_osnovice_ppot * -1; -- IRN 1845
    pkarnk_n_rec_l.izn_popusta := pkarnk_c.izn_popusta * -1; -- IRN 4015
    -- izn_placanja2 -- podrazumijeva se da je NULL
    pkarnk_n_rec_l.izn_pnaknade := pkarnk_c.izn_pnaknade * -1; -- mnoi se s -1
    pkarnk_n_rec_l.izn_napojnice := pkarnk_c.izn_napojnice * -1; -- mnoi se s -1
    pkarnk_n_rec_l.izn_popusta2 := pkarnk_c.izn_popusta2 * -1; -- IRN 4015
    INSERT INTO tpka_rnkasa VALUES pkarnk_n_rec_l;

    -- stavke poreza RNK
    FOR pkarnkpdv_c IN  (
      SELECT * FROM ipka_rnk_pdv WHERE pkarnk_id = pkarnk_c.id)
    LOOP
      pkarnkpdv_n_rec_l := pkarnkpdv_c;
      pkarnkpdv_n_rec_l.id := NULL;
      pkarnkpdv_n_rec_l.pkarnk_id := pkarnk_id_l; -- RNK za koji se kreiraju stavke
      pkarnkpdv_n_rec_l.iznos := pkarnkpdv_c.iznos * -1; -- mnoi se s -1
      pkarnkpdv_n_rec_l.izn_osnovice := pkarnkpdv_c.izn_osnovice * -1; -- mnoi se s -1
      pkarnkpdv_n_rec_l.izn_pdv := pkarnkpdv_c.izn_pdv * -1; -- mnoi se s -1
      pkarnkpdv_n_rec_l.unos_korisnik := NULL;
      pkarnkpdv_n_rec_l.unos_dat := NULL;
      pkarnkpdv_n_rec_l.izmjena_korisnik := NULL;
      pkarnkpdv_n_rec_l.izmjena_dat := NULL;
      INSERT INTO ipka_rnk_pdv VALUES pkarnkpdv_n_rec_l;
    END LOOP;

    -- stavke isporuka RNK
    FOR pkarnkisp_c IN (
      SELECT * FROM tpka_rnk_isp WHERE pkarnk_id = pkarnk_c.id)
    LOOP
      pkarnkisp_n_rec_l := pkarnkisp_c;
      pkarnkisp_n_rec_l.id := NULL;
      pkarnkisp_n_rec_l.pkarnk_id := pkarnk_id_l; -- RNK za koji se kreiraju stavke
      pkarnkisp_n_rec_l.kolicina := pkarnkisp_c.kolicina * -1; -- mnoi se s -1
      pkarnkisp_n_rec_l.izn_pdv := pkarnkisp_c.izn_pdv * -1; -- mnoi se s -1
      pkarnkisp_n_rec_l.izn_ppot := pkarnkisp_c.izn_ppot * -1; -- mnoi se s -1
      pkarnkisp_n_rec_l.unos_korisnik := NULL;
      pkarnkisp_n_rec_l.unos_dat := NULL;
      pkarnkisp_n_rec_l.izmjena_korisnik := NULL;
      pkarnkisp_n_rec_l.izmjena_dat := NULL;
      pkarnkisp_n_rec_l.izn_pnaknade := pkarnkisp_c.izn_pnaknade * -1; -- mnoi se s -1
      INSERT INTO tpka_rnk_isp VALUES pkarnkisp_n_rec_l;
    END LOOP;

  END LOOP;

  -- kreiraj razradu poreza za N raun
  FOR pkaracpdv_c IN (
    SELECT * FROM ipka_rac_pdv WHERE pkarac_id = pkarac_id_p)
  LOOP
    pkaracpdv_n_rec_l := pkaracpdv_c;
    pkaracpdv_n_rec_l.pkarac_id := pkarac_id_l; -- raun za koji se kreiraju stavke
    pkaracpdv_n_rec_l.iznos := pkaracpdv_c.iznos * -1; -- mnoi se s -1
    pkaracpdv_n_rec_l.izn_domval := pkaracpdv_c.izn_domval * -1; -- mnoi se s -1
    pkaracpdv_n_rec_l.izn_racval := pkaracpdv_c.izn_racval * -1; -- mnoi se s -1
    pkaracpdv_n_rec_l.unos_korisnik := NULL;
    pkaracpdv_n_rec_l.unos_dat := NULL;
    pkaracpdv_n_rec_l.izmjena_korisnik := NULL;
    pkaracpdv_n_rec_l.izmjena_dat := NULL;
    INSERT INTO ipka_rac_pdv VALUES pkaracpdv_n_rec_l;
  END LOOP;

  -- IRN 3305; kreiraj razradu poreza po otpremnicama za N raun
  FOR pkaracpdvg_c IN (
    SELECT * FROM ipka_rac_pdvg WHERE pkarac_id = pkarac_id_p)
  LOOP
    pkaracpdvg_n_rec_l := pkaracpdvg_c;
    pkaracpdvg_n_rec_l.id := NULL;
    pkaracpdvg_n_rec_l.pkarac_id := pkarac_id_l; -- raun za koji se kreiraju stavke
    pkaracpdvg_n_rec_l.izn_osnovice := pkaracpdvg_c.izn_osnovice * -1; -- mnoi se s -1
    pkaracpdvg_n_rec_l.izn_pdv := pkaracpdvg_c.izn_pdv * -1; -- mnoi se s -1
    pkaracpdvg_n_rec_l.unos_korisnik := NULL;
    pkaracpdvg_n_rec_l.unos_dat := NULL;
    pkaracpdvg_n_rec_l.izmjena_korisnik := NULL;
    pkaracpdvg_n_rec_l.izmjena_dat := NULL;
    INSERT INTO ipka_rac_pdvg VALUES pkaracpdvg_n_rec_l;
  END LOOP;

  -- vrste plaanja za N raun
  FOR pkaracnap_c IN (
    SELECT * FROM tpka_rac_nap WHERE pkarac_id = pkarac_id_p)
  LOOP
    pkaracnap_n_rec_l := pkaracnap_c;
    pkaracnap_n_rec_l.id := NULL;
    pkaracnap_n_rec_l.pkarac_id := pkarac_id_l; -- raun za koji se kreiraju stavke
    pkaracnap_n_rec_l.iznos := pkaracnap_c.iznos * -1; -- mnoi se s -1
    pkaracnap_n_rec_l.unos_korisnik := NULL;
    pkaracnap_n_rec_l.unos_dat := NULL;
    pkaracnap_n_rec_l.izmjena_korisnik := NULL;
    pkaracnap_n_rec_l.izmjena_dat := NULL;
    INSERT INTO tpka_rac_nap VALUES pkaracnap_n_rec_l;
  END LOOP;

  -- predujmovi za N raun
  FOR pkaracpred_c IN (
    SELECT * FROM tpka_rac_pred WHERE pkarac_id = pkarac_id_p)
  LOOP
    pkaracpred_n_rec_l := pkaracpred_c;
    pkaracpred_n_rec_l.pkarac_id := pkarac_id_l; -- raun za koji se kreiraju stavke
    pkaracpred_n_rec_l.iznos := pkaracpred_c.iznos * -1; -- mnoi se s -1
    pkaracpred_n_rec_l.unos_korisnik := NULL;
    pkaracpred_n_rec_l.unos_dat := NULL;
    pkaracpred_n_rec_l.izmjena_korisnik := NULL;
    pkaracpred_n_rec_l.izmjena_dat := NULL;
    INSERT INTO tpka_rac_pred VALUES pkaracpred_n_rec_l;
  END LOOP;
END;
PROCEDURE PROVJERI_PKAOBR
 (PKARAC_ID_P IN TPKA_RACUNI.ID%TYPE
 ,PKARAC_OZNAKA_P IN TPKA_RACUNI.OZNAKA%TYPE
 )
 IS
-- Ne moe se ponititi PKA raun vezan za valjani obraun.
  br_redaka_l NUMBER;
BEGIN
  IF pkarac_oznaka_p IS NULL
    OR pkarac_id_p IS NULL
  THEN
    RETURN;
  END IF;
  IF pkarac_oznaka_p IN ('P') THEN
    SELECT COUNT (1) INTO br_redaka_l
      FROM tpka_rac_nap, tpka_obr_rac, tpka_obracuni
     WHERE tpka_rac_nap.pkarac_id = pkarac_id_p
       AND tpka_obr_rac.pkaracnap_id = tpka_rac_nap.id
       AND tpka_obr_rac.pkaobr_id = tpka_obracuni.id
       AND tpka_obracuni.oznaka IN ('V');
    IF br_redaka_l > 0 THEN
      pra_pka_zaj.vrati_poruku (-20038);
    END IF;
  END IF;
END;
PROCEDURE VRATI_INFO_U_FIN
 (VAPLDOK_OZNAKA_P IN S_VAPLDOK.OZNAKA%TYPE
 ,VDOK_SIFRA2N_P IN TPKA_RACUNI.VDOK_SIFRA2N%TYPE
 ,RBR_P IN TPKA_RACUNI.RBR%TYPE
 ,GOD_POSLOVNA_P IN TPKA_RACUNI.GOD_POSLOVNA%TYPE
 ,OJ_SIFRA_P IN TPKA_RACUNI.OJ_SIFRA%TYPE
 ,FINPRED_ID_P IN TPKA_RACUNI.FINPRED_ID%TYPE
 ,DATUM_P IN DATE
 ,DAT_ERAC_OBVEZE_P IN DATE
 )
 IS
--
  naredba_l VARCHAR2(200);
  possus_l NUMBER := 0;
  rac_ozn_l VARCHAR2(30);
BEGIN
  -- IRN 4098
  IF TRUNC (datum_p) >= dat_erac_obveze_p THEN
    rac_ozn_l := vdok_sifra2n_p || god_poslovna_p || '-' || oj_sifra_p || '-' || rbr_p;
  ELSE
    rac_ozn_l := vdok_sifra2n_p || '-' || oj_sifra_p || '-' || rbr_p;
  END IF;

  IF UPPER (pra_zmp_zaj.vrijednost_parametra ('0003')) = 'D' THEN
    IF pra_zmp_zaj.possus_na_centru = -1 OR pra_zmp_zaj.possus_na_podcentru = -1 THEN
      possus_l := -1;
    END IF;
  ELSE
    naredba_l := 'SELECT pra_zmp_zaj.possus_na_centru@' || pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0018') || ' FROM dual';
    EXECUTE IMMEDIATE naredba_l INTO possus_l;
    IF possus_l <> -1 THEN
      naredba_l := 'SELECT pra_zmp_zaj.possus_na_podcentru@' || pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0018') || ' FROM dual';
      EXECUTE IMMEDIATE naredba_l INTO possus_l;
    END IF;
  END IF;

  IF vapldok_oznaka_p = 'BP'
    AND rac_ozn_l IS NOT NULL
    AND finpred_id_p IS NOT NULL
    AND possus_l = -1
  THEN
    IF UPPER (pra_zmp_zaj.vrijednost_parametra ('0003')) = 'D' THEN    -- na centru
      naredba_l := 'UPDATE fp_analitikeknjigovodstva'||
                   '   SET brojsadokumenta = :rac_oznaka' ||
                   ' WHERE id = :id';

    ELSIF UPPER (pra_zmp_zaj.vrijednost_parametra ('0003')) = 'N' THEN -- na necentru
      naredba_l := 'UPDATE fp_analitikeknjigovodstva@' || pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0018') ||
                   '   SET brojsadokumenta = :rac_oznaka' ||
                   ' WHERE id = :id';

    END IF;

    EXECUTE IMMEDIATE naredba_l USING rac_ozn_l, finpred_id_p;

  END IF;
END;
PROCEDURE PONISTI_DIO_RACUNA_PRED
 (PKARACD_ID_P IN tpka_racuni.id%TYPE
 ,IZNOS_P IN tpka_racuni.iznos%TYPE
 ,DATUM_P IN tpka_racuni.datum%TYPE
 ,NAPOMENA_P IN tpka_racuni.napomena%TYPE
 ,FINPRED_ID_P IN tpka_racuni.finpred_id%TYPE
 ,FINPRED_UK_P IN tpka_racuni.finpred_uk%TYPE
 ,FINPRED_ID_PONISTENI_P IN tpka_racuni.finpred_id_ponisteni%TYPE
 ,GOD_POSLOVNA_P IN tpka_racuni.god_poslovna%TYPE
 ,RACUN_ROW_P IN tpka_racuni%ROWTYPE
 ,KNJIGA_NA_P IN NUMBER
 ,NEISKORISTENO_P IN NUMBER
 ,RBR_P OUT tpka_racuni.rbr%TYPE
 ,ID_P OUT tpka_racuni.id%TYPE
 ,ID_NEG_P OUT tpka_racuni.id%TYPE
 )
 IS
/*
Poniti dio pka rauna za predujam, poniti dio predujma.
iznos_p iz parametra je pozitivan, kod upisa mnoi se sa -1
*/
  pkarac_row_l     tpka_racuni%ROWTYPE;
  pkarac_row_new_l tpka_racuni%ROWTYPE;
  izn_ostatak_l    NUMBER;
  broj_stavaka_l   NUMBER;
  cijena_l         NUMBER;
  vapldok_oznaka_l s_vapldok.oznaka%TYPE;
  rbr_l            tpka_racuni.rbr%TYPE;
  id_l            tpka_racuni.id%TYPE;
BEGIN
  IF pkaracd_id_p IS NULL OR iznos_p IS NULL THEN
    RETURN;
  END IF;

  SELECT * INTO pkarac_row_l FROM tpka_racuni WHERE id = pkaracd_id_p;

  /*
  Ne moe se djelomino ponititi poniteni (P) niti N raun
  niti raun sa negativnim iznosom.
  (Ne moe se djelomino ponititi raun koji djelomino ponitava drugi raun -
  ugraeno u provjeri predujam)
  */
  IF pkarac_row_l.oznaka IN ('P', 'N') OR pkarac_row_l.iznos < 0 OR iznos_p < 0
  THEN
    pra_pka_zaj.vrati_poruku (-20070);
  END IF;

  /*
  Djelomino poniten raun za predujam u PKA
  mora biti vezan na djelomino poniten raun u FIN
  */
  IF finpred_id_p IS NOT NULL
    AND finpred_id_ponisteni_p IS NOT NULL
    AND pkarac_row_l.finpred_id IS NOT NULL
    AND pkarac_row_l.finpred_id <> finpred_id_ponisteni_p
  THEN
    pra_pka_zaj.vrati_poruku (-20071);
  END IF;

  -- Provjeri oznaku vrste dokumenata
  SELECT oznaka INTO vapldok_oznaka_l
    FROM s_vapldok
   WHERE id = pkarac_row_l.vapldok_id;
  IF vapldok_oznaka_l NOT IN ('BP', 'GP') THEN
    -- Doputeno je djelomino ponititi samo raun za primljeni predujam.
    pra_pka_zaj.vrati_poruku (-20084);
  END IF;

  -- Kreiraj raun s oznakom V i vezom na raun koji djelomino ponitava
  pkarac_row_new_l.id := pra_pka_zaj.sekvenca (NULL); -- ID novog rauna sa negativnim stavkama
  pkarac_row_new_l.oj_id := pkarac_row_l.oj_id;
  pkarac_row_new_l.vapldok_id := pkarac_row_l.vapldok_id;
  pkarac_row_new_l.pkarac_id := NULL; -- id ponitenog rauna ostaje NULL
  pkarac_row_new_l.gmpkom_id := pkarac_row_l.gmpkom_id;
  pkarac_row_new_l.pkaadr_id := pkarac_row_l.pkaadr_id;
  pkarac_row_new_l.val_id := pkarac_row_l.val_id;
  pkarac_row_new_l.vtec_id := pkarac_row_l.vtec_id;
  pkarac_row_new_l.urac_id := pkarac_row_l.urac_id;
  pkarac_row_new_l.vnap_id := pkarac_row_l.vnap_id;
  pkarac_row_new_l.vpknj_id := pkarac_row_l.vpknj_id;
  pkarac_row_new_l.vpdog_id := pkarac_row_l.vpdog_id;
  pkarac_row_new_l.god_poslovna := god_poslovna_p;
  -- rbr -- novi rn ima novi rbr
  pkarac_row_new_l.oznaka := 'V';
  pkarac_row_new_l.ozn_valjanosti := pkarac_row_l.ozn_valjanosti;
  pkarac_row_new_l.datum := datum_p;
  pkarac_row_new_l.dat_nobveze := pkarac_row_l.dat_nobveze;
  pkarac_row_new_l.iznos := iznos_p * -1; -- uneseni iznos mnoi se s -1
  pkarac_row_new_l.izn_tecaja := pkarac_row_l.izn_tecaja; -- teaj ostaje isti
  pkarac_row_new_l.stopa_popusta := NULL; -- ne popunjava se
  pkarac_row_new_l.izn_popusta := NULL; -- ne popunjava se
  pkarac_row_new_l.opis_popusta := NULL; -- ne popunjava se
  pkarac_row_new_l.stopa_provizije := NULL; -- ne popunjava se
  pkarac_row_new_l.izn_provizije := NULL; -- ne popunjava se
  pkarac_row_new_l.opis_provizije := NULL; -- ne popunjava se
  pkarac_row_new_l.br_smjesta := NULL; -- ne popunjava se
  pkarac_row_new_l.izn_smjesta := NULL; -- ne popunjava se
  pkarac_row_new_l.rok_dospijeca := pkarac_row_l.rok_dospijeca;
  pkarac_row_new_l.dat_dospijeca := pkarac_row_l.dat_dospijeca;
  pkarac_row_new_l.stopa_zkamate := pkarac_row_l.stopa_zkamate;
  pkarac_row_new_l.br_modela := pkarac_row_l.br_modela;
  pkarac_row_new_l.poziv_na_broj := pkarac_row_l.poziv_na_broj;
  pkarac_row_new_l.napomena := napomena_p; -- novo unesena napomena
  pkarac_row_new_l.finpred_id := finpred_id_p; -- id predujma u fin
  pkarac_row_new_l.finpred_uk := finpred_uk_p; -- uk predujma u fin
  pkarac_row_new_l.finpred_id_ponisteni := pkarac_row_l.finpred_id; -- finpred_id_ponisteni - fin id ponitenog predujma
  pkarac_row_new_l.naz_platitelja := pkarac_row_l.naz_platitelja;
  pkarac_row_new_l.pkaracd_id := pkaracd_id_p; -- id djelomino ponitenog rauna
  pkarac_row_new_l.ms_id := pkarac_row_l.ms_id;
  pkarac_row_new_l.datum_za_n := NULL;
  -- god_poslovna_za_n
  pkarac_row_new_l.pkakar_id := pkarac_row_l.pkakar_id; -- IRN 2527
  pkarac_row_new_l.guid := NULL;
  -- Pratei dokument - ne zadravamo vezu
  pkarac_row_new_l.pkapd_id := NULL;
  pkarac_row_new_l.izn_tecajat := pkarac_row_l.izn_tecajat; -- IRN 3543; teaj ostaje isti

  INSERT INTO tpka_racuni VALUES pkarac_row_new_l;

  -- Kreiraj negativne stavke isporuka za novi raun u istom odnosu kao prethodne
  SELECT COUNT (1)
    INTO broj_stavaka_l
    FROM tpka_rac_isp
   WHERE pkarac_id = pkaracd_id_p;
  izn_ostatak_l := iznos_p * -1;
  FOR pkaracisp IN (
    SELECT *
      FROM tpka_rac_isp
     WHERE pkarac_id = pkaracd_id_p
     ORDER BY ABS (kolicina * cijena))
  LOOP
    IF broj_stavaka_l = 1 THEN
      cijena_l := izn_ostatak_l / SIGN (pkaracisp.kolicina) * -1;
    ELSE
      cijena_l := pkaracisp.cijena * pkaracisp.kolicina / SIGN (pkaracisp.kolicina)
                  * iznos_p / pkarac_row_l.iznos;
    END IF;
    INSERT INTO tpka_rac_isp (
        pkarac_id,
        vpispz_id,
        rbr,
        naziv,
        kolicina,
        cijena)
      VALUES (
        pkarac_row_new_l.id,
        pkaracisp.vpispz_id,
        pkaracisp.rbr,
        pkaracisp.naziv,
        SIGN (pkaracisp.kolicina) * -1, -- koliina ima obrnuti predznak od koliine u raunu koji se ponitava
        cijena_l);
    broj_stavaka_l := broj_stavaka_l - 1;
    izn_ostatak_l := izn_ostatak_l - SIGN (pkaracisp.kolicina) * -1 * cijena_l;
  END LOOP;

  /*
  Raun za primljeni predujam:
  - nema zaraunate raune sa kasa odnosno nema stavke u tpka_rnkasa,
  - nema zaraunate otpremnice odnosno stavke u tpka_rac_gasizldok,
  - nije plaen predujmom odnosno nema stavke u tpka_rac_pred.
  */

  -- stavke poreza za novi raun
  FOR pkaracpdv_c IN (
    SELECT * FROM ipka_rac_pdv WHERE pkarac_id = pkaracd_id_p)
  LOOP
    INSERT INTO ipka_rac_pdv (
        pkarac_id,
        vpispz_id,
        iznos,
        stopa_pdv,
        izn_domval,
        izn_racval)
      VALUES (
        pkarac_row_new_l.id,  -- raun za koji se kreiraju stavke
        pkaracpdv_c.vpispz_id,
        pkaracpdv_c.iznos * -1 * iznos_p / pkarac_row_l.iznos,         -- mnoi se s -1 i odnosom
        pkaracpdv_c.stopa_pdv,
        pkaracpdv_c.izn_domval * -1 * iznos_p / pkarac_row_l.iznos,    -- mnoi se s -1 i odnosom
        pkaracpdv_c.izn_racval * -1 * iznos_p / pkarac_row_l.iznos);  -- mnoi se s -1 i odnosom
  END LOOP;

  -- stavke plaanja za novi raun
  FOR pkaracnap IN (SELECT * FROM tpka_rac_nap WHERE pkarac_id = pkaracd_id_p)
  LOOP
    INSERT INTO tpka_rac_nap (
        pkarac_id,
        iznos,
        izn_tecaja,
        opis1,
        opis2,
        vpla_id,     -- IRN 3543
        val_id,      -- IRN 3543
        izn_tecajat) -- IRN 3543
      VALUES (
        pkarac_row_new_l.id,  -- raun za koji se kreiraju stavke
        pkaracnap.iznos * -1 * iznos_p / pkarac_row_l.iznos,  -- mnoi se s -1 i odnosom
        pkaracnap.izn_tecaja,
        pkaracnap.opis1,
        pkaracnap.opis2,
        pkaracnap.vpla_id,      -- IRN 3543
        pkaracnap.val_id,       -- IRN 3543
        pkaracnap.izn_tecajat); -- IRN 3543
  END LOOP;

  -- Puni valjani predujam
  IF knjiga_na_p IS NOT NULL THEN
    pra_pka_iud.prebaci_rn_pred_izbor (racun_row_p, knjiga_na_p, neiskoristeno_p, rbr_l, id_l);
    rbr_p := rbr_l;
    id_p := id_l;
  END IF;                         
  
  id_neg_p := pkarac_row_new_l.id;

  COMMIT;
END;
PROCEDURE PROVJERI_GASIZLDOK_STATUS
 (PKARAC_ID_P IN TPKA_RAC_GASIZLDOK.PKARAC_ID%TYPE
 ,GASIZLDOK_ID_P IN TPKA_RAC_GASIZLDOK.GASIZLDOK_ID%TYPE
 )
 IS
-- Ponitena (ili negativna) otpremnica ne moe pripadati valjanom raunu
  pkarac_oznaka_l tpka_racuni.oznaka%TYPE;
  gasizldok_status_l tgas_izlazdok.status%TYPE;
BEGIN
  IF pkarac_id_p IS NULL
    OR gasizldok_id_p IS NULL
  THEN
    RETURN;
  END IF;

  SELECT oznaka INTO pkarac_oznaka_l
    FROM tpka_racuni
   WHERE id = pkarac_id_p;

  SELECT status INTO gasizldok_status_l
    FROM tgas_izlazdok
   WHERE id = gasizldok_id_p;

  IF pkarac_oznaka_l = 'V'
    AND gasizldok_status_l <> 'V'
  THEN
    pra_pka_zaj.vrati_poruku (-20080);
  END IF;
END;
PROCEDURE PROVJERI_GASIZLDOK_VDOK
 (GASIZLDOK_ID_P IN TPKA_RAC_GASIZLDOK.GASIZLDOK_ID%TYPE
 )
 IS
-- Oznaka vrste dokumenata mora biti O = otpremnica ili P = povrat
  gasizldok_ozn_vdokumenta_l tgas_izlazdok.ozn_vdokumenta%TYPE;
BEGIN
  IF gasizldok_id_p IS NULL THEN
    RETURN;
  END IF;

  SELECT ozn_vdokumenta INTO gasizldok_ozn_vdokumenta_l
    FROM tgas_izlazdok
   WHERE id = gasizldok_id_p;

  IF gasizldok_ozn_vdokumenta_l NOT IN ('O', 'P') THEN
    pra_pka_zaj.vrati_poruku (-20082);
  END IF;
END;
PROCEDURE PROVJERI_GASIZLDOK_ZARACUNAT
 (PKARACGAS_ID_P IN TPKA_RAC_GASIZLDOK.ID%TYPE
 ,GASIZLDOK_ID_P IN TPKA_RAC_GASIZLDOK.GASIZLDOK_ID%TYPE
 )
 IS
-- Zaraunata otpremnica ne moe se ponovo zaraunati.
BEGIN
  IF gasizldok_id_p IS NOT NULL
    AND pra_pka_s.gasizldok_zaracunat (pkaracgas_id_p, gasizldok_id_p) = -1
  THEN
    pra_pka_zaj.vrati_poruku (-20081);
  END IF;
END;
PROCEDURE PROVJERI_PKARAC_OZNAKA
 (PKARAC_ID_P IN TPKA_RACUNI.ID%TYPE
 )
 IS
-- Zabrani auriranje stavaka ponitenog rauna
  br_redaka_l NUMBER;
BEGIN
  IF pkarac_id_p IS NULL THEN
    RETURN;
  END IF;
  SELECT COUNT (ROWID) INTO br_redaka_l
    FROM tpka_racuni
   WHERE id = pkarac_id_p
     AND oznaka = 'P';
  IF br_redaka_l > 0 THEN
    -- Poniteni dokument ne moe se mijenjati.
    pra_pka_zaj.vrati_poruku (-20083);
  END IF;
END;
FUNCTION POZIV_NA_BROJ
 (OJ_SIFRA_P IN M_OJ.SIFRA%TYPE
 ,VDOK_SIFRA2N_P IN TPKA_RACUNI.VDOK_SIFRA2N%TYPE
 ,GMPKOM_ID_P IN TPKA_RACUNI.GMPKOM_ID%TYPE
 ,GOD_POSLOVNA_P IN TPKA_RACUNI.GOD_POSLOVNA%TYPE
 ,RBR_P IN TPKA_RACUNI.RBR%TYPE
 )
 RETURN tpka_racuni.poziv_na_broj%TYPE
 IS
-- poziv na broj prema PKA parametru 1042
  poziv_na_broj_l VARCHAR2(2000);
  pkapar_vrijednost_l szmp_parametri.vrijednost%TYPE;
  gmpkom_sifra_l mgmp_komitenti.sifra%TYPE;
BEGIN
  IF oj_sifra_p IS NULL
    OR vdok_sifra2n_p IS NULL
    OR gmpkom_id_p IS NULL
    OR god_poslovna_p IS NULL
    OR rbr_p IS NULL
  THEN
    RETURN (NULL);
  END IF;
  pkapar_vrijednost_l := UPPER (pra_pka_zaj.vrijednost_parametra ('1042'));
  IF pkapar_vrijednost_l IS NULL
    OR pkapar_vrijednost_l = 'NEBITNO'
  THEN
    RETURN (NULL);
  END IF;
  FOR podatak_l IN 1 .. LENGTH (pkapar_vrijednost_l)
  LOOP
    IF (SUBSTR (pkapar_vrijednost_l, podatak_l, 1)) = 'A' THEN
      poziv_na_broj_l := poziv_na_broj_l || vdok_sifra2n_p;        -- IRN 2439
    ELSIF (SUBSTR (pkapar_vrijednost_l, podatak_l, 1)) = 'B' THEN
      poziv_na_broj_l := poziv_na_broj_l || god_poslovna_p;
    ELSIF (SUBSTR (pkapar_vrijednost_l, podatak_l, 1)) = 'C' THEN
      poziv_na_broj_l := poziv_na_broj_l || SUBSTR (rbr_p, 2, 6);
    ELSIF (SUBSTR (pkapar_vrijednost_l, podatak_l, 1)) = 'D' THEN
      poziv_na_broj_l := poziv_na_broj_l || rbr_p;
    ELSIF (SUBSTR (pkapar_vrijednost_l, podatak_l, 1)) = 'E' THEN
      SELECT sifra INTO gmpkom_sifra_l
        FROM mgmp_komitenti
       WHERE id = gmpkom_id_p;
      poziv_na_broj_l := poziv_na_broj_l || SUBSTR (gmpkom_sifra_l, 1, 5);
    ELSIF (SUBSTR (pkapar_vrijednost_l, podatak_l, 1)) = 'F' THEN
      poziv_na_broj_l := poziv_na_broj_l || oj_sifra_p; -- IRN 2439
    ELSIF (SUBSTR (pkapar_vrijednost_l, podatak_l, 1)) = 'G' THEN
      SELECT sifra INTO gmpkom_sifra_l
        FROM mgmp_komitenti
       WHERE id = gmpkom_id_p;
      poziv_na_broj_l := poziv_na_broj_l || gmpkom_sifra_l;
    ELSIF (SUBSTR (pkapar_vrijednost_l, podatak_l, 1)) = 'H' THEN
      poziv_na_broj_l := poziv_na_broj_l || SUBSTR (god_poslovna_p, 4, 1);
    ELSE
      poziv_na_broj_l := poziv_na_broj_l || SUBSTR (pkapar_vrijednost_l, podatak_l, 1);
    END IF;
  END LOOP;
  RETURN (SUBSTR (poziv_na_broj_l, 1, 22));
END;
PROCEDURE PROVJERI_ZMPSIZV_RAZDOBLJE
 (PKARAC_ID_P IN TPKA_RACUNI.ID%TYPE
 ,PKARAC_DATUM_P IN TPKA_RACUNI.DATUM%TYPE
 )
 IS
/*
Datum rauna mora biti
vei ili jednak datumu od kada vrijedi stavka izvjetaja i
manji od datuma od kada je ponitena stavka izvjetaja.
*/
BEGIN
  IF pkarac_id_p IS NULL
    OR pkarac_datum_p IS NULL
  THEN
    RETURN;
  END IF;
  FOR pkaracisp_c IN (
    SELECT zmpsizv_id
      FROM tpka_rac_isp
     WHERE pkarac_id = pkarac_id_p)
  LOOP
    pra_zmp.provjeri_zmpsizv_razdoblje (
      pkaracisp_c.zmpsizv_id,
      pkarac_datum_p);
  END LOOP;
END;
PROCEDURE PROVJERI_ZMPSIZV
 (PKARAC_ID_P IN TPKA_RAC_ISP.PKARAC_ID%TYPE
 ,ZMPSIZV_ID_P IN TPKA_RAC_ISP.ZMPSIZV_ID%TYPE
 )
 IS
--
  datum_l tpka_racuni.datum%TYPE;
  vapldok_oznaka_l s_vapldok.oznaka%TYPE;
  br_redaka_l NUMBER;
BEGIN
  IF pkarac_id_p IS NULL THEN
    RETURN;
  END IF;

  SELECT datum, pra_zmp.vapldok_oznaka (vapldok_id)
    INTO datum_l, vapldok_oznaka_l
    FROM tpka_racuni
   WHERE id = pkarac_id_p;
  IF vapldok_oznaka_l IN ('BP', 'GP') THEN
    RETURN;
  END IF;

  IF zmpsizv_id_p IS NULL THEN
    -- Stavka izvjetaja je obvezan podatak!
    pra_pka_zaj.vrati_poruku (-20092);
  END IF;

  pra_zmp.provjeri_zmpsizv_razdoblje (zmpsizv_id_p, datum_l);

  pra_zmp.provjeri_zmpsizv_ozn_izvedena (zmpsizv_id_p, 0);

  SELECT COUNT (ROWID) INTO br_redaka_l
    FROM mzmp_sizvjestaja
   WHERE id = zmpsizv_id_p
     AND sifra IN (
         -- 0049 ifra stavke izvjetaja za knjienje RNK
         pra_pka_zaj.vrijednost_parametra ('0049'),
         -- 0050 ifra stavke izvjetaja za knjienje RNK drugih OJ
         pra_pka_zaj.vrijednost_parametra ('0050'),
         -- 0051 ifra stavke izvjetaja za knjienje otpremnica
         pra_pka_zaj.vrijednost_parametra ('0051'),
         -- 0052 ifra stavke izvjetaja za knjienje razlike zbog zaokruivanja na strani usluga.
         pra_pka_zaj.vrijednost_parametra ('0052'),
         -- 0053 ifra stavke izvjetaja za knjienje razlike zbog zaokruivanja na strani naplate.
         pra_pka_zaj.vrijednost_parametra ('0053')
         );
  IF br_redaka_l > 0 THEN
    -- Provjerite vrijednost ZMP parametara od 0049 do 0053!
    pra_pka_zaj.vrati_poruku (-20090);
  END IF;

END;
PROCEDURE PROVJERI_PKARAC_DATUM
 (VAPLDOK_ID_P IN tpka_racuni.vapldok_id%TYPE
 ,DATUM_NEW_P IN tpka_racuni.datum%TYPE
 ,DATUM_OLD_P IN tpka_racuni.datum%TYPE
 )
 IS
-- IRN 1847
  oznaka_l s_vapldok.oznaka%TYPE;
BEGIN
  IF vapldok_id_p IS NULL OR datum_new_p IS NULL THEN
    RETURN;
  END IF;
  SELECT oznaka INTO oznaka_l FROM s_vapldok WHERE id = vapldok_id_p;
  IF oznaka_l IN ('GI', 'GP') THEN
    IF INSERTING AND datum_new_p <> TRUNC (SYSDATE) THEN
      -- Datum gotovinskog rauna ne moe biti razliit od tekueg!
      pra_rec_zaj.vrati_poruku (-20576);
    ELSIF UPDATING AND datum_new_p <> datum_old_p THEN
      -- Datum gotovinskog rauna ne moe se mijenjati!
      pra_rec_zaj.vrati_poruku (-20577);
    END IF;
  END IF;
END;
PROCEDURE ZABRANI_IZMJENU_PKARAC
 (OZNAKA_P IN tpka_racuni.oznaka%TYPE
 )
 IS
-- IRN 1847; za P i N raune doputena je promjena samo stupaca jir i zki
-- IRN 1926; za P i N raune doputena takoer promjena stupaca finpred_id i finpred_uk
BEGIN
  IF oznaka_p IS NULL THEN
    RETURN;
  END IF;
  IF oznaka_p NOT IN ('P', 'N') THEN
    RETURN;
  END IF;
  IF UPDATING ('jir') OR UPDATING ('zki') OR UPDATING ('finpred_id') OR UPDATING ('finpred_uk') THEN
    -- provjeri je li se mijenjao jo koji stupac
    FOR c IN (
      SELECT column_name
        FROM user_tab_columns
       WHERE table_name = 'TPKA_RACUNI'
         AND column_name NOT IN ('JIR', 'ZKI', 'FINPRED_ID', 'FINPRED_UK')
       ORDER BY column_id)
    LOOP
      IF UPDATING (c.column_name) THEN
        -- Poniteni raun ne moe se mijenjati.
        pra_rec_zaj.vrati_poruku (-20061);
      END IF;
    END LOOP;
  ELSE
    -- Poniteni raun ne moe se mijenjati.
    pra_rec_zaj.vrati_poruku (-20061);
  END IF;
END;
PROCEDURE IZRADI_ISKORISTENI_PREDUJAM
 (PKARACD_ID_P IN tpka_racuni.pkaracd_id%TYPE
 ,RACI_ID_P IN tpka_racuni.raci_id%TYPE
 ,PKARACI_ID_P IN tpka_racuni.pkaraci_id%TYPE
 ,IZNOS_P IN tpka_racuni.iznos%TYPE
 ,DATUM_P IN tpka_racuni.datum%TYPE
 )
 IS
/*
Kreiraj raun za iskoriteni predujam
iznos_p iz parametra je pozitivan, kod upisa mnoi se sa -1
*/
  pkarac_row_izv_l tpka_racuni%ROWTYPE;
  pkarac_row_new_l tpka_racuni%ROWTYPE; -- IRN 3543
  izn_ostatak_l NUMBER;
  broj_stavaka_l NUMBER;
  cijena_l NUMBER;
  cijena_new_l NUMBER;   -- IRN 4096
  kolicina_new_l NUMBER; -- IRN 4096
  vapldok_oznaka_l s_vapldok.oznaka%TYPE;
  vpla_id_l        s_vplacanja.id%TYPE; -- IRN 3543
  izn_domval_l     ipka_rac_pdv.izn_domval%TYPE;
  izn_racval_l     ipka_rac_pdv.izn_racval%TYPE;
  izn_domval_max_l ipka_rac_pdv.izn_domval%TYPE;
  izn_razlike_domval_l ipka_rac_pdv.izn_domval%TYPE;
  izn_razlike_racval_l ipka_rac_pdv.izn_racval%TYPE;
  vpispz_id_l      s_vpisporukaz.id%TYPE;
  CURSOR pkaracpdv_izn_c (pkarac_id_k ipka_rac_pdv.pkarac_id%TYPE, iznos_k ipka_rac_pdv.izn_domval%TYPE) IS
    SELECT vpispz_id
      FROM ipka_rac_pdv
     WHERE pkarac_id = pkarac_id_k
       AND izn_domval = iznos_k;
  rac_vapldok_oznaka_l s_vapldok.oznaka%TYPE; -- IRN 3184
BEGIN
  IF pkaracd_id_p IS NULL OR (raci_id_p IS NULL AND pkaraci_id_p IS NULL) OR iznos_p IS NULL THEN
    RETURN;
  END IF;

  /*
  IRN 3184
  raun za iskoriteni predujam ne treba izraditi
  ako se predujam iskoritava na raunu u pripremi (RP)
  */
  IF raci_id_p IS NOT NULL THEN
    SELECT vapldok.oznaka
      INTO rac_vapldok_oznaka_l
      FROM t_racuni rac,
           s_vapldok vapldok
     WHERE rac.id = raci_id_p
       AND rac.vapldok_id = vapldok.id;
    IF rac_vapldok_oznaka_l = 'RP' THEN
      RETURN;
    END IF;
  END IF;

  SELECT * INTO pkarac_row_izv_l
    FROM tpka_racuni
   WHERE id = pkaracd_id_p;
  /*
  Ne moe se iskoristiti poniteni (P) niti N raun
   (Ne moe se djelomino ponititi raun koji djelomino ponitava drugi raun -
  ugraeno u provjeri predujam)
  */
  IF pkarac_row_izv_l.oznaka IN ('P', 'N')
  THEN
    -- Ne moe se iskoristiti niti djelomino ponititi poniteni (P) niti N raun niti raun s negativnim iznosom.
    pra_pka_zaj.vrati_poruku (-20070);
  END IF;

  -- Provjeri oznaku vrste dokumenata
  SELECT oznaka INTO vapldok_oznaka_l
    FROM s_vapldok
   WHERE id = pkarac_row_izv_l.vapldok_id;
  IF vapldok_oznaka_l NOT IN ('BP', 'GP') THEN
    -- Doputeno je iskoristiti samo raun za primljeni predujam.
    pra_pka_zaj.vrati_poruku (-20084);
  END IF;

  /*
  Kreiraj raun s oznakom V,
  vezom na PKA raun za primljeni predujam koji se iskoritava
  i REC ili PKA raun na kojem se iskoritava
  */
  pkarac_row_new_l.id := pra_pka_zaj.sekvenca (NULL); -- id novog rauna
  pkarac_row_new_l.oj_id := pkarac_row_izv_l.oj_id;
  pkarac_row_new_l.vapldok_id := pkarac_row_izv_l.vapldok_id;
  pkarac_row_new_l.pkarac_id := NULL; -- id ponitenog rauna - ostaje NULL
  pkarac_row_new_l.gmpkom_id := pkarac_row_izv_l.gmpkom_id;
  pkarac_row_new_l.pkaadr_id := pkarac_row_izv_l.pkaadr_id;
  pkarac_row_new_l.val_id := pkarac_row_izv_l.val_id;
  pkarac_row_new_l.vtec_id := pkarac_row_izv_l.vtec_id;
  pkarac_row_new_l.urac_id := pkarac_row_izv_l.urac_id;
  pkarac_row_new_l.vnap_id := pkarac_row_izv_l.vnap_id;
  pkarac_row_new_l.vpknj_id := pkarac_row_izv_l.vpknj_id;
  pkarac_row_new_l.vpdog_id := pkarac_row_izv_l.vpdog_id;
  pkarac_row_new_l.god_poslovna := NULL;
  pkarac_row_new_l.rbr := NULL; -- novi raun ima novi rbr
  pkarac_row_new_l.oznaka := 'V';
  pkarac_row_new_l.ozn_valjanosti := pkarac_row_izv_l.ozn_valjanosti;
  pkarac_row_new_l.datum := datum_p;
  pkarac_row_new_l.dat_nobveze := datum_p;
  pkarac_row_new_l.iznos := iznos_p * -1; -- uneseni iznos mnoi se s -1
  pkarac_row_new_l.izn_tecaja := pkarac_row_izv_l.izn_tecaja;
  pkarac_row_new_l.stopa_popusta := NULL;
  pkarac_row_new_l.izn_popusta := NULL;
  pkarac_row_new_l.opis_popusta := NULL;
  pkarac_row_new_l.stopa_provizije := NULL;
  pkarac_row_new_l.izn_provizije := NULL;
  pkarac_row_new_l.opis_provizije := NULL;
  pkarac_row_new_l.br_smjesta := NULL;
  pkarac_row_new_l.izn_smjesta := NULL;
  pkarac_row_new_l.rok_dospijeca := NULL;
  pkarac_row_new_l.dat_dospijeca := NULL;
  pkarac_row_new_l.stopa_zkamate := NULL;
  pkarac_row_new_l.br_modela := NULL;
  pkarac_row_new_l.poziv_na_broj := NULL;
  pkarac_row_new_l.napomena := NULL;
  pkarac_row_new_l.finpred_id := TO_NUMBER (NULL);
  pkarac_row_new_l.finpred_uk := NULL;
  pkarac_row_new_l.finpred_id_ponisteni := TO_NUMBER (NULL);
  pkarac_row_new_l.naz_platitelja := pkarac_row_izv_l.naz_platitelja;
  pkarac_row_new_l.pkaracd_id  := pkaracd_id_p; -- id djelomino ponitenog rauna
  pkarac_row_new_l.ms_id := pkarac_row_izv_l.ms_id;
  pkarac_row_new_l.datum_za_n := NULL;
  pkarac_row_new_l.zki := NULL;
  pkarac_row_new_l.jir := NULL;
  pkarac_row_new_l.paragon := NULL;
  pkarac_row_new_l.raci_id := racI_id_p;
  pkarac_row_new_l.pkaraci_id := pkaracI_id_p;
  pkarac_row_new_l.vdok_id := NULL;
  pkarac_row_new_l.paragon_set := NULL;
  pkarac_row_new_l.paragon_serija := NULL;
  pkarac_row_new_l.oj_sifra := NULL;
  pkarac_row_new_l.vdok_sifra2N := NULL;
  pkarac_row_new_l.guid := NULL;
  pkarac_row_new_l.pkapd_id := NULL; -- kod iskoritavanja ne zadravamo vezu na PD
  pkarac_row_new_l.izn_tecajat := pkarac_row_izv_l.izn_tecajat; -- IRN 3543
  INSERT INTO tpka_racuni VALUES pkarac_row_new_l;

  -- Kreiraj negativne isporuke za novi raun u istom odnosu kao prethodne
  SELECT COUNT (1)
    INTO broj_stavaka_l
    FROM tpka_rac_isp
   WHERE pkarac_id = pkaracd_id_p;
  izn_ostatak_l := iznos_p * -1;
  FOR pkaracisp IN (
    SELECT *
      FROM tpka_rac_isp
     WHERE pkarac_id = pkaracd_id_p
     ORDER BY ABS (kolicina * cijena)
    )
  LOOP
    IF broj_stavaka_l = 1 THEN
      cijena_l := izn_ostatak_l / SIGN (pkaracisp.kolicina) * -1;
    ELSE
      cijena_l := pkaracisp.cijena * pkaracisp.kolicina / SIGN (pkaracisp.kolicina)
                  * iznos_p / pkarac_row_izv_l.iznos;
    END IF;

    -- IRN 4096
    kolicina_new_l := SIGN (pkaracisp.kolicina) * -1; -- koliina = 1 ali s obrnutim predznakom od koliine u raunu koji se ponitava
    cijena_new_l := cijena_l;
    IF cijena_new_l < 0 THEN
      -- [BR-27]-Neto (jedinina) cijena artikla (BT-146) nee biti negativna.
      kolicina_new_l := kolicina_new_l * -1;
      cijena_new_l := cijena_new_l * -1;
    END IF;
    -- KRAJ IRN 4096

    INSERT INTO tpka_rac_isp (
        pkarac_id,
        vpispz_id,
        rbr,
        naziv,
        kolicina,
        cijena)
      VALUES (
        pkarac_row_new_l.id,
        pkaracisp.vpispz_id,
        pkaracisp.rbr,
        pkaracisp.naziv,
        kolicina_new_l, -- IRN 4096
        cijena_new_l);  -- IRN 4096
    broj_stavaka_l := broj_stavaka_l - 1;
    izn_ostatak_l := izn_ostatak_l - SIGN (pkaracisp.kolicina) * -1 * cijena_l;
  END LOOP;

  /*
  Raun za primljeni predujam:
  - nema zaraunate raune sa kasa odnosno nema stavke u tpka_rnkasa,
  - nema zaraunate otpremnice odnosno stavke u tpka_rac_gasizldok,
  - nije plaen predujmom odnosno nema stavke u tpka_rac_pred.
  */

  -- ifra vrste plaanja "iskoriteni predujam".
  SELECT MIN (id) INTO vpla_id_l FROM s_vplacanja WHERE sifra = pra_zmp_zaj.vrijednost_parametra ('0061');
  INSERT INTO tpka_rac_nap (
      pkarac_id,
      iznos,
      izn_tecaja,
      vpla_id,     -- IRN 3543
      val_id,      -- IRN 3543
      izn_tecajat) -- IRN 3543
    VALUES (
      pkarac_row_new_l.id,           -- raun za koji se kreiraju stavke
      iznos_p * -1,                  -- mnoi se s -1
      pkarac_row_izv_l.izn_tecaja,
      vpla_id_l,                     -- IRN 3543
      pkarac_row_izv_l.val_id,       -- IRN 3543
      pkarac_row_izv_l.izn_tecajat); -- IRN 3543

  /*
  razrada poreza za novi raun se takoer radi prema prethodnim stavkama u odnosu iskoriteno/primljeno
  ako bi se koristila uobiajena procedura puni_ipka_rac_pdv preko isporuka koje su ve zaokruene dolo bi do sitnih razlika
  */

  FOR pkaracpdv_c IN (
    SELECT * FROM ipka_rac_pdv WHERE pkarac_id = pkaracd_id_p)
  LOOP
    INSERT INTO ipka_rac_pdv (
        pkarac_id,
        vpispz_id,
        iznos,
        stopa_pdv,
        izn_domval,
        izn_racval)
      VALUES (
        pkarac_row_new_l.id,  -- raun za koji se kreiraju stavke
        pkaracpdv_c.vpispz_id,
        pkaracpdv_c.iznos * -1 * iznos_p / pkarac_row_izv_l.iznos,        -- mnoi se s -1 i odnosom
        pkaracpdv_c.stopa_pdv,
        pkaracpdv_c.izn_domval * -1 * iznos_p / pkarac_row_izv_l.iznos,   -- mnoi se s -1 i odnosom
        pkaracpdv_c.izn_racval * -1 * iznos_p / pkarac_row_izv_l.iznos);  -- mnoi se s -1 i odnosom
  END LOOP;

   -- izraunaj razliku i dodaj je stavci s najveim iznosom
   SELECT SUM (izn_domval), SUM (izn_racval), MAX (izn_domval)
     INTO izn_domval_l, izn_racval_l, izn_domval_max_l
     FROM ipka_rac_pdv
    WHERE pkarac_id = pkarac_row_new_l.id;

  izn_razlike_domval_l := ROUND (iznos_p * -1 * pkarac_row_izv_l.izn_tecaja, 2) - izn_domval_l;
  izn_razlike_racval_l := iznos_p * -1 - izn_racval_l;

  IF izn_razlike_domval_l <> 0
    OR izn_razlike_racval_l <> 0
  THEN
    OPEN pkaracpdv_izn_c (pkarac_row_new_l.id,izn_domval_max_l);
    FETCH pkaracpdv_izn_c INTO vpispz_id_l;
    CLOSE pkaracpdv_izn_c;
    UPDATE ipka_rac_pdv
       SET izn_domval = izn_domval + izn_razlike_domval_l,
           izn_racval = izn_racval + izn_razlike_racval_l,
           iznos = (izn_domval + izn_razlike_domval_l) * 100 / (100 + stopa_pdv)
     WHERE pkarac_id = pkarac_row_new_l.id
       AND vpispz_id = vpispz_id_l;
  END IF;

END;
PROCEDURE PROVJERI_ISKORISTENI_PREDUJAM
 (PKARACD_ID_P IN tpka_racuni.pkaracd_id%TYPE
 ,RACI_ID_P IN tpka_racuni.raci_id%TYPE
 ,PKARACI_ID_P IN tpka_racuni.pkaraci_id%TYPE
 )
 IS
-- (Isti) Predujam se moe na (istom) raunu iskoristiti samo jednom (pkaracp_id + (pka)rac_id = UK)
  br_redaka_l NUMBER;
BEGIN
  IF pkaracd_id_p IS NULL OR (raci_id_p IS NULL AND pkaraci_id_p IS NULL) THEN
    RETURN;
  END IF;
  SELECT COUNT (ROWID) INTO br_redaka_l
    FROM tpka_racuni
   WHERE pkaracd_id_p = pkaracd_id
     AND NVL (raci_id_p, 0) = NVL (raci_id, 0)
     AND NVL (pkaraci_id_p, 0) = NVL (pkaraci_id, 0);
  IF br_redaka_l > 1 THEN
    -- Predujam se moe na istom raunu iskoristiti samo jednom.
    pra_pka_zaj.vrati_poruku (-20118);
  END IF;
END;
PROCEDURE PROVJERI_PREDUJAM
 (PKARAC_ID_P IN tpka_racuni.id%TYPE
 ,PKARACD_ID_P IN tpka_racuni.pkaracd_id%TYPE
 )
 IS
/*
IRN 2026
Iznos iskoritenog predujma ne moe biti vei od iznosa primljenog predujma.
Ne moe se djelomino ponititi predujam koji djelomino ponitava drugi predujam.
Procedura ita tpka_racuni (u pra_pka.izn_primljenog_predujma)
pa se ne moe koristiti u R trigerima na tpka_racuni.
*/
  pkarac_id_l tpka_racuni.id%TYPE;
  pkaracd_id_originala_l tpka_racuni.id%TYPE;
BEGIN
  IF pkarac_id_p IS NULL THEN
    RETURN;
  END IF;

  IF pkaracd_id_p IS NULL THEN
    -- predujam koji NE ponitava drugi predujam
    pkarac_id_l := pkarac_id_p;
  ELSE
    -- predujam koji ponitava drugi predujam
    SELECT pkaracd_id INTO pkaracd_id_originala_l
      FROM tpka_racuni
     WHERE id = pkaracd_id_p;
    IF pkaracd_id_originala_l IS NOT NULL THEN
      -- Ne moete djelomino ponititi predujam koji djelomino ponitava drugi predujam.
      pra_pka_zaj.vrati_poruku (-20069);
    END IF;
    -- za predujam koji ponitava drugi predujam provjerava se taj drugi predujam
    pkarac_id_l := pkaracd_id_p;
  END IF;

  IF pra_pka.izn_primljenog_predujma (pkarac_id_l) < 0 THEN
    -- primljeni predujam je 'negativan'
    IF pra_pka.izn_primljenog_predujma (pkarac_id_l) > (
      pra_pka_s.izn_ponisteni_pkarac (pkarac_id_l) +
      pra_pka.izn_iskoristenog_predujma (pkarac_id_l) +
      pra_rec.izn_iskoristenog_predujma (pkarac_id_l))
    THEN
      -- Iznos iskoritenog predujma ne moe biti vei od iznosa primljenog predujma.
      pra_pka_zaj.vrati_poruku (-20017);
    END IF;
  ELSE
    -- primljeni predujam je 'pozitivan'
    IF pra_pka.izn_primljenog_predujma (pkarac_id_l) < (
      pra_pka_s.izn_ponisteni_pkarac (pkarac_id_l) +
      pra_pka.izn_iskoristenog_predujma (pkarac_id_l) +
      pra_rec.izn_iskoristenog_predujma (pkarac_id_l))
    THEN
      -- Iznos iskoritenog predujma ne moe biti vei od iznosa primljenog predujma.
      pra_pka_zaj.vrati_poruku (-20017);
    END IF;
  END IF;
END;
PROCEDURE ZABRANI_PONISTAVANJE
 (PKARAC_ID_P IN tpka_racuni.id%TYPE
 ,PKARAC_OZNAKA_P IN tpka_racuni.oznaka%TYPE
 )
 IS
/*
IRN 2026
Ne moe se ponititi PKA predujam vezan za valjani PKA raun ili REC raun
niti djelomino poniten predujam.
*/
  br_redaka_l NUMBER;
BEGIN
  IF pkarac_oznaka_p IS NULL
    OR pkarac_id_p IS NULL
  THEN
    RETURN;
  END IF;
  IF pkarac_oznaka_p IN ('P') THEN
    SELECT COUNT (tpka_racuni.ROWID) INTO br_redaka_l
      FROM tpka_rac_pred, tpka_racuni
     WHERE tpka_rac_pred.pkaracp_id = pkarac_id_p
       AND tpka_rac_pred.pkarac_id = tpka_racuni.id
       AND tpka_racuni.oznaka IN ('V');
    IF br_redaka_l > 0 THEN
      -- Ne moe se ponititi predujam vezan za valjani PKA raun.
      pra_pka_zaj.vrati_poruku (-20041);
    END IF;
    SELECT COUNT (t_racuni.ROWID) INTO br_redaka_l
      FROM t_rac_pred, t_racuni
     WHERE t_rac_pred.pkaracp_id = pkarac_id_p
       AND t_rac_pred.rac_id = t_racuni.id
       AND t_racuni.oznaka IN ('V');
    IF br_redaka_l > 0 THEN
      -- Ne moe se ponititi predujam vezan za valjani REC raun.
      pra_pka_zaj.vrati_poruku (-20042);
    END IF;
    SELECT COUNT (ROWID) INTO br_redaka_l
      FROM tpka_racuni
     WHERE pkaracd_id = pkarac_id_p
       AND oznaka IN ('V');
    IF br_redaka_l > 0 THEN
      -- Ne moe se ponititi djelomino poniten predujam.
      pra_pka_zaj.vrati_poruku (-20107);
    END IF;
  END IF;
END;
PROCEDURE UPISI_PRED_U_FIN
 (FINPRED_ID_IZVORNI_P IN TPKA_RACUNI.FINPRED_ID%TYPE
 ,PKARAC_ID_P IN TPKA_RACUNI.ID%TYPE
 ,OJ_ID_P IN TPKA_RACUNI.oj_id%TYPE
 ,VDOK_SIFRA2N_P IN TPKA_RACUNI.vdok_sifra2n%TYPE
 ,OJ_SIFRA_P IN TPKA_RACUNI.oj_sifra%TYPE
 ,GOD_POSLOVNA_P IN TPKA_RACUNI.god_poslovna%TYPE
 ,RBR_P IN TPKA_RACUNI.rbr%TYPE
 ,DATUM_P IN TPKA_RACUNI.datum%TYPE
 ,IZNOS_P IN TPKA_RACUNI.iznos%TYPE
 ,VAL_ID_P IN TPKA_RACUNI.val_ID%TYPE
 ,VTEC_ID_P IN TPKA_RACUNI.vtec_id%TYPE
 ,IZN_TECAJA_P IN TPKA_RACUNI.izn_tecaja%TYPE
 ,GMPKOM_ID_P IN TPKA_RACUNI.gmpkom_ID%TYPE
 ,NAZ_PLATITELJA_P IN tpka_racuni.naz_platitelja%type
 ,DAT_ERAC_OBVEZE_P IN DATE
 ,FINPRED_ID_P OUT TPKA_RACUNI.FINPRED_ID%TYPE
 ,FINPRED_UK_P OUT TPKA_RACUNI.FINPRED_uk%TYPE
 )
 IS
-- proceduru poziva bir_tpka_racuni prilikom prebacivanja predujmova
-- kako bi se predujmovi generirani u mish upisali u possus
  naredba_l VARCHAR2(4000);
  rac_oznaka_l VARCHAR2 (30);
  finpred_id_l tpka_racuni.finpred_id%TYPE;
  finpred_uk_l tpka_racuni.finpred_uk%TYPE;
BEGIN
  -- IRN 4098
  IF TRUNC (datum_p) >= dat_erac_obveze_p THEN
    rac_oznaka_l := vdok_sifra2n_p || god_poslovna_p || '-' || oj_sifra_p || '-' || rbr_p;
  ELSE
    rac_oznaka_l := vdok_sifra2n_p || '-' || oj_sifra_p || '-' || rbr_p;
  END IF;

  IF UPPER (pra_zmp_zaj.vrijednost_parametra ('0003')) = 'D' THEN -- jesam na centru
    IF pra_zmp_zaj.vrijednost_parametra ('0031') = 'D' THEN -- imam possus --> odradi: pozovi possus proceduru i upii u tablicu
      naredba_l :=
       'BEGIN
          finprednovi' ||
            '(pizvorniid => :finpred_id_izvorni_p' ||
            ',porganizacija => :oj_id_p' ||
            ',pbrojsadokumenta => :rac_oznaka_l' ||
            ',pdatum => :datum_p' ||
            ',piznos => :iznos_p' ||
            ',pnoviid => :finpred_id_l' ||
            ',pnoviuk => :finpred_uk_l' ||
            '); END;';
      EXECUTE IMMEDIATE naredba_l USING
         finpred_id_izvorni_p
        ,oj_id_p
        ,rac_oznaka_l
        ,datum_p
        ,iznos_p
        ,OUT finpred_id_l
        ,OUT finpred_uk_l;

      INSERT INTO lpka_pred_fin (
        finpred_id_izvorni, pkarac_id, oj_id, rac_oznaka, datum, iznos,
        val_id, vtec_id, izn_tecaja, gmpkom_id, naz_platitelja, finpred_id, finpred_uk)
      VALUES (
        finpred_id_izvorni_p, pkarac_id_p, oj_id_p, rac_oznaka_l, datum_p ,iznos_p,
        val_id_p, vtec_id_p, izn_tecaja_p, gmpkom_id_p, naz_platitelja_p, finpred_id_l, finpred_uk_l);
    END IF;
  ELSE
    -- nisam na centru --> pozovi sama sebe na centru;
    naredba_l :=
     'BEGIN
        pra_tpka_racuni.upisi_pred_u_fin@' || pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0018') ||
          '(finpred_id_izvorni_p => :finpred_id_izvorni_p' ||
          ',pkarac_id_p => :pkarac_id_p' ||
          ',oj_id_p => :oj_id_p' ||
          ',vdok_sifra2n_p => :vdok_sifra2n_p' ||
          ',oj_sifra_p => :oj_sifra_p' ||
          ',god_poslovna_p => :god_poslovna_p' ||
          ',rbr_p => :rbr_p' ||
          ',datum_p => :datum_p' ||
          ',iznos_p => :iznos_p' ||
          ',val_id_p => :val_id_p' ||
          ',vtec_id_p => :vtec_id_p' ||
          ',izn_tecaja_p => :izn_tecaja_p' ||
          ',gmpkom_id_p => :gmpkom_id_p' ||
          ',naz_platitelja_p => :naz_platitelja_p' ||
          ',finpred_id_p => :finpred_id_l' ||
          ',finpred_uk_p => :finpred_uk_l' ||
          '); END;';
    EXECUTE IMMEDIATE naredba_l USING
       finpred_id_izvorni_p
      ,pkarac_id_p
      ,oj_id_p
      ,vdok_sifra2n_p
      ,oj_sifra_p
      ,god_poslovna_p
      ,rbr_p
      ,datum_p
      ,iznos_p
      ,val_id_p
      ,vtec_id_p
      ,izn_tecaja_p
      ,gmpkom_id_p
      ,naz_platitelja_p
      ,OUT finpred_id_l
      ,OUT finpred_uk_l;
  END IF;
  finpred_id_p := finpred_id_l;
  finpred_uk_p := finpred_uk_l;
END;
PROCEDURE PROVJERI_VAPLDOK_VPLA
 (VAPLDOK_ID_P IN tpka_racuni.vapldok_id%TYPE
 ,OJ_ID_P IN tpka_racuni.oj_id%TYPE
 ,VPLA_ID_P IN s_vplacanja.id%TYPE
 ,VAL_ID_P IN s_valute.id%TYPE
 )
 IS
-- IRN 2696
  br_redaka_l NUMBER;
  vapldok_oznaka_l s_vapldok.oznaka%TYPE;
  vlas_row_l s_vlasnik%ROWTYPE;
BEGIN
  IF vapldok_id_p IS NULL
    OR oj_id_p IS NULL
    OR vpla_id_p IS NULL
    OR val_id_p IS NULL
  THEN
    RETURN;
  END IF;

  vapldok_oznaka_l := pra_zmp.vapldok_oznaka (vapldok_id_p);
  SELECT * INTO vlas_row_l FROM s_vlasnik;

  SELECT COUNT (1) INTO br_redaka_l
    FROM m_vpla_val vplaval,
         s_valute val,
         s_vplacanja vpla,
         s_vpplacanja vppla
   WHERE vplaval.vpla_id = vpla.id
     AND vplaval.val_id = val.id
     AND vpla.id = vpla_id_p
     AND vpla.vppla_id = vppla.id
     AND val.id = val_id_p
     AND (
            (vapldok_oznaka_l = 'GI' AND vpla.ozn_got = -1)
         OR (vapldok_oznaka_l = 'BI' AND vpla.ozn_bez = -1 AND vpla.ozn_vpot = 0)
         OR (vapldok_oznaka_l = 'IR' AND vpla.ozn_bez = -1 AND vpla.ozn_vpot = 0)
         OR (vapldok_oznaka_l = 'BV' AND vpla.ozn_bez = -1 AND vpla.ozn_vpot = -1)
         OR (vapldok_oznaka_l = 'RP' AND 0 = 1)
         OR (vapldok_oznaka_l = 'GP' AND vpla.ozn_got = -1 AND vpla.ozn_pre = -1)
         OR (vapldok_oznaka_l = 'BP' AND vpla.ozn_bez = -1 AND vpla.ozn_pre = -1)
         )
     AND vpla.ozn_pka = -1
     AND vplaval.oj_id = oj_id_p
     AND (
         val.ozn_upotrebe = -1
         OR val.sifra_3a = pra_rec_zaj.vrijednost_parametra ('0001')
         -- IRN 3543; dvojni optjecaj
         OR (
            vapldok_oznaka_l IN ('GI', 'GP')
            AND vppla.sifra = 'G'
            AND val.id = vlas_row_l.domval0_id
            AND TRUNC (SYSDATE) BETWEEN vlas_row_l.dat_primjene_domval AND vlas_row_l.dat_optjecaj_2val_zav
            )
         );
  IF br_redaka_l = 0 THEN
    -- Nedoputena vrsta plaanja!
    pra_rec_zaj.vrati_poruku (-20443);
  END IF;
END;

END PRA_TPKA_RACUNI;
/
SHOW ERROR

