PROMPT Creating Package Body 'PRA_TPKA_KARTICE'
CREATE OR REPLACE PACKAGE BODY PRA_TPKA_KARTICE IS

PROCEDURE PROVJERI_PKAKAR_OZNAKA
 (PKAKAR_ID_P IN TPKA_KARTICE.ID%TYPE
 )
 IS
-- Izmjena ponitene kartice nije doputena.
  br_redaka_l NUMBER;
BEGIN
  IF pkakar_id_p IS NULL THEN
    RETURN;
  END IF;
  SELECT COUNT (1) INTO br_redaka_l
    FROM tpka_kartice
   WHERE id = pkakar_id_p
     AND oznaka IN ('P');
  IF br_redaka_l > 0 THEN
    -- Izmjena ponitene kartice (Pay Card) nije doputena.
    pra_pka_zaj.vrati_poruku (-20072);
  END IF;
END;
FUNCTION VALJANA_PKAKAR
 (PKAKAR_ID_P IN TPKA_KARTICE.ID%TYPE
 )
 RETURN NUMBER
 IS
--
  br_redaka_l NUMBER;
BEGIN
  IF pkakar_id_p IS NULL THEN
    RETURN (-1);
  END IF;
  SELECT COUNT (1) INTO br_redaka_l
    FROM tpka_kartice pkakar,
         t_gosti gost
   WHERE pkakar.id = pkakar_id_p
     AND pkakar.oznaka = 'V'
     AND TRUNC (NVL (pkakar.dat_zav, SYSDATE)) >= TRUNC (SYSDATE)
     AND pkakar.gost_id = gost.id(+)
     /*
     -- komentirano po IRN 2999
     AND (
         pkakar.gost_id IS NOT NULL AND gost.ozn_prisutnosti = 'P' AND gost.dat_odlaska >= TRUNC (SYSDATE)
         OR
         pkakar.gost_id IS NULL
         )
     */
     AND (pkakar.gost_id IS NULL OR gost.ozn_prisutnosti = 'P'); -- IRN 2999
  IF br_redaka_l = 1 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;
END;
PROCEDURE PROVJERI_PKAKAR_BROJ
 (PKAKAR_ID_P IN TPKA_KARTICE.ID%TYPE
 ,PKAKAR_BROJ_P IN TPKA_KARTICE.BROJ%TYPE
 )
 IS
-- poziva se iz AIS_TPKA_KARTICE i AUS_TPKA_KARTICE, AIS_TPKA_KAR_DOD
  br_redaka_l NUMBER;
  pkakar_broj_l tpka_kartice.broj%TYPE; -- IRN 3897
BEGIN
  IF pkakar_id_p IS NULL
    OR pkakar_broj_p IS NULL
  THEN
    RETURN;
  END IF;

  SELECT COUNT(1) INTO br_redaka_l
    FROM tpka_kartice pkakar,
         t_gosti gost -- IRN 2999
   WHERE pkakar.id <> pkakar_id_p
     AND UPPER (pkakar.broj) = UPPER (pkakar_broj_p)
     /*
     komentirano po IRN 2999
     AND NVL (pkakar.pin, 0) = NVL (pkakar_pin_p, 0)
     AND pra_tpka_kartice.valjana_pkakar (id) = -1
     */
     -- IRN 2999
     AND pkakar.oznaka = 'V'
     -- IRN 3897 AND TRUNC (NVL (pkakar.dat_zav, SYSDATE)) >= TRUNC (SYSDATE)
     AND pkakar.gost_id = gost.id(+) -- IRN 2999
     AND gost.ozn_prisutnosti(+) = 'P';

  IF br_redaka_l > 0 THEN
    -- Valjana kartica (Pay Card) s brojem #0 ve postoji!
    pra_pka_zaj.vrati_poruku (-20077, pkakar_broj_p);
  END IF;

  -- IRN 3478; Provjeri dodatne kartice
  SELECT MIN (pkakar.broj) INTO pkakar_broj_l -- IRN 3897
    FROM tpka_kar_dod pkakardod,
         tpka_kartice pkakar,
         t_gosti gost
   WHERE pkakardod.id <> pkakar_id_p
     AND pkakardod.pkakar_id = pkakar.id
     AND UPPER (pkakardod.broj) = UPPER (pkakar_broj_p)
     AND pkakardod.oznaka = 'V'
     AND pkakar.oznaka = 'V'
     -- IRN 3897 AND TRUNC (NVL (pkakar.dat_zav, SYSDATE)) >= TRUNC (SYSDATE)
     AND pkakar.gost_id = gost.id(+)
     AND gost.ozn_prisutnosti(+) = 'P';

  IF pkakar_broj_l IS NOT NULL THEN -- IRN 3897
    -- Valjana kartica (Pay Card) s brojem #0 ve postoji!
    pra_pka_zaj.vrati_poruku (-20077, pkakar_broj_p || ' (' || pkakar_broj_l || ')');
  END IF;

END;
PROCEDURE PROVJERI_IPKAKAR_BROJ
 (PKAKAR_BROJ_P IN IPKA_KARTICE.BROJ%TYPE
 ,METCVOR_SIFRA_P IN IPKA_KARTICE.METCVOR_SIFRA%TYPE
 )
 IS
-- poziva se iz BIR_IPKA_KARTICE
  CURSOR ipkakar_c IS
    SELECT metcvor_sifra
      FROM ipka_kartice
     WHERE UPPER (broj) = UPPER (pkakar_broj_p)
       AND metcvor_sifra <> metcvor_sifra_p;
  metcvor_sifra_l ipka_kartice.metcvor_sifra%TYPE;
  naredba_l VARCHAR2(4000);
BEGIN
  IF pkakar_broj_p IS NULL
    OR metcvor_sifra_p IS NULL
  THEN
    RETURN;
  END IF;

  OPEN ipkakar_c;
  FETCH ipkakar_c INTO metcvor_sifra_l;
  CLOSE ipkakar_c;
  IF metcvor_sifra_l IS NULL THEN
    RETURN;
  END IF;

  -- IRN 3487
  naredba_l :=
    'BEGIN
       pra_tpka_kartice.provjeri_pkakar_broj<CVOR> (
         pkakar_id_p   => -1,
         pkakar_broj_p => :pkakar_broj_p);
     END;';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', '@' || metcvor_sifra_l) USING pkakar_broj_p;

END;
PROCEDURE PROVJERI_PKAKAR_OZN_IZVAN_OJ
 (PKAKAR_OZN_IZVAN_OJ_P IN TPKA_KARTICE.OZN_IZVAN_OJ%TYPE
 )
 IS
/*
Oznaka kartice (ozn_izvan_oj) ne moe se postaviti na Da,
ako je vrijednost parametra 1037 (Izdajem kartice koje se
mogu koristiti u drugim OJ) postavljena na Ne.
*/
BEGIN
  IF pkakar_ozn_izvan_oj_p IS NULL THEN
    RETURN;
  END IF;
  IF UPPER (pra_pka_zaj.vrijednost_parametra ('1037')) NOT IN ('DA')
    AND pkakar_ozn_izvan_oj_p IN (-1)
  THEN
    -- Oznaka kartice (Pay Card) ne moe se postaviti na Da, ako je vrijednost PKA parametra 1037 postavljena na Ne.
    pra_pka_zaj.vrati_poruku (-20078);
  END IF;
END;
FUNCTION PIN4
 RETURN VARCHAR2
 IS
-- Personal Identification Number
BEGIN
  IF pra_pka_zaj.vrijednost_parametra ('1038') IN ('4') THEN
    RETURN (
      LPAD (TO_CHAR (ROUND (dbms_random.value (low => 0, high => 9999))), 4, '0'));
  ELSE
    RETURN (TO_CHAR (NULL));
  END IF;
END;
PROCEDURE ZABRANI_IZMJENU_PKAKAR
 (PKAKAR_OLD_ROW_P IN tpka_kartice%ROWTYPE
 ,PKAKAR_NEW_ROW_P IN tpka_kartice%ROWTYPE
 )
 IS
-- IRN 2527
  dat_null_l DATE := TO_DATE ('01.01.1800', 'DD.MM.RRRR');
BEGIN
  IF    pkakar_old_row_p.oznaka = 'V' AND pkakar_old_row_p.ozn_prepaid = 0 THEN
    RETURN;
  ELSIF pkakar_old_row_p.oznaka = 'P' AND pkakar_old_row_p.ozn_prepaid = 0 THEN
    -- Izmjena ponitene kartice nije doputena.
    pra_pka_zaj.vrati_poruku (-20072);
  ELSIF pkakar_old_row_p.oznaka = 'P' AND pkakar_old_row_p.ozn_prepaid = -1 THEN
    -- Dopusti promjenu izn_odobren zbog eventualnog povrata uplate
    IF pkakar_old_row_p.zmpojr_id <> pkakar_new_row_p.zmpojr_id
      OR NVL (pkakar_old_row_p.gost_id, 0) <> NVL (pkakar_new_row_p.gost_id, 0)
      OR NVL (pkakar_old_row_p.age_id, 0) <> NVL (pkakar_new_row_p.age_id, 0)
      OR NVL (pkakar_old_row_p.pkaadr_id, 0) <> NVL (pkakar_new_row_p.pkaadr_id, 0)
      -- broj -- promjenu ne doputa BUR
      OR pkakar_old_row_p.oznaka <> pkakar_new_row_p.oznaka
      OR pkakar_old_row_p.ozn_izvan_oj <> pkakar_new_row_p.ozn_izvan_oj
      OR NVL (pkakar_old_row_p.dat_poc, dat_null_l) <> NVL (pkakar_new_row_p.dat_poc, dat_null_l)
      OR NVL (pkakar_old_row_p.dat_zav, dat_null_l) <> NVL (pkakar_new_row_p.dat_zav, dat_null_l)
      OR NVL (pkakar_old_row_p.ime, '') <> NVL (pkakar_new_row_p.ime, '')
      OR NVL (pkakar_old_row_p.prezime, '') <> NVL (pkakar_new_row_p.prezime, '')
      OR NVL (pkakar_old_row_p.pin, '') <> NVL (pkakar_new_row_p.pin, '')
      -- izn_odobren -- promjena doputena
      OR NVL (pkakar_old_row_p.izn_potrosen, 0) <> NVL (pkakar_new_row_p.izn_potrosen, 0)
      -- unos_korisnik, unos_dat, izmjena_korisnik, izmjena_dat
      OR pkakar_old_row_p.ozn_jednokratna <> pkakar_new_row_p.ozn_jednokratna
      OR NVL (pkakar_old_row_p.nac_id, 0) <> NVL (pkakar_new_row_p.nac_id, 0)
      OR NVL (pkakar_old_row_p.stopa_popusta_pos1, 0) <> NVL (pkakar_new_row_p.stopa_popusta_pos1, 0)
      OR NVL (pkakar_old_row_p.stopa_popusta_pos2, 0) <> NVL (pkakar_new_row_p.stopa_popusta_pos2, 0)
      OR NVL (pkakar_old_row_p.kcsus_id, 0) <> NVL (pkakar_new_row_p.kcsus_id, 0)
      -- ozn_prepaid -- promjenu ne doputa BUR
      OR NVL (pkakar_old_row_p.nac2_id, 0) <> NVL (pkakar_new_row_p.nac2_id, 0) -- IRN 2716
      -- ozn_nfc     -- promjenu ne doputa BUR                                 -- IRN 2716
      -- IRN 3897
      OR NVL (pkakar_old_row_p.sifra, '') <> NVL (pkakar_new_row_p.sifra, '')
      OR NVL (pkakar_old_row_p.oj_id, 0) <> NVL (pkakar_new_row_p.oj_id, 0)
      OR NVL (pkakar_old_row_p.izn_limita2, 0) <> NVL (pkakar_new_row_p.izn_limita2, 0)
      OR NVL (pkakar_old_row_p.oj_sifra_izv, '') <> NVL (pkakar_new_row_p.oj_sifra_izv, '')
      OR NVL (pkakar_old_row_p.sifra2, '') <> NVL (pkakar_new_row_p.sifra2, '')
      -- opis -- promjena doputena
      -- KRAJ IRN 3897
    THEN
      -- Izmjena ponitene kartice nije doputena.
      pra_pka_zaj.vrati_poruku (-20072);
    END IF;
  ELSIF pkakar_old_row_p.oznaka = 'V' AND pkakar_old_row_p.ozn_prepaid = -1 THEN
    -- Dopusti promjenu: oznaka, dat_zav, ime, prezime, pin, izn_odobren, izn_potrosen, nac_id, stopa_popusta_pos1 i stopa_popusta_pos2,
    -- Dopusti promjenu: nac2_id -- IRN 2716
    -- Dopusti promjenu: dat_poc -- IRN 2807
    -- Dopusti promjenu: sifra, oj_id, izn_limita2, oj_sifra_izv, sifra2, opis -- IRN 3897

    -- Izmjena Prepaid kartice nije doputena (#0).
    IF pkakar_old_row_p.zmpojr_id <> pkakar_new_row_p.zmpojr_id THEN
      pra_pka_zaj.vrati_poruku (-20213, 'zmpojr_id');
    END IF;
    IF NVL (pkakar_old_row_p.gost_id, 0) <> NVL (pkakar_new_row_p.gost_id, 0) THEN
      pra_pka_zaj.vrati_poruku (-20213, 'gost_id');
    END IF;
    IF NVL (pkakar_old_row_p.age_id, 0) <> NVL (pkakar_new_row_p.age_id, 0) THEN
      pra_pka_zaj.vrati_poruku (-20213, 'age_id');
    END IF;
    IF NVL (pkakar_old_row_p.pkaadr_id, 0) <> NVL (pkakar_new_row_p.pkaadr_id, 0) THEN
      pra_pka_zaj.vrati_poruku (-20213, 'pkaadr_id');
    END IF;
    -- broj               -- promjenu ne doputa BUR
    -- oznaka             -- promjena doputena
    IF pkakar_old_row_p.ozn_izvan_oj <> pkakar_new_row_p.ozn_izvan_oj THEN
      pra_pka_zaj.vrati_poruku (-20213, 'ozn_izvan_oj');
    END IF;
    -- dat_poc            -- promjena doputena -- IRN 2807
    -- dat_zav            -- promjena doputena
    -- ime                -- promjena doputena
    -- prezime            -- promjena doputena
    -- pin                -- promjena doputena
    -- izn_odobren        -- promjena doputena
    -- izn_potrosen       -- promjena doputena
    -- unos_korisnik, unos_dat, izmjena_korisnik, izmjena_dat
    IF pkakar_old_row_p.ozn_jednokratna <> pkakar_new_row_p.ozn_jednokratna THEN
      pra_pka_zaj.vrati_poruku (-20213, 'ozn_jednokratna');
    END IF;
    -- nac_id             -- promjena doputena
    -- stopa_popusta_pos1 -- promjena doputena
    -- stopa_popusta_pos2 -- promjena doputena
    IF NVL (pkakar_old_row_p.kcsus_id, 0) <> NVL (pkakar_new_row_p.kcsus_id, 0) THEN
      pra_pka_zaj.vrati_poruku (-20213, 'kcsus_id');
    END IF;
    -- ozn_prepaid        -- promjenu ne doputa BUR
    -- nac2_id            -- promjena doputena      -- IRN 2716
    -- ozn_nfc            -- promjenu ne doputa BUR -- IRN 2716
    -- IRN 3897
    -- sifra              -- promjena doputena
    -- oj_id              -- promjena doputena
    -- izn_limita2        -- promjena doputena
    -- oj_sifra_izv       -- promjena doputena
    -- sifra2             -- promjena doputena
    -- opis               -- promjena doputena
    -- KRAJ IRN 3897
  END IF;
END;
FUNCTION KOL_NEZARACUNATIH_RNK
 (PKAKAR_ID_P IN tpka_kartice.id%TYPE
 )
 RETURN NUMBER
 IS
-- koliina nezaraunatih RNK vezanih za promatranu karticu
-- IRN 2807; umjesto poziva funkcije pra_pka.neiskoristen_rnk dodano itanje ozn_irn, oznaka, rac_id i pkarac_id
  br_redaka_l NUMBER;
BEGIN
  IF pkakar_id_p IS NULL THEN
    RETURN (NULL);
  END IF;

  /*
  komentirano po IRN 3115
  SELECT COUNT (1) INTO br_redaka_l
    FROM tpka_rnkasa
   WHERE pkakar_id = pkakar_id_p
     AND vpla_id IN (SELECT id FROM s_vplacanja WHERE ozn_irn IS NOT NULL) -- IRN 2872
     AND oznaka = 'V'
     AND rac_id IS NULL
     AND pkarac_id IS NULL;
  */

  -- IRN 3115; dohvati samo nezaraunate uplate
  SELECT COUNT (1) INTO br_redaka_l
    FROM tpka_rnkasa pkarnk,
         tpka_kar_rnk pkakarrnk
   WHERE pkarnk.god_poslovna_izvor = pkakarrnk.god_poslovna
     AND pkarnk.gmpkas_id_izvor = pkakarrnk.gmpkas_id
     AND pkarnk.rbr_izvor = pkakarrnk.rbr
     AND pkarnk.pkakar_id = pkakarrnk.pkakar_id
     AND pkakarrnk.oznaka IN (1) -- uplata
     AND NVL (pkakarrnk.iznos, 0) <> 0
     AND pkarnk.pkakar_id = pkakar_id_p
     AND pkarnk.vpla_id IN (SELECT id FROM s_vplacanja WHERE ozn_irn IS NOT NULL) -- IRN 2872
     AND pkarnk.oznaka = 'V'
     AND pkarnk.rac_id IS NULL
     AND pkarnk.pkarac_id IS NULL;

  RETURN (br_redaka_l);
END;
PROCEDURE AZURIRAJ_PKAKAR
 (GOST_ID_P IN t_gosti.id%TYPE
 ,PONSO_ID_P IN t_gosti.ponso_id%TYPE
 ,RECAGOST_ID_P IN t_gosti.recagost_id%TYPE
 ,MS_ID_P IN t_gosti.ms_id%TYPE
 ,SJ_ID_P IN t_gosti.sj_id%TYPE
 ,DAT_DOLASKA_P IN t_gosti.dat_dolaska%TYPE
 ,DAT_ODLASKA_P IN t_gosti.dat_odlaska%TYPE
 )
 IS
-- IRN 2997; poziva se iz AUS_T_GOSTI
  nac_id_l tpka_kartice.nac_id%TYPE;
  stopa_popusta_pos1_l tpka_kartice.stopa_popusta_pos1%TYPE;
  stopa_popusta_pos2_l tpka_kartice.stopa_popusta_pos2%TYPE;
  ozn_loyalty_l m_msegmenti.ozn_loyalty%TYPE; -- IRN 3105
BEGIN
  IF gost_id_p IS NULL THEN
    RETURN;
  END IF;

  -- ugovoren nain potronje i popust
  IF ponso_id_p IS NOT NULL THEN
    SELECT pon.nac_id, pon.stopa_popusta_pos
      INTO nac_id_l, stopa_popusta_pos1_l
      FROM t_pon_so ponso, t_pon_ojr ponojr, t_ponude pon
     WHERE ponso.id = ponso_id_p
       AND ponso.ponojr_id = ponojr.id
       AND ponojr.pon_id = pon.id;
  END IF;

  -- popust iz arhive gostiju
  IF recagost_id_p IS NOT NULL THEN
    SELECT stopa_popusta_pos
      INTO stopa_popusta_pos2_l
      FROM trec_agostiju
     WHERE id = recagost_id_p;
  END IF;

  /*
  IRN 3105
  LoyaltyInSky (LIS); svim gostima u SJ (koji pripadaju loyalty MS) kod izrade Pay Card upisati
  stopu popusta za POS koju ima lan programa vjernosti smjeten u toj istoj SJ
  LOY 1017 => Oznaka vrste programa vjernosti
  IRN 4108
  Dodala vrstu programa vjernosti BECRM = Be-terna CRM
  */
  IF pra_zmp_zaj.zmppar_vrijednost ('LOY', '1017') IN ('LIS', 'BECRM') THEN
    SELECT ozn_loyalty INTO ozn_loyalty_l FROM m_msegmenti WHERE id = ms_id_p;
    IF ozn_loyalty_l = -1 THEN
      IF NVL (stopa_popusta_pos2_l, 0) = 0 THEN
        SELECT MAX (recagost.stopa_popusta_pos) INTO stopa_popusta_pos2_l
          FROM t_gosti gost,
               trec_agostiju recagost,
               m_msegmenti ms
         WHERE gost.recagost_id = recagost.id
           AND gost.ms_id = ms.id
           AND ms.ozn_loyalty = -1
           AND gost.sj_id = sj_id_p
           AND gost.ozn_prisutnosti = 'P' -- IRN 4083
           AND gost.dat_dolaska < dat_odlaska_p
           AND gost.dat_odlaska > dat_dolaska_p;
      ELSE
        FOR gost_c IN (
          SELECT gost.id AS id
            FROM t_gosti gost,
                 m_msegmenti ms
           WHERE gost.ms_id = ms.id
             AND ms.ozn_loyalty = -1
             AND gost.sj_id = sj_id_p
             AND gost.ozn_prisutnosti = 'P' -- IRN 4083
             AND gost.dat_dolaska < dat_odlaska_p
             AND gost.dat_odlaska > dat_dolaska_p
             AND gost.id <> gost_id_p
          )
        LOOP
          UPDATE tpka_kartice
             SET stopa_popusta_pos2 = stopa_popusta_pos2_l
           WHERE gost_id = gost_c.id
             AND oznaka = 'V'
             AND NVL (stopa_popusta_pos2, 0) < stopa_popusta_pos2_l; -- IRN 4083
        END LOOP;
      END IF;
    ELSE
      -- nije loy MS
      stopa_popusta_pos2_l := NULL;
    END IF;
  END IF;

  IF stopa_popusta_pos2_l IS NULL THEN
    -- PKA param 1048 Stopa popusta koja se odobrava korisnicima Pay Card na kasama (POS): do 99,99 pisano s decimalnim zarezom.
    stopa_popusta_pos2_l := TO_NUMBER (pra_pka_zaj.vrijednost_parametra ('1048'), '99D99', 'NLS_NUMERIC_CHARACTERS = '',.''');
  END IF;

  UPDATE tpka_kartice
     SET nac_id = nac_id_l,
         stopa_popusta_pos1 = stopa_popusta_pos1_l,
         stopa_popusta_pos2 = stopa_popusta_pos2_l
   WHERE gost_id = gost_id_p
     AND oznaka = 'V';

END;
PROCEDURE PROVJERI_PKAKARRNK_DATUM
 (PKAKAR_ID_P IN tpka_kartice.id%TYPE
 ,DAT_POC_P IN tpka_kartice.dat_poc%TYPE
 ,DAT_ZAV_P IN tpka_kartice.dat_zav%TYPE
 )
 IS
-- IRN 3278
  CURSOR pkakarrnk_c IS
    SELECT NVL (rbr, rbr_nar) AS rbr, -- IRN 3715
           TO_CHAR (datum, 'DD.MM.RRRR') AS datum
      FROM tpka_kar_rnk
     WHERE pkakar_id = pkakar_id_p
       AND (
           (datum < TRUNC (dat_poc_p) AND dat_poc_p IS NOT NULL)
           OR
           (datum > TRUNC (dat_zav_p) AND dat_zav_p IS NOT NULL)
           )
     ORDER BY id;
  pkakarrnk_c_l pkakarrnk_c%ROWTYPE;
  dat_poc_l VARCHAR2(10) := '***';
  dat_zav_l VARCHAR2(10) := '***';
BEGIN
  IF pkakar_id_p IS NULL THEN
    RETURN;
  END IF;
  IF dat_poc_p IS NULL AND dat_zav_p IS NULL THEN
    RETURN;
  END IF;

  OPEN pkakarrnk_c;
  FETCH pkakarrnk_c INTO pkakarrnk_c_l;
  IF pkakarrnk_c%FOUND THEN
    CLOSE pkakarrnk_c;
    IF dat_poc_p IS NOT NULL THEN
      dat_poc_l := TO_CHAR (dat_poc_p, 'DD.MM.RRRR');
    END IF;
    IF dat_zav_p IS NOT NULL THEN
      dat_zav_l := TO_CHAR (dat_zav_p, 'DD.MM.RRRR');
    END IF;
    -- Datum narudbe / rauna (#0) broj #1 izvan je razdoblja valjanosti kartice (#2 - #3).
    pra_pka_zaj.vrati_poruku (-20243, pkakarrnk_c_l.datum, pkakarrnk_c_l.rbr, dat_poc_l, dat_zav_l);
  END IF;
  CLOSE pkakarrnk_c;

END;
PROCEDURE PROVJERI_PKAKAR_RAZDOBLJE
 (PKAKAR_ID_P IN tpka_kar_rnk.pkakar_id%TYPE
 ,RBR_P IN tpka_kar_rnk.rbr%TYPE
 ,DATUM_P IN tpka_kar_rnk.datum%TYPE
 )
 IS
-- IRN 3278
  CURSOR pkakar_c IS
    SELECT DECODE (dat_poc, NULL, '***', TO_CHAR (dat_poc, 'DD.MM.RRRR')) AS dat_poc,
           DECODE (dat_zav, NULL, '***', TO_CHAR (dat_zav, 'DD.MM.RRRR')) AS dat_zav
      FROM tpka_kartice
     WHERE id = pkakar_id_p
       AND (
           (datum_p < TRUNC (dat_poc) AND dat_poc IS NOT NULL)
           OR
           (datum_p > TRUNC (dat_zav) AND dat_zav IS NOT NULL)
           );
  pkakar_c_l pkakar_c%ROWTYPE;
BEGIN
  IF pkakar_id_p IS NULL
    OR datum_p IS NULL
  THEN
    RETURN;
  END IF;

  OPEN pkakar_c;
  FETCH pkakar_c INTO pkakar_c_l;
  IF pkakar_c%FOUND THEN
    CLOSE pkakar_c;
    -- Datum narudbe / rauna (#0) broj #1 izvan je razdoblja valjanosti kartice (#2 - #3).
    pra_pka_zaj.vrati_poruku (-20243, TO_CHAR (datum_p, 'DD.MM.RRRR'), rbr_p, pkakar_c_l.dat_poc, pkakar_c_l.dat_zav);
  END IF;
  CLOSE pkakar_c;

END;

END PRA_TPKA_KARTICE;
/
SHOW ERROR

