PROMPT Creating Package Body 'PRA_T_ZAKUP'
CREATE OR REPLACE PACKAGE BODY PRA_T_ZAKUP IS

PROCEDURE ODUZMI_BOOKING
 (ZAK_ID_P IN t_zakup.id%TYPE
 ,OZNAKA_P IN t_zakup.oznaka%TYPE
 ,SO_ID_P IN i_booking.so_id%TYPE
 ,MS_ID_P IN i_booking.ms_id%TYPE
 ,AGE_ID_P IN i_booking.age_id%TYPE
 ,DAT_POC_P IN t_zakup.dat_poc%TYPE
 ,DAT_ZAV_P IN t_zakup.dat_zav%TYPE
 ,OZN_B_P IN t_zakup.ozn_b%TYPE
 ,OZN_U_P IN t_zakup.ozn_u%TYPE
 )
 IS
--
  br_osoba_l i_booking.br_osoba%TYPE;
  vsj_id_l i_booking.vsj_id%TYPE;
BEGIN
  FOR zaksj_c IN (
    SELECT sj_id
      FROM t_zak_sj
     WHERE zak_id = zak_id_p)
  LOOP

    -- koliina sj
    SELECT br_opostelja, vsj_id INTO br_osoba_l, vsj_id_l
      FROM m_sj
     WHERE id = zaksj_c.sj_id;

    -- auriraj booking stupanj prodaje B
    IF oznaka_p IN ('V') AND ozn_b_p IN (-1) THEN
      pra_rec_book.azuriraj_booking_razdoblje (
        so_id_p,
        ms_id_p,
        age_id_p,
        vsj_id_l,
        dat_poc_p,
        dat_zav_p,
        'B',
        0 - 1,
        0 - br_osoba_l,
        NULL,
        NULL,    -- ponso_id
        NULL     -- recvpro_id
        );
    END IF;

    -- auriraj booking stupanj prodaje U
    IF oznaka_p IN ('V') AND ozn_u_p IN (-1) THEN
      pra_rec_book.azuriraj_booking_razdoblje (
        so_id_p,
        ms_id_p,
        age_id_p,
        vsj_id_l,
        dat_poc_p,
        dat_zav_p,
        'U',
        0 - 1,
        0 - br_osoba_l,
        NULL,
        NULL,    -- ponso_id
        NULL     -- recvpro_id
        );
    END IF;
  END LOOP;
END;
PROCEDURE DODAJ_BOOKING
 (ZAK_ID_P IN t_zakup.id%TYPE
 ,OZNAKA_P IN t_zakup.oznaka%TYPE
 ,SO_ID_P IN i_booking.so_id%TYPE
 ,MS_ID_P IN i_booking.ms_id%TYPE
 ,AGE_ID_P IN i_booking.age_id%TYPE
 ,DAT_POC_P IN t_zakup.dat_poc%TYPE
 ,DAT_ZAV_P IN t_zakup.dat_zav%TYPE
 ,OZN_B_P IN t_zakup.ozn_b%TYPE
 ,OZN_U_P IN t_zakup.ozn_u%TYPE
 )
 IS
--
  br_osoba_l i_booking.br_osoba%TYPE;
  vsj_id_l i_booking.vsj_id%TYPE;
BEGIN
  FOR zaksj_c IN (
    SELECT sj_id
      FROM t_zak_sj
     WHERE zak_id = zak_id_p)
  LOOP

    -- koliina sj
    SELECT br_opostelja, vsj_id INTO br_osoba_l, vsj_id_l
      FROM m_sj
     WHERE id = zaksj_c.sj_id;

    -- auriraj booking stupanj prodaje B
    IF oznaka_p IN ('V') AND ozn_b_p IN (-1) THEN
      pra_rec_book.azuriraj_booking_razdoblje (
        so_id_p,
        ms_id_p,
        age_id_p,
        vsj_id_l,
        dat_poc_p,
        dat_zav_p,
        'B',
        1,
        br_osoba_l,
        NULL,
        NULL,    -- ponso_id
        NULL     -- recvpro_id
        );
    END IF;

    -- auriraj booking stupanj prodaje U
    IF oznaka_p IN ('V') AND ozn_u_p IN (-1) THEN
      pra_rec_book.azuriraj_booking_razdoblje (
        so_id_p,
        ms_id_p,
        age_id_p,
        vsj_id_l,
        dat_poc_p,
        dat_zav_p,
        'U',
        1,
        br_osoba_l,
        NULL,
        NULL,    -- ponso_id
        NULL     -- recvpro_id
        );
    END IF;
  END LOOP;
END;
PROCEDURE DODAJ_STATUSSJ
 (ZAK_ID_P IN t_zakup.id%TYPE
 ,OZNAKA_P IN t_zakup.oznaka%TYPE
 ,OZN_STSJ_P IN t_zakup.ozn_stsj%TYPE
 ,DAT_POC_P IN t_zakup.dat_poc%TYPE
 ,DAT_ZAV_P IN t_zakup.dat_zav%TYPE
 )
 IS
BEGIN
  FOR zaksj_c IN (
    SELECT sj_id
      FROM t_zak_sj
     WHERE zak_id = zak_id_p)
  LOOP
    IF oznaka_p IN ('V') AND ozn_stsj_p IN (-1) THEN
      pra_rec2.dodaj_statussj_u (
        zaksj_c.sj_id,
        dat_poc_p,
        dat_zav_p);
    END IF;
  END LOOP;
END;
PROCEDURE ODUZMI_STATUSSJ
 (ZAK_ID_P IN t_zakup.id%TYPE
 ,OZNAKA_P IN t_zakup.oznaka%TYPE
 ,OZN_STSJ_P IN t_zakup.ozn_stsj%TYPE
 ,DAT_POC_P IN t_zakup.dat_poc%TYPE
 ,DAT_ZAV_P IN t_zakup.dat_zav%TYPE
 )
 IS
BEGIN
  FOR zaksj_c IN (
    SELECT sj_id
      FROM t_zak_sj
     WHERE zak_id = zak_id_p)
  LOOP
    IF oznaka_p IN ('V') AND ozn_stsj_p IN (-1) THEN
      pra_rec2.oduzmi_statussj_u (
        zaksj_c.sj_id,
        dat_poc_p,
        dat_zav_p);
    END IF;
  END LOOP;
END;
PROCEDURE PROVJERI_SJ_REZERVIRANA
 (SJ_ID_P IN t_zak_sj.sj_id%TYPE
 ,DAT_POC_P IN t_zakup.dat_poc%TYPE
 ,DAT_ZAV_P IN t_zakup.dat_zav%TYPE
 ,OZNAKA_P IN t_zakup.oznaka%TYPE
 ,OZN_B_P IN t_zakup.ozn_b%TYPE
 )
 IS
/*
Ne moete zakupiti SJ za koju postoji rezervacija.
*/
  br_redaka_l NUMBER;
BEGIN
  IF sj_id_p IS NULL
    OR dat_poc_p IS NULL
    OR dat_zav_p IS NULL
    OR ozn_b_p <> -1
    OR oznaka_p <> 'V'
  THEN
    RETURN;
  END IF;
  SELECT COUNT (1) INTO br_redaka_l
    FROM i_statusisj
   WHERE sj_id = sj_id_p
     AND datum >= dat_poc_p
     AND datum < dat_zav_p
     AND ozn_R > 0;

  IF br_redaka_l > 0 THEN
    pra_rec_zaj.vrati_poruku (-20381);
  END IF;
END;
PROCEDURE PROVJERI_SJ_ZAK_REZERVIRANA
 (ZAK_ID_P IN t_zakup.id%TYPE
 ,DAT_POC_P IN t_zakup.dat_poc%TYPE
 ,DAT_ZAV_P IN t_zakup.dat_zav%TYPE
 ,OZNAKA_P IN t_zakup.oznaka%TYPE
 ,OZN_B_P IN t_zakup.ozn_b%TYPE
 )
 IS
/*
SJ mora biti valjana
Ne moete zakupiti SJ za koju postoji rezervacija
Provjera za sve zaksj
*/
BEGIN
  FOR zaksj_c IN (
    SELECT sj_id
      FROM t_zak_sj
     WHERE zak_id = zak_id_p)
  LOOP
    pra_rec_s2.provjeri_sj (
      zaksj_c.sj_id,
      NULL,
      NULL,
      dat_poc_p,
      dat_zav_p - 1);
    pra_t_zakup.provjeri_sj_rezervirana (
      zaksj_c.sj_id,
      dat_poc_p,
      dat_zav_p,
      oznaka_p,
      ozn_b_p);
  END LOOP;
END;
PROCEDURE AZURIRAJ_BOOKING_X_ZAKSJ
 (SO_ID_P IN i_booking.so_id%TYPE
 ,SJ_ID_P IN m_sj.id%TYPE
 ,OZNAKA_P IN t_zakup.oznaka%TYPE
 ,OZN_B_P IN t_zakup.ozn_b%TYPE
 ,DAT_POC_P IN i_booking.datum%TYPE
 ,DAT_ZAV_P IN i_booking.datum%TYPE
 ,MS_ID_P IN i_booking.ms_id%TYPE
 ,AGE_ID_P IN i_booking.age_id%TYPE
 ,KOL_SJ_P IN i_booking.kol_sj%TYPE
 ,CIJENA_SJ_P IN i_booking.cijena_sj%TYPE
 )
 IS
--
  datum_l i_booking.datum%TYPE;
  vsj_id_l i_booking.vsj_id%TYPE;
  br_osoba_l i_booking.br_osoba%TYPE;
  nebitno_l NUMBER;

  CURSOR stsj_c (datum_k i_booking.datum%TYPE) IS
    SELECT 1
      FROM i_statusisj
     WHERE sj_id = sj_id_p
       AND datum = datum_k
       AND gost_id IS NOT NULL;

  CURSOR book_c (
    vsj_id_k i_booking.vsj_id%TYPE,
    datum_k i_booking.datum%TYPE)
  IS
    SELECT 1
      FROM i_booking
     WHERE so_id = so_id_p
       AND ms_id = ms_id_p
       AND NVL (age_id, 0) = NVL (age_id_p, 0)
       AND ponso_id IS NULL
       AND vsj_id = vsj_id_k
       AND datum = datum_k
       AND ozn_sprodaje = 'X'
       FOR UPDATE OF kol_sj NOWAIT;
BEGIN
  IF oznaka_p IN ('V') AND ozn_B_p IN (-1) THEN
    SELECT br_opostelja, vsj_id INTO br_osoba_l, vsj_id_l
      FROM m_sj
     WHERE id = sj_id_p;
    datum_l := dat_poc_p;
    WHILE datum_l < dat_zav_p LOOP
      OPEN stsj_c (datum_l);
      FETCH stsj_c INTO nebitno_l;
      IF stsj_c%FOUND THEN
        OPEN book_c (vsj_id_l, datum_l);
        FETCH book_c INTO nebitno_l;
        IF book_c%FOUND THEN
          UPDATE i_booking
             SET kol_sj = kol_sj + kol_sj_p,
                 br_osoba = NVL (br_osoba, 0) + NVL (kol_sj_p * br_osoba_l, 0),
                 cijena_sj = NVL (cijena_sj_p, cijena_sj)
           WHERE CURRENT OF book_c;
        ELSE
          INSERT INTO i_booking (
              so_id,
              ms_id,
              age_id,
              vsj_id,
              datum,
              ozn_sprodaje,
              kol_sj,
              br_osoba,
              cijena_sj)
            VALUES (
              so_id_p,
              ms_id_p,
              age_id_p,
              vsj_id_l,
              datum_l,
              'X',
              kol_sj_p,
              kol_sj_p * br_osoba_l,
              cijena_sj_p);
        END IF;
        CLOSE book_c;
      END IF;
      CLOSE stsj_c;
      datum_l := datum_l + 1;
    END LOOP;
  END IF;
EXCEPTION
  WHEN OTHERS THEN
    IF stsj_c%ISOPEN THEN
      CLOSE stsj_c;
    END IF;
    IF book_c%ISOPEN THEN
      CLOSE book_c;
    END IF;
    RAISE;
END;
PROCEDURE AZURIRAJ_BOOKING_X_ZAKUP
 (ZAK_ID_P IN t_zakup.id%TYPE
 ,SO_ID_P IN i_booking.so_id%TYPE
 ,OZNAKA_P IN t_zakup.oznaka%TYPE
 ,OZN_B_P IN t_zakup.ozn_b%TYPE
 ,DAT_POC_P IN i_booking.datum%TYPE
 ,DAT_ZAV_P IN i_booking.datum%TYPE
 ,MS_ID_P IN i_booking.ms_id%TYPE
 ,AGE_ID_P IN i_booking.age_id%TYPE
 ,KOL_SJ_P IN i_booking.kol_sj%TYPE
 )
 IS
/*
Auriraj booking stupanj prodaje X za sve zaksj
*/
BEGIN
  FOR zaksj_c IN (
    SELECT sj_id
      FROM t_zak_sj
     WHERE zak_id = zak_id_p)
  LOOP
    pra_t_zakup.azuriraj_booking_x_zaksj (
      so_id_p,
      zaksj_c.sj_id,
      oznaka_p,
      ozn_b_p,
      dat_poc_p,
      dat_zav_p,
      ms_id_p,
      age_id_p,
      kol_sj_p,
      NULL);
  END LOOP;
END;
PROCEDURE PROVJERI_ZAK_OZNAKA
 (ZAK_ID_P IN t_zakup.id%TYPE
 ,ZAKSJ_ID_P IN t_zak_sj.id%TYPE
 )
 IS
/*
Zabrani izmjenu stavaka ponitenog ugovora o zakupu kamp prostora.
*/
  br_redaka_l NUMBER;
BEGIN
  IF (zak_id_p IS NULL AND zaksj_id_p IS NULL)
    OR
     (zak_id_p IS NOT NULL AND zaksj_id_p IS NOT NULL)
  THEN
    RETURN;
  END IF;
  IF zak_id_p IS NOT NULL THEN
    SELECT COUNT (1) INTO br_redaka_l
      FROM t_zakup
     WHERE id = zak_id_p
       AND oznaka <> 'V';
  ELSE
    SELECT COUNT (1) INTO br_redaka_l
      FROM t_zakup,
           t_zak_sj
     WHERE t_zak_sj.zak_id = t_zakup.id
       AND t_zak_sj.id = zaksj_id_p
       AND t_zakup.oznaka <> 'V';
  END IF;
  IF br_redaka_l > 0 THEN
    pra_rec_zaj.vrati_poruku (-20055);
  END IF;
END;
PROCEDURE VRATI_ZAK
 (ZAK_ID_P IN t_zakup.id%TYPE
 ,VPDOG_ID_P OUT t_zakup.vpdog_id%TYPE
 ,IZN_TECAJA_P OUT t_zakup.izn_tecaja%TYPE
 ,DAT_POC_P OUT t_zakup.dat_poc%TYPE
 ,DAT_ZAV_P OUT t_zakup.dat_zav%TYPE
 ,SO_ID_P OUT t_zakup.so_id%TYPE
 )
 IS
/*
Prodaci potrebni za izraun poreza na dodatnu vrijednost
IRN 4118; so_id je potreban za provjeru u mrec_so_usl
*/
BEGIN
  SELECT vpdog_id, izn_tecaja, dat_poc, dat_zav, so_id
    INTO vpdog_id_p, izn_tecaja_p, dat_poc_p, dat_zav_p, so_id_p
    FROM t_zakup
   WHERE id = zak_id_p;
END;
PROCEDURE INSERT_RECZAKPDV
 (ZAK_ID_P IN irec_zak_pdv.zak_id%TYPE
 ,RAC_ID_P IN irec_zak_pdv.rac_id%TYPE
 ,VPISPZ_ID_P IN irec_zak_pdv.vpispz_id%TYPE
 ,DATUM_P IN irec_zak_pdv.datum%TYPE
 ,IZNOS_P IN irec_zak_pdv.iznos%TYPE
 ,STOPA_PDV_P IN irec_zak_pdv.stopa_pdv%TYPE
 ,OZN_ZARACUNATO_P IN NUMBER := 0
 )
 IS
BEGIN
  INSERT INTO irec_zak_pdv (
      zak_id,
      rac_id,
      vpispz_id,
      datum,
      iznos,
      stopa_pdv,
      ozn_zaracunato)
    VALUES (
      zak_id_p,
      rac_id_p,
      vpispz_id_p,
      datum_p,
      iznos_p,
      stopa_pdv_p,
      ozn_zaracunato_p);
END;
PROCEDURE DODAJ_RECZAKPDV1
 (ZAK_ID_P IN t_zakup.id%TYPE
 ,IZN_TECAJA_P IN t_zakup.izn_tecaja%TYPE
 ,DAT_POC_P IN t_zakup.dat_poc%TYPE
 ,DAT_ZAV_P IN t_zakup.dat_zav%TYPE
 ,DAT_POC_1_P IN t_zakup.dat_poc%TYPE
 ,DAT_ZAV_1_P IN t_zakup.dat_zav%TYPE
 ,USL_ID_P IN trec_zak_usl.usl_id%TYPE
 ,KOLICINA_P IN trec_zak_usl.kolicina%TYPE
 ,CIJENA_P IN trec_zak_usl.cijena%TYPE
 ,VPISPZ_ID_P IN trec_zak_usl.vpispz_id%TYPE
 ,STOPA_PDV_P IN trec_zak_usl.stopa_pdv%TYPE
 ,OBR_ZDANA_P IN trec_zak_usl.obr_zdana%TYPE
 ,DATUM_P IN irec_zak_pdv.datum%TYPE
 )
 IS
--
  datum_l irec_zak_pdv.datum%TYPE;
  iznos1_l irec_zak_pdv.iznos%TYPE;
  br_dana_l NUMBER;
BEGIN
  IF zak_id_p IS NULL
    OR izn_tecaja_p IS NULL
    OR dat_poc_p IS NULL
    OR dat_zav_p IS NULL
    OR dat_poc_1_p IS NULL
    OR dat_zav_1_p IS NULL
    OR usl_id_p IS NULL
    OR kolicina_p IS NULL
    OR cijena_p IS NULL
    OR vpispz_id_p IS NULL
    OR stopa_pdv_p IS NULL
    OR obr_zdana_p IS NULL
  THEN
    RETURN;
  END IF;

  IF izn_tecaja_p = 0
    OR kolicina_p = 0
    OR cijena_p = 0
    OR dat_poc_p > dat_zav_p
    OR dat_poc_1_p > dat_zav_1_p
  THEN
    RETURN;
  END IF;

  -- iznos osnovice dnevno u domaoj valuti
  iznos1_l :=
    ROUND (
      kolicina_p * cijena_p * izn_tecaja_p / (dat_zav_p - obr_zdana_p - dat_poc_p) * 100 / (100 + stopa_pdv_p),
      8);

  IF datum_p IS NULL THEN
    -- knjii pdv po danima
    datum_l := dat_poc_1_p;
    WHILE datum_l <= (dat_zav_1_p - 1 - obr_zdana_p)
    LOOP
      pra_t_zakup.insert_reczakpdv (
        zak_id_p,
        NULL,
        vpispz_id_p,
        datum_l,
        iznos1_l,
        stopa_pdv_p,
        0);
      datum_l := datum_l + 1;
    END LOOP;
  ELSE
    -- knjii pdv na zadani datum
    IF datum_p <= dat_zav_p AND obr_zdana_p = -1 THEN
      /*
      zadnji dan usluge se rauna, pa kod naknadnog knjienja poreza
      gdje se ugovoreno razdoblje lomi na tekui datum (= datum_p)
      zavrni datum usluge treba umanjiti za 1 dan kako se ne bi raunao dva puta
      */
      br_dana_l := dat_zav_1_p - dat_poc_1_p;
    ELSE
      br_dana_l := dat_zav_1_p - obr_zdana_p - dat_poc_1_p;
    END IF;
    IF br_dana_l > 0 THEN
      pra_t_zakup.insert_reczakpdv (
        zak_id_p,
        NULL,
        vpispz_id_p,
        datum_p,
        br_dana_l * iznos1_l,
        stopa_pdv_p,
        0);
    END IF;
  END IF;
END;
PROCEDURE DODAJ_RECZAKPDV
 (ZAK_ID_P IN t_zakup.id%TYPE
 ,IZN_TECAJA_P IN t_zakup.izn_tecaja%TYPE
 ,DAT_POC_P IN t_zakup.dat_poc%TYPE
 ,DAT_ZAV_P IN t_zakup.dat_zav%TYPE
 ,DAT_POC_1_P IN t_zakup.dat_poc%TYPE
 ,DAT_ZAV_1_P IN t_zakup.dat_zav%TYPE
 ,KOLICINA_P IN trec_zak_usl.kolicina%TYPE
 ,DATUM_P IN irec_zak_pdv.datum%TYPE
 )
 IS
BEGIN
  IF zak_id_p IS NULL
    OR izn_tecaja_p IS NULL
    OR dat_poc_p IS NULL
    OR dat_zav_p IS NULL
    OR dat_poc_1_p IS NULL
    OR dat_zav_1_p IS NULL
    OR kolicina_p IS NULL
  THEN
    RETURN;
  END IF;
  FOR reczakusl_c IN (
    SELECT usl_id,
           kolicina,
           cijena,
           vpispz_id,
           stopa_pdv,
           obr_zdana
      FROM trec_zak_usl
     WHERE zak_id = zak_id_p)
  LOOP
    pra_t_zakup.dodaj_reczakpdv1 (
      zak_id_p,
      izn_tecaja_p,
      dat_poc_p,
      dat_zav_p,
      dat_poc_1_p,
      dat_zav_1_p,
      reczakusl_c.usl_id,
      reczakusl_c.kolicina * kolicina_p,
      reczakusl_c.cijena,
      reczakusl_c.vpispz_id,
      reczakusl_c.stopa_pdv,
      reczakusl_c.obr_zdana,
      datum_p);
  END LOOP;
END;
PROCEDURE DODAJ_RECZAKPDV_TRO
 (TRO_ID_P IN t_troskovi.id%TYPE
 ,ZAK_ID_P IN t_racuni.zak_id%TYPE
 ,ZAK_IZN_TECAJA_P IN t_zakup.izn_tecaja%TYPE
 ,RECZAKUSL_VPISPZ_ID_P IN trec_zak_usl.vpispz_id%TYPE
 ,RECZAKUSL_STOPA_PDV_P IN trec_zak_usl.stopa_pdv%TYPE
 ,RAC_ID_P IN t_racuni.id%TYPE
 ,RAC_DATUM_P IN t_racuni.datum%TYPE
 )
 IS
--
  CURSOR tro_c IS
    SELECT *
      FROM t_troskovi
     WHERE id = tro_id_p;
  tro_c_l  tro_c%ROWTYPE;

  iznos_l          irec_zak_pdv.iznos%TYPE;
  cijena_po_danu_l t_troskovi.cijena_usluge%TYPE;
  datum_l          irec_zak_pdv.datum%TYPE;
  dat_pom_l        t_troskovi.dat_zav%TYPE;
BEGIN
  -- dohvati troak
  OPEN tro_c;
  FETCH tro_c INTO tro_c_l;
  CLOSE tro_c;

  -- MK 25.08.2009
  -- vpispz_id i stopa_pdv moraju biti iste kao kod kreiranja iz zakupa
  -- (i u sluaju da je raun napravljen prema drugom vpdog ili da usluga pripada drugoj vpispz ili da se stopa mijenjala)

  -- MK 15.07.2014 cijena iz troka nije cijena po danu ako ne ovisi o broju dana pa je u tom sluaju treba izraunati
  -- tu treba uzeti konane oznake (ne _poc) po kojima je naplaeno
  IF tro_c_l.obr_po_danu = -1 THEN
    cijena_po_danu_l := tro_c_l.cijena_usluge;
  ELSE
    cijena_po_danu_l := tro_c_l.cijena_usluge / (tro_c_l.dat_zav - tro_c_l.obr_zdana - tro_c_l.dat_poc);
  END IF;

  -- zbog "debele" stavke, kreni od datuma rauna
  datum_l := rac_datum_p;

  -- Kreiraj "debelu" stavku za zaraunato razdoblje,
  --     tj. od poetka troka do:
  --          - datuma rauna ukljuivo;
  --          - zavrnog datuma troka, ako je manji/jednak datumu rauna
  --                                   (pozor, zadnji dan se zauna?!)
  --
  -- "Debela" stavka nije potrebna ako zaraunatog razdoblja nema,
  --     tj. datum rauna je manji/jednak poetnom datumu troka.
  --

  IF tro_c_l.dat_poc < rac_datum_p THEN

    IF tro_c_l.dat_zav <= rac_datum_p THEN
      dat_pom_l := tro_c_l.dat_zav - tro_c_l.obr_zdana;
    ELSE
      dat_pom_l := rac_datum_p + 1;     -- + 1 da bi uraunao i cifru za datum rauna
    END IF;

    iznos_l := (tro_c_l.kol_usluge * cijena_po_danu_l * -- MK 15.07.2014 tro_c_l.cijena_usluge *
                (tro_c_l.stopa_placanja / 100) * zak_izn_tecaja_p *
                (dat_pom_l - tro_c_l.dat_poc)) * 100 / (100 + reczakusl_stopa_pdv_p) * (-1);

    pra_t_zakup.insert_reczakpdv (
      zak_id_p, rac_id_p, reczakusl_vpispz_id_p, datum_l, iznos_l, reczakusl_stopa_pdv_p, -1);

    -- stavka sa datumom rauna je kreirana,
    -- dalje kreiraj stavke od sljedeeg datuma (ako bude trebalo)
    datum_l := datum_l + 1;

  ELSE
    datum_l := tro_c_l.dat_poc;
    dat_pom_l := tro_c_l.dat_poc;

  END IF;

  -- Kreiraj dnevne stavke
  -- za sve datume troka > od datuma "debele" stavke, ako postoje.
  iznos_l := (tro_c_l.kol_usluge * cijena_po_danu_l * -- MK 15.07.2014 * tro_c_l.cijena_usluge *
              (tro_c_l.stopa_placanja / 100) * zak_izn_tecaja_p) *
              100 / (100 + reczakusl_stopa_pdv_p) * (-1);

  FOR i IN 1..(tro_c_l.dat_zav - tro_c_l.obr_zdana - dat_pom_l)
  LOOP
    pra_t_zakup.insert_reczakpdv (
      zak_id_p, rac_id_p, reczakusl_vpispz_id_p, datum_l, iznos_l, reczakusl_stopa_pdv_p, 0);
    datum_l := datum_l + 1;
  END LOOP;

END;
PROCEDURE DODAJ_RAC_RECZAKPDV
 (RAC_ID_P IN t_racuni.id%TYPE
 )
 IS
BEGIN

  -- MK 25.08.2009
  -- moraju se koristiti iste vpispz_id i stopa_pdv kao kod kreiranja iz zakupa
  -- (i u sluaju da je raun napravljen prema drugom vpdog ili da usluga pripada drugoj vpispz ili da se stopa mijenjala)

  FOR tro_c IN (
    SELECT tro.id tro_id,
           rac.datum rac_datum,
           zak.id zak_id,
           zak.izn_tecaja zak_izn_tecaja,
           reczakusl.vpispz_id reczakusl_vpispz_id,
           reczakusl.stopa_pdv reczakusl_stopa_pdv
      FROM t_troskovi tro,
           t_racuni rac,
           t_zakup zak,
           trec_zak_usl reczakusl
     WHERE rac.id = rac_id_p
       AND tro.rac_id = rac.id
       AND rac.zak_id = zak.id
       AND reczakusl.zak_id = zak.id
       AND reczakusl.usl_id = tro.usl_id
       AND tro.val_id = zak.val_id)
  LOOP
    pra_t_zakup.dodaj_reczakpdv_tro (
      tro_c.tro_id,
      tro_c.zak_id,
      tro_c.zak_izn_tecaja,
      tro_c.reczakusl_vpispz_id,
      tro_c.reczakusl_stopa_pdv,
      rac_id_p,
      tro_c.rac_datum);
  END LOOP;

END;
FUNCTION KOL_RAC
 (ZAK_ID_P IN t_racuni.zak_id%TYPE
 )
 RETURN INTEGER
 IS
--
  br_redaka_l NUMBER;
BEGIN
  SELECT COUNT(1) INTO br_redaka_l
    FROM t_racuni
   WHERE zak_id = zak_id_p
     AND oznaka = 'V';

  RETURN br_redaka_l;
END;
PROCEDURE PROVJERI_RECPLO_ZAKPLO
 (ID_P IN trec_zak_plovila.id%TYPE
 ,RECPLO_ID_P IN mrec_plovila.id%TYPE
 ,ZAKSJ_ID_P IN t_zak_sj.id%TYPE
 )
 IS
/*
PRA148148_RECZAKPLO
Plovilo se moe istovremeno nalaziti samo na jednom valjanom zakupljenom vezu.
*/
  zak_id_l t_zakup.id%TYPE;
  dat_poc_l t_zakup.dat_poc%TYPE;
  dat_zav_l t_zakup.dat_zav%TYPE;
BEGIN
   IF recplo_id_p IS NULL
     OR zaksj_id_p IS NULL
     -- Provjeriti da se plovilo moe istovremeno nalaziti samo na jednom valjanom zakupljenom vezu: da ili ne.
     OR pra_rec_zaj.vrijednost_parametra ('1092') = 'ne'
   THEN
     RETURN;
   END IF;

   -- ugovor u kojem se radi
   SELECT zak.dat_poc, zak.dat_zav, zak.id
     INTO dat_poc_l, dat_zav_l, zak_id_l
     FROM t_zak_sj zaksj, t_zakup zak
    WHERE zaksj.zak_id = zak.id
      AND zaksj.id = zaksj_id_p;

  FOR zakplo_c IN (
    SELECT
      zakplo.id,
      zaksj.zak_id,
      zakplo.zaksj_id,
      so.sifra || '-' || zak.god_poslovna || '-' || vzak.sifra || '-' || zak.rbr AS opis,
      zak.dat_poc,
      zak.dat_zav
    FROM
      trec_zak_plovila zakplo,
      t_zak_sj zaksj,
      t_zakup zak,
      m_so so,
      s_vzakupa vzak
    WHERE
      zakplo.recplo_id = recplo_id_p
      AND zakplo.zaksj_id = zaksj.id
      AND zaksj.zak_id = zak.id
      AND zak.oznaka = 'V'
      AND zak.so_id = so.id
      AND zak.vzak_id = vzak.id)
  LOOP
    -- ugovor <> od ugovora u kojem se radi
    IF zakplo_c.zak_id <> zak_id_l THEN
      IF zakplo_c.dat_poc >= dat_zav_l OR zakplo_c.dat_zav <= dat_poc_l THEN
        NULL;
      ELSE
        -- Plovilo ve uneseno #0
        pra_rec_zaj.vrati_poruku (-20418, CHR(10) || zakplo_c.opis);
      END IF;
    ELSE
      -- isti ugovor
      -- drugi vez
      IF zakplo_c.zaksj_id <> zaksj_id_p THEN
        -- Plovilo ve uneseno #0
        pra_rec_zaj.vrati_poruku (-20418);
      ELSE
        -- isti vez
        IF zakplo_c.id <> id_p THEN
          pra_rec_zaj.vrati_poruku (-20418);
        END IF;
      END IF;
    END IF;
  END LOOP;
END;
PROCEDURE PROVJERI_RECPLO_ZAK
 (ZAK_ID_P IN t_zakup.id%TYPE
 ,DAT_POC_P IN t_zakup.dat_poc%TYPE
 ,DAT_ZAV_P IN t_zakup.dat_zav%TYPE
 )
 IS
/*
PRA148148_RECZAKPLO
Plovilo se moe istovremeno nalaziti samo na jednom valjanom zakupljenom vezu.
*/
BEGIN
  IF zak_id_p IS NULL
    OR dat_poc_p IS NULL
    OR dat_zav_p IS NULL
    -- Provjeriti da se plovilo moe istovremeno nalaziti samo na jednom valjanom zakupljenom vezu: da ili ne.
    OR pra_rec_zaj.vrijednost_parametra ('1092') = 'ne'
  THEN
    RETURN;
  END IF;

  FOR zakplo_izv_c IN (
    SELECT zakplo.recplo_id
      FROM trec_zak_plovila zakplo,
           t_zak_sj zaksj
     WHERE zakplo.zaksj_id = zaksj.id
       AND zaksj.zak_id = zak_id_p)
  LOOP
    FOR zakplo_usp_c IN (
      SELECT so.sifra || '-' || zak.god_poslovna || '-' || vzak.sifra || '-' || zak.rbr AS opis,
             zak.dat_poc,
             zak.dat_zav
        FROM trec_zak_plovila zakplo,
             t_zak_sj zaksj,
             t_zakup zak,
             m_so so,
             s_vzakupa vzak
       WHERE zakplo.zaksj_id = zaksj.id
         AND zaksj.zak_id = zak.id
         AND zak.oznaka = 'V'
         AND zakplo.recplo_id = zakplo_izv_c.recplo_id
         AND so.id = zak.so_id
         AND vzak.id = zak.vzak_id
         AND zak.id <> zak_id_p)
    LOOP
      IF zakplo_usp_c.dat_poc >= dat_zav_p OR zakplo_usp_c.dat_zav <= dat_poc_p THEN
        NULL;
      ELSE
        -- Razdoblje ugovora se preklapa s ugovorom #0
        pra_rec_zaj.vrati_poruku (-20419, CHR(10) || zakplo_usp_c.opis);
      END IF;
    END LOOP;
  END LOOP;
END;

END PRA_T_ZAKUP;
/
SHOW ERROR

