PROMPT Creating Package Body 'PRA_T_REZERVACIJE'
CREATE OR REPLACE PACKAGE BODY PRA_T_REZERVACIJE IS

PROCEDURE ODUZMI_STATUSSJ
 (REZ_ID_P IN T_REZERVACIJE.ID%TYPE
 ,OZNAKA_P IN T_REZERVACIJE.OZNAKA%TYPE
 ,OZN_VSTORNA_P IN t_rezervacije.ozn_vstorna%TYPE
 ,DAT_DOLASKA_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,DAT_ODLASKA_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
 )
 IS
BEGIN
  IF oznaka_p IN ('V') AND ozn_vstorna_p IS NULL THEN -- valjana rezervacija
    NULL;
  ELSE
    RETURN;
  END IF;

  FOR rezvsj_c IN (
    SELECT id, sj_id, pra_zmp_s.vsj_je_sastavljena (vsj_id) ozn_sastavljena
      FROM t_rez_vsj
     WHERE rez_id = rez_id_p)
  LOOP
    IF rezvsj_c.sj_id IS NOT NULL 
      AND rezvsj_c.ozn_sastavljena = 0
    THEN
      pra_rec.oduzmi_statussj_r (rezvsj_c.sj_id, dat_dolaska_p, dat_odlaska_p);
    END IF;
    -- 14.08.2007. G.J.
    FOR recrezsj_c IN (
      SELECT sj_id
        FROM trec_rez_sj
       WHERE rezvsj_id = rezvsj_c.id)
    LOOP
      pra_rec.oduzmi_statussj_r (recrezsj_c.sj_id, dat_dolaska_p, dat_odlaska_p);
    END LOOP;
  END LOOP;
END;
PROCEDURE DODAJ_STATUSSJ
 (REZ_ID_P IN T_REZERVACIJE.ID%TYPE
 ,OZNAKA_P IN T_REZERVACIJE.OZNAKA%TYPE
 ,OZN_VSTORNA_P IN t_rezervacije.ozn_vstorna%TYPE
 ,DAT_DOLASKA_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,DAT_ODLASKA_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
 ,OZN_F_P IN T_REZERVACIJE.OZN_F%TYPE
 )
 IS
BEGIN
  IF oznaka_p IN ('V') AND ozn_vstorna_p IS NULL THEN -- valjana rezervacija
    NULL;
  ELSE
    RETURN;
  END IF;

  FOR rezvsj_c IN (
    SELECT id, sj_id, pra_zmp_s.vsj_je_sastavljena (vsj_id) ozn_sastavljena, 
           br_osoba, br_osobaZ,
           NVL(ozn_fiksna_sj, 0) sj_f,
           DECODE(ozn_f_p, 0, 1, 3) - NVL(ozn_fiksna_sj, 0) ozn_r
      FROM t_rez_vsj
     WHERE rez_id = rez_id_p)
  LOOP
    IF rezvsj_c.sj_id IS NOT NULL 
      AND rezvsj_c.ozn_sastavljena = 0
      AND rezvsj_c.br_osoba > NVL (rezvsj_c.br_osobaZ, 0)
    THEN
      pra_rec.dodaj_statussj_r (rezvsj_c.sj_id, dat_dolaska_p, dat_odlaska_p, rezvsj_c.ozn_r);
    END IF;
    -- 14.08.2007. G.J.
    FOR recrezsj_c IN (
      SELECT sj_id, 
             DECODE(rezvsj_c.ozn_sastavljena, 0, br_osoba, rezvsj_c.br_osoba) br_osoba, 
             DECODE(rezvsj_c.ozn_sastavljena, 0, br_osobaZ, rezvsj_c.br_osobaZ) br_osobaZ, 
             DECODE(ozn_f_p, 0, 1, 3) - NVL(ozn_fiksna_sj, 0) ozn_r
        FROM trec_rez_sj
       WHERE rezvsj_id = rezvsj_c.id)
    LOOP
      IF recrezsj_c.br_osoba > NVL (recrezsj_c.br_osobaZ, 0) THEN
        pra_rec.dodaj_statussj_r (recrezsj_c.sj_id, dat_dolaska_p, dat_odlaska_p, recrezsj_c.ozn_r);
      END IF;
    END LOOP;
  END LOOP;
END;
PROCEDURE AZURIRAJ_BOOK_REZ
 (REZ_ID_P IN t_rezervacije.id%TYPE
 ,OZNAKA_P IN T_REZERVACIJE.OZNAKA%TYPE
 ,OZN_VSTORNA_P IN t_rezervacije.ozn_vstorna%TYPE
 ,SO_ID_P IN T_REZERVACIJE.SO_ID%TYPE
 ,MS_ID_P IN T_REZERVACIJE.MS_ID%TYPE
 ,AGE_ID_P IN T_REZERVACIJE.AGE_ID%TYPE
 ,PONSO_ID_P IN I_BOOKING.PONSO_ID%TYPE
 ,RECVPRO_ID_P IN T_REZERVACIJE.RECVPRO_ID%TYPE
 ,DAT_DOLASKA_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,DAT_ODLASKA_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
 ,OZN_B_P IN T_REZERVACIJE.OZN_B%TYPE
 ,OZN_F_P IN T_REZERVACIJE.OZN_F%TYPE
 ,OZN_PLUSMINUS_P IN NUMBER
 )
 IS
-- auriraj booking kod promjene rezervacije
BEGIN
  IF oznaka_p IN ('P') OR ozn_vstorna_p IS NOT NULL
    OR (ozn_B_p <> '-1' AND ozn_F_p <> '-1')
  THEN
    RETURN;
  END IF;
  /*
  auriranje C/W ako je rez vezana na pon
  C/W se aurira neovisno o recrezsj.
  */
  IF ponso_id_p IS NOT NULL THEN
    FOR rezvsj IN (
     SELECT vsjp_id, SUM (kol_sj) kol_sj, SUM (br_osoba) br_osoba
       FROM (
            SELECT NVL (vsjp_id, rezvsj.vsj_id) vsjp_id,
                   GREATEST (kol_sj - NVL (kol_sjZ, 0), 0) kol_sj,
                   GREATEST (br_osoba - NVL (br_osobaZ, 0), 0) br_osoba
              FROM t_rez_vsj rezvsj
             WHERE rez_id = rez_id_p)
      GROUP BY vsjp_id
      )
    LOOP
      IF (rezvsj.kol_sj > 0 OR rezvsj.br_osoba > 0) THEN
         pra_t_rezervacije.azuriraj_book_rezvsj_cw (
           oznaka_p,
           ozn_vstorna_p,
           so_id_p,
           ms_id_p,
           age_id_p,
           rezvsj.vsjp_id,
           ponso_id_p,
           recvpro_id_p,
           dat_dolaska_p,
           dat_odlaska_p,
           ozn_B_p,
           ozn_F_p,
           rezvsj.kol_sj,
           rezvsj.br_osoba,
           rezvsj.vsjp_id,
           ozn_PlusMinus_p
           );
      END IF;
    END LOOP;
  END IF;

  /*
  Booking B, F, X se aurira samo za neiskoriteni dio rezervacije.
  (Ispravnije bi bilo aurirati kompletnu rezervaciju a to bi znailo osim B, F i X aurirati i Y)
  */
  /* za nesastavljene vsj */
  FOR rezvsj IN (
    SELECT vsj_id,
           SUM (kol_sj) kol_sj,
           SUM (br_osoba) br_osoba
      FROM (
           SELECT rezvsj.id rezvsj_id, NVL (sj.vsj_id, rezvsj.vsj_id) vsj_id,
                  GREATEST (rezvsj.kol_sj - NVL (rezvsj.kol_sjZ, 0), 0) kol_sj,
                  GREATEST (rezvsj.br_osoba - NVL (rezvsj.br_osobaZ, 0), 0) br_osoba
             FROM t_rez_vsj rezvsj, m_sj sj, s_vsj vsj
            WHERE rezvsj.sj_id = sj.id (+)
              AND rezvsj.vsj_id = vsj.id
              AND vsj.ozn_sastavljena = 0
              AND rez_id = rez_id_p
           UNION ALL
           SELECT rezvsj.id rezvsj_id, sj.vsj_id vsj_id,
                  1 - DECODE (NVL (recrezsj.br_osobaz, 0), 0, 0, 1) kol_sj,
                  GREATEST (recrezsj.br_osoba - NVL (recrezsj.br_osobaz, 0), 0) br_osoba
             FROM trec_rez_sj recrezsj, m_sj sj, t_rez_vsj rezvsj, s_vsj vsj
            WHERE recrezsj.sj_id = sj.id (+)
              AND recrezsj.rezvsj_id = rezvsj.id
              AND rezvsj.vsj_id = vsj.id
              AND vsj.ozn_sastavljena = 0
              AND rez_id = rez_id_p
           UNION ALL
           SELECT rezvsj.id rezvsj_id, rezvsj.vsj_id vsj_id,
                  (1 - DECODE (NVL (recrezsj.br_osobaz, 0), 0, 0, 1)) * (-1) kol_sj,
                  (GREATEST (recrezsj.br_osoba - NVL (recrezsj.br_osobaz, 0), 0)) * (-1) br_osoba
             FROM trec_rez_sj recrezsj, t_rez_vsj rezvsj, s_vsj vsj
            WHERE recrezsj.rezvsj_id = rezvsj.id
              AND rezvsj.vsj_id = vsj.id
              AND vsj.ozn_sastavljena = 0
              AND rez_id = rez_id_p
           )
     GROUP BY rezvsj_id, vsj_id -- auriramo redak vsj po redak
    )
  LOOP
    IF (rezvsj.kol_sj <> 0 OR rezvsj.br_osoba <> 0) THEN
      pra_t_rezervacije.azuriraj_book_bxf (
        so_id_p,
        ms_id_p,
        age_id_p,
        rezvsj.vsj_id,
        ponso_id_p,
        recvpro_id_p,
        dat_dolaska_p,
        dat_odlaska_p,
        ozn_B_p,
        ozn_F_p,
        rezvsj.kol_sj,
        rezvsj.br_osoba,
        ozn_PlusMinus_p
        );
    END IF;
  END LOOP;

  /* za sastavljene VSJ */
  FOR rezvsj IN (
     SELECT vsj_id,
            SUM (kol_sj) kol_sj,
            SUM (br_osoba) br_osoba
       FROM (
            SELECT rezvsj.id rezvsj_id, vsjvsj.vsjus_id vsj_id,
                   vsjvsj.kol_sj kol_sj,
                   pra_zmp_s.br_osoba_vsjus (rezvsj.vsj_id, rezvsj.br_osoba, vsjvsj.vsjus_id) br_osoba
              FROM t_rez_vsj rezvsj, s_vsj vsj, s_vsj_vsj vsjvsj
             WHERE rezvsj.vsj_id = vsj.id AND rezvsj.vsj_id = vsjvsj.vsjs_id
               /*
               po rezvsj ide samo ako po rezervaciji nita nije ekirano;
               to ni ne treba ako vrijedi pravilo da se moe ekirati samo rasporeene rezervacije
               */
               AND NVL (rezvsj.kol_sjZ, 0) = 0
               /*
               i ako nije upisana SJ jer kad je upisana SJ upisane su i stavke recrezsj pa se ide po njima
               */
               AND rezvsj.sj_id IS NULL
               AND vsj.ozn_sastavljena = -1
               AND rez_id = rez_id_p
            UNION ALL
            SELECT rezvsj.id rezvsj_id, sj.vsj_id vsj_id,
                   1 - DECODE (NVL (recrezsj.br_osobaz, 0), 0, 0, 1) kol_sj,
                   GREATEST (recrezsj.br_osoba - NVL (recrezsj.br_osobaz, 0), 0) br_osoba
              FROM trec_rez_sj recrezsj, m_sj sj, t_rez_vsj rezvsj, s_vsj vsj -- ako su upisane recrezsj ide se po njima
             WHERE recrezsj.sj_id = sj.id
               AND recrezsj.rezvsj_id = rezvsj.id
               AND rezvsj.vsj_id = vsj.id
               AND vsj.ozn_sastavljena = -1
               AND rez_id = rez_id_p
            )
      GROUP BY rezvsj_id, vsj_id
    )
  LOOP
    IF (rezvsj.kol_sj <> 0 OR rezvsj.br_osoba <> 0) THEN
      pra_t_rezervacije.azuriraj_book_bxf (
        so_id_p,
        ms_id_p,
        age_id_p,
        rezvsj.vsj_id,
        ponso_id_p,
        recvpro_id_p,
        dat_dolaska_p,
        dat_odlaska_p,
        ozn_B_p,
        ozn_F_p,
        rezvsj.kol_sj,
        rezvsj.br_osoba,
        ozn_PlusMinus_p
       );
    END IF;
  END LOOP;
END;
PROCEDURE AZURIRAJ_BOOK_REZVSJ_BXF
 (OZNAKA_P IN T_REZERVACIJE.OZNAKA%TYPE
 ,OZN_VSTORNA_P IN t_rezervacije.ozn_vstorna%TYPE
 ,SO_ID_P IN T_REZERVACIJE.SO_ID%TYPE
 ,MS_ID_P IN T_REZERVACIJE.MS_ID%TYPE
 ,AGE_ID_P IN T_REZERVACIJE.AGE_ID%TYPE
 ,VSJ_ID_P IN T_REZ_VSJ.VSJ_ID%TYPE
 ,PONSO_ID_P IN I_BOOKING.PONSO_ID%TYPE
 ,RECVPRO_ID_P IN T_REZERVACIJE.RECVPRO_ID%TYPE
 ,DAT_DOLASKA_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,DAT_ODLASKA_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
 ,OZN_B_P IN T_REZERVACIJE.OZN_B%TYPE
 ,OZN_F_P IN T_REZERVACIJE.OZN_F%TYPE
 ,KOL_SJ_P IN T_REZ_VSJ.KOL_SJ%TYPE
 ,BR_OSOBA_P IN T_REZ_VSJ.BR_OSOBA%TYPE
 ,SJ_ID_P IN T_REZ_VSJ.SJ_ID%TYPE
 ,OZN_PLUSMINUS_P IN NUMBER
 )
 IS
--
  vsj_id_l t_rez_vsj.vsj_id%TYPE;
BEGIN
  IF oznaka_p IN ('P') OR ozn_vstorna_p IS NOT NULL
    OR (kol_sj_p = 0 AND br_osoba_p = 0)
    OR (ozn_B_p <> '-1' AND ozn_F_p <> '-1')
  THEN
    RETURN;
  END IF;

  --  auriranje B, F, X
  IF  pra_zmp_s.vsj_je_sastavljena (vsj_id_p) = 0 THEN
    IF sj_id_p IS NOT NULL THEN
      SELECT vsj_id INTO vsj_id_l
        FROM m_sj sj
       WHERE sj.id = sj_id_p;
    ELSE
      vsj_id_l := vsj_id_p;
    END IF;

    pra_t_rezervacije.azuriraj_book_bxf (
       so_id_p
      ,ms_id_p
      ,age_id_p
      ,vsj_id_l -- ili sj.vsj ili rezvsj.vsj
      ,ponso_id_p
      ,recvpro_id_p -- iz rez
      ,dat_dolaska_p
      ,dat_odlaska_p
      ,ozn_b_p
      ,ozn_f_p
      ,kol_sj_p
      ,br_osoba_p
      ,ozn_PlusMinus_p
      );
  ELSE
    IF sj_id_p IS NULL THEN
      -- ako je za sastavljenu vsj popunjena sj auriranje ide preko recrezsj
      -- ako sj nije upisana onda auriranje ide preko sastava
      FOR vsjus_c IN (SELECT vsjus_id, kol_sj FROM s_vsj_vsj WHERE vsjs_id = vsj_id_p)
      LOOP
        pra_t_rezervacije.azuriraj_book_bxf (
           so_id_p
          ,ms_id_p
          ,age_id_p
          ,vsjus_c.vsjus_id -- iz sastava
          ,ponso_id_p
          ,recvpro_id_p -- iz rez
          ,dat_dolaska_p
          ,dat_odlaska_p
          ,ozn_b_p
          ,ozn_f_p
          ,vsjus_c.kol_sj -- kol_sj iz sastava
          ,pra_zmp_s.br_osoba_vsjus (vsj_id_p, br_osoba_p, vsjus_c.vsjus_id) -- br_osoba koji pripada toj vsjus
          ,ozn_PlusMinus_p
          );
       END LOOP;
     END IF;
  END IF;

END;
PROCEDURE AZURIRAJ_BOOK_REZVSJ_CW
 (OZNAKA_P IN T_REZERVACIJE.OZNAKA%TYPE
 ,OZN_VSTORNA_P IN t_rezervacije.ozn_vstorna%TYPE
 ,SO_ID_P IN T_REZERVACIJE.SO_ID%TYPE
 ,MS_ID_P IN T_REZERVACIJE.MS_ID%TYPE
 ,AGE_ID_P IN T_REZERVACIJE.AGE_ID%TYPE
 ,VSJ_ID_P IN T_REZ_VSJ.VSJ_ID%TYPE
 ,PONSO_ID_P IN I_BOOKING.PONSO_ID%TYPE
 ,RECVPRO_ID_P IN T_REZERVACIJE.RECVPRO_ID%TYPE
 ,DAT_DOLASKA_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,DAT_ODLASKA_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
 ,OZN_B_P IN T_REZERVACIJE.OZN_B%TYPE
 ,OZN_F_P IN T_REZERVACIJE.OZN_F%TYPE
 ,KOL_SJ_P IN T_REZ_VSJ.KOL_SJ%TYPE
 ,BR_OSOBA_P IN T_REZ_VSJ.BR_OSOBA%TYPE
 ,VSJP_ID_P IN t_rez_vsj.vsjp_id%TYPE
 ,OZN_PLUSMINUS_P IN NUMBER
 )
 IS
--
  recvpro_id_pon_l i_booking.recvpro_id%TYPE;
  ozn_sprodaje_l i_booking.ozn_sprodaje%TYPE;
  CURSOR recvpro_id_pon_c IS
    SELECT pon.recvpro_id, DECODE (pon.ozn_book, '3', 'C', '5', 'W', '0') ozn_sprodaje
      FROM t_ponude pon, t_pon_ojr ponojr, t_pon_so ponso
     WHERE ponso.id = ponso_id_p
       AND ponso.ponojr_id = ponojr.id
       AND ponojr.pon_id = pon.id;
BEGIN
  -- auriranje C/W - umanjivanje prihvaenih ponuda (A)/fiksnog zakupa - prema podacima iz ponude
  IF (oznaka_p IN ('P') OR ozn_vstorna_p IS NOT NULL)
    OR (kol_sj_p = 0 AND br_osoba_p = 0)
    OR (ozn_B_p <> '-1' AND ozn_F_p <> '-1')
  THEN
    RETURN;
  END IF;
  IF ponso_id_p IS NULL THEN
    RETURN;
  END IF;
  OPEN recvpro_id_pon_c;
  FETCH recvpro_id_pon_c INTO recvpro_id_pon_l, ozn_sprodaje_l;
  CLOSE recvpro_id_pon_c;
  IF ozn_sprodaje_l NOT IN ('C', 'W') THEN -- ugovori
    RETURN;
  END IF;
  pra_rec_book.azuriraj_booking_razdoblje (
    so_id_p,
    ms_id_p,
    age_id_p,
    NVL (vsjp_id_p, vsj_id_p),
    dat_dolaska_p,
    dat_odlaska_p,
    ozn_sprodaje_l, -- C ili W
    kol_sj_p * ozn_PlusMinus_p,
    br_osoba_p * ozn_PlusMinus_p,
    NULL,
    ponso_id_p,
    recvpro_id_pon_l);

END;
PROCEDURE AZURIRAJ_BOOK_BXF
 (SO_ID_P IN T_REZERVACIJE.SO_ID%TYPE
 ,MS_ID_P IN T_REZERVACIJE.MS_ID%TYPE
 ,AGE_ID_P IN T_REZERVACIJE.AGE_ID%TYPE
 ,VSJ_ID_P IN t_rez_vsj.vsjp_id%TYPE
 ,PONSO_ID_P IN I_BOOKING.PONSO_ID%TYPE
 ,RECVPRO_ID_P IN T_REZERVACIJE.RECVPRO_ID%TYPE
 ,DAT_DOLASKA_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,DAT_ODLASKA_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
 ,OZN_B_P IN T_REZERVACIJE.OZN_B%TYPE
 ,OZN_F_P IN T_REZERVACIJE.OZN_F%TYPE
 ,KOL_SJ_P IN T_REZ_VSJ.KOL_SJ%TYPE
 ,BR_OSOBA_P IN T_REZ_VSJ.BR_OSOBA%TYPE
 ,OZN_PLUSMINUS_P IN NUMBER
 )
 IS
BEGIN
  -- auriranje B - najave
  IF ozn_B_p = '-1' THEN
    pra_rec_book.azuriraj_booking_razdoblje (
      so_id_p,
      ms_id_p,
      age_id_p,
      vsj_id_p,
      dat_dolaska_p,
      dat_odlaska_p,
      'B',
      kol_sj_p * ozn_PlusMinus_p,
      br_osoba_p * ozn_PlusMinus_p,
      NULL,
      ponso_id_p,
      recvpro_id_p);
  END IF;
  -- auriranje F - fiksne najave
  IF ozn_F_p = '-1' THEN
    pra_rec_book.azuriraj_booking_razdoblje (
      so_id_p,
      ms_id_p,
      age_id_p,
      vsj_id_p,
      dat_dolaska_p,
      dat_odlaska_p,
      'F',
      kol_sj_p * ozn_PlusMinus_p,
      br_osoba_p * ozn_PlusMinus_p,
      NULL,
      ponso_id_p,
      recvpro_id_p);
    -- auriranje X - fiksirane najave - one koje su nastale iz B
    IF ozn_B_p = '-1' THEN
      pra_rec_book.azuriraj_booking_razdoblje (
        so_id_p,
        ms_id_p,
        age_id_p,
        vsj_id_p,
        dat_dolaska_p,
        dat_odlaska_p,
        'X',
        kol_sj_p * ozn_PlusMinus_p,
        br_osoba_p * ozn_PlusMinus_p,
        NULL,
        ponso_id_p,
        recvpro_id_p);
    END IF;
  END IF;

END;
PROCEDURE AZURIRAJ_BOOK_RECREZSJ
 (OZNAKA_P IN T_REZERVACIJE.OZNAKA%TYPE
 ,OZN_VSTORNA_P IN t_rezervacije.ozn_vstorna%TYPE
 ,SO_ID_P IN T_REZERVACIJE.SO_ID%TYPE
 ,MS_ID_P IN T_REZERVACIJE.MS_ID%TYPE
 ,AGE_ID_P IN T_REZERVACIJE.AGE_ID%TYPE
 ,VSJ_ID_P IN T_REZ_VSJ.VSJ_ID%TYPE
 ,PONSO_ID_P IN I_BOOKING.PONSO_ID%TYPE
 ,RECVPRO_ID_P IN T_REZERVACIJE.RECVPRO_ID%TYPE
 ,DAT_DOLASKA_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,DAT_ODLASKA_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
 ,OZN_B_P IN T_REZERVACIJE.OZN_B%TYPE
 ,OZN_F_P IN T_REZERVACIJE.OZN_F%TYPE
 ,BR_OSOBA_P IN T_REZ_VSJ.BR_OSOBA%TYPE
 ,BR_OSOBAZ_P IN trec_rez_sj.br_osobaz%type
 ,SJ_ID_P IN T_REZ_VSJ.SJ_ID%TYPE
 ,OZN_PLUSMINUS_P IN NUMBER
 )
 IS
--
  vsj_id_sj_l t_rez_vsj.vsj_id%TYPE;
  kol_sj_l t_rez_vsj.kol_sj%TYPE;
  br_osoba_l t_rez_vsj.br_osoba%TYPE;
BEGIN
  -- auriranje bookinga za recrezsj potrebno ako sj.vsj <> rezvsj.vsj
  -- C i W  nije potrebno aurirati, oni se auriraju za vsjp iz rezvsj, recrezsj na njih ne utjee

  IF (oznaka_p IN ('P') OR ozn_vstorna_p IS NOT NULL) -- rez_je_ponistena
    OR (ozn_B_p <> '-1' AND ozn_F_p <> '-1') -- booking se ne aurira
    OR (br_osobaZ_p IS NOT NULL   -- bez tog dijela uvjeta preskoili bi auriranje u sluaju br_osoba = 0 i br_osobaz IS NULL
        AND br_osoba_p <= NVL (br_osobaZ_p, 0)) -- rezervirane osobe za tu SJ su ekirane i to sve ili vie
    OR sj_id_p IS NULL
  THEN
    RETURN;
  END IF;

  SELECT vsj_id INTO vsj_id_sj_l
    FROM m_sj sj
   WHERE sj.id = sj_id_p;

  IF vsj_id_P = vsj_id_sj_l THEN -- ako je vsj sastavljena onda je siguno <> sj.vsj i ide dalje u auriranje
    RETURN;
  END IF;

  IF NVL (br_osobaZ_p,0) = 0 THEN -- ako nije ekirana niti jedna osoba za tu SJ onda se aurira booking za 1 SJ inae se aurira samo za preostali broj osoba
    kol_sj_l := 1;
  ELSE
    kol_sj_l := 0;
  END IF;
  br_osoba_l :=  br_osoba_p - NVL (br_osobaZ_p,0);

  IF ozn_plusMinus_p = 1 THEN -- dodaj booking za rezvsjsj
    IF pra_zmp_s.vsj_je_sastavljena (vsj_id_p) = 0 THEN -- za rezvsj auriramo samo za nesastavljene
      pra_t_rezervacije.azuriraj_book_bxf (
        so_id_p
       ,ms_id_p
       ,age_id_p
       ,vsj_id_p -- oduzmi za rezvsj.vsj
       ,ponso_id_p
       ,recvpro_id_p
       ,dat_dolaska_p
       ,dat_odlaska_p
       ,ozn_b_p
       ,ozn_f_p
       ,kol_sj_l
       ,br_osoba_l
       ,-1  -- ozn_PlusMinus = oduzmi_booking
       );
    END IF;
    pra_t_rezervacije.azuriraj_book_bxf (
       so_id_p
      ,ms_id_p
      ,age_id_p
      ,vsj_id_sj_l -- dodaj za sj.vsj
      ,ponso_id_p
      ,recvpro_id_p
      ,dat_dolaska_p
      ,dat_odlaska_p
      ,ozn_b_p
      ,ozn_f_p
      ,kol_sj_l
      ,br_osoba_l
      ,1  -- ozn_PlusMinus = dodaj_booking
      );
  ELSE -- oduzmi booking za rezvsjsj
    pra_t_rezervacije.azuriraj_book_bxf (
       so_id_p
      ,ms_id_p
      ,age_id_p
      ,vsj_id_sj_l -- oduzmi za sj.vsj
      ,ponso_id_p
      ,recvpro_id_p
      ,dat_dolaska_p
      ,dat_odlaska_p
      ,ozn_b_p
      ,ozn_f_p
      ,kol_sj_l
      ,br_osoba_l
      ,-1  -- ozn_PlusMinus
      );
    IF pra_zmp_s.vsj_je_sastavljena (vsj_id_p) = 0 THEN -- za rezvsj auriramo samo za nesastavljene
      pra_t_rezervacije.azuriraj_book_bxf (
        so_id_p
       ,ms_id_p
       ,age_id_p
       ,vsj_id_p -- dodaj za rezvsj.vsj
       ,ponso_id_p
       ,recvpro_id_p
       ,dat_dolaska_p
       ,dat_odlaska_p
       ,ozn_b_p
       ,ozn_f_p
       ,kol_sj_l
       ,br_osoba_l
       ,1  -- ozn_PlusMinus
       );
    END IF;
  END IF;

END;
PROCEDURE PROVJERI_BORAVAK_REZ_USL
 (ID_P IN T_REZERVACIJE.ID%TYPE
 ,DAT_DOLASKA_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,DAT_ODLASKA_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
 )
 IS
BEGIN
  IF id_p IS NULL
    OR dat_dolaska_p IS NULL
    OR dat_odlaska_p IS NULL
  THEN
    RETURN;
  END IF;

  FOR rezusl IN (
    SELECT dat_poc, dat_zav
      FROM t_rez_usl
     WHERE rez_id = id_p)
  LOOP
    IF rezusl.dat_poc IS NOT NULL THEN
      IF (rezusl.dat_poc < dat_dolaska_p OR rezusl.dat_poc > dat_odlaska_p)
        OR (rezusl.dat_zav < dat_dolaska_p OR rezusl.dat_zav > dat_odlaska_p)
      THEN
        pra_rec_zaj.vrati_poruku (-20032);
      END IF;
    END IF;
  END LOOP;
END;
PROCEDURE PROVJERI_BORAVAK_REZ_GUSL
 (REZ_ID_P IN T_REZERVACIJE.ID%TYPE
 ,DAT_DOLASKA_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,DAT_ODLASKA_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
 )
 IS
BEGIN
  IF rez_id_p IS NULL
    OR dat_dolaska_p IS NULL
    OR dat_odlaska_p IS NULL
  THEN
    RETURN;
  END IF;

  FOR rezgusl IN (
    SELECT rezgusl.dat_poc AS dat_poc, rezgusl.dat_zav AS dat_zav
      FROM t_rez_gusl rezgusl,
           t_rez_gost rezgost,
           t_rez_vsj rezvsj
     WHERE rezgusl.rezgost_id = rezgost.id
       AND rezgost.rezvsj_id = rezvsj.id
       AND rezvsj.rez_id = rez_id_p)
  LOOP
    /* Vidi REZGUSL_DAT_POC_ZAV_CK */
    IF rezgusl.dat_poc IS NOT NULL THEN
      IF (rezgusl.dat_poc < dat_dolaska_p OR rezgusl.dat_poc > dat_odlaska_p)
        OR (rezgusl.dat_zav < dat_dolaska_p OR rezgusl.dat_zav > dat_odlaska_p)
      THEN
        pra_rec_zaj.vrati_poruku (-20032);
      END IF;
    END IF;
  END LOOP;
END;
PROCEDURE PROVJERI_SJ_ZAKUPLJENA
 (OZNAKA_P IN T_REZERVACIJE.OZNAKA%TYPE
 ,OZN_VSTORNA_P IN t_rezervacije.ozn_vstorna%TYPE
 ,SJ_ID_P IN M_SJ.ID%TYPE
 ,DAT_POC_P IN I_BOOKING.DATUM%TYPE
 ,DAT_ZAV_P IN I_BOOKING.DATUM%TYPE
 )
 IS
/*
Ne moete rezervirati SJ za koju postoji ugovor o zakupu kamp prostora
sa oznakom Najava = Da.
*/
BEGIN
  IF --oznaka_p NOT IN ('V') 
    oznaka_p IN ('P') OR ozn_vstorna_p IS NOT NULL -- rezervacija je ponitena
    OR sj_id_p IS NULL
    OR dat_poc_p IS NULL OR dat_zav_p IS NULL
  THEN
    RETURN;
  END IF;
  IF pra_rec_s.postoji_zakupB_za_SJ (sj_id_p, dat_poc_p, dat_zav_p) = -1 THEN
    pra_rec_zaj.vrati_poruku (-20380);
  END IF;
END;
PROCEDURE PROVJERI_SJ_REZ_ZAKUPLJENA
 (REZ_ID_P IN T_REZERVACIJE.ID%TYPE
 ,OLD_DAT_POC_P IN I_BOOKING.DATUM%TYPE
 ,OLD_DAT_ZAV_P IN I_BOOKING.DATUM%TYPE
 ,NEW_DAT_POC_P IN I_BOOKING.DATUM%TYPE
 ,NEW_DAT_ZAV_P IN I_BOOKING.DATUM%TYPE
 ,OZNAKA_P IN T_REZERVACIJE.OZNAKA%TYPE
 ,OZN_VSTORNA_P IN t_rezervacije.ozn_vstorna%type
 )
 IS
/*
SJ mora biti valjana.
Ne moe se rezervirati SJ za koju postoji ugovor o zakupu kamp prostora
sa oznakom Najava = Da - provjera za sve rezvsj
*/
BEGIN
  IF old_dat_poc_p <> new_dat_poc_p OR old_dat_zav_p <> new_dat_zav_p
  THEN
    FOR rezvsj_c IN (
      SELECT id, sj_id
        FROM t_rez_vsj
       WHERE rez_id = rez_id_p)
    LOOP
      pra_rec_s2.provjeri_sj (
        rezvsj_c.sj_id, NULL, NULL, new_dat_poc_p, new_dat_zav_p - 1);
      pra_t_rezervacije.provjeri_sj_zakupljena (
        oznaka_p, ozn_vstorna_p, rezvsj_c.sj_id, new_dat_poc_p, new_dat_zav_p);
      -- 08.05.2007. G.J.
      FOR recrezsj_c IN (
        SELECT sj_id
          FROM trec_rez_sj
         WHERE rezvsj_id = rezvsj_c.id)
      LOOP
        pra_rec_s2.provjeri_sj (
          recrezsj_c.sj_id, NULL, NULL, new_dat_poc_p, new_dat_zav_p - 1);
        pra_t_rezervacije.provjeri_sj_zakupljena (
          oznaka_p, ozn_vstorna_p, recrezsj_c.sj_id, new_dat_poc_p, new_dat_zav_p);
      END LOOP;
    END LOOP;
  END IF;
END;
PROCEDURE PROVJERI_VSJ
 (REZ_ID_P IN T_REZERVACIJE.ID%TYPE
 ,SO_ID_P IN T_REZERVACIJE.SO_ID%TYPE
 ,DAT_POC_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,DAT_ZAV_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
 )
 IS
/*
Rezervirana VSJ mora pripadati rezerviranom SO
*/
BEGIN
  IF rez_id_p IS NULL OR so_id_p IS NULL THEN
    RETURN;
  END IF;

  FOR rezvsj IN (
    SELECT vsj_id
      FROM t_rez_vsj
     WHERE t_rez_vsj.rez_id = rez_id_p)
  LOOP
    pra_rec.provjeri_vsj (rezvsj.vsj_id, so_id_p, dat_poc_p, dat_zav_p, 1);
  END LOOP;
END;
PROCEDURE PROVJERI_RAZDOBLJE
 (ID_P IN T_REZERVACIJE.ID%TYPE
 ,RECAGOST_ID_P IN T_REZERVACIJE.RECAGOST_ID%TYPE
 ,DAT_DOLASKA_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,DAT_ODLASKA_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
 )
 IS
/*
Razdoblja boravka gosta iz arhive gostiju ne mogu se preklapati.
*/
  CURSOR rez_c IS
    SELECT rbr, dat_dolaska, dat_odlaska
      FROM t_rezervacije
     WHERE id <> NVL (id_p, -1)
       AND NVL (recagost_id, -1) = recagost_id_p
       AND oznaka = 'V'
       AND dat_dolaska <= dat_odlaska_p
       AND dat_odlaska >= dat_dolaska_p;
  rez_c_l rez_c%ROWTYPE;
BEGIN
  IF recagost_id_p IS NULL
    OR dat_dolaska_p IS NULL
    OR dat_odlaska_p IS NULL
  THEN
    RETURN;
  END IF;

  OPEN rez_c;
  LOOP
    FETCH rez_c INTO rez_c_l;
    EXIT WHEN rez_c%NOTFOUND;
    IF dat_dolaska_p >= rez_c_l.dat_odlaska
      OR dat_odlaska_p <= rez_c_l.dat_dolaska
    THEN
      NULL;
    ELSE
      CLOSE rez_c;
      pra_rec_zaj.vrati_poruku (-20442, rez_c_l.rbr);
    END IF;
  END LOOP;
  CLOSE rez_c;
END;
PROCEDURE PROVJERI_REZVSJ_KOL_SJ
 (REZVSJ_ID_P IN T_REZ_VSJ.ID%TYPE
 )
 IS
-- broj redaka u TREC_REZ_SJ ne moe biti vei od koliine SJ u T_REZ_VSJ
  br_redaka_l NUMBER;
  vsj_id_l t_rez_vsj.vsj_id%TYPE;
  kol_sj_l t_rez_vsj.kol_sj%TYPE;
BEGIN
  IF rezvsj_id_p IS NULL THEN
    RETURN;
  END IF;

  SELECT COUNT (1) INTO br_redaka_l
    FROM trec_rez_sj
   WHERE rezvsj_id = rezvsj_id_p;

  SELECT vsj_id, kol_sj INTO vsj_id_l, kol_sj_l
    FROM t_rez_vsj
   WHERE id = rezvsj_id_p;

  IF pra_zmp_s.vsj_je_sastavljena (vsj_id_l) = -1 THEN
    kol_sj_l := pra_zmp_s.kol_sj_vsjs (vsj_id_l);
  END IF;

  IF br_redaka_l > kol_sj_l THEN
    -- Broj redaka ne moe biti vei od rezervirane koliine SJ.
    pra_rec_zaj.vrati_poruku (-20447);
  END IF;
END;
PROCEDURE PROVJERI_REZVSJ_BR_OSOBA
 (REZVSJ_ID_P IN T_REZ_VSJ.ID%TYPE
 )
 IS
-- ukupan broj osoba u TREC_REZ_SJ ne moe biti vei od broja osoba u T_REZ_VSJ
  br_osoba_sta_l t_rez_vsj.br_osoba%TYPE;
  br_osoba_zag_l t_rez_vsj.br_osoba%TYPE;
BEGIN
  IF rezvsj_id_p IS NULL THEN
    RETURN;
  END IF;

  SELECT SUM (br_osoba) INTO br_osoba_sta_l
    FROM trec_rez_sj
   WHERE rezvsj_id = rezvsj_id_p;

  SELECT br_osoba INTO br_osoba_zag_l
    FROM t_rez_vsj
   WHERE id = rezvsj_id_p;

  IF NVL (br_osoba_sta_l, 0) > br_osoba_zag_l THEN
    -- Ukupan broj osoba (u rezerviranim SJ) ne moe biti vei od rezerviranog broja osoba.
    pra_rec_zaj.vrati_poruku (-20448);
  END IF;
END;
PROCEDURE PROVJERI_REZGOST_SJ_ID
 (REZVSJ_ID_P IN TREC_REZ_SJ.REZVSJ_ID%TYPE
 ,SJ_ID_P IN TREC_REZ_SJ.SJ_ID%TYPE
 )
 IS
--
  br_redaka_l NUMBER;
BEGIN
  IF rezvsj_id_p IS NULL
    OR sj_id_p IS NULL
  THEN
    RETURN;
  END IF;

  SELECT COUNT (1) INTO br_redaka_l
    FROM t_rez_gost
   WHERE rezvsj_id = rezvsj_id_p
     AND sj_id = sj_id_p;

  IF br_redaka_l > 0 THEN
    -- Rezervirana smjetajna jedinica koristi se u rezervaciji za gosta.
    pra_rec_zaj.vrati_poruku (-20451);
  END IF;
END;
PROCEDURE PROVJERI_REZGOST_BR_REDAKA
 (REZVSJ_ID_P IN TREC_REZ_SJ.REZVSJ_ID%TYPE
 ,SJ_ID_P IN TREC_REZ_SJ.SJ_ID%TYPE
 ,BR_OSOBA_P IN TREC_REZ_SJ.BR_OSOBA%TYPE
 )
 IS
--
  br_redaka_l NUMBER;
BEGIN
  IF rezvsj_id_p IS NULL
    OR sj_id_p IS NULL
    OR br_osoba_p IS NULL
  THEN
    RETURN;
  END IF;
  
  SELECT COUNT (1) INTO br_redaka_l
    FROM t_rez_gost
   WHERE rezvsj_id = rezvsj_id_p
     AND sj_id = sj_id_p
     AND ozn_fiktivni = 0;

  IF br_redaka_l > br_osoba_p THEN
    -- Broj redaka ne moe biti vei od rezerviranog broja osoba.
    pra_rec_zaj.vrati_poruku (-20075);
  END IF;

  SELECT COUNT (1) INTO br_redaka_l
    FROM t_rez_gost
   WHERE rezvsj_id = rezvsj_id_p
     AND sj_id = sj_id_p
     AND ozn_fiktivni = -1;

  IF NVL(br_redaka_l, 0) <> 0 AND NVL(br_redaka_l, 0) > 1 - br_osoba_p THEN
    -- Upisane fiktivne goste nije mogue ispravno rasporediti.
    pra_rec_zaj.vrati_poruku (-20629);
  END IF;
END;
PROCEDURE PROVJERI_RECREZCJE_DAT_POC_ZAV
 (REZ_ID_P IN trec_rez_cjeusl.rez_id%TYPE
 ,VSJ_ID_P IN trec_rez_cjeusl.vsj_id%TYPE
 ,USL_ID_P IN trec_rez_cjeusl.usl_id%TYPE
 ,DAT_POC_P IN trec_rez_cjeusl.dat_poc%TYPE
 ,DAT_ZAV_P IN trec_rez_cjeusl.dat_zav%TYPE
 )
 IS
--
  CURSOR recrezcje_c IS
    SELECT dat_poc, dat_zav
      FROM trec_rez_cjeusl
     WHERE rez_id = rez_id_p
       AND NVL (vsj_id, -1) = NVL (vsj_id_p, -1)
       AND usl_id = usl_id_p;
  dat_poc_l trec_rez_cjeusl.dat_poc%TYPE;
  dat_zav_l trec_rez_cjeusl.dat_zav%TYPE;
BEGIN
  IF rez_id_p IS NULL
    OR usl_id_p IS NULL
    OR dat_poc_p IS NULL
    OR dat_zav_p IS NULL
  THEN
    RETURN;
  END IF;

  OPEN recrezcje_c;
  LOOP
    FETCH recrezcje_c INTO dat_poc_l, dat_zav_l;
    EXIT WHEN recrezcje_c%NOTFOUND;
    IF dat_poc_p <> dat_poc_l
      AND dat_poc_p <= dat_zav_l
      AND dat_zav_p >= dat_poc_l
    THEN
      CLOSE recrezcje_c;
      -- Razdoblja rezerviranog cjenika ne mogu se preklapati.
      pra_rec_zaj.vrati_poruku (-20476);
    END IF;
  END LOOP;
  CLOSE recrezcje_c;
END;
PROCEDURE PROVJERI_REZGOST_RECAGOST
 (REZ_ID_P IN t_rezervacije.id%TYPE
 ,RECAGOST_ID_P IN t_rezervacije.recagost_id%TYPE
 )
 IS
--
  br_redaka_l NUMBER;
BEGIN
  IF rez_id_p IS NULL OR recagost_id_p IS NULL THEN
    RETURN;
  END IF;

  SELECT COUNT (1) INTO br_redaka_l
    FROM t_rez_gost rezgost,
         t_rez_vsj rezvsj
   WHERE rezgost.rezvsj_id = rezvsj.id
     AND rezvsj.rez_id = rez_id_p
     AND rezgost.recagost_id = recagost_id_p;
  IF br_redaka_l > 0 THEN
    -- Veza gosta iz arhive i rezervacije ve postoji.
    pra_rec_zaj.vrati_poruku (-20478);
  END IF;
END;
PROCEDURE PROVJERI_REZ_PON
 (PONSO_ID_P IN t_rezervacije.ponso_id%TYPE
 ,AGE_ID_P IN t_rezervacije.age_id%TYPE
 ,MS_ID_P IN t_rezervacije.ms_id%TYPE
 ,SO_ID_P IN t_rezervacije.so_id%TYPE
 ,OZNAKA_P IN t_rezervacije.oznaka%TYPE
 ,OZN_VSTORNA_P IN t_rezervacije.ozn_vstorna%TYPE
 ,OZN_B_P IN t_rezervacije.ozn_b%TYPE
 ,OZN_F_P IN t_rezervacije.ozn_f%TYPE
 )
 IS
--
  age_id_l t_ponude.age_id%TYPE;
  ms_id_l t_ponude.ms_id%TYPE;
  so_id_l t_pon_so.so_id%TYPE;
  oznaka_l t_ponude.oznaka%TYPE;
  ozn_book_l t_ponude.ozn_book%TYPE;

  CURSOR pon_c (so_id_p NUMBER) IS
    SELECT pon.age_id, pon.ms_id,
           DECODE (ponsoso.so_id, so_id_p, ponsoso.so_id, ponso.so_id) so_id,
           pon.oznaka, pon.ozn_book
      FROM t_pon_so ponso,
           t_pon_ojr ponojr,
           t_ponude pon,
           t_ponso_so ponsoso
     WHERE ponso.id = ponso_id_p
       AND ponso.ponojr_id = ponojr.id
       AND ponojr.pon_id = pon.id
       AND ponso.id = ponsoso.ponso_id(+)
     ORDER BY DECODE (NVL (ponsoso.so_id, ponso.so_id), so_id_p, 0, 1);
BEGIN
  IF ponso_id_p IS NULL THEN
    RETURN;
  END IF;

  OPEN pon_c (so_id_p);
  FETCH pon_c INTO age_id_l, ms_id_l, so_id_l, oznaka_l, ozn_book_l;
  CLOSE pon_c;

  IF oznaka_p IN ('V') AND ozn_vstorna_p IS NULL
    AND oznaka_l IN ('P')
  THEN
    -- Valjana rezervacija ne moe se vezati na ponitenu ponudu.
    pra_rec_zaj.vrati_poruku (-20486);
  END IF;
  IF age_id_l = age_id_p AND ms_id_l = ms_id_p AND so_id_l = so_id_p THEN
    NULL;
  ELSE
    -- Ako je rezervacija vezana za ponudu onda im agencija, MS i SO moraju biti jednaki.
    pra_rec_zaj.vrati_poruku (-20485);
  END IF;
  IF ozn_book_l IN ('4') THEN -- ugovor
    NULL;
  ELSIF ozn_book_l IN ('5') THEN  -- zakup, provjeriti oznake B i F
    IF ozn_B_p = -1 AND ozn_F_p = 0 THEN
      -- Ako je rezervacija vezana na fiksni zakup onda ne moe biti Najava=da a Fiksna najava=ne.
      pra_rec_zaj.vrati_poruku (-20554);
    END IF;
  ELSIF ozn_book_l IN ('3') THEN  -- potvrena ponuda, provjeriti oznake B i F ovisno o REC parametru 1138
    IF ozn_B_p = -1 AND ozn_F_p = 0 AND UPPER (pra_rec_zaj.vrijednost_parametra ('1138')) = 'NE' THEN
      -- Ako je rezervacija vezana na ponudu onda ne moe biti Najava=da a Fiksna najava=ne.
      pra_rec_zaj.vrati_poruku (-20554);
    END IF;
  ELSE
    -- Ako je rezervacija vezana za ponudu onda ponuda mora biti potvrena.
    pra_rec_zaj.vrati_poruku (-20489);
  END IF;
END;
PROCEDURE ZABRANI_IZMJENU_REZERVACIJE
 (OZNAKA_P IN t_rezervacije.oznaka%TYPE
 ,OZN_VSTORNA_P IN t_rezervacije.ozn_vstorna%TYPE
 )
 IS
BEGIN
  IF oznaka_p IS NULL THEN
    RETURN;
  END IF;
  IF oznaka_p IN ('P') OR ozn_vstorna_p IS NOT NULL THEN
    IF UPDATING ('pkaadr_id')
      OR UPDATING ('recpotk_oznaka')
      OR UPDATING ('recagost_id')
      OR UPDATING ('priga_id') -- IRN 2804
      OR UPDATING ('token_status') -- IRN 3810
    THEN
      -- provjeri je li se mijenjao jo koji stupac
      FOR c IN (
        SELECT column_name
          FROM user_tab_columns
         WHERE table_name = 'T_REZERVACIJE'
           AND column_name NOT IN ('PKAADR_ID', 'RECPOTK_OZNAKA', 'RECAGOST_ID', 'PRIGA_ID', 'TOKEN_STATUS')
         ORDER BY column_id)
      LOOP
        IF UPDATING (c.column_name) THEN
          -- Poniteni zapis nije doputeno mijenjati.
          pra_rec_zaj.vrati_poruku (-20055);
        END IF;
      END LOOP;
    ELSE
      -- Poniteni zapis nije doputeno mijenjati.
      pra_rec_zaj.vrati_poruku (-20055);
    END IF;
  END IF;
END;
PROCEDURE PROVJERI_DOPUSTENU_TRANZICIJU
 (REZ_ID_P IN t_rezervacije.id%TYPE
 ,OZNAKA_NEW_P IN T_REZERVACIJE.OZNAKA%TYPE
 ,OZNAKA_OLD_P IN T_REZERVACIJE.OZNAKA%TYPE
 ,OZN_VSTORNA_NEW_P IN t_rezervacije.ozn_vstorna%TYPE
 ,OZN_VSTORNA_OLD_P IN t_rezervacije.ozn_vstorna%TYPE
 )
 IS
-- Procedura se koristi u BUR okidau tablice T_REZERVACIJE
  redaka_l NUMBER;
BEGIN
  IF oznaka_new_p IS NULL
    OR oznaka_old_p IS NULL
    OR (oznaka_new_p = oznaka_old_p AND NVL (ozn_vstorna_old_p, 0) = NVL (ozn_vstorna_new_p, 0))
  THEN
    RETURN;
  END IF;

  SELECT COUNT (1) INTO redaka_l
    FROM t_rez_vsj
   WHERE rez_id = rez_id_p
     AND (NVL (kol_sjz, 0) > 0 OR NVL (br_osobaz, 0) > 0);

  IF oznaka_old_p IN ('V') AND
    (oznaka_new_p = 'P' AND NVL (redaka_l, 0) = 0
     OR
    (oznaka_new_p IN ('V', 'P') -- oznaka se moe mijenjati V u P ili ostati V
     AND ozn_vstorna_old_p IS NULL
     AND 0 <= NVL (ozn_vstorna_new_p, 0) -- ozn_vstorna se moe mijenjati iz prazno u neto ili ostati prazno
    )
    )
  THEN
    NULL;
  ELSE
    -- Nedoputena tranzicija oznake dokumenata.
    pra_rec_zaj.vrati_poruku (-20056);
  END IF;
END;
PROCEDURE AZURIRAJ_PKAADR_ID
 (PKAADR_ID_P IN MPKA_ADRESE.ID%TYPE
 ,REZ_ID_P IN T_REZERVACIJE.ID%TYPE
 )
 IS
BEGIN
  UPDATE t_rezervacije SET pkaadr_id = pkaadr_id_p WHERE id = rez_id_p;
  COMMIT;
END;
PROCEDURE PROVJERI_DAT_STORNA
 (DAT_STORNA_P IN T_REZERVACIJE.DAT_STORNA%TYPE
 ,DAT_REZ_P IN T_REZERVACIJE.DATUM%TYPE
 )
 IS
BEGIN
  IF dat_storna_p IS NULL OR dat_rez_p IS NULL THEN
    RETURN;
  END IF;

  IF dat_storna_p >= dat_rez_p AND dat_storna_p <= TRUNC (SYSDATE) THEN
    NULL;
  ELSE
    -- Datum ponitavanja mora biti vei ili jednak datumu rezervacije i manji ili jednak tekuem datumu.
    pra_rec_zaj.vrati_poruku (-20604);
  END IF;
END;
PROCEDURE BRISI_RECREZSJ_ZA_SJS
 (REZVSJ_ID_P IN t_rez_vsj.id%TYPE
 )
 IS
BEGIN
  -- brii recrezsj za sastavljenu sj (kada se brie rezvsj.sj_id moraju se brisati rezrezsj)
  IF rezvsj_id_p IS NULL THEN
    RETURN;
  END IF;
  UPDATE t_rez_gost SET sj_id = NULL WHERE rezvsj_id = rezvsj_id_p AND sj_id IS NOT NULL;
  DELETE FROM trec_rez_sj WHERE rezvsj_id = rezvsj_id_p;
END;
PROCEDURE PROMIJENI_RECREZSJ_ZA_SJS
 (REZVSJ_ID_P IN t_rez_vsj.id%TYPE
 ,VSJ_ID_P IN t_rez_vsj.vsj_id%TYPE
 ,BR_OSOBA_P IN  t_rez_vsj.br_osoba%TYPE
 ,SJ_ID_P IN t_rez_vsj.sj_id%TYPE
 ,OZN_FIKSNA_SJ_P IN t_rez_vsj.ozn_fiksna_sj%TYPE
 )
 IS
--
  br_osoba_vsjus_l NUMBER;
  br_osoba_za_svaku_sj_l NUMBER;
  ostatak_osoba_l NUMBER;
  br_osoba_l NUMBER;
BEGIN
  -- promijeni br_osoba u recrezsj za sastavljenu sj u rezvsj
  IF rezvsj_id_p IS NULL OR vsj_id_p IS NULL OR br_osoba_p IS NULL OR sj_id_p IS NULL THEN
    RETURN;
  END IF;
  FOR vsjus_c IN (SELECT vsjus_id, kol_sj FROM s_vsj_vsj WHERE vsjs_id = vsj_id_p)
  LOOP
    br_osoba_vsjus_l := pra_zmp_s.br_osoba_vsjus (vsj_id_p, br_osoba_p, vsjus_c.vsjus_id);
    br_osoba_za_svaku_sj_l := FLOOR (br_osoba_vsjus_l / vsjus_c.kol_sj);
    ostatak_osoba_l := MOD (br_osoba_vsjus_l, vsjus_c.kol_sj);
    FOR sjp_c IN (
      SELECT id sj_id, brojs, (br_opostelja + br_ppostelja)
        FROM m_sj 
       WHERE (id = sj_id_p OR sjp_id = sj_id_p)
         AND vsj_id = vsjus_c.vsjus_id
       ORDER BY 2, 3 DESC)
    LOOP
      IF ostatak_osoba_l > 0 THEN
        br_osoba_l := br_osoba_za_svaku_sj_l + 1;
        ostatak_osoba_l := ostatak_osoba_l - 1;
      ELSE
        br_osoba_l := br_osoba_za_svaku_sj_l;
      END IF;
      UPDATE trec_rez_sj
         SET br_osoba = br_osoba_l,
             ozn_fiksna_sj = ozn_fiksna_sj_p
       WHERE rezvsj_id = rezvsj_id_p
         AND sj_id = sjp_c.sj_id 
         AND (br_osoba <> br_osoba_l OR NVL (ozn_fiksna_sj, 0) <> NVL (ozn_fiksna_sj_p, 0));
    END LOOP;
  END LOOP;
END;
PROCEDURE UPISI_RECREZSJ_ZA_SJS
 (REZVSJ_ID_P IN t_rez_vsj.id%TYPE
 ,VSJ_ID_P IN t_rez_vsj.vsj_id%TYPE
 ,BR_OSOBA_P IN  t_rez_vsj.br_osoba%TYPE
 ,SJ_ID_P IN t_rez_vsj.sj_id%TYPE
 ,OZN_FIKSNA_SJ_P IN t_rez_vsj.ozn_fiksna_sj%TYPE
 )
 IS
--
  br_osoba_vsjus_l NUMBER;
  br_osoba_za_svaku_sj_l NUMBER;
  ostatak_osoba_l NUMBER;
  br_osoba_l NUMBER;
BEGIN
  -- upii recrezsj za sastavljenu sj u rezvsj
  IF rezvsj_id_p IS NULL OR vsj_id_p IS NULL OR br_osoba_p IS NULL OR sj_id_p IS NULL THEN
    RETURN;
  END IF;
  FOR vsjus_c IN (SELECT vsjus_id, kol_sj FROM s_vsj_vsj WHERE vsjs_id = vsj_id_p)
  LOOP
    br_osoba_vsjus_l := pra_zmp_s.br_osoba_vsjus (vsj_id_p, br_osoba_p, vsjus_c.vsjus_id);
    br_osoba_za_svaku_sj_l := FLOOR (br_osoba_vsjus_l / vsjus_c.kol_sj);
    ostatak_osoba_l := MOD (br_osoba_vsjus_l, vsjus_c.kol_sj);
    FOR sjp_c IN (
      SELECT id sj_id, brojs, (br_opostelja + br_ppostelja) 
        FROM m_sj
       WHERE (id = sj_id_p OR sjp_id = sj_id_p)
         AND vsj_id = vsjus_c.vsjus_id 
       ORDER BY 2, 3 DESC)
    LOOP
      IF ostatak_osoba_l > 0 THEN
        br_osoba_l := br_osoba_za_svaku_sj_l + 1;
        ostatak_osoba_l := ostatak_osoba_l - 1;
      ELSE
        br_osoba_l := br_osoba_za_svaku_sj_l;
      END IF;
      INSERT INTO trec_rez_sj (id, rezvsj_id, sj_id, br_osoba, ozn_fiksna_sj) 
        VALUES (NULL, rezvsj_id_p, sjp_c.sj_id, br_osoba_l, ozn_fiksna_sj_p);
    END LOOP;
  END LOOP;
END;
FUNCTION REZ_PKAADR_ID
 (REZ_ID_P IN T_REZERVACIJE.ID%TYPE
 )
 RETURN NUMBER
 IS
--
  CURSOR rez_c IS
    SELECT ime, prezime, naz_ulice, email, NVL(zem_id, zemd_id) zema_id,
           recagost_id recagost_id, pkaadr_id, dat_dolaska
      FROM t_rezervacije
     WHERE id = rez_id_p;
  rez_c_l rez_c%ROWTYPE;

  CURSOR pkaadr_recagost_c (recagost_id_k IN mpka_adrese.recagost_id%TYPE) IS
    SELECT id, ime, prezime, naz_ulice, email, zem_id
      FROM mpka_adrese
     WHERE recagost_id = recagost_id_k
     ORDER BY id DESC; -- prvo najnovije
  pkaadr_recagost_c_l pkaadr_recagost_c%ROWTYPE;

  CURSOR recagost_c (recagost_id_k IN trec_agostiju.id%TYPE) IS
    SELECT id id, ime, prezime, naz_ulice, email, NVL(zem_id, zemd_id) zema_id
      FROM trec_agostiju
     WHERE id = recagost_id_k;
  recagost_c_l recagost_c%ROWTYPE;

  CURSOR pkaadr_c (ime_k t_rezervacije.ime%TYPE,
                   prezime_k t_rezervacije.prezime%TYPE,
                   naz_ulice_k t_rezervacije.naz_ulice%TYPE,
                   email_k t_rezervacije.email%TYPE,
                   zem_id_k t_rezervacije.zem_id%TYPE,
                   dat_k IN t_rezervacije.dat_dolaska%TYPE) IS
    SELECT id
      FROM mpka_adrese
           -- uzmi staru adresu ako je:
     WHERE zem_id = NVL(zem_id_k, zem_id)
       AND prezime IS NOT NULL
       AND CONVERT (UPPER (prezime), 'US7ASCII') = CONVERT (UPPER (prezime_k), 'US7ASCII')
       AND CONVERT (UPPER (NVL (ime, 'III-III')), 'US7ASCII') = CONVERT (UPPER (NVL (ime_k, NVL (ime, 'III-III'))), 'US7ASCII')
       AND CONVERT (UPPER (NVL (naz_ulice, 'III-III')), 'US7ASCII') = CONVERT (UPPER (NVL (naz_ulice_k, NVL (naz_ulice, 'III-III'))), 'US7ASCII')
       AND CONVERT (UPPER (NVL (email, 'III-III')), 'US7ASCII') = CONVERT (UPPER (NVL (email_k, NVL (email, 'III-III'))), 'US7ASCII')
       AND dat_k < NVL (dat_ponisten, dat_k + 1)
     ORDER BY unos_dat DESC;

  pkaadr_c_l pkaadr_c%ROWTYPE;

  pkaadr_id_l mpka_adrese.id%TYPE;
BEGIN
  /*
  Ova procedura pokuava vezati rezervaciju bez adrese na odgovarajuu (novu) adresu prema dostupnim podacima.
  */

  OPEN rez_c;
  FETCH rez_c INTO rez_c_l;
  CLOSE rez_c;

  IF rez_c_l.pkaadr_id IS NOT NULL THEN
    RETURN NULL;
  END IF;

  -- provjeri postojanje sline adrese
  OPEN pkaadr_c (rez_c_l.ime, rez_c_l.prezime, rez_c_l.naz_ulice, rez_c_l.email, rez_c_l.zema_id, rez_c_l.dat_dolaska);
  FETCH pkaadr_c INTO pkaadr_id_l;
  CLOSE pkaadr_c;

  IF pkaadr_id_l IS NULL THEN
  -- takva adresa ne postoji

    IF NVL(rez_c_l.naz_ulice, rez_c_l.email) IS NULL OR rez_c_l.zema_id IS NULL THEN
    -- u rezervaciji nema (dovoljno) podataka za kreiranje adrese

      IF rez_c_l.recagost_id IS NOT NULL THEN
      -- u rezervaciji postoji gost iz arhive

        -- potrai vezanu adresu, ako postoji
        OPEN pkaadr_recagost_c (rez_c_l.recagost_id);
        FETCH pkaadr_recagost_c INTO pkaadr_recagost_c_l;
        CLOSE pkaadr_recagost_c;

        IF pkaadr_recagost_c_l.id IS NULL THEN
        -- gost iz arhive nije vezan na adresu;

          -- provjeri ima li u arhivi dovoljno podataka za kreiranje adrese
          OPEN recagost_c (rez_c_l.recagost_id);
          FETCH recagost_c INTO recagost_c_l;
          CLOSE recagost_c;

          OPEN pkaadr_c (recagost_c_l.ime, recagost_c_l.prezime, recagost_c_l.naz_ulice, recagost_c_l.email, recagost_c_l.zema_id, rez_c_l.dat_dolaska);
          FETCH pkaadr_c INTO pkaadr_id_l;
          CLOSE pkaadr_c;

          IF pkaadr_id_l IS NULL AND
            recagost_c_l.prezime IS NOT NULL AND
            NVL (recagost_c_l.naz_ulice, recagost_c_l.email) IS NOT NULL AND
            recagost_c_l.zema_id IS NOT NULL
          THEN
            -- kreiraj adresu i vei je uz arhivu
            INSERT INTO mpka_adrese (ime, prezime, naz_ulice, email, zem_id, recagost_id)
              VALUES (recagost_c_l.ime, recagost_c_l.prezime, recagost_c_l.naz_ulice, recagost_c_l.email, recagost_c_l.zema_id, recagost_c_l.id)
              RETURNING id INTO pkaadr_id_l;
            COMMIT;

          ELSE
          -- u arhivi gostiju nema dovoljno podataka za kreiranje adrese;

            -- javi greku: nema dovoljno podataka.
            NULL;
          END IF;

        ELSE
        -- gost iz arhive vezan je na adresu;
          -- nema svjeijih podataka pa uzimamo tu adresu kao adresu za predraun
          pkaadr_id_l := pkaadr_recagost_c_l.id;
        END IF;

      ELSE
      -- rezervacija nema podataka za izradu adresu i nije vezana na gosta iz arhive;
        -- javiti greku: nema dovoljno podataka.
        NULL;
      END IF;

    ELSE
    -- u rezervaciji postoje svjei podaci za adresu;

      -- kreiraj novu adresu
      INSERT INTO mpka_adrese (ime, prezime, naz_ulice, email, zem_id)
        VALUES (rez_c_l.ime, rez_c_l.prezime, rez_c_l.naz_ulice, rez_c_l.email, rez_c_l.zema_id)
        RETURNING id INTO pkaadr_id_l;
      COMMIT;
    END IF;

  END IF;

  IF pkaadr_id_l IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20636);
  END IF;

  RETURN pkaadr_id_l;

END;
PROCEDURE PROVJERI_REZGOST_PRISTUPNI_KOD
 (REZ_ID_P IN t_rezervacije.id%TYPE
 ,PRISTUPNI_KOD_P IN t_rezervacije.pristupni_kod%TYPE
 )
 IS
-- IRN 3200
  br_redaka_l NUMBER;
BEGIN
  IF rez_id_p IS NULL
    OR pristupni_kod_p IS NULL
  THEN
    RETURN;
  END IF;
  SELECT COUNT (1) INTO br_redaka_l
    FROM t_rez_gost rezgost,
         t_rez_vsj rezvsj
   WHERE rezgost.rezvsj_id = rezvsj.id
     AND rezvsj.rez_id = rez_id_p
     AND rezgost.pristupni_kod IS NOT NULL;
  IF br_redaka_l > 0 THEN
    -- Osobe (#0) promatrane rezervacije ve imaju pristupni kod.
    pra_rec_zaj.vrati_poruku (-20650, br_redaka_l);
  END IF;
END;
PROCEDURE PROVJERI_STSJ_REZ
 (REZ_ID_P IN T_REZERVACIJE.ID%TYPE
 ,OZNAKA_P IN T_REZERVACIJE.OZNAKA%TYPE
 ,OZN_VSTORNA_P IN T_REZERVACIJE.OZN_VSTORNA%TYPE
 ,REZ_DAT_POC_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,REZ_DAT_ZAV_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
 ,DAT_POC_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,DAT_ZAV_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
 )
 IS
-- kod promjene razdoblja rezervacije provjeravamo da su rezervirane SJ u novom razdoblju slobodne
-- ako su sj bile automatski dodane prilikom preuzimanja iz vanjskog sustava i u novom razdoblju nisu slobodne 
--    one su prilikom auriranja zaglavlja ve brisane  
-- prilikom izmjene rezervacije u modulu se poziva procedura fm_rec2120.provjeri_status_sj koja javlja detaljniju greku
-- ova se poziva iz BUR_T_REZERVACIJE da bi se greka javila kod upisa iz vanjskih sustava ('Moe se rezervirati samo slobodna smjetajna jedinica.')

  CURSOR c_stsj (sj_id_k i_statusisj.sj_id%TYPE) IS
           SELECT datum
             FROM i_statusisj
            WHERE sj_id = sj_id_k
              AND datum >= dat_poc_p  -- datum u novom razdoblju
              AND datum < dat_zav_p
              AND (datum < rez_dat_poc_p OR datum >= rez_dat_zav_p) --ne smije se kontrolirati datume unutar postojee rezervacije
              AND (  ozn_i = 3   -- izvan upotrebe
                   OR ozn_u = -1  -- vezana ugovorom o zakupu
                   OR ozn_z > 0   -- zauzeta
                   OR ozn_r > 0)  -- rezervirana
  ;
  datum_l i_statusisj.datum%TYPE;
BEGIN
  IF rez_id_p IS NULL OR oznaka_p IN ('P') OR ozn_vstorna_p IS NOT NULL
  THEN
    RETURN;
  END IF;
  FOR rezvsj_c IN
    (SELECT rezvsj.id id, rezvsj.sj_id
       FROM t_rez_vsj rezvsj
      WHERE rezvsj.rez_id = rez_id_p)
  LOOP
    IF rezvsj_c.sj_id IS NOT NULL THEN
      OPEN c_stsj (rezvsj_c.sj_id);
      FETCH c_stsj INTO datum_l;
      IF c_stsj%FOUND THEN
        CLOSE c_stsj;
        pra_rec_zaj.vrati_poruku (-20101);  
      END IF;
      CLOSE c_stsj;
    END IF;
    FOR recrezsj_c IN (
      SELECT id, sj_id
        FROM trec_rez_sj
       WHERE rezvsj_id = rezvsj_c.id)
    LOOP
      OPEN c_stsj (recrezsj_c.sj_id);
      FETCH c_stsj INTO datum_l;
      IF c_stsj%FOUND THEN
        CLOSE c_stsj;      
        pra_rec_zaj.vrati_poruku (-20101);  
      END IF;
      CLOSE c_stsj;
    END LOOP;
  END LOOP;
END;
PROCEDURE PUNI_PKAOBA
 (ZAPIS_P IN tab_t_rezervacije_flex.rez_rec_type
 )
 IS
-- IRN 3977; puni tablicu tpka_obavijesti ako je stigla rezervacija s dolaskom danas
-- poziva se iz AIS/AUS_T_REZERVACIJE

  gkor_id_l   m_korisnici.gkor_id%TYPE;
  tekst_l     tpka_obavijesti.tekst%TYPE; -- VARCHAR2 (4000)
  por_sifra_l s_poruke.sifra%TYPE;
BEGIN

  IF zapis_p.rez_row_new.dat_dolaska <> TRUNC (SYSDATE)
    OR (UPDATING AND zapis_p.rez_row_new.dat_dolaska = zapis_p.rez_row_old.dat_dolaska)
    OR zapis_p.rez_row_new.oznaka = 'P'
    OR zapis_p.rez_row_new.ozn_vstorna IS NOT NULL
    -- REC param 1235; Naziv grupe korisnika kojima treba izraditi obavijest da je stigla rezervacija s dolaskom danas ili nebitno.
    OR pra_zmp_zaj.zmppar_vrijednost ('REC', '1235') = 'nebitno'
  THEN
    RETURN;
  END IF;

  SELECT MIN (id) INTO gkor_id_l
    FROM s_gkorisnika
   WHERE naziv = pra_zmp_zaj.zmppar_vrijednost ('REC', '1235');
  IF gkor_id_l IS NULL THEN
    RETURN;
  END IF;

  tekst_l := '(' || LOWER (zapis_p.rez_row_new.unos_korisnik) || ')';
  IF INSERTING THEN
    -- Upisana je rezervacija broj #0 na prezime #1 za dolazak danas.
    por_sifra_l := 'REC1613';
  ELSE
    -- U rezervaciji broj #0 na prezime #1 promijenjen je dolazak na danas.
    por_sifra_l := 'REC1614';
    /*
    U rezervacijama vanjskih sustava u stupcu izmjena_korisnik pie naziv dblinka, pa je
    korisnije ostaviti da se u tekst obavijesti upisuje podatak unos_korisnik npr. PHOBS.
    */
    -- ZMP param 0018; Naziv (pod)centralnog servera i DB linka.
    IF zapis_p.rez_row_new.izmjena_korisnik <> UPPER (pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0018')) THEN
      tekst_l := '(' || LOWER (zapis_p.rez_row_new.izmjena_korisnik) || ')';
    END IF;
  END IF;

  tekst_l :=
    TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || CHR(10) || CHR(10) ||
    pra_zmp_zaj.poruka ('REC', por_sifra_l, zapis_p.rez_row_new.rbr || '/' || zapis_p.rez_row_new.god_poslovna, zapis_p.rez_row_new.prezime) || CHR(10) || CHR(10) ||
    tekst_l;

  FOR kor_c IN (
    SELECT naziv
      FROM m_korisnici
     WHERE (
           apl_shema_naziv = zmp_zaj.current_schema
           OR
           SYS_CONTEXT ('loginfo_ctx', 'vlasnikpodatka') IS NOT NULL -- IRN 4027; multitenant
           )
       AND gkor_id = gkor_id_l
       AND ozn_aktivan_korisnik = -1
     ORDER BY naziv)
  LOOP
    INSERT INTO tpka_obavijesti (
        naz_korisnika, oznaka, tekst, dat_zav, ozn_dopusten_dismiss, ozn_vobavijesti)
      VALUES (
        kor_c.naziv, 'V', tekst_l, TRUNC (SYSDATE) + 1, -1, 'A');
  END LOOP;

END;

END PRA_T_REZERVACIJE;
/
SHOW ERROR

