-- C:\Radni\pra_t_racuni.pkb
--
-- Generated for Oracle 10g on Fri Oct 03  10:07:07 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'PRA_T_RACUNI'
CREATE OR REPLACE PACKAGE BODY PRA_T_RACUNI IS

PROCEDURE ZABRANI_IZMJENU_UK
 (OLD_GOD_POSLOVNA_P IN T_RACUNI.GOD_POSLOVNA%TYPE
 ,OLD_OJ_ID_P IN T_RACUNI.OJ_ID%TYPE
 ,OLD_VAPLDOK_ID_P IN T_RACUNI.VAPLDOK_ID%TYPE
 ,OLD_RBR_P IN T_RACUNI.RBR%TYPE
 ,NEW_DATUM_P IN T_RACUNI.DATUM%TYPE
 ,NEW_GOD_POSLOVNA_P IN OUT T_RACUNI.GOD_POSLOVNA%TYPE
 ,NEW_OJ_ID_P IN T_RACUNI.OJ_ID%TYPE
 ,NEW_VAPLDOK_ID_P IN T_RACUNI.VAPLDOK_ID%TYPE
 ,NEW_RBR_P IN OUT T_RACUNI.RBR%TYPE
 ,NEW_VDOK_ID_P IN OUT S_VDOKUMENATA.ID%TYPE
 ,NEW_VDOK_SIFRA2N_P IN OUT S_VDOKUMENATA.SIFRA2N%TYPE
 ,NEW_OJ_SIFRA_P IN OUT M_OJ.SIFRA%TYPE
 )
 IS
/*
Izraunaj novi rbr i popuni vdok i oj_sifru kod prelaska
iz rauna u pripremi (RP) u dokument (GI, BI, BV, ...)
inae zabrani izmjenu UK
*/
  new_rbr_l t_racuni.rbr%TYPE;
  old_oznaka_l s_vapldok.oznaka%TYPE;
  new_oznaka_l s_vapldok.oznaka%TYPE;
  new_vdok_id_l s_vapldok.vdok_id%TYPE; -- IRN 2439
  new_vdok_sifra2N_l s_vdokumenata.sifra2N%TYPE; -- IRN 2439 
  dat_erac_obveze_l DATE := pra_zmp_s.dat_erac_obveze; -- IRN 4098
BEGIN
  SELECT oznaka INTO old_oznaka_l
    FROM s_vapldok
   WHERE id = old_vapldok_id_p;
  SELECT vapldok.oznaka, vapldok.vdok_id, vdok.sifra2N
    INTO new_oznaka_l, new_vdok_id_l, new_vdok_sifra2N_l
    FROM s_vapldok vapldok, s_vdokumenata vdok
   WHERE vapldok.id = new_vapldok_id_p
     AND vapldok.vdok_id = vdok.id;
  IF old_oznaka_l = 'RP' AND new_oznaka_l <> 'RP' THEN
    new_oj_sifra_p := pra_zmp.oj_sifra (new_oj_id_p);
    new_god_poslovna_p := TO_CHAR (SYSDATE, 'RRRR'); -- IRN 4098
    pra_zmp.vrati_vdok (new_vapldok_id_p, TRUNC (SYSDATE), new_vdok_id_p, new_vdok_sifra2N_p, dat_erac_obveze_l); --  IRN 4098
    
    pra_rec.izracunaj_redni_broj (
      'T_RACUNI',
      new_god_poslovna_p,
      new_oj_id_p,
      new_vdok_id_l,
      6,
      new_rbr_l);
    new_rbr_p := new_rbr_l;

  ELSIF new_god_poslovna_p <> old_god_poslovna_p
    OR new_oj_id_p <> old_oj_id_p
    OR new_vapldok_id_p <> old_vapldok_id_p
    OR new_rbr_p <> old_rbr_p
  THEN
    -- Nije doputena izmjena UK.
    pra_rec_zaj.vrati_poruku (-20100);
  END IF;
END;
PROCEDURE PROVJERI_VALJANOST_ZAKUPA
 (OZNAKA_P IN T_RACUNI.OZNAKA%TYPE
 ,ZAK_ID_P IN T_ZAKUP.ID%TYPE
 )
 IS
/*
Valjani raun ne moe se vezati na
poniteni ugovor o zakupu kamp prostora.
*/
  oznaka_l t_zakup.oznaka%TYPE;
BEGIN
  IF oznaka_p IS NULL
    OR zak_id_p IS NULL
  THEN
    RETURN;
  END IF;

  SELECT oznaka INTO oznaka_l
    FROM t_zakup
   WHERE id = zak_id_p;
  IF oznaka_p IN ('V')
    AND oznaka_l IN ('P')
  THEN
    pra_rec_zaj.vrati_poruku (-20117);
  END IF;

END;
PROCEDURE PROVJERI_BEZGOTOVINSKI_RACUN
 (VAPLDOK_ID_P IN T_RACUNI.VAPLDOK_ID%TYPE
 ,DAT_DOSPIJECA_P IN T_RACUNI.DAT_DOSPIJECA%TYPE
 ,URAC_ID_P IN T_RACUNI.URAC_ID%TYPE
 )
 IS
/*
Za raune vrste "bezgotovinski raun za redovnu isporuku"
dat_dospijeca i urac_id su obvezni podaci
*/
  oznaka_l s_vapldok.oznaka%TYPE;
BEGIN
  IF vapldok_id_p IS NULL THEN
    RETURN;
  END IF;

  SELECT oznaka INTO oznaka_l
    FROM s_vapldok
   WHERE id = vapldok_id_p;

  IF oznaka_l IN ('BI')
    AND (dat_dospijeca_p IS NULL OR urac_id_p IS NULL)
  THEN
    pra_rec_zaj.vrati_poruku (-20098);
  END IF;
END;
PROCEDURE ZABRANI_IZMJENU_RACUNA
 (OZNAKA_P IN T_RACUNI.OZNAKA%TYPE
 )
 IS
/*
za P i N raune doputena je promjena samo stupaca jir i zki
*/
BEGIN
  IF oznaka_p IS NULL THEN
    RETURN;
  END IF;
  IF oznaka_p NOT IN ('P', 'N') THEN
    RETURN;
  END IF;
  IF UPDATING ('jir') OR UPDATING ('zki') THEN -- IRN 1846
    -- provjeri je li se mijenjao jo koji stupac
    FOR c IN (
      SELECT column_name
        FROM user_tab_columns
       WHERE table_name = 'T_RACUNI'
         AND column_name NOT IN ('JIR', 'ZKI')
       ORDER BY column_id)
    LOOP
      IF UPDATING (c.column_name) THEN
        -- Poniteni raun ne moe se mijenjati.
        pra_rec_zaj.vrati_poruku (-20061);
      END IF;
    END LOOP;
  ELSE
    -- Poniteni raun ne moe se mijenjati.
    pra_rec_zaj.vrati_poruku (-20061);
  END IF;
END;
PROCEDURE PROVJERI_NA_DAT_ZURNALA
 (OLD_VAPLDOK_ID_P IN T_RACUNI.VAPLDOK_ID%TYPE
 ,NEW_VAPLDOK_ID_P IN T_RACUNI.VAPLDOK_ID%TYPE
 ,DATUM_P IN T_RACUNI.DATUM%TYPE
 ,SO_ID_P IN T_RACUNI.SO_ID%TYPE
 )
 IS
/*
Provjeri datum na datum urnala kod
prelaska iz RP (rauna u pripremi) u dokument
*/
  old_oznaka_l s_vapldok.oznaka%TYPE;
  new_oznaka_l s_vapldok.oznaka%TYPE;
BEGIN
  IF old_vapldok_id_p IS NULL
    OR new_vapldok_id_p IS NULL
    OR datum_p IS NULL
    OR so_id_p IS NULL
  THEN
    RETURN;
  END IF;

  SELECT oznaka INTO old_oznaka_l
    FROM s_vapldok
   WHERE id = old_vapldok_id_p;
  SELECT oznaka INTO new_oznaka_l
    FROM s_vapldok
   WHERE id = new_vapldok_id_p;
  IF old_oznaka_l = 'RP' AND new_oznaka_l <> 'RP' THEN
    pra_rec.provjeri_na_dat_zurnala (datum_p, so_id_p);
  END IF;
END;
PROCEDURE PROVJERI_PKAOBR
 (RAC_ID_P IN T_RACUNI.ID%TYPE
 ,RAC_OZNAKA_P IN T_RACUNI.OZNAKA%TYPE
 )
 IS
-- Ne moe se ponititi REC raun vezan za valjani PKA obraun.
  br_redaka_l NUMBER;
BEGIN
  IF rac_oznaka_p IS NULL
    OR rac_id_p IS NULL
  THEN
    RETURN;
  END IF;
  IF rac_oznaka_p IN ('P') THEN
    SELECT COUNT (1) INTO br_redaka_l
      FROM t_rac_nap, tpka_obr_rac, tpka_obracuni
     WHERE t_rac_nap.rac_id = rac_id_p
       AND tpka_obr_rac.racnap_id = t_rac_nap.id
       AND tpka_obr_rac.pkaobr_id = tpka_obracuni.id
       AND tpka_obracuni.oznaka IN ('V');
    IF br_redaka_l > 0 THEN
      pra_rec_zaj.vrati_poruku (-20224);
    END IF;
  END IF;
END;
PROCEDURE PONISTI_RACUN
 (RAC_ID_P IN T_RACUNI.ID%TYPE
 )
 IS
-- Poniti raun
  rac_rec_l t_racuni%ROWTYPE;
  rac_n_rec_l t_racuni%ROWTYPE;

  rac_id_l t_racuni.id%TYPE;
  pkarnk_id_l tpka_rnkasa.id%TYPE;
  ponso_id_l t_troskovi.ponso_id%TYPE;
  pon_oznaka_l t_ponude.oznaka%TYPE; -- IRN 3332
  soc_id_l t_troskovi.soc_id%TYPE;
  cje_id_l t_troskovi.cje_id%TYPE;
  ozn_cijene_l t_troskovi.ozn_cijene%TYPE;
  rez_id_l t_rezervacije.id%TYPE;
  ozn_cje_poseb_l t_rezervacije.ozn_cje_poseb%TYPE;
  ozn_usl_poseb_l s_usluge.ozn_cje_poseb%TYPE;
  tro_id1_l t_troskovi.id1%TYPE;

  tro_rec_l t_troskovi%ROWTYPE;
  tro_n_rec_l t_troskovi%ROWTYPE;

  tpka_rnkasa_rec_l  tpka_rnkasa%ROWTYPE;
  ipka_rnk_pdv_rec_l ipka_rnk_pdv%ROWTYPE;
  tpka_rnk_isp_rec_l tpka_rnk_isp%ROWTYPE;
  i_rac_pdv_rec_l    i_rac_pdv%ROWTYPE;
  t_rac_nap_rec_l    t_rac_nap%ROWTYPE;
  t_rac_pred_rec_l   t_rac_pred%ROWTYPE;
BEGIN
  IF rac_id_p IS NULL THEN
    RETURN;
  END IF;

  SELECT * INTO rac_rec_l
    FROM t_racuni
   WHERE id = rac_id_p;

  -- Trai ID novog rauna sa negativnim stavkama
  rac_id_l := pra_rec_zaj.sekvenca (NULL);

  -- Kreiraj raun s oznakom N
  rac_n_rec_l.id := rac_id_l; -- id novog racuna
  rac_n_rec_l.oj_id := rac_rec_l.oj_id;
  rac_n_rec_l.vapldok_id := rac_rec_l.vapldok_id;
  rac_n_rec_l.rac_id := rac_rec_l.id; -- pokazuje na poniteni raun iz kojeg je nastao
  rac_n_rec_l.so_id := rac_rec_l.so_id;
  rac_n_rec_l.ms_id := rac_rec_l.ms_id;
  rac_n_rec_l.gost_id := rac_rec_l.gost_id;
  rac_n_rec_l.age_id := rac_rec_l.age_id;
  rac_n_rec_l.agep_id := rac_rec_l.agep_id;
  rac_n_rec_l.pkaadr_id := rac_rec_l.pkaadr_id;
  rac_n_rec_l.val_id := rac_rec_l.val_id;
  rac_n_rec_l.vtec_id := rac_rec_l.vtec_id;
  rac_n_rec_l.zak_id := rac_rec_l.zak_id;
  rac_n_rec_l.urac_id := rac_rec_l.urac_id;
  rac_n_rec_l.vnap_id := rac_rec_l.vnap_id;
  rac_n_rec_l.vpknj_id := rac_rec_l.vpknj_id;
  rac_n_rec_l.vpdog_id := rac_rec_l.vpdog_id;
  rac_n_rec_l.god_poslovna := NULL;
  -- rbr
  rac_n_rec_l.ozn_valjanosti := rac_rec_l.ozn_valjanosti;
  rac_n_rec_l.oznaka := 'N';
  rac_n_rec_l.datum := SYSDATE;
  rac_n_rec_l.dat_nobveze := rac_rec_l.dat_nobveze;
  rac_n_rec_l.dat_pripreme := rac_rec_l.dat_pripreme;
  rac_n_rec_l.iznos := rac_rec_l.iznos * -1;
  rac_n_rec_l.izn_tecaja := rac_rec_l.izn_tecaja;
  rac_n_rec_l.stopa_popusta1 := rac_rec_l.stopa_popusta1;
  rac_n_rec_l.izn_popusta1 := rac_rec_l.izn_popusta1 * -1;
  rac_n_rec_l.opis_popusta1 := rac_rec_l.opis_popusta1;
  rac_n_rec_l.stopa_popusta4 := rac_rec_l.stopa_popusta4;
  rac_n_rec_l.izn_popusta4 := rac_rec_l.izn_popusta4 * -1;
  rac_n_rec_l.opis_popusta4 := rac_rec_l.opis_popusta4;
  rac_n_rec_l.br_smjesta := rac_rec_l.br_smjesta;
  rac_n_rec_l.izn_smjesta := rac_rec_l.izn_smjesta * -1;
  rac_n_rec_l.rok_dospijeca := rac_rec_l.rok_dospijeca;
  rac_n_rec_l.dat_dospijeca := SYSDATE + (rac_rec_l.dat_dospijeca - rac_rec_l.datum);
  rac_n_rec_l.stopa_zkamate := rac_rec_l.stopa_zkamate;
  rac_n_rec_l.br_modela := rac_rec_l.br_modela;
  rac_n_rec_l.poziv_na_broj := rac_rec_l.poziv_na_broj;
  rac_n_rec_l.napomena := rac_rec_l.napomena;
  rac_n_rec_l.ozn_racuna := rac_rec_l.ozn_racuna;
  -- unos_korisnik
  -- unos_dat
  -- izmjena_korisnik
  -- izmjena_dat
  rac_n_rec_l.stopa_popusta2 := rac_rec_l.stopa_popusta2;
  rac_n_rec_l.izn_popusta2 := rac_rec_l.izn_popusta2 * -1;
  rac_n_rec_l.opis_popusta2 := rac_rec_l.opis_popusta2;
  rac_n_rec_l.stopa_popusta3 := rac_rec_l.stopa_popusta3;
  rac_n_rec_l.izn_popusta3 := rac_rec_l.izn_popusta3 * -1;
  rac_n_rec_l.opis_popusta3 := rac_rec_l.opis_popusta3;
  rac_n_rec_l.zmppop1_id := rac_rec_l.zmppop1_id;
  rac_n_rec_l.zmppop2_id := rac_rec_l.zmppop2_id;
  rac_n_rec_l.zmppop3_id := rac_rec_l.zmppop3_id;
  rac_n_rec_l.zmppop4_id := rac_rec_l.zmppop4_id;
  rac_n_rec_l.vnap2_id := rac_rec_l.vnap2_id;
  rac_n_rec_l.vnap3_id := rac_rec_l.vnap3_id;
  rac_n_rec_l.gmpkomad_id := rac_rec_l.gmpkomad_id;
  rac_n_rec_l.jir := NULL; -- IRN 1846
  rac_n_rec_l.zki := NULL;
  -- rac_n_rec_l.paragon := rac_rec_l.paragon; -- IRN 2439
  rac_n_rec_l.glavni_racun := rac_rec_l.glavni_racun;
  rac_n_rec_l.stopa_provizije := rac_rec_l.stopa_provizije; -- IRN 2348
  rac_n_rec_l.izn_provizije := rac_rec_l.izn_provizije * -1;
  rac_n_rec_l.stopa_pdv_provizije := rac_rec_l.stopa_pdv_provizije;
  -- vdok_id
  rac_n_rec_l.guid := NULL;
  rac_n_rec_l.kol_loy_izlaz := rac_rec_l.kol_loy_izlaz * -1; -- IRN 2819

  /*  IRN 2439
  Ako se radi o SI fiskalizaciji onda kod ponitavanja rauna pretpostavljamo
  da to nije naknadni unos ponitavanja sprovedenog preko paragon bloka i prilikom kreiranja
  N rauna praznimo podatke iz vezane knjige rauna (paragon_*)
  */
  IF pra_pka_i3fiskal.vlas_u_fsus_si (rac_n_rec_l.datum) = -1 THEN
    rac_n_rec_l.paragon := NULL;
    rac_n_rec_l.paragon_set := NULL;
    rac_n_rec_l.paragon_serija := NULL;
  ELSE
    rac_n_rec_l.paragon := rac_rec_l.paragon;
    rac_n_rec_l.paragon_set := rac_rec_l.paragon_set;
    rac_n_rec_l.paragon_serija := rac_rec_l.paragon_serija;
  END IF;
  -- oj_sifra
  -- vdok_sifra2N

  -- Pratei dokument - zadrava se veza na isti PD
  -- Ako je PD = RNK treba imati na umu da e biti N raun preko PD povezan na izvorni RNK, a da taj RNK nije dijete rauna
  -- (za N raun kreiraju novi retci za RNK; za njih ne postoji PD)
  rac_n_rec_l.pkapd_id := rac_rec_l.pkapd_id;
  rac_n_rec_l.izn_tecajat := rac_rec_l.izn_tecajat; -- IRN 3544

  INSERT INTO t_racuni VALUES rac_n_rec_l;

  -- TROKOVI
  -- Kreiraj trokove nevezane za raun
  /*
  trokovi se ne mogu vezati na ponitenu ponudu. Ako je ponuda koja je
  bila upisana u izvorne trokove ponitena ona se u nove trokove ne upisuje.
  osim ponude treba promijeniti soc_id, cje_id, ozn_cje_id
  09.12.2004 MK - upisati vezu na troak iz N rauna a u tom vezu na troak iz P rauna
  */
  pon_oznaka_l := NULL;
  FOR tro IN (SELECT * FROM t_troskovi WHERE rac_id = rac_id_p)
  LOOP
    IF tro.ponso_id IS NOT NULL THEN
      IF tro.ponso_id IS NOT NULL AND pon_oznaka_l IS NULL THEN -- ponuda se provjerava samo kod prvog troka sa ponudom
        SELECT oznaka
          INTO pon_oznaka_l
          FROM t_ponude pon, t_pon_ojr ponojr, t_pon_so ponso
         WHERE ponso.id = tro.ponso_id
           AND ponso.ponojr_id = ponojr.id
           AND ponojr.pon_id = pon.id;
      END IF;
      IF pon_oznaka_l = 'P' THEN
        ponso_id_l := NULL;
        soc_id_l := tro.so_id;
        -- cje_id_l i ozn_cijene_l
        IF tro.gost_id IS NOT NULL THEN
          -- ako je korisnik gost - kao u fm_rec2210.prom_tro_pon_ozn
          IF tro.tcoraz_id IS NULL AND tro.ptvtro_id IS NULL THEN
            -- troak nije vanjski
            ozn_cijene_l := 4;
            SELECT ozn_cje_poseb INTO ozn_usl_poseb_l FROM s_usluge WHERE id = tro.usl_id;
            IF ozn_usl_poseb_l <> -1 THEN -- za uslugu koja nije po posebnom cjeniku se uzima cjenik iz gosta
              SELECT cje_id INTO cje_id_l
                FROM t_gosti
               WHERE id = tro.gost_id;
            ELSE  -- za uslugu po posebnom cjeniku provjeriti da li se koristi poseban cjenik
              SELECT gost.cje_id, rezvsj.rez_id
                INTO cje_id_l, rez_id_l
                FROM t_gosti gost,
                     t_rez_vsj rezvsj
               WHERE gost.id = tro.gost_id
                 AND gost.rezvsj_id = rezvsj.id (+);
              IF rez_id_l IS NOT NULL THEN
                SELECT ozn_cje_poseb
                  INTO ozn_cje_poseb_l
                  FROM t_rezervacije
                 WHERE id = rez_id_l;
              END IF;
              IF NVL (ozn_cje_poseb_l, -1) = -1 THEN
                -- vrijednost parametra 1068 provjerava funkcija pra_rec_s.bp_cje_id
                cje_id_l := pra_rec_s.bp_cje_id (cje_id_l);
              END IF;
            END IF;
          ELSE
            -- troak je vanjski (TCO, PTV)
            cje_id_l := NULL;
            ozn_cijene_l := 3;
          END IF;
        ELSE
          -- ako je korisnik agencija - kao u fm_rec2210.prom_tro_ponso
          IF tro.soc_id <> tro.so_id
          THEN
            IF tro.tcoraz_id IS NULL AND tro.ptvtro_id IS NULL THEN
              cje_id_l := tro.cje_id;
              ozn_cijene_l := 4;
            ELSE
              -- vanjskim trokovima maknuti cjenik i vratiti ozn_cijene
              cje_id_l := NULL;
              ozn_cijene_l := 3;
            END IF;
          ELSE
            IF tro.tcoraz_id IS NULL AND tro.ptvtro_id IS NULL THEN
              cje_id_l := tro.cje_id;
              ozn_cijene_l := 4;  -- cijena se oznaava kao posebna jer je prije moda bila nadjaana, moda bi se trebalo provjeravati prijanju oznaku
            ELSE
              -- vanjskim trokovima vratiti ozn_cijene
              cje_id_l := NULL;
              ozn_cijene_l := 3;
            END IF;
          END IF;
        END IF;
      ELSE -- Ponuda nije ponitena
        ponso_id_l := tro.ponso_id;
        soc_id_l := tro.soc_id;
        cje_id_l := tro.cje_id;
        ozn_cijene_l := tro.ozn_cijene;
      END IF;
    ELSE -- ponso_id IS NULL
      ponso_id_l := tro.ponso_id;
      soc_id_l := tro.soc_id;
      cje_id_l := tro.cje_id;
      ozn_cijene_l := tro.ozn_cijene;
    END IF;

    -- 09.12.2004 MK - id1 za troak iz N rauna i ltro_id1 za nevezan troak
    tro_id1_l := pra_zmp_zaj.i3_sekvenca (NULL);

    tro_rec_l.so_id := tro.so_id;
    tro_rec_l.soc_id := soc_id_l; -- moe se mijenjati ako je ponuda iz izvornog troka ponitena
    tro_rec_l.usl_id := tro.usl_id;
    tro_rec_l.sas_id := tro.sas_id;
    tro_rec_l.gost_id := tro.gost_id;
    tro_rec_l.age_id := tro.age_id;
    tro_rec_l.pkaadr_id := tro.pkaadr_id;
    tro_rec_l.cje_id := cje_id_l; -- moe se mijenjati ako je ponuda iz izvornog troka ponitena
    tro_rec_l.vsj_id := tro.vsj_id;
    tro_rec_l.val_id := tro.val_id;
    tro_rec_l.ms_id := tro.ms_id;
    tro_rec_l.gostp_id := tro.gostp_id;
    tro_rec_l.agep_id := tro.agep_id;
    tro_rec_l.pkaadrp_id := tro.pkaadrp_id;
    tro_rec_l.vpispp_id := NULL;
    tro_rec_l.vpispz_id := NULL;
    tro_rec_l.rac_id := NULL; -- trokovi nevezani za raun
    tro_rec_l.tcoraz_id := tro.tcoraz_id;
    tro_rec_l.ptvtro_id := tro.ptvtro_id;
    tro_rec_l.id1 := NULL;
    tro_rec_l.ltro_id1 := tro_id1_l;
    tro_rec_l.id1_prvi := tro.id1_prvi;
    tro_rec_l.dat_poc := tro.dat_poc;
    tro_rec_l.dat_zav := tro.dat_zav;
    tro_rec_l.kol_usluge := tro.kol_usluge;
    tro_rec_l.cijena_usluge := tro.cijena_usluge;
    tro_rec_l.ozn_cijene := ozn_cijene_l; -- moe se mijenjati ako je ponuda iz izvornog troka ponitena
    tro_rec_l.stopa_placanja := tro.stopa_placanja;
    tro_rec_l.br_uputnice := tro.br_uputnice;
    tro_rec_l.ozn_smjesta := tro.ozn_smjesta;
    tro_rec_l.izn_prihoda := NULL;
    tro_rec_l.izn_pdv_poc := NULL;
    tro_rec_l.dat_upisa := NULL;
    tro_rec_l.obr_zdana := NULL;
    tro_rec_l.obr_smjesta := NULL;
    tro_rec_l.obr_popusta1 := NULL;
    tro_rec_l.obr_popusta4 := NULL;
    tro_rec_l.izn_tecaja := NULL;
    tro_rec_l.izn_odbitka := NULL;
    tro_rec_l.stopa_pdv := NULL;
    tro_rec_l.izn_pdv := NULL;
    tro_rec_l.iznos := NULL;
    tro_rec_l.recara_id := tro.recara_id;
    tro_rec_l.obr_popusta2 := NULL;
    tro_rec_l.obr_popusta3 := NULL;
    tro_rec_l.zmppop1_id := NULL;
    tro_rec_l.zmppop2_id := NULL;
    tro_rec_l.zmppop3_id := NULL;
    tro_rec_l.zmppop4_id := NULL;
    tro_rec_l.stopa_popusta1 := NULL;
    tro_rec_l.stopa_popusta2 := NULL;
    tro_rec_l.stopa_popusta3 := NULL;
    tro_rec_l.stopa_popusta4 := NULL;
    tro_rec_l.izn_prihoda_prvidan := NULL;
    tro_rec_l.izn_pdv_prvidan := NULL;
    tro_rec_l.ozn_rac_rp := NULL;
    tro_rec_l.obr_po_danu_poc := NULL;
    tro_rec_l.obr_po_danu := NULL;
    tro_rec_l.ponso_id := ponso_id_l; -- NULL ako je ponuda iz izvornog troka ponitena
    tro_rec_l.usl_id1 := tro.usl_id1;
    tro_rec_l.vpispp_id1 := NULL;
    tro_rec_l.vpispz_id1 := NULL;
    tro_rec_l.izn_pdv_poc1 := NULL;
    tro_rec_l.stopa_pdv_poc1 := NULL;
    tro_rec_l.stopa_pdv1 := NULL;
    tro_rec_l.izn_pdv1 := NULL;
    tro_rec_l.izn_pdv_prvidan1 := NULL;
    tro_rec_l.recrez2pros_id := tro.recrez2pros_id;
    tro_rec_l.recrez2opr_id := tro.recrez2opr_id;
    tro_rec_l.zak_id := tro.zak_id;
    tro_rec_l.izn_odbitka_poc := NULL;
    tro_rec_l.izn_odbitka_pdv_poc := NULL;
    tro_rec_l.izn_odbitka_pdv_poc1 := NULL;
    tro_rec_l.recvpro_id := tro.recvpro_id;
    tro_rec_l.dat_poc1 := tro.dat_poc1;
    tro_rec_l.dat_zav1 := tro.dat_zav1;
    tro_rec_l.obr_provizije := NULL; -- IRN 2439
    tro_rec_l.domval_id := tro.domval_id; -- IRN 3536
    INSERT INTO t_troskovi VALUES tro_rec_l;

    -- Kreiraj negativne trokove za raun s oznakom N
    tro_n_rec_l.so_id := tro.so_id;
    tro_n_rec_l.soc_id := tro.soc_id;
    tro_n_rec_l.usl_id := tro.usl_id;
    tro_n_rec_l.sas_id := tro.sas_id;
    tro_n_rec_l.gost_id := tro.gost_id;
    tro_n_rec_l.age_id := tro.age_id;
    tro_n_rec_l.pkaadr_id := tro.pkaadr_id;
    tro_n_rec_l.cje_id := tro.cje_id;
    tro_n_rec_l.vsj_id := tro.vsj_id;
    tro_n_rec_l.val_id := tro.val_id;
    tro_n_rec_l.ms_id := tro.ms_id;
    tro_n_rec_l.gostp_id := tro.gostp_id;
    tro_n_rec_l.agep_id := tro.agep_id;
    tro_n_rec_l.pkaadrp_id := tro.pkaadrp_id;
    tro_n_rec_l.vpispp_id := tro.vpispp_id;
    tro_n_rec_l.vpispz_id := tro.vpispz_id;
    tro_n_rec_l.rac_id := rac_id_l; -- raun za koji se kreiraju stavke
    tro_n_rec_l.tcoraz_id := tro.tcoraz_id;
    tro_n_rec_l.ptvtro_id := tro.ptvtro_id;
    tro_n_rec_l.id1 := tro_id1_l;
    tro_n_rec_l.ltro_id1 := tro.id1;
    tro_n_rec_l.id1_prvi := tro.id1_prvi;
    tro_n_rec_l.dat_poc := tro.dat_poc;
    tro_n_rec_l.dat_zav := tro.dat_zav;
    tro_n_rec_l.kol_usluge := tro.kol_usluge * -1; -- mnoi se s -1
    tro_n_rec_l.cijena_usluge := tro.cijena_usluge;
    tro_n_rec_l.ozn_cijene := tro.ozn_cijene;
    tro_n_rec_l.stopa_placanja := tro.stopa_placanja;
    tro_n_rec_l.br_uputnice := tro.br_uputnice;
    tro_n_rec_l.ozn_smjesta := tro.ozn_smjesta;
    tro_n_rec_l.izn_prihoda := tro.izn_prihoda * -1; -- mnoi se s -1, u bir_t_troskovi se ne rauna ponovo
    tro_n_rec_l.izn_pdv_poc := tro.izn_pdv_poc * -1; -- mnoi se s -1, u bir_t_troskovi se ne rauna ponovo
    tro_n_rec_l.stopa_pdv_poc := tro.stopa_pdv_poc;
    tro_n_rec_l.dat_upisa := tro.dat_upisa;
    tro_n_rec_l.obr_zdana_poc := tro.obr_zdana_poc;
    tro_n_rec_l.obr_zdana := tro.obr_zdana;
    tro_n_rec_l.obr_smjesta := tro.obr_smjesta;
    tro_n_rec_l.obr_popusta1 := tro.obr_popusta1;
    tro_n_rec_l.obr_popusta4 := tro.obr_popusta4;
    tro_n_rec_l.izn_tecaja := tro.izn_tecaja;
    tro_n_rec_l.izn_odbitka := tro.izn_odbitka * -1; -- mnoi se s -1
    tro_n_rec_l.stopa_pdv := tro.stopa_pdv;
    tro_n_rec_l.izn_pdv := tro.izn_pdv * -1; -- mnoi se s -1
    tro_n_rec_l.iznos := tro.iznos * -1; -- mnoi se s -1
    tro_n_rec_l.recara_id := tro.recara_id;
    tro_n_rec_l.obr_popusta2 := tro.obr_popusta2;
    tro_n_rec_l.obr_popusta3 := tro.obr_popusta3;
    tro_n_rec_l.zmppop1_id := tro.zmppop1_id;
    tro_n_rec_l.zmppop2_id := tro.zmppop2_id;
    tro_n_rec_l.zmppop3_id := tro.zmppop3_id;
    tro_n_rec_l.zmppop4_id := tro.zmppop4_id;
    tro_n_rec_l.stopa_popusta1 := tro.stopa_popusta1;
    tro_n_rec_l.stopa_popusta2 := tro.stopa_popusta2;
    tro_n_rec_l.stopa_popusta3 := tro.stopa_popusta3;
    tro_n_rec_l.stopa_popusta4 := tro.stopa_popusta4;
    tro_n_rec_l.izn_prihoda_prvidan := tro.izn_prihoda_prvidan * -1; -- mnoi se s -1, u bir_t_troskovi se ne rauna ponovo
    tro_n_rec_l.izn_pdv_prvidan := tro.izn_pdv_prvidan * -1; -- mnoi se s -1, u bir_t_troskovi se ne rauna ponovo
    tro_n_rec_l.ozn_rac_rp := tro.ozn_rac_rp;
    tro_n_rec_l.obr_po_danu_poc := tro.obr_po_danu_poc;
    tro_n_rec_l.obr_po_danu := tro.obr_po_danu;
    tro_n_rec_l.ponso_id := tro.ponso_id;
    tro_n_rec_l.usl_id1 := tro.usl_id1;
    tro_n_rec_l.vpispp_id1 := tro.vpispp_id1;
    tro_n_rec_l.vpispz_id1 := tro.vpispz_id1;
    tro_n_rec_l.izn_pdv_poc1 := tro.izn_pdv_poc1 * -1; -- mnoi se s -1, u bir_t_troskovi se ne rauna ponovo
    tro_n_rec_l.stopa_pdv_poc1 := tro.stopa_pdv_poc1;
    tro_n_rec_l.stopa_pdv1 := tro.stopa_pdv1;
    tro_n_rec_l.izn_pdv1 := tro.izn_pdv1 * -1; -- mnoi se s -1
    tro_n_rec_l.izn_pdv_prvidan1 := tro.izn_pdv_prvidan1 * -1; -- mnoi se s -1, u bir_t_troskovi se ne rauna ponovo
    tro_n_rec_l.recrez2pros_id := tro.recrez2pros_id;
    tro_n_rec_l.recrez2opr_id := tro.recrez2opr_id;
    tro_n_rec_l.zak_id := tro.zak_id;
    tro_n_rec_l.izn_odbitka_poc := tro.izn_odbitka_poc * -1; -- mnoi se s -1, u bir_t_troskovi se ne rauna ponovo
    tro_n_rec_l.izn_odbitka_pdv_poc := tro.izn_odbitka_pdv_poc * -1; -- mnoi se s -1, u bir_t_troskovi se ne rauna ponovo
    tro_n_rec_l.izn_odbitka_pdv_poc1 := tro.izn_odbitka_pdv_poc1 * -1; -- mnoi se s -1, u bir_t_troskovi se ne rauna ponovo
    tro_n_rec_l.recvpro_id := tro.recvpro_id;
    tro_n_rec_l.dat_poc1 := tro.dat_poc1;
    tro_n_rec_l.dat_zav1 := tro.dat_zav1;
    tro_n_rec_l.obr_provizije := tro.obr_provizije; -- IRN 2439
    tro_n_rec_l.domval_id := tro.domval_id; -- IRN 3536

    INSERT INTO t_troskovi VALUES tro_n_rec_l;
  END LOOP;

  -- Interni POS rauni
  FOR rnkasa IN (SELECT * FROM tpka_rnkasa WHERE rac_id = rac_id_p)
  LOOP
    -- Skini vezu na poniteni REC raun
    UPDATE tpka_rnkasa SET rac_id = NULL WHERE id = rnkasa.id;

    /*
    Kreiraj raune sa kasa (i njihove stavke)
    sa vezom na poniteni REC raun.
    Poslovnu godinu insertira triger, ne prepisuje se.
    */
    pkarnk_id_l := pra_pka_zaj.sekvenca (NULL);

    tpka_rnkasa_rec_l := rnkasa;
    tpka_rnkasa_rec_l.id := pkarnk_id_l;
    tpka_rnkasa_rec_l.ozn_izvorni := 0;
    tpka_rnkasa_rec_l.god_poslovna_izvor := NULL;
    tpka_rnkasa_rec_l.gmpkas_id_izvor := NULL;
    tpka_rnkasa_rec_l.rbr_izvor := NULL;
    tpka_rnkasa_rec_l.unos_korisnik := NULL;
    tpka_rnkasa_rec_l.unos_dat := NULL;
    tpka_rnkasa_rec_l.izmjena_korisnik := NULL;
    tpka_rnkasa_rec_l.izmjena_dat := NULL;

    INSERT INTO tpka_rnkasa VALUES tpka_rnkasa_rec_l;

    -- stavke poreza internih POS rauna
    FOR pkarnkpdv IN (
      SELECT * FROM ipka_rnk_pdv WHERE pkarnk_id = rnkasa.id)
    LOOP
      ipka_rnk_pdv_rec_l := pkarnkpdv;
      ipka_rnk_pdv_rec_l.id := NULL;
      ipka_rnk_pdv_rec_l.pkarnk_id := pkarnk_id_l;
      ipka_rnk_pdv_rec_l.unos_korisnik := NULL;
      ipka_rnk_pdv_rec_l.unos_dat := NULL;
      ipka_rnk_pdv_rec_l.izmjena_korisnik := NULL;
      ipka_rnk_pdv_rec_l.izmjena_dat := NULL;

      INSERT INTO ipka_rnk_pdv VALUES ipka_rnk_pdv_rec_l;

    END LOOP;

    -- stavke isporuka internih POS rauna
    FOR pkarnkisp IN (
      SELECT * FROM tpka_rnk_isp WHERE pkarnk_id = rnkasa.id)
    LOOP
      tpka_rnk_isp_rec_l := pkarnkisp;
      tpka_rnk_isp_rec_l.id := NULL;
      tpka_rnk_isp_rec_l.pkarnk_id := pkarnk_id_l;
      tpka_rnk_isp_rec_l.unos_korisnik := NULL;
      tpka_rnk_isp_rec_l.unos_dat := NULL;
      tpka_rnk_isp_rec_l.izmjena_korisnik := NULL;
      tpka_rnk_isp_rec_l.izmjena_dat := NULL;

      INSERT INTO tpka_rnk_isp VALUES tpka_rnk_isp_rec_l;

    END LOOP;

    /*
    Kreiraj interne POS raune (i njihove stavke)
    sa vezom na N raun
    */
    pkarnk_id_l := pra_pka_zaj.sekvenca (NULL);

    tpka_rnkasa_rec_l := rnkasa;
    tpka_rnkasa_rec_l.id := pkarnk_id_l;
    tpka_rnkasa_rec_l.rac_id := rac_id_l;
    tpka_rnkasa_rec_l.izn_placanja := tpka_rnkasa_rec_l.izn_placanja * -1;
    tpka_rnkasa_rec_l.izn_ppot := tpka_rnkasa_rec_l.izn_ppot * -1;
    tpka_rnkasa_rec_l.izn_osnovice_ppot := tpka_rnkasa_rec_l.izn_osnovice_ppot * -1;
    tpka_rnkasa_rec_l.izn_popusta := tpka_rnkasa_rec_l.izn_popusta * -1; -- IRN 4015
    -- izn_placanja2 -- podrazumijeva se da je NULL
    tpka_rnkasa_rec_l.ozn_izvorni := 0;
    tpka_rnkasa_rec_l.god_poslovna_izvor := NULL;
    tpka_rnkasa_rec_l.gmpkas_id_izvor := NULL;
    tpka_rnkasa_rec_l.rbr_izvor := NULL;
    tpka_rnkasa_rec_l.unos_korisnik := NULL;
    tpka_rnkasa_rec_l.unos_dat := NULL;
    tpka_rnkasa_rec_l.izmjena_korisnik := NULL;
    tpka_rnkasa_rec_l.izmjena_dat := NULL;
    tpka_rnkasa_rec_l.izn_pnaknade := tpka_rnkasa_rec_l.izn_pnaknade * -1;
    tpka_rnkasa_rec_l.izn_napojnice := tpka_rnkasa_rec_l.izn_napojnice * -1;
    tpka_rnkasa_rec_l.izn_popusta2 := tpka_rnkasa_rec_l.izn_popusta2 * -1; -- IRN 4015

    INSERT INTO tpka_rnkasa VALUES tpka_rnkasa_rec_l;

    -- stavke poreza internih POS rauna
    FOR pkarnkpdv IN (
      SELECT * FROM ipka_rnk_pdv WHERE pkarnk_id = rnkasa.id)
    LOOP
      ipka_rnk_pdv_rec_l := pkarnkpdv;
      ipka_rnk_pdv_rec_l.id := NULL;
      ipka_rnk_pdv_rec_l.pkarnk_id := pkarnk_id_l;
      ipka_rnk_pdv_rec_l.iznos := ipka_rnk_pdv_rec_l.iznos * -1;
      ipka_rnk_pdv_rec_l.izn_osnovice := ipka_rnk_pdv_rec_l.izn_osnovice * -1;
      ipka_rnk_pdv_rec_l.izn_pdv := ipka_rnk_pdv_rec_l.izn_pdv * -1;
      ipka_rnk_pdv_rec_l.unos_korisnik := NULL;
      ipka_rnk_pdv_rec_l.unos_dat := NULL;
      ipka_rnk_pdv_rec_l.izmjena_korisnik := NULL;
      ipka_rnk_pdv_rec_l.izmjena_dat := NULL;

      INSERT INTO ipka_rnk_pdv VALUES ipka_rnk_pdv_rec_l;

    END LOOP;

    -- stavke isporuka internih POS rauna
    FOR pkarnkisp IN (
      SELECT * FROM tpka_rnk_isp WHERE pkarnk_id = rnkasa.id)
    LOOP
      tpka_rnk_isp_rec_l := pkarnkisp;
      tpka_rnk_isp_rec_l.id := NULL;
      tpka_rnk_isp_rec_l.pkarnk_id := pkarnk_id_l;
      tpka_rnk_isp_rec_l.kolicina := tpka_rnk_isp_rec_l.kolicina * -1;
      tpka_rnk_isp_rec_l.izn_pdv := tpka_rnk_isp_rec_l.izn_pdv * -1;
      tpka_rnk_isp_rec_l.izn_ppot := tpka_rnk_isp_rec_l.izn_ppot * -1;
      tpka_rnk_isp_rec_l.unos_korisnik := NULL;
      tpka_rnk_isp_rec_l.unos_dat := NULL;
      tpka_rnk_isp_rec_l.izmjena_korisnik := NULL;
      tpka_rnk_isp_rec_l.izmjena_dat := NULL;
      tpka_rnk_isp_rec_l.izn_pnaknade :=  tpka_rnk_isp_rec_l.izn_pnaknade * -1;

      INSERT INTO tpka_rnk_isp VALUES tpka_rnk_isp_rec_l;

    END LOOP;

  END LOOP;

  -- stavke poreza za N raun
  FOR racpdv IN (SELECT * FROM i_rac_pdv WHERE rac_id = rac_id_p)
  LOOP
    i_rac_pdv_rec_l := racpdv;
    i_rac_pdv_rec_l.rac_id := rac_id_l;
    i_rac_pdv_rec_l.iznos := i_rac_pdv_rec_l.iznos * -1;
    i_rac_pdv_rec_l.izn_domval := i_rac_pdv_rec_l.izn_domval * -1;
    i_rac_pdv_rec_l.izn_racval := i_rac_pdv_rec_l.izn_racval * -1;
    i_rac_pdv_rec_l.unos_korisnik := NULL;
    i_rac_pdv_rec_l.unos_dat := NULL;
    i_rac_pdv_rec_l.izmjena_korisnik := NULL;
    i_rac_pdv_rec_l.izmjena_dat := NULL;

    INSERT INTO i_rac_pdv VALUES i_rac_pdv_rec_l;

  END LOOP;

  -- stavke plaanja za N raun
  FOR racnap IN (SELECT * FROM t_rac_nap WHERE rac_id = rac_id_p)
  LOOP
    t_rac_nap_rec_l := racnap;
    t_rac_nap_rec_l.id := NULL;
    t_rac_nap_rec_l.rac_id := rac_id_l;
    t_rac_nap_rec_l.izn_placanja := t_rac_nap_rec_l.izn_placanja * -1;
    t_rac_nap_rec_l.unos_korisnik := NULL;
    t_rac_nap_rec_l.unos_dat := NULL;
    t_rac_nap_rec_l.izmjena_korisnik := NULL;
    t_rac_nap_rec_l.izmjena_dat := NULL;
    t_rac_nap_rec_l.opis2 := NULL; -- IRN 3520
    t_rac_nap_rec_l.izn_napojnice := t_rac_nap_rec_l.izn_napojnice * -1;

    INSERT INTO t_rac_nap VALUES t_rac_nap_rec_l;

  END LOOP;

  -- predujmovi za N raun
  FOR racpred IN (SELECT * FROM t_rac_pred WHERE rac_id = rac_id_p)
  LOOP
    t_rac_pred_rec_l := racpred;
    t_rac_pred_rec_l.rac_id := rac_id_l;
    t_rac_pred_rec_l.iznos := t_rac_pred_rec_l.iznos * -1;
    t_rac_pred_rec_l.unos_korisnik := NULL;
    t_rac_pred_rec_l.unos_dat := NULL;
    t_rac_pred_rec_l.izmjena_korisnik := NULL;
    t_rac_pred_rec_l.izmjena_dat := NULL;

    INSERT INTO t_rac_pred VALUES t_rac_pred_rec_l;

  END LOOP;

  IF rac_rec_l.zak_id IS NOT NULL THEN
    pra_t_zakup.dodaj_rac_reczakpdv (rac_id_l);
  END IF;

  -- Poniti prikupljene i iskoritene bodove programa vjernosti; IRN 1143
  pra_rec_loy.ponisti_bodove ( -- IRN 2678
    rac_rec_l.id, -- IRN 1556
    rac_rec_l.datum, -- IRN 1556
    rac_rec_l.god_poslovna,
    rac_rec_l.oj_id,
    rac_rec_l.vapldok_id,
    rac_rec_l.rbr);

  -- Brii zapise o iskoritenim popustima lanova programa vjernosti; IRN 1491
  DELETE FROM tloy_izlaz1 WHERE id2 = rac_id_p;

END;
PROCEDURE PUNI_PDV
 (RAC_ID_P T_RACUNI.ID%TYPE
 )
 IS
--
  rac_rec_l t_racuni%ROWTYPE;
  brojac_l NUMBER;
  izn_domval_l i_rac_pdv.izn_domval%TYPE;
  izn_racval_l i_rac_pdv.izn_racval%TYPE;
  izn_domval_max_l i_rac_pdv.izn_domval%TYPE;
  izn_ppot_l i_rac_pdv.izn_domval%TYPE;
  izn_razlike_domval_l i_rac_pdv.izn_domval%TYPE;
  izn_razlike_racval_l i_rac_pdv.izn_racval%TYPE;
  vpispz_id_l i_rac_pdv.vpispz_id%TYPE;
  izn_pnaknade_l tpka_rnkasa.izn_pnaknade%TYPE;  

  CURSOR rac_c IS
    SELECT COUNT (1)
      FROM i_rac_pdv
     WHERE rac_id = rac_id_p;
  CURSOR racpdv_c (iznos_k i_rac_pdv.izn_domval%TYPE) IS
    SELECT vpispz_id
      FROM i_rac_pdv
     WHERE rac_id = rac_id_p
       AND izn_domval = iznos_k;
BEGIN
  IF rac_id_p IS NULL THEN
    RETURN;
  END IF;
  BEGIN
    SELECT * INTO rac_rec_l FROM t_racuni WHERE id = rac_id_p;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      RETURN;
  END;

  OPEN rac_c;
  FETCH rac_c INTO brojac_l;
  CLOSE rac_c;

  -- ako stavke ve postoje ne raunaju se ponovo
  IF brojac_l <> 0 THEN
    RETURN;
  END IF;

  FOR racpdv IN
    -- MK 12.05.2009 Osnovni iznos za izraun je iznos u valuti rauna koji je bio osnovni i do sada za tro
    --  ali je do sada osnovni iznos za rnk bio osnovica u dom val
    --  Ne pretvara se svaki rnk u racval ve SUM (iznosa) iz ipka_rnk_pdv to je sa stanovita PDV tonije
    --  ali ne odgovara zbroju rnk u RN jer se oni pojedinano pretvaraju u racval i zbrajaju u RN
    -- MK 23.03.2012, osnovni iznos za izraun PDV je domaa valuta
    --  za tro je vano zbog BP koji ima cijene u domval i one moraju biti osnovica za PDV i tono ta osnovica
    --  mora umanjivati osnovicu za poreznu grupu osnovnih usluga kada je BP ukljuena u njihovu cijenu
    --  iznos domval se raunati iz tro, vie ne mora vrijediti izn_domval = izn_racval * tecaj
    --  pa je i izraun za RNK prebaen na domval a izn_racval se zaokruuje za svaki RN tako da odgovara zbroju
    --  RNK u RN ako nema ppot (ako ima ppot u svakom sluaju moe doi do razlika)

    (
    SELECT
      vpispz_id,
      stopa_pdv,
      SUM (izn_domval) * 100 / (100 + stopa_pdv) AS iznos, --iznos osnovice
      ROUND (SUM (izn_domval),2) AS izn_domval,
      ROUND (SUM (izn_racval), 2) AS izn_racval
    FROM
      (
      -- tro
      SELECT
        SUM (izn_tro_racval) - SUM (iznos_odbitaka) AS izn_racval,
        SUM (izn_tro_domval) - SUM (iznos_odbitaka)* rac_rec_l.izn_tecaja AS izn_domval,
        vpispz_id,
        stopa_pdv
      FROM
        (
        SELECT ROUND (cijena_usluge * stopa_placanja / 100 * izn_tecaja / rac_rec_l.izn_tecaja, 2)
                 * kol_usluge
                 * DECODE (obr_po_danu, -1, (dat_zav - dat_poc - obr_zdana), 1)
               AS izn_tro_racval,                          -- iznos racval
               izn_odbitka AS iznos_odbitaka,              -- iznos odb racval
               (ROUND (cijena_usluge * stopa_placanja / 100 * izn_tecaja, 2))
                 * kol_usluge
                 * DECODE (obr_po_danu, -1, (dat_zav - dat_poc - obr_zdana), 1)
               AS izn_tro_domval,                          -- iznos domval novim izraunom
               vpispz_id,
               stopa_pdv
          FROM t_troskovi
         WHERE rac_id = rac_id_p
           AND vpispz_id IS NOT NULL
        UNION ALL
        SELECT (ROUND (cijena_usluge * stopa_placanja / 100 * izn_tecaja / rac_rec_l.izn_tecaja, 2)
                 * kol_usluge
                 * DECODE (obr_po_danu, -1, (dat_zav - dat_poc - obr_zdana), 1)
                 ) * -1  AS izn_tro_racval,                -- iznos racval
               izn_odbitka * -1 AS iznos_odbitaka,         -- iznos odb racval
               (ROUND (cijena_usluge * stopa_placanja / 100 * izn_tecaja, 2))
                 * kol_usluge
                 * DECODE (obr_po_danu, -1, (dat_zav - dat_poc - obr_zdana), 1)
                 * -1 AS izn_tro_domval,                   -- iznos domval novim izraunom
               --
               vpispz_id1 AS vpispz_id,
               stopa_pdv1 AS stopa_pdv
          FROM t_troskovi
         WHERE rac_id = rac_id_p
           AND vpispz_id1 IS NOT NULL
           AND usl_id1 IS NOT NULL
       )
     GROUP BY vpispz_id, stopa_pdv
     -- kraj tro
     UNION ALL
     -- rnk
     SELECT -- SUM (i.iznos * (1 + i.stopa_pdv/100)) / rac_rec_l.izn_tecaja AS iznos,
            SUM (ROUND ((i.izn_osnovice + i.izn_pdv) / rac_rec_l.izn_tecaja, 2)) AS izn_racval,
            SUM (i.izn_osnovice + i.izn_pdv) AS izn_domval,
            i.vpispz_id,
            i.stopa_pdv
       FROM ipka_rnk_pdv i, tpka_rnkasa t
      WHERE t.id = i.pkarnk_id
        AND t.rac_id = rac_id_p
      GROUP BY i.vpispz_id, i.stopa_pdv
     )
  GROUP BY vpispz_id, stopa_pdv
  )
  LOOP
    INSERT INTO i_rac_pdv (
       rac_id
      ,vpispz_id
      ,iznos
      ,stopa_pdv
      ,izn_domval
      ,izn_racval)
    VALUES (
       rac_id_p
      ,racpdv.vpispz_id
      ,racpdv.iznos
      ,racpdv.stopa_pdv
      ,racpdv.izn_domval
      ,racpdv.izn_racval
     );
  END LOOP;

  SELECT SUM (izn_domval),
         SUM (izn_racval),
         MAX (izn_domval)
    INTO izn_domval_l, izn_racval_l, izn_domval_max_l
    FROM i_rac_pdv
   WHERE rac_id = rac_id_p;

  SELECT NVL (SUM (izn_ppot), 0), NVL (SUM (izn_pnaknade), 0) INTO izn_ppot_l, izn_pnaknade_l
    FROM tpka_rnkasa
   WHERE rac_id = rac_id_p;

  izn_razlike_domval_l :=
    ROUND (pra_rec_s2.iznos_racuna_bruto (rac_rec_l.id, rac_rec_l.iznos, rac_rec_l.izn_tecaja) * rac_rec_l.izn_tecaja, 2)
      - (izn_domval_l + izn_ppot_l + izn_pnaknade_l);
  izn_razlike_racval_l :=
    pra_rec_s2.iznos_racuna_bruto (rac_rec_l.id, rac_rec_l.iznos, rac_rec_l.izn_tecaja)
      - (izn_racval_l + ROUND (izn_ppot_l / rac_rec_l.izn_tecaja, 2) + ROUND (izn_pnaknade_l / rac_rec_l.izn_tecaja, 2));

  IF izn_razlike_domval_l <> 0
    OR izn_razlike_racval_l <> 0
  THEN
    OPEN racpdv_c (izn_domval_max_l);
    FETCH racpdv_c INTO vpispz_id_l;
    CLOSE racpdv_c;
    UPDATE i_rac_pdv
       SET izn_domval = izn_domval + izn_razlike_domval_l,
           izn_racval = izn_racval + izn_razlike_racval_l,
           iznos = (izn_domval + izn_razlike_domval_l) * 100 / (100 + stopa_pdv)
     WHERE rac_id = rac_id_p
       AND vpispz_id = vpispz_id_l;
  END IF;
END;
PROCEDURE UPISI_PROMJENU_DATUMA
 (GOD_POSLOVNA_P IN T_RACUNI.GOD_POSLOVNA%TYPE
 ,OJ_ID_P IN T_RACUNI.OJ_ID%TYPE
 ,OLD_VAPLDOK_ID_P IN T_RACUNI.VAPLDOK_ID%TYPE
 ,NEW_VAPLDOK_ID_P IN T_RACUNI.VAPLDOK_ID%TYPE
 ,RBR_P IN T_RACUNI.RBR%TYPE
 ,OLD_DATUM_P IN T_RACUNI.DATUM%TYPE
 ,NEW_DATUM_P IN T_RACUNI.DATUM%TYPE
 )
 IS
/*
Upisati u lrec_promjene promjenu datuma rauna (0011)
- kod izrade rauna ako je datum rauna razliit od tekueg
- kod prelaska vrste rauna iz RP u ne-RP ako je datum rauna razliit od tekueg
- kod promjene datuma rauna vrste ne-RP
*/
  new_vapldok_oznaka_l s_vapldok.oznaka%TYPE;
  oj_sifra_l           m_oj.sifra%TYPE;
  datum_l              t_racuni.datum%TYPE;
BEGIN
  IF god_poslovna_p IS NULL
    OR oj_id_p IS NULL
    OR new_vapldok_id_p IS NULL
    OR rbr_p IS NULL
    OR new_datum_p IS NULL
  THEN
    RETURN;
  END IF;
  IF old_datum_p IS NULL AND new_datum_p = TRUNC (SYSDATE) THEN
    -- datum novog rauna jednak je tekuem
    RETURN;
  END IF;
  IF old_vapldok_id_p IS NOT NULL
    AND pra_rec2.racun_je_u_pripremi (old_vapldok_id_p) = -1
    AND pra_rec2.racun_je_u_pripremi (new_vapldok_id_p) = -1
  THEN
    -- raun je ostao raun u pripremi
    RETURN;
  END IF;
  IF old_vapldok_id_p IS NOT NULL
    AND pra_rec2.racun_je_u_pripremi (old_vapldok_id_p) = -1
    AND pra_rec2.racun_je_u_pripremi (new_vapldok_id_p) <> -1
    AND new_datum_p = TRUNC (SYSDATE)
  THEN
    -- promijenjena je vrsta dokumenata iz RP u ne-RP i novi datum je tekui
    RETURN;
  END IF;
  IF old_vapldok_id_p IS NOT NULL
    AND pra_rec2.racun_je_u_pripremi (old_vapldok_id_p) <> -1
    AND old_datum_p IS NOT NULL
    AND old_datum_p = new_datum_p
  THEN
    -- raun nije bio raun u pripremi i nema promjene datuma rauna
    RETURN;
  END IF;

  SELECT oznaka INTO new_vapldok_oznaka_l
    FROM s_vapldok
   WHERE id = new_vapldok_id_p;
  SELECT sifra INTO oj_sifra_l
    FROM m_oj
   WHERE id = oj_id_p;

  IF old_datum_p IS NOT NULL THEN
    IF pra_rec2.racun_je_u_pripremi (old_vapldok_id_p) <> -1 THEN
      datum_l := old_datum_p;
    ELSE
      datum_l := SYSDATE;
    END IF;
  ELSE
    datum_l := SYSDATE;
  END IF;

  pra_rec.puni_promjene_t ( -- IRN 2997
    '0011',
    god_poslovna_p || '; ' ||
      oj_sifra_l || '; ' ||
      new_vapldok_oznaka_l || '; ' ||
      rbr_p || '; ' ||
      TO_CHAR (datum_l, 'DD.MM.RRRR') || '; ' ||
      TO_CHAR (new_datum_p, 'DD.MM.RRRR'),
    0);
END;
FUNCTION POZIV_NA_BROJ
 (OJ_SIFRA_P IN T_RACUNI.OJ_SIFRA%TYPE
 ,VDOK_ID_P IN S_VDOKUMENATA.ID%TYPE
 ,VDOK_SIFRA2N_P IN T_RACUNI.VDOK_SIFRA2N%TYPE
 ,AGE_ID_P IN T_RACUNI.AGE_ID%TYPE
 ,AGEP_ID_P IN T_RACUNI.AGEP_ID%TYPE
 ,VPDOG_ID_P IN T_RACUNI.VPDOG_ID%TYPE
 ,GOD_POSLOVNA_P IN T_RACUNI.GOD_POSLOVNA%TYPE
 ,RBR_P IN T_RACUNI.RBR%TYPE
 )
 RETURN VARCHAR2
 IS
/*
Generiranje poziva na broj (22 znaka) za BI, BV raune:
  nebitno = ne generira se,
  A = vdok.sifra2n,
  B = rac.god_poslovna,
  C = SUBSTR (rac.rbr, 2, 6),
  D = rac.rbr,
  E = SUBSTR (agekup_sifra, 1, 5),
  F = oj.sifra,
  G = agekup_sifra,
  H = SUBSTR (rac.god_poslovna, 4, 1),
  ostalo prepisuje.
*/
  poziv_na_broj_l VARCHAR2(240);
  -- vdok_sifra2n_l s_vdokumenata.sifra2n%TYPE; -- IRN 2439 alju se ifre zapamene u raune
  -- oj_sifra_l m_oj.sifra%TYPE;
  agekupac_sifra_l m_agencije.sifra%TYPE;
  vrijednost_parametra_l szmp_parametri.vrijednost%TYPE;
BEGIN
  IF oj_sifra_p IS NULL
    OR vdok_id_p IS NULL
    OR vdok_sifra2N_p IS NULL
    OR age_id_p IS NULL
    OR god_poslovna_p IS NULL
    OR rbr_p IS NULL
  THEN
    RETURN (NULL);
  END IF;
  vrijednost_parametra_l := pra_rec_zaj.vrijednost_parametra ('1053');
  IF UPPER (vrijednost_parametra_l) = 'NEBITNO' THEN
    RETURN (NULL);
  END IF;
  FOR i IN 1 .. 10
  LOOP
    IF (SUBSTR (vrijednost_parametra_l, i, 1)) = 'A' THEN
      /* IRN 2439
      SELECT vdok.sifra2n INTO vdok_sifra2n_l
        FROM s_vapldok vapldok,
             s_vdokumenata vdok
       WHERE vapldok.id = vapldok_id_p
         AND vdok.id = vapldok.vdok_id;
      poziv_na_broj_l := poziv_na_broj_l || vdok_sifra2n_l;
      */
      poziv_na_broj_l := poziv_na_broj_l || vdok_sifra2n_p;
    ELSIF (SUBSTR (vrijednost_parametra_l, i, 1)) = 'B' THEN
      poziv_na_broj_l := poziv_na_broj_l || god_poslovna_p;
    ELSIF (SUBSTR (vrijednost_parametra_l, i, 1)) = 'C' THEN
      poziv_na_broj_l := poziv_na_broj_l || SUBSTR (rbr_p, 2, 6);
    ELSIF (SUBSTR (vrijednost_parametra_l, i, 1)) = 'D' THEN
      poziv_na_broj_l := poziv_na_broj_l || rbr_p;
    ELSIF (SUBSTR (vrijednost_parametra_l, i, 1)) = 'E' THEN
      SELECT sifra INTO agekupac_sifra_l
        FROM m_agencije
       WHERE id = pra_rec2.agekupac_id (vdok_id_p, age_id_p, agep_id_p, vpdog_id_p); -- vdok_id_p IRN 2439
      poziv_na_broj_l := poziv_na_broj_l || SUBSTR (agekupac_sifra_l, 1, 5);
    ELSIF (SUBSTR (vrijednost_parametra_l, i, 1)) = 'F' THEN
      /* IRN 2439
      SELECT oj.sifra INTO oj_sifra_l
        FROM m_oj oj
       WHERE oj.id = oj_id_p;
      poziv_na_broj_l := poziv_na_broj_l || oj_sifra_l;
      */
      poziv_na_broj_l := poziv_na_broj_l || oj_sifra_p;
    ELSIF (SUBSTR (vrijednost_parametra_l, i, 1)) = 'G' THEN
      SELECT sifra INTO agekupac_sifra_l
        FROM m_agencije
       WHERE id = pra_rec2.agekupac_id (vdok_id_p, age_id_p, agep_id_p, vpdog_id_p);
      poziv_na_broj_l := poziv_na_broj_l || agekupac_sifra_l;
    ELSIF (SUBSTR (vrijednost_parametra_l, i, 1)) = 'H' THEN
      poziv_na_broj_l := poziv_na_broj_l || SUBSTR (god_poslovna_p, 4, 1);
    ELSE
      poziv_na_broj_l := poziv_na_broj_l || SUBSTR (vrijednost_parametra_l, i, 1);
    END IF;
  END LOOP;
  RETURN (SUBSTR (poziv_na_broj_l, 1, 22));
END;
PROCEDURE PROVJERI_VAPLDOK_VPLA
 (VAPLDOK_ID_P IN t_racuni.vapldok_id%TYPE
 ,OJ_ID_P IN t_racuni.oj_id%TYPE
 ,VPLA_ID_P IN t_rac_nap.vpla_id%TYPE
 ,VAL_ID_P IN t_rac_nap.val_id%TYPE
 )
 IS
-- Provjeri doputenu vrstu plaanja
-- IRN 3544; alju se t_racuni.vapldok_id, t_racuni.oj_id, t_rac_nap.vpla_id i t_rac_nap.val_id
  vapldok_oznaka_l s_vapldok.oznaka%TYPE;
  br_redaka_l NUMBER;
  vlas_row_l s_vlasnik%ROWTYPE;
BEGIN
  IF vapldok_id_p IS NULL
    OR oj_id_p IS NULL
    OR vpla_id_p IS NULL
    OR val_id_p IS NULL
  THEN
    RETURN;
  END IF;

  vapldok_oznaka_l := pra_zmp.vapldok_oznaka (vapldok_id_p); -- IRN 3544
  SELECT * INTO vlas_row_l FROM s_vlasnik; -- IRN 3544

  SELECT COUNT (1) INTO br_redaka_l
    FROM m_vpla_val vplaval,
         s_valute val,
         s_vplacanja vpla,
         s_vpplacanja vppla
   WHERE vplaval.vpla_id = vpla.id
     AND vpla.id = vpla_id_p
     AND vpla.vppla_id = vppla.id
     AND vplaval.val_id = val.id
     AND val.id = val_id_p
     AND (
            (vapldok_oznaka_l = 'GI' AND vpla.ozn_got = -1)
         OR (vapldok_oznaka_l = 'BI' AND vpla.ozn_bez = -1 AND vpla.ozn_vpot = 0)
         OR (vapldok_oznaka_l = 'IR' AND vpla.ozn_bez = -1 AND vpla.ozn_vpot = 0)
         OR (vapldok_oznaka_l = 'BV' AND vpla.ozn_bez = -1 AND vpla.ozn_vpot = -1)
         OR (vapldok_oznaka_l = 'RP' AND 0 = 1)
         )
     AND vpla.ozn_rec = -1
     AND vplaval.oj_id = oj_id_p
     AND (
         val.ozn_upotrebe = -1
         OR val.sifra_3a = pra_rec_zaj.vrijednost_parametra ('0001')
         -- IRN 3544; dvojni optjecaj
         OR (vapldok_oznaka_l = 'GI'
             AND vppla.sifra = 'G'
             AND val.id = vlas_row_l.domval0_id
             AND TRUNC (SYSDATE) BETWEEN vlas_row_l.dat_primjene_domval AND vlas_row_l.dat_optjecaj_2val_zav)
         );
  IF br_redaka_l = 0 THEN
    -- Nedoputena vrsta plaanja!
    pra_rec_zaj.vrati_poruku (-20443);
  END IF;
END;
PROCEDURE PROVJERI_RACNAP
 (RAC_ID_P IN t_racuni.id%TYPE
 ,VAPLDOK_ID_P IN t_racuni.vapldok_id%TYPE
 ,OJ_ID_P IN t_racuni.oj_id%TYPE
 )
 IS
BEGIN
  IF rac_id_p IS NULL
    OR vapldok_id_p IS NULL
    OR oj_id_p IS NULL -- IRN 3544
  THEN
    RETURN;
  END IF;
  FOR c IN (
    SELECT vpla_id, val_id -- IRN 3544
      FROM t_rac_nap
     WHERE rac_id = rac_id_p)
  LOOP
    pra_t_racuni.provjeri_vapldok_vpla (vapldok_id_p, oj_id_p, c.vpla_id, c.val_id); -- IRN 3544
  END LOOP;
END;
PROCEDURE PROVJERI_RAC_DATUM
 (VAPLDOK_ID_P IN t_racuni.vapldok_id%TYPE
 ,DATUM_NEW_P IN t_racuni.datum%TYPE
 ,DATUM_OLD_P IN t_racuni.datum%TYPE
 )
 IS
-- IRN 1846
  oznaka_l s_vapldok.oznaka%TYPE;
BEGIN
  IF vapldok_id_p IS NULL OR datum_new_p IS NULL THEN
    RETURN;
  END IF;
  SELECT oznaka INTO oznaka_l FROM s_vapldok WHERE id = vapldok_id_p;
  IF oznaka_l = 'GI' THEN
    IF INSERTING AND datum_new_p <> TRUNC (SYSDATE) THEN
      -- Datum gotovinskog rauna ne moe biti razliit od tekueg!
      pra_rec_zaj.vrati_poruku (-20576);
    ELSIF UPDATING AND datum_new_p <> datum_old_p THEN
      -- Datum gotovinskog rauna ne moe se mijenjati!
      pra_rec_zaj.vrati_poruku (-20577);
    END IF;
  END IF;
END;
PROCEDURE PROVJERI_TRO_ZAK_ID
 (RAC_ID_P IN t_racuni.id%TYPE
 ,ZAK_ID_P IN t_racuni.zak_id%TYPE
 )
 IS
-- IRN 1861
  br_redaka_l NUMBER;
BEGIN
  IF rac_id_p IS NULL OR zak_id_p IS NULL THEN
    RETURN;
  END IF;

  SELECT COUNT (1) INTO br_redaka_l FROM t_troskovi WHERE rac_id = rac_id_p AND zak_id IS NOT NULL AND zak_id <> zak_id_p;
  IF br_redaka_l > 0 THEN
    -- Zaraunata usluga i raun ne mogu biti vezani za razliite ugovore o zakupu.
    pra_rec_zaj.vrati_poruku (-20578);
  END IF;
END;
FUNCTION TRO_IZNOS_BODB
 (RAC_ID_P IN t_troskovi.rac_id%TYPE
 ,RAC_IZN_TECAJA_P IN t_racuni.izn_tecaja%TYPE
 )
 RETURN t_racuni.iznos%TYPE
 IS
-- IRN 2562; zbroj iznosa zaraunatih usluga umanjen za odbitke u domaoj valuti
  iznos_l t_racuni.iznos%TYPE;
BEGIN
  IF rac_id_p IS NULL OR rac_izn_tecaja_p IS NULL THEN
    RETURN (0);
  END IF;

  SELECT SUM (ROUND (cijena_usluge * (stopa_placanja / 100) * izn_tecaja, 2)
              * kol_usluge
              * DECODE (obr_po_danu, -1, (dat_zav - dat_poc - obr_zdana), 1)
              - ROUND (izn_odbitka * rac_izn_tecaja_p, 2))
    INTO iznos_l
    FROM t_troskovi
   WHERE rac_id = rac_id_p
     AND usl_id1 IS NULL;

  RETURN (NVL (iznos_l, 0));

END;
FUNCTION PKARNK_IZNOS
 (RAC_ID_P IN tpka_rnkasa.rac_id%TYPE
 )
 RETURN t_racuni.iznos%TYPE
 IS
-- IRN 2562; zbroj iznosa zaraunatih internih POS rauna u domaoj valuti
  iznos_l t_racuni.iznos%TYPE;
BEGIN
  IF rac_id_p IS NULL THEN
    RETURN (0);
  END IF;

  SELECT SUM (izn_placanja) INTO iznos_l FROM tpka_rnkasa WHERE rac_id = rac_id_p;

  RETURN (NVL (iznos_l, 0));

END;
FUNCTION RACPDV_IZNOS
 (RAC_ID_P IN i_rac_pdv.rac_id%TYPE
 )
 RETURN t_racuni.iznos%TYPE
 IS
-- IRN 2562; zbroj iznosa (osnovica + PDV) po vrstama poreznih isporuka u domaoj valuti
  iznos_l t_racuni.iznos%TYPE;
BEGIN
  IF rac_id_p IS NULL THEN
    RETURN (0);
  END IF;

  SELECT SUM (izn_domval) INTO iznos_l FROM i_rac_pdv WHERE rac_id = rac_id_p;

  RETURN (NVL (iznos_l, 0));

END;
FUNCTION PPOT_IZNOS
 (RAC_ID_P IN tpka_rnkasa.rac_id%TYPE
 )
 RETURN t_racuni.iznos%TYPE
 IS
-- IRN 2562; zbroj iznosa zaraunatog poreza na potronju
  iznos_l t_racuni.iznos%TYPE;
BEGIN
  IF rac_id_p IS NULL THEN
    RETURN (0);
  END IF;

  SELECT SUM (izn_ppot) INTO iznos_l FROM tpka_rnkasa WHERE rac_id = rac_id_p;

  RETURN (NVL (iznos_l, 0));

END;
PROCEDURE PROVJERI_RAC_IZNOS
 (RAC_ID_P IN t_racuni.id%TYPE
 ,RAC_IZNOS_P IN t_racuni.iznos%TYPE
 ,RAC_IZN_TECAJA_P IN t_racuni.izn_tecaja%TYPE
 )
 IS
-- IRN 2562
  param_iznos_l    t_racuni.iznos%TYPE;
  param_iznos_ch_l VARCHAR2(5);
  rac_iznos_l      t_racuni.iznos%TYPE;
  tro_iznos_bodb_l t_racuni.iznos%TYPE;
  pkarnk_iznos_l   t_racuni.iznos%TYPE;
  racpdv_iznos_l   t_racuni.iznos%TYPE;
  ppot_iznos_l     t_racuni.iznos%TYPE;
  pnaknade_iznos_l  t_racuni.iznos%TYPE;
BEGIN
  IF rac_id_p IS NULL
    OR rac_iznos_p IS NULL
    OR rac_izn_tecaja_p IS NULL
  THEN
    RETURN;
  END IF;

  -- Doputeni iznos razlike izmeu iznosa rauna i zbroja iznosa zaraunatih usluga (do 99,99 pisano s decimalnim zarezom)
  BEGIN
    param_iznos_l := TO_NUMBER (pra_rec_zaj.vrijednost_parametra ('1190'), '99D99', 'NLS_NUMERIC_CHARACTERS = '',.'' ');
  EXCEPTION
    WHEN OTHERS THEN
      param_iznos_l := 1 / 100;
  END;
  param_iznos_ch_l := LTRIM (TO_CHAR (param_iznos_l, '90D00'));

  rac_iznos_l := ROUND (pra_rec_s2.iznos_racuna_bruto (rac_id_p, rac_iznos_p, rac_izn_tecaja_p) * rac_izn_tecaja_p, 2);
  tro_iznos_bodb_l := tro_iznos_bodb (rac_id_p, rac_izn_tecaja_p);
  pkarnk_iznos_l := pkarnk_iznos (rac_id_p);
  IF ABS (rac_iznos_l - tro_iznos_bodb_l - pkarnk_iznos_l) > param_iznos_l THEN
    -- Razlika izmeu iznosa rauna i zbroja iznosa zaraunatih usluga (#0) vea je od doputene (#1).
    pra_rec_zaj.vrati_poruku (-20607, LTRIM (TO_CHAR (ABS (rac_iznos_l - tro_iznos_bodb_l - pkarnk_iznos_l), '9G999G999G990D00')), param_iznos_ch_l);
  END IF;

  racpdv_iznos_l := racpdv_iznos (rac_id_p);
  ppot_iznos_l := ppot_iznos (rac_id_p);
  pnaknade_iznos_l := pra_rec_s5.izn_pnaknade_po (rac_id_p);
  IF ABS (rac_iznos_l - racpdv_iznos_l - ppot_iznos_l - pnaknade_iznos_l) > param_iznos_l THEN
    -- Razlika izmeu iznosa rauna i zbroja iznosa po vrstama poreznih isporuka (#0) vea je od doputene (#1).
    pra_rec_zaj.vrati_poruku (-20608, LTRIM (TO_CHAR (ABS (rac_iznos_l - racpdv_iznos_l - ppot_iznos_l - pnaknade_iznos_l), '9G999G999G990D00')), param_iznos_ch_l);
  END IF;

  IF ABS (tro_iznos_bodb_l + pkarnk_iznos_l - racpdv_iznos_l - ppot_iznos_l - pnaknade_iznos_l) > param_iznos_l THEN
    -- Razlika izmeu zbroja iznosa zaraunatih usluga i zbroja iznosa po vrstama poreznih isporuka (#0) vea je od doputene (#1).
    pra_rec_zaj.vrati_poruku (-20609, LTRIM (TO_CHAR (ABS (tro_iznos_bodb_l + pkarnk_iznos_l - racpdv_iznos_l - ppot_iznos_l - pnaknade_iznos_l), '9G999G999G990D00')), param_iznos_ch_l);
  END IF;
END;

END PRA_T_RACUNI;
/
SHOW ERROR

