PROMPT Creating Package Body 'PRA_T_PONUDE'
CREATE OR REPLACE PACKAGE BODY PRA_T_PONUDE IS

FUNCTION RASPOLOZIVI_KAPACITET
 (PONVSJ_ID_P IN T_PON_VSJ.ID%TYPE
 ,DAT_POC_P IN DATE
 ,DAT_ZAV_P IN DATE
 ,UGOVORENO_P IN NUMBER
 ,UVJET_P IN VARCHAR2 := NULL
 )
 RETURN SYS_REFCURSOR;


PROCEDURE AZURIRAJ_BOOKING
 (PON_ID_P IN T_PONUDE.ID%TYPE
 ,OZNAKA_P IN T_PONUDE.OZNAKA%TYPE
 ,MS_ID_P IN T_PONUDE.MS_ID%TYPE
 ,AGE_ID_P IN T_PONUDE.AGE_ID%TYPE
 ,RECVPRO_ID_P IN T_PONUDE.RECVPRO_ID%TYPE
 ,OZN_BOOK_P IN T_PONUDE.OZN_BOOK%TYPE
 ,OZN_AZURIRAJ_P IN NUMBER
 )
 IS
-- Azuriraj booking
  ozn_sprodaje_l i_booking.ozn_sprodaje%TYPE;
  ozn_sprodaje2_l i_booking.ozn_sprodaje%TYPE;
BEGIN
  IF oznaka_p IN ('V') THEN
    IF ozn_book_p = '1' THEN ozn_sprodaje_l := 'P';
    ELSIF ozn_book_p IN ('3') THEN ozn_sprodaje_l := 'A'; ozn_sprodaje2_l := 'P';
    ELSIF ozn_book_p IN ('4') THEN ozn_sprodaje_l := 'U'; ozn_sprodaje2_l := 'P';
    ELSIF ozn_book_p IN ('5') THEN ozn_sprodaje_l := 'Z'; ozn_sprodaje2_l := 'P';
    END IF;
    FOR ponvsj IN (
      SELECT ponvsj.id, ponso.id ponso_id, ponso.so_id,
             ponvsj.vsj_id, ponvsj.dat_poc, ponvsj.dat_zav, ponvsj.kol_sj, ponvsj.br_postelja
        FROM t_pon_so ponso,
             t_pon_vsj ponvsj
       WHERE ponso.ponojr_id IN (SELECT id FROM t_pon_ojr WHERE pon_id = pon_id_p)
         AND ponvsj.ponso_id = ponso.id)
    LOOP
    -- Auriraj booking za stupanj prodaje P - ponude, A - prihvaene ponude
      pra_rec_book.azuriraj_booking_razdoblje (
        ponvsj.so_id,
        ms_id_p,
        age_id_p,
        ponvsj.vsj_id,
        ponvsj.dat_poc,
        ponvsj.dat_zav,
        ozn_sprodaje_l,
        ozn_sprodaje2_l,
        ponvsj.kol_sj * ozn_azuriraj_p,
        ponvsj.br_postelja * ozn_azuriraj_p,
        NULL,      -- cijena
        ponvsj.ponso_id,
        recvpro_id_p);

      FOR recponvsja IN (
        SELECT kol_sj, br_postelja, dat_poc, dat_zav, DECODE(ozn_book_p, -1, ozn_sprodaje2_l, NULL) ozn_sprodaje2_l
          FROM trec_pon_vsja recponvsja
         WHERE ponvsj_id = ponvsj.id)
      LOOP
        pra_rec_book.azuriraj_booking_razdoblje (
          ponvsj.so_id,
          ms_id_p,
          age_id_p,
          ponvsj.vsj_id,
          recponvsja.dat_poc,
          recponvsja.dat_zav,
          ozn_sprodaje_l,
          recponvsja.ozn_sprodaje2_l,
          recponvsja.kol_sj * ozn_azuriraj_p,
          recponvsja.br_postelja * ozn_azuriraj_p,
          NULL,      -- cijena
          ponvsj.ponso_id,
          recvpro_id_p);
      END LOOP;
    END LOOP;
  END IF;
END;
PROCEDURE ZABRANI_IZMJENU_PONUDE
 (OZNAKA_P IN T_PONUDE.OZNAKA%TYPE
 )
 IS
BEGIN
  IF oznaka_p IS NULL THEN
    RETURN;
  END IF;

  IF oznaka_p IN ('P') THEN
    pra_rec_zaj.vrati_poruku (-20055);
  END IF;
END;
PROCEDURE PROVJERI_POCETAK_PONUDE
 (PON_ID_P IN T_PONUDE.ID%TYPE
 ,DAT_POC_P IN T_PONUDE.DAT_POC%TYPE
 ,DAT_DOL_MIN_P IN T_PONUDE.DAT_DOL_MIN%TYPE
 )
 IS
/* 
SO se ne moe nuditi prije poetka ponude
*/
BEGIN
  IF pon_id_p IS NULL
    OR dat_poc_p IS NULL
  THEN
    RETURN;
  END IF;
  FOR ponso IN (
    SELECT dat_dol_min, dat_poc
      FROM t_pon_so
     WHERE ponojr_id IN (SELECT id FROM t_pon_ojr WHERE pon_id = pon_id_p))
  LOOP
    IF ponso.dat_poc < dat_poc_p OR 
      NVL (ponso.dat_dol_min, ponso.dat_poc) < NVL (dat_dol_min_p, dat_poc_p)
    THEN
      pra_rec_zaj.vrati_poruku (-20206);
    END IF;
  END LOOP;
END;
PROCEDURE PROVJERI_ZAVRSETAK_PONUDE
 (PON_ID_P IN T_PONUDE.ID%TYPE
 ,DAT_ZAV_P IN T_PONUDE.DAT_ZAV%TYPE
 ,DAT_ODL_MAX_P IN T_PONUDE.DAT_ODL_MAX%TYPE
 )
 IS
/*
SO se ne moe nuditi nakon zavretka ponude
*/
BEGIN
  IF pon_id_p IS NULL
    OR dat_zav_p IS NULL
  THEN
    RETURN;
  END IF;
  FOR ponso IN (
    SELECT dat_zav, dat_odl_max
      FROM t_pon_so
     WHERE ponojr_id IN (SELECT id FROM t_pon_ojr WHERE pon_id = pon_id_p))
  LOOP
    IF ponso.dat_zav > dat_zav_p OR
      NVL (ponso.dat_odl_max, ponso.dat_zav) > NVL (dat_odl_max_p, dat_zav_p)
    THEN
      pra_rec_zaj.vrati_poruku (-20207);
    END IF;
  END LOOP;
END;
PROCEDURE PROVJERI_VALUTU
 (PON_ID_P IN T_PONUDE.ID%TYPE
 ,VAL_ID_P IN T_PONUDE.VAL_ID%TYPE
 )
 IS
/*
Valuta je obvezan podatak, ako postoji barem
jedan iznos traenog predujma
*/

  brojac_l NUMBER;
BEGIN
  IF val_id_p IS NOT NULL THEN
    RETURN;
  END IF;
  
  SELECT COUNT (id) INTO brojac_l
    FROM t_pon_so
   WHERE ponojr_id IN (SELECT id FROM t_pon_ojr WHERE pon_id = pon_id_p)
     AND izn_predujma IS NOT NULL; 
  IF brojac_l > 0 THEN
    pra_rec_zaj.vrati_poruku (-20073);
  END IF;

  SELECT COUNT (id) INTO brojac_l
    FROM t_pon_ojr
   WHERE pon_id = pon_id_p
     AND izn_predujma_gas IS NOT NULL;  
  IF brojac_l > 0 THEN
    pra_rec_zaj.vrati_poruku (-20073);
  END IF;
END;
PROCEDURE PROVJERI_VSJ
 (PON_ID_P IN T_PONUDE.ID%TYPE
 )
 IS
/*
Ponuena VSJ mora pripadati ponuenom SO
odnosno biti jednaka VSJ bilo koje SJ ponuenog SO
*/
BEGIN
  IF pon_id_p IS NULL THEN
    RETURN;
  END IF;

  FOR ponvsj IN (
    SELECT so_id, vsj_id, t_pon_vsj.dat_poc, t_pon_vsj.dat_zav
      FROM t_pon_so, t_pon_vsj
     WHERE t_pon_so.ponojr_id IN (SELECT id FROM t_pon_ojr WHERE pon_id = pon_id_p)
       AND t_pon_so.id = t_pon_vsj.ponso_id)
  LOOP
    pra_rec.provjeri_vsj 
      (ponvsj.vsj_id, ponvsj.so_id, ponvsj.dat_poc, ponvsj.dat_zav - 1);
  END LOOP;
END;
PROCEDURE PROVJERI_DOPUSTENU_TRANZICIJU
 (OZNAKA_NEW_P IN T_PONUDE.OZNAKA%TYPE
 ,OZNAKA_OLD_P IN T_PONUDE.OZNAKA%TYPE
 ,OZN_BOOK_NEW_P IN T_PONUDE.OZN_BOOK%TYPE
 ,OZN_BOOK_OLD_P IN T_PONUDE.OZN_BOOK%TYPE
 ,PON_ID_P IN T_PONUDE.ID%TYPE
 )
 IS
-- Provjeri doputene tranzicije; koristi se u BUR okidau tablice T_PONUDE
-- nisu provjeravane tranzicije koje se provjeravaju drugdje: pra_t_ponude.zabrani_izmjenu_ponude i PON_OZN_BOOK_OZNAKA_CK
BEGIN
  IF   (oznaka_new_p = 'P' AND NVL (ozn_book_new_p, 0) <> NVL (ozn_book_old_p, 0))
    OR (oznaka_new_p = 'V' AND NVL (ozn_book_new_p, 0) < NVL (ozn_book_old_p, 0))
    OR (oznaka_new_p = '*' AND oznaka_old_p = 'V')
  THEN
    -- Nedoputena tranzicija oznake dokumenata.
    pra_rec_zaj.vrati_poruku (-20056);
  END IF;
  IF (oznaka_new_p = 'V'
    AND NVL (ozn_book_old_p, '0') <> NVL (ozn_book_new_p, '0')
    AND NVL (ozn_book_old_p, '0') IN ('3', '4', '5')
    AND NVL (ozn_book_new_p, '0') IN ('3', '4', '5'))
  THEN
    -- Samo poslana ponuda i ponuda u izradi (*) mogu biti potvrene u ugovor.
    pra_rec_zaj.vrati_poruku (-20535);
  END IF;
END;
PROCEDURE VRATI_ZAGLAVLJE
 (PON_ID_P IN T_PONUDE.ID%TYPE
 ,OZNAKA_P IN OUT T_PONUDE.OZNAKA%TYPE
 )
 IS
BEGIN
  SELECT oznaka
    INTO oznaka_p
    FROM t_ponude
   WHERE id = pon_id_p;
END;
PROCEDURE PROVJERI_RECPONCJE_DAT_POC_ZAV
 (PONSO_ID_P IN trec_pon_cjeusl.ponso_id%TYPE
 ,VSJ_ID_P IN trec_pon_cjeusl.vsj_id%TYPE
 ,USL_ID_P IN trec_pon_cjeusl.usl_id%TYPE
 ,RECARA_ID_P IN TREC_PON_CJEUSL.RECARA_ID%TYPE
 ,DAT_POC_P IN trec_pon_cjeusl.dat_poc%TYPE
 ,DAT_ZAV_P IN trec_pon_cjeusl.dat_zav%TYPE
 )
 IS
--
  CURSOR recponcje_c IS
    SELECT dat_poc, dat_zav
      FROM trec_pon_cjeusl
     WHERE ponso_id = ponso_id_p
       AND NVL (vsj_id, -1) = NVL (vsj_id_p, -1)
       AND NVL (recara_id, -1) = NVL (recara_id_p, -1)
       AND usl_id = usl_id_p;
  dat_poc_l trec_pon_cjeusl.dat_poc%TYPE;
  dat_zav_l trec_pon_cjeusl.dat_zav%TYPE;
BEGIN
  IF ponso_id_p IS NULL
    OR usl_id_p IS NULL
    OR dat_poc_p IS NULL
    OR dat_zav_p IS NULL
  THEN
    RETURN;
  END IF;

  OPEN recponcje_c;
  LOOP
    FETCH recponcje_c INTO dat_poc_l, dat_zav_l;
    EXIT WHEN recponcje_c%NOTFOUND;
    IF dat_poc_p <> dat_poc_l
      AND dat_poc_p <= dat_zav_l
      AND dat_zav_p >= dat_poc_l
    THEN
      CLOSE recponcje_c;
      -- Razdoblja cjenika ne mogu se preklapati.
      pra_rec_zaj.vrati_poruku (-20476);
    END IF;
  END LOOP;
  CLOSE recponcje_c;
END;
PROCEDURE PROVJERI_VALUTU_PONOJR
 (PON_ID_P IN T_PON_OJR.ID%TYPE
 ,IZN_PREDUJMA_P IN T_PON_SO.IZN_PREDUJMA%TYPE
 )
 IS
/* 
Valuta je obvezan podatak, ako postoji barem 
jedan iznos traenog predujma
*/

  val_id_l t_ponude.val_id%TYPE;
BEGIN
  IF pon_id_p IS NULL
    OR izn_predujma_p IS NULL
  THEN
    RETURN;
  END IF;

  SELECT val_id INTO val_id_l
    FROM t_ponude
   WHERE id = pon_id_p;

  IF val_id_l IS NULL THEN 
    pra_rec_zaj.vrati_poruku (-20073);
  END IF; 
END;
PROCEDURE PROVJERI_PON_REZ
 (PON_ID_P IN T_PONUDE.ID%TYPE
 ,AGE_ID_P IN T_PONUDE.AGE_ID%TYPE
 ,MS_ID_P IN T_PONUDE.MS_ID%TYPE
 )
 IS
/*
Ako postoje valjane rezervacija koje su nastale iz ponude onda im 
MS, AGE moraju biti jednaki 
*/
  CURSOR ponso_c IS
    SELECT id
      FROM t_pon_so
     WHERE ponojr_id IN (SELECT id FROM t_pon_ojr WHERE pon_id = pon_id_p);
  CURSOR rez_c (ponso_id_k t_pon_so.id%TYPE) IS
    SELECT age_id, ms_id
      FROM t_rezervacije
     WHERE ponso_id = ponso_id_k
       AND oznaka = 'V';
BEGIN
  FOR ponso IN ponso_c
  LOOP
    FOR rez IN rez_c (ponso.id)
    LOOP
      IF rez.age_id <> age_id_p
        OR rez.ms_id <> ms_id_p
      THEN
        pra_rec_zaj.vrati_poruku (-20485);
      END IF;
    END LOOP;
  END LOOP;
END;
PROCEDURE PROVJERI_PON_TRO
 (PON_ID_P IN T_PONUDE.ID%TYPE
 ,OZNAKA_P IN T_PONUDE.OZNAKA%TYPE
 )
 IS
/*
Ne moe se ponititi ponuda na koju su vezani nezaraunati trokovi
ili trokovi vezani za raune u pripremi.
*/
  brojac_l NUMBER;
BEGIN
  IF pon_id_p IS NULL OR oznaka_p IS NULL THEN
    RETURN;
  END IF;
  
  IF oznaka_p = 'V' THEN
    RETURN;
  END IF;

  SELECT COUNT (tro.ROWID) INTO brojac_l
    FROM t_troskovi tro, t_pon_so ponso, t_pon_ojr ponojr
   WHERE tro.ponso_id = ponso.id
     AND ponso.ponojr_id = ponojr.id
     AND ponojr.pon_id = pon_id_p
     AND rac_id IS NULL;
  IF brojac_l <> 0 AND oznaka_p = 'P' THEN
    pra_rec_zaj.vrati_poruku (-20496);
  END IF;

  SELECT COUNT (tro.ROWID) INTO brojac_l
    FROM t_troskovi tro, t_pon_so ponso, t_pon_ojr ponojr,
         t_racuni rac,
         s_vapldok vapldok
   WHERE tro.ponso_id = ponso.id
     AND ponso.ponojr_id = ponojr.id
     AND ponojr.pon_id = pon_id_p
     AND tro.rac_id = rac.id
     AND rac.vapldok_id = vapldok.id
     AND vapldok.oznaka = 'RP';
  IF brojac_l <> 0 AND oznaka_p = 'P' THEN
    pra_rec_zaj.vrati_poruku (-20496);
  END IF;
END;
PROCEDURE PROVJERI_PRIP_PONDOGDJE_PONOJR
 (PONOJR_ID_P IN t_pon_ojr.id%TYPE
 ,PONDOG_ID_P IN t_pon_dog.id%TYPE
 )
 IS
/*
Provjeri da djeca ponuenog dogaaja pripadaju ponojr.
Koristi se za provjeru ponopr, ponpros, ponproi prilikom upisa ponojr u pondog.
Poruka: Redak koji pripada dogaaju mora pripadati istoj knjizi rauna kao dogaaj
odnosno knjizi rauna koja pripada istoj ponudi kao dogaaj.
*/
  brojac_l NUMBER;
BEGIN
  IF ponojr_id_p IS NULL
    OR pondog_id_p IS NULL
  THEN
    RETURN;
  END IF;

  -- provjera ponojr u t_pon_pros
  SELECT COUNT (id) INTO brojac_l
    FROM t_pon_pros
   WHERE pondog_id = pondog_id_p
     AND ponojr_id <> ponojr_id_p;
  IF brojac_l <> 0 THEN
    pra_rec_zaj.vrati_poruku (-20504);
  ELSE
    -- provjera ponojr u t_pon_opr
    SELECT COUNT (id) INTO brojac_l
      FROM t_pon_opr
     WHERE pondog_id = pondog_id_p
       AND ponojr_id <> ponojr_id_p;
    IF brojac_l <> 0 THEN
      pra_rec_zaj.vrati_poruku (-20504);
    END IF;
  END IF;
END;
PROCEDURE PROVJERI_PRIPADA_PONDOG_PON
 (PON_ID_P IN t_ponude.id%TYPE
 ,PONDOG_ID_P IN t_pon_dog.id%TYPE
 )
 IS
/*
Provjeri da pondog pripada ponudi.
Poruka: Dogaaj napomene mora pripadati istoj ponudi kao napomena.
*/
  pon_id_l t_ponude.id%TYPE;
BEGIN
  IF pon_id_p IS NULL
    OR pondog_id_p IS NULL
  THEN
    RETURN;
  END IF;

  SELECT pon_id INTO pon_id_l
    FROM t_pon_dog
   WHERE id = pondog_id_p;

  IF pon_id_p <> pon_id_l THEN
    pra_rec_zaj.vrati_poruku (-20503);
  END IF;

END;
PROCEDURE PROVJERI_PRIPADA_PONDOG_PONOJR
 (PONOJR_ID_P IN t_pon_ojr.id%TYPE
 ,PONDOG_ID_P IN t_pon_dog.id%TYPE
 )
 IS
/*
Provjeri da pondog pripada ponojr.
Koristi se za provjeru ponopr, ponpros, ponproi.
Poruka: Redak koji pripada dogaaju mora pripadati istoj knjizi rauna kao dogaaj
odnosno knjizi rauna koja pripada istoj ponudi kao dogaaj.
*/
  ponojr_id_l t_pon_ojr.id%TYPE;
  pon_id_dog_l t_ponude.id%TYPE;
  pon_id_ojr_l t_ponude.id%TYPE;
BEGIN
  IF ponojr_id_p IS NULL
    OR pondog_id_p IS NULL
  THEN
    RETURN;
  END IF;

  SELECT pon_id, ponojr_id INTO pon_id_dog_l, ponojr_id_l
    FROM t_pon_dog
   WHERE id = pondog_id_p;

  IF ponojr_id_l IS NOT NULL THEN
    IF ponojr_id_l <> ponojr_id_p THEN
      pra_rec_zaj.vrati_poruku (-20504);
    END IF;
  ELSE
    -- ako dogaaj nije vezan na knjigu rauna onda se provjerava ponuda dogaaja i ponuda ojr
    SELECT pon_id INTO pon_id_ojr_l
      FROM t_pon_ojr
     WHERE id = ponojr_id_p;
    IF pon_id_ojr_l <> pon_id_dog_l THEN
      pra_rec_zaj.vrati_poruku (-20504);
    END IF;
  END IF;
END;
PROCEDURE PROVJERI_PRIPADA_PONOJR_PON
 (PON_ID_P IN t_ponude.id%TYPE
 ,PONOJR_ID_P IN t_pon_ojr.id%TYPE
 )
 IS
/*
Provjeri da ponojr pripada ponudi.
Poruka: Knjiga rauna dogaaja mora pripadati istoj ponudi kao dogaaj.
*/
  pon_id_l t_ponude.id%TYPE;
BEGIN
  IF pon_id_p IS NULL
    OR ponojr_id_p IS NULL
  THEN
    RETURN;
  END IF;

  SELECT pon_id INTO pon_id_l
    FROM t_pon_ojr
   WHERE id = ponojr_id_p;

  IF pon_id_p <> pon_id_l THEN
    pra_rec_zaj.vrati_poruku (-20502);
  END IF;

END;
PROCEDURE PROVJERI_RECPONBOR_PREKLAPANJE
 (PONSO_ID_P IN TREC_PON_BOR.PONSO_ID%TYPE
 ,DAT_POC_P IN TREC_PON_BOR.DAT_POC%TYPE
 ,DAT_ZAV_P IN TREC_PON_BOR.DAT_ZAV%TYPE
 ,OZN_DANA_DOLASKA_P IN TREC_PON_BOR.OZN_DANA_DOLASKA%TYPE
 )
 IS
/*
Razdoblja ponudenog minimalnog boravka ne mogu se preklapati.
*/

  dat_poc_l t_ponude.dat_poc%TYPE;
  dat_zav_l t_ponude.dat_zav%TYPE;

  CURSOR recponbor_c IS
    SELECT dat_poc, dat_zav
      FROM trec_pon_bor
     WHERE ponso_id = ponso_id_p
       AND NVL(ozn_dana_dolaska,0) = NVL(ozn_dana_dolaska_p,0);
BEGIN
  IF ponso_id_p IS NULL
    OR dat_poc_p IS NULL
    OR dat_zav_p IS NULL
  THEN
    RETURN;
  END IF;
  OPEN recponbor_c;
  LOOP
    FETCH recponbor_c INTO dat_poc_l, dat_zav_l;
    EXIT WHEN recponbor_c%NOTFOUND;
    IF dat_poc_p <> dat_poc_l
      AND dat_poc_p < dat_zav_l
      AND dat_zav_p > dat_poc_l
    THEN
      CLOSE recponbor_c;
      pra_rec_zaj.vrati_poruku (-20510);
    END IF;
  END LOOP;
  CLOSE recponbor_c;
END;
PROCEDURE PROVJERI_RECPONROK_PREKLAPANJE
 (PONSO_ID_P IN TREC_PON_ROK.PONSO_ID%TYPE
 ,DAT_POC_P IN TREC_PON_ROK.DAT_POC%TYPE
 ,DAT_ZAV_P IN TREC_PON_ROK.DAT_ZAV%TYPE
 )
 IS
/*
Razdoblja ponudenog roka dospijea popisa gostiju ne mogu se preklapati.
*/

  dat_poc_l t_ponude.dat_poc%TYPE;
  dat_zav_l t_ponude.dat_zav%TYPE;

  CURSOR recponrok_c IS
    SELECT dat_poc, dat_zav
      FROM trec_pon_rok
     WHERE ponso_id = ponso_id_p;
BEGIN
  IF ponso_id_p IS NULL
    OR dat_poc_p IS NULL
    OR dat_zav_p IS NULL
  THEN
    RETURN;
  END IF;
  OPEN recponrok_c;
  LOOP
    FETCH recponrok_c INTO dat_poc_l, dat_zav_l;
    EXIT WHEN recponrok_c%NOTFOUND;
    IF dat_poc_p <> dat_poc_l
      AND dat_poc_p < dat_zav_l
      AND dat_zav_p > dat_poc_l
    THEN
      CLOSE recponrok_c;
      pra_rec_zaj.vrati_poruku (-20511);
    END IF;
  END LOOP;
  CLOSE recponrok_c;
END;
FUNCTION RASPOLOZIVI_KAPACITET
 (PONVSJ_ID_P IN T_PON_VSJ.ID%TYPE
 ,DAT_POC_P IN DATE
 ,DAT_ZAV_P IN DATE
 ,UGOVORENO_P IN NUMBER
 ,UVJET_P IN VARCHAR2 := NULL
 )
 RETURN SYS_REFCURSOR
 IS
--
  vsjc_id_l t_pon_vsj.vsjc_id%TYPE;
  vsj_id_l t_pon_vsj.vsj_id%TYPE;
  ponso_id_l t_pon_so.id%TYPE;
  kol_sj_l t_pon_vsj.kol_sj%TYPE;
  br_postelja_l t_pon_vsj.br_postelja%TYPE;

  CURSOR ponvsj_c IS
    SELECT ponso.id, ponvsj.vsj_id, ponvsj.vsjc_id, ponvsj.kol_sj, ponvsj.br_postelja
      FROM t_ponude pon, t_pon_ojr ponojr, t_pon_so ponso, t_pon_vsj ponvsj
     WHERE pon.id = ponojr.pon_id
       AND ponojr.id = ponso.ponojr_id
       AND ponso.id = ponvsj.ponso_id
       AND ponvsj.id = ponvsj_id_p;

  CURSOR ponso_cvor_c (ponso_id_p NUMBER) IS
    SELECT DECODE (so.metcvor_sifra, sifra_tekuceg_cvora, '', '@' || metcvor_sifra)
      FROM m_so so, t_pon_so ponso, s_vlasnik vla
     WHERE ponso.so_id = so.id
       AND ponso.id = ponso_id_p;

  curs_l sys_refcursor;
  datum_l DATE;
  ponso_cvor_p VARCHAR2(40);
BEGIN
  OPEN ponvsj_c;
  FETCH ponvsj_c INTO ponso_id_l, vsj_id_l, vsjc_id_l, kol_sj_l, br_postelja_l;

  OPEN ponso_cvor_c(ponso_id_l);
  FETCH ponso_cvor_c INTO ponso_cvor_p;

  IF ponvsj_c%FOUND THEN
    datum_l := zmp_zaj.set_dates (dat_poc_p, dat_zav_p - 1);
    IF NVL(ugovoreno_p, 0) = -1 THEN
      OPEN curs_l FOR
        'SELECT datum, SUM (kol_sj) kol_sj,' ||
        '              SUM (br_postelja) br_postelja FROM' ||
        ' (SELECT kal.datum, SUM (ponvsja.kol_sj) + :kol_sj_l kol_sj,' ||
        '                    SUM (ponvsja.br_postelja) + :br_postelja_l br_postelja' ||
        '    FROM v_zmp_kalendar kal,' ||
        '         (SELECT ponvsj_id, dat_poc, dat_zav, kol_sj, br_postelja' ||
        '            FROM trec_pon_vsja' ||
        '           UNION ALL' ||
        '          SELECT 0 ponvsj_id, TO_DATE (:dat_poc_p) dat_poc, TO_DATE (:dat_zav_p) dat_zav, 0 kol_sj, 0 br_postelja' ||
        '            FROM dual) ponvsja' ||
        '   WHERE kal.datum BETWEEN TO_DATE (:dat_poc_p) AND TO_DATE (:dat_zav_p) - 1' ||
        '     AND kal.datum BETWEEN ponvsja.dat_poc AND ponvsja.dat_zav - 1' ||
        '     AND (ponvsja.ponvsj_id = :ponvsj_id_p OR ponvsja.ponvsj_id = 0)' ||
        '   GROUP BY kal.datum' ||
        ' ) ' ||
        'GROUP BY datum ' || uvjet_p  || ' ORDER BY datum'
      USING kol_sj_l, br_postelja_l, dat_poc_p, dat_zav_p, dat_poc_p, dat_zav_p, ponvsj_id_p;
    ELSE
      OPEN curs_l FOR
        'SELECT datum, SUM (kol_sj) kol_sj,' ||
        '              SUM (br_postelja) br_postelja FROM' ||
        ' (SELECT kal.datum, SUM (ponvsja.kol_sj) + :kol_sj_l kol_sj,' ||
        '                    SUM (ponvsja.br_postelja) + :br_postelja_l br_postelja' ||
        '    FROM v_zmp_kalendar kal,' ||
        '         (SELECT ponvsj_id, dat_poc, dat_zav, kol_sj, br_postelja' ||
        '            FROM trec_pon_vsja' ||
        '           UNION ALL' ||
        '          SELECT 0 ponvsj_id, TO_DATE (:dat_poc_p) dat_poc, TO_DATE (:dat_zav_p) dat_zav, 0 kol_sj, 0 br_postelja' ||
        '            FROM dual) ponvsja' ||
        '   WHERE kal.datum BETWEEN TO_DATE (:dat_poc_p) AND TO_DATE (:dat_zav_p) - 1' ||
        '     AND kal.datum BETWEEN ponvsja.dat_poc AND ponvsja.dat_zav - 1' ||
        '     AND (ponvsja.ponvsj_id = :ponvsj_id_p OR ponvsja.ponvsj_id = 0)' ||
        '   GROUP BY kal.datum' ||
        '  UNION ALL' ||
        '  SELECT kal.datum, SUM (DECODE (rez.ozn_vstorna, NULL, rezvsj.kol_sj, NVL (rezvsj.kol_sjz, 0))) * -1 kol_sj,' ||
        '                    SUM (DECODE (rez.ozn_vstorna, NULL, rezvsj.br_osoba, NVL (rezvsj.br_osobaz, 0))) * -1 br_postelja' ||
        '    FROM v_zmp_kalendar kal, t_rez_vsj' || ponso_cvor_p || ' rezvsj, t_rezervacije' || ponso_cvor_p || ' rez' ||
        '   WHERE kal.datum BETWEEN TO_DATE (:dat_poc_p) AND TO_DATE (:dat_zav_p) - 1' ||
        '     AND kal.datum BETWEEN rez.dat_dolaska AND rez.dat_odlaska - 1' ||
        '     AND NVL(rezvsj.vsjp_id, rezvsj.vsj_id) = :vsj_id_l' ||
        '     AND rezvsj.vsjc_id = :vsjc_id_l' ||
        '     AND rezvsj.rez_id = rez.id' ||
        '     AND rez.ponso_id = :ponso_id_l' ||
        '     AND rez.oznaka IN ''V''' ||
        '   GROUP BY kal.datum' ||
        '  UNION ALL' ||
        '  SELECT kal.datum, SUM (DECODE((SELECT gost_id' ||
        '                                   FROM i_statusisj' || ponso_cvor_p || ' sj' ||
        '                                  WHERE sj.sj_id = sj.id' ||
        '                                    AND sj.datum = kal.datum)' ||
        '                    ,gost.id, 1, 0)) * -1 kol_sj,' ||
        '                    COUNT (gost.id) * -1 br_postelja' ||
        '    FROM v_zmp_kalendar kal, t_gosti' || ponso_cvor_p || ' gost, m_sj' || ponso_cvor_p || ' sj, t_pon_vsj' || ponso_cvor_p || ' ponvsj' ||
        '   WHERE kal.datum BETWEEN TO_DATE (:dat_poc_p) AND TO_DATE (:dat_zav_p) - 1' ||
        '     AND kal.datum BETWEEN gost.dat_dolaska AND gost.dat_odlaska - 1' ||
        '     AND kal.datum BETWEEN ponvsj.dat_poc AND ponvsj.dat_zav - 1' ||
        '     AND pra_rec_s2.sj_id_recgostbor' || ponso_cvor_p || ' (gost.id, kal.datum) = sj.id ' ||
        '     AND gost.rezvsj_id IS NULL and gost.ponso_id IS NOT NULL' ||
        '     AND gost.ponso_id = ponvsj.ponso_id' ||
        '     AND ponvsj.vsjc_id = gost.vsj_id' ||
        '     AND ponvsj.vsj_id = sj.vsj_id' ||
        '     AND ponvsj.vsj_id = :vsj_id_l' ||
        '     AND ponvsj.vsjc_id = :vsjc_id_l' ||
        '     AND gost.ponso_id = :ponso_id_l' ||
        '   GROUP BY kal.datum' ||
        ' ) ' ||
        'GROUP BY datum ' || uvjet_p  || ' ORDER BY datum'
      USING kol_sj_l, br_postelja_l, dat_poc_p, dat_zav_p, dat_poc_p, dat_zav_p, ponvsj_id_p,
            dat_poc_p, dat_zav_p, vsj_id_l, vsjc_id_l, ponso_id_l,
            dat_poc_p, dat_zav_p, vsj_id_l, vsjc_id_l, ponso_id_l;
    END IF;
  END IF;
  RETURN curs_l;
END;
PROCEDURE IZMIJENI_PON_KAPACITET
 (PONVSJ_ID_P IN T_PON_VSJ.ID%TYPE
 ,KOL_SJ_P IN T_PON_VSJ.KOL_SJ%TYPE
 ,BR_POSTELJA_P IN T_PON_VSJ.BR_POSTELJA%TYPE
 ,DAT_POC_P IN T_PON_VSJ.DAT_POC%TYPE
 ,DAT_ZAV_P IN T_PON_VSJ.DAT_ZAV%TYPE
 ,UGOVORENO_P IN NUMBER
 ,UNOS_KORISNIK_P IN VARCHAR2
 )
 IS
--
  datum_c DATE;
  kol_sj_c t_pon_vsj.kol_sj%TYPE;
  br_postelja_c t_pon_vsj.br_postelja%TYPE;
  kol_sj_l t_pon_vsj.kol_sj%TYPE;
  br_postelja_l t_pon_vsj.br_postelja%TYPE;
  datum_l DATE := NULL;
  broj_dana_l NUMBER := 0;
  curs_l sys_refcursor;
BEGIN
  IF ponvsj_id_p IS NULL OR
    kol_sj_p IS NULL OR
    br_postelja_p IS NULL OR
    dat_poc_p IS NULL OR
    dat_zav_p IS NULL
  THEN
    RETURN;
  END IF;
  
  /* Samo cvor-centar moe aurirati ponueni kapacitet. */
  IF pra_zmp_zaj.centar = 0 THEN
    pra_rec_zaj.vrati_poruku (-20520);
  END IF;

  curs_l := raspolozivi_kapacitet (ponvsj_id_p, dat_poc_p, dat_zav_p, ugovoreno_p);
  LOOP
    FETCH curs_l INTO datum_c, kol_sj_c, br_postelja_c;
    EXIT WHEN curs_l%NOTFOUND;
    IF datum_l IS NOT NULL AND datum_l + broj_dana_l + 1 = datum_c AND
      kol_sj_l = kol_sj_c AND br_postelja_l = br_postelja_c
    THEN
      broj_dana_l := broj_dana_l + 1;
    ELSE
      IF datum_l IS NOT NULL AND (kol_sj_p - kol_sj_l <> 0) AND (br_postelja_p - br_postelja_l <> 0) THEN
        INSERT INTO trec_pon_vsja
         (ponvsj_id, dat_poc, dat_zav, kol_sj, br_postelja, unos_korisnik, unos_dat, izmjena_korisnik, izmjena_dat)
        VALUES
         (ponvsj_id_p, datum_l, datum_l + broj_dana_l + 1, kol_sj_p - kol_sj_l, br_postelja_p - br_postelja_l, unos_korisnik_p, SYSDATE, unos_korisnik_p, SYSDATE);
      END IF;
      datum_l := datum_c;
      broj_dana_l := 0;
      kol_sj_l := kol_sj_c;
      br_postelja_l := br_postelja_c;
    END IF;
  END LOOP;
  IF datum_l IS NOT NULL AND (kol_sj_p - kol_sj_l <> 0) AND (br_postelja_p - br_postelja_l <> 0) THEN
    INSERT INTO trec_pon_vsja
     (ponvsj_id, dat_poc, dat_zav, kol_sj, br_postelja, unos_korisnik, unos_dat, izmjena_korisnik, izmjena_dat)
    VALUES
     (ponvsj_id_p, datum_l, datum_l + broj_dana_l + 1, kol_sj_p - kol_sj_l, br_postelja_p - br_postelja_l, unos_korisnik_p, SYSDATE, unos_korisnik_p, SYSDATE);
  END IF;
  COMMIT;
  CLOSE curs_l;
END;
FUNCTION RASPOLOZIVI_KAPACITET
 (PONVSJ_ID_P IN T_PON_VSJ.ID%TYPE
 ,DATUM_P IN T_PON_VSJ.DAT_POC%TYPE
 ,UGOVORENO_P IN NUMBER
 )
 RETURN VARCHAR2
 IS
--
  datum_c DATE;
  kol_sj_c t_pon_vsj.kol_sj%TYPE;
  br_postelja_c t_pon_vsj.br_postelja%TYPE;
  curs_l sys_refcursor;
BEGIN
  curs_l := raspolozivi_kapacitet (ponvsj_id_p, datum_p, datum_p + 1, ugovoreno_p);
  LOOP
    FETCH curs_l INTO datum_c, kol_sj_c, br_postelja_c;
    EXIT WHEN curs_l%NOTFOUND;
  END LOOP;
  RETURN TO_CHAR (kol_sj_c);
END;
FUNCTION DODATI_KAPACITET
 (PONVSJ_ID_P IN T_PON_VSJ.ID%TYPE
 ,KOL_SJ_P IN T_PON_VSJ.KOL_SJ%TYPE
 ,DAT_POC_P IN T_PON_VSJ.DAT_POC%TYPE
 ,DAT_ZAV_P IN T_PON_VSJ.DAT_ZAV%TYPE
 ,UGOVORENO_P IN NUMBER
 )
 RETURN BOOLEAN
 IS
--
  rc_l sys_refcursor;
  datum_l DATE;
  kol_sj_l t_pon_vsj.kol_sj%TYPE;
  br_postelja_l t_pon_vsj.br_postelja%TYPE;
BEGIN
  rc_l := raspolozivi_kapacitet (ponvsj_id_p, dat_poc_p, dat_zav_p, ugovoreno_p, 'HAVING SUM (kol_sj) < ' || kol_sj_p);
  FETCH rc_l INTO datum_l, kol_sj_l, br_postelja_l;
  IF rc_l%NOTFOUND THEN
    RETURN FALSE;
  END IF;
  RETURN TRUE;
END;
PROCEDURE PROVJERI_PON_REZ
 (PON_ID_P IN T_PONUDE.ID%TYPE
 ,OZNAKA_P IN T_PONUDE.OZNAKA%TYPE
 )
 IS
/*
Ne moete ponititi ponudu na koju su vezane valjane rezervacije.
*/
  brojac_l NUMBER;
BEGIN
  IF pon_id_p IS NULL OR oznaka_p IS NULL THEN
    RETURN;
  END IF;
  
  IF oznaka_p = 'V' THEN
    RETURN;
  END IF;

  SELECT COUNT (rez.ROWID) INTO brojac_l
    FROM t_rezervacije rez, t_pon_so ponso, t_pon_ojr ponojr
   WHERE rez.ponso_id = ponso.id
     AND ponso.ponojr_id = ponojr.id
     AND ponojr.pon_id = pon_id_p
     AND rez.oznaka = 'V'
     AND rez.ozn_vstorna IS NULL;

  IF brojac_l <> 0 AND oznaka_p = 'P' THEN
    pra_rec_zaj.vrati_poruku (-20542);
  END IF;
END;
PROCEDURE PROVJERI_PON_OZNAKA
 (PON_ID_P IN t_ponude.id%TYPE
 )
 IS
-- Zabrani izmjenu ponitenog dokumenta
  oznaka_l t_ponude.oznaka%TYPE;
BEGIN
  SELECT oznaka INTO oznaka_l FROM t_ponude WHERE id = pon_id_p;
  IF oznaka_l = 'P' THEN
    -- Poniteni dokument ne moe se mijenjati.
    pra_rec_zaj.vrati_poruku (-20055);
  END IF;
END;
PROCEDURE PROVJERI_PON_OZNAKA_PONOJR
 (PONOJR_ID_P IN t_pon_ojr.id%TYPE
 )
 IS
-- Zabrani izmjenu ponitenog dokumenta
  oznaka_l t_ponude.oznaka%TYPE;
BEGIN
  SELECT pon.oznaka
    INTO oznaka_l
    FROM t_pon_ojr ponojr,
         t_ponude pon
   WHERE ponojr.id = ponojr_id_p
     AND ponojr.pon_id = pon.id;
  IF oznaka_l = 'P' THEN
    -- Poniteni dokument ne moe se mijenjati.
    pra_rec_zaj.vrati_poruku (-20055);
  END IF;
END;
PROCEDURE PROVJERI_OVERBOOKING
 (PON_ID_P IN t_ponude.id%TYPE
 ,OZNAKA_P IN t_ponude.oznaka%TYPE
 ,OZN_BOOK_P IN t_ponude.ozn_book%TYPE
 ,POSTOJI_OVER_P IN OUT BOOLEAN
 ,PRVI_DAT_P IN OUT t_pon_vsj.dat_poc%TYPE
 )
 IS
--
  postoji_overbooking_so_l BOOLEAN := FALSE;
  -- Dopustiti overbooking po ugovorima za fiksni zakup: da ili ne.
  RECparam_1143 szmp_parametri.vrijednost%TYPE := UPPER (pra_zmp_zaj.zmppar_vrijednost ('REC', '1143'));
  -- Oznaka za kontrolu overbookinga u Rezervacijama: 0 = nema kontrole, 1 = kontrola na razini ponude/ugovora (javlja se i u Ponudi/Ugovoru), 2 = kontrola na razini SO
  RECparam_1004 szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.zmppar_vrijednost ('REC', '1004');
  dat_over_l t_pon_vsj.dat_poc%TYPE;
BEGIN
  IF oznaka_p = 'V' AND ozn_book_p = '5' THEN
    FOR ponvsj_c IN
      (SELECT ponso.id ponso_id,
              ponvsj.id ponvsj_id,
              ponvsj.dat_poc dat_poc,
              ponvsj.dat_zav dat_zav,
              ponvsj.vsj_id vsj_id,
              ponvsj.vsjc_id vsjc_id,
              ponvsj.kol_sj kol_sj
         FROM t_pon_vsj ponvsj,
              t_pon_so ponso,
              t_pon_ojr ponojr,
              t_ponude pon
        WHERE pon.id = pon_id_p
          AND ponojr.pon_id = pon.id
          AND ponso.ponojr_id = ponojr.id
          AND ponvsj.ponso_id = ponso.id
      )
    LOOP
      IF RECparam_1143 = 'NE' OR RECparam_1004 IN ('1' , '2') THEN
        fm_rec4510.brisi_tab_overbooking;
        fm_rec4510.puni_tab_overbooking_p_s (
          ponvsj_c.ponso_id,
          ponvsj_c.ponvsj_id,
          NULL,
          ponvsj_c.dat_poc,
          ponvsj_c.dat_zav,
          ponvsj_c.vsj_id,
          ponvsj_c.kol_sj,
          postoji_overbooking_so_l,
          dat_over_l);

        IF postoji_overbooking_so_l THEN
          postoji_over_p := TRUE;
          prvi_dat_p := dat_over_l;
          EXIT;
        END IF;
      END IF;
    END LOOP;
  END IF;
END;
PROCEDURE STOP_BOOKING_SO
 (DAT_POC_P IN DATE
 ,DAT_ZAV_P IN DATE
 ,MS_ID_P IN M_MSEGMENTI.ID%TYPE
 ,SO_ID_P IN M_SO.ID%TYPE
 ,VSJ_ID_P IN T_PON_VSJ.VSJ_ID%TYPE
 ,PON_ID_P IN T_PONUDE.ID%TYPE
 ,OZN_BOOK_P IN T_PONUDE.OZN_BOOK%TYPE
 ,USERNAME_P IN VARCHAR2
 )
 IS
BEGIN
  FOR c IN (
    SELECT ponvsj.id ponvsj_id,
           GREATEST (ponvsj.dat_poc, dat_poc_p) dat_poc,
           LEAST (ponvsj.dat_zav, dat_zav_p) dat_zav
      FROM t_ponude pon,
           t_pon_ojr ponojr,
           t_pon_so ponso,
           t_pon_vsj ponvsj
     WHERE pon.ozn_book = ozn_book_p
       AND pon.ms_id = ms_id_p
       -- ifre marketinkih segmenata za koje je u modulu Ponude/Ugovori doputeno skupno stopiranje bookinga ili nebitno.
       AND fm_rec2120.ms_u_param (pon.ms_id, pra_zmp_zaj.zmppar_vrijednost ('REC', '1152')) = -1
       AND pon.id = NVL (pon_id_p, pon.id)
       AND ponojr.pon_id = pon.id
       AND ponso.ponojr_id = ponojr.id
       AND ponso.so_id = NVL (so_id_p, ponso.so_id)
       AND ponvsj.ponso_id = ponso.id
       AND ponvsj.vsj_id = NVL (vsj_id_p, ponvsj.vsj_id)
       AND ponvsj.dat_zav >= dat_poc_p
       AND ponvsj.dat_poc < dat_zav_p)
  LOOP
    pra_t_ponude.izmijeni_pon_kapacitet (
      c.ponvsj_id,
      0,
      0,
      c.dat_poc,
      c.dat_zav,
      -1,
      username_p);
  END LOOP;
END;

END PRA_T_PONUDE;
/
SHOW ERROR

