-- C:\Users\dgajic\Desktop\IRN 4124\greka_MT\des\v1\pra_rezvanjsus.pkb
--
-- Generated for Oracle 10g on Mon Dec 22  15:44:23 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'PRA_REZVANJSUS'
CREATE OR REPLACE PACKAGE BODY PRA_REZVANJSUS IS

VANJSKI_SUSTAV_M VARCHAR2(240) := UPPER(pra_zmp_zaj.zmppar_vrijednost ('REC', '1136'));
BROJAC_M NUMBER(2);
DATA_M CLOB;
ODGOVOR_M CLOB;
PORUKA_M VARCHAR2(4000);
PORUKA_SJ_M VARCHAR2(4000);
SOSUS_SIFRA_ZA_SUBJ_M MREC_SO_SUS.SIFRA%TYPE;
OZN_REZERVACIJA_MAPA_M NUMBER := 0;
PORUKA_M_DODATNO VARCHAR2(4000);
SUBJECT_M VARCHAR2(240);

PROCEDURE ZAPAMTI_UPISANE_SJ
 (SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
 );
PROCEDURE VRATI_ZAPAMCENU_SJ
 (SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,REZVSJ_ID_P IN T_REZ_VSJ.ID%TYPE
 );
FUNCTION REZVANJSUS_STRING
 (VRSTA_P IN VARCHAR2
 )
 RETURN CLOB;
PROCEDURE AZURIRAJ_REZ_ZA_SO
 (SIFRA_P IN MREC_SO_SUS.SIFRA%TYPE
 ,SO_ID_P IN MREC_SO_SUS.SO_ID%TYPE
 ,SAMO_IZMIJENJENE_P IN NUMBER := -1
 ,DAT_POC_P IN DATE := NULL
 ,DAT_ZAV_P IN DATE := NULL
 ,DEBUG_P IN NUMBER := 0
 );
PROCEDURE POST2_REZSUS
 (REQUEST_P IN CLOB
 ,URL_P IN VARCHAR2 := NULL
 );
PROCEDURE ODGOVORI_REZVANJSUS
 (REZ_SIFRA_P IN VARCHAR2
 ,SO_ID_P IN M_SO.ID%TYPE
 ,CONFIRM_ID_P IN VARCHAR2
 ,RBR_STRING_P IN VARCHAR2
 );
PROCEDURE UNESI_REZ
 (SO_ID_P IN M_SO.ID%TYPE
 ,XMLREZ_P IN CLOB
 ,PORUKA_SJ_MAPA_P IN VARCHAR2
 ,RBR_STRING_P OUT VARCHAR2
 );
PROCEDURE UNESI_REZCJE
 (REZ_SIFRA_P IN LSYNXIS_REZERVACIJE.SYNXIS_SIFRA%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,REZ_ID_P IN TREC_REZ_CJEUSL.REZ_ID%TYPE
 ,VSJC_ID_P IN TREC_REZ_CJEUSL.VSJ_ID%TYPE
 ,USL_SIFRA_P IN MZMP_USL_SUS.SIFRA%TYPE
 ,XMLREZCJE_P IN CLOB
 ,XMLREZSUPP_P IN CLOB
 ,DAT_DOLAZ_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,DAT_ODLAZ_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
 ,IZNOS_BP_P IN VARCHAR2
 ,MARKETCODE_P IN VARCHAR2
 ,UNOS_KORISNIK_P IN M_KORISNICI.NAZIV%TYPE
 );
PROCEDURE UNESI_REZGOST
 (REZ_SIFRA_P IN LSYNXIS_REZERVACIJE.SYNXIS_SIFRA%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,REZVSJ_ID_P IN T_REZ_VSJ.ID%TYPE
 ,XMLREZGOST_P IN CLOB
 ,XMLDOBGRUPE_P IN CLOB
 );
FUNCTION UNESI_REZUSL
 (REZ_SIFRA_P IN LSYNXIS_REZERVACIJE.SYNXIS_SIFRA%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,XMLUSL_SIFRA_P IN VARCHAR2
 ,XMLUSLPER_P IN CLOB
 ,RECARA_ID_P IN MREC_ARANZMANI.ID%TYPE
 ,PLACA_GOST_P IN T_REZ_USL.OZN_PLATITELJA%TYPE
 )
 RETURN NUMBER;
PROCEDURE UNESI_REZVSJ
 (REZ_SIFRA_P IN LSYNXIS_REZERVACIJE.SYNXIS_SIFRA%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,REZ_ID_P IN TREC_REZ_CJEUSL.REZ_ID%TYPE
 ,XMLREZVSJ_P IN CLOB
 ,XMLUSL_P IN CLOB
 ,XMLGUESTS_P IN CLOB
 ,PROVJERA_P IN NUMBER
 ,REZ_DATDOL_P IN DATE
 ,REZ_DATODL_P IN DATE
 ,SO_ID_P IN T_REZERVACIJE.SO_ID%TYPE
 ,MS_ID_P IN T_REZERVACIJE.MS_ID%TYPE
 ,MARKETCODE_P IN VARCHAR2
 );
PROCEDURE UNESI_SUPP
 (REZ_SIFRA_P IN LSYNXIS_REZERVACIJE.SYNXIS_SIFRA%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,XMLREZSUPP_P IN CLOB
 ,MS_ID_P IN T_REZERVACIJE.MS_ID%TYPE
 ,SO_ID_P IN T_REZERVACIJE.SO_ID%TYPE
 ,DAT_DOLASKA_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,USL_ID_P IN S_USLUGE.ID%TYPE
 ,IZNOS_BP_P IN VARCHAR2
 ,RECARA_ID_P IN MREC_ARANZMANI.ID%TYPE
 ,PLACA_GOST_P IN T_REZ_USL.OZN_PLATITELJA%TYPE
 );
PROCEDURE ARHIVIRAJ_XML
 (NAZIV_P IN VARCHAR2
 ,XML_P IN CLOB
 ,PORUKA_P IN VARCHAR2
 );
PROCEDURE ODREDI_AGE_I_MS
 (CREATORID_P IN VARCHAR2
 ,AGENCIJA_P IN VARCHAR2
 ,MARKETCODE_P IN VARCHAR2
 ,RECVPRO_ID_P IN MREC_VPROGRAMA.ID%TYPE
 ,AGE_ID_P IN OUT M_AGENCIJE.ID%TYPE
 ,MS_ID_P IN OUT M_MSEGMENTI.ID%TYPE
 );
FUNCTION REPLACEINCLOB
 (OPCLOB IN CLOB
 ,CPREPLACESTR IN VARCHAR2 := UTL_TCP.CRLF
 ,CPREPLACEWITH IN VARCHAR2 := NULL
 )
 RETURN CLOB;
PROCEDURE POVEZI_REZERVACIJU_MAPA
 (REZ_SIFRA_P IN LSYNXIS_REZERVACIJE.SYNXIS_SIFRA%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,REZ_SIFRA_MAPA_P IN VARCHAR2
 ,PORUKA_SJ_MAPA_P OUT VARCHAR2
 );
PROCEDURE ZAPAMTI_REZ_ZA_ODG
 (REZ_SIFRA_P IN PREC_GLOBAL.OPIS1%TYPE
 ,CONFIRM_ID_P IN PREC_GLOBAL.OPIS2%TYPE
 ,RBR_STRING_P IN PREC_GLOBAL.OPIS3%TYPE
 );


PROCEDURE ZAPAMTI_UPISANE_SJ
 (SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
 )
 IS
--
  greska_l EXCEPTION;
  rez_id_l t_rez_vsj.rez_id%TYPE;
  cvor_l m_so.metcvor_sifra%TYPE;

  tekuci_cvor_l m_so.metcvor_sifra%TYPE;
  target_cvor_l VARCHAR2(41) := '';

  CURSOR synxrez_c IS
    SELECT rez_id, metcvor_sifra
      FROM lsynxis_rezervacije
     WHERE synxis_sifra = synxis_sifra_p
       AND vanj_sustav = vanjski_sustav_m;

  select_rezvsj_sj_l VARCHAR2(2000) :=
    'SELECT vsj_id, vsjc_id, kol_sj, br_osoba, sj_id, ozn_fiksna_sj
       FROM t_rez_vsj<cvor>
      WHERE rez_id = :1';

  rezvsj_sj_c  SYS_REFCURSOR;
  rezvsj_sj_l  rezvsjsj_rec;
BEGIN

  IF synxis_sifra_p IS NULL THEN
    RAISE greska_l;
  END IF;

  OPEN synxrez_c;
  FETCH synxrez_c INTO rez_id_l, cvor_l;
  CLOSE synxrez_c;

  SELECT sifra_tekuceg_cvora INTO tekuci_cvor_l FROM s_vlasnik;
  IF NOT cvor_l = tekuci_cvor_l THEN
    target_cvor_l := '@' || cvor_l;
  END IF;

  brojac_m := 0;

  OPEN rezvsj_sj_c FOR REPLACE (REPLACE (select_rezvsj_sj_l, ':1', rez_id_l), '<cvor>', target_cvor_l);
  FETCH rezvsj_sj_c INTO rezvsj_sj_l;

  WHILE rezvsj_sj_c%FOUND LOOP
    brojac_m := brojac_m + 1;

    rezvsjsj (brojac_m).vsj_id        := rezvsj_sj_l.vsj_id;
    rezvsjsj (brojac_m).vsjc_id       := rezvsj_sj_l.vsjc_id;
    rezvsjsj (brojac_m).kol_sj        := rezvsj_sj_l.kol_sj;
    rezvsjsj (brojac_m).br_osoba      := rezvsj_sj_l.br_osoba;
    rezvsjsj (brojac_m).sj_id         := rezvsj_sj_l.sj_id;
    rezvsjsj (brojac_m).ozn_fiksna_sj := rezvsj_sj_l.ozn_fiksna_sj;

    FETCH rezvsj_sj_c INTO rezvsj_sj_l;
  END LOOP;

  CLOSE rezvsj_sj_c;

END;
PROCEDURE VRATI_ZAPAMCENU_SJ
 (SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,REZVSJ_ID_P IN T_REZ_VSJ.ID%TYPE
 )
 IS
--
  greska_l EXCEPTION;
  rez_id_l t_rez_vsj.rez_id%TYPE;
  target_cvor_l VARCHAR2(41) := '';

  select_rezvsj_sj_l VARCHAR2(2000) :=
    'SELECT vsj_id, vsjc_id, kol_sj, br_osoba
       FROM t_rez_vsj<cvor>
      WHERE id = :rezvsj_id';

  rezvsj_c SYS_REFCURSOR;

  vsj_id_l         t_rez_vsj.vsj_id%TYPE;
  vsjc_id_l        t_rez_vsj.vsjc_id%TYPE;
  kol_sj_l         t_rez_vsj.kol_sj%TYPE;
  br_osoba_l       t_rez_vsj.br_osoba%TYPE;

  sj_id_l          t_rez_vsj.sj_id%TYPE;
  ozn_fiksna_sj_l  t_rez_vsj.ozn_fiksna_sj%TYPE;

  update_rezvsj_sj_l VARCHAR2(2000) :=
    'UPDATE t_rez_vsj<cvor>
        SET sj_id = :sj_id,
            ozn_fiksna_sj = :ozn_fiksna_sj
      WHERE id = :rezvsj_id';
BEGIN

  IF synxis_sifra_p IS NULL THEN
    RAISE greska_l;
  END IF;

  /*
  vrati id i cvor t_rezervacije za zadani broj rezervacije
  */
  pra_rec_synxis.vrati_rez_id_cvor
       (synxis_sifra_p => synxis_sifra_p
       ,vanj_sustav_p => vanjski_sustav_m
       ,creator_id_p => creator_id_p
       ,recsosus_sifra_p => recsosus_sifra_p
       ,rez_id_p => rez_id_l
       ,target_cvor_p => target_cvor_l  
       );

  OPEN rezvsj_c FOR
    REPLACE (
      REPLACE (select_rezvsj_sj_l,
               ':rezvsj_id', rezvsj_id_p),
               '<cvor>', target_cvor_l);
  FETCH rezvsj_c INTO vsj_id_l, vsjc_id_l, kol_sj_l, br_osoba_l;
  CLOSE rezvsj_c;

  -- IRN 3613 ako je PHOBS rezervacija napravljena preko mape ne provjerava se broj osoba kod vraanja broja SJ
  FOR i IN 1..brojac_m LOOP
    IF rezvsjsj (i).vsj_id  = vsj_id_l AND
      rezvsjsj (i).vsjc_id  = vsjc_id_l AND
      rezvsjsj (i).kol_sj   = kol_sj_l AND
      (rezvsjsj (i).br_osoba = br_osoba_l OR ozn_rezervacija_mapa_m = -1) AND
      rezvsjsj (i).sj_id IS NOT NULL
    THEN

      sj_id_l := rezvsjsj (i).sj_id;
      ozn_fiksna_sj_l := rezvsjsj (i).ozn_fiksna_sj;

      rezvsjsj (i).sj_id := NULL;
      EXIT;

    END IF;
  END LOOP;

  IF sj_id_l IS NOT NULL THEN
    EXECUTE IMMEDIATE REPLACE (update_rezvsj_sj_l, '<cvor>', target_cvor_l)
      USING sj_id_l, ozn_fiksna_sj_l, rezvsj_id_p;
  END IF;
END;
PROCEDURE UPISI_BROJ_SJ
 (REZ_ID_P IN T_REZERVACIJE.ID%TYPE
 ,REZVSJ_ID_P IN NUMBER
 ,PORUKA_P OUT VARCHAR2
 )
 IS
--
  rezvsj_id_l   t_rez_vsj.id%TYPE;
  so_id_l       t_rezervacije.so_id%TYPE;
  dat_poc_l     t_rezervacije.dat_dolaska%TYPE;
  dat_zav_l     t_rezervacije.dat_odlaska%TYPE;
  vsj_id_l      t_rez_vsj.vsj_id%TYPE;
  kol_sj_l      t_rez_vsj.kol_sj%TYPE;
  vsj_sifra_l   s_vsj.sifra%TYPE;

  sj_id_l       t_rez_vsj.sj_id%TYPE;

  sifra_param_l szmp_parametri.sifra%TYPE := '1006';
  param_l       szmp_parametri.vrijednost%TYPE;
BEGIN

  param_l := LOWER (pra_zmp_zaj.zmppar_vrijednost (vanjski_sustav_m, sifra_param_l));

  IF NVL (param_l, 'ne') <> 'da' THEN
    RETURN;
  END IF;

  FOR rezvsj_c IN
    (SELECT rez.so_id       so_id,
            rez.dat_dolaska dat_poc,
            rez.dat_odlaska dat_zav,
            rezvsj.id       id,
            rezvsj.vsj_id   vsj_id,
            rezvsj.kol_sj   kol_sj,
            rezvsj.sj_id    sj_id,
            vsj.sifra       vsj_sifra
       FROM t_rez_vsj rezvsj,
            t_rezervacije rez,
            s_vsj vsj
      WHERE rez.id = rez_id_p
        AND rezvsj.rez_id = rez.id
        AND NVL(rezvsj_id_p, rezvsj.id) = rezvsj.id
        AND vsj.id = rezvsj.vsj_id)
  LOOP

    sj_id_l := NULL;

    IF rezvsj_c.kol_sj = 1 AND rezvsj_c.sj_id IS NULL THEN
      SELECT pra_rec_s5.slobodna_sj (
               rezvsj_c.so_id,
               rezvsj_c.vsj_id,
               rezvsj_c.dat_poc,
               rezvsj_c.dat_zav)
        INTO sj_id_l
        FROM DUAL;
    END IF;

    IF sj_id_l IS NOT NULL THEN
      BEGIN
        UPDATE t_rez_vsj
           SET sj_id = sj_id_l
         WHERE id = rezvsj_c.id;
      EXCEPTION
        WHEN OTHERS THEN
          poruka_p := poruka_p || 'SJ za ' || rezvsj_c.vsj_sifra || ' nije upisana.' || chr(10);
      END;

    ELSIF rezvsj_c.sj_id IS NULL THEN
      poruka_p := poruka_p || 'SJ za ' || rezvsj_c.vsj_sifra || ' nije upisana.' || chr(10);
    END IF;

  END LOOP;

END;
FUNCTION REZVANJSUS_STRING
 (VRSTA_P IN VARCHAR2
 )
 RETURN CLOB
 IS
--
BEGIN
  IF vrsta_p = 'REQUEST' THEN
  -- request po pravilima odabranog vanjskog sustava

    IF vanjski_sustav_m = 'ROOMCLOUD' THEN
      RETURN
        '<?xml version="1.0" encoding="UTF-8"?>
        <Request apikey="istratech_t7hjSj87NVW44s40R0y" userName="USER" password="PASS">
          <reservations hotelId="SO" useDLM="BOOLEAN" startDate="" endDate="" version="2"/>
        </Request>';

    ELSIF vanjski_sustav_m = 'SIMPLEBOOKING' THEN
      RETURN
        '<?xml version="1.0" encoding="UTF-8" ?>
        <OTA_HotelResNotifRQ xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns="http://www.opentravel.org/OTA/2003/05" xsi:schemaLocation="http://www.opentravel.org/OTA/2003/05 OTA_HotelResNotifRQ.xsd"
        TimeStamp="TIMESTAMP" Target="Production" Version="2.001">
          <TPA_Extensions>
            <provider Name="XMlw23!.33" Pwd="LxlR25.12"/>
            <XMLHotelAgent Name="USER" Pwd="PASS"/>
            <Filter HotelCode="SO" Start="" End="" Code="" FilterType="FILTERTYPE"/>
          </TPA_Extensions>
        </OTA_HotelResNotifRQ>' ;

    ELSIF vanjski_sustav_m = 'PHOBS2' THEN
      RETURN
        '<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
                            xmlns:ns1="http://www.opentravel.org/OTA/2003/05"
                            xmlns:ns2="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd"
                            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
           <SOAP-ENV:Header>
             <ns2:Security>
               <ns2:UsernameToken>
                 <ns2:Username>USER</ns2:Username>
                 <ns2:Password xsi:type="ns2:http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText">PASS</ns2:Password>
               </ns2:UsernameToken>
             </ns2:Security>
           </SOAP-ENV:Header>;
           <SOAP-ENV:Body>
             <ns1:OTA_HotelResNotifRS ResResponseType="Commited" EchoToken="PHOBS2f365ccea7b707701c98d2c13e40d224" TimeStamp="TIMESTAMP" Version="1.006">
               <ns1:Success/>
             </ns1:OTA_HotelResNotifRS>";
           </SOAP-ENV:Body>
         </SOAP-ENV:Envelope>';
    
    ELSE
      RETURN NULL;
    END IF;

  ELSIF vrsta_p = 'OBRADI' THEN
  -- ifra i xml pojedine rezervacije
  -- IRN 3631 dodano itanje rez_sifra_mapa i sj_broj_mapa za povezivanje na mish rez kada ide upis preko mape

    IF vanjski_sustav_m = 'ROOMCLOUD' THEN
      RETURN
        'SELECT Extract(column_value, ''/reservation'').getclobval() rez,
                ExtractValue(column_value, ''/reservation/@id'') rez_sifra,
                NULL PMSConfirmationID,
                NULL rez_sifra_mapa,
                NULL sj_broj_mapa,
                NULL creatorID,
                NULL so_sifra
           FROM TABLE (XMLSequence (extract (XMLType (:odgovor), ''/Response/reservation'')))';

    ELSIF vanjski_sustav_m = 'SIMPLEBOOKING' THEN
      RETURN
        'SELECT Extract(column_value, ''/HotelReservation'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'').getclobval() rez,
                ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/HotelReservationIDs/HotelReservationID/@ResID_Value'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') rez_sifra,
                NULL PMSConfirmationID,
                NULL rez_sifra_mapa,
                NULL sj_broj_mapa,
                NULL creatorID,
                NULL so_sifra
           FROM TABLE (XMLSequence (extract (XMLType (:odgovor), ''/OTA_HotelResNotifRQ/HotelReservations/HotelReservation'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))';

    ELSIF vanjski_sustav_m = 'PHOBS2' THEN
      RETURN
        'SELECT Extract(column_value, ''/HotelReservation'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'').getclobval() rez,
                ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/HotelReservationIDs/HotelReservationID[1]/@ResID_Value'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') rez_sifra,
                ExtractValue(column_value, ''/HotelReservation/UniqueID/@PMSConfirmationID'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') PMSConfirmationID,
                SUBSTR (ExtractValue(column_value, ''/HotelReservation/RoomStays/RoomStay[1]/RoomTypes/RoomType[1]/@RoomTypeCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 32) rez_sifra_mapa,
                SUBSTR (ExtractValue(column_value, ''/HotelReservation/RoomStays/RoomStay[1]/RoomTypes/RoomType[1]/@RoomLocationCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 10) sj_broj_mapa,
                ExtractValue(column_value, ''/HotelReservation/@CreatorID'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') creatorID,
                ExtractValue(column_value, ''/HotelReservation/RoomStays/RoomStay[1]/BasicPropertyInfo/@HotelCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') so_sifra
           FROM TABLE (XMLSequence (extract (XMLType (:odgovor), ''/SOAP-ENV:Envelope//SOAP-ENV:Body/ns2:OTA_HotelResNotifRQ/ns2:HotelReservations/ns2:HotelReservation'', 
                                                                 ''xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ns1="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd" xmlns:ns2="http://www.opentravel.org/OTA/2003/05"'')))';

    ELSE
      RETURN NULL;
    END IF;

  ELSIF vrsta_p = 'REZ' THEN
  -- podaci iz zaglavlja rezervacije, xml svih buduih rezvsj i usluge na razini cijele rezervacije ako mogu postojati

    IF vanjski_sustav_m = 'ROOMCLOUD' THEN
      RETURN
        'SELECT ''<reservation>'' || Extract(column_value, ''/reservation/room'').getclobval() || ''</reservation>'' rooms,
                ''<reservation>'' || Extract(column_value, ''/reservation/supplement'').getclobval() || ''</reservation>'' services,
                NULL guests,
                ExtractValue(column_value, ''/reservation/@id'') rez_sifra,
                ExtractValue(column_value, ''/reservation/@status'') status,
                NULL creatorID,         
                TRUNC(TO_DATE(SUBSTR(ExtractValue(column_value, ''/reservation/@creation_date''), 1, 10), ''rrrr-mm-dd'')) datum_rez,	 
                NULL so_sifra,
				(SELECT MAX(ExtractValue(column_value, ''/room/@rateId'')) 
				   FROM TABLE (XMLSequence (extract(column_value, ''/reservation/room'')))) cje_sifra,
                NULL marketCode,
                ExtractValue(column_value, ''/reservation/@portalId'') age_sifra,
                TRUNC(TO_DATE(ExtractValue(column_value, ''/reservation/@checkin''), ''rrrr-mm-dd'')) dat_dolaska,
                TRUNC(TO_DATE(ExtractValue(column_value, ''/reservation/@checkout''), ''rrrr-mm-dd'')) dat_odlaska,
				NULL vpro_sifra, 
				NULL titula,
                SUBSTR(ExtractValue(column_value, ''/reservation/@firstName''), 1, 20) ime,
                SUBSTR(ExtractValue(column_value, ''/reservation/@lastName''), 1, 20) prezime,
                SUBSTR(ExtractValue(column_value, ''/reservation/@city''), 1, 40) naz_mjesta,
                UPPER(ExtractValue(column_value, ''/reservation/@country'')) zem_sifra2a,
                SUBSTR(ExtractValue(column_value, ''/reservation/@email''), 1, 50) email,
                ExtractValue(column_value, ''/reservation/@telephone'') br_telefona,
                SUBSTR(ExtractValue(column_value, ''/reservation/@address''), 1, 40) address,
                SUBSTR(ExtractValue(column_value, ''/reservation/@zipCode''), 1, 8) zipCode,
				NULL loyaltyID,
				0 newsletter,
                TO_NUMBER(ExtractValue(column_value, ''/reservation/@price''),  ''9999999999999990.09'') iznos,
                ExtractValue(column_value, ''/reservation/@currencycode'') valuta,
				NULL stopa_popusta,
                ExtractValue(column_value, ''/reservation/@notes'') napomena,
                TO_NUMBER (ExtractValue(column_value, ''/reservation/@prepaid''), ''9999999999999990.09'') izn_predujma,
                ExtractValue(column_value, ''/reservation/@currencycode'') val_sifra3a,
                NULL obrazlozenje_storna,
                NULL predujam_text,
                NULL predujam_vpla,
                NULL rez_agent
           FROM TABLE (XMLSequence (extract (XMLType(:xmlrez_p), ''/reservation'')))';

    ELSIF vanjski_sustav_m = 'SIMPLEBOOKING' THEN
      RETURN
        'SELECT ''<HotelReservation xmlns="http://www.opentravel.org/OTA/2003/05">'' || Extract(column_value, ''/HotelReservation/RoomStays'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'').getclobval() || ''</HotelReservation>'' rooms,
                ''<HotelReservation xmlns="http://www.opentravel.org/OTA/2003/05">'' || Extract(column_value, ''/HotelReservation/Services'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'').getclobval() || ''</HotelReservation>'' services,
                ''<HotelReservation xmlns="http://www.opentravel.org/OTA/2003/05">'' || Extract(column_value, ''/HotelReservation/ResGuests'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'').getclobval() || ''</HotelReservation>'' guests,
                ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/HotelReservationIDs/HotelReservationID/@ResID_Value'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') rez_sifra,
                ExtractValue(column_value, ''/HotelReservation/@ResStatus'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') status,
                NULL creatorID,  
                TRUNC(TO_DATE(SUBSTR(ExtractValue(column_value, ''/HotelReservation/@CreateDateTime'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 10), ''rrrr-mm-dd'')) datum_rez,
                NULL so_sifra,
				(SELECT ExtractValue(column_value, ''/RatePlan[1]/@RatePlanID'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')
				   FROM TABLE (XMLSequence (extract(column_value, ''/HotelReservation/RoomStays/RoomStay[1]/RatePlans/RatePlan[1]'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))) cje_sifra,
                NULL marketCode,
                ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/Profiles/ProfileInfo[1]/Profile/Customer/Address/CompanyName'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') age_sifra,
                TRUNC(TO_DATE(ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/TimeSpan/@Start'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), ''rrrr-mm-dd'')) dat_dolaska,
                TRUNC(TO_DATE(ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/TimeSpan/@End'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), ''rrrr-mm-dd'')) dat_odlaska,
                NULL vpro_sifra, 
				NULL titula,
                SUBSTR(ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/Profiles/ProfileInfo/Profile/Customer/PersonName/GivenName'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 20) ime,
                SUBSTR(ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/Profiles/ProfileInfo/Profile/Customer/PersonName/Surname'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 20) prezime,
                SUBSTR(ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/Profiles/ProfileInfo/Profile/Customer/Address/CityName'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 40) naz_mjesta,
                UPPER(ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/Profiles/ProfileInfo/Profile/Customer/Address/CountryName/@Code'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')) zem_sifra2a,
                SUBSTR(ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/Profiles/ProfileInfo/Profile/Customer/Email'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 50) email,
                NULL, -- ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/Profiles/ProfileInfo/Profile/Customer/Telephone/@PhoneNumber'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') br_telefona,
                SUBSTR(ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/Profiles/ProfileInfo/Profile/Customer/Address/AddressLine'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 40) address,
                SUBSTR(ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/Profiles/ProfileInfo/Profile/Customer/Address/PostalCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 8) zipCode,
                NULL loyaltyID,
				0 newsletter,
                ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/Total/@AmountAfterTax'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') / POWER (10, TO_NUMBER(ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/Total/@DecimalPlaces'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''))) iznos,
                ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/Total/@CurrencyCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') valuta,
                NULL stopa_popusta,
                ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/Comments/Comment[1]/Text'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') napomena,  -- moe ih biti vie
                TO_NUMBER (ExtractValue(column_value, ''/HotelReservation/@prepaid'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), ''9999999999999990.09'') izn_predujma,
                ExtractValue(column_value, ''/HotelReservation/@currencycode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') val_sifra3a,
                NULL obrazlozenje_storna,
                NULL predujam_text,
                NULL predujam_vpla,
                NULL rez_agent
           FROM TABLE (XMLSequence (extract (XMLType(:xmlrez_p), ''/HotelReservation'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))';

    ELSIF vanjski_sustav_m = 'PHOBS2' THEN
      RETURN
        'SELECT t.rooms,
                t.services,
                t.guests,
                t.rez_sifra,
                t.status,
                t.creatorID,
                t.datum_rez,
                t.so_sifra,
                t.cje_sifra,
                t.marketCode,
                t.age_sifra,
                t.dat_dolaska,
                t.dat_odlaska,
                t.vpro_sifra,
                SUBSTR(ExtractValue(t.customer, ''/Customer/PersonName/NamePrefix[1]'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 20) titula,
                SUBSTR(ExtractValue(t.customer, ''/Customer/PersonName/GivenName'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 20) ime,
                SUBSTR(ExtractValue(t.customer, ''/Customer/PersonName/Surname'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 20) prezime,
                SUBSTR(ExtractValue(t.customer, ''/Customer/Address/CityName'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 40) naz_mjesta,
                UPPER(ExtractValue(t.customer, ''/Customer/Address/CountryName/@Code'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')) zem_sifra2a,
                SUBSTR(ExtractValue(t.customer, ''/Customer/Email'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 50) email,
                ExtractValue(t.customer, ''/Customer/Telephone[1]/@PhoneNumber'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') br_telefona,
                SUBSTR(ExtractValue(t.customer, ''/Customer/Address[1]/AddressLine'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 40) address,
                SUBSTR(ExtractValue(t.customer, ''/Customer/Address[1]/PostalCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 8) zipCode,
                ExtractValue(t.customer, ''/Customer/CustLoyalty[1]/@MembershipID'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') loyaltyID,
                SIGN ((-1) * INSTR(ExtractValue(t.customer, ''/Customer/@Text'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), ''Newsletter:yes'')) newsletter,
                t.iznos,
                t.valuta,
                DECODE (t.marketCode, ''CAMP'', t.stopa_popusta, NULL),
                t.napomena,
                t.izn_predujma,
                t.val_sifra3a,
                t.obrazlozenje_storna,
                t.predujam_text,
                t.predujam_vpla,
                SUBSTR(t.rez_agent, 1, 24)
           FROM (SELECT ''<HotelReservation xmlns="http://www.opentravel.org/OTA/2003/05">'' || Extract(column_value, ''/HotelReservation/RoomStays'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'').getclobval() || ''</HotelReservation>'' rooms,
                ''<HotelReservation xmlns="http://www.opentravel.org/OTA/2003/05">'' || Extract(column_value, ''/HotelReservation/Services'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'').getclobval() || ''</HotelReservation>'' services,
                ''<HotelReservation xmlns="http://www.opentravel.org/OTA/2003/05">'' || Extract(column_value, ''/HotelReservation/ResGuests'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'').getclobval() || ''</HotelReservation>'' guests,
                ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/HotelReservationIDs/HotelReservationID[1]/@ResID_Value'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') rez_sifra,
                ExtractValue(column_value, ''/HotelReservation/@ResStatus'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') status,
                ExtractValue(column_value, ''/HotelReservation/@CreatorID'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') creatorID,
                TRUNC(TO_DATE(SUBSTR(ExtractValue(column_value, ''/HotelReservation/@CreateDateTime'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 10), ''rrrr-mm-dd'')) datum_rez,
                ExtractValue(column_value, ''/HotelReservation/RoomStays/RoomStay[1]/BasicPropertyInfo/@HotelCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') so_sifra,
                ExtractValue(column_value, ''/HotelReservation/RoomStays/RoomStay[1]/RoomRates/RoomRate[1]/@RatePlanCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') cje_sifra,
                ExtractValue(column_value, ''/HotelReservation/RoomStays/RoomStay[1]/@MarketCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') marketCode,

                (SELECT MIN(ExtractValue(column_value, ''/UniqueID/@ID'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''))
                   FROM TABLE (XMLSequence (extract(column_value, ''/HotelReservation/ResGlobalInfo/Profiles/ProfileInfo/UniqueID'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))
                  WHERE ExtractValue(column_value, ''/UniqueID/@Type'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') <> ''1'') age_sifra,

                TRUNC(TO_DATE(ExtractValue(column_value, ''/HotelReservation/RoomStays/RoomStay[1]/TimeSpan/@Start'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), ''rrrr-mm-dd'')) dat_dolaska,
                TRUNC(TO_DATE(ExtractValue(column_value, ''/HotelReservation/RoomStays/RoomStay[1]/TimeSpan/@End'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), ''rrrr-mm-dd'')) dat_odlaska,
                ExtractValue(column_value, ''/HotelReservation/RoomStays/RoomStay[1]/@PromotionCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') vpro_sifra,

                (SELECT Extract(column_value, ''/ProfileInfo/Profile/Customer'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')
                  from TABLE (XMLSequence (extract(column_value, ''/HotelReservation/ResGlobalInfo/Profiles/ProfileInfo'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))
                  WHERE ExtractValue(column_value, ''/ProfileInfo/Profile/@ProfileType'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') = ''1'') customer,
                
				(SELECT SUM(TO_NUMBER(ExtractValue(column_value, ''/Total/@AmountAfterTax'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), ''9999999999999990.09''))
                   FROM TABLE (XMLSequence (extract(column_value, ''/HotelReservation/RoomStays/RoomStay/Total'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))) iznos,
                ExtractValue(column_value, ''/HotelReservation/RoomStays/RoomStay[1]/Total/@CurrencyCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') valuta,
                (SELECT SUM(TO_NUMBER (ExtractValue(column_value, ''/Discount/@Percent'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), ''990.09''))
                   FROM TABLE (XMLSequence (extract(column_value, ''/HotelReservation/RoomStays/RoomStay[1]/RoomRates/RoomRate[1]/Rates/Rate[1]/Discount'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))) stopa_popusta,
                Extract(column_value, ''/HotelReservation/ResGlobalInfo/Comments'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') napomena, 
                TO_NUMBER (ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/DepositPayments/GuaranteePayment[1]/AmountPercent/@Amount'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), ''9999999999999990.09'') izn_predujma,
                ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/DepositPayments/GuaranteePayment[1]/AmountPercent/@CurrencyCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') val_sifra3a,
                (SELECT ExtractValue(column_value, ''/Comment/Text'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')
                   FROM TABLE (XMLSequence (extract(column_value, ''/HotelReservation/ResGlobalInfo/Comments/Comment'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))
                  WHERE ExtractValue(column_value, ''/Comment/@CreatorID'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') = ''CANCELLATION_COMMENT'') obrazlozenje_storna,
                ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/DepositPayments/GuaranteePayment[1]/Description[1]/Text'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') predujam_text,
                ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/DepositPayments/GuaranteePayment[1]/AcceptedPayments/AcceptedPayment[1]/PaymentCard/@CardCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') predujam_vpla,
                (SELECT ExtractValue(column_value, ''/HotelReservationID/@ResID_SourceContext'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')
                   FROM TABLE (XMLSequence (extract(column_value, ''/HotelReservation/ResGlobalInfo/HotelReservationIDs/HotelReservationID[@ResID_Source="VOICE"]'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))) rez_agent
           FROM TABLE (XMLSequence (extract (XMLType(:xmlrez_p), ''/HotelReservation'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))) t';
    ELSE
      RETURN NULL;
    END IF;

  ELSIF vrsta_p = 'REZVSJ' THEN
  -- podaci za pojedinanu rezvsj i podskup usluga samo za tu rezvsj ako takve usluge mogu postojati

    IF vanjski_sustav_m = 'ROOMCLOUD' THEN
      RETURN
        'SELECT ''<room>'' || Extract(column_value, ''/room/dayPrice'').getclobval() || ''</room>'' dayPrice,
                ''<room>'' || NULL || ''</room>'' dobGrupe,
                DECODE (0, 1, :xmlguests, ''<room>'' || Extract(column_value, ''/room/guest'').getclobval() || ''</room>'') guest,
                DECODE (0, 1, :xmlusl, ''<room>'' || Extract(column_value, ''/room/supplement'').getclobval() || ''</room>'') supplement,
                ExtractValue(column_value, ''/room/@id'') vsj_sifra,
                NULL sj_broj,
                ExtractValue(column_value, ''/room/@rateId'') usl_sifra,
                NULL usl_person,
                ExtractValue(column_value, ''/room/@quantity'') kol_sj,
                NVL(ExtractValue(column_value, ''/room/@adults''), 0) + NVL(ExtractValue(column_value, ''/room/@children''), 0) br_osoba,
                ExtractValue(column_value, ''/room/@price'') iznos,
                ExtractValue(column_value, ''/room/@currency'') val_sifra3a,
                ExtractValue(column_value, ''/room/@status'') status,
                TRUNC(TO_DATE(ExtractValue(column_value, ''/room/@checkin''), ''rrrr-mm-dd'')) dat_dolaska,
                TRUNC(TO_DATE(ExtractValue(column_value, ''/room/@checkout''), ''rrrr-mm-dd'')) dat_odlaska,
                NULL guaranteeCode,
                NULL promotionCode
           FROM TABLE (XMLSequence (extract (XMLType(:xmlrezvsj), ''/reservation/room'')))';

    ELSIF vanjski_sustav_m = 'SIMPLEBOOKING' THEN
      RETURN
        'SELECT ''<RoomStay xmlns="http://www.opentravel.org/OTA/2003/05">'' || Extract(column_value, ''/RoomStay/RoomRates'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'').getclobval() || ''</RoomStay>'' dayPrice,
               ''<RoomStay xmlns="http://www.opentravel.org/OTA/2003/05">'' || Extract(column_value, ''/RoomStay/GuestCounts'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'').getclobval() || ''</RoomStay>'' dobGrupe,
               (SELECT ''<HotelReservation xmlns="http://www.opentravel.org/OTA/2003/05"> <ResGuests>'' ||
                        xmlagg(Extract(column_value, ''/ResGuest'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')).getclobval() ||
                        ''</ResGuests></HotelReservation>''
                  FROM TABLE (XMLSequence (extract (XMLType(:xmlguests), ''/HotelReservation/ResGuests/ResGuest'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))
                 WHERE ExtractValue(column_value, ''/ResGuest/@ResGuestRPH'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') IN
                       (SELECT ExtractValue(column_value, ''ResGuestRPH/@RPH'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')
                          FROM TABLE (XMLSequence (extract (v.column_value, ''/RoomStay/ResGuestRPHs/ResGuestRPH'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''))))) guests,
                (SELECT ''<HotelReservation xmlns="http://www.opentravel.org/OTA/2003/05"> <Services>'' ||
                        xmlagg(Extract(column_value, ''/Service'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')).getclobval() ||
                        ''</Services></HotelReservation>''
                  FROM TABLE (XMLSequence (extract (XMLType(:xmlusl), ''/HotelReservation/Services/Service'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))
                 WHERE ExtractValue(column_value, ''/Service/@ServiceRPH'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') IN
                       (SELECT ExtractValue(column_value, ''ServiceRPH/@RPH'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')
                          FROM TABLE (XMLSequence (extract (v.column_value, ''/RoomStay/ServiceRPHs/ServiceRPH'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''))))) supplement,
                ExtractValue(column_value, ''/RoomStay/RoomTypes/RoomType/@RoomTypeCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') vsj_sifra,
                NULL sj_broj,
                ExtractValue(column_value, ''/RoomStay/RatePlans/RatePlan/MealsIncluded/@MealPlanCodes'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') usl_sifra,
                NULL usl_person,
                ExtractValue(column_value, ''/RoomStay/RoomTypes/RoomType/@NumberOfUnits'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') kol_sj,
                (SELECT SUM (NVL(ExtractValue(column_value, ''/GuestCount/@Count'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 0))
                  FROM TABLE (XMLSequence (extract (v.column_value, ''/RoomStay/GuestCounts/GuestCount'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))) br_osoba,
                ExtractValue(column_value, ''/RoomStay/@price'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') iznos,
                ExtractValue(column_value, ''/RoomStay/@currency'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') val_sifra3a,
                ''4'' status,
                TRUNC(TO_DATE(ExtractValue(column_value, ''/RoomStay/@checkin'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), ''rrrr-mm-dd'')) dat_dolaska,
                TRUNC(TO_DATE(ExtractValue(column_value, ''/RoomStay/@checkout''), ''xmlns="http://www.opentravel.org/OTA/2003/05"'', ''rrrr-mm-dd'')) dat_odlaska,
                NULL guaranteeCode,
                NULL promotionCode
           FROM TABLE (XMLSequence (extract (XMLType(:xmlrezvsj), ''/HotelReservation/RoomStays/RoomStay'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''))) v';

    ELSIF vanjski_sustav_m = 'PHOBS2' THEN
      RETURN
        'SELECT ''<ns2:RoomStay xmlns:ns2="http://www.opentravel.org/OTA/2003/05">'' || Extract(column_value, ''/RoomStay/RoomRates'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'').getclobval() || ''</ns2:RoomStay>'' dayPrice,
               ''<ns2:RoomStay xmlns:ns2="http://www.opentravel.org/OTA/2003/05">'' || Extract(column_value, ''/RoomStay/GuestCounts'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'').getclobval() || ''</ns2:RoomStay>'' dobGrupe,
               (SELECT ''<ns2:HotelReservation xmlns:ns2="http://www.opentravel.org/OTA/2003/05"><ns2:ResGuests>'' ||
                        xmlagg(Extract(column_value, ''/ResGuest'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')).getclobval() ||
                        ''</ns2:ResGuests></ns2:HotelReservation>''
                  FROM TABLE (XMLSequence (extract (XMLType(:xmlguests), ''/HotelReservation/ResGuests/ResGuest'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))
                 WHERE ExtractValue(column_value, ''/ResGuest/@ResGuestRPH'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') IN
                       (SELECT ExtractValue(column_value, ''ResGuestRPH/@RPH'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')
                          FROM TABLE (XMLSequence (extract (v.column_value, ''/RoomStay/ResGuestRPHs/ResGuestRPH'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''))))) guests,
                (SELECT ''<ns2:HotelReservation xmlns:ns2="http://www.opentravel.org/OTA/2003/05"><ns2:Services>'' ||
                        xmlagg(Extract(column_value, ''/Service'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')).getclobval() ||
                        ''</ns2:Services></ns2:HotelReservation>''
                  FROM TABLE (XMLSequence (extract (XMLType(:xmlusl), ''/HotelReservation/Services/Service'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))
                 WHERE ExtractValue(column_value, ''/Service/@ServiceRPH'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') IN
                       (SELECT ExtractValue(column_value, ''ServiceRPH/@RPH'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')
                          FROM TABLE (XMLSequence (extract (v.column_value, ''/RoomStay/ServiceRPHs/ServiceRPH'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''))))) supplement,
                (SELECT MIN (ExtractValue(column_value, ''/RoomRate/@RoomTypeCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''))
                   FROM TABLE (XMLSequence (extract (v.column_value, ''/RoomStay/RoomRates/RoomRate'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))
                  WHERE (ExtractValue(column_value, ''RoomRate/@RoomTypeCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')) LIKE ''ROOM%'') vsj_sifra,
                ExtractValue(column_value, ''/RoomStay/RoomTypes/RoomType[1]/@RoomLocationCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') sj_broj,                
                NVL(ExtractValue(column_value, ''/RoomStay/RatePlans/RatePlan[1]/MealsIncluded/@MealPlanCodes'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), ''15'') usl_sifra,
                (SELECT XMLagg(XMLelement("UslPerson", ExtractValue (column_value, ''/RoomRate/@RoomTypeCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''))).getclobval()
                   FROM TABLE (XMLSequence (extract (v.column_value, ''/RoomStay/RoomRates/RoomRate'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))
                  WHERE ExtractValue(column_value, ''RoomRate/@RoomTypeCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') LIKE ''PERSON%'') usl_person,
                (SELECT MIN (ExtractValue(column_value, ''/RoomRate/@NumberOfUnits'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''))
                   FROM TABLE (XMLSequence (extract (v.column_value, ''/RoomStay/RoomRates/RoomRate'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))
                  WHERE (ExtractValue(column_value, ''RoomRate/@RoomTypeCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')) LIKE ''ROOM%'') kol_sj,
                (SELECT SUM (NVL(ExtractValue(column_value, ''/GuestCount/@Count'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 0))
                  FROM TABLE (XMLSequence (extract (v.column_value, ''/RoomStay/GuestCounts/GuestCount'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))) br_osoba,
                ExtractValue(column_value, ''/RoomStay/Total/Taxes/@Amount'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') iznos,
                NULL val_sifra3a,
                ''4'' status,
                NULL dat_dolaska,
                NULL dat_odlaska,
                ExtractValue(column_value, ''/RoomStay/Guarantee[1]/@GuaranteeCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') guaranteeCode,
                ExtractValue(column_value, ''/RoomStay/@PromotionCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') promotionCode
           FROM TABLE (XMLSequence (extract (XMLType(:xmlrezvsj), ''/HotelReservation/RoomStays/RoomStay'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''))) v';

    ELSE
      RETURN NULL;
    END IF;

  ELSIF vrsta_p = 'REZCJE' THEN
  -- podaci o cijenama smjetaja (osnovne usluge) za pojedinu rezvsj

    IF vanjski_sustav_m = 'ROOMCLOUD' THEN
      RETURN
        'SELECT TO_NUMBER(ExtractValue(column_value, ''/dayPrice/@price''), ''9999999999999990.09'') iznos,
                TRUNC(TO_DATE(ExtractValue(column_value, ''/dayPrice/@day''), ''rrrr-mm-dd'')) dat_poc,
                TRUNC(TO_DATE(ExtractValue(column_value, ''/dayPrice/@day''), ''rrrr-mm-dd'')) dat_zav,
                NULL rates,
                NULL typeCode
           FROM TABLE (XMLSequence (extract (XMLType(:xmlrezcje), ''/room/dayPrice'')))';

    ELSIF vanjski_sustav_m = 'SIMPLEBOOKING' THEN
      RETURN
        'SELECT TO_NUMBER(ExtractValue(column_value, ''/RoomRate/Rates/Rate/Total/@AmountAfterTax'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), ''9999999999999990.09'') /
                  POWER (10, TO_NUMBER(ExtractValue(column_value, ''/RoomRate/Rates/Rate/Total/@DecimalPlaces'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''))) iznos,
                TRUNC(TO_DATE(ExtractValue(column_value, ''/RoomRate/@EffectiveDate'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), ''rrrr-mm-dd'')) dat_poc,
                TRUNC(TO_DATE(ExtractValue(column_value, ''/RoomRate/@ExpireDate'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), ''rrrr-mm-dd'')) dat_zav,
                NULL rates,
                NULL typeCode
           FROM TABLE (XMLSequence (extract (XMLType(:xmlrezcje),  ''/RoomStay/RoomRates/RoomRate'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))';

    ELSIF vanjski_sustav_m = 'PHOBS2' THEN
      RETURN
        'SELECT NULL iznos,
                NULL dat_poc,
                NULL dat_zav,
                XMLelement("Rates", xmlattributes(''http://www.opentravel.org/OTA/2003/05'' "xmlns"),
                  XMLagg(Extract(column_value, ''/RoomRate/Rates/Rate'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''))).getclobval() rates,
                ExtractValue(column_value, ''/RoomRate/@RoomTypeCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') typeCode
           FROM TABLE (XMLSequence (extract (XMLType(:xmlrezcje),  ''/RoomStay/RoomRates/RoomRate'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))
          GROUP BY ExtractValue(column_value, ''/RoomRate/@RoomTypeCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''),
                   ExtractValue(column_value, ''/RoomRate/@EffectiveDate'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''),
                   ExtractValue(column_value, ''/RoomRate/@ExpireDate'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')
          ORDER BY 5 DESC'; -- zato da se prvo obrauju cijene za osnovnu uslugu, pa tek zatim uslPerson
    ELSE
      RETURN NULL;
    END IF;

  ELSIF vrsta_p = 'REZSUPP' THEN
  -- podaci o dodatnim uslugama filtrirani za pojedinu rezvsj

    IF vanjski_sustav_m = 'ROOMCLOUD' THEN
      RETURN
        'SELECT ExtractValue(column_value, ''/supplement/@supplementId'') usl_sifra,
                TO_NUMBER(ExtractValue(column_value, ''/supplement/@price''), ''9999999999999990.09'') iznos,
                ExtractValue(column_value, ''/supplement/@type'') tip,
                ExtractValue(column_value, ''/supplement/@number'') kol,
                ExtractValue(column_value, ''/supplement/@persons'') br_osoba,
                NULL inclusive
           FROM TABLE (XMLSequence (extract (XMLType(:xmlrezsupp), ''/room/supplement'')))';

    ELSIF vanjski_sustav_m = 'SIMPLEBOOKING' THEN
      RETURN
        'SELECT ExtractValue(column_value, ''Service/@ServiceInventoryCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') usl_sifra,
                TO_NUMBER(ExtractValue(column_value, ''/Service/Price/Total/@AmountAfterTax'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), ''9999999999999990.09'') /
                  POWER (10, TO_NUMBER(ExtractValue(column_value, ''/Service/Price/Total/@DecimalPlaces'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''))) iznos,
                ExtractValue(column_value, ''/Service/@ServicePricingType'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') tip,
                1 kol, -- ExtractValue(column_value, ''/Service/@Quantity'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') kol,
                ExtractValue(column_value, ''/Service/@Quantity'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') br_osoba,
                NULL inclusive
           FROM TABLE (XMLSequence (extract (XMLType(:xmlrezsupp), ''/HotelReservation/Services/Service'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))';
    
    ELSIF vanjski_sustav_m = 'PHOBS2' THEN
      RETURN
        'SELECT ExtractValue(column_value, ''Service/@ServiceInventoryCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') usl_sifra,
                TO_NUMBER(ExtractValue(column_value, ''/Service/Price/Total/@AmountBeforeTax'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), ''9999999999999990.09'') iznos,
                ExtractValue(column_value, ''/Service/@ServicePricingType'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') tip,
                ExtractValue(column_value, ''/Service/@Quantity'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') kol,
                ExtractValue(column_value, ''/Service/@Quantity'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') br_osoba,
                ExtractValue(column_value, ''/Service/@Inclusive'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') inclusive
           FROM TABLE (XMLSequence (extract (XMLType(:xmlrezsupp), ''/HotelReservation/Services/Service'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))';
    
    ELSE
      RETURN NULL;
    END IF;

  ELSIF vrsta_p = 'REZGOST' THEN
  -- ime, prezime i ostali osobni podaci gostiju za pojedinu rezvsj ako su poslani

    IF vanjski_sustav_m = 'ROOMCLOUD' THEN
      RETURN
        'SELECT NULL titula,
                SUBSTR(ExtractValue(column_value, ''/guest/@firstName''), 1, 20) ime,
                SUBSTR(ExtractValue(column_value, ''/guest/@secondName''), 1, 20) prezime,
                NULL dat_rodjenja,
                NULL reg_vozila
           FROM TABLE (XMLSequence (extract (XMLType(:xmlrezgost), ''/room/guest'')))';

    ELSIF vanjski_sustav_m = 'SIMPLEBOOKING' THEN
      RETURN
        'SELECT NULL titula,
                SUBSTR(ExtractValue(column_value, ''/ResGuest/Profiles/ProfileInfo/Profile/Customer/PersonName/GivenName'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 20) ime,
                SUBSTR(ExtractValue(column_value, ''/ResGuest/Profiles/ProfileInfo/Profile/Customer/PersonName/Surname'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 20) prezime,
                NULL dat_rodjenja,
                NULL reg_vozila
           FROM TABLE (XMLSequence (extract (XMLType(:xmlrezgost), ''/HotelReservation/ResGuests/ResGuest'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))';

    ELSIF vanjski_sustav_m = 'PHOBS2' THEN
      RETURN
        'SELECT SUBSTR(ExtractValue(column_value, ''/ResGuest/Profiles/ProfileInfo/Profile/Customer/PersonName/NamePrefix[1]'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 20) titula,
                SUBSTR(ExtractValue(column_value, ''/ResGuest/Profiles/ProfileInfo/Profile/Customer/PersonName/GivenName'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 20) ime,
                SUBSTR(ExtractValue(column_value, ''/ResGuest/Profiles/ProfileInfo/Profile/Customer/PersonName/Surname'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 20) prezime,
                TO_DATE(ExtractValue(column_value, ''/ResGuest/Profiles/ProfileInfo/Profile/Customer/@BirthDate'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), ''rrrr-mm-dd'') dat_rodjenja,
                SUBSTR(ExtractValue(column_value, ''/ResGuest/ArrivalTransport/TransportInfo/@ID'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 20) reg_vozila
           FROM TABLE (XMLSequence (extract (XMLType(:xmlrezgost), ''/HotelReservation/ResGuests/ResGuest'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))
          ORDER BY TO_NUMBER(ExtractValue(column_value, ''/ResGuest/@ResGuestRPH'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')) DESC';

    ELSE
      RETURN NULL;
    END IF;

  ELSIF vrsta_p = 'DOBNEGRUPE' THEN
  -- broj gostiju prema dobi za pojedinu rezvsj

    IF vanjski_sustav_m = 'ROOMCLOUD' THEN
      RETURN
        'SELECT NULL,
                NULL
           FROM TABLE (XMLSequence (extract (XMLType(:xmldobGrupe), ''/'')))
          WHERE 0 = 1';

    ELSIF vanjski_sustav_m = 'SIMPLEBOOKING' THEN
      RETURN
        'SELECT ExtractValue(column_value, ''/GuestCount/@Age'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') dob,
                ExtractValue(column_value, ''/GuestCount/@Count'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') br_osoba
           FROM TABLE (XMLSequence (extract (XMLType(:xmldobGrupe), ''/RoomStay/GuestCounts/GuestCount'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))';
    
    ELSIF vanjski_sustav_m = 'PHOBS2' THEN
      RETURN
        'SELECT ExtractValue(column_value, ''/GuestCount/@Age'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') dob,
                ExtractValue(column_value, ''/GuestCount/@Count'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') br_osoba
           FROM TABLE (XMLSequence (extract (XMLType(:xmldobGrupe), ''/RoomStay/GuestCounts/GuestCount'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))
          ORDER BY TO_NUMBER(NVL(ExtractValue(column_value, ''/GuestCount/@Age'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), ''150''))';
    
    ELSE
      RETURN NULL;
    END IF;

  ELSIF vrsta_p = 'SINGLEXML' THEN
  -- obrada pripremljenog xml-a, string NIJE isti kao u 'OBRADI'

    IF vanjski_sustav_m = 'ROOMCLOUD' THEN
      RETURN
        'SELECT Extract(column_value, ''/reservation'').getclobval() rez,
                ExtractValue(column_value, ''/reservation/@id'') rez_sifra,
                NULL PMSConfirmationID,
                NULL rez_sifra_mapa,
                NULL sj_broj_mapa,
                NULL creatorID,
                NULL so_sifra
           FROM TABLE (XMLSequence (extract (XMLType (:odgovor), ''/reservation'')))';

    ELSIF vanjski_sustav_m = 'SIMPLEBOOKING' THEN
      RETURN
        'SELECT Extract(column_value, ''/HotelReservation'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'').getclobval() rez,
                ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/HotelReservationIDs/HotelReservationID/@ResID_Value'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') rez_sifra,
                NULL PMSConfirmationID,
                NULL rez_sifra_mapa,
                NULL sj_broj_mapa,
                NULL creatorID,
                NULL so_sifra
           FROM TABLE (XMLSequence (extract (XMLType (:odgovor), ''/HotelReservation'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))';

    ELSIF vanjski_sustav_m = 'PHOBS2' THEN
      RETURN
        'SELECT Extract(column_value, ''/HotelReservation'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'').getclobval() rez,
                ExtractValue(column_value, ''/HotelReservation/ResGlobalInfo/HotelReservationIDs/HotelReservationID[1]/@ResID_Value'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') rez_sifra,
                ExtractValue(column_value, ''/HotelReservation/UniqueID/@PMSConfirmationID'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') PMSConfirmationID,
                SUBSTR (ExtractValue(column_value, ''/HotelReservation/RoomStays/RoomStay[1]/RoomTypes/RoomType[1]/@RoomTypeCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 32) rez_sifra_mapa,
                SUBSTR (ExtractValue(column_value, ''/HotelReservation/RoomStays/RoomStay[1]/RoomTypes/RoomType[1]/@RoomLocationCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''), 1, 10) sj_broj_mapa,
                ExtractValue(column_value, ''/HotelReservation/@CreatorID'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') creatorID,
                ExtractValue(column_value, ''/HotelReservation/RoomStays/RoomStay[1]/BasicPropertyInfo/@HotelCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') so_sifra
           FROM TABLE (XMLSequence (extract (XMLType (:xml), ''/HotelReservation'', ''xmlns="http://www.opentravel.org/OTA/2003/05'')))';

    ELSE
      RETURN NULL;
    END IF;

  ELSIF vrsta_p = 'RESPONSE' THEN
  -- odgovor kao potvrda primitka rezervacije

    IF vanjski_sustav_m = 'ROOMCLOUD' THEN
      RETURN NULL;

    ELSIF vanjski_sustav_m = 'SIMPLEBOOKING' THEN
      RETURN
        'SELECT
           ''<?xml version="1.0" encoding="UTF-8" ?>'' ||
           XMLSERIALIZE(DOCUMENT
             XMLELEMENT("OTA_HotelResNotifRS",
               XMLATTRIBUTES(
                 ''http://www.w3.org/2001/XMLSchema-instance'' AS "xmlns:xsi",
                 ''http://www.opentravel.org/OTA/2003/05'' AS "xmlns",
                 ''http://www.opentravel.org/OTA/2003/05 OTA_HotelResNotifRS.xsd'' AS "xsi:schemaLocation",
                 ''TIMESTAMP'' AS "TimeStamp",
                 ''Production'' AS "Target",
                 ''2.001'' AS "Version"
               ),
               XMLELEMENT("Success"),
                 XMLELEMENT("HotelReservations",
                   XMLELEMENT("HotelReservation",
                     XMLELEMENT("ResGlobalInfo",
                       XMLELEMENT("HotelReservationIDs",
                         XMLAGG(
                           XMLELEMENT("HotelReservationID",
                             XMLATTRIBUTES(p.OPIS1 AS "ResID_Value")
                           )
                         )
                       )
                     )
                   )
                 ),
                 XMLELEMENT("TPA_Extensions",
                   XMLELEMENT("provider",
                     XMLATTRIBUTES(''XMlw23!.33'' AS "Name", ''LxlR25.12'' AS "Pwd")
                   ),
                   XMLELEMENT("XMLHotelAgent",
                     XMLATTRIBUTES(''USER'' AS "Name", ''PASS'' AS "Pwd")
                   )
                 )
               )
             ) AS CLOB
            FROM prec_global p'; -- IRN 3881     
         
    ELSIF vanjski_sustav_m = 'PHOBS2' THEN  
      RETURN   
        'SELECT
           ''<?xml version="1.0" encoding="UTF-8"?>'' ||
           XMLSERIALIZE(DOCUMENT
             XMLELEMENT("SOAP-ENV:Envelope",
               XMLATTRIBUTES(
                 ''http://schemas.xmlsoap.org/soap/envelope/'' AS "xmlns:SOAP-ENV",
                 ''http://www.opentravel.org/OTA/2003/05'' AS "xmlns:ns1",
                 ''http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd'' AS "xmlns:ns2",
                 ''http://www.w3.org/2001/XMLSchema-instance'' AS "xmlns:xsi"
               ),
               XMLELEMENT("SOAP-ENV:Header",
                 XMLELEMENT("ns2:Security",
                   XMLELEMENT("ns2:UsernameToken",
                     XMLELEMENT("ns2:Username", ''USER''),
                       XMLELEMENT("ns2:Password",
                         XMLATTRIBUTES (''ns2:http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText'' AS "xsi:type"),''PASS'')
                   )
                 )
               ),
               XMLELEMENT("SOAP-ENV:Body",
                 XMLELEMENT("ns1:OTA_HotelResNotifRS",
                   XMLATTRIBUTES(
                     ''Commited'' AS "ResResponseType",
                     ''PHOBSc80d8411950633ef9a4f49214361d75b'' AS "EchoToken",
                     ''TIMESTAMP'' AS "TimeStamp",
                     ''1.006'' AS "Version"),
                     XMLELEMENT("ns1:Success"),
                       XMLELEMENT("ns1:HotelReservations",
                         XMLAGG(
                           XMLELEMENT("ns1:HotelReservation",
                             XMLELEMENT("ns1:UniqueID",
                               XMLATTRIBUTES(''14'' AS "Type", p.OPIS1 AS "ID")
                             ),
                             XMLELEMENT("ns1:ResGlobalInfo",
                               XMLELEMENT("ns1:HotelReservationIDs",
                                 XMLELEMENT("ns1:HotelReservationID",
                                   XMLATTRIBUTES(''10'' AS "ResID_Type", p.OPIS3 AS "ResID_Value", p.OPIS2 AS "PMSConfirmationID", ''true'' AS "ForGuest")
                                 )
                               )
                             )
                           )
                         )
                       )
                     )
                   )
                 ) AS CLOB
               )
           FROM prec_global p'; -- IRN 3881
   
    ELSE
      RETURN NULL;
    END IF;

  ELSE
    RETURN NULL;
  END IF;

END;
PROCEDURE DOHVATI_REZERVACIJE
 (SO_ID_P IN NUMBER := NULL
 ,SAMO_IZMIJENJENE_P IN NUMBER := -1
 ,DAT_POC_P IN DATE := NULL
 ,DAT_ZAV_P IN DATE := NULL
 ,DEBUG_P IN NUMBER := 0
 )
 IS
--
BEGIN

  IF vanjski_sustav_m = 'ROOMCLOUD' AND pra_zmp_s.oznaka ('P0038') = -1 OR
    vanjski_sustav_m = 'SIMPLEBOOKING' AND pra_zmp_s.oznaka ('P0039') = -1 OR
    vanjski_sustav_m = 'PHOBS2' AND pra_zmp_s.oznaka ('P0043') = -1
  THEN
    NULL;
  ELSE
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  FOR so_c IN (
    SELECT sifra, so_id
      FROM mrec_so_sus
     WHERE zmpsus_id = (SELECT id
                          FROM szmp_sustavi
                         WHERE sifra = vanjski_sustav_m)
       AND so_id = NVL(so_id_p, so_id)
       AND vanjski_sustav_m IN ('ROOMCLOUD', 'SIMPLEBOOKING')
     UNION
    SELECT NULL, so_id
      FROM mrec_auth_sus
     WHERE zmpsus_id = (SELECT id
                          FROM szmp_sustavi
                         WHERE sifra = vanjski_sustav_m)
       AND so_id_p IS NULL  -- ne moe se dobiti rezervacije SAMO ZA odreeni SO
       AND vanjski_sustav_m  = 'PHOBS2')
  LOOP
    -- dbms_output.put_line ('DOHVATI_REZERVACIJE za  so_c.sifra '  || so_c.sifra  || ', so_c.so_id '  || so_c.so_id);      
    sosus_sifra_za_subj_m := so_c.sifra;  -- za SB i RC se ovdje puni sosus_sifra, za PHOBS e se nakon itanja xml-a u unesi_rez
    azuriraj_rez_za_so (so_c.sifra, so_c.so_id, samo_izmijenjene_p, dat_poc_p, dat_zav_p, debug_p);
  END LOOP;
END;
PROCEDURE AZURIRAJ_REZ_ZA_SO
 (SIFRA_P IN MREC_SO_SUS.SIFRA%TYPE
 ,SO_ID_P IN MREC_SO_SUS.SO_ID%TYPE
 ,SAMO_IZMIJENJENE_P IN NUMBER := -1
 ,DAT_POC_P IN DATE := NULL
 ,DAT_ZAV_P IN DATE := NULL
 ,DEBUG_P IN NUMBER := 0
 )
 IS
--
  request_l CLOB := rezvanjsus_string ('REQUEST');

  CURSOR params_c IS
    SELECT sus_username, sus_password
      FROM mrec_auth_sus
     WHERE zmpsus_id = (SELECT id
                          FROM szmp_sustavi
                         WHERE sifra = vanjski_sustav_m)
       AND (so_id IS NULL OR
            so_id = so_id_p)
     ORDER BY so_id NULLS LAST;
  params_r_l params_c%ROWTYPE;

  url_l    VARCHAR2(50);
BEGIN

  OPEN params_c;
  FETCH params_c INTO params_r_l;
  CLOSE params_c;

  request_l := REPLACE (request_l, 'USER', params_r_l.sus_username);
  request_l := REPLACE (request_l, 'PASS', params_r_l.sus_password);
  request_l := REPLACE (request_l, '"SO"', '"' || sifra_p || '"');

  request_l := REPLACE (request_l, '"TIMESTAMP"', '"' || TO_CHAR(SYSDATE, 'rrrr-mm-dd') || 'T' || TO_CHAR(SYSDATE, 'hh24:mi:ss') || '"');

  -- IF samo_izmijenjene_p = -1 THEN
  --   request_l := REPLACE (request_l, '"FILTERTYPE"', '"New"');
  -- ELSE
    request_l := REPLACE (request_l, '"FILTERTYPE"', '"All"');
  -- END IF;

  IF samo_izmijenjene_p = -1 THEN
    request_l := REPLACE (request_l, '"BOOLEAN"', '"true"');
  ELSE
    request_l := REPLACE (request_l, '"BOOLEAN"', '"false"');
  END IF;

  IF dat_poc_p IS NOT NULL THEN
    request_l := REPLACE (request_l, 'startDate=""', 'startDate="' || TO_CHAR(dat_poc_p, 'rrrr-mm-dd') || '"');
    request_l := REPLACE (request_l, 'Start=""', 'Start="' || TO_CHAR(dat_poc_p, 'rrrr-mm-dd') || '"');
  ELSE
    request_l := REPLACE (request_l, 'startDate=""', '');
    IF vanjski_sustav_m = 'SIMPLEBOOKING' THEN     -- IRN 3613
      request_l := REPLACE (request_l, 'Start=""', 'Start="' || TO_CHAR(SYSDATE - pra_zmp_zaj.zmppar_vrijednost ('SIMPLEBOOKING', '1024'), 'rrrr-mm-dd') || '"');
    ELSE
      request_l := REPLACE (request_l, 'Start=""', 'Start="' || TO_CHAR(SYSDATE, 'rrrr-mm-dd') || '"');
    END IF;
  END IF;

  IF dat_zav_p IS NOT NULL THEN
    request_l := REPLACE (request_l, 'endDate=""', 'endDate="' || TO_CHAR(dat_zav_p, 'rrrr-mm-dd') || '"');
    request_l := REPLACE (request_l, 'End=""', 'End="' || TO_CHAR(dat_zav_p, 'rrrr-mm-dd') || '"');
  ELSE
    request_l := REPLACE (request_l, 'endDate=""', '');
    IF vanjski_sustav_m = 'SIMPLEBOOKING' THEN -- IRN 3949
      request_l := REPLACE (request_l, 'End=""', 'End="' || TO_CHAR(SYSDATE - pra_zmp_zaj.zmppar_vrijednost ('SIMPLEBOOKING', '1024') + 365, 'rrrr-mm-dd') || '"');
    ELSE
      request_l := REPLACE (request_l, 'End=""', 'End="' || TO_CHAR(SYSDATE + 730, 'rrrr-mm-dd') || '"');
    END IF;
  END IF;

  IF vanjski_sustav_m = 'SIMPLEBOOKING' THEN
    url_l := '/ResRQ';
  END IF;

  -- dbms_output.put_line (request_l);
  post2_rezsus (request_l, url_l);

  obradi_odgovor (so_id_p, debug_p => debug_p);

END;
PROCEDURE POST2_REZSUS
 (REQUEST_P IN CLOB
 ,URL_P IN VARCHAR2 := NULL
 )
 IS
--
  url_l szmp_parametri.vrijednost%TYPE;
  -- timeout_l NUMBER;

  logiraj_l  szmp_parametri.vrijednost%TYPE := lower(pra_zmp_zaj.zmppar_vrijednost (vanjski_sustav_m, '1007'));

  req_l UTL_HTTP.req;
  res_l UTL_HTTP.resp;
  tekst_l VARCHAR2(32767);  
  clob_l CLOB;
BEGIN

  IF vanjski_sustav_m IN ('ROOMCLOUD', 'SIMPLEBOOKING', 'PHOBS2') THEN
    url_l := pra_zmp_zaj.zmppar_vrijednost (vanjski_sustav_m, '1001') || url_p;
  ELSE
    RETURN;
  END IF;

  odgovor_m := NULL;
  data_m := request_p;

  IF logiraj_l = 'da' THEN
    pra_pka2.clob_to_table ('[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' || url_l || CHR(10), TO_CHAR(SYSDATE, 'dd-mm-rrrr'), NULL, vanjski_sustav_m);
    pra_pka2.clob_to_table (CHR(10) || data_m || CHR(10), TO_CHAR(SYSDATE, 'dd-mm-rrrr'), NULL, vanjski_sustav_m);
  END IF;
  
  UTL_HTTP.set_detailed_excp_support (enable => true); -- potrebno za UTL_HTTP.get_detailed_sqlerrm
  -- UTL_HTTP.set_transfer_timeout (timeout => timeout_l);
  UTL_HTTP.set_body_charset (charset => 'UTF-8');
  req_l := UTL_HTTP.begin_request (url => url_l, method => 'POST', http_version => 'HTTP/1.1');
  IF vanjski_sustav_m = 'SIMPLEBOOKING' THEN
    UTL_HTTP.set_header (r => req_l, name => 'Content-Type', value => 'application/x-www-form-urlencoded');
    data_m := 'xml=' || data_m;
  ELSE
    UTL_HTTP.set_header (r => req_l, name => 'Content-Type', value => 'text/xml; charset=utf-8');
  END IF;
  UTL_HTTP.set_header (req_l, 'Content-Length', pra_pka2.clob_length (data_m));
  UTL_HTTP.write_text (req_l, data_m);

  res_l := UTL_HTTP.get_response (req_l);

  DBMS_LOB.createtemporary (clob_l, FALSE);

  BEGIN
    LOOP
      -- dbms_output.put_line('loop prije read_line');
      UTL_HTTP.read_text (res_l, tekst_l, 30000);   
         -- ne ita se maksimalna duljina 32676 da ima rezerve za replace sa duljim stringom
      -- dbms_output.put_line(line_l);  
      -- IRN 03481 - ne smije se ve ovdje pretvarati escape znakove jer inae oni pokvare xml. (Pretvarati kasnije nakon uitavanja u napomenu)
      --tekst_l := REPLACE(tekst_l, chr(38) || 'lt;', '<');
      --tekst_l := REPLACE(tekst_l, chr(38) || 'gt;', '>');
      tekst_l := REPLACE(tekst_l, '<p>', '');
      tekst_l := REPLACE(tekst_l, '</p>', '');
      tekst_l := REPLACE(tekst_l, '<b>', '');
      tekst_l := REPLACE(tekst_l, '</b>', '');
      tekst_l := REPLACE(tekst_l, '''', '''''');

      IF tekst_l <> '<?xml version="1.0" encoding="UTF-8"?>' THEN
        DBMS_LOB.writeappend (clob_l, LENGTH (tekst_l), tekst_l);
      END IF;
    END LOOP;
    UTL_HTTP.end_response (res_l);
  EXCEPTION
    WHEN UTL_HTTP.end_of_body THEN
      UTL_HTTP.end_response (res_l);
  END;

  odgovor_m := clob_l;

  DBMS_LOB.FREETEMPORARY(clob_l);

  IF logiraj_l = 'da' THEN
    pra_pka2.clob_to_table (CHR(10) || odgovor_m || CHR(10), TO_CHAR(SYSDATE, 'dd-mm-rrrr'), NULL, vanjski_sustav_m);
  END IF;
  
EXCEPTION
  WHEN UTL_HTTP.transfer_timeout THEN -- IRN 2465
    NULL;
END;
PROCEDURE OBRADI_XML
 (DATA_COLUMN_P IN VARCHAR2 := 'data'
 ,TABLE_P IN VARCHAR2 := 'lpka_clob'
 ,LINK_COLUMN_P IN VARCHAR2 := 'veza'
 ,ID_P IN NUMBER
 ,SO_ID_P IN NUMBER := NULL
 ,DEBUG_P IN NUMBER := 0
 )
 IS
--
  clob_c  SYS_REFCURSOR;
  clob_l CLOB;
BEGIN             
  
  -- inicijalizacija varijable za sluaj kad se procedura poziva iz modula 
  -- neposredno nakon promjene vrijednost REC parametra 1136
  vanjski_sustav_m := UPPER(pra_zmp_zaj.zmppar_vrijednost ('REC', '1136'));
    
  OPEN clob_c FOR
    'SELECT ' || data_column_p || '
       FROM ' || table_p || '
      WHERE ' || link_column_p || ' = ' || id_p;

  FETCH clob_c INTO clob_l;
  IF clob_c%NOTFOUND OR dbms_lob.getlength (clob_l) = 0 THEN
   CLOSE clob_c;
    RETURN;
  END IF;
  CLOSE clob_c;

  IF vanjski_sustav_m = 'PHOBS2' AND dbms_lob.instr (clob_l, 'ns2:') = 0 THEN
    clob_l := REPLACEINCLOB (REPLACEINCLOB (REPLACEINCLOB (clob_l, '<', '<ns2:'), '<ns2:/', '</ns2:'), '<ns2:HotelReservation ', '<ns2:HotelReservation xmlns:ns2="http://www.opentravel.org/OTA/2003/05" ');
    EXECUTE IMMEDIATE
      'UPDATE ' || table_p || '
          SET ' || data_column_p || ' = :clob 
        WHERE ' || link_column_p || ' = ' || id_p
      USING clob_l;
    COMMIT;
  END IF;
  obradi_odgovor (so_id_p, clob_l, debug_p);
END;
PROCEDURE OBRADI_ODGOVOR
 (SO_ID_P IN M_SO.ID%TYPE
 ,XML_P IN CLOB := NULL
 ,DEBUG_P IN NUMBER := 0
 )
 IS
--
  email_ok_l   szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.zmppar_vrijednost (vanjski_sustav_m, '1003');
  email_fail_l szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.zmppar_vrijednost (vanjski_sustav_m, '1004');
  subject_l    szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.zmppar_vrijednost (vanjski_sustav_m, '1005');
  sender_l     szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0905'); -- noreply

  rezdata_c    SYS_REFCURSOR;

  rezxml_l         CLOB;
  rez_sifra_l      lsynxis_rezervacije.synxis_sifra%TYPE;
  confirm_id_l     VARCHAR2(50);   
  rbr_string_l     VARCHAR2 (20);
  rez_sifra_mapa_l VARCHAR2 (32); --lsynxis_rezervacije.id
  sj_broj_mapa_l   m_sj.broj%TYPE;
  poruka_sj_mapa_l VARCHAR2(50);
  creator_id_l     lsynxis_rezervacije.creator_id%TYPE;
  so_sifra_l       lsynxis_rezervacije.recsosus_sifra%TYPE;
BEGIN

  IF pra_zmp_zaj.centar = 0 THEN
    RETURN;
  END IF;

  IF debug_p = -1 THEN
    RETURN;
  END IF;

/*
<?xml version="1.0" encoding="utf-8" ?>
<OTA_HotelResNotifRQ xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xmlns="http://www.opentravel.org/OTA/2003/05"
xsi:schemaLocation="http://www.opentravel.org/OTA/2003/05 OTA_HotelResNotifRQ.xsd"
TimeStamp="2009-02-20T16:46:53" Target="Production" Version="1.005">
  <TPA_Extensions />
</OTA_HotelResNotifRQ>

<?xml version="1.0" encoding="utf-8" ?>
<OTA_HotelResNotifRQ xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xmlns="http://www.opentravel.org/OTA/2003/05"
xsi:schemaLocation="http://www.opentravel.org/OTA/2003/05 OTA_HotelResNotifRQ.xsd"
TimeStamp="2009-02-20T16:46:53" Target="Production" Version="1.005">
  <TPA_Extensions >
    <Errors>
      <Error Type="169" ShortText="Logged Hotel user is not granted to manipulate the hotel 333" Code="6" Status="NotProcessed" />
    </Errors>
  </TPA_Extensions >
</OTA_HotelResNotifRQ>
*/
  IF NVL(subject_l, 'nebitno') <> 'nebitno' THEN
    subject_l := subject_l || ' ';
  ELSE
    subject_l := SYS_CONTEXT ('USERENV', 'CURRENT_SCHEMA') || ' - ' || vanjski_sustav_m || '; ';
  END IF;

  IF xml_p IS NOT NULL THEN
    OPEN rezdata_c FOR rezvanjsus_string ('SINGLEXML')  USING xml_p;
    -- dbms_output.put_line ('Obradi_odgovor SINGLEXML');
  ELSE
    OPEN rezdata_c FOR rezvanjsus_string ('OBRADI') USING odgovor_m;
    -- dbms_output.put_line ('Obradi_odgovor OBRADI');    
  END IF;
  
  DELETE FROM PREC_GLOBAL; -- IRN 3881
  COMMIT; -- IRN 3949

  FETCH rezdata_c INTO rezxml_l, rez_sifra_l, confirm_id_l, rez_sifra_mapa_l, sj_broj_mapa_l, creator_id_l, so_sifra_l;
  WHILE rezdata_c%FOUND LOOP
    poruka_m := NULL;
    poruka_sj_m := NULL; -- IRN 3372
    poruka_sj_mapa_l := NULL; -- IRN 3613
    ozn_rezervacija_mapa_m := 0;
    automatski_upis_sj_g := -1; -- IRN 4085
    subject_m := NULL; -- IRN 4085
    poruka_m_dodatno := NULL; -- IRN 4085
    IF rez_sifra_mapa_l IS NOT NULL AND sj_broj_mapa_l IS NOT NULL AND creator_id_l != 'VOICE' THEN -- IRN 4085
      ozn_rezervacija_mapa_m := -1;
    END IF;
    -- dbms_output.put_line ('Obradi_odgovor za rez_sifra_l = '  || rez_sifra_l);
    
    BEGIN

      -- IRN 3613 - ako je rez_sifra_mapa_l <> null onda najprije aurirati rezervaciju sa rez_sifra_l 
      IF rez_sifra_mapa_l IS NOT NULL THEN
        povezi_rezervaciju_mapa
          (rez_sifra_l,
           creator_id_l,
           so_sifra_l,
           rez_sifra_mapa_l,
           poruka_sj_mapa_l
          );
      END IF;
      IF poruka_sj_mapa_l IS NOT NULL THEN
        poruka_sj_mapa_l := poruka_sj_mapa_l || '-' || sj_broj_mapa_l;             
      END IF;

      rezxml_l := pra_pka2.pretty_print_xml(rezxml_l);

      unesi_rez (so_id_p, rezxml_l, poruka_sj_mapa_l, rbr_string_l);
      
      zapamti_rez_za_odg (rez_sifra_l, confirm_id_l, rbr_string_l); -- IRN 3881

      COMMIT;  
      IF poruka_m IS NOT NULL THEN
        poruka_m := poruka_m || chr(10);
      END IF;
      poruka_m := poruka_m || 'Rezervacija ' || rez_sifra_l || ' je uitana.';
      -- informacija o rezervaciji preko mape koja se nije aurirala (ve se upisala nova bez SJ)
      IF poruka_sj_mapa_l IS NOT NULL THEN
        poruka_m := poruka_m || chr(10) || poruka_sj_mapa_l;
      END IF;
      
      -- odgovori_rezvanjsus (rez_sifra_l, so_id_p, confirm_id_l, rbr_string_l); -- IRN 3881

      arhiviraj_xml ('R-' || rez_sifra_l, rezxml_l, SUBSTR(TRIM(REPLACE(REPLACE(REPLACE(poruka_m, CHR(13)||CHR(10), ' '),CHR(13), ' '),CHR(10), ' ')), 1, 2000)); -- IRN 4085
      
      BEGIN -- IRN 4085
        IF UPPER(email_ok_l) <> 'NEBITNO' THEN
          -- alji mail potvrde
          pra_pka2.salji_html_email (
            recipient_p   => email_ok_l,
            recipient_h_p => NULL, -- naziv primatelja
            sender_p      => sender_l, --noreply
            sender_h_p    => NULL, -- naziv poiljatelja
            bcc_p         => NULL,
            subject_p     => subject_l || sosus_sifra_za_subj_m || ' rezervacija ' || rez_sifra_l || ' je uspjeno uitana' || subject_m, -- IRN 4085
            text_p        => poruka_m || chr(10) || chr(10) || poruka_m_dodatno || chr(10) || chr(10) || SUBSTR(rezxml_l, 1, 32500)); -- IRN 4085
        END IF;
      EXCEPTION WHEN OTHERS THEN 
        pra_pka2.clob_to_table (
          '[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' || rez_sifra_l || CHR(10) || SQLERRM  || CHR(10),
          TO_CHAR (SYSDATE, 'dd-mm-rrrr'),
          NULL,
          vanjski_sustav_m);
      END;       
      
    EXCEPTION

      WHEN OTHERS THEN
        
        ROLLBACK;   
        
        IF poruka_m IS NOT NULL THEN
          poruka_m := poruka_m  || chr(10) ;
        END IF;
        -- informacija o rezervaciji preko mape koja se nije aurirala (ve se probala upisati nova bez SJ)
        IF poruka_sj_mapa_l IS NOT NULL THEN
          poruka_m := poruka_m || poruka_sj_mapa_l || ' ' || chr(10);
        END IF;
        
        arhiviraj_xml ('G-' || rez_sifra_l, rezxml_l, poruka_m || SQLERRM);
        
        BEGIN -- IRN 4085
          -- alji mail greke
          IF UPPER(email_fail_l) <> 'NEBITNO' THEN -- IRN 3372
            pra_pka2.salji_html_email (
              recipient_p   => email_fail_l,
              recipient_h_p => NULL, -- naziv primatelja
              sender_p      => sender_l, --noreply
              sender_h_p    => NULL, -- naziv poiljatelja
              bcc_p         => NULL,
              subject_p     => subject_l || sosus_sifra_za_subj_m || ' Greka kod upisa rezervacije ' || rez_sifra_l,
              text_p        => poruka_m || chr(10) || SQLERRM || chr(10) || chr(10) || SUBSTR(rezxml_l, 1, 32500));
          END IF;
        EXCEPTION WHEN OTHERS THEN 
          pra_pka2.clob_to_table (
            '[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' || rez_sifra_l || CHR(10) || SQLERRM  || CHR(10),
            TO_CHAR (SYSDATE, 'dd-mm-rrrr'),
            NULL,
            vanjski_sustav_m);
        END;
    END;

    FETCH rezdata_c INTO rezxml_l, rez_sifra_l, confirm_id_l, rez_sifra_mapa_l, sj_broj_mapa_l, creator_id_l, so_sifra_l;
  END LOOP;

  CLOSE rezdata_c;
  
  odgovori_rezvanjsus (rez_sifra_l, so_id_p, confirm_id_l, rbr_string_l); -- IRN 3881

END;
PROCEDURE ODGOVORI_REZVANJSUS
 (REZ_SIFRA_P IN VARCHAR2
 ,SO_ID_P IN M_SO.ID%TYPE
 ,CONFIRM_ID_P IN VARCHAR2
 ,RBR_STRING_P IN VARCHAR2
 )
 IS
--
  response_l CLOB; -- IRN 3881
  sql_l  VARCHAR2(4000) := rezvanjsus_string ('RESPONSE'); -- IRN 3881

  CURSOR params_c IS
    SELECT sus_username, sus_password
      FROM mrec_auth_sus
     WHERE zmpsus_id = (SELECT id
                          FROM szmp_sustavi
                         WHERE sifra = vanjski_sustav_m)
       AND (so_id IS NULL OR
            so_id = so_id_p)
     ORDER BY so_id NULLS LAST;
  params_r_l params_c%ROWTYPE;
BEGIN
/*
<OTA_HotelResNotifRS xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xmlns="http://www.opentravel.org/OTA/2003/05"
xsi:schemaLocation="http://www.opentravel.org/OTA/2003/05 OTA_HotelResNotifRS.xsd"
TimeStamp="2008-11-14T09:42:26" Target="Production" Version="2.001">
  <Success />
  <HotelReservations>
    <HotelReservation>
      <ResGlobalInfo>
        <HotelReservationIDs>
Starts the sequence [1..N] of nodes HotelReservationID...
          <HotelReservationID ResID_Value="[Reservation code previously received]" />
        </HotelReservationIDs>
      </ResGlobalInfo>
    </HotelReservation>
  </HotelReservations>
  <TPA_Extensions>Authentication (see 1.5)</TPA_Extensions>
</OTA_HotelResNotifRS>
*/
  IF vanjski_sustav_m NOT IN ('SIMPLEBOOKING', 'PHOBS2') THEN
    RETURN;
  END IF;

  OPEN params_c;
  FETCH params_c INTO params_r_l;
  CLOSE params_c;      
  
  EXECUTE IMMEDIATE sql_l INTO response_l; -- IRN 3881

  -- response_l := REPLACE (response_l, '"RESIDVALUE"', '"' || rez_sifra_p || '"');-- IRN 3881
  response_l := REPLACE (response_l, 'USER', params_r_l.sus_username);
  response_l := REPLACE (response_l, 'PASS', params_r_l.sus_password);

  response_l := REPLACE (response_l, '"TIMESTAMP"', '"' || TO_CHAR(SYSDATE, 'rrrr-mm-dd') || 'T' || TO_CHAR(SYSDATE, 'hh24:mi:ss') || '"');

  -- response_l := REPLACE (response_l, 'RBRGOD', rbr_string_p);-- IRN 3881
  -- response_l := REPLACE (response_l, 'PMSCONFIRMID', confirm_id_p);-- IRN 3881

  post2_rezsus (response_l, '/ResRS');
  
  DELETE FROM PREC_GLOBAL; -- IRN 3881
  COMMIT; -- IRN 3949

END;
PROCEDURE UNESI_REZ
 (SO_ID_P IN M_SO.ID%TYPE
 ,XMLREZ_P IN CLOB
 ,PORUKA_SJ_MAPA_P IN VARCHAR2
 ,RBR_STRING_P OUT VARCHAR2
 )
 IS
--
  sifranik EXCEPTION;

  rezxml_l CLOB;

  rezdata_c SYS_REFCURSOR;
  TYPE rezdata_r IS RECORD (
      rooms         CLOB,
      services      CLOB,
      guests        CLOB,
      rez_sifra     lsynxis_rezervacije.synxis_sifra%TYPE,
      status        VARCHAR2(20),
      creatorID     lsynxis_rezervacije.creator_id%TYPE,
      datum_rez     DATE,
      so_sifra      mrec_so_sus.sifra%TYPE,
	  cje_sifra     trec_cje_sus.sifra%TYPE,
      marketCode    VARCHAR2(20),
      age_sifra     mrec_age_sus.sifra%TYPE,
      dat_dolaska   DATE,
      dat_odlaska   DATE,
      vpro_sifra    mrec_vpro_sus.sifra%TYPE,
      titula        t_rezervacije.titula%TYPE,
      ime           t_rezervacije.ime%TYPE,
      prezime       t_rezervacije.prezime%TYPE,
      naz_mjesta    t_rezervacije.naz_mjesta%TYPE,
      zem_sifra2a   s_zemlje.sifra_2a%TYPE,
      email         t_rezervacije.email%TYPE,
      br_telefona   t_rezervacije.br_telefona%TYPE,
      address       t_rezervacije.naz_ulice%TYPE,
      zipCode       m_poste.broj%TYPE,
      loyaltyID     VARCHAR2(30),
	  newsletter    NUMBER(3),
	  iznos         VARCHAR2(20),-- t_racuni.iznos%TYPE,
      valuta        s_valute.sifra_3a%TYPE,
      stopa_popusta VARCHAR2(5),
	  napomena      VARCHAR2(4000), --t_rezervacije.napomena2%TYPE, -- irn 3491
      izn_predujma  t_racuni.iznos%TYPE,
      val_sifra3a   s_valute.sifra_3a%TYPE,
      obrazlozenje_storna  t_rezervacije.napomena2%TYPE,
      predujam_text VARCHAR2(200),
      predujam_vpla VARCHAR2(20),
      rez_agent     t_rezervacije.unos_korisnik%TYPE); -- IRN 3936
  rezdata_l rezdata_r;

  CURSOR so_c (sifra_k mrec_so_sus.sifra%TYPE) IS
    SELECT so_id
      FROM mrec_so_sus
     WHERE sifra = sifra_k
       AND zmpsus_id = (SELECT id
                          FROM szmp_sustavi
                         WHERE sifra = vanjski_sustav_m);
  so_id_l m_so.id%TYPE;

  CURSOR zem_c (sifra2a_k s_zemlje.sifra_2a%TYPE) IS
    SELECT id
      FROM s_zemlje
     WHERE sifra_2a = sifra2a_k;
  zem_id_l s_zemlje.id%TYPE;

  CURSOR cje_c (sifra_k trec_cje_sus.sifra%TYPE) IS
    SELECT cje_id
      FROM trec_cje_sus
     WHERE sifra = sifra_k
       AND zmpsus_id = (SELECT id
                          FROM szmp_sustavi
                         WHERE sifra = vanjski_sustav_m);
  cje_id_l t_cjenici.id%TYPE;
  
  -- IRN 3949
  CURSOR cje1_c (sifra_k t_cjenici.sifra%TYPE) IS
    SELECT id
      FROM t_cjenici
     WHERE sifra = sifra_k
       AND dat_ponisten IS NULL;                        
  cje_sifra_l t_cjenici.sifra%TYPE;   

  CURSOR recvpro_c (sifra_k mrec_vpro_sus.sifra%TYPE) IS
    SELECT recvpro_id
      FROM mrec_vpro_sus
     WHERE sifra = sifra_k
       AND zmpsus_id = (SELECT id
                          FROM szmp_sustavi
                         WHERE sifra = vanjski_sustav_m);
  recvpro_id_l mrec_vpro_sus.id%TYPE;

  CURSOR recnrez_c IS
    SELECT id
      FROM mrec_nrezerviranja
     WHERE sifra = pra_zmp_zaj.zmppar_vrijednost ('PHOBS2', '1002');
  recnrez_id_l mrec_nrezerviranja.id%TYPE;

  CURSOR val_c (sifra3a_k s_valute.sifra_3a%TYPE) IS
    SELECT id
      FROM s_valute
     WHERE sifra_3a = sifra3a_k;
  val_id_l s_valute.id%TYPE;
  valR_id_l s_valute.id%TYPE;

  CURSOR vpla_c (sifra_k mzmp_vpla_sus.sifra%TYPE) IS
    SELECT vpla_id
      FROM mzmp_vpla_sus
     WHERE sifra = sifra_k
       AND zmpsus_id = (SELECT id
                          FROM szmp_sustavi
                         WHERE sifra = vanjski_sustav_m);
  vpla_id_l mzmp_vpla_sus.vpla_id%TYPE;

  izn_predujma_l   t_rezervacije.izn_predujma%TYPE;

  rez_id_l         t_rezervacije.id%TYPE;
  rez_rbr_l        t_rezervacije.rbr%TYPE;
  rez_god_l        t_rezervacije.god_poslovna%TYPE;

  provjera_l       NUMBER(1);

  fiksnaRez_l      NUMBER(2) := -1;
  posebanCjeBP_l   NUMBER(2);

  napomena_c       SYS_REFCURSOR;
  nap_part_l       CLOB; -- IRN 4085
  nap_part2_l      CLOB; -- IRN 4085
  napomena_l       VARCHAR2(4000); --t_rezervacije.napomena2%TYPE -- irn 3491
  datumRez_l       t_rezervacije.datum%TYPE := TRUNC(SYSDATE);
  
  age_id_l         m_agencije.id%TYPE;
  ms_id_l          m_msegmenti.id%TYPE;
  
  predujam_val_l   VARCHAR2(100);
  predujam_iznos_l VARCHAR2(100);
  predujam_tecaj_l VARCHAR2(100);

  br_osoba_c       SYS_REFCURSOR;
  br_odraslih_l    t_rezervacije.br_osoba1%TYPE;
  br_djece_l       t_rezervacije.br_osoba2%TYPE;   
  
  i                NUMBER(2) := 0;
  discount_c       SYS_REFCURSOR;
  TYPE discount_r IS RECORD (
      totalAAT        VARCHAR2(20),
      discount        CLOB,
      guaranteeCode   VARCHAR2(2),
      guaranteeText   VARCHAR2(200));
  discount_l       discount_r;

  subdiscount_c       SYS_REFCURSOR;
  TYPE subdiscount_r IS RECORD (
      discountCode    VARCHAR2(20),
      discountPercent VARCHAR2(10),
      discountABT     VARCHAR2(20),
      discountReason  VARCHAR2(200));
  subdiscount_l       subdiscount_r;
  
  nap_storno_l     VARCHAR2(100) :=  'Poniteno u vanjskom sustavu';
  obrazlozenje_l   t_rezervacije.napomena2%TYPE;
  guarantee_code_l t_rezervacije.guarantee_code%TYPE;        
  
  CURSOR ms_c (ms_id_k m_msegmenti.id%TYPE) IS -- IRN 4085
    SELECT sifra
      FROM m_msegmenti
     WHERE id = ms_id_l;
  ms_sifra_l  m_msegmenti.sifra%TYPE; -- IRN 4085
  
  CURSOR so1_c (so_id_k m_so.id%TYPE) IS -- IRN 4085
    SELECT naziv
      FROM m_so
     WHERE id = so_id_k;
  so_naziv_l  m_so.naziv%TYPE; -- IRN 4085
BEGIN

  OPEN rezdata_c FOR rezvanjsus_string ('REZ') USING xmlrez_p;
  FETCH rezdata_c INTO rezdata_l;

  WHILE rezdata_c%FOUND LOOP

    BEGIN
      IF rezdata_l.so_sifra IS NOT NULL THEN    
        sosus_sifra_za_subj_m := rezdata_l.so_sifra;  -- za PHOBS se iz xml-a sazna sosus_sifra 
      END IF;
      IF rezdata_l.status IN ('3', '5', '6', '7', 'Cancelled', 'Cancel') THEN

        obrazlozenje_l := rezdata_l.obrazlozenje_storna;
        IF obrazlozenje_l IS NOT NULL THEN
          nap_storno_l := 'Vidi napomenu';
          obrazlozenje_l := obrazlozenje_l || CHR(10);
        END IF;
        
        IF rezdata_l.status = '6' THEN
          pra_rec_synxis.ponisti_rezervaciju (
               rezdata_l.rez_sifra             -- SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
             , vanjski_sustav_m                -- VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
             , rezdata_l.creatorID             -- creator_id_p IN lsynxis_rezervacije.creator_id%TYPE; dio kljua za PHOBS rezervacije
             , rezdata_l.so_sifra              -- recsosus_sifra_p IN lsynxis_rezervacije.recsosus_sifra%TYPE; dio kljua za PHOBS rezervacije   
             , nap_storno_l                    -- OPIS_STORNA_P IN T_REZERVACIJE.OPIS_STORNA%TYPE
             , obrazlozenje_l                  -- NAPOMENA_P IN T_REZERVACIJE.NAPOMENA2%TYPE
             , rez_rbr_l                       -- RBR_P IN OUT T_REZERVACIJE.RBR%TYPE
             , rez_god_l                       -- GOD_POSLOVNA_P IN OUT T_REZERVACIJE.GOD_POSLOVNA%TYPE
             , '3'
          );

        ELSE
          pra_rec_synxis.ponisti_rezervaciju (
               rezdata_l.rez_sifra             -- SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
             , vanjski_sustav_m                -- VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
             , rezdata_l.creatorID             -- creator_id_p IN lsynxis_rezervacije.creator_id%TYPE; dio kljua za PHOBS rezervacije
             , rezdata_l.so_sifra              -- recsosus_sifra_p IN lsynxis_rezervacije.recsosus_sifra%TYPE; dio kljua za PHOBS rezervacije   
             , nap_storno_l                    -- OPIS_STORNA_P IN T_REZERVACIJE.OPIS_STORNA%TYPE
             , obrazlozenje_l                  -- NAPOMENA_P IN T_REZERVACIJE.NAPOMENA2%TYPE
             , rez_rbr_l                       -- RBR_P IN OUT T_REZERVACIJE.RBR%TYPE
             , rez_god_l                       -- GOD_POSLOVNA_P IN OUT T_REZERVACIJE.GOD_POSLOVNA%TYPE
          );
        END IF;

      ELSE
        
        IF UPPER(rezdata_l.status) IN ('HOLD') THEN    
          fiksnaRez_l := 0;
        END IF;
        
        datumRez_l := rezdata_l.datum_rez;
        IF rezdata_l.dat_dolaska = TRUNC (SYSDATE) - 1 THEN
          datumRez_l := rezdata_l.dat_dolaska;
        END IF;

        IF rezdata_l.so_sifra IS NOT NULL THEN
          OPEN so_c (rezdata_l.so_sifra);
          FETCH so_c INTO so_id_l;
          CLOSE so_c;
        ELSE
          so_id_l := so_id_p;
        END IF;
        IF so_id_l IS NULL THEN
          poruka_m := 'smjetajni objekt ' || rezdata_l.so_sifra;
          RAISE sifranik;
        END IF;

        cje_id_l := NULL;
        -- cjenik se popunjavana s vrijednosti iz ifrarnika sustava 
        OPEN cje_c (rezdata_l.cje_sifra);
        FETCH cje_c INTO cje_id_l;
        CLOSE cje_c;
        
        -- IRN 3949 - cjenik se popunjava s vrijednosti parametra 1025
        IF cje_id_l IS NULL THEN
          cje_sifra_l := pra_zmp_zaj.zmppar_vrijednost (vanjski_sustav_m, '1025');
          IF cje_sifra_l <> 'nebitno' THEN 
            OPEN cje1_c (cje_sifra_l);
            FETCH cje1_c INTO cje_id_l;
            CLOSE cje1_c;   
          END IF;
        END IF;         
        
        IF cje_id_l IS NULL THEN
          poruka_m := 'cjenik ' || rezdata_l.cje_sifra;
          RAISE sifranik;
        END IF;

        OPEN recvpro_c (NVL(rezdata_l.vpro_sifra, (rezdata_l.cje_sifra)));
        FETCH recvpro_c INTO recvpro_id_l;
        CLOSE recvpro_c;
        
        BEGIN
          odredi_age_i_ms (rezdata_l.creatorId, rezdata_l.age_sifra, rezdata_l.marketCode, recvpro_id_l, age_id_l, ms_id_l);
        EXCEPTION
          WHEN OTHERS THEN
            RAISE sifranik;
        END;
        
        -- iznos i valuta iznosa rezervacije
        IF rezdata_l.iznos = 0 THEN rezdata_l.iznos := NULL; END IF;
        IF rezdata_l.iznos IS NOT NULL THEN
          OPEN val_c (rezdata_l.valuta);
          FETCH val_c INTO valR_id_l;
          CLOSE val_c;
          IF valR_id_l IS NULL THEN
            poruka_m := 'valuta iznosa rezervacije ' || rezdata_l.valuta;
            RAISE sifranik;
          END IF;
        END IF;

        -- parsiranje podataka o plaenom predujmu ako postoje
        SELECT REGEXP_SUBSTR (rezdata_l.predujam_text, 'TransactionCurrency:(.*?)]'),
               REGEXP_SUBSTR (rezdata_l.predujam_text, 'TransactionAmount:(.*?)]'),
               REGEXP_SUBSTR (rezdata_l.predujam_text, 'ConversionRate:(.*?)]')
          INTO predujam_val_l,
               predujam_iznos_l,
               predujam_tecaj_l
          FROM DUAL;
 
        IF predujam_iznos_l IS NOT NULL THEN
          predujam_iznos_l := SUBSTR (predujam_iznos_l, LENGTH('TransactionAmount:('), INSTR(predujam_iznos_l, ']') - LENGTH('TransactionAmount:('));
        END IF;

        -- iznos i valuta traenog predujma
        ---
        -- u valuti cijene
        IF NVL(rezdata_l.izn_predujma, 0) <> 0 THEN
          izn_predujma_l := rezdata_l.izn_predujma;
          val_id_l := NULL;
          OPEN val_c (rezdata_l.val_sifra3a);
          FETCH val_c INTO val_id_l;
          CLOSE val_c;
          IF val_id_l IS NULL THEN
            poruka_m := 'valuta traenog predujma ' || rezdata_l.val_sifra3a;
            RAISE sifranik;
          END IF;
        END IF;

        -- u valuti naplate
        IF vanjski_sustav_m = 'PHOBS2' AND
          pra_zmp_zaj.zmppar_vrijednost (vanjski_sustav_m, '1023') = '2'
        THEN
          IF TO_NUMBER (NVL(predujam_iznos_l, 0), '9999999999999990.09') <> 0 THEN
            izn_predujma_l := TO_NUMBER (predujam_iznos_l, '9999999999999990.09');
            IF predujam_val_l IS NOT NULL THEN
              predujam_val_l := SUBSTR (predujam_val_l, LENGTH('TransactionCurrency:('), INSTR(predujam_val_l, ']') - LENGTH('TransactionCurrency:('));
              val_id_l := NULL;
              OPEN val_c (predujam_val_l);
              FETCH val_c INTO val_id_l;
              CLOSE val_c;
              IF val_id_l IS NULL THEN
                poruka_m := 'valuta plaenog predujma ' || predujam_val_l;
                RAISE sifranik;
              END IF;
            END IF;
          END IF;
        END IF;
        
        OPEN zem_c (rezdata_l.zem_sifra2a);
        FETCH zem_c INTO zem_id_l;
        CLOSE zem_c;

        IF lower(pra_zmp_zaj.zmppar_vrijednost ('REC', '1068')) = 'nebitno' THEN
          posebanCjeBP_l := 0;
        ELSE
          posebanCjeBP_l := -1;
        END IF;

        -- punjenje napomene     
        IF vanjski_sustav_m = 'PHOBS2' THEN
          
          OPEN discount_c FOR
            'SELECT ExtractValue(column_value, ''/RoomStay/Total/@AmountAfterTax'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') totalAAT,
                    Extract(column_value, ''/RoomStay/RoomRates/RoomRate[1]/Rates/Rate[1]'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'').getclobval() discount,
                    ExtractValue(column_value, ''/RoomStay/Guarantee/@GuaranteeCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') guaranteeCode,
                    ExtractValue(column_value, ''/RoomStay/Guarantee/GuaranteeDescription[1]/Text'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') guaranteeText
               FROM TABLE (XMLSequence (extract (XMLType(:rooms), ''/HotelReservation/RoomStays/RoomStay'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))'
            USING rezdata_l.rooms;

          FETCH discount_c INTO discount_l;
          WHILE discount_c%FOUND LOOP

            i := i + 1;

            -- IRN 3831 punjenje guaranteeCode (samo u prvom prolazu)
            IF i = 1 THEN
              IF discount_l.guaranteeCode = '13' AND INSTR (discount_l.guaranteeText , 'Reservation CC time option' ) > 0 THEN
                guarantee_code_l := '13CC';
              ELSE
                guarantee_code_l := discount_l.guaranteeCode;
              END IF;              
            END IF;
            
            IF napomena_l IS NOT NULL THEN
              napomena_l := napomena_l || CHR(10);
            END IF;

            napomena_l := napomena_l || 'Total: ' || discount_l.totalAAT;

            IF discount_l.discount IS NOT NULL AND rezdata_l.marketCode = 'CAMP' THEN
              OPEN subdiscount_c FOR
                'SELECT ExtractValue(column_value, ''/Discount/@DiscountCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') discountCode,
                        ExtractValue(column_value, ''/Discount/@Percent'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') discountPercent,
                        ExtractValue(column_value, ''/Discount/@AmountBeforeTax'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') discountABT,
                        ExtractValue(column_value, ''/Discount/DiscountReason/Text'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') discountReason
                   FROM TABLE (XMLSequence (extract (XMLType(:discount), ''/Rate/Discount'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))'
                USING discount_l.discount;
              FETCH subdiscount_c INTO subdiscount_l;
              WHILE subdiscount_c%FOUND LOOP
                IF napomena_l IS NOT NULL THEN
                  napomena_l := napomena_l || CHR(10);
                END IF;
                napomena_l := napomena_l || 'Popust:' || subdiscount_l.discountCode;
                IF subdiscount_l.discountPercent IS NOT NULL THEN
                  napomena_l := napomena_l || ' ' || subdiscount_l.discountPercent || '%';
                END IF;
                IF subdiscount_l.discountABT IS NOT NULL THEN
                  napomena_l := napomena_l || ' Iznos:' || subdiscount_l.discountABT;
                END IF;
                napomena_l := napomena_l || ' ' || subdiscount_l.discountReason;
                FETCH subdiscount_c INTO subdiscount_l;
              END LOOP;
              CLOSE subdiscount_c;
            END IF; 

            IF discount_l.guaranteeText IS NOT NULL AND INSTR (napomena_l, discount_l.guaranteeText) = 0 OR
              rezdata_l.predujam_text IS NOT NULL AND INSTR (napomena_l, rezdata_l.predujam_text) = 0
            THEN
              IF napomena_l IS NOT NULL THEN 
                napomena_l := napomena_l || CHR(10);
              END IF;  
              napomena_l := napomena_l || 'Predujam:';
              IF discount_l.guaranteeText IS NOT NULL AND INSTR (napomena_l, discount_l.guaranteeText) = 0 THEN
                napomena_l := napomena_l || ' ' || discount_l.guaranteeText;
              END IF;
              IF rezdata_l.predujam_text IS NOT NULL  AND INSTR (napomena_l, rezdata_l.predujam_text) = 0 THEN
                napomena_l := napomena_l || ' ' || rezdata_l.predujam_text;
              END IF;
            END IF;
            FETCH discount_c INTO discount_l;

          END LOOP;
          CLOSE discount_c;
          
          IF i >= 2 THEN  -- dodati na poetak svih napomena
            napomena_l := 'Provjeriti unesene usluge i cijene u PHOBS-u!' || CHR(10) || napomena_l;
          END IF;

          IF rezdata_l.napomena IS NOT NULL THEN
            -- ako u napomeni postoji formatiranje sa <span.. ili <strong treba ga maknuti inae donji select pukne sa ORA-19025
            rezdata_l.napomena := REGEXP_REPLACE (rezdata_l.napomena, '<\/?(ns2:)?span[^>]*>', ' ');
            rezdata_l.napomena := REGEXP_REPLACE (rezdata_l.napomena, '<\/?(ns2:)?strong>', ' ');
                  
            OPEN napomena_c FOR
              'SELECT ExtractValue(column_value, ''/Comment/Text'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'') 
                  FROM TABLE (XMLSequence (extract (XMLType(:napomene), ''/Comments/Comment'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))'
              USING rezdata_l.napomena;
            FETCH napomena_c INTO nap_part_l;
            WHILE napomena_c%FOUND LOOP
              nap_part2_l := nap_part2_l || CHR(10) || SUBSTR(nap_part_l, 1, 500); -- IRN 4085
              FETCH napomena_c INTO nap_part_l;
            END LOOP;
            CLOSE napomena_c;
            napomena_l := napomena_l || CHR(10) || nap_part2_l; -- IRN 4085 
          END IF;
          
        ELSE -- punjenje napomene za vanjski_sustav_m <> 'PHOBS2'
          napomena_l := 'Total: ' || TRIM(TO_CHAR(TO_NUMBER(rezdata_l.iznos, '999999999999999999D00'), '999G999G999G999G999G999D00')) || ' ' || rezdata_l.valuta || CHR(10);
          napomena_l := napomena_l || rezdata_l.napomena;
        
        END IF;       
        
        napomena_l := REGEXP_REPLACE (napomena_l, '(' || CHR(10) || ')+', CHR(10)); 
        -- IRN 3481 - pretvarati escape znakove
        napomena_l := REPLACE(napomena_l, chr(38) || 'lt;', '<');
        napomena_l := REPLACE(napomena_l, chr(38) || 'gt;', '>');
        
        -- kraj punjenje napomene
        
        IF vanjski_sustav_m = 'PHOBS2' AND lower(pra_zmp_zaj.zmppar_vrijednost ('PHOBS2', '1002')) <> 'nebitno' THEN
          OPEN recnrez_c;
          FETCH recnrez_c INTO recnrez_id_l;
          CLOSE recnrez_c;
        END IF;
        
        -- ukupan broj odraslih i djece u rezervaciji
        IF vanjski_sustav_m = 'PHOBS2' THEN
          br_odraslih_l := NULL;
          br_djece_l := NULL;
        
          OPEN br_osoba_c FOR
            'SELECT SUM (DECODE (ExtractValue(column_value, ''/GuestCount/@AgeQualifyingCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''),
                                 ''10'', ExtractValue(column_value, ''/GuestCount/@Count'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''))) broj_odraslih,
                    SUM (DECODE (ExtractValue(column_value, ''/GuestCount/@AgeQualifyingCode'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''),
                                 ''8'', ExtractValue(column_value, ''/GuestCount/@Count'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''))) broj_djece
               FROM TABLE (XMLSequence (extract (XMLType(:rooms), ''/HotelReservation/RoomStays/RoomStay/GuestCounts/GuestCount'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))'
            USING rezdata_l.rooms;
          FETCH br_osoba_c INTO br_odraslih_l, br_djece_l;
          CLOSE br_osoba_c;
        END IF;
        
        -- provjeri lsynxis_rezervacije
        pra_rec_synxis.spremi_rezervaciju (
             rezdata_l.rez_sifra      -- SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
           , vanjski_sustav_m         -- VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
           , rezdata_l.creatorID      -- creator_id_p IN lsynxis_rezervacije.creator_id%TYPE; dio kljua za PHOBS rezervacije
           , rezdata_l.so_sifra       -- recsosus_sifra_p IN lsynxis_rezervacije.recsosus_sifra%TYPE; dio kljua za PHOBS rezervacije   
           , rez_id_l                 -- REZ_ID_P IN OUT T_REZERVACIJE.ID%TYPE
           , rez_rbr_l                -- REZ_RBR_P IN OUT T_REZERVACIJE.RBR%TYPE
           , so_id_l                  -- SO_ID_P IN T_REZERVACIJE.SO_ID%TYPE
           , ms_id_l                  -- MS_ID_P IN T_REZERVACIJE.MS_ID%TYPE
           , cje_id_l                 -- CJE_ID_P IN T_REZERVACIJE.CJE_ID%TYPE
           , recvpro_id_l             -- RECVPRO_ID_P IN T_REZERVACIJE.RECVPRO_ID%TYPE
           , recnrez_id_l             -- RECNREZ_ID_P IN T_REZERVACIJE.RECNREZ_ID%TYPE
           , age_id_l                 -- AGE_ID_P IN T_REZERVACIJE.AGE_ID%TYPE
           , NULL                     -- PONSO_ID_P IN T_PON_SO.ID%TYPE
           , val_id_l                 -- VAL_ID_P IN T_REZERVACIJE.VAL_ID%TYPE
           , valR_id_l                -- VALR_ID_P IN T_REZERVACIJE.VALR_ID%TYPE
           , zem_id_l                 -- ZEM_ID_P IN T_REZERVACIJE.ZEM_ID%TYPE
           , NULL                     -- RECAGOST_ID_P IN T_REZERVACIJE.RECAGOST_ID%TYPE
           , TO_CHAR(rezdata_l.dat_dolaska, 'rrrr') -- GOD_POSLOVNA_P IN T_REZERVACIJE.GOD_POSLOVNA%TYPE
           , datumRez_l               -- DATUM_P IN T_REZERVACIJE.DATUM%TYPE
           , rezdata_l.titula         -- TITULA_P IN T_REZERVACIJE.TITULA%TYPE
           , UPPER (rezdata_l.ime)       -- IME_P IN T_REZERVACIJE.IME%TYPE
           , UPPER (rezdata_l.prezime)   -- PREZIME_P IN T_REZERVACIJE.PREZIME%TYPE
           , rezdata_l.address        -- NAZ_ULICE_P IN T_REZERVACIJE.NAZ_ULICE%TYPE
           , rezdata_l.naz_mjesta     -- NAZ_MJESTA_P IN T_REZERVACIJE.NAZ_MJESTA%TYPE
           , NULL                     -- NAZ_REGIJE_P IN T_REZERVACIJE.NAZ_REGIJE%TYPE
           , rezdata_l.br_telefona    -- BR_TELEFONA_P IN T_REZERVACIJE.BR_TELEFONA%TYPE
           , rezdata_l.email          -- EMAIL_P IN T_REZERVACIJE.EMAIL%TYPE
           , NULL                     -- WWW_P IN T_REZERVACIJE.WWW%TYPE
           , rezdata_l.newsletter     -- NEWSLETTER_P IN T_REZERVACIJE.OZN_NEWSLETTER%TYPE
           , rezdata_l.dat_dolaska    -- DAT_DOLASKA_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
           , NULL                     -- SAT_DOLASKA_P IN T_REZERVACIJE.SAT_DOLASKA%TYPE
           , rezdata_l.dat_odlaska    -- DAT_ODLASKA_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
           , posebanCjeBP_l           -- OZN_CJE_POSEB_P IN T_REZERVACIJE.OZN_CJE_poseb%TYPE
           , -1                       -- OZN_B_P IN T_REZERVACIJE.OZN_B%TYPE
           , fiksnaRez_l              -- OZN_F_P IN T_REZERVACIJE.OZN_F%TYPE
           , izn_predujma_l           -- IZN_PREDUJMA_P IN T_REZERVACIJE.IZN_PREDUJMA%TYPE
           , rezdata_l.iznos          -- IZN_REZERVACIJE_P IN T_REZERVACIJE.IZN_REZERVACIJE%TYPE
           , rezdata_l.stopa_popusta  -- STOPA_POPUSTA_P IN T_REZERVACIJE.STOPA_POPUSTA%TYPE
           , NULL                     -- OPIS1_P IN T_REZERVACIJE.OPIS1%TYPE
           , NULL                     -- OPIS2_P IN T_REZERVACIJE.OPIS2%TYPE
           , NULL                     -- DAT_KARTICE_P IN T_REZERVACIJE.DAT_KARTICE%TYPE
           , SUBSTR (napomena_l, 1, 2000)             -- NAPOMENA_P IN T_REZERVACIJE.NAPOMENA%TYPE -- irn3491
           , br_odraslih_l            -- BR_OSOBA1_P IN T_REZERVACIJE.BR_OSOBA1%TYPE
           , br_djece_l               -- BR_OSOBA2_P IN T_REZERVACIJE.BR_OSOBA2%TYPE
           , 'V'                      -- OZNAKA_P IN T_REZERVACIJE.OZNAKA%TYPE
           , NULL                     -- OZN_VSTORNA_P IN T_REZERVACIJE.OZN_VSTORNA%TYPE
           , NULL                     -- OZN_VIP_P IN T_REZERVACIJE.OZN_VIP%TYPE
           , NULL                     -- OPIS_STORNA_P IN T_REZERVACIJE.OPIS_STORNA%TYPE
           , rezdata_l.loyaltyID      -- LOYKAR_BROJ_P IN TLOY_KARTICE.BROJ%TYPE
           , NULL                     -- LOYLEVEL_P IN VARCHAR2
           , SUBSTR (poruka_sj_mapa_p, 1, 30) -- opis_rezervacije_mjesta_p IN t_rezervacije.opis_rezervacije_mjesta%type
           , provjera_l               -- PROVJERA_BORAVKA_OK_P IN OUT NUMBER
           , guarantee_code_l         -- guarantee_code_p IN T_REZERVACIJE.guarantee_code%TYPE
           , rezdata_l.rez_agent      -- REZ_AGENT_P IN T_REZERVACIJE.unos_korisnik%TYPE -- IRN 3936
           ); 
           
        -- IRN 4085
        OPEN ms_c (ms_id_l);
        FETCH ms_c INTO ms_sifra_l;
        CLOSE ms_c;
        
        -- IRN 4085
        OPEN so1_c (so_id_l);
        FETCH so1_c INTO so_naziv_l;
        CLOSE so1_c;
           
        -- IRN 4085
        poruka_m_dodatno := poruka_m_dodatno || 'Rbr/Godina: ' || rez_rbr_l || '/' || TO_CHAR(rezdata_l.dat_dolaska, 'rrrr') || CHR(10);
        poruka_m_dodatno := poruka_m_dodatno || 'SO: ' || rezdata_l.so_sifra || ' - ' || so_naziv_l || CHR(10);
        poruka_m_dodatno := poruka_m_dodatno || 'Datum: ' || TO_CHAR(datumRez_l, 'dd.mm.rrrr') || CHR(10);
        poruka_m_dodatno := poruka_m_dodatno || 'Datum dolaska: ' || TO_CHAR(rezdata_l.dat_dolaska, 'dd.mm.rrrr') || CHR(10);
        poruka_m_dodatno := poruka_m_dodatno || 'Datum odlaska: ' || TO_CHAR(rezdata_l.dat_odlaska, 'dd.mm.rrrr') || CHR(10);
        poruka_m_dodatno := poruka_m_dodatno || 'Marketinki segment: ' || ms_sifra_l || CHR(10);
        poruka_m_dodatno := poruka_m_dodatno || 'Ime: ' || UPPER (rezdata_l.ime) || CHR(10);
        poruka_m_dodatno := poruka_m_dodatno || 'Prezime: ' || UPPER (rezdata_l.prezime) || CHR(10);
        poruka_m_dodatno := poruka_m_dodatno || 'E-mail: ' || rezdata_l.email || CHR(10);
        poruka_m_dodatno := poruka_m_dodatno || 'Napomena: ' || SUBSTR (napomena_l, 1, 2000) || CHR(10);
        poruka_m_dodatno := poruka_m_dodatno || 'Predujam: ' || izn_predujma_l || CHR(10);    
       

        pra_rec_synxis.clear_rezervacije_cijene_usl (
             rezdata_l.rez_sifra  -- SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
           , vanjski_sustav_m     -- VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
           , rezdata_l.creatorID      -- creator_id_p IN lsynxis_rezervacije.creator_id%TYPE; dio kljua za PHOBS rezervacije
           , rezdata_l.so_sifra       -- recsosus_sifra_p IN lsynxis_rezervacije.recsosus_sifra%TYPE; dio kljua za PHOBS rezervacije   

           );
        pra_rec_synxis.clear_rezervacije_gosti_usluga (
             rezdata_l.rez_sifra  -- SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
           , vanjski_sustav_m     -- VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
           , rezdata_l.creatorID      -- creator_id_p IN lsynxis_rezervacije.creator_id%TYPE; dio kljua za PHOBS rezervacije
           , rezdata_l.so_sifra       -- recsosus_sifra_p IN lsynxis_rezervacije.recsosus_sifra%TYPE; dio kljua za PHOBS rezervacije   
           );
        pra_rec_synxis.clear_rezervacije_gosti (
             rezdata_l.rez_sifra  -- SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
           , vanjski_sustav_m     -- VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
           , rezdata_l.creatorID      -- creator_id_p IN lsynxis_rezervacije.creator_id%TYPE; dio kljua za PHOBS rezervacije
           , rezdata_l.so_sifra       -- recsosus_sifra_p IN lsynxis_rezervacije.recsosus_sifra%TYPE; dio kljua za PHOBS rezervacije   
           );
        pra_rec_synxis.clear_rezervacije_usluga (
             rezdata_l.rez_sifra  -- SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
           , vanjski_sustav_m     -- VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
           , rezdata_l.creatorID      -- creator_id_p IN lsynxis_rezervacije.creator_id%TYPE; dio kljua za PHOBS rezervacije
           , rezdata_l.so_sifra       -- recsosus_sifra_p IN lsynxis_rezervacije.recsosus_sifra%TYPE; dio kljua za PHOBS rezervacije   
           );

        unesi_rezvsj (rezdata_l.rez_sifra, rezdata_l.creatorId, rezdata_l.so_sifra,  
                      rez_id_l,
                      rezdata_l.rooms, rezdata_l.services, rezdata_l.guests,
                      provjera_l, rezdata_l.dat_dolaska, rezdata_l.dat_odlaska,
                      so_id_l, ms_id_l, rezdata_l.marketCode);
                                        
                                        
        -- upis uplaenog predujma
        IF vanjski_sustav_m = 'PHOBS2' AND
          TO_NUMBER (NVL(predujam_iznos_l, 0), '9999999999999990.09') <> 0 AND
          lower (pra_zmp_zaj.zmppar_vrijednost (vanjski_sustav_m, '1009')) = 'da'
        THEN
          IF pra_zmp_zaj.zmppar_vrijednost (vanjski_sustav_m, '1023') = '2' THEN
          -- 2 = valuti plaanja, pretpostavljamo da je to domaa valuta 
            predujam_tecaj_l := 1;
          ELSE        
            predujam_tecaj_l := SUBSTR (predujam_tecaj_l, LENGTH('ConversionRate:('), INSTR(predujam_tecaj_l, ']') - LENGTH('ConversionRate:('));
          END IF;        
        
          OPEN vpla_c (rezdata_l.predujam_vpla);
          FETCH vpla_c INTO vpla_id_l;
          CLOSE vpla_c;
          IF vpla_id_l IS NULL THEN
            poruka_m := 'vrsta plaanja predujma ' || rezdata_l.predujam_vpla;
            RAISE sifranik;
          END IF;

          -- dbms_output.put_line ('traeni predujam iznos ' || NVL(rezdata_l.izn_predujma, 0));
          -- dbms_output.put_line ('traeni predujam valuta ' || rezdata_l.val_sifra3a);
          -- dbms_output.put_line ('plaeni predujam iznos ' || TO_NUMBER(predujam_iznos_l, '9999999999.99'));
          -- dbms_output.put_line ('plaeni predujam_tecaj_l ' || predujam_tecaj_l);
          -- dbms_output.put_line ('plaeni rezdata_l.predujam_vpla ' || rezdata_l.predujam_vpla);

          pra_pka_predujmovi.insert_predujam
             (rezdata_l.rez_sifra                          -- SYNXIS_SIFRA_P IN LSYNXIS_REZERVACIJE.SYNXIS_SIFRA%TYPE
             ,rezdata_l.creatorID                          -- creator_id_p IN lsynxis_rezervacije.creator_id%TYPE; dio kljua za PHOBS rezervacije
             ,rezdata_l.so_sifra                           -- recsosus_sifra_p IN lsynxis_rezervacije.recsosus_sifra%TYPE; dio kljua za PHOBS rezervacije   
             ,izn_predujma_l                               -- IZNOS_P IN TPKA_RACUNI.IZNOS%TYPE
             ,val_id_l                                     -- VAL_ID_P IN S_VALUTE.ID%TYPE
             ,TO_NUMBER(predujam_tecaj_l, '999999.999999') -- TECAJ_P IN TPKA_RACUNI.IZN_TECAJA%TYPE
             ,rezdata_l.predujam_vpla                      -- VPLA_SIFRA_P IN MZMP_VPLA_SUS.SIFRA%TYPE
             ,TO_NUMBER(predujam_iznos_l, '9999999999.99') -- IZNOS_NAPLATE_P IN TPKA_RAC_NAP.IZNOS%TYPE
             ,vanjski_sustav_m                             -- ZMPSUS_SIFRA_P IN SZMP_SUSTAVI.SIFRA%TYPE
             );
        END IF;

      END IF;
       
      rbr_string_p := rez_rbr_l || ' ' || TO_CHAR(rezdata_l.dat_dolaska, 'rrrr'); -- IRN 3936
      
    EXCEPTION
      WHEN sifranik THEN
        poruka_m := 'Podatak ne postoji: ' || poruka_m || '.';
        RAISE;

      WHEN OTHERS THEN
        RAISE;
    END;

    FETCH rezdata_c INTO rezdata_l;
  END LOOP;

  CLOSE rezdata_c;

END;
PROCEDURE UNESI_REZCJE
 (REZ_SIFRA_P IN LSYNXIS_REZERVACIJE.SYNXIS_SIFRA%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,REZ_ID_P IN TREC_REZ_CJEUSL.REZ_ID%TYPE
 ,VSJC_ID_P IN TREC_REZ_CJEUSL.VSJ_ID%TYPE
 ,USL_SIFRA_P IN MZMP_USL_SUS.SIFRA%TYPE
 ,XMLREZCJE_P IN CLOB
 ,XMLREZSUPP_P IN CLOB
 ,DAT_DOLAZ_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,DAT_ODLAZ_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
 ,IZNOS_BP_P IN VARCHAR2
 ,MARKETCODE_P IN VARCHAR2
 ,UNOS_KORISNIK_P IN M_KORISNICI.NAZIV%TYPE
 )
 IS
--
  CURSOR usl_c (sifra_k mzmp_usl_sus.sifra%TYPE) IS
    SELECT usl_id
      FROM mzmp_usl_sus
     WHERE UPPER (sifra) = UPPER (sifra_k)
       AND zmpsus_id = (SELECT id
                          FROM szmp_sustavi
                         WHERE sifra = vanjski_sustav_m);
  usl_id_l            s_usluge.id%TYPE;

  CURSOR zmpusl_c (usl_id_k IN s_usluge.id%TYPE) IS
    SELECT obr_zdana, ozn_cje_vsj, 
           ozn_cijene_phobs, ozn_1dan
      FROM s_usluge
     WHERE id = usl_id_k;
  zmpusl_r_l          zmpusl_c%ROWTYPE;

  vsjc_id_l           s_vsj.id%TYPE;
  cijena_l            trec_rez_cjeusl.cijena_usluge%TYPE;
  kol_usl_l           NUMBER(2);
  dat_zav_l           trec_rez_cjeusl.dat_zav%TYPE;
  
  preklapanje_l       VARCHAR2(500) :=
   'SELECT COUNT(1)
      FROM trec_rez_cjeusl<cvor>
     WHERE rez_id = :rez_id
       AND usl_id = :usl_id
       AND NVL(vsj_id, 0) = NVL(:vsj_id, 0)
       AND (dat_poc BETWEEN :dat_poc AND :dat_zav
            OR
            dat_zav BETWEEN :dat_poc AND :dat_zav)';
  br_preklap_l        NUMBER(1) := 0;

  rezcje_sc           SYS_REFCURSOR;

  TYPE dayPrice_r IS RECORD (
      iznos     t_racuni.iznos%TYPE,
      dat_poc   DATE,
      dat_zav   DATE,
      rates     CLOB,
      typeCode  mzmp_vsj_sus.sifra%TYPE
    );
  rezcje_l            dayPrice_r;
  rezcjesupp_l        supplement_r;
  
  rates_c             SYS_REFCURSOR;
  rates_l             dayPrice_r;

  rez_id_l            t_rez_vsj.rez_id%TYPE;
  target_cvor_l       VARCHAR2 (41) := '';
  greska_l            EXCEPTION;

  zakljucati_cijene_l szmp_parametri.vrijednost%TYPE := lower(pra_zmp_zaj.zmppar_vrijednost('PHOBS2', '1022'));
BEGIN
  IF rez_sifra_p IS NULL THEN
    RAISE greska_l;
  END IF;

  /*
  vrati id i cvor t_rezervacije za zadani broj rezervacije
  */
  pra_rec_synxis.vrati_rez_id_cvor
       (synxis_sifra_p => rez_sifra_p
       ,vanj_sustav_p => vanjski_sustav_m
       ,creator_id_p => creator_id_p
       ,recsosus_sifra_p => recsosus_sifra_p
       ,rez_id_p => rez_id_l
       ,target_cvor_p => target_cvor_l  
       );

  /* osnovna usluga */

  -- odredi usl_id
  OPEN usl_c (usl_sifra_p);
  FETCH usl_c INTO usl_id_l;
  CLOSE usl_c;

  OPEN zmpusl_c (usl_id_l);
  FETCH zmpusl_c INTO zmpusl_r_l;
  CLOSE zmpusl_c;

  IF zmpusl_r_l.ozn_cje_vsj = -1 THEN
    vsjc_id_l := vsjc_id_p;
  END IF;

  IF zmpusl_r_l.ozn_cijene_phobs = 0 AND
    vanjski_sustav_m = 'PHOBS2' AND
    zakljucati_cijene_l = 'da'
  THEN
    -- ako treba zakljuati cijene iz Mish cjenika
    pra_rec_synxis.zakljucaj_cijene_usluge (
          rez_sifra_p         -- SYNXIS_SIFRA_P IN VARCHAR2
        , vanjski_sustav_m    -- VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
        , creator_ID_p        -- creator_id_p IN lsynxis_rezervacije.creator_id%TYPE; dio kljua za PHOBS rezervacije
        , recsosus_sifra_p    -- recsosus_sifra_p IN lsynxis_rezervacije.recsosus_sifra%TYPE; dio kljua za PHOBS rezervacije   
        , vsjc_id_l           -- VSJ_ID_P IN NUMBER
        , usl_id_l            -- USL_ID_P IN NUMBER
        , NULL                -- RECARA_ID_P IN T_REZ_USL.RECARA_ID%TYPE
        , NULL                -- DATPOC_P IN T_REZ_USL.DAT_POC%TYPE
        , NULL                -- DATZAV_P IN T_REZ_USL.DAT_ZAV%TYPE
        , unos_korisnik_p);
  
  ELSIF zmpusl_r_l.ozn_cijene_phobs = -1 THEN
    -- upisivanje cijena iz Phobsa
    
    OPEN rezcje_sc FOR rezvanjsus_string ('REZCJE') USING xmlrezcje_p;
    FETCH rezcje_sc INTO rezcje_l;

    WHILE rezcje_sc%FOUND LOOP

      -- vidi je li cijena za MealPlanCode ili za UslPerson
      IF NVL(rezcje_l.typeCode, 'ROOM') LIKE 'PERSON%' THEN
        
        -- ako je PERSON%,
        -- zbog ORDER BY 4 DESC u selectu cursora,
        -- dosad su ve obraene cijene osnovne usluge

        usl_id_l := NULL;
        zmpusl_r_l := NULL;
        vsjc_id_l := NULL;

        OPEN usl_c (rezcje_l.typeCode);
        FETCH usl_c INTO usl_id_l;
        CLOSE usl_c;

        OPEN zmpusl_c (usl_id_l);
        FETCH zmpusl_c INTO zmpusl_r_l;
        CLOSE zmpusl_c;

        IF zmpusl_r_l.ozn_cje_vsj = -1 THEN
          vsjc_id_l := vsjc_id_p;
        END IF;
      END IF;
      
      IF rezcje_l.rates IS NOT NULL THEN
        OPEN rates_c FOR
          'SELECT SUM(TO_NUMBER(
                  DECODE (:marketcode,
                          ''CAMP'', ExtractValue(column_value, ''/Rate/Base/@AmountBeforeTax'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''),
                          ExtractValue(column_value, ''/Rate/Total/@AmountBeforeTax'', ''xmlns="http://www.opentravel.org/OTA/2003/05"''))
                    , ''9999999999999990.09'')) iznos,
                  TRUNC(TO_DATE(ExtractValue(column_value, ''/Rate/@EffectiveDate'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')
                                , ''rrrr-mm-dd''))
                    dat_poc,
                  TRUNC(TO_DATE(ExtractValue(column_value, ''/Rate/@ExpireDate'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')
                                , ''rrrr-mm-dd''))
                    dat_zav,
                  NULL,
                  NULL
             FROM TABLE (XMLSequence (extract (XMLType(:rates), ''/Rates/Rate'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')))
            GROUP BY TRUNC(TO_DATE(ExtractValue(column_value, ''/Rate/@EffectiveDate'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')
                                   , ''rrrr-mm-dd'')),
                     TRUNC(TO_DATE(ExtractValue(column_value, ''/Rate/@ExpireDate'', ''xmlns="http://www.opentravel.org/OTA/2003/05"'')
                                   , ''rrrr-mm-dd''))'
          USING marketcode_p, rezcje_l.rates;

       
       ELSE
         OPEN rates_c FOR
           'SELECT :1 iznos,
                   :2 dat_poc,
                   :3 dat_zav,
                   NULL, 
                   NULL
              FROM DUAL'
         USING rezcje_l.iznos, rezcje_l.dat_poc, rezcje_l.dat_zav;
      END IF;

      FETCH rates_c INTO rates_l;
      WHILE rates_c%FOUND LOOP

        br_preklap_l := 0;
      
        dat_zav_l := rates_l.dat_zav;
      
        IF vanjski_sustav_m = 'PHOBS2' THEN
          dat_zav_l := dat_zav_l - 1;
        END IF;
        
        EXECUTE IMMEDIATE REPLACE (preklapanje_l, '<cvor>', target_cvor_l)
          INTO br_preklap_l
          USING rez_id_p, usl_id_l, vsjc_id_l,
                rates_l.dat_poc, dat_zav_l,
                rates_l.dat_poc, dat_zav_l; 

        IF br_preklap_l = 0 THEN
          pra_rec_synxis.dodaj_preracunatu_cijenu_usl (
                rez_sifra_p         -- SYNXIS_SIFRA_P IN VARCHAR2
              , vanjski_sustav_m    -- VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
              , creator_ID_p        -- creator_id_p IN lsynxis_rezervacije.creator_id%TYPE; dio kljua za PHOBS rezervacije
              , recsosus_sifra_p    -- recsosus_sifra_p IN lsynxis_rezervacije.recsosus_sifra%TYPE; dio kljua za PHOBS rezervacije   
              , vsjc_id_l           -- VSJ_ID_P IN NUMBER
              , usl_id_l            -- USL_ID_P IN NUMBER
              , rates_l.dat_poc     -- DAT_POC_P IN DATE
              , dat_zav_l           -- DAT_ZAV_P IN DATE
              , rates_l.iznos       -- IZNOS_P IN NUMBER
              , unos_korisnik_p);
        END IF;
        
        FETCH rates_c INTO rates_l;
      END LOOP;
      CLOSE rates_c;
      
      FETCH rezcje_sc INTO rezcje_l;
    END LOOP;

    CLOSE rezcje_sc;
  END IF;
  /* kraj osnovna usluga */

  /* BP, EP */
  FOR bp_ep_c IN (
    SELECT 'BP' usl_sifra
      FROM DUAL
     WHERE vanjski_sustav_m = 'PHOBS2'
       AND lower(pra_zmp_zaj.zmppar_vrijednost ('REC', '1068')) = 'nebitno'
       AND iznos_bp_p IS NOT NULL
       AND TO_NUMBER(iznos_bp_p, '9999999999.99') <> 0)
  LOOP
    usl_id_l := NULL;
    zmpusl_r_l := NULL;
    vsjc_id_l := NULL;

    OPEN usl_c (bp_ep_c.usl_sifra);
    FETCH usl_c INTO usl_id_l;
    CLOSE usl_c;

    OPEN zmpusl_c (usl_id_l);
    FETCH zmpusl_c INTO zmpusl_r_l;
    CLOSE zmpusl_c;

    IF zmpusl_r_l.ozn_cje_vsj = -1 THEN
      vsjc_id_l := vsjc_id_p;
    END IF;

    IF zmpusl_r_l.ozn_cijene_phobs = 0 AND
      vanjski_sustav_m = 'PHOBS2' AND
      zakljucati_cijene_l = 'da'
    THEN
        -- ako treba zakljuati cijene iz Mish cjenika
        pra_rec_synxis.zakljucaj_cijene_usluge (
            rez_sifra_p         -- SYNXIS_SIFRA_P IN VARCHAR2
          , vanjski_sustav_m    -- VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
          , creator_ID_p        -- creator_id_p IN lsynxis_rezervacije.creator_id%TYPE; dio kljua za PHOBS rezervacije
          , recsosus_sifra_p    -- recsosus_sifra_p IN lsynxis_rezervacije.recsosus_sifra%TYPE; dio kljua za PHOBS rezervacije   
          , vsjc_id_l           -- VSJ_ID_P IN NUMBER
          , usl_id_l            -- USL_ID_P IN NUMBER
          , NULL                -- RECARA_ID_P IN T_REZ_USL.RECARA_ID%TYPE
          , NULL                -- DATPOC_P IN T_REZ_USL.DAT_POC%TYPE
          , NULL                -- DATZAV_P IN T_REZ_USL.DAT_ZAV%TYPE
          , unos_korisnik_p);
    ELSIF zmpusl_r_l.ozn_cijene_phobs = -1 THEN

      br_preklap_l := 0;

      EXECUTE IMMEDIATE REPLACE (preklapanje_l, '<cvor>', target_cvor_l)
        INTO br_preklap_l
        USING rez_id_p, usl_id_l, vsjc_id_l,
              dat_dolaz_p, dat_odlaz_p - 1,
              dat_dolaz_p, dat_odlaz_p - 1;

      IF br_preklap_l = 0 THEN
        pra_rec_synxis.dodaj_preracunatu_cijenu_usl (
              rez_sifra_p         -- SYNXIS_SIFRA_P IN VARCHAR2
            , vanjski_sustav_m    -- VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
            , creator_ID_p        -- creator_id_p IN lsynxis_rezervacije.creator_id%TYPE; dio kljua za PHOBS rezervacije
            , recsosus_sifra_p    -- recsosus_sifra_p IN lsynxis_rezervacije.recsosus_sifra%TYPE; dio kljua za PHOBS rezervacije   
            , vsjc_id_l           -- VSJ_ID_P IN NUMBER
            , usl_id_l            -- USL_ID_P IN NUMBER
            , dat_dolaz_p         -- DAT_POC_P IN DATE
            , dat_odlaz_p - 1     -- DAT_ZAV_P IN DATE
            , TO_NUMBER(iznos_bp_p, '9999999999.99') -- IZNOS_P IN NUMBER
            , unos_korisnik_p);
      END IF;
    END IF;
  END LOOP;
  /* kraj BP, EP */

  /* dodatne usluge */
  OPEN rezcje_sc FOR rezvanjsus_string ('REZSUPP') USING xmlrezsupp_p;
  FETCH rezcje_sc INTO rezcjesupp_l;

  WHILE rezcje_sc%FOUND LOOP

    vsjc_id_l := NULL;
    cijena_l := NULL;
    kol_usl_l := NULL;
    br_preklap_l := NULL;

    -- odredi usl_id
    usl_id_l := NULL;
    OPEN usl_c (rezcjesupp_l.usl_sifra);
    FETCH usl_c INTO usl_id_l;
    CLOSE usl_c;

    OPEN zmpusl_c (usl_id_l);
    FETCH zmpusl_c INTO zmpusl_r_l;
    CLOSE zmpusl_c;

    vsjc_id_l := NULL;
    IF zmpusl_r_l.ozn_cje_vsj = -1 THEN
      vsjc_id_l := vsjc_id_p;
    END IF;

    IF zmpusl_r_l.ozn_cijene_phobs = 0 AND
      vanjski_sustav_m = 'PHOBS2' AND
      zakljucati_cijene_l = 'da'
    THEN
      -- ako treba zakljuati cijene iz Mish cjenika
      pra_rec_synxis.zakljucaj_cijene_usluge (
            rez_sifra_p         -- SYNXIS_SIFRA_P IN VARCHAR2
          , vanjski_sustav_m    -- VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
          , creator_ID_p        -- creator_id_p IN lsynxis_rezervacije.creator_id%TYPE; dio kljua za PHOBS rezervacije
          , recsosus_sifra_p    -- recsosus_sifra_p IN lsynxis_rezervacije.recsosus_sifra%TYPE; dio kljua za PHOBS rezervacije   
          , vsjc_id_l           -- VSJ_ID_P IN NUMBER
          , usl_id_l            -- USL_ID_P IN NUMBER
          , NULL                -- RECARA_ID_P IN T_REZ_USL.RECARA_ID%TYPE
          , NULL                -- DATPOC_P IN T_REZ_USL.DAT_POC%TYPE
          , NULL                -- DATZAV_P IN T_REZ_USL.DAT_ZAV%TYPE
          , unos_korisnik_p);
    ELSIF zmpusl_r_l.ozn_cijene_phobs = -1 THEN

      IF vanjski_sustav_m = 'PHOBS2' AND rezcjesupp_l.tip LIKE 'Per person%' THEN
        kol_usl_l := 1;
      ELSIF NVL(rezcjesupp_l.kol, 0) <> 0 THEN
        kol_usl_l := rezcjesupp_l.kol;
      ELSIF NVL(rezcjesupp_l.br_osoba, 0) <> 0 THEN
        kol_usl_l := rezcjesupp_l.br_osoba;
      ELSE
        kol_usl_l := 1;
      END IF;

      cijena_l := ROUND(rezcjesupp_l.iznos / kol_usl_l, 2);

      IF zmpusl_r_l.ozn_1dan = -1 THEN
        dat_zav_l := dat_dolaz_p;
      ELSE
        dat_zav_l := dat_odlaz_p - 1;
      END IF;

      br_preklap_l := 0;

      EXECUTE IMMEDIATE REPLACE (preklapanje_l, '<cvor>', target_cvor_l)
        INTO br_preklap_l
        USING rez_id_p, usl_id_l, vsjc_id_l,
              dat_dolaz_p, dat_zav_l,
              dat_dolaz_p, dat_zav_l;

      IF br_preklap_l = 0 THEN
        pra_rec_synxis.dodaj_preracunatu_cijenu_usl (
              rez_sifra_p         -- SYNXIS_SIFRA_P IN VARCHAR2
            , vanjski_sustav_m    -- VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
            , creator_ID_p        -- creator_id_p IN lsynxis_rezervacije.creator_id%TYPE; dio kljua za PHOBS rezervacije
            , recsosus_sifra_p    -- recsosus_sifra_p IN lsynxis_rezervacije.recsosus_sifra%TYPE; dio kljua za PHOBS rezervacije   
            , vsjc_id_l           -- VSJ_ID_P IN NUMBER
            , usl_id_l            -- USL_ID_P IN NUMBER
            , dat_dolaz_p         -- DAT_POC_P IN DATE
            , dat_zav_l           -- DAT_ZAV_P IN DATE
            , cijena_l            -- IZNOS_P IN NUMBER
            , unos_korisnik_p);
      END IF;

    END IF;

    FETCH rezcje_sc INTO rezcjesupp_l;

  END LOOP;
  /* kraj dodatne usluge */

  CLOSE rezcje_sc;


END;
PROCEDURE UNESI_REZGOST
 (REZ_SIFRA_P IN LSYNXIS_REZERVACIJE.SYNXIS_SIFRA%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,REZVSJ_ID_P IN T_REZ_VSJ.ID%TYPE
 ,XMLREZGOST_P IN CLOB
 ,XMLDOBGRUPE_P IN CLOB
 )
 IS
--
  rezgost_sc SYS_REFCURSOR;

  rezgost_id_l           t_rez_gost.id%TYPE;
  rezgost_ime_l          t_rez_gost.ime%TYPE;
  rezgost_prezime_l      t_rez_gost.prezime%TYPE;
  rezgost_titula_l       t_rez_gost.titula%TYPE;
  rezgost_dat_rodjenja_l t_rez_gost.dat_rodjenja%TYPE;
  rezgost_reg_vozila_l   t_rez_gost.reg_vozila%TYPE;
  
  dobgrupa_sc SYS_REFCURSOR;

  dob_l             t_rez_gost.dob%TYPE;
  br_osoba_dobi_l   NUMBER;

  unos_korisnik_l  m_korisnici.naziv%TYPE := zmp_zaj.korisnik (-1);
BEGIN
  IF vanjski_sustav_m = 'PHOBS2' THEN
    unos_korisnik_l := 'PHOBS';
  END IF;

  -- upii listu gostiju ako postoji
  OPEN rezgost_sc FOR rezvanjsus_string ('REZGOST') USING xmlrezgost_p;
  FETCH rezgost_sc INTO rezgost_titula_l, rezgost_ime_l, rezgost_prezime_l, rezgost_dat_rodjenja_l, rezgost_reg_vozila_l;

  WHILE rezgost_sc%FOUND LOOP
    rezgost_id_l := NULL;

    IF rezgost_reg_vozila_l IS NOT NULL THEN
      BEGIN
        pra_zmp_zaj.oblikuj_slovo_upp_broj (rezgost_reg_vozila_l);
      EXCEPTION
        WHEN OTHERS THEN
          rezgost_reg_vozila_l := NULL;
      END;
    END IF;      

    pra_rec_synxis.dodaj_rezervacija_gosti (
            rez_sifra_p            -- SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
          , vanjski_sustav_m       -- VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
          , creator_ID_p           -- creator_id_p IN lsynxis_rezervacije.creator_id%TYPE; dio kljua za PHOBS rezervacije
          , recsosus_sifra_p       -- recsosus_sifra_p IN lsynxis_rezervacije.recsosus_sifra%TYPE; dio kljua za PHOBS rezervacije   
          , rezgost_id_l           -- REZGOST_ID_P IN OUT T_REZ_GOST.ID%TYPE
          , rezvsj_id_p            -- REZVSJ_ID_P IN T_REZ_VSJ.ID%TYPE
          , NULL                   -- RBR_P IN T_REZ_GOST.rbr%TYPE := NULL
          , rezgost_ime_l          -- IME_P IN T_REZ_GOST.IME%TYPE
          , rezgost_prezime_l      -- PREZIME_P IN T_REZ_GOST.PREZIME%TYPE
          , rezgost_titula_l       -- TITULA_P IN T_REZ_GOST.TITULA%TYPE
          , rezgost_dat_rodjenja_l -- DAT_RODJENJA_P IN T_REZ_GOST.DAT_RODJENJA%TYPE
          , NULL                   -- DOB_P IN T_REZ_GOST.DOB%TYPE := NULL
          , NULL                   -- VPISP_ID_P IN S_VPISPRAVA.ID%TYPE
          , NULL                   -- BR_PISPRAVE_P IN T_REZ_GOST.BR_PISPRAVE%TYPE
          , NULL                   -- NAZ_MJRODJ_P IN T_REZ_GOST.NAZ_MJRODJ%TYPE
          , NULL                   -- ZEMR_ID_P IN T_REZ_GOST.ZEMR_ID%TYPE
          , NULL                   -- ZEMD_ID_P IN T_REZ_GOST.ZEMD_ID%TYPE
          , rezgost_reg_vozila_l   -- reg_vozila_P IN T_REZ_GOST.reg_vozila%TYPE
          );
    FETCH rezgost_sc INTO rezgost_titula_l, rezgost_ime_l, rezgost_prezime_l, rezgost_dat_rodjenja_l, rezgost_reg_vozila_l;
  END LOOP;
  CLOSE rezgost_sc;

  -- dopuni goste dobne grupe
  OPEN dobgrupa_sc FOR rezvanjsus_string ('DOBNEGRUPE') USING xmldobgrupe_p;
  FETCH dobgrupa_sc INTO dob_l, br_osoba_dobi_l;
  WHILE dobgrupa_sc%FOUND LOOP
    IF dob_l IS NOT NULL THEN
      pra_rec_synxis.popuni_dobnu_grupu (
            rez_sifra_p         -- SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
          , vanjski_sustav_m    -- VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
          , creator_ID_p        -- creator_id_p IN lsynxis_rezervacije.creator_id%TYPE; dio kljua za PHOBS rezervacije
          , recsosus_sifra_p    -- recsosus_sifra_p IN lsynxis_rezervacije.recsosus_sifra%TYPE; dio kljua za PHOBS rezervacije   
          , rezvsj_id_p         -- REZVSJ_ID_P IN T_REZ_VSJ.ID%TYPE
          , dob_l               -- DOB_P IN T_REZ_GOST.DOB%TYPE
          , br_osoba_dobi_l     -- BR_OSOBA_DOBI_P IN NUMBER
          , unos_korisnik_l);
    END IF;
    FETCH dobgrupa_sc INTO dob_l, br_osoba_dobi_l;
  END LOOP;
  CLOSE dobgrupa_sc;

END;
FUNCTION UNESI_REZUSL
 (REZ_SIFRA_P IN LSYNXIS_REZERVACIJE.SYNXIS_SIFRA%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,XMLUSL_SIFRA_P IN VARCHAR2
 ,XMLUSLPER_P IN CLOB
 ,RECARA_ID_P IN MREC_ARANZMANI.ID%TYPE
 ,PLACA_GOST_P IN T_REZ_USL.OZN_PLATITELJA%TYPE
 )
 RETURN NUMBER
 IS
--
  sifranik EXCEPTION;

  CURSOR usl_c (sifra_k mzmp_usl_sus.sifra%TYPE) IS
    SELECT usl_id
      FROM mzmp_usl_sus
     WHERE UPPER (sifra) = UPPER (sifra_k)
       AND zmpsus_id = (SELECT id
                          FROM szmp_sustavi
                         WHERE sifra = vanjski_sustav_m);
  usl_id_l s_usluge.id%TYPE;

  usl_person_c SYS_REFCURSOR;
  usl_person_sifra_l mzmp_usl_sus.sifra%TYPE;

  osn_usluga_l s_usluge.id%TYPE;
BEGIN

  -- odredi usl_id
  OPEN usl_c (xmlusl_sifra_p);
  FETCH usl_c INTO usl_id_l;
  CLOSE usl_c;
  IF usl_id_l IS NULL THEN
    poruka_m := 'USL ' || xmlusl_sifra_p;
    RAISE sifranik;
  END IF;

  -- INSERT REZUSL
  pra_rec_synxis.dodaj_rezervacija_usluga (
        rez_sifra_p         -- SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
      , vanjski_sustav_m    -- VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
      , creator_ID_p        -- creator_id_p IN lsynxis_rezervacije.creator_id%TYPE; dio kljua za PHOBS rezervacije
      , recsosus_sifra_p    -- recsosus_sifra_p IN lsynxis_rezervacije.recsosus_sifra%TYPE; dio kljua za PHOBS rezervacije   
      , usl_id_l            -- USL_ID_P IN T_REZ_USL.USL_ID%TYPE
      , NULL                -- SAS_ID_P IN T_REZ_USL.SAS_ID%TYPE
      , NULL                -- USL_ID1_P IN T_REZ_USL.USL_ID1%TYPE
      , recara_id_p         -- RECARA_ID_P IN T_REZ_USL.RECARA_ID%TYPE
      , NULL                -- DAT_POC_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
      , NULL                -- DAT_ZAV_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
      , placa_gost_p        -- PLACA_GOST_P IN T_REZ_GUSL.OZN_PLATITELJA%TYPE
      );

  osn_usluga_l := usl_id_l;

  OPEN usl_person_c
    FOR 'SELECT DISTINCT ExtractValue(column_value, ''/UslPerson'')
           FROM TABLE (XMLSequence (extract (XMLType (''<Usl>'' || :uslperson || ''</Usl>''), ''/Usl/UslPerson'')))'
    USING xmluslper_p;
  FETCH usl_person_c INTO usl_person_sifra_l;
    WHILE usl_person_c%FOUND LOOP
    usl_id_l := NULL;

    OPEN usl_c (usl_person_sifra_l);
    FETCH usl_c INTO usl_id_l;
    CLOSE usl_c;
    IF usl_id_l IS NULL THEN
      poruka_m := 'USL ' || usl_person_sifra_l;
      RAISE sifranik;
    END IF;

    -- INSERT REZUSL
    pra_rec_synxis.dodaj_rezervacija_usluga (
          rez_sifra_p         -- SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
        , vanjski_sustav_m    -- VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
        , creator_ID_p        -- creator_id_p IN lsynxis_rezervacije.creator_id%TYPE; dio kljua za PHOBS rezervacije
        , recsosus_sifra_p    -- recsosus_sifra_p IN lsynxis_rezervacije.recsosus_sifra%TYPE; dio kljua za PHOBS rezervacije   
        , usl_id_l            -- USL_ID_P IN T_REZ_USL.USL_ID%TYPE
        , NULL                -- SAS_ID_P IN T_REZ_USL.SAS_ID%TYPE
        , NULL                -- USL_ID1_P IN T_REZ_USL.USL_ID1%TYPE
        , NULL                -- RECARA_ID_P IN T_REZ_USL.RECARA_ID%TYPE
        , NULL                -- DAT_POC_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
        , NULL                -- DAT_ZAV_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
        , placa_gost_p        -- PLACA_GOST_P IN T_REZ_GUSL.OZN_PLATITELJA%TYPE      -- IRN 3613
        );
    FETCH usl_person_c INTO usl_person_sifra_l;
  END LOOP;
  CLOSE usl_person_c;

  RETURN osn_usluga_l;

EXCEPTION
  WHEN sifranik THEN
    poruka_m := 'Podatak ne postoji: ' || poruka_m || '.';
    RAISE;

  WHEN OTHERS THEN
    RAISE;

END;
PROCEDURE UNESI_REZVSJ
 (REZ_SIFRA_P IN LSYNXIS_REZERVACIJE.SYNXIS_SIFRA%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,REZ_ID_P IN TREC_REZ_CJEUSL.REZ_ID%TYPE
 ,XMLREZVSJ_P IN CLOB
 ,XMLUSL_P IN CLOB
 ,XMLGUESTS_P IN CLOB
 ,PROVJERA_P IN NUMBER
 ,REZ_DATDOL_P IN DATE
 ,REZ_DATODL_P IN DATE
 ,SO_ID_P IN T_REZERVACIJE.SO_ID%TYPE
 ,MS_ID_P IN T_REZERVACIJE.MS_ID%TYPE
 ,MARKETCODE_P IN VARCHAR2
 )
 IS
--
  razdoblja EXCEPTION;
  sifranik EXCEPTION;

  rezvsj_c SYS_REFCURSOR;
  TYPE rezvsj_r IS RECORD (
      dayPrices     CLOB,
      dobGrupe      CLOB,
      guests        CLOB,
      supplements   CLOB,
      vsj_sifra     mzmp_vsj_sus.sifra%TYPE,
      sj_broj       m_sj.broj%TYPE, -- IRN 4085
      usl_sifra     mzmp_usl_sus.sifra%TYPE,
      usl_person    CLOB,
      kol_sj        t_rez_vsj.kol_sj%TYPE,
      br_osoba      t_rez_vsj.br_osoba%TYPE,
      iznos         VARCHAR2(20), -- t_racuni.iznos%TYPE,
      val_sifra3a   s_valute.sifra_3a%TYPE,
      status        VARCHAR2(10),
      dat_dolaska   DATE,
      dat_odlaska   DATE,
      guaranteeCode VARCHAR2(2),
      promotionCode mrec_ara_sus.sifra%TYPE);
  rezvsj_l rezvsj_r;

  brojac_l   NUMBER(2);
  provjera_l NUMBER(1) := provjera_p;

  CURSOR vsj_c (sifra_k mzmp_vsj_sus.sifra%TYPE, 
                kol_sj_l t_rez_vsj.kol_sj%TYPE) IS
    SELECT vsj_id, vsjc_id, kol_sj_l * NVL(kolicina, 1)
      FROM mzmp_vsj_sus
     WHERE sifra = sifra_k
       AND zmpsus_id = (SELECT id
                          FROM szmp_sustavi
                         WHERE sifra = vanjski_sustav_m);
  vsj_id_l  s_vsj.id%TYPE;
  vsjc_id_l s_vsj.id%TYPE;

  kol_sj_l t_rez_vsj.kol_sj%TYPE;
  rezvsj_id_l t_rez_vsj.id%TYPE;
  osn_usluga_id_l s_usluge.id%TYPE;

  placa_gost_l t_rez_usl.ozn_platitelja%TYPE := -1;

  CURSOR recara_c (sifra_k IN mrec_ara_sus.sifra%TYPE) IS
    SELECT recara_id
      FROM mrec_ara_sus
     WHERE sifra = sifra_k
       AND zmpsus_id = (SELECT id
                          FROM szmp_sustavi
                         WHERE sifra = vanjski_sustav_m);
  recara_id_l mrec_ara_usl.recara_id%TYPE;

  unos_korisnik_l  m_korisnici.naziv%TYPE := zmp_zaj.korisnik (-1);
  
  sj_broj_l m_sj.broj%TYPE; -- IRN 4085
  sj_broj_warn_l VARCHAR2 (2000); -- IRN 4085
BEGIN
  IF vanjski_sustav_m = 'PHOBS2' THEN
    unos_korisnik_l := 'PHOBS';
  END IF;

  brojac_l := 0;

  zapamti_upisane_sj (
            rez_sifra_p         -- SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
          );

  OPEN rezvsj_c FOR rezvanjsus_string ('REZVSJ') USING xmlguests_p, xmlusl_p, xmlrezvsj_p;
  FETCH rezvsj_c INTO rezvsj_l;

  WHILE rezvsj_c%FOUND LOOP
    IF rezvsj_l.status IN ('4', '8') THEN
      rezvsj_id_l := NULL;
      brojac_l := brojac_l + 1;

      IF brojac_l <> 1 THEN
        provjera_l := 0;
      END IF;

      -- provjeri dat_dolaska i dat odlaska
      IF rez_datdol_p <> NVL(rezvsj_l.dat_dolaska, rez_datdol_p) OR rez_datodl_p <> NVL(rezvsj_l.dat_odlaska, rez_datodl_p) THEN
        RAISE razdoblja;
      END IF;

      -- odredi vsj_id, vsjc_id
      vsj_id_l := NULL;
      OPEN vsj_c (rezvsj_l.vsj_sifra, rezvsj_l.kol_sj);
      FETCH vsj_c INTO vsj_id_l, vsjc_id_l, kol_sj_l;
      CLOSE vsj_c;
      IF vsj_id_l IS NULL THEN
        poruka_m := 'VSJ ' || rezvsj_l.vsj_sifra;
        RAISE sifranik;
      END IF;
      
      -- IRN 4085
      IF vanjski_sustav_m = 'PHOBS2' AND creator_ID_p = 'VOICE' AND rezvsj_l.sj_broj IS NOT NULL THEN
        sj_broj_l := rezvsj_l.sj_broj;
        automatski_upis_sj_g := 0;
      ELSE
        sj_broj_l := NULL;
      END IF;

      -- INSERT REZVSJ
      pra_rec_synxis.dodaj_rezervacija_vsj (
            rez_sifra_p         -- SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
          , vanjski_sustav_m    -- VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
          , creator_ID_p        -- creator_id_p IN lsynxis_rezervacije.creator_id%TYPE; dio kljua za PHOBS rezervacije
          , recsosus_sifra_p    -- recsosus_sifra_p IN lsynxis_rezervacije.recsosus_sifra%TYPE; dio kljua za PHOBS rezervacije   
          , rezvsj_id_l         -- REZVSJ_ID_P IN OUT T_REZ_VSJ.ID%TYPE
          , vsj_id_l            -- VSJ_ID_P IN T_REZ_VSJ.VSJ_ID%TYPE
          , vsjc_id_l           -- VSJC_ID_P IN T_REZ_VSJ.VSJC_ID%TYPE
          , kol_sj_l            -- KOL_SJ_P IN T_REZ_VSJ.KOL_SJ%TYPE
          , rezvsj_l.br_osoba   -- BR_OSOBA_P IN T_REZ_VSJ.BR_OSOBA%TYPE
          , sj_broj_l           -- SJ_BROJ_P IN M_SJ.BROJ%TYPE -- IRN 4085
          , provjera_l          -- BRISANJE_P IN NUMBER
          , brojac_l            -- PRVI_REDAK_P IN NUMBER
          , sj_broj_warn_l      -- SJ_BROJ_WARN_P OUT VARCHAR2 -- IRN 4085
          );
          
      -- IRN 4085
      IF sj_broj_warn_l IS NOT NULL THEN
        subject_m := ' (Greka prilikom upisa SJ)';
        poruka_m :=  poruka_m || 'Broj SJ ' || sj_broj_l || ' nije upisan.' ||CHR(10) || sj_broj_warn_l || CHR(10);
      END IF;

      vrati_zapamcenu_sj (rez_sifra_p, creator_ID_p, recsosus_sifra_p, rezvsj_id_l);

      IF vanjski_sustav_m = 'PHOBS2' THEN
      -- za sve rezervacije u kojima je poslan GuaranteeCode=3 oznaiti da usluge plaa agencija -- IRN 3613
        IF rezvsj_l.guaranteeCode = '3' THEN
          placa_gost_l := 0;
        END IF;  
      END IF;

      -- vezivanje uz aranman, moe vrijediti za sve vanjske sustave ako alju ifru aranmana
      IF rezvsj_l.promotionCode IS NOT NULL THEN
        OPEN recara_c (rezvsj_l.promotionCode);
        FETCH recara_c INTO recara_id_l;
        IF recara_id_l IS NULL THEN
          poruka_m := 'aranman ' || rezvsj_l.promotionCode;
          RAISE sifranik;
        END IF;
        CLOSE recara_c;
      END IF;

      -- pripremi usl(c) ako je potrebno
      osn_usluga_id_l := unesi_rezusl (rez_sifra_p, creator_ID_p, recsosus_sifra_p, rezvsj_l.usl_sifra, rezvsj_l.usl_person, recara_id_l, placa_gost_l);
      unesi_supp (rez_sifra_p, creator_ID_p, recsosus_sifra_p, rezvsj_l.supplements, ms_id_p, so_id_p, rez_datdol_p, osn_usluga_id_l, rezvsj_l.iznos, recara_id_l, placa_gost_l);

      unesi_rezgost (rez_sifra_p, creator_ID_p, recsosus_sifra_p, rezvsj_id_l, rezvsj_l.guests, rezvsj_l.dobGrupe);

      -- rasporedi po rezvsj (jesu li upisane sve usluge?)
      pra_rec_synxis.rasporedi_osobe_i_usluge (
            rez_sifra_p         -- SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
          , vanjski_sustav_m    -- VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
          , creator_ID_p        -- creator_id_p IN lsynxis_rezervacije.creator_id%TYPE; dio kljua za PHOBS rezervacije
          , recsosus_sifra_p    -- recsosus_sifra_p IN lsynxis_rezervacije.recsosus_sifra%TYPE; dio kljua za PHOBS rezervacije   
          , rezvsj_id_l         -- REZVSJ_ID_P IN NUMBER := NULL
          , poruka_sj_m         -- IRN 3372
          , unos_korisnik_l);

      poruka_m := poruka_m || poruka_sj_m; -- IRN 3372

      unesi_rezcje (rez_sifra_p, creator_ID_p, recsosus_sifra_p, rez_id_p, vsjc_id_l, rezvsj_l.usl_sifra, rezvsj_l.dayPrices, 
                    rezvsj_l.supplements, rez_datdol_p, rez_datodl_p, rezvsj_l.iznos, marketcode_p,
                    unos_korisnik_l);

    END IF;

    FETCH rezvsj_c INTO rezvsj_l;
  END LOOP;

  CLOSE rezvsj_c;

EXCEPTION
  WHEN razdoblja THEN
    poruka_m := 'Razdoblja rezerviranja VSJ ne mogu biti razliita od boravka po rezervaciji.';
    RAISE;

  WHEN sifranik THEN
    poruka_m := 'Podatak ne postoji: ' || poruka_m || '.';
    RAISE;

  WHEN OTHERS THEN
    RAISE;

END;
PROCEDURE UNESI_SUPP
 (REZ_SIFRA_P IN LSYNXIS_REZERVACIJE.SYNXIS_SIFRA%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,XMLREZSUPP_P IN CLOB
 ,MS_ID_P IN T_REZERVACIJE.MS_ID%TYPE
 ,SO_ID_P IN T_REZERVACIJE.SO_ID%TYPE
 ,DAT_DOLASKA_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,USL_ID_P IN S_USLUGE.ID%TYPE
 ,IZNOS_BP_P IN VARCHAR2
 ,RECARA_ID_P IN MREC_ARANZMANI.ID%TYPE
 ,PLACA_GOST_P IN T_REZ_USL.OZN_PLATITELJA%TYPE
 )
 IS
--
  sifranik EXCEPTION;

  CURSOR usl_c (sifra_k mzmp_usl_sus.sifra%TYPE) IS
    SELECT usl_id
      FROM mzmp_usl_sus
     WHERE UPPER (sifra) = UPPER (sifra_k)
       AND zmpsus_id = (SELECT id
                          FROM szmp_sustavi
                         WHERE sifra = vanjski_sustav_m);
  usl_id_l s_usluge.id%TYPE;
  kol_usl_l NUMBER(2);

  rezsupp_c     SYS_REFCURSOR;
  rezcjesupp_l  supplement_r;

  iznos_bp_l    trec_rez_cjeusl.cijena_usluge%TYPE;
  uslc_id_l     s_usluge.id%TYPE;
  
  supp_c        SYS_REFCURSOR;
  
  s_usl_id_l    s_usluge.id%TYPE;
  s_usl_sifra_l s_usluge.sifra%TYPE;
  s_usl_id1_l   s_usluge.id%TYPE;

-- IRN 3459
  s_usl_idBP_l s_usluge.id%TYPE;
  s_usl_idEP_l s_usluge.id%TYPE;
-- K IRN 3459
  
  query_l       VARCHAR2(32000);
BEGIN

  OPEN rezsupp_c FOR rezvanjsus_string ('REZSUPP') USING xmlrezsupp_p;
  FETCH rezsupp_c INTO rezcjesupp_l;

  WHILE rezsupp_c%FOUND LOOP
    kol_usl_l := NULL;

    -- odredi usl_id
    usl_id_l := NULL;
    OPEN usl_c (rezcjesupp_l.usl_sifra);
    FETCH usl_c INTO usl_id_l;
    CLOSE usl_c;
    IF usl_id_l IS NULL THEN
      poruka_m := 'USL ' || rezcjesupp_l.usl_sifra;
      RAISE sifranik;
    END IF;

    IF vanjski_sustav_m = 'PHOBS2' AND rezcjesupp_l.tip LIKE 'Per person%' THEN
      kol_usl_l := 1;
    ELSIF NVL(rezcjesupp_l.kol, 0) <> 0 THEN
      kol_usl_l := rezcjesupp_l.kol;
    ELSIF NVL(rezcjesupp_l.br_osoba, 0) <> 0 THEN
      kol_usl_l := rezcjesupp_l.br_osoba;
    ELSE
      kol_usl_l := 1;
    END IF;

    IF lower(rezcjesupp_l.inclusive) = 'true' THEN
      uslc_id_l := usl_id_p;
    ELSE
      uslc_id_l := NULL;
    END IF;

    FOR i IN 1..kol_usl_l LOOP
      -- INSERT REZUSL
      pra_rec_synxis.dodaj_rezervacija_usluga (
            rez_sifra_p         -- SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
          , vanjski_sustav_m    -- VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
          , creator_ID_p        -- creator_id_p IN lsynxis_rezervacije.creator_id%TYPE; dio kljua za PHOBS rezervacije
          , recsosus_sifra_p    -- recsosus_sifra_p IN lsynxis_rezervacije.recsosus_sifra%TYPE; dio kljua za PHOBS rezervacije   
          , usl_id_l            -- USL_ID_P IN T_REZ_USL.USL_ID%TYPE
          , NULL                -- SAS_ID_P IN T_REZ_USL.SAS_ID%TYPE
          , uslc_id_l           -- USL_ID1_P IN T_REZ_USL.USL_ID1%TYPE
          , recara_id_p         -- RECARA_ID_P IN T_REZ_USL.RECARA_ID%TYPE
          , NULL                -- DAT_POC_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
          , NULL                -- DAT_ZAV_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
          , placa_gost_p        -- PLACA_GOST_P IN T_REZ_GUSL.OZN_PLATITELJA%TYPE
          );
    END LOOP;

    FETCH rezsupp_c INTO rezcjesupp_l;
  END LOOP;

  CLOSE rezsupp_c;

  -- IRN 3459
  -- odredi usl_id BP i EK
  s_usl_idBP_l := NULL;
  OPEN usl_c ('BP');
  FETCH usl_c INTO s_usl_idBP_l;
  CLOSE usl_c;
  s_usl_idEP_l := NULL;
  OPEN usl_c ('EP');
  FETCH usl_c INTO s_usl_idEP_l;
  CLOSE usl_c;
  IF vanjski_sustav_m = 'PHOBS2' AND
    s_usl_idBP_l IS NULL AND   -- ako EP nije ifrirana, nema veze, ali za BP javi greku
    iznos_bp_p IS NOT NULL
  THEN
     poruka_m := 'USL BP';
     RAISE sifranik;
  END IF;    

  -- IRN 3459 u query_l izmijenjena prva dva selecta
  -- u drugom selectu se BP nadodaje iz podataka u xml-u za PHOBS2; BP je u xml-u ako iznos_bp_p nije null

  query_l :=
   'SELECT msusl.usl_id    usl_id,
           usl.sifra       usl_sifra,
           CASE
             WHEN msusl.usl_id = ' || NVL (s_usl_idBP_l, 0) || ' OR msusl.usl_id =  ' || NVL (s_usl_idEP_l, 0) || '
               THEN DECODE (' || NVL(iznos_bp_p, 'NULL') || ',
                       NULL, TO_NUMBER(NULL),
                       DECODE (TO_NUMBER(''' || NVL(iznos_bp_p, 'NULL') || ''', ''999999.09''),
                               0, ' || usl_id_p || ',
                               TO_NUMBER(NULL)))
             ELSE NULL
           END usl_id1
      FROM m_ms_usl msusl,
           s_usluge usl
     WHERE msusl.ms_id = ' || ms_id_p || '
       AND msusl.usl_id = usl.id
       AND usl.dat_valjan <= NVL (TO_DATE(''' || to_char(dat_dolaska_p, 'dd.mm.rrrr') || ''',''dd.mm.rrrr''), SYSDATE)
       AND NVL (usl.dat_ponisten, TO_DATE (''31.12.9999'', ''DD.MM.RRRR'')) >
           NVL (TO_DATE(''' || to_char(dat_dolaska_p, 'dd.mm.rrrr') || ''',''dd.mm.rrrr''), TO_DATE (''01.01.0001'', ''DD.MM.RRRR''))
       AND usl.id IN (SELECT usl_id FROM mrec_so_usl WHERE so_id = ' || so_id_p || ')
    UNION
    SELECT uslsus.usl_id    usl_id,
           usl.sifra       usl_sifra,
           DECODE (' || NVL(iznos_bp_p, 'NULL') || ',
                       NULL, TO_NUMBER(NULL),
                       DECODE (TO_NUMBER(''' || NVL(iznos_bp_p, 'NULL') || ''', ''999999.09''),
                               0, ' || usl_id_p || ',
                               TO_NUMBER(NULL))
                  )
             usl_id1
      FROM mzmp_usl_sus uslsus,
           s_usluge usl
     WHERE uslsus.sifra IN (''BP'', ''EP'')
       AND ''' || vanjski_sustav_m || ''' = ''PHOBS2''    
       AND uslsus.zmpsus_id = (SELECT id
                                  FROM szmp_sustavi
                                 WHERE sifra = ''' || vanjski_sustav_m || ''') 
       AND ''' || NVL (iznos_bp_p, 'XX')  || ''' <> ''XX''
       AND uslsus.usl_id = usl.id
       AND usl.dat_valjan <= NVL (TO_DATE(''' || to_char(dat_dolaska_p, 'dd.mm.rrrr') || ''',''dd.mm.rrrr''), SYSDATE)
       AND NVL (usl.dat_ponisten, TO_DATE (''31.12.9999'', ''DD.MM.RRRR'')) >
           NVL (TO_DATE(''' || to_char(dat_dolaska_p, 'dd.mm.rrrr') || ''',''dd.mm.rrrr''), TO_DATE (''01.01.0001'', ''DD.MM.RRRR''))
       AND usl.id IN (SELECT usl_id FROM mrec_so_usl WHERE so_id = ' || so_id_p || ')     
    UNION
    SELECT recarausl.usl_id  usl_id,
           usl.sifra         usl_sifra,
           recarausl.usl_id1 usl_id1
      FROM mrec_ara_usl recarausl, s_usluge usl
     WHERE usl.id = recarausl.usl_id
       AND recarausl.usl_id IN (SELECT usl_id FROM mrec_so_usl recsousl WHERE recsousl.so_id = ' || so_id_p || ')
       AND pra_rec_s.usl_je_bp (recarausl.usl_id) = 0
       AND usl.ozn_osnovna = 0
       AND recarausl.recara_id = ' || NVL(TO_CHAR(recara_id_p), 'NULL') || '
   MINUS
    SELECT zmpuslsus.usl_id,
           usl.sifra,
           DECODE (supp.inclusive, ''true'', ' || usl_id_p || ', NULL) usl_id1
      FROM mzmp_usl_sus zmpuslsus,
           s_usluge usl,
           (' || rezvanjsus_string ('REZSUPP') || ') supp
     WHERE UPPER (supp.usl_sifra) = UPPER (zmpuslsus.sifra)
       AND zmpuslsus.zmpsus_id = (SELECT id from szmp_sustavi WHERE sifra = ''' || vanjski_sustav_m || ''')
       AND zmpuslsus.usl_id = usl.id';

  -- dbms_output.put_line ('------- query_l=');
  -- dbms_output.put_line (query_l);
  -- dbms_output.put_line ('------- xmlrezsupp_p=');
  -- dbms_output.put_line (xmlrezsupp_p);

  OPEN supp_c FOR query_l USING xmlrezsupp_p;
  FETCH supp_c INTO s_usl_id_l, s_usl_sifra_l, s_usl_id1_l;
  
  WHILE supp_c%FOUND LOOP
    
    IF s_usl_id_l IS NOT NULL THEN  --moe biti samo za EP
      pra_rec_synxis.dodaj_rezervacija_usluga (
            rez_sifra_p         -- SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
          , vanjski_sustav_m    -- VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
          , creator_ID_p        -- creator_id_p IN lsynxis_rezervacije.creator_id%TYPE; dio kljua za PHOBS rezervacije
          , recsosus_sifra_p    -- recsosus_sifra_p IN lsynxis_rezervacije.recsosus_sifra%TYPE; dio kljua za PHOBS rezervacije   
          , s_usl_id_l          -- USL_ID_P IN T_REZ_USL.USL_ID%TYPE
          , NULL                -- SAS_ID_P IN T_REZ_USL.SAS_ID%TYPE
          , s_usl_id1_l         -- USL_ID1_P IN T_REZ_USL.USL_ID1%TYPE
          , recara_id_p         -- RECARA_ID_P IN T_REZ_USL.RECARA_ID%TYPE
          , NULL                -- DAT_POC_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
          , NULL                -- DAT_ZAV_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
          --, -1                  -- PLACA_GOST_P IN T_REZ_GUSL.OZN_PLATITELJA%TYPE  -- IRN 3613
          , CASE WHEN s_usl_id1_l IS NOT NULL THEN placa_gost_p ELSE -1 END
        );  
    END IF;
    
    FETCH supp_c INTO s_usl_id_l, s_usl_sifra_l, s_usl_id1_l;
  
  END LOOP;
  CLOSE supp_c;
    
EXCEPTION
  WHEN sifranik THEN
    poruka_m := 'Podatak ne postoji: ' || poruka_m || '.';
    RAISE;

END;
PROCEDURE DOHVATI_REZERVACIJE_MT
 (VLASNIKPODATKA_P IN NUMBER := NULL
 ,SO_ID_P IN NUMBER := NULL
 ,SAMO_IZMIJENJENE_P IN NUMBER := -1
 ,DAT_POC_P IN DATE := NULL
 ,DAT_ZAV_P IN DATE := NULL
 ,DEBUG_P IN NUMBER := 0
 )
 IS
--
BEGIN
  pra_zmp_context.set_vlasnikpodatka (vlasnikpodatka_p);
  vanjski_sustav_m := UPPER(pra_zmp_zaj.zmppar_vrijednost ('REC', '1136'));
  pra_rezvanjsus.dohvati_rezervacije (so_id_p, samo_izmijenjene_p, dat_poc_p, dat_zav_p, debug_p);
EXCEPTION
  WHEN OTHERS THEN
    RAISE;
END;
PROCEDURE ARHIVIRAJ_XML
 (NAZIV_P IN VARCHAR2
 ,XML_P IN CLOB
 ,PORUKA_P IN VARCHAR2
 )
 IS
--
 br_dana_l        szmp_parametri.vrijednost%TYPE;
BEGIN
  br_dana_l := pra_zmp_zaj.zmppar_vrijednost('PHOBS2', '1008');

  IF UPPER(br_dana_l) = '0' THEN
    RETURN; -- ne spremaju se (i ne briu)
  
  ELSE
    DELETE FROM lrec_xml
     WHERE TRUNC(SYSDATE) - TRUNC(unos_dat) >= TO_NUMBER(br_dana_l);
    
    INSERT INTO LREC_XML (naziv, data, poruka)
      VALUES
      (naziv_p, xml_p, poruka_p);
    
    COMMIT;

  END IF;

END;
PROCEDURE ODREDI_AGE_I_MS
 (CREATORID_P IN VARCHAR2
 ,AGENCIJA_P IN VARCHAR2
 ,MARKETCODE_P IN VARCHAR2
 ,RECVPRO_ID_P IN MREC_VPROGRAMA.ID%TYPE
 ,AGE_ID_P IN OUT M_AGENCIJE.ID%TYPE
 ,MS_ID_P IN OUT M_MSEGMENTI.ID%TYPE
 )
 IS
--
  sifranik EXCEPTION;

  CURSOR age_c (sifra_k mrec_age_sus.sifra%TYPE) IS
    SELECT age_id, ms_id
      FROM mrec_age_sus
     WHERE UPPER(sifra) = UPPER(sifra_k)
       AND zmpsus_id = (SELECT id
                          FROM szmp_sustavi
                         WHERE sifra = vanjski_sustav_m);
  age_id_l m_agencije.id%TYPE;
  
  CURSOR ms_c (paramSifra_k IN VARCHAR2) IS
    SELECT id
      FROM m_msegmenti
     WHERE sifra = pra_zmp_zaj.zmppar_vrijednost (vanjski_sustav_m, paramSifra_k);
  ms_id_l m_msegmenti.id%TYPE;
  age_ms_id_l m_msegmenti.id%TYPE;
BEGIN
  IF vanjski_sustav_m IN ('SIMPLEBOOKING', 'ROOMCLOUD') THEN  
    
    OPEN age_c (agencija_p);
    FETCH age_c INTO age_id_p, ms_id_l;
    CLOSE age_c;
        
    IF ms_id_l IS NULL THEN
      OPEN ms_c ('1002');
      FETCH ms_c INTO ms_id_l;
      CLOSE ms_c;
    END IF;         
        
    IF ms_id_l IS NULL THEN
      poruka_m := 'MS, provjeriti parametar ' || vanjski_sustav_m || ' 1002';
      RAISE sifranik;
    END IF;  
  
  ELSIF vanjski_sustav_m = 'PHOBS2' THEN
    
    IF recvpro_id_p IS NOT NULL THEN
      OPEN ms_c ('1014');
      FETCH ms_c INTO ms_id_l;
      CLOSE ms_c;
    END IF;

    OPEN age_c (agencija_p);
    FETCH age_c INTO age_id_p, age_ms_id_l;
    CLOSE age_c;
    
    age_id_l := age_id_p; -- pod-agencija

    IF age_id_p IS NULL THEN
      IF creatorID_p IS NOT NULL THEN
        OPEN age_c (creatorID_p);
        FETCH age_c INTO age_id_p, age_ms_id_l;
        CLOSE age_c;
      END IF;                
    END IF;
    
    IF ms_id_l IS NULL THEN  -- ako MS nije po RECVPRO,
      ms_id_l := age_ms_id_l;  -- uzmi MS iz pod-agencije
    END IF;

    -- ADS rezervacije
    IF ms_id_l IS NULL AND marketCode_p = 'ADS' THEN
      OPEN ms_c ('1013');
      FETCH ms_c INTO ms_id_l;
      CLOSE ms_c;
    END IF;
       
    IF ms_id_l IS NULL THEN
      IF creatorID_p = 'VOICE' AND age_id_l IS NOT NULL THEN
        OPEN ms_c ('1015');
        FETCH ms_c INTO ms_id_l;
        CLOSE ms_c;
      ELSIF creatorID_p = 'VOICE' AND age_id_l IS NULL THEN
        OPEN ms_c ('1016');
        FETCH ms_c INTO ms_id_l;
        CLOSE ms_c;
      ELSIF creatorID_p = 'PHOBS' AND age_id_l IS NOT NULL THEN
        OPEN ms_c ('1017');
        FETCH ms_c INTO ms_id_l;
        CLOSE ms_c;
      ELSIF creatorID_p = 'PHOBS' AND age_id_l IS NULL THEN
        OPEN ms_c ('1018');
        FETCH ms_c INTO ms_id_l;
        CLOSE ms_c;
      END IF;
    END IF;
        
    IF ms_id_l IS NULL THEN
      OPEN ms_c ('1019');
      FETCH ms_c INTO ms_id_l;
      CLOSE ms_c;
    END IF;         
      
    IF ms_id_l IS NULL THEN
      poruka_m := 'MS, provjeriti parametre sustava ' || vanjski_sustav_m;
      RAISE sifranik;
    END IF;  
  END IF;
       
  ms_id_p := ms_id_l;

END;
FUNCTION REPLACEINCLOB
 (OPCLOB IN CLOB
 ,CPREPLACESTR IN VARCHAR2 := UTL_TCP.CRLF
 ,CPREPLACEWITH IN VARCHAR2 := NULL
 )
 RETURN CLOB
 IS
--
  cBuffer    VARCHAR2 (32767);
  nBuffer    BINARY_INTEGER := 25000; --32767; treba uzimati krae dijelove jer e se poveati sa duljim replacewith
  nStart     PLS_INTEGER := 1;
  nLen       PLS_INTEGER;
  oCRtn      CLOB := EMPTY_CLOB;
BEGIN
  DBMS_LOB.CreateTemporary(oCRtn, TRUE);
  nLen := DBMS_LOB.GetLength(opCLob);

  WHILE nStart < nLen LOOP
    DBMS_LOB.Read(opCLob, nBuffer, nStart, cBuffer);
    IF cBuffer IS NOT NULL THEN
      cBuffer := REPLACE(cBuffer, cpReplaceStr, cpReplaceWith);
      DBMS_LOB.WriteAppend(oCRtn, LENGTH(cBuffer), cBuffer);
    END IF;
    nStart := nStart + nBuffer;
  END LOOP;
  RETURN oCRtn;
END;
PROCEDURE POVEZI_REZERVACIJU_MAPA
 (REZ_SIFRA_P IN LSYNXIS_REZERVACIJE.SYNXIS_SIFRA%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,REZ_SIFRA_MAPA_P IN VARCHAR2
 ,PORUKA_SJ_MAPA_P OUT VARCHAR2
 )
 IS
rez_id_l t_rezervacije.id%TYPE;
  rez_sifra_l lsynxis_rezervacije.synxis_sifra%TYPE;
  cvor_l smet_cvorovi.sifra%TYPE;
  tekuci_cvor_l smet_cvorovi.sifra%TYPE;
  target_cvor_l smet_cvorovi.sifra%TYPE;
  select_rezervacija_l VARCHAR2(200) :=
    'SELECT oznaka FROM t_rezervacije<cvor> WHERE id = :rez_id_l';
  update_rezervacija_l VARCHAR2(200) :=
    'UPDATE t_rezervacije<cvor> SET br_uputnice = :rez_sifra_p, creator_id = :creator_id_p WHERE id = :rez_id_l';
  greska_l EXCEPTION;  
  rez_oznaka_l t_rezervacije.oznaka%TYPE;
  CURSOR synxrez_c IS
    SELECT rez_id, synxis_sifra, metcvor_sifra
      FROM lsynxis_rezervacije
     WHERE id = rez_sifra_mapa_p
       AND vanj_sustav = vanjski_sustav_m;
BEGIN
   /*
  vrati podatke iz lsynxis_rezervacije kako bismo znali je li ta rezervacija napravljena preko mape 
  ve upisana u MISH bez veze na PHOBS i treba ju najprije povezati na Phobs  
  */
  OPEN synxrez_c;
  FETCH synxrez_c INTO rez_id_l, rez_sifra_l, cvor_l;
  CLOSE synxrez_c;

  IF rez_id_l IS NULL THEN 
    -- rezervacija sa rez_sifra_mapa_p koji je poslao phobs kod nas ne postoji, Upozorenje
    poruka_sj_mapa_p := 'U-' || rez_sifra_mapa_p;
  ELSIF rez_sifra_l IS NULL THEN -- rezervacija postoji, jo nije povezana na PHOBS
    SELECT sifra_tekuceg_cvora INTO tekuci_cvor_l FROM s_vlasnik;
    IF NOT cvor_l = tekuci_cvor_l THEN
      target_cvor_l := '@' || cvor_l;
    END IF;
    EXECUTE IMMEDIATE REPLACE (select_rezervacija_l, '<cvor>', target_cvor_l) INTO rez_oznaka_l USING rez_id_l;
    IF NVL (rez_oznaka_l, 'P') = 'V' THEN
      -- Valjana, povezati na PHOBS
      UPDATE lsynxis_rezervacije SET synxis_sifra = rez_sifra_p, creator_id = creator_id_p, recsosus_sifra = recsosus_sifra_p WHERE id = rez_sifra_mapa_p;
      EXECUTE IMMEDIATE REPLACE (update_rezervacija_l, '<cvor>', target_cvor_l) USING rez_sifra_p, creator_id_p, rez_id_l;
    ELSE
      -- nije valjana, Upozorenje
      poruka_sj_mapa_p := 'U-' || rez_sifra_mapa_p;
    END IF;
  END IF;
END;
/* pra_rezvanjsus */
PROCEDURE BRISI_BROJ_SJ
 (REZ_ID_P IN T_REZERVACIJE.ID%TYPE
 ,REZ_DAT_POC_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,REZ_DAT_ZAV_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
 ,DAT_POC_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,DAT_ZAV_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
 )
 IS
-- ako su sj automatski dodane u rezvsj a u izmijenjenom razdoblju rezervacije nisu slobodne one se prije izmjene iz rezvsj briu (ako nisu bile fiksirane)
  CURSOR c_stsj (sj_id_k i_statusisj.sj_id%TYPE) IS
           SELECT datum
             FROM i_statusisj
            WHERE sj_id = sj_id_k
              AND datum >= dat_poc_p
              AND datum < dat_zav_p
              AND (datum < rez_dat_poc_p OR datum >= rez_dat_zav_p) --ne smije se kontrolirati datume unutar postojee rezervacije 
              AND (  ozn_i = 3   -- izvan upotrebe
                   OR ozn_u = -1  -- vezana ugovorom o zakupu
                   OR ozn_z > 0   -- zauzeta
                   OR ozn_r > 0)  -- rezervirana
  ;
  
  datum_l i_statusisj.datum%TYPE;

  sifra_param_l szmp_parametri.sifra%TYPE := '1006';
  param_l       szmp_parametri.vrijednost%TYPE;
BEGIN

  param_l := LOWER (pra_zmp_zaj.zmppar_vrijednost (vanjski_sustav_m, sifra_param_l));

  IF NVL (param_l, 'ne') <> 'da' THEN
    RETURN;
  END IF;

  FOR rezvsj_c IN
    (SELECT rezvsj.id id, rezvsj.sj_id, rezvsj.ozn_fiksna_sj
       FROM t_rez_vsj rezvsj,
            t_rezervacije rez
      WHERE rez.id = rez_id_p
        AND rezvsj.rez_id = rez.id)
  LOOP
    IF rezvsj_c.sj_id IS NOT NULL AND rezvsj_c.ozn_fiksna_sj = 0 THEN
      OPEN c_stsj (rezvsj_c.sj_id);
      FETCH c_stsj INTO datum_l;
      IF c_stsj%FOUND THEN
        BEGIN
          UPDATE t_rez_vsj
             SET sj_id = NULL
           WHERE id = rezvsj_c.id;
        EXCEPTION
          WHEN OTHERS THEN
            NULL; -- ne oekujemo greku ali ako se ipak desi je ovdje zanemarujemo, javit e se kasnije da SJ nije slobodna 
        END;
      END IF;
      CLOSE c_stsj;
    END IF;
  END LOOP;

END;
PROCEDURE ZAPAMTI_REZ_ZA_ODG
 (REZ_SIFRA_P IN PREC_GLOBAL.OPIS1%TYPE
 ,CONFIRM_ID_P IN PREC_GLOBAL.OPIS2%TYPE
 ,RBR_STRING_P IN PREC_GLOBAL.OPIS3%TYPE
 )
 IS
BEGIN
    INSERT INTO PREC_GLOBAL (OPIS1, OPIS2, OPIS3)
    VALUES (rez_sifra_p, confirm_id_p, rbr_string_p);
END;

END PRA_REZVANJSUS;
/
SHOW ERROR

