-- C:\Users\dgajic\Desktop\IRN 4124\zahtjev_7511\v2\pra_rec_synxis.pkb
--
-- Generated for Oracle 10g on Tue Dec 30  09:55:17 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'PRA_REC_SYNXIS'
CREATE OR REPLACE PACKAGE BODY PRA_REC_SYNXIS IS

PROCEDURE FIND_REZERVACIJA
 (SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
 ,VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,REZ_ROW_P OUT t_rezervacije%ROWTYPE
 );
PROCEDURE DODAJ_REZERVACIJU
 (SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
 ,VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,SO_ID_P IN T_REZERVACIJE.SO_ID%TYPE
 ,MS_ID_P IN T_REZERVACIJE.MS_ID%TYPE
 ,CJE_ID_P IN T_REZERVACIJE.CJE_ID%TYPE
 ,RECVPRO_ID_P IN T_REZERVACIJE.RECVPRO_ID%TYPE
 ,RECNREZ_ID_P IN T_REZERVACIJE.RECNREZ_ID%TYPE
 ,AGE_ID_P IN T_REZERVACIJE.AGE_ID%TYPE
 ,PONSO_ID_P IN T_REZERVACIJE.PONSO_ID%TYPE
 ,VAL_ID_P IN T_REZERVACIJE.VAL_ID%TYPE
 ,VALR_ID_P IN T_REZERVACIJE.VALR_ID%TYPE
 ,ZEM_ID_P IN T_REZERVACIJE.ZEM_ID%TYPE
 ,JEZ_ID_P IN S_JEZICI.ID%TYPE
 ,RECAGOST_ID_P IN T_REZERVACIJE.RECAGOST_ID%TYPE
 ,GOD_POSLOVNA_P IN T_REZERVACIJE.GOD_POSLOVNA%TYPE
 ,DATUM_P IN T_REZERVACIJE.DATUM%TYPE
 ,TITULA_P IN T_REZERVACIJE.TITULA%TYPE
 ,IME_P IN T_REZERVACIJE.IME%TYPE
 ,PREZIME_P IN T_REZERVACIJE.PREZIME%TYPE
 ,NAZ_ULICE_P IN T_REZERVACIJE.NAZ_ULICE%TYPE
 ,NAZ_MJESTA_P IN T_REZERVACIJE.NAZ_MJESTA%TYPE
 ,NAZ_REGIJE_P IN T_REZERVACIJE.NAZ_REGIJE%TYPE
 ,BR_TELEFONA_P IN T_REZERVACIJE.BR_TELEFONA%TYPE
 ,EMAIL_P IN T_REZERVACIJE.EMAIL%TYPE
 ,WWW_P IN T_REZERVACIJE.WWW%TYPE
 ,NEWSLETTER_P IN T_REZERVACIJE.OZN_NEWSLETTER%TYPE
 ,DAT_DOLASKA_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,SAT_DOLASKA_P IN T_REZERVACIJE.SAT_DOLASKA%TYPE
 ,DAT_ODLASKA_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
 ,OZN_CJE_POSEB_P IN T_REZERVACIJE.OZN_CJE_poseb%TYPE
 ,OZN_B_P IN T_REZERVACIJE.OZN_B%TYPE
 ,OZN_F_P IN T_REZERVACIJE.OZN_F%TYPE
 ,IZN_PREDUJMA_P IN T_REZERVACIJE.IZN_PREDUJMA%TYPE
 ,IZN_REZERVACIJE_P IN T_REZERVACIJE.IZN_REZERVACIJE%TYPE
 ,STOPA_POPUSTA_P IN T_REZERVACIJE.STOPA_POPUSTA%TYPE
 ,OPIS1_P IN T_REZERVACIJE.OPIS1%TYPE
 ,OPIS2_P IN T_REZERVACIJE.OPIS2%TYPE
 ,DAT_KARTICE_P IN T_REZERVACIJE.DAT_KARTICE%TYPE
 ,NAPOMENA_P IN T_REZERVACIJE.NAPOMENA%TYPE
 ,BR_OSOBA1_P IN T_REZERVACIJE.BR_OSOBA1%TYPE
 ,BR_OSOBA2_P IN T_REZERVACIJE.BR_OSOBA2%TYPE
 ,OZN_VIP_P IN T_REZERVACIJE.OZN_VIP%TYPE
 ,OPIS_REZERVACIJE_MJESTA_P IN T_REZERVACIJE.OPIS_REZERVACIJE_MJESTA%TYPE
 ,GUARANTEE_CODE_P IN T_REZERVACIJE.guarantee_code%TYPE
 ,REZ_ID_P OUT T_REZERVACIJE.ID%TYPE
 ,REZ_RBR_P OUT T_REZERVACIJE.RBR%TYPE
 ,REZ_AGENT_P IN T_REZERVACIJE.unos_korisnik%TYPE
 );
PROCEDURE DODAJ_REZ_USLUGA_RECARA
 (SYNXIS_SIFRA_P IN LSYNXIS_REZERVACIJE.SYNXIS_SIFRA%TYPE
 ,VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,USLC_ID_P IN NUMBER := NULL
 );
FUNCTION SAS_ID
 (USL_ID_P IN S_USLUGE.ID%TYPE
 )
 RETURN s_sastojci.id%TYPE;


PROCEDURE FIND_REZERVACIJA
 (SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
 ,VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,REZ_ROW_P OUT t_rezervacije%ROWTYPE
 )
 IS
/*
Trai rezervaciju na osnovu lsynxis_rezervacije.synxis_sifra parametra
Poziva se iz procedure spremi_rezervaciju.

parametar: synxis_sifra_p - CrsReservationNumber. Jedinstveni broj rezervacije u SynXis sustavu
izlazni parametar: rez_row_p t_rezervacije%ROWTYPE
*/

  greska_l EXCEPTION;
  target_cvor_l VARCHAR2(41) := '';
  rez_id_l t_rezervacije.id%TYPE;

  select_rezervacija_l VARCHAR2(200) :=
    'SELECT * FROM t_rezervacije<cvor> WHERE id = :id';
BEGIN
  /*
  find_rezervacija
       (synxis_sifra_p => ..synxis_sifra_p
       ,vanj_sustav_p => ..vanj_sustav_p
       ,creator_id_p => ..creator_id_p
       ,recsosus_sifra_p => ..recsosus_sifra_p
       ,rez_row_p => ..rez_row_l
       );
  */
  /*
  provjeri ulazni parametar
  */
  IF synxis_sifra_p IS NULL THEN
    RAISE greska_l;
  END IF;

  /*
  vrati id i cvor t_rezervacije za zadani broj rezervacije
  */
  vrati_rez_id_cvor
       (synxis_sifra_p => synxis_sifra_p
       ,vanj_sustav_p => vanj_sustav_p
       ,creator_id_p => creator_id_p
       ,recsosus_sifra_p => recsosus_sifra_p
       ,rez_id_p => rez_id_l
       ,target_cvor_p => target_cvor_l
       );

  IF rez_id_l IS NULL THEN
    RETURN;
  END IF;

  EXECUTE IMMEDIATE REPLACE (select_rezervacija_l, '<cvor>', target_cvor_l) INTO rez_row_p USING rez_id_l;

END;
PROCEDURE DODAJ_REZERVACIJU
 (SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
 ,VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,SO_ID_P IN T_REZERVACIJE.SO_ID%TYPE
 ,MS_ID_P IN T_REZERVACIJE.MS_ID%TYPE
 ,CJE_ID_P IN T_REZERVACIJE.CJE_ID%TYPE
 ,RECVPRO_ID_P IN T_REZERVACIJE.RECVPRO_ID%TYPE
 ,RECNREZ_ID_P IN T_REZERVACIJE.RECNREZ_ID%TYPE
 ,AGE_ID_P IN T_REZERVACIJE.AGE_ID%TYPE
 ,PONSO_ID_P IN T_REZERVACIJE.PONSO_ID%TYPE
 ,VAL_ID_P IN T_REZERVACIJE.VAL_ID%TYPE
 ,VALR_ID_P IN T_REZERVACIJE.VALR_ID%TYPE
 ,ZEM_ID_P IN T_REZERVACIJE.ZEM_ID%TYPE
 ,JEZ_ID_P IN S_JEZICI.ID%TYPE
 ,RECAGOST_ID_P IN T_REZERVACIJE.RECAGOST_ID%TYPE
 ,GOD_POSLOVNA_P IN T_REZERVACIJE.GOD_POSLOVNA%TYPE
 ,DATUM_P IN T_REZERVACIJE.DATUM%TYPE
 ,TITULA_P IN T_REZERVACIJE.TITULA%TYPE
 ,IME_P IN T_REZERVACIJE.IME%TYPE
 ,PREZIME_P IN T_REZERVACIJE.PREZIME%TYPE
 ,NAZ_ULICE_P IN T_REZERVACIJE.NAZ_ULICE%TYPE
 ,NAZ_MJESTA_P IN T_REZERVACIJE.NAZ_MJESTA%TYPE
 ,NAZ_REGIJE_P IN T_REZERVACIJE.NAZ_REGIJE%TYPE
 ,BR_TELEFONA_P IN T_REZERVACIJE.BR_TELEFONA%TYPE
 ,EMAIL_P IN T_REZERVACIJE.EMAIL%TYPE
 ,WWW_P IN T_REZERVACIJE.WWW%TYPE
 ,NEWSLETTER_P IN T_REZERVACIJE.OZN_NEWSLETTER%TYPE
 ,DAT_DOLASKA_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,SAT_DOLASKA_P IN T_REZERVACIJE.SAT_DOLASKA%TYPE
 ,DAT_ODLASKA_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
 ,OZN_CJE_POSEB_P IN T_REZERVACIJE.OZN_CJE_poseb%TYPE
 ,OZN_B_P IN T_REZERVACIJE.OZN_B%TYPE
 ,OZN_F_P IN T_REZERVACIJE.OZN_F%TYPE
 ,IZN_PREDUJMA_P IN T_REZERVACIJE.IZN_PREDUJMA%TYPE
 ,IZN_REZERVACIJE_P IN T_REZERVACIJE.IZN_REZERVACIJE%TYPE
 ,STOPA_POPUSTA_P IN T_REZERVACIJE.STOPA_POPUSTA%TYPE
 ,OPIS1_P IN T_REZERVACIJE.OPIS1%TYPE
 ,OPIS2_P IN T_REZERVACIJE.OPIS2%TYPE
 ,DAT_KARTICE_P IN T_REZERVACIJE.DAT_KARTICE%TYPE
 ,NAPOMENA_P IN T_REZERVACIJE.NAPOMENA%TYPE
 ,BR_OSOBA1_P IN T_REZERVACIJE.BR_OSOBA1%TYPE
 ,BR_OSOBA2_P IN T_REZERVACIJE.BR_OSOBA2%TYPE
 ,OZN_VIP_P IN T_REZERVACIJE.OZN_VIP%TYPE
 ,OPIS_REZERVACIJE_MJESTA_P IN T_REZERVACIJE.OPIS_REZERVACIJE_MJESTA%TYPE
 ,GUARANTEE_CODE_P IN T_REZERVACIJE.guarantee_code%TYPE
 ,REZ_ID_P OUT T_REZERVACIJE.ID%TYPE
 ,REZ_RBR_P OUT T_REZERVACIJE.RBR%TYPE
 ,REZ_AGENT_P IN T_REZERVACIJE.unos_korisnik%TYPE
 )
 IS
/*
Dodaje novu rezervaciju u tablicu T_REZERVACIJE u bazu smjestajnog objekta.
Dodaje vezu u LSYNXIS_REZERVACIJE
Poziva se iz procedure spremi_rezervaciju.

parametar: synxis_sifra_p - broj rezervacije u vanjskom sustavu
parametar: so_id_p - id smjetajnog objekta
parametar: ms_id_p - id marketinkog segmenta
parametar: cje_id_p - id cjenika
parametar: recvpro_id_p - id vrste programa
parametar: recnrez_id_p - id naina rezervacije (nije obavezan)
parametar: age_id_p - id agencije (nije obavezan)
parametar: val_id_p - id valute
parametar: god_poslovna_p - poslovna godina
parametar: datum_p - datum unosa rezervacije
parametar: titula_p - titula gosta
parametar: ime_p - ime gosta
parametar: prezime_p - prezime gosta
parametar: naz_ulice_p - adresa gosta
parametar: naz_regije_p - naziv regije gosta
parametar: email_p - e-mail gosta
parametar: www_p - url gosta
parametar: dat_dolaska_p - datum dolaska gosta
parametar: sat_dolaska_p - sat dolaska gosta
parametar: dat_odlaska_p - datum odlaska gosta
parametar: ozn_cje_poseb_p - :11
parametar: ozn_b_p - :12
parametar: ozn_f_p - :13
parametar: izn_predujma_p - iznos predujma
parametar: opis1_p - :14
parametar: opis2_p - :15
parametar: dat_kartice_p - datum valjanosti kartice
parametar: napomena_p - napomena
parametar: br_osoba1_p - :16
parametar: br_osoba2_p - :17
izlazni parametar: rez_id_p - id nove rezervacije
izlazni parametar: rez_rbr_p - redni broj nove rezervacije
*/

  greska_l EXCEPTION;
  cvor_l m_so.metcvor_sifra%TYPE;
  tekuci_cvor_l m_so.metcvor_sifra%TYPE;
  target_cvor_l VARCHAR2(41) := '';
  recagost_id_l t_rezervacije.recagost_id%TYPE;
  za_uputnicu_l t_rezervacije.br_uputnice%TYPE;
  br_redaka_l NUMBER;
  naredba_l VARCHAR2(1000);
  insert_rezervacija_l VARCHAR2(2000) :=
    'INSERT INTO t_rezervacije<cvor> (
        so_id, ms_id, cje_id,
        recvpro_id, recnrez_id, age_id,
        ponso_id, val_id, valr_id, zem_id, recagost_id,
        god_poslovna, ozn_valjanosti, datum,
        titula, ime, prezime,
        naz_ulice, naz_mjesta, naz_regije,
        email, www, dat_dolaska,
        sat_dolaska, dat_odlaska, ozn_cje_poseb,
        ozn_b, ozn_f, izn_predujma, izn_rezervacije,
        stopa_popusta, opis1, opis2,
        dat_kartice, napomena2, br_osoba1,
        br_osoba2, oznaka, ozn_vip,
        br_uputnice, id, dat_opcije,
        br_telefona, ozn_newsletter,
        unos_korisnik, unos_dat, jez_id, zemd_id,
        opis_rezervacije_mjesta, creator_id, guarantee_code)
      VALUES (
        :1, :2, :3,
        :4, :5, :6,
        :7, :8, :9,
        :10, :11, :12,
        :13, :14, :15,
        :16, :17, :18,
        :19, :20, :21,
        :22, :23, :24,
        :25, :26, :27,
        :28, :29, :30,
        :31, :32, :33,
        :34, :35, :36,
        :37, :38, :39,
        :40, :41, :42,
        :43, :44, :45,
        :46, :47, :48,
        :49, :50, :51
        )';
  age_id_l         m_agencije.id%TYPE; -- IRN 2256
  ms_ozn_ugovora_l m_msegmenti.ozn_ugovora%TYPE; -- IRN 2256
  dat_opcije_l     t_rezervacije.dat_opcije%TYPE;
  unos_korisnik_l  m_korisnici.naziv%TYPE := zmp_zaj.korisnik (-1);
BEGIN
  IF vanj_sustav_p = 'PHOBS2' THEN
    IF rez_agent_p IS NOT NULL THEN -- IRN 3936
      unos_korisnik_l := 'PHOBS' || ' ' || UPPER(rez_agent_p);
    ELSE
      unos_korisnik_l := 'PHOBS';
    END IF;
  END IF;

  /*
  provjeri ulazni parametar
  */
  IF synxis_sifra_p IS NULL THEN
    RAISE greska_l;
  END IF;

  /*
  vrati sifru cvora baze
  */
  SELECT sifra_tekuceg_cvora INTO tekuci_cvor_l FROM s_vlasnik;

  /*
  vrati sifru cvora smjestajnog objekta (dblink)
  */
  SELECT metcvor_sifra INTO cvor_l FROM m_so WHERE id = so_id_p;
  IF NOT cvor_l = tekuci_cvor_l THEN
    target_cvor_l := '@' || cvor_l;
  END IF;

  /*
  vrati id nove rezervacije
  */
  EXECUTE IMMEDIATE REPLACE ('SELECT pra_rec_zaj.sekvenca<cvor> (NULL) FROM dual', '<cvor>', target_cvor_l)
    INTO rez_id_p;
  IF rez_id_p IS NULL THEN
    RAISE greska_l;
  END IF;

  IF vanj_sustav_p IN ('PHOBS2', 'ROOMCLOUD', 'SIMPLEBOOKING') THEN
    za_uputnicu_l := synxis_sifra_p;
  END IF;

  /* 19.07.2011. ne mogu biti dva gosta iz arhive u istom razdoblju */
  IF recagost_id_p IS NOT NULL THEN
    naredba_l :=
      'SELECT COUNT (id) ' ||
      '  FROM t_rezervacije' || target_cvor_l ||
      ' WHERE oznaka = ''V'' ' ||
      '   AND recagost_id = :recagost_id_p ' ||
      '   AND dat_dolaska <= :dat_odlaska_p ' ||
      '   AND dat_odlaska >= :dat_dolaska_p ';
    EXECUTE IMMEDIATE naredba_l INTO br_redaka_l USING recagost_id_p, dat_odlaska_p, dat_dolaska_p;
    IF br_redaka_l = 0 THEN
      recagost_id_l := recagost_id_p;
    END IF;
  END IF;

  -- IRN 2256; popravi age_id
  IF age_id_p IS NOT NULL THEN
    age_id_l := age_id_p;
  ELSE
    SELECT MIN (ozn_ugovora) INTO ms_ozn_ugovora_l FROM m_msegmenti WHERE id = ms_id_p;
    IF ms_ozn_ugovora_l = 0 THEN
      age_id_l := age_id_p;
    ELSE
      SELECT MIN (id) INTO age_id_l FROM m_agencije WHERE sifra = pra_zmp_zaj.zmppar_vrijednost ('IRS', '1001');
    END IF;
  END IF;

  IF ozn_f_p = '0' THEN
    IF UPPER (vanj_sustav_p) = 'PHOBS2' AND UPPER (pra_zmp_zaj.zmppar_vrijednost ('PHOBS2', '1012')) <> 'NEBITNO' THEN
      dat_opcije_l := TRUNC(SYSDATE) + TO_NUMBER(pra_zmp_zaj.zmppar_vrijednost ('PHOBS2', '1012'));
    END IF;
  END IF;

  /*
  puni t_rezervacije
  */
  EXECUTE IMMEDIATE REPLACE (insert_rezervacija_l, '<cvor>', target_cvor_l)
    USING
        so_id_p
       ,ms_id_p
       ,cje_id_p
       ,recvpro_id_p
       ,recnrez_id_p
       ,age_id_l -- IRN 2256
       ,ponso_id_p
       ,val_id_p
       ,valr_id_p
       ,zem_id_p
       ,recagost_id_l
       ,god_poslovna_p
       ,'V'
       ,datum_p
       ,titula_p
       ,ime_p
       ,prezime_p
       ,naz_ulice_p
       ,naz_mjesta_p
       ,naz_regije_p
       ,email_p
       ,www_p
       ,dat_dolaska_p
       ,sat_dolaska_p
       ,dat_odlaska_p
       ,ozn_cje_poseb_p
       ,ozn_b_p
       ,ozn_f_p
       ,izn_predujma_p
       ,izn_rezervacije_p
       ,stopa_popusta_p
       ,opis1_p
       ,opis2_p
       ,dat_kartice_p
       ,napomena_p
       ,br_osoba1_p
       ,br_osoba2_p
       ,'V'
       ,ozn_vip_p
       ,za_uputnicu_l
       ,rez_id_p
       ,dat_opcije_l
       ,br_telefona_p
       ,newsletter_p
       ,unos_korisnik_l
       ,SYSDATE
       ,jez_id_p
       ,zem_id_p
       ,opis_rezervacije_mjesta_p
       ,creator_id_p
       ,guarantee_code_p;

  /*
  vrati rbr nove rezervacije
  */
  EXECUTE IMMEDIATE REPLACE ('SELECT rbr FROM t_rezervacije<cvor> WHERE id = :1', '<cvor>', target_cvor_l)
     INTO rez_rbr_p
    USING rez_id_p;

  /*
  puni lsynxis_rezervacije
  */
  INSERT INTO lsynxis_rezervacije (
      synxis_sifra,
      vanj_sustav,
      metcvor_sifra,
      rez_id,
      creator_id,
      recsosus_sifra)
    VALUES (
      synxis_sifra_p,
      vanj_sustav_p,
      cvor_l,
      rez_id_p,
      DECODE (vanj_sustav_p, 'PHOBS2', creator_id_p, NULL),
      DECODE (vanj_sustav_p, 'PHOBS2', recsosus_sifra_p, NULL)
     );

  EXECUTE IMMEDIATE REPLACE ('BEGIN pra_rec_synxis.dodaj_pkapd<cvor> (:rez_id, :napomena); END;', '<cvor>', target_cvor_l)
    USING rez_id_p, napomena_p;

  IF vanj_sustav_p IN ('PHOBS2') THEN
    EXECUTE IMMEDIATE REPLACE ('BEGIN pra_rec_synxis.azu_ppord<cvor> (:rez_id, :br_uputnice, :creator_id); END;', '<cvor>', target_cvor_l)
      USING rez_id_p, synxis_sifra_p, creator_id_p;
  END IF;
END;
PROCEDURE DODAJ_REZ_USLUGA_RECARA
 (SYNXIS_SIFRA_P IN LSYNXIS_REZERVACIJE.SYNXIS_SIFRA%TYPE
 ,VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,USLC_ID_P IN NUMBER := NULL
 )
 IS
/*
Trai pripadajue rezervirane usluge za rezervaciju
Poziva se iz procedure dodaj_rezervacija_vsj.

parametar: synxis_sifra_p - CRSReservationNumber. Jedinstveni broj rezervacije u SynXis sustavu
*/

  rez_id_l t_rez_vsj.rez_id%TYPE;
  target_cvor_l VARCHAR2(41) := '';
  select_usl1_recara_l VARCHAR2(4000) :=
    'SELECT rezusl.usl_id, rezusl.recara_id, rezusl.dat_poc, rezusl.dat_zav FROM t_rez_usl<cvor> rezusl, s_usluge<cvor> usl ' ||
    ' WHERE rez_id = <id> AND rezusl.usl_id = usl.id' ||
    '   AND pra_rec_s.usl_je_bp (rezusl.usl_id) = 0 ' ||
    ' ORDER BY ozn_osnovna, (SELECT COUNT(*) FROM trec_rez_cjeusl<cvor> WHERE rez_id = <id> AND usl_id = rezusl.usl_id) DESC';
  select_usluge_l VARCHAR2(1000) :=
    'SELECT recarausl.usl_id, recarausl.usl_id1 FROM mrec_ara_usl<cvor> recarausl, s_usluge<cvor> usl '||
    ' WHERE usl.id = recarausl.usl_id' ||
    '   AND recarausl.usl_id NOT IN (SELECT usl_id FROM t_rez_usl<cvor> WHERE rez_id = <id>)' ||
    '   AND recarausl.usl_id IN (SELECT usl_id FROM mrec_so_usl<cvor> recsousl, t_rezervacije<cvor> rez WHERE recsousl.so_id = rez.so_id AND rez.id = <id>)' ||
    '   AND pra_rec_s.usl_je_bp (recarausl.usl_id) = 0' ||
    '   AND usl.ozn_osnovna = 0' ||
    '   AND recara_id = <recara_id>' ||
    '   AND recarausl.ozn_sum = -1' ||
    '   AND (:usl1 IS NOT NULL AND (recarausl.usl_id1 IS NULL OR recarausl.usl_id1 = :usl2)
             OR :usl3 IS NULL)';
  count_usluge_l VARCHAR2(1000) :=
    'SELECT COUNT(*) FROM t_rez_usl<cvor> WHERE rez_id = <id> AND recara_id IS NOT NULL';
  greska_l EXCEPTION;
BEGIN
  IF vanj_sustav_p <> 'PHOBS2' THEN
    RETURN;
  END IF;

  /*
  provjeri ulazni parametar
  */
  IF synxis_sifra_p IS NULL THEN
    RAISE greska_l;
  END IF;

  /*
  vrati id i cvor t_rezervacije za zadani broj rezervacije
  */
  vrati_rez_id_cvor
       (synxis_sifra_p => synxis_sifra_p
       ,vanj_sustav_p => vanj_sustav_p
       ,creator_id_p => creator_id_p
       ,recsosus_sifra_p => recsosus_sifra_p
       ,rez_id_p => rez_id_l
       ,target_cvor_p => target_cvor_l
       );

  DECLARE
    usl1_recara_rc REF_CURSOR;
    usluge_rc REF_CURSOR;
    count_l NUMBER;
    usl_id_l s_usluge.id%TYPE;
    usl1_id_l s_usluge.id%TYPE;
    recara_usl1_id_l s_usluge.id%TYPE;
    recara_id_l mrec_aranzmani.id%TYPE;
    dat_poc_l t_rez_usl.dat_poc%TYPE;
    dat_zav_l t_rez_usl.dat_zav%TYPE;
  BEGIN
    /* provjeri ako ima usluga sa aranmanom */
    EXECUTE IMMEDIATE REPLACE (REPLACE (count_usluge_l, '<id>', rez_id_l), '<cvor>', target_cvor_l)
      INTO count_l;

    IF count_l = 0 THEN
      RETURN;
    END IF;

    /* dohvat aranmana */
    OPEN usl1_recara_rc FOR REPLACE (REPLACE (select_usl1_recara_l, '<id>', rez_id_l), '<cvor>', target_cvor_l);
    FETCH usl1_recara_rc INTO usl1_id_l, recara_id_l, dat_poc_l, dat_zav_l;
    IF usl1_recara_rc%NOTFOUND OR recara_id_l IS NULL THEN
      RETURN;
    END IF;
    CLOSE usl1_recara_rc;

    OPEN usluge_rc
      FOR REPLACE (REPLACE (REPLACE (select_usluge_l, '<recara_id>', recara_id_l), '<id>', rez_id_l), '<cvor>', target_cvor_l)
      USING uslc_id_p, uslc_id_p, uslc_id_p;
    LOOP   -- loop through the two tables and get pairs of numbers
      FETCH usluge_rc INTO usl_id_l, recara_usl1_id_l;
      IF usluge_rc%NOTFOUND THEN
        EXIT;
      END IF;
      dodaj_rezervacija_usluga (synxis_sifra_p, vanj_sustav_p, creator_ID_p, recsosus_sifra_p, usl_id_l, NULL, recara_usl1_id_l, recara_id_l, dat_poc_l, dat_zav_l, -1);
    END LOOP;
    CLOSE usluge_rc;
  END;
END;
PROCEDURE DODAJ_REZERVACIJA_VSJ
 (SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
 ,VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,REZVSJ_ID_P IN OUT T_REZ_VSJ.ID%TYPE
 ,VSJ_ID_P IN T_REZ_VSJ.VSJ_ID%TYPE
 ,VSJC_ID_P IN T_REZ_VSJ.VSJC_ID%TYPE
 ,KOL_SJ_P IN T_REZ_VSJ.KOL_SJ%TYPE
 ,BR_OSOBA_P IN T_REZ_VSJ.BR_OSOBA%TYPE
 ,SJ_BROJ_P IN M_SJ.BROJ%TYPE
 ,BRISANJE_P IN NUMBER
 ,PRVI_REDAK_P IN NUMBER
 ,SJ_BROJ_WARN_P OUT VARCHAR2
 )
 IS
/*
Dodaje rezervaciju vrsta smjetajnih jedinica u tablicu T_REZ_VSJ u bazu smjestajnog objekta.

parametar: synxis_sifra_p - broj rezervacije u vanjskom sustavu
parametar: vsj_id_p - id vrste smjetajnih jedinica
parametar: vsjc_id_p - id cjenovne vrste smjetajnih jedinica
parametar: kol_sj_p - koliina smjetajnih jedinica promatrane vrste SJ
parametar: br_osoba_p - broj osoba za koje se rezervira promatrana vrsta SJ
parametar: sj_broj_p - broj smjetajne jedinice
*/

  rez_id_l t_rez_vsj.rez_id%TYPE;
  target_cvor_l VARCHAR2(41) := '';
  select_rezervacija_vsj_l VARCHAR2(2000) :=
    'SELECT id FROM t_rez_vsj<cvor> x WHERE
       rez_id = :1 AND vsj_id = :2 AND vsjc_id = :3
       AND kol_sj = :4 AND br_osoba = :5
       AND (SELECT count(*) FROM t_rez_vsj<cvor> y WHERE y.rez_id = x.rez_id) = 1';

  insert_rezervacija_vsj_l VARCHAR2(2000) :=
    'INSERT INTO t_rez_vsj<cvor> (
       id, rez_id, vsj_id, vsjc_id, kol_sj, br_osoba, sj_id, unos_korisnik, unos_dat)
     VALUES (
       :1, :2, :3, :4, :5, :6, :7, :8, :9)';
  greska_l EXCEPTION;
  sj_id_l t_rez_vsj.sj_id%TYPE := NULL;
  so_id_l m_so.id%TYPE := NULL;
  dat_dolaska_l t_rezervacije.dat_dolaska%TYPE := NULL;
  dat_odlaska_l t_rezervacije.dat_odlaska%TYPE := NULL;
  sj_broj_l m_sj.broj%TYPE := NULL;
  select_rezervacija_l VARCHAR2(2000) :=
    'SELECT so_id, dat_dolaska, dat_odlaska
       FROM t_rezervacije<cvor>
      WHERE id = <id>';
  select_sj_l VARCHAR2(2000) :=
    'SELECT id
       FROM m_sj<cvor>
      WHERE so_id = <so_id>
        AND broj = ''<broj>''';
  unos_korisnik_l  m_korisnici.naziv%TYPE := zmp_zaj.korisnik (-1);
BEGIN
  IF vanj_sustav_p = 'PHOBS2' THEN
    unos_korisnik_l := 'PHOBS';
  END IF;

  /*
  provjeri ulazni parametar
  */
  IF synxis_sifra_p IS NULL THEN
     RAISE greska_l;
  END IF;

  /*
  vrati id i cvor t_rezervacije za zadani broj rezervacije
  */
  vrati_rez_id_cvor
       (synxis_sifra_p => synxis_sifra_p
       ,vanj_sustav_p => vanj_sustav_p
       ,creator_id_p => creator_id_p
       ,recsosus_sifra_p => recsosus_sifra_p
       ,rez_id_p => rez_id_l
       ,target_cvor_p => target_cvor_l
       );

  /*
   provjeri ako rez treba brisati
   (ako je samo jedan redak i ako su iste vrijednosti za stupce)
   ako vrati odgovarajuu rezvsj_id ne treba je unositi
  */
  BEGIN
    IF brisanje_p = 1 THEN
      EXECUTE IMMEDIATE REPLACE (select_rezervacija_vsj_l, '<cvor>', target_cvor_l)
        INTO rezvsj_id_p USING
          rez_id_l,
          vsj_id_p,
          vsjc_id_p,
          kol_sj_p,
          br_osoba_p;
    END IF;
  EXCEPTION WHEN OTHERS THEN
    rezvsj_id_p := NULL;
  END;

  /*
  obrii VSJ samo se radi o unosu prvog retka VSJ
  */
  IF prvi_redak_p = 1 AND rezvsj_id_p IS NULL THEN
    CLEAR_REZERVACIJE_VSJ(synxis_sifra_p, vanj_sustav_p, creator_id_p, recsosus_sifra_p);
  END IF;

  IF NOT sj_broj_p IS NULL THEN
    /*
    zerrofill sj_broj_p
    */
    sj_broj_l := sj_broj_p;
    
    BEGIN -- IRN 4085
      pra_rec_zaj.oblikuj_podatak ('BROJ', 'M_SJ', sj_broj_l);
    EXCEPTION WHEN OTHERS THEN
      sj_broj_l := NULL;
      sj_broj_warn_p :=  sj_broj_l ||  CHR(10);
    END;
    
    /*
    vrati id smjestajnog objekta
    */
    EXECUTE IMMEDIATE REPLACE (REPLACE (select_rezervacija_l, '<id>', rez_id_l), '<cvor>', target_cvor_l)
      INTO so_id_l, dat_dolaska_l, dat_odlaska_l;

    /*
    vrati id smjestajne jedinice za broj
    */
    IF sj_broj_l IS NOT NULL THEN -- IRN 4085
      BEGIN
        EXECUTE IMMEDIATE REPLACE (REPLACE (REPLACE (select_sj_l, '<broj>', sj_broj_l), '<so_id>', so_id_l), '<cvor>', target_cvor_l)
          INTO sj_id_l;
      EXCEPTION WHEN NO_DATA_FOUND THEN
        sj_id_l := NULL;
        sj_broj_warn_p := sj_broj_warn_p || SQLERRM || CHR(10);
      END;
    END IF;

    -- Provjeri status SJ
    IF sj_id_l IS NOT NULL THEN -- IRN 4085
      BEGIN    
        EXECUTE IMMEDIATE REPLACE ('BEGIN fm_rec2120.provjeri_status_sj<cvor> ( ' ||
                                   '         :dat_dolaska_l,'||
                                   '         :dat_odlaska_l,'||
                                   '         :rezvsj_id_l,'||
                                   '         TO_NUMBER (NULL),'||
                                   '         :sj_id_l); END;', '<cvor>', target_cvor_l)
          USING dat_dolaska_l, dat_odlaska_l, rezvsj_id_p, sj_id_l;
          
        -- IRN 4085
        EXECUTE IMMEDIATE REPLACE ('BEGIN pra_t_rez_vsj.provjeri_sj<cvor> ( ' ||
                                   '         :rez_id_l,'||
                                   '         :sj_id_l,'||
                                   '         :vsj_id_p,'||
                                   '         :rezvsj_id_p'||
                                   '); END;', '<cvor>', target_cvor_l)
          USING rez_id_l, sj_id_l, vsj_id_p, rezvsj_id_p;            
          
      EXCEPTION WHEN OTHERS THEN
        sj_id_l := NULL;
        sj_broj_warn_p := sj_broj_warn_p || SQLERRM || CHR(10);
      END;    
    END IF;
  END IF;

  IF rezvsj_id_p IS NULL THEN
    /*
    vrati id nove rezervacije
    */
    EXECUTE IMMEDIATE REPLACE ('SELECT pra_rec_zaj.sekvenca<cvor> (NULL) FROM dual', '<cvor>', target_cvor_l)
      INTO rezvsj_id_p;

    IF rezvsj_id_p IS NULL THEN
      RAISE greska_l;
    END IF;
    /*
    puni t_rez_vsj na zadanom cvoru
    */
    EXECUTE IMMEDIATE REPLACE (insert_rezervacija_vsj_l, '<cvor>', target_cvor_l)
      USING
        rezvsj_id_p,
        rez_id_l,
        vsj_id_p,
        vsjc_id_p,
        kol_sj_p,
        br_osoba_p,
        sj_id_l,
        unos_korisnik_l,
        SYSDATE;
  END IF;
END;
PROCEDURE CLEAR_REZERVACIJE_VSJ
 (SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
 ,VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 )
 IS
/*
Brie sve rezervacije vrsta smjetajnih jedinica iz tablice T_REZ_VSJ u zadanoj bazi,
za zadanu rezervaciju.
*/

  cvor_l m_so.metcvor_sifra%TYPE;
  rez_id_l t_rez_vsj.rez_id%TYPE;
  target_cvor_l VARCHAR2(41) := '';
  delete_rezervacije_vsj_l VARCHAR2(2000) :=
    'DELETE FROM t_rez_vsj<cvor>
      WHERE rez_id = :1';
  delete_rezervacije_sj_l VARCHAR2(2000) :=
    'DELETE FROM trec_rez_sj<cvor>
      WHERE rezvsj_id IN (SELECT id FROM t_rez_vsj<cvor> WHERE rez_id = :1)';
  greska_l EXCEPTION;
BEGIN
  /*
  provjeri ulazni parametar
  */
  IF synxis_sifra_p IS NULL THEN
    RAISE greska_l;
  END IF;

  /*
  vrati id i cvor t_rezervacije za zadani broj synxis rezervacije
  */
  vrati_rez_id_cvor
       (synxis_sifra_p => synxis_sifra_p
       ,vanj_sustav_p => vanj_sustav_p
       ,creator_id_p => creator_id_p
       ,recsosus_sifra_p => recsosus_sifra_p
       ,rez_id_p => rez_id_l
       ,target_cvor_p => target_cvor_l
       );

  /*
  brii t_rez_sj na zadanom cvoru
  */
  EXECUTE IMMEDIATE REPLACE (delete_rezervacije_sj_l, '<cvor>', target_cvor_l)
    USING rez_id_l;

  /*
  brii t_rez_vsj na zadanom cvoru
  */
  EXECUTE IMMEDIATE REPLACE (delete_rezervacije_vsj_l, '<cvor>', target_cvor_l)
    USING rez_id_l;

END;
PROCEDURE DODAJ_REZERVACIJA_GOSTI
 (SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
 ,VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,REZGOST_ID_P IN OUT T_REZ_GOST.ID%TYPE
 ,REZVSJ_ID_P IN T_REZ_VSJ.ID%TYPE
 ,RBR_P IN T_REZ_GOST.rbr%TYPE := NULL
 ,IME_P IN T_REZ_GOST.IME%TYPE
 ,PREZIME_P IN T_REZ_GOST.PREZIME%TYPE
 ,TITULA_P IN T_REZ_GOST.TITULA%TYPE
 ,DAT_RODJENJA_P IN T_REZ_GOST.DAT_RODJENJA%TYPE
 ,DOB_P IN T_REZ_GOST.DOB%TYPE := NULL
 ,VPISP_ID_P IN S_VPISPRAVA.ID%TYPE
 ,BR_PISPRAVE_P IN T_REZ_GOST.BR_PISPRAVE%TYPE
 ,NAZ_MJRODJ_P IN T_REZ_GOST.NAZ_MJRODJ%TYPE
 ,ZEMR_ID_P IN T_REZ_GOST.ZEMR_ID%TYPE
 ,ZEMD_ID_P IN T_REZ_GOST.ZEMD_ID%TYPE
 ,REG_VOZILA_P IN T_REZ_GOST.REG_VOZILA%TYPE
 )
 IS
--
  rez_id_l t_rez_vsj.rez_id%TYPE;
  target_cvor_l VARCHAR2(41) := '';
  insert_rezervacija_gosti_l VARCHAR2(2000) :=
    'INSERT INTO t_rez_gost<cvor> (
        id, rbr, ime, prezime, titula, rezvsj_id, dat_rodjenja, dob, vpisp_id, br_pisprave, naz_mjrodj, zemr_id, zemd_id, ozn_gratis, ozn_ispis_hk,
        unos_korisnik, unos_dat, reg_vozila)
      VALUES (
        :1, :2, :3, :4, :5, :6, :7, :8, :9, :10, :11, :12, :13, 0, -1, :14, :15, :16)';

  rezgost_rec_l      t_rez_gost%ROWTYPE;

  greska_l EXCEPTION;
  sj_id_l t_rez_vsj.sj_id%TYPE := NULL;
  so_id_l m_so.id%TYPE := NULL;
  sj_broj_l m_sj.broj%TYPE := NULL;

  select_recagost_l VARCHAR2(2000) :=
    'SELECT rez.recagost_id,
            (SELECT COUNT(*)
               FROM t_rez_vsj<cvor> rezvsj,
                    t_rez_gost<cvor> rezgost
              WHERE rezvsj.rez_id = rez.id
                AND rezgost.rezvsj_id = rezvsj.id
                AND rezgost.recagost_id = rez.recagost_id)
      FROM t_rezervacije<cvor> rez
     WHERE rez.id = :1';
   recagost_id_l NUMBER;
   recagost_l NUMBER;

  unos_korisnik_l  m_korisnici.naziv%TYPE := zmp_zaj.korisnik (-1);
BEGIN
  IF vanj_sustav_p = 'PHOBS2' THEN
    unos_korisnik_l := 'PHOBS';
  END IF;

  /*
  provjeri ulazni parametar
  */
  IF synxis_sifra_p IS NULL THEN
     RAISE greska_l;
  END IF;

  /*
  vrati id i cvor t_rezervacije za zadani broj rezervacije
  */
  vrati_rez_id_cvor
       (synxis_sifra_p => synxis_sifra_p
       ,vanj_sustav_p => vanj_sustav_p
       ,creator_id_p => creator_id_p
       ,recsosus_sifra_p => recsosus_sifra_p
       ,rez_id_p => rez_id_l
       ,target_cvor_p => target_cvor_l
       );

  /*
  vrati id novog retka
  */
  EXECUTE IMMEDIATE REPLACE ('SELECT pra_rec_zaj.sekvenca<cvor> (NULL) FROM dual', '<cvor>', target_cvor_l)
    INTO rezgost_id_p;

  IF rezgost_id_p IS NULL THEN
    RAISE greska_l;
  END IF;

  rezgost_rec_l.id := rezgost_id_p;
  rezgost_rec_l.titula := titula_p;
  rezgost_rec_l.dob :=  dob_p;
  rezgost_rec_l.vpisp_id :=  vpisp_id_p;
  rezgost_rec_l.br_pisprave :=  br_pisprave_p;
  rezgost_rec_l.naz_mjrodj :=  naz_mjrodj_p;
  rezgost_rec_l.zemr_id := zemr_id_p;
  rezgost_rec_l.zemd_id :=  zemd_id_p;

  EXECUTE IMMEDIATE REPLACE (select_recagost_l, '<cvor>', target_cvor_l)
    INTO recagost_id_l, recagost_l USING rez_id_l;

  IF recagost_l = 0 AND recagost_id_l IS NOT NULL THEN
    -- arhiva je na centru
    pra_rez_rasporedi.puni_iz_recagost(recagost_id_l, rezgost_rec_l);
  END IF;

  rezgost_rec_l.ime := ime_p;
  rezgost_rec_l.prezime := prezime_p;
  rezgost_rec_l.dat_rodjenja := dat_rodjenja_p;
  rezgost_rec_l.reg_vozila := reg_vozila_p;

  /*
  puni t_rez_gost na zadanom cvoru
  */
  EXECUTE IMMEDIATE REPLACE (insert_rezervacija_gosti_l, '<cvor>', target_cvor_l)
    USING
      rezgost_id_p,
      rbr_p,
      rezgost_rec_l.ime,          -- ime_p,
      rezgost_rec_l.prezime,      -- prezime_p,
      rezgost_rec_l.titula,       -- titula_p,
      rezvsj_id_p,
      rezgost_rec_l.dat_rodjenja, -- dat_rodjenja_p,
      rezgost_rec_l.dob,          -- dob_p,
      rezgost_rec_l.vpisp_id,     -- vpisp_id_p,
      rezgost_rec_l.br_pisprave,  -- br_pisprave_p,
      rezgost_rec_l.naz_mjrodj,   -- naz_mjrodj_p,
      rezgost_rec_l.zemr_id,      -- zemr_id_p,
      rezgost_rec_l.zemd_id,      -- zemd_id_p,
      unos_korisnik_l,
      SYSDATE,
      rezgost_rec_l.reg_vozila;   -- reg_vozila_p

END;
PROCEDURE CLEAR_REZERVACIJE_GOSTI
 (SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
 ,VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 )
 IS
/*
Brie iz tablice T_REZ_GOST u zadanoj bazi, za zadanu rezervaciju.
parametar: synxis_sifra_p - broj rezervacije u vanjskom sustavu
*/

  rez_id_l t_rez_vsj.rez_id%TYPE;
  target_cvor_l VARCHAR2(41) := '';
  delete_rezervacije_gosti_l VARCHAR2(2000) :=
    'DELETE FROM t_rez_gost<cvor>
      WHERE rezvsj_id IN (SELECT id FROM t_rez_vsj<cvor> WHERE rez_id = :1)';
  greska_l EXCEPTION;
BEGIN
  /*
  provjeri ulazni parametar
  */
  IF synxis_sifra_p IS NULL THEN
    RAISE greska_l;
  END IF;

  /*
  vrati id i cvor t_rezervacije za zadani broj rezervacije
  */
  vrati_rez_id_cvor
       (synxis_sifra_p => synxis_sifra_p
       ,vanj_sustav_p => vanj_sustav_p
       ,creator_id_p => creator_id_p
       ,recsosus_sifra_p => recsosus_sifra_p
       ,rez_id_p => rez_id_l
       ,target_cvor_p => target_cvor_l
       );

  /*
  brii t_rez_gost na zadanom cvoru
  */
  EXECUTE IMMEDIATE REPLACE (delete_rezervacije_gosti_l, '<cvor>', target_cvor_l)
    USING rez_id_l;

END;
PROCEDURE DODAJ_REZERVACIJA_USLUGA
 (SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
 ,VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,USL_ID_P IN T_REZ_USL.USL_ID%TYPE
 ,SAS_ID_P IN T_REZ_USL.SAS_ID%TYPE
 ,USL_ID1_P IN T_REZ_USL.USL_ID1%TYPE
 ,RECARA_ID_P IN T_REZ_USL.RECARA_ID%TYPE
 ,DAT_POC_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,DAT_ZAV_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
 ,PLACA_GOST_P IN T_REZ_GUSL.OZN_PLATITELJA%TYPE
 )
 IS
/*
Dodaje rezervaciju usluge u tablicu T_REZ_USL u bazu smjestajnog objekta.
Poziva se iz procedure dodaj_rez_usluga_recara.

parametar: synxis_sifra_p - broj rezervacije u vanjskom sustavu
parametar: usl_id_p - id usluge
parametar: sas_id_p - id sastojka - poetni sastojak usluge
usl_id1_p, recara_id_p, dat_poc_p, dat_zav_p
*/

  rez_id_l t_rez_vsj.rez_id%TYPE;
  sas_id_l s_sastojci.id%TYPE;
  target_cvor_l VARCHAR2(41) := '';
  insert_rezervacija_usluga_l VARCHAR2(2000) :=
    'INSERT INTO t_rez_usl<cvor> (
       rez_id, usl_id, sas_id, usl_id1, recara_id, dat_poc, dat_zav, ozn_platitelja, unos_korisnik, unos_dat)
     VALUES (
       :1, :2, :3, :4, :5, :6, :7, :8, :9, :10)';
  greska_l EXCEPTION;
  unos_korisnik_l  m_korisnici.naziv%TYPE := zmp_zaj.korisnik (-1);
BEGIN
  IF vanj_sustav_p = 'PHOBS2' THEN
    unos_korisnik_l := 'PHOBS';
  END IF;

  /*
  provjeri ulazni parametar
  */
  IF synxis_sifra_p IS NULL THEN
    RAISE greska_l;
  END IF;

  /*
  vrati id i cvor t_rezervacije za zadani broj rezervacije
  */
  vrati_rez_id_cvor
       (synxis_sifra_p => synxis_sifra_p
       ,vanj_sustav_p => vanj_sustav_p
       ,creator_id_p => creator_id_p
       ,recsosus_sifra_p => recsosus_sifra_p
       ,rez_id_p => rez_id_l
       ,target_cvor_p => target_cvor_l
       );


  sas_id_l := sas_id_p;
  IF sas_id_l IS NULL THEN
    sas_id_l := sas_id (usl_id_p);
  END IF;
  /*
  puni t_rez_usl na zadanom cvoru
  */
  EXECUTE IMMEDIATE REPLACE (insert_rezervacija_usluga_l, '<cvor>', target_cvor_l)
    USING
      rez_id_l,
      usl_id_p,
      sas_id_l,
      usl_id1_p,
      recara_id_p,
      dat_poc_p,
      dat_zav_p,
      placa_gost_p,
      unos_korisnik_l,
      SYSDATE;

END;
PROCEDURE CLEAR_REZERVACIJE_USLUGA
 (SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
 ,VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 )
 IS
/*
Brie rezervacije svih usluga iz tablice T_REZ_USL iz zadane baze,
za zadanu rezervaciju.

parametar: synxis_sifra_p - broj rezervacije u vanjskom sustavu
*/

  rez_id_l t_rez_usl.rez_id%TYPE;
  target_cvor_l VARCHAR2(41) := '';
  delete_rezervacije_usluga_l VARCHAR2(2000) :=
    'DELETE FROM t_rez_usl<cvor>
      WHERE rez_id = :1';
  greska_l EXCEPTION;
BEGIN
  /*
  provjeri ulazni parametar
  */
  IF synxis_sifra_p IS NULL THEN
    RAISE greska_l;
  END IF;

  /*
  vrati id i cvor t_rezervacije za zadani broj rezervacije
  */
  vrati_rez_id_cvor
       (synxis_sifra_p => synxis_sifra_p
       ,vanj_sustav_p => vanj_sustav_p
       ,creator_id_p => creator_id_p
       ,recsosus_sifra_p => recsosus_sifra_p
       ,rez_id_p => rez_id_l
       ,target_cvor_p => target_cvor_l
       );

  /*
  brii t_rez_usl na zadanom cvoru
  */
  EXECUTE IMMEDIATE REPLACE (delete_rezervacije_usluga_l, '<cvor>', target_cvor_l)
    USING rez_id_l;
END;
PROCEDURE DODAJ_REZERVACIJA_GOSTI_USLUGA
 (SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
 ,VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,REZGOST_ID_P IN OUT T_REZ_GOST.ID%TYPE
 ,USL_ID_P IN T_REZ_USL.USL_ID%TYPE
 ,SAS_ID_P IN T_REZ_USL.SAS_ID%TYPE
 ,USL_ID1_P IN T_REZ_USL.USL_ID1%TYPE
 ,RECARA_ID_P IN T_REZ_USL.RECARA_ID%TYPE
 ,DAT_POC_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,DAT_ZAV_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
 ,STOPA_PLACANJA_P IN T_REZ_GUSL.STOPA_PLACANJA%TYPE
 ,PLACA_GOST_P IN T_REZ_GUSL.OZN_PLATITELJA%TYPE
 )
 IS
/*
Dodaje rezervaciju usluge u tablicu T_REZ_GUSL u bazu smjestajnog objekta.
*/

  rez_id_l t_rez_vsj.rez_id%TYPE;
  target_cvor_l VARCHAR2(41) := '';
  insert_rez_gost_usluga_l VARCHAR2(2000) :=
    'INSERT INTO t_rez_gusl<cvor> (
       rezgost_id, usl_id, sas_id, usl_id1, recara_id, dat_poc, dat_zav, stopa_placanja, ozn_platitelja, unos_korisnik, unos_dat)
     VALUES (
       :1, :2, :3, :4, :5, :6, :7, :8, :9, :10, :11)';
  greska_l EXCEPTION;

  unos_korisnik_l  m_korisnici.naziv%TYPE := zmp_zaj.korisnik (-1);
BEGIN
  IF vanj_sustav_p = 'PHOBS2' THEN
    unos_korisnik_l := 'PHOBS';
  END IF;

  /*
  provjeri ulazni parametar
  */
  IF synxis_sifra_p IS NULL THEN
    RAISE greska_l;
  END IF;

  /*
  vrati id i cvor t_rezervacije za zadani broj rezervacije
  */
  vrati_rez_id_cvor
       (synxis_sifra_p => synxis_sifra_p
       ,vanj_sustav_p => vanj_sustav_p
       ,creator_id_p => creator_id_p
       ,recsosus_sifra_p => recsosus_sifra_p
       ,rez_id_p => rez_id_l
       ,target_cvor_p => target_cvor_l
       );

  /*
  puni t_rez_usl na zadanom cvoru
  */
  EXECUTE IMMEDIATE REPLACE (insert_rez_gost_usluga_l, '<cvor>', target_cvor_l)
    USING
      rezgost_id_p,
      usl_id_p,
      sas_id_p,
      usl_id1_p,
      recara_id_p,
      dat_poc_p,
      dat_zav_p,
      stopa_placanja_p,
      placa_gost_p,
      unos_korisnik_l,
      SYSDATE;

END;
PROCEDURE CLEAR_REZERVACIJE_GOSTI_USLUGA
 (SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
 ,VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 )
 IS
/*
Brie rezervacije svih usluga iz tablice T_REZ_GUSL iz zadane baze,
za zadanu rezervaciju.

parametar: synxis_sifra_p - CRSReservationNumber. Jedinstveni broj rezervacije u SynXis sustavu
*/

  rez_id_l t_rez_usl.rez_id%TYPE;
  target_cvor_l VARCHAR2(41) := '';
  delete_rezervacije_usluga_l VARCHAR2(2000) :=
    'DELETE FROM t_rez_gusl<cvor>
      WHERE rezgost_id IN (SELECT rezgost.id FROM t_rez_gost<cvor> rezgost, t_rez_vsj<cvor> rezvsj WHERE rezgost.rezvsj_id = rezvsj.id AND rezvsj.rez_id = :1)';
  greska_l EXCEPTION;
BEGIN
  /*
  provjeri ulazni parametar
  */
  IF synxis_sifra_p IS NULL THEN
    RAISE greska_l;
  END IF;

  /*
  vrati id i cvor t_rezervacije za zadani broj rezervacije
  */
  vrati_rez_id_cvor
       (synxis_sifra_p => synxis_sifra_p
       ,vanj_sustav_p => vanj_sustav_p
       ,creator_id_p => creator_id_p
       ,recsosus_sifra_p => recsosus_sifra_p
       ,rez_id_p => rez_id_l
       ,target_cvor_p => target_cvor_l
       );
  /*
  brii t_rez_usl na zadanom cvoru
  */
  EXECUTE IMMEDIATE REPLACE (delete_rezervacije_usluga_l, '<cvor>', target_cvor_l)
    USING rez_id_l;
END;
PROCEDURE DODAJ_REZERVACIJA_CIJENE_USL
 (SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
 ,VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
 ,VSJ_ID_P IN TREC_REZ_CJEUSL.VSJ_ID%TYPE
 ,USL_ID_P IN TREC_REZ_CJEUSL.USL_ID%TYPE
 ,DAT_POC_P IN TREC_REZ_CJEUSL.DAT_POC%TYPE
 ,DAT_ZAV_P IN TREC_REZ_CJEUSL.DAT_ZAV%TYPE
 ,CIJENA_USLUGE_P IN TREC_REZ_CJEUSL.CIJENA_USLUGE%TYPE
 )
 IS
/*
Dodaje u tablicu TREC_REZ_CJEUSL u bazu smjestajnog objekta.
*/

  cvor_l m_so.metcvor_sifra%TYPE;
  rez_id_l t_rez_vsj.rez_id%TYPE;
  tekuci_cvor_l m_so.metcvor_sifra%TYPE;
  target_cvor_l VARCHAR2(41) := '';
  insert_recrezcje_l VARCHAR2(2000) :=
    'INSERT INTO trec_rez_cjeusl<cvor> (
       rez_id, vsj_id, usl_id, dat_poc, dat_zav, cijena_usluge, unos_korisnik, unos_dat)
     VALUES (
       :1, :2, :3, :4, :5, :6, :7, :8)';
  greska_l EXCEPTION;
  CURSOR synxrez_c IS
    SELECT rez_id, metcvor_sifra
      FROM lsynxis_rezervacije
     WHERE synxis_sifra = synxis_sifra_p
       AND vanj_sustav = vanj_sustav_p;
  vsj_id_l trec_rez_cjeusl.vsj_id%TYPE;

  unos_korisnik_l  m_korisnici.naziv%TYPE := zmp_zaj.korisnik (-1);
BEGIN
  IF vanj_sustav_p = 'PHOBS2' THEN
    unos_korisnik_l := 'PHOBS';
  END IF;

  /*
  IF UPPER(pra_zmp_zaj.zmppar_vrijednost ('PHOBS', '0002')) = 'NE' THEN
    RETURN;
  END IF;
  */

  /*
  provjeri ulazni parametar
  */
  IF synxis_sifra_p IS NULL THEN
    RAISE greska_l;
  END IF;

  /*
  vrati id i cvor t_rezervacije za zadani broj synxis rezervacije
  */
  OPEN synxrez_c;
  FETCH synxrez_c INTO rez_id_l, cvor_l;
  CLOSE synxrez_c;

  /*
  vrati sifru cvora baze
  */
  SELECT sifra_tekuceg_cvora INTO tekuci_cvor_l FROM s_vlasnik;
  IF NOT cvor_l = tekuci_cvor_l THEN
    target_cvor_l := '@' || cvor_l;
  END IF;

  /*
  ako cijena usluge nije vezana za VSJ ne proslijedi VSJ
  */
  SELECT DECODE (ozn_cje_vsj, -1, vsj_id_p, NULL) INTO vsj_id_l
    FROM s_usluge
   WHERE id = usl_id_p;

  /*
  puni trec_rez_cjeusl na zadanom cvoru
  */
  EXECUTE IMMEDIATE REPLACE (insert_recrezcje_l, '<cvor>', target_cvor_l)
    USING
      rez_id_l,
      vsj_id_l,
      usl_id_p,
      dat_poc_p,
      dat_zav_p,
      cijena_usluge_p,
      unos_korisnik_l,
      SYSDATE;

END;
PROCEDURE CLEAR_REZERVACIJE_CIJENE_USL
 (SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
 ,VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 )
 IS
/*
Brie iz tablice TREC_REZ_CJEUSL iz zadane baze,
za zadanu rezervaciju.
*/

  rez_id_l t_rez_usl.rez_id%TYPE;
  target_cvor_l VARCHAR2(41) := '';
  delete_recrezcje_l VARCHAR2(2000) :=
    'DELETE FROM trec_rez_cjeusl<cvor>
      WHERE rez_id = :1';
  greska_l EXCEPTION;
BEGIN
  /*
  provjeri ulazni parametar
  */
  IF synxis_sifra_p IS NULL THEN
    RAISE greska_l;
  END IF;

  /*
  vrati id i cvor t_rezervacije za zadani broj rezervacije
  */
  vrati_rez_id_cvor
       (synxis_sifra_p => synxis_sifra_p
       ,vanj_sustav_p => vanj_sustav_p
       ,creator_id_p => creator_id_p
       ,recsosus_sifra_p => recsosus_sifra_p
       ,rez_id_p => rez_id_l
       ,target_cvor_p => target_cvor_l
       );

  /*
  brii trec_rez_cjeusl na zadanom cvoru
  */
  EXECUTE IMMEDIATE REPLACE (delete_recrezcje_l, '<cvor>', target_cvor_l)
    USING rez_id_l;
END;
PROCEDURE PONISTI_REZERVACIJU
 (SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
 ,VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,OPIS_STORNA_P IN T_REZERVACIJE.OPIS_STORNA%TYPE
 ,NAPOMENA_P IN T_REZERVACIJE.NAPOMENA2%TYPE
 ,RBR_P IN OUT T_REZERVACIJE.RBR%TYPE
 ,GOD_POSLOVNA_P IN OUT T_REZERVACIJE.GOD_POSLOVNA%TYPE
 ,OZN_VSTORNA_P IN VARCHAR2 := '1'
 )
 IS
/*
Postavlja OZNAKA u 'P' i OZN_VSTORNA u 1 (ponitava rezervaciju)
u tablici T_REZERVACIJE u bazi na osnovu veze iz LSYNXIS_REZERVACIJE.
Poziva se iz procedure spremi_rezervaciju i iz pra_rezvanjsus.unesi_rez.

parametar: synxis_sifra_p - Broj rezervacije u vanjskom sustavu
*/

  rez_id_l lsynxis_rezervacije.rez_id%TYPE;
  target_cvor_l VARCHAR2(41) := '';
  update_rezervacija_l VARCHAR2(2000) :=
   'UPDATE t_rezervacije<cvor>
       SET oznaka = ''P'',
           ozn_vstorna = :0,
           opis_storna = SUBSTR (:1, 1, 40),
           napomena2 = :2 || napomena2
     WHERE id = :3';
BEGIN
  /*
  vrati id i cvor t_rezervacije za zadani broj rezervacije
  */
  vrati_rez_id_cvor
       (synxis_sifra_p => synxis_sifra_p
       ,vanj_sustav_p => vanj_sustav_p
       ,creator_id_p => creator_id_p
       ,recsosus_sifra_p => recsosus_sifra_p
       ,rez_id_p => rez_id_l
       ,target_cvor_p => target_cvor_l
       );
  /*
  auriraj t_rezervacije na zadanom cvoru
  */
  EXECUTE IMMEDIATE REPLACE (update_rezervacija_l, '<cvor>', target_cvor_l)
    USING ozn_vstorna_p, opis_storna_p, napomena_p, rez_id_l;

  /*
  vrati rbr, god_poslovna rezervacije
  */
  IF rez_id_l IS NOT NULL THEN
    EXECUTE IMMEDIATE REPLACE ('SELECT rbr, god_poslovna FROM t_rezervacije<cvor> WHERE id = :1', '<cvor>', target_cvor_l)
       INTO rbr_p, god_poslovna_p
      USING rez_id_l;
  END IF;
END;
PROCEDURE SPREMI_REZERVACIJU
 (SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
 ,VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,REZ_ID_P IN OUT T_REZERVACIJE.ID%TYPE
 ,REZ_RBR_P IN OUT T_REZERVACIJE.RBR%TYPE
 ,SO_ID_P IN T_REZERVACIJE.SO_ID%TYPE
 ,MS_ID_P IN T_REZERVACIJE.MS_ID%TYPE
 ,CJE_ID_P IN T_REZERVACIJE.CJE_ID%TYPE
 ,RECVPRO_ID_P IN T_REZERVACIJE.RECVPRO_ID%TYPE
 ,RECNREZ_ID_P IN T_REZERVACIJE.RECNREZ_ID%TYPE
 ,AGE_ID_P IN T_REZERVACIJE.AGE_ID%TYPE
 ,PONSO_ID_P IN T_PON_SO.ID%TYPE
 ,VAL_ID_P IN T_REZERVACIJE.VAL_ID%TYPE
 ,VALR_ID_P IN T_REZERVACIJE.VALR_ID%TYPE
 ,ZEM_ID_P IN T_REZERVACIJE.ZEM_ID%TYPE
 ,RECAGOST_ID_P IN T_REZERVACIJE.RECAGOST_ID%TYPE
 ,GOD_POSLOVNA_P IN T_REZERVACIJE.GOD_POSLOVNA%TYPE
 ,DATUM_P IN T_REZERVACIJE.DATUM%TYPE
 ,TITULA_P IN T_REZERVACIJE.TITULA%TYPE
 ,IME_P IN T_REZERVACIJE.IME%TYPE
 ,PREZIME_P IN T_REZERVACIJE.PREZIME%TYPE
 ,NAZ_ULICE_P IN T_REZERVACIJE.NAZ_ULICE%TYPE
 ,NAZ_MJESTA_P IN T_REZERVACIJE.NAZ_MJESTA%TYPE
 ,NAZ_REGIJE_P IN T_REZERVACIJE.NAZ_REGIJE%TYPE
 ,BR_TELEFONA_P IN T_REZERVACIJE.BR_TELEFONA%TYPE
 ,EMAIL_P IN T_REZERVACIJE.EMAIL%TYPE
 ,WWW_P IN T_REZERVACIJE.WWW%TYPE
 ,NEWSLETTER_P IN T_REZERVACIJE.OZN_NEWSLETTER%TYPE
 ,DAT_DOLASKA_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,SAT_DOLASKA_P IN T_REZERVACIJE.SAT_DOLASKA%TYPE
 ,DAT_ODLASKA_P IN T_REZERVACIJE.DAT_ODLASKA%TYPE
 ,OZN_CJE_POSEB_P IN T_REZERVACIJE.OZN_CJE_poseb%TYPE
 ,OZN_B_P IN T_REZERVACIJE.OZN_B%TYPE
 ,OZN_F_P IN T_REZERVACIJE.OZN_F%TYPE
 ,IZN_PREDUJMA_P IN T_REZERVACIJE.IZN_PREDUJMA%TYPE
 ,IZN_REZERVACIJE_P IN T_REZERVACIJE.IZN_REZERVACIJE%TYPE
 ,STOPA_POPUSTA_P IN T_REZERVACIJE.STOPA_POPUSTA%TYPE
 ,OPIS1_P IN T_REZERVACIJE.OPIS1%TYPE
 ,OPIS2_P IN T_REZERVACIJE.OPIS2%TYPE
 ,DAT_KARTICE_P IN T_REZERVACIJE.DAT_KARTICE%TYPE
 ,NAPOMENA_P IN T_REZERVACIJE.NAPOMENA%TYPE
 ,BR_OSOBA1_P IN T_REZERVACIJE.BR_OSOBA1%TYPE
 ,BR_OSOBA2_P IN T_REZERVACIJE.BR_OSOBA2%TYPE
 ,OZNAKA_P IN T_REZERVACIJE.OZNAKA%TYPE
 ,OZN_VSTORNA_P IN T_REZERVACIJE.OZN_VSTORNA%TYPE
 ,OZN_VIP_P IN T_REZERVACIJE.OZN_VIP%TYPE
 ,OPIS_STORNA_P IN T_REZERVACIJE.OPIS_STORNA%TYPE
 ,LOYKAR_BROJ_P IN TLOY_KARTICE.BROJ%TYPE
 ,LOYLEVEL_P IN VARCHAR2
 ,OPIS_REZERVACIJE_MJESTA_P IN T_REZERVACIJE.OPIS_REZERVACIJE_MJESTA%TYPE
 ,PROVJERA_BORAVKA_OK_P IN OUT NUMBER
 ,GUARANTEE_CODE_P IN T_REZERVACIJE.guarantee_code%TYPE
 ,REZ_AGENT_P IN T_REZERVACIJE.unos_korisnik%TYPE
 )
 IS
/*
Sprema postojeu rezervaciju u tablicu T_REZERVACIJE u bazu smjetajnog objekta.
Ukoliko se je promjenio smjetajni objekt, tada stornira staru rezervaciju i dodaje novu.
(U phobs rezervaciji se SO ne moe promijeniti)

parametar: synxis_sifra_p - CRSReservationNumber. Jedinstveni broj rezervacije u SynXis sustavu
parametar: so_id_p - id smjetajnog objekta
parametar: ms_id_p - id marketinkog segmenta
parametar: cje_id_p - id cjenika
parametar: recvpro_id_p - id vrste programa
parametar: recnrez_id_p - id naina rezervacije (nije obavezan)
parametar: age_id_p - id agencije (nije obavezan)
parametar: val_id_p - id valute
parametar: god_poslovna_p - poslovna godina
parametar: datum_p - datum rezervacije
parametar: titula_p - titula gosta
parametar: ime_p - ime gosta
parametar: prezime_p - prezime gosta
parametar: naz_ulice_p - adresa gosta
parametar: naz_regije_p - naziv regije gosta
parametar: email_p - e-mail gosta
parametar: www_p - url gosta
parametar: dat_dolaska_p - datum dolaska gosta
parametar: sat_dolaska_p - sat dolaska gosta
parametar: dat_odlaska_p - datum odlaska gosta
parametar: ozn_cje_poseb_p - :18
parametar: ozn_b_p - :19
parametar: ozn_f_p - :20
parametar: izn_predujma_p - iznos predujma
parametar: opis1_p - :21
parametar: opis2_p - :22
parametar: dat_kartice_p - datum valjanosti kartice
parametar: napomena_p - napomena
parametar: br_osoba1_p - :23
parametar: br_osoba2_p - :24
parametar: oznaka_p - :25
parametar: ozn_vstorna_p - vrsta storna
parametar: recagost_id_p - recagost_id
parametar: ozn_vip_p - ozn_vip_p
*/

  rez_row_old_l t_rezervacije%ROWTYPE;

  recagost_id_l t_rezervacije.recagost_id%TYPE;
  napomena_l    t_rezervacije.napomena%TYPE := napomena_p;
  br_redaka_l   NUMBER;
  naredba_l     VARCHAR2(1000);

  cvor_l        m_so.metcvor_sifra%TYPE;
  cvor_old_l    m_so.metcvor_sifra%TYPE;
  tekuci_cvor_l m_so.metcvor_sifra%TYPE;
  target_cvor_l VARCHAR2(41) := '';
  dat_opcije_l  t_rezervacije.dat_opcije%TYPE;

  jez_id_l      s_jezici.id%TYPE;

  naz_ulice_l   t_rezervacije.naz_ulice%TYPE := naz_ulice_p;
  naz_mjesta_l  t_rezervacije.naz_mjesta%TYPE := naz_mjesta_p;
  naz_regije_l  t_rezervacije.naz_regije%TYPE := naz_regije_p;
  br_telefona_l t_rezervacije.br_telefona%TYPE := br_telefona_p;
  email_l       t_rezervacije.email%TYPE := email_p;
  www_l         t_rezervacije.www%TYPE := www_p;

  CURSOR age_c (id_k IN m_agencije.id%TYPE) IS
    SELECT sifra
      FROM m_agencije
     WHERE id = id_k;
  age_sifra_l   m_agencije.id%TYPE;

  update_rezervacija_l VARCHAR2(2000) :=
    'UPDATE t_rezervacije<cvor> SET
         so_id = :1
        ,ms_id = :2
        ,cje_id = :3
        ,recvpro_id = :4
        ,recnrez_id = NVL (recnrez_id, :5)
        ,age_id = :6
        ,ponso_id = :7
        ,val_id = :8
        ,valr_id = :9
        ,zem_id = :10
        ,god_poslovna = :11
        ,datum = :12
        ,titula = :13
        ,ime = :14
        ,prezime = :15
        ,naz_ulice = :16
        ,naz_mjesta = :17
        ,naz_regije = :18
        ,br_telefona = :19
        ,email = :20
        ,www = :21
        ,dat_dolaska = :22
        ,sat_dolaska = :23
        ,dat_odlaska = :24
        ,ozn_cje_poseb = :25
        ,ozn_b = :26
        ,ozn_f = :27
        ,izn_predujma = :28
        ,izn_rezervacije = :29
        ,stopa_popusta = :30
        ,opis1 = :31
        ,opis2 = :32
        ,dat_kartice = :33
        ,napomena2 = :34
        ,br_osoba1 = :35
        ,br_osoba2 = :36
        ,oznaka = :37
        ,ozn_vstorna = :38
        ,recagost_id = :39
        ,ozn_vip = :40
        ,dat_opcije = :41
        ,opis_storna = :42
        ,ozn_newsletter = :43
        ,jez_id = :44
        ,zemd_id = :45
        ,opis_rezervacije_mjesta = NVL (:46, opis_rezervacije_mjesta)
        ,creator_id = :47
        ,guarantee_code = :48
      WHERE id = :49';

  CURSOR so_c (id_p m_so.id%TYPE) IS
    SELECT metcvor_sifra
      FROM m_so
     WHERE id = id_p;

  greska_l EXCEPTION;
  age_id_l m_agencije.id%TYPE; -- IRN 2256
  ms_ozn_ugovora_l m_msegmenti.ozn_ugovora%TYPE; -- IRN 2256

  CURSOR loykar_c IS
    SELECT recagost_id
      FROM tloy_kartice
     WHERE broj = loykar_broj_p;

  age_email_l szmp_parametri.vrijednost%TYPE;
  adresa_upis_l szmp_parametri.vrijednost%TYPE;

  naredba_brisi_broj_sj_l VARCHAR2 (2000) :=
      'BEGIN
         pra_rezvanjsus.brisi_broj_sj<cvor>(:1, :2, :3, :4, :5);
         --COMMIT;
       END;';
BEGIN
  /*
  provjeri ulazni parametar
  */
  IF synxis_sifra_p IS NULL THEN
    RAISE greska_l;
  END IF;

  -- IRN 3459 komentirano zakljuavanje
  -- LOCK TABLE lsynxis_rezervacije IN EXCLUSIVE MODE NOWAIT;

  find_rezervacija
       (synxis_sifra_p => synxis_sifra_p
       ,vanj_sustav_p => vanj_sustav_p
       ,creator_id_p => creator_id_p
       ,recsosus_sifra_p => recsosus_sifra_p
       ,rez_row_p => rez_row_old_l
       );

  /*
  vrati stari cvor
  */
  OPEN so_c (rez_row_old_l.so_id);
  FETCH so_c INTO cvor_old_l;
  CLOSE so_c;

  /*
  vrati novi cvor
  */
  OPEN so_c (so_id_p);
  FETCH so_c INTO cvor_l;
  CLOSE so_c;

  jez_id_l := pra_t_gosti.jez_id(zem_id_p, NULL);

  IF UPPER (vanj_sustav_p) = 'PHOBS2'  THEN
    adresa_upis_l := UPPER (pra_zmp_zaj.zmppar_vrijednost ('PHOBS2', '1011'));
    age_email_l := UPPER (pra_zmp_zaj.zmppar_vrijednost ('PHOBS2', '1010'));

  ELSE
    adresa_upis_l := 'DA';
    age_email_l := 'NEBITNO';
  END IF;

  IF age_id_p IS NOT NULL AND age_email_l <> 'NEBITNO' THEN

    OPEN age_c (age_id_p);
    FETCH age_c INTO age_sifra_l;
    CLOSE age_c;

    IF INSTR (age_email_l, age_sifra_l) > 0 THEN
      email_l := NULL;
    END IF;
  END IF;

  IF adresa_upis_l = 'NE' THEN
    naz_ulice_l := NULL;
    naz_mjesta_l := NULL;
    naz_regije_l := NULL;
    br_telefona_l := NULL;
    email_l := NULL;
    www_l := NULL;
  END IF;

  IF loykar_broj_p IS NOT NULL THEN
    IF loylevel_p IS NOT NULL THEN
      napomena_l := loylevel_p || chr(10) || napomena_l;
    END IF;

    OPEN loykar_c;
    FETCH loykar_c INTO recagost_id_l;
    CLOSE loykar_c;
    IF recagost_id_l IS NULL THEN
      -- ako gost nije pronaen u arhivi, upii broj kartice u napomenu
      napomena_l := pra_zmp_zaj.poruka ('REC', 'REC_LOYKAR') || ': ' || loykar_broj_p || chr(10) || napomena_l;
    END IF;
  END IF;

  -- IRN 3459
  -- u nastavku komentirana provjera posl.godine jer nju u update-u ne treba mijenjati da ne dolazi do nepotrebnog ponitavanja i upisa nove rez
  IF cvor_old_l = cvor_l
     -- AND god_poslovna_p = rez_row_old_l.god_poslovna
    AND so_id_p = rez_row_old_l.so_id
  THEN
    /*
    vrati sifru cvora baze
    */
    SELECT sifra_tekuceg_cvora INTO tekuci_cvor_l FROM s_vlasnik;
    IF NOT cvor_l = tekuci_cvor_l THEN
      target_cvor_l := '@' || cvor_l;
    END IF;

    /*
    19.07.2011. dva gosta iz arhive u istom razdoblju
    */
    IF NVL(recagost_id_l, recagost_id_p) IS NOT NULL THEN
      naredba_l :=
        'SELECT COUNT (id) ' ||
        '  FROM t_rezervacije' || target_cvor_l ||
        ' WHERE oznaka = ''V'' ' ||
        '   AND id <> NVL (:rez_id_p, 0) ' ||
        '   AND recagost_id = :recagost_id_p ' ||
        '   AND dat_dolaska <= :dat_odlaska_p ' ||
        '   AND dat_odlaska >= :dat_dolaska_p ';
      EXECUTE IMMEDIATE naredba_l INTO br_redaka_l USING rez_row_old_l.id, NVL(recagost_id_l, recagost_id_p), dat_odlaska_p, dat_dolaska_p;
      IF br_redaka_l = 0 THEN
        recagost_id_l := NVL(recagost_id_l, recagost_id_p);
      ELSE
        recagost_id_l := NULL;
      END IF;
    END IF;

    /*
    ako se boravak skratio ili je isti ne mora se brisati VSJ
    */
    naredba_l :=
      'SELECT COUNT (*) ' ||
      '  FROM t_rezervacije' || target_cvor_l ||
      ' WHERE oznaka = ''V'' ' ||
      '   AND id = :rez_id_p ' ||
      '   AND dat_dolaska <= :dat_dolaska_p ' ||
      '   AND dat_odlaska >= :dat_odlaska_p ';
    EXECUTE IMMEDIATE naredba_l INTO br_redaka_l USING rez_row_old_l.id, dat_dolaska_p, dat_odlaska_p;
    IF br_redaka_l > 0 THEN
      provjera_boravka_ok_p := 1;
    ELSE
    -- inae se brie automatski dodijeljena sj ako je u novom razdoblju zauzeta
      EXECUTE IMMEDIATE REPLACE (naredba_brisi_broj_sj_l, '<cvor>', target_cvor_l)
        USING IN rez_row_old_l.id, IN rez_row_old_l.dat_dolaska, IN rez_row_old_l.dat_odlaska, IN dat_dolaska_p, IN dat_odlaska_p;
    END IF;

    IF rez_row_old_l.pos_id IS NOT NULL THEN
      naz_mjesta_l := NULL;
    END IF;

    -- IRN 2256; popravi age_id
    IF age_id_p IS NOT NULL THEN
      age_id_l := age_id_p;
    ELSE
      SELECT MIN (ozn_ugovora) INTO ms_ozn_ugovora_l FROM m_msegmenti WHERE id = ms_id_p;
      IF ms_ozn_ugovora_l = 0 THEN
        age_id_l := age_id_p;
      ELSE
        SELECT MIN (id) INTO age_id_l FROM m_agencije WHERE sifra = pra_zmp_zaj.zmppar_vrijednost ('IRS', '1001');
      END IF;
    END IF;

    IF UPPER (pra_zmp_zaj.zmppar_vrijednost ('PHOBS2', '1012')) <> 'NEBITNO' THEN
      IF ozn_f_p = '0' THEN
        dat_opcije_l := TRUNC(SYSDATE) + TO_NUMBER(pra_zmp_zaj.zmppar_vrijednost ('PHOBS2', '1012'));
      ELSE
        dat_opcije_l := NULL;
      END IF;
    END IF;

    /*
    auriraj rezervaciju
    */
    EXECUTE IMMEDIATE REPLACE (update_rezervacija_l, '<cvor>', target_cvor_l)
      USING
         so_id_p
        ,ms_id_p
        ,cje_id_p
        ,recvpro_id_p
        ,recnrez_id_p
        ,age_id_l -- IRN 2256
        ,ponso_id_p
        ,val_id_p
        ,valr_id_p
        ,zem_id_p
        ,rez_row_old_l.god_poslovna -- IRN 3459 - god_poslovna se ne mijenja
        ,datum_p
        ,titula_p
        ,ime_p
        ,prezime_p
        ,naz_ulice_l
        ,naz_mjesta_l
        ,naz_regije_l
        ,br_telefona_l
        ,email_l
        ,www_l
        ,dat_dolaska_p
        ,sat_dolaska_p
        ,dat_odlaska_p
        ,ozn_cje_poseb_p
        ,ozn_b_p
        ,ozn_f_p
        ,izn_predujma_p
        ,izn_rezervacije_p
        ,stopa_popusta_p
        ,opis1_p
        ,opis2_p
        ,dat_kartice_p
        ,napomena_l
        ,br_osoba1_p
        ,br_osoba2_p
        ,oznaka_p
        ,ozn_vstorna_p
        ,recagost_id_l
        ,ozn_vip_p
        ,dat_opcije_l
        ,opis_storna_p
        ,newsletter_p
        ,jez_id_l
        ,zem_id_p
        ,opis_rezervacije_mjesta_p
        ,creator_id_p
        ,guarantee_code_p
        ,rez_row_old_l.id;

       /* dodano */
       rez_id_p := rez_row_old_l.id;
       rez_rbr_p := rez_row_old_l.rbr;

    -- za PHOBS popravljamo lsynxis_rezervacije koje nisu imale upisan creator_id i recsosus_sifra
    IF UPPER (vanj_sustav_p) = 'PHOBS2'  AND rez_row_old_l.creator_id IS NULL THEN
      UPDATE  lsynxis_rezervacije
            SET creator_id = creator_id_p, recsosus_sifra = recsosus_sifra_p
       WHERE synxis_sifra = synxis_sifra_p AND creator_id IS NULL
           AND vanj_sustav = UPPER (vanj_sustav_p);

      EXECUTE IMMEDIATE REPLACE ('BEGIN pra_rec_synxis.azu_ppord<cvor> (:rez_id, :br_uputnice, :creator_id); END;', '<cvor>', target_cvor_l)
        USING rez_id_p, synxis_sifra_p, creator_id_p;
    END IF;

    EXECUTE IMMEDIATE REPLACE ('BEGIN pra_rec_synxis.dodaj_pkapd<cvor> (:rez_id, :napomena); END;', '<cvor>', target_cvor_l)
      USING rez_id_p, napomena_p;

  ELSE
    /*
    ako se promijenio SO poniti staru rezervaciju; to se za PHOBS ne moe desiti pa smatramo da su creator_id i recsosus_sifra = NULL
    */
    ponisti_rezervaciju (synxis_sifra_p, vanj_sustav_p, NULL, NULL, opis_storna_p, napomena_p, rez_row_old_l.rbr, rez_row_old_l.god_poslovna);
    /*
    brii lsynxis_rezervacije
    */
    DELETE
      FROM lsynxis_rezervacije
     WHERE synxis_sifra = synxis_sifra_p AND creator_id IS NULL AND recsosus_sifra IS NULL
       AND vanj_sustav = vanj_sustav_p;

    /*
    dodaj novu rezervaciju
    */
    dodaj_rezervaciju (
       synxis_sifra_p
      ,vanj_sustav_p
      ,creator_id_p
      ,recsosus_sifra_p
      ,so_id_p
      ,ms_id_p
      ,cje_id_p
      ,recvpro_id_p
      ,recnrez_id_p
      ,age_id_p
      ,ponso_id_p
      ,val_id_p
      ,valr_id_p
      ,zem_id_p
      ,jez_id_l
      ,recagost_id_l
      ,god_poslovna_p
      ,datum_p
      ,titula_p
      ,ime_p
      ,prezime_p
      ,naz_ulice_l
      ,naz_mjesta_l
      ,naz_regije_l
      ,br_telefona_l
      ,email_l
      ,www_l
      ,newsletter_p
      ,dat_dolaska_p
      ,sat_dolaska_p
      ,dat_odlaska_p
      ,ozn_cje_poseb_p
      ,ozn_b_p
      ,ozn_f_p
      ,izn_predujma_p
      ,izn_rezervacije_p
      ,stopa_popusta_p
      ,opis1_p
      ,opis2_p
      ,dat_kartice_p
      ,napomena_l
      ,br_osoba1_p
      ,br_osoba2_p
      ,ozn_vip_p
      ,opis_rezervacije_mjesta_p
      ,guarantee_code_p
      ,rez_id_p
      ,rez_rbr_p
      ,rez_agent_p);

  END IF;
END;
FUNCTION SAS_ID
 (USL_ID_P IN S_USLUGE.ID%TYPE
 )
 RETURN s_sastojci.id%TYPE
 IS
/*
Poetni sastojak promatrane usluge.
Poziva se iz procedure dodaj_rezervacija_usluga.
*/
  CURSOR uslsas_c IS
    SELECT sas.id
      FROM s_sastojci sas,
           s_usl_sas uslsas
     WHERE sas.id = uslsas.sas_id
       AND uslsas.usl_id = usl_id_p;
  uslsas1_c_l uslsas_c%ROWTYPE;
  uslsas2_c_l uslsas_c%ROWTYPE;
  CURSOR uslsaspz_c IS
    SELECT sas.id, uslsaspz.ozn_uobicajen_sasp
      FROM s_sastojci sas,
           s_usl_sas uslsas,
           s_usl_saspz uslsaspz
     WHERE uslsaspz.uslsasp_id = uslsas.id
       AND uslsas.usl_id = usl_id_p
       AND uslsas.sas_id = sas.id
     ORDER BY uslsaspz.ozn_uobicajen_sasp, sas.id;
  uslsaspz1_c_l uslsaspz_c%ROWTYPE;
BEGIN
  OPEN uslsas_c;
  FETCH uslsas_c INTO uslsas1_c_l;
  IF uslsas_c%FOUND THEN
    FETCH uslsas_c INTO uslsas2_c_l;
    IF uslsas_c%NOTFOUND THEN
      -- usluga ima samo jedan doputeni sastojak
      CLOSE uslsas_c;
      RETURN uslsas1_c_l.id;
    ELSE
      OPEN uslsaspz_c;
      FETCH uslsaspz_c INTO uslsaspz1_c_l;
      IF uslsaspz_c%FOUND THEN
        CLOSE uslsas_c;
        CLOSE uslsaspz_c;
        RETURN uslsaspz1_c_l.id;
      END IF;
      CLOSE uslsaspz_c;
    END IF;
  END IF;
  CLOSE uslsas_c;
  RETURN NULL;
END;
PROCEDURE XPOVEZI_REZERVACIJU
 (SYNXIS_SIFRA_P IN LSYNXIS_REZERVACIJE.SYNXIS_SIFRA%TYPE
 ,VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
 ,SO_ID_P IN T_REZERVACIJE.SO_ID%TYPE
 ,REZ_ID_P OUT T_REZERVACIJE.ID%TYPE
 ,REZ_RBR_P IN T_REZERVACIJE.RBR%TYPE
 ,GOD_POSLOVNA_P IN T_REZERVACIJE.GOD_POSLOVNA%TYPE
 )
 IS
-- irn3613 procedura se ne koristi pa je preimenovana u xpovezi_rezervaciju. kod sljedee izmjene izbaciti.

/*
Dodaje vezu u LSYNXIS_REZERVACIJE izmeu SYNXIS SIFRE (CRSReservationNumber)
i umetnutog sloga.

parametar: synxis_sifra_p - CRSReservationNumber. Jedinstveni broj rezervacije u SynXis sustavu
parametar: so_id_p - id smjetajnog objekta
izlazni parametar: rez_id_p - id nove rezervacije
izlazni parametar: rez_rbr_p - redni broj nove rezervacije
*/

  greska_l EXCEPTION;
  cvor_l m_so.metcvor_sifra%TYPE;
  tekuci_cvor_l m_so.metcvor_sifra%TYPE;
  target_cvor_l VARCHAR2(41) := '';
  kol_l NUMBER;
BEGIN
  /*
  provjeri ulazni parametar
  */
  IF synxis_sifra_p IS NULL THEN
    RAISE greska_l;
  END IF;

  LOCK TABLE lsynxis_rezervacije IN EXCLUSIVE MODE NOWAIT;

  /*
  vrati sifru cvora baze
  */
  SELECT sifra_tekuceg_cvora INTO tekuci_cvor_l FROM s_vlasnik;

  /*
  vrati sifru cvora smjestajnog objekta (dblink)
  */
  SELECT metcvor_sifra INTO cvor_l FROM m_so WHERE id = so_id_p;
  IF NOT cvor_l = tekuci_cvor_l THEN
    target_cvor_l := '@' || cvor_l;
  END IF;

  /*
  vrati id nove rezervacije
  */
  EXECUTE IMMEDIATE REPLACE ('SELECT id FROM t_rezervacije<cvor> WHERE rbr = :1 AND god_poslovna = :2 AND so_id = :so_id', '<cvor>', target_cvor_l)
     INTO rez_id_p
    USING rez_rbr_p, god_poslovna_p, so_id_p;

  IF rez_id_p IS NULL THEN
    RAISE greska_l;
  END IF;
  /*
  EXECUTE IMMEDIATE REPLACE ('UPDATE t_rezervacije<cvor> SET br_uputnice = :synxis_sifra WHERE id = :id', '<cvor>', target_cvor_l)
    USING synxis_sifra_p, rez_id_p;
  */
  /*
  puni lsynxis_rezervacije
  */
  SELECT COUNT(*) INTO kol_l
    FROM lsynxis_rezervacije
   WHERE synxis_sifra = synxis_sifra_p
     AND vanj_sustav = vanj_sustav_p;

  IF kol_l = 0 THEN
    INSERT INTO lsynxis_rezervacije (
        synxis_sifra,
        vanj_sustav,
        metcvor_sifra,
        rez_id)
      VALUES (
        synxis_sifra_p,
        vanj_sustav_p,
        cvor_l,
        rez_id_p);
  ELSE
    UPDATE lsynxis_rezervacije
       SET rez_id = rez_id_p
     WHERE synxis_sifra = synxis_sifra_p
       AND vanj_sustav = vanj_sustav_p
       AND metcvor_sifra = cvor_l;
  END IF;

END;
/* pra_rec_synxis */
PROCEDURE ZAKLJUCAJ_CIJENE_USLUGE
 (SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
 ,VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,VSJ_ID_P IN T_REZ_VSJ.VSJ_ID%TYPE
 ,USL_ID_P IN T_REZ_USL.USL_ID%TYPE
 ,RECARA_ID_P IN T_REZ_USL.RECARA_ID%TYPE
 ,DATPOC_P IN T_REZ_USL.DAT_POC%TYPE
 ,DATZAV_P IN T_REZ_USL.DAT_ZAV%TYPE
 ,UNOS_KORISNIK_P IN VARCHAR2 := NULL
 )
 IS
--
  rez_id_l               t_rez_vsj.rez_id%TYPE;
  target_cvor_l          VARCHAR2 (41) := '';
  greska_l               EXCEPTION;

  select_rezervacija_l VARCHAR2 (2000) :=
    'SELECT dat_dolaska, dat_odlaska, so_id, cje_id, recvpro_id, ozn_cje_poseb
       FROM t_rezervacije<cvor>
      WHERE id = :1';
  insert_recrezcje_l VARCHAR2 (2000) :=
    'INSERT INTO trec_rez_cjeusl<cvor> (
       rez_id, vsj_id, usl_id, recara_id, dat_poc, dat_zav, cijena_usluge, unos_korisnik, unos_dat)
     VALUES (
       :1, :2, :3, :4, :5, :6, :7, :8, :9)';
  pripremi_cjenik_l VARCHAR2 (2000) :=
    'DECLARE ozn_l NUMBER(2);
     BEGIN
       ozn_l := :0;
       pra_rec_iud2.puni_zajtro<cvor> (
         zag_id_p => NULL,
         rez_id_p => :1,
         recvpro_id_p => :2,
         ponso_id_p => NULL,
         so_id_p => :3,
         vsj_id_p => :4,
         usl_id_p => :5,
         vtec_id_p => :6,
         cje_id_p => :7,
         ozn_cje_poseb_p => :8,
         dat_poc_p => :9,
         dat_zav_p => :10,
         kolicina_p => 1,
         stopa_placanja_p => 100,
         br_uputnice_p => NULL,
         ozn_smjesta_p => 0,
         recara_id_p => :11,
         vpispz_id_p => NULL,
         stopa_pdv_p  => NULL,
         ban_id_p => :12,
         ozn_ugo_p => 0,
         cje_id1_p => NULL,
         usl_id1_p => NULL,
         vpispz_id1_p => NULL,
         stopa_pdv1_p => NULL,
         ozn_tab_p => ''RECTRO'',
         ozn_postoji_cijena_p => ozn_l);
     END;';

  dat_dolaska_l          t_rezervacije.dat_dolaska%TYPE;
  dat_odlaska_l          t_rezervacije.dat_odlaska%TYPE;
  so_id_l                t_rezervacije.so_id%TYPE;
  cje_id_l               t_rezervacije.cje_id%TYPE;
  recvpro_id_l           t_rezervacije.recvpro_id%TYPE;
  ozn_cje_poseb_l        t_rezervacije.ozn_cje_poseb%TYPE;

  ban_id_l               m_banke.id%TYPE;
  vtec_id_l              s_vtecajeva.id%TYPE;
  ozn_postoji_cijena_l   NUMBER (2);

  dat_zav_l              trec_rez_cjeusl.dat_zav%TYPE;

  usl_id_r               trec_rez_cjeusl.usl_id%TYPE;
  vsj_id_r               trec_rez_cjeusl.vsj_id%TYPE;
  dat_poc_r              trec_rez_cjeusl.dat_poc%TYPE;
  dat_zav_r              trec_rez_cjeusl.dat_zav%TYPE;
  recara_id_r            trec_rez_cjeusl.recara_id%TYPE;
  cijena_usluge_r        trec_rez_cjeusl.cijena_usluge%TYPE;

  rec_c                  SYS_REFCURSOR;
BEGIN

   /*
   provjeri ulazni parametar
   */
   IF synxis_sifra_p IS NULL THEN
     RAISE greska_l;
   END IF;

   /*
   vrati id i cvor t_rezervacije za zadani broj rezervacije
   */
   vrati_rez_id_cvor
        (synxis_sifra_p => synxis_sifra_p
        ,vanj_sustav_p => vanj_sustav_p
        ,creator_id_p => creator_id_p
        ,recsosus_sifra_p => recsosus_sifra_p
        ,rez_id_p => rez_id_l
        ,target_cvor_p => target_cvor_l
        );

   EXECUTE IMMEDIATE REPLACE (select_rezervacija_l, '<cvor>', target_cvor_l)
      INTO dat_dolaska_l,
           dat_odlaska_l,
           so_id_l,
           cje_id_l,
           recvpro_id_l,
           ozn_cje_poseb_l
     USING rez_id_l;

   vtec_id_l := pra_rec_s2.vtec_id_vapldok (oznaka_p => 'PR', age_id_p => NULL);
   ban_id_l := pra_rec_s2.ban_id_vapldok (oznaka_p => 'PR', age_id_p => NULL);

   EXECUTE IMMEDIATE REPLACE (pripremi_cjenik_l, '<cvor>', target_cvor_l)
      USING ozn_postoji_cijena_l,
            rez_id_l,
            recvpro_id_l,
            so_id_l,
            vsj_id_p,
            usl_id_p,
            vtec_id_l,
            cje_id_l,
            ozn_cje_poseb_l,
            NVL (datpoc_p, dat_dolaska_l),
            NVL (datzav_p, dat_odlaska_l),
            recara_id_p,
            ban_id_l;

   OPEN rec_c FOR REPLACE (
     'SELECT usl_id, vsj_id, dat_poc, GREATEST (dat_poc, dat_zav) dat_zav, recara_id, MAX (cijena) cijena_usluge
        FROM prec_troskovi<cvor> tro, s_usluge<cvor> usl
       WHERE usl.id = tro.usl_id
       GROUP BY usl_id, vsj_id, dat_poc, GREATEST (dat_poc, dat_zav), recara_id
      HAVING MAX (NVL (cijenacp, cijena)) <> 0',
         '<cvor>', target_cvor_l);
   FETCH rec_c INTO usl_id_r,
                    vsj_id_r,
                    dat_poc_r,
                    dat_zav_r,
                    recara_id_r,
                    cijena_usluge_r;

   WHILE rec_c%FOUND LOOP
     IF dat_zav_r < dat_odlaska_l THEN
       dat_zav_l := GREATEST (dat_zav_r - 1, dat_poc_r);
     ELSE
       dat_zav_l := dat_zav_r;
     END IF;

     EXECUTE IMMEDIATE REPLACE (insert_recrezcje_l, '<cvor>', target_cvor_l)
       USING rez_id_l,
             vsj_id_r,
             usl_id_r,
             recara_id_r,
             dat_poc_r,
             dat_zav_l,
             cijena_usluge_r,
             unos_korisnik_p,
             SYSDATE;

     FETCH rec_c INTO usl_id_r,
                      vsj_id_r,
                      dat_poc_r,
                      dat_zav_r,
                      recara_id_r,
                      cijena_usluge_r;
   END LOOP;

   CLOSE rec_c;
   EXECUTE IMMEDIATE REPLACE ('DELETE FROM prec_troskovi<cvor>', '<cvor>', target_cvor_l);
END;
/* pra_rec_synxis */
PROCEDURE RASPOREDI_OSOBE_I_USLUGE
 (SYNXIS_SIFRA_P IN LSYNXIS_REZERVACIJE.SYNXIS_SIFRA%TYPE
 ,VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,REZVSJ_ID_P IN NUMBER := NULL
 ,PORUKA_P OUT VARCHAR2
 ,UNOS_KORISNIK_P IN VARCHAR2 := NULL
 )
 IS
--
  rez_id_l               t_rez_vsj.rez_id%TYPE;
  target_cvor_l          VARCHAR2 (41) := '';
  greska_l               EXCEPTION;

  naredba_rasporedi_l VARCHAR2 (2000) :=
    'BEGIN
       pra_rez_rasporedi.puni_rezgost<cvor> (:1, -1, :2, unos_korisnik_p => :3);
       --pra_rezvanjsus.upisi_broj_sj<cvor> (:4, :5, :6);
       --COMMIT;
     END;';
  
  -- IRN 4085   
  naredba_upisi_broj_sj_l VARCHAR2 (2000) :=
    'BEGIN
       pra_rezvanjsus.upisi_broj_sj<cvor> (:1, :2, :3);
     END;';
BEGIN

   IF synxis_sifra_p IS NULL THEN
     RAISE greska_l;
   END IF;

   /*
   vrati id i cvor t_rezervacije za zadani broj rezervacije
   */
   vrati_rez_id_cvor
        (synxis_sifra_p => synxis_sifra_p
        ,vanj_sustav_p => vanj_sustav_p
        ,creator_id_p => creator_id_p
        ,recsosus_sifra_p => recsosus_sifra_p
        ,rez_id_p => rez_id_l
        ,target_cvor_p => target_cvor_l
        );

   EXECUTE IMMEDIATE REPLACE (naredba_rasporedi_l, '<cvor>', target_cvor_l)
     USING IN rez_id_l, IN rezvsj_id_p, IN unos_korisnik_p;
   
   -- IRN 4085  
   IF pra_rezvanjsus.automatski_upis_sj_g = -1 THEN        
     EXECUTE IMMEDIATE REPLACE (naredba_upisi_broj_sj_l, '<cvor>', target_cvor_l)
       USING IN rez_id_l, IN rezvsj_id_p, OUT poruka_p;
   END IF;
END;
/* pra_rec_synxis */
PROCEDURE POPUNI_DOBNU_GRUPU
 (SYNXIS_SIFRA_P IN LSYNXIS_REZERVACIJE.SYNXIS_SIFRA%TYPE
 ,VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,REZVSJ_ID_P IN T_REZ_VSJ.ID%TYPE
 ,DOB_P IN T_REZ_GOST.DOB%TYPE
 ,BR_OSOBA_DOBI_P IN NUMBER
 ,UNOS_KORISNIK_P IN VARCHAR2 := NULL
 )
 IS
--
  cvor_l                 m_so.metcvor_sifra%TYPE;
  rez_id_l               t_rez_vsj.rez_id%TYPE;
  tekuci_cvor_l          m_so.metcvor_sifra%TYPE;
  target_cvor_l          VARCHAR2 (41) := '';
  greska_l               EXCEPTION;

  CURSOR synxrez_c IS
    SELECT rez_id, metcvor_sifra
      FROM lsynxis_rezervacije
     WHERE synxis_sifra = synxis_sifra_p
       AND creator_id = creator_id_p -- IRN 4124
       AND recsosus_sifra = recsosus_sifra_p -- IRN 4124
       AND vanj_sustav = vanj_sustav_p;

  naredba_azu_dob_l VARCHAR2 (2000) :=
    'BEGIN
       pra_rec_synxis.azuriraj_rezgost_dob<cvor> (:1, :2, :3, :4);
     END;';
BEGIN

  IF synxis_sifra_p IS NULL THEN
    RAISE greska_l;
  END IF;

  OPEN synxrez_c;
  FETCH synxrez_c INTO rez_id_l, cvor_l;
  CLOSE synxrez_c;

  SELECT sifra_tekuceg_cvora INTO tekuci_cvor_l FROM s_vlasnik;

  IF NOT cvor_l = tekuci_cvor_l THEN
    target_cvor_l := '@' || cvor_l;
  END IF;

  EXECUTE IMMEDIATE REPLACE (naredba_azu_dob_l, '<cvor>', target_cvor_l)
    USING rezvsj_id_p, dob_p, br_osoba_dobi_p, unos_korisnik_p;
END;
/* pra_rec_synxis */
PROCEDURE AZURIRAJ_REZGOST_DOB
 (REZVSJ_ID_P IN T_REZ_VSJ.ID%TYPE
 ,DOB_P IN NUMBER
 ,BR_OSOBA_DOBI_P IN NUMBER
 ,UNOS_KORISNIK_P IN VARCHAR2 := NULL
 )
 IS
--
  CURSOR rez_prezime_c IS
    SELECT rez.prezime
      FROM t_rez_vsj rezvsj,
           t_rezervacije rez
     WHERE rezvsj.id = rezvsj_id_p
       AND rez.id = rezvsj.rez_id;

  CURSOR gosti_bez_dobi_c IS
    SELECT rezgost.id id,
           DECODE (rezgost.prezime || '.' || rezgost.ime,
                  rez.prezime || '.' || rez.ime, 1,
                  0) nositelj
      FROM t_rez_gost rezgost,
           t_rez_vsj rezvsj,
           t_rezervacije rez
     WHERE rezgost.rezvsj_id = rezvsj_id_p
       AND rezvsj.id = rezgost.rezvsj_id
       AND rez.id = rezvsj.rez_id
       AND NVL (rezgost.dob, pra_rec_s3.dob (rezgost.dat_rodjenja, rez.dat_dolaska)) IS NULL
     ORDER BY rezgost.rbr DESC;

  rezgost_l       gosti_bez_dobi_c%ROWTYPE;
  br_osoba_dobi_l t_rez_vsj.br_osoba%TYPE;
  rez_prezime_l   t_rezervacije.prezime%TYPE;

  upisane_sve_osobe NUMBER(2);

  datum_za_dob_l  szmp_parametri.vrijednost%TYPE;
  vanj_sustav_l szmp_parametri.vrijednost%TYPE;
BEGIN

  EXECUTE IMMEDIATE 'SELECT UPPER (pra_zmp_zaj.zmppar_vrijednost' || pra_zmp_s.at_centar || ' (''REC'', ''1136'')) FROM DUAL'
    INTO vanj_sustav_l;

  IF vanj_sustav_l = 'PHOBS2' THEN
    EXECUTE IMMEDIATE 'SELECT pra_zmp_zaj.zmppar_vrijednost' || pra_zmp_s.at_centar || ' (''PHOBS2'', ''1020'') FROM DUAL'
    INTO datum_za_dob_l;
  END IF;

  OPEN rez_prezime_c;
  FETCH rez_prezime_c INTO rez_prezime_l;
  CLOSE rez_prezime_c;

  SELECT MIN (rezvsj.br_osoba) - NVL (COUNT (rezgost.id), 0)
    INTO upisane_sve_osobe
    FROM t_rez_gost rezgost,
         t_rez_vsj rezvsj
   WHERE rezvsj.id = rezvsj_id_p
     AND rezgost.rezvsj_id (+) = rezvsj.id;

  SELECT COUNT(*)
    INTO br_osoba_dobi_l
    FROM t_rez_gost rezgost,
         t_rez_vsj rezvsj,
         t_rezervacije rez
   WHERE rezgost.rezvsj_id(+) = rezvsj_id_p
     AND rezvsj.id = rezgost.rezvsj_id
     AND rez.id = rezvsj.rez_id
     AND NVL (rezgost.dob, pra_rec_s3.dob (rezgost.dat_rodjenja, DECODE (datum_za_dob_l, '0', rez.datum, '1', rez.dat_dolaska, '2', rez.dat_odlaska, rez.dat_dolaska))) = dob_p;

  IF br_osoba_dobi_l < br_osoba_dobi_p THEN
    OPEN gosti_bez_dobi_c;
    FETCH gosti_bez_dobi_c INTO rezgost_l;
    FOR i IN 1..(br_osoba_dobi_p - br_osoba_dobi_l) LOOP
      IF gosti_bez_dobi_c%FOUND AND
        (rezgost_l.nositelj = 1 AND upisane_sve_osobe = 0 OR
         rezgost_l.nositelj = 0)
      THEN
        UPDATE t_rez_gost
           SET dob = dob_p
         WHERE id = rezgost_l.id;
        FETCH gosti_bez_dobi_c INTO rezgost_l;
      ELSE
        INSERT INTO t_rez_gost (rezvsj_id, ime, prezime, dob, ozn_ispis_hk, ozn_gratis, unos_korisnik, unos_dat)
          VALUES (rezvsj_id_p, '.', rez_prezime_l, dob_p, 0, 0, NVL (unos_korisnik_p, zmp_zaj.korisnik (-1)), SYSDATE);
      END IF;
    END LOOP;
    CLOSE gosti_bez_dobi_c;
  END IF;
END;
/* pra_rec_synxis */
PROCEDURE DODAJ_PRERACUNATU_CIJENU_USL
 (SYNXIS_SIFRA_P IN VARCHAR2
 ,VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,VSJ_ID_P IN NUMBER
 ,USL_ID_P IN NUMBER
 ,DAT_POC_P IN DATE
 ,DAT_ZAV_P IN DATE
 ,IZNOS_P IN NUMBER
 ,UNOS_KORISNIK_P IN VARCHAR2 := NULL
 )
 IS
--
  rez_id_l               t_rez_vsj.rez_id%TYPE;
  target_cvor_l          VARCHAR2 (41) := '';
  greska_l               EXCEPTION;

  naredba_preracunaj_l VARCHAR2 (2000) :=
    'BEGIN
       pra_rez_rasporedi.preracunaj_cijenu_usluge<cvor> (:1, :2, :3, :4, :5, :6, :7);
     END;';
BEGIN

  IF synxis_sifra_p IS NULL THEN
    RAISE greska_l;
  END IF;

  /*
  vrati id i cvor t_rezervacije za zadani broj rezervacije
  */
  vrati_rez_id_cvor
       (synxis_sifra_p => synxis_sifra_p
       ,vanj_sustav_p => vanj_sustav_p
       ,creator_id_p => creator_id_p
       ,recsosus_sifra_p => recsosus_sifra_p
       ,rez_id_p => rez_id_l
       ,target_cvor_p => target_cvor_l
       );

  EXECUTE IMMEDIATE REPLACE (naredba_preracunaj_l, '<cvor>', target_cvor_l)
    USING rez_id_l, vsj_id_p, usl_id_p, dat_poc_p, dat_zav_p, iznos_p, unos_korisnik_p;

END;
PROCEDURE DODAJ_PKAPD
 (REZ_ID_P IN T_REZERVACIJE.ID%TYPE
 ,NAPOMENA_P IN T_REZERVACIJE.NAPOMENA%TYPE
 ,UNOS_KORISNIK_P IN VARCHAR2 := NULL
 )
 IS
--
  jir_l     tpka_pdokumenti.jir%TYPE;
  poc_jir_l NUMBER(4);

  zki_l     tpka_pdokumenti.zki%TYPE;
  poc_zki_l NUMBER(4);
BEGIN
  IF TRUNC (SYSDATE) >= pra_zmp_s.dat_prestanka_pd THEN -- IRN 4079
    RETURN;
  END IF;

  IF INSTR (napomena_p, '{FiscalResponse:[') > 0 THEN
    poc_jir_l := INSTR (napomena_p, '[JIR:');
    IF poc_jir_l > 0 THEN
      poc_jir_l := poc_jir_l + 5;
      jir_l := SUBSTR (napomena_p, poc_jir_l, INSTR (napomena_p, ']', poc_jir_l, 1) - poc_jir_l);
    END IF;

    poc_zki_l := INSTR (napomena_p, '[ZKI:') + 5;
    zki_l := SUBSTR (napomena_p, poc_zki_l, INSTR (napomena_p, ']', poc_zki_l, 1) - poc_zki_l);

    IF zki_l IS NOT NULL THEN
      puni_pkapd (rez_id_p, zki_l, jir_l, NULL, NULL, NULL, NULL, unos_korisnik_p);
    END IF;
  END IF;
END;
PROCEDURE PUNI_PKAPD
 (REZ_ID_P IN TPKA_PDOKUMENTI.REZ_ID%TYPE
 ,ZKI_P IN TPKA_PDOKUMENTI.ZKI%TYPE
 ,JIR_P IN TPKA_PDOKUMENTI.JIR%TYPE
 ,DATUM_P IN TPKA_PDOKUMENTI.DATUM%TYPE
 ,IZNOS_P IN TPKA_PDOKUMENTI.IZNOS%TYPE
 ,VAL_ID_P IN TPKA_PDOKUMENTI.VAL_ID%TYPE
 ,NAPOMENA_P IN TPKA_PDOKUMENTI.NAPOMENA%TYPE
 ,UNOS_KORISNIK_P IN VARCHAR2 := NULL
 )
 IS
--
  pkapd_row_l tpka_pdokumenti%ROWTYPE;
  ima_pkapd_l NUMBER;
  pkapd_id_l NUMBER;
  ban_id_l s_vapldok.ban_id%TYPE;
  vtec_id_l s_vapldok.vtec_id%TYPE;
BEGIN

  IF rez_id_p IS NULL
    OR zki_p IS NULL
    -- OR jir_p IS NULL
    OR TRUNC (SYSDATE) >= pra_zmp_s.dat_prestanka_pd -- IRN 4079
  THEN
    RETURN;
  END IF;

  -- da li postoji prateci dokument za istu rezervaciju i zki
  SELECT COUNT(1)
    INTO ima_pkapd_l
    FROM tpka_pdokumenti
   WHERE rez_id = rez_id_p
     AND zki = zki_p
     -- AND jir = jir_p
   ;

  -- ako ne postoji prateci dokument za istu rezervaciju i zki onda insert PD
  IF ima_pkapd_l = 0 THEN

    pkapd_row_l.ozn_vlastiti := 0; -- nije vlastiti pratei dokument
    pkapd_row_l.rez_id := rez_id_p;
    pkapd_row_l.zki := zki_p;
    pkapd_row_l.jir := jir_p;

    IF iznos_p IS NOT NULL THEN

      IF val_id_p IS NOT NULL THEN -- dodano 28.07.2020 VS
        pkapd_row_l.iznos := iznos_p;
        pkapd_row_l.val_id := val_id_p;
      END IF;

      SELECT ban_id, vtec_id
        INTO ban_id_l, vtec_id_l
        FROM s_vapldok
       WHERE metapl_sifra = 'REC'
         AND oznaka = 'GI';

      IF ban_id_l IS NULL OR vtec_id_l IS NULL THEN
        -- Provjerite banku i vrstu tecajeva za vrstu aplikacijskih dokumenata REC GI.
        pra_zmp_zaj.vrati_poruku (-20098, pra_zmp_zaj.poruka ('ZMP', 'ZMP0146'));
      ELSE
        -- IRN 3541
        pra_pka_s3.vrati_izn_tecaja (val_id_p, ban_id_l, vtec_id_l, datum_p, pkapd_row_l.izn_tecajat, pkapd_row_l.izn_tecaja);
      END IF;

    END IF;

    pkapd_row_l.datum := datum_p;
    pkapd_row_l.napomena := napomena_p;
    pkapd_row_l.unos_korisnik := NVL (unos_korisnik_p, zmp_zaj.korisnik (-1));
    pkapd_row_l.unos_dat := SYSDATE;

    INSERT INTO tpka_pdokumenti VALUES pkapd_row_l;

  -- ako postoji prateci dokument za istu rezervaciju i zki, i poslan je jir; onda update jir
  ELSIF (ima_pkapd_l > 0) AND jir_p IS NOT NULL THEN

    SELECT id
      INTO pkapd_id_l
      FROM tpka_pdokumenti
     WHERE rez_id = rez_id_p
       AND zki = zki_p;

    UPDATE tpka_pdokumenti
       SET jir = jir_p
     WHERE id = pkapd_id_l
       AND jir IS NULL;

  END IF;
END;
PROCEDURE VRATI_REZ_ID_CVOR
 (SYNXIS_SIFRA_P IN lsynxis_rezervacije.synxis_sifra%TYPE
 ,VANJ_SUSTAV_P IN LSYNXIS_REZERVACIJE.VANJ_SUSTAV%TYPE
 ,CREATOR_ID_P IN lsynxis_rezervacije.creator_id%TYPE
 ,RECSOSUS_SIFRA_P IN lsynxis_rezervacije.recsosus_sifra%TYPE
 ,REZ_ID_P OUT t_rezervacije.id%TYPE
 ,TARGET_CVOR_P OUT VARCHAR2
 )
 IS
/*
Trai rezervaciju na osnovu lsynxis_rezervacije.synxis_sifra parametra, to je broj rezervacije u vanjskom sustavu
Za Phobs jo na osnovi Creator_id i recsosus_sifra.
Poziva se iz iz dosta procedura.

izlazni parametri: id MISH rezervacije i cvor na kojem se rezervacija nalazi
*/

  greska_l EXCEPTION;
  cvor_l m_so.metcvor_sifra%TYPE;
  tekuci_cvor_l m_so.metcvor_sifra%TYPE;
  target_cvor_l VARCHAR2(41) := '';

  -- trai rezervaciju samo preko ifre
  CURSOR synxrez_c IS
    SELECT rez_id, metcvor_sifra
      FROM lsynxis_rezervacije
     WHERE synxis_sifra = synxis_sifra_p
       AND creator_id IS NULL
       AND recsosus_sifra IS NULL
       AND vanj_sustav = vanj_sustav_p;

  -- trai rezervaciju preko kompletnog UK
  CURSOR synxrez1_c IS
    SELECT rez_id, metcvor_sifra
      FROM lsynxis_rezervacije
     WHERE synxis_sifra = synxis_sifra_p
       AND creator_id = creator_id_p
       AND recsosus_sifra = recsosus_sifra_p
       AND vanj_sustav = vanj_sustav_p;
BEGIN

  /*
  provjeri ulazni parametar
  */
  IF synxis_sifra_p IS NULL THEN
    RAISE greska_l;
  END IF;

  /*
  vrati id i cvor t_rezervacije iz lsynxis_rezervacije
  za PHOBS prema kompletnom kljuu
  */
  IF vanj_sustav_p = 'PHOBS2' THEN
    OPEN synxrez1_c;
    FETCH synxrez1_c INTO rez_id_p, cvor_l;
    CLOSE synxrez1_c;
  END IF;

  -- ako PHOBS rezervacija prema kompletnom kljuu nije naena ili sustav nije PHOBS2 trai rezervaciju samo po synxis_sifra_p
  IF rez_id_p IS NULL THEN
    OPEN synxrez_c;
    FETCH synxrez_c INTO rez_id_p, cvor_l;
    CLOSE synxrez_c;
  END IF;

  IF rez_id_p IS NULL THEN
    RETURN;
  END IF;

  /*
  vrati sifru cvora baze
  */
  SELECT sifra_tekuceg_cvora INTO tekuci_cvor_l FROM s_vlasnik;
  IF NOT cvor_l = tekuci_cvor_l THEN
    target_cvor_l := '@' || cvor_l;
  END IF;

  target_cvor_p := target_cvor_l;
END;
/* pra_rec_synxis */
PROCEDURE AZU_PPORD
 (REZ_ID_P IN T_REZERVACIJE.ID%TYPE
 ,BR_UPUTNICE_P IN t_rezervacije.br_uputnice%TYPE
 ,CREATOR_ID_P IN t_rezervacije.creator_id%TYPE
 )
 IS
-- ako u tpp_orders postoji odgovarajui nepovezan redak povezuje ga na rezervaciju
BEGIN
  UPDATE tpp_orders
     SET rez_id = rez_id_p
   WHERE rez_id IS NULL
     AND order_type = 1 -- 1 = Card on File (COF)
     AND status = 2     -- 2 = Completed
     AND merchant_reference_id = br_uputnice_p || '|' || creator_id_p;
END;

END PRA_REC_SYNXIS;
/
SHOW ERROR

