PROMPT Creating Package Body 'PRA_REC_S2'
CREATE OR REPLACE PACKAGE BODY PRA_REC_S2 IS

FUNCTION CIJENA_PRIPADA_CVORU
 (CJE_ID_P IN t_cjenici.id%TYPE
 ,SO_ID_P IN m_so.id%TYPE
 ,METCVOR_SIFRA_P IN smet_cvorovi.sifra%TYPE
 )
 RETURN NUMBER
 IS
/*
cijena pripada voru:
- ako je vor = centar
- ako se cijena odnosi na objekt na tom voru
- ako je vor jedan od onih na koje je kopirana valjana ponuda
za taj so i cjenik (za ponudu mogu vaiti dva cjenika -
onaj upisan u ponudi i onaj za BP)
!!! ITA PONUDE - kod koritenja paziti na mutiranje
!!! ITA CJENIK, PARAMETRE
*/
  br_redaka_l NUMBER;
BEGIN
  IF so_id_p IS NULL OR cje_id_p IS NULL OR metcvor_sifra_p IS NULL THEN
    RETURN (0);
  END IF;
  -- metcvor_sifra_p je centar
  IF UPPER (pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0018')) = UPPER (metcvor_sifra_p)
    OR (UPPER (metcvor_sifra_p) = pra_zmp_zaj.tekuci_cvor
       AND pra_zmp_zaj.centar = -1)
  THEN
    RETURN (-1);
  END IF;

  SELECT COUNT (metcvor_sifra) INTO br_redaka_l
    FROM
        (
        -- metcvor_sifra_p jednak je voru objekta
        SELECT metcvor_sifra
          FROM m_so
         WHERE id = so_id_p
         AND UPPER (metcvor_sifra) = UPPER (metcvor_sifra_p)
        UNION
        -- metcvor_sifra je jedan od onih na kojima se koristi ponuda drugog SO
        SELECT so.metcvor_sifra
          FROM t_ponude pon, t_pon_ojr ponojr, t_pon_so ponso, t_ponso_so ponsoso, m_so so
         WHERE pon.id = ponojr.pon_id
           AND ponojr.id = ponso.ponojr_id
           AND ponso.id = ponsoso.ponso_id
           AND ponsoso.so_id = so.id
           AND ponso.so_id = so_id_p
           AND pon.oznaka = 'V'
           AND (pon.cje_id = cje_id_p
                OR (pon.ozn_cje_poseb = -1
                    AND
                    cje_id_p =
                      (SELECT cje.id
                         FROM t_cjenici cje
                        WHERE cje.sifra = pra_zmp_zaj.zmppar_vrijednost ('REC', '1068'))
                   )
               )
           AND so.metcvor_sifra = metcvor_sifra_p
        );
  IF br_redaka_l > 0 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;
END;
FUNCTION ZAKKOR_NAZIV
 (ZAKSJ_ID_P IN t_zak_korisnici.zaksj_id%TYPE
 )
 RETURN VARCHAR2
 IS
/*
Prvi korisnik zakupljene SJ poredano po id.
*/
  CURSOR zakkor_c IS
    SELECT prezime || ', ' || ime
      FROM t_zak_korisnici
     WHERE zaksj_id = zaksj_id_p
     ORDER BY id;
  zakkor_naziv_l VARCHAR2(50);
BEGIN
  IF zaksj_id_p IS NULL THEN
    RETURN (NULL);
  END IF;
  OPEN zakkor_c;
  FETCH zakkor_c INTO zakkor_naziv_l;
  CLOSE zakkor_c;
  RETURN (zakkor_naziv_l);
END;
FUNCTION PKARACP_PRIPADA_GOSTU
 (PKARACP_ID_P IN tpka_racuni.id%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE
 )
 RETURN NUMBER
 IS
-- Predujam pripada gostu ako pripada rezervaciji gosta.
  br_redaka_l NUMBER;
BEGIN
  IF pkaracp_id_p IS NULL
    OR gost_id_p IS NULL
  THEN
    RETURN (0);
  END IF;

  SELECT COUNT (rezpred.rowid) INTO br_redaka_l
    FROM t_rez_pred rezpred,
         t_rezervacije rez,
         t_rez_vsj rezvsj,
         t_gosti gost
   WHERE rezpred.pkaracp_id = pkaracp_id_p
     AND rezpred.rez_id = rez.id
     AND rezvsj.rez_id = rez.id
     AND gost.rezvsj_id = rezvsj.id
     AND gost.id = gost_id_p;
  IF br_redaka_l = 0 THEN
    RETURN (0);
  ELSE
    RETURN (-1);
  END IF;
END;
FUNCTION IZNOS_RACUNA_BRUTO
 (RAC_ID_P IN t_racuni.id%TYPE
 ,IZNOS_P IN t_racuni.iznos%TYPE
 ,IZN_TECAJA_P IN t_racuni.izn_tecaja%TYPE
 )
 RETURN t_racuni.iznos%TYPE
 IS
-- iznos rauna uvean za predujam
  izn_racpred_l t_rac_pred.iznos%TYPE;
BEGIN
  IF rac_id_p IS NULL OR iznos_p IS NULL OR izn_tecaja_p IS NULL THEN
    RETURN 0;
  END IF;
  SELECT SUM (ROUND (t_rac_pred.iznos * t_rac_pred.izn_tecaja / izn_tecaja_p, 2))
    INTO izn_racpred_l
    FROM t_rac_pred
   WHERE rac_id = rac_id_p;

  RETURN (iznos_p + NVL (izn_racpred_l, 0));
END;
FUNCTION RECSPOK_OZN_IZVEDENA
 (RECSPOK_ID_P IN mrec_spokazatelja.id%TYPE
 )
 RETURN VARCHAR2
 IS
/*
Stavka pokazatelja uspjenosti je izvedena
ako je etvrta znamenka ifre = 1.
*/
  br_redaka_l NUMBER;
BEGIN
  IF recspok_id_p IS NULL THEN
    RETURN (0);
  END IF;

  SELECT COUNT (1) INTO br_redaka_l
    FROM mrec_spokazatelja
   WHERE id = recspok_id_p
     AND SUBSTR (sifra, 4, 1) = 1;

  IF br_redaka_l > 0 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;

END;
FUNCTION RECSPOK_OZN_MS
 (RECSPOK_ID_P IN mrec_spokazatelja.id%TYPE
 )
 RETURN NUMBER
 IS
/*
Stavka pokazatelja uspjenosti rauna se po MS
ako je peta znamenka ifre = 1.
*/
  br_redaka_l NUMBER;
BEGIN
  IF recspok_id_p IS NULL THEN
    RETURN (0);
  END IF;

  SELECT COUNT (1) INTO br_redaka_l
    FROM mrec_spokazatelja
   WHERE id = recspok_id_p
     AND SUBSTR (sifra, 5, 1) = 1;

  IF br_redaka_l > 0 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;

END;
FUNCTION RECSPOK_SIFRA
 (RECSPOK_ID_P IN mrec_spokazatelja.id%TYPE
 )
 RETURN mrec_spokazatelja.sifra%TYPE
 IS
/*
ifra stavke pokazatelja uspjenosti
*/
  CURSOR recspok_c IS
    SELECT sifra
      FROM mrec_spokazatelja
     WHERE id = recspok_id_p;
  recspok_sifra_l mrec_spokazatelja.sifra%TYPE;
BEGIN
  OPEN recspok_c;
  FETCH recspok_c INTO recspok_sifra_l;
  CLOSE recspok_c;
  RETURN (recspok_sifra_l);
END;
FUNCTION SO_PRIPADA_TEKUCEM_CVORU
 (SO_ID_P IN m_so.id%TYPE
 )
 RETURN NUMBER
 IS
--
  br_redaka_l NUMBER;
BEGIN
  IF so_id_p IS NULL THEN
    RETURN (-1);
  END IF;
  SELECT COUNT (1) INTO br_redaka_l
    FROM m_so
   WHERE id = so_id_p
     AND metcvor_sifra = pra_zmp_zaj.tekuci_cvor;
  IF br_redaka_l = 0 THEN
    RETURN 0;
  ELSE
    RETURN (-1);
  END IF;
END;
FUNCTION IZNOS_USLUGE
 (PONSO_ID_P IN t_pon_so.id%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 ,CJE_ID_P IN t_cjenici.id%TYPE
 ,SO_ID_P IN m_so.id%TYPE
 ,VSJ_ID_P IN s_vsj.id%TYPE
 ,USL_ID_P IN s_usluge.id%TYPE
 ,OZN_USL1_P IN NUMBER
 ,OZN_UGO_P IN NUMBER
 ,DAT_POC_P IN DATE
 ,DAT_ZAV_P IN DATE
 ,KOL_SJ_P IN NUMBER
 ,BR_OSOBA_P IN NUMBER
 ,RECVPRO_ID_P IN mrec_vprograma.id%TYPE := NULL
 ,RECARA_ID_P IN mrec_aranzmani.id%TYPE
 ,BR_DANA_BORAVKA_P IN NUMBER
 ,ZMPPOP1_ID_P IN mzmp_popusti.id%TYPE
 ,STOPA_POPUSTA1_P IN t_racuni.stopa_popusta1%TYPE
 ,ZMPPOP3_ID_P IN mzmp_popusti.id%TYPE
 ,ZMPPOP4_ID_P IN mzmp_popusti.id%TYPE
 ,STOPA_POPUSTA4_P IN t_racuni.stopa_popusta4%TYPE
 )
 RETURN NUMBER
 IS
PRAGMA AUTONOMOUS_TRANSACTION;  -- da bi se mogla koristiti u SQL-u
/*
Procedura izrauna iznos usluge za zadani cjenik, so, vsj, usl,
razdoblje i kol_sj odnosno br_osoba.
Cjenik se puni prema poslanom dokumentu (ponso ili rez)
(u valuti cjenika)
Budui se koristi smao za izraun iz ponude radi samo sa popustima 1,2,4.
*/
/*
pra_rec_s2.iznos_usluge
   (ponso_id_p =>
   ,rez_id_p =>
   ,cje_id_p =>
   ,so_id_p =>
   ,vsj_id_p =>
   ,usl_id_p =>
   ,ozn_usl1_p =>
   ,ozn_ugo_p =>
   ,dat_poc_p =>
   ,dat_zav_p =>
   ,kol_sj_p =>
   ,br_osoba_p =>
   ,recvpro_id_p =>
   ,recara_id_p =>
   ,br_dana_boravka =>
   ,zmppop1_id =>
   ,sto_pop1 =>
   ,zmppop3_id =>
   ,zmppop4_id =>
   ,sto_pop4 =>
   )
*/

  dat_poc_l DATE;
  dat_zav_l DATE;
  datum_l DATE;
  dat_cje_prethodni_l DATE;
  obr_zdana_l s_usluge.obr_zdana%TYPE;
  obr_po_danu_l s_usluge.obr_po_danu%TYPE;
  ozn_cje_vsj_l s_usluge.ozn_cje_vsj%TYPE;
  kolicina_l NUMBER;
  cijena_usluge_l t_cje_usl.cijena_usluge%TYPE;
  iznos_l NUMBER := 0;
  iznos_pom_l NUMBER;
  ozn_cje_ara_l mrec_ara_usl.ozn_cje_ara%TYPE := 0;

  CURSOR recarausl_c IS
    SELECT ozn_cje_ara FROM mrec_ara_usl WHERE usl_id = usl_id_p AND recara_id = recara_id_p;
BEGIN
  IF (ponso_id_p IS NULL AND rez_id_p IS NULL)
    OR dat_poc_p IS NULL OR dat_zav_p IS NULL
    OR so_id_p IS NULL OR cje_id_p IS NULL OR usl_id_p IS NULL
    OR dat_zav_p < dat_poc_p
  THEN
    RETURN 0;
  END IF;

  /* zapamtiti obraun zadnjeg dana, koliina */
  SELECT obr_zdana,
         obr_po_danu,
         ozn_cje_vsj,
         -- ako je obr_osoba=-1 i ozn_cijenasj=0 => br_osoba inae kol_sj
         DECODE (obr_osoba * (ozn_cijenasj + 1), -1, br_osoba_p, kol_sj_p)
    INTO obr_zdana_l, obr_po_danu_l, ozn_cje_vsj_l, kolicina_l
    FROM s_usluge
   WHERE id = usl_id_p;

  IF obr_po_danu_l = 0 THEN
    dat_zav_l := dat_poc_p;
    dat_cje_prethodni_l := dat_poc_p + 1;
  ELSIF obr_zdana_l = -1 THEN
    dat_zav_l := dat_zav_p;
    dat_cje_prethodni_l := dat_zav_p + 1;
  ELSE
    dat_zav_l := dat_zav_p;
    dat_cje_prethodni_l := dat_zav_p;
  END IF;

  pra_rec_iud.puni_prec_cje_usl (
    ponso_id_p => ponso_id_p,
    rez_id_p => rez_id_p,
    usl_id_p => usl_id_p,
    dat_poc_p => dat_poc_p,
    dat_zav_p => dat_zav_p,
    recvpro_id_p => recvpro_id_p);

  LOOP
    SELECT MAX (dat_poc) INTO datum_l
      FROM prec_cje_usl
     WHERE cje_id = cje_id_p
       AND so_id = so_id_p
       AND NVL (vsj_id, 0) = DECODE (ozn_cje_vsj_l, -1, vsj_id_p, 0, 0)
       AND usl_id = usl_id_p
       AND NVL (recara_id, 0) = DECODE (ozn_cje_ara_l, -1, recara_id_p, 0, 0)
       AND ozn_ugo = ozn_ugo_p
       AND dat_poc < dat_cje_prethodni_l;
    IF datum_l IS NOT NULL THEN
      SELECT DECODE (ozn_usl1_p, 0, cijena_usluge, NVL (cje_usl_obr, cijena_usluge))
        INTO cijena_usluge_l
        FROM prec_cje_usl
       WHERE cje_id = cje_id_p
         AND so_id = so_id_p
         AND NVL (vsj_id, 0) = DECODE (ozn_cje_vsj_l, -1, vsj_id_p, 0, 0)
         AND usl_id = usl_id_p
         AND NVL (recara_id, 0) = DECODE (ozn_cje_ara_l, -1, recara_id_p, 0, 0)
         AND ozn_ugo = ozn_ugo_p
         AND dat_poc = datum_l;
      SELECT GREATEST (dat_poc_p, datum_l) INTO dat_poc_l FROM dual;
      -- obr_zdana mora utjecati samo na zadnju sezonu i ako iznos ovisi o broju dana u razdoblju
      IF obr_po_danu_l = 0 THEN
        iznos_pom_l :=   cijena_usluge_l * kolicina_l;
      ELSIF dat_cje_prethodni_l > dat_zav_p THEN
        iznos_pom_l := cijena_usluge_l *  (dat_zav_l - dat_poc_l - obr_zdana_l) * kolicina_l;
      ELSE
        iznos_pom_l := cijena_usluge_l * (dat_zav_l - dat_poc_l) * kolicina_l;
      END IF;
      iznos_l := iznos_l + iznos_pom_l
        * (1 - pra_rec_s2.stopa_odbitka (
                 so_id_p => so_id_p,
                 vsj_id_p => vsj_id_p,
                 usl_id_p => usl_id_p,
                 dat_poc_p => dat_poc_l,
                 dat_zav_p => dat_zav_l,
                 br_dana_boravka_p => br_dana_boravka_p,
                 zmppop1_id_p => zmppop1_id_p,
                 stopa_popusta1_p => stopa_popusta1_p,
                 zmppop2_id_p => NULL,
                 stopa_popusta2_p => NULL,
                 zmppop3_id_p => zmppop3_id_p,
                 stopa_popusta3_p => NULL,
                 zmppop4_id_p => zmppop4_id_p,
                 stopa_popusta4_p => stopa_popusta4_p)
           / 100);
      dat_zav_l := dat_poc_l;
      dat_cje_prethodni_l := datum_l;
    ELSE
      EXIT;
    END IF;
    EXIT WHEN dat_zav_l <= dat_poc_p;
  END LOOP;
  ROLLBACK;  -- zavrava autonomnu transakciju
  RETURN iznos_l;
END;
FUNCTION ZAK_IZN_UGOVORENO
 (ZAK_ID_P IN t_zakup.id%TYPE
 )
 RETURN t_troskovi.iznos%TYPE
 IS
-- Ugovoreni iznos po ugovoru o zakupu
  zak_izn_ugovoreno_l t_troskovi.iznos%TYPE;
BEGIN
  IF zak_id_p IS NULL THEN
    RETURN (0);
  END IF;

  SELECT SUM (kolicina * cijena) INTO zak_izn_ugovoreno_l
    FROM trec_zak_usl
   WHERE zak_id = zak_id_p;

  RETURN (NVL (zak_izn_ugovoreno_l, 0));
END;
FUNCTION ZAK_IZN_ZARACUNATO
 (ZAK_ID_P IN t_zakup.id%TYPE
 )
 RETURN t_troskovi.iznos%TYPE
 IS
-- Zaraunati iznos troka po ugovoru o zakupu
  zak_izn_zaracunato_l t_troskovi.iznos%TYPE;
BEGIN
  IF zak_id_p IS NULL THEN
    RETURN (0);
  END IF;

  SELECT SUM (tro.iznos) INTO zak_izn_zaracunato_l
    FROM t_troskovi tro,
         t_racuni rac,
         t_zakup zak,
         trec_zak_usl reczakusl
   WHERE tro.rac_id = rac.id
     AND tro.usl_id = reczakusl.usl_id
     AND tro.val_id = zak.val_id
     AND rac.zak_id = zak.id
     AND reczakusl.zak_id = zak.id
     AND zak.id = zak_id_p;

  RETURN (NVL (zak_izn_zaracunato_l, 0));
END;
FUNCTION AGE_IMEP_OSOBEODG
 (AGE_ID_P IN m_agencije.id%TYPE
 )
 RETURN m_agencije.imep_osobeodg%TYPE
 IS
-- ime i prezime odgovorne osobe zadane agencije
  CURSOR age_c IS
    SELECT imep_osobeodg
      FROM m_agencije
     WHERE id = age_id_p;
  imep_osobeodg_l m_agencije.imep_osobeodg%TYPE;
BEGIN
  IF age_id_p IS NULL THEN
    RETURN (NULL);
  END IF;
  OPEN age_c;
  FETCH age_c INTO imep_osobeodg_l;
  CLOSE age_c;
  RETURN (imep_osobeodg_l);
END;
FUNCTION ZEM_PLAT
 (GOST_ID_P IN t_gosti.id%TYPE
 ,AGE_ID_P IN m_agencije.id%TYPE
 ,PKAADR_ID_P IN mpka_adrese.id%TYPE
 ,GMPKOM_ID_P IN mgmp_komitenti.id%TYPE := NULL
 )
 RETURN VARCHAR2
 IS
--
  CURSOR zemlje_c (zem_id_k s_zemlje.id%TYPE) IS
    SELECT sifra_2a
      FROM s_zemlje
     WHERE id = zem_id_k;

  zem_plat_l s_zemlje.sifra_2a%TYPE;
  zem_id_l s_zemlje.id%TYPE;
BEGIN

  IF gost_id_p IS NULL
    AND age_id_p IS NULL
    AND pkaadr_id_p IS NULL
    AND gmpkom_id_p IS NULL
  THEN
    zem_plat_l := NULL;
    RETURN (zem_plat_l);
  END IF;

  IF gost_id_p IS NOT NULL THEN
    SELECT zem_id INTO zem_id_l FROM t_gosti WHERE id = gost_id_p;

  ELSIF age_id_p IS NOT NULL THEN
    SELECT zem_id INTO zem_id_l FROM m_agencije WHERE id = age_id_p;

  ELSIF pkaadr_id_p IS NOT NULL THEN
    SELECT zem_id INTO zem_id_l FROM mpka_adrese WHERE id = pkaadr_id_p;

  ELSIF gmpkom_id_p IS NOT NULL THEN
    SELECT zem_id INTO zem_id_l FROM mgmp_komitenti WHERE id = gmpkom_id_p;

  END IF;

  OPEN zemlje_c (zem_id_l);
  FETCH zemlje_c INTO zem_plat_l;
  IF zemlje_c%NOTFOUND THEN
    zem_plat_l := NULL;
  END IF;
  CLOSE zemlje_c;

  RETURN zem_plat_l;

END;
FUNCTION GOST_ID_1
 (SJ_ID_P IN t_gosti.sj_id%TYPE
 ,DAT_POC_P IN DATE
 ,DAT_ZAV_P IN DATE
 )
 RETURN t_gosti.id%TYPE
 IS
/*
Prvi gost odabrane SJ u odabranom razdoblju poredano po
oznaci prisutnosti, oznaci platitelja i rednom broju.
*/
  CURSOR gost_c IS
    SELECT id
      FROM t_gosti
     WHERE sj_id = sj_id_p
       AND dat_dolaska <= dat_zav_p
       AND dat_odlaska >= dat_poc_p
     ORDER BY ozn_prisutnosti DESC, ozn_platitelj, rbr;
  gost_id_l t_gosti.id%TYPE;
BEGIN
  IF sj_id_p IS NULL
    OR dat_poc_p IS NULL
    OR dat_zav_p IS NULL
  THEN
    RETURN (NULL);
  END IF;

  OPEN gost_c;
  FETCH gost_c INTO gost_id_l;
  CLOSE gost_c;
  RETURN (gost_id_l);
END;
FUNCTION CIJENA_USL
 (PONSO_ID_P IN t_ponude.id%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 ,CJE_ID_P IN t_cjenici.id%TYPE
 ,SO_ID_P IN m_so.id%TYPE
 ,VSJ_ID_P IN s_vsj.id%TYPE
 ,USL_ID_P IN s_usluge.id%TYPE
 ,OZN_USL1_P IN NUMBER
 ,OZN_UGO_P IN NUMBER
 ,OZN_CJE_VSJ_P IN NUMBER
 ,DATUM_P IN t_cje_usl.datum%TYPE
 ,RECVPRO_ID_P IN mrec_vprograma.id%TYPE := NULL
 ,RECARA_ID_P IN mrec_aranzmani.id%TYPE := NULL
 )
 RETURN NUMBER
 IS
PRAGMA AUTONOMOUS_TRANSACTION;  -- da bi se mogla koristiti u SQL-u
/*
Dokumenti se proslijeuju da bi se mogao napuniti cjenik
SO, cje,..se proslijeuju da se ne bi trebali ponovo itati dokumenti
*/
/*
pra_rec_s2.cijena_usl
   (ponso_id_p =>
   ,rez_id_p =>
   ,cje_id_p =>
   ,so_id_p =>
   ,vsj_id_p =>
   ,usl_id_p =>
   ,ozn_usl1_p =>
   ,ozn_ugo_p =>
   ,ozn_cje_vsj_p =>
   ,datum_p =>
   ,recvpro_id_p =>
   ,recara_id_p =>
*/
  cijena_l t_cje_usl.cijena_usluge%TYPE;
  ozn_cje_ara_l mrec_ara_usl.ozn_cje_ara%TYPE := 0;
  pon_id_l t_ponude.id%TYPE;

  CURSOR cjeusl_c (ozn_cje_ara_k NUMBER) IS
    SELECT DECODE (ozn_usl1_p, 0, cijena_usluge, NVL (cje_usl_obr, cijena_usluge))
      FROM prec_cje_usl
     WHERE cje_id = cje_id_p
       AND so_id = so_id_p
       AND NVL (vsj_id, 0) = DECODE (ozn_cje_vsj_p, -1, vsj_id_p, 0, 0)
       AND usl_id = usl_id_p
       AND NVL (recara_id, 0) = DECODE (ozn_cje_ara_k, -1, recara_id_p, 0, 0)
       AND ozn_ugo = ozn_ugo_p
       AND dat_poc = (
           SELECT MAX (dat_poc)
             FROM prec_cje_usl
            WHERE cje_id = cje_id_p
              AND so_id = so_id_p
              AND NVL (vsj_id, 0) = DECODE (ozn_cje_vsj_p, -1, vsj_id_p, 0, 0)
              AND usl_id = usl_id_p
              AND NVL (recara_id, 0) = DECODE (ozn_cje_ara_k, -1, recara_id_p, 0, 0)
              AND ozn_ugo = ozn_ugo_p
              AND dat_poc <= datum_p);

  CURSOR recarausl_c IS
    SELECT ozn_cje_ara FROM mrec_ara_usl WHERE usl_id = usl_id_p AND recara_id = recara_id_p;
BEGIN
  IF recara_id_p IS NOT NULL THEN
    OPEN recarausl_c;
    FETCH recarausl_c INTO ozn_cje_ara_l;
    CLOSE recarausl_c;
  END IF;

  pra_rec_iud.puni_prec_cje_usl (
    ponso_id_p => ponso_id_p,
    rez_id_p => rez_id_p,
    usl_id_p => usl_id_p,
    recvpro_id_p => recvpro_id_p);

  OPEN cjeusl_c (ozn_cje_ara_l);
  FETCH cjeusl_c INTO cijena_l;
  CLOSE cjeusl_c;
  ROLLBACK;  -- zavrava autonomnu transakciju
  RETURN cijena_l;
END;
FUNCTION GDGOST_ID
 (DAT_RODJENJA_P IN t_kgostiju.dat_rodjenja%TYPE
 ,DAT_DOLASKA_P IN t_gosti.dat_dolaska%TYPE
 ,DOB_P IN NUMBER := NULL
 ,DATUM_P IN DATE := TRUNC (SYSDATE)
 )
 RETURN NUMBER
 IS
-- id dobne grupe gostiju
-- IRN 4023; dodano itanje dat_valjan i dat_ponisten

  dob_l NUMBER;

  CURSOR recgdgost_c (dob_k NUMBER) IS
    SELECT recgdgost.id
      FROM mrec_gdgostiju recgdgost
     WHERE recgdgost.br_godina_poc IN (
           SELECT MAX (recgdgost2.br_godina_poc)
             FROM mrec_gdgostiju recgdgost2
            WHERE recgdgost2.br_godina_poc <= dob_k
              AND recgdgost2.dat_valjan <= datum_p
              AND (recgdgost2.dat_ponisten IS NULL OR recgdgost2.dat_ponisten > datum_p)
           )
       AND recgdgost.dat_valjan <= datum_p
       AND (recgdgost.dat_ponisten IS NULL OR recgdgost.dat_ponisten > datum_p);

  recgdgost_id_l mrec_gdgostiju.id%TYPE;
BEGIN

  dob_l := pra_rec_s3.dob (dat_rodjenja_p, dat_dolaska_p);

  IF dob_l IS NULL THEN
    IF dob_p IS NOT NULL THEN
      dob_l := dob_p;
    ELSE
      dob_l := -1;
    END IF;
  END IF;

  OPEN recgdgost_c (dob_l);
  FETCH recgdgost_c INTO recgdgost_id_l;
  CLOSE recgdgost_c;

  RETURN recgdgost_id_l;
END;
FUNCTION DAT_RODJENJA
 (GOST_ID_P IN t_gosti.id%TYPE
 )
 RETURN t_kgostiju.dat_rodjenja%TYPE
 IS
-- Datum roenja gosta
  CURSOR kgost_c IS
    SELECT dat_rodjenja
      FROM t_kgostiju
     WHERE gost_id = gost_id_p
       AND oznaka = 'V';
  dat_rodjenja_l t_kgostiju.dat_rodjenja%TYPE;
BEGIN
  IF gost_id_p IS NULL THEN
    RETURN (NULL);
  END IF;
  OPEN kgost_c;
  FETCH kgost_c INTO dat_rodjenja_l;
  CLOSE kgost_c;
  RETURN (dat_rodjenja_l);
END;
FUNCTION VALUTA_CJENIKA
 (CJE_ID_P IN t_cjenici.id%TYPE
 )
 RETURN NUMBER
 IS
--
  val_id_l s_valute.id%TYPE;
BEGIN
  SELECT MIN (val_id) INTO val_id_l
    FROM t_cjenici
   WHERE id = cje_id_p;
  RETURN (val_id_l);
END;
FUNCTION SJ_ID_RECGOSTBOR
 (GOST_ID_P IN trec_gost_boravci.gost_id%TYPE
 ,DATUM_P IN trec_gost_boravci.dat_poc%TYPE
 )
 RETURN trec_gost_boravci.sj_id%TYPE
 IS
-- SJ u kojoj je gost boravio na datum_p
  sj_id_l trec_gost_boravci.sj_id%TYPE;
  CURSOR bor_c IS
    SELECT bor.sj_id
      FROM trec_gost_boravci bor
     WHERE bor.gost_id = gost_id_p
       AND bor.dat_poc <= datum_p
       AND bor.dat_zav > datum_p;
BEGIN
  IF gost_id_p IS NULL THEN
    RETURN (NULL);
  END IF;
  OPEN bor_c;
  FETCH bor_c INTO sj_id_l;
  CLOSE bor_c;
  RETURN (sj_id_l);
END;
PROCEDURE PROVJERI_SJ
 (SJ_ID_P IN m_sj.id%TYPE
 ,SO_ID_P IN m_so.id%TYPE
 ,VSJ_ID_P IN t_rez_vsj.vsj_id%TYPE
 ,DAT_POC_P IN m_sj.dat_valjan%TYPE
 ,DAT_ZAV_P IN m_sj.dat_ponisten%TYPE
 ,OZN_VSJS_P IN NUMBER := 0
 ,SJS_ID_P IN m_sj.id%TYPE := NULL
 )
 IS
/*

SJ mora pripadati SO, VSJ (ili VSJS/VSJUS za sastavljenu VSJ) i biti valjana u razdoblju
Ako neki od tih podataka nije naveden ne kontrolira se

ozn_vsjs_p moe biti
0 - uobiajena provjera,
provjerava se da li SJ pripada VSJ

1 - provjera za rezvsj,
ako poslana VSJ nije sastavljena provjerava se da li SJ pripada VSJ
ako je poslana VSJ sastavljena provjerava se da li SJ pripada sastavljenoj VSJ

2 - provjera za recrezsj,
ako poslana VSJ nije sastavljena provjerava se da li SJ pripada VSJ
ako je poslana VSJ sastavljena onda SJ mora pripadati  poslanoj SJS i biti valjana u razdoblju

*/

  dat_max_c DATE := TO_DATE ('31.12.9999', 'DD.MM.RRRR');
  dat_min_c DATE := TO_DATE ('01.01.0001', 'DD.MM.RRRR');

  CURSOR sj_c (vsj_id_k NUMBER) IS
    SELECT id
      FROM m_sj
     WHERE id = sj_id_p
       AND so_id = NVL (so_id_p, so_id)
       AND vsj_id = NVL (vsj_id_k, vsj_id)
       AND dat_valjan <= NVL (dat_poc_p, dat_max_c)
       AND NVL (dat_ponisten, dat_max_c) > NVL (dat_zav_p, dat_min_c);

  CURSOR sj_vsjs_c IS
    SELECT id
      FROM m_sj
     WHERE id = sj_id_p
       AND so_id = NVL (so_id_p, so_id)
       AND vsjS_id = vsj_id_p AND brojs IS NOT NULL
       AND dat_valjan <= NVL (dat_poc_p, dat_max_c)
       AND NVL (dat_ponisten, dat_max_c) > NVL (dat_zav_p, dat_min_c);

  CURSOR sj_sjs_c IS
    SELECT id
       FROM m_sj sj
     WHERE sj.id = sj_id_p
        AND (sj.id = sjs_id_p OR sj.sjp_id = sjs_id_p)
        AND sj.dat_valjan <= NVL (dat_poc_p, dat_max_c)
        AND NVL (sj.dat_ponisten, dat_max_c) > NVL (dat_zav_p, dat_min_c);

  vsj_id_l s_vsj.id%TYPE := vsj_id_p;
  nebitno_l NUMBER;
BEGIN
  IF sj_id_p IS NULL THEN
    RETURN;
  END IF;

  /* default provjera ili poslana vsj nije sastavljena */
  IF ozn_vsjs_p = 0 OR pra_zmp_s.vsj_je_sastavljena (vsj_id_p) = 0 THEN
    /* Ako je param postavljen da se VSJ ne provjerava onda SJ ne mora pripadati poslanoj VSJ */
    IF pra_zmp_zaj.zmppar_vrijednost ('REC', '1124') = 'da' THEN
      vsj_id_l := NULL;
    END IF;

    OPEN sj_c (vsj_id_l);
    FETCH sj_c INTO nebitno_l;
    IF sj_c%NOTFOUND THEN
      CLOSE sj_c;
      -- Smjetajna jedinica ne pripada smjetajnom objektu ili vrsti smjetajnih jedinica ili nije valjana.
      pra_rec_zaj.vrati_poruku (-20331);
    END IF;
    CLOSE sj_c;
  ELSIF ozn_vsjs_p = 1 THEN
    /* provjera je pozvana iz rezvsj i vsj je sastavljena - sj mora biti sastavljena */
    OPEN sj_vsjs_c;
    FETCH sj_vsjs_c INTO nebitno_l;
    IF sj_vsjs_c%NOTFOUND THEN
      CLOSE sj_vsjs_c;
      -- Smjetajna jedinica ne pripada smjetajnom objektu ili vrsti smjetajnih jedinica ili nije valjana.
      pra_rec_zaj.vrati_poruku (-20331);
    END IF;
    CLOSE sj_vsjs_c;
  ELSIF ozn_vsjs_p = 2 THEN
    IF sjs_id_p IS NOT NULL THEN
      -- provjera je pozvana iz recrezsj i vsj je sastavljena - sj mora biti vrste koja je u sastavu VSJ
      OPEN sj_sjs_c;
      FETCH sj_sjs_c INTO nebitno_l;
      IF sj_sjs_c%NOTFOUND THEN
        CLOSE sj_sjs_c;
        -- Smjetajna jedinica ne pripada smjetajnom objektu ili vrsti smjetajnih jedinica ili nije valjana.
        pra_rec_zaj.vrati_poruku (-20331);
      END IF;
      CLOSE sj_sjs_c;
    END IF;
  ELSE
    pra_rec_zaj.vrati_poruku (-20331);
  END IF;
END;
PROCEDURE PROVJERI_RECKPLO_RECZAKPLO
 (RECPLO_ID_P IN mrec_plovila.id%TYPE
 ,RECZAKPLO_ID_P IN trec_zak_plovila.id%TYPE
 ,OZNAKA_P IN VARCHAR2
 )
 IS
/*
PRA1466_RECKPLO_PLO
Ako je knjiga plovila vezana za plovilo i za plovilo na zakupljenom vezu
onda to mora biti isto plovilo.
*/
  recplo_id_l mrec_plovila.id%TYPE;
  br_redaka_l NUMBER;
BEGIN
  IF oznaka_p NOT IN ('1', '2') OR reczakplo_id_p IS NULL THEN
    RETURN;
  END IF;
  IF oznaka_p = '1' THEN
    /*
    provjera na zakup koja se poziva prilikom provjere knjige
    */
    SELECT COUNT (1) INTO br_redaka_l
      FROM trec_zak_plovila
     WHERE id = reczakplo_id_p
       AND recplo_id = recplo_id_p;
    IF br_redaka_l = 0 THEN
      pra_rec_zaj.vrati_poruku (-20417);
    END IF;
  END IF;
  IF oznaka_p = '2' THEN
    /*
    provjera na knjigu plovila koja se poziva prilikom izmjene plovila
    na zakupljenom vezu
    */
    SELECT MAX (recplo_id) INTO recplo_id_l
      FROM trec_kplovila
     WHERE reczakplo_id = reczakplo_id_p;
    IF recplo_id_l <> recplo_id_p THEN
      pra_rec_zaj.vrati_poruku (-20417);
    END IF;
  END IF;
END;
FUNCTION ZMPDPLO_ID
 (DULJINA_P IN trec_kplovila.duljina%TYPE
 )
 RETURN szmp_duljine_plovila.id%TYPE
 IS
-- zmpdplo_id
  CURSOR zmpdplo_c IS
    SELECT id
      FROM szmp_duljine_plovila
     WHERE duljina_poc = ( -- IRN 3332
           SELECT MAX (duljina_poc)
             FROM szmp_duljine_plovila
            WHERE duljina_poc <= duljina_p);
  zmpdplo_id_l szmp_duljine_plovila.id%TYPE;
BEGIN
  OPEN zmpdplo_c;
  FETCH zmpdplo_c INTO zmpdplo_id_l;
  CLOSE zmpdplo_c;
  RETURN zmpdplo_id_l;
END;
FUNCTION AGEKUPAC_SIFRA
 (VDOK_ID_P IN t_racuni.vdok_id%TYPE
 ,AGE_ID_P IN t_racuni.age_id%TYPE
 ,AGEP_ID_P IN t_racuni.agep_id%TYPE
 ,VPDOG_ID_P IN t_racuni.vpdog_id%TYPE
 )
 RETURN m_agencije.sifra%TYPE
 IS
/*
Agencija salda-konti kupac odreuje se preko pravila knjienja (m_pknjizenja),
ako posrednik (t_racuni.agep_id) nije NULL; inae, agencija salda-konti kupac
je agencija (t_racuni.age_id).
*/
  CURSOR age_c IS
    SELECT sifra
      FROM m_agencije
     WHERE id = pra_rec2.agekupac_id (vdok_id_p, age_id_p, agep_id_p, vpdog_id_p);
  agek_sifra_l m_agencije.sifra%TYPE;
BEGIN
  OPEN age_c;
  FETCH age_c INTO agek_sifra_l;
  CLOSE age_c;
  RETURN (agek_sifra_l);
END;
FUNCTION IZN_BP
 (RAC_ID_P IN t_racuni.id%TYPE
 ,IZN_TECAJA_P IN t_racuni.izn_tecaja%TYPE
 )
 RETURN NUMBER
 IS
-- Iznos boravine pristojbe u domaoj valuti
  iznos_l t_racuni.iznos%TYPE;
BEGIN
  SELECT NVL (ROUND (SUM (iznos * izn_tecaja - izn_odbitka * izn_tecaja_p), 2), 0)
    INTO iznos_l
    FROM t_troskovi
   WHERE rac_id = rac_id_p
     AND usl_id IN (SELECT DISTINCT usl_id FROM s_vplabp_tz);
  RETURN (iznos_l);
END;
FUNCTION IZN_PREDUJMA_RACVAL
 (RAC_ID_P IN t_racuni.id%TYPE
 ,IZN_TECAJA_P IN t_racuni.izn_tecaja%TYPE
 )
 RETURN NUMBER
 IS
-- Iznos iskoritenog predujma u valuti rauna
  iznos_l t_rac_pred.iznos%TYPE;
BEGIN
  IF rac_id_p IS NULL OR izn_tecaja_p IS NULL THEN
    RETURN (NULL);
  END IF;
  SELECT NVL (SUM (ROUND (iznos * izn_tecaja / izn_tecaja_p, 2)), 0)
    INTO iznos_l
    FROM t_rac_pred
   WHERE rac_id = rac_id_p;
  RETURN (iznos_l);
END;
PROCEDURE PROVJERI_VSUS_ID
 (ZMPVPOG_ID_P IN lrec_pogreske.zmpvpog_id%TYPE
 ,VSUS_ID_P IN lrec_pogreske.vsus_id%TYPE
 )
 IS
/*
Provjeri pripada li vsus_id_p odgovarajuem sustavu
*/
  CURSOR zmpvpog_c IS
    SELECT ozn_vvsustava
      FROM szmp_vpogresaka
     WHERE id = zmpvpog_id_p;
  zmpvpog_c_l zmpvpog_c%ROWTYPE;
  br_redaka_l NUMBER;
BEGIN
  IF zmpvpog_id_p IS NULL
    OR vsus_id_p IS NULL
  THEN
    RETURN;
  END IF;

  OPEN zmpvpog_c;
  FETCH zmpvpog_c INTO zmpvpog_c_l;
  IF zmpvpog_c%NOTFOUND THEN
    CLOSE zmpvpog_c;
    -- Nedostaje vrsta pogreaka (id = #0).
    pra_rec_zaj.vrati_poruku (-20431, zmpvpog_id_p);
  END IF;
  CLOSE zmpvpog_c;

  IF zmpvpog_c_l.ozn_vvsustava IN ('TCO') THEN
    -- Pogrena vrsta vanjskih sustava (oznaka = #0).
    -- tablica MTCO_SUSTAVI jo (26.06.2006.) ne postoji
    pra_rec_zaj.vrati_poruku (-20432, zmpvpog_c_l.ozn_vvsustava);
  ELSIF zmpvpog_c_l.ozn_vvsustava IN ('PTV') THEN
    SELECT COUNT (ROWID) INTO br_redaka_l
      FROM mptv_sustavi
     WHERE id = vsus_id_p;
    IF br_redaka_l = 0 THEN
      -- Pogrean vanjski sustav (oznaka = #0, id = #1).
      pra_rec_zaj.vrati_poruku (-20433, zmpvpog_c_l.ozn_vvsustava, vsus_id_p);
    END IF;
  ELSIF zmpvpog_c_l.ozn_vvsustava IN ('KC') THEN
    SELECT COUNT (ROWID) INTO br_redaka_l
      FROM mkc_sustavi
     WHERE id = vsus_id_p;
    IF br_redaka_l = 0 THEN
      -- Pogrean vanjski sustav (oznaka = #0, id = #1).
      pra_rec_zaj.vrati_poruku (-20433, zmpvpog_c_l.ozn_vvsustava, vsus_id_p);
    END IF;
  ELSIF zmpvpog_c_l.ozn_vvsustava IN ('SMS') THEN -- IRN 1678
    SELECT COUNT (ROWID) INTO br_redaka_l
      FROM m_so
     WHERE id = vsus_id_p;
    IF br_redaka_l = 0 THEN
      -- Pogrean vanjski sustav (oznaka = #0, id = #1).
      pra_rec_zaj.vrati_poruku (-20433, zmpvpog_c_l.ozn_vvsustava, vsus_id_p);
    END IF;
  ELSE
    -- Pogrena vrsta vanjskih sustava (oznaka = #0).
    pra_rec_zaj.vrati_poruku (-20432, zmpvpog_c_l.ozn_vvsustava);
  END IF;

END;
PROCEDURE PROVJERI_USL_ARA
 (USL_ID_P IN mrec_ara_usl.usl_id%TYPE
 ,RECARA_ID_P IN mrec_ara_usl.recara_id%TYPE
 )
 IS
-- provjeri da usluga pripada aranmanu ako je ara.ozn_provjeri_usl = -1
  oznaka_l NUMBER;
  brojac_l NUMBER;
BEGIN
  IF recara_id_p IS NULL OR usl_id_p IS NULL THEN
    RETURN;
  END IF;

  SELECT ozn_provjeri_usl
    INTO oznaka_l
    FROM mrec_aranzmani
   WHERE id = recara_id_p;

  IF oznaka_l = -1 THEN
    SELECT COUNT (*) INTO brojac_l
      FROM mrec_ara_usl
     WHERE recara_id = recara_id_p
       AND usl_id = usl_id_p;

    IF brojac_l = 0 THEN
      -- Usluga ne pripada aranmanu.
      pra_rec_zaj.vrati_poruku (-20438);
    END IF;
  END IF;
END;
FUNCTION IZN_USL1
 (CIJENA_USLUGE_P IN t_troskovi.cijena_usluge%TYPE
 ,STOPA_PLACANJA_P IN t_troskovi.stopa_placanja%TYPE
 ,KOL_USLUGE_P IN t_troskovi.kol_usluge%TYPE
 ,DAT_POC_P IN t_troskovi.dat_poc%TYPE
 ,DAT_ZAV_P IN t_troskovi.dat_zav%TYPE
 ,OBR_ZDANA_P IN s_usluge.obr_zdana%TYPE
 ,OBR_PO_DANU_P IN s_usluge.obr_po_danu%TYPE
 ,BR_DECIMALA_P IN NUMBER := 2
 )
 RETURN NUMBER
 IS
-- iznos usluge (za jednu sezonu u valuti troka)
-- bi trebao odgovarati funkciji pftriznos iz rec2250.fmb pomou koje se rauna tro.iznos
BEGIN
  IF obr_po_danu_p = -1 THEN
    RETURN (ROUND (cijena_usluge_p * (stopa_placanja_p / 100) *
                 kol_usluge_p * (dat_zav_p - dat_poc_p - obr_zdana_p)
                , br_decimala_p)
           );
  ELSE
    RETURN (ROUND (cijena_usluge_p * (stopa_placanja_p / 100) *
                 kol_usluge_p
                , br_decimala_p)
           );
  END IF;
END;
FUNCTION IZN_USL1_TEC
 (CIJENA_USLUGE_P IN t_troskovi.cijena_usluge%TYPE
 ,STOPA_PLACANJA_P IN t_troskovi.stopa_placanja%TYPE
 ,KOL_USLUGE_P IN t_troskovi.kol_usluge%TYPE
 ,DAT_POC_P IN t_troskovi.dat_poc%TYPE
 ,DAT_ZAV_P IN t_troskovi.dat_zav%TYPE
 ,OBR_ZDANA_P IN s_usluge.obr_zdana%TYPE
 ,OBR_PO_DANU_P IN s_usluge.obr_po_danu%TYPE
 ,IZN_TECAJA_SA_P IN t_troskovi.izn_tecaja%TYPE
 ,IZN_TECAJA_NA_P IN t_troskovi.izn_tecaja%TYPE
 )
 RETURN NUMBER
 IS
-- iznos usluge (za jednu sezonu preraunat prema poslanim teajevima,
-- ZAOKRUEN)
-- bi trebao odgovarati funkciji pftriznos_racval iz rec2250.fmb iz koje se rauna iznos troka za raun
BEGIN
  IF obr_po_danu_p = -1 THEN
    RETURN (ROUND (cijena_usluge_p * (stopa_placanja_p / 100) *
             (izn_tecaja_sa_p / izn_tecaja_na_p), 2) *
             kol_usluge_p *
             (dat_zav_p - dat_poc_p - obr_zdana_p));
  ELSE
    RETURN (ROUND (cijena_usluge_p * (stopa_placanja_p / 100) *
             (izn_tecaja_sa_p / izn_tecaja_na_p), 2) *
             kol_usluge_p);
  END IF;
END;
FUNCTION DOM_ZEM_NAZIV
 (SIFRA_JEZ_P IN s_jezici.sifra_3a%TYPE
 )
 RETURN s_zemlje.naziv%TYPE
 IS
-- Naziv domae zemlje na jeziku rauna
  CURSOR zemjez_c IS
    SELECT zemjez.naziv
      FROM s_zem_jez zemjez,
           s_zemlje zem,
           s_jezici jez
     WHERE zemjez.zem_id = zem.id
       AND zem.sifra_2a = pra_rec_zaj.vrijednost_parametra ('0002')
       AND zemjez.jez_id = jez.id
       AND jez.sifra_3a = sifra_jez_p;
  CURSOR zem_c IS
    SELECT naziv
      FROM s_zemlje
     WHERE sifra_2a = pra_rec_zaj.vrijednost_parametra ('0002');
  zem_naziv_l s_zemlje.naziv%TYPE;
BEGIN
  OPEN zemjez_c;
  FETCH zemjez_c INTO zem_naziv_l;
  IF zemjez_c%NOTFOUND THEN
    OPEN zem_c;
    FETCH zem_c INTO zem_naziv_l;
    CLOSE zem_c;
  END IF;
  CLOSE zemjez_c;
  RETURN (zem_naziv_l);
END;
FUNCTION BAN_ID_VAPLDOK
 (OZNAKA_P IN s_vapldok.oznaka%TYPE
 ,AGE_ID_P IN m_agencije.id%TYPE := NULL
 )
 RETURN s_vapldok.ban_id%TYPE
 IS
-- IRN 425
  CURSOR vapldok_c (oznaka_k IN s_vapldok.oznaka%TYPE) IS
    SELECT ban_id
      FROM s_vapldok
     WHERE metapl_sifra = 'REC'
       AND oznaka = oznaka_k;
  ban_id_l s_vapldok.ban_id%TYPE;

  CURSOR age_c IS
    SELECT id
      FROM m_agencije
     WHERE id = age_id_p
       AND ozn_individualno = 0;
  age_id_l m_agencije.id%TYPE;
BEGIN
  OPEN vapldok_c (oznaka_p);
  FETCH vapldok_c INTO ban_id_l;
  IF vapldok_c%NOTFOUND AND oznaka_p = 'PR' THEN
    CLOSE vapldok_c;
    IF age_id_p IS NOT NULL THEN
      OPEN age_c;
      FETCH age_c INTO age_id_l;
      IF age_c%FOUND THEN
        OPEN vapldok_c ('BI');
      ELSE
        OPEN vapldok_c ('GI');
      END IF;
      CLOSE age_c;
    ELSE
      OPEN vapldok_c ('GI');
    END IF;
    FETCH vapldok_c INTO ban_id_l;
  END IF;
  CLOSE vapldok_c;
  RETURN ban_id_l;
END;
FUNCTION VTEC_ID_VAPLDOK
 (OZNAKA_P IN s_vapldok.oznaka%TYPE
 ,AGE_ID_P IN m_agencije.id%TYPE
 )
 RETURN s_vapldok.vtec_id%TYPE
 IS
-- IRN 425
  CURSOR vapldok_c (oznaka_k IN s_vapldok.oznaka%TYPE) IS
    SELECT vtec_id
      FROM s_vapldok
     WHERE metapl_sifra = 'REC'
       AND oznaka = oznaka_k;
  vtec_id_l s_vapldok.vtec_id%TYPE;

  CURSOR age_c IS
    SELECT id
      FROM m_agencije
     WHERE id = age_id_p
       AND ozn_individualno = 0;
  age_id_l m_agencije.id%TYPE;
BEGIN
  OPEN vapldok_c (oznaka_p);
  FETCH vapldok_c INTO vtec_id_l;
  IF vapldok_c%NOTFOUND AND oznaka_p = 'PR' THEN
    CLOSE vapldok_c;
    IF age_id_p IS NOT NULL THEN
      OPEN age_c;
      FETCH age_c INTO age_id_l;
      IF age_c%FOUND THEN
        OPEN vapldok_c ('BI');
      ELSE
        OPEN vapldok_c ('GI');
      END IF;
      CLOSE age_c;
    ELSE
      OPEN vapldok_c ('GI');
    END IF;
    FETCH vapldok_c INTO vtec_id_l;
  END IF;
  CLOSE vapldok_c;
  RETURN vtec_id_l;
END;
PROCEDURE PROVJERI_RECSPOK
 (RECSPOK_SIFRA_P IN mrec_spokazatelja.sifra%TYPE
 ,RECSPOK_ID_P OUT mrec_spokazatelja.id%TYPE
 )
 IS
/*
Provjeri postoji li stavka pokazatelja sa odabranom ifrom
i ako postoji vrati njen id.
*/
  CURSOR recspok_c IS
    SELECT id
      FROM mrec_spokazatelja
     WHERE sifra = recspok_sifra_p;
BEGIN
  OPEN recspok_c;
  FETCH recspok_c INTO recspok_id_p;
  IF recspok_c%NOTFOUND THEN
    CLOSE recspok_c;
    pra_rec_zaj.vrati_poruku (-20410, recspok_sifra_p);
  END IF;
  CLOSE recspok_c;
END;
FUNCTION CIJENA_USL_2
 (PONSO_ID_P IN t_ponude.id%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 ,CJE_ID_P IN t_cjenici.id%TYPE
 ,SO_ID_P IN m_so.id%TYPE
 ,VSJ_ID_P IN s_vsj.id%TYPE
 ,USL_ID_P IN s_usluge.id%TYPE
 ,OZN_USL1_P IN NUMBER
 ,OZN_UGO_P IN NUMBER
 ,OZN_CJE_VSJ_P IN NUMBER
 ,DATUM_P IN t_cje_usl.datum%TYPE
 ,RECARA_ID_P IN mrec_aranzmani.id%TYPE := NULL
 )
 RETURN NUMBER
 IS
/*
Cijena za datum za usl iz ponso ili rez koja se koristi u izraunima (rec3040-book_sum, rec3070-prognoze i pokrm).
Ne koristi se funkcija pra_rec_s2.cijena_usl (koja ide preko puni_prec_cje_usl) jer je prespora
Dokumenti se proslijeuju da bi se znalo traiti nadjaane cijene
SO, cje,.. su poslani u parametrima da se ne bi dokumenti morali ponovo itati osim
za rezervacije koje su vezane na ponudu i na recvpro - u tom sluaju se cjenik za ugovorene usluge trai iz ponrecvpro,
ako ga tu nema uzima se poslani cjenik
*/
/*
pra_rec_s2.cijena_usl_2 (
  ponso_id_p => ,
  rez_id_p => ,
  cje_id_p => ,
  so_id_p => ,
  vsj_id_p => ,
  usl_id_p => ,
  ozn_usl1_p => ,
  ozn_ugo_p => ,
  ozn_cje_vsj_p => ,
  datum_p => ,
  recara_id_p => )
*/
  cijena_usluge_l t_cje_usl.cijena_usluge%TYPE;
  ozn_cje_poseb_l t_rezervacije.ozn_cje_poseb%TYPE := 0;
  usl_ozn_cje_poseb_l s_usluge.ozn_cje_poseb%TYPE;
  ponso_id_l t_pon_so.id%TYPE;
  recvpro_id_l mrec_vprograma.id%TYPE;
  cje_id_pom_l t_cjenici.id%TYPE;
  ozn_nadjacaj_pon_cje_l NUMBER := -1;
  ozn_cje_ara_l mrec_ara_usl.ozn_cje_ara%TYPE := 0;

  -- cijena iz cjenika
  CURSOR cjeusl_c (cje_id_k t_cjenici.id%TYPE, ozn_cje_ara_k NUMBER) IS
    SELECT DECODE (ozn_usl1_p, 0, cijena_usluge, NVL (cje_usl_obr, cijena_usluge))
      FROM t_cje_usl
     WHERE cje_id = cje_id_k
       AND so_id = so_id_p
       AND NVL (vsj_id, 0) = DECODE (ozn_cje_vsj_p, -1, vsj_id_p, 0, 0)
       AND usl_id = usl_id_p
       AND NVL (recara_id, 0) =  DECODE (ozn_cje_ara_k, -1, recara_id_p, 0, 0)
       AND datum <= datum_p
     ORDER BY datum DESC;

  -- cijena iz prometnih tablica
  CURSOR recrezcje_c (ozn_cje_ara_k NUMBER) IS
    SELECT cijena_usluge
      FROM trec_rez_cjeusl
     WHERE rez_id = rez_id_p
       AND NVL (vsj_id, 0) = DECODE (ozn_cje_vsj_p, -1, vsj_id_p, 0, 0)
       AND usl_id = usl_id_p
       AND NVL (recara_id, 0) =  DECODE (ozn_cje_ara_k, -1, recara_id_p, 0, 0)
       AND datum_p BETWEEN dat_poc AND dat_zav;

  CURSOR recponcje_c (ozn_nadjacaj_pon_cje_k NUMBER, ozn_cje_ara_k NUMBER)IS
    SELECT cijena_usluge
      FROM trec_pon_cjeusl
     WHERE ozn_nadjacaj_pon_cje_k = -1
     AND ponso_id = ponso_id_l
       AND NVL (vsj_id, 0) = DECODE (ozn_cje_vsj_p, -1, vsj_id_p, 0, 0)
       AND usl_id = usl_id_p
       AND NVL (recara_id, 0) =  DECODE (ozn_cje_ara_k, -1, recara_id_p, 0, 0)
       AND datum_p BETWEEN dat_poc AND dat_zav;

  CURSOR recarausl_c IS
    SELECT ozn_cje_ara FROM mrec_ara_usl WHERE usl_id = usl_id_p AND recara_id = recara_id_p;

  CURSOR recponvpro_c (ponso_id_k t_pon_so.id%TYPE, recvpro_id_k mrec_vprograma.id%TYPE) IS
    SELECT recponvpro.cje_id
      FROM trec_pon_vpro recponvpro
     WHERE recponvpro.ponso_id = ponso_id_k
       AND recponvpro.recvpro_id = recvpro_id_k;
BEGIN
  IF (ponso_id_p IS NOT NULL AND rez_id_p IS NULL)
    OR (ponso_id_p IS NULL AND rez_id_p IS NOT NULL)
    OR (cje_id_p IS NOT NULL AND so_id_p IS NOT NULL AND datum_p IS NOT NULL)
  THEN
    -- te kombinacije prolaze dalje
    NULL;
  ELSE
    RETURN (NULL);
  END IF;

  SELECT ozn_cje_poseb INTO usl_ozn_cje_poseb_l FROM s_usluge WHERE id = usl_id_p;
  IF recara_id_p IS NOT NULL THEN
    OPEN recarausl_c;
    FETCH recarausl_c INTO ozn_cje_ara_l;
    CLOSE recarausl_c;
  END IF;

  -- rezervacije
  IF rez_id_p IS NOT NULL THEN
    SELECT ponso_id, recvpro_id, ozn_cje_poseb
      INTO ponso_id_l, recvpro_id_l, ozn_cje_poseb_l
      FROM t_rezervacije
     WHERE id = rez_id_p;
    IF ponso_id_l IS NOT NULL -- rez po ponudi
      AND ozn_ugo_p = -1 AND (usl_ozn_cje_poseb_l = 0 OR ozn_cje_poseb_l = 0) -- usluga je ugovorena i nije posebna
    THEN
      -- nai nadjaanu cijenu rez, pon ako je rezervacija vezana na ponudu a usluga je ugovorena i nije posebna
      -- trai rezerviranu cijenu
      OPEN recrezcje_c (ozn_cje_ara_l);
      FETCH recrezcje_c INTO cijena_usluge_l;
      CLOSE recrezcje_c;
      IF cijena_usluge_l IS NULL THEN
        -- trai ponuenu cijenu
        IF recvpro_id_l IS NOT NULL THEN
          OPEN recponvpro_c (ponso_id_l, recvpro_id_l);
          FETCH recponvpro_c INTO cje_id_pom_l;
          CLOSE recponvpro_c;
          IF cje_id_pom_l IS NOT NULL THEN
            ozn_nadjacaj_pon_cje_l := 0; -- u tom sluaju se nee itati cijene iz ponreccje niti iz cjenika iz ponude
            OPEN cjeusl_c (cje_id_pom_l, ozn_cje_ara_l);
            FETCH cjeusl_c INTO cijena_usluge_l;
            CLOSE cjeusl_c;
          END IF;
        END IF;
        OPEN recponcje_c (ozn_nadjacaj_pon_cje_l, ozn_cje_ara_l);
        FETCH recponcje_c INTO cijena_usluge_l;
        CLOSE recponcje_c;
      END IF;
    END IF;
    IF ponso_id_l IS NULL -- rez nije po pon
      AND (usl_ozn_cje_poseb_l = 0 OR ozn_cje_poseb_l = 0) -- usluga nije posebna
    THEN
      -- nai nadjaanu cijenu samo rez
      -- nai rezerviranu cijenu
      OPEN recrezcje_c (ozn_cje_ara_l);
      FETCH recrezcje_c INTO cijena_usluge_l;
      CLOSE recrezcje_c;
    END IF;
    -- ako cijena usluge nije bila naena (ali se ne radi o ponudi za vrstu programa sa navedenim cjenikom u kojem cijena nije bila naena)
    -- ili je usluga posebna, trai cijenu u cjeniku
    IF cijena_usluge_l IS NULL AND ozn_nadjacaj_pon_cje_l <> 0 THEN
      OPEN cjeusl_c (cje_id_p, ozn_cje_ara_l);
      FETCH cjeusl_c INTO cijena_usluge_l;
      CLOSE cjeusl_c;
    END IF;
  END IF;

  -- ponude
  IF rez_id_p IS NULL AND ponso_id_p IS NOT NULL THEN
    ponso_id_l := ponso_id_p;
    IF usl_ozn_cje_poseb_l = 0 OR ozn_cje_poseb_l = 0 THEN
      OPEN recponcje_c (ozn_nadjacaj_pon_cje_l, ozn_cje_ara_l);
      FETCH recponcje_c INTO cijena_usluge_l;
      CLOSE recponcje_c;
    END IF;
    IF cijena_usluge_l IS NULL THEN -- ako cijena usluge nije bila naena ili je usluga posebna trai cijenu u cjeniku
      OPEN cjeusl_c (cje_id_p, ozn_cje_ara_l);
      FETCH cjeusl_c INTO cijena_usluge_l;
      CLOSE cjeusl_c;
    END IF;
  END IF;

  IF rez_id_p IS NULL AND ponso_id_p IS NULL THEN
    OPEN cjeusl_c (cje_id_p, ozn_cje_ara_l);
    FETCH cjeusl_c INTO cijena_usluge_l;
    CLOSE cjeusl_c;
  END IF;

  RETURN NVL (cijena_usluge_l, 0);
END;
FUNCTION STOPA_ODBITKA
 (SO_ID_P IN m_so.id%TYPE
 ,VSJ_ID_P IN s_vsj.id%TYPE
 ,USL_ID_P IN s_usluge.id%TYPE
 ,DAT_POC_P IN DATE
 ,DAT_ZAV_P IN DATE
 ,BR_DANA_BORAVKA_P IN NUMBER
 ,ZMPPOP1_ID_P IN mzmp_popusti.id%TYPE
 ,STOPA_POPUSTA1_P IN t_racuni.stopa_popusta1%TYPE
 ,ZMPPOP2_ID_P IN mzmp_popusti.id%TYPE
 ,STOPA_POPUSTA2_P IN t_racuni.stopa_popusta2%TYPE
 ,ZMPPOP3_ID_P IN mzmp_popusti.id%TYPE
 ,STOPA_POPUSTA3_P IN t_racuni.stopa_popusta3%TYPE
 ,ZMPPOP4_ID_P IN mzmp_popusti.id%TYPE
 ,STOPA_POPUSTA4_P IN t_racuni.stopa_popusta4%TYPE
 )
 RETURN NUMBER
 IS
-- funkcija trai stope popusta ovisno o unesenim ifriranim popustima ili stopama i vraa stopu odbitka
/*
pra_rec_s4.stopa_odbitka (
  so_id_p =>
  ,vsj_id_p =>
  ,usl_id_p =>
  ,dat_poc_p =>
  ,dat_zav_p =>
  ,br_dana_boravka_p =>
  ,zmppop1_id_p =>
  ,stopa_popusta1_p =>
  ,zmppop2_id_p =>
  ,stopa_popusta2_p =>
  ,zmppop3_id_p =>
  ,stopa_popusta3_p =>
  ,zmppop4_id_p =>
  ,stopa_popusta4_p =>
)
*/
  stopa_popusta1_l NUMBER;
  stopa_popusta2_l NUMBER;
  stopa_popusta3_l NUMBER;
  stopa_popusta4_l NUMBER;
  stopa_odbitka_l  NUMBER;
BEGIN
  IF zmppop1_id_p IS NOT NULL THEN
    stopa_popusta1_l := pra_rec_s4.stopa_zmppop (
      zmppop1_id_p, so_id_p, vsj_id_p, usl_id_p, dat_poc_p, dat_zav_p, NVL (br_dana_boravka_p, 99));
  ELSE
    stopa_popusta1_l := stopa_popusta1_p;
  END IF;
  IF zmppop2_id_p IS NOT NULL THEN
    stopa_popusta2_l := pra_rec_s4.stopa_zmppop (
      zmppop2_id_p, so_id_p, vsj_id_p, usl_id_p, dat_poc_p, dat_zav_p, NVL (br_dana_boravka_p, 99));
  ELSE
    stopa_popusta2_l := stopa_popusta2_p;
  END IF;
  IF zmppop3_id_p IS NOT NULL THEN
    stopa_popusta3_l := pra_rec_s4.stopa_zmppop (
      zmppop3_id_p, so_id_p, vsj_id_p, usl_id_p, dat_poc_p, dat_zav_p, NVL (br_dana_boravka_p, 99));
  ELSE
    stopa_popusta3_l := stopa_popusta3_p;
  END IF;
  IF zmppop4_id_p IS NOT NULL THEN
    stopa_popusta4_l := pra_rec_s4.stopa_zmppop (
      zmppop4_id_p, so_id_p, vsj_id_p, usl_id_p, dat_poc_p, dat_zav_p, NVL (br_dana_boravka_p, 99));
  ELSE
    stopa_popusta4_l := stopa_popusta4_p;
  END IF;
  stopa_popusta1_l := NVL (stopa_popusta1_l, 0) / 100;
  stopa_popusta2_l := NVL (stopa_popusta2_l, 0) / 100;
  stopa_popusta3_l := NVL (stopa_popusta3_l, 0) / 100;
  stopa_popusta4_l := NVL (stopa_popusta4_l, 0) / 100;
  stopa_odbitka_l :=
        (stopa_popusta1_l + stopa_popusta2_l + stopa_popusta3_l + stopa_popusta4_l
         - stopa_popusta1_l * stopa_popusta2_l - stopa_popusta1_l * stopa_popusta3_l
         - stopa_popusta1_l * stopa_popusta4_l - stopa_popusta2_l * stopa_popusta3_l
         - stopa_popusta2_l * stopa_popusta4_l - stopa_popusta3_l * stopa_popusta4_l
         + stopa_popusta1_l * stopa_popusta2_l * stopa_popusta3_l
         + stopa_popusta1_l * stopa_popusta2_l * stopa_popusta4_l
         + stopa_popusta1_l * stopa_popusta3_l * stopa_popusta4_l
         + stopa_popusta2_l * stopa_popusta3_l * stopa_popusta4_l
         - stopa_popusta1_l * stopa_popusta2_l * stopa_popusta3_l * stopa_popusta4_l
       ) * 100;

  RETURN stopa_odbitka_l;
END;
PROCEDURE PROVJERI_RECGDGOST_RAZDOBLJE
 (ID_P IN mrec_gdgostiju.id%TYPE
 ,BR_GODINA_POC_P IN mrec_gdgostiju.br_godina_poc%TYPE
 ,DAT_VALJAN_P IN mrec_gdgostiju.dat_valjan%TYPE
 ,DAT_PONISTEN_P IN mrec_gdgostiju.dat_ponisten%TYPE
 )
 IS
-- IRN 4023; Razdoblja dobnih grupa gostiju ne mogu se preklapati
  CURSOR recgdgost_c IS
    SELECT br_godina_poc || ' | ' ||
             TO_CHAR (dat_valjan, 'DD.MM.RRRR') || ' - ' ||
             DECODE (dat_ponisten, NULL, '...', TO_CHAR (dat_ponisten, 'DD.MM.RRRR')) AS opis
      FROM mrec_gdgostiju
     WHERE id <> id_p
       AND br_godina_poc = br_godina_poc_p
       AND dat_valjan < NVL (dat_ponisten_p, TO_DATE ('31.12.9999', 'DD.MM.RRRR'))
       AND NVL (dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) > dat_valjan_p
     ORDER BY dat_valjan;
  recgdgost_c_l recgdgost_c%ROWTYPE;
BEGIN
  IF br_godina_poc_p IS NULL
    OR dat_valjan_p IS NULL
  THEN
    RETURN;
  END IF;

  OPEN recgdgost_c;
  FETCH recgdgost_c INTO recgdgost_c_l;
  IF recgdgost_c%FOUND THEN
    CLOSE recgdgost_c;
    -- Razdoblja dobnih grupa gostiju ne mogu se preklapati (#0).
    pra_rec_zaj.vrati_poruku (-20136, recgdgost_c_l.opis);
  END IF;
  CLOSE recgdgost_c;
END;

END PRA_REC_S2;
/
SHOW ERROR

