-- C:\Radni\pra_rec_s.pkb
--
-- Generated for Oracle 10g on Thu Oct 02  15:49:48 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'PRA_REC_S'
CREATE OR REPLACE PACKAGE BODY PRA_REC_S IS

MINUS_PDV1059_M NUMBER(1) := NULL;
MINUS_ODBITAK1060_M NUMBER(1) := NULL;


/* PRA_REC_S */
PROCEDURE PISI_RECVLAS
 (NAZIV_P OUT SREC_VLASNIK.NAZIV%TYPE
 ,NAZ_LICENCE_P OUT SREC_VLASNIK.NAZ_LICENCE%TYPE
 ,VERZIJA_P OUT SREC_VLASNIK.VERZIJA%TYPE
 )
 IS
--
  CURSOR recvlas_c IS
    SELECT naziv, naz_licence, verzija
      FROM srec_vlasnik;
BEGIN
  OPEN recvlas_c;
  FETCH recvlas_c INTO naziv_p, naz_licence_p, verzija_p;
  CLOSE recvlas_c;
END;
/* pra_rec2, pra_rec_s */
FUNCTION SO_ID
 (TIP_MODULA_P IN VARCHAR2
 )
 RETURN NUMBER
 IS
/*
Prvi SO poredano po ifri (koji pripada tekuem voru)
ovisno o vrsti modula i vrijednosti parametra 1033

REC param 1033
Instalacija radi:
1 = svi moduli sa svim SO,
2 = PRO moduli - nita, REC moduli samo s vlastitim SO,
3 = PRO moduli sa svim SO, REC moduli samo s vlastitim SO
*/
  so_id_l m_so.id%TYPE;
  so_param_l szmp_parametri.vrijednost%TYPE;
  br_redaka_l NUMBER;

  CURSOR so_c IS
    SELECT id
      FROM m_so
     WHERE dat_ponisten IS NULL
     ORDER BY sifra;
  CURSOR so_cvor_c IS
    SELECT id
      FROM m_so
     WHERE metcvor_sifra = pra_zmp_zaj.tekuci_cvor
       AND dat_ponisten IS NULL
     ORDER BY sifra;
BEGIN
  so_id_l := NULL;
  so_param_l := pra_rec_zaj.vrijednost_parametra ('1033');
  IF so_param_l = '1'
    OR (so_param_l = '3' AND (tip_modula_p = 'PRO' OR tip_modula_p = 'PROI'))
  THEN
    OPEN so_c;
    FETCH so_c INTO so_id_l;
    CLOSE so_c;
  ELSIF (so_param_l = '2' AND (tip_modula_p = 'REC' OR tip_modula_p = 'PROI'))
     OR (so_param_l = '3' AND tip_modula_p = 'REC')
  THEN
    OPEN so_cvor_c;
    FETCH so_cvor_c INTO so_id_l;
    CLOSE so_cvor_c;
  END IF;
  RETURN so_id_l;
END;
/* pra_rec2, pra_rec_s */
PROCEDURE PROVJERI_SO_CVOR_PARAM
 (SO_ID_P IN M_SO.ID%TYPE
 ,TIP_MODULA_P IN VARCHAR2
 )
 IS
-- Provjeri SO obzirom na tekui vor, vrstu modula i parametar 1033

  so_param_l szmp_parametri.vrijednost%TYPE;

  CURSOR so_c IS
    SELECT 1
      FROM m_so
     WHERE id = so_id_p
       AND metcvor_sifra = pra_zmp_zaj.tekuci_cvor;

  nebitno_l NUMBER;
BEGIN
  IF so_id_p IS NULL THEN
    RETURN;
  END IF;
  so_param_l := pra_rec_zaj.vrijednost_parametra ('1033');
  IF so_param_l = '2' AND UPPER (tip_modula_p) = 'PRO'
  THEN
    -- Zabrani unos SO u PRO modulima na recepciji
    pra_rec_zaj.vrati_poruku(-20353);
  ELSIF so_param_l = '2' AND UPPER (tip_modula_p) = 'REC'
    OR so_param_l = '3' AND UPPER (tip_modula_p) = 'REC'
  THEN
    -- Dopusti unos SO koji pripadaju tekuem voru u REC modulima
    OPEN so_c;
    FETCH so_c INTO nebitno_l;
    IF so_c%NOTFOUND THEN
      CLOSE so_c;
      pra_rec_zaj.vrati_poruku (-20353);
    END IF;
    CLOSE so_c;
  END IF;
END;
/* PRA_REC_S */
FUNCTION STAROST
 (DAT_POC_P IN DATE
 ,DAT_ZAV_P IN DATE
 )
 RETURN VARCHAR2
 IS
   mjeseci_ukupno_l NUMBER;
   dat_pomoc_l      DATE;
   godina_l         NUMBER;
   mjeseci_l        NUMBER;
   dana_l           NUMBER;
   starost_l        VARCHAR2 (9);
/* Razlika izmeu poetnog i zavrnog datuma u obliku GGG/MM/DD (broj godina, broj mjeseci, broj dana) */
BEGIN
   IF dat_poc_p IS NULL OR dat_zav_p IS NULL THEN
      RETURN NULL;
   END IF;

   IF dat_poc_p > dat_zav_p THEN
      RETURN NULL;
   END IF;

   mjeseci_ukupno_l := FLOOR (MONTHS_BETWEEN (dat_zav_p, dat_poc_p));
   dat_pomoc_l := ADD_MONTHS (dat_poc_p, mjeseci_ukupno_l);
   /*
   Funkcija MONTH_BETWEEN ponekad ne radi logino.
   Npr. za datume 30.09.1994 i 30.07.2005 daje 130 mjeseci, umjesto 129,...
   Zbog toga, ako pomoni datum premauje zavrni datum, oduzima se 1.
   */
   IF dat_pomoc_l > dat_zav_p THEN
      mjeseci_ukupno_l := mjeseci_ukupno_l - 1;
      dat_pomoc_l := ADD_MONTHS (dat_poc_p, mjeseci_ukupno_l);
   END IF;

   godina_l  := FLOOR (mjeseci_ukupno_l / 12);
   mjeseci_l := MOD (mjeseci_ukupno_l, 12);
   dana_l    := dat_zav_p - dat_pomoc_l;
   starost_l :=
      LTRIM (TO_CHAR (godina_l, '000')) || '/' ||
      LTRIM (TO_CHAR (mjeseci_l, '00')) || '/' ||
      LTRIM (TO_CHAR (dana_l,    '00'));
   RETURN starost_l;
END;
/* PRA_REC_S */
FUNCTION RAC_RBR
 (RAC_ID_P IN T_RACUNI.ID%TYPE
 ,RAC_OZNAKA_P IN T_RACUNI.OZNAKA%TYPE
 )
 RETURN t_racuni.rbr%TYPE
 IS

RAC_RBR_L T_RACUNI.RBR%TYPE;
/*
Ako je oznaka rauna N vraa
broj rauna kojeg je ponitio taj N raun; inae,
ako je oznaka rauna P vraa
broj rauna kojim je poniten taj P raun.
*/
  CURSOR racn_c IS
    SELECT rbr
      FROM t_racuni
     WHERE id = rac_id_p;
  CURSOR racp_c IS
    SELECT rbr
      FROM t_racuni
     WHERE rac_id = rac_id_p;
BEGIN
  IF rac_id_p IS NULL
    OR rac_oznaka_p IS NULL
  THEN
    RETURN NULL;
  END IF;
  IF rac_oznaka_p = 'N' THEN
    OPEN racn_c;
    FETCH racn_c INTO rac_rbr_l;
    IF racn_c%NOTFOUND THEN
      rac_rbr_l := '???';
    END IF;
    CLOSE racn_c;
  ELSIF rac_oznaka_p = 'P' THEN
    OPEN racp_c;
    FETCH racp_c INTO rac_rbr_l;
    IF racp_c%NOTFOUND THEN
      rac_rbr_l := '???';
    END IF;
    CLOSE racp_c;
  END IF;
  RETURN (rac_rbr_l);
END;
/* PRA_REC_S */
FUNCTION VALJAN_TROSAK
 (TRO_ID_P IN T_TROSKOVI.ID%TYPE
 ,RAC_ID_P IN T_TROSKOVI.RAC_ID%TYPE
 )
 RETURN NUMBER
 IS

RAC_OZNAKA_L T_RACUNI.OZNAKA%TYPE;
/*
Troak nije zaraunat ili pripada valjanom raunu
*/
BEGIN
  IF tro_id_p IS NULL THEN
    -- Greka
    RETURN (0);
  END IF;
  IF rac_id_p IS NULL THEN
    -- Troak nije zaraunat
    RETURN (-1);
  END IF;
  SELECT oznaka INTO rac_oznaka_l
    FROM t_racuni
   WHERE id = rac_id_p;
  IF rac_oznaka_l = 'V' THEN
    -- Raun je valjan
    RETURN (-1);
  ELSE
    -- Raun je poniten (P) ili negativan (N)
    RETURN (0);
  END IF;
END;
FUNCTION PLATITELJ
 (OZNAKA_P IN VARCHAR2
 ,GOST_ID_P IN T_GOSTI.ID%TYPE
 ,AGE_ID_P IN M_AGENCIJE.ID%TYPE
 ,PKAADR_ID_P IN MPKA_ADRESE.ID%TYPE
 )
 RETURN VARCHAR2
 IS
--
  platitelj_l VARCHAR2(60);  
  CURSOR gost_c IS
    SELECT DECODE (oznaka_p,
           '1', t_gosti.rbr || ' ' || m_sj.broj,
           '2', t_gosti.prezime || ', ' || t_gosti.ime,
           '3', t_gosti.rbr || ' ' || m_sj.broj || ' ' || t_gosti.prezime || ', ' || t_gosti.ime,
           '4', t_gosti.god_poslovna || ' ' || t_gosti.rbr,
           '5', t_gosti.rbr || ' ' || t_gosti.prezime || ', ' || t_gosti.ime) -- IRN 2544
      FROM t_gosti, m_sj
     WHERE t_gosti.id = gost_id_p
       AND t_gosti.sj_id = m_sj.id;
  CURSOR age_c IS
    SELECT DECODE (oznaka_p,
           '1', sifra,
           '2', naziv,
           '3', sifra || ' ' || naziv,
           '4', sifra,
           '5', sifra || ' ' || naziv)
      FROM m_agencije
     WHERE id = age_id_p;
  CURSOR pkaadr_c IS
    SELECT DECODE (oznaka_p,
           '1', rbr,
           '2', DECODE (prezime, NULL, naz_poduzeca, prezime || ', ' || ime),
           '3', rbr || ' ' || DECODE (prezime, NULL, naz_poduzeca, prezime || ', ' || ime),
           '4', rbr,
           '5', rbr || ' ' || DECODE (prezime, NULL, naz_poduzeca, prezime || ', ' || ime))
      FROM mpka_adrese
     WHERE id = pkaadr_id_p;
BEGIN
  IF oznaka_p IS NULL THEN
    RETURN (platitelj_l);
  END IF;
  IF gost_id_p IS NULL
    AND age_id_p IS NULL
    AND pkaadr_id_p IS NULL
  THEN
    RETURN (platitelj_l);
  END IF;
  IF gost_id_p IS NOT NULL THEN
    OPEN gost_c;
    FETCH gost_c INTO platitelj_l;
    CLOSE gost_c;
    RETURN (platitelj_l);
  END IF;
  IF age_id_p IS NOT NULL THEN
    OPEN age_c;
    FETCH age_c INTO platitelj_l;
    CLOSE age_c;
    RETURN (platitelj_l);
  END IF;
  IF pkaadr_id_p IS NOT NULL THEN
    OPEN pkaadr_c;
    FETCH pkaadr_c INTO platitelj_l;
    CLOSE pkaadr_c;
    RETURN (platitelj_l);
  END IF;
END;
FUNCTION SJ_ID
 (GOST_ID_P IN T_GOSTI.ID%TYPE
 )
 RETURN m_sj.id%TYPE
 IS
--
  CURSOR gost_c IS
    SELECT sj_id
      FROM t_gosti
     WHERE id = gost_id_p;
  sj_id_l m_sj.id%TYPE;
BEGIN
  IF gost_id_p IS NULL THEN
    RETURN (NULL);
  END IF;
  OPEN gost_c;
  FETCH gost_c INTO sj_id_l;
  CLOSE gost_c;
  RETURN (sj_id_l);
END;
/* PRA_REC_S */
FUNCTION IZN_PPOT
 (RAC_ID_P IN T_RACUNI.ID%TYPE
 )
 RETURN tpka_rnkasa.izn_ppot%TYPE
 IS

IZNOS_L TPKA_RNKASA.IZN_PPOT%TYPE;
/* Iznos zaraunatog poreza na potronju */
BEGIN
  SELECT NVL (SUM (izn_ppot), 0)
    INTO iznos_l
    FROM tpka_rnkasa
   WHERE rac_id = rac_id_p;

  RETURN iznos_l;
END;
/* pra_rec_s */
FUNCTION KAPAC_UPOTREBLJIVI
 (SO_SIFRA_P IN M_SO.SIFRA%TYPE
 ,OJ_ID_P IN M_OJ.ID%TYPE
 ,VUO_SIFRA_P IN S_VUO.SIFRA%TYPE
 ,VSJ_SIFRA_P IN S_VSJ.SIFRA%TYPE
 ,SSJ_SIFRA_P IN S_SSJ.SIFRA%TYPE
 ,POC_DAT_P IN DATE
 ,ZAV_DAT_P IN DATE
 ,POSTELJA_P IN NUMBER := NULL
 )
 RETURN NUMBER
 IS
--
  kolicina_l NUMBER;
  kolicina_i_l NUMBER;
  centar_l NUMBER := pra_zmp_zaj.centar;
  tekuci_cvor_l VARCHAR2(100) := pra_zmp_zaj.tekuci_cvor;
BEGIN
  IF NVL (postelja_p, 0) = 0 THEN -- broje se SJ
    SELECT SUM (DECODE (SIGN (  TO_DATE (LEAST (zav_dat_p, NVL (sj.dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.YYYY')) - 1))
                              - TO_DATE (GREATEST (poc_dat_p, sj.dat_valjan))
                              + 1
                             ),
                        -1,  0,
                             (  TO_DATE (LEAST (zav_dat_p, NVL (sj.dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.YYYY')) - 1))
                              - TO_DATE (GREATEST (poc_dat_p, sj.dat_valjan))
                              + 1
                             )
                       )
               )
      INTO kolicina_l
      FROM m_sj  sj,
           (SELECT *
              FROM m_so
             WHERE sifra = so_sifra_p OR
                   (so_sifra_p IS NULL AND oj_id_p IS NULL AND (centar_l <> 0 OR metcvor_sifra = tekuci_cvor_l)) OR
                   (so_sifra_p IS NULL AND oj_id_p IS NOT NULL AND id IN (SELECT id1 FROM prec_global))
           )     so,
           s_vuo vo,
           s_vsj vs,
           s_ssj ss
     WHERE sj.so_id  = so.id
       AND so.vuo_id = vo.id AND NVL (vuo_sifra_p, vo.sifra) = vo.sifra
       AND sj.vsj_id = vs.id AND NVL (vsj_sifra_p, vs.sifra) = vs.sifra
       AND vs.ssj_id = ss.id AND NVL (ssj_sifra_p, ss.sifra) = ss.sifra;
  ELSE -- broje se postelje
    SELECT SUM (DECODE (SIGN (  TO_DATE (LEAST (zav_dat_p, NVL (sj.dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.YYYY')) - 1))
                              - TO_DATE (GREATEST (poc_dat_p, sj.dat_valjan))
                              + 1
                             ),
                        -1,  0,
                             (  TO_DATE (LEAST (zav_dat_p, NVL (sj.dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.YYYY')) - 1))
                              - TO_DATE (GREATEST (poc_dat_p, sj.dat_valjan))
                              + 1
                             ) * sj.br_opostelja
                       )
               )
      INTO kolicina_l
      FROM m_sj  sj,
           (SELECT *
              FROM m_so
             WHERE sifra = so_sifra_p OR
                   (so_sifra_p IS NULL AND oj_id_p IS NULL AND (centar_l <> 0 OR metcvor_sifra = tekuci_cvor_l)) OR
                   (so_sifra_p IS NULL AND oj_id_p IS NOT NULL AND id IN (SELECT id1 FROM prec_global))
           )     so,
           s_vuo vo,
           s_vsj vs,
           s_ssj ss
     WHERE sj.so_id  = so.id
       AND so.vuo_id = vo.id AND NVL (vuo_sifra_p, vo.sifra) = vo.sifra
       AND sj.vsj_id = vs.id AND NVL (vsj_sifra_p, vs.sifra) = vs.sifra
       AND vs.ssj_id = ss.id AND NVL (ssj_sifra_p, ss.sifra) = ss.sifra;
  END IF;

  SELECT DECODE (NVL (postelja_p, 0), 0, COUNT (st.sj_id), SUM (sj.br_opostelja))
    INTO kolicina_i_l
    FROM m_sj sj,
         (SELECT *
            FROM m_so
           WHERE sifra = so_sifra_p OR
                 (so_sifra_p IS NULL AND oj_id_p IS NULL AND (centar_l <> 0 OR metcvor_sifra = tekuci_cvor_l)) OR
                 (so_sifra_p IS NULL AND oj_id_p IS NOT NULL AND id IN (SELECT id1 FROM prec_global))
         )     so,
         s_vuo vo,
         s_vsj vs,
         s_ssj ss,
         i_statusisj st
   WHERE sj.so_id  = so.id
     AND so.vuo_id = vo.id AND NVL (vuo_sifra_p, vo.sifra) = vo.sifra
     AND sj.vsj_id = vs.id AND NVL (vsj_sifra_p, vs.sifra) = vs.sifra
     AND vs.ssj_id = ss.id AND NVL (ssj_sifra_p, ss.sifra) = ss.sifra
     AND st.sj_id = sj.id
     AND st.datum BETWEEN poc_dat_p AND zav_dat_p
     AND st.ozn_i = 3;

  kolicina_l := NVL (kolicina_l, 0) - NVL (kolicina_i_l, 0);
  RETURN (kolicina_l);
END;
/* PRA_REC_S */
FUNCTION RAC_PRIPADA_RP
 (RAC_ID_P IN T_RACUNI.ID%TYPE
 )
 RETURN NUMBER
 IS

BR_REDAKA_L NUMBER;
/*
Raun je "raun u pripremi"
*/
BEGIN
  IF rac_id_p IS NULL THEN
    RETURN (-1);
  END IF;
  SELECT COUNT (t_racuni.ROWID) INTO br_redaka_l
    FROM t_racuni,
         s_vapldok
   WHERE t_racuni.id = rac_id_p
     AND t_racuni.vapldok_id = s_vapldok.id
     AND s_vapldok.oznaka = 'RP';
  IF br_redaka_l = 1 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;
END;
/* pra_rec_s */
FUNCTION OBRACUNATO
 (PKARNK_ID_P IN tpka_racuni.id%TYPE
 )
 RETURN NUMBER
 IS

BR_REDAKA_L NUMBER;
/*
Raun sa kase pripada valjanom obraunu za kartiare
*/
BEGIN
  IF pkarnk_id_p IS NULL THEN
    RETURN (0);
  END IF;
  SELECT COUNT (tpka_obracuni.rowid) INTO br_redaka_l
    FROM tpka_obracuni,
         tpka_obr_rac
   WHERE tpka_obracuni.oznaka = 'V'
     AND tpka_obr_rac.pkaobr_id = tpka_obracuni.id
     AND tpka_obr_rac.pkarnk_id = pkarnk_id_p;
  IF br_redaka_l = 0 THEN
    RETURN 0;
  ELSE
    RETURN (-1);
  END IF;
END;
/* PRA_REC_S */
FUNCTION KGOST_ID
 (GOST_ID_P IN T_GOSTI.ID%TYPE
 )
 RETURN t_kgostiju.id%TYPE
 IS

KGOST_ID_L T_KGOSTIJU.ID%TYPE;
/*
Prva, poredano po rednom broju, valjana prijava gosta
*/
  CURSOR kgost_c IS
    SELECT id
      FROM t_kgostiju
     WHERE gost_id = gost_id_p
       AND oznaka = 'V'
     ORDER BY rbr;
BEGIN
  IF gost_id_p IS NULL THEN
    RETURN (NULL);
  END IF;
  OPEN kgost_c;
  FETCH kgost_c INTO kgost_id_l;
  CLOSE kgost_c;
  RETURN (kgost_id_l);
END;
/* PRA_REC_S */
FUNCTION IZN_PREDUJMA
 (RAC_ID_P IN T_RACUNI.ID%TYPE
 )
 RETURN t_rac_pred.iznos%TYPE
 IS

IZNOS_L T_RAC_PRED.IZNOS%TYPE;
/* Iznos iskoritenog predujma */
BEGIN
  SELECT NVL (SUM (ROUND (iznos * izn_tecaja, 2)), 0)
    INTO iznos_l
    FROM t_rac_pred
   WHERE rac_id = rac_id_p;

  RETURN iznos_l;
END;
/* PRA_REC_S */
FUNCTION IZN_PKARNK
 (RAC_ID_P IN T_RACUNI.ID%TYPE
 ,VPISPZ_ID_P IN IPKA_RNK_PDV.VPISPZ_ID%TYPE
 ,OSNOVICA_P IN NUMBER
 )
 RETURN IPKA_RNK_PDV.IZNOS%TYPE
 IS
/*
Zaraunata osnovica (-1) ili porez (0) po raunima sa kasa
Iznos poreza = iznos bruto - iznos neto
*/
  iznos_l NUMBER(14, 2);
BEGIN
  SELECT DECODE (osnovica_p, 
           -- -1, NVL (SUM (ROUND (ipka_rnk_pdv.iznos, 2)), 0),
           --  0, NVL (SUM (ROUND (ipka_rnk_pdv.iznos * (1 + ipka_rnk_pdv.stopa_pdv / 100), 2)
           --          - ROUND (ipka_rnk_pdv.iznos, 2)), 0))
           -1, NVL (SUM (ipka_rnk_pdv.izn_osnovice), 0),
            0, NVL (SUM (ipka_rnk_pdv.izn_pdv), 0))
    INTO iznos_l
    FROM ipka_rnk_pdv,
         tpka_rnkasa
   WHERE tpka_rnkasa.rac_id = rac_id_p
     AND ipka_rnk_pdv.pkarnk_id = tpka_rnkasa.id
     AND ipka_rnk_pdv.vpispz_id = vpispz_id_p;

  RETURN iznos_l;
END;
/* pra_rec_s */
FUNCTION KUP_BR_POREZNI
 (AGE_ID_P IN M_AGENCIJE.ID%TYPE
 ,GOST_ID_P IN T_GOSTI.ID%TYPE
 ,PKAADR_ID_P IN MPKA_ADRESE.ID%TYPE
 )
 RETURN VARCHAR2
 IS
-- ifra i porezni broj kupca
  CURSOR age_c IS
    SELECT age.sifra  || ', ' ||
             NVL (
               DECODE (zem.sifra_2a, pra_zmp_zaj.vrijednost_parametra ('0002'), -- IRN 2032
                 age.oib,
                 age.br_porezni),
               '-')
      FROM m_agencije age,
           s_zemlje zem
     WHERE age.id = age_id_p
       AND age.zem_id = zem.id;

  CURSOR gost_c IS
    SELECT 'Gost ' || god_poslovna || '-' || rbr || ', -'
      FROM t_gosti
     WHERE id = gost_id_p;

  CURSOR pkaadr_c IS
    SELECT 'Adresa ' || pkaadr.rbr || ', ' ||
             NVL (
               DECODE (zem.sifra_2a, pra_zmp_zaj.vrijednost_parametra ('0002'), -- IRN 2032
                 pkaadr.oib,
                 pkaadr.br_porezni),
               '-')
      FROM mpka_adrese pkaadr,
           s_zemlje zem
     WHERE pkaadr.id = pkaadr_id_p
       AND pkaadr.zem_id = zem.id;

  kup_br_porezni_l VARCHAR2(100);
BEGIN
  IF age_id_p IS NULL
    AND gost_id_p IS NULL
    AND pkaadr_id_p IS NULL
  THEN
    RETURN (kup_br_porezni_l);
  END IF;

  IF age_id_p IS NOT NULL THEN
    OPEN age_c;
    FETCH age_c INTO kup_br_porezni_l;
    CLOSE age_c;
  ELSIF gost_id_p IS NOT NULL THEN
    OPEN gost_c;
    FETCH gost_c INTO kup_br_porezni_l;
    CLOSE gost_c;
  ELSIF pkaadr_id_p IS NOT NULL THEN
    OPEN pkaadr_c;
    FETCH pkaadr_c INTO kup_br_porezni_l;
    CLOSE pkaadr_c;
  END IF;

  RETURN (kup_br_porezni_l);

END;
/* PRA_REC_S */
FUNCTION KUP_VPOBV_ID
 (AGE_ID_P IN M_AGENCIJE.ID%TYPE
 ,GOST_ID_P IN T_GOSTI.ID%TYPE
 ,PKAADR_ID_P IN MPKA_ADRESE.ID%TYPE
 )
 RETURN s_vpobveznika.id%TYPE
 IS

KUP_VPOBV_ID_L S_VPOBVEZNIKA.ID%TYPE;
  CURSOR age_c IS
    SELECT vpobv_id 
      FROM m_agencije
     WHERE id = age_id_p;

  CURSOR gost_c IS
    SELECT id 
      FROM s_vpobveznika
     WHERE sifra = pra_rec_zaj.vrijednost_parametra ('0013');

  CURSOR pkaadr_c IS
    SELECT vpobv_id 
      FROM mpka_adrese
     WHERE id = pkaadr_id_p;
/* Vrsta poreznih obveznika kojoj pripada kupac */
BEGIN
  IF age_id_p IS NULL
    AND gost_id_p IS NULL
    AND pkaadr_id_p IS NULL
  THEN
    kup_vpobv_id_l := NULL;
    RETURN (kup_vpobv_id_l);
  END IF;

  IF age_id_p IS NOT NULL THEN
    OPEN age_c;
    FETCH age_c INTO kup_vpobv_id_l;
    IF age_c%NOTFOUND THEN
       kup_vpobv_id_l := NULL;
    END IF;
    CLOSE age_c;
    RETURN (kup_vpobv_id_l);
  END IF;

  IF gost_id_p IS NOT NULL THEN
    OPEN gost_c;
    FETCH gost_c INTO kup_vpobv_id_l;
    IF gost_c%NOTFOUND THEN
       kup_vpobv_id_l := NULL;
    END IF;
    CLOSE gost_c;
    RETURN (kup_vpobv_id_l);
  END IF;

  IF pkaadr_id_p IS NOT NULL THEN
    OPEN pkaadr_c;
    FETCH pkaadr_c INTO kup_vpobv_id_l;
    IF pkaadr_c%NOTFOUND THEN
       kup_vpobv_id_l := NULL;
    END IF;
    CLOSE pkaadr_c;
    RETURN (kup_vpobv_id_l);
  END IF;
END;
/* pra_rec_s */
FUNCTION KUP_NAZIV
 (AGE_ID_P IN M_AGENCIJE.ID%TYPE
 ,GOST_ID_P IN T_GOSTI.ID%TYPE
 ,PKAADR_ID_P IN MPKA_ADRESE.ID%TYPE
 )
 RETURN VARCHAR2
 IS
-- Naziv i sjedite kupca

  kup_naziv_l VARCHAR2(100);

  CURSOR age_c IS
    SELECT age.naziv || ', ' ||
             DECODE (age.zem_id, pra_zmp_zaj.domaca_zemlja,
               NVL (pos.naziv, zem.sifra_2a),
               zem.sifra_2a)
      FROM m_agencije age,
           s_zemlje zem,
           m_poste pos
     WHERE age.id = age_id_p
       AND age.zem_id = zem.id
       AND age.pos_id = pos.id (+);

  CURSOR gost_c IS
    SELECT gost.prezime || ', ' || gost.ime || ', ' ||
             DECODE (gost.zem_id, pra_zmp_zaj.domaca_zemlja,
               NVL (NVL (pos.naziv, kgost.naz_mjesta), zem.sifra_2a),
               zem.sifra_2a)
      FROM t_gosti gost,
           s_zemlje zem,
           t_kgostiju kgost,
           m_poste pos
     WHERE gost.id = gost_id_p
       AND kgost.gost_id (+) = gost.id
       -- IRN 3032; AND NVL (kgost.oznaka, 'V') = 'V'
       AND kgost.oznaka (+) = 'V' -- IRN 3032
       AND gost.zem_id = zem.id
       AND kgost.pos_id = pos.id (+);

  CURSOR pkaadr_c IS
    SELECT DECODE (pkaadr.prezime, NULL,
             pkaadr.naz_poduzeca || ', ' ||
               DECODE (pkaadr.zem_id, pra_zmp_zaj.domaca_zemlja,
                 NVL (pos.naziv, NVL (pkaadr.naz_mjesta, zem.sifra_2a)),
                 zem.sifra_2a),
             pkaadr.prezime || ', ' || NVL (pkaadr.ime, '-') || ', ' ||
               DECODE (pkaadr.zem_id, pra_zmp_zaj.domaca_zemlja,
                 NVL (pos.naziv, NVL (pkaadr.naz_mjesta, zem.sifra_2a)),
                 zem.sifra_2a))
      FROM mpka_adrese pkaadr,
           s_zemlje zem,
           m_poste pos
     WHERE pkaadr.id = pkaadr_id_p
       AND pkaadr.zem_id = zem.id
       AND pkaadr.pos_id = pos.id (+);
BEGIN
  IF gost_id_p IS NULL
    AND age_id_p IS NULL
    AND pkaadr_id_p IS NULL
  THEN
    kup_naziv_l := NULL;
    RETURN (kup_naziv_l);
  END IF;

  IF age_id_p IS NOT NULL THEN
    OPEN age_c;
    FETCH age_c INTO kup_naziv_l;
    IF age_c%NOTFOUND THEN
       kup_naziv_l := NULL;
    END IF;
    CLOSE age_c;
    RETURN (kup_naziv_l);
  END IF;

  IF gost_id_p IS NOT NULL THEN
    OPEN gost_c;
    FETCH gost_c INTO kup_naziv_l;
    IF gost_c%NOTFOUND THEN
       kup_naziv_l := NULL;
    END IF;
    CLOSE gost_c;
    RETURN (kup_naziv_l);
  END IF;

  IF pkaadr_id_p IS NOT NULL THEN
    OPEN pkaadr_c;
    FETCH pkaadr_c INTO kup_naziv_l;
    IF pkaadr_c%NOTFOUND THEN
       kup_naziv_l := NULL;
    END IF;
    CLOSE pkaadr_c;
    RETURN (kup_naziv_l);
  END IF;
END;
/* pra_rec_s */
FUNCTION POSTOJI_ZAKUPB_ZA_SJ
 (SJ_ID_P IN M_SJ.ID%TYPE
 ,DAT_POC_P IN I_BOOKING.DATUM%TYPE
 ,DAT_ZAV_P IN I_BOOKING.DATUM%TYPE
 )
 RETURN INTEGER
 IS
/*
Funkcija vraa -1 ako za barem jedan dan u zadanom razdoblju postoji
zakup sa ozn_B = -1 za zadanu SJ.
Zadnji dan zadanog razdoblja se ne uzima. Ako se eli kontola na datum
treba zadati datum, datum + 1.
*/
  nebitno_l NUMBER;
  postoji_zakupB_za_sj_l NUMBER := NULL;
BEGIN
  IF sj_id_p IS NULL
    OR dat_poc_p IS NULL
    OR dat_zav_p IS NULL
  THEN
    RETURN (postoji_zakupB_za_sj_l);
  END IF;

  SELECT COUNT (1)
    INTO nebitno_l
    FROM t_zakup zak, t_zak_sj zaksj
   WHERE zaksj.zak_id = zak.id
     AND zak.dat_poc < dat_zav_p
     AND zak.dat_zav > dat_poc_p
     AND zak.ozn_B = -1
     AND zak.oznaka = 'V'
     AND zaksj.sj_id = sj_id_p;
  IF nebitno_l > 0 THEN
    postoji_zakupB_za_sj_l := -1;
  ELSE
    postoji_zakupB_za_sj_l := 0;
  END IF;
  RETURN (postoji_zakupB_za_sj_l);
END;
/* PRA_REC_S */
FUNCTION VSJ_PRIPADA_SO
 (VSJ_ID_P IN M_SJ.VSJ_ID%TYPE
 ,SO_ID_P IN M_SJ.SO_ID%TYPE
 ,DAT_POC_P IN M_SJ.DAT_VALJAN%TYPE
 ,DAT_ZAV_P IN M_SJ.DAT_VALJAN%TYPE
 ,OZN_VSJ_P IN NUMBER := 0
 )
 RETURN NUMBER
 IS

BR_REDAKA_L NUMBER := 0;
BEGIN
  IF vsj_id_p IS NULL
    OR so_id_p IS NULL
  THEN
    RETURN (-1);
  END IF;
  
  IF ozn_vsj_p = 0 THEN 
    SELECT COUNT(ROWID) INTO br_redaka_l
      FROM m_sj
     WHERE so_id = so_id_p
       AND vsj_id = vsj_id_p
       AND dat_valjan <= NVL (dat_poc_p, TO_DATE ('31.12.9999', 'DD.MM.RRRR'))
       AND NVL (dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) > 
           NVL (dat_zav_p, TO_DATE ('01.01.0001', 'DD.MM.RRRR'));
  
  ELSIF ozn_vsj_p = 1 THEN
    SELECT COUNT(ROWID) INTO br_redaka_l
      FROM m_sj
     WHERE so_id = so_id_p
       AND (vsj_id = vsj_id_p OR vsjS_id = vsj_id_p AND brojs IS NOT NULL)
       AND dat_valjan <= NVL (dat_poc_p, TO_DATE ('31.12.9999', 'DD.MM.RRRR'))
       AND NVL (dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) > 
           NVL (dat_zav_p, TO_DATE ('01.01.0001', 'DD.MM.RRRR'));
  
  ELSIF ozn_vsj_p = 2 THEN
    SELECT COUNT(ROWID) INTO br_redaka_l
      FROM m_sj
     WHERE so_id = so_id_p
       AND vsjS_id = vsj_id_p AND brojs IS NOT NULL
       AND dat_valjan <= NVL (dat_poc_p, TO_DATE ('31.12.9999', 'DD.MM.RRRR'))
       AND NVL (dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) > 
           NVL (dat_zav_p, TO_DATE ('01.01.0001', 'DD.MM.RRRR'));
  
  ELSE
    br_redaka_l := 0;
  END IF;

  IF br_redaka_l > 0 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;
END;
/* PRA_REC_S */
FUNCTION USL_JE_BP
 (USL_ID_P IN S_USLUGE.ID%TYPE
 )
 RETURN NUMBER
 IS

BR_REDAKA_L NUMBER := 0;
BEGIN
  IF usl_id_p IS NULL THEN
    RETURN (0);
  END IF;

  SELECT COUNT (ROWID) INTO br_redaka_l
    FROM s_vplabp_tz
   WHERE usl_id = usl_id_p;
  IF br_redaka_l > 0 THEN
    RETURN (-1);
  END IF;

  IF UPPER (pra_rec_zaj.vrijednost_parametra ('1063')) = 'NEBITNO' THEN
    RETURN (0);
  END IF;

  SELECT COUNT (ROWID) INTO br_redaka_l
    FROM s_usluge
   WHERE id = usl_id_p
     AND UPPER (sifra) = UPPER (pra_rec_zaj.vrijednost_parametra ('1063'));
  IF br_redaka_l > 0 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;
END;
/* PRA_REC_S */
FUNCTION BP_CJE_ID
 (CJE_ID_P IN T_CJENICI.ID%TYPE
 )
 RETURN t_cjenici.id%TYPE
 IS

CJE_ID_L T_CJENICI.ID%TYPE;
--
  CURSOR cje_c IS
    SELECT id
      FROM t_cjenici
     WHERE sifra = pra_rec_zaj.vrijednost_parametra ('1068');
BEGIN
  -- Provjeri parametar
  IF UPPER (pra_rec_zaj.vrijednost_parametra ('1068')) = 'NEBITNO' THEN
    RETURN (cje_id_p);
  END IF;

  -- Provjeri cjenik
  OPEN cje_c;
  FETCH cje_c INTO cje_id_l;
  CLOSE cje_c;
  IF cje_id_l IS NULL THEN
    RETURN (cje_id_p);
  END IF;
  RETURN (cje_id_l);
END;
/* pra_rec_s */
FUNCTION CENTAR_CONNECTED
 (METCVOR_CENTRA_P IN VARCHAR2
 )
 RETURN BOOLEAN
 IS
-- provjeri da li je server Centar za aplikaciju REC aktivan
  retboolean_l BOOLEAN;
  cursor_l INTEGER;
  crows_l INTEGER;
  br_vlasnika_l NUMBER;
BEGIN
  IF metcvor_centra_p IS NULL THEN
    RETURN (FALSE);
  END IF;

  -- IRN 1585
  SELECT COUNT (rowid) INTO crows_l
    FROM smet_cvorovi
   WHERE sifra = pra_zmp_zaj.tekuci_cvor
     AND ozn_u_mrezi = 0;
  IF crows_l > 0 THEN
    RETURN (FALSE);
  END IF;
  -- KRAJ IRN 1585

  crows_l  := 0;
  cursor_l := dbms_sql.open_cursor;
  BEGIN
    dbms_sql.parse (cursor_l, 'SELECT COUNT (rowid) FROM srec_vlasnik' || '@' || metcvor_centra_p, 1);
    dbms_sql.define_column (cursor_l, 1, br_vlasnika_l);
    crows_l := dbms_sql.execute (cursor_l);
    crows_l := dbms_sql.fetch_rows (cursor_l);
    dbms_sql.column_value (cursor_l, 1, br_vlasnika_l);
    dbms_sql.close_cursor (cursor_l);
    IF crows_l = 1 AND br_vlasnika_l = 1 THEN
      retboolean_l := TRUE;
    ELSE
      retboolean_l := FALSE;
    END IF;
  EXCEPTION
    WHEN OTHERS THEN
      dbms_sql.close_cursor (cursor_l);
      RETURN (FALSE);
  END;
  RETURN (retboolean_l);
EXCEPTION
  WHEN OTHERS THEN
    RETURN (FALSE);
END;
/* pra_rec_s */
FUNCTION MINUS_PDV1059
 RETURN NUMBER
 IS
BEGIN
  IF minus_pdv1059_m IS NULL THEN
    SELECT DECODE (UPPER (pra_rec_zaj.vrijednost_parametra ('1059')), 'DA', 0, 1)
      INTO minus_pdv1059_m FROM dual;
  END IF;
  RETURN (minus_pdv1059_m);
END;
/* PRA_REC_S */
FUNCTION MINUS_ODBITAK1060
 RETURN NUMBER
 IS
BEGIN
  IF MINUS_ODBITAK1060_M IS NULL THEN
    SELECT DECODE(UPPER(PRA_REC_ZAJ.VRIJEDNOST_PARAMETRA('1060')),'DA',1,0) 
      INTO MINUS_ODBITAK1060_M FROM DUAL; 
  END IF;
  RETURN(MINUS_ODBITAK1060_M);
END MINUS_ODBITAK1060;
/* PRA_REC_S */
FUNCTION IZN_PRIHODA_IZV
 (IZN_PRIHODA_NZ_P IN I_ZUR_USL.IZN_PRIHODA_NZ%TYPE
 ,IZN_PDV_NZ_P IN I_ZUR_USL.IZN_PDV_NZ%TYPE
 ,IZN_PRIHODA_Z_P IN I_ZUR_USL.IZN_PRIHODA_Z%TYPE
 ,IZN_PDV_Z_P IN I_ZUR_USL.IZN_PDV_Z%TYPE
 ,IZN_PRIHODA_UZ_P IN I_ZUR_USL.IZN_PRIHODA_UZ%TYPE
 ,IZN_PDV_UZ_P IN I_ZUR_USL.IZN_PDV_UZ%TYPE
 ,IZN_ODBITKA_NZ_P IN I_ZUR_USL.IZN_ODBITKA_NZ%TYPE
 ,IZN_ODBITKA_PDV_NZ_P IN I_ZUR_USL.IZN_ODBITKA_PDV_NZ%TYPE
 ,IZN_ODBITKA_Z_P IN I_ZUR_USL.IZN_ODBITKA_Z%TYPE
 ,IZN_ODBITKA_PDV_Z_P IN I_ZUR_USL.IZN_ODBITKA_PDV_Z%TYPE
 ,IZN_ODBITKA_UZ_P IN I_ZUR_USL.IZN_ODBITKA_UZ%TYPE
 ,IZN_ODBITKA_PDV_UZ_P IN I_ZUR_USL.IZN_ODBITKA_PDV_UZ%TYPE
 )
 RETURN NUMBER
 IS
--
  iznos_l i_zur_usl.izn_prihoda_nz%TYPE;
BEGIN
  iznos_l :=
   -- prihod sa ili bez PDV realizacija
      izn_prihoda_nz_p - pra_rec_s.minus_pdv1059 * izn_pdv_nz_p
    + izn_prihoda_z_p - pra_rec_s.minus_pdv1059 * (izn_pdv_z_p + izn_odbitka_pdv_z_p + izn_odbitka_pdv_uz_p)
    - -- minus ili ne odbici sa ili bez pdv realizacija
    pra_rec_s.minus_odbitak1060 *
       (izn_odbitka_nz_p - pra_rec_s.minus_pdv1059 * izn_odbitka_pdv_nz_p
        + izn_odbitka_z_p - pra_rec_s.minus_pdv1059 * izn_odbitka_pdv_z_p)
    ;

  RETURN (iznos_l);
END;
/* pra_rec_s */
FUNCTION IZN_PDV_IZV
 (IZN_PDV_NZ_P IN NUMBER := 0
 ,IZN_PDV_Z_P IN NUMBER := 0
 ,IZN_ODBITKA_PDV_NZ_P IN I_ZUR_USL.IZN_ODBITKA_PDV_NZ%TYPE
 ,IZN_ODBITKA_PDV_UZ_P IN I_ZUR_USL.IZN_ODBITKA_PDV_UZ%TYPE
 )
 RETURN NUMBER
 IS
--
  iznos_l i_zur_usl.izn_pdv_nz%TYPE;
BEGIN
  iznos_l := izn_pdv_nz_p - izn_odbitka_pdv_nz_p + izn_pdv_z_p + izn_odbitka_pdv_uz_p;
  RETURN (iznos_l); 
END;
/* PRA_REC_S */
FUNCTION IZN_ODBITKA_IZV
 (IZN_ODBITKA_NZ_P IN I_ZUR_USL.IZN_ODBITKA_NZ%TYPE
 ,IZN_ODBITKA_PDV_NZ_P IN I_ZUR_USL.IZN_ODBITKA_PDV_NZ%TYPE
 ,IZN_ODBITKA_Z_P IN I_ZUR_USL.IZN_ODBITKA_Z%TYPE
 ,IZN_ODBITKA_PDV_Z_P IN I_ZUR_USL.IZN_ODBITKA_PDV_Z%TYPE
 )
 RETURN NUMBER
 IS
--
  iznos_l i_zur_usl.izn_odbitka_z%TYPE;
BEGIN
  iznos_l :=
    izn_odbitka_nz_p - (pra_rec_s.minus_pdv1059 * izn_odbitka_pdv_nz_p)
    + izn_odbitka_z_p - (pra_rec_s.minus_pdv1059 * izn_odbitka_pdv_z_p);
  RETURN (iznos_l);
END;
/* pra_rec_s */
FUNCTION KAPAC_UPOTREBLJIVI_PO_ID
 (SO_ID_P IN M_SO.ID%TYPE
 ,VUO_ID_P IN S_VUO.ID%TYPE
 ,VSJ_ID_P IN S_VSJ.ID%TYPE
 ,SSJ_ID_P IN S_SSJ.ID%TYPE
 ,POC_DAT_P IN DATE
 ,ZAV_DAT_P IN DATE
 ,POSTELJA_P IN NUMBER := NULL
 )
 RETURN NUMBER
 IS
--
  kolicina_l NUMBER;
  kolicina_i_l NUMBER;
  centar_l NUMBER := pra_zmp_zaj.centar;
  tekuci_cvor_l VARCHAR2(100) := pra_zmp_zaj.tekuci_cvor;
BEGIN
  IF NVL (postelja_p, 0) = 0 THEN -- broje se SJ
    SELECT SUM (DECODE (SIGN (  TO_DATE (LEAST (zav_dat_p, NVL (sj.dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.YYYY')) - 1))
                              - TO_DATE (GREATEST (poc_dat_p, sj.dat_valjan))
                              + 1
                             ),
                        -1,  0,
                             (  TO_DATE (LEAST (zav_dat_p, NVL (sj.dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.YYYY')) - 1))
                              - TO_DATE (GREATEST (poc_dat_p, sj.dat_valjan))
                              + 1
                             )
                       )
               )
      INTO kolicina_l
      FROM m_sj  sj, m_so so,
           s_vuo vo,
           s_vsj vs,
           s_ssj ss
     WHERE --( (so_id_p IS NOT NULL AND so.id = so_id_p) OR (so_id_p IS NULL AND (centar_l <> 0 OR so.metcvor_sifra = tekuci_cvor_l)))
           so.id = NVL (so_id_p, so.id) AND (centar_l <> 0 OR so.metcvor_sifra = tekuci_cvor_l)
           AND sj.so_id  = so.id
           AND so.vuo_id = vo.id AND so.vuo_id = NVL (vuo_id_p, vo.id)
           AND sj.vsj_id = vs.id AND sj.vsj_id = NVL (vsj_id_p, vs.id)
           AND vs.ssj_id = ss.id AND vs.ssj_id = NVL (ssj_id_p, ss.id);
  ELSE -- broje se postelje
    SELECT SUM (DECODE (SIGN (  TO_DATE (LEAST (zav_dat_p, NVL (sj.dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.YYYY')) - 1))
                              - TO_DATE (GREATEST (poc_dat_p, sj.dat_valjan))
                              + 1
                             ),
                        -1,  0,
                             (  TO_DATE (LEAST (zav_dat_p, NVL (sj.dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.YYYY')) - 1))
                              - TO_DATE (GREATEST (poc_dat_p, sj.dat_valjan))
                              + 1
                             ) * sj.br_opostelja
                       )
               )
      INTO kolicina_l
      FROM m_sj  sj, m_so so,
           s_vuo vo,
           s_vsj vs,
           s_ssj ss
     WHERE --( (so_id_p IS NOT NULL AND so.id = so_id_p) OR (so_id_p IS NULL AND (centar_l <> 0 OR so.metcvor_sifra = tekuci_cvor_l)))
           so.id = NVL (so_id_p, so.id) AND (centar_l <> 0 OR so.metcvor_sifra = tekuci_cvor_l)
           AND sj.so_id  = so.id
           AND so.vuo_id = vo.id AND so.vuo_id = NVL (vuo_id_p, vo.id)
           AND sj.vsj_id = vs.id AND sj.vsj_id = NVL (vsj_id_p, vs.id)
           AND vs.ssj_id = ss.id AND vs.ssj_id = NVL (ssj_id_p, ss.id);
  END IF;

  SELECT DECODE (NVL (postelja_p, 0), 0, COUNT (st.sj_id), SUM (sj.br_opostelja))
    INTO kolicina_i_l
    FROM m_sj sj, m_so so,
         s_vuo vo,
         s_vsj vs,
         s_ssj ss,
         i_statusisj st
   WHERE --( (so_id_p IS NOT NULL AND so.id = so_id_p) OR (so_id_p IS NULL AND (centar_l <> 0 OR so.metcvor_sifra = tekuci_cvor_l)))
         so.id = NVL (so_id_p, so.id) AND (centar_l <> 0 OR so.metcvor_sifra = tekuci_cvor_l)
         AND sj.so_id  = so.id
         AND so.vuo_id = vo.id AND so.vuo_id = NVL (vuo_id_p, vo.id)
         AND sj.vsj_id = vs.id AND sj.vsj_id = NVL (vsj_id_p, vs.id)
         AND vs.ssj_id = ss.id AND vs.ssj_id = NVL (ssj_id_p, ss.id)
         AND st.sj_id = sj.id
         AND st.datum BETWEEN poc_dat_p AND zav_dat_p
         AND st.ozn_i = 3;

  kolicina_l := NVL (kolicina_l, 0) - NVL (kolicina_i_l, 0);
  RETURN (kolicina_l);
END;

END PRA_REC_S;
/
SHOW ERROR

