PROMPT Creating Package Body 'PRA_REC_OBROCI'
CREATE OR REPLACE PACKAGE BODY PRA_REC_OBROCI IS
-- Private Declaration

  napomena_m trec_sas_iskoristeni.napomena%TYPE; -- IRN 4078

-- END Private Declaration


PROCEDURE PUNI_COLL_PRESTORANI
 IS
-- IRN 2867
-- Poziva se iz apex aplikacije Obroci (f210 i f211)
BEGIN

  -- kreiraj ili oisti kolekciju PRESTORANI
  apex_collection.create_or_truncate_collection (
    p_collection_name => 'PRESTORANI');

  -- puni kolekciju PRESTORANI
  FOR zmppres_c IN (
    SELECT id AS zmppres_id, sifra AS zmppres_sifra, naziv AS zmppres_naziv
      FROM mzmp_prestorani
     WHERE TRUNC (SYSDATE) BETWEEN dat_valjan AND (NVL (dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) - 1)
     ORDER BY sifra
    )
  LOOP
    apex_collection.add_member (
      p_collection_name => 'PRESTORANI',
      p_c001 => zmppres_c.zmppres_id,
      p_c002 => zmppres_c.zmppres_sifra,
      p_c003 => zmppres_c.zmppres_naziv);
  END LOOP;
END;
PROCEDURE PUNI_COLL_OBROCI
 (SAT_P IN DATE
 ,OZN_ZA_SAT_P IN NUMBER := -1
 )
 IS
/*
IRN 2867
Kreiraj i puni kolekciju OBROCI sa svim pansionskim sastojcima koji imaju upisan poetni i zavrni datum
Ozn_za_sat_p: -1 = trai obroke koji se nude tog sata ili 0 = trai sve obroke

Poziva se iz apex aplikacije Obroci (f210 i f211)
*/

  sat_l VARCHAR2(5) := TO_CHAR (NVL (sat_p, SYSDATE), 'HH24:MI');
BEGIN

  -- kreiraj ili oisti kolekciju OBROCI
  apex_collection.create_or_truncate_collection (
    p_collection_name => 'OBROCI');

  -- puni kolekciju OBROCI
  FOR obroci_c IN (
    SELECT TO_CHAR (id) AS sas_id, sifra AS sas_sifra, naziv AS sas_naziv, rbr AS sas_rbr,
           TO_CHAR (sat_poc, 'HH24:MI') AS sas_sat_poc,
           TO_CHAR (sat_zav,  'HH24:MI') AS sas_sat_zav
      FROM s_sastojci
     WHERE sat_poc IS NOT NULL AND sat_zav IS NOT NULL
       AND gsas_id IN (SELECT id FROM m_gsastojaka WHERE ozn_obroka = -1)
       AND (ozn_za_sat_p <> -1 OR sat_l BETWEEN TO_CHAR (sat_poc, 'HH24:MI') AND TO_CHAR (sat_zav, 'HH24:MI'))
    )
  LOOP
    apex_collection.add_member (
      p_collection_name => 'OBROCI',
      p_c001 => obroci_c.sas_id,
      p_c002 => obroci_c.sas_sifra,
      p_c003 => obroci_c.sas_naziv,
      p_n001 => obroci_c.sas_rbr,
      p_c004 => obroci_c.sas_sat_poc,
      p_c005 => obroci_c.sas_sat_zav);
  END LOOP;
END;
PROCEDURE PUNI_COLL_SO_PRES
 IS
-- IRN 2867
-- Puni kolekciju sa svim SO i njima dodijeljenim pansionskim restoranima
-- Poziva se iz apex aplikacije Obroci (f210)
BEGIN

  -- kreiraj ili oisti kolekciju SO_ZA_PRES
  apex_collection.create_or_truncate_collection (
    p_collection_name => 'SO_ZA_PRES');

  -- svaki pronaeni SO dodaj u kolekciju
  FOR so_c IN (
    SELECT
      so.id AS so_id,
      so.sifra AS so_sifra,
      so.naziv AS so_naziv,
      recpresso.zmppres_id AS zmppres_id
    FROM
      m_so so
      LEFT OUTER JOIN mrec_pres_so recpresso ON so.id = recpresso.so_id
    )
  LOOP
    apex_collection.add_member (
      p_collection_name => 'SO_ZA_PRES',
      p_c001 => so_c.so_id,
      p_c002 => so_c.so_sifra,
      p_c003 => so_c.so_naziv,
      p_c004 => so_c.zmppres_id);
  END LOOP;
END;
PROCEDURE PUNI_COLL_SJ
 (ZMPPRES_ID_P IN NUMBER
 ,OZN_ZAUZETE_SJ_P IN NUMBER := 1
 )
 IS
/*
IRN 2867
Puni kolekciju sa SJ-ovima za sve SO vezane za prosljeeni restoran (zmppres_id_p).
Ovisno o pramateru (ozn_zauzete_sj_p), dohvaa sve SJ ili samo zauzete SJ.

Poziva se iz apex aplikacije Obroci (f210)
*/
BEGIN

  -- kreiraj ili oisti kolekciju SMJESTAJNE_JEDINICE
  apex_collection.create_or_truncate_collection (
    p_collection_name => 'SMJESTAJNE_JEDINICE');

  -- puni kolekciju SMJESTAJNE_JEDINICE
  FOR sj_c IN (
    SELECT DISTINCT
      sj.id AS sj_id,
      sj.broj AS sj_broj,
      sj.so_id AS so_id
    FROM
      m_sj sj
      JOIN mrec_pres_so recpresso ON sj.so_id = recpresso.so_id
      LEFT OUTER JOIN t_gosti gost ON gost.sj_id = sj.id
        AND gost.ozn_prisutnosti = 'P'
        AND TRUNC (SYSDATE) BETWEEN gost.dat_dolaska AND gost.dat_odlaska
    WHERE
      sj.dat_ponisten IS NULL
      AND recpresso.zmppres_id = zmppres_id_p
      AND (gost.id IS NOT NULL OR ozn_zauzete_sj_p = 0)
  )
  LOOP
    apex_collection.add_member (
      p_collection_name => 'SMJESTAJNE_JEDINICE',
      p_c001 => sj_c.sj_id,
      p_c002 => sj_c.sj_broj,
      p_c003 => sj_c.so_id);
  END LOOP;
END;
PROCEDURE PUNI_COLL_AGENCIJE
 (ZMPPRES_ID_P IN mzmp_prestorani.id%TYPE
 )
 IS
/*
IRN 2867
Puni kolekciju s agencijama koje trenutno imaju pravo na uslugu
sa sastojkom koji ima vrijeme posluivanja i smjetajnim objektima kojima pripadaju

Poziva se iz apex aplikacije Obroci (f210)
*/
BEGIN

  -- kreiraj ili oisti kolekciju AGENCIJE
  apex_collection.create_or_truncate_collection (
    p_collection_name => 'AGENCIJE');

  -- puni kolekciju AGENCIJE
  FOR age_c IN (
    SELECT DISTINCT
      tro.age_id AS age_id,
      age.sifra AS age_sifra,
      age.naziv AS age_naziv,
      tro.so_id AS so_id
    FROM
      t_troskovi tro
      JOIN m_agencije age ON tro.age_id = age.id
    WHERE
      tro.so_id IN (SELECT so_id FROM mrec_pres_so WHERE zmppres_id = zmppres_id_p)
      AND tro.usl_id IN (
          -- samo usluge sa sastojkom koji ima definirano vrijeme posluivanja
          SELECT DISTINCT usl_id
            FROM s_usl_sas uslsas
            JOIN s_sastojci sas ON uslsas.sas_id = sas.id
           WHERE sas.sat_poc IS NOT NULL
             AND sas.sat_zav IS NOT NULL)
      AND TRUNC (SYSDATE) BETWEEN tro.dat_poc AND tro.dat_zav
    )
  LOOP
    apex_collection.add_member (
      p_collection_name => 'AGENCIJE',
      p_c001 => age_c.age_id,
      p_c002 => age_c.age_sifra,
      p_c003 => age_c.age_naziv,
      p_c004 => age_c.so_id);
  END LOOP;
END;
PROCEDURE PUNI_COLL_ADRESE
 (ZMPPRES_ID_P IN mzmp_prestorani.id%TYPE
 )
 IS
/*
IRN 2867
Puni kolekciju s adresama koje trenutno imaju pravo na uslugu
sa sastojkom koji ima vrijeme posluivanja i smjetajnim objektima kojima pripadaju

Poziva se iz apex aplikacije Obroci (f210)
*/
BEGIN

  -- kreiraj ili oisti kolekciju ADRESE
  apex_collection.create_or_truncate_collection (
    p_collection_name => 'ADRESE');

  -- puni kolekciju ADRESE
  FOR pkaadr_c IN (
    SELECT DISTINCT
      tro.pkaadr_id AS pkaadr_id,
      pkaadr.rbr AS pkaadr_rbr,
      pkaadr.ime AS ime,
      pkaadr.prezime AS prezime,
      pkaadr.naz_poduzeca AS poduzece,
      tro.so_id AS so_id
    FROM
      t_troskovi tro
      JOIN mpka_adrese pkaadr ON tro.pkaadr_id = pkaadr.id
    WHERE
      tro.so_id IN (SELECT so_id FROM mrec_pres_so WHERE zmppres_id = zmppres_id_p)
      AND tro.usl_id IN (
          -- samo usluge sa sastojkom koji ima definirano vrijeme posluivanja
          SELECT DISTINCT usl_id
            FROM s_usl_sas uslsas
            JOIN s_sastojci sas ON uslsas.sas_id = sas.id
           WHERE sas.sat_poc IS NOT NULL
             AND sas.sat_zav IS NOT NULL)
      AND TRUNC (SYSDATE) BETWEEN tro.dat_poc AND tro.dat_zav
    )
  LOOP
    apex_collection.add_member (
      p_collection_name => 'ADRESE',
      p_c001 => pkaadr_c.pkaadr_id,
      p_c002 => pkaadr_c.pkaadr_rbr,
      p_c003 => pkaadr_c.ime,
      p_c004 => pkaadr_c.prezime,
      p_c005 => pkaadr_c.poduzece,
      p_c006 => pkaadr_c.so_id);
  END LOOP;
END;
PROCEDURE PUNI_RECGLO_OBROCI_GOST
 (ZMPPRES_ID_P IN mzmp_prestorani.id%TYPE
 ,SJ_ID_P IN m_sj.id%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE
 ,SAS_ID_P IN s_sastojci.id%TYPE
 ,DATUM_P IN DATE
 ,OZN_ZA_SAT_P IN NUMBER := -1
 )
 IS
/*
IRN 2867
Upisuje u prec_global raspoloive i iskoritene koliine sastojaka za gosta/goste
Ako je poslan gost_id trai samo sastojke za tog gosta
Ako je poslana sj_id trai sastojke za tu SJ
Ako ni gost ni SJ nije upisano trae se sastojci za sve goste sa TIM BROJEM RESTORANA (inae
  se gledaju gosti s tim brojem restorana ili sa NULL)
Datum (koji ukljuuje sat i minute) se ne bi trebao slati ve ii na sistemski. Ovdje je zbog testiranja.
Ako sastojak nije upisan gleda sve sastojke koji se upravo nude

Ozn_za_sat_p: -1 = trai obroke koji se nude tog sata, 0 = trai sve obroke (ako je sat odnosno systime
  izvan uobiajenog vremena za sastojak treba poslati sastojak i ozn_za_sat = 0)

prec_global
id1     sas_id   Obavezno
id2     gost_id  Obavezno (Ne mora biti = gost sa kartice ako ide koritenje na SJ)
Id3     sj_id    Upisuje se SJ ako ide koritenje na SJ (inae NULL).
Iznos1  kol_sas_raspoloziva  Raspoloiva koliina sastojka (kupljena odnosno 'ima pravo')
Iznos2  kol_sas_iskoristena  Iskoritena koliina sastojka
*/

  datum_l DATE := TRUNC (NVL (datum_p, SYSDATE));
  sat_l VARCHAR2(5) := TO_CHAR (NVL (datum_p, SYSDATE), 'HH24:MI');
  sj_id_l m_sj.id%TYPE := sj_id_p;
  gost_id_l t_gosti.id%TYPE := gost_id_p;
BEGIN

  -- dbms_output.put_line ('1');
  IF zmppres_id_p IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'zmppres_id_p');
  END IF;
  IF gost_id_p IS NOT NULL AND sj_id_p IS NOT NULL  -- mora biti upisano samo jedno od gost, SJ
  THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'gost_id_p, sj_id_p');
  END IF;

  DELETE FROM prec_global;

  FOR obroci_c IN (
    SELECT
      gost_id,
      sas_id,
      SUM (NVL (kol_usluge_r, 0)) AS kol_sas_raspoloziva,
      SUM (NVL (kol_usluge_i, 0)) AS kol_sas_iskoristena
    FROM
     (
      -- boravak; sastojak ulazi u zbroj ako je jedan od doputenih za uslugu
      SELECT ALL
        t_gosti.id AS gost_id,
        s_usl_sas.sas_id AS sas_id,
        SUM (kol_usluge * DECODE (s_usl_sas.ozn_zbrajanja, '+', 1, '-', -1)) AS kol_usluge_r,
        0 AS kol_usluge_i
      FROM
        t_gosti,
        m_sj, mrec_pres_so,
        t_troskovi,
        s_usl_sas
      WHERE
        t_gosti.sj_id = NVL (sj_id_l, t_gosti.sj_id)
        AND t_gosti.id = NVL (gost_id_l, t_gosti.id)
        AND t_gosti.sj_id = m_sj.id
        AND m_sj.so_id = mrec_pres_so.so_id
        AND mrec_pres_so.zmppres_id = zmppres_id_p
        -- ako raunamo ukupno preostalo sastojaka treba uzeti goste za taj restoran
        -- i goste bez restorana
        AND NVL (t_gosti.br_restorana, mrec_pres_so.br_restorana) = mrec_pres_so.br_restorana
        AND t_troskovi.gost_id = t_gosti.id
        AND s_usl_sas.usl_id = t_troskovi.usl_id
        AND s_usl_sas.sas_id IN (
            SELECT id
              FROM s_sastojci
             WHERE id = NVL (sas_id_p, id)
               AND gsas_id IN (SELECT id FROM m_gsastojaka WHERE ozn_obroka = -1)
               AND (ozn_za_sat_p <> -1 OR sat_l BETWEEN TO_CHAR (sat_poc, 'HH24:MI') AND TO_CHAR (sat_zav, 'HH24:MI'))
            )
        AND t_troskovi.dat_poc < datum_l
        AND t_troskovi.dat_zav > datum_l
      GROUP BY
        t_gosti.id,
        s_usl_sas.sas_id
      UNION ALL
      -- dolazak; ulaze sastojci definirani preko poetnih i zavrnih sastojaka za Dolazak (za usl koje se zadnji dan ne raunaju)
      SELECT ALL
        t_gosti.id AS gost_id,
        n.sas_id AS sas_id,
        SUM (kol_usluge * DECODE (s_usl_sas.ozn_zbrajanja, '+', 1, '-', -1)) AS kol_usluge_r,
        0 AS kol_usluge_i
      FROM
        t_gosti,
        m_sj, mrec_pres_so,
        t_troskovi,
        s_usl_sas,
        s_usl_saspz,
        s_usl_sasb,
        s_usl_sas n,
        s_usluge
      WHERE
        t_gosti.sj_id = NVL (sj_id_l, t_gosti.sj_id)
        AND t_gosti.id = NVL (gost_id_l, t_gosti.id)
        AND t_gosti.sj_id = m_sj.id
        AND m_sj.so_id = mrec_pres_so.so_id
        AND mrec_pres_so.zmppres_id = zmppres_id_p
        AND NVL (t_gosti.br_restorana, mrec_pres_so.br_restorana) = mrec_pres_so.br_restorana
        AND t_troskovi.gost_id = t_gosti.id
        AND s_usl_sas.usl_id = t_troskovi.usl_id
        AND s_usl_sas.sas_id = t_troskovi.sas_id
        AND s_usluge.id = s_usl_sas.usl_id
        AND s_usluge.obr_zdana = 0
        AND s_usl_sas.id = s_usl_saspz.uslsasp_id
        AND s_usl_saspz.id = s_usl_sasb.uslsaspz_id
        AND s_usl_sasb.ozn_vboravaka = 'D'
        AND n.id = s_usl_sasb.uslsas_id
        AND n.sas_id IN (
            SELECT id
              FROM s_sastojci
             WHERE id = NVL (sas_id_p, id)
               AND gsas_id IN (SELECT id FROM m_gsastojaka WHERE ozn_obroka = -1)
               AND (ozn_za_sat_p <> -1 OR sat_l BETWEEN TO_CHAR (sat_poc, 'HH24:MI') AND TO_CHAR (sat_zav, 'HH24:MI'))
            )
        AND t_troskovi.dat_poc = datum_l
        AND t_troskovi.dat_poc <> t_troskovi.dat_zav
      GROUP BY
        t_gosti.id,
        n.sas_id
      UNION ALL
      -- dolazak; funkcija;
      -- ulaze svi sastojci za usl sa obr_zdana = -1 i svi sas za usl sa obr_zdana = 0 ali za koju ne postoje definirani saspz
      -- za usl sa dat_poc = dat_zav i ozn_obr = 0 sastojak ulazi - JE LI TO POGRENO?  (u urnal ne ulazi)
      SELECT ALL
        t_gosti.id AS gost_id,
        s_usl_sas.sas_id AS sas_id,
        SUM (kol_usluge * DECODE (s_usl_sas.ozn_zbrajanja, '+', 1, '-', -1)
          * rm_rec5150.sastojak (s_usl_sas.usl_id, 'D')) AS kol_usluge_r,
        0 AS kol_usluge_i
      FROM
        t_gosti,
        m_sj, mrec_pres_so,
        t_troskovi,
        s_usl_sas
      WHERE
        t_gosti.sj_id = NVL (sj_id_l, t_gosti.sj_id)
        AND t_gosti.id = NVL (gost_id_l, t_gosti.id)
        AND t_gosti.sj_id = m_sj.id
        AND m_sj.so_id = mrec_pres_so.so_id
        AND mrec_pres_so.zmppres_id = zmppres_id_p
        AND NVL (t_gosti.br_restorana, mrec_pres_so.br_restorana) = mrec_pres_so.br_restorana
        AND t_troskovi.gost_id = t_gosti.id
        AND s_usl_sas.usl_id = t_troskovi.usl_id
        AND s_usl_sas.sas_id IN (
            SELECT id
              FROM s_sastojci
             WHERE id = NVL (sas_id_p, id)
               AND gsas_id IN (SELECT id FROM m_gsastojaka WHERE ozn_obroka = -1)
               AND (ozn_za_sat_p <> -1 OR sat_l BETWEEN TO_CHAR (sat_poc, 'HH24:MI') AND TO_CHAR (sat_zav, 'HH24:MI'))
            )
        AND t_troskovi.dat_poc = datum_l
      GROUP BY
        t_gosti.id,
        s_usl_sas.sas_id
      UNION ALL
      -- odlazak
      SELECT ALL
        t_gosti.id AS gost_id,
        n.sas_id AS sas_id,
        SUM (kol_usluge * DECODE (s_usl_sas.ozn_zbrajanja, '+', 1, '-', -1)) AS kol_usluge_r,
        0 AS kol_usluge_i
      FROM
        t_gosti,
        m_sj, mrec_pres_so,
        t_troskovi,
        s_usl_sas,
        s_usl_saspz,
        s_usl_sasb,
        s_usl_sas n,
        s_usluge
      WHERE
        t_gosti.sj_id = NVL (sj_id_l, t_gosti.sj_id)
        AND t_gosti.id = NVL (gost_id_l, t_gosti.id)
        AND t_gosti.sj_id = m_sj.id
        AND m_sj.so_id = mrec_pres_so.so_id
        AND mrec_pres_so.zmppres_id = zmppres_id_p
        AND NVL (t_gosti.br_restorana, mrec_pres_so.br_restorana) = mrec_pres_so.br_restorana
        AND t_troskovi.gost_id = t_gosti.id
        AND s_usl_sas.usl_id = t_troskovi.usl_id
        AND s_usl_sas.sas_id = t_troskovi.sas_id
        AND s_usluge.id = s_usl_sas.usl_id
        AND s_usluge.obr_zdana = 0
        AND s_usl_sas.id = s_usl_saspz.uslsasp_id
        AND s_usl_saspz.id = s_usl_sasb.uslsaspz_id
        AND s_usl_sasb.ozn_vboravaka = 'O'
        AND n.id = s_usl_sasb.uslsas_id
        AND n.sas_id IN (
            SELECT id
              FROM s_sastojci
             WHERE id = NVL (sas_id_p, id)
               AND gsas_id IN (SELECT id FROM m_gsastojaka WHERE ozn_obroka = -1)
               AND (ozn_za_sat_p <> -1 OR sat_l BETWEEN TO_CHAR (sat_poc, 'HH24:MI') AND TO_CHAR (sat_zav, 'HH24:MI'))
            )
        AND t_troskovi.dat_zav = datum_l
        AND t_troskovi.dat_poc <> t_troskovi.dat_zav
      GROUP BY
        t_gosti.id,
        n.sas_id
      UNION ALL
      -- odlazak; funkcija
      SELECT ALL
        t_gosti.id AS gost_id,
        s_usl_sas.sas_id,
        SUM (kol_usluge * DECODE (s_usl_sas.ozn_zbrajanja, '+', 1, '-', -1)
          * rm_rec5150.sastojak (s_usl_sas.usl_id, 'O')) AS kol_usluge_r,
        0 AS kol_usluge_i
      FROM
        t_gosti,
        m_sj, mrec_pres_so,
        t_troskovi,
        s_usl_sas
      WHERE
        t_gosti.sj_id = NVL (sj_id_l, t_gosti.sj_id)
        AND t_gosti.id = NVL (gost_id_l, t_gosti.id)
        AND t_gosti.sj_id = m_sj.id
        AND m_sj.so_id = mrec_pres_so.so_id
        AND mrec_pres_so.zmppres_id = zmppres_id_p
        AND NVL (t_gosti.br_restorana, mrec_pres_so.br_restorana) = mrec_pres_so.br_restorana
        AND t_troskovi.gost_id = t_gosti.id
        AND s_usl_sas.usl_id = t_troskovi.usl_id
        AND s_usl_sas.sas_id IN (
            SELECT id
              FROM s_sastojci
             WHERE id = NVL (sas_id_p, id)
               AND gsas_id IN (SELECT id FROM m_gsastojaka WHERE ozn_obroka = -1)
               AND (ozn_za_sat_p <> -1 OR sat_l BETWEEN TO_CHAR (sat_poc, 'HH24:MI') AND TO_CHAR (sat_zav, 'HH24:MI'))
            )
        AND t_troskovi.dat_zav = datum_l
        AND t_troskovi.dat_zav <> t_troskovi.dat_poc
      GROUP BY
        t_gosti.id,
        s_usl_sas.sas_id
      UNION ALL
      -- iskoriteno
      SELECT ALL
        gost.id gost_id,
        recsasisk.sas_id,
        0 AS kol_usluge_r,
        SUM (recsasisk.kol_iskoristena) AS kol_usluge_i
      FROM
        t_gosti gost, trec_sas_iskoristeni recsasisk
      WHERE
        gost.sj_id = NVL (sj_id_l, gost.sj_id)
        AND gost.id = NVL (gost_id_l, gost.id)
        -- ako raunamo za gosta ili SJ treba oduzeti iskoritenu za tog gosta ili goste u toj SJ.
        -- Ako raunamo ukupno treba oduzeti iskoriteno u tom restoranu)
        AND (sj_id_l IS NOT NULL OR gost_id_l IS NOT NULL OR recsasisk.zmppres_id = zmppres_id_p)
        AND gost.id = recsasisk.gost_id
        AND recsasisk.oznaka = 'V'
        AND recsasisk.sas_id IN (
            SELECT id
              FROM s_sastojci
             WHERE id = NVL (sas_id_p, id)
               AND gsas_id IN (SELECT id FROM m_gsastojaka WHERE ozn_obroka = -1)
               AND (ozn_za_sat_p <> -1 OR sat_l BETWEEN TO_CHAR (sat_poc, 'HH24:MI') AND TO_CHAR (sat_zav, 'HH24:MI'))
            )
        AND TRUNC (recsasisk.datum) = datum_l
      GROUP BY
        gost.id, recsasisk.sas_id, recsasisk.usl_id
      )
    GROUP BY
      gost_id,
      sas_id
    )
  LOOP
    INSERT INTO prec_global (id1, id2, id3, iznos1, iznos2)
      VALUES (obroci_c.sas_id, obroci_c.gost_id, sj_id_l, NVL (obroci_c.kol_sas_raspoloziva, 0), NVL (obroci_c.kol_sas_iskoristena, 0));
  END LOOP;

  -- Ako se trai ukupno zbrojiti sve retke u jedan bez gosta, SJ i usluge i brisati ostalo
  IF gost_id_p IS NULL AND sj_id_p IS NULL THEN
    INSERT INTO prec_global (id1, id2, id3, iznos1, iznos2)
      SELECT id1, TO_NUMBER (NULL), TO_NUMBER (NULL), SUM (iznos1), SUM (iznos2) FROM prec_global GROUP BY id1;
    DELETE FROM prec_global WHERE id2 IS NOT NULL OR id3 IS NOT NULL;
  END IF;

  COMMIT;

END;
PROCEDURE PUNI_RECGLO_OBROCI_AGE
 (ZMPPRES_ID_P IN mzmp_prestorani.id%TYPE
 ,AGE_ID_P IN m_agencije.id%TYPE
 ,SAS_ID_P IN s_sastojci.id%TYPE
 ,DATUM_P IN DATE
 ,OZN_ZA_SAT_P IN NUMBER := -1
 )
 IS
-- IRN 2867

  datum_l DATE := TRUNC (NVL (datum_p, SYSDATE));
  sat_l VARCHAR2(5) := TO_CHAR (NVL (datum_p, SYSDATE), 'HH24:MI');
BEGIN
  -- mora biti upisan restoran
  IF zmppres_id_p IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'zmppres_id_p');
  END IF;

  DELETE FROM prec_global;

  FOR obroci_c IN (
    SELECT
      age_id,
      sas_id,
      SUM (NVL (kol_usluge_r, 0)) AS raspolozivo,
      SUM (NVL (kol_usluge_i, 0)) AS iskoristeno
    FROM (
      -- boravak -- svi sastojci
      SELECT
        t_troskovi.age_id AS age_id,
        s_usl_sas.sas_id AS sas_id,
        SUM (t_troskovi.kol_usluge * DECODE (s_usl_sas.ozn_zbrajanja, '+', 1, '-', -1)) AS kol_usluge_r,
        0 AS kol_usluge_i
      FROM
        t_troskovi,
        s_usl_sas
      WHERE
        t_troskovi.age_id = NVL (age_id_p, t_troskovi.age_id )
        AND t_troskovi.so_id IN (SELECT so_id FROM mrec_pres_so WHERE zmppres_id = zmppres_id_p)
        AND s_usl_sas.sas_id IN (
            SELECT id
              FROM s_sastojci
             WHERE id = NVL (sas_id_p, id)
               AND gsas_id IN (SELECT id FROM m_gsastojaka WHERE ozn_obroka = -1)
               AND (ozn_za_sat_p <> -1 OR sat_l BETWEEN TO_CHAR (sat_poc, 'HH24:MI') AND TO_CHAR (sat_zav, 'HH24:MI'))
            )
        AND t_troskovi.dat_poc < datum_l
        AND t_troskovi.dat_zav > datum_l
        AND t_troskovi.usl_id = s_usl_sas.usl_id
      GROUP BY
        t_troskovi.age_id,
        s_usl_sas.sas_id,
        0
      UNION ALL

      -- dolazak -- poetni sastojci usluga kojima se zadnji dan NE rauna
      SELECT
        t_troskovi.age_id AS age_id,
        n.sas_id AS sas_id,
        SUM (t_troskovi.kol_usluge * DECODE (s_usl_sas.ozn_zbrajanja, '+', 1, '-', -1)) AS kol_usluge_r,
        0 AS kol_usluge_i
      FROM
        t_troskovi,
        s_usl_sas,
        s_usl_saspz,
        s_usl_sasb,
        s_usl_sas n,
        s_usluge
      WHERE
        t_troskovi.age_id = NVL (age_id_p, t_troskovi.age_id)
        AND t_troskovi.so_id IN (SELECT so_id FROM mrec_pres_so WHERE zmppres_id = zmppres_id_p)
        AND t_troskovi.dat_poc = datum_l
        AND t_troskovi.usl_id = s_usl_sas.usl_id
        AND t_troskovi.sas_id = s_usl_sas.sas_id
        AND s_usl_sas.usl_id = s_usluge.id
        AND s_usluge.obr_zdana = 0
        AND s_usl_sas.id = s_usl_saspz.uslsasp_id
        AND s_usl_saspz.id = s_usl_sasb.uslsaspz_id
        AND s_usl_sasb.ozn_vboravaka = 'D'
        AND n.id = s_usl_sasb.uslsas_id
        AND n.sas_id IN (
            SELECT id
              FROM s_sastojci
             WHERE id = NVL (sas_id_p, id)
               AND gsas_id IN (SELECT id FROM m_gsastojaka WHERE ozn_obroka = -1)
               AND (ozn_za_sat_p <> -1 OR sat_l BETWEEN TO_CHAR (sat_poc, 'HH24:MI') AND TO_CHAR (sat_zav, 'HH24:MI'))
            )
        AND t_troskovi.dat_poc <> t_troskovi.dat_zav
      GROUP BY
        t_troskovi.age_id,
        n.sas_id,
        0
      UNION ALL

      -- dolazak; funkcija
      SELECT
        t_troskovi.age_id AS age_id,
        s_usl_sas.sas_id AS sas_id,
        SUM (t_troskovi.kol_usluge * DECODE (s_usl_sas.ozn_zbrajanja, '+', 1, '-', -1)
          * rm_rec5150.sastojak (s_usl_sas.usl_id, 'D')) AS kol_usluge_r,
        0 AS kol_usluge_i
      FROM
        t_troskovi,
        s_usl_sas
      WHERE
        t_troskovi.age_id = NVL (age_id_p, t_troskovi.age_id)
        AND t_troskovi.so_id IN (SELECT so_id FROM mrec_pres_so WHERE zmppres_id = zmppres_id_p)
        AND t_troskovi.dat_poc = datum_l
        AND s_usl_sas.sas_id IN (
            SELECT id
              FROM s_sastojci
             WHERE id = NVL (sas_id_p, id)
               AND gsas_id IN (SELECT id FROM m_gsastojaka WHERE ozn_obroka = -1)
               AND (ozn_za_sat_p <> -1 OR sat_l BETWEEN TO_CHAR (sat_poc, 'HH24:MI') AND TO_CHAR (sat_zav, 'HH24:MI'))
            )
        AND s_usl_sas.usl_id = t_troskovi.usl_id
      GROUP BY
        t_troskovi.age_id,
        s_usl_sas.sas_id,
        0
      UNION ALL

      -- odlazak -- zadnji dan se NE rauna
      SELECT
        t_troskovi.age_id AS age_id,
        n.sas_id AS sas_id,
        SUM (t_troskovi.kol_usluge * DECODE (s_usl_sas.ozn_zbrajanja, '+', 1, '-', -1)) AS kol_usluge_r,
        0 AS kol_usluge_i
      FROM
        t_troskovi,
        s_usl_sas,
        s_usl_saspz,
        s_usl_sasb,
        s_usl_sas n,
        s_usluge
      WHERE
        t_troskovi.age_id = NVL (age_id_p, t_troskovi.age_id)
        AND t_troskovi.so_id IN (SELECT so_id FROM mrec_pres_so WHERE zmppres_id = zmppres_id_p)
        AND t_troskovi.dat_zav = datum_l
        AND t_troskovi.usl_id = s_usl_sas.usl_id
        AND t_troskovi.sas_id = s_usl_sas.sas_id
        AND s_usluge.id = s_usl_sas.usl_id
        AND s_usluge.obr_zdana = 0
        AND s_usl_sas.id = s_usl_saspz.uslsasp_id
        AND s_usl_saspz.id = s_usl_sasb.uslsaspz_id
        AND s_usl_sasb.ozn_vboravaka = 'O'
        AND n.id = s_usl_sasb.uslsas_id
        AND n.sas_id IN (
            SELECT id
              FROM s_sastojci
             WHERE id = NVL (sas_id_p, id)
               AND gsas_id IN (SELECT id FROM m_gsastojaka WHERE ozn_obroka = -1)
               AND (ozn_za_sat_p <> -1 OR sat_l BETWEEN TO_CHAR (sat_poc, 'HH24:MI') AND TO_CHAR (sat_zav, 'HH24:MI'))
            )
        AND t_troskovi.dat_poc <> t_troskovi.dat_zav
      GROUP BY
        t_troskovi.age_id,
        n.sas_id,
        0
      UNION ALL

      -- odlazak; funkcija
      SELECT
        t_troskovi.age_id AS age_id,
        s_usl_sas.sas_id AS sas_id,
        SUM (t_troskovi.kol_usluge * DECODE (s_usl_sas.ozn_zbrajanja, '+', 1, '-', -1)
          * rm_rec5150.sastojak (s_usl_sas.usl_id, 'O')) AS kol_usluge_r,
        0 AS kol_usluge_i
      FROM
        t_troskovi,
        s_usl_sas
      WHERE
        t_troskovi.age_id = NVL (age_id_p, t_troskovi.age_id)
        AND t_troskovi.so_id IN (SELECT so_id FROM mrec_pres_so WHERE zmppres_id = zmppres_id_p)
        AND t_troskovi.dat_zav = datum_l
        AND t_troskovi.usl_id = s_usl_sas.usl_id
        AND s_usl_sas.sas_id IN (
            SELECT id
              FROM s_sastojci
             WHERE id = NVL (sas_id_p, id)
               AND gsas_id IN (SELECT id FROM m_gsastojaka WHERE ozn_obroka = -1)
               AND (ozn_za_sat_p <> -1 OR sat_l BETWEEN TO_CHAR (sat_poc, 'HH24:MI') AND TO_CHAR (sat_zav, 'HH24:MI'))
            )
        AND t_troskovi.dat_poc <> t_troskovi.dat_zav
      GROUP BY
        t_troskovi.age_id,
        s_usl_sas.sas_id,
        0
      UNION ALL

      -- iskoriteno
      SELECT ALL
        recsasisk.age_id AS age_id,
        recsasisk.sas_id AS sas_id,
        0 AS kol_usluge_r,
        SUM (recsasisk.kol_iskoristena) AS kol_usluge_i
      FROM
        trec_sas_iskoristeni recsasisk
      WHERE
        recsasisk.age_id = NVL (age_id_p, recsasisk.age_id)
        AND recsasisk.oznaka = 'V'
        AND recsasisk.sas_id IN (
            SELECT id
              FROM s_sastojci
             WHERE id = NVL (sas_id_p, id)
               AND gsas_id IN (SELECT id FROM m_gsastojaka WHERE ozn_obroka = -1)
               AND (ozn_za_sat_p <> -1 OR sat_l BETWEEN TO_CHAR (sat_poc, 'HH24:MI') AND TO_CHAR (sat_zav, 'HH24:MI'))
            )
        AND TRUNC (recsasisk.datum) = datum_l
      GROUP BY
        recsasisk.age_id,
        recsasisk.sas_id,
        0
      ) obroci
    GROUP BY
      age_id,
      sas_id
    ORDER BY
      sas_id
    )
  LOOP
    INSERT INTO prec_global (id1, id2, iznos1, iznos2)
      VALUES (obroci_c.sas_id, obroci_c.age_id, obroci_c.raspolozivo, obroci_c.iskoristeno);
  END LOOP;

  -- ako se trai ukupno zbrojiti sve retke u jedan agencije i usluge i brisati ostalo
  IF age_id_p IS NULL THEN
    INSERT INTO prec_global (id1, id2, iznos1, iznos2)
      SELECT id1, TO_NUMBER (NULL), SUM (iznos1), SUM (iznos2) FROM prec_global GROUP BY id1;
    DELETE FROM prec_global WHERE id2 IS NOT NULL;
  END IF;

  COMMIT;

END;
PROCEDURE PUNI_RECGLO_OBROCI_PKAADR
 (ZMPPRES_ID_P IN mzmp_prestorani.id%TYPE
 ,PKAADR_ID_P IN mpka_adrese.id%TYPE
 ,SAS_ID_P IN s_sastojci.id%TYPE
 ,DATUM_P IN DATE
 ,OZN_ZA_SAT_P IN NUMBER := -1
 )
 IS
-- IRN 2867

  datum_l DATE := TRUNC (NVL (datum_p, SYSDATE));
  sat_l VARCHAR2(5) := TO_CHAR (NVL (datum_p, SYSDATE), 'HH24:MI');
BEGIN
  -- mora biti upisan restoran
  IF zmppres_id_p IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'zmppres_id_p');
  END IF;

  DELETE FROM prec_global;

  FOR obroci_c IN (
    SELECT
      pkaadr_id,
      sas_id,
      SUM (NVL (kol_usluge_r, 0)) AS raspolozivo,
      SUM (NVL (kol_usluge_i, 0)) AS iskoristeno
    FROM (
      -- boravak -- svi sastojci
      SELECT
        t_troskovi.pkaadr_id AS pkaadr_id,
        s_usl_sas.sas_id AS sas_id,
        SUM (t_troskovi.kol_usluge * DECODE (s_usl_sas.ozn_zbrajanja, '+', 1, '-', -1)) AS kol_usluge_r,
        0 AS kol_usluge_i
      FROM
        t_troskovi,
        s_usl_sas
      WHERE
        t_troskovi.pkaadr_id = NVL (pkaadr_id_p, t_troskovi.pkaadr_id)
        AND t_troskovi.so_id IN (SELECT so_id FROM mrec_pres_so WHERE zmppres_id = zmppres_id_p)
        AND s_usl_sas.sas_id IN (
            SELECT id
              FROM s_sastojci
             WHERE id = NVL (sas_id_p, id)
               AND gsas_id IN (SELECT id FROM m_gsastojaka WHERE ozn_obroka = -1)
               AND (ozn_za_sat_p <> -1 OR sat_l BETWEEN TO_CHAR (sat_poc, 'HH24:MI') AND TO_CHAR (sat_zav, 'HH24:MI'))
            )
        AND t_troskovi.dat_poc < datum_l
        AND t_troskovi.dat_zav > datum_l
        AND t_troskovi.usl_id = s_usl_sas.usl_id
      GROUP BY
        t_troskovi.pkaadr_id,
        s_usl_sas.sas_id,
        0
      UNION ALL

      -- dolazak -- poetni sastojci usluga kojima se zadnji dan NE rauna
      SELECT
        t_troskovi.pkaadr_id AS pkaadr_id,
        n.sas_id AS sas_id,
        SUM (t_troskovi.kol_usluge * DECODE (s_usl_sas.ozn_zbrajanja, '+', 1, '-', -1)) AS kol_usluge_r,
        0 AS kol_usluge_i
      FROM
        t_troskovi,
        s_usl_sas,
        s_usl_saspz,
        s_usl_sasb,
        s_usl_sas n,
        s_usluge
      WHERE
        t_troskovi.pkaadr_id = NVL (pkaadr_id_p, t_troskovi.pkaadr_id)
        AND t_troskovi.so_id IN (SELECT so_id FROM mrec_pres_so WHERE zmppres_id = zmppres_id_p)
        AND t_troskovi.dat_poc = datum_l
        AND t_troskovi.usl_id = s_usl_sas.usl_id
        AND t_troskovi.sas_id = s_usl_sas.sas_id
        AND s_usl_sas.usl_id = s_usluge.id
        AND s_usluge.obr_zdana = 0
        AND s_usl_sas.id = s_usl_saspz.uslsasp_id
        AND s_usl_saspz.id = s_usl_sasb.uslsaspz_id
        AND s_usl_sasb.ozn_vboravaka = 'D'
        AND n.id = s_usl_sasb.uslsas_id
        AND n.sas_id IN (
            SELECT id
              FROM s_sastojci
             WHERE id = NVL (sas_id_p, id)
               AND gsas_id IN (SELECT id FROM m_gsastojaka WHERE ozn_obroka = -1)
               AND (ozn_za_sat_p <> -1 OR sat_l BETWEEN TO_CHAR (sat_poc, 'HH24:MI') AND TO_CHAR (sat_zav, 'HH24:MI'))
            )
        AND t_troskovi.dat_poc <> t_troskovi.dat_zav
      GROUP BY
        t_troskovi.pkaadr_id,
        n.sas_id,
        0
      UNION ALL

      -- dolazak; funkcija
      SELECT
        t_troskovi.pkaadr_id AS pkaadr_id,
        s_usl_sas.sas_id AS sas_id,
        SUM (t_troskovi.kol_usluge * DECODE (s_usl_sas.ozn_zbrajanja, '+', 1, '-', -1)
          * rm_rec5150.sastojak (s_usl_sas.usl_id, 'D')) AS kol_usluge_r,
        0 AS kol_usluge_i
      FROM
        t_troskovi,
        s_usl_sas
      WHERE
        t_troskovi.pkaadr_id = NVL (pkaadr_id_p, t_troskovi.pkaadr_id)
        AND t_troskovi.so_id IN (SELECT so_id FROM mrec_pres_so WHERE zmppres_id = zmppres_id_p)
        AND t_troskovi.dat_poc = datum_l
        AND s_usl_sas.sas_id IN (
            SELECT id
              FROM s_sastojci
             WHERE id = NVL (sas_id_p, id)
               AND gsas_id IN (SELECT id FROM m_gsastojaka WHERE ozn_obroka = -1)
               AND (ozn_za_sat_p <> -1 OR sat_l BETWEEN TO_CHAR (sat_poc, 'HH24:MI') AND TO_CHAR (sat_zav, 'HH24:MI'))
            )
        AND s_usl_sas.usl_id = t_troskovi.usl_id
      GROUP BY
        t_troskovi.pkaadr_id,
        s_usl_sas.sas_id,
        0
      UNION ALL

      -- odlazak -- zadnji dan se NE rauna
      SELECT
        t_troskovi.pkaadr_id AS pkaadr_id,
        n.sas_id AS sas_id,
        SUM (t_troskovi.kol_usluge * DECODE (s_usl_sas.ozn_zbrajanja, '+', 1, '-', -1)) AS kol_usluge_r,
        0 AS kol_usluge_i
      FROM
        t_troskovi,
        s_usl_sas,
        s_usl_saspz,
        s_usl_sasb,
        s_usl_sas n,
        s_usluge
      WHERE
        t_troskovi.pkaadr_id = NVL (pkaadr_id_p, t_troskovi.pkaadr_id)
        AND t_troskovi.so_id IN (SELECT so_id FROM mrec_pres_so WHERE zmppres_id = zmppres_id_p)
        AND t_troskovi.dat_zav = datum_l
        AND t_troskovi.usl_id = s_usl_sas.usl_id
        AND t_troskovi.sas_id = s_usl_sas.sas_id
        AND s_usluge.id = s_usl_sas.usl_id
        AND s_usluge.obr_zdana = 0
        AND s_usl_sas.id = s_usl_saspz.uslsasp_id
        AND s_usl_saspz.id = s_usl_sasb.uslsaspz_id
        AND s_usl_sasb.ozn_vboravaka = 'O'
        AND n.id = s_usl_sasb.uslsas_id
        AND n.sas_id IN (
            SELECT id
              FROM s_sastojci
             WHERE id = NVL (sas_id_p, id)
               AND gsas_id IN (SELECT id FROM m_gsastojaka WHERE ozn_obroka = -1)
               AND (ozn_za_sat_p <> -1 OR sat_l BETWEEN TO_CHAR (sat_poc, 'HH24:MI') AND TO_CHAR (sat_zav, 'HH24:MI'))
            )
        AND t_troskovi.dat_poc <> t_troskovi.dat_zav
      GROUP BY
        t_troskovi.pkaadr_id,
        n.sas_id,
        0
      UNION ALL

      -- odlazak; funkcija
      SELECT
        t_troskovi.pkaadr_id AS pkaadr_id,
        s_usl_sas.sas_id AS sas_id,
        SUM (t_troskovi.kol_usluge * DECODE(s_usl_sas.ozn_zbrajanja, '+', 1, '-', -1)
          * rm_rec5150.sastojak (s_usl_sas.usl_id, 'O')) AS kol_usluge_r,
        0 AS kol_usluge_i
      FROM
        t_troskovi,
        s_usl_sas
      WHERE
        t_troskovi.pkaadr_id = NVL (pkaadr_id_p, t_troskovi.pkaadr_id)
        AND t_troskovi.so_id IN (SELECT so_id FROM mrec_pres_so WHERE zmppres_id = zmppres_id_p)
        AND t_troskovi.dat_zav = datum_l
        AND t_troskovi.usl_id = s_usl_sas.usl_id
        AND s_usl_sas.sas_id IN (
            SELECT id
              FROM s_sastojci
             WHERE id = NVL (sas_id_p, id)
               AND gsas_id IN (SELECT id FROM m_gsastojaka WHERE ozn_obroka = -1)
               AND (ozn_za_sat_p <> -1 OR sat_l BETWEEN TO_CHAR (sat_poc, 'HH24:MI') AND TO_CHAR (sat_zav, 'HH24:MI'))
            )
        AND t_troskovi.dat_poc <> t_troskovi.dat_zav
      GROUP BY
        t_troskovi.pkaadr_id,
        s_usl_sas.sas_id,
        0
      UNION ALL

      -- iskoriteno
      SELECT ALL
        recsasisk.pkaadr_id AS pkaadr_id,
        recsasisk.sas_id AS sas_id,
        0 AS kol_usluge_r,
        SUM (recsasisk.kol_iskoristena) AS kol_usluge_i
      FROM
        trec_sas_iskoristeni recsasisk
      WHERE
        recsasisk.pkaadr_id = NVL (pkaadr_id_p, recsasisk.pkaadr_id)
        AND recsasisk.oznaka = 'V'
        AND recsasisk.sas_id IN (
            SELECT id
              FROM s_sastojci
             WHERE id = NVL (sas_id_p, id)
               AND gsas_id IN (SELECT id FROM m_gsastojaka WHERE ozn_obroka = -1)
               AND (ozn_za_sat_p <> -1 OR sat_l BETWEEN TO_CHAR (sat_poc, 'HH24:MI') AND TO_CHAR (sat_zav, 'HH24:MI'))
            )
        AND TRUNC(recsasisk.datum) = datum_l
      GROUP BY
        recsasisk.pkaadr_id,
        recsasisk.sas_id,
        0
      ) obroci
    GROUP BY
      pkaadr_id,
      sas_id
    ORDER BY
      sas_id
    )
  LOOP
    INSERT INTO prec_global (id1, id2, iznos1, iznos2)
      VALUES (obroci_c.sas_id, obroci_c.pkaadr_id, obroci_c.raspolozivo, obroci_c.iskoristeno);
  END LOOP;

  -- ako se trai ukupno zbrojiti sve retke u jedan i brisati ostalo
  IF pkaadr_id_p IS NULL THEN
    INSERT INTO prec_global (id1, id2, iznos1, iznos2)
      SELECT id1, TO_NUMBER (NULL), SUM (iznos1), SUM (iznos2) FROM prec_global GROUP BY id1;
    DELETE FROM prec_global WHERE id2 IS NOT NULL;
  END IF;

  COMMIT;

END;
FUNCTION OBROCI_GOST
 (ZMPPRES_ID_P IN mzmp_prestorani.id%TYPE
 ,SJ_ID_P IN m_sj.id%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE
 ,SAS_ID_P IN s_sastojci.id%TYPE
 ,DATUM_P IN DATE
 ,OZN_ZA_SAT_P IN NUMBER := -1
 ,OZN_ODJAVLJENI_GOSTI_P IN NUMBER := -1
 )
 RETURN sys_refcursor
 IS
/*
IRN 2867
napuni prec_global s podacima o raspoloivim i iskoritenim obrocima i
vraa refcursor nadopunjen s ostalim podacima o gostu
*/

  datum_l DATE := TRUNC (NVL (datum_p, SYSDATE), 'MI'); -- datum treba ve u ovoj proceduri zbog ozn_rodjendan

  curs_l sys_refcursor;
BEGIN
  pra_rec_obroci.puni_recglo_obroci_gost (
    zmppres_id_p,
    sj_id_p,
    gost_id_p,
    sas_id_p,
    datum_l,
    ozn_za_sat_p);

  OPEN curs_l FOR
    SELECT
      sas.id AS sas_id,
      gost.id AS gost_id,
      gost.sj_id AS za_sj_id,
      usl.id AS usl_id,
      NVL (recglo.iznos1, 0) AS kol_sas,
      NVL (recglo.iznos2, 0) AS kol_sas_iskoristeno,
      sas.sifra AS sas_sifra,
      sas.naziv AS sas_naziv,
      usl.sifra AS usl_sifra,
      usl.naziv AS usl_naziv,
      gost.ime AS ime,
      gost.prezime AS prezime,
      gost.dat_dolaska AS dat_dolaska,
      gost.dat_odlaska AS dat_odlaska,
      pra_rec_s3.dob (kgost.dat_rodjenja, gost.dat_dolaska) AS dob, -- IRN 4078
      CASE
        WHEN TO_CHAR (kgost.dat_rodjenja, 'DD.MM') = TO_CHAR (datum_l, 'DD.MM') THEN 1
        ELSE NULL
      END AS ozn_rodjendan,
      ms.sifra AS ms_sifra,
      age.sifra AS age_sifra,
      age.naziv AS age_naziv,
      gost.sj_id AS gost_sj_id,
      sj.broj AS sj_broj,
      so.sifra AS so_sifra,
      so.naziv AS so_naziv,
      gost.ozn_vip AS ozn_vip,
      pres.naziv AS pres_naziv,
      gost.ozn_prisutnosti AS ozn_prisutnosti
    FROM
      t_gosti gost
      LEFT OUTER JOIN prec_global recglo ON gost.id = recglo.id2
      LEFT OUTER JOIN t_kgostiju kgost ON gost.id = kgost.gost_id
        AND kgost.oznaka = 'V'
      LEFT OUTER JOIN m_agencije age ON gost.age_id = age.id
      JOIN m_msegmenti ms ON gost.ms_id = ms.id
      JOIN m_sj sj ON gost.sj_id = sj.id
      JOIN m_so so ON sj.so_id = so.id
      LEFT OUTER JOIN mrec_pres_so recpresso ON gost.br_restorana = recpresso.br_restorana
        AND so.id = recpresso.so_id
      LEFT OUTER JOIN mzmp_prestorani pres ON recpresso.zmppres_id = pres.id
      LEFT OUTER JOIN (
        SELECT
          tro.gost_id AS gost_id,
          MIN (tro.usl_id) AS usl_id
        FROM
          t_troskovi tro
          JOIN s_usl_sas uslsas ON tro.usl_id = uslsas.usl_id
        WHERE
          uslsas.sas_id = sas_id_p
          AND uslsas.ozn_zbrajanja = '+'
          AND TRUNC (datum_l) BETWEEN tro.dat_poc AND tro.dat_zav
        GROUP BY
          tro.gost_id
        )
        tro ON tro.gost_id = gost.id
      LEFT OUTER JOIN s_usluge usl ON tro.usl_id = usl.id
      JOIN s_sastojci sas ON sas.id = NVL( sas_id_p, recglo.id1 )
    WHERE
      (gost.id = gost_id_p OR gost.sj_id = sj_id_p)
      AND (gost.ozn_prisutnosti = 'P' OR ozn_odjavljeni_gosti_p = -1)
      AND TRUNC (datum_l) BETWEEN gost.dat_dolaska AND gost.dat_odlaska
    ORDER BY
      gost.ozn_prisutnosti DESC,
      gost.prezime ASC,
      gost.ime ASC;

  RETURN curs_l;

END;
FUNCTION OBROCI_AGE
 (ZMPPRES_ID_P IN mzmp_prestorani.id%TYPE
 ,AGE_ID_P IN m_agencije.id%TYPE
 ,SAS_ID_P IN s_sastojci.id%TYPE
 ,DATUM_P IN DATE
 ,OZN_ZA_SAT_P IN NUMBER := -1
 )
 RETURN sys_refcursor
 IS
-- IRN 2867

  curs_l sys_refcursor;
BEGIN
  pra_rec_obroci.puni_recglo_obroci_age (
    zmppres_id_p,
    age_id_p,
    sas_id_p,
    datum_p,
    ozn_za_sat_p);

  OPEN curs_l FOR
    SELECT
      sas.id AS sas_id,
      age.id AS age_id,
      usl.id AS usl_id,
      NVL (recglo.iznos1, 0) AS kol_sas,
      NVL (recglo.iznos2, 0) AS kol_sas_iskoristeno,
      sas.sifra AS sas_sifra,
      sas.naziv AS sas_naziv,
      age.naziv AS age_naziv,
      usl.sifra AS usl_sifra,
      usl.naziv AS usl_naziv,
      ms.sifra AS ms_sifra,
      tro.dat_poc AS dat_poc,
      tro.dat_zav AS dat_zav
    FROM
      m_agencije age
      LEFT OUTER JOIN prec_global recglo ON age.id = recglo.id2
      JOIN s_sastojci sas ON sas.id = NVL (sas_id_p, recglo.id1)
      LEFT OUTER JOIN (
        SELECT
          tro.age_id AS age_id,
          MIN (tro.usl_id) AS usl_id
        FROM
          t_troskovi tro
          JOIN s_usl_sas uslsas ON tro.usl_id = uslsas.usl_id
        WHERE
          uslsas.sas_id = sas_id_p
          AND uslsas.ozn_zbrajanja = '+'
          AND TRUNC (datum_p) BETWEEN tro.dat_poc AND tro.dat_zav
        GROUP BY
          tro.age_id
        )
        tro2 ON tro2.age_id = age.id
      LEFT OUTER JOIN t_troskovi tro ON tro2.age_id = tro.age_id
        AND tro2.usl_id = tro.usl_id
        AND TRUNC (datum_p) BETWEEN tro.dat_poc AND tro.dat_zav
      LEFT OUTER JOIN s_usluge usl ON tro2.usl_id = usl.id
      LEFT OUTER JOIN m_msegmenti ms ON ms.id = tro.ms_id
    WHERE
      age.id = age_id_p;

  RETURN curs_l;

END;
FUNCTION OBROCI_PKAADR
 (ZMPPRES_ID_P IN mzmp_prestorani.id%TYPE
 ,PKAADR_ID_P IN mpka_adrese.id%TYPE
 ,SAS_ID_P IN s_sastojci.id%TYPE
 ,DATUM_P IN DATE
 ,OZN_ZA_SAT_P IN NUMBER := -1
 )
 RETURN sys_refcursor
 IS
-- IRN 2867

  curs_l sys_refcursor;
BEGIN
  pra_rec_obroci.puni_recglo_obroci_pkaadr (
    zmppres_id_p,
    pkaadr_id_p,
    sas_id_p,
    datum_p,
    ozn_za_sat_p);

  OPEN curs_l FOR
    SELECT
      sas.id AS sas_id,
      pkaadr.id AS pkaadr_id,
      usl.id AS usl_id,
      NVL (recglo.iznos1, 0) AS kol_sas,
      NVL (recglo.iznos2, 0) AS kol_sas_iskoristeno,
      sas.sifra AS sas_sifra,
      sas.naziv AS sas_naziv,
      CASE
        WHEN pkaadr.ime IS NULL AND pkaadr.prezime IS NULL THEN
          pkaadr.naz_poduzeca
        ELSE
          pkaadr.prezime || ' ' || pkaadr.ime
      END AS pkaadr_naziv,
      usl.sifra AS usl_sifra,
      usl.naziv AS usl_naziv,
      ms.sifra AS ms_sifra,
      tro.dat_poc AS dat_poc,
      tro.dat_zav AS dat_zav
    FROM
      mpka_adrese pkaadr
      LEFT OUTER JOIN prec_global recglo ON pkaadr.id = recglo.id2
      JOIN s_sastojci sas ON sas.id = NVL (sas_id_p, recglo.id1)
      LEFT OUTER JOIN (
        SELECT
          tro.pkaadr_id AS pkaadr_id,
          MIN (tro.usl_id) AS usl_id
        FROM
          t_troskovi tro
          JOIN s_usl_sas uslsas ON tro.usl_id = uslsas.usl_id
        WHERE
          uslsas.sas_id = sas_id_p
          AND uslsas.ozn_zbrajanja = '+'
          AND TRUNC (datum_p) BETWEEN tro.dat_poc AND tro.dat_zav
        GROUP BY
          tro.pkaadr_id
        )
        tro2 ON tro2.pkaadr_id = pkaadr.id
      LEFT OUTER JOIN t_troskovi tro ON tro2.pkaadr_id = tro.pkaadr_id
        AND tro2.usl_id = tro.usl_id
        AND TRUNC (datum_p) BETWEEN tro.dat_poc AND tro.dat_zav
      LEFT OUTER JOIN s_usluge usl ON tro2.usl_id = usl.id
      LEFT OUTER JOIN m_msegmenti ms ON ms.id = tro.ms_id
    WHERE
      pkaadr.id = pkaadr_id_p;

  RETURN curs_l;

END;
PROCEDURE PUNI_COLL_OBROCI_GOST
 (ZMPPRES_ID_P IN mzmp_prestorani.id%TYPE
 ,SJ_ID_P IN m_sj.id%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE
 ,SAS_ID_P IN s_sastojci.id%TYPE
 ,DATUM_P IN DATE
 ,OZN_ZA_SAT_P IN NUMBER := -1
 ,OZN_ODJAVLJENI_GOSTI_P IN NUMBER := -1
 )
 IS
-- IRN 2867
-- Poziva se iz apex aplikacije Obroci (f210)

  curs_l                sys_refcursor;
  obrok_gost_rec_l      obrok_gost_rec_type;
  kol_sas_raspoloziva_l NUMBER;
BEGIN
  curs_l := pra_rec_obroci.obroci_gost (
    zmppres_id_p,
    sj_id_p,
    gost_id_p,
    sas_id_p,
    datum_p,
    ozn_za_sat_p,
    ozn_odjavljeni_gosti_p);

  -- kreiraj ili oisti kolekciju OBROCI_GOST
  apex_collection.create_or_truncate_collection (
    p_collection_name => 'OBROCI_GOST');

  -- puni kolekciju OBROCI_GOST
  LOOP
    kol_sas_raspoloziva_l := 0;

    FETCH curs_l INTO obrok_gost_rec_l;
    EXIT WHEN curs_l%NOTFOUND;

    IF obrok_gost_rec_l.kol_sas > 0 THEN
      -- sprijeava negativne vrijednosti raspoloive koliine
      -- u sluaju da je gost iskoristio obrok u nekom drugom restoranu, a nema pravo u trenutnom
      kol_sas_raspoloziva_l := obrok_gost_rec_l.kol_sas - obrok_gost_rec_l.kol_sas_iskoristena;
    END IF;

    apex_collection.add_member (
      p_collection_name => 'OBROCI_GOST',
      p_c001 => obrok_gost_rec_l.sas_id,
      p_c002 => obrok_gost_rec_l.gost_id,
      p_c003 => obrok_gost_rec_l.za_sj_id,
      p_c004 => obrok_gost_rec_l.usl_id,
      p_n001 => obrok_gost_rec_l.kol_sas,
      p_n002 => obrok_gost_rec_l.kol_sas_iskoristena,
      p_n003 => kol_sas_raspoloziva_l,
      p_c005 => obrok_gost_rec_l.sas_sifra,
      p_c006 => obrok_gost_rec_l.sas_naziv,
      p_c007 => obrok_gost_rec_l.usl_sifra,
      p_c008 => obrok_gost_rec_l.usl_naziv,
      p_c009 => obrok_gost_rec_l.ime,
      p_c010 => obrok_gost_rec_l.prezime,
      p_d001 => obrok_gost_rec_l.dat_dolaska,
      p_d002 => obrok_gost_rec_l.dat_odlaska,
      p_c011 => obrok_gost_rec_l.dob,
      p_c012 => obrok_gost_rec_l.ozn_rodjendan,
      p_c013 => obrok_gost_rec_l.ms_sifra,
      p_c014 => obrok_gost_rec_l.age_sifra,
      p_c015 => obrok_gost_rec_l.age_naziv,
      p_c016 => obrok_gost_rec_l.ozn_vip,
      p_c017 => obrok_gost_rec_l.pres_naziv,
      p_c018 => obrok_gost_rec_l.ozn_prisutnosti);
  END LOOP;
END;
PROCEDURE PUNI_COLL_OBROCI_AGE
 (ZMPPRES_ID_P IN mzmp_prestorani.id%TYPE
 ,AGE_ID_P IN m_agencije.id%TYPE
 ,SAS_ID_P IN s_sastojci.id%TYPE
 ,DATUM_P IN DATE
 ,OZN_ZA_SAT_P IN NUMBER := -1
 )
 IS
-- IRN 2867
-- Poziva se iz apex aplikacije Obroci (f210)

  curs_l                sys_refcursor;
  obrok_age_rec_l       obrok_age_rec_type;
  kol_sas_raspoloziva_l NUMBER;
BEGIN
  curs_l := pra_rec_obroci.obroci_age (
    zmppres_id_p,
    age_id_p,
    sas_id_p,
    datum_p,
    ozn_za_sat_p);

  -- kreiraj ili oisti kolekciju OBROCI_AGE
  apex_collection.create_or_truncate_collection (
    p_collection_name => 'OBROCI_AGE');

  -- puni kolekciju OBROCI_AGE
  IF curs_l IS NOT NULL THEN
    LOOP
      kol_sas_raspoloziva_l := 0;

      FETCH curs_l INTO obrok_age_rec_l;
      EXIT WHEN curs_l%NOTFOUND;

      IF obrok_age_rec_l.kol_sas > 0 THEN
        -- sprijeava negativne vrijednosti raspoloive koliine
        -- u sluaju da je agencija iskoristila obrok u nekom drugom restoranu, a nema pravo u trenutnom
        kol_sas_raspoloziva_l := obrok_age_rec_l.kol_sas - obrok_age_rec_l.kol_sas_iskoristena;
      END IF;

      apex_collection.add_member (
        p_collection_name => 'OBROCI_AGE',
        p_c001 => obrok_age_rec_l.sas_id,
        p_c002 => obrok_age_rec_l.age_id,
        p_c003 => obrok_age_rec_l.usl_id,
        p_n001 => obrok_age_rec_l.kol_sas,
        p_n002 => obrok_age_rec_l.kol_sas_iskoristena,
        p_n003 => kol_sas_raspoloziva_l,
        p_c004 => obrok_age_rec_l.sas_sifra,
        p_c005 => obrok_age_rec_l.sas_naziv,
        p_c006 => obrok_age_rec_l.age_naziv,
        p_c007 => obrok_age_rec_l.usl_sifra,
        p_c008 => obrok_age_rec_l.usl_naziv,
        p_c009 => obrok_age_rec_l.ms_sifra,
        p_d001 => obrok_age_rec_l.dat_poc,
        p_d002 => obrok_age_rec_l.dat_zav);
    END LOOP;
  END IF;
END;
PROCEDURE PUNI_COLL_OBROCI_PKAADR
 (ZMPPRES_ID_P IN mzmp_prestorani.id%TYPE
 ,PKAADR_ID_P IN mpka_adrese.id%TYPE
 ,SAS_ID_P IN s_sastojci.id%TYPE
 ,DATUM_P IN DATE
 ,OZN_ZA_SAT_P IN NUMBER := -1
 )
 IS
-- IRN 2867
-- Poziva se iz apex aplikacije Obroci (f210)

  curs_l                sys_refcursor;
  obrok_pkaadr_rec_l    obrok_pkaadr_rec_type;
  kol_sas_raspoloziva_l NUMBER;
BEGIN
  curs_l := pra_rec_obroci.obroci_pkaadr (
    zmppres_id_p,
    pkaadr_id_p,
    sas_id_p,
    datum_p,
    ozn_za_sat_p);

  -- kreiraj ili oisti kolekciju OBROCI_PKAADR
  apex_collection.create_or_truncate_collection (
    p_collection_name => 'OBROCI_PKAADR');

  -- puni kolekciju OBROCI_PKAADR
  IF curs_l IS NOT NULL THEN
    LOOP
      kol_sas_raspoloziva_l := 0;

      FETCH curs_l INTO obrok_pkaadr_rec_l;
      EXIT WHEN curs_l%NOTFOUND;

      IF obrok_pkaadr_rec_l.kol_sas > 0 THEN
        -- sprijeava negativne vrijednosti raspoloive koliine
        -- u sluaju da je osoba iskoristila obrok u nekom drugom restoranu, a nema pravo u trenutnom
        kol_sas_raspoloziva_l := obrok_pkaadr_rec_l.kol_sas - obrok_pkaadr_rec_l.kol_sas_iskoristena;
      END IF;

      apex_collection.add_member (
        p_collection_name => 'OBROCI_PKAADR',
        p_c001 => obrok_pkaadr_rec_l.sas_id,
        p_c002 => obrok_pkaadr_rec_l.pkaadr_id,
        p_c003 => obrok_pkaadr_rec_l.usl_id,
        p_n001 => obrok_pkaadr_rec_l.kol_sas,
        p_n002 => obrok_pkaadr_rec_l.kol_sas_iskoristena,
        p_n003 => kol_sas_raspoloziva_l,
        p_c004 => obrok_pkaadr_rec_l.sas_sifra,
        p_c005 => obrok_pkaadr_rec_l.sas_naziv,
        p_c006 => obrok_pkaadr_rec_l.pkaadr_naziv,
        p_c007 => obrok_pkaadr_rec_l.usl_sifra,
        p_c008 => obrok_pkaadr_rec_l.usl_naziv,
        p_c009 => obrok_pkaadr_rec_l.ms_sifra,
        p_d001 => obrok_pkaadr_rec_l.dat_poc,
        p_d002 => obrok_pkaadr_rec_l.dat_zav);
    END LOOP;
  END IF;
END;
PROCEDURE PUNI_COLL_IZVJESTAJ
 (ZMPPRES_ID_P IN MZMP_PRESTORANI.ID%TYPE
 ,SAS_ID_P IN S_SASTOJCI.ID%TYPE
 ,DATUM_P IN DATE
 )
 IS
-- IRN 2996
-- Poziva se iz apex aplikacije Obroci (f210)

  ukupno_l      NUMBER;
  iskoristeno_l NUMBER;
  preostalo_l   NUMBER;
BEGIN

  -- kreiraj ili oisti kolekciju IZVJESTAJ
  apex_collection.create_or_truncate_collection ('IZVJESTAJ');


  -- GOSTI
  pra_rec_obroci.puni_recglo_obroci_gost (
    zmppres_id_p,
    NULL,
    NULL,
    sas_id_p,
    datum_p,
    0);

  -- samo je jedan redak jer se sadraj tablice prec_global
  -- izbrie na poetku poziva procedure puni_recglo_obroci_gost
  SELECT NVL (SUM (iznos1), 0), NVL (SUM (iznos2), 0), NVL (SUM (iznos1) - SUM (iznos2), 0)
    INTO ukupno_l, iskoristeno_l, preostalo_l
    FROM prec_global;

  apex_collection.add_member (
    p_collection_name => 'IZVJESTAJ',
    p_c001 => 'Gosti',
    p_n001 => preostalo_l,
    p_n002 => iskoristeno_l,
    p_n003 => ukupno_l);


  -- AGENCIJE
  pra_rec_obroci.puni_recglo_obroci_age (
    zmppres_id_p,
    NULL,
    sas_id_p,
    datum_p,
    0);

  -- samo je jedan redak jer se sadraj tablice prec_global
  -- izbrie na poetku poziva procedure puni_recglo_obroci_age
  SELECT NVL (SUM (iznos1), 0), NVL (SUM (iznos2), 0), NVL (SUM (iznos1) - SUM (iznos2), 0)
    INTO ukupno_l, iskoristeno_l, preostalo_l
    FROM prec_global;

  apex_collection.add_member (
    p_collection_name => 'IZVJESTAJ',
    p_c001 => 'Agencije',
    p_n001 => preostalo_l,
    p_n002 => iskoristeno_l,
    p_n003 => ukupno_l);


  -- ADRESE
  pra_rec_obroci.puni_recglo_obroci_pkaadr (
    zmppres_id_p,
    NULL,
    sas_id_p,
    datum_p,
    0);

  -- samo je jedan redak jer se sadraj tablice prec_global
  -- izbrie na poetku poziva procedure puni_recglo_obroci_pkaadr
  SELECT NVL (SUM (iznos1), 0), NVL (SUM (iznos2), 0), NVL (SUM (iznos1) - SUM (iznos2), 0)
    INTO ukupno_l, iskoristeno_l, preostalo_l
    FROM prec_global;

  apex_collection.add_member (
    p_collection_name => 'IZVJESTAJ',
    p_c001 => 'Adrese',
    p_n001 => preostalo_l,
    p_n002 => iskoristeno_l,
    p_n003 => ukupno_l);


  -- REDAK SUMA
  SELECT SUM (n001), SUM (n002), SUM (n003)
    INTO preostalo_l, iskoristeno_l, ukupno_l
    FROM apex_collections
   WHERE collection_name = 'IZVJESTAJ';

  apex_collection.add_member (
    p_collection_name => 'IZVJESTAJ',
    p_c001 => 'Suma',
    p_n001 => preostalo_l,
    p_n002 => iskoristeno_l,
    p_n003 => ukupno_l);

END;
PROCEDURE PUNI_COLL_TABLO
 (ZMPPRES_ID_P IN mzmp_prestorani.id%TYPE
 ,SO_ID_P IN m_so.id%TYPE
 ,SAS_ID_P IN s_sastojci.id%TYPE
 ,DATUM_P IN DATE
 ,OZN_ZAUZETE_SJ_P IN NUMBER := -1
 ,OZN_ODJAVLJENI_GOSTI_P IN NUMBER := -1
 )
 IS
/*
IRN 3227
Izrada kolekcije za prikaz tabloa
pansionskih obroka po smjetajnim jedinicama

Poziva se iz apex aplikacije Obroci (f210)
*/

  iskoristeno_l NUMBER;
  ukupno_l      NUMBER;
BEGIN

  -- kreiraj ili oisti kolekciju TABLO
  apex_collection.create_or_truncate_collection ('TABLO');

  -- za svaku SJ u navedenom SO
  FOR sj_c IN (
    SELECT DISTINCT
      sj.id AS id,
      sj.gsj_id AS gsj_id,
      sj.broj AS broj
    FROM
      m_sj sj
      LEFT OUTER JOIN t_gosti gost ON sj.id = gost.sj_id
        AND gost.ozn_prisutnosti = 'P'
        AND TRUNC (SYSDATE) BETWEEN gost.dat_dolaska AND gost.dat_odlaska
    WHERE
      sj.so_id = so_id_p
      AND (sj.dat_ponisten IS NULL OR sj.dat_ponisten > TRUNC (SYSDATE))
      AND (gost.id IS NOT NULL OR ozn_zauzete_sj_p = 0)
    ORDER BY
      sj.broj
    )
  LOOP
    -- izraunaj ukupno i iskoristeno obroka
    pra_rec_obroci.puni_recglo_obroci_gost (
      zmppres_id_p,
      sj_c.id,
      NULL,
      sas_id_p,
      datum_p,
      0);

    -- u izraun ulaze odjavljeni gosti ako je omoguen njihov prikaz
    SELECT
      NVL (SUM (recglo.iznos1), 0), NVL (SUM (recglo.iznos2), 0)
    INTO
      ukupno_l, iskoristeno_l
    FROM
      prec_global recglo
      JOIN t_gosti gost ON recglo.id2 = gost.id
        AND (gost.ozn_prisutnosti = 'P' OR ozn_odjavljeni_gosti_p = -1);

    apex_collection.add_member (
      p_collection_name => 'TABLO',
      p_c001 => sj_c.id,
      p_c002 => sj_c.gsj_id,
      p_c003 => sj_c.broj,
      p_n001 => iskoristeno_l,
      p_n002 => ukupno_l);

  END LOOP;
END;
PROCEDURE PRIPREMI_OBROKE_ZA_KCKAR
 (ZMPPRES_ID_P IN mzmp_prestorani.id%TYPE
 ,KCKAR_BROJ_P IN tkc_kartice.broj%TYPE
 ,SAS_ID_P IN s_sastojci.id%TYPE
 ,DATUM_P IN DATE
 ,OZN_ZA_SAT_P IN NUMBER := -1
 ,KCKAR_ID_P OUT tkc_kartice.id%TYPE
 ,GOST_ID_P OUT t_gosti.id%TYPE
 ,SJ_ID_P OUT m_sj.id%TYPE
 ,OZN_SJ_GOST_P OUT VARCHAR2
 ,AGE_ID_P OUT m_agencije.id%TYPE
 ,PKAADR_ID_P OUT mpka_adrese.id%TYPE
 )
 IS
-- IRN 2867
-- Poziva se iz apex aplikacije Obroci (f210 i f211)
-- Poziva procedure koje pune apex kolekciju pa se ne moe pokrenuti na bazama bez apex-a

  datum_l DATE := TRUNC (NVL (datum_p, SYSDATE), 'MI'); -- datum_p bi trebao sadravati i sat i minutu

  CURSOR kckar_c IS -- Key Card
    SELECT kckar.id, kckar.gost_id, kcjed.sj_id, kckar.age_id, kckar.pkaadr_id
      FROM tkc_kartice kckar, mkc_jedinice kcjed
     WHERE UPPER (kckar.broj) = UPPER (kckar_broj_p)
       AND kckar.kcjed_id = kcjed.id
       AND kckar.oznaka = 'V'
       AND NVL (kckar.dat_poc, datum_l) <= datum_l
       AND NVL (kckar.dat_zav, datum_l + 1) > datum_l;

  CURSOR pkakar_c IS -- IRN 4078; Pay Card
    SELECT pkakar.id, pkakar.gost_id, gost.sj_id, pkakar.age_id, pkakar.pkaadr_id
      FROM tpka_kartice pkakar, t_gosti gost
     WHERE UPPER (pkakar.broj) = UPPER (kckar_broj_p)
       AND pkakar.gost_id = gost.id(+)
       AND pkakar.oznaka = 'V'
       AND NVL (pkakar.dat_poc, datum_l) <= datum_l
       AND NVL (pkakar.dat_zav, datum_l + 1) > datum_l;

  kckar_id_l  tkc_kartice.id%TYPE;
  gost_id_l   t_gosti.id%TYPE;
  sj_id_l     m_sj.id%TYPE;
  age_id_l    m_agencije.id%TYPE;
  pkaadr_id_l mpka_adrese.id%TYPE;
BEGIN
  OPEN kckar_c;
  FETCH kckar_c INTO kckar_id_l, gost_id_l, sj_id_l, age_id_l, pkaadr_id_l;
  CLOSE kckar_c;

  IF kckar_id_l IS NULL THEN -- IRN 4078
    OPEN pkakar_c;
    FETCH pkakar_c INTO kckar_id_l, gost_id_l, sj_id_l, age_id_l, pkaadr_id_l;
    CLOSE pkakar_c;
  END IF;

  IF kckar_id_l IS NULL THEN
    RETURN;
  END IF;

  kckar_id_p := kckar_id_l;
  gost_id_p := gost_id_l;
  sj_id_p := sj_id_l;
  age_id_p := age_id_l;
  pkaadr_id_p := pkaadr_id_l;

  CASE
    -- dohvaanje gostiju
    WHEN gost_id_l IS NOT NULL AND sj_id_l IS NOT NULL THEN
      -- REC parametar 1209
      -- Prilikom koritenja obroka, neiskoritena koliina obroka se provjerava: 1 = na razini SJ, 2 = za gosta.
      IF pra_rec_zaj.vrijednost_parametra ('1209') = '1' THEN
        gost_id_l := NULL;
        ozn_sj_gost_p := 1;
      ELSIF pra_rec_zaj.vrijednost_parametra ('1209') = '2' THEN
        sj_id_l := NULL;
        ozn_sj_gost_p := 2;
      ELSE
        -- Provjerite vrijednost #0 parametra #1!
        pra_zmp_zaj.vrati_poruku (-20100, 'REC', '1209');
      END IF;

      pra_rec_obroci.puni_coll_obroci_gost (
        zmppres_id_p,
        sj_id_l,
        gost_id_l,
        sas_id_p,
        datum_l,
        ozn_za_sat_p);

    -- dohvaanje agencije
    WHEN age_id_l IS NOT NULL THEN
      pra_rec_obroci.puni_coll_obroci_age (
        zmppres_id_p,
        age_id_l,
        sas_id_p,
        datum_l,
        ozn_za_sat_p);

    -- dohvaanje adrese
    WHEN pkaadr_id_l IS NOT NULL THEN
      pra_rec_obroci.puni_coll_obroci_pkaadr (
        zmppres_id_p,
        pkaadr_id_l,
        sas_id_p,
        datum_l,
        ozn_za_sat_p);

    ELSE RETURN; -- greka: kartica ne glasi ni na gosta, ni agenciju, ni adresu
  END CASE;
END;
PROCEDURE PUNI_RECSASISK_GOST
 (ZMPPRES_ID_P IN mzmp_prestorani.id%TYPE
 ,KCKAR_ID_P IN tkc_kartice.id%TYPE
 ,SJ_ID_P IN m_sj.id%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE
 ,SAS_ID_P IN s_sastojci.id%TYPE
 ,DATUM_P IN DATE
 ,OZN_ZA_SAT_P IN NUMBER := -1
 ,KOL_ISKORISTITI_P IN trec_sas_iskoristeni.kol_iskoristena%TYPE
 ,KOL_PREOSTALA_P OUT trec_sas_iskoristeni.kol_iskoristena%TYPE
 )
 IS
/*
IRN 2867
Parametar kckar_id_p (kartica) slui samo za upis u tablicu.
Koriste li se obroci samo tog gosta ili SJ ovisi o tome je li poslan gost_id_p ili sj_id_p.
Ako sastojaka ima jo dovoljno upisuje redak u tablicu trec_sas_iskoristeni
(ako provjera ide na SJ oduzima redom od gostiju dok ima)
Vraa razliku (= preostala koliina) sastojka za iskoristiti.

Poziva se iz apex aplikacije Obroci (f210)
*/

  datum_l DATE := TRUNC (NVL (datum_p, SYSDATE), 'MI');
  usl_id_l s_usluge.id%TYPE;
  kol_raspoloziva_l NUMBER;
  kol_iskoristiti_l NUMBER;
  recsasisk_rec_l trec_sas_iskoristeni%ROWTYPE;
BEGIN

  IF zmppres_id_p IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'zmppres_id_p');
  END IF;

  IF (gost_id_p IS NULL AND sj_id_p IS NULL)
    OR (gost_id_p IS NOT NULL AND sj_id_p IS NOT NULL)
  THEN
    -- mora biti upisano ili gost ili SJ
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'gost_id_p, sj_id_p');
  END IF;

  IF NVL (kol_iskoristiti_p, 0) <= 0 THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'kol_iskoristiti_p');
  END IF;

  pra_rec_obroci.puni_recglo_obroci_gost (
    zmppres_id_p,
    sj_id_p,
    gost_id_p,
    sas_id_p,
    datum_l,
    ozn_za_sat_p);

  kol_iskoristiti_l := NVL (kol_iskoristiti_p, 0);
  -- iznos1 = kol_raspoloziva, iznos2 = kol_iskoristena
  SELECT NVL (SUM (iznos1) - SUM (iznos2), 0) INTO kol_raspoloziva_l FROM prec_global;

  IF kol_raspoloziva_l < kol_iskoristiti_l THEN
    -- Raspoloiva koliina (#0) manja je od koliine koju elite iskoristiti (#1)
    pra_rec_zaj.vrati_poruku (-20641, kol_raspoloziva_l, kol_iskoristiti_p);
  END IF;

  FOR kolsas_c IN (
    SELECT id1 AS sas_id, id2 AS gost_id, id3 AS sj_id, iznos1 AS kol_raspoloziva, iznos2 AS kol_iskoristena
      FROM prec_global
     WHERE iznos1 - iznos2 > 0)
  LOOP
    SELECT MIN (tro.usl_id) AS usl_id
      INTO usl_id_l
      FROM t_troskovi tro
      JOIN s_usl_sas uslsas ON tro.usl_id = uslsas.usl_id
     WHERE tro.gost_id = kolsas_c.gost_id
       AND uslsas.sas_id = kolsas_c.sas_id
       AND uslsas.ozn_zbrajanja = '+'
       AND TRUNC (datum_l) BETWEEN tro.dat_poc AND tro.dat_zav;

    IF kol_iskoristiti_l <= kolsas_c.kol_raspoloziva - kolsas_c.kol_iskoristena THEN
      recsasisk_rec_l.kol_iskoristena := kol_iskoristiti_l;
      recsasisk_rec_l.kol_raspoloziva_1 := kol_raspoloziva_l;
      kol_raspoloziva_l := kol_raspoloziva_l - kol_iskoristiti_l;
      kol_iskoristiti_l := 0;
    ELSE -- ako u retku za jednog gosta odnosno sastojak nema dovoljno oduzimat e se od sljedeeg retka (sljedei gost ili sastojak)
      recsasisk_rec_l.kol_iskoristena := kolsas_c.kol_raspoloziva - kolsas_c.kol_iskoristena;
      recsasisk_rec_l.kol_raspoloziva_1 := kol_raspoloziva_l;
      kol_raspoloziva_l := kol_raspoloziva_l - (kolsas_c.kol_raspoloziva - kolsas_c.kol_iskoristena);
      kol_iskoristiti_l := kol_iskoristiti_l - (kolsas_c.kol_raspoloziva - kolsas_c.kol_iskoristena);
    END IF;
    recsasisk_rec_l.zmppres_id := zmppres_id_p;
    recsasisk_rec_l.sas_id := kolsas_c.sas_id;
    recsasisk_rec_l.sas_id_1 := sas_id_p;
    recsasisk_rec_l.usl_id := usl_id_l;
    recsasisk_rec_l.kckar_id_1 := kckar_id_p;
    recsasisk_rec_l.sj_id := kolsas_c.sj_id;
    recsasisk_rec_l.gost_id := kolsas_c.gost_id;
    recsasisk_rec_l.gost_id_1 := gost_id_p;
    recsasisk_rec_l.oznaka := 'V';
    recsasisk_rec_l.datum := datum_l;
    recsasisk_rec_l.datum_1 := datum_p;
    recsasisk_rec_l.napomena := napomena_m; -- IRN 4078
     -- razmisliti da li ipak prenijeti oznaku koja se koristila kod provjere.
     -- Ako ostane ovako paziti da se ita na shemi 'iskoritavanja' kao kod provjere
    recsasisk_rec_l.ozn_sj_gost_1 := pra_rec_zaj.vrijednost_parametra ('1209');
    recsasisk_rec_l.ozn_samo_raspolozivo_1 := -1;
    INSERT INTO trec_sas_iskoristeni VALUES recsasisk_rec_l;

    EXIT WHEN kol_iskoristiti_l = 0;
  END LOOP;

  COMMIT;

  kol_preostala_p := kol_raspoloziva_l;
  napomena_m := NULL;

END;
PROCEDURE PUNI_RECSASISK_AGE
 (ZMPPRES_ID_P IN mzmp_prestorani.id%TYPE
 ,KCKAR_ID_P IN tkc_kartice.id%TYPE
 ,AGE_ID_P IN m_agencije.id%TYPE
 ,SAS_ID_P IN s_sastojci.id%TYPE
 ,DATUM_P IN DATE
 ,OZN_ZA_SAT_P IN NUMBER := -1
 ,KOL_ISKORISTITI_P IN trec_sas_iskoristeni.kol_iskoristena%TYPE
 ,KOL_PREOSTALA_P OUT trec_sas_iskoristeni.kol_iskoristena%TYPE
 )
 IS
-- IRN 2867
-- Poziva se iz apex aplikacije Obroci (f210)

  datum_l DATE := TRUNC (NVL (datum_p, SYSDATE), 'MI');
  usl_id_l s_usluge.id%TYPE;
  kol_raspoloziva_l NUMBER;
  kol_iskoristiti_l NUMBER;
BEGIN

  IF zmppres_id_p IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'zmppres_id_p');
  END IF;
  IF age_id_p IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'age_id_p');
  END IF;
  IF NVL (kol_iskoristiti_p, 0) <= 0 THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'kol_iskoristiti_p');
  END IF;

  pra_rec_obroci.puni_recglo_obroci_age (
    zmppres_id_p,
    age_id_p,
    sas_id_p,
    datum_l,
    ozn_za_sat_p);

  kol_iskoristiti_l := NVL (kol_iskoristiti_p, 0);
  -- iznos1 = kol_raspoloziva, iznos2 = kol_iskoristena
  SELECT NVL (SUM (iznos1) - SUM (iznos2), 0) INTO kol_raspoloziva_l FROM prec_global;

  IF kol_raspoloziva_l < kol_iskoristiti_l THEN
    -- Raspoloiva koliina (#0) manja je od koliine koju elite iskoristiti (#1)
    pra_rec_zaj.vrati_poruku (-20641, kol_raspoloziva_l, kol_iskoristiti_p);
  END IF;

  SELECT MIN (tro.usl_id) AS usl_id
    INTO usl_id_l
    FROM t_troskovi tro
    JOIN s_usl_sas uslsas ON tro.usl_id = uslsas.usl_id
   WHERE tro.age_id = (SELECT id2 FROM prec_global)
     AND uslsas.sas_id = (SELECT id1 FROM prec_global)
     AND uslsas.ozn_zbrajanja = '+'
     AND TRUNC (datum_l) BETWEEN tro.dat_poc AND tro.dat_zav;

  -- u praksi bi za agenciju trebao biti samo jedan redak u PREC_GLOBAL
  INSERT INTO trec_sas_iskoristeni (
    zmppres_id,
    sas_id,
    usl_id,
    age_id,
    datum,
    kol_iskoristena,
    sas_id_1,
    kckar_id_1,
    datum_1,
    kol_raspoloziva_1,
    ozn_samo_raspolozivo_1,
    napomena) -- IRN 4078
  VALUES (
    zmppres_id_p,
    (SELECT id1 FROM prec_global),
    usl_id_l,
    (SELECT id2 FROM prec_global),
    datum_l,
    kol_iskoristiti_l,
    sas_id_p,
    kckar_id_p,
    datum_p,
    kol_raspoloziva_l,
    -1,
    napomena_m); -- IRN 4078

  napomena_m := NULL; -- IRN 4078

END;
PROCEDURE PUNI_RECSASISK_PKAADR
 (ZMPPRES_ID_P IN mzmp_prestorani.id%TYPE
 ,KCKAR_ID_P IN tkc_kartice.id%TYPE
 ,PKAADR_ID_P IN mpka_adrese.id%TYPE
 ,SAS_ID_P IN s_sastojci.id%TYPE
 ,DATUM_P IN DATE
 ,OZN_ZA_SAT_P IN NUMBER := -1
 ,KOL_ISKORISTITI_P IN trec_sas_iskoristeni.kol_iskoristena%TYPE
 ,KOL_PREOSTALA_P OUT trec_sas_iskoristeni.kol_iskoristena%TYPE
 )
 IS
-- IRN 2867
-- Poziva se iz apex aplikacije Obroci (f210)

  datum_l DATE := TRUNC (NVL (datum_p, SYSDATE), 'MI');
  usl_id_l s_usluge.id%TYPE;
  kol_raspoloziva_l NUMBER;
  kol_iskoristiti_l NUMBER;
BEGIN

  IF zmppres_id_p IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'zmppres_id_p');
  END IF;
  IF pkaadr_id_p IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'pkaadr_id_p');
  END IF;
  IF NVL (kol_iskoristiti_p, 0) <= 0 THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'kol_iskoristiti_p');
  END IF;

  pra_rec_obroci.puni_recglo_obroci_pkaadr (
    zmppres_id_p,
    pkaadr_id_p,
    sas_id_p,
    datum_l,
    ozn_za_sat_p);

  kol_iskoristiti_l := NVL (kol_iskoristiti_p, 0);
  -- iznos1 = kol_raspoloziva, iznos2 = kol_iskoristena
  SELECT NVL (SUM (iznos1) - SUM (iznos2), 0) INTO kol_raspoloziva_l FROM prec_global;

  IF kol_raspoloziva_l < kol_iskoristiti_l THEN
    -- Raspoloiva koliina (#0) manja je od koliine koju elite iskoristiti (#1)
    pra_rec_zaj.vrati_poruku (-20641, kol_raspoloziva_l, kol_iskoristiti_p);
  END IF;

  SELECT MIN (tro.usl_id)
    INTO usl_id_l
    FROM t_troskovi tro
    JOIN s_usl_sas uslsas ON tro.usl_id = uslsas.usl_id
   WHERE tro.pkaadr_id = (SELECT id2 FROM prec_global)
     AND uslsas.sas_id = (SELECT id1 FROM prec_global)
     AND uslsas.ozn_zbrajanja = '+'
     AND TRUNC (datum_l) BETWEEN tro.dat_poc AND tro.dat_zav;

  -- u praksi bi za adresu trebao biti samo jedan redak u PREC_GLOBAL
  INSERT INTO trec_sas_iskoristeni (
    zmppres_id,
    sas_id,
    usl_id,
    pkaadr_id,
    datum,
    kol_iskoristena,
    sas_id_1,
    kckar_id_1,
    datum_1,
    kol_raspoloziva_1,
    ozn_samo_raspolozivo_1,
    napomena) -- IRN 4078
  VALUES (
    zmppres_id_p,
    (SELECT id1 FROM prec_global),
    usl_id_l,
    (SELECT id2 FROM prec_global),
    datum_l,
    kol_iskoristiti_l,
    sas_id_p,
    kckar_id_p,
    datum_p,
    kol_raspoloziva_l,
    -1,
    napomena_m); -- IRN 4078;

  napomena_m := NULL; -- IRN 4078

END;
PROCEDURE KORISTI_OBROKE_ZA_KCKAR
 (ZMPPRES_ID_P IN mzmp_prestorani.id%TYPE
 ,KCKAR_BROJ_P IN tkc_kartice.broj%TYPE
 ,SAS_ID_P IN s_sastojci.id%TYPE
 ,DATUM_P IN DATE
 ,OZN_ZA_SAT_P IN NUMBER := -1
 ,KOL_ISKORISTITI_P IN trec_sas_iskoristeni.kol_iskoristena%TYPE
 ,KCKAR_ID_P OUT tkc_kartice.id%TYPE
 ,GOST_ID_P OUT t_gosti.id%TYPE
 ,SJ_ID_P OUT m_sj.id%TYPE
 ,AGE_ID_P OUT m_agencije.id%TYPE
 ,PKAADR_ID_P OUT mpka_adrese.id%TYPE
 ,KOL_PREOSTALA_P OUT trec_sas_iskoristeni.kol_iskoristena%TYPE
 )
 IS
-- IRN 2867
-- Poziva se iz apex aplikacije Obroci (f211)

  datum_l DATE := TRUNC (NVL (datum_p, SYSDATE), 'MI'); -- datum_p bi trebao sadravati i sat i minutu

  CURSOR kckar_c IS -- Key Card
    SELECT kckar.id, kckar.gost_id, kcjed.sj_id, kckar.age_id, kckar.pkaadr_id, 'Key Card'
      FROM tkc_kartice kckar, mkc_jedinice kcjed
     WHERE UPPER (kckar.broj) = UPPER (kckar_broj_p)
       AND kckar.kcjed_id = kcjed.id
       AND kckar.oznaka = 'V'
       AND NVL (kckar.dat_poc, datum_l) <= datum_l
       AND NVL (kckar.dat_zav, datum_l + 1) > datum_l;

  CURSOR pkakar_c IS -- IRN 4078; Pay Card
    SELECT pkakar.id, pkakar.gost_id, gost.sj_id, pkakar.age_id, pkakar.pkaadr_id, 'Pay Card'
      FROM tpka_kartice pkakar, t_gosti gost
     WHERE UPPER (pkakar.broj) = UPPER (kckar_broj_p)
       AND pkakar.gost_id = gost.id(+)
       AND pkakar.oznaka = 'V'
       AND NVL (pkakar.dat_poc, datum_l) <= datum_l
       AND NVL (pkakar.dat_zav, datum_l + 1) > datum_l;

  kckar_id_l tkc_kartice.id%TYPE;
  gost_id_l t_gosti.id%TYPE;
  sj_id_l m_sj.id%TYPE;
  age_id_l m_agencije.id%TYPE;
  pkaadr_id_l mpka_adrese.id%TYPE;
BEGIN

  OPEN kckar_c;
  FETCH kckar_c INTO kckar_id_l, gost_id_l, sj_id_l, age_id_l, pkaadr_id_l, napomena_m;
  CLOSE kckar_c;

  IF kckar_id_l IS NULL THEN -- IRN 4078
    OPEN pkakar_c;
    FETCH pkakar_c INTO kckar_id_l, gost_id_l, sj_id_l, age_id_l, pkaadr_id_l, napomena_m;
    CLOSE pkakar_c;
  END IF;

  IF kckar_id_l IS NULL THEN
    RETURN;
  END IF;

  kckar_id_p := kckar_id_l;
  gost_id_p := gost_id_l;
  sj_id_p := sj_id_l;
  age_id_p := age_id_l;
  pkaadr_id_p := pkaadr_id_l;

  CASE
    -- koritenje na gosta/SJ
    WHEN gost_id_l IS NOT NULL AND sj_id_l IS NOT NULL THEN
      -- REC parametar 1209
      -- Prilikom koritenja obroka, neiskoritena koliina obroka se provjerava: 1 = na razini SJ, 2 = za gosta.
      IF pra_rec_zaj.vrijednost_parametra ('1209') = '1' THEN
        gost_id_l := NULL;
        -- ozn_sj_gost_p := 1;
      ELSIF pra_rec_zaj.vrijednost_parametra ('1209') = '2' THEN
        sj_id_l := NULL;
        -- ozn_sj_gost_p := 2;
      ELSE
        -- Provjerite vrijednost #0 parametra #1!
        pra_zmp_zaj.vrati_poruku (-20100, 'REC', '1209');
      END IF;

      pra_rec_obroci.puni_recsasisk_gost (
        zmppres_id_p,
        kckar_id_p,
        sj_id_l,
        gost_id_l,
        sas_id_p,
        datum_l,
        ozn_za_sat_p,
        kol_iskoristiti_p,
        kol_preostala_p);

    -- koritenje na agenciju
    WHEN age_id_l IS NOT NULL THEN
      pra_rec_obroci.puni_recsasisk_age (
        zmppres_id_p,
        kckar_id_p,
        age_id_l,
        sas_id_p,
        datum_l,
        ozn_za_sat_p,
        kol_iskoristiti_p,
        kol_preostala_p);

    -- koritenje na adresu
    WHEN pkaadr_id_l IS NOT NULL THEN
      pra_rec_obroci.puni_recsasisk_pkaadr (
        zmppres_id_p,
        kckar_id_p,
        pkaadr_id_l,
        sas_id_p,
        datum_l,
        ozn_za_sat_p,
        kol_iskoristiti_p,
        kol_preostala_p);

    ELSE RETURN; -- greka: kartica ne glasi ni na gosta, ni agenciju, ni adresu
  END CASE;
END;

END PRA_REC_OBROCI;
/
SHOW ERROR

