PROMPT Creating Package Body 'PRA_REC_LIS'
CREATE OR REPLACE PACKAGE BODY PRA_REC_LIS IS

URL_M VARCHAR2(4000);
END_POINT_M VARCHAR2(1000);
TIMEOUT_M NUMBER;
ODGOVOR_M CLOB;
ACCESS_TOKEN_M VARCHAR2(1024);
LOG_FILE_NAME_M VARCHAR2(100);
PKACLOB_DATA_M CLOB;


PROCEDURE GET_POINTS
 (TIMEOUT_P IN NUMBER := NULL
 ,GOD_POSLOVNA_P IN t_gosti.god_poslovna%TYPE
 ,SO_SIFRA_P IN m_so.sifra%TYPE
 ,GOST_RBR_P IN t_gosti.rbr%TYPE
 ,BASE_AMMOUNT_P IN t_racuni.iznos%TYPE
 ,POINTS_AVAILABLE_P OUT NUMBER
 ,STEP_P OUT NUMBER
 )
 IS
--
  values_l           APEX_JSON.t_values; -- IRN 3385
  status_l           VARCHAR2(5); -- true ili false
  error_message_l    VARCHAR2(2000);
  points_available_l NUMBER;
  step_l             NUMBER;
BEGIN

  /*
  primjer:  /getpoints/get?godPoslovna=1000+soSifra=001+rbr=000001+baseAmmount=1230.43
  napomena: znak + je znak and
  */

  -- CHR(38) -> znak and
  end_point_m := '/getpoints/get' ||
    '?godPoslovna=' || god_poslovna_p ||
    CHR(38) || 'soSifra=' || so_sifra_p ||
    CHR(38) || 'rbr=' || gost_rbr_p ||
    CHR(38) || 'baseAmmount=' || TRIM (TO_CHAR (base_ammount_p, '9999999990D00', 'NLS_NUMERIC_CHARACTERS = ''.,'''));

  zaj_get (timeout_p); -- IRN 3385

  /*
  {
    "PointsAvailable": 1050,
    "Step": 25,
    "Status": true,
    "ErrorMessage": null
  }
  */
  -- IRN 3385
  APEX_JSON.parse (values_l, odgovor_m);
  points_available_l := APEX_JSON.get_number (p_path => 'PointsAvailable', p_values => values_l);
  step_l := APEX_JSON.get_number (p_path => 'Step', p_values => values_l);
  status_l := APEX_JSON.get_varchar2 (p_path => 'Status', p_values => values_l);
  error_message_l := APEX_JSON.get_varchar2 (p_path => 'ErrorMessage', p_values => values_l);
  -- KRAJ IRN 3385

  IF status_l = 'false' THEN
    pra_zmp_zaj.vrati_poruku (-20000, error_message_l);
  END IF;

  points_available_p := points_available_l;
  step_p  := step_l;

END;
PROCEDURE PROCCESS_RECIEPT
 (TIMEOUT_P IN NUMBER := NULL
 ,GOD_POSLOVNA_P IN t_racuni.god_poslovna%TYPE
 ,OJ_SIFRA_P IN m_oj.sifra%TYPE
 ,RAC_RBR_P IN t_racuni.rbr%TYPE
 ,VAPLDOK_SIFRA_P IN s_vapldok.oznaka%TYPE
 ,POINTS_EARNED_P OUT NUMBER
 ,TOTAL_POINTS_P OUT NUMBER
 )
 IS
--
  values_l        APEX_JSON.t_values; -- IRN 3385
  status_l        VARCHAR2(5); -- true ili false
  error_message_l VARCHAR2(2000);
  points_earned_l NUMBER;
  total_points_l  NUMBER;
BEGIN

  /*
  primjer:  /api/proccessreciept/get?godPoslovna=2017+ojSifra=871+rbr=000111+vapldokSifra=GI
  napomena: znak + je znak and
  */

  -- CHR(38) -> znak and
  end_point_m := '/proccessreciept/get' ||
    '?godPoslovna=' || god_poslovna_p ||
    CHR(38) || 'ojSifra=' || oj_sifra_p ||
    CHR(38) || 'rbr=' || rac_rbr_p ||
    CHR(38) || 'vapldokSifra=' || vapldok_sifra_p;

  zaj_get (timeout_p); -- IRN 3385

  -- IRN 3385
  /*
  {
    "PointsEarned": 1061,
    "TotalPoints": 0,
    "Status": true,
    "ErrorMessage": "No Errors"
  }
  */
  APEX_JSON.parse (values_l, odgovor_m);
  points_earned_l := APEX_JSON.get_number (p_path => 'PointsEarned', p_values => values_l);
  total_points_l := APEX_JSON.get_number (p_path => 'TotalPoints', p_values => values_l);
  status_l := APEX_JSON.get_varchar2 (p_path => 'Status', p_values => values_l);
  error_message_l := APEX_JSON.get_varchar2 (p_path => 'ErrorMessage', p_values => values_l);
  -- KRAJ IRN 3385

  IF status_l = 'false' THEN
    pra_zmp_zaj.vrati_poruku (-20000, error_message_l);
  END IF;

  points_earned_p := points_earned_l;
  total_points_p  := total_points_l;

END;
PROCEDURE ZAJ_GET
 (TIMEOUT_P IN NUMBER := NULL
 )
 IS
-- LIS (LoyaltyInSky) je web servis tvrtke InSky Solutions

  req_l  UTL_HTTP.req;
  res_l  UTL_HTTP.resp;
  clob_l CLOB;
  text_l VARCHAR2(32767);

  datetime_l VARCHAR2(20); -- IRN 3385
BEGIN

  url_m := pra_zmp_zaj.zmppar_vrijednost ('LOY', '1020'); -- IRN 3385

  IF timeout_p IS NULL THEN -- IRN 3385
    timeout_m := pra_zmp_zaj.zmppar_vrijednost ('LOY', '1018');
  ELSE
    timeout_m := timeout_p;
  END IF;

  odgovor_m := 'false';

  UTL_HTTP.set_detailed_excp_support (enable => true);

  UTL_HTTP.set_transfer_timeout (timeout => timeout_m);

  url_m := url_m || end_point_m;
  pra_rec.puni_promjene ('9401', 'url_m: ' || url_m, -1);

  req_l := UTL_HTTP.begin_request (url => url_m, method => 'GET', http_version => 'HTTP/1.1');

  UTL_HTTP.set_header (r => req_l, name => 'Content-Type', value => 'application/json; charset=utf-8');

  datetime_l := TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS'); -- IRN 3385

  res_l := UTL_HTTP.get_response (req_l);

  IF res_l.status_code = UTL_HTTP.HTTP_OK THEN
    odgovor_m := NULL;
  ELSE
    pra_zmp_zaj.vrati_poruku (-20000, res_l.status_code || ': ' || res_l.reason_phrase);
  END IF;

  -- Initialize the CLOB.
  DBMS_LOB.createtemporary (clob_l, FALSE);

  -- Copy the response into the CLOB.
  BEGIN
    LOOP
      UTL_HTTP.read_text (res_l, text_l, 32766);
      DBMS_LOB.writeappend (clob_l, LENGTH (text_l), text_l);
    END LOOP;
    UTL_HTTP.end_response (res_l);
  EXCEPTION
    WHEN UTL_HTTP.end_of_body THEN
      UTL_HTTP.end_response (res_l);
  END;

  odgovor_m := clob_l;
  pra_rec.puni_promjene ('9401', SUBSTR ('odgovor_m: ' || odgovor_m || ' | ' || datetime_l || ' url_m: ' || url_m, 1, 2000), -1); -- IRN 3385

EXCEPTION
  WHEN OTHERS THEN
    -- IRN 3385
    pra_rec.puni_promjene ('9401', SUBSTR ('odgovor_m: ' || odgovor_m || ' | ' || SQLERRM || ' | ' || datetime_l || ' url_m: ' || url_m, 1, 2000), 0);
    UTL_HTTP.end_response (res_l);
    RAISE;
END;
PROCEDURE PING
 (TIMEOUT_P IN NUMBER := NULL
 ,ODGOVOR_P OUT VARCHAR2
 )
 IS
-- IRN 3385
BEGIN

  -- https://loyop.aminess.com/api/ping/get
  -- http://odbmishsvc.lano.local:9999/api/ping/get

  end_point_m := '/ping/get';

  zaj_get (timeout_p);

  odgovor_p := SUBSTR (odgovor_m, 1, 10); -- "OK"

END;
PROCEDURE GET_POINTS_BECRM
 (TIMEOUT_P IN NUMBER := NULL
 ,LOYKAR_BROJ_P IN VARCHAR2
 ,AMOUNT_P IN t_racuni.iznos%TYPE
 ,POINTS_AVAILABLE_P OUT NUMBER
 ,STEP_P OUT NUMBER
 )
 IS
-- IRN 4108; Be-terna CRM API
-- Returns available points for a receipt for a given guest loyalty profile.

  values_l           APEX_JSON.t_values;
  message_l          VARCHAR2(2000);
  success_l          VARCHAR2(5) := 'false'; -- true ili false
  error_message_l    VARCHAR2(2000);
  points_available_l NUMBER;
  step_l             NUMBER;
BEGIN

  /*
  primjer:  /api/v1/mish/getpoints?loyalty_card=525000105+amount=102
  napomena: znak + je znak and
  */

  -- CHR(38) -> znak and
  end_point_m := '/api/v1/mish/getpoints' ||
    '?loyalty_card=' || loykar_broj_p ||
    CHR(38) || 'amount=' || TRIM (TO_CHAR (amount_p, '9999999990D00', 'NLS_NUMERIC_CHARACTERS = ''.,'''));

  zaj_get_becrm (timeout_p);

  /*
  {
    "success": true,
    "points_available": 1020,
    "error_message": "",
    "step": 10
  }

  ili

  {
    "message": "string",
    "code": "string",
    "details": "string",
    "field_errors": {
      "additionalProp1": "string",
      "additionalProp2": "string",
      "additionalProp3": "string"
    }
  }
  */

  APEX_JSON.parse (values_l, odgovor_m);
  message_l := APEX_JSON.get_varchar2 (p_path => 'message', p_values => values_l);
  success_l := APEX_JSON.get_varchar2 (p_path => 'success', p_values => values_l);
  points_available_l := APEX_JSON.get_number (p_path => 'points_available', p_values => values_l);
  error_message_l := APEX_JSON.get_varchar2 (p_path => 'error_message', p_values => values_l);
  step_l := APEX_JSON.get_number (p_path => 'step', p_values => values_l);

  IF success_l = 'false' THEN
    pra_zmp_zaj.vrati_poruku (-20000, NVL (error_message_l, message_l));
  END IF;

  points_available_p := points_available_l;
  step_p  := step_l;

END;
PROCEDURE PROCESS_RECEIPT_BECRM
 (TIMEOUT_P IN NUMBER := NULL
 ,RAC_ID_P IN t_racuni.id%TYPE
 ,RAC_UIDC_P IN VARCHAR2
 ,RACP_UIDC_P IN VARCHAR2 := NULL
 ,RECAGOST_RBR_P IN trec_agostiju.rbr%TYPE
 ,LOYKAR_BROJ_P IN tloy_kartice.broj%TYPE
 ,POINTS_P IN NUMBER
 )
 IS
-- IRN 4108; Be-terna CRM API
-- Use (or return) points for a receipt for a given guest loyalty profile.

  br_redaka_l     NUMBER;
  values_l        APEX_JSON.t_values;
  message_l       VARCHAR2(2000);
  success_l       VARCHAR2(5) := 'false'; -- true ili false
  error_message_l VARCHAR2(2000);
  -- total_points_l  NUMBER;
BEGIN

  IF rac_id_p IS NULL THEN
    RETURN;
  END IF;

  SELECT COUNT(1) INTO br_redaka_l
    FROM lloy_racuni
   WHERE id = rac_id_p
     AND oznaka = 0;
  IF br_redaka_l > 0 THEN
    RETURN; -- informacija o koliini iskoritenih bodova je poslana
  END IF;

  /*
  primjer za V raun:
  /api/v1/mish/processreceipt?uidc=2025-801-GI-000018+rbr=00046597+loyalty_card=801043+points=100
  primjer za N raun:
  /api/v1/mish/processreceipt?uidc=2025-801-GI-000019+racp_uidc=2025-801-GI-000018+rbr=00046597+loyalty_card=801043+points=-100
  napomena: znak + je znak and
  */

  -- CHR(38) -> znak and
  end_point_m := '/api/v1/mish/processreceipt' || '?uidc=' || rac_uidc_p;
  IF racp_uidc_p IS NOT NULL THEN
    end_point_m := end_point_m || CHR(38) || 'racp_uidc=' || racp_uidc_p;
  END IF;
  end_point_m := end_point_m ||
    CHR(38) || 'rbr=' || recagost_rbr_p ||
    CHR(38) || 'loyalty_card=' || loykar_broj_p ||
    CHR(38) || 'points=' || points_p;

  zaj_get_becrm (timeout_p);

  /*
  {
    "success": true,
    "error_message": "",
    "total_points": 900
  }

  ili

  {
    "message": "Resource not found",
    "code": "LoyaltyService.NotFound",
    "details": "",
    "field_errors": {
      "loyalty_service.not_found": "Resource not found"
    }
  }
  */

  APEX_JSON.parse (values_l, odgovor_m);
  message_l := APEX_JSON.get_varchar2 (p_path => 'message', p_values => values_l);
  success_l := APEX_JSON.get_varchar2 (p_path => 'success', p_values => values_l);
  error_message_l := APEX_JSON.get_varchar2 (p_path => 'error_message', p_values => values_l);
  -- total_points_l := APEX_JSON.get_number (p_path => 'total_points', p_values => values_l); -- ne sprema se

  IF success_l = 'true' THEN
    -- koliina iskoritenih bodova programa vjernosti za raun rac_id_p je uspjeno poslana
    INSERT INTO lloy_racuni (id, oznaka) VALUES (rac_id_p, 0);
    COMMIT;
  ELSE
    pra_zmp_zaj.vrati_poruku (-20000, NVL (error_message_l, message_l));
  END IF;

END;
PROCEDURE ZAJ_GET_BECRM
 (TIMEOUT_P IN NUMBER := NULL
 )
 IS
-- IRN 4108; Be-terna CRM API
  req_l   UTL_HTTP.req;
  res_l   UTL_HTTP.resp;
  clob_l  CLOB;
  text_l  VARCHAR2(32767);
BEGIN

  log_file_name_m := 'api-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '.log';

  zaj_post_becrm (timeout_p); -- puni access_token_m

  odgovor_m := 'false';

  UTL_HTTP.set_detailed_excp_support (enable => true);
  UTL_HTTP.set_transfer_timeout (timeout => timeout_m);

  url_m := url_m || end_point_m;
  pkaclob_data_m := CHR(10) || 'Request [' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' || CHR(10) || url_m || CHR(10);

  req_l := UTL_HTTP.begin_request (url => url_m, method => 'GET', http_version => 'HTTP/1.1');

  UTL_HTTP.set_header (r => req_l, name => 'Content-Type', value => 'application/json; charset=utf-8');
  UTL_HTTP.set_header (req_l, 'Authorization', 'Bearer ' || access_token_m);

  res_l := UTL_HTTP.get_response (req_l);

  -- Initialize the CLOB.
  DBMS_LOB.createtemporary (clob_l, FALSE);

  -- Copy the response into the CLOB.
  BEGIN
    LOOP
      UTL_HTTP.read_text (res_l, text_l, 32766);
      DBMS_LOB.writeappend (clob_l, LENGTH (text_l), text_l);
    END LOOP;
    UTL_HTTP.end_response (res_l);
  EXCEPTION
    WHEN UTL_HTTP.end_of_body THEN
      UTL_HTTP.end_response (res_l);
  END;

  odgovor_m := clob_l;

  pkaclob_data_m := pkaclob_data_m || 'Response [' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' || CHR(10) || odgovor_m || CHR(10);
  pra_pka2.clob_to_table (pkaclob_data_m, log_file_name_m, NULL, 'CRM');

EXCEPTION
  WHEN OTHERS THEN
    pkaclob_data_m := pkaclob_data_m || 'Error [' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' || CHR(10) || SQLERRM || CHR(10); 
    pra_pka2.clob_to_table (pkaclob_data_m, log_file_name_m, NULL, 'CRM');
    UTL_HTTP.end_response (res_l);
    RAISE;
END;
PROCEDURE ZAJ_POST_BECRM
 (TIMEOUT_P IN NUMBER := NULL
 )
 IS
-- IRN 4108; Be-terna CRM API
-- Get access token

  client_id_l  szmp_parametri.vrijednost%TYPE;
  client_key_l szmp_parametri.vrijednost%TYPE;
  data_l       CLOB;

  req_l  UTL_HTTP.req;
  res_l  UTL_HTTP.resp;
  clob_l CLOB;
  text_l VARCHAR2(32767);

  values_l APEX_JSON.t_values;
BEGIN

  log_file_name_m := 'api-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '.log';

  url_m := pra_zmp_zaj.zmppar_vrijednost ('LOY', '1020');

  client_id_l := pra_zmp_zaj.zmppar_vrijednost ('LOY', '1021');
  client_key_l := pra_zmp_zaj.zmppar_vrijednost ('LOY', '1022');

  /*
  {
    "client_id": "aminess-mish",
    "client_key": "wK7pL2tN5xM9rQ4vH8jC6fG3yB1sD0zA"
  }
  */

  APEX_JSON.initialize_clob_output;
  APEX_JSON.open_object; -- {
  APEX_JSON.write ('client_id', client_id_l, TRUE);
  APEX_JSON.write ('client_key', client_key_l, TRUE);
  APEX_JSON.close_object; -- }
  data_l := APEX_JSON.get_clob_output;
  APEX_JSON.free_output;

  IF timeout_p IS NULL THEN
    timeout_m := pra_zmp_zaj.zmppar_vrijednost ('LOY', '1018');
  ELSE
    timeout_m := timeout_p;
  END IF;

  odgovor_m := 'false';

  UTL_HTTP.set_detailed_excp_support (enable => true);
  UTL_HTTP.set_transfer_timeout (timeout => timeout_m);

  pkaclob_data_m := CHR(10) || 'Request [' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' || CHR(10) || url_m || '/api/v1/authorize' || CHR(10);
  pkaclob_data_m := pkaclob_data_m || 'client_id ' || client_id_l || CHR(10);

  req_l := UTL_HTTP.begin_request (url => url_m || '/api/v1/authorize', method => 'POST', http_version => 'HTTP/1.1');

  UTL_HTTP.set_header (r => req_l, name => 'Content-Type', value => 'application/json; charset=utf-8');
  UTL_HTTP.set_header (req_l, 'Content-Length', pra_pka2.clob_length (data_l));
  UTL_HTTP.write_text (req_l, data_l);

  res_l := UTL_HTTP.get_response (req_l);

  -- Initialize the CLOB.
  DBMS_LOB.createtemporary (clob_l, FALSE);

  -- Copy the response into the CLOB.
  BEGIN
    LOOP
      UTL_HTTP.read_text (res_l, text_l, 32766);
      DBMS_LOB.writeappend (clob_l, LENGTH (text_l), text_l);
    END LOOP;
    UTL_HTTP.end_response (res_l);
  EXCEPTION
    WHEN UTL_HTTP.end_of_body THEN
      UTL_HTTP.end_response (res_l);
  END;

  odgovor_m := clob_l;

  /*
  {
    "access_token": "eyJ...OaY",
    "refresh_token": "jhP+lo4aIewAZrg+6RWnCs+MEFTbYSDx1QviqlbPXLA="
  }
  */

  APEX_JSON.parse (values_l, odgovor_m);
  access_token_m := APEX_JSON.get_varchar2 (p_path => 'access_token', p_values => values_l);

  pkaclob_data_m := pkaclob_data_m || 'Response [' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] Token Length ' || LENGTH (access_token_m) || CHR(10);
  pra_pka2.clob_to_table (pkaclob_data_m, log_file_name_m, NULL, 'CRM');

EXCEPTION
  WHEN OTHERS THEN
    pkaclob_data_m := pkaclob_data_m || 'Error [' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' || CHR(10) || SQLERRM || CHR(10); 
    pra_pka2.clob_to_table (pkaclob_data_m, log_file_name_m, NULL, 'CRM');
    UTL_HTTP.end_response (res_l);
    RAISE;
END;

END PRA_REC_LIS;
/
SHOW ERROR

