PROMPT Creating Package Body 'PRA_REC_IUD4'
CREATE OR REPLACE PACKAGE BODY PRA_REC_IUD4 IS

PROCEDURE IZRADI_REC_GI
 (TRO_NIZ_P IN VARCHAR2
 ,RAC_ID_P IN OUT T_RACUNI.ID%TYPE
 )
 IS
--
  rac_rec_l t_racuni%ROWTYPE;
  tro_rec_l t_troskovi%ROWTYPE;

  CURSOR vapldok_c IS
    SELECT vapldok.id, vapldok.vtec_id, vpdok.vpknj_id
      FROM s_vapldok vapldok, s_vpdokumenata vpdok
     WHERE vapldok.oznaka= 'GI'
       AND vapldok.metapl_sifra = 'REC'
       AND vpdok.id = vapldok.vpdok_id;

  vpla_id_l s_vplacanja.id%TYPE; -- IRN 3544
  br_so_l NUMBER;
  br_ms_l NUMBER;
  br_pkaadrp_l NUMBER;
  br_val_l NUMBER;
  rac_iznos_l t_racuni.iznos%TYPE;
  curs_l sys_refcursor;
BEGIN

  IF tro_niz_p IS NULL THEN
    RETURN;
  END IF;

  OPEN curs_l FOR
    'SELECT COUNT (DISTINCT so_id), COUNT (DISTINCT ms_id), COUNT (DISTINCT pkaadrp_id), COUNT (DISTINCT val_id)
       FROM t_troskovi
      WHERE id IN (' || tro_niz_p || ')';
  FETCH curs_l INTO br_so_l, br_ms_l, br_pkaadrp_l, br_val_l;
  CLOSE curs_l;

  IF br_so_l <> 1 OR br_ms_l <> 1 OR br_pkaadrp_l <> 1 OR br_val_l <> 1 THEN
    -- Odabrane usluge ne mogu biti naplaene na istom raunu.
    pra_rec_zaj.vrati_poruku(-20583);
  END IF;

  OPEN curs_l FOR
    'SELECT MIN (so_id), MIN (ms_id), MIN (pkaadrp_id), 0
       FROM t_troskovi
      WHERE id IN (' || tro_niz_p || ')';
  FETCH curs_l INTO rac_rec_l.so_id, rac_rec_l.ms_id, rac_rec_l.pkaadr_id, rac_rec_l.iznos;
  CLOSE curs_l;

  IF rac_rec_l.so_id IS NOT NULL THEN
    SELECT val.id, so.ojr_id
      INTO rac_rec_l.val_id, rac_rec_l.oj_id
      FROM s_valute val,
           m_so so
     WHERE val.sifra_3a = pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0001')
       AND so.id = rac_rec_l.so_id;
  ELSE
    RETURN;
  END IF;

  OPEN vapldok_c;
  FETCH vapldok_c INTO rac_rec_l.vapldok_id, rac_rec_l.vtec_id, rac_rec_l.vpknj_id;
  CLOSE vapldok_c;

  rac_rec_l.id := pra_zmp_zaj.sekvenca (NULL);
  rac_rec_l.izn_tecaja := 1;
  rac_rec_l.god_poslovna := pra_zmp_zaj.zmppar_vrijednost ('REC', '1003');
  rac_rec_l.ozn_valjanosti := 'V';
  rac_rec_l.oznaka := 'V';
  rac_rec_l.datum := TRUNC (SYSDATE);
  rac_rec_l.dat_nobveze := TRUNC (SYSDATE);
  rac_rec_l.izn_tecajat := 1; -- IRN 3544

  INSERT INTO t_racuni VALUES rac_rec_l;

  OPEN curs_l FOR
    'SELECT tro.id,
            usl.obr_zdana,
            usl.obr_smjesta,
            usl.obr_popusta,
            usl.obr_popusta4,
            usl.obr_popusta2,
            usl.obr_popusta3,
            usl.obr_po_danu,
            usl.obr_provizije,
            vpispp.vpispz_id,
            vpispz.stopa
       FROM t_troskovi tro,
            s_usluge usl,
            s_vpisporukap vpispp,
            s_vpisporukaz vpispz
      WHERE tro.id IN (' || tro_niz_p || ')
        AND tro.usl_id = usl.id
        AND vpispp.id = pra_szmp_usl_raz.vpispp_id (tro.usl_id) /* IRN 2613 */
        AND vpispz.id = vpispp.vpispz_id';
  FETCH curs_l INTO
    tro_rec_l.id,
    tro_rec_l.obr_zdana,
    tro_rec_l.obr_smjesta,
    tro_rec_l.obr_popusta1,
    tro_rec_l.obr_popusta4,
    tro_rec_l.obr_popusta2,
    tro_rec_l.obr_popusta3,
    tro_rec_l.obr_po_danu,
    tro_rec_l.obr_provizije,
    tro_rec_l.vpispz_id,
    tro_rec_l.stopa_pdv;

  WHILE curs_l%FOUND LOOP
    UPDATE t_troskovi
       SET vpispz_id = tro_rec_l.vpispz_id,
           rac_id = rac_rec_l.id,
           obr_zdana = tro_rec_l.obr_zdana,
           obr_smjesta = tro_rec_l.obr_smjesta,
           obr_popusta1 = tro_rec_l.obr_popusta1,
           obr_popusta4 = tro_rec_l.obr_popusta4,
           izn_tecaja = 1,
           izn_odbitka = 0,
           stopa_pdv = tro_rec_l.stopa_pdv,
           izn_pdv = (ROUND (cijena_usluge * (stopa_placanja / 100) * 1 / rac_rec_l.izn_tecaja, 2)
                      * kol_usluge
                      * DECODE (tro_rec_l.obr_po_danu, -1, (dat_zav - dat_poc - tro_rec_l.obr_zdana), 1)
                      * tro_rec_l.stopa_pdv) / (tro_rec_l.stopa_pdv + 100),
           iznos = cijena_usluge * (stopa_placanja / 100) * kol_usluge * DECODE (tro_rec_l.obr_po_danu, -1, (dat_zav - dat_poc - tro_rec_l.obr_zdana), 1),
           obr_popusta2 = tro_rec_l.obr_popusta2,
           obr_popusta3 = tro_rec_l.obr_popusta3,
           stopa_popusta1 = 0,
           stopa_popusta2 = 0,
           stopa_popusta3 = 0,
           stopa_popusta4 = 0,
           obr_po_danu = tro_rec_l.obr_po_danu,
           obr_provizije = tro_rec_l.obr_provizije
     WHERE id = tro_rec_l.id;
    FETCH curs_l INTO
      tro_rec_l.id,
      tro_rec_l.obr_zdana,
      tro_rec_l.obr_smjesta,
      tro_rec_l.obr_popusta1,
      tro_rec_l.obr_popusta4,
      tro_rec_l.obr_popusta2,
      tro_rec_l.obr_popusta3,
      tro_rec_l.obr_po_danu,
      tro_rec_l.obr_provizije,
      tro_rec_l.vpispz_id,
      tro_rec_l.stopa_pdv;
  END LOOP;
  CLOSE curs_l;

  OPEN curs_l FOR
    'SELECT SUM (ROUND (cijena_usluge * (stopa_placanja / 100) * tro.izn_tecaja / rac.izn_tecaja, 2)
                        * kol_usluge
                        * DECODE (obr_po_danu, -1, (dat_zav - dat_poc - obr_zdana), 1))
       FROM t_troskovi tro,
            t_racuni rac
      WHERE tro.id IN (' || tro_niz_p || ')
        AND tro.rac_id = rac.id';
  FETCH curs_l INTO rac_iznos_l;
  CLOSE curs_l;

  UPDATE t_racuni
     SET iznos = rac_iznos_l
   WHERE id = rac_rec_l.id;

  -- IRN 3544; REC param 1156 --> ifra vrste plaanja kojom se naplauje raun za razgovor s telefonske govornice ili nebitno.
  SELECT id INTO vpla_id_l FROM s_vplacanja WHERE sifra = pra_zmp_zaj.zmppar_vrijednost ('REC', '1156');

  INSERT INTO t_rac_nap (
    rac_id,
    izn_placanja,
    izn_tecaja,
    vpla_id,          -- IRN 3544
    val_id,           -- IRN 3544
    izn_tecajat       -- IRN 3544
    ) VALUES (
    rac_rec_l.id,
    rac_iznos_l,
    1,
    vpla_id_l,        -- IRN 3544
    rac_rec_l.val_id, -- IRN 3544
    1);               -- IRN 3544

  pra_t_racuni.puni_pdv (rac_rec_l.id);
  pra_pka_i3fiskal.i3fiskal_rec_racun (rac_rec_l.id);

  rac_id_p := rac_rec_l.id;

END;
PROCEDURE IZRADI_TCORAZ_TRO
 (TCORAZ_NIZ_P IN VARCHAR2
 ,TRO_NIZ_P IN OUT VARCHAR2
 )
 IS
--
  tcoraz_rec_l       ttco_razgovori%ROWTYPE;
  trosak_rec_l       t_troskovi%ROWTYPE;
  kol_usluge_l       t_troskovi.kol_usluge%TYPE;
  cijena_usluge_l    t_troskovi.cijena_usluge%TYPE;

  CURSOR so_c (oj_id_k IN ttco_razgovori.oj_id%TYPE) IS
    SELECT so.id, so.id
      FROM m_so so
     WHERE pra_zmp.oj_pripada_oj (so.oj_id, oj_id_k) = -1
       AND NVL (so.dat_ponisten, SYSDATE) > TRUNC (SYSDATE)
     ORDER BY so.sifra;

  curs_l sys_refcursor;
  retval_l VARCHAR2(100);
BEGIN
  OPEN curs_l FOR
    'SELECT *
       FROM ttco_razgovori
      WHERE id IN (' || tcoraz_niz_p || ')';

  FETCH curs_l INTO tcoraz_rec_l;

  WHILE curs_l%FOUND LOOP
    trosak_rec_l.id := pra_zmp_zaj.sekvenca (NULL);
    OPEN so_c (tcoraz_rec_l.oj_id);
    FETCH so_c INTO trosak_rec_l.so_id, trosak_rec_l.soc_id;
    IF so_c%NOTFOUND THEN
      CLOSE so_c;
      -- Nedostaje podatak (#0 #1).
      pra_rec_zaj.vrati_poruku (-20445, pra_zmp_zaj.poruka ('REC', 'REC_SO'), tcoraz_rec_l.oj_id);
    END IF;
    CLOSE so_c;

    BEGIN
      SELECT usl.id,
             pkaadr.id,
             val.id,
             ms.id,
             pkaadr.id
        INTO trosak_rec_l.usl_id,
             trosak_rec_l.pkaadr_id,
             trosak_rec_l.val_id,
             trosak_rec_l.ms_id,
             trosak_rec_l.pkaadrp_id
        FROM s_valute val,
             s_usluge usl,
             m_msegmenti ms,
             mpka_adrese pkaadr
       WHERE val.sifra_3a = pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0001')
         AND usl.sifra = pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0005')
         AND pkaadr.rbr = pra_zmp_zaj.zmppar_vrijednost ('REC', '1154')
         AND ms.sifra = pra_zmp_zaj.zmppar_vrijednost ('REC', '1155');
    EXCEPTION
      WHEN NO_DATA_FOUND THEN
        -- Pogrena vrijednost parametra #0.
        pra_rec_zaj.vrati_poruku (-20474, '1154 / 1155');
    END;

    trosak_rec_l.tcoraz_id := tcoraz_rec_l.id;
    trosak_rec_l.dat_poc := TRUNC (tcoraz_rec_l.sat_poc); -- IRN 2623
    trosak_rec_l.dat_zav := TRUNC (tcoraz_rec_l.sat_poc); -- IRN 2623

    IF tcoraz_rec_l.br_impulsa <> 0 AND tcoraz_rec_l.br_impulsa < 1000 THEN
      trosak_rec_l.kol_usluge := tcoraz_rec_l.br_impulsa;
      trosak_rec_l.cijena_usluge := tcoraz_rec_l.iznos / tcoraz_rec_l.br_impulsa;
      IF ROUND (trosak_rec_l.kol_usluge * trosak_rec_l.cijena_usluge, 2) <> trosak_rec_l.iznos THEN
        trosak_rec_l.kol_usluge := 1;
        trosak_rec_l.cijena_usluge := trosak_rec_l.iznos;
      END IF;
    ELSE
      trosak_rec_l.kol_usluge := 1;
      trosak_rec_l.cijena_usluge := tcoraz_rec_l.iznos;
    END IF;

    trosak_rec_l.ozn_cijene := 3;
    trosak_rec_l.stopa_placanja := 100;
    trosak_rec_l.ozn_smjesta := 0;

    INSERT INTO t_troskovi VALUES trosak_rec_l;
    retval_l := retval_l || trosak_rec_l.id  || ',';
    FETCH curs_l INTO tcoraz_rec_l;

  END LOOP;
  CLOSE curs_l;
  tro_niz_p := SUBSTR(retval_l, 1, LENGTH(retval_l) - 1);
END;
PROCEDURE PUNI_RECREZNS
 (REZ_ID_P IN T_REZERVACIJE.ID%TYPE
 ,OZN_VSTORNA_P IN T_REZERVACIJE.OZN_VSTORNA%TYPE
 )
 IS
BEGIN
  -- kreiranje trec_rez_noshow, poziva se iz bur_t_rezervacije i procedure puni_recrezns_razd
  IF ozn_vstorna_p IN ('3', '1') AND pra_rec_zaj.vrijednost_parametra (1158) = 'da' THEN
    FOR rezvsj_c IN (
      SELECT vsjc_id,
             SUM (kol_sj) kol_sj,
             SUM (br_osoba) br_osoba,
             SUM (NVL (kol_sjZ, 0)) kol_sjZ,
             SUM (NVL (br_osobaZ, 0)) br_osobaZ
        FROM t_rez_vsj rezvsj
       WHERE rezvsj.rez_id = rez_id_p
       GROUP BY vsjc_id
      )
    LOOP
      IF rezvsj_c.kol_sj - NVL (rezvsj_c.kol_sjZ,0) > 0 OR rezvsj_c.br_osoba - NVL (rezvsj_c.br_osobaZ,0) > 0 THEN
        INSERT INTO trec_rez_noshow (
            rez_id, vsjc_id, kol_sj, br_osoba, kol_sjZ, br_osobaZ)
          VALUES (
            rez_id_p, rezvsj_c.vsjc_id, rezvsj_c.kol_sj, rezvsj_c.br_osoba, rezvsj_c.kol_sjZ, rezvsj_c.br_osobaZ);
      END IF;
    END LOOP;
  END IF;
END;
PROCEDURE PUNI_RECREZNS_RAZD
 (DAT_POC_P IN t_rezervacije.dat_dolaska%TYPE
 ,DAT_ZAV_P IN t_rezervacije.dat_odlaska%type
 ,NOSHOW_P IN NUMBER
 ,OTKAZ_P IN NUMBER
 ,OBRAD_REZ_P IN OUT NUMBER
 )
 IS
--
  br_redaka_l NUMBER;
  recpotk_id_l NUMBER;
  recpotk_oznaka_l VARCHAR2(4);
BEGIN
  obrad_rez_p := 0;
  FOR rez_c IN (
    SELECT id, ozn_vstorna, ponso_id, dat_dolaska, dat_storna, datum, recpotk_oznaka
      FROM t_rezervacije
     WHERE dat_storna BETWEEN dat_poc_p AND dat_zav_p
       AND (oznaka = 'P' OR ozn_vstorna IS NOT NULL)
     )
  LOOP
    IF noshow_p = -1 AND rez_c.ozn_vstorna = '3' THEN
      SELECT COUNT (1) INTO br_redaka_l FROM trec_rez_noshow WHERE rez_id = rez_c.id;
      -- kreira retke ako ve ne postoje
      IF br_redaka_l = 0 THEN
        pra_rec_iud4.puni_recrezns (rez_c.id, rez_c.ozn_vstorna);
        obrad_rez_p := obrad_rez_p + 1;
        COMMIT;
      END IF;
    END IF;
    IF otkaz_p = -1 AND rez_c.ozn_vstorna = '1' AND rez_c.recpotk_oznaka IS NULL THEN
      IF rez_c.ponso_id IS NOT NULL THEN
        recpotk_id_l := NULL;
        recpotk_oznaka_l := NULL;
        recpotk_oznaka_l := pra_rec_iud4.ozn_pravila_otkaza (rez_c.ponso_id,rez_c.dat_dolaska, rez_c.dat_storna,rez_c.datum);
      END IF;
      IF recpotk_oznaka_l IS NOT NULL THEN
        SELECT COUNT (1) INTO br_redaka_l FROM trec_rez_noshow WHERE rez_id = rez_c.id;
        -- kreira retke ako ve ne postoje
        IF br_redaka_l = 0  THEN
          pra_rec_iud4.puni_recrezns (rez_c.id, rez_c.ozn_vstorna);
          obrad_rez_p := obrad_rez_p + 1;
          UPDATE t_rezervacije SET recpotk_oznaka = recpotk_oznaka_l WHERE id = rez_c.id;
          COMMIT;
        END IF;
      END IF;
    END IF;
  END LOOP;
END;
PROCEDURE PUNI_TRO_NOSHOW
 (RECREZNS_ID_P IN TREC_REZ_NOSHOW.ID%TYPE
 ,NOSITELJ_TRO_P IN VARCHAR2
 ,PKAADR_ID_P IN MPKA_ADRESE.ID%TYPE
 )
 IS
-- puni troak za noshow
  rec_rez_l      t_rezervacije%ROWTYPE;
  rec_recrezns_l trec_rez_noshow%ROWTYPE;
  rec_tro_l      t_troskovi%ROWTYPE;
  br_uputnice_l  VARCHAR2(100);
BEGIN

  IF recrezns_id_p IS NULL THEN
    RETURN;
  END IF;
  SELECT * INTO rec_recrezns_l FROM trec_rez_noshow WHERE id = recrezns_id_p;
  SELECT * INTO rec_rez_l FROM t_rezervacije WHERE id = rec_recrezns_l.rez_id;

  rec_tro_l.id := pra_zmp_zaj.sekvenca (NULL);
  rec_tro_l.so_id := rec_rez_l.so_id;
  rec_tro_l.soc_id := rec_rez_l.so_id;
  rec_tro_l.usl_id := rec_recrezns_l.usl_id;

  IF nositelj_tro_p = 'AD' THEN
    rec_tro_l.pkaadr_id := NVL (rec_rez_l.pkaadr_id, pkaadr_id_p);
    rec_tro_l.pkaadrp_id := rec_tro_l.pkaadr_id;
  ELSE
    rec_tro_l.age_id := rec_rez_l.age_id;
    rec_tro_l.agep_id := rec_tro_l.age_id;
  END IF;

  SELECT cje.val_id INTO rec_tro_l.val_id
    FROM t_rezervacije rez, t_ponude pon, t_pon_ojr ponojr, t_pon_so ponso, t_cjenici cje
   WHERE rez.id = rec_rez_l.id
     AND rez.ponso_id = ponso.id (+)
     AND ponso.ponojr_id = ponojr.id (+)
     AND ponojr.pon_id = pon.id (+)
     AND NVL (pon.cje_id, rez.cje_id) = cje.id;

  IF rec_rez_l.br_uputnice IS NOT NULL THEN
    br_uputnice_l := rec_rez_l.br_uputnice || ', ';
  END IF;
  br_uputnice_l := br_uputnice_l || rec_rez_l.prezime;
  IF rec_rez_l.ime IS NOT NULL THEN
    br_uputnice_l := br_uputnice_l || ', ' || rec_rez_l.ime;
  END IF;
  rec_tro_l.br_uputnice := SUBSTR (br_uputnice_l, 1, 30);

  rec_tro_l.ms_id := rec_rez_l.ms_id;
  rec_tro_l.vsj_id := rec_recrezns_l.vsjc_id;
  rec_tro_l.dat_poc := rec_recrezns_l.dat_poc;
  rec_tro_l.dat_zav := rec_recrezns_l.dat_zav;

  IF rec_recrezns_l.ozn_cijenasj = -1 THEN rec_tro_l.kol_usluge := rec_recrezns_l.kol_sjp;
  ELSE rec_tro_l.kol_usluge := rec_recrezns_l.br_osobap;
  END IF;

  rec_tro_l.cijena_usluge := rec_recrezns_l.cijena_usluge;
  rec_tro_l.ozn_cijene := 4;
  rec_tro_l.stopa_placanja := rec_recrezns_l.stopa_placanja;
  rec_tro_l.ozn_smjesta := 0;
  rec_tro_l.ponso_id := rec_rez_l.ponso_id;

  INSERT INTO t_troskovi VALUES rec_tro_l;
  UPDATE trec_rez_noshow SET id1_ltro = rec_tro_l.id, dat_tro = SYSDATE WHERE id = recrezns_id_p;

  COMMIT;

END;
PROCEDURE PROMIJENI_POP_RAZD
 (ZMPPOP_ID_P IN TREC_POP_RAZD.ZMPPOP_ID%TYPE
 ,SO_ID_P IN TREC_POP_RAZD.SO_ID%TYPE
 ,USL_ID_P IN TREC_POP_RAZD.USL_ID%TYPE
 ,VSJ_ID_P IN TREC_POP_RAZD.VSJ_ID%TYPE
 ,DAT_POC_P IN TREC_POP_RAZD.DAT_POC%TYPE
 ,DAT_ZAV_P IN TREC_POP_RAZD.DAT_ZAV%TYPE
 ,STOPA_P IN TREC_POP_RAZD.STOPA%TYPE
 )
 IS
--
  CURSOR razd_dat (datum_k IN trec_pop_razd.dat_poc%TYPE) IS
    -- postoji jedno ili nijedno razdoblje
    -- u koje upada poslani datum (zabrana preklapanja);
    SELECT id, stopa, dat_poc, dat_zav
      FROM trec_pop_razd
     WHERE zmppop_id = zmppop_id_p
       AND so_id = so_id_p
       AND usl_id = usl_id_p
       AND NVL(vsj_id, 0) = NVL(vsj_id_p, 0)
       AND dat_poc <= datum_k
       AND datum_k <= dat_zav;

  razd_poc_stopa_l   trec_pop_razd.stopa%TYPE;
  razd_poc_id_l      trec_pop_razd.id%TYPE;
  razd_poc_dat_poc_l trec_pop_razd.dat_poc%TYPE;
  razd_poc_dat_zav_l trec_pop_razd.dat_zav%TYPE;

  razd_zav_stopa_l   trec_pop_razd.stopa%TYPE;
  razd_zav_id_l      trec_pop_razd.id%TYPE;
  razd_zav_dat_poc_l trec_pop_razd.dat_poc%TYPE;
  razd_zav_dat_zav_l trec_pop_razd.dat_zav%TYPE;

  postojeca_stopa_l  trec_pop_razd.stopa%TYPE;
  razd_poc_zavrsni_l trec_pop_razd.dat_zav%TYPE;
  insertiraj_novo_l  BOOLEAN := FALSE;
  insertiraj_zav_l   BOOLEAN := TRUE;
BEGIN

  -- samo vor-centar moe aurirati razdoblje popusta
  IF pra_zmp_zaj.centar = 0 THEN
    pra_rec_zaj.vrati_poruku (-20587);
  END IF;

  IF zmppop_id_p IS NULL OR so_id_p IS NULL THEN
    RETURN;
  END IF;

  IF dat_poc_p > dat_zav_p THEN
    RETURN;
  END IF;

  -- provjeri postoji li ve identino razdoblje kakvo se eli unijeti
  -- bez obzira na stopu
  BEGIN
    SELECT stopa
      INTO postojeca_stopa_l
      FROM trec_pop_razd
     WHERE zmppop_id = zmppop_id_p
       AND so_id = so_id_p
       AND usl_id = usl_id_p
       AND NVL(vsj_id, 0) = NVL(vsj_id_p, 0)
       AND dat_poc = dat_poc_p
       AND dat_zav = dat_zav_p;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      NULL;
  END;

  IF postojeca_stopa_l IS NOT NULL THEN
  -- postoji identino razdoblje, treba ga obrisati ili mu promijeniti stopu

    IF stopa_p IS NULL THEN
      DELETE FROM trec_pop_razd
       WHERE zmppop_id = zmppop_id_p
         AND so_id = so_id_p
         AND usl_id = usl_id_p
         AND NVL(vsj_id, 0) = NVL(vsj_id_p, 0)
         AND dat_poc = dat_poc_p
         AND dat_zav = dat_zav_p;

    ELSE
      UPDATE trec_pop_razd
         SET stopa = stopa_p
       WHERE zmppop_id = zmppop_id_p
         AND so_id = so_id_p
         AND usl_id = usl_id_p
         AND NVL(vsj_id, 0) = NVL(vsj_id_p, 0)
         AND dat_poc = dat_poc_p
         AND dat_zav = dat_zav_p;
    END IF;

    -- zadatak je obavljen
    COMMIT;
    RETURN;
  END IF;

  -- obrii eventualna razdoblja
  -- koja potpuno ulaze u razdoblje dat_poc_p - dat_zav_p
  -- bez obzira na stopu
  DELETE FROM trec_pop_razd
   WHERE zmppop_id = zmppop_id_p
     AND so_id = so_id_p
     AND usl_id = usl_id_p
     AND NVL(vsj_id, 0) = NVL(vsj_id_p, 0)
     AND dat_poc_p <= dat_poc
     AND dat_zav <= dat_zav_p;

  -- pronai razdoblje u koje upada dat_poc_p, ako postoji (zovimo ga poetno razdoblje)
  OPEN razd_dat (dat_poc_p);
  FETCH razd_dat INTO razd_poc_id_l, razd_poc_stopa_l, razd_poc_dat_poc_l, razd_poc_dat_zav_l;
  CLOSE razd_dat;

  -- pronai razdoblje u koje upada dat_zav_p, ako postoji (zovimo ga zavrno razdoblje)
  OPEN razd_dat (dat_zav_p);
  FETCH razd_dat INTO razd_zav_id_l, razd_zav_stopa_l, razd_zav_dat_poc_l, razd_zav_dat_zav_l;
  CLOSE razd_dat;

  IF razd_poc_id_l IS NULL AND razd_zav_id_l IS NULL AND stopa_p IS NOT NULL THEN
  -- ne postoji ni poetno ni zavrno razdoblje
    -- umetni novo razdoblje za novu stopu
    INSERT INTO trec_pop_razd
      (zmppop_id, so_id, vsj_id, usl_id, dat_poc, dat_zav, stopa)
    VALUES
      (zmppop_id_p, so_id_p, vsj_id_p, usl_id_p, dat_poc_p, dat_zav_p, stopa_p);

  ELSIF razd_poc_id_l IS NOT NULL AND razd_zav_id_l IS NULL THEN
  -- postoji poetno razdoblje, ali ne postoji zavrno razdoblje;

    -- provjeri stopu poetnog razdoblja
    IF stopa_p IS NOT NULL AND razd_poc_stopa_l = stopa_p THEN
    -- produi poetno razdoblje do dat_zav_p;
    -- preklapanja nee biti
    -- jer je period dat_poc_p - dat_zav_p "oien"
      UPDATE trec_pop_razd
         SET dat_zav = dat_zav_p
       WHERE id = razd_poc_id_l;

    ELSE
    -- poetno razdoblje ima drukiju stopu;
      -- skrati poetno razdoblje
      UPDATE trec_pop_razd
         SET dat_zav = dat_poc_p - 1
       WHERE id = razd_poc_id_l;

      IF stopa_p IS NOT NULL THEN
        -- umetni novo razdoblje za novu stopu
        INSERT INTO trec_pop_razd
          (zmppop_id, so_id, vsj_id, usl_id, dat_poc, dat_zav, stopa)
        VALUES
          (zmppop_id_p, so_id_p, vsj_id_p, usl_id_p, dat_poc_p, dat_zav_p, stopa_p);
      END IF;
    END IF;

  ELSIF razd_poc_id_l IS NULL AND razd_zav_id_l IS NOT NULL THEN
  -- ne postoji poetno razdoblje, ali postoji zavrno razdoblje;

    -- provjeri stopu zavrnog razdoblja
    IF stopa_p IS NOT NULL AND razd_zav_stopa_l = stopa_p THEN
    -- produi zavrno razdoblje do dat_poc_p
    -- preklapanja nee biti
    -- jer je period dat_poc_p - dat_zav_p "oien"
      UPDATE trec_pop_razd
         SET dat_poc = dat_poc_p
       WHERE id = razd_poc_id_l;

    ELSE
    -- zavrno razdoblje ima drukiju stopu;
      -- skrati zavrno razdoblje
      UPDATE trec_pop_razd
         SET dat_poc = dat_zav_p + 1
       WHERE id = razd_zav_id_l;

      IF stopa_p IS NOT NULL THEN
        -- umetni novo razdoblje za novu stopu
        INSERT INTO trec_pop_razd
          (zmppop_id, so_id, vsj_id, usl_id, dat_poc, dat_zav, stopa)
        VALUES
          (zmppop_id_p, so_id_p, vsj_id_p, usl_id_p, dat_poc_p, dat_zav_p, stopa_p);
      END IF;
    END IF;

  ELSIF razd_poc_id_l IS NOT NULL AND razd_zav_id_l IS NOT NULL AND razd_poc_id_l <> razd_zav_id_l THEN
  -- postoje oba razdoblja i razliita su;
  -- treba ih obraditi odvojeno

    -- poetno razdoblje
    IF stopa_p IS NOT NULL AND razd_poc_stopa_l = stopa_p THEN
    -- ako poetno razdoblje ima istu stopu
      -- pripremi varijablu za update poetnog razdoblja
      razd_poc_zavrsni_l := dat_zav_p;

    ELSE
    -- poetno razdoblje ima razliitu stopu:
      -- skrati poetno razdoblje
      UPDATE trec_pop_razd
         SET dat_zav = dat_poc_p - 1
       WHERE id = razd_poc_id_l;

      -- predvidi unos novog razdoblja
      insertiraj_novo_l := TRUE;
    END IF;

    -- zavrno razdoblje
    IF stopa_p IS NOT NULL AND razd_zav_stopa_l = stopa_p THEN
    -- ako zavrno razdoblje ima istu stopu

      IF razd_poc_zavrsni_l = dat_zav_p THEN
      -- ako je poetno razdoblje imalo istu stopu,
      -- tj. ve smo pripremili varijablu za novi zavrni datum poetnog razdoblja

        -- 1) zapamti zavretak zavrnog razdoblja kao novi zavretak poetnog razdoblja
        razd_poc_zavrsni_l := razd_zav_dat_zav_l;

        -- 2) obrii zavrno razdoblje
        DELETE FROM trec_pop_razd
         WHERE id = razd_zav_id_l;

        -- 3) produi poetno razdoblje do zapamenog zavretka
        UPDATE trec_pop_razd
           SET dat_zav = razd_poc_zavrsni_l
         WHERE id = razd_poc_id_l;

        razd_poc_zavrsni_l := NULL;

      ELSE
      -- ako je poetno razdoblje imalo razliitu stopu
      -- produi zavrno da obuhvati novo razdoblje
        UPDATE trec_pop_razd
           SET dat_poc = dat_poc_p
         WHERE id = razd_zav_id_l;
      END IF;

      -- ako zavrno razdoblje ima istu stopu,
      -- novo razdoblje dosad je ve rijeeno
      insertiraj_novo_l := FALSE;

    ELSE
    -- ako zavrno razdoblje ima razliitu stopu

      -- skrati zavrno razdoblje
      UPDATE trec_pop_razd
         SET dat_poc = dat_zav_p + 1
       WHERE id = razd_zav_id_l;

    END IF;

    -- ako treba produiti poetno razdoblje, produi
    IF razd_poc_zavrsni_l IS NOT NULL THEN
      UPDATE trec_pop_razd
         SET dat_zav = razd_poc_zavrsni_l
       WHERE id = razd_poc_id_l;
    END IF;

    -- ako treba umetnuti novo razdoblje, umetni
    IF stopa_p IS NOT NULL AND insertiraj_novo_l THEN
      IF stopa_p IS NOT NULL THEN
        INSERT INTO trec_pop_razd
          (zmppop_id, so_id, vsj_id, usl_id, dat_poc, dat_zav, stopa)
        VALUES
          (zmppop_id_p, so_id_p, vsj_id_p, usl_id_p, dat_poc_p, dat_zav_p, stopa_p);
      END IF;
    END IF;

  ELSIF razd_poc_id_l IS NOT NULL AND razd_zav_id_l IS NOT NULL AND razd_poc_id_l = razd_zav_id_l THEN
  -- ako oba razdoblja postoje i radi se o istom razdoblju

    -- provjeri mu stopu
    IF stopa_p IS NOT NULL AND razd_poc_stopa_l = stopa_p THEN
      -- razdoblje stope koje se eli unijeti
      -- ve je pokriveno postojeim razdobljem iste stope

      RETURN;
      -- COMMIT nije potreban jer, zbog preklapanja,
      -- "ienje" na poetku nije nita odradilo

    ELSE
      -- postojee razdoblje ima drukiju stopu;
      -- treba ga podijeliti u dva dijela i izmeu umetnuti novo razdoblje:

      IF razd_poc_dat_poc_l < dat_poc_p THEN
      -- ako razdoblje ne poinje ba na dat_poc_p,
      -- skrati prvi dio do dat_poc_p - 1

        UPDATE trec_pop_razd
           SET dat_zav = dat_poc_p - 1
         WHERE id = razd_poc_id_l;

        insertiraj_novo_l := TRUE;

      ELSIF razd_poc_dat_poc_l = dat_poc_p THEN
      -- ako poinje ba na dat_poc_p,
      -- provjeri treba li ga aurirati ili skratiti (brisati)

        IF stopa_p IS NOT NULL THEN
        -- skrati razdoblje do (novog) poetka zavrnog razdoblja - 1
        -- i usput mu auriraj stopu;
          UPDATE trec_pop_razd
             SET dat_zav = dat_zav_p,
                 stopa = stopa_p
           WHERE id = razd_poc_id_l;

        -- insertiraj_novo_l inicijalno je FALSE,
        -- insertiraj_zav_l inicijalno je TRUE

        ELSE
        -- stopu treba brisati (ne treba je unijeti);
          -- skrati zavrno razdoblje
          UPDATE trec_pop_razd
             SET dat_poc = dat_zav_p + 1
           WHERE id = razd_zav_id_l;

          insertiraj_zav_l := FALSE;
          -- insertiraj_novo_l inicijalno FALSE

        END IF;
      END IF;

      -- ako razdoblje ne zavrava ba na dat_zav_p
      -- unesi novi redak za zavrni komad postojeeg razdoblja
      -- (radi se o istom retku pa je razd_poc_dat_zav_l = razd_zav_dat_zav_l)
      IF dat_zav_p < razd_zav_dat_zav_l AND insertiraj_zav_l THEN
        INSERT INTO trec_pop_razd
          (zmppop_id, so_id, vsj_id, usl_id, dat_poc, dat_zav, stopa)
        VALUES
          (zmppop_id_p, so_id_p, vsj_id_p, usl_id_p, dat_zav_p + 1, razd_zav_dat_zav_l, razd_zav_stopa_l);
      END IF;

      IF stopa_p IS NOT NULL AND insertiraj_novo_l THEN
        -- umetni novo razdoblje za novu stopu
        INSERT INTO trec_pop_razd
          (zmppop_id, so_id, vsj_id, usl_id, dat_poc, dat_zav, stopa)
        VALUES
          (zmppop_id_p, so_id_p, vsj_id_p, usl_id_p, dat_poc_p, dat_zav_p, stopa_p);
      END IF;
    END IF;

  END IF;

  COMMIT;

END;
PROCEDURE PROMIJENI_RECAGOSTBO
 (RECAGOST_ID_P IN irec_agost_boravci.recagost_id%TYPE
 ,GOST_ID_P IN irec_agost_boravci.gost_id%TYPE
 ,SO_SIFRA_P IN irec_agost_boravci.sifra_so%TYPE
 ,RECAGOST_OLD_ID_P IN irec_agost_boravci.recagost_id%TYPE
 )
 IS
-- koristi se u modulu REC2380 Naknadni izraun redovnih bodova

  metcvor_sifra_podcentar_l smet_cvorovi.sifra%TYPE;
  metcvor_sifra_x_l VARCHAR2(41);
  br_redaka_l NUMBER;
BEGIN
  IF recagost_id_p IS NULL
    OR gost_id_p IS NULL
    OR so_sifra_p IS NULL
  THEN
    RETURN;
  END IF;

  metcvor_sifra_podcentar_l := pra_zmp_zaj.vrijednost_parametra ('0018');
  metcvor_sifra_x_l := pra_trec_agostiju.metcvor_sifra_x ('irec_agost_boravci');

  EXECUTE IMMEDIATE
    REPLACE (
      'SELECT COUNT(1)
         FROM irec_agost_boravci<Centar>
        WHERE recagost_id = :recagost_id_p
          AND gost_id = :gost_id_p
          AND metcvor_sifra = :metcvor_sifra_podcentar_l
          AND sifra_so = :so_sifra_p',
      '<Centar>',
      metcvor_sifra_x_l)
    INTO br_redaka_l USING recagost_id_p, gost_id_p, metcvor_sifra_podcentar_l, so_sifra_p;

  IF br_redaka_l = 0 THEN
    EXECUTE IMMEDIATE
      REPLACE (
        'UPDATE irec_agost_boravci<Centar>
            SET recagost_id = :recagost_id_p
          WHERE gost_id = :gost_id_p
            AND metcvor_sifra = :metcvor_sifra_podcentar_l
            AND sifra_so = :so_sifra_p',
        '<Centar>',
        metcvor_sifra_x_l)
      USING recagost_id_p, gost_id_p, metcvor_sifra_podcentar_l, so_sifra_p;
  ELSE
    pra_rec_iud4.brisi_recagostbo (gost_id_p, so_sifra_p, recagost_old_id_p);
  END IF;
END;
FUNCTION OZN_PRAVILA_OTKAZA
 (PONSO_ID_P IN NUMBER
 ,DAT_DOLASKA_P IN DATE
 ,DAT_STORNA_P IN DATE
 ,DAT_REZ_P IN DATE
 )
 RETURN VARCHAR2
 IS
--
  recpotk_id_l     t_ponude.recpotk_id%TYPE;
  recpotk_oznaka_l trec_potk_razdoblja.oznaka%TYPE;
BEGIN
  SELECT pon.recpotk_id INTO recpotk_id_l
    FROM t_pon_so ponso, t_pon_ojr ponojr, t_ponude pon
   WHERE ponso.id = ponso_id_p
     AND ponso.ponojr_id = ponojr.id
     AND ponojr.pon_id = pon.id;
  IF recpotk_id_l IS NOT NULL THEN
    FOR stavke_c IN (
      SELECT *
        FROM trec_potk_razdoblja
       WHERE recpotk_id = recpotk_id_l
         AND dat_dolaska_p BETWEEN dat_poc AND dat_zav
         AND dat_dolaska_p - dat_storna_p BETWEEN br_dana_poc AND br_dana_zav)
    LOOP
      recpotk_oznaka_l := stavke_c.oznaka;
      IF stavke_c.br_dana_bez IS NOT NULL THEN
        IF dat_storna_p - dat_rez_p <= stavke_c.br_dana_bez THEN
          recpotk_oznaka_l := NULL;
        END IF;
      END IF;
    END LOOP;
  END IF;
  RETURN (recpotk_oznaka_l);
END;
PROCEDURE PUNI_TROSKOVE
 (GOSTK_ID_P IN T_TROSKOVI.GOST_ID%TYPE
 ,AGEK_ID_P IN T_TROSKOVI.AGE_ID%TYPE
 ,PKAADRK_ID_P IN T_TROSKOVI.PKAADR_ID%TYPE
 ,GOSTP_ID_P IN T_TROSKOVI.GOSTP_ID%TYPE
 ,AGEP_ID_P IN T_TROSKOVI.AGEP_ID%TYPE
 ,PKAADRP_ID_P IN T_TROSKOVI.PKAADRP_ID%TYPE
 ,SO_ID_P IN T_TROSKOVI.SO_ID%TYPE
 ,CJE_ID_P IN T_TROSKOVI.CJE_ID%TYPE
 ,MS_ID_P IN T_TROSKOVI.MS_ID%TYPE
 ,AGE_ID_P IN T_TROSKOVI.AGE_ID%TYPE
 ,USL_ID_P IN T_TROSKOVI.USL_ID%TYPE
 ,SAS_ID_P IN T_TROSKOVI.SAS_ID%TYPE
 ,KOL_USLUGE_P IN T_TROSKOVI.KOL_USLUGE%TYPE
 ,VSJ_ID_P IN T_TROSKOVI.VSJ_ID%TYPE
 ,DAT_POC_P IN T_TROSKOVI.DAT_POC%TYPE
 ,DAT_ZAV_P IN T_TROSKOVI.DAT_ZAV%TYPE
 ,BR_UPUTNICE_P IN T_TROSKOVI.BR_UPUTNICE%TYPE
 ,STOPA_PLACANJA_P IN T_TROSKOVI.STOPA_PLACANJA%TYPE
 ,OZN_GRATIS_P IN T_GOSTI.OZN_GRATIS%TYPE
 ,OZN_PLATITELJ_P IN T_GOSTI.OZN_PLATITELJ%TYPE
 ,CIJENA_USLUGE_P IN T_TROSKOVI.CIJENA_USLUGE%TYPE
 ,VAL_ID_P IN T_TROSKOVI.VAL_ID%TYPE
 ,RECARA_ID_P IN T_TROSKOVI.RECARA_ID%TYPE
 ,PONSO_ID_P IN T_TROSKOVI.PONSO_ID%TYPE
 ,RECVPRO_ID_P IN mrec_vprograma.id%TYPE
 ,USL_ID1_P IN T_TROSKOVI.USL_ID1%TYPE
 ,RECREZ2PROS_ID_P IN T_TROSKOVI.recrez2pros_id%TYPE
 ,RECREZ2OPR_ID_P IN T_TROSKOVI.recrez2opr_id%TYPE
 ,OZN_POSTOJI_CIJENA_P IN OUT NUMBER
 )
 IS
--
  ponso_id_za_cje_l t_pon_so.id%TYPE;
  rez_id_za_cje_l t_rezervacije.id%TYPE;
  obr_smjesta_l s_usluge.obr_smjesta%TYPE;
  ozn_cijenaSJ_l s_usluge.ozn_cijenaSJ%TYPE;
  rec_trosak_l t_troskovi%ROWTYPE;
BEGIN
  IF usl_id_p IS NULL OR so_id_p IS NULL
    OR dat_poc_p IS NULL OR dat_zav_p IS NULL
    OR kol_usluge_p IS NULL OR ms_id_p IS NULL
    OR stopa_placanja_p IS NULL OR ozn_gratis_p IS NULL
  THEN
    -- Podatak je obvezan.
    pra_rec_zaj.vrati_poruku (-20333);
  END IF;
  IF NOT ((gostk_id_p IS NOT NULL AND agek_id_p IS NULL AND pkaadrk_id_p IS NULL)
    OR (gostk_id_p IS NULL AND agek_id_p IS NOT NULL AND pkaadrk_id_p IS NULL)
    OR (gostk_id_p IS NULL AND agek_id_p IS NULL AND pkaadrk_id_p IS NOT NULL))
  THEN
    -- Korisnik troka mora biti gost ili agencija ili adresa.
    pra_rec_zaj.vrati_poruku (-20645); -- IRN 2986
  END IF;
  IF NOT ((gostp_id_p IS NOT NULL AND agep_id_p IS NULL AND pkaadrp_id_p IS NULL)
    OR (gostp_id_p IS NULL AND agep_id_p IS NOT NULL AND pkaadrp_id_p IS NULL)
    OR (gostp_id_p IS NULL AND agep_id_p IS NULL AND pkaadrp_id_p IS NOT NULL))
  THEN
    -- Platitelj troka mora biti gost ili agencija ili adresa.
    pra_rec_zaj.vrati_poruku (-20646); -- IRN 2986
  END IF;
  -- Postavi zajednike vrijednosti troka
  rec_trosak_l.id := NULL;
  rec_trosak_l.so_id := so_id_p;
  rec_trosak_l.usl_id := usl_id_p;
  rec_trosak_l.sas_id := sas_id_p;
  -- arc je provjeren na ulaznim argumentima
  rec_trosak_l.gost_id := gostk_id_p;
  rec_trosak_l.age_id := agek_id_p;
  rec_trosak_l.pkaadr_id := pkaadrk_id_p;
  -- arc je provjeren na ulaznim argumentima
  rec_trosak_l.gostp_id := gostp_id_p;
  rec_trosak_l.agep_id := agep_id_p;
  rec_trosak_l.pkaadrp_id := pkaadrp_id_p;

  rec_trosak_l.ponso_id := ponso_id_p;

  /*
  recvpro moe utjecati na kreiranje trokova zbog popusta
  pa se aurira u svim trokovima gostiju neovisno o ponso
  */
  -- rijeeno samo za goste korisnike
  IF gostk_id_p IS NOT NULL
  THEN
    rec_trosak_l.recvpro_id := recvpro_id_p;
  END iF;

  /*
  napune se podaci cje_id i soc_id i pripreme podaci za punjenje prec_cje_usl
  */
  pra_rec_iud.vrati_podatke_za_cje (
    ponso_id_p,
    gostk_id_p,
    usl_id_p,
    cje_id_p,
    so_id_p,
    ponso_id_za_cje_l,
    rez_id_za_cje_l,
    rec_trosak_l.cje_id,
    rec_trosak_l.soc_id,
    recvpro_id_p);

  rec_trosak_l.vsj_id := vsj_id_p;
  rec_trosak_l.ms_id := ms_id_p;
  rec_trosak_l.id1 := NULL;
  rec_trosak_l.ltro_id1 := NULL;
  rec_trosak_l.id1_prvi := NULL;

  rec_trosak_l.dat_poc := dat_poc_p;
  rec_trosak_l.dat_zav := dat_zav_p;

  rec_trosak_l.vpispz_id := NULL;
  rec_trosak_l.vpispz_id1 := NULL;
  rec_trosak_l.rac_id := NULL;
  rec_trosak_l.kol_usluge := kol_usluge_p;
  rec_trosak_l.stopa_placanja := stopa_placanja_p;
  rec_trosak_l.br_uputnice := br_uputnice_p;
  rec_trosak_l.izn_tecaja := NULL;
  rec_trosak_l.izn_odbitka := NULL;
  rec_trosak_l.stopa_pdv := NULL;
  rec_trosak_l.izn_pdv := NULL;
  rec_trosak_l.iznos := NULL;
  rec_trosak_l.recara_id := recara_id_p;
  rec_trosak_l.usl_id1 := usl_id1_p;
  rec_trosak_l.recrez2pros_id := recrez2pros_id_p;
  rec_trosak_l.recrez2opr_id := recrez2opr_id_p;

  -- potrebne oznake iz s_usluge
  SELECT obr_smjesta, ozn_cijenaSJ INTO obr_smjesta_l, ozn_cijenaSJ_l
    FROM s_usluge
   WHERE id = usl_id_p;

  rec_trosak_l.ozn_smjesta := ozn_gratis_p;
  -- ispravi uslugu koja nema SM
  IF ozn_gratis_p = -1 THEN
    rec_trosak_l.ozn_smjesta := obr_smjesta_l;
  END IF;

  /*
  stupce
    dat_upisa, vpispp_id, stopa_pdv_poc, obr_zdana_poc,
    izn_prihoda, izn_pdv_poc, izn_prihoda_prvidan, izn_pdv_prvidan,
    obr_po_danu_poc, vpispp_id1, stopa_pdv_poc1, izn_pdv_poc1, izn_pdv_prvidan1
  puni triger
  */

  IF cijena_usluge_p IS NOT NULL OR rec_trosak_l.cje_id IS NULL THEN
    /*
    Poslana cijena znai posebnu cijenu (ozn_cijene = 4). Ako cjenik nije naveden
    (to se ne bi trebalo dogoditi) takoer znai posebnu cijenu.
    */
    rec_trosak_l.ozn_cijene := 4;
    rec_trosak_l.cijena_usluge := NVL (cijena_usluge_p, 0);
    IF val_id_p IS NOT NULL THEN
      rec_trosak_l.val_id := val_id_p;
    ELSE
      SELECT id INTO rec_trosak_l.val_id
        FROM s_valute
       WHERE sifra_3a = pra_rec_zaj.vrijednost_parametra ('0001');
    END IF;
    pra_rec_iud.insert_tro (rec_trosak_l);
    ozn_postoji_cijena_p := -1;
  ELSE
    /*
    Usluga za koju je definirana cijena na SJ se gostima koji nisu platitelji
    otvara sa stopom plaanja 0 ali brigu o tome mora voditi CI
    */
    -- nai valutu preko cjenika
    SELECT val_id INTO rec_trosak_l.val_id
      FROM t_cjenici
     WHERE id = rec_trosak_l.cje_id;

    pra_rec_iud.puni_prec_cje_usl (
      ponso_id_p => ponso_id_za_cje_l,
      rez_id_p => rez_id_za_cje_l,
      usl_id_p => rec_trosak_l.usl_id,
      cje_id_p => rec_trosak_l.cje_id,
      so_id_p => rec_trosak_l.soc_id,
      dat_poc_p => rec_trosak_l.dat_poc,
      dat_zav_p => rec_trosak_l.dat_zav,
      recvpro_id_p => rec_trosak_l.recvpro_id,
      recara_id_p => rec_trosak_l.recara_id);

    pra_rec_iud2.promijeni_zajtro (
      dat_poc_p => rec_trosak_l.dat_poc,
      dat_zav_p => rec_trosak_l.dat_zav,
      cje_id_p => rec_trosak_l.cje_id,
      so_id_p => rec_trosak_l.soc_id,
      vsj_id_p => rec_trosak_l.vsj_id,
      vtec_id_p => NULL,
      ban_id_p => NULL,
      ozn_postoji_cijena_p => ozn_postoji_cijena_p,
      ozn_tab_p => 'TRO',
      rec_tro_p => rec_trosak_l,
      rec_recpon2usl_p => NULL,
      rec_rectro_p => NULL);

  END IF;

END;
PROCEDURE AZURIRAJ_GOST_OZN_DPRIVOLE
 (METCVOR_SIFRA_P IN smet_cvorovi.sifra%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE
 ,OZN_DPRIVOLE_P IN t_gosti.ozn_dprivole%TYPE
 )
 IS
-- IRN 2970
  naredba_l VARCHAR2(1000);
  cvor_l VARCHAR2(41);
BEGIN
  IF metcvor_sifra_p IS NULL
    OR gost_id_p IS NULL
    OR ozn_dprivole_p IS NULL
  THEN
    RETURN;
  END IF;

  naredba_l := 'UPDATE t_gosti<CVOR> SET ozn_dprivole = :ozn_dprivole_p WHERE id = :gost_id_p'; -- IRN 3275
  IF metcvor_sifra_p = pra_zmp_zaj.tekuci_cvor THEN
    cvor_l := NULL;
  ELSE
    cvor_l := '@' || metcvor_sifra_p;
  END IF;
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_l) USING ozn_dprivole_p, gost_id_p;
END;
PROCEDURE BRISI_RECAGOSTBO
 (GOST_ID_P IN irec_agost_boravci.gost_id%TYPE
 ,SO_SIFRA_P IN irec_agost_boravci.sifra_so%TYPE
 ,RECAGOST_ID_P IN irec_agost_boravci.recagost_id%TYPE := NULL
 )
 IS
-- koristi se u modulu REC2380 Naknadni izraun redovnih bodova

  metcvor_sifra_podcentar_l smet_cvorovi.sifra%TYPE;
  metcvor_sifra_x_l VARCHAR2(41);
BEGIN
  IF gost_id_p IS NULL
    OR so_sifra_p IS NULL
  THEN
    RETURN;
  END IF;

  metcvor_sifra_podcentar_l := pra_zmp_zaj.vrijednost_parametra ('0018');
  metcvor_sifra_x_l := pra_trec_agostiju.metcvor_sifra_x ('irec_agost_boravci');

  /*
  brisanje retka tablice irec_agost_boravci je doputeno ako je gost_id = -2
  zato se prvo postavlja gost_id na -2, a nakon toga se brie
  */
  EXECUTE IMMEDIATE
    REPLACE (
      'BEGIN
         FOR c IN (
           SELECT id
             FROM irec_agost_boravci<Centar>
            WHERE gost_id = :gost_id_p
              AND metcvor_sifra = :metcvor_sifra_podcentar_l
              AND sifra_so = :so_sifra_p
              AND recagost_id = NVL (:recagost_id_p, recagost_id)
           )
         LOOP
           UPDATE irec_agost_boravci<Centar> SET gost_id = -2 WHERE id = c.id;
           DELETE FROM irec_agost_boravci<Centar> WHERE id = c.id;
         END LOOP;
       END;',
      '<Centar>',
      metcvor_sifra_x_l)
    USING gost_id_p, metcvor_sifra_podcentar_l, so_sifra_p, recagost_id_p;
END;
PROCEDURE CANCEL_TENTATIVE_RESERVATIONS
 (VLASNIKPODATKA_P IN NUMBER := NULL
 ,BR_MINUTA_P IN NUMBER
 )
 IS
-- IRN 3611
  unos_dat_l      DATE;
  recnrez_id_l    mrec_nrezerviranja.id%TYPE;
  naredba_l       VARCHAR2(2000);
  br_ponistenih_l NUMBER := 0;
BEGIN

  pra_zmp_context.set_vlasnikpodatka (vlasnikpodatka_p);

  IF pra_zmp_zaj.centar = 0
    OR br_minuta_p IS NULL
  THEN
    RETURN;
  END IF;

  unos_dat_l := SYSDATE - br_minuta_p / 24 / 60;

  -- MISHAPI param 1008; Posting Tentative Reservation to PMS; ifra naina rezerviranja ili nebitno.
  SELECT MIN (id) INTO recnrez_id_l FROM mrec_nrezerviranja WHERE sifra = pra_zmp_zaj.zmppar_vrijednost ('MISHAPI', '1008');
  IF recnrez_id_l IS NULL THEN
    -- Provjerite vrijednost #0 parametra #1!
    pra_zmp_zaj.vrati_poruku (-20100, 'MISHAPI', '1008');
  END IF;

  -- IRN 3838; u WHERE naredbe UPDATE dodano ponavljanje uvjeta iz FOR petlje
  -- IRN 3991; u WHERE dodano AND br_uputnice IS NULL
  naredba_l :=
  'BEGIN
    FOR rez_c IN (
      SELECT id
        FROM t_rezervacije<CVOR>
       WHERE oznaka = ''V''
         AND ozn_vstorna IS NULL
         AND br_uputnice IS NULL
         AND recnrez_id = :recnrez_id_l
         AND ozn_b = -1
         AND ozn_f = 0
         AND unos_dat < :unos_dat_l
      )
    LOOP
      UPDATE t_rezervacije<CVOR>
         SET oznaka = ''P'',
             opis_storna = ''MISH automatska obrada''
       WHERE id = rez_c.id
         AND oznaka = ''V''
         AND ozn_vstorna IS NULL
         AND br_uputnice IS NULL
         AND recnrez_id = :recnrez_id_l
         AND ozn_f = 0;
      COMMIT;
      :br_ponistenih_l := :br_ponistenih_l + 1;
    END LOOP;
  EXCEPTION
    WHEN OTHERS THEN
      pra_rec.puni_promjene (''0043'', :br_ponistenih_l || '' | '' || SQLERRM, 0);
  END;';

  FOR c IN (
    SELECT
      DECODE (so.metcvor_sifra, vlas.sifra_tekuceg_cvora, NULL, '@' || so.metcvor_sifra) AS cvor -- IRN 3729
    FROM
      (SELECT DISTINCT (metcvor_sifra) AS metcvor_sifra FROM m_so) so,
      s_vlasnik vlas
    ORDER BY 1
    )
  LOOP
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', c.cvor) USING recnrez_id_l, unos_dat_l, IN OUT br_ponistenih_l; -- IRN 3729
  END LOOP;

  IF br_ponistenih_l > 0 THEN
    -- 0043 Ponitavanje privremenih rezervacija (broj ponitenih rezervacija)
    pra_rec.puni_promjene ('0043', br_ponistenih_l, 0);
  END IF;

EXCEPTION
  WHEN OTHERS THEN
    pra_rec.puni_promjene ('0043', br_ponistenih_l || ' | ' || SQLERRM, 0);
    RAISE;
END;
PROCEDURE POST2MDM
 (SJ_ID_P IN m_sj.id%TYPE
 )
 IS
/*
Kod odjave zadnjeg gosta iz SJ poalji zahtjev EraseDevice u MDM za ureaj
koji je "tagiran" sa ifrom smjetajnog objekta i brojem smjetajne jedinice.
Poziva se iz procedure pra_t_gosti.izradi_vszah.
*/
  CURSOR sj_c IS
    SELECT so.sifra, sj.broj, so.id
      FROM m_sj sj, m_so so
     WHERE sj.id = sj_id_p
       AND sj.so_id = so.id
       AND pra_zmp_s.oznaka ('O0007', so.sifra) = -1;
  so_sifra_l m_so.sifra%TYPE;
  sj_broj_l m_sj.broj%TYPE;
  so_id_l m_so.id%TYPE;
  --
  url_l          szmp_parametri.vrijednost%TYPE;
  token_l        szmp_parametri.vrijednost%TYPE;
  timeout_l      szmp_parametri.vrijednost%TYPE;
  request_type_l szmp_parametri.vrijednost%TYPE;
  prefix_so_l    szmp_parametri.vrijednost%TYPE;
  prefix_sj_l    szmp_parametri.vrijednost%TYPE;
  br_dana_l      szmp_parametri.vrijednost%TYPE;
  --
  pkaclob_opis_l lpka_clob.opis%TYPE;
  --
  data_l    CLOB;
  odgovor_l CLOB;
  --
  req_l     UTL_HTTP.req;
  res_l     UTL_HTTP.resp;
  line_l    CLOB;
BEGIN

  IF sj_id_p IS NULL THEN
    RETURN;
  END IF;

  OPEN sj_c;
  FETCH sj_c INTO so_sifra_l, sj_broj_l, so_id_l;
  IF sj_c%NOTFOUND THEN
    CLOSE sj_c;
    RETURN;
  END IF;
  CLOSE sj_c;

  url_l := pra_zmp_zaj.zmppar_vrijednost ('MDM', '1001');
  IF url_l = 'nebitno' THEN
    RETURN;
  ELSE
    url_l := url_l || '/devices/push_mdm_command_by_tags';
  END IF;

  token_l := pra_zmp_zaj.zmppar_vrijednost ('MDM', '1002');
  IF token_l = 'nebitno' THEN
    RETURN;
  END IF;

  timeout_l := pra_zmp_zaj.zmppar_vrijednost ('MDM', '1003');
  IF timeout_l = 'nebitno' THEN
    RETURN;
  END IF;

  -- Naredba (request_type) npr. DeviceInformation, EraseDevice ili nebitno.
  request_type_l := pra_zmp_zaj.zmppar_vrijednost ('MDM', '1004');
  IF request_type_l = 'nebitno' THEN
    RETURN;
  END IF;

  -- Prefiks uz ifru smjetajnog objekta npr. H ili nebitno.
  prefix_so_l := pra_zmp_zaj.zmppar_vrijednost ('MDM', '1005');
  IF prefix_so_l = 'nebitno' THEN
    prefix_so_l := NULL;
  END IF;

  -- Prefiks uz broj smjetajne jedinice npr. R ili nebitno.
  prefix_sj_l := pra_zmp_zaj.zmppar_vrijednost ('MDM', '1006');
  IF prefix_sj_l = 'nebitno' THEN
    prefix_sj_l := NULL;
  END IF;

  -- Spremati komunikaciju u log: 1 = da ili 0 = ne.
  IF pra_zmp_zaj.zmppar_vrijednost ('MDM', '1007') = '1' THEN
    pkaclob_opis_l := 'mdm-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '-' || so_sifra_l || '.log';
  END IF;

  -- Broj dana koliko se uvaju zapisi o komunikaciji u logu: od 1 do 999 ili nebitno = ne briu se.
  br_dana_l := pra_zmp_zaj.zmppar_vrijednost ('MDM', '1008');
  IF br_dana_l NOT IN ('nebitno') THEN
    DELETE
      FROM lpka_clob
     WHERE oznaka = 'MDM'
       AND TRUNC (SYSDATE) - TRUNC (unos_dat) >= TO_NUMBER (br_dana_l);
  END IF;

  /*
  curl -v -k POST
    -H "Content-Type: application/json"
    -H "Accept: application/json"
    -H 'Authorization: Token token=y0N1MdOZsZJxYs3Ujvsl7Att'
    -d '{"taglist":["H1","R1"], "mdm_commands": [{"request_type": "DeviceInformation"}]}'
    https://mdmtest.aminess.com/api/v3/d67f7a37-6780-43ef-9435-8b1ac2c991c0/devices/push_mdm_command_by_tags
  */

  APEX_JSON.initialize_clob_output;
  APEX_JSON.open_object(); -- {
  APEX_JSON.open_array ('taglist'); -- [
  APEX_JSON.write (prefix_so_l || so_sifra_l);
  APEX_JSON.write (prefix_sj_l || sj_broj_l);
  APEX_JSON.close_array; -- ]
  APEX_JSON.open_array ('mdm_commands'); -- [
  APEX_JSON.open_object(); -- {
  APEX_JSON.write ('request_type', request_type_l);
  APEX_JSON.close_object(); -- }
  APEX_JSON.close_array; -- ]
  APEX_JSON.close_object(); -- }
  data_l := APEX_JSON.get_clob_output;
  APEX_JSON.free_output;

  data_l := REPLACE (data_l, CHR(10), '');

  IF pkaclob_opis_l IS NOT NULL THEN
    pra_pka2.clob_to_table ('[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' || url_l || CHR(10), pkaclob_opis_l, so_id_l, 'MDM');
    pra_pka2.clob_to_table (data_l || CHR(10), pkaclob_opis_l, so_id_l, 'MDM');
  END IF;

  UTL_HTTP.set_detailed_excp_support (enable => true);
  UTL_HTTP.set_transfer_timeout (timeout => TO_NUMBER (timeout_l));
  UTL_HTTP.set_body_charset (charset => 'UTF-8');

  req_l := UTL_HTTP.begin_request (url => url_l, method => 'POST', http_version => 'HTTP/1.1');

  UTL_HTTP.set_header (req_l, 'Content-Type', 'application/json; charset=utf-8');
  UTL_HTTP.set_header (req_l, 'Accept', 'application/json');
  UTL_HTTP.set_header (req_l, 'Authorization', 'Token token=' || token_l);
  UTL_HTTP.set_header (req_l, 'Content-Length', pra_pka2.clob_length (data_l));

  UTL_HTTP.write_text (req_l, data_l);

  res_l := UTL_HTTP.get_response (req_l);

  odgovor_l := res_l.status_code || ' ' || res_l.reason_phrase || ' | ';

  BEGIN
    LOOP
      UTL_HTTP.read_line (res_l, line_l);
      odgovor_l := odgovor_l || line_l;
    END LOOP;
    UTL_HTTP.end_response (res_l);
  EXCEPTION
    WHEN UTL_HTTP.end_of_body THEN
      UTL_HTTP.end_response (res_l);
  END;

  /*
  Primjeri odgovora:
    {"status": 201, "msgs": ["1 devices successfully targeted by command(s)!"]}
  ili
    {"status": 204, "msgs": ["No devices found by defined tag(s): [[\"XH1\", \"XR1\"]] !"]}
  ili
    {"status": 500, "error": "Internal Server Error"}
  ili
    {"errors":"Bad credentials"}
  */

  IF pkaclob_opis_l IS NOT NULL THEN
    pra_pka2.clob_to_table (odgovor_l || CHR(10), pkaclob_opis_l, so_id_l, 'MDM');
  END IF;

EXCEPTION
  WHEN OTHERS THEN
    UTL_HTTP.end_response (res_l); -- It completes the HTTP request and response.
    IF pkaclob_opis_l IS NOT NULL THEN
      pra_pka2.clob_to_table (SQLERRM || CHR(10), pkaclob_opis_l, so_id_l, 'MDM');
    END IF;
END;
PROCEDURE PUNI_PKAOBA_OVERBOOKING
 (SJ_ID_OLD_P IN m_sj.id%TYPE
 ,SJ_ID_NEW_P IN m_sj.id%TYPE
 ,RBR_P IN VARCHAR2
 ,GOD_POSLOVNA_P IN VARCHAR2
 ,PREZIME_P IN VARCHAR2
 ,DAT_DOLASKA_P IN i_booking.datum%TYPE
 ,DAT_ODLASKA_P IN i_booking.datum%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE := NULL
 )
 IS
-- IRN 3977; izrada obavijesti o overbookingu
-- poziva se iz AUS_T_REZ_VSJ, AUS_TREC_REZ_SJ i AUS_T_GOSTI

  CURSOR sj_c (sj_id_k IN m_sj.id%TYPE) IS
    SELECT sj.so_id so_id, sj.vsj_id vsj_id, sj.broj sj_broj, vsj.sifra vsj_sifra
      FROM m_sj sj, s_vsj vsj
     WHERE sj.id = sj_id_k
       AND sj.vsj_id = vsj.id;
  sj_r_old_l     sj_c%ROWTYPE;
  sj_r_new_l     sj_c%ROWTYPE;
  dat_odlaska_l  t_gosti.dat_odlaska%TYPE;
  gkor_id_l      m_korisnici.gkor_id%TYPE;
  datum_l        i_booking.datum%TYPE;
  kol_pomocna_l  i_booking.kol_sj%TYPE;
  kol_prodanih_l i_booking.kol_sj%TYPE;
  kapacitet_l    i_booking.kol_sj%TYPE;
  kol_sj_iu_l    i_booking.kol_sj%TYPE;
  overbooking_l  BOOLEAN := FALSE;
  tekst_l        tpka_obavijesti.tekst%TYPE;
BEGIN

  IF sj_id_old_p IS NULL
    OR sj_id_new_p IS NULL
    OR sj_id_old_p = sj_id_new_p
    OR dat_dolaska_p IS NULL
    OR dat_odlaska_p IS NULL
    OR dat_odlaska_p <= TRUNC (SYSDATE)
    -- REC param 1236; Naziv grupe korisnika kojima treba izraditi obavijest o overbookingu nakon seljenja ili nebitno.
    OR pra_zmp_zaj.zmppar_vrijednost ('REC', '1236') = 'nebitno'
  THEN
    RETURN;
  END IF;

  OPEN sj_c (sj_id_old_p);
  FETCH sj_c INTO sj_r_old_l;
  IF sj_c%NOTFOUND THEN
    CLOSE sj_c;
    RETURN;
  END IF;
  CLOSE sj_c;

  OPEN sj_c (sj_id_new_p);
  FETCH sj_c INTO sj_r_new_l;
  IF sj_c%NOTFOUND THEN
    CLOSE sj_c;
    RETURN;
  END IF;
  CLOSE sj_c;

  IF sj_r_old_l.so_id = sj_r_new_l.so_id
    AND sj_r_old_l.vsj_id = sj_r_new_l.vsj_id
  THEN
    -- nema promjene SJ
    RETURN;
  END IF;

  IF gost_id_p IS NOT NULL THEN
    SELECT MAX (dat_odlaska) INTO dat_odlaska_l
      FROM t_gosti
     WHERE sj_id = sj_id_new_p
       AND ozn_prisutnosti = 'P'
       AND id <> gost_id_p;
    IF dat_odlaska_l IS NOT NULL
      AND dat_odlaska_l >= dat_odlaska_p
    THEN
      -- u novoj SJ ve boravi gost s jednakim ili veim datumom odlaska
      RETURN;
    END IF;
  END IF;

  SELECT MIN (id) INTO gkor_id_l
    FROM s_gkorisnika
   WHERE naziv = pra_zmp_zaj.zmppar_vrijednost ('REC', '1236');
  IF gkor_id_l IS NULL THEN
    RETURN;
  END IF;

  kapacitet_l := pra_rec.kapacitet_so (sj_r_new_l.so_id, sj_r_new_l.vsj_id);

  datum_l := GREATEST (TRUNC (SYSDATE), dat_dolaska_p);
  WHILE datum_l < dat_odlaska_p
  LOOP
    -- prodano
    SELECT NVL (SUM (kol_sj), 0)
      INTO kol_pomocna_l
      FROM i_booking
     WHERE so_id = sj_r_new_l.so_id
       AND vsj_id = sj_r_new_l.vsj_id
       AND datum = datum_l
       AND ozn_sprodaje IN ('B', 'F', 'O', 'Z');
    kol_prodanih_l := kol_pomocna_l;
    SELECT NVL (SUM (kol_sj), 0)
      INTO kol_pomocna_l
      FROM i_booking
     WHERE so_id = sj_r_new_l.so_id
       AND vsj_id = sj_r_new_l.vsj_id
       AND datum = datum_l
       AND ozn_sprodaje IN ('X', 'Y', 'W');
    kol_prodanih_l := kol_prodanih_l - kol_pomocna_l;

    -- koliina SJ izvan upotrebe
    SELECT COUNT (1) INTO kol_sj_iu_l
      FROM i_statusisj
     WHERE sj_id IN (SELECT id FROM m_sj WHERE so_id = sj_r_new_l.so_id AND vsj_id = sj_r_new_l.vsj_id)
       AND datum = datum_l
       AND NVL (ozn_z, 0) = 0 -- nije zauzeta
       AND ozn_i = 3; -- izvan upotrebe

    IF (kapacitet_l - kol_sj_iu_l) < kol_prodanih_l THEN
      overbooking_l := TRUE;
      EXIT;
    END IF;

    datum_l := datum_l + 1;
  END LOOP;

  IF NOT overbooking_l THEN
    RETURN;
  END IF;

  IF gost_id_p IS NULL THEN -- rezervacija
    -- Nakon promjene SJ iz #0 u #1 (u rezervaciji broj #2 na prezime #3) nastao je overbooking za vrstu SJ #4 na dan #5.
    tekst_l :=
      pra_zmp_zaj.poruka (
        'REC',
        'REC1615',
        sj_r_old_l.sj_broj,
        sj_r_new_l.sj_broj,
        rbr_p || '/' || god_poslovna_p,
        prezime_p,
        sj_r_new_l.vsj_sifra,
        TO_CHAR (datum_l, 'DD.MM.RRRR'));
  ELSE
    -- Nakon seljenja gosta #0 #1 iz SJ #2 u SJ #3 nastao je overbooking za vrstu SJ #4 na dan #5.
    tekst_l :=
      pra_zmp_zaj.poruka (
        'REC',
        'REC1616',
        rbr_p,
        prezime_p,
        sj_r_old_l.sj_broj,
        sj_r_new_l.sj_broj,
        sj_r_new_l.vsj_sifra,
        TO_CHAR (datum_l, 'DD.MM.RRRR'));
  END IF;
  tekst_l :=
    TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || CHR(10) || CHR(10) ||
    tekst_l || CHR(10) || CHR(10) ||
    '(' || LOWER (zmp_zaj.korisnik (-1)) || ')';

  FOR kor_c IN (
    SELECT naziv
      FROM m_korisnici
     WHERE (
           apl_shema_naziv = zmp_zaj.current_schema
           OR
           SYS_CONTEXT ('loginfo_ctx', 'vlasnikpodatka') IS NOT NULL -- IRN 4027; multitenant
           )
       AND gkor_id = gkor_id_l
       AND ozn_aktivan_korisnik = -1
     ORDER BY naziv)
  LOOP
    INSERT INTO tpka_obavijesti (
        naz_korisnika, oznaka, tekst, dat_zav, ozn_dopusten_dismiss, ozn_vobavijesti)
      VALUES (
        kor_c.naziv, 'V', tekst_l, TRUNC (SYSDATE) + 1, -1, 'A');
  END LOOP;

END;

END PRA_REC_IUD4;
/
SHOW ERROR

