-- C:\Users\dgajic\Desktop\IRN 4101\procedure\v1\des\pra_rec_iud.pkb
--
-- Generated for Oracle 10g on Fri Oct 10  08:47:44 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'PRA_REC_IUD'
CREATE OR REPLACE PACKAGE BODY PRA_REC_IUD IS

PROCEDURE PONISTI_REZ
 (SO_ID_P IN T_REZERVACIJE.SO_ID%TYPE
 ,DAT_DOLASKA_P IN T_REZERVACIJE.DAT_DOLASKA%TYPE
 ,MS_ID_P IN M_MSEGMENTI.ID%TYPE
 ,OZN_STOPBOOK_P IN NUMBER := 0
 )
 IS
/*
Poniti (No Show) rezervacije za promatrani SO i dolaske
15.02.2002. G.J.
IRN 2782; promijenjen SELECT, dodani uvjeti u UPDATE, izmijenjen DECODE
*/
BEGIN
  IF so_id_p IS NULL
    OR dat_dolaska_p IS NULL
  THEN
    RETURN;
  END IF;

  FOR rez_c IN (
    SELECT rez.id AS id,
           (
           SELECT COUNT (id)
             FROM t_rez_vsj
            WHERE rez_id = rez.id
              AND (   kol_sj - NVL (kol_sjz, 0) > 0
                   OR br_osoba - NVL (br_osobaz, 0) > 0
                   OR NVL (kol_sjz, 0) = 0
                   OR NVL (br_osobaz, 0) = 0)
           ) AS kol_rezvsj_neiskoristeno,
           (
           SELECT COUNT (id)
             FROM t_rez_vsj
            WHERE rez_id = rez.id
              AND (NVL (kol_sjz, 0) > 0 OR NVL (br_osobaz, 0) > 0)
           ) AS kol_rezvsj_iskoristeno
      FROM t_rezervacije rez
     WHERE rez.so_id = so_id_p
       AND rez.dat_dolaska <= dat_dolaska_p
       AND rez.ms_id = NVL (ms_id_p, rez.ms_id)
       AND rez.oznaka = 'V'
       AND rez.ozn_vstorna IS NULL
     ORDER BY rez.id)
  LOOP

    UPDATE t_rezervacije
       SET oznaka = DECODE (rez_c.kol_rezvsj_iskoristeno, 0, 'P', 'V'),
           ozn_vstorna = '3',
           dat_storna = SYSDATE
     WHERE id = rez_c.id
       AND (   rez_c.kol_rezvsj_iskoristeno = 0     -- nema iskoritenih SJ ili osoba
            OR rez_c.kol_rezvsj_neiskoristeno > 0); -- ima neiskoritenih SJ ili osoba

    IF ozn_stopbook_p = -1 THEN
      pra_rec_iud3.rez_stopbook_pon (rez_c.id);
    END IF;

  END LOOP;

  COMMIT;

END;
PROCEDURE AZURIRAJ_CIJENE_NA_CVOROVIMA
 (SO_ID_P IN m_so.id%TYPE
 ,CJE_ID_P IN t_cjenici.id%TYPE
 ,METCVOR_SIFRA_P IN smet_cvorovi.sifra%TYPE := NULL
 )
 IS
/*
Ako metcvor_sifra_p u pozivu procedure nije upisana
proe sve vorove i upie cijene za so i cjenik na one
vorove na kojima trebaju biti odnosno brie ih sa onih vorova
gdje ne trebaju biti.
Ako metcvor_sifra_p u pozivu procedure JE upisana poe samo taj vor
*/
  apl_sif_const CONSTANT smet_aplikacije.sifra%TYPE := 'REC';
  tablica_const CONSTANT VARCHAR2 (30) := 'T_CJE_USL';
  tablica_l VARCHAR2 (100);
  naredba_l VARCHAR2 (4000);
  brojac_l INTEGER;
  metcvor_sifra_l smet_cvorovi.sifra%TYPE;
BEGIN
  -- samo centar azurira po mrezi
  IF pra_zmp_zaj.centar = 0 THEN
    RETURN;
  END IF;
  FOR metins IN (
    SELECT ins.metcvor_sifra
      FROM smet_instalacije ins,
           smet_cvorovi cvor
     WHERE ins.metapl_sifra = apl_sif_const
       AND ins.metcvor_sifra <> pra_zmp_zaj.tekuci_cvor
       AND ins.metcvor_sifra = cvor.sifra
       AND cvor.sifra = NVL (metcvor_sifra_p, cvor.sifra)
    )
  LOOP
    IF replikacija.tab_replicira_na_cvor (metins.metcvor_sifra, tablica_const) = 0 THEN
      GOTO kraj_petlje;
    END IF;
    tablica_l := tablica_const || '@' || metins.metcvor_sifra;
    IF pra_rec_s2.cijena_pripada_cvoru (cje_id_p, so_id_p, metins.metcvor_sifra ) = -1 THEN
      -- kopirati na vor sve cijene za so_id_p i cje_id_p kojih tamo nema
      naredba_l :=
        'INSERT INTO ' || tablica_l ||
                ' (id,
                   cje_id,
                   so_id,
                   vsj_id,
                   usl_id,
                   recara_id,
                   datum,
                   cijena_usluge,
                   unos_korisnik, unos_dat, izmjena_korisnik, izmjena_dat)
            SELECT c.id,
                   c.cje_id,
                   c.so_id,
                   c.vsj_id,
                   c.usl_id,
                   c.recara_id,
                   c.datum,
                   c.cijena_usluge,
                   c.unos_korisnik, c.unos_dat, c.izmjena_korisnik, c.izmjena_dat
              FROM t_cje_usl c, ' || tablica_l || ' u ' ||
            'WHERE c.so_id = :so_id_p AND c.cje_id = :cje_id_p
               AND u.id (+) = c.id
               AND u.id IS NULL';
      EXECUTE IMMEDIATE naredba_l USING so_id_p, cje_id_p;
    ELSE
      -- brisati tamo sve cijene za so_id_p i cje_id_p
      naredba_l :=
        'DELETE FROM ' || tablica_l ||
             ' WHERE so_id = :so_id_p AND cje_id = :cje_id_p';
      EXECUTE IMMEDIATE naredba_l USING so_id_p, cje_id_p;
    END IF;
    <<kraj_petlje>> NULL;
  END LOOP;
END;
PROCEDURE KOPIRAJ_AGE_U_GMPKOM
 (AGE_ID_P IN M_AGENCIJE.ID%TYPE
 ,GMPKOM_ID_P IN OUT M_AGENCIJE.GMPKOM_ID%TYPE
 )
 IS
-- Kopiraj podatke iz agencije u novog komitenta
  age_rec_l m_agencije%ROWTYPE;
  br_redaka_l NUMBER;
BEGIN
  IF age_id_p IS NULL THEN
    RETURN;
  END IF;

  SELECT * INTO age_rec_l
    FROM m_agencije
   WHERE id = age_id_p;

  SELECT COUNT (ROWID) INTO br_redaka_l
    FROM mgmp_komitenti
   WHERE sifra = age_rec_l.sifra;
  IF br_redaka_l > 0 THEN
    pra_rec_zaj.vrati_poruku ('-20222');
  END IF;

  INSERT INTO mgmp_komitenti (
    gkage_id,
    vpobv_id,
    pos_id,
    reg_id,
    zem_id,
    ban_id,
    stpla_id,
    sifra,
    naziv,
    naz_dodatni,
    oib,
    br_porezni,
    br_racuna,
    naz_ulice,
    imep_osobeodg,
    br_telefona,
    br_telefaksa,
    email,
    www,
    sifra_pj, -- VS 07.10.2019
    napomena,
    ozn_uputnica,
    ozn_glavni_racun,
    ozn_vfisk, -- IRN 4101
    ozn_identifikatora, -- IRN 4101
    gln) -- IRN 4101
  VALUES (
    age_rec_l.gkage_id,
    age_rec_l.vpobv_id,
    age_rec_l.pos_id,
    age_rec_l.reg_id,
    age_rec_l.zem_id,
    age_rec_l.ban_id,
    age_rec_l.stpla_id,
    age_rec_l.sifra,
    age_rec_l.naziv,
    age_rec_l.naz_dodatni,
    age_rec_l.oib,
    age_rec_l.br_porezni,
    age_rec_l.br_racuna,
    age_rec_l.naz_ulice,
    age_rec_l.imep_osobeodg,
    age_rec_l.br_telefona,
    age_rec_l.br_telefaksa,
    age_rec_l.email,
    age_rec_l.www,
    age_rec_l.sifra_pj, -- VS 07.10.2019
    age_rec_l.napomena,
    age_rec_l.ozn_uputnica,
    age_rec_l.ozn_glavni_racun,
    age_rec_l.ozn_vfisk, -- IRN 4101
    age_rec_l.ozn_identifikatora, -- IRN 4101
    age_rec_l.gln); -- IRN 4101

  SELECT id INTO gmpkom_id_p
    FROM mgmp_komitenti
   WHERE sifra = age_rec_l.sifra;

  COMMIT;
END;
PROCEDURE PUNI_RECSPOKSIZV
 (RECSPOK_ID_P IN MREC_SPOK_SIZV.RECSPOK_ID%TYPE
 ,ZMPSIZV_ID_P IN MREC_SPOK_SIZV.ZMPSIZV_ID%TYPE
 )
 IS
/*
Izradi pravila knjienja stavaka pokazatelja uspjenosti:
odabrana stavka pokazatelja uspjenosti knjii se na
odabranu stavku izvjetaja za sve MS.
*/
  br_redaka_l NUMBER;
BEGIN
  IF recspok_id_p IS NULL
    OR zmpsizv_id_p IS NULL
  THEN
    RETURN;
  END IF;

  IF pra_zmp_zaj.centar = 0 THEN
    RETURN;
  END IF;

  IF pra_rec_s2.recspok_ozn_izvedena (recspok_id_p) IN (-1)
    OR pra_rec_s2.recspok_ozn_ms (recspok_id_p) IN (0)
  THEN
    RETURN;
  END IF;

  FOR ms_c IN (
    SELECT id
      FROM m_msegmenti
     ORDER BY sifra)
  LOOP
    SELECT COUNT (ROWID) INTO br_redaka_l
      FROM mrec_spok_sizv
     WHERE recspok_id = recspok_id_p
       AND ms_id = ms_c.id;
    IF br_redaka_l = 0 THEN
      INSERT INTO mrec_spok_sizv (
          recspok_id,
          ms_id,
          zmpsizv_id)
        VALUES (
          recspok_id_p,
          ms_c.id,
          zmpsizv_id_p);
    END IF;
  END LOOP;
  COMMIT;
END;
PROCEDURE PUNI_RECAGOST
 (GOST_ID_P IN t_gosti.id%TYPE
 ,CENSO_ID_P IN mcen_so.id%TYPE
 ,DAT_UCLANJENJA_P IN tloy_kartice.dat_valjan%TYPE
 ,LOYKAR_BROJ_P IN tloy_kartice.broj%TYPE
 ,RECAGOST_ID_P OUT trec_agostiju.id%TYPE
 )
 IS
--
  metcvor_sifra_x_l VARCHAR2(41);
  naredba_l VARCHAR2(400);
  recagost_rec_l trec_agostiju%ROWTYPE;
  /* -- IRN 2477
  Prilikom automatskog upisa u arhivu gostiju (parametar 1121) smiju se upisati podaci
  B = datum roenja,
  C = zemlja i mjesto roenja,
  D = oznaka VIP,
  E = o prebivalitu,
  F = o putnoj ispravi,
  G = vrsta plaanja BP
  */
  recparam1121_l szmp_parametri.vrijednost%TYPE := UPPER (pra_rec_zaj.vrijednost_parametra ('1121'));
  CURSOR gost_c (id_k t_gosti.id%TYPE) IS
    SELECT 1
      FROM t_gosti
     WHERE id = id_k
       FOR UPDATE OF recagost_id NOWAIT;
  br_redaka_l NUMBER;
  loykar_id_l tloy_kartice.id%TYPE; -- IRN 2678
BEGIN
  IF gost_id_p IS NULL THEN
    RETURN;
  END IF;

  metcvor_sifra_x_l := pra_trec_agostiju.metcvor_sifra_x ('trec_agostiju'); -- IRN 2291

  FOR kgost_c IN (
    SELECT
      kgost.pos_id AS pos_id,
      kgost.reg_id AS reg_id,
      kgost.vplabp_id AS vplabp_id,
      kgost.zemr_id AS zemr_id,
      kgost.posr_id AS posr_id,
      gost.zem_id AS zemd_id,
      kgost.vpisp_id AS vpisp_id,
      kgost.gpri_id AS gpri_id,
      gost.titula AS titula,
      gost.ime AS ime,
      gost.prezime AS prezime,
      kgost.naz_ulice AS naz_ulice,
      kgost.naz_poduzeca AS naz_poduzeca,
      kgost.dat_rodjenja AS dat_rodjenja,
      kgost.naz_mjrodj AS naz_mjrodj,
      kgost.ozn_spola AS ozn_spola,
      kgost.br_telefona AS br_telefona,
      kgost.br_telefaksa AS br_telefaksa,
      kgost.email AS email,
      kgost.www AS www,
      kgost.br_pisprave AS br_pisprave,
      kgost.naz_mjpisp AS naz_mjpisp,
      NVL (kgost.zem_id, gost.zem_id) AS zem_id,
      gost.jez_id AS jez_id,
      kgost.naz_mjesta AS naz_mjesta,
      kgost.naz_regije AS naz_regije,
      NVL (kgost.ozn_kontakt, 0) AS ozn_kontakt,
      NVL (kgost.ozn_kontakt_telefon, 0) AS ozn_kontakt_telefon,
      NVL (kgost.ozn_kontakt_telefaks, 0) AS ozn_kontakt_telefaks,
      NVL (kgost.ozn_kontakt_email, 0) AS ozn_kontakt_email,
      gost.ozn_vip AS ozn_vip,
      gost.id AS gost_id
    FROM
      t_kgostiju kgost,
      t_gosti gost
    WHERE
      gost.id = gost_id_p
      AND kgost.gost_id = gost.id
      AND gost.recagost_id IS NULL
      AND gost.id NOT IN (SELECT id FROM trec_kplovila)
      AND kgost.oznaka = 'V'
    )
  LOOP
    naredba_l := 'SELECT pra_zmp_zaj.i3_sekvenca' || metcvor_sifra_x_l || ' (NULL) FROM dual';
    EXECUTE IMMEDIATE naredba_l INTO recagost_rec_l.id;

    recagost_rec_l.oznaka := 'V';
    recagost_rec_l.titula := kgost_c.titula;
    recagost_rec_l.ime := kgost_c.ime;
    recagost_rec_l.prezime := kgost_c.prezime;
    recagost_rec_l.zemd_id := kgost_c.zemd_id;
    recagost_rec_l.naz_poduzeca := kgost_c.naz_poduzeca;

    IF INSTR(recparam1121_l, 'B') > 0 THEN -- IRN 2477
      recagost_rec_l.dat_rodjenja := kgost_c.dat_rodjenja;
    END IF;

    IF INSTR(recparam1121_l, 'C') > 0 THEN -- IRN 2477
      recagost_rec_l.zemr_id := kgost_c.zemr_id;
      recagost_rec_l.posr_id := kgost_c.posr_id;
      recagost_rec_l.naz_mjrodj := kgost_c.naz_mjrodj;
     END IF;

    IF INSTR(recparam1121_l, 'D') > 0 THEN -- IRN 2477
      recagost_rec_l.ozn_vip := kgost_c.ozn_vip;
    END IF;

    recagost_rec_l.zem_id := kgost_c.zem_id; -- obavezan podatak u trec_agostiju

    IF INSTR(recparam1121_l, 'E') > 0 THEN -- IRN 2477
      recagost_rec_l.naz_ulice := kgost_c.naz_ulice;
      recagost_rec_l.pos_id := kgost_c.pos_id;
      recagost_rec_l.reg_id := kgost_c.reg_id;
      recagost_rec_l.naz_mjesta := kgost_c.naz_mjesta;
      recagost_rec_l.naz_regije := kgost_c.naz_regije;
    END IF;

    IF INSTR(recparam1121_l, 'F') > 0 THEN -- IRN 2477
      recagost_rec_l.vpisp_id := kgost_c.vpisp_id;
      recagost_rec_l.br_pisprave := kgost_c.br_pisprave;
      recagost_rec_l.naz_mjpisp := kgost_c.naz_mjpisp;
      -- IRN 2477 recagost_rec_l.gpri_id := kgost_c.gpri_id;
    END IF;

    IF INSTR(recparam1121_l, 'G') > 0 THEN -- IRN 2477
      recagost_rec_l.vplabp_id := kgost_c.vplabp_id;
    END IF;

    recagost_rec_l.ozn_spola := kgost_c.ozn_spola;
    recagost_rec_l.br_telefona := kgost_c.br_telefona;
    recagost_rec_l.br_telefaksa := kgost_c.br_telefaksa;
    recagost_rec_l.email := kgost_c.email;
    recagost_rec_l.www := kgost_c.www;

    recagost_rec_l.unos_korisnik := zmp_zaj.korisnik (-1); -- IRN 2225
    recagost_rec_l.unos_dat := SYSDATE; -- IRN 2225

    recagost_rec_l.jez_id := kgost_c.jez_id;

    recagost_rec_l.ozn_kontakt := kgost_c.ozn_kontakt;
    recagost_rec_l.ozn_kontakt_telefon := kgost_c.ozn_kontakt_telefon;
    recagost_rec_l.ozn_kontakt_telefon2 := 0;
    recagost_rec_l.ozn_kontakt_telefaks := kgost_c.ozn_kontakt_telefaks;
    recagost_rec_l.ozn_kontakt_email := kgost_c.ozn_kontakt_email;

    -- IRN 2291; funkcija pra_trec_agostiju.recagost_rec aurira i pra_trec_agostiju.ozn_azuriraj_podcentar_g
    pra_rec_iud2.insert_recagost_cvor (metcvor_sifra_x_l, pra_trec_agostiju.recagost_rec (recagost_rec_l));

    OPEN gost_c (kgost_c.gost_id);
    FETCH gost_c INTO br_redaka_l;
    IF gost_c%FOUND THEN
      UPDATE t_gosti
         SET recagost_id = recagost_rec_l.id
       WHERE CURRENT OF gost_c;
    END IF;
    CLOSE gost_c;
  END LOOP;

  -- IRN 2678 upii karticu programa vjernosti
  IF censo_id_p IS NOT NULL
    AND loykar_broj_p IS NOT NULL
    AND dat_uclanjenja_p IS NOT NULL
  THEN
    naredba_l := 'SELECT pra_zmp_zaj.i3_sekvenca' || metcvor_sifra_x_l || ' (NULL) FROM dual';
    EXECUTE IMMEDIATE naredba_l INTO loykar_id_l;

    naredba_l :=
      'INSERT INTO tloy_kartice<Centar> (id, recagost_id, censo_id, broj, dat_valjan)' ||
      '  VALUES (:loykar_id_l, :recagost_id, :censo_id, :broj, :dat_valjan)';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<Centar>', metcvor_sifra_x_l)
      USING loykar_id_l, recagost_rec_l.id, censo_id_p, loykar_broj_p, dat_uclanjenja_p;

    IF SQL%ROWCOUNT = 1 THEN
      -- IRN 2163 puni bodove dobrodolice
      pra_rec_loy.puni_loyula_21 (recagost_rec_l.id, metcvor_sifra_x_l, censo_id_p, dat_uclanjenja_p, loykar_id_l); -- IRN 2678
    END IF;

  END IF;

  COMMIT;

  -- IRN 2291; auriraj tablicu trec_agostiju na podcentru
  IF pra_trec_agostiju.ozn_azuriraj_podcentar_g = -1 THEN -- oznaku aurira funkcija pra_trec_agostiju.recagost_rec
    SELECT rbr INTO recagost_rec_l.rbr FROM trec_agostiju WHERE id = recagost_rec_l.id;
    pra_trec_agostiju.update_recagost_podcentar (recagost_rec_l);
    COMMIT;
  END IF;

  recagost_id_p := recagost_rec_l.id;

EXCEPTION
  WHEN OTHERS THEN
    IF gost_c%ISOPEN THEN
      CLOSE gost_c;
    END IF;
    RAISE;
END;
PROCEDURE KOPIRAJ_ZAKUP
 (ZAK_ID_P IN T_ZAKUP.ID%TYPE
 ,GOD_POSLOVNA_P IN T_ZAKUP.GOD_POSLOVNA%TYPE
 ,DATUM_P IN T_ZAKUP.DATUM%TYPE
 ,DAT_POC_P IN T_ZAKUP.DAT_POC%TYPE
 ,DAT_ZAV_P IN T_ZAKUP.DAT_ZAV%TYPE
 ,DAT_PREDUJMA_P IN T_ZAKUP.DAT_PREDUJMA%TYPE
 ,DAT_DOSPIJECA_P IN T_ZAKUP.DAT_DOSPIJECA%TYPE
 ,NAPOMENA_P IN T_ZAKUP.NAPOMENA%TYPE
 ,ZAK_NOVI_ID_P OUT T_ZAKUP.ID%TYPE
 )
 IS
-- kopiraj ugovor o zakupu
  zak_row_l t_zakup%ROWTYPE; -- IRN 3541

  zaksj_id_l t_zak_sj.id%TYPE;

  dob_plus_l NUMBER;
  dob_l NUMBER;
  --
  ban_id_l m_banke.id%TYPE;
  vtec_id_l s_vtecajeva.id%TYPE;
BEGIN
  IF zak_id_p IS NULL THEN
    RETURN;
  END IF;

  -- ifra banke ija se teajna lista koristi kod izrade usluge
  SELECT MIN (id) INTO ban_id_l FROM m_banke WHERE sifra = pra_rec_zaj.vrijednost_parametra ('1002');

  -- ifra vrste teajeva po kojoj se usluga knjii u urnal
  SELECT MIN (id) INTO vtec_id_l FROM s_vtecajeva WHERE sifra = pra_rec_zaj.vrijednost_parametra ('1001');

  FOR zak_c IN (
    SELECT *
      FROM t_zakup
     WHERE id = zak_id_p)
  LOOP
    zak_row_l := zak_c;
    zak_row_l.id := pra_rec_zaj.sekvenca (NULL);
    zak_row_l.god_poslovna := god_poslovna_p;
    zak_row_l.rbr := NULL;
    pra_rec.izracunaj_redni_broj (
      'T_ZAKUP',
      zak_row_l.god_poslovna,
      zak_row_l.so_id,
      zak_row_l.vzak_id,
      5,
      zak_row_l.rbr);
    zak_row_l.ozn_valjanosti := 'V';
    zak_row_l.oznaka := 'V';
    zak_row_l.datum := datum_p;
    pra_pka_s3.vrati_izn_tecaja ( -- IRN 3541; teaj na datum novog ugovora
      zak_row_l.val_id,
      ban_id_l,
      vtec_id_l,
      datum_p,
      zak_row_l.izn_tecajat,
      zak_row_l.izn_tecaja);
    dob_plus_l := FLOOR (MONTHS_BETWEEN (dat_poc_p, zak_c.dat_poc) / 12);
    zak_row_l.dat_poc := dat_poc_p;
    zak_row_l.dat_zav := dat_zav_p;
    zak_row_l.dat_predujma := dat_predujma_p;
    zak_row_l.dat_dospijeca := dat_dospijeca_p;
    zak_row_l.napomena := napomena_p;
    zak_row_l.unos_korisnik := NULL;
    zak_row_l.unos_dat := NULL;
    zak_row_l.pristupni_kod := NULL;
    INSERT INTO t_zakup VALUES zak_row_l;
  END LOOP;

  FOR reczakusl_c IN (
    SELECT usl_id,
           kolicina,
           cijena
      FROM trec_zak_usl
     WHERE zak_id = zak_id_p)
  LOOP
    INSERT INTO trec_zak_usl (
           id,
           zak_id,
           usl_id,
           kolicina,
           cijena)
    VALUES (
           NULL,
           zak_row_l.id,
           reczakusl_c.usl_id,
           reczakusl_c.kolicina,
           reczakusl_c.cijena);
  END LOOP;

  FOR zaksj_c IN (
    SELECT id,
           sj_id
      FROM t_zak_sj
     WHERE zak_id = zak_id_p)
  LOOP
    zaksj_id_l := pra_rec_zaj.sekvenca (NULL); -- potrebno za upis t_zak_kj, t_zak_korisnici i trec_zak_plovila
    INSERT INTO t_zak_sj (
           id,
           zak_id,
           sj_id)
    VALUES (
           zaksj_id_l,
           zak_row_l.id,
           zaksj_c.sj_id);

    FOR zakkj_c IN (
      SELECT zem_id,
             naz_vrste,
             naz_marke,
             broj,
             opis,
             br_evidencije
        FROM t_zak_kj
       WHERE zaksj_id = zaksj_c.id)
    LOOP
      INSERT INTO t_zak_kj (
             id,
             zaksj_id,
             zem_id,
             naz_vrste,
             naz_marke,
             broj,
             opis,
             br_evidencije)
      VALUES (
             NULL,
             zaksj_id_l,
             zakkj_c.zem_id,
             zakkj_c.naz_vrste,
             zakkj_c.naz_marke,
             zakkj_c.broj,
             zakkj_c.opis,
             zakkj_c.br_evidencije);
    END LOOP;

    FOR zakkor_c IN (
      SELECT titula,
             ime,
             prezime,
             dob
        FROM t_zak_korisnici
       WHERE zaksj_id = zaksj_c.id)
    LOOP
      IF zakkor_c.dob IS NOT NULL THEN
        dob_l := zakkor_c.dob + dob_plus_l;
      ELSE
        dob_l := NULL;
      END IF;
      INSERT INTO t_zak_korisnici (
             id,
             zaksj_id,
             titula,
             ime,
             prezime,
             dob)
      VALUES (
             NULL,
             zaksj_id_l,
             zakkor_c.titula,
             zakkor_c.ime,
             zakkor_c.prezime,
             dob_l);
    END LOOP;

    FOR reczakplo_c IN (
      SELECT recplo_id,
             broj_dokumenta,
             vrijednost_plovila,
             osiguranje1,
             osiguranje2,
             osiguranje3,
             osiguranje4,
             ozn_abc,
             ozn_suhi_vez,
             napomena
        FROM trec_zak_plovila
       WHERE zaksj_id = zaksj_c.id)
    LOOP
      INSERT INTO trec_zak_plovila (
             id,
             zaksj_id,
             recplo_id,
             broj_dokumenta,
             dat_dolaska,
             vrijednost_plovila,
             osiguranje1,
             osiguranje2,
             osiguranje3,
             osiguranje4,
             ozn_abc,
             ozn_suhi_vez,
             napomena)
      VALUES (
             NULL,
             zaksj_id_l,
             reczakplo_c.recplo_id,
             reczakplo_c.broj_dokumenta,
             NULL, -- dat_dolaska
             reczakplo_c.vrijednost_plovila,
             reczakplo_c.osiguranje1,
             reczakplo_c.osiguranje2,
             reczakplo_c.osiguranje3,
             reczakplo_c.osiguranje4,
             reczakplo_c.ozn_abc,
             reczakplo_c.ozn_suhi_vez,
             reczakplo_c.napomena);
    END LOOP;
  END LOOP;

  zak_novi_id_p := zak_row_l.id;

  COMMIT;
END;
FUNCTION POZIV_NA_BROJ
 (OJ_ID_P IN TREC_PONUDE2.OJ_ID%TYPE
 ,AGE_ID_P IN TREC_PONUDE2.AGE_ID%TYPE
 ,PKAADR_ID_P IN TREC_PONUDE2.PKAADR_ID%TYPE
 ,GOD_POSLOVNA_P IN TREC_PONUDE2.GOD_POSLOVNA%TYPE
 ,RBR_P IN TREC_PONUDE2.RBR%TYPE
 )
 RETURN VARCHAR2
 IS
/*
Generiranje poziva na broj (22 znaka):
nebitno = ne generira se,
A (1) = vdok.sifra2n,
B (2) = recpon2.god_poslovna,
C (3) = SUBSTR(recpon2.rbr, 2, 6),
D (4) = recpon2.rbr,
E (5) = SUBSTR(NVL(age_sifra, pkaadr_rbr), 1, 5),
F (6) = oj.sifra,
G (7) = NVL(age_sifra, pkaadr_sifra),
H (8) = SUBSTR(recpon2.god_poslovna, 4, 1),
ostalo prepisuje.
*/

  poziv_na_broj_l VARCHAR2(240);
  vdok_sifra2n_l s_vdokumenata.sifra2n%TYPE;
  oj_sifra_l m_oj.sifra%TYPE;
  age_sifra_l m_agencije.sifra%TYPE;
  pkaadr_rbr_l mpka_adrese.rbr%TYPE;
  vrijednost_parametra_l szmp_parametri.vrijednost%TYPE;
BEGIN

  IF oj_id_p IS NULL
    OR (age_id_p IS NULL AND pkaadr_id_p IS NULL)
    OR god_poslovna_p IS NULL
    OR rbr_p IS NULL
  THEN
    RETURN (NULL);
  END IF;

  vrijednost_parametra_l := pra_rec_zaj.vrijednost_parametra ('1096');

  IF UPPER (vrijednost_parametra_l) = 'NEBITNO' THEN
    RETURN (NULL);
  END IF;

  FOR i IN 1 .. 10
  LOOP
    IF (SUBSTR (vrijednost_parametra_l, i, 1)) = 'A' THEN
      BEGIN
        SELECT vdok.sifra2n
          INTO vdok_sifra2n_l
          FROM s_vapldok vapldok,
               s_vdokumenata vdok
         WHERE vapldok.metapl_sifra = 'REC'
           AND vapldok.oznaka = 'PR'
           AND vapldok.vdok_id = vdok.id;
      EXCEPTION
        WHEN NO_DATA_FOUND THEN
          vdok_sifra2n_l := NULL;
      END;

      poziv_na_broj_l := poziv_na_broj_l || vdok_sifra2n_l;

    ELSIF (SUBSTR (vrijednost_parametra_l, i, 1)) = 'B' THEN
      poziv_na_broj_l := poziv_na_broj_l || god_poslovna_p;

    ELSIF (SUBSTR (vrijednost_parametra_l, i, 1)) = 'C' THEN
      poziv_na_broj_l := poziv_na_broj_l || SUBSTR (rbr_p, 2, 6);

    ELSIF (SUBSTR (vrijednost_parametra_l, i, 1)) = 'D' THEN
      poziv_na_broj_l := poziv_na_broj_l || rbr_p;

    ELSIF (SUBSTR (vrijednost_parametra_l, i, 1)) = 'E' THEN
      IF age_id_p IS NOT NULL THEN
        SELECT sifra
          INTO age_sifra_l
          FROM m_agencije
         WHERE id = age_id_p;
      ELSE
        SELECT rbr
          INTO pkaadr_rbr_l
          FROM mpka_adrese
         WHERE id = pkaadr_id_p;
      END IF;

      poziv_na_broj_l := poziv_na_broj_l || SUBSTR (NVL (age_sifra_l, pkaadr_rbr_l), 1, 6);

    ELSIF (SUBSTR (vrijednost_parametra_l, i, 1)) = 'F' THEN
      SELECT oj.sifra
        INTO oj_sifra_l
        FROM m_oj oj
       WHERE oj.id = oj_id_p;

      poziv_na_broj_l := poziv_na_broj_l || oj_sifra_l;

    ELSIF (SUBSTR (vrijednost_parametra_l, i, 1)) = 'G' THEN
      IF age_id_p IS NOT NULL THEN
        SELECT sifra
          INTO age_sifra_l
          FROM m_agencije
         WHERE id = age_id_p;
      ELSE
        SELECT rbr
          INTO pkaadr_rbr_l
          FROM mpka_adrese
         WHERE id = pkaadr_id_p;
      END IF;

      poziv_na_broj_l := poziv_na_broj_l || NVL (age_sifra_l, pkaadr_rbr_l);

    ELSIF (SUBSTR (vrijednost_parametra_l, i, 1)) = 'H' THEN
      poziv_na_broj_l := poziv_na_broj_l || SUBSTR (god_poslovna_p, 4, 1);

    ELSE
      poziv_na_broj_l := poziv_na_broj_l || SUBSTR (vrijednost_parametra_l, i, 1);

    END IF;
  END LOOP;

  RETURN (SUBSTR (poziv_na_broj_l, 1, 22));

END;
PROCEDURE INSERT_RECPON2
 (REC_PON2_P IN TREC_PONUDE2%ROWTYPE
 )
 IS
BEGIN
  INSERT INTO trec_ponude2 VALUES rec_pon2_p;
END;
PROCEDURE INSERT_RECPON2USL
 (REC_PON2USL_P IN TREC_PON2_USL%ROWTYPE
 )
 IS
BEGIN
  INSERT INTO trec_pon2_usl VALUES rec_pon2usl_p;
END;
PROCEDURE PUNI_RECPON2USL_IZN_ODBITKA
 (RECPON2_ID_P IN TREC_PON2_USL.RECPON2_ID%TYPE
 ,BR_DANA_BORAVKA_P IN NUMBER := NULL
 )
 IS
--  
  izn_pon2_bez_odb_l NUMBER;
  izn_usl_bez_odb_l  NUMBER;
  
  izn_smjesta_pon2_l NUMBER;
  
  izn_smjesta_l      NUMBER;
  izn_usl_pop1_l     NUMBER;
  izn_usl_pop2_l     NUMBER;
  izn_usl_pop3_l     NUMBER;
  izn_usl_pop4_l     NUMBER;
  izn_odbitka_l      NUMBER;

  stopa_popusta1_l   NUMBER;
  stopa_popusta2_l   NUMBER;
  stopa_popusta3_l   NUMBER;
  stopa_popusta4_l   NUMBER;
BEGIN
  /*  
  -- ukupni iznos svih usluga bez odbitaka
  SELECT SUM (ROUND (DECODE (recpon2usl.usl_id1, NULL, recpon2usl.cijena, 0) *
                       recpon2usl.stopa_placanja / 100 *
                       recpon2usl.izn_tecaja / recpon2.izn_tecaja
                     , 2) *
              DECODE (NVL (recpon2usl.obr_po_danu, usl.obr_po_danu), 0, 1,
                (recpon2usl.dat_zav - recpon2usl.dat_poc - NVL (recpon2usl.obr_zdana, usl.obr_zdana))) *
              recpon2usl.kolicina)
    INTO izn_pon2_bez_odb_l
    FROM trec_pon2_usl recpon2usl,
         s_usluge usl,
         trec_ponude2 recpon2
   WHERE recpon2usl.usl_id = usl.id
     AND recpon2usl.recpon2_id = recpon2.id
     AND recpon2.id = recpon2_id_p;

  -- ukupni iznos slobodnih mjesta
  SELECT SUM (ROUND (DECODE (recpon2usl.usl_id1, NULL, recpon2usl.cijena, 0) *
                       recpon2usl.stopa_placanja / 100 *
                       recpon2usl.izn_tecaja / recpon2.izn_tecaja
                     , 2) *
              DECODE (NVL (recpon2usl.obr_po_danu, usl.obr_po_danu), 0, 1,
                (recpon2usl.dat_zav - recpon2usl.dat_poc - NVL (recpon2usl.obr_zdana, usl.obr_zdana))) *
              recpon2usl.kolicina)
    INTO izn_smjesta_pon2_l
    FROM trec_pon2_usl recpon2usl,
         s_usluge usl,
         trec_ponude2 recpon2
   WHERE recpon2usl.usl_id = usl.id
     AND recpon2usl.recpon2_id = recpon2.id
     AND recpon2.id = recpon2_id_p
     AND recpon2usl.ozn_smjesta = -1
     AND NVL (recpon2usl.obr_smjesta, usl.obr_smjesta) = -1;

  IF izn_pon2_bez_odb_l = 0 THEN
    stopa_smjesta_l := 0;
  ELSE
    stopa_smjesta_l := LEAST (izn_smjesta_pon2_l / izn_pon2_bez_odb_l * 100, 100);
  END IF;
  */

  FOR c IN (
    SELECT recpon2usl.id id,
           recpon2usl.usl_id usl_id,
           DECODE (recpon2usl.usl_id1, NULL, recpon2usl.cijena, 0) cijena,
           recpon2usl.stopa_placanja stopa_placanja,
           recpon2usl.izn_tecaja izn_tecaja_usl,
           recpon2usl.dat_poc dat_poc,
           recpon2usl.dat_zav dat_zav,
           NVL (recpon2usl.obr_po_danu, usl.obr_po_danu) obr_po_danu,
           NVL (recpon2usl.obr_zdana, usl.obr_zdana) obr_zdana,
           recpon2usl.kolicina kolicina,
           recpon2usl.vsj_id vsj_id,
           recpon2.izn_tecaja izn_tecaja,
           recpon2.stopa_popusta1 stopa_popusta1,
           recpon2.stopa_popusta2 stopa_popusta2,
           recpon2.stopa_popusta3 stopa_popusta3,
           recpon2.stopa_popusta4 stopa_popusta4,
           recpon2.zmppop1_id zmppop1_id,
           recpon2.zmppop2_id zmppop2_id,
           recpon2.zmppop3_id zmppop3_id,
           recpon2.zmppop4_id zmppop4_id,
           recpon2.so_id so_id,
           recpon2usl.ozn_smjesta ozn_smjesta,
           NVL (recpon2usl.obr_smjesta, usl.obr_smjesta) obr_smjesta,
           NVL (recpon2usl.obr_popusta1, usl.obr_popusta) obr_popusta1,
           NVL (recpon2usl.obr_popusta2, usl.obr_popusta2) obr_popusta2,
           NVL (recpon2usl.obr_popusta3, usl.obr_popusta3) obr_popusta3,
           NVL (recpon2usl.obr_popusta4, usl.obr_popusta4) obr_popusta4,
           DECODE (NVL (recpon2usl.obr_po_danu, usl.obr_po_danu), 
                   0, 1,
                   (recpon2usl.dat_zav - recpon2usl.dat_poc - NVL (recpon2usl.obr_zdana, usl.obr_zdana))
                   ) AS br_dana,
           NVL(br_dana_boravka_p, recpon2usl.dat_zav - recpon2usl.dat_poc + 1) br_dana_boravka
      FROM trec_pon2_usl recpon2usl,
           s_usluge usl,
           trec_ponude2 recpon2
     WHERE recpon2usl.usl_id = usl.id
       AND recpon2usl.recpon2_id = recpon2.id
       AND recpon2.id = recpon2_id_p)
  LOOP
    izn_usl_bez_odb_l := ROUND (c.cijena * c.stopa_placanja / 100 * c.izn_tecaja_usl / c.izn_tecaja, 2) *
                         c.br_dana * c.kolicina;

    izn_smjesta_l := ROUND (izn_usl_bez_odb_l * c.obr_smjesta * c.ozn_smjesta, 2);

    IF c.zmppop1_id IS NULL THEN
      izn_usl_pop1_l := ROUND ((izn_usl_bez_odb_l - 
                                izn_smjesta_l) * -1 * c.obr_popusta1 *
                               NVL (c.stopa_popusta1, 0) / 100, 2);
    ELSE
      stopa_popusta1_l := pra_rec_s4.stopa_zmppop (c.zmppop1_id, c.so_id, c.vsj_id, c.usl_id, c.dat_poc, c.dat_zav, c.br_dana_boravka);
      izn_usl_pop1_l := ROUND ((izn_usl_bez_odb_l - 
                                izn_smjesta_l) *
                               NVL (stopa_popusta1_l, 0) / 100, 2);
    END IF;

    IF c.zmppop2_id IS NULL THEN
      izn_usl_pop2_l := ROUND ((izn_usl_bez_odb_l - 
                                izn_smjesta_l - 
                                izn_usl_pop1_l) * -1 * c.obr_popusta2 *
                               NVL (c.stopa_popusta2, 0) / 100, 2);

    ELSE
      stopa_popusta2_l := pra_rec_s4.stopa_zmppop (c.zmppop2_id, c.so_id, c.vsj_id, c.usl_id, c.dat_poc, c.dat_zav, c.br_dana_boravka);
      izn_usl_pop2_l := ROUND ((izn_usl_bez_odb_l - 
                                izn_smjesta_l - 
                                izn_usl_pop1_l) *
                               NVL (stopa_popusta2_l, 0) / 100, 2);
    END IF;

    IF c.zmppop3_id IS NULL THEN
      izn_usl_pop3_l := ROUND ((izn_usl_bez_odb_l - 
                                izn_smjesta_l - 
                                izn_usl_pop1_l - 
                                izn_usl_pop2_l) * -1 * c.obr_popusta3 *
                               NVL (c.stopa_popusta3, 0) / 100, 2);
    ELSE
      stopa_popusta3_l := pra_rec_s4.stopa_zmppop (c.zmppop3_id, c.so_id, c.vsj_id, c.usl_id, c.dat_poc, c.dat_zav, c.br_dana_boravka);
      izn_usl_pop3_l := ROUND ((izn_usl_bez_odb_l - 
                                izn_smjesta_l - 
                                izn_usl_pop1_l - 
                                izn_usl_pop2_l) *
                               NVL (stopa_popusta3_l, 0) / 100, 2);
    END IF;
    
    IF c.zmppop4_id IS NULL THEN
      izn_usl_pop4_l := ROUND ((izn_usl_bez_odb_l - 
                                izn_smjesta_l - 
                                izn_usl_pop1_l - 
                                izn_usl_pop2_l - 
                                izn_usl_pop3_l) * -1 * c.obr_popusta4 *
                               NVL (c.stopa_popusta4, 0) / 100, 2);
    ELSE
      stopa_popusta4_l := pra_rec_s4.stopa_zmppop (c.zmppop4_id, c.so_id, c.vsj_id, c.usl_id, c.dat_poc, c.dat_zav, c.br_dana_boravka);
      izn_usl_pop4_l := ROUND ((izn_usl_bez_odb_l - 
                                izn_smjesta_l - 
                                izn_usl_pop1_l - 
                                izn_usl_pop2_l - 
                                izn_usl_pop3_l) *
                               NVL (stopa_popusta4_l, 0) / 100, 2);
    END IF;

    izn_odbitka_l := izn_smjesta_l + izn_usl_pop1_l + izn_usl_pop2_l + izn_usl_pop3_l + izn_usl_pop4_l;

    UPDATE trec_pon2_usl
       SET izn_odbitka = izn_odbitka_l
     WHERE id = c.id;

  END LOOP;
END;
PROCEDURE PUNI_RECPON2_IZNOS
 (RECPON2_ID_P IN TREC_PONUDE2.ID%TYPE
 ,STOPA_PREDUJMA_P IN TREC_PONUDE2.STOPA_PREDUJMA%TYPE
 ,BR_DANA_BORAVKA_P IN NUMBER := NULL
 )
 IS
--  
  CURSOR recpon2_c IS
    SELECT NVL(recpon2.stopa_popusta1, 0) stopa_popusta1, recpon2.izn_popusta1,
           NVL(recpon2.stopa_popusta2, 0) stopa_popusta2, recpon2.izn_popusta2,
           NVL(recpon2.stopa_popusta3, 0) stopa_popusta3, recpon2.izn_popusta3,
           NVL(recpon2.stopa_popusta4, 0) stopa_popusta4, recpon2.izn_popusta4,
           recpon2.izn_predujma,
           recpon2.br_smjesta,
           recpon2.izn_smjesta,
           recpon2.zmppop1_id, 
           recpon2.zmppop2_id, 
           recpon2.zmppop3_id,
           recpon2.zmppop4_id
      FROM trec_ponude2 recpon2
     WHERE recpon2.id = recpon2_id_p;
  
  recpon2_c_l recpon2_c%ROWTYPE;

  izn_pon2_bez_odb_l     NUMBER;
  izn_pon2_predujma_l    NUMBER;
  izn_ponude_l           NUMBER;
  br_smjesta_l           NUMBER := 0;

  izn_pon2_smjesta_l     NUMBER := 0;
  izn_pon2_popust1_l     NUMBER := 0;
  izn_pon2_popust2_l     NUMBER := 0;
  izn_pon2_popust3_l     NUMBER := 0;
  izn_pon2_popust4_l     NUMBER := 0;

  izn_pon2usl_smjesta_l  NUMBER := 0;
  izn_pon2usl_popust1_l  NUMBER := 0;
  izn_pon2usl_popust2_l  NUMBER := 0;
  izn_pon2usl_popust3_l  NUMBER := 0;
  izn_pon2usl_popust4_l  NUMBER := 0;
BEGIN
  -- ova procedura poziva se u izradi predrauna iz rezervacije (pa i kod izrauna iznosa rezervacije);
  -- neke vrijednosti u toj situaciji nije mogue unijeti (iznos SM, iznos popusta),
  -- zato se te vrijednost ovdje ne obrauju kao to se obrauju u modulu Predraun
 
  OPEN recpon2_c;
  FETCH recpon2_c INTO recpon2_c_l;
  CLOSE recpon2_c;

  /* ukupni iznos svih usluga bez odbitaka */
  SELECT SUM (ROUND (DECODE (recpon2usl.usl_id1, NULL, recpon2usl.cijena, 0) *
                       recpon2usl.stopa_placanja / 100 *
                       recpon2usl.izn_tecaja / recpon2.izn_tecaja
                     , 2) *
              DECODE (NVL (recpon2usl.obr_po_danu, usl.obr_po_danu), 0, 1,
                (recpon2usl.dat_zav - recpon2usl.dat_poc - NVL (recpon2usl.obr_zdana, usl.obr_zdana))) *
              recpon2usl.kolicina)
    INTO izn_pon2_bez_odb_l
    FROM trec_pon2_usl recpon2usl,
         s_usluge usl,
         trec_ponude2 recpon2
   WHERE recpon2usl.usl_id = usl.id
     AND recpon2usl.recpon2_id = recpon2.id
     AND recpon2.id = recpon2_id_p;

  FOR uslpop_c IN
    (SELECT ROUND (DECODE (recpon2usl.usl_id1, NULL, recpon2usl.cijena, 0) *
                   recpon2usl.stopa_placanja / 100 *
                   recpon2usl.izn_tecaja / recpon2.izn_tecaja
                   , 2) *
            DECODE (NVL (recpon2usl.obr_po_danu, usl.obr_po_danu), 
                    0, 1,
                   (recpon2usl.dat_zav - recpon2usl.dat_poc - NVL (recpon2usl.obr_zdana, usl.obr_zdana))
                    ) *
            recpon2usl.kolicina                                                                         osnusl,
            recpon2usl.ozn_smjesta * -1                                                                 ozn_smjesta,
            NVL (recpon2usl.obr_smjesta, usl.obr_smjesta) * -1                                          obr_smjesta,
            NVL (recpon2usl.obr_popusta1, usl.obr_popusta) * -1                                         obr_popusta1,
            NVL (recpon2usl.obr_popusta2, usl.obr_popusta2) * -1                                        obr_popusta2,
            NVL (recpon2usl.obr_popusta3, usl.obr_popusta3) * -1                                        obr_popusta3,
            NVL (recpon2usl.obr_popusta4, usl.obr_popusta4) * -1                                        obr_popusta4,
            recpon2.stopa_popusta1                                                                      stopa_popusta1,
            recpon2.stopa_popusta2                                                                      stopa_popusta2,
            recpon2.stopa_popusta3                                                                      stopa_popusta3,
            recpon2.stopa_popusta4                                                                      stopa_popusta4,
            pra_rec_s4.stopa_zmppop (recpon2.zmppop1_id,
                                     recpon2.so_id, 
                                     recpon2usl.vsj_id,
                                     recpon2usl.usl_id,
                                     recpon2usl.dat_poc, 
                                     recpon2usl.dat_zav, 
                                     NVL(br_dana_boravka_p, 
                                         recpon2usl.dat_zav - recpon2usl.dat_poc + 1))                  stopa_popusta1_zmp,
            pra_rec_s4.stopa_zmppop (recpon2.zmppop2_id,
                                     recpon2.so_id, 
                                     recpon2usl.vsj_id,
                                     recpon2usl.usl_id,
                                     recpon2usl.dat_poc, 
                                     recpon2usl.dat_zav, 
                                     NVL(br_dana_boravka_p, 
                                         recpon2usl.dat_zav - recpon2usl.dat_poc + 1))                  stopa_popusta2_zmp,
            pra_rec_s4.stopa_zmppop (recpon2.zmppop3_id, 
                                     recpon2.so_id, 
                                     recpon2usl.vsj_id, 
                                     recpon2usl.usl_id, 
                                     recpon2usl.dat_poc, 
                                     recpon2usl.dat_zav, 
                                     NVL(br_dana_boravka_p, 
                                         recpon2usl.dat_zav - recpon2usl.dat_poc + 1))                  stopa_popusta3_zmp,
            pra_rec_s4.stopa_zmppop (recpon2.zmppop4_id,
                                     recpon2.so_id, 
                                     recpon2usl.vsj_id,
                                     recpon2usl.usl_id,
                                     recpon2usl.dat_poc, 
                                     recpon2usl.dat_zav, 
                                     NVL(br_dana_boravka_p, 
                                         recpon2usl.dat_zav - recpon2usl.dat_poc + 1))                  stopa_popusta4_zmp
       FROM trec_ponude2 recpon2,
            trec_pon2_usl recpon2usl,
            s_usluge usl
      WHERE recpon2.id = recpon2_id_p
        AND recpon2usl.recpon2_id = recpon2.id
        AND usl.id = recpon2usl.usl_id)
  LOOP
    -- slobodno mjesto
    izn_pon2usl_smjesta_l := uslpop_c.osnusl * uslpop_c.obr_smjesta * uslpop_c.ozn_smjesta;
    br_smjesta_l := br_smjesta_l + uslpop_c.obr_smjesta * uslpop_c.ozn_smjesta;
    
    -- popust 1
    IF uslpop_c.stopa_popusta1 IS NOT NULL THEN
      izn_pon2usl_popust1_l := ROUND((uslpop_c.osnusl - 
                                      izn_pon2usl_smjesta_l) * 
                                     uslpop_c.obr_popusta1 *
                                     uslpop_c.stopa_popusta1 / 100
                                    , 2);
    
    ELSIF uslpop_c.stopa_popusta1_zmp IS NOT NULL THEN
      izn_pon2usl_popust1_l := ROUND((uslpop_c.osnusl - 
                                      izn_pon2usl_smjesta_l) * 
                                     uslpop_c.stopa_popusta1_zmp / 100
                                    , 2);
    END IF;
    
    -- popust 2
    IF uslpop_c.stopa_popusta2 IS NOT NULL THEN
      izn_pon2usl_popust2_l := ROUND((uslpop_c.osnusl - 
                                      izn_pon2usl_smjesta_l - 
                                      izn_pon2usl_popust1_l) *
                                     uslpop_c.obr_popusta2 *
                                     uslpop_c.stopa_popusta2 / 100
                                    , 2);
    
    ELSIF uslpop_c.stopa_popusta2_zmp IS NOT NULL THEN
      izn_pon2usl_popust2_l := ROUND((uslpop_c.osnusl - 
                                      izn_pon2usl_smjesta_l- 
                                      izn_pon2usl_popust1_l) * 
                                    uslpop_c.stopa_popusta2_zmp / 100
                                    , 2);
    END IF;

    -- popust 3
    IF uslpop_c.stopa_popusta3 IS NOT NULL THEN
      izn_pon2usl_popust3_l := ROUND((uslpop_c.osnusl - 
                                      izn_pon2usl_smjesta_l - 
                                      izn_pon2usl_popust1_l - 
                                      izn_pon2usl_popust2_l) *
                                     uslpop_c.obr_popusta3 *
                                     uslpop_c.stopa_popusta3 / 100
                                    , 2);
    
    ELSIF uslpop_c.stopa_popusta3_zmp IS NOT NULL THEN
      izn_pon2usl_popust3_l := ROUND((uslpop_c.osnusl - 
                                      izn_pon2usl_smjesta_l- 
                                      izn_pon2usl_popust1_l - 
                                      izn_pon2usl_popust2_l) * 
                                     uslpop_c.stopa_popusta3_zmp / 100
                                    , 2);
    END IF;

    -- popust 4
    IF uslpop_c.stopa_popusta4 IS NOT NULL THEN
      izn_pon2usl_popust4_l := ROUND((uslpop_c.osnusl - 
                                      izn_pon2usl_smjesta_l - 
                                      izn_pon2usl_popust1_l - 
                                      izn_pon2usl_popust2_l - 
                                      izn_pon2usl_popust3_l) *
                                     uslpop_c.obr_popusta4 *
                                     uslpop_c.stopa_popusta4 / 100
                                    , 2);
    
    ELSIF uslpop_c.stopa_popusta4_zmp IS NOT NULL THEN
      izn_pon2usl_popust4_l := ROUND((uslpop_c.osnusl - 
                                      izn_pon2usl_smjesta_l - 
                                      izn_pon2usl_popust1_l - 
                                      izn_pon2usl_popust2_l - 
                                      izn_pon2usl_popust3_l) * 
                                     uslpop_c.stopa_popusta4_zmp / 100
                                    , 2);
    END IF;

    izn_pon2_smjesta_l := izn_pon2_smjesta_l + izn_pon2usl_smjesta_l;
    izn_pon2_popust1_l := izn_pon2_popust1_l + izn_pon2usl_popust1_l;
    izn_pon2_popust2_l := izn_pon2_popust2_l + izn_pon2usl_popust2_l;
    izn_pon2_popust3_l := izn_pon2_popust3_l + izn_pon2usl_popust3_l;
    izn_pon2_popust4_l := izn_pon2_popust4_l + izn_pon2usl_popust4_l;

    izn_pon2usl_smjesta_l := 0;
    izn_pon2usl_popust1_l := 0;
    izn_pon2usl_popust2_l := 0;
    izn_pon2usl_popust3_l := 0;
    izn_pon2usl_popust4_l := 0;

  END LOOP;

  izn_pon2_popust1_l := ROUND (izn_pon2_popust1_l, 2);
  izn_pon2_popust2_l := ROUND (izn_pon2_popust2_l, 2);
  izn_pon2_popust3_l := ROUND (izn_pon2_popust3_l, 2);
  izn_pon2_popust4_l := ROUND (izn_pon2_popust4_l, 2);

  izn_ponude_l := NVL (izn_pon2_bez_odb_l, 0) -
                  NVL (izn_pon2_smjesta_l, NVL (recpon2_c_l.izn_smjesta, 0)) -
                  NVL (izn_pon2_popust1_l, NVL (recpon2_c_l.izn_popusta1, 0)) -
                  NVL (izn_pon2_popust2_l, NVL (recpon2_c_l.izn_popusta2, 0)) -
                  NVL (izn_pon2_popust3_l, NVL (recpon2_c_l.izn_popusta3, 0)) -
                  NVL (izn_pon2_popust4_l, NVL (recpon2_c_l.izn_popusta4, 0));

  IF stopa_predujma_p IS NOT NULL THEN
    izn_pon2_predujma_l := ROUND (izn_ponude_l * stopa_predujma_p / 100, 2);
  ELSE
    izn_pon2_predujma_l := recpon2_c_l.izn_predujma;
  END IF;

  UPDATE trec_ponude2
     SET iznos = izn_ponude_l,
         stopa_predujma = stopa_predujma_p,
         izn_predujma = izn_pon2_predujma_l,
         -- br_smjesta = DECODE (br_smjesta_l, NULL, recpon2_c_l.br_smjesta, br_smjesta_l),
         -- izn_smjesta = DECODE (izn_pon2_smjesta_l, NULL, recpon2_c_l.izn_smjesta, izn_pon2_smjesta_l),
         izn_popusta1 = DECODE (NVL(stopa_popusta1, zmppop1_id), NULL, recpon2_c_l.izn_popusta1, izn_pon2_popust1_l),
         izn_popusta2 = DECODE (NVL(stopa_popusta2, zmppop2_id), NULL, recpon2_c_l.izn_popusta2, izn_pon2_popust2_l),
         izn_popusta3 = DECODE (NVL(stopa_popusta3, zmppop3_id), NULL, recpon2_c_l.izn_popusta3, izn_pon2_popust3_l),
         izn_popusta4 = DECODE (NVL(stopa_popusta4, zmppop4_id), NULL, recpon2_c_l.izn_popusta4, izn_pon2_popust4_l)
   WHERE id = recpon2_id_p;
END;
PROCEDURE VRATI_PON_REZ
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,REZ_ID_P IN T_REZERVACIJE.ID%TYPE
 ,RBR_P IN OUT T_REZERVACIJE.RBR%TYPE
 )
 IS
BEGIN
  EXECUTE IMMEDIATE
    'SELECT rbr FROM t_rezervacije' || metcvor_sifra_p || ' WHERE id = :id'
    INTO rbr_p USING rez_id_p;
END;
PROCEDURE PONISTI_REZ_DAT_OPCIJE
 (SO_ID_P IN T_REZERVACIJE.SO_ID%TYPE
 ,DAT_OPCIJE_P IN T_REZERVACIJE.DAT_OPCIJE%TYPE
 ,MS_ID_P IN T_REZERVACIJE.MS_ID%TYPE
 ,OZN_STOPBOOK_P IN NUMBER := 0
 )
 IS
-- Poniti nefiksirane rezervacije za promatrani SO do datuma opcije
BEGIN
  IF so_id_p IS NULL
    OR dat_opcije_p IS NULL
  THEN
    RETURN;
  END IF;

  FOR rez_c IN (
    SELECT rez.id AS id,
           (
           SELECT COUNT (id)
             FROM t_rez_vsj
            WHERE rez_id = rez.id
              AND (NVL (kol_sjz, 0) > 0 OR NVL (br_osobaz, 0) > 0)
           ) AS kol_rezvsj_iskoristeno -- IRN 2782
      FROM t_rezervacije rez
     WHERE rez.so_id = so_id_p
       AND rez.ms_id = NVL (ms_id_p, rez.ms_id)
       AND rez.dat_opcije IS NOT NULL
       AND rez.dat_opcije <= dat_opcije_p
       AND rez.oznaka = 'V'
       AND rez.ozn_vstorna IS NULL
       AND rez.ozn_f = 0
     ORDER BY rez.id)
  LOOP

    UPDATE t_rezervacije
       SET oznaka = 'P',       -- IRN 2782
           ozn_vstorna = '2',  -- nepotvreno (istekla opcija)
           dat_storna = SYSDATE
     WHERE id = rez_c.id
       AND rez_c.kol_rezvsj_iskoristeno = 0;  -- IRN 2782

    IF ozn_stopbook_p = -1 THEN
      pra_rec_iud3.rez_stopbook_pon (rez_c.id);
    END IF;

  END LOOP;

  COMMIT;
END;
PROCEDURE INSERT_TRO
 (REC_TRO_P IN T_TROSKOVI%ROWTYPE
 )
 IS
--
  rec_tro_l t_troskovi%ROWTYPE;
BEGIN
  rec_tro_l := rec_tro_p;
  rec_tro_l.id := NULL;
  rec_tro_l.izmjena_dat := NULL;
  rec_tro_l.izmjena_korisnik := NULL;

  -- IRN 2986; varijable unos_korisnik_g i unos_dat_g pune paketi pra_self_check_in i pra_self_ordering
  IF pra_rec_iud.unos_korisnik_g IS NOT NULL
    AND pra_rec_iud.unos_dat_g IS NOT NULL
  THEN
    rec_tro_l.unos_korisnik := pra_rec_iud.unos_korisnik_g; -- npr. Self-Check-in ili Self-ordering
    rec_tro_l.unos_dat      := pra_rec_iud.unos_dat_g;
  END iF;
  -- KRAJ IRN 2986

  INSERT INTO t_troskovi VALUES rec_tro_l;
END;
PROCEDURE PUNI_PREC_CJE_USL
 (PONSO_ID_P IN t_pon_so.id%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 ,USL_ID_P IN s_usluge.id%TYPE := NULL
 ,CJE_ID_P IN t_cjenici.id%TYPE := NULL
 ,SO_ID_P IN m_so.id%TYPE := NULL
 ,DAT_POC_P IN t_cje_usl.datum%TYPE := NULL
 ,DAT_ZAV_P IN t_cje_usl.datum%TYPE := NULL
 ,RECVPRO_ID_P IN mrec_vprograma.id%TYPE
 ,RECARA_ID_P IN mrec_aranzmani.id%TYPE := NULL
 )
 IS
/*
Procedura napuni pomonu tablicu cijena ovisno o poslanim parametrima.

Recvpro se koristi samo za odreivanje ponuenih cijena. Prema tom podatku se odreuje ponueni cjenik i
da li e se on nadjaati sa cijenama u recponcje.
Ako je poslana vrsta programa jednaka nekoj ponuenoj u dodatnim mogunostima
koja ima upisan cjenik onda se uzima taj cjenik (i ne nadjaava se).
Ako poslana vrsta programa nije popunjena ili takve nema u dodatnim mogunostima ili je ima ali uz nju nije naveden cjenik
onda se uzima cjenik iz zaglavlja ponude i nadjaava se sa cijenama u recponcje.
Tako odreene cijene iz ponude se nadjaavaju sa cijenama u rezervaciji (bez obzira na rezerviranu vrstu programa).

ponso + recvpro; ako je poslana vrsta programa jednaka nekoj ponuenoj u dodatnim mogunostima
koja ima upisan cjenik onda se uzima taj cjenik (i ne nadjaava se)
      - ponueni cjenik = ponrecvpro.cje_id
      - neponueni cjenik
      - poseban cjenik
ponso + recvpro; inae
      - ponueni cjenik (pon.cje_id) nadjaan sa cijenama iz ponso
      - neponueni cjenik
      - poseban cjenik
rez + recvpro,
    ako je rezervacija vezana na ponso
      - ponueni cjenik prema pravilima ponrecvpro nadjaan sa cijenama iz rez
      - neponueni cjenik
      - poseban cjenik
    ako rezervacija nije vezana na ponso
      - cjenik nadjaan sa cijenama iz rez
      - poseban cjenik
cje   - cjenik

ako je poslana usl puni se cjenik samo za tu usl inae za sve koje nae u cjeniku
ako je poslano razdoblje puni se cjenik za to razdoblje inae za razdoblje iz poslanog dokumenta
ako je poslan recara provjerava se da li je vaan za cijenu te usluge. Ako nije (ili ako usluga nije poslana) recara kao da nije poslan

Popust iz recvpro (ispravak IRN 1956)
ako traimo cijenu za troak onda se popust ita iz recvpro_id_p
inae
recvpro_id_p not null --> uzima se popust iz recvpro_id_p
recvpro_id_p null + rez_id_p not null --> popust iz rez.recvpro
recvpro_id_p null + rez_id_p null + ponso_id_p not null + pon.recvpro_id not null --> uzima se popust iz pon.recvpro
*/
  ponso_id_l t_pon_so.id%TYPE;
  pon_id_l   t_ponude.id%TYPE;
  cje_id1_l  t_cjenici.id%TYPE;
  cje_id2_l  t_cjenici.id%TYPE;
  cje_id3_l  t_cjenici.id%TYPE; -- poseban cjenik
  cje_id_pom_l  t_cjenici.id%TYPE; -- pomono polje u koje se privremeno puni cjenik
  so_id1_l   m_so.id%TYPE;
  so_id2_l   m_so.id%TYPE;
  dat_poc_l  DATE;
  dat_zav_l  DATE;
  ozn_cje_poseb_l t_ponude.ozn_cje_poseb%TYPE;
  recara_id_l mrec_aranzmani.id%TYPE;
  ozn_cje_ara_l mrec_ara_usl.ozn_cje_ara%TYPE;

  TYPE dat_poc_tab_type IS TABLE OF t_cje_usl.datum%TYPE INDEX BY BINARY_INTEGER;
  TYPE dat_zav_tab_type IS TABLE OF t_cje_usl.datum%TYPE INDEX BY BINARY_INTEGER;
  dat_poc_tab_l dat_poc_tab_type;
  dat_zav_tab_l dat_zav_tab_type;
  i NUMBER := 2;
  j NUMBER := 1;
  zadnji_l NUMBER := 1;

  CURSOR recrezcje_c (vsj_id_k NUMBER, usl_id_k NUMBER, recara_id_k NUMBER, dat_poc_k DATE) IS
    SELECT cijena_usluge
      FROM trec_rez_cjeusl
     WHERE rez_id = rez_id_p
       AND NVL (vsj_id, -1) = NVL (vsj_id_k, -1)
       AND usl_id = usl_id_k
       AND NVL (recara_id, -1) =  NVL (recara_id_k, -1)
       AND dat_poc_k BETWEEN dat_poc AND dat_zav;

  CURSOR recponcje_c (vsj_id_k NUMBER, usl_id_k NUMBER, recara_id_k NUMBER, dat_poc_k DATE,
                      ozn_nadjacaj_pon_cje_k NUMBER) IS
    SELECT cijena_usluge
      FROM trec_pon_cjeusl
     WHERE ozn_nadjacaj_pon_cje_k = -1 -- ponueni cjenik ne nadjaavamo uvijek
       AND ponso_id = ponso_id_l
       AND NVL (vsj_id, -1) = NVL (vsj_id_k, -1)
       AND usl_id = usl_id_k
       AND NVL (recara_id, -1) =  NVL (recara_id_k, -1)
       AND dat_poc_k BETWEEN dat_poc AND dat_zav;

  CURSOR cjeusl_c (vsj_id_k NUMBER, usl_id_k NUMBER, recara_id_k NUMBER, dat_poc_k DATE) IS
    SELECT cijena_usluge, cje_usl_obr
      FROM t_cje_usl
     WHERE cje_id = cje_id1_l
       AND so_id = so_id1_l
       AND NVL (vsj_id, -1) = NVL (vsj_id_k, -1)
       AND usl_id = usl_id_k
       AND NVL (recara_id, -1) =  NVL (recara_id_k, -1)
       AND datum <= NVL (dat_poc_k, datum)
     ORDER BY datum DESC;

  CURSOR recponvpro_c (ponso_id_k t_pon_so.id%TYPE, recvpro_id_k mrec_vprograma.id%TYPE) IS
    SELECT cje_id
      FROM trec_pon_vpro
     WHERE ponso_id = ponso_id_k AND recvpro_id = recvpro_id_k;

  CURSOR recarausl_c IS
    SELECT ozn_cje_ara FROM mrec_ara_usl WHERE usl_id = usl_id_p AND recara_id = recara_id_p;

  cijena_usluge_l  t_cje_usl.cijena_usluge%TYPE;
  cijena_usluge3_l t_cje_usl.cijena_usluge%TYPE;
  cje_usl_obr_l    t_cje_usl.cje_usl_obr%TYPE;
  ozn_ugo_l        prec_cje_usl.ozn_ugo%TYPE;
  ozn_cijene_l     prec_cje_usl.ozn_cijene%TYPE;
  ozn_nadjacaj_pon_cje_l NUMBER;

  recvpro_id_l mrec_vprograma.id%TYPE; -- recvpro iz pon odnosno rez za odreivanje sezona prema popustima.
  zmppop1_id_l mzmp_popusti.id%TYPE;   -- popust1 iz ponude
  zmppop2_id_l mzmp_popusti.id%TYPE;   -- popust2 iz rezervacije
  zmppop3_id_l mzmp_popusti.id%TYPE;   -- popust iz recvpro (iz rezervacije ili ponude)
  zmppop4_id_l mzmp_popusti.id%TYPE;   -- popust4 iz rezervacije ili ponude
BEGIN
  -- brii cijene
  DELETE FROM prec_cje_usl;

  IF (ponso_id_p IS NOT NULL AND rez_id_p IS NULL)
    OR (ponso_id_p IS NULL AND rez_id_p IS NOT NULL)
    OR (cje_id_p IS NOT NULL AND so_id_p IS NOT NULL AND dat_poc_p IS NOT NULL AND dat_zav_p IS NOT NULL)
  THEN
    -- samo jedan od ulaznih parametara ponso, rez moe biti NOT NULL
    -- PANJA. Uz rez_id je potrebno poslati i recvpro_id da bi se moglo odrediti ponuene cijene
    -- ako je cje_id_p NOT NULL onda moraju biti i ostali podaci potrebni za cjenik
    NULL;
  ELSE
    RETURN;
  END IF;

  IF usl_id_p IS NOT NULL AND recara_id_p IS NOT NULL THEN
    OPEN recarausl_c;
    FETCH recarausl_c INTO ozn_cje_ara_l;
    CLOSE recarausl_c;
  END IF;
  IF ozn_cje_ara_l = -1 THEN
    recara_id_l := recara_id_p;
  ELSE
    recara_id_l := NULL;
  END IF;

  IF rez_id_p IS NOT NULL THEN
    SELECT ponso_id, so_id, so_id, cje_id,
           recvpro_id,
           NVL (dat_poc_p, dat_dolaska), NVL (dat_zav_p, dat_odlaska), ozn_cje_poseb,
           zmppop2_id, zmppop4_id
      INTO ponso_id_l, so_id1_l, so_id2_l, cje_id2_l,
           recvpro_id_l,
           dat_poc_l, dat_zav_l, ozn_cje_poseb_l,
           zmppop2_id_l, zmppop4_id_l
      FROM t_rezervacije
     WHERE id = rez_id_p;
  ELSIF ponso_id_p IS NOT NULL THEN
    ponso_id_l := ponso_id_p;
  ELSIF cje_id_p IS NOT NULL THEN
    cje_id1_l := 0;
    cje_id2_l := cje_id_p;
    so_id2_l := so_id_p;
    dat_poc_l := dat_poc_p;
    dat_zav_l := dat_zav_p;
    ozn_ugo_l := 0;
    ozn_cje_poseb_l := 0;   -- ne igra ulogu jer je potrebno napuniti cijene samo za cje_id_p
    GOTO cje_izvan_ugo;     -- preskae prvi dio koji trai nadjaane cijene
  END IF;

  IF ponso_id_l IS NOT NULL THEN
    SELECT pon.id, pon.cje_id, NVL (cje_id2_l, pon.cje2_id), ponso.so_id, NVL (so_id2_l, ponso.so_id), -- IRN 1174
           -- NVL (recvpro_id_l, pon.recvpro_id), zmppop1_id, -- ispravak IRN 1956 pon.recvpro uzima samo ako traimo cijene za ponudu
           DECODE (rez_id_p, NULL, pon.recvpro_id, recvpro_id_l), zmppop1_id,
           NVL (dat_poc_l, NVL (dat_poc_p, NVL (ponso.dat_dol_min, ponso.dat_poc))), NVL (dat_zav_l, NVL (dat_zav_p, NVL (ponso.dat_odl_max, ponso.dat_zav))), NVL (ozn_cje_poseb_l, ozn_cje_poseb),
           DECODE (rez_id_p, NULL, pon.zmppop4_id, zmppop4_id_l)  -- kao recvpro, pop4 iz rezervacije je jai od pop4 iz ponude
      INTO pon_id_l, cje_id1_l, cje_id2_l, so_id1_l, so_id2_l,
           recvpro_id_l, zmppop1_id_l,
           dat_poc_l, dat_zav_l, ozn_cje_poseb_l,
           zmppop4_id_l
      FROM t_pon_so ponso, t_pon_ojr ponojr, t_ponude pon
     WHERE ponso.id = ponso_id_l
       AND ponso.ponojr_id = ponojr.id
       AND ponojr.pon_id = pon.id;
    ozn_nadjacaj_pon_cje_l := -1;
    IF recvpro_id_p IS NOT NULL THEN
      OPEN recponvpro_c (ponso_id_l, recvpro_id_p);
      FETCH recponvpro_c INTO cje_id_pom_l;
      CLOSE recponvpro_c;
      IF cje_id_pom_l IS NOT NULL THEN
        cje_id1_l := cje_id_pom_l;
        ozn_nadjacaj_pon_cje_l := 0;
      END IF;
    END IF;
  END IF;
  IF cje_id1_l IS NULL THEN
    -- rezervacija nevezana za ponudu/ugovor
    cje_id1_l := cje_id2_l;
    ozn_ugo_l := 0;
  ELSE
    ozn_ugo_l := -1;
  END IF;

  -- puni razdoblje
  dat_poc_tab_l (1) := dat_poc_l;
  FOR datum IN (
    SELECT datum -- cjenik - poetni datum
      FROM t_cje_usl
     WHERE cje_id = cje_id1_l
       AND so_id = so_id1_l
       AND usl_id = NVL (usl_id_p, usl_id)
       AND NVL (recara_id, -1) = NVL (NVL (recara_id_l, recara_id), -1)
       AND datum BETWEEN dat_poc_l + 1 AND dat_zav_l
    UNION
    SELECT dat_poc -- ponueni cjenik - poetni datum
      FROM trec_pon_cjeusl
     WHERE ozn_nadjacaj_pon_cje_l = -1 -- ponueni cjenik ne nadjaavamo za cjenike iz vrste programa
       AND ponso_id = ponso_id_l
       AND usl_id = NVL (usl_id_p, usl_id)
       AND NVL (recara_id, -1) = NVL (NVL (recara_id_l, recara_id), -1)
       AND dat_poc BETWEEN dat_poc_l + 1 AND dat_zav_l
    UNION
    SELECT dat_zav + 1 -- ponueni cjenik - novi poetni datumi
      FROM trec_pon_cjeusl
     WHERE ozn_nadjacaj_pon_cje_l = -1 -- ponueni cjenik ne nadjaavamo za cjenike iz vrste programa
       AND ponso_id = ponso_id_l
       AND usl_id = NVL (usl_id_p, usl_id)
       AND NVL (recara_id, -1) = NVL (NVL (recara_id_l, recara_id), -1)
       AND (dat_zav + 1) BETWEEN dat_poc_l + 1 AND dat_zav_l
    UNION
    SELECT dat_poc -- rezervirani cjenik - poetni datum
      FROM trec_rez_cjeusl
     WHERE rez_id = rez_id_p
       AND usl_id = NVL (usl_id_p, usl_id)
       AND NVL (recara_id, -1) = NVL (NVL (recara_id_l, recara_id), -1)
       AND dat_poc BETWEEN dat_poc_l + 1 AND dat_zav_l
    UNION
    SELECT dat_zav + 1 -- rezervirani cjenik - novi poetni datumi
      FROM trec_rez_cjeusl
     WHERE rez_id = rez_id_p
       AND usl_id = NVL (usl_id_p, usl_id)
       AND NVL (recara_id, -1) = NVL (NVL (recara_id_l, recara_id), -1)
       AND (dat_zav + 1) BETWEEN dat_poc_l + 1 AND dat_zav_l
     ORDER BY 1)
  LOOP
    dat_zav_tab_l (j) := datum.datum;
    dat_poc_tab_l (i) := datum.datum;
    j := j + 1;
    i := i + 1;
    zadnji_l := j;
  END LOOP;
  dat_zav_tab_l (zadnji_l) := dat_zav_l;

  /*
  FOR k IN 1 .. zadnji_l
  LOOP
    DBMS_OUTPUT.PUT_LINE (dat_poc_tab_l (k) || ', ' || dat_zav_tab_l (k));
  END LOOP;
  */

  FOR vsjusl_c IN (
    SELECT DISTINCT vsj_id, usl_id, recara_id
      FROM (
           SELECT p.vsj_id, p.usl_id, p.recara_id -- cjenik
             FROM t_cje_usl p
            WHERE p.cje_id = cje_id1_l
              AND p.so_id = so_id1_l
              AND p.usl_id = NVL (usl_id_p, p.usl_id)
              AND NVL (p.recara_id, -1) = NVL (NVL (recara_id_l, p.recara_id), -1)
              AND p.datum BETWEEN (
                    SELECT
                      NVL (MAX (datum), p.datum)
                    FROM
                      t_cje_usl
                    WHERE
                      cje_id = cje_id1_l
                      AND so_id = so_id1_l
                      AND NVL (vsj_id, -1) = NVL (p.vsj_id, -1)
                      AND usl_id = p.usl_id
                      AND NVL (recara_id, -1) = NVL (p.recara_id, -1)
                      AND datum <= dat_poc_l)
                  AND dat_zav_l
           UNION
           SELECT p.vsj_id, p.usl_id, p.recara_id  -- rezervirani cjenik
             FROM trec_rez_cjeusl p
            WHERE p.rez_id = rez_id_p
              AND p.usl_id = NVL (usl_id_p, p.usl_id)
              AND NVL (p.recara_id, -1) = NVL (NVL (recara_id_l, p.recara_id), -1)
              AND p.dat_poc BETWEEN (
                    SELECT
                      NVL (MAX (dat_poc), p.dat_poc)
                    FROM
                      trec_rez_cjeusl
                    WHERE
                      rez_id = rez_id_p
                      AND NVL (vsj_id, -1) = NVL (p.vsj_id, -1)
                      AND usl_id = p.usl_id
                      AND NVL (recara_id, -1) = NVL (p.recara_id, -1)
                      AND dat_poc <= dat_poc_l)
                  AND dat_zav_l
           UNION
           SELECT p.vsj_id, p.usl_id, recara_id -- ponueni cjenik
             FROM trec_pon_cjeusl p
            WHERE ozn_nadjacaj_pon_cje_l = -1 -- ponueni cjenik ne nadjaavamo za cjenike iz vrste programa
              AND p.ponso_id = ponso_id_l
              AND p.usl_id = NVL (usl_id_p, p.usl_id)
              AND NVL (p.recara_id, -1) = NVL (NVL (recara_id_l, p.recara_id), -1)
              AND p.dat_poc BETWEEN (
                    SELECT
                      NVL (MAX (dat_poc), p.dat_poc)
                    FROM
                      trec_pon_cjeusl
                    WHERE
                      ponso_id = ponso_id_l
                      AND NVL (vsj_id, -1) = NVL (p.vsj_id, -1)
                      AND usl_id = p.usl_id
                      AND NVL (recara_id, -1) = NVL (p.recara_id, -1)
                      AND dat_poc <= dat_poc_l)
                  AND dat_zav_l
           )
     WHERE usl_id IS NOT NULL
     ORDER BY vsj_id, usl_id
    )
  LOOP
    FOR k IN dat_zav_tab_l.FIRST .. dat_zav_tab_l.LAST
    LOOP
      /*
      DBMS_OUTPUT.PUT_LINE (vsjusl_c.vsj_id || ', ' || vsjusl_c.usl_id || ', ' || dat_poc_tab_l (k) || ', ' || dat_zav_tab_l (k));
      */
      cijena_usluge_l  := NULL;
      cijena_usluge3_l := NULL;
      cje_usl_obr_l    := NULL;
      ozn_cijene_l     := NULL; -- 1 = iz rezervacije, 2 = iz ponude/ugovora, 3 = iz cjenika ili 4 = posebna
      -- nai cje_usl_obr
      OPEN cjeusl_c (vsjusl_c.vsj_id, vsjusl_c.usl_id, vsjusl_c.recara_id, dat_poc_tab_l (k));
      FETCH cjeusl_c INTO cijena_usluge3_l, cje_usl_obr_l;
      CLOSE cjeusl_c;
      -- nai rezerviranu cijenu
      OPEN recrezcje_c (vsjusl_c.vsj_id, vsjusl_c.usl_id, vsjusl_c.recara_id, dat_poc_tab_l (k));
      FETCH recrezcje_c INTO cijena_usluge_l;
      CLOSE recrezcje_c;
      IF cijena_usluge_l IS NOT NULL THEN
        ozn_cijene_l := 1;
      ELSE
        -- nai ponuenu cijenu
        OPEN recponcje_c (vsjusl_c.vsj_id, vsjusl_c.usl_id, vsjusl_c.recara_id, dat_poc_tab_l (k), ozn_nadjacaj_pon_cje_l);
        FETCH recponcje_c INTO cijena_usluge_l;
        CLOSE recponcje_c;
        IF cijena_usluge_l IS NOT NULL THEN
          ozn_cijene_l := 2;
        END IF;
      END IF;
      IF cijena_usluge_l IS NOT NULL THEN
        INSERT INTO prec_cje_usl (
            cje_id, so_id, vsj_id, usl_id, recara_id, dat_poc, dat_zav, cijena_usluge, cje_usl_obr, ozn_ugo, ozn_cijene)
          VALUES (
            cje_id1_l, so_id1_l, vsjusl_c.vsj_id, vsjusl_c.usl_id, vsjusl_c.recara_id, dat_poc_tab_l (k), dat_zav_tab_l (k), cijena_usluge_l, cje_usl_obr_l, ozn_ugo_l, ozn_cijene_l);
      ELSIF cijena_usluge3_l IS NOT NULL THEN
        INSERT INTO prec_cje_usl (
            cje_id, so_id, vsj_id, usl_id, recara_id, dat_poc, dat_zav, cijena_usluge, cje_usl_obr, ozn_ugo, ozn_cijene)
          VALUES (
            cje_id1_l, so_id1_l, vsjusl_c.vsj_id, vsjusl_c.usl_id, vsjusl_c.recara_id, dat_poc_tab_l (k), dat_zav_tab_l (k), cijena_usluge3_l, cje_usl_obr_l, ozn_ugo_l, 3);
      ELSE
        INSERT INTO prec_cje_usl (
            cje_id, so_id, vsj_id, usl_id, recara_id, dat_poc, dat_zav, cijena_usluge, cje_usl_obr, ozn_ugo, ozn_cijene)
          VALUES (
            cje_id1_l, so_id1_l, vsjusl_c.vsj_id, vsjusl_c.usl_id, vsjusl_c.recara_id, dat_poc_tab_l (k), dat_zav_tab_l (k), 0, NULL, ozn_ugo_l, 4);
      END IF;
    END LOOP; -- razdoblja
  END LOOP; -- usluge i vrste SJ


  -- cijene iz cjenika za usluge izvan ponude/ugovora
  <<cje_izvan_ugo>>
  IF cje_id2_l IS NOT NULL AND (ozn_ugo_l = -1 OR cje_id2_l <> cje_id1_l) THEN
    INSERT INTO prec_cje_usl (
        cje_id, so_id, vsj_id, usl_id, recara_id, dat_poc,
        dat_zav,
        cijena_usluge, cje_usl_obr, ozn_ugo, ozn_cijene)
      SELECT
        p.cje_id, p.so_id, p.vsj_id, p.usl_id, p.recara_id, p.datum,
        (
        SELECT NVL (MIN (z.datum), dat_zav_l)
           FROM t_cje_usl z
          WHERE z.cje_id = p.cje_id
            AND z.so_id = p.so_id
            AND NVL (z.vsj_id, -1) = NVL (p.vsj_id, -1)
            AND z.usl_id = p.usl_id
            AND NVL (z.recara_id, -1) = NVL (p.recara_id, -1)
            AND z.datum > p.datum
        ) AS dat_zav,
        p.cijena_usluge, p.cje_usl_obr, 0, 3 -- cijena iz cjenika
      FROM
        t_cje_usl p
      WHERE
        p.cje_id = cje_id2_l
        AND p.so_id = so_id2_l
        AND p.usl_id = NVL (usl_id_p, p.usl_id)
        AND NVL (p.recara_id, -1) = NVL (NVL (recara_id_l, p.recara_id), -1)
        AND p.datum
            BETWEEN (
              SELECT
                NVL (MAX (datum), p.datum)
              FROM
                t_cje_usl
              WHERE
                cje_id = cje_id2_l
                AND so_id = so_id2_l
                AND NVL (vsj_id, -1) = NVL (p.vsj_id, -1)
                AND usl_id = p.usl_id
                AND NVL (recara_id, -1) = NVL (p.recara_id, -1)
                AND datum <= dat_poc_l)
            AND dat_zav_l;
  END IF;

  -- poseban cjenik
  IF ozn_cje_poseb_l = -1 THEN
    cje_id3_l := pra_rec_s.bp_cje_id (cje_id1_l);
    IF cje_id3_l <> cje_id1_l THEN
      INSERT INTO prec_cje_usl (
          cje_id, so_id, vsj_id, usl_id, recara_id, dat_poc,
          dat_zav,
          cijena_usluge, cje_usl_obr, ozn_ugo, ozn_cijene)
        SELECT
          p.cje_id, p.so_id, p.vsj_id, p.usl_id, p.recara_id, p.datum,
          (
          SELECT NVL (MIN (z.datum), dat_zav_l)
             FROM t_cje_usl z
            WHERE z.cje_id = p.cje_id
              AND z.so_id = p.so_id
              AND NVL (z.vsj_id, -1) = NVL (p.vsj_id, -1)
              AND z.usl_id = p.usl_id
              AND NVL (z.recara_id, -1) = NVL (p.recara_id, -1)
              AND z.datum > p.datum
          ) AS dat_zav,
          p.cijena_usluge, p.cje_usl_obr, ozn_ugo_l, 3 -- cijena iz cjenika
        FROM
          t_cje_usl p,
          s_usluge usl
        WHERE
          p.cje_id = cje_id3_l
          AND p.so_id = so_id1_l
          AND p.usl_id = NVL (usl_id_p, p.usl_id)
          AND NVL (p.recara_id, -1) = NVL (NVL (recara_id_l, p.recara_id), -1)
          AND p.datum
              BETWEEN (
                SELECT
                  NVL (MAX (datum), p.datum)
                FROM
                  t_cje_usl
                WHERE
                  cje_id = cje_id3_l
                  AND so_id = so_id1_l
                  AND NVL (vsj_id, -1) = NVL (p.vsj_id, -1)
                  AND usl_id = p.usl_id
                  AND NVL (recara_id, -1) = NVL (p.recara_id, -1)
                  AND datum <= dat_poc_l)
              AND dat_zav_l
          AND p.usl_id = usl.id
          AND usl.ozn_cje_poseb = -1;
    END IF;
    IF cje_id2_l IS NOT NULL AND ozn_ugo_l = -1 THEN
      cje_id3_l := pra_rec_s.bp_cje_id (cje_id2_l);
      IF cje_id3_l <> cje_id2_l THEN
        INSERT INTO prec_cje_usl (
            cje_id, so_id, vsj_id, usl_id, recara_id, dat_poc,
            dat_zav,
            cijena_usluge, cje_usl_obr, ozn_ugo, ozn_cijene)
          SELECT
            p.cje_id, p.so_id, p.vsj_id, p.usl_id, p.recara_id, p.datum,
            (
            SELECT NVL (MIN (z.datum), dat_zav_l)
               FROM t_cje_usl z
              WHERE z.cje_id = p.cje_id
                AND z.so_id = p.so_id
                AND NVL (z.vsj_id, -1) = NVL (p.vsj_id, -1)
                AND z.usl_id = p.usl_id
                AND NVL (z.recara_id, -1) = NVL (p.recara_id, -1)
                AND z.datum > p.datum
            ) AS dat_zav,
            p.cijena_usluge, p.cje_usl_obr, 0, 3 -- izvan ugovora, cijena iz cjenika
          FROM
            t_cje_usl p,
            s_usluge usl
          WHERE
            p.cje_id = cje_id3_l
            AND p.so_id = so_id2_l
            AND p.usl_id = NVL (usl_id_p, p.usl_id)
            AND NVL (p.recara_id, -1) = NVL (NVL (recara_id_l, p.recara_id), -1)
            AND p.datum
                BETWEEN (
                  SELECT
                    NVL (MAX (datum), p.datum)
                  FROM
                    t_cje_usl
                  WHERE
                    cje_id = cje_id3_l
                    AND so_id = so_id2_l
                    AND NVL (vsj_id, -1) = NVL (p.vsj_id, -1)
                    AND usl_id = p.usl_id
                    AND NVL (recara_id, -1) = NVL (p.recara_id, -1)
                    AND datum <= dat_poc_l)
                AND dat_zav_l
            AND p.usl_id = usl.id
            AND usl.ozn_cje_poseb = -1;
      END IF;
    END IF;
  END IF;

  -- IRN 3933 spajanje razdoblja u prec_cje_usl sa istom cijenom  
  pra_rec_iud.sazmi_prec_cje_usl;

  -- podijeliti razdoblja u prec_cje_usl prema razdobljima u popustima

  -- zmppop1_id (iz ponude)
  pra_rec_iud.puni_prec_cje_usl_dijeli (zmppop1_id_l);

  -- zmppop2_id (iz rezervacije)
  pra_rec_iud.puni_prec_cje_usl_dijeli (zmppop2_id_l);

  -- zmppop3_id iz vrste programa
  -- iz dokumenta (rez, pon) imamo recvpro_id_l. On vrijedi ako traimo cijene za dokument a recvpro_id_p nije poslan.
  -- Ako traimo cijenu za troak treba uzeti recvpro iz gosta odnosno troka. To smo dobili u recvpro_id_p a prepoznamo po popunjenom cje_id_p
  IF recvpro_id_p IS NOT NULL OR cje_id_p IS NOT NULL THEN
    recvpro_id_l := recvpro_id_p;
  END IF;
  IF recvpro_id_l IS NOT NULL THEN
    SELECT zmppop_id INTO zmppop3_id_l FROM mrec_vprograma where id = recvpro_id_l;
  END IF;
  pra_rec_iud.puni_prec_cje_usl_dijeli (zmppop3_id_l);

  -- zmppop4_id (iz rezervacije ili ponude)
  pra_rec_iud.puni_prec_cje_usl_dijeli (zmppop4_id_l);

END;
PROCEDURE IZRADI_PON_RECREZ2
 (PON_ID_P IN t_ponude.id%TYPE
 ,BR_REDAKA_P IN OUT NUMBER
 )
 IS
--
  CURSOR ponojr_c (pon_id_p IN t_ponude.id%TYPE) IS
    SELECT DISTINCT pra_zmp_s.metcvor_sifra_ojr(zmpojr_id)
      FROM t_pon_ojr ponojr
     WHERE ponojr.pon_id = pon_id_p
       AND ponojr.id IN (SELECT ponojr_id
                           FROM t_pon_pros
                          UNION
                         SELECT ponojr_id
                           FROM t_pon_opr);
    CURSOR pon_c (pon_id_p IN t_ponude.id%TYPE) IS
    SELECT pon.oznaka
      FROM t_ponude pon
     WHERE pon.id = pon_id_p;
  oznaka_l        t_ponude.oznaka%TYPE;
  apl_sif_const CONSTANT smet_aplikacije.sifra%TYPE := 'REC';
  metcvor_sifra_l smet_cvorovi.sifra%TYPE;
  brojac_l number;
  brojac2_l number;
  test_l number;
  command_l VARCHAR2(1000);
BEGIN
  /* samo centar aurira po mrei */
  IF pra_zmp_zaj.centar = 0 THEN
    RETURN;
  END IF;
  IF pon_id_p IS NULL THEN
    RETURN;
  END IF;
  OPEN pon_c (pon_id_p);
  FETCH pon_c INTO oznaka_l;
  CLOSE pon_c;
  IF oznaka_l <> 'V' THEN
    RETURN;
  END IF;
  OPEN ponojr_c (pon_id_p);
  FETCH ponojr_c  INTO metcvor_sifra_l;
  WHILE ponojr_c%FOUND LOOP
    /* ako je vor tekui, upisuje slog u svoje tablice */
    IF metcvor_sifra_l = pra_zmp_zaj.tekuci_cvor THEN
      pra_rec_iud.izradi_pon_recrez2_objekt(pon_id_p, brojac_l);
    ELSE
      IF metcvor_sifra_l IS NOT NULL THEN
      /* ako vor nije u mrei, javlja greku */
        SELECT COUNT (1)
          INTO test_l
          FROM smet_cvorovi
         WHERE sifra = metcvor_sifra_l
           AND ozn_u_mrezi = -1;
        IF test_l = 0 THEN
          pra_rec_zaj.vrati_poruku (-20230);
          RETURN;
        END IF;
        /* ako vor nema aplikaciju REC, javlja greku */
        SELECT COUNT (1) INTO test_l
          FROM smet_instalacije
         WHERE metapl_sifra  = apl_sif_const
           AND metcvor_sifra = metcvor_sifra_l;
        IF test_l = 0 THEN
          pra_rec_zaj.vrati_poruku (-20231);
          RETURN;
        END IF;
        metcvor_sifra_l := '@' || metcvor_sifra_l;
        command_l := 'call pra_rec_iud.izradi_pon_recrez2_objekt<CVOR>(:pon_id_p, :brojac2_l)';
        EXECUTE IMMEDIATE REPLACE (command_l, '<CVOR>', metcvor_sifra_l)
          USING IN pon_id_p, IN OUT brojac2_l;
        brojac_l := NVL(brojac_l,0) + brojac2_l;
      END IF;
    END IF;
    FETCH ponojr_c  INTO metcvor_sifra_l;
  END LOOP;
  CLOSE ponojr_c;
  COMMIT;
  br_redaka_p := brojac_l;
END;
PROCEDURE IZRADI_PON_RECREZ2_OBJEKT
 (PON_ID_P IN t_ponude.id%TYPE
 ,BR_REDAKA_P IN OUT NUMBER
 )
 IS
--
  CURSOR usl_c (usl_id_p NUMBER) IS
    SELECT ozn_cje_poseb
      FROM s_usluge
     WHERE id = usl_id_p;
  CURSOR cjep_c IS
    SELECT cje.id, val_id
      FROM t_cjenici cje
     WHERE cje.sifra = pra_rec_zaj.vrijednost_parametra ('1068');
  CURSOR pon_c (pon_id_p NUMBER) IS
    SELECT cje.id, cje.val_id, pon.ozn_cje_poseb
      FROM t_ponude pon, t_cjenici cje
     WHERE pon.id = pon_id_p
       AND pon.cje_id = cje.id;
  CURSOR so_c (ponojr_id_p NUMBER) IS
  SELECT so.id
    FROM t_pon_so ponso, m_so so
   WHERE so.id = so_id
     AND ponso.ponojr_id = ponojr_id_p
   ORDER BY ponso.ozn_glavni, sifra;
  so_id_l m_so.id%TYPE;
  ozn_cje_poseb_l NUMBER;
  val_id_l s_valute.id%TYPE;
  cje_id_l t_cjenici.id%TYPE;
  pon_ozn_cje_poseb_l NUMBER;
  pon_val_id_l s_valute.id%TYPE;
  pon_cje_id_l t_cjenici.id%TYPE;
  valp_id_l s_valute.id%TYPE;
  cjep_id_l t_cjenici.id%TYPE;
  brojac_l NUMBER := br_redaka_p;
BEGIN
  OPEN pon_c (pon_id_p);
  FETCH pon_c INTO pon_cje_id_l, pon_val_id_l, pon_ozn_cje_poseb_l;
  CLOSE pon_c;
  OPEN cjep_c;
  FETCH cjep_c INTO cjep_id_l, valp_id_l;
  CLOSE cjep_c;
  FOR ponpros IN (
    SELECT ponojr.id ponojr_id, ponojr.zmpojr_id, zmppros_id, ponpros.id ponpros_id, usl_id, zmpvpos_id,
           dat_poc, sat_poc, dat_zav, sat_zav,
           br_osoba, br_jed_trajanja, kolicina, cijena, napomena
      FROM t_pon_pros ponpros, t_pon_ojr ponojr
     WHERE ponpros.ponojr_id = ponojr.id
       AND ponojr.pon_id = pon_id_p
       AND ozn_statusa NOT IN (2, 4)
       AND ponpros.id NOT IN (SELECT ponpros_id FROM trec_rez2_pros WHERE ponpros_id IS NOT NULL AND oznaka = 'V'))
  LOOP
    OPEN so_c (ponpros.ponojr_id);
    FETCH so_c INTO so_id_l;
    CLOSE so_c;
    cje_id_l := pon_cje_id_l;
    val_id_l := pon_val_id_l;
    OPEN usl_c (ponpros.usl_id);
    FETCH usl_c INTO ozn_cje_poseb_l;
    CLOSE usl_c;
    -- Poseban cjenik
    IF ozn_cje_poseb_l = -1  AND pon_ozn_cje_poseb_l = -1
      AND UPPER (pra_rec_zaj.vrijednost_parametra ('1068')) <> 'NEBITNO'
    THEN
      cje_id_l := cjep_id_l;
      val_id_l := valp_id_l;
    END IF;
    INSERT INTO trec_rez2_pros (
        oznaka, ozn_statusa, zmpojr_id, zmppros_id, ponpros_id, usl_id, zmpvpos_id,
        so_id, cje_id, val_id, dat_poc, sat_poc, dat_zav, sat_zav,
        br_osoba, br_jed_trajanja, kolicina, cijena, napomena)
      VALUES (
        'V', '3', ponpros.zmpojr_id, ponpros.zmppros_id, ponpros.ponpros_id, ponpros.usl_id, ponpros.zmpvpos_id,
        so_id_l, cje_id_l, val_id_l, ponpros.dat_poc, ponpros.sat_poc, ponpros.dat_zav, ponpros.sat_zav,
        ponpros.br_osoba, ponpros.br_jed_trajanja, ponpros.kolicina, ponpros.cijena, ponpros.napomena);
    brojac_l := NVL (brojac_l,0) + 1;
  END LOOP;
  FOR ponopr IN (
    SELECT ponojr.id ponojr_id, ponojr.zmpojr_id, zmpopr_id, ponopr.id ponopr_id, usl_id,
           dat_poc, sat_poc, dat_zav, sat_zav,
           br_jed_trajanja, kolicina, cijena, napomena
      FROM t_pon_opr ponopr, t_pon_ojr ponojr
     WHERE ponopr.ponojr_id = ponojr.id
       AND ponojr.pon_id = pon_id_p
       AND ozn_statusa NOT IN (2, 4)
       AND ponopr.id NOT IN (SELECT ponopr_id FROM trec_rez2_opr WHERE ponopr_id IS NOT NULL AND oznaka = 'V'))
  LOOP
    OPEN so_c (ponopr.ponojr_id);
    FETCH so_c INTO so_id_l;
    CLOSE so_c;
    cje_id_l := pon_cje_id_l;
    val_id_l := pon_val_id_l;
    OPEN usl_c (ponopr.usl_id);
    FETCH usl_c INTO ozn_cje_poseb_l;
    CLOSE usl_c;
    -- Poseban cjenik
    IF ozn_cje_poseb_l = -1  AND pon_ozn_cje_poseb_l = -1
      AND UPPER (pra_rec_zaj.vrijednost_parametra ('1068')) <> 'NEBITNO'
    THEN
      cje_id_l := cjep_id_l;
      val_id_l := valp_id_l;
    END IF;
    INSERT INTO trec_rez2_opr (
        oznaka, ozn_statusa, zmpojr_id, zmpopr_id, ponopr_id, usl_id,
        so_id, cje_id, val_id, dat_poc, sat_poc, dat_zav, sat_zav,
        br_jed_trajanja, kolicina, cijena, napomena)
      VALUES (
        'V', '3', ponopr.zmpojr_id, ponopr.zmpopr_id, ponopr.ponopr_id, ponopr.usl_id,
        so_id_l, cje_id_l, val_id_l, ponopr.dat_poc, ponopr.sat_poc, ponopr.dat_zav, ponopr.sat_zav,
        ponopr.br_jed_trajanja, ponopr.kolicina, ponopr.cijena, ponopr.napomena);
    brojac_l := NVL (brojac_l,0) + 1;
  END LOOP;
  br_redaka_p := brojac_l;
END;
PROCEDURE VRATI_PODATKE_ZA_CJE
 (TRO_PONSO_ID_P IN t_pon_so.id%TYPE
 ,TRO_GOSTK_ID_P IN t_gosti.id%TYPE
 ,TRO_USL_ID_P IN s_usluge.id%TYPE
 ,TRO_CJE_ID_P IN t_cjenici.id%TYPE
 ,TRO_SO_ID_P IN m_so.id%TYPE
 ,PONSO_ID_P OUT t_pon_so.id%TYPE
 ,REZ_ID_P OUT t_rezervacije.id%TYPE
 ,CJE_ID_P OUT t_cjenici.id%TYPE
 ,SO_ID_P OUT m_so.id%TYPE
 ,TRO_RECVPRO_ID_P IN mrec_vprograma.id%TYPE
 )
 IS
-- procedura se poziva prije punjenja prec_cje_usl i upisa u troak da bi napunila parametre potrebne za te dvije procedure
-- za punjenje prec_cje_usl su potrebni dokumenti (ponso, rez) a napuni se za sve cjenike, za upis u troak treba znati konkretan cjenik koji se vraa (cje_id_p)
-- ako je tro ponuen vrijedi cjenik iz ponso (!recvpro) nadjaan sa rez ako je rez vezana na isti ponso
-- ako je tro neponuen vrijedi poslani cjenik nadjaan sa rez ako je gost korisnik vezan na rez
   -- sa istim cjenikom i istim so bez pon
-- ako nije poslan cjenik podrazumjeva se cjenik iz gosta
  rez_ponso_id_l t_pon_so.id%TYPE;
  rez_rez_id_l t_rezervacije.id%TYPE;
  rez_cje_id_l  t_cjenici.id%TYPE;
  rez_ozn_cje_poseb_l t_rezervacije.ozn_cje_poseb%TYPE;
  rez_so_id_l t_rezervacije.so_id%TYPE;
  gost_cje_id_l  t_cjenici.id%TYPE;
  ozn_cje_poseb_l t_rezervacije.ozn_cje_poseb%TYPE;
  ozn_usl_poseb_l NUMBER;
  pon_id_l t_ponude.id%TYPE;
  cje_id_pom_l t_cjenici.id%TYPE;

  CURSOR rez_c (gost_id_k t_troskovi.gost_id%TYPE) IS
    SELECT rez.id, rez.ponso_id, rez.cje_id, rez.so_id, rez.ozn_cje_poseb, gost.cje_id
      FROM t_rezervacije rez,
           t_rez_vsj rezvsj,
           t_gosti gost
     WHERE gost.id = gost_id_k
       AND gost.rezvsj_id = rezvsj.id (+)
       AND rezvsj.rez_id = rez.id (+);

  CURSOR recponvpro_c (ponso_id_k t_pon_so.id%TYPE) IS
    SELECT cje_id
      FROM trec_pon_vpro
     WHERE ponso_id = ponso_id_k AND recvpro_id = tro_recvpro_id_p;
BEGIN
  SELECT MIN (ozn_cje_poseb) INTO ozn_usl_poseb_l FROM s_usluge WHERE id = tro_usl_id_p;

  -- ako je korisnik troka gost vani su podaci iz rezervacije
  -- ako nije poslan cjenik podrazumjeva se cjenik iz gosta
  IF tro_gostk_id_p IS NOT NULL THEN
    OPEN rez_c (tro_gostk_id_p);
    FETCH rez_c INTO rez_rez_id_l, rez_ponso_id_l, rez_cje_id_l, rez_so_id_l,
                     rez_ozn_cje_poseb_l, gost_cje_id_l;
    CLOSE rez_c;
  END IF;
  -- ponuena usluga
  IF tro_ponso_id_p IS NOT NULL THEN
    SELECT pon.id, pon.cje_id, ponso.so_id, ozn_cje_poseb
      INTO pon_id_l, cje_id_p, so_id_p, ozn_cje_poseb_l
      FROM t_pon_so ponso, t_pon_ojr ponojr, t_ponude pon
     WHERE ponso.id = tro_ponso_id_p
       AND ponso.ponojr_id = ponojr.id
       AND ponojr.pon_id = pon.id;
    IF tro_recvpro_id_p IS NOT NULL THEN
      OPEN recponvpro_c (tro_ponso_id_p);
      FETCH recponvpro_c INTO cje_id_pom_l;
      CLOSE recponvpro_c;
      IF cje_id_pom_l IS NOT NULL THEN
        cje_id_p := cje_id_pom_l;
      END IF;
  END IF;
    IF tro_ponso_id_p = NVL (rez_ponso_id_l, 0) THEN
      rez_id_p := rez_rez_id_l;
      IF rez_ozn_cje_poseb_l = -1 AND ozn_usl_poseb_l = -1 THEN
        cje_id_p := pra_rec_s.bp_cje_id (cje_id_p);
      END IF;
    ELSE
      ponso_id_p := tro_ponso_id_p;
      IF ozn_cje_poseb_l = -1 AND ozn_usl_poseb_l = -1 THEN
        cje_id_p := pra_rec_s.bp_cje_id (cje_id_p);
      END IF;
    END IF;
  -- neponuena usluga
  ELSIF rez_rez_id_l IS NOT NULL THEN
    -- ako rezervacija nije po ponudi i cjenik troka je onaj iz rezervacije
    -- i so (= soc) iz troka = onaj iz rezervacije  onda se cjenik nadjaava sa rez
    IF rez_ponso_id_l IS NULL AND NVL (tro_cje_id_p, gost_cje_id_l) = rez_cje_id_l
      AND tro_so_id_p = rez_so_id_l  -- mk 20.04.2009 dodana provjera na so
    THEN
      rez_id_p := rez_rez_id_l;
      cje_id_p := tro_cje_id_p;
    ELSE -- cjenik bez nadjaavanja
      cje_id_p := NVL (tro_cje_id_p, gost_cje_id_l);
    END IF;
    IF rez_ozn_cje_poseb_l = -1 AND ozn_usl_poseb_l = -1 THEN
      cje_id_p := pra_rec_s.bp_cje_id (NVL (tro_cje_id_p, gost_cje_id_l));
    END IF;
  ELSE
    cje_id_p := NVL (tro_cje_id_p, gost_cje_id_l);
    IF ozn_usl_poseb_l = -1 THEN
      cje_id_p := pra_rec_s.bp_cje_id (cje_id_p);
    END IF;
  END IF;
  so_id_p := NVL (so_id_p, tro_so_id_p); -- so se moe mijenjati samo iz ponude inae ostaje isti

END;
PROCEDURE PUNI_PREC_CJE_USL_DIJELI
 (ZMPPOP_ID_P IN trec_pop_razd.zmppop_id%TYPE
 )
 IS
-- procedura dijeli retke u prec_cje_usl prema razdobljima u trec_pop_razd za zmppop_id iz ulaznog parametra

-- retci u prec_cje_usl su formirani tako da je dat_zav prethodnog razdoblja jednak dat_poc sljedeeg
-- ako kod dijeljenja treba taj datum staviti u posebno razdoblje treba ga staviti samo iz jednog retka i
--  to iz onog sljedeeg jer je u tom ispravna cijena

  TYPE dat_poc_tab_type IS TABLE OF trec_pop_razd.dat_poc%TYPE INDEX BY BINARY_INTEGER;
  TYPE dat_zav_tab_type IS TABLE OF trec_pop_razd.dat_zav%TYPE INDEX BY BINARY_INTEGER;
  dat_poc_tab_l dat_poc_tab_type;
  dat_zav_tab_l dat_zav_tab_type;
  i NUMBER := 2;
  j NUMBER := 1;
  zadnji_l NUMBER := 1;
  nebitno_l NUMBER;

  CURSOR reccjeusl_exist_c ( -- za provjeru postoji li redak u prec_cje_usl 
    cje_id_k  NUMBER,
    so_id_k NUMBER,
    vsj_id_k NUMBER,
    usl_id_k NUMBER,
    recara_id_k NUMBER,
    ozn_ugo_k prec_cje_usl.ozn_ugo%TYPE,
    dat_poc_k prec_cje_usl.dat_poc%TYPE)
  IS
    SELECT 1
      FROM prec_cje_usl
     WHERE cje_id = cje_id_k
       AND so_id = so_id_k
       AND NVL (vsj_id, 0) = NVL (vsj_id_k, 0)
       AND usl_id = usl_id_k
       AND NVL (recara_id, 0) = NVL (recara_id_k, 0)
       AND ozn_ugo = ozn_ugo_k
       AND dat_poc = dat_poc_k;
BEGIN
  IF zmppop_id_p IS NULL THEN
    RETURN;
  END IF;

  SELECT COUNT (ID) INTO nebitno_l FROM trec_pop_razd WHERE zmppop_id = zmppop_id_p;
  IF nebitno_l = 0 THEN
    RETURN;
  END IF;

  FOR reccjeusl_c IN
    (SELECT ROWID, prec_cje_usl.*  FROM prec_cje_usl ORDER BY dat_poc DESC) -- od zadnjeg razdoblja prema prvom
  LOOP
    -- puni razdoblje
    i := 2;
    j := 1;
    zadnji_l := 1;
    dat_poc_tab_l (1) := reccjeusl_c.dat_poc;
    FOR datum IN (
      SELECT dat_poc datum -- poetni datum iz popusta
        FROM trec_pop_razd
       WHERE so_id = reccjeusl_c.so_id
         AND zmppop_id = zmppop_id_p
         AND NVL (vsj_id, 0) = NVL (reccjeusl_c.vsj_id, 0)
         AND usl_id = reccjeusl_c.usl_id
         AND dat_poc BETWEEN reccjeusl_c.dat_poc + 1 AND reccjeusl_c.dat_zav
      UNION
      SELECT dat_zav + 1 datum -- novi poetni datumi
        FROM trec_pop_razd
       WHERE so_id = reccjeusl_c.so_id
         AND zmppop_id = zmppop_id_p
         AND NVL (vsj_id, 0) = NVL (reccjeusl_c.vsj_id, 0)
         AND usl_id = reccjeusl_c.usl_id
         AND (dat_zav + 1) BETWEEN reccjeusl_c.dat_poc + 1 AND reccjeusl_c.dat_zav
       ORDER BY 1)
    LOOP
      dat_zav_tab_l (j) := datum.datum;
      dat_poc_tab_l (i) := datum.datum;
      j := j + 1;
      i := i + 1;
      zadnji_l := j;
    END LOOP;
    dat_zav_tab_l (zadnji_l) := reccjeusl_c.dat_zav;
    IF zadnji_l <> 1 THEN
      DELETE prec_cje_usl WHERE ROWID = reccjeusl_c.ROWID;
      FOR k IN 1 .. zadnji_l
      LOOP
        IF k = zadnji_l THEN  -- za zadnje razdoblje provjeriti da li ve postoji takav redak u prec_cje_usl
          nebitno_l := 0;
          OPEN reccjeusl_exist_c (
               reccjeusl_c.cje_id,
               reccjeusl_c.so_id,
               reccjeusl_c.vsj_id,
               reccjeusl_c.usl_id,
               reccjeusl_c.recara_id,
               reccjeusl_c.ozn_ugo,
               dat_poc_tab_l (k));
          FETCH reccjeusl_exist_c INTO nebitno_l;
          CLOSE reccjeusl_exist_c;
        END IF;
        IF k <> zadnji_l OR (k = zadnji_l AND nebitno_l = 0) THEN
          INSERT INTO prec_cje_usl (
              cje_id, so_id, vsj_id, usl_id, recara_id,
              dat_poc, dat_zav, cijena_usluge, cje_usl_obr, ozn_ugo, ozn_cijene)
            VALUES (
              reccjeusl_c.cje_id, reccjeusl_c.so_id, reccjeusl_c.vsj_id, reccjeusl_c.usl_id, reccjeusl_c.recara_id,
              dat_poc_tab_l (k), dat_zav_tab_l (k), reccjeusl_c.cijena_usluge, reccjeusl_c.cje_usl_obr, reccjeusl_c.ozn_ugo, reccjeusl_c.ozn_cijene);
         END IF;
      END LOOP;
    END IF;
  END LOOP;
END;
PROCEDURE SET_AUDIT_G
 (UNOS_KORISNIK_P IN t_troskovi.unos_korisnik%TYPE
 ,UNOS_DAT_P IN t_troskovi.unos_dat%TYPE
 )
 IS
/*
Proceduru pozivaju paketi pra_self_check_in i pra_self_ordering.
Varijable unos_korisnik_g i unos_dat_g ita procedura insert_tro.
*/
BEGIN
  unos_korisnik_g := unos_korisnik_p;
  unos_dat_g := unos_dat_p;
END;
PROCEDURE SAZMI_PREC_CJE_USL
 IS
-- IRN 3933
  dat_poc_l prec_cje_usl.dat_poc%TYPE;
  dat_zav_l prec_cje_usl.dat_zav%TYPE;
BEGIN
-- saima retke u prec_cje_usl koji imaju sve podatke osim razdoblja iste a razdoblje se nastavlja

  -- IRN 3988
  IF pra_rec_iud.citaj_ozn_cijene_g = 0 THEN
    UPDATE prec_cje_usl SET ozn_cijene = 3 WHERE ozn_cijene = 1; 
  END IF;

  pra_rec_iud.citaj_ozn_cijene_g := -1;

  FOR reccjeusl_c IN (
    SELECT cje_id, so_id, vsj_id, usl_id, ozn_ugo, dat_poc, dat_zav, cijena_usluge, cje_usl_obr, ozn_cijene, recara_id
      FROM prec_cje_usl
     ORDER BY cje_id, so_id, vsj_id, usl_id, ozn_ugo, cijena_usluge, cje_usl_obr, ozn_cijene, recara_id, dat_poc
    )
    LOOP

    -- zapamtiti poetni datum prvog retka koji e se spajati
    -- taj redak e se aurirati do kraja spajanja, to je sve dok se pronalazi novi zavrni datum
    IF dat_zav_l IS NULL THEN
      dat_poc_l := reccjeusl_c.dat_poc;
    END IF;

    SELECT MIN (dat_zav)
      INTO dat_zav_l
      FROM prec_cje_usl
     WHERE cje_id = reccjeusl_c.cje_id
       AND so_id = reccjeusl_c.so_id
       AND NVL (vsj_id, 0) = NVL (reccjeusl_c.vsj_id, 0)
       AND usl_id = reccjeusl_c.usl_id
       AND ozn_ugo = reccjeusl_c.ozn_ugo
       AND dat_poc > reccjeusl_c.dat_poc   -- sljedee razdoblje sa istim podacima, IRN 3933
       AND dat_poc = reccjeusl_c.dat_zav   -- koje se nastavlja na prethodno, IRN 3933
       AND cijena_usluge = reccjeusl_c.cijena_usluge
       AND NVL (cje_usl_obr, 0) = NVL (reccjeusl_c.cje_usl_obr, 0)
       AND ozn_cijene = reccjeusl_c.ozn_cijene
       AND NVL (recara_id, 0) = NVL (reccjeusl_c.recara_id, 0);

/*
dbms_output.put_line (
reccjeusl_c.cje_id
|| ' so ' || reccjeusl_c.so_id
|| ' as ' || reccjeusl_c.vsj_id
|| ' us ' || reccjeusl_c.usl_id
|| ' oz ' || reccjeusl_c.ozn_ugo
|| ' po ' || reccjeusl_c.dat_poc
|| ' za ' || reccjeusl_c.dat_zav
|| ' ci ' || reccjeusl_c.cijena_usluge
|| ' co ' || reccjeusl_c.cje_usl_obr
|| ' oz ' || reccjeusl_c.ozn_cijene
|| ' ar ' || reccjeusl_c.recara_id
|| ' l ' || dat_zav_l
);
*/

    -- ako je sljedee razdoblje pronaeno aurira se zavrni datum u prvom retku s istim podacima
    IF dat_zav_l IS NOT NULL THEN
      UPDATE prec_cje_usl SET dat_zav = dat_zav_l
       WHERE cje_id = reccjeusl_c.cje_id
         AND so_id = reccjeusl_c.so_id
         AND NVL (vsj_id, 0) = NVL (reccjeusl_c.vsj_id, 0)
         AND usl_id = reccjeusl_c.usl_id
         AND ozn_ugo = reccjeusl_c.ozn_ugo
         AND dat_poc = dat_poc_l
         AND dat_zav = reccjeusl_c.dat_zav
         AND cijena_usluge = reccjeusl_c.cijena_usluge
         AND NVL (cje_usl_obr, 0) = NVL (reccjeusl_c.cje_usl_obr, 0)
         AND ozn_cijene = reccjeusl_c.ozn_cijene
         AND NVL (recara_id, 0) = NVL (reccjeusl_c.recara_id, 0);

    -- i brie sljedei redak
      DELETE FROM prec_cje_usl
       WHERE cje_id = reccjeusl_c.cje_id
         AND so_id = reccjeusl_c.so_id
         AND NVL (vsj_id, 0) = NVL (reccjeusl_c.vsj_id, 0)
         AND usl_id = reccjeusl_c.usl_id
         AND ozn_ugo = reccjeusl_c.ozn_ugo
         AND dat_poc = reccjeusl_c.dat_zav
         AND cijena_usluge = reccjeusl_c.cijena_usluge
         AND NVL (cje_usl_obr, 0) = NVL (reccjeusl_c.cje_usl_obr, 0)
         AND ozn_cijene = reccjeusl_c.ozn_cijene
         AND NVL (recara_id, 0) = NVL (reccjeusl_c.recara_id, 0);

    END IF;

  END LOOP;

END;

END PRA_REC_IUD;
/
SHOW ERROR

