PROMPT Creating Package Body 'PRA_REC_CRM'
CREATE OR REPLACE PACKAGE BODY PRA_REC_CRM IS

LOG_FILE_NAME_M VARCHAR2(100);
LOG_OPIS_M CLOB;


PROCEDURE AZURIRAJ_CJE1
 (CJE_SIFRA_P IN t_cjenici.sifra%TYPE
 ,CJE_NAZIV_P IN t_cjenici.naziv%TYPE
 ,CJE_OPIS_P IN t_cjenici.opis%TYPE
 ,VAL_SIFRA_3A_P IN s_valute.sifra_3a%TYPE
 ,DAT_POC_P IN DATE
 ,DAT_ZAV_P IN DATE
 ,CJE_ID_P OUT t_cjenici.id%TYPE
 )
 IS
--
  recpro_opis_l lrec_promjene.opis%TYPE;
  cje_rec_l t_cjenici%ROWTYPE;
  metcvor_sifra_centar_l VARCHAR2(41);
  naredba_l VARCHAR2(2000);
  error_text_l VARCHAR2(2000);
BEGIN

  IF pra_zmp_s.oznaka ('P0001') = 0 THEN
    RETURN;
  END IF;

  recpro_opis_l :=
    SUBSTR (
      cje_sifra_p || '; ' ||
        cje_naziv_p || '; ' ||
        cje_opis_p || '; ' ||
        val_sifra_3a_p || '; ' ||
        TO_CHAR (dat_poc_p, 'DD.MM.RRRR') || '; ' ||
        TO_CHAR (dat_zav_p, 'DD.MM.RRRR'),
      1,
      2000);

  -- Nedostaje obvezan ulazni parametar (#0).
  IF cje_sifra_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'cje_sifra_p');
  ELSIF cje_naziv_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'cje_naziv_p');
  -- cje_opis_p
  ELSIF val_sifra_3a_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'val_sifra_3a_p');
  -- dat_poc_p
  -- dat_zav_p
  END IF;

  metcvor_sifra_centar_l := pra_rec_s3.metcvor_sifra_centar;

  cje_rec_l.id := pra_rec_s3.cje_id (cje_sifra_p => cje_sifra_p, ozn_obvezan_p => -1, ozn_mora_postojati_p => 0);
  IF cje_rec_l.id IS NOT NULL THEN -- IRN 1110
    naredba_l := 'SELECT * FROM t_cjenici' || metcvor_sifra_centar_l || ' WHERE id = :id';
    EXECUTE IMMEDIATE naredba_l INTO cje_rec_l USING cje_rec_l.id;
  END IF;
  cje_rec_l.val_id := pra_rec_s3.val_id (val_sifra_3a_p);
  cje_rec_l.sifra := cje_sifra_p;
  cje_rec_l.naziv := cje_naziv_p;
  cje_rec_l.opis := cje_opis_p;
  cje_rec_l.dat_valjan := TRUNC (SYSDATE, 'RRRR'); -- G.J. 30.01.2009. IRN 801
  IF cje_rec_l.id IS NULL THEN
    -- INSERT
    naredba_l :=
      'SELECT pra_zmp_zaj.i3_sekvenca' || metcvor_sifra_centar_l || ' (NULL) FROM dual';
    EXECUTE IMMEDIATE naredba_l INTO cje_rec_l.id;
    pra_rec_iud2.insert_cje_cvor (
      metcvor_sifra_p => metcvor_sifra_centar_l,
      cje_rec_p => cje_rec_l);
  ELSE
    -- UPDATE
    pra_rec_iud2.update_cje_cvor (
      metcvor_sifra_p => metcvor_sifra_centar_l,
      cje_rec_p => cje_rec_l);
    IF dat_poc_p IS NOT NULL AND dat_zav_p IS NOT NULL THEN
      -- DELETE stavaka
      naredba_l :=
        'DELETE FROM t_cje_usl' || metcvor_sifra_centar_l ||
        ' WHERE cje_id = :cje_id
            AND datum BETWEEN TRUNC (:dat_poc_p) AND TRUNC (:dat_zav_p)';
      EXECUTE IMMEDIATE naredba_l USING cje_rec_l.id, dat_poc_p, dat_zav_p;
    END IF;
  END IF;

  pra_rec.puni_promjene ('9111', recpro_opis_l, -1);

  cje_id_p := cje_rec_l.id;

EXCEPTION
  WHEN OTHERS THEN
    error_text_l := SUBSTR (SQLERRM || ' ' || recpro_opis_l, 1, 2000);
    pra_rec.puni_promjene ('9111', recpro_opis_l, 0);
    pra_rec.puni_promjene ('9111', error_text_l, 0);
    RAISE;
END;
PROCEDURE AZURIRAJ_CJEUSL
 (CJE_ID_P IN t_cjenici.id%TYPE
 ,SO_SIFRA_P IN m_so.sifra%TYPE
 ,VSJ_SIFRA_P IN s_vsj.sifra%TYPE
 ,USL_SIFRA_P IN s_usluge.sifra%TYPE
 ,DATUM_P IN t_cje_usl.datum%TYPE
 ,CIJENA_USLUGE_P IN t_cje_usl.cijena_usluge%TYPE
 )
 IS
--
  recpro_opis_l lrec_promjene.opis%TYPE;
  so_id_l t_cje_usl.so_id%TYPE;
  vsj_id_l t_cje_usl.vsj_id%TYPE;
  usl_id_l t_cje_usl.usl_id%TYPE;
  cjeusl_rec_l t_cje_usl%ROWTYPE;
  metcvor_sifra_centar_l VARCHAR2(41);
  naredba_l VARCHAR2(2000);
  rc_l SYS_REFCURSOR;
  error_text_l VARCHAR2(2000);
BEGIN

  IF pra_zmp_s.oznaka ('P0002') = 0 THEN
    RETURN;
  END IF;

  recpro_opis_l :=
    SUBSTR (
      cje_id_p || '; ' ||
        so_sifra_p || '; ' ||
        vsj_sifra_p || '; ' ||
        usl_sifra_p || '; ' ||
        TO_CHAR (datum_p, 'DD.MM.RRRR') || '; ' ||
        cijena_usluge_p,
      1,
      2000);

  -- Nedostaje obvezan ulazni parametar (#0).
  IF cje_id_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'cje_id_p');
  ELSIF so_sifra_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'so_sifra_p');
  -- vsj_sifra_p
  ELSIF usl_sifra_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'usl_sifra_p');
  -- cje_opis_p
  ELSIF datum_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'datum_p');
  ELSIF cijena_usluge_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'cijena_usluge_p');
  END IF;

  metcvor_sifra_centar_l := pra_rec_s3.metcvor_sifra_centar;

  cjeusl_rec_l.id := NULL;
  so_id_l := pra_rec_s3.so_id (so_sifra_p);
  vsj_id_l := pra_rec_s3.vsj_id (vsj_sifra_p, 0);
  usl_id_l := pra_rec_s3.usl_id (usl_sifra_p);
  OPEN rc_l FOR
   'SELECT id
      FROM t_cje_usl' || metcvor_sifra_centar_l || '
     WHERE cje_id = :cje_id
       AND so_id = :so_id
       AND NVL (vsj_id, 0) = NVL (:vsj_id, 0)
       AND usl_id = :usl_id
       AND datum = :datum'
     USING
       cje_id_p, so_id_l, vsj_id_l, usl_id_l, datum_p;
  FETCH rc_l INTO cjeusl_rec_l.id;
  CLOSE rc_l;
  IF cjeusl_rec_l.id IS NOT NULL THEN -- IRN 1110
    naredba_l := 'SELECT * FROM t_cje_usl' || metcvor_sifra_centar_l || ' WHERE id = :id';
    EXECUTE IMMEDIATE naredba_l INTO cjeusl_rec_l USING cjeusl_rec_l.id;
  END IF;
  cjeusl_rec_l.cje_id := cje_id_p;
  cjeusl_rec_l.so_id := so_id_l;
  cjeusl_rec_l.vsj_id := vsj_id_l;
  cjeusl_rec_l.usl_id := usl_id_l;
  cjeusl_rec_l.datum := datum_p;
  cjeusl_rec_l.cijena_usluge := cijena_usluge_p;
  IF cjeusl_rec_l.id IS NULL THEN
    pra_rec_iud2.insert_cjeusl_cvor (
      metcvor_sifra_p => metcvor_sifra_centar_l,
      cjeusl_rec_p => cjeusl_rec_l);
  ELSE
    pra_rec_iud2.update_cjeusl_cvor (
      metcvor_sifra_p => metcvor_sifra_centar_l,
      cjeusl_rec_p => cjeusl_rec_l);
  END IF;

  pra_rec.puni_promjene ('9112', recpro_opis_l, -1);

EXCEPTION
  WHEN OTHERS THEN
    error_text_l := SUBSTR (SQLERRM || ' ' || recpro_opis_l, 1, 2000);
    pra_rec.puni_promjene ('9112', recpro_opis_l, 0);
    pra_rec.puni_promjene ('9112', error_text_l, 0);
    RAISE;
END;
PROCEDURE AZURIRAJ_AGE
 (AGE_ID_P IN OUT m_agencije.id%TYPE
 ,AGE_SIFRA_P IN m_agencije.sifra%TYPE
 ,AGE_NAZIV_P IN m_agencije.naziv%TYPE
 ,AGE_NAZ_DODATNI_P IN m_agencije.naz_dodatni%TYPE
 ,GKAGE_SIFRA_P IN m_gkagencija.sifra%TYPE
 ,STPLA_SIFRA_P IN m_statusi_platisa.sifra%TYPE
 ,GSAGE_SIFRA_P IN m_gsagencija.sifra%TYPE
 ,GZEM_SIFRA_P IN m_gzemalja.sifra%TYPE
 ,VPOBV_SIFRA_P IN s_vpobveznika.sifra%TYPE
 ,BR_POREZNI_P IN m_agencije.br_porezni%TYPE
 ,OIB_P IN M_AGENCIJE.OIB%TYPE
 ,AGEP_ID_P IN m_agencije.age_id%TYPE
 ,BAN_SIFRA_P IN m_banke.sifra%TYPE
 ,BR_RACUNA_P IN m_agencije.br_racuna%TYPE
 ,IMEP_OSOBEODG_P IN m_agencije.imep_osobeodg%TYPE
 ,ZEM_SIFRA_2A_P IN s_zemlje.sifra_2a%TYPE
 ,REG_SIFRA_P IN m_regije.sifra%TYPE
 ,POS_BROJ_P IN m_poste.broj%TYPE
 ,NAZ_ULICE_P IN m_agencije.naz_ulice%TYPE
 ,BR_TELEFONA_P IN m_agencije.br_telefona%TYPE
 ,BR_TELEFAKSA_P IN m_agencije.br_telefaksa%TYPE
 ,EMAIL_P IN m_agencije.email%TYPE
 ,WWW_P IN m_agencije.www%TYPE
 ,NAPOMENA_P IN m_agencije.napomena%TYPE
 ,DAT_VALJAN_P IN m_agencije.dat_valjan%TYPE
 ,DAT_PONISTEN_P IN m_agencije.dat_ponisten%TYPE
 )
 IS
/*
Procedura aurira podatke u tablici m_agencije, ako agencija nije vezana komitenta.
*/
  recpro_opis_l lrec_promjene.opis%TYPE;
  metcvor_sifra_centar_l VARCHAR2(41);
  naredba_l VARCHAR2(2000);
  ozn_cvor_je_podcentar_l szmp_parametri.vrijednost%TYPE;

  naziv_l VARCHAR2(40);

  age_rec_l m_agencije%ROWTYPE;

  error_text_l VARCHAR2(2000);
BEGIN

  IF pra_zmp_s.oznaka ('P0003') = 0 THEN
    RETURN;
  END IF;

  recpro_opis_l :=
    SUBSTR (
      age_id_p || '; ' ||
        age_sifra_p || '; ' ||
        age_naziv_p || '; ' ||
        age_naz_dodatni_p || '; ' ||
        gkage_sifra_p || '; ' ||
        stpla_sifra_p || '; ' ||
        gsage_sifra_p || '; ' ||
        gzem_sifra_p || '; ' ||
        vpobv_sifra_p || '; ' ||
        br_porezni_p || '; ' ||
        OIB_p || '; ' ||
        agep_id_p || '; ' ||
        ban_sifra_p || '; ' ||
        br_racuna_p || '; ' ||
        imep_osobeodg_p || '; ' ||
        zem_sifra_2a_p || '; ' ||
        reg_sifra_p || '; ' ||
        pos_broj_p || '; ' ||
        naz_ulice_p || '; ' ||
        br_telefona_p || '; ' ||
        br_telefaksa_p || '; ' ||
        email_p || '; ' ||
        www_p || '; ' ||        
        napomena_p || '; ' ||
        TO_CHAR (dat_valjan_p, 'DD.MM.RRRR') || '; ' ||
        TO_CHAR (dat_ponisten_p, 'DD.MM.RRRR'),
      1,
      2000);

  -- Nedostaje obvezan ulazni parametar (#0).
  -- age_id_p
  IF age_sifra_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'age_sifra_p');
  ELSIF age_naziv_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'age_naziv_p');
  -- age_naz_dodatni_p
  ELSIF gkage_sifra_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'gkage_sifra_p');
  -- stpla_sifra_p
  ELSIF gsage_sifra_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'gsage_sifra_p');
  -- gzem_sifra_p
  ELSIF vpobv_sifra_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'vpobv_sifra_p');
  -- br_porezni_p
  -- agep_id_p
  -- ban_sifra_p
  -- br_racuna_p
  -- imep_osobeodg_p
  ELSIF zem_sifra_2a_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'zem_sifra_2a_p');
  -- reg_sifra_p
  -- pos_broj_p
  -- naz_ulice_p
  -- br_telefona_p
  -- br_telefaksa_p
  -- email_p
  -- www_p
  -- napomena_p
  -- dat_valjan_p
  -- dat_ponisten_p
  END IF;

  metcvor_sifra_centar_l := pra_rec_s3.metcvor_sifra_centar;

  -- Provjeri postoji li komitent sa ifrom age_sifra_p
  SELECT MAX (naziv) INTO naziv_l FROM mgmp_komitenti WHERE sifra = age_sifra_p;
  IF naziv_l IS NOT NULL THEN
    -- Postoji komitent #0 sa ifrom #1.
    pra_rec_zaj.vrati_poruku (-20473, naziv_l, age_sifra_p);
  END IF;

  IF age_id_p IS NOT NULL THEN
    SELECT * INTO age_rec_l FROM m_agencije WHERE id = age_id_p;
    IF age_rec_l.gmpkom_id IS NOT NULL THEN
      SELECT MAX (naziv) INTO naziv_l FROM mgmp_komitenti WHERE id = age_rec_l.gmpkom_id;
      -- Agencija je vezana za komitenta #0.
      pra_rec_zaj.vrati_poruku (-20522, naziv_l);
    END IF;
  ELSE
    SELECT MAX (naziv) INTO naziv_l FROM m_agencije WHERE sifra = age_sifra_p;
    IF naziv_l IS NOT NULL THEN
      -- Postoji agencija #0 sa ifrom #1.
      pra_rec_zaj.vrati_poruku (-20523, naziv_l, age_sifra_p);
    END IF;
  END IF;

  -- Trai vrijednost ZMP parametra 0032 Da li je vor podcentar mree. (D/N)
  naredba_l :=
    'SELECT UPPER (pra_zmp_zaj.vrijednost_parametra' || metcvor_sifra_centar_l || ' (''0032'')) FROM dual';
  EXECUTE IMMEDIATE naredba_l INTO ozn_cvor_je_podcentar_l;

  -- Zabrani insert na podcentru
  IF ozn_cvor_je_podcentar_l = 'D' AND age_id_p IS NULL THEN
    -- Nedostaje podatak (#0 #1).
    pra_rec_zaj.vrati_poruku (-20445, pra_zmp_zaj.poruka ('REC', 'REC_AGE'), age_sifra_p);
  END IF;

  IF NOT (ozn_cvor_je_podcentar_l = 'D') THEN
    age_rec_l.sifra := age_sifra_p;
    age_rec_l.naziv := age_naziv_p;
    age_rec_l.naz_dodatni := age_naz_dodatni_p;
    age_rec_l.gmpkom_id := NULL;
    age_rec_l.gkage_id := pra_rec_s3.gkage_id (gkage_sifra_p);
    age_rec_l.vpobv_id := pra_rec_s3.vpobv_id (vpobv_sifra_p);
    age_rec_l.oib := oib_p;
    age_rec_l.br_porezni := br_porezni_p;
    age_rec_l.zem_id := pra_rec_s3.zem_id (zem_sifra_2a_p);
    age_rec_l.www := www_p;
    age_rec_l.dat_valjan := NVL (dat_valjan_p, TRUNC (SYSDATE, 'RRRR'));
    age_rec_l.dat_ponisten := dat_ponisten_p;
  END IF;
  age_rec_l.gsage_id := pra_rec_s3.gsage_id (gsage_sifra_p);
  age_rec_l.gzem_id := pra_rec_s3.gzem_id (gzem_sifra_p, 0);
  age_rec_l.age_id := agep_id_p;
  age_rec_l.stpla_id := pra_rec_s3.stpla_id (stpla_sifra_p, 0);
  age_rec_l.ban_id := pra_rec_s3.ban_id (ban_sifra_p, 0);
  age_rec_l.br_racuna := br_racuna_p;
  age_rec_l.imep_osobeodg := imep_osobeodg_p;
  age_rec_l.reg_id := pra_rec_s3.reg_id (reg_sifra_p, age_rec_l.zem_id, 0);
  age_rec_l.pos_id := pra_rec_s3.pos_id (pos_broj_p, age_rec_l.zem_id, 0);
  age_rec_l.naz_ulice := naz_ulice_p;
  age_rec_l.br_telefona := br_telefona_p;
  age_rec_l.br_telefaksa := br_telefaksa_p;
  age_rec_l.email := email_p;
  age_rec_l.napomena := napomena_p;

  IF age_id_p IS NULL THEN
    -- INSERT m_agencije
    naredba_l :=
      'SELECT pra_zmp_zaj.i3_sekvenca' || metcvor_sifra_centar_l || ' (NULL) FROM dual';
    EXECUTE IMMEDIATE naredba_l INTO age_rec_l.id;
    pra_rec_iud2.insert_age_cvor (
      metcvor_sifra_p => metcvor_sifra_centar_l,
      age_rec_p => age_rec_l);
  ELSE
    -- UPDATE m_agencije
    age_rec_l.id := age_id_p;
    pra_rec_iud2.update_age_cvor (
      metcvor_sifra_p => metcvor_sifra_centar_l,
      age_rec_p => age_rec_l);
  END IF;

  pra_rec.puni_promjene ('9120', recpro_opis_l, -1);

  age_id_p := age_rec_l.id;

EXCEPTION
  WHEN OTHERS THEN
    error_text_l := SUBSTR (SQLERRM || ' ' || recpro_opis_l, 1, 2000);
    pra_rec.puni_promjene ('9120', recpro_opis_l, 0);
    pra_rec.puni_promjene ('9120', error_text_l, 0);
    RAISE;
END;
PROCEDURE AZURIRAJ_RECAGOST
 (RBR_P IN OUT trec_agostiju.rbr%TYPE
 ,TITULA_P IN trec_agostiju.titula%TYPE := NULL
 ,IME_P IN trec_agostiju.ime%TYPE
 ,PREZIME_P IN trec_agostiju.prezime%TYPE
 ,OZNAKA_P IN trec_agostiju.oznaka%TYPE
 ,RECGGOST_SIFRA_P IN mrec_ggostiju.sifra%TYPE := NULL
 ,SIFRA_P IN trec_agostiju.sifra%TYPE := NULL
 ,OZN_VIP_P IN trec_agostiju.ozn_vip%TYPE := NULL
 ,OZN_ABC_P IN trec_agostiju.ozn_abc%TYPE := NULL
 ,STOPA_POPUSTA_P IN trec_agostiju.stopa_popusta%TYPE := NULL
 ,STOPA_POPUSTA_POS_P IN trec_agostiju.stopa_popusta_pos%TYPE := NULL
 ,STPLA_SIFRA_P IN m_statusi_platisa.sifra%TYPE := NULL
 ,RECAGOST_RBR_P IN trec_agostiju.rbr%TYPE := NULL
 ,SRODSTVO_P IN trec_agostiju.srodstvo%TYPE := NULL
 ,ZEM_SIFRA_2A_P IN s_zemlje.sifra_2a%TYPE
 ,REG_SIFRA_P IN m_regije.sifra%TYPE := NULL
 ,NAZ_REGIJE_P IN trec_agostiju.naz_regije%TYPE := NULL
 ,POS_BROJ_P IN m_poste.broj%TYPE := NULL
 ,NAZ_MJESTA_P IN trec_agostiju.naz_mjesta%TYPE := NULL
 ,NAZ_ULICE_P IN trec_agostiju.naz_ulice%TYPE := NULL
 ,OZN_KONTAKT_P IN trec_agostiju.ozn_kontakt%TYPE := 0
 ,BR_TELEFONA_P IN trec_agostiju.br_telefona%TYPE := NULL
 ,OZN_KONTAKT_TELEFON_P IN trec_agostiju.ozn_kontakt_telefon%TYPE := 0
 ,BR_TELEFONA2_P IN trec_agostiju.br_telefona2%TYPE := NULL
 ,OZN_KONTAKT_TELEFON2_P IN trec_agostiju.ozn_kontakt_telefon2%TYPE := 0
 ,BR_TELEFAKSA_P IN trec_agostiju.br_telefaksa%TYPE := NULL
 ,OZN_KONTAKT_TELEFAKS_P IN trec_agostiju.ozn_kontakt_telefaks%TYPE := 0
 ,EMAIL_P IN trec_agostiju.email%TYPE := NULL
 ,OZN_KONTAKT_EMAIL_P IN trec_agostiju.ozn_kontakt_email%TYPE := 0
 ,WWW_P IN trec_agostiju.www%TYPE := NULL
 ,JEZ_SIFRA_2A_P IN s_jezici.sifra_2a%TYPE := NULL
 ,NAZ_PODUZECA_P IN trec_agostiju.naz_poduzeca%TYPE := NULL
 ,ZANIMANJE_P IN trec_agostiju.zanimanje%TYPE := NULL
 ,OZN_SPOLA_P IN trec_agostiju.ozn_spola%TYPE := NULL
 ,DAT_RODJENJA_P IN trec_agostiju.dat_rodjenja%TYPE := NULL
 ,VPLABP_SIFRA_P IN s_vplabp_tz.sifra%TYPE := NULL
 ,ZEMR_SIFRA_2A_P IN s_zemlje.sifra_2a%TYPE := NULL
 ,POSR_BROJ_P IN m_poste.broj%TYPE := NULL
 ,NAZ_MJRODJ_P IN trec_agostiju.naz_mjrodj%TYPE := NULL
 ,ZEMD_SIFRA_2A_P IN s_zemlje.sifra_2a%TYPE := NULL
 ,GPRI_SIFRA_P IN s_gprijelazi.sifra%TYPE := NULL
 ,VPISP_SIFRA_P IN s_vpisprava.sifra%TYPE := NULL
 ,BR_PISPRAVE_P IN trec_agostiju.br_pisprave%TYPE := NULL
 ,NAZ_MJPISP_P IN trec_agostiju.naz_mjpisp%TYPE := NULL
 ,NAPOMENA1_P IN trec_agostiju.napomena1%TYPE := NULL
 ,NAPOMENA2_P IN trec_agostiju.napomena2%TYPE := NULL
 ,ODGOVOR_P OUT VARCHAR2
 )
 IS
/*
Procedura aurira podatke u tablici trec_agostiju na shemi "Centar"
*/
  metcvor_sifra_centar_l VARCHAR2(41);
  naredba_l VARCHAR2(2000);
  recagost_rec_l trec_agostiju%ROWTYPE;
  rowcount_l NUMBER := 0;
BEGIN

  log_file_name_m := 'crm-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '.log';
  log_opis_m :=
    'pra_rec_crm.azuriraj_recagost; ' ||
      rbr_p || '; ' ||
      titula_p || '; ' ||
      ime_p || '; ' ||
      prezime_p || '; ' ||
      oznaka_p || '; ' ||
      recggost_sifra_p || '; ' ||
      -- IRN 2678 -- br_loy_kartice_p || '; ' || -- IRN 1696
      -- IRN 2678 -- dat_uclanjenja_p || '; ' || -- IRN 1696
      -- IRN 2678 -- censo_sifra_p || '; ' || -- IRN 1696
      sifra_p || '; ' ||
      ozn_vip_p || '; ' ||
      ozn_abc_p || '; ' ||
      stopa_popusta_p || '; ' ||
      stopa_popusta_pos_p || '; ' ||
      stpla_sifra_p || '; ' || -- IRN 1696
      recagost_rbr_p || '; ' ||
      srodstvo_p || '; ' ||
      zem_sifra_2a_p || '; ' ||
      reg_sifra_p || '; ' ||
      naz_regije_p || '; ' ||
      pos_broj_p || '; ' ||
      naz_mjesta_p || '; ' ||
      naz_ulice_p || '; ' ||
      ozn_kontakt_p || '; ' ||
      br_telefona_p || '; ' ||
      ozn_kontakt_telefon_p || '; ' ||
      br_telefona2_p || '; ' ||
      ozn_kontakt_telefon2_p || '; ' ||
      br_telefaksa_p || '; ' ||
      ozn_kontakt_telefaks_p || '; ' ||
      email_p || '; ' ||
      ozn_kontakt_email_p || '; ' ||
      www_p || '; ' ||
      jez_sifra_2a_p || '; ' ||
      naz_poduzeca_p || '; ' ||
      zanimanje_p || '; ' ||
      ozn_spola_p || '; ' ||
      dat_rodjenja_p || '; ' ||
      vplabp_sifra_p || '; ' ||
      zemr_sifra_2a_p || '; ' ||
      posr_broj_p || '; ' ||
      naz_mjrodj_p || '; ' ||
      zemd_sifra_2a_p || '; ' ||
      gpri_sifra_p || '; ' ||
      vpisp_sifra_p || '; ' ||
      br_pisprave_p || '; ' ||
      naz_mjpisp_p || '; ' ||
      napomena1_p || '; ' ||
      napomena2_p;

  IF pra_zmp_s.oznaka ('P0004') = 0 THEN
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  -- Nedostaje obvezan ulazni parametar (#0).
  -- rbr_p
  -- titula_p
  IF ime_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'ime_p');
  ELSIF prezime_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'prezime_p');
  ELSIF oznaka_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'oznaka_p');
  -- recggost_sifra_p
  -- IRN 2678 -- br_loy_kartice_p -- IRN 1696
  -- IRN 2678 -- dat_uclanjenja_p -- IRN 1696
  -- IRN 2678 -- censo_sifra_p -- IRN 1696
  -- sifra_p
  -- ozn_vip_p
  -- ozn_abc_p
  -- stopa_popusta_p
  -- stopa_popusta_pos_p
  -- stpla_sifra_p -- IRN 1696
  -- recagost_rbr_p
  -- srodstvo_p
  ELSIF zem_sifra_2a_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'zem_sifra_2a_p');
  -- reg_sifra_p
  -- naz_regije_p
  -- pos_broj_p
  -- naz_mjesta_p
  -- naz_ulice_p
  -- ozn_kontakt_p
  -- br_telefona_p
  -- ozn_kontakt_telefon_p
  -- br_telefona2_p
  -- ozn_kontakt_telefon2_p
  -- br_telefaksa_p
  -- ozn_kontakt_telefaks_p
  -- email_p
  -- ozn_kontakt_email_p
  -- www_p
  -- jez_sifra_2a_p
  -- naz_poduzeca_p
  -- zanimanje_p
  -- ozn_spola_p
  -- dat_rodjenja_p
  -- vplabp_sifra_p
  -- zemr_sifra_2a_p
  -- posr_broj_p
  -- naz_mjrodj_p
  -- zemd_sifra_2a_p
  -- gpri_sifra_p
  -- vpisp_sifra_p
  -- br_pisprave_p
  -- naz_mjpisp_p
  -- napomena1_p
  -- napomena2_p
  END IF;

  IF rbr_p IS NULL AND UPPER (oznaka_p) NOT IN ('V') THEN
    -- Pogrena vrijednost parametra #0.
    pra_rec_zaj.vrati_poruku (-20474, 'oznaka_p');
  END IF;

  metcvor_sifra_centar_l := pra_rec_s3.metcvor_sifra_centar;

  IF rbr_p IS NOT NULL THEN -- IRN 1110
    -- provjeri postoji li odgovarajui redak
    recagost_rec_l.id := pra_rec_s3.recagost_id (recagost_rbr_p => rbr_p, ozn_obvezan_p => -1, ozn_mora_postojati_p => -1);
    -- uitaj sve podatke
    naredba_l := 'SELECT * FROM trec_agostiju' || metcvor_sifra_centar_l || ' WHERE id = :id';
    EXECUTE IMMEDIATE naredba_l INTO recagost_rec_l USING recagost_rec_l.id;
  END IF;

  recagost_rec_l.titula := titula_p;
  recagost_rec_l.ime := ime_p;
  recagost_rec_l.prezime := prezime_p;
  recagost_rec_l.oznaka := oznaka_p;
  recagost_rec_l.recggost_id := pra_rec_s3.recggost_id (recggost_sifra_p, 0);
  -- IRN 2678 -- recagost_rec_l.br_loy_kartice := br_loy_kartice_p; -- IRN 1696
  -- IRN 2678 -- recagost_rec_l.dat_uclanjenja := dat_uclanjenja_p; -- IRN 1696
  -- IRN 2678 -- recagost_rec_l.censo_id := pra_rec_s3.censo_id (censo_sifra_p, 0); -- IRN 1696
  recagost_rec_l.sifra := sifra_p;
  recagost_rec_l.ozn_vip := ozn_vip_p;
  recagost_rec_l.ozn_abc := ozn_abc_p;
  recagost_rec_l.stopa_popusta := stopa_popusta_p;
  recagost_rec_l.stopa_popusta_pos := stopa_popusta_pos_p;
  recagost_rec_l.stpla_id := pra_rec_s3.stpla_id (stpla_sifra_p, 0); -- IRN 1696
  recagost_rec_l.recagost_id := pra_rec_s3.recagost_id (recagost_rbr_p, 0);
  recagost_rec_l.srodstvo := srodstvo_p;
  recagost_rec_l.zem_id := pra_rec_s3.zem_id (zem_sifra_2a_p);
  recagost_rec_l.reg_id := pra_rec_s3.reg_id (reg_sifra_p, recagost_rec_l.zem_id, 0);
  recagost_rec_l.naz_regije := naz_regije_p;
  recagost_rec_l.pos_id := pra_rec_s3.pos_id (pos_broj_p, recagost_rec_l.zem_id, 0);
  recagost_rec_l.naz_mjesta := naz_mjesta_p;
  recagost_rec_l.naz_ulice := naz_ulice_p;
  recagost_rec_l.ozn_kontakt := NVL (ozn_kontakt_p, 0);
  recagost_rec_l.br_telefona := br_telefona_p;
  recagost_rec_l.ozn_kontakt_telefon := NVL (ozn_kontakt_telefon_p, 0);
  recagost_rec_l.br_telefona2 := br_telefona2_p;
  recagost_rec_l.ozn_kontakt_telefon2 := NVL (ozn_kontakt_telefon2_p, 0);
  recagost_rec_l.br_telefaksa := br_telefaksa_p;
  recagost_rec_l.ozn_kontakt_telefaks := NVL (ozn_kontakt_telefaks_p, 0);
  recagost_rec_l.email := email_p;
  recagost_rec_l.ozn_kontakt_email := NVL (ozn_kontakt_email_p, 0);
  recagost_rec_l.www := www_p;
  recagost_rec_l.jez_id := pra_rec_s3.jez_id (jez_sifra_2a_p, 0);
  recagost_rec_l.naz_poduzeca := naz_poduzeca_p;
  recagost_rec_l.zanimanje := zanimanje_p;
  recagost_rec_l.ozn_spola := ozn_spola_p;
  recagost_rec_l.dat_rodjenja := dat_rodjenja_p;
  recagost_rec_l.vplabp_id := pra_rec_s3.vplabp_id (vplabp_sifra_p, 0);
  recagost_rec_l.zemr_id := pra_rec_s3.zem_id (zemr_sifra_2a_p, 0);
  recagost_rec_l.posr_id := pra_rec_s3.pos_id (posr_broj_p, recagost_rec_l.zemr_id, 0);
  recagost_rec_l.naz_mjrodj := naz_mjrodj_p;
  recagost_rec_l.zemd_id := pra_rec_s3.zem_id (zemd_sifra_2a_p, 0);
  recagost_rec_l.gpri_id := pra_rec_s3.gpri_id (gpri_sifra_p, 0);
  recagost_rec_l.vpisp_id := pra_rec_s3.vpisp_id (vpisp_sifra_p, 0);
  recagost_rec_l.br_pisprave := br_pisprave_p;
  recagost_rec_l.naz_mjpisp := naz_mjpisp_p;
  recagost_rec_l.napomena1 := napomena1_p;
  recagost_rec_l.napomena2 := napomena2_p;

  IF rbr_p IS NULL THEN
    naredba_l :=
      'SELECT pra_zmp_zaj.i3_sekvenca' || metcvor_sifra_centar_l || ' (NULL) FROM dual';
    EXECUTE IMMEDIATE naredba_l INTO recagost_rec_l.id;
    -- INSERT trec_agostiju
    pra_rec_iud2.insert_recagost_cvor (
      metcvor_sifra_p => metcvor_sifra_centar_l,
      recagost_rec_p => recagost_rec_l);
    odgovor_p := 'INSERTED';
  ELSE
    -- UPDATE trec_agostiju
    pra_rec_iud2.update_recagost_cvor (
      metcvor_sifra_p => metcvor_sifra_centar_l,
      recagost_rec_p => recagost_rec_l);
    odgovor_p := 'UPDATED';
  END IF;
  rowcount_l := SQL%ROWCOUNT;

  naredba_l :=
    'SELECT rbr FROM trec_agostiju' || metcvor_sifra_centar_l || ' WHERE id = :id';
  EXECUTE IMMEDIATE naredba_l INTO rbr_p USING recagost_rec_l.id;

  odgovor_p := 'OK [' || odgovor_p || ' ' || rowcount_l || ' ' || rbr_p || ']';

EXCEPTION
  WHEN OTHERS THEN
    odgovor_p := SUBSTR ('ERROR ' || SQLERRM, 1, 2000);
    -- IRN 3991
    pra_pka2.clob_to_table (TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || CHR(10) || log_opis_m || CHR(10) || SQLERRM || CHR(10) || CHR(10), log_file_name_m, NULL, 'CRM');
    RAISE; -- IRN 2861
END;
PROCEDURE PUNI_REZ1
 (CRMID_P IN t_rezervacije.crmid%TYPE
 ,GOD_POSLOVNA_P IN t_rezervacije.god_poslovna%TYPE
 ,SO_SIFRA_P IN m_so.sifra%TYPE
 ,RBR_P IN OUT t_rezervacije.rbr%TYPE
 ,DATUM_P IN t_rezervacije.datum%TYPE
 ,MS_SIFRA_P IN m_msegmenti.sifra%TYPE
 ,RECVPRO_SIFRA_P IN mrec_vprograma.sifra%TYPE
 ,RECAGOST_RBR_P IN trec_agostiju.rbr%TYPE
 ,AGE_SIFRA_P IN m_agencije.sifra%TYPE
 ,PON_GOD_POSLOVNA_P IN t_ponude.god_poslovna%TYPE
 ,PON_SO_SIFRA_P IN m_so.sifra%TYPE
 ,PON_RBR_P IN t_ponude.rbr%TYPE
 ,CJE_SIFRA_P IN t_cjenici.sifra%TYPE
 ,OZN_CJE_POSEB_P IN t_rezervacije.ozn_cje_poseb%TYPE
 ,RECNREZ_SIFRA_P IN mrec_nrezerviranja.sifra%TYPE
 ,TITULA_P IN t_rezervacije.titula%TYPE
 ,IME_P IN t_rezervacije.ime%TYPE
 ,PREZIME_P IN t_rezervacije.prezime%TYPE
 ,OZN_ABC_P IN t_rezervacije.ozn_abc%TYPE
 ,DAT_DOLASKA_P IN t_rezervacije.dat_dolaska%TYPE
 ,SAT_DOLASKA_P IN t_rezervacije.sat_dolaska%TYPE
 ,DAT_ODLASKA_P IN t_rezervacije.dat_odlaska%TYPE
 ,OZN_B_P IN t_rezervacije.ozn_b%TYPE
 ,OZN_F_P IN t_rezervacije.ozn_f%TYPE
 ,DAT_OPCIJE_P IN t_rezervacije.dat_opcije%TYPE
 ,OPIS_REZERVACIJE_MJESTA_P IN t_rezervacije.opis_rezervacije_mjesta%TYPE
 ,IZN_PREDUJMA_P IN t_rezervacije.izn_predujma%TYPE
 ,VAL_SIFRA_3A_P IN s_valute.sifra_3a%TYPE
 ,OZN_PLATITELJ_P IN t_rezervacije.ozn_platitelj%TYPE
 ,BR_UPUTNICE_P IN t_rezervacije.br_uputnice%TYPE
 ,STOPA_POPUSTA_P IN t_rezervacije.stopa_popusta%TYPE
 ,ZEMD_SIFRA_2A_P IN s_zemlje.sifra_2a%TYPE
 ,OZN_VIP_P IN t_rezervacije.ozn_vip%TYPE
 ,BR_OSOBA1_P IN t_rezervacije.br_osoba1%TYPE
 ,BR_OSOBA2_P IN t_rezervacije.br_osoba2%TYPE
 ,NAPOMENA_P IN t_rezervacije.napomena%TYPE
 ,JEZ_SIFRA_2A_P IN s_jezici.sifra_2a%TYPE
 ,ZEM_SIFRA_2A_P IN s_zemlje.sifra_2a%TYPE
 ,REG_SIFRA_P IN m_regije.sifra%TYPE
 ,NAZ_REGIJE_P IN t_rezervacije.naz_regije%TYPE
 ,POS_BROJ_P IN m_poste.broj%TYPE
 ,NAZ_MJESTA_P IN t_rezervacije.naz_mjesta%TYPE
 ,NAZ_ULICE_P IN t_rezervacije.naz_ulice%TYPE
 ,BR_TELEFONA_P IN t_rezervacije.br_telefona%TYPE
 ,EMAIL_P IN t_rezervacije.email%TYPE
 ,WWW_P IN t_rezervacije.www%TYPE
 ,VPLA_SIFRA_P IN s_vplacanja.sifra%TYPE
 ,OPIS1_P IN t_rezervacije.opis1%TYPE
 ,OPIS2_P IN t_rezervacije.opis2%TYPE
 ,DAT_KARTICE_P IN t_rezervacije.dat_kartice%TYPE
 ,IZN_KREDITNOG_LIMITA_P IN t_rezervacije.izn_kreditnog_limita%TYPE
 )
 IS
-- 
  recpro_opis_l lrec_promjene.opis%TYPE;
  rez_rec_l t_rezervacije%ROWTYPE;
  metcvor_sifra_centar_l VARCHAR2(41);
  metcvor_sifra_so_l VARCHAR2(41);
  naredba_l VARCHAR2(2000);
  error_text_l VARCHAR2(2000);
BEGIN

  IF pra_zmp_s.oznaka ('P0005') = 0 THEN
    RETURN;
  END IF;

  recpro_opis_l :=
    SUBSTR (
      crmid_p || '; ' ||
        god_poslovna_p || '; ' ||
        so_sifra_p || '; ' ||
        rbr_p || '; ' ||
        TO_CHAR (datum_p, 'DD.MM.RRRR') || '; ' ||
        ms_sifra_p || '; ' ||
        recvpro_sifra_p || '; ' ||
        recagost_rbr_p || '; ' ||
        age_sifra_p || '; ' ||
        pon_god_poslovna_p || '; ' ||
        pon_so_sifra_p || '; ' ||
        pon_rbr_p || '; ' ||
        cje_sifra_p || '; ' ||
        ozn_cje_poseb_p || '; ' ||
        recnrez_sifra_p || '; ' ||
        titula_p || '; ' ||
        ime_p || '; ' ||
        prezime_p || '; ' ||
        ozn_abc_p || '; ' ||
        TO_CHAR (dat_dolaska_p, 'DD.MM.RRRR') || '; ' ||
        TO_CHAR (sat_dolaska_p, 'DD.MM.RRRR HH24:MI') || '; ' ||
        TO_CHAR (dat_odlaska_p, 'DD.MM.RRRR') || '; ' ||
        ozn_b_p || '; ' ||
        ozn_f_p || '; ' ||
        TO_CHAR (dat_opcije_p, 'DD.MM.RRRR') || '; ' ||
        opis_rezervacije_mjesta_p || '; ' ||
        izn_predujma_p || '; ' ||
        val_sifra_3a_p || '; ' ||
        ozn_platitelj_p || '; ' ||
        br_uputnice_p || '; ' ||
        stopa_popusta_p || '; ' ||
        zemd_sifra_2a_p || '; ' ||
        ozn_vip_p || '; ' ||
        br_osoba1_p || '; ' ||
        br_osoba2_p || '; ' ||
        jez_sifra_2a_p || '; ' ||
        zem_sifra_2a_p || '; ' ||
        reg_sifra_p || '; ' ||
        naz_regije_p || '; ' ||
        pos_broj_p || '; ' ||
        naz_mjesta_p || '; ' ||
        naz_ulice_p || '; ' ||
        br_telefona_p || '; ' ||
        email_p || '; ' ||
        www_p || '; ' ||
        vpla_sifra_p || '; ' ||
        opis1_p || '; ' ||
        opis2_p || '; ' ||
        dat_kartice_p || '; ' ||
        izn_kreditnog_limita_p || '; ' ||
        napomena_p,
      1,
      2000);

  -- Nedostaje obvezan ulazni parametar (#0).
  -- crmid_p
  IF god_poslovna_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'god_poslovna_p');
  ELSIF so_sifra_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'so_sifra_p');
  -- rbr_p
  ELSIF datum_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'datum_p');
  ELSIF ms_sifra_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'ms_sifra_p');
  -- recvpro_sifra_p
  -- recagost_rbr_p
  -- age_sifra_p
  -- pon_god_poslovna_p
  -- pon_so_sifra_p
  -- pon_rbr_p
  ELSIF cje_sifra_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'cje_sifra_p');
  ELSIF ozn_cje_poseb_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'ozn_cje_poseb_p');
  -- recnrez_sifra_p
  -- titula_p
  -- ime_p
  ELSIF prezime_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'prezime_p');
  -- ozn_abc_p
  ELSIF dat_dolaska_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'dat_dolaska_p');
  -- sat_dolaska_p
  ELSIF dat_odlaska_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'dat_odlaska_p');
  ELSIF ozn_b_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'ozn_b_p');
  ELSIF ozn_f_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'ozn_f_p');
  -- dat_opcije_p
  -- opis_rezervacije_mjesta_p
  -- izn_predujma_p
  -- val_sifra_3a_p IS NULL THEN
  ELSIF ozn_platitelj_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'ozn_platitelj_p');
  -- br_uputnice_p
  -- stopa_popusta_p
  -- zemd_sifra_2a_p
  -- ozn_vip_p
  -- br_osoba1_p
  -- br_osoba2_p
  -- napomena_p
  -- jez_sifra_2a_p
  -- zem_sifra_2a_p
  -- reg_sifra_p
  -- naz_regije_p
  -- pos_broj_p
  -- naz_mjesta_p
  -- naz_ulice_p
  -- br_telefona_p
  -- email_p
  -- www_p
  -- vpla_sifra_p
  -- opis1_p
  -- opis2_p
  -- dat_kartice_p
  -- izn_kreditnog_limita_p
  END IF;

  /*
  09.05.2008. G.J. Tablica LREC_PROMJENE punit e se na tekuem voru
  metcvor_sifra_centar_l := pra_rec_s3.metcvor_sifra_centar;
  */
  metcvor_sifra_so_l := pra_rec_s3.metcvor_sifra_so (so_sifra_p);

  naredba_l :=
    'SELECT pra_zmp_zaj.i3_sekvenca' || metcvor_sifra_so_l || ' (NULL) FROM dual';
  EXECUTE IMMEDIATE naredba_l INTO rez_rec_l.id;
  rez_rec_l.so_id := pra_rec_s3.so_id (so_sifra_p => so_sifra_p, ozn_obvezan_p => -1, ozn_mora_postojati_p => -1);
  rez_rec_l.ms_id := pra_rec_s3.ms_id (ms_sifra_p);
  rez_rec_l.age_id := pra_rec_s3.age_id (age_sifra_p, 0);
  rez_rec_l.cje_id := pra_rec_s3.cje_id (cje_sifra_p);
  rez_rec_l.zem_id := pra_rec_s3.zem_id (zem_sifra_2a_p, 0);
  rez_rec_l.pos_id := pra_rec_s3.pos_id (pos_broj_p, rez_rec_l.zem_id, 0);
  rez_rec_l.reg_id := pra_rec_s3.reg_id (reg_sifra_p, rez_rec_l.zem_id, 0);
  rez_rec_l.recagost_id := pra_rec_s3.recagost_id (recagost_rbr_p, 0);
  rez_rec_l.val_id := pra_rec_s3.val_id (val_sifra_3a_p, 0);
  rez_rec_l.jez_id := pra_rec_s3.jez_id (jez_sifra_2a_p, 0);
  -- pkaadr_id
  rez_rec_l.zemd_id := pra_rec_s3.zem_id (zemd_sifra_2a_p, 0);
  rez_rec_l.vpla_id := pra_rec_s3.vpla_id (vpla_sifra_p, 0);
  rez_rec_l.recvpro_id := pra_rec_s3.recvpro_id (recvpro_sifra_p, 0);
  rez_rec_l.recnrez_id := pra_rec_s3.recnrez_id (recnrez_sifra_p, 0);
  rez_rec_l.god_poslovna := god_poslovna_p;
  -- rbr
  rez_rec_l.ozn_valjanosti := 'V';
  rez_rec_l.oznaka := 'V';
  -- ozn_vstorna
  rez_rec_l.datum := datum_p;
  rez_rec_l.titula := titula_p;
  rez_rec_l.ime := ime_p;
  rez_rec_l.prezime := prezime_p;
  rez_rec_l.naz_ulice := naz_ulice_p;
  rez_rec_l.naz_mjesta := naz_mjesta_p;
  rez_rec_l.naz_regije := naz_regije_p;
  rez_rec_l.email := email_p;
  rez_rec_l.www := www_p;
  rez_rec_l.dat_dolaska := dat_dolaska_p;
  rez_rec_l.sat_dolaska := sat_dolaska_p;
  rez_rec_l.dat_odlaska := dat_odlaska_p;
  rez_rec_l.ozn_cje_poseb := ozn_cje_poseb_p;
  rez_rec_l.ozn_b := ozn_b_p;
  rez_rec_l.ozn_f := ozn_f_p;
  rez_rec_l.ozn_abc := ozn_abc_p;
  rez_rec_l.br_uputnice := br_uputnice_p;
  rez_rec_l.stopa_popusta := stopa_popusta_p;
  rez_rec_l.dat_opcije := dat_opcije_p;
  rez_rec_l.izn_predujma := izn_predujma_p;
  rez_rec_l.opis1 := opis1_p;
  rez_rec_l.opis2 := opis2_p;
  rez_rec_l.dat_kartice := dat_kartice_p;
  rez_rec_l.napomena := napomena_p;
  rez_rec_l.br_osoba1 := br_osoba1_p;
  rez_rec_l.br_osoba2 := br_osoba2_p;
  rez_rec_l.opis_rezervacije_mjesta := opis_rezervacije_mjesta_p;
  rez_rec_l.br_telefona := br_telefona_p;
  rez_rec_l.ozn_vip := ozn_vip_p;
  -- naz_autorizacijskog_servisa
  -- br_transakcije
  rez_rec_l.izn_kreditnog_limita := izn_kreditnog_limita_p;
  rez_rec_l.ozn_platitelj := ozn_platitelj_p;
  rez_rec_l.ozn_newsletter := 0; -- G.J. 30.01.2009. IRN 801
  IF pon_god_poslovna_p IS NOT NULL AND pon_so_sifra_p IS NOT NULL AND pon_rbr_p IS NOT NULL THEN
    SELECT MAX (ponso.id) INTO rez_rec_l.ponso_id
      FROM t_pon_so ponso,
           t_pon_ojr ponojr,
           t_ponude pon
     WHERE ponso.so_id = (SELECT id FROM m_so WHERE sifra = pon_so_sifra_p)
       AND ponso.ponojr_id = ponojr.id
       AND ponojr.pon_id = pon.id
       AND pon.god_poslovna = pon_god_poslovna_p
       AND pon.rbr = pon_rbr_p;
  END IF;
  rez_rec_l.crmid := crmid_p;
  rez_rec_l.unos_korisnik := zmp_zaj.korisnik (-1); -- IRN 1383
  rez_rec_l.unos_dat := SYSDATE; -- IRN 1383

  pra_rec_iud2.insert_rez_cvor (
    metcvor_sifra_p => metcvor_sifra_so_l,
    rez_rec_p => rez_rec_l);

  naredba_l :=
    'SELECT rbr FROM t_rezervacije' || metcvor_sifra_so_l || ' WHERE id = :id';
  EXECUTE IMMEDIATE naredba_l INTO rbr_p USING rez_rec_l.id;

  pra_rec.puni_promjene ('9151', recpro_opis_l, -1);

EXCEPTION
  WHEN OTHERS THEN
    error_text_l := SUBSTR (SQLERRM || ' ' || recpro_opis_l, 1, 2000);
    pra_rec.puni_promjene ('9151', recpro_opis_l, 0);
    pra_rec.puni_promjene ('9151', error_text_l, 0);
    RAISE;
END;
PROCEDURE PUNI_REZVSJ
 (GOD_POSLOVNA_P IN t_rezervacije.god_poslovna%TYPE
 ,SO_SIFRA_P IN m_so.sifra%TYPE
 ,RBR_P IN t_rezervacije.rbr%TYPE
 ,VSJ_SIFRA_P IN s_vsj.sifra%TYPE
 ,VSJC_SIFRA_P IN s_vsj.sifra%TYPE
 ,SJ_BROJ_P IN m_sj.broj%TYPE
 ,KOL_SJ_P IN t_rez_vsj.kol_sj%TYPE
 ,BR_OSOBA_P IN t_rez_vsj.br_osoba%TYPE
 )
 IS
--
  recpro_opis_l lrec_promjene.opis%TYPE;
  metcvor_sifra_so_l VARCHAR2(41);
  rezvsj_rec_l t_rez_vsj%ROWTYPE;
  so_id_l m_so.id%TYPE;
  naredba_l VARCHAR2(2000);
  error_text_l VARCHAR2(2000);
BEGIN

  IF pra_zmp_s.oznaka ('P0006') = 0 THEN
    RETURN;
  END IF;

  recpro_opis_l :=
    SUBSTR (
      god_poslovna_p || '; ' ||
        so_sifra_p || '; ' ||
        rbr_p || '; ' ||
        vsj_sifra_p || '; ' ||
        vsjc_sifra_p || '; ' ||
        sj_broj_p || '; ' ||
        kol_sj_p || '; ' ||
        br_osoba_p,
      1,
      2000);

  -- Nedostaje obvezan ulazni parametar (#0).
  IF god_poslovna_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'god_poslovna_p');
  ELSIF so_sifra_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'so_sifra_p');
  ELSIF rbr_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'rbr_p');
  ELSIF vsj_sifra_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'vsj_sifra_p');
  ELSIF vsjc_sifra_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'vsjc_sifra_p');
  -- sj_broj_p
  ELSIF kol_sj_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'kol_sj_p');
  ELSIF br_osoba_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'br_osoba_p');
  END IF;

  metcvor_sifra_so_l := pra_rec_s3.metcvor_sifra_so (so_sifra_p);

  naredba_l :=
    'SELECT id, so_id
       FROM t_rezervacije' || metcvor_sifra_so_l || '
      WHERE god_poslovna = :god_poslovna_p
        AND so_id = (SELECT id FROM m_so WHERE sifra = :so_sifra_p)
        AND rbr = :rbr_p';
  EXECUTE IMMEDIATE naredba_l INTO rezvsj_rec_l.rez_id, so_id_l USING god_poslovna_p, so_sifra_p, rbr_p;

  IF rezvsj_rec_l.rez_id IS NULL THEN
    -- Nedostaje podatak (#0 #1).
    pra_rec_zaj.vrati_poruku (-20445, pra_zmp_zaj.poruka ('REC', 'REC_REZ'), god_poslovna_p || '-' || so_sifra_p || '-' || rbr_p);
  END IF;

  rezvsj_rec_l.vsj_id := pra_rec_s3.vsj_id (vsj_sifra_p);
  rezvsj_rec_l.vsjc_id := pra_rec_s3.vsj_id (vsjc_sifra_p);
  rezvsj_rec_l.sj_id := pra_rec_s3.sj_id (sj_broj_p, so_id_l, 0);
  rezvsj_rec_l.kol_sj := kol_sj_p;
  rezvsj_rec_l.br_osoba := br_osoba_p;
  rezvsj_rec_l.unos_korisnik := zmp_zaj.korisnik (-1); -- IRN 1383
  rezvsj_rec_l.unos_dat := SYSDATE; -- IRN 1383

  pra_rec_iud2.insert_rezvsj_cvor (
    metcvor_sifra_p => metcvor_sifra_so_l,
    rezvsj_rec_p => rezvsj_rec_l);

  pra_rec.puni_promjene ('9152', recpro_opis_l, -1);

EXCEPTION
  WHEN OTHERS THEN
    error_text_l := SUBSTR (SQLERRM || ' ' || recpro_opis_l, 1, 2000);
    pra_rec.puni_promjene ('9152', recpro_opis_l, 0);
    pra_rec.puni_promjene ('9152', error_text_l, 0);
    RAISE;
END;
PROCEDURE PUNI_REZUSL
 (GOD_POSLOVNA_P IN t_rezervacije.god_poslovna%TYPE
 ,SO_SIFRA_P IN m_so.sifra%TYPE
 ,RBR_P IN t_rezervacije.rbr%TYPE
 ,USL_SIFRA_P IN s_usluge.sifra%TYPE
 ,SAS_SIFRA_P IN s_sastojci.sifra%TYPE
 ,RECARA_SIFRA_P IN mrec_aranzmani.sifra%TYPE
 ,USLC_SIFRA_P IN s_usluge.sifra%TYPE
 ,DAT_POC_P IN t_rez_usl.dat_poc%TYPE
 ,DAT_ZAV_P IN t_rez_usl.dat_zav%TYPE
 ,OZN_UGO_P IN t_rez_usl.ozn_ugo%TYPE
 ,OZN_PLATITELJA_P IN t_rez_usl.ozn_platitelja%TYPE
 )
 IS
--
  recpro_opis_l lrec_promjene.opis%TYPE;
  rezusl_rec_l t_rez_usl%ROWTYPE;
  metcvor_sifra_so_l VARCHAR2(41);
  naredba_l VARCHAR2(2000);
  error_text_l VARCHAR2(2000);
  -- 02.02.2009. G.J. IRN 801
  ponso_id_l t_rezervacije.ponso_id%TYPE;
BEGIN

  IF pra_zmp_s.oznaka ('P0007') = 0 THEN
    RETURN;
  END IF;

  recpro_opis_l :=
    SUBSTR (
      god_poslovna_p || '; ' ||
        so_sifra_p || '; ' ||
        rbr_p || '; ' ||
        usl_sifra_p || '; ' ||
        sas_sifra_p || '; ' ||
        recara_sifra_p || '; ' ||
        uslc_sifra_p || '; ' ||
        TO_CHAR (dat_poc_p, 'DD.MM.RRRR') || '; ' ||
        TO_CHAR (dat_zav_p, 'DD.MM.RRRR') || '; ' ||
        ozn_ugo_p || '; ' ||
        ozn_platitelja_p,
      1,
      2000);

  -- Nedostaje obvezan ulazni parametar (#0).
  IF god_poslovna_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'god_poslovna_p');
  ELSIF so_sifra_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'so_sifra_p');
  ELSIF rbr_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'rbr_p');
  ELSIF usl_sifra_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'usl_sifra_p');
  -- sas_sifra_p
  -- recara_sifra_p
  -- uslc_sifra_p
  -- dat_poc_p
  -- dat_zav_p
  -- ozn_ugo_p
  ELSIF ozn_platitelja_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'ozn_platitelja_p');
  END IF;

  metcvor_sifra_so_l := pra_rec_s3.metcvor_sifra_so (so_sifra_p);

  naredba_l :=
    'SELECT id, ponso_id
       FROM t_rezervacije' || metcvor_sifra_so_l || '
      WHERE god_poslovna = :god_poslovna_p
        AND so_id = (SELECT id FROM m_so WHERE sifra = :so_sifra_p)
        AND rbr = :rbr_p';
  EXECUTE IMMEDIATE naredba_l INTO rezusl_rec_l.rez_id, ponso_id_l USING god_poslovna_p, so_sifra_p, rbr_p;

  IF rezusl_rec_l.rez_id IS NULL THEN
    -- Nedostaje podatak (#0 #1).
    pra_rec_zaj.vrati_poruku (-20445, pra_zmp_zaj.poruka ('REC', 'REC_REZ'), god_poslovna_p || '-' || so_sifra_p || '-' || rbr_p);
  END IF;

  rezusl_rec_l.usl_id := pra_rec_s3.usl_id (usl_sifra_p);
  rezusl_rec_l.sas_id := pra_rec_s3.sas_id (sas_sifra_p, 0);
  pra_rec3.provjeri_sastojak_poc (rezusl_rec_l.usl_id, rezusl_rec_l.sas_id);
  rezusl_rec_l.dat_poc := dat_poc_p;
  rezusl_rec_l.dat_zav := dat_zav_p;
  rezusl_rec_l.recara_id := pra_rec_s3.recara_id (recara_sifra_p, 0);
  rezusl_rec_l.ozn_platitelja := ozn_platitelja_p;
  IF ponso_id_l IS NOT NULL THEN
    rezusl_rec_l.ozn_ugo := NVL (ozn_ugo_p, -1);
  ELSE
    rezusl_rec_l.ozn_ugo := 0;
  END IF;
  rezusl_rec_l.usl_id1 := pra_rec_s3.usl_id (uslc_sifra_p, 0);
  rezusl_rec_l.unos_korisnik := zmp_zaj.korisnik (-1); -- IRN 1383
  rezusl_rec_l.unos_dat := SYSDATE; -- IRN 1383

  pra_rec_iud2.insert_rezusl_cvor (
    metcvor_sifra_p => metcvor_sifra_so_l,
    rezusl_rec_p => rezusl_rec_l);

  pra_rec.puni_promjene ('9153', recpro_opis_l, -1);

EXCEPTION
  WHEN OTHERS THEN
    error_text_l := SUBSTR (SQLERRM || ' ' || recpro_opis_l, 1, 2000);
    pra_rec.puni_promjene ('9153', recpro_opis_l, 0);
    pra_rec.puni_promjene ('9153', error_text_l, 0);
    RAISE;
END;
PROCEDURE PUNI_RECREZCJE
 (GOD_POSLOVNA_P IN t_rezervacije.god_poslovna%TYPE
 ,SO_SIFRA_P IN m_so.sifra%TYPE
 ,RBR_P IN t_rezervacije.rbr%TYPE
 ,VSJC_SIFRA_P IN s_vsj.sifra%TYPE
 ,USL_SIFRA_P IN s_usluge.sifra%TYPE
 ,DAT_POC_P IN trec_rez_cjeusl.dat_poc%TYPE
 ,DAT_ZAV_P IN trec_rez_cjeusl.dat_zav%TYPE
 ,CIJENA_USLUGE_P IN trec_rez_cjeusl.cijena_usluge%TYPE
 )
 IS
--
  recpro_opis_l lrec_promjene.opis%TYPE;
  recrezcje_rec_l trec_rez_cjeusl%ROWTYPE;
  metcvor_sifra_so_l VARCHAR2(41);
  naredba_l VARCHAR2(2000);
  error_text_l VARCHAR2(2000);
BEGIN

  IF pra_zmp_s.oznaka ('P0008') = 0 THEN
    RETURN;
  END IF;

  recpro_opis_l :=
    SUBSTR (
      god_poslovna_p || '; ' ||
        so_sifra_p || '; ' ||
        rbr_p || '; ' ||
        vsjc_sifra_p || '; ' ||
        usl_sifra_p || '; ' ||
        TO_CHAR (dat_poc_p, 'DD.MM.RRRR') || '; ' ||
        TO_CHAR (dat_zav_p, 'DD.MM.RRRR') || '; ' ||
        cijena_usluge_p,
      1,
      2000);

  -- Nedostaje obvezan ulazni parametar (#0).
  IF god_poslovna_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'god_poslovna_p');
  ELSIF so_sifra_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'so_sifra_p');
  ELSIF rbr_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'rbr_p');
  -- vsjc_sifra_p
  ELSIF usl_sifra_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'usl_sifra_p');
  ELSIF dat_poc_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'dat_poc_p');
  ELSIF dat_zav_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'dat_zav_p');
  ELSIF cijena_usluge_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'cijena_usluge_p');
  END IF;

  metcvor_sifra_so_l := pra_rec_s3.metcvor_sifra_so (so_sifra_p);

  naredba_l :=
    'SELECT id
       FROM t_rezervacije' || metcvor_sifra_so_l || '
      WHERE god_poslovna = :god_poslovna_p
        AND so_id = (SELECT id FROM m_so WHERE sifra = :so_sifra_p)
        AND rbr = :rbr_p';
  EXECUTE IMMEDIATE naredba_l INTO recrezcje_rec_l.rez_id USING god_poslovna_p, so_sifra_p, rbr_p;

  IF recrezcje_rec_l.rez_id IS NULL THEN
    -- Nedostaje podatak (#0 #1).
    pra_rec_zaj.vrati_poruku (-20445, pra_zmp_zaj.poruka ('REC', 'REC_REZ'), god_poslovna_p || '-' || so_sifra_p || '-' || rbr_p);
  END IF;

  recrezcje_rec_l.vsj_id := pra_rec_s3.vsj_id (vsjc_sifra_p, 0);
  recrezcje_rec_l.usl_id := pra_rec_s3.usl_id (usl_sifra_p);
  recrezcje_rec_l.dat_poc := dat_poc_p;
  recrezcje_rec_l.dat_zav := dat_zav_p;
  recrezcje_rec_l.cijena_usluge := cijena_usluge_p;
  recrezcje_rec_l.unos_korisnik := zmp_zaj.korisnik (-1); -- IRN 1383
  recrezcje_rec_l.unos_dat := SYSDATE; -- IRN 1383

  pra_rec_iud2.insert_recrezcje_cvor (
    metcvor_sifra_p => metcvor_sifra_so_l,
    recrezcje_rec_p => recrezcje_rec_l);

  pra_rec.puni_promjene ('9154', recpro_opis_l, -1);

EXCEPTION
  WHEN OTHERS THEN
    error_text_l := SUBSTR (SQLERRM || ' ' || recpro_opis_l, 1, 2000);
    pra_rec.puni_promjene ('9154', recpro_opis_l, 0);
    pra_rec.puni_promjene ('9154', error_text_l, 0);
    RAISE;
END;
PROCEDURE PONISTI_REZ
 (GOD_POSLOVNA_P IN t_rezervacije.god_poslovna%TYPE
 ,SO_SIFRA_P IN m_so.sifra%TYPE
 ,RBR_P IN t_rezervacije.rbr%TYPE
 ,OZN_VSTORNA_P IN t_rezervacije.ozn_vstorna%TYPE
 ,NAPOMENA_P IN t_rezervacije.napomena%TYPE
 )
 IS
--
  recpro_opis_l lrec_promjene.opis%TYPE;
  metcvor_sifra_so_l VARCHAR2(41);
  so_id_l m_so.id%TYPE;
  naredba_l VARCHAR2(2000);
  error_text_l VARCHAR2(2000);
BEGIN

  IF pra_zmp_s.oznaka ('P0009') = 0 THEN
    RETURN;
  END IF;

  recpro_opis_l :=
    SUBSTR (
      god_poslovna_p || '; ' ||
        so_sifra_p || '; ' ||
        rbr_p || '; ' ||
        ozn_vstorna_p || '; ' ||
        napomena_p,
      1,
      2000);

  -- Nedostaje obvezan ulazni parametar (#0).
  IF god_poslovna_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'god_poslovna_p');
  ELSIF so_sifra_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'so_sifra_p');
  ELSIF rbr_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'rbr_p');
  ELSIF ozn_vstorna_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'ozn_vstorna_p');
  -- napomena_p
  END IF;

  metcvor_sifra_so_l := pra_rec_s3.metcvor_sifra_so (so_sifra_p);

  so_id_l := pra_rec_s3.so_id (so_sifra_p => so_sifra_p, ozn_obvezan_p => -1, ozn_mora_postojati_p => -1);

  naredba_l :=
    'UPDATE t_rezervacije' || metcvor_sifra_so_l || '
        SET oznaka = ''P'',
            ozn_vstorna = :ozn_vstorna,
            napomena = SUBSTR (:napomena || ''; '' || napomena, 1, 2000)
      WHERE god_poslovna = :god_poslovna
        AND so_id = :so_id
        AND rbr = :rbr';
  EXECUTE IMMEDIATE naredba_l USING ozn_vstorna_p, napomena_p, god_poslovna_p, so_id_l, rbr_p;

  pra_rec.puni_promjene ('9171', recpro_opis_l, -1);

EXCEPTION
  WHEN OTHERS THEN
    error_text_l := SUBSTR (SQLERRM || ' ' || recpro_opis_l, 1, 2000);
    pra_rec.puni_promjene ('9171', recpro_opis_l, 0);
    pra_rec.puni_promjene ('9171', error_text_l, 0);
    RAISE;
END;
PROCEDURE SPOJI_RECAGOST
 (RBR1_P IN trec_agostiju.rbr%TYPE
 ,RBR2_P IN trec_agostiju.rbr%TYPE
 ,ODGOVOR_P OUT VARCHAR2
 )
 IS
--
  CURSOR recagost_c (rbr_k IN trec_agostiju.rbr%TYPE) IS
    SELECT id, oznaka, ime, prezime, recagostv_id FROM trec_agostiju WHERE rbr = rbr_k;

  row1_l recagost_c%ROWTYPE; -- zapis koji ostaje valjan
  row2_l recagost_c%ROWTYPE; -- zapis ije boravke treba preseliti valjanom zapisu i kojeg treba ponititi

  CURSOR rez_c (rbr_k IN trec_agostiju.rbr%TYPE) IS
    SELECT so_sifra || '-' || god_poslovna || '-' || rbr AS rbr, prezime
      FROM v_crm_rezervacije
     WHERE oznaka = 'V'
       AND dat_dolaska >= TRUNC (SYSDATE)
       AND recagost_rbr = rbr_k;
  rez_c_l rez_c%ROWTYPE;

  CURSOR gost_c (rbr_k IN trec_agostiju.rbr%TYPE) IS
    SELECT so_sifra || '-' || god_poslovna || '-' || rbr AS rbr, prezime
      FROM v_crm_gosti
     WHERE ozn_prisutnosti = 'P'
       AND recagost_rbr = rbr_k;
  gost_c_l gost_c%ROWTYPE;

  rowcount_l NUMBER := 0;
  rowcount2_l NUMBER := 0;
BEGIN

  log_file_name_m := 'crm-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '-a.log';
  log_opis_m := 'pra_rec_crm.spoji_recagost; ' || rbr1_p || '; ' || rbr2_p;

  IF pra_zmp_s.oznaka ('P0010') = 0 THEN
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  IF rbr1_p IS NULL THEN
    -- Nedostaje obvezan ulazni parametar (#0).
    pra_rec_zaj.vrati_poruku (-20422, 'rbr1_p');
  ELSIF rbr2_p IS NULL THEN
    -- Nedostaje obvezan ulazni parametar (#0).
    pra_rec_zaj.vrati_poruku (-20422, 'rbr2_p');
  END IF;

  IF pra_zmp_zaj.centar = 0 THEN
    -- Samo vor Centar moe aurirati podatke u arhivi gostiju (tekui vor je #0).
    pra_rec_zaj.vrati_poruku (-20546, pra_zmp_zaj.tekuci_cvor);
  END IF;

  IF UPPER (pra_zmp_zaj.vrijednost_parametra ('0019')) <> 'NEBITNO'
    AND pra_zmp_zaj.vrijednost_parametra ('0019') <> pra_zmp_zaj.tekuci_cvor
  THEN
    -- Samo vor Centar moe aurirati podatke u arhivi gostiju (tekui vor je #0).
    pra_rec_zaj.vrati_poruku (-20546, pra_zmp_zaj.tekuci_cvor);
  END IF;

  OPEN recagost_c (rbr1_p);
  FETCH recagost_c INTO row1_l;
  CLOSE recagost_c;
  IF row1_l.id IS NULL THEN
    -- Nedostaje podatak (#0 #1).
    pra_rec_zaj.vrati_poruku (-20445, pra_zmp_zaj.poruka ('REC', 'REC_RECAGOST'), rbr1_p);
  END IF;

  log_opis_m := log_opis_m || CHR(10) || rbr1_p || ' (' || row1_l.oznaka || ') ' || row1_l.ime || ' ' || row1_l.prezime;

  IF row1_l.oznaka = 'P' THEN
    -- Zapis (#0) je poniten.
    pra_rec_zaj.vrati_poruku (-20637, rbr1_p);
  END IF;

  OPEN recagost_c (rbr2_p);
  FETCH recagost_c INTO row2_l;
  CLOSE recagost_c;
  IF row2_l.id IS NULL THEN -- IRN 3239
    -- Nedostaje podatak (#0 #1).
    pra_rec_zaj.vrati_poruku (-20445, pra_zmp_zaj.poruka ('REC', 'REC_RECAGOST'), rbr2_p);
  END IF;

  log_opis_m := log_opis_m || ' | ' || rbr2_p || ' (' || row2_l.oznaka || ') ' || row2_l.ime || ' ' || row2_l.prezime;

  -- IRN 3991
  IF row2_l.oznaka = 'P' AND row2_l.recagostv_id IS NOT NULL THEN
    -- Zapis rbr #0 ve je povezan i poniten.
    pra_rec_zaj.vrati_poruku (-20133, rbr2_p);
  END IF;

  -- zabrani spajanje zapisa s razliitim imenom
  IF CONVERT (UPPER (row1_l.ime), 'US7ASCII') = CONVERT (UPPER (row2_l.ime), 'US7ASCII')
    AND CONVERT (UPPER (row1_l.prezime), 'US7ASCII') = CONVERT (UPPER (row2_l.prezime), 'US7ASCII')
  THEN
    NULL;
  ELSE
    -- Ime i prezime u zapisu #0 je #1, a ime i prezime u zapisu #2 je #3.
    pra_rec_zaj.vrati_poruku (
      -20129,
      rbr1_p || ' (' || row1_l.oznaka || ')',
      row1_l.ime || ' ' || row1_l.prezime,
      rbr2_p || ' (' || row2_l.oznaka || ')',
      row2_l.ime || ' ' || row2_l.prezime);
  END IF;

  IF row2_l.oznaka = 'V' THEN
    OPEN rez_c (rbr2_p);
    FETCH rez_c INTO rez_c_l;
    IF rez_c%FOUND THEN
      CLOSE rez_c;
      -- Postoji valjana rezervacija broj #0 na prezime #1 povezana na arhivu rbr #2.
      pra_rec_zaj.vrati_poruku (-20134, rez_c_l.rbr, rez_c_l.prezime, rbr2_p);
    END IF;
    CLOSE rez_c;

    OPEN gost_c (rbr2_p);
    FETCH gost_c INTO gost_c_l;
    IF gost_c%FOUND THEN
      CLOSE gost_c;
      -- Postoji prisutan gost #0 #1 povezan na arhivu rbr #2.
      pra_rec_zaj.vrati_poruku (-20135, gost_c_l.rbr, gost_c_l.prezime, rbr2_p);
    END IF;
    CLOSE gost_c;
  END IF;
  -- KRAJ IRN 3991

  UPDATE irec_agost_boravci
     SET recagost_id = row1_l.id
   WHERE recagost_id = row2_l.id;
  rowcount2_l := SQL%ROWCOUNT;

  UPDATE tloy_kartice -- IRN 2839
     SET recagost_id = row1_l.id
   WHERE recagost_id = row2_l.id;
  rowcount2_l := rowcount2_l + SQL%ROWCOUNT;

  -- tloy_ulaz, tloy_izlaz

  UPDATE trec_agostiju
     SET oznaka = 'P',
         recagostv_id = row1_l.id
   WHERE id = row2_l.id;
  rowcount_l := SQL%ROWCOUNT;

  odgovor_p := 'OK [UPDATED ' || rowcount_l || ' + ' || rowcount2_l || ']'; -- IRN 2839
  pra_pka2.clob_to_table (TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || CHR(10) || log_opis_m || CHR(10) || odgovor_p || CHR(10) || CHR(10), log_file_name_m, NULL, 'CRM');

EXCEPTION
  WHEN OTHERS THEN
    odgovor_p := SUBSTR ('ERROR ' || SQLERRM, 1, 2000);
    -- IRN 3991; pogreke se spremaju u lpka_clob
    pra_pka2.clob_to_table (TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || CHR(10) || log_opis_m || CHR(10) || SQLERRM || CHR(10) || CHR(10), log_file_name_m, NULL, 'CRM');
    RAISE; -- IRN 2861
END;
PROCEDURE AZURIRAJ_AGE_OSOBE
 (ID_P IN OUT m_age_gzem.id%TYPE
 ,AGE_SIFRA_P IN m_agencije.sifra%TYPE
 ,GZEM_SIFRA_P IN m_gzemalja.sifra%TYPE
 ,TITULA_P IN m_age_gzem.titula%TYPE
 ,IME_P IN m_age_gzem.ime%TYPE
 ,PREZIME_P IN m_age_gzem.prezime%TYPE
 ,BR_TELEFONA_P IN m_agencije.br_telefona%TYPE
 ,BR_TELEFAKSA_P IN m_agencije.br_telefaksa%TYPE
 ,EMAIL_P IN m_agencije.email%TYPE
 ,NAPOMENA_P IN m_agencije.napomena%TYPE
 )
 IS
-- Procedura aurira podatke u tablici m_age_gzem na podcentru.
  recpro_opis_l lrec_promjene.opis%TYPE;
  br_redaka_l NUMBER;
  agegzem_rec_l m_age_gzem%ROWTYPE;
  error_text_l VARCHAR2(2000);
BEGIN

  IF pra_zmp_s.oznaka ('P0011') = 0 THEN
    RETURN;
  END IF;

  recpro_opis_l :=
    SUBSTR (
      id_p || '; ' ||
        age_sifra_p || '; ' ||
        gzem_sifra_p || '; ' ||
        titula_p || '; ' ||
        ime_p || '; ' ||
        prezime_p || '; ' ||
        br_telefona_p || '; ' ||
        br_telefaksa_p || '; ' ||
        email_p || '; ' ||
        napomena_p,
      1,
      2000);

  -- Nedostaje obvezan ulazni parametar (#0).
  -- id_p
  IF age_sifra_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'age_sifra_p');
  -- gzem_sifra_p
  -- titula_p
  ELSIF ime_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'ime_p');
  ELSIF prezime_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'prezime_p');
  -- br_telefona_p
  -- br_telefaksa_p
  -- email_p
  -- napomena_p
  END IF;

  IF pra_zmp_zaj.tekuci_cvor = pra_zmp_zaj.vrijednost_parametra ('0018') THEN
    NULL;
  ELSE
    -- vor #0 nije niti Centar niti Podcentar.
    pra_zmp_zaj.vrati_poruku (-20095, pra_zmp_zaj.tekuci_cvor);
  END IF;

  IF id_p IS NOT NULL THEN
    -- provjeri postoji li odgovarajui redak
    SELECT COUNT(rowid) INTO br_redaka_l FROM m_age_gzem WHERE id = id_p;
    IF br_redaka_l = 0 THEN
      -- Pogrena vrijednost parametra #0.
      pra_rec_zaj.vrati_poruku (-20474, 'id_p');
    END IF;
    -- uitaj sve podatke
    SELECT * INTO agegzem_rec_l FROM m_age_gzem WHERE id = id_p;
  END IF;

  agegzem_rec_l.age_id := pra_rec_s3.age_id (age_sifra_p);
  agegzem_rec_l.gzem_id := pra_rec_s3.gzem_id (gzem_sifra_p, 0);
  agegzem_rec_l.titula := titula_p;
  agegzem_rec_l.ime := ime_p;
  agegzem_rec_l.prezime := prezime_p;
  agegzem_rec_l.br_telefona := br_telefona_p;
  agegzem_rec_l.br_telefaksa := br_telefaksa_p;
  agegzem_rec_l.email := email_p;
  agegzem_rec_l.napomena := napomena_p;

  IF id_p IS NULL THEN
    -- INSERT m_age_gzem
    agegzem_rec_l.id := pra_zmp_zaj.i3_sekvenca (NULL);
    INSERT INTO m_age_gzem VALUES agegzem_rec_l;
  ELSE
    -- UPDATE m_age_gzem
    agegzem_rec_l.id := id_p;
    UPDATE m_age_gzem SET ROW = agegzem_rec_l WHERE id = id_p;
  END IF;

  pra_rec.puni_promjene ('9121', recpro_opis_l, -1);

  id_p := agegzem_rec_l.id;

EXCEPTION
  WHEN OTHERS THEN
    error_text_l := SUBSTR (SQLERRM || ' ' || recpro_opis_l, 1, 2000);
    pra_rec.puni_promjene ('9121', recpro_opis_l, 0);
    pra_rec.puni_promjene ('9121', error_text_l, 0);
    RAISE;
END;
PROCEDURE AZURIRAJ_REZ_RECAGOST
 (REZ_GOD_POSLOVNA_P IN t_rezervacije.god_poslovna%TYPE
 ,SO_SIFRA_P IN m_so.sifra%TYPE
 ,REZ_RBR_P IN t_rezervacije.rbr%TYPE
 ,RECAGOST_RBR_P IN trec_agostiju.rbr%TYPE
 ,ODGOVOR_P OUT VARCHAR2
 )
 IS
-- IRN 1778; auriraj t_rezervacije.recagost_id
  CURSOR recagost_c IS
    SELECT id, oznaka, ime, prezime FROM trec_agostiju WHERE rbr = recagost_rbr_p;
  recagost_row_l recagost_c%ROWTYPE;

  metcvor_sifra_so_l VARCHAR2(41);
  naredba_l VARCHAR2(2000);
  rez_id_l t_rezervacije.id%TYPE;
  rez_ime_l t_rezervacije.ime%TYPE;
  rez_prezime_l t_rezervacije.prezime%TYPE;
  rowcount_l NUMBER := 0;
BEGIN

  log_file_name_m := 'crm-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '-r.log';
  log_opis_m := 'pra_rec_crm.azuriraj_rez_recagost; ' || rez_god_poslovna_p || '; ' || so_sifra_p || '; ' || rez_rbr_p || '; ' || recagost_rbr_p;

  IF pra_zmp_s.oznaka ('P0012') = 0 THEN
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  -- Nedostaje obvezan ulazni parametar (#0).
  IF rez_god_poslovna_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'rez_god_poslovna_p');
  ELSIF so_sifra_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'so_sifra_p');
  ELSIF rez_rbr_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'rez_rbr_p');
  ELSIF recagost_rbr_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'recagost_rbr_p');
  END IF;

  OPEN recagost_c;
  FETCH recagost_c INTO recagost_row_l;
  CLOSE recagost_c;
  IF recagost_row_l.id IS NULL THEN
    -- Nedostaje podatak (#0 #1).
    pra_rec_zaj.vrati_poruku (-20445, pra_zmp_zaj.poruka ('REC', 'REC_RECAGOST'), recagost_rbr_p);
  END IF;
  IF recagost_row_l.oznaka = 'P' THEN
    -- Zapis (#0) je poniten.
    pra_rec_zaj.vrati_poruku (-20637, recagost_rbr_p);
  END IF;

  metcvor_sifra_so_l := pra_rec_s3.metcvor_sifra_so (so_sifra_p);
  naredba_l :=
    'SELECT id, ime, prezime
       FROM t_rezervacije<CVOR>
      WHERE god_poslovna = :god_poslovna
        AND so_id = (SELECT id FROM m_so WHERE sifra = :sifra)
        AND rbr = :rbr';
  BEGIN
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', metcvor_sifra_so_l)
       INTO rez_id_l, rez_ime_l, rez_prezime_l
      USING rez_god_poslovna_p, so_sifra_p, rez_rbr_p;
  EXCEPTION
    WHEN OTHERS THEN
      NULL; -- IRN 4108; moe biti i no data found
  END;
  IF rez_id_l IS NULL THEN
    -- Nedostaje podatak (#0 #1).
    pra_rec_zaj.vrati_poruku (-20445, pra_zmp_zaj.poruka ('REC', 'REC_REZ'), rez_god_poslovna_p || '-' || so_sifra_p || '-' || rez_rbr_p);
  END IF;

  -- IRN 3991
  IF CONVERT (UPPER (rez_ime_l), 'US7ASCII') = CONVERT (UPPER (recagost_row_l.ime), 'US7ASCII')
    AND CONVERT (UPPER (rez_prezime_l), 'US7ASCII') = CONVERT (UPPER (recagost_row_l.prezime), 'US7ASCII')
  THEN
    NULL;
  ELSE
    -- Ime i prezime u rezervaciji je #0, a u arhivi je #1.
    pra_rec_zaj.vrati_poruku (-20130, rez_ime_l || ' ' || rez_prezime_l, recagost_row_l.ime || ' ' || recagost_row_l.prezime);
  END IF;
  -- KRAJ IRN 3991

  naredba_l := 'UPDATE t_rezervacije<CVOR> SET recagost_id = :recagost_id WHERE id = :id';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', metcvor_sifra_so_l) USING recagost_row_l.id, rez_id_l;
  rowcount_l := SQL%ROWCOUNT;

  odgovor_p := 'OK [UPDATED ' || rowcount_l || ']'; -- IRN 2839

EXCEPTION
  WHEN OTHERS THEN
    odgovor_p := SUBSTR ('ERROR ' || SQLERRM, 1, 2000);
    -- IRN 3991
    pra_pka2.clob_to_table (TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || CHR(10) || log_opis_m || CHR(10) || SQLERRM || CHR(10) || CHR(10), log_file_name_m, NULL, 'CRM');
    RAISE; -- IRN 2861
END;
PROCEDURE AZURIRAJ_GOST_RECAGOST
 (GOST_GOD_POSLOVNA_P IN t_gosti.god_poslovna%TYPE
 ,MISH_SHEMA_RBR_P IN smet_cvorovi.rbr%TYPE
 ,GOST_RBR_P IN t_gosti.rbr%TYPE
 ,RECAGOST_RBR_P IN trec_agostiju.rbr%TYPE
 ,ODGOVOR_P OUT VARCHAR2
 )
 IS
-- IRN 2750; Auriraj t_gosti.recagost_id
  CURSOR recagost_c IS
    SELECT id, oznaka, ime, prezime FROM trec_agostiju WHERE rbr = recagost_rbr_p;
  recagost_row_l recagost_c%ROWTYPE;

  gost_id_l t_gosti.id%TYPE;
  gost_ime_l t_gosti.ime%TYPE;
  gost_prezime_l t_gosti.prezime%TYPE;

  metcvor_sifra_so_l VARCHAR2(41);
  naredba_l VARCHAR2(2000);
  rowcount_l NUMBER := 0;
BEGIN

  log_file_name_m := 'crm-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '-g.log';
  log_opis_m := 'pra_rec_crm.azuriraj_gost_recagost; ' || gost_god_poslovna_p || '; ' || mish_shema_rbr_p || '; ' || gost_rbr_p || '; ' || recagost_rbr_p;

  IF pra_zmp_s.oznaka ('P0014') = 0 THEN
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  -- Nedostaje obvezan ulazni parametar (#0).
  IF gost_god_poslovna_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'gost_god_poslovna_p');
  ELSIF mish_shema_rbr_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'mish_shema_rbr_p');
  ELSIF gost_rbr_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'gost_rbr_p');
  -- recagost_rbr_p
  END IF;

  IF recagost_rbr_p IS NOT NULL THEN
    OPEN recagost_c;
    FETCH recagost_c INTO recagost_row_l;
    CLOSE recagost_c;
    IF recagost_row_l.id IS NULL THEN
      -- Nedostaje podatak (#0 #1).
      pra_rec_zaj.vrati_poruku (-20445, pra_zmp_zaj.poruka ('REC', 'REC_RECAGOST'), recagost_rbr_p);
    END IF;
    IF recagost_row_l.oznaka = 'P' THEN
      -- Zapis (#0) je poniten.
      pra_rec_zaj.vrati_poruku (-20637, recagost_rbr_p);
    END IF;
  END IF;

  -- IRN 4027
  -- metcvor_sifra_so_l := pra_rec_s3.metcvor_sifra_so (so_sifra_p);
  SELECT MIN (sifra) INTO metcvor_sifra_so_l FROM smet_cvorovi WHERE rbr = mish_shema_rbr_p;
  IF metcvor_sifra_so_l IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'mish_shema_rbr_p');
  END IF;
  IF metcvor_sifra_so_l = pra_zmp_zaj.tekuci_cvor THEN
    metcvor_sifra_so_l := '';
  ELSE
    metcvor_sifra_so_l := '@' || metcvor_sifra_so_l;
  END IF;
  -- KRAJ IRN 4027

  naredba_l := 'SELECT id, ime, prezime FROM t_gosti<CVOR> WHERE god_poslovna = :god_poslovna AND rbr = :rbr';
  BEGIN
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', metcvor_sifra_so_l)
       INTO gost_id_l, gost_ime_l, gost_prezime_l
      USING gost_god_poslovna_p, gost_rbr_p;
  EXCEPTION
    WHEN OTHERS THEN
      NULL; -- IRN 4108; moe biti i no data found
  END;
  IF gost_id_l IS NULL THEN
    -- Nedostaje podatak (#0 #1).
    pra_rec_zaj.vrati_poruku (-20445, pra_zmp_zaj.poruka ('REC', 'REC_GOST'), gost_god_poslovna_p || '-' || mish_shema_rbr_p || '-' || gost_rbr_p);
  END IF;

  -- IRN 3991
  IF recagost_row_l.id IS NOT NULL THEN
    IF CONVERT (UPPER (gost_ime_l), 'US7ASCII') = CONVERT (UPPER (recagost_row_l.ime), 'US7ASCII')
      AND CONVERT (UPPER (gost_prezime_l), 'US7ASCII') = CONVERT (UPPER (recagost_row_l.prezime), 'US7ASCII')
    THEN
      NULL;
    ELSE
      -- Ime i prezime gosta je #0, a ime i prezime u arhivi je #1.
      pra_rec_zaj.vrati_poruku (-20131, gost_ime_l || ' ' || gost_prezime_l, recagost_row_l.ime || ' ' || recagost_row_l.prezime);
    END IF;
  END IF;
  -- KRAJ IRN 3991

  naredba_l := 'UPDATE t_gosti<CVOR> SET recagost_id = :recagost_id WHERE id = :id';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', metcvor_sifra_so_l) USING recagost_row_l.id, gost_id_l;
  rowcount_l := SQL%ROWCOUNT;

  odgovor_p := 'OK [UPDATED ' || rowcount_l || ']';

EXCEPTION
  WHEN OTHERS THEN
    odgovor_p := SUBSTR ('ERROR ' || SQLERRM, 1, 2000);
    -- IRN 3991
    pra_pka2.clob_to_table (TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || CHR(10) || log_opis_m || CHR(10) || SQLERRM || CHR(10) || CHR(10), log_file_name_m, NULL, 'CRM');
    RAISE; -- IRN 2861
END;
PROCEDURE AZURIRAJ_LOYKAR
 (GUID_P IN tloy_kartice.guid%TYPE
 ,RECAGOST_RBR_P IN trec_agostiju.rbr%TYPE
 ,SO_SIFRA_P IN mcen_so.sifra%TYPE := NULL
 ,BROJ_P IN tloy_kartice.broj%TYPE
 ,DAT_VALJAN_P IN tloy_kartice.dat_valjan%TYPE
 ,DAT_PONISTEN_P IN tloy_kartice.dat_ponisten%TYPE := NULL
 ,ODGOVOR_P OUT VARCHAR2
 )
 IS
/*
Procedura aurira podatke u tablici TLOY_KARTICE na shemi Centar
*/
  CURSOR recagost_c IS
    SELECT id, oznaka FROM trec_agostiju WHERE rbr = recagost_rbr_p;
  recagost_row_l recagost_c%ROWTYPE;

  loykar_row_l tloy_kartice%ROWTYPE;
  dat_max_c CONSTANT DATE := TO_DATE ('31.12.9999', 'DD.MM.RRRR');
  rowcount_l NUMBER := 0;
BEGIN

  log_file_name_m := 'crm-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '.log';
  log_opis_m :=
    'pra_rec_crm.azuriraj_loykar; ' ||
      guid_p || '; ' ||
      recagost_rbr_p || '; ' ||
      so_sifra_p || '; ' ||
      broj_p || '; ' ||
      TO_CHAR (dat_valjan_p, 'DD.MM.RRRR') || '; ' ||
      TO_CHAR (dat_ponisten_p, 'DD.MM.RRRR');

  IF pra_zmp_s.oznaka ('P0019') = 0 THEN
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  IF pra_zmp_zaj.centar = 0 THEN
    -- vor #0 nije niti Centar niti Podcentar.
    pra_zmp_zaj.vrati_poruku (-20095);
  END IF;

  -- Nedostaje obvezan ulazni parametar (#0).
  IF guid_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'guid_p');
  ELSIF recagost_rbr_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'recagost_rbr_p');
  -- so_sifra_p
  ELSIF broj_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'broj_p');
  ELSIF dat_valjan_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'dat_valjan_p');
  -- dat_ponisten_p
  END IF;

  OPEN recagost_c;
  FETCH recagost_c INTO recagost_row_l;
  CLOSE recagost_c;
  IF recagost_row_l.id IS NULL THEN
    -- Nedostaje podatak (#0 #1).
    pra_rec_zaj.vrati_poruku (-20445, pra_zmp_zaj.poruka ('REC', 'REC_RECAGOST'), recagost_rbr_p);
  END IF;

  loykar_row_l.guid := guid_p;
  loykar_row_l.recagost_id := recagost_row_l.id; 
  IF so_sifra_p IS NULL THEN
    SELECT MIN (id) INTO loykar_row_l.censo_id
      FROM mcen_so
     WHERE dat_valjan_p BETWEEN dat_valjan AND (NVL (dat_ponisten, dat_max_c) - 1);
  ELSE
    SELECT MIN (id) INTO loykar_row_l.censo_id FROM mcen_so WHERE sifra = so_sifra_p;
  END IF;
  IF loykar_row_l.censo_id IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'so_sifra_p');
  END IF;
  loykar_row_l.broj := broj_p;
  loykar_row_l.dat_valjan := dat_valjan_p;
  loykar_row_l.dat_ponisten := dat_ponisten_p;

  SELECT MIN (id) INTO loykar_row_l.id FROM tloy_kartice WHERE guid = guid_p;
  IF loykar_row_l.id IS NULL THEN
    IF recagost_row_l.oznaka = 'P' THEN -- IRN 3991
      -- Zapis (#0) je poniten.
      pra_rec_zaj.vrati_poruku (-20637, recagost_rbr_p);
    END IF;
    -- INSERT tloy_kartice
    loykar_row_l.id := pra_zmp_zaj.i3_sekvenca (NULL);
    INSERT INTO tloy_kartice VALUES loykar_row_l;
    odgovor_p := 'INSERTED';
  ELSE
    -- UPDATE tloy_kartice
    UPDATE tloy_kartice
       SET recagost_id = loykar_row_l.recagost_id,
           broj = loykar_row_l.broj,
           censo_id = loykar_row_l.censo_id,
           dat_valjan = loykar_row_l.dat_valjan,
           dat_ponisten = loykar_row_l.dat_ponisten
     WHERE id = loykar_row_l.id;
    odgovor_p := 'UPDATED';
  END IF;
  rowcount_l := SQL%ROWCOUNT;

  odgovor_p := 'OK [' || odgovor_p || ' ' || rowcount_l || ']';

EXCEPTION
  WHEN OTHERS THEN
    odgovor_p := SUBSTR ('ERROR ' || SQLERRM, 1, 2000);
    -- IRN 3991
    pra_pka2.clob_to_table (TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || CHR(10) || log_opis_m || CHR(10) || SQLERRM || CHR(10) || CHR(10), log_file_name_m, NULL, 'CRM');
    RAISE; -- IRN 2861
END;
PROCEDURE AZURIRAJ_POPUST_POS
 (RECAGOST_RBR_P IN trec_agostiju.rbr%TYPE
 ,STOPA_POPUSTA_POS_P IN trec_agostiju.stopa_popusta_pos%TYPE
 ,NAPOMENA2_P IN trec_agostiju.napomena2%TYPE := NULL
 ,ODGOVOR_P OUT VARCHAR2
 )
 IS
/*
Procedura aurira TREC_AGOSTIJU.STOPA_POPUSTA_POS i NAPOMENA2 na shemi Centar
*/
  recagost_id_l trec_agostiju.id%TYPE;
  rowcount_l NUMBER := 0;
BEGIN

  log_file_name_m := 'crm-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '.log';
  log_opis_m := 'pra_rec_crm.azuriraj_popust_pos; ' || recagost_rbr_p || '; ' || stopa_popusta_pos_p || '; ' || napomena2_p;

  IF pra_zmp_s.oznaka ('P0020') = 0 THEN
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  IF pra_zmp_zaj.centar = 0 THEN
    -- vor #0 nije niti Centar niti Podcentar.
    pra_zmp_zaj.vrati_poruku (-20095);
  END IF;

  -- Nedostaje obvezan ulazni parametar (#0).
  IF recagost_rbr_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'recagost_rbr_p');
  -- stopa_popusta_pos_p
  -- napomena2_p
  END IF;

  recagost_id_l := pra_rec_s3.recagost_id (recagost_rbr_p, -1, -1);
  UPDATE trec_agostiju
     SET stopa_popusta_pos = stopa_popusta_pos_p,
         napomena2 = napomena2_p -- IRN 2839; opis razine lanstva programa vjernosti
   WHERE id = recagost_id_l;
  rowcount_l := SQL%ROWCOUNT;

  odgovor_p := 'OK [UPDATED ' || rowcount_l || ']';

EXCEPTION
  WHEN OTHERS THEN
    odgovor_p := SUBSTR ('ERROR ' || SQLERRM, 1, 2000);
    -- IRN 3991
    pra_pka2.clob_to_table (TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || CHR(10) || log_opis_m || CHR(10) || SQLERRM || CHR(10) || CHR(10), log_file_name_m, NULL, 'CRM');
    RAISE; -- IRN 2861
END;

END PRA_REC_CRM;
/
SHOW ERROR

