PROMPT Creating Package Body 'PRA_PPC_API'
CREATE OR REPLACE PACKAGE BODY PRA_PPC_API IS
-- Designer Private Declaration
  opis_m          CLOB;
  sqlerrm_m       VARCHAR2(512);
  zmpojr_id_m     mzmp_ojr.id%TYPE;
  cvor_m          VARCHAR2(21);
  naredba_m       VARCHAR2(3000);
  pkakar_id_m     tpka_kartice.id%TYPE;
  is_basic_card_m NUMBER;
-- END Designer Private Declaration


PROCEDURE ZAJ_SET_CVOR
 (ZMPOJR_SIFRA_P IN m_oj.sifra%TYPE
 )
 IS
BEGIN
  zmpojr_id_m := NULL;

  SELECT MIN (id) INTO zmpojr_id_m FROM m_oj WHERE sifra = zmpojr_sifra_p;
  IF zmpojr_id_m IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'pc_code');
  END IF;

  cvor_m := NULL;

  SELECT MIN (NVL (metcvor_sifra, metcvor_sifra_gas)) INTO cvor_m FROM mzmp_ojr WHERE id = zmpojr_id_m;
  IF cvor_m IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'pc_code');
  END IF;
  IF cvor_m = pra_zmp_zaj.tekuci_cvor THEN
    cvor_m := NULL;
  ELSE
    cvor_m := '@' || cvor_m;
  END IF;
END;
PROCEDURE ZAJ_SET_PKAKAR_ID
 (PKAKAR_BROJ_P IN tpka_kartice.broj%TYPE
 ,OZN_VAZECA_P IN NUMBER := -1
 ,OZN_DODATNA_P IN NUMBER := 0
 )
 IS
/*
doputeno je ponititi isteklu karticu ozn_vazeca_p = 0
i traiti balance via dodatna kartica ozn_dodatna_p = -1
*/
BEGIN

  pkakar_id_m := NULL;
  is_basic_card_m := NULL;

  naredba_m :=
    'SELECT MIN (id), -1
       FROM tpka_kartice<CVOR>
      WHERE UPPER (broj) = UPPER (:pkakar_broj_p)
        AND oznaka = ''V''
        AND (SYSDATE BETWEEN dat_poc AND dat_zav OR :ozn_vazeca_p = 0)
        AND ozn_prepaid = -1';
  EXECUTE IMMEDIATE REPLACE (naredba_m, '<CVOR>', cvor_m)
     INTO pkakar_id_m, is_basic_card_m
    USING pkakar_broj_p, ozn_vazeca_p;

  IF pkakar_id_m IS NULL AND ozn_dodatna_p = -1 THEN
    naredba_m :=
      'SELECT MIN (pkakar.id), 0
         FROM tpka_kartice<CVOR> pkakar,
              tpka_kar_dod<CVOR> pkakardod
        WHERE pkakardod.pkakar_id = pkakar.id
          AND UPPER (pkakardod.broj) = UPPER (:pkakar_broj_p)
          AND pkakar.oznaka = ''V''
          AND pkakardod.oznaka = ''V''
          AND (SYSDATE BETWEEN pkakar.dat_poc AND pkakar.dat_zav OR :ozn_vazeca_p = 0)
          AND pkakar.ozn_prepaid = -1';
    EXECUTE IMMEDIATE REPLACE (naredba_m, '<CVOR>', cvor_m)
       INTO pkakar_id_m, is_basic_card_m
      USING pkakar_broj_p, ozn_vazeca_p;
  END IF;

  IF pkakar_id_m IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'paycard_number');
  END IF;

END;
PROCEDURE INSERT_PKAKAR
 (BROJ_P IN tpka_kartice.broj%TYPE
 ,ZMPOJR_SIFRA_P IN m_oj.sifra%TYPE
 ,OZN_IZVAN_OJ_P IN tpka_kartice.ozn_izvan_oj%TYPE := 0
 ,NAC_SIFRA1_P IN m_nacpot.sifra%TYPE
 ,SAT_POC_P IN tpka_kartice.dat_poc%TYPE
 ,SAT_ZAV_P IN tpka_kartice.dat_zav%TYPE
 ,IME_P IN tpka_kartice.ime%TYPE
 ,PREZIME_P IN tpka_kartice.prezime%TYPE
 ,SIFRA_P IN tpka_kartice.sifra%TYPE
 ,IZNOS0_P IN tpka_kar_rnk.iznos%TYPE
 ,PREPAID_TYPE_P IN tpka_kartice.prepaid_type%TYPE
 )
 IS
-- API PPC / Pay Card / Posting Pay Card Data to PMS
  param_1005_l szmp_parametri.vrijednost%TYPE;
  param_1006_l szmp_parametri.vrijednost%TYPE;
BEGIN

  opis_m :=
    '[PC POST] paycard_number ' || broj_p ||
      ', pc_code ' || zmpojr_sifra_p ||
      ', can_use_outside ' || ozn_izvan_oj_p ||
      ', price1_code ' || nac_sifra1_p ||
      ', valid_from ' || TO_CHAR (sat_poc_p, 'DD.MM.RRRR HH24:MI') ||
      ', valid_to ' || TO_CHAR (sat_zav_p, 'DD.MM.RRRR HH24:MI') ||
      ', first_name ' || ime_p ||
      ', last_name ' || prezime_p ||
      ', unit_code ' || sifra_p ||
      ', initial_balance ' || iznos0_p ||
      ', prepaid_type ' || prepaid_type_p; -- IRN 4099

  pra_ppc_api.zaj_puni_log;

  IF pra_zmp_s.oznaka ('O0003') = 0 THEN
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  -- Pogrena vrijednost ulaznog parametra (#0)!
  IF broj_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'paycard_number');
  ELSIF zmpojr_sifra_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'pc_code');
  ELSIF NVL (ozn_izvan_oj_p, 0) NOT IN (-1, 0) THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'can_use_outside');
  -- nac_sifra1_p -- price1_code
  ELSIF sat_poc_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'valid_from');
  ELSIF sat_zav_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'valid_to');
  -- ime_p        -- first_name
  -- prezime_p    -- last_name
  -- sifra_p      -- unit_code
  -- prepaid_type_p
  END IF;

  pkakar_row_g := NULL;

  zaj_set_cvor (zmpojr_sifra_p);

  -- 1005 ifra agencije korisnika Prepaid kartice
  -- 1006 ifra PKA blagajne za upis inicijalne uplate
  EXECUTE IMMEDIATE REPLACE (
    'SELECT
       pra_zmp_zaj.zmppar_vrijednost<CVOR> (''MISHAPI'', ''1005''),
       pra_zmp_zaj.zmppar_vrijednost<CVOR> (''MISHAPI'', ''1006'')
     FROM dual', '<CVOR>', cvor_m)
    INTO param_1005_l, param_1006_l;

  EXECUTE IMMEDIATE 'SELECT pra_zmp_zaj.i3_sekvenca_cvor (:cvor_m, NULL) FROM dual' INTO pkakar_id_m USING cvor_m;
  pkakar_row_g.id := pkakar_id_m;
  pkakar_row_g.zmpojr_id := zmpojr_id_m;
  -- gost_id

  SELECT MIN (id) INTO pkakar_row_g.age_id FROM m_agencije WHERE sifra = param_1005_l;
  IF pkakar_row_g.age_id IS NULL THEN
    -- Provjerite vrijednost #0 parametra #1!
    pra_zmp_zaj.vrati_poruku (-20100, 'MISHAPI', '1005');
  END IF;

  -- pkaadr_id
  pkakar_row_g.broj := broj_p;
  pkakar_row_g.oznaka := 'V';
  pkakar_row_g.ozn_izvan_oj := NVL (ozn_izvan_oj_p, 0);
  pkakar_row_g.dat_poc := sat_poc_p;
  pkakar_row_g.dat_zav := sat_zav_p;
  pkakar_row_g.ime := SUBSTR (ime_p, 1, 20);
  pkakar_row_g.prezime := SUBSTR (prezime_p, 1, 40);
  -- pin
  -- izn_odobren
  -- izn_potrosen
  pkakar_row_g.unos_korisnik := zmp_zaj.korisnik (-1);
  pkakar_row_g.unos_dat := SYSDATE;
  -- izmjena_korisnik, izmjena_dat
  pkakar_row_g.ozn_jednokratna := 0;

  IF nac_sifra1_p IS NOT NULL THEN
    SELECT MIN (id) INTO pkakar_row_g.nac_id FROM m_nacpot WHERE sifra = nac_sifra1_p;
    IF pkakar_row_g.nac_id IS NULL THEN
      -- Pogrena vrijednost ulaznog parametra (#0)!
      pra_zmp_zaj.vrati_poruku (-20099, 'price1_code');
    END IF;
  END IF;

  -- stopa_popusta_pos1
  -- stopa_popusta_pos2
  -- kcsus_id
  pkakar_row_g.ozn_prepaid := -1;
  -- nac2_id
  pkakar_row_g.ozn_nfc := 0;
  pkakar_row_g.sifra := SUBSTR (sifra_p, 1, 38); -- IRN 3771
  pkakar_row_g.oj_id := zmpojr_id_m;
  pkakar_row_g.prepaid_type := SUBSTR (prepaid_type_p, 1, 20); -- IRN 4099

  naredba_m := 'BEGIN INSERT INTO tpka_kartice<CVOR> VALUES pra_ppc_api.pkakar_row_g; END;';
  EXECUTE IMMEDIATE REPLACE (naredba_m, '<CVOR>', cvor_m);

  -- Upii inicijalnu uplatu
  IF NVL (iznos0_p, 0) > 0 THEN
    -- id -- puni BIR
    pkakarrnk_row_g.pkakar_id := pkakar_id_m;

    SELECT MIN (id) INTO pkakarrnk_row_g.gmpkas_id FROM mgmp_kase WHERE sifra = param_1006_l;
    IF pkakarrnk_row_g.gmpkas_id IS NULL THEN
      -- Provjerite vrijednost #0 parametra #1!
      pra_zmp_zaj.vrati_poruku (-20100, 'MISHAPI', '1006');
    END IF;

    pkakarrnk_row_g.god_poslovna := TO_CHAR (SYSDATE, 'RRRR');
    -- rbr -- puni BIR
    pkakarrnk_row_g.datum := TRUNC (SYSDATE);
    pkakarrnk_row_g.iznos := iznos0_p;
    pkakarrnk_row_g.unos_korisnik := zmp_zaj.korisnik (-1);
    pkakarrnk_row_g.unos_dat := SYSDATE;
    -- izmjena_korisnik, izmjena_dat
    pkakarrnk_row_g.oznaka := 0; -- inicijalna uplata
    pkakarrnk_row_g.nac_id := pkakar_row_g.nac_id;
    pkakarrnk_row_g.izn_rnk := 0;
    pkakarrnk_row_g.izn_popusta := 0;
    pkakarrnk_row_g.oj_id := zmpojr_id_m;
    naredba_m := 'BEGIN INSERT INTO tpka_kar_rnk<CVOR> VALUES pra_ppc_api.pkakarrnk_row_g; END;';
    EXECUTE IMMEDIATE REPLACE (naredba_m, '<CVOR>', cvor_m);
  END IF;
  -- KRAJ Upii inicijalnu uplatu

EXCEPTION
  WHEN OTHERS THEN
    sqlerrm_m := SQLERRM;
    pra_ppc_api.zaj_puni_log;
    RAISE;
END;
PROCEDURE INSERT_PKAKARDOD_M
 (BROJ_P IN tpka_kar_dod.broj%TYPE
 ,IME_P IN tpka_kar_dod.ime%TYPE
 ,PREZIME_P IN tpka_kar_dod.prezime%TYPE
 ,SIFRA_P IN tpka_kar_dod.sifra%TYPE
 )
 IS
-- API PPC / Pay Card / Posting Pay Card Data to PMS
-- varijable pkakar_id_m i cvor_m napunila je procedura insert_pkakar
BEGIN

  opis_m :=
    '[PC POST 2] paycard_number ' || broj_p ||
      ', first_name ' || ime_p ||
      ', last_name ' || prezime_p ||
      ', unit_code ' || sifra_p;

  pra_ppc_api.zaj_puni_log;

  IF pra_zmp_s.oznaka ('O0003') = 0 THEN
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  -- Pogrena vrijednost ulaznog parametra (#0)!
  IF pkakar_id_m IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'basic_paycard_id');
  ELSIF broj_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'paycard_number');
  -- ime_p        -- first_name
  -- prezime_p    -- last_name
  -- sifra_p      -- unit_code
  END IF;

  -- IRN 3502; poniti isteklu dodatnu karticu jednakog broja
  naredba_m :=
    'UPDATE tpka_kar_dod<CVOR>
        SET oznaka = ''P''
      WHERE UPPER (broj) = UPPER (:broj_p)
        AND oznaka = ''V''
        AND pkakar_id IN (
            SELECT id
              FROM tpka_kartice<CVOR>
             WHERE id <> :pkakar_id_m
               AND oznaka = ''V''
               AND dat_zav < SYSDATE)'; -- istekla kartica
  EXECUTE IMMEDIATE REPLACE (naredba_m, '<CVOR>', cvor_m) USING broj_p, pkakar_id_m;


  -- id
  pkakardod_row_g.pkakar_id := pkakar_id_m;
  pkakardod_row_g.broj := broj_p;
  pkakardod_row_g.oznaka := 'V';
  pkakardod_row_g.ime := SUBSTR (ime_p, 1, 20);
  pkakardod_row_g.prezime := SUBSTR (prezime_p, 1, 40);
  pkakardod_row_g.sifra := SUBSTR (sifra_p, 1, 38); -- IRN 3771
  pkakardod_row_g.unos_korisnik := zmp_zaj.korisnik (-1);
  pkakardod_row_g.unos_dat := SYSDATE;
  -- izmjena_korisnik, izmjena_dat
  naredba_m := 'BEGIN INSERT INTO tpka_kar_dod<CVOR> VALUES pra_ppc_api.pkakardod_row_g; END;';
  EXECUTE IMMEDIATE REPLACE (naredba_m, '<CVOR>', cvor_m);

EXCEPTION
  WHEN OTHERS THEN
    sqlerrm_m := SQLERRM;
    pra_ppc_api.zaj_puni_log;
    RAISE;
END;
PROCEDURE UPDATE_PKAKAR
 (BROJ_P IN tpka_kartice.broj%TYPE
 ,ZMPOJR_SIFRA_P IN m_oj.sifra%TYPE
 ,NAC_SIFRA1_P IN m_nacpot.sifra%TYPE
 ,SAT_ZAV_P IN tpka_kartice.dat_zav%TYPE
 ,IME_P IN tpka_kartice.ime%TYPE
 ,PREZIME_P IN tpka_kartice.prezime%TYPE
 ,SIFRA_P IN tpka_kartice.sifra%TYPE
 ,IZNOS0_P IN tpka_kar_rnk.iznos%TYPE
 ,PREPAID_TYPE_P IN tpka_kartice.prepaid_type%TYPE
 )
 IS
-- API PPC / Pay Card / Modify Data
  nac_id_l m_nacpot.id%TYPE;
  initial_balance_l tpka_kar_rnk.iznos%TYPE;   -- IRN 3502
  param_1006_l szmp_parametri.vrijednost%TYPE; -- IRN 3502
BEGIN

  opis_m :=
    '[PC PUT] paycard_number ' || broj_p ||
      ', pc_code ' || zmpojr_sifra_p ||
      ', price1_code ' || nac_sifra1_p ||
      ', valid_to ' || TO_CHAR (sat_zav_p, 'DD.MM.RRRR HH24:MI') ||
      ', first_name ' || ime_p ||
      ', last_name ' || prezime_p ||
      ', unit_code ' || sifra_p ||
      ', initial_balance ' || iznos0_p ||
      ', prepaid_type ' || prepaid_type_p; -- IRN 4099

  pra_ppc_api.zaj_puni_log;

  IF pra_zmp_s.oznaka ('O0003') = 0 THEN
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  -- Pogrena vrijednost ulaznog parametra (#0)!
  IF broj_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'paycard_number');
  ELSIF zmpojr_sifra_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'pc_code');
  -- nac_sifra1_p -- price1_code
  ELSIF sat_zav_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'valid_to');
  -- ime_p        -- first_name
  -- prezime_p    -- last_name
  -- sifra_p      -- unit_code
  -- prepaid_type_p
  END IF;

  pkakarrnk_row_g := NULL; -- IRN 3502

  zaj_set_cvor (zmpojr_sifra_p); -- puni cvor_m
  zaj_set_pkakar_id (broj_p);    -- puni pkakar_id_m

  IF nac_sifra1_p IS NOT NULL THEN
    SELECT MIN (id) INTO nac_id_l FROM m_nacpot WHERE sifra = nac_sifra1_p;
    IF nac_id_l IS NULL THEN
      -- Pogrena vrijednost ulaznog parametra (#0)!
      pra_zmp_zaj.vrati_poruku (-20099, 'price1_code');
    END IF;
  END IF;

  -- IRN 4099; u UPDATE dodan prepaid_type
  naredba_m :=
    'UPDATE tpka_kartice<CVOR>
        SET nac_id = :nac_id_l,
            dat_zav = :sat_zav_p,
            ime = SUBSTR (:ime_p, 1, 20),
            prezime = SUBSTR (:prezime_p, 1, 40),
            sifra = SUBSTR (:sifra_p, 1, 38),
            prepaid_type = SUBSTR (:prepaid_type_p, 1, 20)
      WHERE id = :pkakar_id_m';
  EXECUTE IMMEDIATE REPLACE (naredba_m, '<CVOR>', cvor_m)
    USING nac_id_l, sat_zav_p, ime_p, prezime_p, sifra_p, prepaid_type_p, pkakar_id_m; -- IRN 3771, IRN 4099

  -- IRN 3502
  naredba_m := 'SELECT SUM (iznos) FROM tpka_kar_rnk<CVOR> WHERE pkakar_id = :pkakar_id_m AND oznaka = 0';
  EXECUTE IMMEDIATE REPLACE (naredba_m, '<CVOR>', cvor_m) INTO initial_balance_l USING pkakar_id_m;

  -- IRN 3502; Upii dodatnu inicijalnu uplatu
  IF NVL (iznos0_p, 0) - NVL (initial_balance_l, 0) <> 0 THEN
    -- id -- puni BIR
    pkakarrnk_row_g.pkakar_id := pkakar_id_m;

    -- 1006 ifra PKA blagajne za upis inicijalne uplate
    EXECUTE IMMEDIATE
      REPLACE ('SELECT pra_zmp_zaj.zmppar_vrijednost<CVOR> (''MISHAPI'', ''1006'') FROM dual', '<CVOR>', cvor_m)
      INTO param_1006_l;

    SELECT MIN (id) INTO pkakarrnk_row_g.gmpkas_id FROM mgmp_kase WHERE sifra = param_1006_l;
    IF pkakarrnk_row_g.gmpkas_id IS NULL THEN
      -- Provjerite vrijednost #0 parametra #1!
      pra_zmp_zaj.vrati_poruku (-20100, 'MISHAPI', '1006');
    END IF;

    pkakarrnk_row_g.god_poslovna := TO_CHAR (SYSDATE, 'RRRR');
    -- rbr -- puni BIR
    pkakarrnk_row_g.datum := TRUNC (SYSDATE);
    pkakarrnk_row_g.iznos := NVL (iznos0_p, 0) - NVL (initial_balance_l, 0);
    pkakarrnk_row_g.unos_korisnik := zmp_zaj.korisnik (-1);
    pkakarrnk_row_g.unos_dat := SYSDATE;
    -- izmjena_korisnik, izmjena_dat
    pkakarrnk_row_g.oznaka := 0; -- inicijalna uplata
    pkakarrnk_row_g.nac_id := nac_id_l;
    pkakarrnk_row_g.izn_rnk := 0;
    pkakarrnk_row_g.izn_popusta := 0;
    pkakarrnk_row_g.oj_id := zmpojr_id_m;
    naredba_m := 'BEGIN INSERT INTO tpka_kar_rnk<CVOR> VALUES pra_ppc_api.pkakarrnk_row_g; END;';
    EXECUTE IMMEDIATE REPLACE (naredba_m, '<CVOR>', cvor_m);
  END IF;
  -- KRAJ Upii dodatnu inicijalnu uplatu

EXCEPTION
  WHEN OTHERS THEN
    sqlerrm_m := SQLERRM;
    pra_ppc_api.zaj_puni_log;
    RAISE;
END;
PROCEDURE PONISTI_PKAKAR
 (BROJ_P IN tpka_kartice.broj%TYPE
 ,ZMPOJR_SIFRA_P IN m_oj.sifra%TYPE
 )
 IS
-- API PPC / Pay Card / Cancel Paycard
BEGIN
  opis_m :=
    '[PC DEL] paycard_number ' || broj_p ||
      ', pc_code ' || zmpojr_sifra_p;

  pra_ppc_api.zaj_puni_log;

  IF pra_zmp_s.oznaka ('O0003') = 0 THEN
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  -- Pogrena vrijednost ulaznog parametra (#0)!
  IF broj_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'paycard_number');
  ELSIF zmpojr_sifra_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'pc_code');
  END IF;

  zaj_set_cvor (zmpojr_sifra_p); -- puni cvor_m
  -- doputeno je ponititi istekle kartice zato se alje ozn_vazeca_p => 0
  zaj_set_pkakar_id (pkakar_broj_p => broj_p, ozn_vazeca_p => 0); -- puni pkakar_id_m

  naredba_m := 'UPDATE tpka_kartice<CVOR> SET oznaka = ''P'' WHERE id = :pkakar_id_m';
  EXECUTE IMMEDIATE REPLACE (naredba_m, '<CVOR>', cvor_m) USING pkakar_id_m;

EXCEPTION
  WHEN OTHERS THEN
    sqlerrm_m := SQLERRM;
    pra_ppc_api.zaj_puni_log;
    RAISE;
END;
PROCEDURE VRATI_PKAKAR_BALANCE
 (BROJ_P IN tpka_kartice.broj%TYPE
 ,ZMPOJR_SIFRA_P IN m_oj.sifra%TYPE
 ,INITIAL_BALANCE_P OUT NUMBER
 ,BALANCE_P OUT NUMBER
 ,REFUNDABLE_P OUT NUMBER
 ,IS_BASIC_CARD_P OUT NUMBER
 ,PREPAID_TYPE_P OUT tpka_kartice.prepaid_type%TYPE
 ,LINKED_CARDS_P OUT SYS_REFCURSOR
 )
 IS
-- API PPC / Pay Card / Retrieve Pay Card Data
-- Pregled statusa flexi balansa (inicijalna uplata, ukupni ostatak, povratni ostatak - koji gost moe povui)

  rc_l SYS_REFCURSOR;
  paycard_number_l tpka_kartice.broj%TYPE; -- IRN 3502
BEGIN

  opis_m :=
    '[PC GET] paycard_number ' || broj_p ||
      ', pc_code ' || zmpojr_sifra_p;

  IF pra_zmp_s.oznaka ('O0003') = 0 THEN
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  -- Pogrena vrijednost ulaznog parametra (#0)!
  IF broj_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'paycard_number');
  ELSIF zmpojr_sifra_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'pc_code');
  END IF;

  zaj_set_cvor (zmpojr_sifra_p); -- puni cvor_m
  -- balance se moe pitati i via dodatna kartica zato ozn_dodatna_p => -1
  zaj_set_pkakar_id (pkakar_broj_p => broj_p, ozn_dodatna_p => -1); -- puni pkakar_id_m i is_basic_card_m

  -- IRN 4099; dodan prepaid_type
  OPEN rc_l FOR
    REPLACE (
      'SELECT
         NVL (init.iznos, 0) AS initial_balance,
         NVL (pkakar.izn_odobren, 0) - NVL (pkakar.izn_potrosen, 0) AS balance,
         LEAST (
           NVL (pkakar.izn_odobren, 0) - NVL (pkakar.izn_potrosen, 0),
           NVL (pkakar.izn_odobren, 0) - NVL (init.iznos, 0))
           AS refundable,
         pkakar.prepaid_type AS prepaid_type,
         pkakar.broj AS paycard_number
       FROM
         tpka_kartice<CVOR> pkakar,
         (
         SELECT
           pkakar_id,
           SUM (iznos) AS iznos
         FROM
           tpka_kar_rnk<CVOR>
         WHERE
           pkakar_id = :pkakar_id_m
           AND oznaka = 0
         GROUP BY
           pkakar_id
         ) init
       WHERE
         pkakar.id = :pkakar_id_m
         AND init.pkakar_id(+) = pkakar.id',
       '<CVOR>',
       cvor_m)
     USING pkakar_id_m, pkakar_id_m;
  FETCH rc_l INTO initial_balance_p, balance_p, refundable_p, prepaid_type_p, paycard_number_l;
  CLOSE rc_l;

  -- IRN 4027
  -- IRN 4099; dodan prepaid_type
  opis_m := opis_m || ' | Response: ' ||
    'initial_balance ' || initial_balance_p || ', ' ||
    'balance ' || balance_p || ', ' ||
    'refundable ' || refundable_p || ', ' ||
    'is_basic_card ' ||  is_basic_card_m || ', ' || 
    'prepaid_type ' || prepaid_type_p || ', ' ||
    'basic_paycard_number ' || paycard_number_l || ', ' ||
    'basic_pkakar_id ' || pkakar_id_m;

  pra_ppc_api.zaj_puni_log;
  -- KRAJ IRN 4027

  is_basic_card_p := is_basic_card_m;

  -- IRN 3502
  OPEN rc_l FOR
    REPLACE (
      'SELECT
         :paycard_number_l AS paycard_number,
         -1 AS is_basic_card
       FROM
         dual
       UNION ALL
       SELECT
         broj AS paycard_number,
         0 AS is_basic_card
       FROM
         tpka_kar_dod<CVOR>
       WHERE
         pkakar_id = :pkakar_id_m
         AND oznaka = ''V''',
       '<CVOR>',
       cvor_m)
     USING paycard_number_l, pkakar_id_m;

  linked_cards_p := rc_l;

EXCEPTION
  WHEN OTHERS THEN
    pra_ppc_api.zaj_puni_log; -- IRN 4027
    IF rc_l%ISOPEN THEN
      CLOSE rc_l;
    END IF;
    sqlerrm_m := SQLERRM;
    pra_ppc_api.zaj_puni_log;
    RAISE;
END;
PROCEDURE INSERT_PKAKARDOD
 (PKAKAR_BROJ_P IN tpka_kartice.broj%TYPE
 ,ZMPOJR_SIFRA_P IN m_oj.sifra%TYPE
 ,BROJ_P IN tpka_kar_dod.broj%TYPE
 ,IME_P IN tpka_kar_dod.ime%TYPE
 ,PREZIME_P IN tpka_kar_dod.prezime%TYPE
 ,SIFRA_P IN tpka_kar_dod.sifra%TYPE
 )
 IS
-- API PPC / Additional Card / Posting Additional Card Data to PMS
BEGIN

  opis_m :=
    '[APC POST] basic_paycard_number ' || pkakar_broj_p ||
      ', pc_code ' || zmpojr_sifra_p ||
      ', paycard_number ' || broj_p ||
      ', first_name ' || ime_p ||
      ', last_name ' || prezime_p ||
      ', unit_code ' || sifra_p;

  pra_ppc_api.zaj_puni_log;

  IF pra_zmp_s.oznaka ('O0003') = 0 THEN
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  -- Pogrena vrijednost ulaznog parametra (#0)!
  IF pkakar_broj_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'basic_paycard_number');
  ELSIF zmpojr_sifra_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'pc_code');
  ELSIF broj_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'paycard_number');
  -- ime_p        -- first_name
  -- prezime_p    -- last_name
  -- sifra_p      -- unit_code
  END IF;

  zaj_set_cvor (zmpojr_sifra_p);     -- puni cvor_m
  zaj_set_pkakar_id (pkakar_broj_p); -- puni pkakar_id_m

  -- IRN 3502; poniti isteklu dodatnu karticu jednakog broja
  naredba_m :=
    'UPDATE tpka_kar_dod<CVOR>
        SET oznaka = ''P''
      WHERE UPPER (broj) = UPPER (:broj_p)
        AND oznaka = ''V''
        AND pkakar_id IN (
            SELECT id
              FROM tpka_kartice<CVOR>
             WHERE id <> :pkakar_id_m
               AND oznaka = ''V''
               AND dat_zav < SYSDATE)'; -- istekla kartica
  EXECUTE IMMEDIATE REPLACE (naredba_m, '<CVOR>', cvor_m) USING broj_p, pkakar_id_m;


  pkakardod_row_g := NULL;

  -- id        -- puni BIR
  pkakardod_row_g.pkakar_id := pkakar_id_m;
  pkakardod_row_g.broj := broj_p;
  pkakardod_row_g.oznaka := 'V';
  pkakardod_row_g.ime := SUBSTR (ime_p, 1, 20);
  pkakardod_row_g.prezime := SUBSTR (prezime_p, 1, 40);
  pkakardod_row_g.sifra := SUBSTR (sifra_p, 1, 38); -- IRN 3771
  pkakardod_row_g.unos_korisnik := zmp_zaj.korisnik (-1);
  pkakardod_row_g.unos_dat := SYSDATE;
  -- izmjena_korisnik, izmjena_dat

  naredba_m := 'BEGIN INSERT INTO tpka_kar_dod<CVOR> VALUES pra_ppc_api.pkakardod_row_g; END;';
  EXECUTE IMMEDIATE REPLACE (naredba_m, '<CVOR>', cvor_m);

EXCEPTION
  WHEN OTHERS THEN
    sqlerrm_m := SQLERRM;
    pra_ppc_api.zaj_puni_log;
    RAISE;
END;
PROCEDURE UPDATE_PKAKARDOD
 (PKAKAR_BROJ_P IN tpka_kartice.broj%TYPE
 ,ZMPOJR_SIFRA_P IN m_oj.sifra%TYPE
 ,BROJ_P IN tpka_kar_dod.broj%TYPE
 ,IME_P IN tpka_kar_dod.ime%TYPE
 ,PREZIME_P IN tpka_kar_dod.prezime%TYPE
 ,SIFRA_P IN tpka_kartice.sifra%TYPE
 )
 IS
-- API PPC / Additional Card / Modify Data
BEGIN
  opis_m :=
    '[APC PUT] basic_paycard_number ' || pkakar_broj_p ||
      ', pc_code ' || zmpojr_sifra_p ||
      ', paycard_number ' || broj_p ||
      ', first_name ' || ime_p ||
      ', last_name ' || prezime_p ||
      ', unit_code ' || sifra_p;

  pra_ppc_api.zaj_puni_log;

  IF pra_zmp_s.oznaka ('O0003') = 0 THEN
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  -- Pogrena vrijednost ulaznog parametra (#0)!
  IF pkakar_broj_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'basic_paycard_number');
  ELSIF zmpojr_sifra_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'pc_code');
  ELSIF broj_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'paycard_number');
  -- ime_p        -- first_name
  -- prezime_p    -- last_name
  -- sifra_p      -- unit_code
  END IF;

  zaj_set_cvor (zmpojr_sifra_p);     -- puni cvor_m
  zaj_set_pkakar_id (pkakar_broj_p); -- puni pkakar_id_m

  naredba_m :=
    'UPDATE tpka_kar_dod<CVOR>
        SET ime = SUBSTR (:ime_p, 1, 20),
            prezime = SUBSTR (:prezime_p, 1, 40),
            sifra = SUBSTR (:sifra_p, 1, 38)
      WHERE pkakar_id = :pkakar_id_m
        AND UPPER (broj) = UPPER (:broj_p)';
  EXECUTE IMMEDIATE REPLACE (naredba_m, '<CVOR>', cvor_m)
    USING ime_p, prezime_p, sifra_p, pkakar_id_m, broj_p;

EXCEPTION
  WHEN OTHERS THEN
    sqlerrm_m := SQLERRM;
    pra_ppc_api.zaj_puni_log;
    RAISE;
END;
PROCEDURE DELETE_PKAKARDOD
 (PKAKAR_BROJ_P IN tpka_kartice.broj%TYPE
 ,ZMPOJR_SIFRA_P IN m_oj.sifra%TYPE
 ,BROJ_P IN tpka_kar_dod.broj%TYPE
 )
 IS
-- API PPC / Additional Card / Cancel Paycard
BEGIN
  opis_m :=
    '[APC DEL] basic_paycard_number ' || pkakar_broj_p ||
      ', pc_code ' || zmpojr_sifra_p ||
      ', paycard_number ' || broj_p;

  pra_ppc_api.zaj_puni_log;

  IF pra_zmp_s.oznaka ('O0003') = 0 THEN
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  -- Pogrena vrijednost ulaznog parametra (#0)!
  IF pkakar_broj_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'basic_paycard_number');
  ELSIF zmpojr_sifra_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'pc_code');
  ELSIF broj_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'paycard_number');
  END IF;

  zaj_set_cvor (zmpojr_sifra_p); -- puni cvor_m
  zaj_set_pkakar_id (pkakar_broj_p => pkakar_broj_p, ozn_vazeca_p => 0); -- puni pkakar_id_m; IRN 3502

  -- IRN 3502; umjesto DELETE stavljen UPDATE
  naredba_m :=
    'UPDATE tpka_kar_dod<CVOR>
        SET oznaka = ''P''
      WHERE oznaka = ''V''
        AND pkakar_id = :pkakar_id_m
        AND UPPER (broj) = UPPER (:broj_p)';
  EXECUTE IMMEDIATE REPLACE (naredba_m, '<CVOR>', cvor_m) USING pkakar_id_m, broj_p;

EXCEPTION
  WHEN OTHERS THEN
    sqlerrm_m := SQLERRM;
    pra_ppc_api.zaj_puni_log;
    RAISE;
END;
PROCEDURE ZAJ_PUNI_LOG
 IS
-- IRN 3771; puni log komunikacije u tablicu lpka_clob
  log_file_name_l VARCHAR2(100);
  pkaclob_data_l lpka_clob.data%TYPE; -- IRN 4099
BEGIN

  -- PPC; Spremati komunikaciju u log: 1 = da ili 0 = ne.
  IF pra_zmp_zaj.zmppar_vrijednost ('MISHAPI', '1010') = 0
    AND sqlerrm_m IS NULL
  THEN
    RETURN;
  END IF;

  log_file_name_l := 'apippc-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '.log';
  pkaclob_data_l := '[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || ']' || CHR(10);

  -- upii opis u log
  pkaclob_data_l := pkaclob_data_l || opis_m || CHR(10);

  IF sqlerrm_m IS NOT NULL THEN
    -- upii pogreku u log
    pkaclob_data_l := pkaclob_data_l || sqlerrm_m || CHR(10);
  END IF;

  -- IRN 4099; samo jedan poziv pra_pka2.clob_to_table
  pra_pka2.clob_to_table (pkaclob_data_l || CHR(10), log_file_name_l, NULL, 'APIPPC');

  sqlerrm_m := NULL;

END;

END PRA_PPC_API;
/
SHOW ERROR

