PROMPT Creating Package Body 'PRA_POS_PKAKAR'
CREATE OR REPLACE PACKAGE BODY PRA_POS_PKAKAR IS

FUNCTION GMPKAS_TEKUCEG_CVORA
 (GMPKAS_ID_P IN mgmp_kase.id%TYPE
 )
 RETURN BOOLEAN;
FUNCTION CVOR_CENTAR
 RETURN VARCHAR2;
FUNCTION CVOR_GMPKAS
 (GMPKAS_ID_P IN mgmp_kase.id%TYPE
 )
 RETURN VARCHAR2;


PROCEDURE PROVJERI_PKAKAR
 (GMPKAS_ID_P IN mgmp_kase.id%TYPE
 ,PKAKAR_BROJ_P IN tpka_kartice.broj%TYPE
 ,PKAKAR_PIN4_P IN VARCHAR2
 ,DATUM_P IN tpka_kartice.dat_zav%TYPE
 ,IZNOS_P IN tpka_kar_rnk.iznos%TYPE
 ,GMPKAS_OIB_P IN s_vlasnik.oib%TYPE
 ,PKAKAR_ID_P OUT tpka_kartice.id%TYPE
 ,METCVOR_SIFRA_P OUT smet_cvorovi.sifra%TYPE
 ,NAC_ID_P OUT tpka_kartice.nac_id%TYPE
 ,STOPA_POPUSTA_POS1_P OUT tpka_kartice.stopa_popusta_pos1%TYPE
 ,STOPA_POPUSTA_POS2_P OUT tpka_kartice.stopa_popusta_pos2%TYPE
 ,GOST_ID_P OUT tpka_kartice.gost_id%TYPE
 ,AGE_ID_P OUT tpka_kartice.age_id%TYPE
 ,PKAADR_ID_P OUT tpka_kartice.pkaadr_id%TYPE
 ,OZN_PREPAID_P OUT tpka_kartice.ozn_prepaid%TYPE
 ,IZN_NEISKORISTEN_P OUT tpka_kartice.izn_odobren%TYPE
 ,IME_P OUT tpka_kartice.ime%TYPE
 ,PREZIME_P OUT tpka_kartice.prezime%TYPE
 ,NAC2_ID_P OUT tpka_kartice.nac2_id%TYPE
 ,OJ_SIFRA_P OUT m_oj.sifra%TYPE
 ,ZMPOJR_SIFRA_P OUT m_oj.sifra%TYPE
 ,ZMPOJR_NAZIV_P OUT m_oj.naziv%TYPE
 ,METCVOR_SIFRA2_P OUT smet_cvorovi.sifra%TYPE
 ,IZN_POVRATA_P OUT tpka_kartice.izn_odobren%TYPE
 ,SIFRA_P OUT tpka_kartice.sifra%TYPE
 ,OZN_PROVJERI_LIMIT_P OUT NUMBER
 ,IZN_ODOBREN0_P OUT tpka_kartice.izn_odobren%TYPE
 ,BASIC_PAYCARD_NUMBER_P OUT tpka_kartice.broj%TYPE
 ,PREPAID_TYPE_P OUT tpka_kartice.prepaid_type%TYPE
 )
 IS
--
  pkakar_id_l tpka_kartice.id%TYPE;
  metcvor_sifra_l smet_cvorovi.sifra%TYPE;
  nac_id_l tpka_kartice.nac_id%TYPE;
  stopa_popusta_pos1_l tpka_kartice.stopa_popusta_pos1%TYPE;
  stopa_popusta_pos2_l tpka_kartice.stopa_popusta_pos2%TYPE;
  gost_id_l tpka_kartice.gost_id%TYPE;
  age_id_l tpka_kartice.age_id%TYPE;
  pkaadr_id_l tpka_kartice.pkaadr_id%TYPE;
  ozn_prepaid_l tpka_kartice.ozn_prepaid%TYPE; -- IRN 2527
  izn_neiskoristen_l tpka_kartice.izn_odobren%TYPE; -- IRN 2527
  ime_l tpka_kartice.ime%TYPE; -- IRN 2598
  prezime_l tpka_kartice.prezime%TYPE; -- IRN 2598
  nac2_id_l tpka_kartice.nac2_id%TYPE; -- IRN 2716
  oj_sifra_l m_oj.sifra%TYPE; -- IRN 2716
  zmpojr_sifra_l m_oj.sifra%TYPE; -- IRN 3218
  zmpojr_naziv_l m_oj.naziv%TYPE; -- IRN 3218
  metcvor_sifra2_l smet_cvorovi.sifra%TYPE; -- IRN 3371
  izn_povrata_l tpka_kartice.izn_odobren%TYPE; -- IRN 3478
  sifra_l tpka_kartice.sifra%TYPE; -- IRN 3771
  ozn_provjeri_limit_l NUMBER;     -- IRN 3771
  izn_odobren0_l tpka_kartice.izn_odobren%TYPE; -- IRN 3940
  basic_paycard_number_l tpka_kartice.broj%TYPE; -- IRN 4099
  prepaid_type_l tpka_kartice.prepaid_type%TYPE; -- IRN 4099
  --
  oznaka_l NUMBER(1);
  cvor_centar_l VARCHAR2(21);
  naredba_l VARCHAR2(2000);
BEGIN

  pra_pka_iud.puni_pkapro ( -- IRN 1700
    zmpsus_sifra_p => 'PKA',
    zmpvpro_sifra_p => '0003', -- Pay Card sustav
    pkapro_opis_p =>
      SUBSTR (
        'pra_pos_pkakar.provjeri_pkakar: gmpkas_id_p ' || gmpkas_id_p ||
          ', pkakar_broj_p ' || pkakar_broj_p ||
          ', pkakar_pin4_p ' || pkakar_pin4_p ||
          ', datum_p ' || TO_CHAR (datum_p, 'DD.MM.RRRR HH24:MI:SS') ||
          ', iznos_p ' || iznos_p,
        1,
        2000),
    ozn_vaznosti_p => -1);

  IF gmpkas_tekuceg_cvora (gmpkas_id_p) THEN
    pra_pos_pkakar.provjeri_pkakar_t (
      gmpkas_id_p, pkakar_broj_p, pkakar_pin4_p, datum_p, iznos_p, gmpkas_oib_p,
      pkakar_id_l, metcvor_sifra_l, nac_id_l, stopa_popusta_pos1_l, stopa_popusta_pos2_l,
      gost_id_l, age_id_l, pkaadr_id_l, ozn_prepaid_l, izn_neiskoristen_l,
      ime_l, prezime_l, nac2_id_l, oj_sifra_l,
      zmpojr_sifra_l, zmpojr_naziv_l, metcvor_sifra2_l, izn_povrata_l,
      sifra_l, ozn_provjeri_limit_l, -- IRN 3771
      izn_odobren0_l, -- IRN 3940
      basic_paycard_number_l, prepaid_type_l, -- IRN 4099
      oznaka_l);
  ELSE
    cvor_centar_l := cvor_centar;
    naredba_l :=
      'BEGIN ' ||
      '  pra_pos_pkakar.provjeri_pkakar_c1<CVOR> ( ' ||
      '    :gmpkas_id_p, :pkakar_broj_p, :pkakar_pin4_p, :datum_p, :iznos_p, :gmpkas_oib_p, ' ||
      '    :pkakar_id_l, :metcvor_sifra_l, :nac_id_l, :stopa_popusta_pos1_l, :stopa_popusta_pos2_l, ' ||
      '    :gost_id_l, :age_id_l, :pkaadr_id_l, :ozn_prepaid_l, :izn_neiskoristen_l, ' ||
      '    :ime_l, :prezime_l, :nac2_id_l, :oj_sifra_l, ' ||
      '    :zmpojr_sifra_l, :zmpojr_naziv_l, :metcvor_sifra2_l, :izn_povrata_l, ' ||
      '    :sifra_l, :ozn_provjeri_limit_l, ' ||
      '    :izn_odobren0_l, ' ||
      '    :basic_paycard_number_l, :prepaid_type_l, ' ||
      '    :oznaka_l); ' ||
      'END;';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_centar_l)
      USING gmpkas_id_p, pkakar_broj_p, pkakar_pin4_p, datum_p, iznos_p, gmpkas_oib_p,
            OUT pkakar_id_l, OUT metcvor_sifra_l, OUT nac_id_l, OUT stopa_popusta_pos1_l, OUT stopa_popusta_pos2_l,
            OUT gost_id_l, OUT age_id_l, OUT pkaadr_id_l, OUT ozn_prepaid_l, OUT izn_neiskoristen_l,
            OUT ime_l, OUT prezime_l, OUT nac2_id_l, OUT oj_sifra_l,
            OUT zmpojr_sifra_l, OUT zmpojr_naziv_l, OUT metcvor_sifra2_l, OUT izn_povrata_l,
            OUT sifra_l, OUT ozn_provjeri_limit_l, -- IRN 3771
            OUT izn_odobren0_l, -- IRN 3940
            OUT basic_paycard_number_l, OUT prepaid_type_l, -- IRN 4099
            OUT oznaka_l;
  END IF;

  IF oznaka_l = -1 THEN
    -- karticu treba traiti na drugim vorovima
    cvor_centar_l := cvor_centar;
    naredba_l :=
      'BEGIN ' ||
      '  pra_pos_pkakar.provjeri_pkakar_c2<CVOR> ( ' ||
      '    :gmpkas_id_p, :pkakar_broj_p, :pkakar_pin4_p, :datum_p, :iznos_p, :gmpkas_oib_p, ' ||
      '    :pkakar_id_l, :metcvor_sifra_l, :nac_id_l, :stopa_popusta_pos1_l, :stopa_popusta_pos2_l, ' ||
      '    :gost_id_l, :age_id_l, :pkaadr_id_l, :ozn_prepaid_l, :izn_neiskoristen_l, ' ||
      '    :ime_l, :prezime_l, :nac2_id_l, :oj_sifra_l, ' ||
      '    :zmpojr_sifra_l, :zmpojr_naziv_l, :metcvor_sifra2_l, :izn_povrata_l, ' ||
      '    :sifra_l, :ozn_provjeri_limit_l, ' ||
      '    :izn_odobren0_l, ' ||
      '    :basic_paycard_number_l, :prepaid_type_l); ' ||
      'END;';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_centar_l)
      USING gmpkas_id_p, pkakar_broj_p, pkakar_pin4_p, datum_p, iznos_p, gmpkas_oib_p,
            OUT pkakar_id_l, OUT metcvor_sifra_l, OUT nac_id_l, OUT stopa_popusta_pos1_l, OUT stopa_popusta_pos2_l,
            OUT gost_id_l, OUT age_id_l, OUT pkaadr_id_l, OUT ozn_prepaid_l, OUT izn_neiskoristen_l,
            OUT ime_l, OUT prezime_l, OUT nac2_id_l, OUT oj_sifra_l,
            OUT zmpojr_sifra_l, OUT zmpojr_naziv_l, OUT metcvor_sifra2_l, OUT izn_povrata_l,
            OUT sifra_l, OUT ozn_provjeri_limit_l, -- IRN 3771
            OUT izn_odobren0_l, -- IRN 3940
            OUT basic_paycard_number_l, OUT prepaid_type_l; -- IRN 4099

  END IF;

  pkakar_id_p := pkakar_id_l;
  metcvor_sifra_p := metcvor_sifra_l;
  nac_id_p := nac_id_l;
  stopa_popusta_pos1_p := stopa_popusta_pos1_l;
  stopa_popusta_pos2_p := stopa_popusta_pos2_l;
  gost_id_p := gost_id_l;
  age_id_p := age_id_l;
  pkaadr_id_p := pkaadr_id_l;
  ozn_prepaid_p := ozn_prepaid_l;
  izn_neiskoristen_p := izn_neiskoristen_l;
  ime_p := ime_l;
  prezime_p := prezime_l;
  nac2_id_p := nac2_id_l;
  oj_sifra_p := oj_sifra_l;
  zmpojr_sifra_p := zmpojr_sifra_l;
  zmpojr_naziv_p := zmpojr_naziv_l;
  metcvor_sifra2_p := metcvor_sifra2_l;
  izn_povrata_p := izn_povrata_l;
  sifra_p := sifra_l;                           -- IRN 3771
  ozn_provjeri_limit_p := ozn_provjeri_limit_l; -- IRN 3771
  izn_odobren0_p := izn_odobren0_l; -- IRN 3940
  basic_paycard_number_p := basic_paycard_number_l; -- IRN 4099
  prepaid_type_p := prepaid_type_l;                 -- IRN 4099

END;
PROCEDURE PROVJERI_PKAKAR_C1
 (GMPKAS_ID_P IN mgmp_kase.id%TYPE
 ,PKAKAR_BROJ_P IN tpka_kartice.broj%TYPE
 ,PKAKAR_PIN4_P IN VARCHAR2
 ,DATUM_P IN tpka_kartice.dat_zav%TYPE
 ,IZNOS_P IN tpka_kar_rnk.iznos%TYPE
 ,GMPKAS_OIB_P IN s_vlasnik.oib%TYPE
 ,PKAKAR_ID_P OUT tpka_kartice.id%TYPE
 ,METCVOR_SIFRA_P OUT smet_cvorovi.sifra%TYPE
 ,NAC_ID_P OUT tpka_kartice.nac_id%TYPE
 ,STOPA_POPUSTA_POS1_P OUT tpka_kartice.stopa_popusta_pos1%TYPE
 ,STOPA_POPUSTA_POS2_P OUT tpka_kartice.stopa_popusta_pos2%TYPE
 ,GOST_ID_P OUT tpka_kartice.gost_id%TYPE
 ,AGE_ID_P OUT tpka_kartice.age_id%TYPE
 ,PKAADR_ID_P OUT tpka_kartice.pkaadr_id%TYPE
 ,OZN_PREPAID_P OUT tpka_kartice.ozn_prepaid%TYPE
 ,IZN_NEISKORISTEN_P OUT tpka_kartice.izn_odobren%TYPE
 ,IME_P OUT tpka_kartice.ime%TYPE
 ,PREZIME_P OUT tpka_kartice.prezime%TYPE
 ,NAC2_ID_P OUT tpka_kartice.nac2_id%TYPE
 ,OJ_SIFRA_P OUT m_oj.sifra%TYPE
 ,ZMPOJR_SIFRA_P OUT m_oj.sifra%TYPE
 ,ZMPOJR_NAZIV_P OUT m_oj.naziv%TYPE
 ,METCVOR_SIFRA2_P OUT smet_cvorovi.sifra%TYPE
 ,IZN_POVRATA_P OUT tpka_kartice.izn_odobren%TYPE
 ,SIFRA_P OUT tpka_kartice.sifra%TYPE
 ,OZN_PROVJERI_LIMIT_P OUT NUMBER
 ,IZN_ODOBREN0_P OUT tpka_kartice.izn_odobren%TYPE
 ,BASIC_PAYCARD_NUMBER_P OUT tpka_kartice.broj%TYPE
 ,PREPAID_TYPE_P OUT tpka_kartice.prepaid_type%TYPE
 ,OZNAKA_P OUT NUMBER
 )
 IS
--
  naredba_l VARCHAR2(2000);
  cvor_gmpkas_l VARCHAR2(21) := cvor_gmpkas (gmpkas_id_p);
BEGIN
  naredba_l :=
    'BEGIN ' ||
    '  pra_pos_pkakar.provjeri_pkakar_t<CVOR> ( ' ||
    '    :gmpkas_id_p, :pkakar_broj_p, :pkakar_pin4_p, :datum_p, :iznos_p, :gmpkas_oib_p, ' ||
    '    :pkakar_id_p, :metcvor_sifra_p, :nac_id_p, :stopa_popusta_pos1_p, :stopa_popusta_pos2_p, ' ||
    '    :gost_id_p, :age_id_p, :pkaadr_id_p, :ozn_prepaid_p, :izn_neiskoristen_p, ' ||
    '    :ime_p, :prezime_p, :nac2_id_p, :oj_sifra_p, ' ||
    '    :zmpojr_sifra_p, :zmpojr_naziv_p, :metcvor_sifra2_p, :izn_povrata_p, ' ||
    '    :sifra_p, :ozn_provjeri_limit_p, ' ||
    '    :izn_odobren0_p, ' ||
    '    :basic_paycard_number_p, :prepaid_type_p, ' ||
    '    :oznaka_p); ' ||
    'END;';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_gmpkas_l)
    USING gmpkas_id_p, pkakar_broj_p, pkakar_pin4_p, datum_p, iznos_p, gmpkas_oib_p,
          OUT pkakar_id_p, OUT metcvor_sifra_p, OUT nac_id_p, OUT stopa_popusta_pos1_p, OUT stopa_popusta_pos2_p,
          OUT gost_id_p, OUT age_id_p, OUT pkaadr_id_p, OUT ozn_prepaid_p, OUT izn_neiskoristen_p,
          OUT ime_p, OUT prezime_p, OUT nac2_id_p, OUT oj_sifra_p,
          OUT zmpojr_sifra_p, OUT zmpojr_naziv_p, OUT metcvor_sifra2_p, OUT izn_povrata_p,
          OUT sifra_p, OUT ozn_provjeri_limit_p, -- IRN 3771
          OUT izn_odobren0_p, -- IRN 3940
          OUT basic_paycard_number_p, OUT prepaid_type_p, -- IRN 4099
          OUT oznaka_p;
END;
PROCEDURE PROVJERI_PKAKAR_C2
 (GMPKAS_ID_P IN mgmp_kase.id%TYPE
 ,PKAKAR_BROJ_P IN tpka_kartice.broj%TYPE
 ,PKAKAR_PIN4_P IN VARCHAR2
 ,DATUM_P IN tpka_kartice.dat_zav%TYPE
 ,IZNOS_P IN tpka_kar_rnk.iznos%TYPE
 ,GMPKAS_OIB_P IN s_vlasnik.oib%TYPE
 ,PKAKAR_ID_P OUT tpka_kartice.id%TYPE
 ,METCVOR_SIFRA_P OUT smet_cvorovi.sifra%TYPE
 ,NAC_ID_P OUT tpka_kartice.nac_id%TYPE
 ,STOPA_POPUSTA_POS1_P OUT tpka_kartice.stopa_popusta_pos1%TYPE
 ,STOPA_POPUSTA_POS2_P OUT tpka_kartice.stopa_popusta_pos2%TYPE
 ,GOST_ID_P OUT tpka_kartice.gost_id%TYPE
 ,AGE_ID_P OUT tpka_kartice.age_id%TYPE
 ,PKAADR_ID_P OUT tpka_kartice.pkaadr_id%TYPE
 ,OZN_PREPAID_P OUT tpka_kartice.ozn_prepaid%TYPE
 ,IZN_NEISKORISTEN_P OUT tpka_kartice.izn_odobren%TYPE
 ,IME_P OUT tpka_kartice.ime%TYPE
 ,PREZIME_P OUT tpka_kartice.prezime%TYPE
 ,NAC2_ID_P OUT tpka_kartice.nac2_id%TYPE
 ,OJ_SIFRA_P OUT m_oj.sifra%TYPE
 ,ZMPOJR_SIFRA_P OUT m_oj.sifra%TYPE
 ,ZMPOJR_NAZIV_P OUT m_oj.naziv%TYPE
 ,METCVOR_SIFRA2_P OUT smet_cvorovi.sifra%TYPE
 ,IZN_POVRATA_P OUT tpka_kartice.izn_odobren%TYPE
 ,SIFRA_P OUT tpka_kartice.sifra%TYPE
 ,OZN_PROVJERI_LIMIT_P OUT NUMBER
 ,IZN_ODOBREN0_P OUT tpka_kartice.izn_odobren%TYPE
 ,BASIC_PAYCARD_NUMBER_P OUT tpka_kartice.broj%TYPE
 ,PREPAID_TYPE_P OUT tpka_kartice.prepaid_type%TYPE
 )
 IS
--
  oznaka_l NUMBER(1);
  naredba_l VARCHAR2(2000);
BEGIN

  <<petlja>>
  FOR ipkakar_c IN (
    SELECT DISTINCT ipkakar.metcvor_sifra AS metcvor_sifra
      FROM ipka_kartice ipkakar,
           smet_cvorovi metcvor
     WHERE metcvor.sifra = ipkakar.metcvor_sifra
       AND metcvor.ozn_u_mrezi = -1
       AND UPPER (ipkakar.broj) = UPPER (pkakar_broj_p)
       AND NVL (ipkakar.pin, 0) = NVL (pra_pka_s.pin32 (pkakar_pin4_p), 0)
       AND ipkakar.metcvor_sifra NOT IN ( -- na voru kojem "pripada" gmpkas ne treba opet traiti
           SELECT zmpojr.metcvor_sifra
             FROM mgmp_kase gmpkas,
                  mzmp_ojr zmpojr
            WHERE gmpkas.id = gmpkas_id_p
              AND gmpkas.zmpojr_id = zmpojr.id))
  LOOP
    oznaka_l := NULL; -- IRN 3405
    IF ipkakar_c.metcvor_sifra = pra_zmp_zaj.tekuci_cvor THEN
      pra_pos_pkakar.provjeri_pkakar_t (
        gmpkas_id_p, pkakar_broj_p, pkakar_pin4_p, datum_p, iznos_p, gmpkas_oib_p,
        pkakar_id_p, metcvor_sifra_p, nac_id_p, stopa_popusta_pos1_p, stopa_popusta_pos2_p,
        gost_id_p, age_id_p, pkaadr_id_p, ozn_prepaid_p, izn_neiskoristen_p,
        ime_p, prezime_p, nac2_id_p, oj_sifra_p,
        zmpojr_sifra_p, zmpojr_naziv_p, metcvor_sifra2_p, izn_povrata_p,
        sifra_p, ozn_provjeri_limit_p, -- IRN 3771
        izn_odobren0_p, -- IRN 3940
        basic_paycard_number_p, prepaid_type_p, -- IRN 4099 
        oznaka_l);
    ELSE
      naredba_l :=
        'BEGIN ' ||
        '  pra_pos_pkakar.provjeri_pkakar_t<CVOR> ( ' ||
        '    :gmpkas_id_p, :pkakar_broj_p, :pkakar_pin4_p, :datum_p, :iznos_p, :gmpkas_oib_p, ' ||
        '    :pkakar_id_p, :metcvor_sifra_p, :nac_id_p, :stopa_popusta_pos1_p, :stopa_popusta_pos2_p, ' ||
        '    :gost_id_p, :age_id_p, :pkaadr_id_p, :ozn_prepaid_p, :izn_neiskoristen_p, ' ||
        '    :ime_p, :prezime_p, :nac2_id_p, :oj_sifra_p, ' ||
        '    :zmpojr_sifra_p, :zmpojr_naziv_p, :metcvor_sifra2_p, :izn_povrata_p, ' ||
        '    :sifra_p, :ozn_provjeri_limit_p, ' ||
        '    :izn_odobren0_p, ' ||
        '    :basic_paycard_number_p, :prepaid_type_p, ' ||
        '    :oznaka_l); ' ||
        'END;';
      EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', '@' || ipkakar_c.metcvor_sifra)
        USING gmpkas_id_p, pkakar_broj_p, pkakar_pin4_p, datum_p, iznos_p, gmpkas_oib_p,
              OUT pkakar_id_p, OUT metcvor_sifra_p, OUT nac_id_p, OUT stopa_popusta_pos1_p, OUT stopa_popusta_pos2_p,
              OUT gost_id_p, OUT age_id_p, OUT pkaadr_id_p, OUT ozn_prepaid_p, OUT izn_neiskoristen_p,
              OUT ime_p, OUT prezime_p, OUT nac2_id_p, OUT oj_sifra_p,
              OUT zmpojr_sifra_p, OUT zmpojr_naziv_p, OUT metcvor_sifra2_p, OUT izn_povrata_p,
              OUT sifra_p, OUT ozn_provjeri_limit_p, -- IRN 3771
              OUT izn_odobren0_p, -- IRN 3940
              OUT basic_paycard_number_p, OUT prepaid_type_p, -- IRN 4099
              OUT oznaka_l;
    END IF;
    -- IRN 3405; IF oznaka_l = -1 THEN
    IF pkakar_id_p IS NOT NULL THEN -- IRN 3405; kartica je naena
      EXIT petlja;
    END IF;
  END LOOP;

END;
PROCEDURE PROVJERI_PKAKAR_T
 (GMPKAS_ID_P IN mgmp_kase.id%TYPE
 ,PKAKAR_BROJ_P IN tpka_kartice.broj%TYPE
 ,PKAKAR_PIN4_P IN VARCHAR2
 ,DATUM_P IN tpka_kartice.dat_zav%TYPE
 ,IZNOS_P IN tpka_kar_rnk.iznos%TYPE
 ,GMPKAS_OIB_P IN s_vlasnik.oib%TYPE
 ,PKAKAR_ID_P OUT tpka_kartice.id%TYPE
 ,METCVOR_SIFRA_P OUT smet_cvorovi.sifra%TYPE
 ,NAC_ID_P OUT tpka_kartice.nac_id%TYPE
 ,STOPA_POPUSTA_POS1_P OUT tpka_kartice.stopa_popusta_pos1%TYPE
 ,STOPA_POPUSTA_POS2_P OUT tpka_kartice.stopa_popusta_pos2%TYPE
 ,GOST_ID_P OUT tpka_kartice.gost_id%TYPE
 ,AGE_ID_P OUT tpka_kartice.age_id%TYPE
 ,PKAADR_ID_P OUT tpka_kartice.pkaadr_id%TYPE
 ,OZN_PREPAID_P OUT tpka_kartice.ozn_prepaid%TYPE
 ,IZN_NEISKORISTEN_P OUT tpka_kartice.izn_odobren%TYPE
 ,IME_P OUT tpka_kartice.ime%TYPE
 ,PREZIME_P OUT tpka_kartice.prezime%TYPE
 ,NAC2_ID_P OUT tpka_kartice.nac2_id%TYPE
 ,OJ_SIFRA_P OUT m_oj.sifra%TYPE
 ,ZMPOJR_SIFRA_P OUT m_oj.sifra%TYPE
 ,ZMPOJR_NAZIV_P OUT m_oj.naziv%TYPE
 ,METCVOR_SIFRA2_P OUT smet_cvorovi.sifra%TYPE
 ,IZN_POVRATA_P OUT tpka_kartice.izn_odobren%TYPE
 ,SIFRA_P OUT tpka_kartice.sifra%TYPE
 ,OZN_PROVJERI_LIMIT_P OUT NUMBER
 ,IZN_ODOBREN0_P OUT tpka_kartice.izn_odobren%TYPE
 ,BASIC_PAYCARD_NUMBER_P OUT tpka_kartice.broj%TYPE
 ,PREPAID_TYPE_P OUT tpka_kartice.prepaid_type%TYPE
 ,OZNAKA_P OUT NUMBER
 )
 IS
--
  ozn_knjizenja_l mgmp_kase.ozn_knjizenja%TYPE; -- IRN 2819
  datum_l DATE := TRUNC (NVL (datum_p, SYSDATE), 'MI'); -- datum_p bi trebao biti sadravati i sat i minutu

  CURSOR pkakar_c IS
    SELECT
      pkakar.id, pkakar.nac_id, pkakar.stopa_popusta_pos1, pkakar.stopa_popusta_pos2,
      pkakar.gost_id, pkakar.age_id, pkakar.pkaadr_id, pkakar.ozn_prepaid,
      DECODE (pkakar.izn_odobren, NULL,
        -- ako je odobreni iznos neispunjen i kartica nije Prepaid onda znai da je odobreni iznos neogranien
        DECODE (pkakar.ozn_prepaid, -1, 0, -1),
        pkakar.izn_odobren - NVL (pkakar.izn_potrosen, 0)) AS izn_neiskoristen, -- IRN 2527
      pkakar.ime,
      pkakar.prezime,
      pkakar.nac2_id,     -- IRN 2716
      pkakar.oj_id,       -- IRN 2819
      pkakar.zmpojr_id,   -- IRN 3218
      pkakar.izn_odobren, -- IRN 3478
      pkakar.sifra,       -- IRN 3771
      DECODE (pkakar.izn_limita2, NULL, 0, -1) AS ozn_provjeri_limit, -- IRN 3771
      pkakar.broj,        -- IRN 4099
      pkakar.prepaid_type -- IRN 4099
    FROM
      (
      SELECT
        id, nac_id, stopa_popusta_pos1, stopa_popusta_pos2,
        gost_id, age_id, pkaadr_id, ozn_prepaid,
        izn_odobren, izn_potrosen,
        ime,
        prezime,
        nac2_id, oj_id, zmpojr_id,
        pin,
        dat_poc, dat_zav,
        sifra,       -- IRN 3771
        izn_limita2, -- IRN 3771
        broj,        -- IRN 4099
        prepaid_type -- IRN 4099
      FROM
        tpka_kartice
      WHERE
        UPPER (broj) = UPPER (pkakar_broj_p)
        AND oznaka = 'V'
      UNION ALL
      -- IRN 3478; dodatne kartice
      SELECT
        pkakar2.id, pkakar2.nac_id, pkakar2.stopa_popusta_pos1, pkakar2.stopa_popusta_pos2,
        pkakar2.gost_id, pkakar2.age_id, pkakar2.pkaadr_id, pkakar2.ozn_prepaid,
        pkakar2.izn_odobren, pkakar2.izn_potrosen,
        DECODE (pkakardod.ime || pkakardod.prezime, NULL, pkakar2.ime, pkakardod.ime),
        DECODE (pkakardod.ime || pkakardod.prezime, NULL, pkakar2.prezime, pkakardod.prezime),
        pkakar2.nac2_id, pkakar2.oj_id, pkakar2.zmpojr_id,
        NULL, -- dodatna kartica nema PIN
        pkakar2.dat_poc, pkakar2.dat_zav,
        DECODE (pkakardod.sifra, NULL, pkakar2.sifra, pkakardod.sifra), -- IRN 3771
        pkakar2.izn_limita2, -- IRN 3771
        pkakar2.broj,        -- IRN 4099
        pkakar2.prepaid_type -- IRN 4099
      FROM
        tpka_kartice pkakar2,
        tpka_kar_dod pkakardod
      WHERE
        pkakardod.pkakar_id = pkakar2.id
        AND UPPER (pkakardod.broj) = UPPER (pkakar_broj_p)
        AND pkakar2.oznaka = 'V'
        AND pkakardod.oznaka = 'V'
      -- KRAJ IRN 3478; dodatne kartice
      ) pkakar, -- IRN 2819
      t_gosti gost
    WHERE
      NVL (pkakar.pin, 0) = NVL (pra_pka_s.pin32 (pkakar_pin4_p), 0)
      AND datum_l BETWEEN NVL (pkakar.dat_poc, datum_l) AND NVL (pkakar.dat_zav, datum_l)
      AND pkakar.gost_id = gost.id(+)
      AND (
          pkakar.gost_id IS NULL
          OR
            (
            gost.ozn_prisutnosti = 'P'
            -- IRN 2548; AND TRUNC (NVL (datum_l, SYSDATE)) BETWEEN gost.dat_dolaska AND gost.dat_odlaska - 1 - pra_pos_pkakar.gmpkas_ozn_knjizenja (gmpkas_id_p)
            -- IRN 2548; Oznaka RNK uz gosta (t_gosti.ozn_rnk) nadjaava oznaku RNK uz kasu (mgmp_kase.ozn_knjizenja).
            -- IRN 2819; umjesto funkcije pra_pos_pkakar.gmpkas_ozn_knjizenja varijabla ozn_knjizenja_l
            AND TRUNC (NVL (datum_l, SYSDATE)) BETWEEN gost.dat_dolaska AND gost.dat_odlaska - 1 - NVL (gost.ozn_rnk, ozn_knjizenja_l)
            AND NVL (gost.ozn_rnk, -1) = -1
            )
          )
      -- IRN 2548; ako je Prepaid uplata putem posebno oznaenog proizvoda (= B) onda ne smije biti nezaraunatih PKA RNK
      AND (pkakar.ozn_prepaid = 0 OR pra_tpka_kartice.kol_nezaracunatih_rnk (pkakar.id) = 0)
      -- IRN 2527; AND DECODE (izn_odobren, NULL, 1, izn_odobren - NVL (izn_potrosen, 0) - NVL (iznos_p, 0)) >= 0;
      AND DECODE (pkakar.izn_odobren, NULL, 1, pkakar.izn_odobren - NVL (pkakar.izn_potrosen, 0)) >= 0;

  pkakar_c_l pkakar_c%ROWTYPE;

  -- IRN 3218; knjiga rauna kartice ujedno i knjiga rauna gdje se trai adresa korisnik kartice
  CURSOR zmpojr_c IS
    SELECT sifra, naziv FROM m_oj WHERE id = pkakar_c_l.zmpojr_id;

  -- IRN 3371; podaci o kartici u povezanim drutvima
  CURSOR pkakarpd_c IS
    SELECT pkakarpd.id, pkakarpd.nac_id, pkakarpd.nac2_id, oj.sifra AS oj_sifra,
           pkakarpd.age_id -- IRN 3447
      FROM tpka_kar_pd pkakarpd,
           m_oj oj
     WHERE pkakarpd.oj_id = oj.id(+)
       AND pkakarpd.pkakar_id = pkakar_c_l.id
       AND pkakarpd.oib = gmpkas_oib_p;
  pkakarpd_c_l pkakarpd_c%ROWTYPE;

  izn_odobren0_l tpka_kartice.izn_odobren%TYPE; -- IRN 3478

  -- IRN 4025; ifre naina potronje za koje treba provjeriti OIB povezanog drutva
  pka_param_1095_l szmp_parametri.vrijednost%TYPE;

  FUNCTION f_nac_id (p_nac_id IN NUMBER) RETURN NUMBER
  IS
    br_redaka_l NUMBER;
  BEGIN
    IF p_nac_id IS NOT NULL THEN
      SELECT COUNT (1) INTO br_redaka_l
        FROM m_nacpot
       WHERE id = p_nac_id
         AND -1 = zmp_zaj.string_in_list (sifra, pka_param_1095_l);
      IF br_redaka_l > 0 THEN
        RETURN (NULL); -- nain potronje se ne moe koristiti u povezanom drutvu
      END IF;
    END IF;
    RETURN (p_nac_id);
  END;
BEGIN

  SELECT MIN (ozn_knjizenja) INTO ozn_knjizenja_l FROM mgmp_kase WHERE id = gmpkas_id_p; -- IRN 2819

  OPEN pkakar_c;
  FETCH pkakar_c INTO pkakar_c_l;
  CLOSE pkakar_c;

  IF pkakar_c_l.id IS NOT NULL THEN
    pkakar_id_p := pkakar_c_l.id;
    metcvor_sifra_p := pra_zmp_zaj.tekuci_cvor;
    nac_id_p := pkakar_c_l.nac_id;
    stopa_popusta_pos1_p := pkakar_c_l.stopa_popusta_pos1;
    stopa_popusta_pos2_p := pkakar_c_l.stopa_popusta_pos2;
    gost_id_p := pkakar_c_l.gost_id;
    age_id_p := pkakar_c_l.age_id;
    pkaadr_id_p := pkakar_c_l.pkaadr_id;
    ozn_prepaid_p := pkakar_c_l.ozn_prepaid; -- IRN 2527
    izn_neiskoristen_p := pkakar_c_l.izn_neiskoristen; -- IRN 2527
    ime_p := pkakar_c_l.ime;          -- IRN 2598
    prezime_p := pkakar_c_l.prezime;  -- IRN 2598
    nac2_id_p := pkakar_c_l.nac2_id;  -- IRN 2716
    SELECT MIN (sifra) INTO oj_sifra_p FROM m_oj WHERE id = pkakar_c_l.oj_id; -- IRN 2819; mjesto troka zaposlenika
    -- IRN 3218; knjiga rauna kartice ujedno i knjiga rauna gdje se trai adresa korisnik kartice
    OPEN zmpojr_c;
    FETCH zmpojr_c INTO zmpojr_sifra_p, zmpojr_naziv_p;
    CLOSE zmpojr_c;

    -- IRN 3478; izraunaj iznos povrata (inicijalna uplata nije povratna)
    IF pkakar_c_l.ozn_prepaid = -1 THEN
      SELECT SUM (iznos) INTO izn_odobren0_l
        FROM tpka_kar_rnk
       WHERE pkakar_id = pkakar_c_l.id
         AND oznaka = 0; -- inicijalna uplata

      izn_odobren0_p := izn_odobren0_l; -- IRN 3940
      izn_povrata_p := LEAST (NVL (pkakar_c_l.izn_neiskoristen, 0), NVL (pkakar_c_l.izn_odobren, 0) - NVL (izn_odobren0_l, 0));
    END IF;
    -- KRAJ IRN 3478; izraunaj iznos povrata (inicijalna uplata nije povratna)

    -- IRN 3371; kartice zaposlenika u povezanim drutvima
    IF gmpkas_oib_p = pra_zmp_s.vlas_oib
      -- ako je korisnik kartice gost ili adresa onda se POS raun mora knjiiti na shemu gdje je izdana kartica
      OR pkakar_c_l.age_id IS NULL
    THEN
      -- vor kartice na koji e se knjiiti POS raun (tpka_rnkase)
      metcvor_sifra2_p := pra_zmp_zaj.tekuci_cvor;
    ELSE
      -- vor kase na koji e se knjiiti POS raun (tpka_rnkase)
      SELECT MIN (NVL (zmpojr.metcvor_sifra_gas, zmpojr.metcvor_sifra)) INTO metcvor_sifra2_p
        FROM mgmp_kase gmpkas, mzmp_ojr zmpojr
       WHERE gmpkas.zmpojr_id = zmpojr.id
         AND gmpkas.id = gmpkas_id_p;
      -- podaci o kartici u povezanim drutvima
      OPEN pkakarpd_c;
      FETCH pkakarpd_c INTO pkakarpd_c_l;
      CLOSE pkakarpd_c;
      IF pkakarpd_c_l.id IS NOT NULL THEN
        -- Postoji podatak o kartici u povezanim druvima
        nac_id_p := NVL (pkakarpd_c_l.nac_id, nac_id_p);
        nac2_id_p := NVL (pkakarpd_c_l.nac2_id, nac2_id_p);
        oj_sifra_p := NVL (pkakarpd_c_l.oj_sifra, oj_sifra_p);
        age_id_p := NVL (pkakarpd_c_l.age_id, age_id_p); -- IRN 3447
      ELSE
        -- IRN 4025
        -- Ne postoji podatak o kartici u povezanim drutvima
        -- ifre naina potronje za koje treba provjeriti OIB povezanog drutva
        pka_param_1095_l := pra_pka_zaj.vrijednost_parametra ('1095');
        IF pka_param_1095_l = 'nebitno' THEN
          NULL;
        ELSE
          nac_id_p := f_nac_id (nac_id_p);
          nac2_id_p := f_nac_id (nac2_id_p);
        END IF;
      END IF;
    END IF;
    -- KRAJ IRN 3371

    -- IRN 3771
    sifra_p := pkakar_c_l.sifra;
    ozn_provjeri_limit_p := pkakar_c_l.ozn_provjeri_limit;
    -- KRAJ IRN 3771

    -- IRN 4099
    basic_paycard_number_p := pkakar_c_l.broj;
    prepaid_type_p := pkakar_c_l.prepaid_type;
    -- KRAJ IRN 4099

  ELSE
    IF UPPER (pra_pka_zaj.vrijednost_parametra ('1036')) NOT IN ('DA') THEN
      -- Na tekuem voru ne primaju kartice drugih OJ.
      oznaka_p := 0;  -- karticu NE treba traiti na drugim vorovima
    ELSE
      oznaka_p := -1; -- karticu treba traiti na drugim vorovima
    END IF;
  END IF;

END;
FUNCTION PKAKAR_TREBA_PIN
 (PKAKAR_ID_P IN tpka_kartice.id%TYPE
 ,METCVOR_SIFRA_P IN smet_cvorovi.sifra%TYPE
 )
 RETURN NUMBER
 IS
-- da (-1) = kartica treba PIN, ne (0) = kartica ne treba PIN
  oznaka_l NUMBER(1);
  cvor_centar_l VARCHAR2(21);
  naredba_l VARCHAR2(2000);
BEGIN

  IF metcvor_sifra_p = pra_zmp_zaj.tekuci_cvor THEN
    oznaka_l := pra_pos_pkakar.pkakar_treba_pin_t (pkakar_id_p);
  ELSE
    cvor_centar_l := cvor_centar;
    naredba_l :=
      'SELECT pra_pos_pkakar.pkakar_treba_pin_c<CVOR> (:pkakar_id_p, :metcvor_sifra_p) FROM dual<CVOR>';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_centar_l) INTO oznaka_l
      USING pkakar_id_p, metcvor_sifra_p;
  END IF;

  RETURN (oznaka_l);

END;
FUNCTION PKAKAR_TREBA_PIN_C
 (PKAKAR_ID_P IN tpka_kartice.id%TYPE
 ,METCVOR_SIFRA_P IN smet_cvorovi.sifra%TYPE
 )
 RETURN NUMBER
 IS
--
  naredba_l VARCHAR2(2000);
  oznaka_l NUMBER(1);
BEGIN
  naredba_l :=
    'SELECT pra_pos_pkakar.pkakar_treba_pin_t<CVOR> (:pkakar_id_p) FROM dual<CVOR>';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', '@' || metcvor_sifra_p) INTO oznaka_l
    USING pkakar_id_p;
  RETURN (oznaka_l);
END;
FUNCTION PKAKAR_TREBA_PIN_T
 (PKAKAR_ID_P IN tpka_kartice.id%TYPE
 )
 RETURN NUMBER
 IS
-- da (-1) = kartica treba PIN, ne (0) = kartica ne treba PIN
  br_redaka_l NUMBER;
BEGIN

  SELECT COUNT (id) INTO br_redaka_l
    FROM tpka_kartice
   WHERE id = pkakar_id_p
     AND pin IS NOT NULL;

  IF br_redaka_l > 0 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;

END;
FUNCTION PKAKAR_PIN_OK
 (PKAKAR_ID_P IN tpka_kartice.id%TYPE
 ,METCVOR_SIFRA_P IN smet_cvorovi.sifra%TYPE
 ,PKAKAR_PIN4_P IN VARCHAR2
 )
 RETURN NUMBER
 IS
--
  oznaka_l NUMBER(1);
  cvor_centar_l VARCHAR2(21);
  naredba_l VARCHAR2(2000);
BEGIN

  IF metcvor_sifra_p = pra_zmp_zaj.tekuci_cvor THEN
    oznaka_l := pra_pos_pkakar.pkakar_pin_ok_t (pkakar_id_p, pkakar_pin4_p);
  ELSE
    cvor_centar_l := cvor_centar;
    naredba_l :=
      'SELECT pra_pos_pkakar.pkakar_pin_ok_c<CVOR> (:pkakar_id_p, :metcvor_sifra_p, :pkakar_pin4_p) FROM dual<CVOR>';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_centar_l) INTO oznaka_l
      USING pkakar_id_p, metcvor_sifra_p, pkakar_pin4_p;
  END IF;

  RETURN (oznaka_l);

END;
FUNCTION PKAKAR_PIN_OK_C
 (PKAKAR_ID_P IN tpka_kartice.id%TYPE
 ,METCVOR_SIFRA_P IN smet_cvorovi.sifra%TYPE
 ,PKAKAR_PIN4_P IN VARCHAR2
 )
 RETURN NUMBER
 IS
--
  naredba_l VARCHAR2(2000);
  oznaka_l NUMBER(1);
BEGIN
  naredba_l :=
    'SELECT pra_pos_pkakar.pkakar_pin_ok_t<CVOR> (:pkakar_id_p, :pkakar_pin4_p) FROM dual<CVOR>';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', '@' || metcvor_sifra_p) INTO oznaka_l
    USING pkakar_id_p, pkakar_pin4_p;
  RETURN (oznaka_l);
END;
FUNCTION PKAKAR_PIN_OK_T
 (PKAKAR_ID_P IN tpka_kartice.id%TYPE
 ,PKAKAR_PIN4_P IN VARCHAR2
 )
 RETURN NUMBER
 IS
--
  br_redaka_l NUMBER;
BEGIN

  SELECT COUNT (id) INTO br_redaka_l
    FROM tpka_kartice
   WHERE id = pkakar_id_p
     AND NVL (pin, 0) = NVL (pra_pka_s.pin32 (pkakar_pin4_p), 0);

  IF br_redaka_l > 0 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;

END;
PROCEDURE PUNI_PKAKARRNK
 (PKAKAR_ID_P IN tpka_kartice.id%TYPE
 ,METCVOR_SIFRA_P IN smet_cvorovi.sifra%TYPE
 ,PKAKAR_PIN4_P IN VARCHAR2
 ,GMPKAS_ID_P IN tpka_kar_rnk.gmpkas_id%TYPE
 ,GOD_POSLOVNA_P IN tpka_kar_rnk.god_poslovna%TYPE
 ,RBR_P IN tpka_kar_rnk.rbr%TYPE
 ,DATUM_P IN tpka_kar_rnk.datum%TYPE
 ,IZNOS_P IN tpka_kar_rnk.iznos%TYPE
 ,OZNAKA_P IN tpka_kar_rnk.oznaka%TYPE
 ,NAC_ID_P IN tpka_kar_rnk.nac_id%TYPE
 ,IZN_RNK_P IN tpka_kar_rnk.izn_rnk%TYPE
 ,IZN_POPUSTA_P IN tpka_kar_rnk.izn_popusta%TYPE
 ,IZN_POPUSTA2_P IN tpka_kar_rnk.izn_popusta%TYPE := 0
 ,ZMPOJR_ID_P OUT mzmp_ojr.id%TYPE
 ,SO_ID_P OUT m_so.id%TYPE
 ,PKAKARRNK_ID_P OUT tpka_kar_rnk.id%TYPE
 )
 IS
-- puni redak tablice tpka_kar_rnk
  cvor_centar_l VARCHAR2(21);
  naredba_l VARCHAR2(2000);
BEGIN

  IF pkakar_id_p IS NULL
    OR metcvor_sifra_p IS NULL
    OR gmpkas_id_p IS NULL
    OR god_poslovna_p IS NULL
    OR rbr_p IS NULL
    OR datum_p IS NULL
    OR iznos_p IS NULL
    OR oznaka_p IS NULL  -- IRN 2548; 1 = uplata, 2 = koritenje
    OR nac_id_p IS NULL  -- IRN 2766
    OR izn_rnk_p IS NULL -- IRN 2766
    OR izn_popusta_p IS NULL -- IRN 2766
  THEN
    -- Nedostaju vrijednosti obveznih parametara!
    pra_pka_zaj.vrati_poruku (-20086);
  END IF;

  IF datum_p > TRUNC (SYSDATE) THEN
    -- Datum je vei od tekueg!
    pra_pka_zaj.vrati_poruku (-20087);
  END IF;

  IF metcvor_sifra_p = pra_zmp_zaj.tekuci_cvor THEN
    pra_pos_pkakar.puni_pkakarrnk_t (
      pkakar_id_p, pkakar_pin4_p, gmpkas_id_p, god_poslovna_p, rbr_p, datum_p, iznos_p,
      oznaka_p, nac_id_p, izn_rnk_p, izn_popusta_p, izn_popusta2_p,
      zmpojr_id_p, so_id_p, pkakarrnk_id_p);
  ELSE
    cvor_centar_l := cvor_centar;
    naredba_l :=
      'BEGIN ' ||
      '  pra_pos_pkakar.puni_pkakarrnk_c<CVOR> ( ' ||
      '    :pkakar_id_p, :metcvor_sifra_p, :pkakar_pin4_p, :gmpkas_id_p, :god_poslovna_p, :rbr_p, :datum_p, :iznos_p, ' ||
      '    :oznaka_p, :nac_id_p, :izn_rnk_p, :izn_popusta_p, :izn_popusta2_p, ' ||
      '    :zmpojr_id_p, :so_id_p, :pkakarrnk_id_p); ' ||
      'END;';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_centar_l)
      USING pkakar_id_p, metcvor_sifra_p, pkakar_pin4_p, gmpkas_id_p, god_poslovna_p, rbr_p, datum_p, iznos_p,
            oznaka_p, nac_id_p, izn_rnk_p, izn_popusta_p, izn_popusta2_p,
            OUT zmpojr_id_p, OUT so_id_p, OUT pkakarrnk_id_p;
  END IF;

END;
PROCEDURE PUNI_PKAKARRNK_C
 (PKAKAR_ID_P IN tpka_kartice.id%TYPE
 ,METCVOR_SIFRA_P IN smet_cvorovi.sifra%TYPE
 ,PKAKAR_PIN4_P IN VARCHAR2
 ,GMPKAS_ID_P IN tpka_kar_rnk.gmpkas_id%TYPE
 ,GOD_POSLOVNA_P IN tpka_kar_rnk.god_poslovna%TYPE
 ,RBR_P IN tpka_kar_rnk.rbr%TYPE
 ,DATUM_P IN tpka_kar_rnk.datum%TYPE
 ,IZNOS_P IN tpka_kar_rnk.iznos%TYPE
 ,OZNAKA_P IN tpka_kar_rnk.oznaka%TYPE
 ,NAC_ID_P IN tpka_kar_rnk.nac_id%TYPE
 ,IZN_RNK_P IN tpka_kar_rnk.izn_rnk%TYPE
 ,IZN_POPUSTA_P IN tpka_kar_rnk.izn_popusta%TYPE
 ,IZN_POPUSTA2_P IN tpka_kar_rnk.izn_popusta%TYPE
 ,ZMPOJR_ID_P OUT mzmp_ojr.id%TYPE
 ,SO_ID_P OUT m_so.id%TYPE
 ,PKAKARRNK_ID_P OUT tpka_kar_rnk.id%TYPE
 )
 IS
--
  naredba_l VARCHAR2(2000);
BEGIN
  naredba_l :=
    'BEGIN ' ||
    '  pra_pos_pkakar.puni_pkakarrnk_t<CVOR> ( ' ||
    '    :pkakar_id_p, :pkakar_pin4_p, :gmpkas_id_p, :god_poslovna_p, :rbr_p, :datum_p, :iznos_p, ' ||
    '    :oznaka_p, :nac_id_p, :izn_rnk_p, :izn_popusta_p, :izn_popusta2_p, ' ||
    '    :zmpojr_id_p, :so_id_p, :pkakarrnk_id_p); ' ||
    'END;';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', '@' || metcvor_sifra_p)
    USING pkakar_id_p, pkakar_pin4_p, gmpkas_id_p, god_poslovna_p, rbr_p, datum_p, iznos_p,
          oznaka_p, nac_id_p, izn_rnk_p, izn_popusta_p, izn_popusta2_p,
          OUT zmpojr_id_p, OUT so_id_p, OUT pkakarrnk_id_p;
END;
PROCEDURE PUNI_PKAKARRNK_T
 (PKAKAR_ID_P IN tpka_kartice.id%TYPE
 ,PKAKAR_PIN4_P IN VARCHAR2
 ,GMPKAS_ID_P IN tpka_kar_rnk.gmpkas_id%TYPE
 ,GOD_POSLOVNA_P IN tpka_kar_rnk.god_poslovna%TYPE
 ,RBR_P IN tpka_kar_rnk.rbr%TYPE
 ,DATUM_P IN tpka_kar_rnk.datum%TYPE
 ,IZNOS_P IN tpka_kar_rnk.iznos%TYPE
 ,OZNAKA_P IN tpka_kar_rnk.oznaka%TYPE
 ,NAC_ID_P IN tpka_kar_rnk.nac_id%TYPE
 ,IZN_RNK_P IN tpka_kar_rnk.izn_rnk%TYPE
 ,IZN_POPUSTA_P IN tpka_kar_rnk.izn_popusta%TYPE
 ,IZN_POPUSTA2_P IN tpka_kar_rnk.izn_popusta%TYPE
 ,ZMPOJR_ID_P OUT mzmp_ojr.id%TYPE
 ,SO_ID_P OUT m_so.id%TYPE
 ,PKAKARRNK_ID_P OUT tpka_kar_rnk.id%TYPE
 )
 IS
-- puni redak tablice TPKA_KAR_RNK
  CURSOR pkakar_c IS
    SELECT gost_id,
           zmpojr_id,
           pin
      FROM tpka_kartice
     WHERE id = pkakar_id_p;
  pkakar_c_l pkakar_c%ROWTYPE;

  pkakarrnk_id_l tpka_kar_rnk.id%TYPE; -- IRN 2781
BEGIN

  OPEN pkakar_c;
  FETCH pkakar_c INTO pkakar_c_l;
  IF pkakar_c%NOTFOUND THEN
    CLOSE pkakar_c;
    RETURN;
  END IF;
  CLOSE pkakar_c;

  IF NOT NVL (pkakar_c_l.pin, 0) = NVL (pra_pka_s.pin32 (pkakar_pin4_p), 0) THEN
    IF pkakar_pin4_p IS NULL AND oznaka_p = 1 THEN -- IRN 2548
      -- kod uplate PIN nije potreban i ako nije poznat ne treba ga slati
      NULL;
    ELSE
      -- Pogrean PIN!
      pra_pka_zaj.vrati_poruku (-20098);
    END IF;
  END IF;

  /*
  IRN 2527; dodan LPAD
  IRN 2548; dodana oznaka
  IRN 2766; dodani nac_id, izn_rnk, izn_popusta
  IRN 2781; dodan pkakarrnk_id_p
  IRN 4015; dodan izn_popusta2
  */
  pkakarrnk_id_l := pra_zmp_zaj.i3_sekvenca (NULL); -- IRN 2781

  INSERT INTO tpka_kar_rnk (
      id,
      pkakar_id, gmpkas_id, god_poslovna, rbr, datum, iznos, oznaka,
      nac_id, izn_rnk, izn_popusta, izn_popusta2)
    VALUES (
      pkakarrnk_id_l,
      pkakar_id_p, gmpkas_id_p, god_poslovna_p, LPAD (rbr_p, 6, '0'), datum_p, iznos_p, oznaka_p,
      nac_id_p, izn_rnk_p, izn_popusta_p, izn_popusta2_p);

  zmpojr_id_p := pkakar_c_l.zmpojr_id;

  IF pkakar_c_l.gost_id IS NOT NULL THEN
    SELECT sj.so_id INTO so_id_p
      FROM t_gosti gost,
           m_sj sj
     WHERE gost.sj_id = sj.id
       AND gost.id = pkakar_c_l.gost_id;
  END IF;

  pkakarrnk_id_p := pkakarrnk_id_l; -- IRN 2781

END;
PROCEDURE PONISTI_PKAKARRNK
 (PKAKAR_BROJ_P IN tpka_kartice.broj%TYPE
 ,ZMPOJR_ID_P IN tpka_rnkasa.zmpojr_id%TYPE
 ,GMPKAS_ID_P IN tpka_kar_rnk.gmpkas_id%TYPE
 ,GOD_POSLOVNA_P_P IN tpka_kar_rnk.god_poslovna%TYPE
 ,RBR_P_P IN tpka_kar_rnk.rbr%TYPE
 ,GOD_POSLOVNA_P IN tpka_kar_rnk.god_poslovna%TYPE
 ,RBR_P IN tpka_kar_rnk.rbr%TYPE
 ,DATUM_P IN tpka_kar_rnk.datum%TYPE
 ,IZNOS_P IN tpka_kar_rnk.iznos%TYPE
 ,OZNAKA_P IN tpka_kar_rnk.oznaka%TYPE
 ,NAC_ID_P IN tpka_kar_rnk.nac_id%TYPE
 ,IZN_RNK_P IN tpka_kar_rnk.izn_rnk%TYPE
 ,IZN_POPUSTA_P IN tpka_kar_rnk.izn_popusta%TYPE
 ,IZN_POPUSTA2_P IN tpka_kar_rnk.izn_popusta%TYPE
 ,PKAKARRNK_ID_P OUT tpka_kar_rnk.id%TYPE
 ,OZN_PONISTEN_P OUT NUMBER
 )
 IS
-- ponitavanje rauna sa kase; puni redak tablice tpka_kar_rnk
  metcvor_sifra_l smet_cvorovi.sifra%TYPE;
  pkakarrnk_id_l tpka_kar_rnk.id%TYPE; -- IRN 2781
  ozn_ponisten_l NUMBER := 0;
  cvor_centar_l VARCHAR2(21);
  naredba_l VARCHAR2(2000);
BEGIN

  IF pkakar_broj_p IS NULL
    OR zmpojr_id_p IS NULL
    OR gmpkas_id_p IS NULL
    OR god_poslovna_p_p IS NULL
    OR rbr_p_p IS NULL
    OR god_poslovna_p IS NULL
    OR rbr_p IS NULL
    OR datum_p IS NULL
    OR iznos_p IS NULL
    OR oznaka_p IS NULL      -- IRN 2548; 1 = uplata, 2 = koritenje
    OR nac_id_p IS NULL      -- IRN 2766
    OR izn_rnk_p IS NULL     -- IRN 2766
    OR izn_popusta_p IS NULL -- IRN 2766
  THEN
    -- Nedostaju vrijednosti obveznih parametara!
    pra_pka_zaj.vrati_poruku (-20086);
  END IF;

  IF datum_p > TRUNC (SYSDATE) THEN
    -- Datum je vei od tekueg!
    pra_pka_zaj.vrati_poruku (-20087);
  END IF;

  SELECT metcvor_sifra INTO metcvor_sifra_l
    FROM mzmp_ojr
   WHERE id = zmpojr_id_p;

  IF metcvor_sifra_l = pra_zmp_zaj.tekuci_cvor THEN
    pra_pos_pkakar.ponisti_pkakarrnk_t (
      pkakar_broj_p, gmpkas_id_p, god_poslovna_p_p, rbr_p_p, god_poslovna_p, rbr_p, datum_p, iznos_p,
      oznaka_p, nac_id_p, izn_rnk_p, izn_popusta_p, izn_popusta2_p,
      pkakarrnk_id_l, ozn_ponisten_l);
  ELSE
    cvor_centar_l := cvor_centar;
    naredba_l :=
      'BEGIN ' ||
      '  pra_pos_pkakar.ponisti_pkakarrnk_c<CVOR> ( ' ||
      '    :pkakar_broj_p, :metcvor_sifra_l, :gmpkas_id_p, :god_poslovna_p_p, :rbr_p_p, :god_poslovna_p, :rbr_p, :datum_p, :iznos_p, ' ||
      '    :oznaka_p, :nac_id_p, :izn_rnk_p, :izn_popusta_p, :izn_popusta2_p, ' ||
      '    :pkakarrnk_id_l, :ozn_ponisten_l); ' ||
      'END;';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_centar_l)
      USING pkakar_broj_p, metcvor_sifra_l, gmpkas_id_p, god_poslovna_p_p, rbr_p_p, god_poslovna_p, rbr_p, datum_p, iznos_p,
            oznaka_p, nac_id_p, izn_rnk_p, izn_popusta_p, izn_popusta2_p,
            OUT pkakarrnk_id_l, OUT ozn_ponisten_l;
  END IF;

  pkakarrnk_id_p := pkakarrnk_id_l;
  IF NVL (ozn_ponisten_l, 0) = -1 THEN
    -- poniten raun je upisan
    ozn_ponisten_p := ozn_ponisten_l;
  END IF;

END;
PROCEDURE PONISTI_PKAKARRNK_C
 (PKAKAR_BROJ_P IN tpka_kartice.broj%TYPE
 ,METCVOR_SIFRA_P IN smet_cvorovi.sifra%TYPE
 ,GMPKAS_ID_P IN tpka_kar_rnk.gmpkas_id%TYPE
 ,GOD_POSLOVNA_P_P IN tpka_kar_rnk.god_poslovna%TYPE
 ,RBR_P_P IN tpka_kar_rnk.rbr%TYPE
 ,GOD_POSLOVNA_P IN tpka_kar_rnk.god_poslovna%TYPE
 ,RBR_P IN tpka_kar_rnk.rbr%TYPE
 ,DATUM_P IN tpka_kar_rnk.datum%TYPE
 ,IZNOS_P IN tpka_kar_rnk.iznos%TYPE
 ,OZNAKA_P IN tpka_kar_rnk.oznaka%TYPE
 ,NAC_ID_P IN tpka_kar_rnk.nac_id%TYPE
 ,IZN_RNK_P IN tpka_kar_rnk.izn_rnk%TYPE
 ,IZN_POPUSTA_P IN tpka_kar_rnk.izn_popusta%TYPE
 ,IZN_POPUSTA2_P IN tpka_kar_rnk.izn_popusta%TYPE
 ,PKAKARRNK_ID_P OUT tpka_kar_rnk.id%TYPE
 ,OZN_PONISTEN_P OUT NUMBER
 )
 IS
--
  naredba_l VARCHAR2(2000);
BEGIN
  naredba_l :=
    'BEGIN ' ||
    '  pra_pos_pkakar.ponisti_pkakarrnk_t<CVOR> ( ' ||
    '    :pkakar_broj_p, :gmpkas_id_p, :god_poslovna_p_p, :rbr_p_p, :god_poslovna_p, :rbr_p, :datum_p, :iznos_p, ' ||
    '    :oznaka_p, :nac_id_p, :izn_rnk_p, :izn_popusta_p, :izn_popusta2_p, ' ||
    '    :pkakarrnk_id_p, :ozn_ponisten_p); ' ||
    'END;';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', '@' || metcvor_sifra_p)
    USING pkakar_broj_p, gmpkas_id_p, god_poslovna_p_p, rbr_p_p, god_poslovna_p, rbr_p, datum_p, iznos_p,
          oznaka_p, nac_id_p, izn_rnk_p, izn_popusta_p, izn_popusta2_p,
          OUT pkakarrnk_id_p, OUT ozn_ponisten_p;
END;
PROCEDURE PONISTI_PKAKARRNK_T
 (PKAKAR_BROJ_P IN tpka_kartice.broj%TYPE
 ,GMPKAS_ID_P IN tpka_kar_rnk.gmpkas_id%TYPE
 ,GOD_POSLOVNA_P_P IN tpka_kar_rnk.god_poslovna%TYPE
 ,RBR_P_P IN tpka_kar_rnk.rbr%TYPE
 ,GOD_POSLOVNA_P IN tpka_kar_rnk.god_poslovna%TYPE
 ,RBR_P IN tpka_kar_rnk.rbr%TYPE
 ,DATUM_P IN tpka_kar_rnk.datum%TYPE
 ,IZNOS_P IN tpka_kar_rnk.iznos%TYPE
 ,OZNAKA_P IN tpka_kar_rnk.oznaka%TYPE
 ,NAC_ID_P IN tpka_kar_rnk.nac_id%TYPE
 ,IZN_RNK_P IN tpka_kar_rnk.izn_rnk%TYPE
 ,IZN_POPUSTA_P IN tpka_kar_rnk.izn_popusta%TYPE
 ,IZN_POPUSTA2_P IN tpka_kar_rnk.izn_popusta%TYPE
 ,PKAKARRNK_ID_P OUT tpka_kar_rnk.id%TYPE
 ,OZN_PONISTEN_P OUT NUMBER
 )
 IS
-- ponitavanje POS rauna na serveru Tekui; puni redak tablice tpka_kar_rnk
  CURSOR pkakar_p_c IS
    SELECT pkakar.id AS id
      FROM (
           SELECT id
             FROM tpka_kartice
            WHERE UPPER (broj) = UPPER (pkakar_broj_p)
           UNION ALL -- IRN 3502
           SELECT pkakar_id AS id
             FROM tpka_kar_dod
            WHERE UPPER (broj) = UPPER (pkakar_broj_p)
           ) pkakar,
           tpka_kar_rnk pkakarrnk
     WHERE pkakarrnk.pkakar_id = pkakar.id
       AND pkakarrnk.gmpkas_id = gmpkas_id_p
       AND LPAD (pkakarrnk.rbr, 6, '0') = LPAD (rbr_p_p, 6, '0') -- IRN 2548; dodan LPAD
       AND pkakarrnk.god_poslovna = god_poslovna_p_p;
  pkakar_id_l tpka_kartice.id%TYPE;

  pkakarrnk_id_l tpka_kar_rnk.id%TYPE;
BEGIN

  OPEN pkakar_p_c;
  FETCH pkakar_p_c INTO pkakar_id_l;
  IF pkakar_p_c%NOTFOUND THEN
    CLOSE pkakar_p_c;
    RETURN;
  END IF;
  CLOSE pkakar_p_c;

  /*
  IRN 2548; dodana oznaka
  IRN 2548; dodan LPAD
  IRN 2766; dodani nac_id, izn_rnk, izn_popusta
  IRN 2781; dodan id
  IRN 4015; dodan izn_popusta2
  */

  pkakarrnk_id_l := pra_zmp_zaj.i3_sekvenca (NULL);

  INSERT INTO tpka_kar_rnk (
      id,
      pkakar_id, gmpkas_id, god_poslovna, rbr, datum, iznos,
      oznaka, nac_id, izn_rnk, izn_popusta, izn_popusta2)
    VALUES (
      pkakarrnk_id_l,
      pkakar_id_l, gmpkas_id_p, god_poslovna_p, LPAD (rbr_p, 6, '0'), datum_p, iznos_p,
      oznaka_p, nac_id_p, izn_rnk_p, izn_popusta_p, izn_popusta2_p);

  pkakarrnk_id_p := pkakarrnk_id_l;
  ozn_ponisten_p := -1;

END;
FUNCTION GMPKAS_TEKUCEG_CVORA
 (GMPKAS_ID_P IN mgmp_kase.id%TYPE
 )
 RETURN BOOLEAN
 IS
--
  br_redaka_l NUMBER;
BEGIN
  SELECT COUNT (gmpkas.id) INTO br_redaka_l
    FROM mgmp_kase gmpkas,
         mzmp_ojr zmpojr,
         s_vlasnik vla
   WHERE gmpkas.id = gmpkas_id_p
     AND gmpkas.zmpojr_id = zmpojr.id
     AND zmpojr.metcvor_sifra = vla.sifra_tekuceg_cvora;

  RETURN br_redaka_l > 0;
END;
FUNCTION CVOR_CENTAR
 RETURN VARCHAR2
 IS
--
  cvor_l VARCHAR2(21);
BEGIN
  SELECT DECODE (pra_zmp_zaj.centar, -1, '', '@' || pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0018')) -- IRN 2548
    INTO cvor_l
    FROM dual;

  RETURN cvor_l;
END;
FUNCTION CVOR_GMPKAS
 (GMPKAS_ID_P IN mgmp_kase.id%TYPE
 )
 RETURN VARCHAR2
 IS
--
  metcvor_sifra_l mzmp_ojr.metcvor_sifra%TYPE;
  cvor_gmpkas_l VARCHAR2(21) := '';
BEGIN
  SELECT zmpojr.metcvor_sifra INTO metcvor_sifra_l
    FROM mgmp_kase gmpkas,
         mzmp_ojr zmpojr
   WHERE gmpkas.id = gmpkas_id_p
     AND gmpkas.zmpojr_id = zmpojr.id;

  IF NOT metcvor_sifra_l = pra_zmp_zaj.tekuci_cvor THEN
    cvor_gmpkas_l := '@' || metcvor_sifra_l;
  END IF;

  RETURN cvor_gmpkas_l;
END;
PROCEDURE PONISTI_GANTNER_NARUKVICU
 (GMPKAS_ID_P IN mgmp_kase.id%TYPE
 ,PKAKAR_BROJ_P IN tpka_kartice.broj%TYPE
 ,KOL_KCKAR_P OUT NUMBER
 ,KOL_PKAKAR_P OUT NUMBER
 )
 IS
-- poniti Gantner narukvicu
  metcvor_sifra_l smet_cvorovi.sifra%TYPE;
  kol_kckar_l NUMBER := 0;
  kol_pkakar_l NUMBER := 0;
  cvor_centar_l VARCHAR2(21);
  naredba_l VARCHAR2(2000);
BEGIN

  IF gmpkas_id_p IS NULL
    OR pkakar_broj_p IS NULL
  THEN
    -- Nedostaju vrijednosti obveznih parametara!
    pra_pka_zaj.vrati_poruku (-20086);
  END IF;

  IF gmpkas_tekuceg_cvora (gmpkas_id_p) THEN
    pra_pos_pkakar.ponisti_gantner_narukvicu_t (pkakar_broj_p, kol_kckar_l, kol_pkakar_l);
  ELSE
    cvor_centar_l := cvor_centar;
    naredba_l :=
      'BEGIN ' ||
      '  pra_pos_pkakar.ponisti_gantner_narukvicu_c<CVOR> (:gmpkas_id_p, :pkakar_broj_p, :kol_kckar_l, :kol_pkakar_l); ' ||
      'END;';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_centar_l)
      USING gmpkas_id_p, pkakar_broj_p, OUT kol_kckar_l, OUT kol_pkakar_l;
  END IF;

  kol_kckar_p := kol_kckar_l;
  kol_pkakar_p := kol_pkakar_l;

END;
PROCEDURE PONISTI_GANTNER_NARUKVICU_C
 (GMPKAS_ID_P IN mgmp_kase.id%TYPE
 ,PKAKAR_BROJ_P IN TPKA_KARTICE.BROJ%TYPE
 ,KOL_KCKAR_P OUT NUMBER
 ,KOL_PKAKAR_P OUT NUMBER
 )
 IS
--
  naredba_l VARCHAR2(2000);
  cvor_gmpkas_l VARCHAR2(21) := cvor_gmpkas (gmpkas_id_p);
BEGIN
  naredba_l :=
    'BEGIN ' ||
    '  pra_pos_pkakar.ponisti_gantner_narukvicu_t<CVOR> (:pkakar_broj_p, :kol_kckar_p, :kol_pkakar_p); ' ||
    'END;';
  EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_gmpkas_l)
    USING pkakar_broj_p, OUT kol_kckar_p, OUT kol_pkakar_p;
END;
PROCEDURE PONISTI_GANTNER_NARUKVICU_T
 (PKAKAR_BROJ_P IN TPKA_KARTICE.BROJ%TYPE
 ,KOL_KCKAR_P OUT NUMBER
 ,KOL_PKAKAR_P OUT NUMBER
 )
 IS
-- poniti Gantner narukvicu na serveru Tekui
  kol_kckar_l NUMBER := 0;
  kol_pkakar_l NUMBER := 0;
BEGIN

  FOR c IN (
    SELECT kckar.id, kckar.gost_id, kckar.age_id, kckar.pkaadr_id
      FROM tkc_kartice kckar, mkc_jedinice kcjed
     WHERE kckar.broj = pkakar_broj_p
       AND kckar.oznaka = 'V'
       AND kckar.kcjed_id = kcjed.id
       AND pra_rec_kc.kcvs_sifra (kcjed.kcsus_id) = 'GATWRITER'
    )
  LOOP
    -- poniti Key Card
    UPDATE tkc_kartice SET oznaka = 'P' WHERE id = c.id;
    kol_kckar_l := kol_kckar_l + SQL%ROWCOUNT;
    -- poniti Pay Card
    UPDATE tpka_kartice
       SET oznaka = 'P'
     WHERE UPPER (broj) = UPPER (pkakar_broj_p) -- IRN 2999 dodan UPPER
       AND oznaka = 'V'
       AND NVL (gost_id, 0) = NVL (c.gost_id, 0)
       AND NVL (age_id, 0) = NVL (c.age_id, 0)
       AND NVL (pkaadr_id, 0) = NVL (c.pkaadr_id, 0);
    kol_pkakar_l := kol_pkakar_l + SQL%ROWCOUNT;
  END LOOP;

  kol_kckar_p := kol_kckar_l;
  kol_pkakar_p := kol_pkakar_l;

END;
FUNCTION GOST_BY_ID
 (METCVOR_SIFRA_P IN smet_cvorovi.sifra%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
--
  upit_l VARCHAR2(1000);
  curs_l sys_refcursor;
  cvor_centar_l VARCHAR2(21);
  naredba_l VARCHAR2(2000);
BEGIN
  IF metcvor_sifra_p = pra_zmp_zaj.tekuci_cvor THEN
    upit_l := gost_query (metcvor_sifra_p => NULL);
    OPEN curs_l FOR upit_l USING gost_id_p;
  ELSE
    cvor_centar_l := cvor_centar;
    naredba_l := 'BEGIN pra_pos_pkakar.gost_centar<CVOR> (:metcvor_sifra_p, :gost_id_p); END;';
    naredba_l := REPLACE (naredba_l, '<CVOR>', cvor_centar_l);
    EXECUTE IMMEDIATE naredba_l USING metcvor_sifra_p, gost_id_p;

    upit_l := REPLACE ('SELECT * FROM p_gosti<CVOR>', '<CVOR>', cvor_centar_l);
    OPEN curs_l FOR upit_l;
  END IF;

  RETURN curs_l;
END;
FUNCTION GOST_QUERY
 (METCVOR_SIFRA_P IN smet_cvorovi.sifra%TYPE
 )
 RETURN VARCHAR2
 IS
--
  cvor_l VARCHAR2(21);
  upit_l VARCHAR2(1000);
BEGIN
  IF metcvor_sifra_p IS NOT NULL THEN
    cvor_l := '@' || metcvor_sifra_p;
  END IF;

  -- IRN 2781; dodan alias imeprezime
  -- IRN 2798; promijenjeni svi aliasi
  -- IRN 2819; dodan pos_discount_rate
  upit_l :=
    'SELECT gost.id AS guest_id, ' ||
    '       gost.ime || '' '' || gost.prezime AS guest_name, ' ||
    '       gost.ozn_platitelj AS payer_indicator, ' ||
    '       sj.id AS unit_id, ' ||
    '       sj.broj AS unit_code, ' ||
    '       SUBSTR (sj.opis, 1, 20) AS unit_description, ' ||
    '       so.id AS property_id, ' ||
    '       so.sifra AS property_code, ' ||
    '       so.naziv AS property_name, ' ||
    '       NULL AS pos_discount_rate ' ||
    '  FROM t_gosti<CVOR> gost, ' ||
    '       m_sj<CVOR> sj, ' ||
    '       m_so<CVOR> so ' ||
    ' WHERE gost.id = :gost_id_p ' ||
    '   AND gost.sj_id = sj.id ' ||
    '   AND sj.so_id = so.id ';

  RETURN REPLACE (upit_l, '<CVOR>', cvor_l);
END;
PROCEDURE GOST_CENTAR
 (METCVOR_SIFRA_P IN smet_cvorovi.sifra%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE
 )
 IS
--
  upit_l VARCHAR2(1000);
  naredba_l VARCHAR2(2000);
BEGIN

  upit_l := gost_query (metcvor_sifra_p);

  naredba_l :=
    ' BEGIN ' ||
    '   DELETE FROM p_gosti; ' ||
    '   INSERT INTO p_gosti ' || upit_l || ';' ||
    ' END;';

  EXECUTE IMMEDIATE naredba_l USING gost_id_p;
END;
FUNCTION PKAADR_BY_ID
 (METCVOR_SIFRA_P IN smet_cvorovi.sifra%TYPE
 ,PKAADR_ID_P IN mpka_adrese.id%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
--
  upit_l VARCHAR2(1000);
  curs_l sys_refcursor;
  cvor_centar_l VARCHAR2(21);
  naredba_l VARCHAR2(2000);
BEGIN
  IF metcvor_sifra_p = pra_zmp_zaj.tekuci_cvor THEN
    upit_l := pkaadr_query (metcvor_sifra_p => NULL);
    OPEN curs_l FOR upit_l USING pkaadr_id_p;
  ELSE
    cvor_centar_l := cvor_centar;
    naredba_l := 'BEGIN pra_pos_pkakar.pkaadr_centar<CVOR> (:metcvor_sifra_p, :pkaadr_id_p); END;';
    naredba_l := REPLACE (naredba_l, '<CVOR>', cvor_centar_l);
    EXECUTE IMMEDIATE naredba_l USING metcvor_sifra_p, pkaadr_id_p;

    upit_l := REPLACE ('SELECT * FROM p_adrese<CVOR>', '<CVOR>', cvor_centar_l);
    OPEN curs_l FOR upit_l;
  END IF;

  RETURN curs_l;
END;
FUNCTION PKAADR_QUERY
 (METCVOR_SIFRA_P IN smet_cvorovi.sifra%TYPE
 )
 RETURN VARCHAR2
 IS
--
-- IRN 2882; pos_broj
  cvor_l VARCHAR2(21);
  upit_l VARCHAR2(2000);
BEGIN
  IF metcvor_sifra_p IS NOT NULL THEN
    cvor_l := '@' || metcvor_sifra_p;
  END IF;

  upit_l :=
    'SELECT pkaadr.id, ' ||
    '       pkaadr.rbr, ' ||
    '       TRIM (DECODE (pkaadr.naz_poduzeca, NULL, pkaadr.ime || '' '' || pkaadr.prezime, ' ||
    '         DECODE (pkaadr.prezime, NULL, pkaadr.naz_poduzeca, ' ||
    '           pkaadr.naz_poduzeca || ''; '' || pkaadr.ime || '' '' || pkaadr.prezime))) naziv, ' ||
    '       pkaadr.naz_ulice, ' ||
    '       pos.broj pos_broj, ' ||
    '       NVL (pkaadr.naz_mjesta, pos.naziv) naz_mjesta, ' ||
    '       DECODE (reg.ozn_adrese, 0, NULL, NVL (pkaadr.naz_regije, reg.naziv)) naz_regije, ' ||
    '       DECODE (zem.sifra_2a, pra_zmp_zaj.vrijednost_parametra (''0002''), NULL, zem.naziv) naz_zemlje, ' ||
    '       pkaadr.oib oib ' ||
    '  FROM mpka_adrese<CVOR> pkaadr, m_poste<CVOR> pos, m_regije<CVOR> reg, s_zemlje<CVOR> zem ' ||
    ' WHERE pkaadr.id = :pkaadr_id_p ' ||
    '   AND pkaadr.pos_id = pos.id (+) AND pkaadr.reg_id = reg.id (+) AND pkaadr.zem_id = zem.id (+)';

  RETURN REPLACE (upit_l, '<CVOR>', cvor_l);
END;
PROCEDURE PKAADR_CENTAR
 (METCVOR_SIFRA_P IN smet_cvorovi.sifra%TYPE
 ,PKAADR_ID_P IN mpka_adrese.id%TYPE
 )
 IS
--
  upit_l VARCHAR2(1000);
  naredba_l VARCHAR2(2000);
BEGIN

  upit_l := pkaadr_query (metcvor_sifra_p);

  naredba_l :=
    ' BEGIN ' ||
    '   DELETE FROM p_adrese; ' ||
    '   INSERT INTO p_adrese ' || upit_l || ';' ||
    ' END;';

  EXECUTE IMMEDIATE naredba_l USING pkaadr_id_p;
END;
FUNCTION AGE_BY_ID
 (AGE_ID_P IN m_agencije.id%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
--
-- IRN 2882; pos_broj
  curs_l sys_refcursor;
BEGIN
  OPEN curs_l FOR
    SELECT age.id, age.sifra, age.naziv,
           age.naz_ulice,
           pos.broj pos_broj,
           pos.naziv naz_mjesta,
           DECODE (reg.ozn_adrese, 0, NULL, reg.naziv) naz_regije,
           DECODE (zem.sifra_2a, pra_zmp_zaj.vrijednost_parametra ('0002'), NULL, zem.naziv) naz_zemlje,
           age.oib oib
      FROM m_agencije age,
           m_poste pos,
           m_regije reg,
           s_zemlje zem
     WHERE age.id = age_id_p
       AND age.pos_id = pos.id (+)
       AND age.reg_id = reg.id (+)
       AND age.zem_id = zem.id (+);
  RETURN curs_l;
END;
FUNCTION NFC_BROJ
 (UUID_P IN VARCHAR2
 ,KOR_ID_P IN NUMBER
 )
 RETURN tpka_kartice.broj%TYPE
 IS
-- IRN 2716; broj NFC kartice
BEGIN
  IF uuid_p IS NULL OR kor_id_p IS NULL THEN
    RETURN (TO_CHAR (NULL));
  END IF;
  RETURN (utl_raw.cast_to_raw (dbms_obfuscation_toolkit.md5 (input_string => uuid_p || kor_id_p)));
END;
PROCEDURE BRISI_PKAKARRNK
 (PKAKARRNK_ID_P IN tpka_kar_rnk.id%TYPE
 ,ROWCOUNT_P OUT NUMBER
 )
 IS
-- IRN 2781
-- ORDS pra_pos_pkakar racuni/{racun_id} [DELETE]
-- kompenzacijska procedura za puni_pkakarrnk i ponisti_pkakarrnk
BEGIN

  rowcount_p := 0;

  IF pkakarrnk_id_p IS NULL THEN
    RETURN;
  END IF;

  DELETE FROM tpka_kar_rnk WHERE id = pkakarrnk_id_p;
  rowcount_p := SQL%ROWCOUNT;

EXCEPTION
  WHEN OTHERS THEN
    pra_pka_iud.puni_pkapro (
      zmpsus_sifra_p  => 'PKA',
      zmpvpro_sifra_p => '0003', -- Pay Card sustav
      pkapro_opis_p   => SUBSTR ('pra_pos_pkakar.brisi_pkakarrnk: pkakarrnk_id_p ' || pkakarrnk_id_p || ', rowcount_p ' || rowcount_p || ' ' || SQLCODE || ' ' || SQLERRM, 1, 2000),
      ozn_vaznosti_p  => 0);
    RAISE;
END;

END PRA_POS_PKAKAR;
/
SHOW ERROR

