PROMPT Creating Package Body 'PRA_POS_PKA'
CREATE OR REPLACE PACKAGE BODY PRA_POS_PKA IS
-- Designer Private Declaration

  pkapro_opis_m lpka_promjene.opis%TYPE; -- IRN 3964

-- KRAJ Designer Private Declaration

FUNCTION UPIT
 (OZN_VUPITA_P IN VARCHAR2
 )
 RETURN VARCHAR2;
FUNCTION CVOR_CENTAR
 RETURN VARCHAR2;
FUNCTION ZMPOJR_TEKUCEG_CVORA
 (ZMPOJR_ID_P IN mzmp_ojr.id%TYPE
 )
 RETURN BOOLEAN;
FUNCTION SO_TEKUCEG_CVORA
 (SO_ID_P IN m_so.id%TYPE
 )
 RETURN BOOLEAN;
FUNCTION ZMPOJR_CVOR
 (ZMPOJR_ID_P IN mzmp_ojr.id%TYPE
 )
 RETURN VARCHAR2;
FUNCTION SO_CVOR
 (SO_ID_P IN m_so.id%TYPE
 )
 RETURN VARCHAR2;
FUNCTION ADRESE_QUERY
 (ZMPOJR_ID_P IN mzmp_ojr.id%TYPE
 )
 RETURN VARCHAR2;
FUNCTION GOSTI_QUERY
 (SO_ID_P IN m_so.id%TYPE
 )
 RETURN VARCHAR2;
FUNCTION SJ_QUERY
 (SO_ID_P IN m_so.id%TYPE
 )
 RETURN VARCHAR2;
FUNCTION SJ_ZA_BROJ_QUERY
 (SO_ID_P IN m_so.id%TYPE
 )
 RETURN VARCHAR2;


FUNCTION UPIT
 (OZN_VUPITA_P IN VARCHAR2
 )
 RETURN VARCHAR2
 IS
BEGIN
  IF ozn_vupita_p = 'ADR' THEN
    -- IRN 2781; dodan filter_p
    -- IRN 2882; pos_broj
    RETURN
    'SELECT adr.id, ' ||
    '       adr.rbr, ' ||
    '       TRIM (DECODE (adr.naz_poduzeca, NULL, adr.ime || '' '' || adr.prezime, ' ||
    '         DECODE (adr.prezime, NULL, adr.naz_poduzeca, ' ||
    '           adr.naz_poduzeca || ''; '' || adr.ime || '' '' || adr.prezime))) naziv, ' ||
    '       adr.naz_ulice, ' ||
    '       pos.broj pos_broj, ' ||
    '       NVL (adr.naz_mjesta, pos.naziv) naz_mjesta, ' ||
    '       DECODE (reg.ozn_adrese, 0, NULL, NVL (adr.naz_regije, reg.naziv)) naz_regije, ' ||
    '       DECODE (zem.sifra_2a, pra_zmp_zaj.vrijednost_parametra (''0002''), NULL, zem.naziv) naz_zemlje, ' ||
    '       adr.oib oib ' ||
    '  FROM mpka_adrese<CVOR> adr, m_poste<CVOR> pos, m_regije<CVOR> reg, s_zemlje<CVOR> zem ' ||
    ' WHERE adr.pos_id = pos.id (+) AND adr.reg_id = reg.id (+) AND adr.zem_id = zem.id (+) ' ||
    '   AND NVL (:datum_p, TRUNC (SYSDATE)) < NVL (adr.dat_ponisten, TO_DATE (''31.12.9999'', ''DD.MM.RRRR'')) ' ||
    '   AND (:filter_p IS NULL ' ||
    '        OR UPPER (adr.rbr) LIKE ''%'' || UPPER (:filter_p) || ''%'' ' ||
    '        OR ' ||
    '          UPPER (DECODE (adr.naz_poduzeca, NULL, adr.ime || '' '' || adr.prezime, ' ||
    '            DECODE (adr.prezime, NULL, adr.naz_poduzeca, ' ||
    '              adr.naz_poduzeca || ''; '' || adr.ime || '' '' || adr.prezime))) LIKE ''%'' || UPPER (:filter_p) || ''%'' ' ||
    '       )' ||
    ' ORDER BY 3';
  ELSIF ozn_vupita_p = 'GOST' THEN
    -- IRN 2402; AND gost.dat_odlaska - 1 - NVL (gost.ozn_rnk, :odlazak_na_dan_l)
    -- IRN 2781; dodan TO_CHAR za id i izmijenjeni aliasi; dodan filter_p
    -- IRN 2798; brisan TO_CHAR
    -- IRN 2819; dodan pos_discount_rate
    RETURN
    'SELECT gost.id AS guest_id, ' ||
    '       gost.ime || '' '' || gost.prezime AS guest_name, ' ||
    '       gost.ozn_platitelj AS payer_indicator, ' ||
    '       sj.id AS unit_id, ' ||
    '       sj.broj AS unit_code, ' ||
    '       SUBSTR (sj.opis, 1, 20) AS unit_description, ' ||
    '       so.id AS property_id, ' ||
    '       so.sifra AS property_code, ' ||
    '       so.naziv AS property_name, ' ||
    '       pra_pos_pka.pos_discount_rate<CVOR> (gost.id) AS pos_discount_rate ' ||
    '  FROM t_gosti<CVOR> gost, ' ||
    '       m_sj<CVOR> sj, ' ||
    '       m_so<CVOR> so ' ||
    ' WHERE gost.sj_id = sj.id ' ||
    '   AND gost.ozn_prisutnosti = ''P'' ' ||
    '   AND sj.so_id = so.id ' ||
    '   AND so.id = :so_id_p ' ||
    '   AND :datum_p BETWEEN gost.dat_dolaska AND gost.dat_odlaska - 1 - NVL (gost.ozn_rnk, :odlazak_na_dan_l) ' ||
    '   AND NVL (gost.ozn_rnk, -1) = -1 ' ||
    '   AND (:filter_p IS NULL ' ||
    '        OR UPPER (sj.broj) LIKE ''%'' || UPPER (:filter_p) || ''%'' ' ||
    '        OR UPPER (gost.ime || '' '' || gost.prezime) LIKE ''%'' || UPPER (:filter_p) || ''%'' ' ||
    '       ) ' ||
    ' ORDER BY ' ||
    '       sj.broj, gost.ozn_platitelj, gost.rbr';
  ELSIF ozn_vupita_p = 'SJ' THEN
    RETURN
    'SELECT sj.id AS unit_id, ' ||
    '       sj.broj AS unit_code, ' ||
    '       SUBSTR (sj.opis, 1, 20) AS unit_description, ' ||
    '       so.id AS property_id, ' ||
    '       so.sifra AS property_code, ' ||
    '       so.naziv AS property_name ' ||
    '  FROM m_sj<CVOR> sj, ' ||
    '       m_so<CVOR> so ' ||
    ' WHERE sj.so_id = so.id ' ||
    '   AND so.id = :so_id_p ' ||
    '   AND sj.id IN ( ' ||
    '       SELECT DISTINCT sj_id ' ||
    '         FROM t_gosti<CVOR> ' ||
    '        WHERE ozn_prisutnosti = ''P'' ' ||
    '          AND :datum_p BETWEEN dat_dolaska AND dat_odlaska - 1 - NVL (ozn_rnk, :odlazak_na_dan_l) ' || -- IRN 2402
    '          AND NVL (ozn_rnk, -1) = -1) ' ||
    ' ORDER BY sj.broj';
  ELSIF ozn_vupita_p = 'SJBR' THEN
    RETURN
    'SELECT sj.id AS unit_id, ' ||
    '       sj.broj AS unit_code, ' ||
    '       SUBSTR (sj.opis, 1, 20) AS unit_description, ' ||
    '       so.id AS property_id, ' ||
    '       so.sifra AS property_code, ' ||
    '       so.naziv AS property_name ' ||
    '  FROM m_sj<CVOR> sj, ' ||
    '       m_so<CVOR> so ' ||
    ' WHERE sj.so_id = so.id ' ||
    '   AND so.id = :so_id_p ' ||
    '   AND sj.broj = :broj_l ' ||
    '   AND sj.id IN ( ' ||
    '       SELECT DISTINCT sj_id ' ||
    '         FROM t_gosti<CVOR> ' ||
    '        WHERE ozn_prisutnosti = ''P'' ' ||
    '          AND NVL (ozn_rnk, -1) = -1)';
  ELSE
    RETURN '';
  END IF;
END;
FUNCTION CVOR_CENTAR
 RETURN VARCHAR2
 IS
--
  centar_l VARCHAR2(21);
BEGIN
  SELECT DECODE (pra_zmp_zaj.centar, -1, '', '@' || pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0018'))
    INTO centar_l
    FROM dual;

  RETURN centar_l;
END;
FUNCTION ZMPOJR_TEKUCEG_CVORA
 (ZMPOJR_ID_P IN mzmp_ojr.id%TYPE
 )
 RETURN BOOLEAN
 IS
--
  br_redaka_l NUMBER;
BEGIN
  SELECT COUNT (zmpojr.id) INTO br_redaka_l
    FROM mzmp_ojr zmpojr, s_vlasnik vla
   WHERE zmpojr.id = zmpojr_id_p
     AND zmpojr.metcvor_sifra = vla.sifra_tekuceg_cvora;

  RETURN br_redaka_l > 0;
END;
FUNCTION SO_TEKUCEG_CVORA
 (SO_ID_P IN m_so.id%TYPE
 )
 RETURN BOOLEAN
 IS
--
  br_redaka_l NUMBER;
BEGIN
  SELECT COUNT (so.id) INTO br_redaka_l
    FROM m_so so, s_vlasnik vla
   WHERE so.id = so_id_p
     AND vla.sifra_tekuceg_cvora = so.metcvor_sifra;

  RETURN br_redaka_l > 0;
END;
FUNCTION ZMPOJR_CVOR
 (ZMPOJR_ID_P IN mzmp_ojr.id%TYPE
 )
 RETURN VARCHAR2
 IS
--
  tekuci_cvor_l s_vlasnik.sifra_tekuceg_cvora%TYPE;
  cvor_l        mzmp_ojr.metcvor_sifra%TYPE;
  target_cvor_l VARCHAR2(21) := '';
BEGIN
  SELECT sifra_tekuceg_cvora
    INTO tekuci_cvor_l
    FROM s_vlasnik;

  SELECT metcvor_sifra
    INTO cvor_l
    FROM mzmp_ojr
   WHERE id = zmpojr_id_p;

  IF NOT cvor_l = tekuci_cvor_l THEN
    target_cvor_l := '@' || cvor_l;
  END IF;

  RETURN target_cvor_l;
END;
FUNCTION SO_CVOR
 (SO_ID_P IN m_so.id%TYPE
 )
 RETURN VARCHAR2
 IS
--
  tekuci_cvor_l s_vlasnik.sifra_tekuceg_cvora%TYPE;
  cvor_l        m_so.metcvor_sifra%TYPE;
  target_cvor_l VARCHAR2(21) := '';
BEGIN
  SELECT sifra_tekuceg_cvora
    INTO tekuci_cvor_l
    FROM s_vlasnik;

  SELECT metcvor_sifra
    INTO cvor_l
    FROM m_so
   WHERE id = so_id_p;

  IF NOT cvor_l = tekuci_cvor_l THEN
    target_cvor_l := '@' || cvor_l;
  END IF;

  RETURN target_cvor_l;
END;
FUNCTION ADRESE_QUERY
 (ZMPOJR_ID_P IN mzmp_ojr.id%TYPE
 )
 RETURN VARCHAR2
 IS
--
  cvor_l VARCHAR2(21) := zmpojr_cvor (zmpojr_id_p);
BEGIN
  RETURN REPLACE (upit ('ADR'), '<CVOR>', cvor_l);
END;
FUNCTION GOSTI_QUERY
 (SO_ID_P IN m_so.id%TYPE
 )
 RETURN VARCHAR2
 IS
--
  cvor_l VARCHAR2(21) := so_cvor (so_id_p);
BEGIN
  RETURN REPLACE (upit ('GOST'), '<CVOR>', cvor_l);
END;
FUNCTION SJ_QUERY
 (SO_ID_P IN m_so.id%TYPE
 )
 RETURN VARCHAR2
 IS
--
  cvor_l VARCHAR2(21) := so_cvor (so_id_p);
BEGIN
  RETURN REPLACE (upit ('SJ'), '<CVOR>', cvor_l);
END;
FUNCTION SJ_ZA_BROJ_QUERY
 (SO_ID_P IN m_so.id%TYPE
 )
 RETURN VARCHAR2
 IS
--
  cvor_l VARCHAR2(21) := so_cvor (so_id_p);
BEGIN
  RETURN REPLACE (upit ('SJBR'), '<CVOR>', cvor_l);
END;
PROCEDURE ADRESE_CENTAR
 (ZMPOJR_ID_P IN mzmp_ojr.id%TYPE
 ,DATUM_P IN mpka_adrese.dat_ponisten%TYPE := TRUNC (SYSDATE)
 ,FILTER_P IN VARCHAR2 := NULL
 )
 IS
--
-- IRN 2781; dodan filter_p
  upit_l    VARCHAR2(32000);
  command_l VARCHAR2(32000);
BEGIN
  upit_l := adrese_query (zmpojr_id_p);

  command_l :=
    ' BEGIN ' ||
    '   DELETE FROM p_adrese; ' ||
    '   INSERT INTO p_adrese ' || upit_l || ';' ||
    ' END;';

  EXECUTE IMMEDIATE command_l USING datum_p, filter_p;
END;
FUNCTION ADRESE
 (ZMPOJR_ID_P IN mzmp_ojr.id%TYPE
 ,DATUM_P IN mpka_adrese.dat_ponisten%TYPE := TRUNC (SYSDATE)
 ,FILTER_P IN VARCHAR2 := NULL
 )
 RETURN SYS_REFCURSOR
 IS
-- adrese
-- IRN 2781; dodan filter_p
  cvor_l    VARCHAR2(21) := zmpojr_cvor (zmpojr_id_p);
  centar_l  VARCHAR2(21) := cvor_centar;
  upit_l    VARCHAR2(32000);
  curs_l    sys_refcursor;
  command_l VARCHAR2(1000);
BEGIN
  IF pra_zmp_zaj.centar = -1 OR NVL (cvor_l, centar_l) = centar_l THEN
    upit_l := adrese_query (zmpojr_id_p);
    OPEN curs_l FOR upit_l USING datum_p, filter_p, filter_p, filter_p;
  ELSE
    command_l := 'BEGIN pra_pos_pka.adrese_centar<CVOR> (:zmpojr_id_p, :datum_p, :filter_p); END;';
    command_l := REPLACE (command_l, '<CVOR>', centar_l);
    EXECUTE IMMEDIATE command_l USING zmpojr_id_p, datum_p, filter_p;

    upit_l := REPLACE ('SELECT * FROM p_adrese<CVOR>', '<CVOR>', centar_l);
    OPEN curs_l FOR upit_l;
  END IF;

  RETURN curs_l;
END;
FUNCTION ARANZMANI
 (DATUM_P IN mrec_aranzmani.dat_valjan%TYPE := TRUNC (SYSDATE)
 )
 RETURN SYS_REFCURSOR
 IS
--
  br_redaka_l NUMBER;
  curs_l      sys_refcursor;
  centar_l    VARCHAR2(21);
  upit_l      VARCHAR2(32000);
BEGIN
  SELECT COUNT (1) INTO br_redaka_l
    FROM smet_instalacije
   WHERE metapl_sifra = 'REC'
     AND metcvor_sifra = pra_zmp_zaj.tekuci_cvor;

  IF br_redaka_l > 0 THEN
    -- postoji instalacija aplikacije REC na tekuem voru
    OPEN curs_l FOR
      SELECT id, sifra, naziv
        FROM mrec_aranzmani
       WHERE ozn_rnk = -1
         AND NVL (datum_p, TRUNC (SYSDATE)) BETWEEN dat_valjan AND (NVL (dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) - 1)
       ORDER BY sifra;
  ELSE
    centar_l := cvor_centar;
    upit_l :=
      'SELECT id, sifra, naziv ' ||
      '  FROM mrec_aranzmani<CVOR> ' ||
      ' WHERE ozn_rnk = -1 ' ||
      '   AND NVL (:datum_p, TRUNC (SYSDATE)) BETWEEN dat_valjan AND (NVL (dat_ponisten, TO_DATE (''31.12.9999'', ''DD.MM.RRRR'')) - 1) ' ||
      ' ORDER BY sifra';
    upit_l := REPLACE (upit_l, '<CVOR>', centar_l);
    OPEN curs_l FOR upit_l USING datum_p;
  END IF;

  RETURN curs_l;
END;
PROCEDURE GOSTI_CENTAR
 (SO_ID_P IN m_so.id%TYPE
 ,DATUM_P IN tpka_rnkasa.datum%TYPE
 ,GMPKAS_ID_P IN mgmp_kase.id%TYPE
 ,FILTER_P IN VARCHAR2 := NULL
 )
 IS
--
  upit_l    VARCHAR2(32000);
  command_l VARCHAR2(32000);
  odlazak_na_dan_l NUMBER := 0;
BEGIN
  SELECT ozn_knjizenja INTO odlazak_na_dan_l
    FROM mgmp_kase
   WHERE id = gmpkas_id_p;

  upit_l := gosti_query (so_id_p);

  command_l :=
    ' BEGIN ' ||
    '   DELETE FROM p_gosti; ' ||
    '   INSERT INTO p_gosti ' || upit_l || ';' ||
    ' END;';

  -- IRN 2781; dodan filter_p
  EXECUTE IMMEDIATE command_l USING so_id_p, datum_p, odlazak_na_dan_l, filter_p;
END;
FUNCTION GOSTI
 (SO_ID_P IN m_so.id%TYPE
 ,DATUM_P IN tpka_rnkasa.datum%TYPE
 ,GMPKAS_ID_P IN mgmp_kase.id%TYPE
 ,FILTER_P IN VARCHAR2 := NULL
 )
 RETURN SYS_REFCURSOR
 IS
--
  centar_l  VARCHAR2(21) := cvor_centar;
  cvor_l    VARCHAR2(21) := so_cvor (so_id_p);
  odlazak_na_dan_l NUMBER := 0;
  upit_l    VARCHAR2(32000);
  curs_l    sys_refcursor;
  command_l VARCHAR2(1000);
BEGIN
  IF pra_zmp_zaj.centar = -1 OR NVL (cvor_l, centar_l) = centar_l THEN

    SELECT ozn_knjizenja INTO odlazak_na_dan_l
      FROM mgmp_kase
     WHERE id = gmpkas_id_p;

    upit_l := gosti_query (so_id_p);
    -- IRN 2781; dodan filter_p
    OPEN curs_l FOR upit_l USING so_id_p, datum_p, odlazak_na_dan_l, filter_p, filter_p, filter_p;

  ELSE

    -- IRN 2781; dodan filter_p
    command_l := 'BEGIN pra_pos_pka.gosti_centar<CVOR> (:so_id_p, :datum_p, :gmpkas_id_p, :filter_p); END;';
    command_l := REPLACE (command_l, '<CVOR>', centar_l);
    EXECUTE IMMEDIATE command_l USING so_id_p, datum_p, gmpkas_id_p, filter_p;

    -- IRN 2781; dodan TO_CHAR za ID i aliasi
    -- IRN 2798; brisan TO_CHAR jer nije potreban, brisani aliasi jer su promijenjeni nazivi stupaca tablice p_gosti
    upit_l := REPLACE ('SELECT * FROM p_gosti<CVOR>', '<CVOR>', centar_l);

    OPEN curs_l FOR upit_l;

  END IF;

  RETURN curs_l;
END;
PROCEDURE SJ_CENTAR
 (SO_ID_P IN m_so.id%TYPE
 ,DATUM_P IN tpka_rnkasa.datum%TYPE
 ,GMPKAS_ID_P IN mgmp_kase.id%TYPE
 )
 IS
--
  upit_l    VARCHAR2(32000);
  command_l VARCHAR2(32000);
  odlazak_na_dan_l NUMBER := 0;
BEGIN
  SELECT ozn_knjizenja INTO odlazak_na_dan_l
    FROM mgmp_kase
   WHERE id = gmpkas_id_p;

  upit_l := sj_query (so_id_p);

  command_l :=
    ' BEGIN ' ||
    '   DELETE FROM p_sj; ' ||
    '   INSERT INTO p_sj ' || upit_l || ';' ||
    ' END;';

  EXECUTE IMMEDIATE command_l USING so_id_p, datum_p, odlazak_na_dan_l;
END;
FUNCTION SJ
 (SO_ID_P IN m_so.id%TYPE
 ,DATUM_P IN tpka_rnkasa.datum%TYPE
 ,GMPKAS_ID_P IN mgmp_kase.id%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
--
  upit_l    VARCHAR2(32000);
  command_l VARCHAR2(1000);
  curs_l    sys_refcursor;
  centar_l  VARCHAR2(21) := cvor_centar;
  cvor_l    VARCHAR2(21) := so_cvor (so_id_p);
  odlazak_na_dan_l NUMBER := 0;
BEGIN
  IF pra_zmp_zaj.centar = -1 OR NVL (cvor_l, centar_l) = centar_l THEN
    SELECT ozn_knjizenja INTO odlazak_na_dan_l
      FROM mgmp_kase
     WHERE id = gmpkas_id_p;

    upit_l := sj_query (so_id_p);
    OPEN curs_l FOR upit_l USING so_id_p, datum_p, odlazak_na_dan_l;
  ELSE
    command_l := 'BEGIN pra_pos_pka.sj_centar<CVOR> (:so_id_p, :datum_p, :gmpkas_id_p); END;';
    command_l := REPLACE (command_l, '<CVOR>', centar_l);
    EXECUTE IMMEDIATE command_l USING so_id_p, datum_p, gmpkas_id_p;

    -- IRN 2798; promijenjeni nazivi stupaca tablice p_sj
    upit_l := REPLACE ('SELECT * FROM p_sj<CVOR>', '<CVOR>', centar_l);
    OPEN curs_l FOR upit_l;
  END IF;

  RETURN curs_l;
END;
PROCEDURE SJ_ZA_BROJ_CENTAR
 (SO_ID_P IN m_so.id%TYPE
 ,BROJ_P IN m_sj.broj%TYPE
 )
 IS
--
  upit_l    VARCHAR2(32000);
  command_l VARCHAR2(32000);
  broj_l m_sj.broj%TYPE;
BEGIN
  broj_l := broj_p;
  pra_rec_zaj.oblikuj_podatak ('BROJ', 'M_SJ', broj_l);

  upit_l := sj_za_broj_query (so_id_p);

  command_l :=
    ' BEGIN ' ||
    '   DELETE FROM p_sj; ' ||
    '   INSERT INTO p_sj ' || upit_l || ';' ||
    ' END;';

  EXECUTE IMMEDIATE command_l USING so_id_p, broj_l;
END;
FUNCTION SJ_ZA_BROJ
 (SO_ID_P IN m_so.id%TYPE
 ,BROJ_P IN m_sj.broj%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
--
  upit_l    VARCHAR2(32000);
  command_l VARCHAR2(1000);
  curs_l    sys_refcursor;
  centar_l  VARCHAR2(21) := cvor_centar;
  cvor_l    VARCHAR2(21) := so_cvor (so_id_p);
  broj_l    m_sj.broj%TYPE;
BEGIN
  IF pra_zmp_zaj.centar = -1 OR NVL (cvor_l, centar_l) = centar_l THEN
    broj_l := broj_p;
    pra_rec_zaj.oblikuj_podatak ('BROJ', 'M_SJ', broj_l);

    upit_l := sj_za_broj_query (so_id_p);
    OPEN curs_l FOR upit_l USING so_id_p, broj_l;
  ELSE
    command_l := 'BEGIN pra_pos_pka.sj_za_broj_centar<CVOR> (:so_id_p, :broj_p); END;';
    command_l := REPLACE (command_l, '<CVOR>', centar_l);
    EXECUTE IMMEDIATE command_l USING so_id_p, broj_p;

    -- IRN 2798; promijenjeni nazivi stupaca tablice p_sj
    upit_l := REPLACE ('SELECT * FROM p_sj<CVOR>', '<CVOR>', centar_l);
    OPEN curs_l FOR upit_l;
  END IF;

  RETURN curs_l;
END;
FUNCTION SO
 RETURN SYS_REFCURSOR
 IS
--
  br_redaka_l NUMBER;
  curs_l      sys_refcursor;
  centar_l    VARCHAR2(21);
  upit_l      VARCHAR2(32000);
BEGIN
  SELECT COUNT (1) INTO br_redaka_l
    FROM smet_instalacije
   WHERE metapl_sifra = 'REC'
     AND metcvor_sifra = pra_zmp_zaj.tekuci_cvor;

  -- IRN 2798; dodani aliasi
  IF br_redaka_l > 0 THEN
    -- postoji instalacija aplikacije REC na tekuem voru
    OPEN curs_l FOR
      SELECT id AS property_id, sifra AS property_code, naziv AS property_name
        FROM m_so
       WHERE TRUNC (SYSDATE) BETWEEN dat_valjan AND (NVL (dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) - 1)
       ORDER BY sifra;
  ELSE
    centar_l := cvor_centar;
    upit_l :=
      'SELECT id AS property_id, sifra AS property_code, naziv AS property_name ' ||
      '  FROM m_so<CVOR> ' ||
      ' WHERE TRUNC (SYSDATE) BETWEEN dat_valjan AND (NVL (dat_ponisten, TO_DATE (''31.12.9999'', ''DD.MM.RRRR'')) - 1) ' ||
      ' ORDER BY sifra';
    upit_l := REPLACE (upit_l, '<CVOR>', centar_l);
    OPEN curs_l FOR upit_l;
  END IF;

  RETURN curs_l;
END;
FUNCTION ZMPOJR
 (DATUM_P IN mzmp_ojr.dat_valjan%TYPE := TRUNC (SYSDATE)
 )
 RETURN SYS_REFCURSOR
 IS
--
  curs_l sys_refcursor;
BEGIN
  OPEN curs_l FOR
    SELECT oj.id, oj.sifra, oj.naziv
      FROM m_oj oj,
           mzmp_ojr zmpojr
     WHERE oj.id = zmpojr.id
       AND NVL (datum_p, TRUNC (SYSDATE)) BETWEEN zmpojr.dat_valjan AND (NVL (zmpojr.dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) - 1)
       AND zmpojr.metcvor_sifra IS NOT NULL
     ORDER BY oj.sifra;

  RETURN curs_l;
END;
FUNCTION SO_OJR_ID
 (SO_ID_P IN m_so.id%TYPE
 )
 RETURN m_so.ojr_id%TYPE
 IS
--
  ojr_id_l m_so.ojr_id%TYPE;
BEGIN
  SELECT ojr_id INTO ojr_id_l
    FROM m_so
   WHERE id = so_id_p;

  RETURN ojr_id_l;
END;
FUNCTION AGENCIJE
 (FILTER_P IN VARCHAR2 := NULL
 )
 RETURN SYS_REFCURSOR
 IS
--
-- IRN 2781; dodan filter_p
-- IRN 2882; pos_broj
  curs_l sys_refcursor;
BEGIN
  OPEN curs_l FOR
    SELECT age.id, age.sifra, age.naziv,
           age.naz_ulice,
           pos.broj pos_broj,
           pos.naziv naz_mjesta,
           DECODE (reg.ozn_adrese, 0, NULL, reg.naziv) naz_regije,
           DECODE (zem.sifra_2a, pra_zmp_zaj.vrijednost_parametra ('0002'), NULL, zem.naziv) naz_zemlje,
           age.oib oib
      FROM m_agencije age,
           m_poste pos,
           m_regije reg,
           s_zemlje zem
     WHERE age.pos_id = pos.id (+)
       AND age.reg_id = reg.id (+)
       AND age.zem_id = zem.id (+)
       AND TRUNC (SYSDATE) BETWEEN age.dat_valjan AND (NVL (age.dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) - 1)
       AND (filter_p IS NULL
            OR UPPER (age.sifra) LIKE '%' || UPPER (filter_p) || '%'
            OR UPPER (age.naziv) LIKE '%' || UPPER (filter_p) || '%'
            )
     ORDER BY age.sifra;
  RETURN curs_l;
END;
PROCEDURE INSERT_RACUN
 (ZMPOJR_ID_P IN mzmp_ojr.id%TYPE
 ,GMPKAS_ID_P IN mgmp_kase.id%TYPE
 ,VPLA_ID_P IN tpka_rnkasa.vpla_id%TYPE
 ,GOSTP_ID_P IN tpka_rnkasa.gostp_id%TYPE
 ,AGEP_ID_P IN tpka_rnkasa.agep_id%TYPE
 ,PKAADRP_ID_P IN tpka_rnkasa.pkaadrp_id%TYPE
 ,GOD_POSLOVNA_P IN tpka_rnkasa.god_poslovna%TYPE
 ,RBR_P IN tpka_rnkasa.rbr%TYPE
 ,DATUM_P IN tpka_rnkasa.datum%TYPE
 ,IZN_PLACANJA_P IN tpka_rnkasa.izn_placanja%TYPE
 ,IZN_PPOT_P IN tpka_rnkasa.izn_ppot%TYPE
 ,OPIS1_P IN tpka_rnkasa.opis1%TYPE
 ,OPIS2_P IN tpka_rnkasa.opis2%TYPE
 ,RECARA_ID_P IN tpka_rnkasa.recara_id%TYPE
 ,VPDOG_ID_P IN tpka_rnkasa.vpdog_id%TYPE
 ,NAC_ID_P IN tpka_rnkasa.nac_id%TYPE
 ,STOPA_PPOT_P IN tpka_rnkasa.stopa_ppot%TYPE
 ,IZN_OSNOVICE_PPOT_P IN tpka_rnkasa.izn_osnovice_ppot%TYPE
 ,PKAKAR_ID_P IN tpka_rnkasa.pkakar_id%TYPE
 ,GOST_ID_P IN tpka_rnkasa.gost_id%TYPE
 ,AGE_ID_P IN tpka_rnkasa.age_id%TYPE
 ,PKAADR_ID_P IN tpka_rnkasa.pkaadr_id%TYPE
 ,IZN_POPUSTA_P IN tpka_kar_rnk.izn_popusta%TYPE
 ,GOD_POSLOVNA_IZV_P IN tpka_rnkasa.god_poslovna%TYPE := NULL
 ,RBR_IZV_P IN tpka_rnkasa.rbr%TYPE := NULL
 ,VPLA2_ID_P IN tpka_rnkasa.vpla2_id%TYPE := NULL
 ,IZN_PLACANJA2_P IN tpka_rnkasa.izn_placanja2%TYPE := NULL
 ,IZN_PNAKNADE_P IN tpka_rnkasa.izn_pnaknade%TYPE := NULL
 ,VPLA_NAPOJNICE_ID_P IN tpka_rnkasa.vpla_napojnice_id%TYPE := NULL
 ,IZN_NAPOJNICE_P IN tpka_rnkasa.izn_napojnice%TYPE := NULL
 ,OIB_OPERATERA_P IN tpka_rnkasa.oib_operatera%TYPE := NULL
 ,NAZ_OPERATERA_P IN tpka_rnkasa.naz_operatera%TYPE := NULL
 ,DAT_FNAPOJNICE_P IN tpka_rnkasa.dat_fnapojnice%TYPE := NULL
 ,IZN_POPUSTA2_P IN tpka_rnkasa.izn_popusta2%TYPE := NULL
 ,RBR_FISK_P IN tpka_rnkasa.rbr_fisk%TYPE := NULL
 ,PKARNK_ID_P OUT VARCHAR2
 )
 IS
--
-- IRN 4015; dodan parametar izn_popusta2_p
-- IRN 4103; dodan parametar rbr_fisk_p; brisani parametri pkapd_zki_p, pkapd_jir_p i pkapd_napomena_p
  command_l VARCHAR2(2000);
  cvor_l    VARCHAR2(21);
  centar_l  VARCHAR2(21);
BEGIN

  pkapro_opis_m :=
    SUBSTR (
      'insert_racun: zmpojr_id_p ' || zmpojr_id_p ||
        ', gmpkas_id_p ' || gmpkas_id_p ||
        ', vpla_id_p ' || vpla_id_p ||
        ', gostp_id_p ' || gostp_id_p ||
        ', agep_id_p ' || agep_id_p ||
        ', pkaadrp_id_p ' || pkaadrp_id_p ||
        ', god_poslovna_p ' || god_poslovna_p ||
        ', rbr_p ' || rbr_p ||
        ', datum_p ' || TO_CHAR (datum_p, 'DD.MM.RRRR') ||
        ', izn_placanja_p ' || izn_placanja_p ||
        ', izn_ppot_p ' || izn_ppot_p ||
        ', opis1_p ' || opis1_p ||
        ', opis2_p ' || opis2_p ||
        ', recara_id_p ' || recara_id_p ||
        ', vpdog_id_p ' || vpdog_id_p ||
        ', nac_id_p ' || nac_id_p || -- IRN 1845
        ', stopa_ppot_p ' || stopa_ppot_p ||
        ', izn_osnovice_ppot_p ' || izn_osnovice_ppot_p ||
        ', pkakar_id_p ' || pkakar_id_p || -- IRN 2527
        ', gost_id_p ' || gost_id_p ||
        ', age_id_p ' || age_id_p ||
        ', pkaadr_id_p ' || pkaadr_id_p ||
        ', izn_popusta_p ' || izn_popusta_p || -- IRN 2766
        -- IRN 2843
        ', god_poslovna_izv_p ' || god_poslovna_izv_p ||
        ', rbr_izv_p ' || rbr_izv_p ||
        -- IRN 2872
        ', vpla2_id_p ' || vpla2_id_p ||
        ', izn_placanja2_p ' || izn_placanja2_p ||
        -- IRN 3785
        ', izn_pnaknade_p ' || izn_pnaknade_p ||
        ', vpla_napojnice_id_p ' || vpla_napojnice_id_p ||
        ', izn_napojnice_p ' || izn_napojnice_p ||
        ', oib_operatera_p ' || oib_operatera_p ||
        ', naz_operatera_p ' || naz_operatera_p ||
        ', dat_fnapojnice_p ' || TO_CHAR (dat_fnapojnice_p, 'DD.MM.RRRR') ||
        ', izn_popusta2_p ' || izn_popusta2_p ||
        ', rbr_fisk_p ' || rbr_fisk_p,
      1,
      2000);

  pra_pka_iud.puni_pkapro ( -- IRN 1731
    zmpsus_sifra_p  => 'PKA',
    zmpvpro_sifra_p => '0004', -- Veza POS - PKA (pra_pos_pka)
    pkapro_opis_p   => pkapro_opis_m,
    ozn_vaznosti_p  => -1);

  IF vpla_id_p IS NULL THEN
    -- Nedostaje obvezan ulazni parametar (#0).
    pra_rec_zaj.vrati_poruku (-20422, pra_zmp_zaj.poruka ('ZMP', 'ZMP_VPLA')); -- IRN 2402
  END IF;

  IF zmpojr_tekuceg_cvora (zmpojr_id_p) THEN
    pra_pos_pka.insert_racun_objekt (
      zmpojr_id_p, gmpkas_id_p, vpla_id_p, gostp_id_p, agep_id_p, pkaadrp_id_p,
      god_poslovna_p, rbr_p, datum_p, izn_placanja_p, izn_ppot_p,
      opis1_p, opis2_p, recara_id_p, vpdog_id_p,
      nac_id_p, stopa_ppot_p, izn_osnovice_ppot_p,   -- IRN 1845
      pkakar_id_p, gost_id_p, age_id_p, pkaadr_id_p, -- IRN 2527
      izn_popusta_p, -- IRN 2766
      god_poslovna_izv_p, rbr_izv_p, -- IRN 2843
      vpla2_id_p, izn_placanja2_p, -- IRN 2872
      izn_pnaknade_p, vpla_napojnice_id_p, izn_napojnice_p, oib_operatera_p, naz_operatera_p, dat_fnapojnice_p, -- IRN 3785
      izn_popusta2_p,
      rbr_fisk_p,
      pkarnk_id_p);
  ELSE
    command_l :=
      'BEGIN ' ||
      '  pra_pos_pka.insert_racun<CVOR> ( ' ||
      '    :zmpojr_id_p, :gmpkas_id_p, :vpla_id_p, :gostp_id_p, :agep_id_p, :pkaadrp_id_p, ' ||
      '    :god_poslovna_p, :rbr_p, :datum_p, :izn_placanja_p, :izn_ppot_p, ' ||
      '    :opis1_p, :opis2_p, :recara_id_p, :vpdog_id_p, ' ||
      '    :nac_id_p, :stopa_ppot_p, :izn_osnovice_ppot_p, ' ||    -- IRN 1845
      '    :pkakar_id_p, :gost_id_p, :age_id_p, :pkaadr_id_p, ' || -- IRN 2527
      '    :izn_popusta_p, ' || -- IRN 2766
      '    :god_poslovna_izv_p, :rbr_izv_p, ' || -- IRN 2843
      '    :vpla2_id_p, :izn_placanja2_p, ' || -- IRN 2872
      '    :izn_pnaknade_p, :vpla_napojnice_id_p, :izn_napojnice_p, :oib_operatera_p, :naz_operatera_p, :dat_fnapojnice_p, ' || -- IRN 3785
      '    :izn_popusta2_p, ' ||
      '    :rbr_fisk_p, ' ||
      '    :pkarnk_id_p); ' ||
      'END;';
    IF pra_zmp_zaj.centar = -1 THEN
      cvor_l := zmpojr_cvor (zmpojr_id_p);
      EXECUTE IMMEDIATE REPLACE (command_l, '<CVOR>', '_objekt' || cvor_l)
        USING zmpojr_id_p, gmpkas_id_p, vpla_id_p, gostp_id_p, agep_id_p, pkaadrp_id_p,
              god_poslovna_p, rbr_p, datum_p, izn_placanja_p, izn_ppot_p,
              opis1_p, opis2_p, recara_id_p, vpdog_id_p,
              nac_id_p, stopa_ppot_p, izn_osnovice_ppot_p,   -- IRN 1845
              pkakar_id_p, gost_id_p, age_id_p, pkaadr_id_p, -- IRN 2527
              izn_popusta_p, -- IRN 2766
              god_poslovna_izv_p, rbr_izv_p, -- IRN 2843
              vpla2_id_p, izn_placanja2_p, -- IRN 2872
              izn_pnaknade_p, vpla_napojnice_id_p, izn_napojnice_p, oib_operatera_p, naz_operatera_p, dat_fnapojnice_p, -- IRN 3785
              izn_popusta2_p,
              rbr_fisk_p,
              OUT pkarnk_id_p;
    ELSE
      centar_l := cvor_centar;
      EXECUTE IMMEDIATE REPLACE (command_l, '<CVOR>', centar_l)
        USING zmpojr_id_p, gmpkas_id_p, vpla_id_p, gostp_id_p, agep_id_p, pkaadrp_id_p,
              god_poslovna_p, rbr_p, datum_p, izn_placanja_p, izn_ppot_p,
              opis1_p, opis2_p, recara_id_p, vpdog_id_p,
              nac_id_p, stopa_ppot_p, izn_osnovice_ppot_p,   -- IRN 1845
              pkakar_id_p, gost_id_p, age_id_p, pkaadr_id_p, -- IRN 2527
              izn_popusta_p, -- IRN 2766
              god_poslovna_izv_p, rbr_izv_p, -- IRN 2843
              vpla2_id_p, izn_placanja2_p, -- IRN 2872
              izn_pnaknade_p, vpla_napojnice_id_p, izn_napojnice_p, oib_operatera_p, naz_operatera_p, dat_fnapojnice_p, -- IRN 3785
              izn_popusta2_p,
              rbr_fisk_p,
              OUT pkarnk_id_p;
    END IF;
  END IF;
EXCEPTION
  WHEN OTHERS THEN
    pra_pka_iud.puni_pkapro (
      zmpsus_sifra_p  => 'PKA',
      zmpvpro_sifra_p => '0004', -- Veza POS - PKA (pra_pos_pka)
      pkapro_opis_p   => SUBSTR (pkapro_opis_m || ', pkarnk_id_p ' || pkarnk_id_p || ' ' || SQLCODE || ' ' || SQLERRM, 1, 2000),
      ozn_vaznosti_p  => 0);
    RAISE;
END;
PROCEDURE INSERT_RACUN_OBJEKT
 (ZMPOJR_ID_P IN mzmp_ojr.id%TYPE
 ,GMPKAS_ID_P IN mgmp_kase.id%TYPE
 ,VPLA_ID_P IN tpka_rnkasa.vpla_id%TYPE
 ,GOSTP_ID_P IN tpka_rnkasa.gostp_id%TYPE
 ,AGEP_ID_P IN tpka_rnkasa.agep_id%TYPE
 ,PKAADRP_ID_P IN tpka_rnkasa.pkaadrp_id%TYPE
 ,GOD_POSLOVNA_P IN tpka_rnkasa.god_poslovna%TYPE
 ,RBR_P IN tpka_rnkasa.rbr%TYPE
 ,DATUM_P IN tpka_rnkasa.datum%TYPE
 ,IZN_PLACANJA_P IN tpka_rnkasa.izn_placanja%TYPE
 ,IZN_PPOT_P IN tpka_rnkasa.izn_ppot%TYPE
 ,OPIS1_P IN tpka_rnkasa.opis1%TYPE
 ,OPIS2_P IN tpka_rnkasa.opis2%TYPE
 ,RECARA_ID_P IN tpka_rnkasa.recara_id%TYPE
 ,VPDOG_ID_P IN tpka_rnkasa.vpdog_id%TYPE
 ,NAC_ID_P IN tpka_rnkasa.nac_id%TYPE
 ,STOPA_PPOT_P IN tpka_rnkasa.stopa_ppot%TYPE
 ,IZN_OSNOVICE_PPOT_P IN tpka_rnkasa.izn_osnovice_ppot%TYPE
 ,PKAKAR_ID_P IN tpka_rnkasa.pkakar_id%TYPE
 ,GOST_ID_P IN tpka_rnkasa.gost_id%TYPE
 ,AGE_ID_P IN tpka_rnkasa.age_id%TYPE
 ,PKAADR_ID_P IN tpka_rnkasa.pkaadr_id%TYPE
 ,IZN_POPUSTA_P IN tpka_kar_rnk.izn_popusta%TYPE
 ,GOD_POSLOVNA_IZV_P IN tpka_rnkasa.god_poslovna%TYPE := NULL
 ,RBR_IZV_P IN tpka_rnkasa.rbr%TYPE := NULL
 ,VPLA2_ID_P IN tpka_rnkasa.vpla2_id%TYPE := NULL
 ,IZN_PLACANJA2_P IN tpka_rnkasa.izn_placanja2%TYPE := NULL
 ,IZN_PNAKNADE_P IN tpka_rnkasa.izn_pnaknade%TYPE := NULL
 ,VPLA_NAPOJNICE_ID_P IN tpka_rnkasa.vpla_napojnice_id%TYPE := NULL
 ,IZN_NAPOJNICE_P IN tpka_rnkasa.izn_napojnice%TYPE := NULL
 ,OIB_OPERATERA_P IN tpka_rnkasa.oib_operatera%TYPE := NULL
 ,NAZ_OPERATERA_P IN tpka_rnkasa.naz_operatera%TYPE := NULL
 ,DAT_FNAPOJNICE_P IN tpka_rnkasa.dat_fnapojnice%TYPE := NULL
 ,IZN_POPUSTA2_P IN tpka_rnkasa.izn_popusta2%TYPE := NULL
 ,RBR_FISK_P IN tpka_rnkasa.rbr_fisk%TYPE := NULL
 ,PKARNK_ID_P OUT tpka_rnkasa.id%TYPE
 )
 IS
--
-- IRN 4015; dodan parametar izn_popusta2_p
-- IRN 4103; dodan parametar rbr_fisk_p; brisani parametri pkapd_zki_p, pkapd_jir_p i pkapd_napomena_p

  rbr_izv_l       tpka_rnkasa.rbr%TYPE; -- IRN 2843
  pkarnk_id_izv_l tpka_rnkasa.id%TYPE;  -- IRN 2843
  gmpkas_row_l    mgmp_kase%ROWTYPE;
  gostp_row_l     t_gosti%ROWTYPE;
  ozn_provjeri1_l NUMBER := -1;
  ozn_provjeri2_l NUMBER := -1;
  pkarnk_row_l    tpka_rnkasa%ROWTYPE;
  -- IRN 3115
  CURSOR pkarnk_c IS
    SELECT id, datum, (izn_placanja + NVL (izn_placanja2, 0)) AS iznos
      FROM tpka_rnkasa
     WHERE god_poslovna_izvor = god_poslovna_p
       AND gmpkas_id_izvor = gmpkas_id_p
       AND rbr_izvor = pkarnk_row_l.rbr;
  pkarnk_c_l pkarnk_c%ROWTYPE;
  -- KRAJ IRN 3115
  vpla_ozn_irn1_l s_vplacanja.ozn_irn%TYPE; -- IRN 3932
  vpla_ozn_irn2_l s_vplacanja.ozn_irn%TYPE; -- IRN 3932
BEGIN

  -- IRN 3115; Provjeri postoji li raun u PKA (PKARNK_UK: god_poslovna_izvor, gmpkas_id_izvor, rbr_izvor)
  pkarnk_row_l.rbr := rbr_p;
  pra_zmp_zaj.oblikuj_broj_zer_all (pkarnk_row_l.rbr, 6);
  OPEN pkarnk_c;
  FETCH pkarnk_c INTO pkarnk_c_l;
  CLOSE pkarnk_c;
  IF pkarnk_c_l.id IS NOT NULL THEN
    SELECT sifra INTO gmpkas_row_l.sifra FROM mgmp_kase WHERE id = gmpkas_id_p;
    IF TRUNC (datum_p) = pkarnk_c_l.datum
      AND (izn_placanja_p + NVL (izn_placanja2_p, 0)) = pkarnk_c_l.iznos
    THEN
      -- Raun #0 blagajne #1 ve postoji u PKA (id = #2)!
      pra_pka_zaj.vrati_poruku (
        -20241,
        rbr_p || '-' || god_poslovna_p,
        gmpkas_row_l.sifra,
        pkarnk_c_l.id);
    ELSE
      -- Raun #0 blagajne #1 ve postoji u PKA (datum #2, iznos #3)!
      pra_pka_zaj.vrati_poruku (
        -20240,
        rbr_p || '-' || god_poslovna_p,
        gmpkas_row_l.sifra,
        TO_CHAR (pkarnk_c_l.datum, 'DD.MM.RRRR'),
        LTRIM (TO_CHAR (pkarnk_c_l.iznos, '9G999G999G990D00')));
    END IF;
  END IF;
  -- KRAJ IRN 3115

  -- Provjeri datum rauna, IRN 960, 07.05.2009. G.J.
  IF datum_p IS NULL THEN
    -- Datum internog POS rauna je obvezan podatak!
    pra_pka_zaj.vrati_poruku (-20103);
  ELSIF datum_p > TRUNC (SYSDATE) THEN
    -- Datum internog POS rauna #0 ne moe biti vei od tekueg #1!
    pra_pka_zaj.vrati_poruku (-20104, TO_CHAR (datum_p, 'DD.MM.RRRR'), TO_CHAR (SYSDATE, 'DD.MM.RRRR'));
  END IF;

  -- IRN 3932
  -- samo ako je oznaka (ozn_irn IN (1, 2, 3)) pozvati provjeru urnala i PKA dnevnika prometa
  IF vpla_id_p IS NOT NULL THEN
    SELECT MIN (ozn_irn) INTO vpla_ozn_irn1_l FROM s_vplacanja WHERE id = vpla_id_p;
  END IF;
  IF vpla2_id_p IS NOT NULL THEN
    SELECT MIN (ozn_irn) INTO vpla_ozn_irn2_l FROM s_vplacanja WHERE id = vpla2_id_p;
  END IF;
  IF NVL (vpla_ozn_irn1_l, '*') IN ('1', '2', '3') OR NVL (vpla_ozn_irn2_l, '*') IN ('1', '2', '3') THEN
    pra_pka_s2.provjeri_pkarnk_datum (datum_p, zmpojr_id_p); -- REC urnal, PKA dnevnik prometa
  END IF;

  -- IRN 2843, Provjeri raun koji se ponitava
  IF god_poslovna_izv_p IS NULL AND rbr_izv_p IS NOT NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'god_poslovna_izv_p');
  ELSIF god_poslovna_izv_p IS NOT NULL AND rbr_izv_p IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'rbr_izv_p');
  ELSIF god_poslovna_izv_p IS NOT NULL AND rbr_izv_p IS NOT NULL THEN

    IF pra_pka_zaj.vrijednost_parametra ('1082') = 'da' THEN
      -- Zabrani ponitavanje POS rauna koji je ve naplaen u REC ili PKA
      rbr_izv_l := rbr_izv_p;
      pra_zmp_zaj.oblikuj_broj_zer_all (rbr_izv_l, 6);
      SELECT MIN (id) INTO pkarnk_id_izv_l
        FROM tpka_rnkasa
       WHERE god_poslovna = god_poslovna_izv_p
         AND gmpkas_id = gmpkas_id_p
         AND rbr = rbr_izv_l
         AND oznaka = 'V'
         AND rac_id IS NULL
         AND pkarac_id IS NULL; -- ne gleda se je li RNK obraunat
      IF pkarnk_id_izv_l IS NULL THEN
        -- POS raun #0 - #1 - #2 je naplaen.
        SELECT sifra INTO gmpkas_row_l.sifra FROM mgmp_kase WHERE id = gmpkas_id_p;
        pra_pka_zaj.vrati_poruku (-20225, god_poslovna_izv_p, gmpkas_row_l.sifra, rbr_izv_l);
      END IF;
    END IF;

    IF pra_pka_zaj.vrijednost_parametra ('1083') = 'da' THEN
      -- Dopusti ponitavanje POS rauna vezanog na odjavljenog gosta
      ozn_provjeri1_l := 0;
      ozn_provjeri2_l := 0;
    END IF;

  END IF;

  -- Provjeri gosta, IRN 960, 06.05.2009. G.J.
  IF gostp_id_p IS NOT NULL AND (ozn_provjeri1_l = -1 OR ozn_provjeri2_l = -1) THEN
    SELECT * INTO gmpkas_row_l FROM mgmp_kase WHERE id = gmpkas_id_p;
    IF gmpkas_row_l.metapl_sifra = 'GAS' AND NVL (gmpkas_row_l.ozn_kase, '') = 'M' THEN
      -- IRN 2402; RN minibara doputeno je proknjiiti i gostima kojima je ozn_rnk "ne" i na dan odlaska i odjavljenim gostima
      ozn_provjeri1_l := 0;
      IF izn_placanja_p < 0 THEN
        -- IRN 2402; negativan RN minibara doputeno je proknjiiti i izvan razdoblja boravka gosta
        ozn_provjeri2_l := 0;
      END IF;
    END IF;

    SELECT * INTO gostp_row_l FROM t_gosti WHERE id = gostp_id_p;
    IF gostp_row_l.ozn_prisutnosti = 'O' AND ozn_provjeri1_l = -1 THEN
      -- Gost #0 #1 je odjavljen!
      pra_pka_zaj.vrati_poruku (-20099, gostp_row_l.ime, gostp_row_l.prezime);
    END IF;
    IF datum_p NOT BETWEEN gostp_row_l.dat_dolaska AND gostp_row_l.dat_odlaska AND ozn_provjeri2_l = -1 THEN
      -- Datum internog POS rauna #0 izvan je razdoblja boravka gosta (#1 - #2)!
      pra_pka_zaj.vrati_poruku (
        -20101,
        TO_CHAR (datum_p, 'DD.MM.RRRR'),
        TO_CHAR (gostp_row_l.dat_dolaska, 'DD.MM.RRRR'),
        TO_CHAR (gostp_row_l.dat_odlaska, 'DD.MM.RRRR'));
    END IF;
    IF gostp_row_l.ozn_rnk = 0 AND ozn_provjeri1_l = -1 THEN
      -- Knjienje internih POS rauna na gosta #0 #1 nije doputeno!
      pra_pka_zaj.vrati_poruku (-20100, gostp_row_l.ime, gostp_row_l.prezime);
    END IF;
    -- IRN 2402; gostp_row_l.ozn_rnk nadjaava gmpkas_row_l.ozn_knjizenja
    IF datum_p = gostp_row_l.dat_odlaska AND NVL (gostp_row_l.ozn_rnk, gmpkas_row_l.ozn_knjizenja) = 0 AND ozn_provjeri1_l = -1 THEN
      -- Nije doputeno knjienje rauna s blagajne #0 na dan odlaska gosta #1!
      pra_pka_zaj.vrati_poruku (-20102, gmpkas_row_l.naziv, TO_CHAR (gostp_row_l.dat_odlaska, 'DD.MM.RRRR'));
    END IF;
  END IF;

  -- id domae valute
  pkarnk_row_l.domval_id := pra_zmp_s2.domval_id (datum_p); -- IRN 3545; domau valutu selektiramo po datumu, prelazak na EUR
  IF pkarnk_row_l.domval_id IS NULL THEN
    -- Nedostaje podatak (#0)!
    pra_zmp_zaj.vrati_poruku (-20098, pra_zmp_zaj.poruka ('ZMP', 'ZMP_VAL'));
  END IF;

  -- insert u TPKA_RNKASA u zadanu shemu
  pkarnk_row_l.id := pra_zmp_zaj.i3_sekvenca (NULL);
  pkarnk_row_l.zmpojr_id := zmpojr_id_p;
  pkarnk_row_l.gmpkas_id := gmpkas_id_p;
  -- vplaval_id -- IRN 2872
  pkarnk_row_l.gost_id := NVL (gost_id_p, gostp_id_p);
  pkarnk_row_l.age_id := NVL (age_id_p, agep_id_p);
  pkarnk_row_l.pkaadr_id := NVL (pkaadr_id_p, pkaadrp_id_p);
  pkarnk_row_l.gostp_id := gostp_id_p;
  pkarnk_row_l.agep_id := agep_id_p;
  pkarnk_row_l.pkaadrp_id := pkaadrp_id_p;
  -- rac_id
  -- pkarac_id
  pkarnk_row_l.god_poslovna := god_poslovna_p;
  -- IRN 3115; pkarnk_row_l.rbr se od 3.3.2020. puni na poetku procedure
  -- IRN 3115; pkarnk_row_l.rbr := rbr_p;
  -- IRN 3115; pra_zmp_zaj.oblikuj_broj_zer_all (pkarnk_row_l.rbr, 6);
  pkarnk_row_l.oznaka := 'V';
  pkarnk_row_l.ozn_unosa := 'A';
  pkarnk_row_l.datum := datum_p;
  pkarnk_row_l.izn_placanja := izn_placanja_p;
  pkarnk_row_l.izn_ppot := izn_ppot_p;
  IF opis2_p LIKE 'Pay Card%' -- IRN 3371
    OR (gostp_id_p IS NULL AND agep_id_p IS NULL AND pkaadrp_id_p IS NULL)
  THEN
    pkarnk_row_l.opis1 := opis1_p;
    pkarnk_row_l.opis2 := opis2_p;
  END IF;
  -- unos_korisnik, unos_dat, izmjena_korisnik, izmjena_dat
  pkarnk_row_l.recara_id := recara_id_p;
  pkarnk_row_l.vpdog_id := vpdog_id_p;
  pkarnk_row_l.ozn_izvorni := -1;
  -- god_poslovna_izvor, gmpkas_id_izvor, rbr_izvor
  pkarnk_row_l.nac_id := nac_id_p;
  pkarnk_row_l.stopa_ppot := stopa_ppot_p;
  pkarnk_row_l.izn_osnovice_ppot := izn_osnovice_ppot_p;
  -- br_transakcije, br_autorizacije
  pkarnk_row_l.pkakar_id := pkakar_id_p; -- IRN 2527
  pkarnk_row_l.izn_popusta := NVL (izn_popusta_p, 0); -- IRN 2766
  -- IRN 2872
  -- val_id -- napunjeno prije
  pkarnk_row_l.vpla_id := vpla_id_p;
  pkarnk_row_l.vpla2_id := vpla2_id_p;
  pkarnk_row_l.izn_placanja2 := izn_placanja2_p;
  -- END IRN 2872
  -- IRN 3785
  pkarnk_row_l.izn_pnaknade := izn_pnaknade_p;
  pkarnk_row_l.vpla_napojnice_id := vpla_napojnice_id_p;
  pkarnk_row_l.izn_napojnice := izn_napojnice_p;
  pkarnk_row_l.oib_operatera := oib_operatera_p;
  pkarnk_row_l.naz_operatera := naz_operatera_p;
  pkarnk_row_l.dat_fnapojnice := dat_fnapojnice_p;
  -- END IRN 3785
  pkarnk_row_l.izn_popusta2 := NVL (izn_popusta2_p, 0);
  pkarnk_row_l.rbr_fisk := rbr_fisk_p;
  IF pkarnk_row_l.rbr_fisk IS NOT NULL THEN 
    pra_zmp_zaj.oblikuj_broj_zer_all (pkarnk_row_l.rbr_fisk, 6);
  END IF;
  INSERT INTO tpka_rnkasa VALUES pkarnk_row_l;

  pkarnk_id_p := pkarnk_row_l.id;
END;
PROCEDURE INSERT_POREZ
 (ZMPOJR_ID_P IN mzmp_ojr.id%TYPE
 ,PKARNK_ID_P IN tpka_rnkasa.id%TYPE
 ,IZN_OSNOVICE_P IN ipka_rnk_pdv.izn_osnovice%TYPE
 ,STOPA_PDV_P IN ipka_rnk_pdv.stopa_pdv%TYPE
 ,VPISPZ_ID_P IN ipka_rnk_pdv.vpispz_id%TYPE
 ,IZN_PDV_P IN ipka_rnk_pdv.izn_pdv%TYPE
 )
 IS
--
  command_l VARCHAR2(1000);
  cvor_l    VARCHAR2(21);
  centar_l  VARCHAR2(21);
BEGIN
  IF zmpojr_tekuceg_cvora (zmpojr_id_p) THEN
    pra_pos_pka.insert_porez_objekt (
      zmpojr_id_p, pkarnk_id_p, izn_osnovice_p, stopa_pdv_p, vpispz_id_p, izn_pdv_p);
  ELSE
    command_l :=
      'BEGIN ' ||
      '  pra_pos_pka.insert_porez<CVOR> ( ' ||
      '    :zmpojr_id_p, :pkarnk_id_p, :izn_osnovice_p, :stopa_pdv_p, :vpispz_id_p, :izn_pdv_p); '||
      'END;';
    IF pra_zmp_zaj.centar = -1 THEN
      cvor_l := zmpojr_cvor (zmpojr_id_p);
      EXECUTE IMMEDIATE REPLACE (command_l, '<CVOR>', '_objekt' || cvor_l)
        USING zmpojr_id_p, pkarnk_id_p, izn_osnovice_p, stopa_pdv_p, vpispz_id_p, izn_pdv_p;
    ELSE
      centar_l := cvor_centar;
      EXECUTE IMMEDIATE REPLACE (command_l, '<CVOR>', centar_l)
        USING zmpojr_id_p, pkarnk_id_p, izn_osnovice_p, stopa_pdv_p, vpispz_id_p, izn_pdv_p;
    END IF;
  END IF;
END;
PROCEDURE INSERT_POREZ_OBJEKT
 (ZMPOJR_ID_P IN mzmp_ojr.id%TYPE
 ,PKARNK_ID_P IN tpka_rnkasa.id%TYPE
 ,IZN_OSNOVICE_P IN ipka_rnk_pdv.izn_osnovice%TYPE
 ,STOPA_PDV_P IN ipka_rnk_pdv.stopa_pdv%TYPE
 ,VPISPZ_ID_P IN ipka_rnk_pdv.vpispz_id%TYPE
 ,IZN_PDV_P IN ipka_rnk_pdv.izn_pdv%TYPE
 )
 IS
/*
10.12.2007. G.J.
Ulazni parametar zmpojr_id_p ovdje nije potreban,
ali ostaje da bi kod procedure insert_porez bio jednostavniji
*/
BEGIN
  -- insert u IPKA_RNK_PDV u zadanu shemu
  INSERT INTO ipka_rnk_pdv (
      pkarnk_id, vpispz_id, izn_osnovice, stopa_pdv, izn_pdv)
    VALUES (
      pkarnk_id_p, vpispz_id_p, izn_osnovice_p, stopa_pdv_p, izn_pdv_p);
END;
PROCEDURE INSERT_PKARNKISP
 (ZMPOJR_ID_P IN mzmp_ojr.id%TYPE
 ,PKARNK_ID_P IN tpka_rnkasa.id%TYPE
 ,SIFRA_P IN tpka_rnk_isp.sifra%TYPE
 ,NAZIV_P IN tpka_rnk_isp.naziv%TYPE
 ,JM_P IN tpka_rnk_isp.jm%TYPE
 ,KOLICINA_P IN tpka_rnk_isp.kolicina%TYPE
 ,CIJENA_P IN tpka_rnk_isp.cijena%TYPE
 ,STOPA_POPUSTA_P IN tpka_rnk_isp.stopa_popusta%TYPE
 ,VPISPZ_ID_P IN tpka_rnk_isp.vpispz_id%TYPE
 ,STOPA_PDV_P IN tpka_rnk_isp.stopa_pdv%TYPE
 ,IZN_PPOT_P IN tpka_rnk_isp.izn_ppot%TYPE
 ,IZN_PDV_P IN tpka_rnk_isp.izn_pdv%TYPE
 ,IZN_PNAKNADE_P IN tpka_rnkasa.izn_pnaknade%TYPE := NULL
 ,KPD_SIFRA_P IN s_kpd.sifra%TYPE := NULL
 )
 IS
--
  command_l VARCHAR2(1000);
  cvor_l    VARCHAR2(21);
  centar_l  VARCHAR2(21);
BEGIN
  -- IRN 3785; dodan parametar izn_pnaknade_p
  -- IRN 4103; dodan parametar kpd_sifra_p
  IF zmpojr_tekuceg_cvora (zmpojr_id_p) THEN
    pra_pos_pka.insert_pkarnkisp_objekt (
      zmpojr_id_p, pkarnk_id_p, sifra_p, naziv_p, jm_p, kolicina_p,
      cijena_p, stopa_popusta_p, vpispz_id_p, stopa_pdv_p, izn_ppot_p,
      izn_pdv_p, izn_pnaknade_p, kpd_sifra_p);
  ELSE
    command_l :=
      'BEGIN ' ||
      '  pra_pos_pka.insert_pkarnkisp<CVOR> ( ' ||
      '    :zmpojr_id_p, :pkarnk_id_p, :sifra_p, :naziv_p, :jm_p, :kolicina_p, ' ||
      '    :cijena_p, :stopa_popusta_p, :vpispz_id_p, :stopa_pdv_p, :izn_ppot_p, ' ||
      '    :izn_pdv_p, :izn_pnaknade_p, :kpd_sifra_p); ' ||
      'END;';
    IF pra_zmp_zaj.centar = -1 THEN
      cvor_l := zmpojr_cvor (zmpojr_id_p);
      EXECUTE IMMEDIATE REPLACE (command_l, '<CVOR>', '_objekt' || cvor_l)
        USING zmpojr_id_p, pkarnk_id_p, sifra_p, naziv_p, jm_p, kolicina_p,
              cijena_p, stopa_popusta_p, vpispz_id_p, stopa_pdv_p, izn_ppot_p,
              izn_pdv_p, izn_pnaknade_p, kpd_sifra_p;
    ELSE
      centar_l := cvor_centar;
      EXECUTE IMMEDIATE REPLACE (command_l, '<CVOR>', centar_l)
        USING zmpojr_id_p, pkarnk_id_p, sifra_p, naziv_p, jm_p, kolicina_p,
              cijena_p, stopa_popusta_p, vpispz_id_p, stopa_pdv_p, izn_ppot_p,
              izn_pdv_p, izn_pnaknade_p, kpd_sifra_p;
    END IF;
  END IF;
END;
PROCEDURE INSERT_PKARNKISP_OBJEKT
 (ZMPOJR_ID_P IN mzmp_ojr.id%TYPE
 ,PKARNK_ID_P IN tpka_rnkasa.id%TYPE
 ,SIFRA_P IN tpka_rnk_isp.sifra%TYPE
 ,NAZIV_P IN tpka_rnk_isp.naziv%TYPE
 ,JM_P IN tpka_rnk_isp.jm%TYPE
 ,KOLICINA_P IN tpka_rnk_isp.kolicina%TYPE
 ,CIJENA_P IN tpka_rnk_isp.cijena%TYPE
 ,STOPA_POPUSTA_P IN tpka_rnk_isp.stopa_popusta%TYPE
 ,VPISPZ_ID_P IN tpka_rnk_isp.vpispz_id%TYPE
 ,STOPA_PDV_P IN tpka_rnk_isp.stopa_pdv%TYPE
 ,IZN_PPOT_P IN tpka_rnk_isp.izn_ppot%TYPE
 ,IZN_PDV_P IN tpka_rnk_isp.izn_pdv%TYPE
 ,IZN_PNAKNADE_P IN tpka_rnkasa.izn_pnaknade%TYPE := NULL
 ,KPD_SIFRA_P IN s_kpd.sifra%TYPE := NULL
 )
 IS
-- insert u TPKA_RNK_ISP u zadanu shemu
-- IRN 3785; dodan parametar izn_pnaknade_p
-- IRN 4103; dodan parametar kpd_sifra_p

  kpd_id_l s_kpd.id%TYPE;
BEGIN

  IF kpd_sifra_p IS NOT NULL THEN
    SELECT MIN (id) INTO kpd_id_l FROM s_kpd WHERE sifra = kpd_sifra_p;
    IF kpd_id_l IS NULL THEN
      -- Pogrena vrijednost ulaznog parametra (#0)!
      pra_zmp_zaj.vrati_poruku (-20099, 'kpd_sifra_p');
    END IF;
  END IF;

  INSERT INTO tpka_rnk_isp (
      pkarnk_id, sifra, naziv, jm, kolicina, cijena, stopa_popusta,
      vpispz_id, stopa_pdv, izn_ppot, izn_pdv, izn_pnaknade, kpd_id)
    VALUES (
      pkarnk_id_p, sifra_p, naziv_p, jm_p, kolicina_p, cijena_p, stopa_popusta_p,
      vpispz_id_p, stopa_pdv_p, izn_ppot_p, izn_pdv_p, izn_pnaknade_p, kpd_id_l);
END;
PROCEDURE VRATI_PKARNK
 (ZMPOJR_ID_P IN mzmp_ojr.id%TYPE
 ,PKARNK_ID_P IN tpka_rnkasa.id%TYPE
 ,IZN_PLACANJA_P OUT tpka_rnkasa.izn_placanja%TYPE
 ,VPLA_ID_P OUT m_vpla_val.vpla_id%TYPE
 )
 IS
--
  upit_l    VARCHAR2(1000);
  command_l VARCHAR2(1000);
  centar_l  VARCHAR2(21) := cvor_centar;
  cvor_l    VARCHAR2(21) := zmpojr_cvor (zmpojr_id_p);
BEGIN
  IF pra_zmp_zaj.centar = -1 OR NVL (cvor_l, centar_l) = centar_l THEN
    upit_l :=
      'SELECT MIN (izn_placanja), MIN (vpla_id)' || -- IRN 1999, IRN 2872
      '  FROM tpka_rnkasa<CVOR>' ||
      ' WHERE id = :pkarnk_id_p';
    EXECUTE IMMEDIATE REPLACE (upit_l, '<CVOR>', cvor_l) INTO izn_placanja_p, vpla_id_p USING pkarnk_id_p;
  ELSE
    command_l := 'BEGIN pra_pos_pka.vrati_pkarnk<CVOR> (:zmpojr_id_p, :pkarnk_id_p, :izn_placanja_p, :vpla_id_p); END;';
    command_l := REPLACE (command_l, '<CVOR>', centar_l);
    EXECUTE IMMEDIATE command_l USING IN zmpojr_id_p, IN pkarnk_id_p, OUT izn_placanja_p, OUT vpla_id_p;
  END IF;
END;
FUNCTION PKARNK_ID
 (ZMPOJR_ID_P IN mzmp_ojr.id%TYPE
 ,RBR_P IN tpka_rnkasa.rbr%TYPE
 ,GMPKAS_ID_P IN mgmp_kase.id%TYPE
 ,GOD_POSLOVNA_P IN tpka_rnkasa.god_poslovna%TYPE
 )
 RETURN tpka_rnkasa.id%TYPE
 IS
--
  rbr_l       tpka_rnkasa.rbr%TYPE;
  upit_l      VARCHAR2(1000);
  pkarnk_id_l tpka_rnkasa.id%TYPE;
  centar_l    VARCHAR2(21) := cvor_centar;
  cvor_l      VARCHAR2(21) := zmpojr_cvor (zmpojr_id_p);
  command_l   VARCHAR2(1000);
BEGIN

  -- oblikuj redni broj
  rbr_l := rbr_p;
  pra_zmp_zaj.oblikuj_broj_zer_all (rbr_l, 6);

  IF pra_zmp_zaj.centar = -1 OR NVL (cvor_l, centar_l) = centar_l THEN
    upit_l :=
      'SELECT MIN (id) ' ||
      '  FROM tpka_rnkasa<CVOR> ' ||
      ' WHERE god_poslovna_izvor = :god_poslovna_p ' ||
      '   AND gmpkas_id_izvor = :gmpkas_id_p ' ||
      '   AND rbr_izvor = :rbr_l';
    EXECUTE IMMEDIATE REPLACE (upit_l, '<CVOR>', cvor_l) INTO pkarnk_id_l USING god_poslovna_p, gmpkas_id_p, rbr_l; -- IRN 1999
  ELSE
    command_l := 'SELECT pra_pos_pka.pkarnk_id<CVOR> (:zmpojr_id_p, :rbr_l, :gmpkas_id_p, :god_poslovna_p) FROM dual';
    command_l := REPLACE (command_l, '<CVOR>', centar_l);
    EXECUTE IMMEDIATE command_l INTO pkarnk_id_l USING zmpojr_id_p, rbr_l, gmpkas_id_p, god_poslovna_p;
  END IF;

  RETURN (pkarnk_id_l);

END;
FUNCTION VPPLA_NAZIV
 (VPLA_ID_P IN s_vplacanja.id%TYPE
 )
 RETURN s_vpplacanja.naziv%TYPE
 IS
-- IRN 1611
  vppla_naziv_l s_vpplacanja.naziv%TYPE;
BEGIN
  IF vpla_id_p IS NULL THEN
    RETURN (NULL);
  END IF;

  SELECT MAX (vppla.naziv) INTO vppla_naziv_l
    FROM s_vpplacanja vppla,
         s_vplacanja vpla
   WHERE vpla.id = vpla_id_p
     AND vpla.vppla_id = vppla.id;

  RETURN (vppla_naziv_l);

END;
FUNCTION BANKE
 RETURN SYS_REFCURSOR
 IS
--
  curs_l SYS_REFCURSOR;
BEGIN
  OPEN curs_l FOR
    SELECT DISTINCT ban.id ban_id, ban.sifra ban_sifra, ban.naziv ban_naziv
      FROM m_banke ban, tpka_tecajnice pkatec
     WHERE pkatec.ban_id = ban.id
       AND TRUNC (SYSDATE) BETWEEN ban.dat_valjan AND (NVL (ban.dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) - 1);
  RETURN curs_l;
END;
FUNCTION VALUTE
 (BAN_ID_P IN tpka_tecajnice.ban_id%TYPE
 ,DATUM_P IN tpka_tecajnice.datum%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
--
  datum_l DATE; -- IRN 1731
  curs_l SYS_REFCURSOR;
BEGIN

  SELECT MAX (datum) INTO datum_l
    FROM tpka_tecajnice
   WHERE ban_id = ban_id_p
     AND datum <= TRUNC (datum_p);

  OPEN curs_l FOR
    SELECT val.sifra_3n, val.sifra_3a, pkatecval.izn_tecaja / val.jedinica tecaj
      FROM tpka_tecajnice pkatec,
           tpka_tec_val pkatecval,
           s_valute val,
           s_vtecajeva vtec
     WHERE pkatec.vtec_id = vtec.id
       AND pkatecval.pkatec_id = pkatec.id
       AND pkatecval.val_id = val.id
       AND NVL (pkatecval.izn_tecaja, 0) > 0
       AND pkatec.ban_id = ban_id_p
       AND vtec.sifra = pra_zmp_zaj.vrijednost_parametra ('0028') -- ifra vrste teajeva "SREDNJI" (ili nebitno)
       AND pkatec.datum = datum_l;

  RETURN curs_l;

END;
FUNCTION LOY_CLAN
 (LOYKAR_BROJ_P IN tloy_kartice.broj%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
--
  curs_l sys_refcursor;
BEGIN
  OPEN curs_l FOR
    SELECT recagost.ime, recagost.prezime
      FROM trec_agostiju recagost,
           tloy_kartice loykar -- IRN 2678
     WHERE loykar.recagost_id = recagost.id
       AND recagost.oznaka = 'V'
       AND loykar.broj = loykar_broj_p;
  RETURN curs_l;
END;
PROCEDURE PROVJERI_LIMIT
 (PKAADR_ID_P IN tpka_kartice.pkaadr_id%TYPE
 ,PKAKAR_ID_P IN tpka_kartice.id%TYPE
 ,NAC_ID_P IN tpka_kartice.nac_id%TYPE
 ,DATUM_P IN DATE := SYSDATE
 ,METCVOR_SIFRA_P IN smet_cvorovi.sifra%TYPE
 ,OZNAKA_P OUT NUMBER
 ,IZNOS_P OUT tpka_kar_rnk.iznos%TYPE
 ,IZNOS2_P OUT tpka_kar_rnk.iznos%TYPE
 )
 IS
-- IRN 3771
  command_l VARCHAR2(1000);
  cvor_l VARCHAR2(21);
BEGIN

  IF (pkaadr_id_p IS NULL AND pkakar_id_p IS NULL)
    OR nac_id_p IS NULL
    -- IRN 3864 -- OR metcvor_sifra_p IS NULL -- parametar vrati pra_pos_pkakar.provjeri_pkakar
    -- IRN 3864 -- OR pra_pka_zaj.vrijednost_parametra ('1079') = 'nebitno' -- ifre limitiranih naina potronje
  THEN
    oznaka_p := 0; -- limit ne postoji
    RETURN; -- izlaz
  END IF;

  pkapro_opis_m :=
    SUBSTR (
      'provjeri_limit: pkaadr_id_p ' || pkaadr_id_p ||
        ', pkakar_id_p ' || pkakar_id_p ||
        ', nac_id_p ' || nac_id_p ||
        ', datum_p ' || TO_CHAR (datum_p, 'DD.MM.RRRR') ||
        ', metcvor_sifra_p ' || metcvor_sifra_p,
      1,
      2000);

  pra_pka_iud.puni_pkapro (
    zmpsus_sifra_p  => 'PKA',
    zmpvpro_sifra_p => '0004', -- Veza POS - PKA (pra_pos_pka)
    pkapro_opis_p   => pkapro_opis_m,
    ozn_vaznosti_p  => -1);

  /*
  IRN 3864
  HNB doputa da se popust i adresa na POS raunu upiu runo, a ne samo putem Pay Card.
  U tom sluaju podatak metcvor_sifra nije poznat, pa e POS slati NULL kao vrijednost
  parametra metcvor_sifra_p, a MISH e smatrati da se radi o tekuem voru.
  IRN 4015
  dodan OUT parametar iznos2_p
  */
  IF metcvor_sifra_p IS NULL OR metcvor_sifra_p = pra_zmp_zaj.tekuci_cvor THEN
    pra_pos_pka.provjeri_limit_objekt (
      pkaadr_id_p, pkakar_id_p, nac_id_p, datum_p, metcvor_sifra_p,
      oznaka_p, iznos_p, iznos2_p);
  ELSE
    command_l :=
      'BEGIN ' ||
      '  pra_pos_pka.provjeri_limit<CVOR> ( ' ||
      '    :pkaadr_id_p, :pkakar_id_p, :nac_id_p, :datum_p, :metcvor_sifra_p, ' ||
      '    :oznaka_p, :iznos_p, :iznos2_p); ' ||
      'END;';

    IF pra_zmp_zaj.centar = -1 THEN
      cvor_l := '@' || metcvor_sifra_p;
      EXECUTE IMMEDIATE REPLACE (command_l, '<CVOR>', '_objekt' || cvor_l)
        USING pkaadr_id_p, pkakar_id_p, nac_id_p, datum_p, metcvor_sifra_p,
              OUT oznaka_p, OUT iznos_p, OUT iznos2_p;
    ELSE
      cvor_l := cvor_centar;
      EXECUTE IMMEDIATE REPLACE (command_l, '<CVOR>', cvor_l)
        USING pkaadr_id_p, pkakar_id_p, nac_id_p, datum_p, metcvor_sifra_p,
              OUT oznaka_p, OUT iznos_p, OUT iznos2_p;
    END IF;
  END IF;

END;
PROCEDURE DELETE_RACUN
 (PKARNK_ID_P IN tpka_rnkasa.id%TYPE
 ,ROWCOUNT_P OUT NUMBER
 )
 IS
-- IRN 2781; multitenant; kompenzacijska procedura za insert_racun, insert_porez i insert_pkarnkisp
BEGIN

  rowcount_p := 0;

  IF pkarnk_id_p IS NULL
    OR SYS_CONTEXT ('loginfo_ctx', 'vlasnikpodatka') IS NULL
  THEN
    RETURN;
  END IF;

  DELETE FROM tpka_pdokumenti WHERE pkarnk_id = pkarnk_id_p; -- IRN 3492
  DELETE FROM ipka_rnk_pdv WHERE pkarnk_id = pkarnk_id_p;
  DELETE FROM tpka_rnk_isp WHERE pkarnk_id = pkarnk_id_p;
  DELETE FROM tpka_rnkasa  WHERE id = pkarnk_id_p;
  rowcount_p := SQL%ROWCOUNT;

EXCEPTION
  WHEN OTHERS THEN
    pra_pka_iud.puni_pkapro (
      zmpsus_sifra_p  => 'PKA',
      zmpvpro_sifra_p => '0004', -- Veza POS - PKA (pra_pos_pka)
      pkapro_opis_p   => SUBSTR ('delete_racun: pkarnk_id_p ' || pkarnk_id_p || ', rowcount_p ' || rowcount_p || ' ' || SQLCODE || ' ' || SQLERRM, 1, 2000),
      ozn_vaznosti_p  => 0);
    RAISE;
END;
FUNCTION GOST_BY_ID
 (SO_ID_P IN m_so.id%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
-- IRN 2798
  metcvor_sifra_l m_so.metcvor_sifra%TYPE;
BEGIN
  SELECT metcvor_sifra INTO metcvor_sifra_l FROM m_so WHERE id = so_id_p;
  RETURN pra_pos_pkakar.gost_by_id (metcvor_sifra_l, gost_id_p);
END;
FUNCTION PKAADR_BY_ID
 (ZMPOJR_ID_P IN mzmp_ojr.id%TYPE
 ,PKAADR_ID_P IN mpka_adrese.id%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
-- IRN 2798
  metcvor_sifra_l mzmp_ojr.metcvor_sifra%TYPE;
BEGIN
  SELECT metcvor_sifra INTO metcvor_sifra_l FROM mzmp_ojr WHERE id = zmpojr_id_p;
  RETURN pra_pos_pkakar.pkaadr_by_id (metcvor_sifra_l, pkaadr_id_p);
END;
FUNCTION POS_DISCOUNT_RATE
 (GOST_ID_P IN t_gosti.id%TYPE
 )
 RETURN trec_agostiju.stopa_popusta_pos%TYPE
 IS
-- IRN 2819
  stopa_popusta_pos_l trec_agostiju.stopa_popusta_pos%TYPE;
BEGIN
  IF gost_id_p IS NULL
    -- Odobriti popust iz arhive gostiju kod knjienja POS rauna na gosta da ili ne.
    OR pra_zmp_zaj.zmppar_vrijednost ('REC', '1201') = 'ne'
  THEN
    RETURN stopa_popusta_pos_l;
  END IF;

  SELECT MIN (recagost.stopa_popusta_pos) INTO stopa_popusta_pos_l
    FROM t_gosti gost,
         trec_agostiju recagost,
         m_msegmenti ms
   WHERE gost.id = gost_id_p
     AND gost.recagost_id = recagost.id
     AND recagost.oznaka = 'V'
     AND gost.ms_id = ms.id
     AND (
         ms.ozn_loyalty = -1
         OR
         -- Oznaka vrste programa vjernosti
         pra_zmp_zaj.zmppar_vrijednost ('LOY', '1017') NOT IN ('LIS', 'BECRM') -- IRN 4108
         );

  RETURN stopa_popusta_pos_l;

END;
FUNCTION STANJE_SUBVENCIJE
 (DATUM_P IN tpka_kar_rnk.datum%TYPE
 ,PKAKAR_DAT_POC_P IN tpka_kartice.dat_poc%TYPE
 ,PKAKAR_DAT_ZAV_P IN tpka_kartice.dat_zav%TYPE
 ,PKAADR_ID_P IN tpka_kartice.pkaadr_id%TYPE
 ,NAC_ID_P IN tpka_kar_rnk.nac_id%TYPE
 )
 RETURN tpka_kar_rnk.iznos%TYPE
 IS
/*
IRN 3623
poziva se iz procedure pra_pos_pka.provjeri_limit_objekt, te procedura paketa
pra_pka_api: hnb_vrati_stanje, hnb_insert_pkakarrnk i hnb_update_pkakarrnk
*/

  izn_limita_l  tpka_kar_rnk.iznos%TYPE;
  dat_poc_god_l tpka_kartice.dat_poc%TYPE;
  mj_poc_l NUMBER;
  mj_zav_l NUMBER;
  pkakarrnk_izn_popusta_l tpka_kartice.izn_odobren%TYPE;
  pkarnk_izn_popusta_l    tpka_kartice.izn_odobren%TYPE;
BEGIN
  IF datum_p IS NULL
    OR pkaadr_id_p IS NULL
    OR nac_id_p IS NULL
  THEN
    RETURN 0;
  END IF;

  -- Iznos subvencije (mjeseno u domaoj valuti)
  BEGIN
    izn_limita_l := pra_pka_zaj.vrijednost_parametra ('1080');
  EXCEPTION
    WHEN OTHERS THEN
      -- Provjerite vrijednost #0 parametra #1!
      pra_zmp_zaj.vrati_poruku (-20100, 'PKA', '1080');
  END;

  dat_poc_god_l := TRUNC (datum_p, 'RRRR');

  IF pkakar_dat_poc_p IS NULL OR pkakar_dat_poc_p < dat_poc_god_l THEN
    mj_poc_l := 1;
  ELSE
    mj_poc_l := TO_NUMBER (TO_CHAR (pkakar_dat_poc_p, 'MM'));
  END IF;
  IF pkakar_dat_zav_p IS NULL OR pkakar_dat_zav_p > datum_p THEN
    mj_zav_l := TO_NUMBER (TO_CHAR (datum_p, 'MM'));
  ELSE
    mj_zav_l := TO_NUMBER (TO_CHAR (pkakar_dat_zav_p, 'MM')); -- dat_zav = datum_p
  END IF;

  IF mj_zav_l < mj_poc_l THEN -- ovo se ne bi smjelo dogoditi
    RETURN 0; -- izlaz
  END IF;

  izn_limita_l := izn_limita_l * (mj_zav_l - mj_poc_l + 1);

  -- iskoriteni iznos subvencije (itaju se sve kartice promatranog zaposlenika)
  SELECT SUM (NVL (pkakarrnk.izn_popusta, 0)) INTO pkakarrnk_izn_popusta_l
    FROM tpka_kar_rnk pkakarrnk,
         tpka_kartice pkakar
   WHERE pkakarrnk.pkakar_id = pkakar.id
     AND pkakar.pkaadr_id = pkaadr_id_p
     AND pkakarrnk.datum BETWEEN dat_poc_god_l AND LAST_DAY (datum_p)
     AND pkakarrnk.nac_id = nac_id_p
     AND pkakarrnk.oznaka = 2; -- 2 = koritenje

  -- iskoriteni iznos subvencije (interni raun)
  SELECT SUM (NVL (izn_popusta, 0)) INTO pkarnk_izn_popusta_l
    FROM tpka_rnkasa
   WHERE pkaadr_id = pkaadr_id_p
     AND datum BETWEEN dat_poc_god_l AND LAST_DAY (datum_p)
     AND nac_id = nac_id_p;

  RETURN (izn_limita_l - NVL (pkakarrnk_izn_popusta_l, 0) - NVL (pkarnk_izn_popusta_l, 0));
END;
PROCEDURE UPDATE_NAPOJNICA
 (ZMPOJR_ID_P IN mzmp_ojr.id%TYPE
 ,PKARNK_ID_P IN tpka_rnkasa.id%TYPE
 ,VPLA_NAPOJNICE_ID_P IN tpka_rnkasa.vpla_napojnice_id%TYPE
 ,IZN_NAPOJNICE_P IN tpka_rnkasa.izn_napojnice%TYPE
 ,DAT_FNAPOJNICE_P IN tpka_rnkasa.dat_fnapojnice%TYPE
 ,ROWCOUNT_P OUT NUMBER
 )
 IS
-- IRN 3785
  command_l VARCHAR2(2000);
  cvor_l    VARCHAR2(21);
  centar_l  VARCHAR2(21);
BEGIN

  IF pkarnk_id_p IS NULL THEN
    RETURN;
  END IF;

  pkapro_opis_m :=
    SUBSTR (
      'update_napojnica: zmpojr_id_p ' || zmpojr_id_p ||
        ', pkarnk_id_p ' || pkarnk_id_p ||
        ', vpla_napojnice_id_p ' || vpla_napojnice_id_p ||
        ', izn_napojnice_p ' || izn_napojnice_p ||
        ', dat_fnapojnice_p ' || TO_CHAR (dat_fnapojnice_p, 'DD.MM.RRRR') ,
      1,
      2000);

  pra_pka_iud.puni_pkapro (
    zmpsus_sifra_p  => 'PKA',
    zmpvpro_sifra_p => '0004', -- Veza POS - PKA (pra_pos_pka)
    pkapro_opis_p   => pkapro_opis_m,
    ozn_vaznosti_p  => -1);

  IF zmpojr_tekuceg_cvora (zmpojr_id_p) THEN
    pra_pos_pka.update_napojnica_objekt (
      zmpojr_id_p, pkarnk_id_p, vpla_napojnice_id_p, izn_napojnice_p, dat_fnapojnice_p, rowcount_p);
  ELSE
    command_l :=
      'BEGIN ' ||
      '  pra_pos_pka.update_napojnica<CVOR> ( ' ||
      '    :zmpojr_id_p, :pkarnk_id_p, :vpla_napojnice_id_p, :izn_napojnice_p, :dat_fnapojnice_p, ' ||
      '    :rowcount_p); ' ||
      'END;';

    IF pra_zmp_zaj.centar = -1 THEN
      cvor_l := zmpojr_cvor (zmpojr_id_p);
      EXECUTE IMMEDIATE REPLACE (command_l, '<CVOR>', '_objekt' || cvor_l)
        USING zmpojr_id_p, pkarnk_id_p, vpla_napojnice_id_p, izn_napojnice_p, dat_fnapojnice_p,
              OUT rowcount_p;
    ELSE
      centar_l := cvor_centar;
      EXECUTE IMMEDIATE REPLACE (command_l, '<CVOR>', centar_l)
        USING zmpojr_id_p, pkarnk_id_p, vpla_napojnice_id_p, izn_napojnice_p, dat_fnapojnice_p,
              OUT rowcount_p;
    END IF;
  END IF;
EXCEPTION
  WHEN OTHERS THEN
    pra_pka_iud.puni_pkapro (
      zmpsus_sifra_p  => 'PKA',
      zmpvpro_sifra_p => '0004', -- Veza POS - PKA (pra_pos_pka)
      pkapro_opis_p   => SUBSTR (pkapro_opis_m || ', rowcount_p ' || rowcount_p || ' ' || SQLCODE || ' ' || SQLERRM, 1, 2000),
      ozn_vaznosti_p  => 0);
    RAISE;
END;
PROCEDURE UPDATE_NAPOJNICA_OBJEKT
 (ZMPOJR_ID_P IN mzmp_ojr.id%TYPE
 ,PKARNK_ID_P IN tpka_rnkasa.id%TYPE
 ,VPLA_NAPOJNICE_ID_P IN tpka_rnkasa.vpla_napojnice_id%TYPE
 ,IZN_NAPOJNICE_P IN tpka_rnkasa.izn_napojnice%TYPE
 ,DAT_FNAPOJNICE_P IN tpka_rnkasa.dat_fnapojnice%TYPE
 ,ROWCOUNT_P OUT NUMBER
 )
 IS
-- IRN 3785
BEGIN
  rowcount_p := 0;

  IF pkarnk_id_p IS NULL THEN
    RETURN;
  END IF;

  UPDATE tpka_rnkasa
     SET izn_napojnice     = izn_napojnice_p,
         vpla_napojnice_id = vpla_napojnice_id_p,
         dat_fnapojnice    = dat_fnapojnice_p
   WHERE id = pkarnk_id_p;

  rowcount_p := SQL%ROWCOUNT;
END;
PROCEDURE PROVJERI_LIMIT_OBJEKT
 (PKAADR_ID_P IN tpka_kartice.pkaadr_id%TYPE
 ,PKAKAR_ID_P IN tpka_kartice.id%TYPE
 ,NAC_ID_P IN tpka_kartice.nac_id%TYPE
 ,DATUM_P IN DATE := SYSDATE
 ,METCVOR_SIFRA_P IN smet_cvorovi.sifra%TYPE
 ,OZNAKA_P OUT NUMBER
 ,IZNOS_P OUT tpka_kar_rnk.iznos%TYPE
 ,IZNOS2_P OUT tpka_kar_rnk.iznos%TYPE
 )
 IS
/*
IRN 2766
Vrijednost PKA parametra 1080 je godinji limit.
Procedura vraa za poslanu adresu (PKAADR_ID_P), nain potronje (NAC_ID_P) i godinu (GODINA_P):
OZNAKA_P -> -1 = limit postoji ili 0 = limit ne postoji
IZNOS_P -> stanje subvencije (= doputeni iznos popusta) prije kupovine

IRN 3605
Vrijednost PKA parametra 1080 je mjeseni limit.
Procedura vraa za poslanu adresu (PKAADR_ID_P), nain potronje (NAC_ID_P) i datum (DATUM_P):
OZNAKA_P -> -1 = limit postoji ili 0 = limit ne postoji
IZNOS_P -> stanje subvencije (= doputeni iznos popusta) prije kupovine

IRN 3771
Vrijednost PKA parametra 1080 je nebitno, a godinji limit upisan je u karticu.
Procedura vraa za poslanu karticu (PKAKAR_ID_P), nain potronje (NAC_ID_P) i datum (DATUM_P):
OZNAKA_P -> -1 = limit postoji ili 0 = limit ne postoji
IZNOS_P -> stanje limita (= doputeni iznos) prije kupovine

IRN 3864
Vrijednost parametra pkaadr_id_p moe biti NULL, a kartica ne mora biti povezana na adresu
odnosno tpka_kartice.pkaadr_id moe biti NULL jer je kartica povezana na npr. agenciju
(kao to jesu kartice zaposlenika u Aminessu).

IRN 4015
Dodan OUT parametar iznos2_p
*/
  datum_l DATE; -- IRN 3605
  br_redaka_l NUMBER;
  CURSOR pkakar_c IS
    SELECT dat_poc, dat_zav, izn_limita2 -- IRN 3771
      FROM tpka_kartice
     WHERE oznaka = 'V'
       AND (pkaadr_id_p IS NULL OR pkaadr_id = pkaadr_id_p) -- IRN 3864
       AND (pkakar_id_p IS NULL OR id = pkakar_id_p)
       -- IRN 3605; kartica je vaea
       AND (dat_poc IS NULL OR dat_poc <= datum_l)
       AND (dat_zav IS NULL OR dat_zav >= datum_l)
     ORDER BY id DESC;
  dat_poc_l tpka_kartice.dat_poc%TYPE;
  dat_zav_l tpka_kartice.dat_zav%TYPE;
  izn_limita2_l tpka_kartice.izn_limita2%TYPE; -- IRN 3771
BEGIN
  IF (pkaadr_id_p IS NULL AND pkakar_id_p IS NULL) -- IRN 3771
    OR nac_id_p IS NULL
    OR pra_pka_zaj.vrijednost_parametra ('1079') = 'nebitno' -- ifre limitiranih naina potronje
    -- IRN 3771; OR pra_pka_zaj.vrijednost_parametra ('1080') = 'nebitno' -- Iznos limita (mjeseno u domaoj valuti)
  THEN
    oznaka_p := 0; -- limit ne postoji
    RETURN; -- izlaz
  END IF;

  -- IRN 3605
  datum_l := NVL (datum_p, SYSDATE);

  SELECT COUNT (1) INTO br_redaka_l
    FROM m_nacpot
   WHERE id = nac_id_p
     AND zmp_zaj.string_in_list (sifra, pra_pka_zaj.vrijednost_parametra ('1079')) = -1; -- IRN 3771
  IF br_redaka_l = 0 THEN
    -- poslani nain potronje nije limitiran
    oznaka_p := 0;
    RETURN; -- izlaz
  END IF;

  IF pkaadr_id_p IS NOT NULL THEN -- IRN 3771
    -- provjeri postoji li adresa na tekuem voru
    SELECT COUNT (1) INTO br_redaka_l
      FROM mpka_adrese
     WHERE id = pkaadr_id_p;
    IF br_redaka_l = 0 THEN -- nema adrese na tekuem voru
      oznaka_p := -1;
      iznos_p := 0;
      RETURN; -- izlaz
    END IF;
  END IF;

  -- poetak i zavretak (zaposlenja) upisan je u Pay Card
  OPEN pkakar_c;
  FETCH pkakar_c INTO dat_poc_l, dat_zav_l, izn_limita2_l;
  IF pkakar_c%NOTFOUND THEN -- zaposlenik nema karticu
    CLOSE pkakar_c;
    oznaka_p := -1;
    iznos_p := 0;
    RETURN; -- izlaz
  END IF;
  CLOSE pkakar_c;

  IF pra_pka_zaj.vrijednost_parametra ('1080') = 'nebitno' THEN -- Iznos limita (mjeseno u domaoj valuti)
     -- IRN 3771
    IF izn_limita2_l IS NULL THEN
      oznaka_p := 0; -- limit ne postoji
    ELSE
      oznaka_p := -1;
      iznos_p := pra_pos_pka.stanje_limita2 (pkakar_id_p, datum_l, izn_limita2_l);
    END IF;
    -- KRAJ IRN 3771
  ELSE
    oznaka_p := -1;
    iznos_p := pra_pos_pka.stanje_subvencije (datum_l, dat_poc_l, dat_zav_l, pkaadr_id_p, nac_id_p); -- IRN 3623
    iznos2_p := pra_pos_pka.stanje_subvencije2 (datum_l, pkaadr_id_p, nac_id_p); -- IRN 4015
  END IF;

END;
FUNCTION STANJE_LIMITA2
 (PKAKAR_ID_P IN tpka_kar_rnk.pkakar_id%TYPE
 ,DATUM_P IN tpka_kar_rnk.datum%TYPE
 ,IZN_LIMITA2_P IN tpka_kartice.izn_limita2%TYPE
 )
 RETURN NUMBER
 IS
/*
IRN 3771; doputeni iznos prije kupovine
poziva se iz procedure pra_pos_pka.provjeri_limit_objekt i modula pka2130.fmb - Pay Card
*/

  iznos_l NUMBER;
BEGIN
  IF pkakar_id_p IS NULL     -- kartica
    OR datum_p IS NULL       -- datum rauna
    OR izn_limita2_p IS NULL -- godinji limit upisan na kartici
    OR pra_pka_zaj.vrijednost_parametra ('1079') = 'nebitno' -- ifre limitiranih naina potronje
  THEN
    RETURN 0;
  END IF;

  -- iskoriteni iznos (= iznos rauna)
  SELECT SUM (izn_rnk) INTO iznos_l -- IRN 3864
    FROM tpka_kar_rnk
   WHERE pkakar_id = pkakar_id_p
     AND datum BETWEEN TRUNC (datum_p, 'RRRR') AND datum_p
     AND nac_id IN (
         SELECT id
           FROM m_nacpot
          WHERE zmp_zaj.string_in_list (sifra, pra_pka_zaj.vrijednost_parametra ('1079')) = -1
         )
     AND oznaka = 2; -- 2 = koritenje

  RETURN (izn_limita2_p - NVL (iznos_l, 0));
END;
PROCEDURE UPDATE_RACUN
 (PKARNK_ID_P IN tpka_rnkasa.id%TYPE
 ,VPLA_ID_NEW_P IN tpka_rnkasa.vpla_id%TYPE
 ,VPLA2_ID_NEW_P IN tpka_rnkasa.vpla2_id%TYPE
 ,VPLA_NAPOJNICE_ID_NEW_P IN tpka_rnkasa.vpla_napojnice_id%TYPE
 ,ROWCOUNT_P OUT NUMBER
 )
 IS
-- IRN 3932; promjena kartine vrste plaanja POS rauna

  CURSOR pkarnk_c IS
    SELECT vppla.sifra,
           vppla2.sifra,
           vppla_napojnice.sifra
      FROM tpka_rnkasa pkarnk,
           s_vplacanja vpla, s_vpplacanja vppla,
           s_vplacanja vpla2, s_vpplacanja vppla2,
           s_vplacanja vpla_napojnice, s_vpplacanja vppla_napojnice
     WHERE pkarnk.id = pkarnk_id_p
       AND pkarnk.vpla_id = vpla.id
       AND vpla.vppla_id = vppla.id
       AND pkarnk.vpla2_id = vpla2.id (+)
       AND vpla2.vppla_id = vppla2.id (+)
       AND pkarnk.vpla_napojnice_id = vpla_napojnice.id (+)
       AND vpla_napojnice.vppla_id = vppla_napojnice.id (+);

  vppla_sifra_old_l s_vpplacanja.sifra%TYPE;
  vppla_sifra2_old_l s_vpplacanja.sifra%TYPE;
  vppla_sifra_napojnice_old_l s_vpplacanja.sifra%TYPE;

  vpla_id_new_l tpka_rnkasa.vpla_id%TYPE;
  vpla2_id_new_l tpka_rnkasa.vpla2_id%TYPE;
  vpla_napojnice_id_new_l tpka_rnkasa.vpla_napojnice_id%TYPE;

  CURSOR vpla_c (vpla_id_k tpka_rnkasa.vpla_id%TYPE) IS
    SELECT vppla.sifra
      FROM s_vplacanja vpla, s_vpplacanja vppla
     WHERE vpla.id = vpla_id_k
       AND vpla.vppla_id = vppla.id;

  vppla_sifra_l s_vpplacanja.sifra%TYPE;
BEGIN

  rowcount_p := 0;

  IF pkarnk_id_p IS NULL
    OR (vpla_id_new_p IS NULL AND vpla2_id_new_p IS NULL AND vpla_napojnice_id_new_p IS NULL)
  THEN
    RETURN;
  END IF;

  pkapro_opis_m :=
    'update_racun: pkarnk_id_p ' || pkarnk_id_p ||
      ', vpla_id_new_p ' || vpla_id_new_p ||
      ', vpla2_id_new_p ' || vpla2_id_new_p ||
      ', vpla_napojnice_id_new_p ' || vpla_napojnice_id_new_p;

  pra_pka_iud.puni_pkapro (
    zmpsus_sifra_p  => 'PKA',
    zmpvpro_sifra_p => '0004', -- Veza POS - PKA (pra_pos_pka)
    pkapro_opis_p   => SUBSTR (pkapro_opis_m, 1, 2000),
    ozn_vaznosti_p  => -1);

  OPEN pkarnk_c;
  FETCH pkarnk_c INTO vppla_sifra_old_l, vppla_sifra2_old_l, vppla_sifra_napojnice_old_l;
  CLOSE pkarnk_c;

  IF vppla_sifra_old_l IS NULL
    AND vppla_sifra2_old_l IS NULL
    AND vppla_sifra_napojnice_old_l IS NULL
  THEN
    RETURN;
  END IF;

  vpla_id_new_l := NULL;
  IF vpla_id_new_p IS NOT NULL
    AND vppla_sifra_old_l IS NOT NULL
    AND vppla_sifra_old_l = 'K'
  THEN
    vppla_sifra_l := NULL;
    OPEN vpla_c (vpla_id_new_p);
    FETCH vpla_c INTO vppla_sifra_l;
    CLOSE vpla_c;
    IF vppla_sifra_l IS NOT NULL AND vppla_sifra_l = 'K' THEN
      vpla_id_new_l := vpla_id_new_p;
    END IF;
  END IF;

  vpla2_id_new_l := NULL;
  IF vpla2_id_new_p IS NOT NULL
    AND vppla_sifra2_old_l IS NOT NULL
    AND vppla_sifra2_old_l = 'K'
  THEN
    vppla_sifra_l := NULL;
    OPEN vpla_c (vpla2_id_new_p);
    FETCH vpla_c INTO vppla_sifra_l;
    CLOSE vpla_c;
    IF vppla_sifra_l IS NOT NULL AND vppla_sifra_l = 'K' THEN
      vpla2_id_new_l := vpla2_id_new_p;
    END IF;
  END IF;

  vpla_napojnice_id_new_l := NULL;
  IF vpla_napojnice_id_new_p IS NOT NULL
    AND vppla_sifra_napojnice_old_l IS NOT NULL
    AND vppla_sifra_napojnice_old_l = 'K'
  THEN
    vppla_sifra_l := NULL;
    OPEN vpla_c (vpla_napojnice_id_new_p);
    FETCH vpla_c INTO vppla_sifra_l;
    CLOSE vpla_c;
    IF vppla_sifra_l IS NOT NULL AND vppla_sifra_l = 'K' THEN
      vpla_napojnice_id_new_l := vpla_napojnice_id_new_p;
    END IF;
  END IF;

  IF vpla_id_new_l IS NULL
    AND vpla2_id_new_l IS NULL
    AND vpla_napojnice_id_new_l IS NULL
  THEN
    RETURN;
  END IF;

  UPDATE tpka_rnkasa
     SET vpla_id           = NVL (vpla_id_new_l, vpla_id),
         vpla2_id          = NVL (vpla2_id_new_l, vpla2_id),
         vpla_napojnice_id = NVL (vpla_napojnice_id_new_l, vpla_napojnice_id)
   WHERE id = pkarnk_id_p;

  rowcount_p := SQL%ROWCOUNT;

EXCEPTION
  WHEN OTHERS THEN
    pra_pka_iud.puni_pkapro (
      zmpsus_sifra_p  => 'PKA',
      zmpvpro_sifra_p => '0004', -- Veza POS - PKA (pra_pos_pka)
      pkapro_opis_p   => SUBSTR (pkapro_opis_m || ', rowcount_p ' || rowcount_p || ' ' || SQLCODE || ' ' || SQLERRM, 1, 2000),
      ozn_vaznosti_p  => 0);
    RAISE;
END;
FUNCTION STANJE_SUBVENCIJE2
 (DATUM_P IN tpka_kar_rnk.datum%TYPE
 ,PKAADR_ID_P IN tpka_kartice.pkaadr_id%TYPE
 ,NAC_ID_P IN tpka_kar_rnk.nac_id%TYPE
 )
 RETURN tpka_kar_rnk.izn_popusta2%TYPE
 IS
/*
IRN 4015
poziva se iz procedure pra_pos_pka.provjeri_limit_objekt, te procedura paketa
pra_pka_api: hnb_vrati_stanje, hnb_insert_pkakarrnk i hnb_update_pkakarrnk
*/

  izn_subvencije2_l        tpka_kar_rnk.izn_popusta2%TYPE;
  pkakarrnk_izn_popusta2_l tpka_kar_rnk.izn_popusta2%TYPE;
  pkarnk_izn_popusta2_l    tpka_rnkasa.izn_popusta2%TYPE;
BEGIN
  IF datum_p IS NULL
    OR pkaadr_id_p IS NULL
    OR nac_id_p IS NULL
    OR pra_pka_zaj.vrijednost_parametra ('1096') = 'nebitno' -- Iznos oporezive neprenosive subvencije (mjeseno u domaoj valuti)
  THEN
    RETURN 0;
  END IF;

  -- Iznos oporezive neprenosive subvencije (mjeseno u domaoj valuti)
  BEGIN
    izn_subvencije2_l := pra_pka_zaj.vrijednost_parametra ('1096');
  EXCEPTION
    WHEN OTHERS THEN
      -- Provjerite vrijednost #0 parametra #1!
      pra_zmp_zaj.vrati_poruku (-20100, 'PKA', '1096');
  END;

  -- iskoriteni iznos subvencije 2 (itaju se sve kartice promatranog zaposlenika)
  SELECT SUM (NVL (pkakarrnk.izn_popusta2, 0)) INTO pkakarrnk_izn_popusta2_l
    FROM tpka_kar_rnk pkakarrnk,
         tpka_kartice pkakar
   WHERE pkakarrnk.pkakar_id = pkakar.id
     AND pkakar.pkaadr_id = pkaadr_id_p
     AND pkakarrnk.datum BETWEEN TRUNC (datum_p, 'MM') AND LAST_DAY (datum_p)
     AND pkakarrnk.nac_id = nac_id_p
     AND pkakarrnk.oznaka = 2; -- 2 = koritenje

  -- iskoriteni iznos subvencije 2 (interni raun)
  SELECT SUM (NVL (izn_popusta2, 0)) INTO pkarnk_izn_popusta2_l
    FROM tpka_rnkasa
   WHERE pkaadr_id = pkaadr_id_p
     AND datum BETWEEN TRUNC (datum_p, 'MM') AND LAST_DAY (datum_p)
     AND nac_id = nac_id_p;

  RETURN (izn_subvencije2_l - NVL (pkakarrnk_izn_popusta2_l, 0) - NVL (pkarnk_izn_popusta2_l, 0));
END;

END PRA_POS_PKA;
/
SHOW ERROR

