PROMPT Creating Package Body 'PRA_PKA_S3'
CREATE OR REPLACE PACKAGE BODY PRA_PKA_S3 IS

FUNCTION IZN_FTECAJA
 RETURN s_valute.izn_tecaja%TYPE
 IS
-- IRN 3516; fiksni teaj konverzije HRK u EUR
  izn_tecaja_l s_valute.izn_tecaja%TYPE;
BEGIN
  SELECT MAX (izn_tecaja) INTO izn_tecaja_l
    FROM s_vlasnik; -- IRN 3541

  RETURN (izn_tecaja_l);
END;
FUNCTION IZN_ITECAJA
 (DATUM_P IN tpka_tecajnice.datum%TYPE
 ,IZN_TECAJA_P IN NUMBER
 )
 RETURN tpka_tec_val.izn_tecaja%TYPE
 IS
-- IRN 3531; iznos teaja za izraun ovisno o datumu
  CURSOR vla_c IS
    SELECT dat_primjene_domval, ozn_tecaja, ozn_tecaja0
      FROM s_vlasnik;
  vla_c_l vla_c%ROWTYPE;
  izn_tecaja_l tpka_tec_val.izn_tecaja%TYPE;
BEGIN
  IF datum_p IS NULL
    OR izn_tecaja_p IS NULL
  THEN
    RETURN (NULL);
  END IF;

  IF izn_tecaja_p = 0 THEN
    RETURN (0);
  END IF;

  OPEN vla_c;
  FETCH vla_c INTO vla_c_l;
  CLOSE vla_c;

  IF datum_p >= vla_c_l.dat_primjene_domval THEN
    -- provjeri oznaku teaja domae valute
    IF vla_c_l.ozn_tecaja = -1 THEN -- dijeli
      izn_tecaja_l := ROUND (1 / izn_tecaja_p, 14);
    ELSE
      izn_tecaja_l := izn_tecaja_p;
    END IF;
  ELSE
    -- provjeri oznaku teaja "prethodne" domae valute
    IF vla_c_l.ozn_tecaja0 = -1 THEN -- dijeli
      izn_tecaja_l := ROUND (1 / izn_tecaja_p, 14);
    ELSE
      izn_tecaja_l := izn_tecaja_p;
    END IF;
  END IF;

  RETURN (izn_tecaja_l);

END;
PROCEDURE VRATI_IZN_TECAJA
 (VAL_ID_P IN s_valute.id%TYPE
 ,BAN_ID_P IN m_banke.id%TYPE
 ,VTEC_ID_P IN s_vtecajeva.id%TYPE
 ,DATUM_P IN tpka_tecajnice.datum%TYPE
 ,IZN_TECAJAT_P OUT tpka_tec_val.izn_tecajat%TYPE
 ,IZN_TECAJA_P OUT tpka_tec_val.izn_tecaja%TYPE
 )
 IS
-- IRN 3539; Za domau valutu procedura vraa iznos 1

  CURSOR vla_c IS
    SELECT domval0_id, domval_id, dat_primjene_domval
      FROM s_vlasnik;
  vla_c_l vla_c%ROWTYPE;

  datum_l DATE;
  jedinica_l s_valute.jedinica%TYPE;
  izn_tecajat_l trec_ponude2.izn_tecajat%TYPE;
  izn_tecaja_l  trec_ponude2.izn_tecaja%TYPE;

  CURSOR pkatecval_c IS
    SELECT tpka_tec_val.izn_tecajat, tpka_tec_val.izn_tecaja
      FROM tpka_tec_val, tpka_tecajnice
     WHERE tpka_tecajnice.datum = datum_l -- IRN 2225
       AND tpka_tec_val.val_id = val_id_p
       AND tpka_tecajnice.ban_id = ban_id_p
       AND tpka_tecajnice.vtec_id = vtec_id_p
       AND tpka_tec_val.pkatec_id = tpka_tecajnice.id
     ORDER BY tpka_tecajnice.datum DESC;
BEGIN
  IF val_id_p IS NULL
    OR ban_id_p IS NULL
    OR vtec_id_p IS NULL
    OR datum_p IS NULL
  THEN
    izn_tecajat_p := NULL;
    izn_tecaja_p  := NULL;
    RETURN;
  END IF;

  OPEN vla_c;
  FETCH vla_c INTO vla_c_l;
  CLOSE vla_c;

  IF val_id_p = vla_c_l.domval_id AND datum_p >= vla_c_l.dat_primjene_domval
     OR
     val_id_p = vla_c_l.domval0_id AND datum_p < vla_c_l.dat_primjene_domval
  THEN
    izn_tecajat_p := 1;
    izn_tecaja_p  := 1;
    RETURN;
  END IF;

  SELECT /*+ index (TPKA_TEC_VAL PKATECVAL_UK) */
         MAX (tpka_tecajnice.datum) INTO datum_l
    FROM tpka_tec_val, tpka_tecajnice
   WHERE tpka_tecajnice.datum <= datum_p
     AND tpka_tec_val.val_id = val_id_p
     AND tpka_tecajnice.ban_id = ban_id_p
     AND tpka_tecajnice.vtec_id = vtec_id_p
     AND tpka_tec_val.pkatec_id = tpka_tecajnice.id;

  OPEN pkatecval_c;
  FETCH pkatecval_c INTO izn_tecajat_l, izn_tecaja_l;
  CLOSE pkatecval_c;

  IF datum_p < NVL (vla_c_l.dat_primjene_domval, datum_p) THEN
    SELECT jedinica INTO jedinica_l
      FROM s_valute
     WHERE id = val_id_p;
    izn_tecajat_p := izn_tecajat_l / jedinica_l;
    izn_tecaja_p  := izn_tecaja_l / jedinica_l;
  ELSE
    izn_tecajat_p := izn_tecajat_l;
    izn_tecaja_p  := izn_tecaja_l;
  END IF;

END;
FUNCTION IZN_TECAJA
 (VAL_ID_P IN s_valute.id%TYPE
 ,BAN_ID_P IN m_banke.id%TYPE
 ,VTEC_ID_P IN s_vtecajeva.id%TYPE
 ,DATUM_P IN tpka_tecajnice.datum%TYPE
 )
 RETURN trec_ponude2.izn_tecaja%TYPE
 IS
-- IRN 3539; Za domau valutu funkcija vraa iznos 1

  CURSOR vla_c IS
    SELECT domval0_id, domval_id, dat_primjene_domval
      FROM s_vlasnik;
  vla_c_l vla_c%ROWTYPE;

  datum_l DATE;
  jedinica_l s_valute.jedinica%TYPE;
  izn_tecaja_l trec_ponude2.izn_tecaja%TYPE;

  CURSOR pkatecval_c IS
    SELECT tpka_tec_val.izn_tecaja
      FROM tpka_tec_val, tpka_tecajnice
     WHERE tpka_tecajnice.datum = datum_l
       AND tpka_tec_val.val_id = val_id_p
       AND tpka_tecajnice.ban_id = ban_id_p
       AND tpka_tecajnice.vtec_id = vtec_id_p
       AND tpka_tec_val.pkatec_id = tpka_tecajnice.id
     ORDER BY tpka_tecajnice.datum DESC;
BEGIN
  IF val_id_p IS NULL
    OR ban_id_p IS NULL
    OR vtec_id_p IS NULL
    OR datum_p IS NULL
  THEN
    RETURN (NULL);
  END IF;

  OPEN vla_c;
  FETCH vla_c INTO vla_c_l;
  CLOSE vla_c;

  IF val_id_p = vla_c_l.domval_id AND datum_p >= vla_c_l.dat_primjene_domval
     OR
     val_id_p = vla_c_l.domval0_id AND datum_p < vla_c_l.dat_primjene_domval
  THEN
    RETURN 1;
  END IF;

  SELECT /*+ index (TPKA_TEC_VAL PKATECVAL_UK) */
         MAX (tpka_tecajnice.datum) INTO datum_l
    FROM tpka_tec_val, tpka_tecajnice
   WHERE tpka_tecajnice.datum <= datum_p
     AND tpka_tec_val.val_id = val_id_p
     AND tpka_tecajnice.ban_id = ban_id_p
     AND tpka_tecajnice.vtec_id = vtec_id_p
     AND tpka_tec_val.pkatec_id = tpka_tecajnice.id;

  OPEN pkatecval_c;
  FETCH pkatecval_c INTO izn_tecaja_l;
  IF pkatecval_c%NOTFOUND THEN
    CLOSE pkatecval_c;
    RETURN (NULL);
  END IF;
  CLOSE pkatecval_c;

  IF datum_p < NVL (vla_c_l.dat_primjene_domval, datum_p) THEN
    SELECT jedinica INTO jedinica_l
      FROM s_valute
     WHERE id = val_id_p;

    RETURN izn_tecaja_l / jedinica_l;
  ELSE
    RETURN izn_tecaja_l;
  END IF;

END;
FUNCTION NAPOMENA_2VAL
 (IZNOS_P IN NUMBER
 ,DATUM_P IN DATE := TRUNC (SYSDATE)
 ,DOMJEZ_SIFRA_P IN s_jezici.sifra_3a%TYPE := NULL
 )
 RETURN VARCHAR2
 IS
-- IRN 3539; vraa poruku PKA0349
-- SVEUKUPNO #0 #1 PO FIKSNOM TEAJU KONVERZIJE 1 EUR = 7,53450 HRK.
  CURSOR vla_c IS
    SELECT * FROM s_vlasnik;
  vla_c_l         vla_c%ROWTYPE;
  domval_sifra_l  s_valute.sifra_3a%TYPE;
BEGIN
  IF iznos_p IS NULL THEN -- iznos u domaoj valuti
    RETURN (NULL);
  END IF;

  OPEN vla_c;
  FETCH vla_c INTO vla_c_l;
  CLOSE vla_c;

  IF datum_p BETWEEN vla_c_l.dat_ispis_2val_poc AND vla_c_l.dat_ispis_2val_zav
    AND NVL (vla_c_l.izn_tecaja, 0) > 0
  THEN
    NULL;
  ELSE
    RETURN (NULL);
  END IF;

  IF datum_p >= vla_c_l.dat_primjene_domval THEN
    -- SVEUKUPNO 567,89 HRK PO FIKSNOM TEAJU KONVERZIJE 1 EUR = 7,53450 HRK.
    SELECT MIN (sifra_3a) INTO domval_sifra_l FROM s_valute WHERE id = vla_c_l.domval0_id;
    RETURN (
      pra_zmp_zaj.porjez (
        'PKA',
        'PKA0349',
        domjez_sifra_p,
        LTRIM (TO_CHAR (ROUND (iznos_p * vla_c_l.izn_tecaja, 2), '9G999G999G990D00')), -- ili vla_c_l.ozn_tecaja
        domval_sifra_l
        )
      );
  ELSE
    -- SVEUKUPNO 123,45 EUR PO FIKSNOM TEAJU KONVERZIJE 1 EUR = 7,53450 HRK.
    SELECT MIN (sifra_3a) INTO domval_sifra_l FROM s_valute WHERE id = vla_c_l.domval_id;
    RETURN (
      pra_zmp_zaj.porjez (
        'PKA',
        'PKA0349',
        domjez_sifra_p,
        LTRIM (TO_CHAR (ROUND (iznos_p / vla_c_l.izn_tecaja, 2), '9G999G999G990D00')), -- ili vla_c_l.ozn_tecaja0
        domval_sifra_l
        )
      );
  END IF;
END;
FUNCTION ERACUN_POSTOJI
 (RAC_ID_P IN t_racuni_blob.rac_id%TYPE
 ,PKARAC_ID_P IN t_racuni_blob.pkarac_id%TYPE
 )
 RETURN NUMBER
 IS
-- IRN 3650
  CURSOR racblob_c IS
    SELECT status
      FROM t_racuni_blob
     WHERE (
           (rac_id_p IS NOT NULL AND rac_id = rac_id_p)
           OR
           (pkarac_id_p IS NOT NULL AND pkarac_id = pkarac_id_p)
           )
       AND oznaka = 'xml'
     ORDER BY id DESC;
  status_l t_racuni_blob.status%TYPE;
BEGIN
  IF rac_id_p IS NULL
    AND pkarac_id_p IS NULL
  THEN
    RETURN 0; -- e-raun ne postoji
  END IF;

  OPEN racblob_c;
  FETCH racblob_c INTO status_l;
  IF racblob_c%NOTFOUND OR status_l = -1 THEN
    CLOSE racblob_c;
    RETURN 0;   -- e-raun ne postoji
  ELSE
    CLOSE racblob_c;
    RETURN -1;  -- e-raun postoji
  END IF;

END;
FUNCTION PKARNK_DOKUMENT
 (PKARNK_ID_P IN tpka_rnkasa.id%TYPE
 ,RAC_ID_P IN tpka_rnkasa.rac_id%TYPE
 ,PKARAC_ID_P IN tpka_rnkasa.pkarac_id%TYPE
 ,VPLA_ID_P IN tpka_rnkasa.vpla_id%TYPE
 ,VPLA2_ID_P IN tpka_rnkasa.vpla_id%TYPE
 ,VPLA_NAPOJNICE_ID_P IN tpka_rnkasa.vpla_napojnice_id%TYPE
 )
 RETURN VARCHAR2
 IS
-- IRN 3773; broj REC/PKA rauna/obrauna na kojem je zaraunat/obraunat interni POS raun
  dokument_l VARCHAR2(100);

  CURSOR pkaobr_c (
    vpla_id_k s_vplacanja.id%TYPE,
    ozn_napojnica_k tpka_obr_rac.ozn_napojnica%TYPE)
  IS
    SELECT 'PKA ' || pkaobr.god_poslovna || ' ' || pkaobr.rbr || ' ' || 'OB ' || oj.sifra
      FROM tpka_obr_rac pkaobrrac, tpka_obracuni pkaobr, m_oj oj
     WHERE pkaobrrac.pkaobr_id = pkaobr.id
       AND pkaobrrac.pkarnk_id = pkarnk_id_p
       AND pkaobrrac.id_vpla = vpla_id_k
       AND pkaobr.oznaka = 'V'
       AND pkaobr.zmpojr_id = oj.id
       AND pkaobrrac.ozn_napojnica = ozn_napojnica_k;
BEGIN

  IF rac_id_p IS NOT NULL THEN

    SELECT 'REC ' || rac.rbr || ' ' || rac.god_poslovna || ' ' || vapldok.oznaka || ' ' || oj.sifra
      INTO dokument_l
      FROM t_racuni rac, s_vapldok vapldok, m_oj oj
     WHERE rac.id = rac_id_p
       AND rac.vapldok_id = vapldok.id
       AND rac.oj_id = oj.id;

  ELSIF pkarac_id_p IS NOT NULL THEN

    SELECT 'PKA ' || pkarac.rbr || ' ' || pkarac.god_poslovna || ' ' || vapldok.oznaka || ' ' || oj.sifra
      INTO dokument_l
      FROM tpka_racuni pkarac, s_vapldok vapldok, m_oj oj
     WHERE pkarac.id = pkarac_id_p
       AND pkarac.vapldok_id = vapldok.id
       AND pkarac.oj_id = oj.id;

  ELSE

    /*
    u modulu pka2030 - Interni POS rauni treba ispisati broj obrauna za vpla2_id
    pa se vpla_id za taj sluaj ne proslijeuje
    */
    IF vpla_id_p IS NOT NULL THEN
      OPEN pkaobr_c (vpla_id_p, 0);
      FETCH pkaobr_c INTO dokument_l;
      CLOSE pkaobr_c;
    END IF;

    IF dokument_l IS NULL AND vpla2_id_p IS NOT NULL THEN
      OPEN pkaobr_c (vpla2_id_p, 0);
      FETCH pkaobr_c INTO dokument_l;
      CLOSE pkaobr_c;
    END IF;

    -- obraun napojnice
    IF dokument_l IS NULL AND vpla_napojnice_id_p IS NOT NULL THEN
      OPEN pkaobr_c (vpla_napojnice_id_p, -1);
      FETCH pkaobr_c INTO dokument_l;
      CLOSE pkaobr_c;
    END IF;

  END IF;

  RETURN dokument_l;
END;
FUNCTION GASRN_RBR
 (RN_ID_P IN t_rnkase.rn_id%TYPE
 ,ID_P IN t_rnkase.id%TYPE
 )
 RETURN VARCHAR2
 IS
-- IRN 3773; broj rauna koji/kojeg je ponitio promatrani raun
  CURSOR c1 IS
    -- Ponitio
    SELECT pra_zmp_zaj.poruka ('ZMP', 'III0149') || ' ' || rbr || ' ' || godina
      FROM t_rnkase
     WHERE id = rn_id_p;
  CURSOR c2 IS
    -- Poniten
    SELECT pra_zmp_zaj.poruka ('ZMP', 'III0148') || ' ' || rbr || ' ' || godina
      FROM t_rnkase
     WHERE rn_id = id_p;
  gasrn_rbr_l VARCHAR2(100);
BEGIN
  IF rn_id_p IS NOT NULL THEN
    OPEN c1;
    FETCH c1 INTO gasrn_rbr_l;
    CLOSE c1;
  ELSE
    OPEN c2;
    FETCH c2 INTO gasrn_rbr_l;
    CLOSE c2;
  END IF;
  RETURN gasrn_rbr_l;
END;
FUNCTION PP_PREAUTHORIZED_AMOUNT
 (GOST_ID_P IN t_gosti.id%TYPE
 )
 RETURN NUMBER
 IS
-- IRN 3869; predautoriziran iznos

CURSOR ppord_c IS
  SELECT SUM (NVL (ppord.amount, 0)) AS ppord_amount
    FROM tpp_orders ppord
   WHERE ppord.gost_id = gost_id_p
     AND ppord.authorization_type = 1 -- 1 = Preauthorization
     AND (ppord.status = 1 OR ppord.transaction_status = 'Approved') -- 1 = Preauthorized
     AND ppord.order_id NOT IN (
         SELECT ppord2.order_id
           FROM tpp_orders ppord2
          WHERE ppord2.order_id = ppord.order_id
            AND ppord2.authorization_type = 1 -- 1 = Preauthorization
            AND ppord2.status IN (3, 2) -- 3 = Voided, 2 = Completed
         UNION
         SELECT ppord2.order_id
           FROM tpp_orders ppord2
          WHERE ppord2.order_id = ppord.order_id
            AND ppord2.authorization_type = 3 -- 3 = Void
            AND ppord2.transaction_status = 'Approved');

  ppord_c_l ppord_c%ROWTYPE;
BEGIN

  OPEN ppord_c;
  FETCH ppord_c INTO ppord_c_l.ppord_amount;
  CLOSE ppord_c;

  RETURN (ppord_c_l.ppord_amount);

END;
FUNCTION PKAOBA_COUNT
 (NAZ_KORISNIKA_P IN tpka_obavijesti.naz_korisnika%TYPE
 )
 RETURN NUMBER
 IS
-- IRN 3977; poziva se iz ORDS endpointa /autonotify/check/

  br_redaka_l NUMBER;
BEGIN
  SELECT COUNT (*)
    INTO br_redaka_l
    FROM tpka_obavijesti
   WHERE ozn_dismiss = 0
     AND oznaka = 'V'
     AND ozn_vobavijesti = 'A' -- A = automatska
     AND (
         (naz_korisnika IS NULL AND gkor_id IS NULL)
         OR
         naz_korisnika = naz_korisnika_p
         OR
         gkor_id IN (SELECT gkor_id FROM m_korisnici WHERE naziv = naz_korisnika_p)
         )
     AND (dat_poc IS NULL OR dat_poc <= TRUNC (SYSDATE))
     AND (dat_zav IS NULL OR dat_zav >= TRUNC (SYSDATE));

  RETURN br_redaka_l;

END;
FUNCTION PRO_KPD_ID
 (PRO_SIFRA_P IN m_proizvodi.sif_proizvoda_kasa%TYPE
 )
 RETURN s_kpd.id%TYPE
 IS
-- IRN 4096; poziva se iz pra_eracun2
  kpd_id_l s_kpd.id%TYPE;
BEGIN
  IF pro_sifra_p IS NULL THEN
    RETURN (NULL);
  END IF;

  -- standardni proizvodi
  SELECT MIN (kpd_id) INTO kpd_id_l
    FROM m_proizvodi
   WHERE sif_proizvoda_kasa = pro_sifra_p;

  IF kpd_id_l IS NULL THEN
    -- nestandardni proizvodi
    SELECT MIN (kpd_id) INTO kpd_id_l
      FROM m_sif_grupa
     WHERE sif_proizvoda_kasa = pro_sifra_p;
  END IF;

  RETURN (kpd_id_l);
END;

END PRA_PKA_S3;
/
SHOW ERROR

