PROMPT Creating Package 'PRA_PKA_PAYPER'
CREATE OR REPLACE PACKAGE PRA_PKA_PAYPER IS

PPORD_ROW_G TPP_ORDERS%ROWTYPE;

PROCEDURE AZURIRAJ_PPORD
 (PPORD_ROW_P IN tpp_orders%ROWTYPE
 );
PROCEDURE PUNI_LOG
 (ENDPOINT_NAME_P IN VARCHAR2
 ,CLOB_P IN VARCHAR2
 ,SQLERRM_P IN VARCHAR2
 );
FUNCTION SIGNATURE
 (ENDPOINT_NAME_P IN VARCHAR2
 ,ORGANIZATION_CODE_P IN tpp_orders.organization_code%TYPE
 ,ORDER_ID_P IN tpp_orders.order_id%TYPE
 ,AMOUNT_P IN tpp_orders.amount%TYPE
 )
 RETURN VARCHAR2;
FUNCTION STRING2SHA512
 (INPUT_P IN VARCHAR2
 )
 RETURN VARCHAR2;
FUNCTION ZAJ_ORGANIZATION_CODE
 (SO_ID_P IN m_so.id%TYPE
 )
 RETURN tpp_orders.organization_code%TYPE;
FUNCTION ZAJ_SECRET_KEY
 (ORGANIZATION_CODE_P IN tpp_orders.organization_code%TYPE
 )
 RETURN VARCHAR2;
PROCEDURE ZAJ_SEND
 (ENDPOINT_P IN VARCHAR2
 ,METHOD_P IN VARCHAR2 := 'POST'
 );
PROCEDURE INIT_TERMINAL_TRANSACTION
 (ORDER_ID_P IN tpp_orders.order_id%TYPE
 ,ORGANIZATION_CODE_P IN tpp_orders.organization_code%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE
 ,RACNAP_ID_P IN t_rac_nap.id%TYPE := NULL
 ,PKARACNAP_ID_P IN tpka_rac_nap.id%TYPE := NULL
 ,MERCHANT_REFERENCE_ID_P IN tpp_orders.merchant_reference_id%TYPE
 ,TERMINAL_IDENTIFICATOR_P IN tpp_orders.terminal_identificator%TYPE
 ,LABEL_P IN VARCHAR2
 ,VALID_FOR_P IN NUMBER
 ,AMOUNT_P IN tpp_orders.amount%TYPE
 ,AUTHORIZATION_TYPE_P IN tpp_orders.authorization_type%TYPE
 ,RESPONSE_P OUT VARCHAR2
 ,PPORD_ID_P OUT tpp_orders.id%TYPE
 );
PROCEDURE CANCELLATION_TRANSACTION
 (ORDER_ID_P IN tpp_orders.order_id%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE
 ,RACNAP_ID_P IN t_rac_nap.id%TYPE := NULL
 ,PKARACNAP_ID_P IN tpka_rac_nap.id%TYPE := NULL
 ,TERMINAL_IDENTIFICATOR_P IN tpp_orders.terminal_identificator%TYPE
 ,ORGANIZATION_CODE_P IN tpp_orders.organization_code%TYPE
 ,AMOUNT_P IN tpp_orders.amount%TYPE
 ,RESPONSE_P OUT VARCHAR2
 ,PPORD_ID_P OUT tpp_orders.id%TYPE
 );
PROCEDURE CAPTURE_TRANSACTION
 (ORDER_ID_P IN tpp_orders.order_id%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE
 ,RACNAP_ID_P IN t_rac_nap.id%TYPE := NULL
 ,PKARACNAP_ID_P IN tpka_rac_nap.id%TYPE := NULL
 ,TRANSACTION_TOKEN_P IN tpp_orders.transaction_token%TYPE
 ,ORGANIZATION_CODE_P IN tpp_orders.organization_code%TYPE
 ,AMOUNT_P IN tpp_orders.amount%TYPE
 ,IME_P IN t_rezervacije.ime%TYPE
 ,PREZIME_P IN t_rezervacije.prezime%TYPE
 ,RESPONSE_P OUT VARCHAR2
 ,PPORD_ID_P OUT tpp_orders.id%TYPE
 );
PROCEDURE PROCESS_PAYMENT
 (ORDER_ID_P IN tpp_orders.order_id%TYPE
 ,ORGANIZATION_CODE_P IN tpp_orders.organization_code%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE
 ,RACNAP_ID_P IN t_rac_nap.id%TYPE := NULL
 ,PKARACNAP_ID_P IN tpka_rac_nap.id%TYPE := NULL
 ,MERCHANT_REFERENCE_ID_P IN tpp_orders.merchant_reference_id%TYPE
 ,AMOUNT_P IN tpp_orders.amount%TYPE
 ,TRANSACTION_TOKEN_P IN tpp_orders.transaction_token%TYPE
 ,AUTHORIZATION_TYPE_P IN tpp_orders.authorization_type%TYPE
 ,RESPONSE_P OUT VARCHAR2
 ,PPORD_ID_P OUT tpp_orders.id%TYPE
 );
PROCEDURE VOID
 (ORDER_ID_P IN tpp_orders.order_id%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE
 ,RACNAP_ID_P IN t_rac_nap.id%TYPE := NULL
 ,PKARACNAP_ID_P IN tpka_rac_nap.id%TYPE := NULL
 ,TRANSACTION_TOKEN_P IN tpp_orders.transaction_token%TYPE
 ,ORGANIZATION_CODE_P IN tpp_orders.organization_code%TYPE
 ,RESPONSE_P OUT VARCHAR2
 ,PPORD_ID_P OUT tpp_orders.id%TYPE
 );
PROCEDURE CREDIT
 (ORDER_ID_P IN tpp_orders.order_id%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE
 ,RACNAP_ID_P IN t_rac_nap.id%TYPE := NULL
 ,PKARACNAP_ID_P IN tpka_rac_nap.id%TYPE := NULL
 ,TRANSACTION_TOKEN_P IN tpp_orders.transaction_token%TYPE
 ,ORGANIZATION_CODE_P IN tpp_orders.organization_code%TYPE
 ,AMOUNT_P IN tpp_orders.amount%TYPE
 ,RESPONSE_P OUT VARCHAR2
 ,PPORD_ID_P OUT tpp_orders.id%TYPE
 );
PROCEDURE CREATE_ORDER
 (ORGANIZATION_CODE_P IN tpp_orders.organization_code%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 ,MERCHANT_REFERENCE_ID_P IN tpp_orders.merchant_reference_id%TYPE
 ,ORDER_TYPE_P IN tpp_orders.order_type%TYPE := 3
 ,AMOUNT_P IN tpp_orders.amount%TYPE := NULL
 ,DAT_ODLASKA_P IN t_rezervacije.dat_odlaska%TYPE
 ,NOTIFICATION_TYPE_P IN NUMBER
 ,JEZ_ID_P IN s_jezici.id%TYPE
 ,BR_UPUTNICE_P IN t_rezervacije.br_uputnice%TYPE
 ,IME_P IN t_rezervacije.ime%TYPE
 ,PREZIME_P IN t_rezervacije.prezime%TYPE
 ,EMAIL_P IN t_rezervacije.email%TYPE
 ,ZEM_ID_P IN s_zemlje.id%TYPE
 ,RESPONSE_P OUT VARCHAR2
 );
PROCEDURE CHECK_ORDER_INFORMATION
 (ORDER_ID_P IN tpp_orders.order_id%TYPE
 ,ORGANIZATION_CODE_P IN tpp_orders.organization_code%TYPE
 ,PPORD_ROW_P OUT tpp_orders%ROWTYPE
 );
PROCEDURE UPDATE_ORDER
 (ORDER_ID_P IN tpp_orders.order_id%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 ,MERCHANT_REFERENCE_ID_P IN tpp_orders.merchant_reference_id%TYPE
 ,ORGANIZATION_CODE_P IN tpp_orders.organization_code%TYPE
 ,AMOUNT_P IN tpp_orders.amount%TYPE
 ,DAT_ODLASKA_P IN t_rezervacije.dat_odlaska%TYPE
 ,RESPONSE_P OUT VARCHAR2
 );
PROCEDURE CANCEL_ORDER
 (ORDER_ID_P IN tpp_orders.order_id%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 ,MERCHANT_REFERENCE_ID_P IN tpp_orders.merchant_reference_id%TYPE
 ,ORGANIZATION_CODE_P IN tpp_orders.organization_code%TYPE
 ,MESSAGE_NOTIFICATION_P IN NUMBER
 ,RESPONSE_P OUT VARCHAR2
 );
PROCEDURE AZURIRAJ_REZ_TOKEN_STATUS
 (REZ_ID_P IN t_rezervacije.id%TYPE
 ,ORDER_TYPE_P IN tpp_orders.order_type%TYPE
 ,STATUS_P IN tpp_orders.status%TYPE
 );
PROCEDURE IZRADI_TKN_NALOGE
 (VLASNIKPODATKA_P IN NUMBER := NULL
 );
END PRA_PKA_PAYPER;
/
SHOW ERROR
