PROMPT Creating Package Body 'PRA_PKA_IUD'
CREATE OR REPLACE PACKAGE BODY PRA_PKA_IUD IS

PROCEDURE KOPIRAJ_PKAPLAN2SIZV
 (PKAPLAN2_ID_P IN TPKA_PLAN2.ID%TYPE
 ,OJ_ID_P IN TPKA_PLAN2_SIZV.OJ_ID%TYPE
 ,DAT_POC_2_P IN TPKA_PLAN2.DATUM%TYPE
 ,DAT_ZAV_2_P IN TPKA_PLAN2.DATUM%TYPE
 ,OJ_ID_2_P IN TPKA_PLAN2_SIZV.OJ_ID%TYPE
 )
 IS
/*
Kopiraj stavke plana za odabrani datum i oj (iz tpka_plan2_sizv)
u stavke plana za odabrano razdoblje i oj (u tpka_plan2_sizv)
*/
  datum_l DATE;
  CURSOR pkaplan2_c (datum_k tpka_plan2.datum%TYPE) IS
    SELECT id
      FROM tpka_plan2
     WHERE datum = datum_k;
  pkaplan2_id_2_l tpka_plan2.id%TYPE;
  br_redaka_l NUMBER;
BEGIN
  IF pra_zmp_zaj.centar = 0 THEN
    -- tablica tpka_plan2_sizv je replikacijska i moe se kopirati samo na centru
    RETURN;
  END IF;

  IF pkaplan2_id_p IS NULL  -- izvorni plan
    OR dat_poc_2_p IS NULL  -- poetak odredinog razdoblja
    OR dat_zav_2_p IS NULL  -- zavretak odredinog razdoblja
  THEN
    RETURN;
  END IF;

  -- ako je zadana izvorna OJ (oj_id_p) mora biti zadana i odredina OJ (oj_id_2_p)
  IF (oj_id_p IS NULL AND oj_id_2_p IS NOT NULL)
    OR (oj_id_p IS NOT NULL AND oj_id_2_p IS NULL)
  THEN
    RETURN;
  END IF;

  datum_l := dat_poc_2_p;
  WHILE datum_l <= dat_zav_2_p
  LOOP

    pkaplan2_id_2_l := NULL;

    OPEN pkaplan2_c (datum_l);
    FETCH pkaplan2_c INTO pkaplan2_id_2_l;
    CLOSE pkaplan2_c;

    IF pkaplan2_id_2_l IS NULL THEN
      -- puni zaglavlje
      pkaplan2_id_2_l := pra_zmp_zaj.i3_sekvenca (NULL);
      INSERT INTO tpka_plan2 (
          id,
          datum)
        VALUES (
          pkaplan2_id_2_l,
          datum_l);
    END IF;

    FOR pkaplan2sizv_c IN (
      SELECT oj_id,
             zmpsizv_id,
             planirano
        FROM tpka_plan2_sizv
       WHERE pkaplan2_id = pkaplan2_id_p
         AND (oj_id = oj_id_p OR oj_id_p IS NULL))
    LOOP
      SELECT COUNT (ROWID) INTO br_redaka_l
        FROM tpka_plan2_sizv
       WHERE pkaplan2_id = pkaplan2_id_2_l
         AND oj_id = NVL (oj_id_2_p, pkaplan2sizv_c.oj_id)
         AND zmpsizv_id = pkaplan2sizv_c.zmpsizv_id;
      IF br_redaka_l = 0 THEN
        -- puni stavke
        INSERT INTO tpka_plan2_sizv (
            pkaplan2_id,
            oj_id,
            zmpsizv_id,
            planirano)
          VALUES (
            pkaplan2_id_2_l,
            NVL (oj_id_2_p, pkaplan2sizv_c.oj_id),
            pkaplan2sizv_c.zmpsizv_id,
            pkaplan2sizv_c.planirano);
      END IF;
    END LOOP;

    datum_l := datum_l + 1;
  END LOOP;

  COMMIT;

END;
PROCEDURE KOPIRAJ_PKAPOKSIZV
 (PKAPOK_ID_P IN TPKA_POK_SIZV.PKAPOK_ID%TYPE
 ,OJ_ID_P IN TPKA_POK_SIZV.OJ_ID%TYPE
 ,DAT_POC_2_P IN TPKA_POKAZATELJI.DATUM%TYPE
 ,DAT_ZAV_2_P IN TPKA_POKAZATELJI.DATUM%TYPE
 ,OJ_ID_2_P IN TPKA_POK_SIZV.OJ_ID%TYPE
 )
 IS
/*
Kopiraj stavke pokazatelja uspjenosti za odabrani datum i oj (iz tpka_pok_spok)
u stavke pokazatelja uspjenosti za odabrano razdoblje i oj (u tpka_pok_spok)
*/
  datum_l DATE;
  CURSOR pkapok_c (datum_k tpka_pokazatelji.datum%TYPE) IS
    SELECT id
      FROM tpka_pokazatelji
     WHERE datum = datum_k;
  pkapok_id_2_l tpka_pokazatelji.id%TYPE;
  br_redaka_l NUMBER;
BEGIN
  IF pra_zmp_zaj.centar = 0 THEN
    -- tablica tpka_pok_spok je replikacijska i moe se kopirati samo na centru
    RETURN;
  END IF;

  IF pkapok_id_p IS NULL  -- izvorni plan
    OR dat_poc_2_p IS NULL  -- poetak odredinog razdoblja
    OR dat_zav_2_p IS NULL  -- zavretak odredinog razdoblja
  THEN
    RETURN;
  END IF;

  -- ako je zadana izvorna OJ (oj_id_p) mora biti zadana i odredina OJ (oj_id_2_p)
  IF (oj_id_p IS NULL AND oj_id_2_p IS NOT NULL)
    OR (oj_id_p IS NOT NULL AND oj_id_2_p IS NULL)
  THEN
    RETURN;
  END IF;

  datum_l := dat_poc_2_p;
  WHILE datum_l <= dat_zav_2_p
  LOOP

    pkapok_id_2_l := NULL;

    OPEN pkapok_c (datum_l);
    FETCH pkapok_c INTO pkapok_id_2_l;
    CLOSE pkapok_c;

    IF pkapok_id_2_l IS NULL THEN
      -- puni zaglavlje
      pkapok_id_2_l := pra_zmp_zaj.i3_sekvenca (NULL);
      INSERT INTO tpka_pokazatelji (
          id,
          datum)
        VALUES (
          pkapok_id_2_l,
          datum_l);
    END IF;

    FOR pkapoksizv_c IN (
      SELECT oj_id,
             zmpsizv_id,
             ostvareno
        FROM tpka_pok_sizv
       WHERE pkapok_id = pkapok_id_p
         AND (oj_id = oj_id_p OR oj_id_p IS NULL))
    LOOP
      SELECT COUNT (ROWID) INTO br_redaka_l
        FROM tpka_pok_sizv
       WHERE pkapok_id = pkapok_id_2_l
         AND oj_id = NVL (oj_id_2_p, pkapoksizv_c.oj_id)
         AND zmpsizv_id = pkapoksizv_c.zmpsizv_id;
      IF br_redaka_l = 0 THEN
        -- puni stavke
        INSERT INTO tpka_pok_sizv (
            pkapok_id,
            oj_id,
            zmpsizv_id,
            ostvareno)
          VALUES (
            pkapok_id_2_l,
            NVL (oj_id_2_p, pkapoksizv_c.oj_id),
            pkapoksizv_c.zmpsizv_id,
            pkapoksizv_c.ostvareno);
      END IF;
    END LOOP;

    datum_l := datum_l + 1;
  END LOOP;

  COMMIT;

END;
PROCEDURE PUNI_PKAADR
 (PKAADR_REC_P IN MPKA_ADRESE%ROWTYPE
 ,VADR_ID_P IN MPKA_ADR_VADR.VADR_ID%TYPE
 )
 IS
BEGIN
  INSERT INTO mpka_adrese VALUES pkaadr_rec_p; -- IRN 1786
  IF vadr_id_p IS NOT NULL THEN
    INSERT INTO mpka_adr_vadr (pkaadr_id, vadr_id)
      VALUES (pkaadr_rec_p.id, vadr_id_p);
  END IF;
  COMMIT;
END;
PROCEDURE AZURIRAJ_PKAKAR_IZN_POTROSEN
 (PKAKAR_ID_P IN tpka_kartice.id%TYPE
 ,IZNOS_P IN tpka_kar_rnk.iznos%TYPE
 )
 IS
-- Auriraj zbroj iznosa svih RNK plaenih karticom.
BEGIN
  UPDATE tpka_kartice
     SET izn_potrosen = NVL (izn_potrosen, 0) + NVL (iznos_p, 0)
   WHERE id = pkakar_id_p;
END;
PROCEDURE AZURIRAJ_IPKAKAR
 (PKAKAR_BROJ_P IN TPKA_KARTICE.BROJ%TYPE
 ,PKAKAR_OZN_IZVAN_OJ_P IN TPKA_KARTICE.OZN_IZVAN_OJ%TYPE
 ,PKAKAR_OZN_IZVAN_OJ_OLD_P IN TPKA_KARTICE.OZN_IZVAN_OJ%TYPE
 ,PKAKAR_PIN_P IN TPKA_KARTICE.PIN%TYPE
 ,PKAKAR_PIN_OLD_P IN TPKA_KARTICE.PIN%TYPE
 )
 IS
--
  cvor_centar_l VARCHAR2(21);
  cvor_tekuci_l smet_cvorovi.sifra%TYPE;
  naredba_l     VARCHAR2(2000);
  id_l          ipka_kartice.id%TYPE; -- IRN 3405
BEGIN

  IF pkakar_broj_p IS NULL
    OR pkakar_ozn_izvan_oj_p IS NULL
  THEN
    RETURN;
  END IF;

  IF INSERTING AND pkakar_ozn_izvan_oj_p IN (0) THEN
    -- Kartica se ne moe koristiti u drugim OJ
    RETURN;
  END IF;

  IF UPPER (pra_pka_zaj.vrijednost_parametra ('1037')) NOT IN ('DA') THEN
    -- Na tekuem voru ne izdaju se kartice koje se mogu koristiti u drugim OJ.
    RETURN;
  END IF;

  cvor_centar_l := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0018');
  IF cvor_centar_l IS NULL THEN
    -- Veza prema centralnom serveru nije definirana!
    pra_pka_zaj.vrati_poruku (-20074);
  END IF;

  cvor_tekuci_l := pra_zmp_zaj.tekuci_cvor;
  IF UPPER (cvor_centar_l) = 'NEBITNO'
    OR cvor_centar_l = cvor_tekuci_l
  THEN
    RETURN;
  END IF;

  IF NOT pra_rec_s.centar_connected (cvor_centar_l) THEN
    -- Veza prema centralnom serveru nije aktivna!
    pra_pka_zaj.vrati_poruku (-20075);
  END IF;

  cvor_centar_l := '@' || cvor_centar_l; -- IRN 3405

  IF INSERTING
    OR (pkakar_ozn_izvan_oj_old_p IN (0) AND pkakar_ozn_izvan_oj_p IN (-1))
  THEN

    -- IRN 3405
    naredba_l := REPLACE ('SELECT pra_zmp_zaj.i3_sekvenca<CVOR> (NULL) FROM dual', '<CVOR>', cvor_centar_l);
    EXECUTE IMMEDIATE naredba_l INTO id_l;
    -- KRAJ IRN 3405

    naredba_l :=
      'INSERT INTO ipka_kartice<CVOR> (id, metcvor_sifra, broj, pin)
         VALUES (:id_l, :cvor_tekuci_l, :pkakar_broj_p, :pkakar_pin_p)'; -- IRN 3405, dodani id i id_l
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_centar_l)
      USING id_l, cvor_tekuci_l, pkakar_broj_p, pkakar_pin_p;            -- IRN 3405, dodan id_l

    -- IRN 3405; Brii ostale zapise o kartici s brojem pkakar_broj_p
    IF SQL%ROWCOUNT > 0 THEN
      naredba_l :=
        'DELETE FROM ipka_kartice<CVOR>
          WHERE UPPER (broj) = UPPER (:pkakar_broj_p)
            AND id <> :id_l';
      EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_centar_l)
        USING pkakar_broj_p, id_l;
    END IF;
    -- KRAJ IRN 3405

  ELSIF UPDATING THEN
    IF pkakar_ozn_izvan_oj_p IN (-1) THEN
      naredba_l :=
        'UPDATE ipka_kartice<CVOR>
            SET pin = :pkakar_pin_p
          WHERE metcvor_sifra = :cvor_tekuci_l
            AND UPPER (broj) = UPPER (:pkakar_broj_p)
            AND NVL (pin, 0) = NVL (:pkakar_pin_old_p, 0)';
      EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_centar_l)
        USING cvor_tekuci_l, pkakar_broj_p, pkakar_pin_p, pkakar_pin_old_p;
    ELSIF pkakar_ozn_izvan_oj_old_p IN (-1) AND pkakar_ozn_izvan_oj_p IN (0) THEN
      naredba_l :=
        'DELETE FROM ipka_kartice<CVOR>
          WHERE metcvor_sifra = :cvor_tekuci_l
            AND UPPER (broj) = UPPER (:pkakar_broj_p)
            AND NVL (pin, 0) = NVL (:pkakar_pin_old_p, 0)';
      EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_centar_l)
        USING cvor_tekuci_l, pkakar_broj_p, pkakar_pin_old_p;
    END IF;
  END IF;

END;
PROCEDURE PUNI_PKAPRO
 (ZMPSUS_SIFRA_P IN SZMP_SUSTAVI.SIFRA%TYPE
 ,ZMPVPRO_SIFRA_P IN SZMP_VPROMJENA.SIFRA%TYPE
 ,PKAPRO_OPIS_P IN LPKA_PROMJENE.OPIS%TYPE
 ,OZN_VAZNOSTI_P IN NUMBER
 )
 IS
/*
Upis u tablicu lpka_promjene.
Ako je ulazni parametar ozn_vaznosti_p = Da, promjena e se zabiljeiti ako je
szmp_vpromjena.ozn_vaznosti = Da.
Ako je ulazni parametar ozn_vaznosti_p = Ne ili NULL, promjena e se zabiljeiti bez obzira na
vrijednost szmp_vpromjena.ozn_vaznosti.
*/

  PRAGMA AUTONOMOUS_TRANSACTION; -- IRN 1700

  CURSOR zmpvpro_c IS
    SELECT id, ozn_vaznosti
      FROM szmp_vpromjena
     WHERE zmpsus_id = (SELECT id FROM szmp_sustavi WHERE sifra = zmpsus_sifra_p)
       AND sifra = zmpvpro_sifra_p;
  zmpvpro_id_l szmp_vpromjena.id%TYPE;
  zmpvpro_ozn_vaznosti_l szmp_vpromjena.ozn_vaznosti%TYPE;
BEGIN
  OPEN zmpvpro_c;
  FETCH zmpvpro_c INTO zmpvpro_id_l, zmpvpro_ozn_vaznosti_l;
  CLOSE zmpvpro_c;
  IF NVL (ozn_vaznosti_p, 0) = 0 THEN
    zmpvpro_ozn_vaznosti_l := -1;
  END IF;
  IF zmpvpro_ozn_vaznosti_l = -1 THEN
    INSERT INTO lpka_promjene (
        zmpvpro_id,
        opis)
      VALUES (
        zmpvpro_id_l,
        DECODE (zmpvpro_id_l, NULL,
          SUBSTR ('ERR ' || NVL (zmpsus_sifra_p, '????') || ' ' || NVL (zmpvpro_sifra_p, '????') || ' ' || pkapro_opis_p, 1, 2000),
          pkapro_opis_p));
    COMMIT; -- IRN 1700
  END IF;
END;
PROCEDURE PREBACI_RN_PRED_IZBOR
 (RACUN_ROW_P IN TPKA_RACUNI%ROWTYPE
 ,KNJIGA_NA_P IN NUMBER
 ,NEISKORISTENO_P IN NUMBER
 ,RBR_P OUT TPKA_RACUNI.RBR%TYPE
 ,ID_P OUT TPKA_RACUNI.ID%TYPE
 )
 IS
--
  cvor_sa_l s_vlasnik.sifra_tekuceg_cvora%TYPE := UPPER (pra_zmp_zaj.tekuci_cvor);
  cvor_na_l s_vlasnik.sifra_tekuceg_cvora%TYPE;
  centar_l s_vlasnik.sifra_tekuceg_cvora%TYPE := UPPER (pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0018'));

  naredba_l VARCHAR2(30000);
  cvor_l s_vlasnik.sifra_tekuceg_cvora%TYPE;
  direktno_l NUMBER := 1;
  broj_stavaka_l NUMBER;
  izn_ostatka_l NUMBER := neiskoristeno_p;
  cijena_l NUMBER;
  rbr_l tpka_racuni.rbr%TYPE;
BEGIN

   SELECT UPPER (zmpojr.metcvor_sifra) INTO cvor_na_l
     FROM m_oj oj, mzmp_ojr zmpojr
    WHERE zmpojr.id = oj.id
      AND oj.id = knjiga_na_p;

   SELECT COUNT (id) INTO broj_stavaka_l FROM tpka_rac_isp WHERE pkarac_id = racun_row_p.id;

   pra_pka_iud.tpka_racuni_g := racun_row_p;

   pra_pka_iud.tpka_racuni_g.oj_id := knjiga_na_p;
   pra_pka_iud.tpka_racuni_g.oznaka := 'V';
   pra_pka_iud.tpka_racuni_g.iznos := neiskoristeno_p;
   -- finpred - IRN 2606
   -- predujam koji je generiran kod prebacivanja u PKA e dobiti finpred_id u BIR-u pozivom procedure za generiranje predujma u FIN
   pra_pka_iud.tpka_racuni_g.finpred_id_ponisteni :=  pra_pka_iud.tpka_racuni_g.finpred_id;
   pra_pka_iud.tpka_racuni_g.finpred_id := NULL;
   pra_pka_iud.tpka_racuni_g.finpred_uk := NULL;

   pra_pka_iud.tpka_racuni_g.pkarac_id := NULL;
   pra_pka_iud.tpka_racuni_g.rbr := NULL;
   -- pra_pka_iud.tpka_racuni_g.napomena := NULL;
   -- IRN 4096; korisnik je potreban za F2
   pra_pka_iud.tpka_racuni_g.unos_korisnik := zmp_zaj.korisnik (-1);
   pra_pka_iud.tpka_racuni_g.unos_dat := SYSDATE;
   -- KRAJ IRN 4096
   pra_pka_iud.tpka_racuni_g.izmjena_korisnik := NULL;
   pra_pka_iud.tpka_racuni_g.izmjena_dat := NULL;
   pra_pka_iud.tpka_racuni_g.pkaracd_id := NULL;
   pra_pka_iud.tpka_racuni_g.datum_za_n := NULL;
   -- pra_pka_iud.tpka_racuni_g.god_poslovna_za_n := NULL; -- IRN 1887
   pra_pka_iud.tpka_racuni_g.zki := NULL; -- IRN 1848
   pra_pka_iud.tpka_racuni_g.jir := NULL;
   pra_pka_iud.tpka_racuni_g.paragon := NULL;
   pra_pka_iud.tpka_racuni_g.racI_id := NULL;    -- IRN 1887
   pra_pka_iud.tpka_racuni_g.pkaracI_id := NULL; -- IRN 1887
   pra_pka_iud.tpka_racuni_g.guid := NULL;   -- IRN 02842
   -- kod prebacivanja ne zadravamo vezu na PD
   pra_pka_iud.tpka_racuni_g.pkapd_id := NULL;

   IF cvor_sa_l = cvor_na_l THEN
      direktno_l := 1;
      pra_pka_iud.tpka_racuni_g.id := pra_pka_zaj.sekvenca (NULL);
   ELSIF cvor_sa_l = centar_l OR cvor_na_l = centar_l THEN
      cvor_l := '@' || cvor_na_l;
      direktno_l := 1;
      EXECUTE IMMEDIATE
         'SELECT pra_zmp_zaj.i3_sekvenca_cvor (:cvor, NULL) FROM dual' INTO pra_pka_iud.tpka_racuni_g.id USING cvor_l;
   ELSE
      cvor_l := '@' || centar_l;
      direktno_l := 0;
      EXECUTE IMMEDIATE
         'SELECT pra_zmp_zaj.i3_sekvenca_cvor' || cvor_l || '(:cvor, NULL) FROM dual' INTO pra_pka_iud.tpka_racuni_g.id USING '@' || cvor_na_l;
   END IF;

   naredba_l :=
      'BEGIN pra_pka_iud.prebaci_rn_pred_kopi' || cvor_l ||
      '(pra_pka_iud.tpka_racuni_g, NULL, NULL, NULL, :a1, :a2, :a3); END;';
   EXECUTE IMMEDIATE naredba_l USING direktno_l, cvor_na_l, 1;

   FOR pkaracisp_cur IN (SELECT * FROM tpka_rac_isp WHERE pkarac_id = racun_row_p.id ORDER BY ABS (kolicina * cijena)) LOOP
      IF broj_stavaka_l = 1 THEN
         cijena_l := izn_ostatka_l / SIGN (pkaracisp_cur.kolicina);
      ELSE
         cijena_l := pkaracisp_cur.cijena * pkaracisp_cur.kolicina / SIGN (pkaracisp_cur.kolicina)
                     * neiskoristeno_p / racun_row_p.iznos;
      END IF;
      pra_pka_iud.tpka_rac_isp_g := pkaracisp_cur;
      pra_pka_iud.tpka_rac_isp_g.id := NULL;
      pra_pka_iud.tpka_rac_isp_g.pkarac_id := pra_pka_iud.tpka_racuni_g.id;
      pra_pka_iud.tpka_rac_isp_g.kolicina := SIGN(pkaracisp_cur.kolicina);
      pra_pka_iud.tpka_rac_isp_g.cijena := cijena_l;
      pra_pka_iud.tpka_rac_isp_g.unos_korisnik := NULL;
      pra_pka_iud.tpka_rac_isp_g.unos_dat := NULL;
      pra_pka_iud.tpka_rac_isp_g.izmjena_korisnik := NULL;
      pra_pka_iud.tpka_rac_isp_g.izmjena_dat := NULL;
      naredba_l :=
         'BEGIN pra_pka_iud.prebaci_rn_pred_kopi' || cvor_l ||
         '(NULL, pra_pka_iud.tpka_rac_isp_g, NULL, NULL, :a1, :a2, :a3); END;';
      EXECUTE IMMEDIATE naredba_l USING direktno_l, cvor_na_l, 2;
      broj_stavaka_l := broj_stavaka_l - 1;
      izn_ostatka_l := izn_ostatka_l - SIGN (pkaracisp_cur.kolicina) * cijena_l;
   END LOOP;

   FOR pkaracnap_cur IN (SELECT * FROM tpka_rac_nap WHERE pkarac_id = racun_row_p.id) LOOP
      pra_pka_iud.tpka_rac_nap_g := pkaracnap_cur;
      pra_pka_iud.tpka_rac_nap_g.id := NULL;
      pra_pka_iud.tpka_rac_nap_g.pkarac_id := pra_pka_iud.tpka_racuni_g.id;
      pra_pka_iud.tpka_rac_nap_g.iznos := pra_pka_iud.tpka_rac_nap_g.iznos *
         neiskoristeno_p / racun_row_p.iznos;
      pra_pka_iud.tpka_rac_nap_g.unos_korisnik := NULL;
      pra_pka_iud.tpka_rac_nap_g.unos_dat := NULL;
      pra_pka_iud.tpka_rac_nap_g.izmjena_korisnik := NULL;
      pra_pka_iud.tpka_rac_nap_g.izmjena_dat := NULL;
      naredba_l :=
         'BEGIN pra_pka_iud.prebaci_rn_pred_kopi' || cvor_l ||
         '(NULL, NULL, pra_pka_iud.tpka_rac_nap_g, NULL, :a1, :a2, :a3); END;';
      EXECUTE IMMEDIATE naredba_l USING direktno_l, cvor_na_l, 3;
   END LOOP;

   -- pdv
   naredba_l := 'BEGIN pra_pka_iud.prebaci_rn_pred_kopi' || cvor_l || '(NULL, NULL, NULL, :a1, :a2, :a3, :a4); END;';
   EXECUTE IMMEDIATE naredba_l USING pra_pka_iud.tpka_racuni_g.id, direktno_l, cvor_na_l,4;

   IF direktno_l = 1 THEN
      EXECUTE IMMEDIATE
         'SELECT rbr FROM tpka_racuni' || cvor_l || ' WHERE id = :id'
         INTO rbr_l USING pra_pka_iud.tpka_racuni_g.id;
   ELSE
      naredba_l := 'BEGIN pra_pka_iud.prebaci_vrati_rbr' || cvor_l || '(:a1, :a2, :a3); END;';
      EXECUTE IMMEDIATE naredba_l USING cvor_na_l, pra_pka_iud.tpka_racuni_g.id, OUT rbr_l;
   END IF;
   rbr_p := rbr_l;
   id_p := pra_pka_iud.tpka_racuni_g.id; -- IRN 4106
   
   COMMIT; -- IRN 4106
END;
PROCEDURE PREBACI_RN_PRED_KOPI
 (RACUN_ROW_P IN TPKA_RACUNI%ROWTYPE
 ,RAC_ISP_ROW_P IN TPKA_RAC_ISP%ROWTYPE
 ,RAC_NAP_ROW_P IN TPKA_RAC_NAP%ROWTYPE
 ,ID_P IN NUMBER
 ,DIREKTNO_P IN NUMBER
 ,CVOR_NA_P IN S_VLASNIK.SIFRA_TEKUCEG_CVORA%TYPE
 ,VRSTA_SLOGA_P IN NUMBER
 )
 IS
-- 1 tpka_racuni
-- 2 tpka_rac_isp
-- 3 tpka_rac_nap
-- 4 ipka_rac_pdv
-- 5 predujam - od 112 vie nema, irn 1887

   naredba_l VARCHAR2(30000);
BEGIN
   IF vrsta_sloga_p = 1 THEN
      IF direktno_p = 1 THEN
         INSERT INTO tpka_racuni VALUES racun_row_p;
      ELSE
         pra_pka_iud.tpka_racuni_g := racun_row_p;
         naredba_l := 'BEGIN pra_pka_iud.prebaci_rn_pred_kopi' || '@' || cvor_na_p ||
                      '(pra_pka_iud.tpka_racuni_g, NULL, NULL, NULL, :b1, NULL, :b2); END;';
         EXECUTE IMMEDIATE naredba_l USING 1,1;
      END IF;
   END IF;

   IF vrsta_sloga_p = 2 THEN
      IF direktno_p = 1 THEN
         INSERT INTO tpka_rac_isp VALUES rac_isp_row_p;
      ELSE
         pra_pka_iud.tpka_rac_isp_g := rac_isp_row_p;
         naredba_l := 'BEGIN pra_pka_iud.prebaci_rn_pred_kopi' || '@' || cvor_na_p ||
                      '(NULL, pra_pka_iud.tpka_rac_isp_g, NULL, NULL, :a1, NULL, :a2); END;';
         EXECUTE IMMEDIATE naredba_l USING 1,2;
      END IF;
   END IF;

   IF vrsta_sloga_p = 3 THEN
      IF direktno_p = 1 THEN
         INSERT INTO tpka_rac_nap VALUES rac_nap_row_p;
      ELSE
         pra_pka_iud.tpka_rac_nap_g := rac_nap_row_p;
         naredba_l := 'BEGIN pra_pka_iud.prebaci_rn_pred_kopi' || '@' || cvor_na_p ||
                      '(NULL, NULL, pra_pka_iud.tpka_rac_nap_g, NULL, :a1, NULL, :a2); END;';
         EXECUTE IMMEDIATE naredba_l USING 1,3;
      END IF;
   END IF;

   IF vrsta_sloga_p = 4 THEN
      IF direktno_p = 1 THEN
         pra_tpka_racuni.puni_ipka_rac_pdv (id_p);
      ELSE
         naredba_l := 'BEGIN pra_pka_iud.prebaci_rn_pred_kopi' || '@' || cvor_na_p ||
                      '(NULL, NULL, NULL, :a1, :a2, NULL, :a3); END;';
         EXECUTE IMMEDIATE naredba_l USING id_p,1,4;
      END IF;
   END IF;

   /* IRN 1887
   IF vrsta_sloga_p = 5 THEN
      IF direktno_p = 1 THEN
         pra_tpka_racuni.puni_valjani_predujam (id_p);
      ELSE
         naredba_l := 'BEGIN pra_pka_iud.prebaci_rn_pred_kopi' || '@' || cvor_na_p ||
                      '(NULL, NULL, NULL, :a1, :a2, NULL, :a3); END;';
         EXECUTE IMMEDIATE naredba_l USING id_p,1,5;
      END IF;
   END IF;
   */

END;
PROCEDURE PREBACI_VRATI_RBR
 (METCVOR_SIFRA_P IN SMET_CVOROVI.SIFRA%TYPE
 ,PKARAC_ID_P IN TPKA_RACUNI.ID%TYPE
 ,RBR_P OUT TPKA_RACUNI.RBR%TYPE
 )
 IS
BEGIN
  EXECUTE IMMEDIATE
    'SELECT rbr FROM tpka_racuni' || '@' || metcvor_sifra_p || ' WHERE id = :id'
    INTO rbr_p USING pkarac_id_p;
END;
PROCEDURE PREBACI_OBJ_ONLINE
 (CENTAR_P IN S_VLASNIK.SIFRA_TEKUCEG_CVORA%TYPE
 ,OBJEKT_P IN S_VLASNIK.SIFRA_TEKUCEG_CVORA%TYPE
 ,REZULTAT_P OUT NUMBER
 )
 IS
--
   cvor_l s_vlasnik.sifra_tekuceg_cvora%TYPE;
BEGIN
   cvor_l := '@' || centar_p;
   EXECUTE IMMEDIATE
      'SELECT zmp_zaj.dblink_is_online' || cvor_l || '(:cvor) FROM dual' INTO rezultat_p USING objekt_p;
END;
PROCEDURE AZURIRAJ_PKAKAR_IZN_ODOBREN
 (PKAKAR_ID_P IN tpka_kartice.id%TYPE
 ,IZNOS_P IN tpka_kar_rnk.iznos%TYPE
 )
 IS
-- IRN 2548; Auriraj zbroj uplata.
BEGIN
  UPDATE tpka_kartice
     SET izn_odobren = NVL (izn_odobren, 0) + NVL (iznos_p, 0)
   WHERE id = pkakar_id_p
     AND ozn_prepaid = -1;
END;
PROCEDURE TRAZI_ADRESU
 (METCVOR_SIFRA_P IN MZMP_OJR.METCVOR_SIFRA%TYPE
 ,PKAADR_RBR_P IN MPKA_ADRESE.RBR%TYPE
 ,ID_P OUT MPKA_ADRESE.ID%TYPE
 ,PREZIME_P OUT VARCHAR2
 ,EMAIL_P OUT MPKA_ADRESE.EMAIL%TYPE
 ,NAZ_ULICE_P OUT MPKA_ADRESE.NAZ_ULICE%TYPE
 ,MJESTO_P OUT VARCHAR2
 ,DAT_PON_P OUT DATE
 )
 IS
--
   naredba_l VARCHAR2(1000);
   ima_l NUMBER;
   zem_id_l NUMBER;
   pos_id_l NUMBER;
   naz_mjesta_l VARCHAR2(100);
   zemlja_l VARCHAR2(100);
   posta_l VARCHAR2(100);
   vrati_l VARCHAR2(200);
BEGIN
   naredba_l := 'SELECT COUNT (1) FROM mpka_adrese' || metcvor_sifra_p || ' WHERE rbr = :pkaadr_rbr_p';
   EXECUTE IMMEDIATE naredba_l INTO ima_l USING pkaadr_rbr_p;
   IF ima_l = 1 THEN
      naredba_l := 'SELECT dat_ponisten, zem_id, pos_id, naz_mjesta, id, DECODE (prezime, NULL, naz_poduzeca, prezime || '', '' || ime), email, naz_ulice FROM mpka_adrese'
         || metcvor_sifra_p || ' WHERE rbr = :pkaadr_rbr_p';
      EXECUTE IMMEDIATE naredba_l INTO dat_pon_p, zem_id_l, pos_id_l, naz_mjesta_l, id_p, prezime_p, email_p, naz_ulice_p USING pkaadr_rbr_p;
      naredba_l := 'SELECT naziv FROM s_zemlje' || metcvor_sifra_p || ' WHERE id = :zemlja';
      EXECUTE IMMEDIATE naredba_l INTO zemlja_l USING zem_id_l;
      IF pos_id_l IS NULL THEN
         vrati_l := zemlja_l || ', ' || naz_mjesta_l;
      ELSE
         naredba_l := 'SELECT naziv FROM m_poste' || metcvor_sifra_p || ' WHERE id = :posta';
         EXECUTE IMMEDIATE naredba_l INTO posta_l USING pos_id_l;
         vrati_l := zemlja_l || ', ' || posta_l;
      END IF;
      mjesto_p := vrati_l;
   END IF;
END;
PROCEDURE TRAZI_ADRESU_OBJ
 (CENTAR_P IN S_VLASNIK.SIFRA_TEKUCEG_CVORA%TYPE
 ,METCVOR_SIFRA_P IN S_VLASNIK.SIFRA_TEKUCEG_CVORA%TYPE
 ,PKAADR_RBR_P IN MPKA_ADRESE.RBR%TYPE
 ,ID_P OUT MPKA_ADRESE.ID%TYPE
 ,PREZIME_P OUT VARCHAR2
 ,EMAIL_P OUT MPKA_ADRESE.EMAIL%TYPE
 ,NAZ_ULICE_P OUT MPKA_ADRESE.NAZ_ULICE%TYPE
 ,MJESTO_P OUT VARCHAR2
 ,DAT_PON_P OUT DATE
 )
 IS
--
   naredba_l VARCHAR2(2000);
BEGIN
   naredba_l := 'BEGIN pra_pka_iud.trazi_adresu' || centar_p || '(:1, :2, :3, :4, :5, :6, :7, :8); END;';
   EXECUTE IMMEDIATE naredba_l USING IN metcvor_sifra_p, IN pkaadr_rbr_p, OUT id_p, OUT prezime_p, OUT email_p, OUT naz_ulice_p, OUT mjesto_p, OUT dat_pon_p;
END;
PROCEDURE TRAZI_PARAM
 (METCVOR_SIFRA_P IN S_VLASNIK.SIFRA_TEKUCEG_CVORA%TYPE
 ,PARAMETAR_P OUT SZMP_PARAMETRI.VRIJEDNOST%TYPE
 )
 IS
--
   naredba_l VARCHAR2(1000);
BEGIN
   naredba_l := 'SELECT pra_pka_zaj.vrijednost_parametra' || metcvor_sifra_p || ' (''1040'') FROM dual';
   EXECUTE IMMEDIATE naredba_l INTO parametar_p;
END;
PROCEDURE TRAZI_PARAM_OBJ
 (CENTAR_P IN S_VLASNIK.SIFRA_TEKUCEG_CVORA%TYPE
 ,METCVOR_SIFRA_P IN S_VLASNIK.SIFRA_TEKUCEG_CVORA%TYPE
 ,PARAMETAR_P OUT SZMP_PARAMETRI.VRIJEDNOST%TYPE
 )
 IS
--
   naredba_l VARCHAR2(2000);
BEGIN
   naredba_l := 'BEGIN pra_pka_iud.trazi_param' || centar_p || '(:1, :2); END;';
   EXECUTE IMMEDIATE naredba_l USING IN metcvor_sifra_p, OUT parametar_p;
END;
PROCEDURE PRED_KREIRAJ_ADR
 (CENTAR_P IN S_VLASNIK.SIFRA_TEKUCEG_CVORA%TYPE
 ,METCVOR_SIFRA_P IN S_VLASNIK.SIFRA_TEKUCEG_CVORA%TYPE
 ,DIREKTNO_P IN NUMBER
 ,PKAADR_REC_P IN MPKA_ADRESE%ROWTYPE
 ,ID_ADRESE_P OUT MPKA_ADRESE.ID%TYPE
 )
 IS
--
   id_adrese_l NUMBER;
   naredba_l VARCHAR2(1000);
BEGIN
   pra_pka_iud.mpka_adrese_g := pkaadr_rec_p;
   IF direktno_p = 1 THEN
      INSERT INTO mpka_adrese VALUES pra_pka_iud.mpka_adrese_g RETURNING id INTO id_adrese_l;
      id_adrese_p := id_adrese_l;
   ELSIF direktno_p = 2 THEN
      naredba_l := 'BEGIN pra_pka_iud.pred_kreiraj_adr' || centar_p || '(:a1, :a2, :a3, pra_pka_iud.mpka_adrese_g, :a4); END;';
      EXECUTE IMMEDIATE naredba_l USING IN centar_p, IN metcvor_sifra_p,IN 1, OUT id_adrese_p;
   ELSIF direktno_p = 3 THEN
      naredba_l := 'BEGIN pra_pka_iud.pred_kreiraj_adr' || metcvor_sifra_p || '(:a1, :a2, :a3, pra_pka_iud.mpka_adrese_g, :a4); END;';
      EXECUTE IMMEDIATE naredba_l USING IN centar_p, IN metcvor_sifra_p,IN 1, OUT id_adrese_p;
   ELSIF direktno_p = 4 THEN
      naredba_l := 'BEGIN pra_pka_iud.pred_kreiraj_adr' || centar_p || '(:a1, :a2, :a3, pra_pka_iud.mpka_adrese_g, :a4); END;';
      EXECUTE IMMEDIATE naredba_l USING IN centar_p, IN metcvor_sifra_p,IN 3, OUT id_adrese_p;
   END IF;
END;
PROCEDURE PUNI_PKAPD
 (PKAPD_ROW_P IN tpka_pdokumenti%ROWTYPE
 ,PKAPD_BROJ_P OUT VARCHAR2
 )
 IS
-- IRN 3134
BEGIN
  INSERT INTO tpka_pdokumenti VALUES pkapd_row_p
    RETURNING TO_NUMBER (rbr) || '-' || oj_sifra || '-' || vdok_sifra2n
    INTO pkapd_broj_p;
  COMMIT;
END;
PROCEDURE OBRISI_PKAPLAN2SIZV
 (DAT_POC_2_P IN TPKA_PLAN2.DATUM%TYPE
 ,DAT_ZAV_2_P IN TPKA_PLAN2.DATUM%TYPE
 )
 IS
/*Brisi plan za ordedjeno razdoblje*/
BEGIN
  IF pra_zmp_zaj.centar = 0 THEN
    -- tablica tpka_plan2_sizv je replikacijska i moe se brisati samo na centru
    RETURN;
  END IF;
  IF dat_poc_2_p IS NULL  -- poetak odredinog razdoblja
    OR dat_zav_2_p IS NULL  -- zavretak odredinog razdoblja
  THEN
    RETURN;
  END IF;
  
  DELETE FROM tpka_plan2_sizv
  WHERE EXISTS (SELECT 'x' FROM tpka_plan2 WHERE datum BETWEEN dat_poc_2_p AND dat_zav_2_p AND ID = pkaplan2_id);
  
  DELETE FROM tpka_plan2
  WHERE datum BETWEEN dat_poc_2_p AND dat_zav_2_p;
  
  COMMIT;
END;

END PRA_PKA_IUD;
/
SHOW ERROR

