-- C:\Users\dgajic\Desktop\IRN 4134\des\v2\pra_pka_i3fiskal.pkb
--
-- Generated for Oracle 10g on Mon Dec 22  11:24:42 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'PRA_PKA_I3FISKAL'
CREATE OR REPLACE PACKAGE BODY PRA_PKA_I3FISKAL IS

DATA_M CLOB;
ODGOVOR_M CLOB;
-- Designer PL/SQL Block

  FUNCTION base64decode (clob_p CLOB)
    RETURN BLOB
  IS
    blob_l    BLOB;
    raw_l     RAW(32767);
    amt_l     NUMBER := 7700;
    offset_l  NUMBER := 1;
    temp_l    VARCHAR2(32767);
  BEGIN
    BEGIN
      DBMS_LOB.createtemporary (blob_l, FALSE, DBMS_LOB.call);
      LOOP
        DBMS_LOB.read (clob_p, amt_l, offset_l, temp_l);
        offset_l := offset_l + amt_l;
        raw_l    := UTL_ENCODE.base64_decode (UTL_RAW.cast_to_raw (temp_l));
        DBMS_LOB.append (blob_l, TO_BLOB (raw_l));
      END LOOP;
    EXCEPTION
      WHEN NO_DATA_FOUND THEN
        NULL;
    END;
    RETURN blob_l;
  END;

-- KRAJ Designer PL/SQL Block


FUNCTION VLAS_U_FSUS_HR
 (DATUM_P IN DATE := TRUNC (SYSDATE)
 )
 RETURN NUMBER
 IS
-- vraa -1 ako je vlasnik u fiskalnom sustavu HR i datum primjene fiskalnog sustava manji ili jednak promatranom
  br_redaka_l NUMBER;
BEGIN

  SELECT COUNT (1) INTO br_redaka_l
    FROM s_vlasnik
   WHERE ozn_fsustava = 'HR'
     AND dat_primjene <= TRUNC (datum_p);

  IF br_redaka_l = 1 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;

END;
FUNCTION VLAS_U_SUST_PDV
 RETURN VARCHAR2
 IS
--
  br_redaka_l NUMBER;
BEGIN
  /* IRN 2212 R-1 se vie ne koristi pa odluka vie ne ide preko tih oznaka ve parametra 0013
  SELECT COUNT (rowid) INTO br_redaka_l
    FROM s_vpobveznika
   WHERE sifra = pra_pka_zaj.vrijednost_parametra ('1014') -- ifra vrste poreznih obveznika vlasnika aplikacije.
     AND ozn_racuna IN ('R-1', 'R-2');
  IF br_redaka_l = 1 THEN
    RETURN ('true');
  ELSE
    RETURN ('false');
  END IF;
  */
  IF pra_pka_zaj.vrijednost_parametra ('1014')   -- ifra vrste poreznih obveznika vlasnika aplikacije
    = pra_zmp_zaj.vrijednost_parametra ('0013')  -- ifra vrste poreznih obveznika izvan_sustava
  THEN
    RETURN ('false');  -- izvan sustava
  ELSE
    RETURN ('true');  -- u sustavu
  END IF;
END;
FUNCTION RECRAC_NACIN_PLAC
 (RAC_ID_P IN t_racuni.id%TYPE
 )
 RETURN VARCHAR2
 IS
--
  br_redaka_l NUMBER;
  sifra_l s_vpplacanja.sifra%TYPE;
BEGIN
  IF rac_id_p IS NULL THEN
    RETURN (NULL);
  END IF;

  SELECT COUNT (1) INTO br_redaka_l FROM t_rac_pred WHERE rac_id = rac_id_p;
  IF br_redaka_l > 0 THEN
    -- postoji iskoriteni predujam
    RETURN ('O');
  END IF;

  SELECT COUNT (DISTINCT (vppla.sifra)), MAX (vppla.sifra) INTO br_redaka_l, sifra_l
    FROM t_rac_nap racnap,
         s_vplacanja vpla,
         s_vpplacanja vppla
   WHERE racnap.rac_id = rac_id_p
     AND racnap.vpla_id = vpla.id
     AND vpla.vppla_id = vppla.id;
  IF br_redaka_l = 1 THEN
    -- samo jedna vrsta poreznih plaanja
    RETURN (sifra_l);
  ELSE
    -- vie vrsta poreznih plaanja
    RETURN ('O');
  END IF;
END;
FUNCTION RECRAC_NACIN_PLAC_NAP
 (RAC_ID_P IN t_racuni.id%TYPE
 )
 RETURN VARCHAR2
 IS
--
  br_napojnica_pos_l NUMBER;
  br_napojnica_rec_l NUMBER;
  br_redaka_l        NUMBER;
  sifra_l            s_vpplacanja.sifra%TYPE;

  CURSOR vppla_c (tip_k VARCHAR2) IS
    SELECT COUNT (DISTINCT (vppla.sifra)), MAX (vppla.sifra)
      FROM t_rac_nap racnap,
           s_vplacanja vpla,
           s_vpplacanja vppla
     WHERE racnap.rac_id = rac_id_p
       AND racnap.vpla_id = vpla.id
       AND vpla.vppla_id = vppla.id
       AND ((tip_k = 'REC_NAP' AND NVL (racnap.izn_napojnice, 0) <> 0) OR tip_k = 'POS_NAP');
BEGIN
  IF rac_id_p IS NULL THEN
    RETURN (NULL);
  END IF;

  -- provjera POS napojnice
  SELECT COUNT(1) INTO br_napojnica_pos_l
    FROM tpka_rnkasa
   WHERE rac_id = rac_id_p AND NVL (izn_napojnice, 0) <> 0;

  -- provjera REC napojnica
  SELECT COUNT(1) INTO br_napojnica_rec_l
    FROM t_rac_nap
   WHERE rac_id = rac_id_p AND NVL (izn_napojnice, 0) <> 0;

  -- nema napojnica na raunu
  IF br_napojnica_pos_l = 0 AND br_napojnica_rec_l = 0 THEN
    RETURN (NULL);
  END IF;

  IF br_napojnica_pos_l > 0 THEN
    OPEN vppla_c ('POS_NAP');
    FETCH vppla_c INTO br_redaka_l, sifra_l;
    CLOSE vppla_c;
    IF br_redaka_l = 1 THEN
      -- samo jedna vrsta poreznih plaanja
      RETURN (sifra_l);
    ELSE
      -- vie vrsta poreznih plaanja
      RETURN ('O');
    END IF;
  END IF;

  IF br_napojnica_rec_l > 0 THEN
    OPEN vppla_c ('REC_NAP');
    FETCH vppla_c INTO br_redaka_l, sifra_l;
    CLOSE vppla_c;
    IF br_redaka_l = 1 THEN
      -- samo jedna vrsta poreznih plaanja
      RETURN (sifra_l);
    ELSE
      -- vie vrsta poreznih plaanja
      RETURN ('O');
    END IF;
  END IF;
END;
FUNCTION PKARAC_NACIN_PLAC
 (PKARAC_ID_P IN tpka_racuni.id%TYPE
 )
 RETURN VARCHAR2
 IS
--
  br_redaka_l NUMBER;
  sifra_l s_vpplacanja.sifra%TYPE;
BEGIN
  IF pkarac_id_p IS NULL THEN
    RETURN (NULL);
  END IF;

  SELECT COUNT (1) INTO br_redaka_l FROM tpka_rac_pred WHERE pkarac_id = pkarac_id_p;
  IF br_redaka_l > 0 THEN
    -- postoji iskoriteni predujam
    RETURN ('O');
  END IF;

  SELECT COUNT (DISTINCT (vppla.sifra)), MAX (vppla.sifra) INTO br_redaka_l, sifra_l
    FROM tpka_rac_nap pkaracnap,
         s_vplacanja vpla,
         s_vpplacanja vppla
   WHERE pkaracnap.pkarac_id = pkarac_id_p
     AND pkaracnap.vpla_id = vpla.id -- IRN 3543
     AND vpla.vppla_id = vppla.id;
  IF br_redaka_l = 1 THEN
    -- samo jedna vrsta poreznih plaanja
    RETURN (sifra_l);
  ELSE
    -- vie vrsta poreznih plaanja
    RETURN ('O');
  END IF;
END;
PROCEDURE ZAJ_POST
 IS
--
  url_l VARCHAR2 (200);
  req_l UTL_HTTP.req;
  res_l UTL_HTTP.resp;
  text_l VARCHAR2(32767);
  clob_l CLOB;
BEGIN
  IF data_m IS NULL
    OR pra_pka_zaj.vrijednost_parametra ('1055') = 'nebitno' -- adresa servera npr. 10.168.2.42
    OR pra_pka_zaj.vrijednost_parametra ('1056') = 'nebitno' -- port npr. 8080
    OR pra_pka_zaj.vrijednost_parametra ('1057') = 'nebitno' -- timeout npr. 3
  THEN
    RETURN;
  END IF;

  odgovor_m := NULL;

  -- url_l := 'http://10.168.2.42:8080';
  url_l :=
    'http://' ||
    pra_pka_zaj.vrijednost_parametra ('1055') || ':' ||
    pra_pka_zaj.vrijednost_parametra ('1056');

  UTL_HTTP.set_response_error_check (enable => FALSE);
  UTL_HTTP.set_detailed_excp_support (enable => FALSE);
  UTL_HTTP.set_transfer_timeout (timeout => pra_pka_zaj.vrijednost_parametra ('1057'));
  req_l := UTL_HTTP.begin_request (url => url_l, method => 'POST');
  UTL_HTTP.set_header (r => req_l, name => 'Content-Type', value => 'text/xml; charset=utf-8');
  UTL_HTTP.set_header (req_l, 'Content-Length', pra_pka2.clob_length (data_m)); -- IRN 2434
  UTL_HTTP.write_text (req_l, data_m);
  res_l := UTL_HTTP.get_response (req_l);
  UTL_HTTP.set_body_charset (res_l, charset => 'UTF-8'); -- IRN 4079

  -- IRN 3409
  IF res_l.status_code = UTL_HTTP.HTTP_OK THEN
    NULL;
  ELSE
    RAISE_APPLICATION_ERROR (-20001, res_l.status_code || ' ' || res_l.reason_phrase);
  END IF;
  -- KRAJ IRN 3409

  BEGIN
    DBMS_LOB.createtemporary (clob_l, TRUE);
    LOOP
      UTL_HTTP.read_text (res_l, text_l, 32767);
      DBMS_LOB.writeappend (clob_l, LENGTH (text_l), text_l);
    END LOOP;
  EXCEPTION
    WHEN UTL_HTTP.end_of_body THEN
      UTL_HTTP.end_response (res_l);
  END;

  odgovor_m := clob_l;

EXCEPTION
  WHEN OTHERS THEN
    UTL_HTTP.end_response (res_l);
END;
FUNCTION ZAJ_REPLACE
 (VRIJEDNOST_P IN VARCHAR2
 )
 RETURN VARCHAR2
 IS
-- vrijednost XML elementa ne smije sadravati znakove '<', '&' i '"'.
BEGIN
  RETURN (REPLACE (REPLACE (REPLACE (vrijednost_p, '<', ''), '&', ''), '"', ''));
END;
PROCEDURE I3FISKAL_REC_RACUN
 (RAC_ID_P IN t_racuni.id%TYPE
 )
 IS
-- dostavi podatke o REC GI raunu i3fiskal servisu
  rac_datum_l t_racuni.datum%TYPE;
  vapldok_oznaka_l s_vapldok.oznaka%TYPE;
  rac_jir_l t_racuni.jir%TYPE;
  old_rac_jir_l t_racuni.jir%TYPE;
  rac_zki_l t_racuni.zki%TYPE;
  rac_iznos_l t_racuni.iznos%TYPE;           -- IRN 2562
  rac_izn_tecaja_l t_racuni.izn_tecaja%TYPE; -- IRN 2562
  OibOper_l s_vlasnik.oib%TYPE;
  pkaracfis_rec_l lpka_rac_fis%ROWTYPE;
  nebitno_l NUMBER;
  rac_qr_l CLOB;
  rac_qr_blob_l BLOB;
  racblob_id_l t_racuni_blob.id%TYPE;
  ozn_napojnice_l NUMBER;

  izn_napojnice_pos_l NUMBER;
  izn_napojnice_rec_l NUMBER;

  opis_zahtjev_l VARCHAR2(300);
  opis_odgovor_l VARCHAR2(300);

  nak_dostava_l  VARCHAR2(5);

  CURSOR vanjskisus_c (rac_id_k NUMBER) IS
    SELECT oib
      FROM s_vlasnik, t_racuni rac
     WHERE rac.id = rac_id_k
       AND (rac.unos_korisnik = 'IT_API');
  
  -- IRN 4106  
  rac_id_l t_racuni.id%TYPE;
  rac_age_id_l t_racuni.age_id%TYPE;
  rac_agep_id_l t_racuni.agep_id%TYPE;
  rac_pkaadr_id_l t_racuni.pkaadr_id%TYPE;
  rac_rac_id_l t_racuni.rac_id%TYPE;
  rac_oznaka_l t_racuni.oznaka%TYPE;
  age_oib_l m_agencije.oib%TYPE;
  pkaadr_oib_l mpka_adrese.oib%TYPE;
  dat_fiskalizacije_l lpka_rac_fis.dat_obrade%TYPE;
BEGIN
  IF rac_id_p IS NULL THEN
    RETURN;
  END IF;

  SELECT rac.datum, vapldok.oznaka, rac.jir, rac.zki,
         rac.iznos, rac.izn_tecaja,           -- IRN 2562
         rac.id, rac.age_id, rac.agep_id, rac.pkaadr_id, rac.rac_id, rac.oznaka -- IRN 4106 
    INTO rac_datum_l, vapldok_oznaka_l, rac_jir_l, rac_zki_l,
         rac_iznos_l, rac_izn_tecaja_l,
         rac_id_l, rac_age_id_l, rac_agep_id_l, rac_pkaadr_id_l, rac_rac_id_l, rac_oznaka_l -- IRN 4106
    FROM t_racuni rac,
         s_vapldok vapldok
   WHERE rac.id = rac_id_p
     AND rac.vapldok_id = vapldok.id;

  old_rac_jir_l := rac_jir_l;

  IF vlas_u_fsus_hr (rac_datum_l) = 0 -- vlasnik nije u fiskalnom sustavu HR ili je datum rauna manji od poetka primjene fiskalnog sustava
    OR vapldok_oznaka_l NOT IN ('GI', 'BI') -- IRN 4106
    OR pra_rec_s5.ozn_napojnice_pkaracfis (rac_id_p) = 2
    -- OR rac_jir_l IS NOT NULL --- komentar jer jir vie nije kontrolno polje, kada se fiskalizira napojnica
  THEN
    RETURN;
  END IF;


  IF old_rac_jir_l IS NULL THEN
    -- fiskalizira se osnovni raun
    ozn_napojnice_l := 0;
    IF rac_zki_l IS NULL THEN
      nak_dostava_l := 'false';
    ELSE
      nak_dostava_l  := 'true';
    END IF;
  ELSE
    SELECT SUM (NVL (izn_napojnice, 0)) INTO izn_napojnice_rec_l FROM t_rac_nap WHERE rac_id = rac_id_p;
    SELECT SUM (NVL (izn_napojnice, 0)) INTO izn_napojnice_pos_l FROM tpka_rnkasa WHERE rac_id = rac_id_p;
    -- ako nema niti jedne napojnice a raun je ve fiskaliziran, izai van
    IF NVL (izn_napojnice_rec_l, 0) = 0 AND NVL (izn_napojnice_pos_l, 0) = 0 THEN
      RETURN;
    END IF;
    -- mora se provjeriti koja se napojnica fiskalizira
    -- ako postoji REC napojnica odmah se stavlja oznaka 2
    IF NVL (izn_napojnice_rec_l, 0) <> 0 THEN
      ozn_napojnice_l := 2;
    ELSIF NVL (izn_napojnice_pos_l, 0) <> 0 THEN
      ozn_napojnice_l := 1;
    END IF;
    
    -- IRN 4106
    IF rac_rac_id_l IS NOT NULL AND rac_oznaka_l = 'N' THEN
      SELECT MAX (dat_obrade) INTO dat_fiskalizacije_l
        FROM lpka_rac_fis
       WHERE rac_id = rac_rac_id_l
         AND ozn_napojnice IN (1, 2)
         AND sifra_greske IS NULL
         AND opis_greske IS NULL;
    
      IF dat_fiskalizacije_l IS NULL THEN
        ozn_napojnice_l := 0;
      END IF;
    END IF;

    SELECT DECODE (COUNT (1), 0, 'false', 'true')
      INTO nak_dostava_l
      FROM lpka_rac_fis
     WHERE rac_id = rac_id_p
       AND ozn_napojnice IS NULL
       AND sifra_greske || opis_greske IS NOT NULL;
  END IF;


  -- pra_t_racuni.provjeri_rac_iznos (rac_id_p, rac_iznos_l, rac_izn_tecaja_l); -- IRN 2562; 27.06.2016 MK komentirano

  OibOper_l := pra_pka_i3fiskal.oib_test ('99999999999'); -- IRN 3409

  OPEN vanjskisus_c (rac_id_p);
  FETCH vanjskisus_c INTO OibOper_l;
  CLOSE vanjskisus_c;

  /*
  <tns:RacunZahtjev
    xmlns:tns="http://www.apis-it.hr/fin/2012/types/f73"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
    <tns:Zaglavlje>
      <tns:IdPoruke>f81d4fae-7dec-11d0-a765-00a0c91e6bf6</tns:IdPoruke>
      <tns:DatumVrijeme>01.09.2012T21:10:34</tns:DatumVrijeme>
    </tns:Zaglavlje>
    <tns:Racun>
      <tns:Oib>98765432198</tns:Oib>
      <tns:USustPdv>true</tns:USustPdv>
      <tns:DatVrijeme>01.09.2012T21:10:34</tns:DatVrijeme>
      <tns:OznSlijed>P</tns:OznSlijed>
      <tns:BrRac>
        <tns:BrOznRac>123456789</tns:BrOznRac>
        <tns:OznPosPr>POSL1</tns:OznPosPr>
        <tns:OznNapUr>12</tns:OznNapUr>
      </tns:BrRac>
      <tns:Pdv>
        <tns:Porez>
          <tns:Stopa>25.00</tns:Stopa>
          <tns:Osnovica>10.00</tns:Osnovica>
          <tns:Iznos>2.50</tns:Iznos>
        </tns:Porez>
        <tns:Porez>
          <tns:Stopa>10.00</tns:Stopa>
          <tns:Osnovica>10.00</tns:Osnovica>
          <tns:Iznos>1.00</tns:Iznos>
        </tns:Porez>
        <tns:Porez>
          <tns:Stopa>0.00</tns:Stopa>
          <tns:Osnovica>10.00</tns:Osnovica>
          <tns:Iznos>0.00</tns:Iznos>
        </tns:Porez>
      </tns:Pdv>
      <tns:Pnp>
        <tns:Porez>
          <tns:Stopa>3.00</tns:Stopa>
          <tns:Osnovica>10.00</tns:Osnovica>
          <tns:Iznos>0.30</tns:Iznos>
        </tns:Porez>
      </tns:Pnp>
      <tns:OstaliPor> -- ne aljemo
        <tns:Porez>
          <tns:Naziv>Porez na luksuz</tns:Naziv>
          <tns:Stopa>15.00</tns:Stopa>
          <tns:Osnovica>10.00</tns:Osnovica>
          <tns:Iznos>1.50</tns:Iznos>
        </tns:Porez>
      </tns:OstaliPor>
      <tns:IznosOslobPdv>12.00</tns:IznosOslobPdv>
      <tns:IznosMarza>13.00</tns:IznosMarza> -- ne aljemo
      <tns:IznosNePodlOpor>100.00</tns:IznosNePodlOpor>
      <tns:Naknade>
        <tns:Naknada>
          <tns:NazivN>Povratna naknada</tns:NazivN>
          <tns:IznosN>1.00</tns:IznosN>
        </tns:Naknada>
      </tns:Naknade>
      <tns:IznosUkupno>30.00</tns:IznosUkupno>
      <tns:NacinPlac>K</tns:NacinPlac>
      <tns:OibOper>01234567890</tns:OibOper>
      <tns:ZastKod>e4d909c290d0fb1ca068ffaddf22cbd0</tns:ZastKod>
      <tns:NakDost>false</tns:NakDost>
      <tns:ParagonBrRac>123/458/5</tns:ParagonBrRac>
      <tns:OibPrimateljaRacuna>94114100359</tns:OibPrimateljaRacuna> -- IRN 4106
      <tns:SpecNamj>Navedeno kao primjer</tns:SpecNamj> -- ne aljemo
    </tns:Racun>
  </tns:RacunZahtjev>
  */

  /*
  <tns:RacunPDZahtjev
    ...
    <tns:Racun>
      ...
      <tns:PrateciDokument>
        <tns:ZastKodPD>9d0dbe601dff64ebf2000ce1f943dc8f</tns:ZastKodPD>
      </tns:PrateciDokument>
    </tns:Racun>
  </tns:RacunPDZahtjev>
  */

  data_m := NULL;

  -- upii u log LPKA_RAC_FIS
  pkaracfis_rec_l.id := pra_zmp_zaj.i3_sekvenca (NULL);
  INSERT INTO lpka_rac_fis (id, rac_id, dat_slanja, ozn_napojnice)
    VALUES (pkaracfis_rec_l.id, rac_id_p, SYSDATE, DECODE (ozn_napojnice_l, 0, NULL, ozn_napojnice_l));
  COMMIT;

  IF old_rac_jir_l IS NULL THEN
    -- fiskalizira se raun
    SELECT 1 INTO nebitno_l FROM t_racuni WHERE id = rac_id_p AND jir IS NULL FOR UPDATE OF zki, jir NOWAIT;
  END IF; 
  
  -- IRN 4106
  IF TRUNC(SYSDATE) >= pra_zmp_s.dat_erac_obveze THEN
    SELECT MAX(age.oib)
      INTO age_oib_l
      FROM m_agencije age, s_zemlje zem
     WHERE age.id = pra_rec2.agek_id(rac_age_id_l, rac_agep_id_l)
       AND age.zem_id = zem.id
       AND zem.sifra_2a = 'HR';

    SELECT MAX(pkaadr.oib)
      INTO pkaadr_oib_l
      FROM mpka_adrese pkaadr, s_zemlje zem
     WHERE pkaadr.id = rac_pkaadr_id_l
       AND pkaadr.zem_id = zem.id
       AND zem.sifra_2a = 'HR';
  END IF;

  SELECT
    xmlelement ("tns:Racun",
      xmlattributes (
          'http://www.apis-it.hr/fin/2012/types/f73' AS "xmlns:tns",
          'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi"),
      xmlelement ("tns:Oib", vlas.oib),
      xmlelement ("tns:USustPdv", vlas_u_sust_pdv),
      xmlelement ("tns:DatVrijeme", TO_CHAR (rac.izmjena_dat, 'DD.MM.RRRR') || 'T' || TO_CHAR (rac.izmjena_dat, 'HH24:MI:SS')), -- IRN 4134 rac.izmjena_dat
      xmlelement ("tns:OznSlijed", 'N'), -- oznaka slijednosti brojeva rauna na razini naplatnog ureaja
      xmlelement ("tns:BrRac",
        xmlelement ("tns:BrOznRac", TO_NUMBER (rac.rbr)),
        xmlelement ("tns:OznPosPr", rac.oj_sifra),
        xmlelement ("tns:OznNapUr", rac.vdok_sifra2n)
        ),
      -- xmlforest javlja greku ORA-01427: single-row subquery returns more than one row
      (
      SELECT
        CASE
          WHEN SUM (osnovica) IS NOT NULL THEN -- IRN 1899
            xmlelement ("tns:Pdv",
              xmlagg (
                xmlelement ("tns:Porez",
                  xmlelement ("tns:Stopa", TRIM (TO_CHAR (stopa, '990.00'))),
                  xmlelement ("tns:Osnovica", TRIM (TO_CHAR (osnovica, '999999999999990.00'))),
                  xmlelement ("tns:Iznos", TRIM (TO_CHAR (iznos, '999999999999990.00')))
                  )
                )
              )
          ELSE NULL
        END
      FROM
        (
        SELECT
          racpdv.stopa_pdv AS stopa,
          SUM (ROUND (racpdv.iznos, 2)) AS osnovica,
          SUM (racpdv.izn_domval - ROUND (racpdv.iznos, 2)) AS iznos
        FROM
          i_rac_pdv racpdv,
          s_vpisporukaz vpispz,
          szmp_spisporuka zmpspisp
        WHERE
          racpdv.rac_id = rac_id_p
          AND racpdv.vpispz_id = vpispz.id
          AND vpispz.zmpspisp_id = zmpspisp.id
          AND zmpspisp.sifra IN ('20', '30', '40', '50', '60') -- oporezivo; IRN 2423
        GROUP BY
          racpdv.stopa_pdv
        )
      ),
      (
      SELECT
        CASE
          WHEN SUM (osnovica) IS NOT NULL THEN -- IRN 1899
            xmlelement ("tns:Pnp",
              xmlagg (
                xmlelement ("tns:Porez",
                  xmlelement ("tns:Stopa", TRIM (TO_CHAR (stopa, '990.00'))),
                  xmlelement ("tns:Osnovica", TRIM (TO_CHAR (osnovica, '999999999999990.00'))),
                  xmlelement ("tns:Iznos", TRIM (TO_CHAR (iznos, '999999999999990.00')))
                  )
                )
              )
          ELSE NULL
        END
      FROM
        (
        SELECT
          stopa_ppot AS stopa,
          SUM (izn_osnovice_ppot) AS osnovica,
          SUM (izn_ppot) AS iznos
        FROM
          tpka_rnkasa
        WHERE
          rac_id = rac_id_p
          AND izn_ppot <> 0
        GROUP BY
          stopa_ppot
        )
      ),
      (
      SELECT
        DECODE (IznosOslobPdv, NULL, NULL, xmlelement ("tns:IznosOslobPdv", TRIM (TO_CHAR (IznosOslobPdv, '999999999999990.00'))))
      FROM
        (
        SELECT
          SUM (ROUND (racpdv.iznos, 2)) AS IznosOslobPdv
        FROM
          i_rac_pdv racpdv,
          s_vpisporukaz vpispz,
          szmp_spisporuka zmpspisp
        WHERE
          racpdv.rac_id = rac_id_p
          AND racpdv.vpispz_id = vpispz.id
          AND vpispz.zmpspisp_id = zmpspisp.id
          AND zmpspisp.sifra IN ('11', '12', '13') -- osloboeno poreza
        )
      ),
      (
      SELECT
        DECODE (IznosNePodlOpor, NULL, NULL, xmlelement ("tns:IznosNePodlOpor", TRIM (TO_CHAR (IznosNePodlOpor, '999999999999990.00'))))
      FROM
        (
        SELECT
          SUM (ROUND (racpdv.iznos, 2)) AS IznosNePodlOpor
        FROM
          i_rac_pdv racpdv,
          s_vpisporukaz vpispz,
          szmp_spisporuka zmpspisp
        WHERE
          racpdv.rac_id = rac_id_p
          AND racpdv.vpispz_id = vpispz.id
          AND vpispz.zmpspisp_id = zmpspisp.id
          AND zmpspisp.sifra IN ('10') -- ne podlijee oporezivanju
        )
      ),
      (
      SELECT
        CASE
          WHEN SUM (iznosN) <> 0 THEN
            xmlelement ("tns:Naknade",
              xmlagg (
                xmlelement ("tns:Naknada",
                  xmlelement ("tns:NazivN", nazivN),
                  xmlelement ("tns:IznosN", TRIM (TO_CHAR (iznosN, '999999999999990.00')))
                  )
                )
              )
          ELSE NULL
        END
      FROM
        (
        SELECT
          'Povratna naknada' AS nazivN,
          SUM (izn_pnaknade) AS iznosN
        FROM
          tpka_rnkasa
        WHERE
          rac_id = rac_id_p
          AND NVL (izn_pnaknade, 0) <> 0
        )
      ),
      xmlelement ("tns:IznosUkupno", TRIM (TO_CHAR (ROUND (pra_rec_s2.iznos_racuna_bruto (rac.id, rac.iznos, rac.izn_tecaja) * rac.izn_tecaja, 2), '999999999999990.00'))),
      xmlelement ("tns:NacinPlac", recrac_nacin_plac (rac.id)),
      (
      SELECT xmlelement ("tns:OibOper", DECODE (TrebaOib, 0, vlas.oib, NVL (OibOper, OibOper_l)))
        FROM
          (
          SELECT
            MAX (kor.sifra) AS OibOper,
            MAX (kor.ozn_ima_oib) AS TrebaOib
          FROM
            t_racuni rac,
            m_korisnici kor
          WHERE
            rac.id = rac_id_p
            AND rac.unos_korisnik = kor.naziv
          )
      ),
      xmlelement ("tns:ZastKod", rac.zki),
      -- xmlelement ("tns:NakDost", DECODE (rac.zki, NULL, 'false', 'true')),
      xmlelement ("tns:NakDost", nak_dostava_l),
      DECODE (rac.paragon, NULL, NULL, xmlelement ("tns:ParagonBrRac", rac.paragon)),
      -- IRN 4106
      DECODE(NVL(age_oib_l, pkaadr_oib_l), NULL, NULL, XMLELEMENT("tns:OibPrimateljaRacuna", NVL(age_oib_l, pkaadr_oib_l))),
      -- napojnica
      (
      SELECT
        CASE
          WHEN SUM (ABS (iznosNapojnice)) > 0 THEN
            xmlelement ("tns:Napojnica",
              xmlelement ("tns:iznosNapojnice", TRIM (TO_CHAR (SUM (iznosNapojnice), '999999999999990.00'))),
              xmlelement ("tns:nacinPlacanjaNapojnice", recrac_nacin_plac_nap (rac_id_p))
            )
          ELSE NULL
        END
      FROM
        (
        SELECT
          SUM (NVL (iznosNapojnice, 0)) iznosNapojnice
        FROM (
          SELECT SUM (ROUND (NVL (izn_napojnice, 0) * izn_tecaja, 2)) iznosNapojnice FROM t_rac_nap WHERE rac_id = rac_id_p AND ozn_napojnice_l <> 0
          UNION
          SELECT SUM (NVL (izn_napojnice, 0)) iznosNapojnice FROM tpka_rnkasa WHERE rac_id = rac_id_p AND ozn_napojnice_l <> 0)
        )
      )
    ).extract('/*').getclobval()
  INTO
    data_m
  FROM
    t_racuni rac,
    s_vapldok vapldok,
    s_vlasnik vlas
  WHERE
    rac.id = rac_id_p
    AND ((rac.jir IS NULL AND ozn_napojnice_l = 0) OR (rac.jir IS NOT NULL AND ozn_napojnice_l > 0))
    AND rac.vapldok_id = vapldok.id
    AND vapldok.oznaka IN ('GI', 'BI'); -- IRN 4106 

  IF ozn_napojnice_l > 0 THEN
    SELECT
      xmlelement ("tns:NapojnicaZahtjev",
        xmlattributes (
          'http://www.apis-it.hr/fin/2012/types/f73' AS "xmlns:tns",
          'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi"),
        xmlelement ("tns:Zaglavlje", xmlattributes (NULL AS "xmlns:tns"), -- NULL xmlattributes zbog 11g
          xmlelement ("tns:DatumVrijeme", REPLACE (TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS'), ' ', 'T'))
          ),
        xmltype (data_m)
      ).extract('/*').getclobval()
    INTO
      data_m
    FROM dual;
  ELSE
    SELECT
      xmlelement ("tns:RacunZahtjev",
        xmlattributes (
          'http://www.apis-it.hr/fin/2012/types/f73' AS "xmlns:tns",
          'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi"),
        xmlelement ("tns:Zaglavlje", xmlattributes (NULL AS "xmlns:tns"), -- NULL xmlattributes zbog 11g
          xmlelement ("tns:DatumVrijeme", REPLACE (TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS'), ' ', 'T'))
          ),
        xmltype (data_m)
      ).extract('/*').getclobval()
    INTO
      data_m
    FROM dual;
  END IF;

  opis_zahtjev_l := 'RecRacunZahtjev_';
  opis_odgovor_l := 'RecRacunOdgovor_';
  IF ozn_napojnice_l <> 0 THEN
    opis_zahtjev_l := 'RecRacunNapZahtjev_';
    opis_odgovor_l := 'RecRacunNapOdgovor_';
  END IF;

  IF pra_pka_zaj.vrijednost_parametra ('1058') = 'da' THEN -- spremi zahtjeve i odgovore u bazu
    pra_pka2.clob_to_table (pra_pka2.pretty_print_xml (data_m), opis_zahtjev_l || pkaracfis_rec_l.id, rac_id_p, 'I3FISKAL');
  END IF;

  zaj_post;

  IF pra_pka_zaj.vrijednost_parametra ('1058') = 'da' THEN -- spremi zahtjeve i odgovore u bazu
    pra_pka2.clob_to_table (pra_pka2.pretty_print_xml (odgovor_m), opis_odgovor_l || pkaracfis_rec_l.id, rac_id_p, 'I3FISKAL');
  END IF;

  -- obradi odgovor
  /*
  <?xml version="1.0" encoding="UTF-8" standalone="no"?>
  <Response>
    <ZastitniKod>71f05b9f64793a4e72bac10f4ebde569</ZastitniKod>
    <IdPoruke>7edb296a-8a1d-4fd7-a1ac-cc96f4e2239f</IdPoruke>
    <Jir>c8461852-a9f8-4c75-aa8f-afd090e063df</Jir>
    <SifraGreske>s004</SifraGreske>
    <PorukaGreske>Neispravan digitalni potpis.</PorukaGreske>
  </Response>
  */

  SELECT extractvalue (xmltype (odgovor_m), '/Response/IdPoruke'),
         extractvalue (xmltype (odgovor_m), '/Response/SifraGreske'),
         extractvalue (xmltype (odgovor_m), '/Response/PorukaGreske'),
         extractvalue (xmltype (odgovor_m), '/Response/ZastitniKod'),
         extractvalue (xmltype (odgovor_m), '/Response/Jir'),
         extractvalue (xmltype (odgovor_m), '/Response/QRCode')
    INTO pkaracfis_rec_l.id_poruke,
         pkaracfis_rec_l.sifra_greske,
         pkaracfis_rec_l.opis_greske,
         rac_zki_l,
         rac_jir_l,
         rac_qr_l
    FROM dual;

  IF old_rac_jir_l IS NULL THEN
    -- fiskaliziran je raun, auriraj zki i jir
    UPDATE t_racuni SET zki = NVL (zki, rac_zki_l), jir = rac_jir_l WHERE id = rac_id_p AND jir IS NULL;
  END IF;

  SELECT MAX (id)
    INTO racblob_id_l
    FROM t_racuni_blob
   WHERE rac_id = rac_id_p
     AND oznaka = 'gif';

  IF rac_qr_l IS NOT NULL THEN
    rac_qr_blob_l := base64decode (rac_qr_l);

    IF racblob_id_l IS NOT NULL THEN
      UPDATE t_racuni_blob
         SET datoteka = rac_qr_blob_l
       WHERE id = racblob_id_l;
    ELSE
      INSERT INTO t_racuni_blob (rac_id, datoteka, oznaka, status)
        VALUES (rac_id_p, rac_qr_blob_l, 'gif', 0);
    END IF;
  END IF;

  -- auriraj log LPKA_RAC_FIS
  UPDATE lpka_rac_fis
     SET id_poruke = pkaracfis_rec_l.id_poruke,
         dat_obrade = SYSDATE,
         sifra_greske = pkaracfis_rec_l.sifra_greske,
         opis_greske = pkaracfis_rec_l.opis_greske
   WHERE id = pkaracfis_rec_l.id;

  COMMIT;

EXCEPTION
  WHEN OTHERS THEN
    ROLLBACK; -- otkljuaj tablicu t_racuni

    -- auriraj log LPKA_RAC_FIS
    pkaracfis_rec_l.opis_greske := SUBSTR (SQLERRM, 1, 500);
    UPDATE lpka_rac_fis
       SET id_poruke = pkaracfis_rec_l.id_poruke,
           dat_obrade = SYSDATE,
           sifra_greske = pkaracfis_rec_l.sifra_greske,
           opis_greske = pkaracfis_rec_l.opis_greske
     WHERE id = pkaracfis_rec_l.id;
    COMMIT;

    -- RAISE; -- IRN 2562; 27.06.2016 MK komentirano
END;
PROCEDURE I3FISKAL_PKA_RACUN
 (PKARAC_ID_P IN tpka_racuni.id%TYPE
 )
 IS
-- dostavi podatke o PKA GI ili GP raunu i3fiskal servisu
  pkarac_datum_l tpka_racuni.datum%TYPE;
  vapldok_oznaka_l s_vapldok.oznaka%TYPE;
  pkarac_jir_l tpka_racuni.jir%TYPE;
  pkarac_zki_l tpka_racuni.zki%TYPE;
  OibOper_l s_vlasnik.oib%TYPE;
  pkaracfis_rec_l lpka_rac_fis%ROWTYPE;
  nebitno_l NUMBER;
  pkarac_qr_l CLOB;
  pkarac_qr_blob_l BLOB;
  racblob_id_l t_racuni_blob.id%TYPE;

  CURSOR vanjskisus_c (pkarac_id_k NUMBER) IS
    SELECT oib
      FROM s_vlasnik, tpka_racuni pkarac
     WHERE pkarac.id = pkarac_id_k
       AND (pkarac.unos_korisnik LIKE '%WEB' OR
            pkarac.unos_korisnik LIKE '%PHOBS%' OR
            pkarac.unos_korisnik = 'SYNXIS' OR
            pkarac.unos_korisnik = 'IT_API');
            
              
  -- IRN 4106
  pkarac_gmpkom_id_l tpka_racuni.gmpkom_id%TYPE;
  pkarac_pkaadr_id_l tpka_racuni.pkaadr_id%TYPE;
  gmpkom_oib_l mgmp_komitenti.oib%TYPE;
  pkaadr_oib_l mpka_adrese.oib%TYPE;
BEGIN
  IF pkarac_id_p IS NULL THEN
    RETURN;
  END IF;

  SELECT rac.datum, vapldok.oznaka, rac.jir, rac.zki,
         rac.gmpkom_id, rac.pkaadr_id -- IRN 4106 
    INTO pkarac_datum_l, vapldok_oznaka_l, pkarac_jir_l, pkarac_zki_l,
         pkarac_gmpkom_id_l, pkarac_pkaadr_id_l -- IRN 4106
    FROM tpka_racuni rac,
         s_vapldok vapldok
   WHERE rac.id = pkarac_id_p
     AND rac.vapldok_id = vapldok.id;
  IF vlas_u_fsus_hr (pkarac_datum_l) = 0 -- vlasnik nije u fiskalnom sustavu HR ili je datum rauna manji od poetka primjene fiskalnog sustava
    OR vapldok_oznaka_l NOT IN ('GI', 'GP', 'BI', 'BP') -- IRN 4106
    OR pkarac_jir_l IS NOT NULL
  THEN
    RETURN;
  END IF;

  OibOper_l := pra_pka_i3fiskal.oib_test ('99999999999'); -- IRN 3409

  -- vanjski sustavi koji unose predujam
  OPEN vanjskisus_c (pkarac_id_p);
  FETCH vanjskisus_c INTO OibOper_l;
  CLOSE vanjskisus_c;

  data_m := NULL;

  -- upii u log LPKA_RAC_FIS
  pkaracfis_rec_l.id := pra_zmp_zaj.i3_sekvenca (NULL);
  INSERT INTO lpka_rac_fis (id, pkarac_id, dat_slanja) VALUES (pkaracfis_rec_l.id, pkarac_id_p, SYSDATE);
  COMMIT;

  SELECT 1 INTO nebitno_l FROM tpka_racuni WHERE id = pkarac_id_p AND jir IS NULL FOR UPDATE OF zki, jir NOWAIT;
  
  -- IRN 4106
  IF TRUNC(SYSDATE) >= pra_zmp_s.dat_erac_obveze THEN
    SELECT MAX(gmpkom.oib)
      INTO gmpkom_oib_l
      FROM mgmp_komitenti gmpkom, s_zemlje zem
     WHERE gmpkom.id = pkarac_gmpkom_id_l
       AND gmpkom.zem_id = zem.id
       AND zem.sifra_2a = 'HR';

    SELECT MAX(pkaadr.oib)
      INTO pkaadr_oib_l
      FROM mpka_adrese pkaadr, s_zemlje zem
     WHERE pkaadr.id = pkarac_pkaadr_id_l
       AND pkaadr.zem_id = zem.id
       AND zem.sifra_2a = 'HR';
  END IF; 

  SELECT
    xmlelement ("tns:Racun",
      xmlattributes (
          'http://www.apis-it.hr/fin/2012/types/f73' AS "xmlns:tns",
          'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi"),
      xmlelement ("tns:Oib", vlas.oib),
      xmlelement ("tns:USustPdv", pra_pka_i3fiskal.vlas_u_sust_pdv),
      xmlelement ("tns:DatVrijeme", TO_CHAR (pkarac.unos_dat, 'DD.MM.RRRR') || 'T' || TO_CHAR (pkarac.unos_dat, 'HH24:MI:SS')), -- IRN 4134 pkarac.unos_dat
      xmlelement ("tns:OznSlijed", 'N'), -- oznaka slijednosti brojeva računa na razini naplatnog ure?aja
      xmlelement ("tns:BrRac",
        xmlelement ("tns:BrOznRac", TO_NUMBER (pkarac.rbr)),
        xmlelement ("tns:OznPosPr", pkarac.oj_sifra),
        xmlelement ("tns:OznNapUr", pkarac.vdok_sifra2n)
        ),
      (
      SELECT
        CASE
          WHEN SUM (osnovica) IS NOT NULL THEN -- IRN 1899
            xmlelement ("tns:Pdv",
              xmlagg (
                xmlelement ("tns:Porez",
                  xmlelement ("tns:Stopa", TRIM (TO_CHAR (stopa, '990.00'))),
                  xmlelement ("tns:Osnovica", TRIM (TO_CHAR (osnovica, '999999999999990.00'))),
                  xmlelement ("tns:Iznos", TRIM (TO_CHAR (iznos, '999999999999990.00')))
                  )
                )
              )
          ELSE NULL
        END
      FROM
        (
        SELECT
          racpdv.stopa_pdv AS stopa,
          SUM (ROUND (racpdv.iznos, 2)) AS osnovica,
          SUM (racpdv.izn_domval - ROUND (racpdv.iznos, 2)) AS iznos
        FROM
          ipka_rac_pdv racpdv,
          s_vpisporukaz vpispz,
          szmp_spisporuka zmpspisp
        WHERE
          racpdv.pkarac_id = pkarac_id_p
          AND racpdv.vpispz_id = vpispz.id
          AND vpispz.zmpspisp_id = zmpspisp.id
          AND zmpspisp.sifra IN ('20', '30', '40', '50', '60') -- oporezivo; IRN 2423
        GROUP BY
          racpdv.stopa_pdv
        )
      ),
      (
      SELECT
        CASE
          WHEN SUM (osnovica) IS NOT NULL THEN -- IRN 1899
            xmlelement ("tns:Pnp",
              xmlagg (
                xmlelement ("tns:Porez",
                  xmlelement ("tns:Stopa", TRIM (TO_CHAR (stopa, '990.00'))),
                  xmlelement ("tns:Osnovica", TRIM (TO_CHAR (osnovica, '999999999999990.00'))),
                  xmlelement ("tns:Iznos", TRIM (TO_CHAR (iznos, '999999999999990.00')))
                  )
                )
              )
          ELSE NULL
        END
      FROM
        -- IRN 3733
        (
        SELECT stopa,
           SUM (osnovica) AS osnovica,
           SUM (iznos) AS iznos
        FROM
          (
          SELECT -- rauni sa kasa
            stopa_ppot AS stopa,
            izn_osnovice_ppot AS osnovica,
            izn_ppot AS iznos
           FROM
            tpka_rnkasa
          WHERE
            pkarac_id = pkarac_id_p
            AND izn_ppot <> 0
          )
        WHERE
          iznos <> 0
        GROUP BY
          stopa
        )
      ),
      (
      SELECT
        DECODE (IznosOslobPdv, NULL, NULL, xmlelement ("tns:IznosOslobPdv", TRIM (TO_CHAR (IznosOslobPdv, '999999999999990.00'))))
      FROM
        (
        SELECT
          SUM (ROUND (racpdv.iznos, 2)) AS IznosOslobPdv
        FROM
          ipka_rac_pdv racpdv,
          s_vpisporukaz vpispz,
          szmp_spisporuka zmpspisp
        WHERE
          racpdv.pkarac_id = pkarac_id_p
          AND racpdv.vpispz_id = vpispz.id
          AND vpispz.zmpspisp_id = zmpspisp.id
          AND zmpspisp.sifra IN ('11', '12', '13') -- osloboeno poreza
        )
      ),
      (
      SELECT
        DECODE (IznosNePodlOpor, NULL, NULL, xmlelement ("tns:IznosNePodlOpor", TRIM (TO_CHAR (IznosNePodlOpor, '999999999999990.00'))))
      FROM
        (
        SELECT
          SUM (ROUND (racpdv.iznos, 2)) AS IznosNePodlOpor
        FROM
          ipka_rac_pdv racpdv,
          s_vpisporukaz vpispz,
          szmp_spisporuka zmpspisp
        WHERE
          racpdv.pkarac_id = pkarac_id_p
          AND racpdv.vpispz_id = vpispz.id
          AND vpispz.zmpspisp_id = zmpspisp.id
          AND zmpspisp.sifra IN ('10') -- ne podlijee oporezivanju
        )
      ),
      (
      SELECT
        CASE
          WHEN SUM (iznosN) <> 0 THEN -- IRN 3813
            xmlelement ("tns:Naknade",
              xmlagg (
                xmlelement ("tns:Naknada",
                  xmlelement ("tns:NazivN", nazivN),
                  xmlelement ("tns:IznosN", TRIM (TO_CHAR (iznosN, '999999999999990.00')))
                )
              )
            )
          ELSE NULL
        END
      FROM
        (
        SELECT
          'Povratna naknada' AS nazivN,
          SUM (izn_pnaknade) AS iznosN
        FROM
          tpka_rnkasa
        WHERE
          pkarac_id = pkarac_id_p
          AND NVL (izn_pnaknade, 0) <> 0
        )
      ),
      xmlelement ("tns:IznosUkupno", TRIM (TO_CHAR (ROUND (pra_pka_s2.pkarac_iznos_bruto (pkarac.id, pkarac.iznos, pkarac.izn_tecaja) * pkarac.izn_tecaja, 2), '999999999999990.00'))),
      xmlelement ("tns:NacinPlac", pra_pka_i3fiskal.pkarac_nacin_plac (pkarac.id)),
      (
      SELECT  xmlelement ("tns:OibOper", DECODE (TrebaOib, 0, vlas.oib, NVL (OibOper, OibOper_l)))
        FROM
          (
          SELECT
            MAX (kor.sifra) AS OibOper,
            MAX (kor.ozn_ima_oib) AS TrebaOib
          FROM
            tpka_racuni pkarac,
            m_korisnici kor
          WHERE
            pkarac.id = pkarac_id_p
            AND pkarac.unos_korisnik = kor.naziv
          )
      ),
      xmlelement ("tns:ZastKod", pkarac.zki),
      xmlelement ("tns:NakDost", DECODE (pkarac.zki, NULL, 'false', 'true')),
      DECODE (pkarac.paragon, NULL, NULL, xmlelement ("tns:ParagonBrRac", pkarac.paragon)),
      -- IRN 4106
      DECODE(NVL(gmpkom_oib_l, pkaadr_oib_l), NULL, NULL, XMLELEMENT("tns:OibPrimateljaRacuna", NVL(gmpkom_oib_l, pkaadr_oib_l)))
    ).extract('/*').getclobval()
  INTO
    data_m
  FROM
    tpka_racuni pkarac,
    s_vapldok vapldok,
    s_vlasnik vlas
  WHERE
    pkarac.id = pkarac_id_p
    AND pkarac.jir IS NULL
    AND pkarac.vapldok_id = vapldok.id
    AND vapldok.oznaka IN ('GI', 'GP', 'BI', 'BP'); -- IRN 4106


  SELECT
    xmlelement ("tns:RacunZahtjev",
      xmlattributes (
        'http://www.apis-it.hr/fin/2012/types/f73' AS "xmlns:tns",
        'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi"),
      xmlelement ("tns:Zaglavlje", xmlattributes (NULL AS "xmlns:tns"), -- NULL xmlattributes zbog 11g
        xmlelement ("tns:DatumVrijeme", REPLACE (TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS'), ' ', 'T'))
        ),
      xmltype(data_m)
    ).extract('/*').getclobval()
  INTO
    data_m
  FROM dual;
    
  IF pra_pka_zaj.vrijednost_parametra ('1058') = 'da' THEN -- spremi zahtjeve i odgovore u bazu
    pra_pka2.clob_to_table (pra_pka2.pretty_print_xml (data_m), 'PkaRacunZahtjev_' || pkaracfis_rec_l.id, pkarac_id_p, 'I3FISKAL');
  END IF;

  zaj_post;

  IF pra_pka_zaj.vrijednost_parametra ('1058') = 'da' THEN -- spremi zahtjeve i odgovore u bazu
    pra_pka2.clob_to_table (pra_pka2.pretty_print_xml (odgovor_m), 'PkaRacunOdgovor_' || pkaracfis_rec_l.id, pkarac_id_p, 'I3FISKAL');
  END IF;

  -- obradi odgovor
  SELECT extractvalue (xmltype (odgovor_m), '/Response/IdPoruke'),
         extractvalue (xmltype (odgovor_m), '/Response/SifraGreske'),
         extractvalue (xmltype (odgovor_m), '/Response/PorukaGreske'),
         extractvalue (xmltype (odgovor_m), '/Response/ZastitniKod'),
         extractvalue (xmltype (odgovor_m), '/Response/Jir'),
         extractvalue (xmltype (odgovor_m), '/Response/QRCode')
    INTO pkaracfis_rec_l.id_poruke,
         pkaracfis_rec_l.sifra_greske,
         pkaracfis_rec_l.opis_greske,
         pkarac_zki_l,
         pkarac_jir_l,
         pkarac_qr_l
    FROM dual;

  -- auriraj raun
  UPDATE tpka_racuni SET zki = NVL (zki, pkarac_zki_l), jir = pkarac_jir_l WHERE id = pkarac_id_p AND jir IS NULL;

  SELECT MAX (id)
    INTO racblob_id_l
    FROM t_racuni_blob
   WHERE pkarac_id = pkarac_id_p
     AND oznaka = 'gif';

  IF pkarac_qr_l IS NOT NULL THEN
    pkarac_qr_blob_l := base64decode (pkarac_qr_l);

    IF racblob_id_l IS NOT NULL THEN
      UPDATE t_racuni_blob
         SET datoteka = pkarac_qr_blob_l
       WHERE id = racblob_id_l;
    ELSE
      INSERT INTO t_racuni_blob (pkarac_id, datoteka, oznaka, status)
        VALUES (pkarac_id_p, pkarac_qr_blob_l, 'gif', 0);
    END IF;
  END IF;

  -- auriraj log LPKA_RAC_FIS
  UPDATE lpka_rac_fis
     SET id_poruke = pkaracfis_rec_l.id_poruke,
         dat_obrade = SYSDATE,
         sifra_greske = pkaracfis_rec_l.sifra_greske,
         opis_greske = pkaracfis_rec_l.opis_greske
   WHERE id = pkaracfis_rec_l.id;

  COMMIT;

EXCEPTION
  WHEN OTHERS THEN
    ROLLBACK; -- otkljuaj tablicu TPKA_RACUNI

    -- auriraj log LPKA_RAC_FIS
    pkaracfis_rec_l.opis_greske := SUBSTR (SQLERRM, 1, 500);
    UPDATE lpka_rac_fis
       SET id_poruke = pkaracfis_rec_l.id_poruke,
           dat_obrade = SYSDATE,
           sifra_greske = pkaracfis_rec_l.sifra_greske,
           opis_greske = pkaracfis_rec_l.opis_greske
     WHERE id = pkaracfis_rec_l.id;
    COMMIT;
END;
FUNCTION I3FISKAL_ECHO
 RETURN VARCHAR2
 IS
--
  poruka_l VARCHAR2(2000);
  poruka_greske_l VARCHAR2(2000);
  timestamp_l VARCHAR(30);
BEGIN
  /*
  <tns:EchoRequest xmlns:tns="http://www.apis-it.hr/fin/2012/types/f73" xmlns:xsi=http://www.w3.org/2001/XMLSchema-instance xsi:schemaLocation="http://www.apis-it.hr/fin/2012/types/f73 FiskalizacijaSchema.xsd ">
    proizvoljan tekst
  </tns:EchoRequest>
  */

  data_m := NULL;

  SELECT
    xmlelement ("tns:EchoRequest",
      xmlattributes (
        'http://www.apis-it.hr/fin/2012/types/f73' AS "xmlns:tns",
        'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi"),
        'Echo'
      ).extract('/*').getclobval()
  INTO
    data_m
  FROM
    dual;

  IF pra_pka_zaj.vrijednost_parametra ('1058') = 'da' THEN -- spremi zahtjeve i odgovore u bazu
    timestamp_l := TO_CHAR (SYSDATE, 'ddmmrrrrhh24miss');
    pra_pka2.clob_to_table (pra_pka2.pretty_print_xml (data_m), 'Echo_' || timestamp_l, NULL, 'I3FISKAL');
  END IF;

  zaj_post;

  IF pra_pka_zaj.vrijednost_parametra ('1058') = 'da' THEN -- spremi zahtjeve i odgovore u bazu
    pra_pka2.clob_to_table (pra_pka2.pretty_print_xml (odgovor_m), 'Echo_' || timestamp_l || '_R', NULL, 'I3FISKAL');
  END IF;

  -- obradi odgovor
  /*
  <?xml version="1.0" encoding="UTF-8" standalone="no"?>
  <Response>
    <Echo>Echo</Echo>
  </Response>
  */

  SELECT extractvalue (xmltype (odgovor_m), '/Response/Echo'),
         extractvalue (xmltype (odgovor_m), '/Response/PorukaGreske')
    INTO poruka_l, poruka_greske_l
    FROM dual;

  IF poruka_l IS NULL THEN
    -- Pogreka u komunikaciji (#0).
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20505, poruka_greske_l);
  END IF;

  RETURN poruka_l;
END;
PROCEDURE I3FISKAL_PKAPD
 (PKAPD_ID_P IN TPKA_PDOKUMENTI.ID%TYPE
 )
 IS
-- dostavi podatke o prateem dokumentu i3fiskal servisu
  ozn_vlastiti_pkapd_l tpka_pdokumenti.ozn_vlastiti%TYPE;
  datum_pkapd_l        tpka_pdokumenti.datum%TYPE;
  jir_pkapd_l          tpka_pdokumenti.jir%TYPE;
  zki_pkapd_l          tpka_pdokumenti.zki%TYPE;
  pkaracfis_r_l        lpka_rac_fis%ROWTYPE;

  nebitno_l NUMBER;
BEGIN

  IF pkapd_id_p IS NULL
    OR TRUNC (SYSDATE) >= pra_zmp_s.dat_prestanka_pd -- IRN 4079
  THEN
    RETURN;
  END IF;

  SELECT datum, jir, ozn_vlastiti
    INTO datum_pkapd_l, jir_pkapd_l, ozn_vlastiti_pkapd_l
    FROM tpka_pdokumenti
   WHERE id = pkapd_id_p;

  IF vlas_u_fsus_hr (datum_pkapd_l) = 0 -- vlasnik nije u fiskalnom sustavu HR ili je datum rauna manji od poetka primjene fiskalnog sustava
    OR jir_pkapd_l IS NOT NULL
    OR ozn_vlastiti_pkapd_l = 0
  THEN
    RETURN;
  END IF;

  data_m := NULL;

  -- upii u log LPKA_RAC_FIS
  pkaracfis_r_l.id := pra_zmp_zaj.i3_sekvenca (NULL);
  INSERT INTO lpka_rac_fis (id, pkapd_id, dat_slanja) VALUES (pkaracfis_r_l.id, pkapd_id_p, SYSDATE);
  COMMIT;

  /*
  <tns:PrateciDokumentiZahtjev>
    <tns:Zaglavlje>
      <tns:IdPoruke>718372db-7f8f-4341-7018-e9af7896d192</tns:IdPoruke>
      <tns:DatumVrijeme>24.01.2020T09:18:53</tns:DatumVrijeme>
    </tns:Zaglavlje>
    <tns:PrateciDokument>
      <tns:Oib>98765432198</tns:Oib>
      <tns:DatVrijeme>24.01.2020T09:17:53</tns:DatVrijeme>
      <tns:BrPratecegDokumenta>
        <tns:BrOznPD>39</tns:BrOznPD>
        <tns:OznPosPr>PL1</tns:OznPosPr>
        <tns:OznNapUr>2</tns:OznNapUr>
      </tns:BrPratecegDokumenta>
      <tns:IznosUkupno>760.00</tns:IznosUkupno>
      <tns:ZastKodPD>7d0dbe602dff64ebf3000ce1f743dc1f</tns:ZastKodPD>
      <tns:NakDost>false</tns:NakDost>
    </tns:PrateciDokument>
  </tns:PrateciDokumentiZahtjev>
  */

  SELECT 1 INTO nebitno_l FROM tpka_pdokumenti WHERE id = pkapd_id_p AND jir IS NULL FOR UPDATE OF zki, jir NOWAIT;

  SELECT xmlelement ("tns:PrateciDokumentiZahtjev",
           xmlattributes (
             'http://www.apis-it.hr/fin/2012/types/f73' AS "xmlns:tns",
             'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi"),
           xmlelement ("tns:Zaglavlje", xmlattributes (NULL AS "xmlns:tns"), -- NULL xmlattributes zbog 11g
             xmlelement ("tns:DatumVrijeme", REPLACE (TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS'), ' ', 'T'))
             ),
           xmlelement ("tns:PrateciDokument", xmlattributes (NULL AS "xmlns:tns"), -- NULL xmlattributes zbog 11g
             xmlelement ("tns:Oib", vla.oib),
             xmlelement ("tns:DatVrijeme", TO_CHAR (pkapd.datum, 'DD.MM.RRRR') || 'T' || TO_CHAR (pkapd.unos_dat, 'HH24:MI:SS')),
             xmlelement ("tns:BrPratecegDokumenta",
               xmlelement ("tns:BrOznPD", TO_NUMBER (pkapd.rbr)),
               xmlelement ("tns:OznPosPr", pkapd.oj_sifra),
               xmlelement ("tns:OznNapUr", pkapd.vdok_sifra2n)
               ),
             xmlelement ("tns:IznosUkupno", TRIM (TO_CHAR (ROUND (pkapd.iznos * pkapd.izn_tecaja, 2), '999999999999990.00'))),
             xmlelement ("tns:ZastKodPD", pkapd.zki),
             xmlelement ("tns:NakDost", DECODE (pkapd.zki, NULL, 'false', 'true'))
             )
           ).extract('/*').getclobval()
    INTO data_m
    FROM tpka_pdokumenti pkapd,
         s_vlasnik vla
   WHERE pkapd.id = pkapd_id_p;

  IF pra_pka_zaj.vrijednost_parametra ('1058') = 'da' THEN -- spremi zahtjeve i odgovore u bazu
    pra_pka2.clob_to_table (pra_pka2.pretty_print_xml (data_m), 'PrateciDokumentiZahtjev_' || pkaracfis_r_l.id, pkapd_id_p, 'I3FISKAL');
  END IF;

  zaj_post;

  IF pra_pka_zaj.vrijednost_parametra ('1058') = 'da' THEN -- spremi zahtjeve i odgovore u bazu
    pra_pka2.clob_to_table (pra_pka2.pretty_print_xml (odgovor_m), 'PrateciDokumentiOdgovor_' || pkaracfis_r_l.id, pkapd_id_p, 'I3FISKAL');
  END IF;

  -- obradi odgovor
  /*
  <Response>
    <ZastitniKodPD>a2b1c068ac3b38a963ceee54d1c97a6a</ZastitniKodPD>
    <IdPoruke>8cb58c9e-3bee-4d81-9379-1be31a1129bd</IdPoruke>
    <Jir>852dfc0f-ad76-4fd6-bee1-1bd2c10bc8b0</Jir>
  </Response>
  */

  SELECT extractvalue (xmltype (odgovor_m), '/Response/IdPoruke'),
         extractvalue (xmltype (odgovor_m), '/Response/SifraGreske'),
         extractvalue (xmltype (odgovor_m), '/Response/PorukaGreske'),
         extractvalue (xmltype (odgovor_m), '/Response/ZastitniKodPD'),
         extractvalue (xmltype (odgovor_m), '/Response/Jir')
    INTO pkaracfis_r_l.id_poruke,
         pkaracfis_r_l.sifra_greske,
         pkaracfis_r_l.opis_greske,
         zki_pkapd_l,
         jir_pkapd_l
    FROM dual;

  -- auriraj pratei dokument
  UPDATE tpka_pdokumenti SET zki = NVL (zki, zki_pkapd_l), jir = jir_pkapd_l WHERE id = pkapd_id_p AND jir IS NULL;

  -- auriraj log LPKA_RAC_FIS
  UPDATE lpka_rac_fis
     SET id_poruke = pkaracfis_r_l.id_poruke,
         dat_obrade = SYSDATE,
         sifra_greske = pkaracfis_r_l.sifra_greske,
         opis_greske = pkaracfis_r_l.opis_greske
   WHERE id = pkaracfis_r_l.id;

  COMMIT;

EXCEPTION
  WHEN OTHERS THEN
    ROLLBACK; -- otkljuaj tablicu tpka_pdokumenti

    -- auriraj log LPKA_RAC_FIS
    pkaracfis_r_l.opis_greske := SUBSTR (SQLERRM, 1, 500);
    UPDATE lpka_rac_fis
       SET id_poruke = pkaracfis_r_l.id_poruke,
           dat_obrade = SYSDATE,
           sifra_greske = pkaracfis_r_l.sifra_greske,
           opis_greske = pkaracfis_r_l.opis_greske
     WHERE id = pkaracfis_r_l.id;
    COMMIT;
END;
FUNCTION VLAS_U_FSUS_SI
 (DATUM_P IN DATE := TRUNC (SYSDATE)
 )
 RETURN NUMBER
 IS
-- IRN 2434; vraa -1 ako je vlasnik u fiskalnom sustavu SI i datum primjene fiskalnog sustava manji ili jednak promatranom
  br_redaka_l NUMBER;
BEGIN

  SELECT COUNT (1) INTO br_redaka_l
    FROM s_vlasnik
   WHERE ozn_fsustava = 'SI'
     AND dat_primjene <= TRUNC (datum_p);

  IF br_redaka_l = 1 THEN
    RETURN (-1);
  ELSE
    RETURN (0);
  END IF;

END;
PROCEDURE I3FISKAL_BUSINESS_PREMISE
 (ZMPOJR_ID_P IN mzmp_ojr.id%TYPE
 )
 IS
-- IRN 2434; dostavi podatke o poslovnom prostoru i3fiskal servisu
  br_redaka_l NUMBER;
  zmpojrfis_rec_l lzmp_ojr_fis%ROWTYPE;
  vlas_oib_l s_vlasnik.oib%TYPE;
  vlas_oib_centar_l s_vlasnik.oib%TYPE;
  zmpojr_metcvor_sifra_l mzmp_ojr.metcvor_sifra%TYPE;
  zmpojr_metcvor_sifra_gas_l mzmp_ojr.metcvor_sifra_gas%TYPE;
BEGIN
  IF zmpojr_id_p IS NULL
    OR vlas_u_fsus_si = 0 -- vlasnik nije u fiskalnom sustavu SI
  THEN
    RETURN;
  END IF;

  SELECT COUNT (ROWID) INTO br_redaka_l
    FROM mzmp_ojr
   WHERE id = zmpojr_id_p
     AND dat_ponisten IS NOT NULL
     AND dat_ponisten <= TRUNC (SYSDATE);
  IF br_redaka_l = 1 THEN
    RETURN; -- podaci o ponitenim (zatvorenim) poslovnim prostorima se ne dostavljaju
  END IF;

  IF pra_zmp_zaj.centar = 0 THEN
    SELECT oib INTO vlas_oib_l FROM s_vlasnik;
    EXECUTE IMMEDIATE 'SELECT oib FROM s_vlasnik@' || pra_zmp_zaj.vrijednost_parametra ('0018') INTO vlas_oib_centar_l;
    IF vlas_oib_l = vlas_oib_centar_l THEN
      -- Samo centar moe dostavljati podatke o poslovnim prostorima
      RETURN;
    END IF;
    SELECT metcvor_sifra, metcvor_sifra_gas INTO zmpojr_metcvor_sifra_l, zmpojr_metcvor_sifra_gas_l FROM mzmp_ojr WHERE id = zmpojr_id_p;
    IF zmpojr_metcvor_sifra_l IS NOT NULL AND zmpojr_metcvor_sifra_gas_l IS NOT NULL
      AND zmpojr_metcvor_sifra_l <> zmpojr_metcvor_sifra_gas_l
    THEN
      -- Ne znam kojoj shemi pripada knjiga rauna.
      RETURN;
    END IF;
    IF NVL (zmpojr_metcvor_sifra_l, zmpojr_metcvor_sifra_gas_l) <> pra_zmp_zaj.tekuci_cvor THEN
      -- vor ne-centar moe dostavljati podatke o svojim poslovnim prostorima
      RETURN;
    END IF;
  END IF;

  /*
  <fu:BusinessPremiseRequest Id="data">
    <fu:Header>
      <fu:MessageID>4e64a93a-40fa-4c02-afb1-488534b85e4c</fu:MessageID>
      <fu:DateTime>2015-07-17T09:30:47Z</fu:DateTime>
    </fu:Header>
    <fu:BusinessPremise>
      <fu:TaxNumber>99999862</fu:TaxNumber>
      <fu:BusinessPremiseID>36CF</fu:BusinessPremiseID>
      <fu:BPIdentifier>
        <fu:RealEstateBP> -- ili <fu:PremiseType>
          <fu:PropertyID>
            <fu:CadastralNumber>365</fu:CadastralNumber>
            <fu:BuildingNumber>12</fu:BuildingNumber>
            <fu:BuildingSectionNumber>3</fu:BuildingSectionNumber>
          </fu:PropertyID>
          <fu:Address>
            <fu:Street>Dunajska cesta</fu:Street>
            <fu:HouseNumber>24</fu:HouseNumber>
            <fu:HouseNumberAdditional>B</fu:HouseNumberAdditional>
            <fu:Community>Ljubljana</fu:Community>
            <fu:City>Ljubljana</fu:City>
            <fu:PostalCode>1000</fu:PostalCode>
          </fu:Address>
        </fu:RealEstateBP>
      </fu:BPIdentifier>
      <fu:ValidityDate>1990-08-25</fu:ValidityDate>
      <fu:ClosingTag>Z</fu:ClosingTag> -- trajno zatvaranje poslovnog prostora
      <fu:SoftwareSupplier>
        <fu:TaxNumber>24564444</fu:TaxNumber> -- ili <fu:NameForeign>
      </fu:SoftwareSupplier>
      <fu:SpecialNotes>Primer prijave poslovnega prostora</fu:SpecialNotes>
    </fu:BusinessPremise>
  </fu:BusinessPremiseRequest>
  */

  data_m := NULL;

  -- upii u log LZMP_OJR_FIS
  zmpojrfis_rec_l.id := pra_zmp_zaj.i3_sekvenca (NULL);
  INSERT INTO lzmp_ojr_fis (id, zmpojr_id, dat_slanja) VALUES (zmpojrfis_rec_l.id, zmpojr_id_p, SYSDATE);
  COMMIT;

  /*
  atribut xmlns:fu dodan je u <fu:BusinessPremiseRequest> zato da se ne javlja greka
  LPX-00234: namespace prefix "fu" is not declared
  */
  SELECT
    xmlelement ("fu:BusinessPremiseRequest", xmlattributes ('http://www.fu.gov.si/' AS "xmlns:fu", 'data' AS "Id"),
      xmlelement ("fu:Header",
        -- xmlelement ("fu:DateTime", REPLACE (TO_CHAR (SYSDATE, 'RRRR-MM-DD HH24:MI:SS'), ' ', 'T') || 'Z')
        xmlelement ("fu:DateTime", REPLACE (TO_CHAR (SYSDATE, 'RRRR-MM-DD HH24:MI:SS'), ' ', 'T'))
        ),
      xmlelement ("fu:BusinessPremise", xmlattributes (NULL AS "xmlns:fu"), -- NULL xmlattributes zbog 11g
        xmlelement ("fu:TaxNumber", vlas.oib),
        xmlelement ("fu:BusinessPremiseID", oj.sifra),
        xmlelement ("fu:BPIdentifier",
          DECODE (zmpojr.ozn_pokretan_pp, NULL,
            xmlelement ("fu:RealEstateBP",
              xmlelement ("fu:PropertyID",
                xmlelement ("fu:CadastralNumber", zaj_replace (zmpojr.br_katastarske_opcine)),
                xmlelement ("fu:BuildingNumber", zaj_replace (zmpojr.br_zgrade)),
                xmlelement ("fu:BuildingSectionNumber", zaj_replace (zmpojr.br_dijela_zgrade))
                ),
            xmlelement ("fu:Address",
              xmlelement ("fu:Street", zaj_replace (zmpojr.naz_ulice)),
              xmlelement ("fu:HouseNumber", zaj_replace (zmpojr.br_kucni)),
              DECODE(zaj_replace (zmpojr.br_kucni2), NULL, NULL, xmlelement ("fu:HouseNumberAdditional", zaj_replace (zmpojr.br_kucni2))),
              xmlelement ("fu:Community", zaj_replace (zmpojr.naz_naselja)),
              xmlelement ("fu:City", zaj_replace (pos.naziv)),
              xmlelement ("fu:PostalCode", SUBSTR(zaj_replace (pos.broj), 1, 4))
              )
            ),
            xmlelement ("fu:PremiseType", zmpojr.ozn_pokretan_pp)
          )
        ),
        xmlelement ("fu:ValidityDate", TO_CHAR (zmpojr.dat_primjene, 'RRRR-MM-DD')),
        -- xmlelement ("fu:ClosingTag", 'Z'), -- in cases of permanent closure
        xmlelement ("fu:SoftwareSupplier",
          -- xmlelement ("fu:TaxNumber", NULL), -- the software supplier is established in Slovenia
          xmlelement ("fu:NameForeign", 'ISTRA TECH d.o.o., Rue Petrovi 12, 52100 Pula, Hrvaka')
          )/*,
        xmlelement ("fu:SpecialNotes", NULL) -- ? zaj_replace (zmpojr.radno_vrijeme)
        */
      )
    ).extract('/*').getclobval()
  INTO
    data_m
  FROM
    mzmp_ojr zmpojr,
    m_oj oj,
    m_poste pos,
    s_vlasnik vlas
  WHERE
    zmpojr.id = zmpojr_id_p
    AND zmpojr.id = oj.id
    AND zmpojr.pos_id = pos.id;

  IF pra_pka_zaj.vrijednost_parametra ('1058') = 'da' THEN -- spremi zahtjeve i odgovore u bazu
    pra_pka2.clob_to_table (pra_pka2.pretty_print_xml (data_m), 'BusinessPremiseRequest_' || zmpojrfis_rec_l.id, zmpojr_id_p, 'I3FISKAL');
  END IF;

  zaj_post;

  IF pra_pka_zaj.vrijednost_parametra ('1058') = 'da' THEN -- spremi zahtjeve i odgovore u bazu
    pra_pka2.clob_to_table (pra_pka2.pretty_print_xml (odgovor_m), 'BusinessPremiseResponse_' || zmpojrfis_rec_l.id, zmpojr_id_p, 'I3FISKAL'); -- IRN 3409
  END IF;

  -- obradi odgovor
  /*
  <?xml version="1.0" encoding="UTF-8" standalone="no"?>
  <Response>
    <SifraGreske>s004</SifraGreske>
    <PorukaGreske>Neispravan digitalni potpis.</PorukaGreske>
    <IdPoruke>7edb296a-8a1d-4fd7-a1ac-cc96f4e2239f</IdPoruke>
  </Response>
  */

  SELECT extractvalue (xmltype (odgovor_m), '/Response/IdPoruke'),
         extractvalue (xmltype (odgovor_m), '/Response/SifraGreske'),
         extractvalue (xmltype (odgovor_m), '/Response/PorukaGreske')
    INTO zmpojrfis_rec_l.id_poruke,
         zmpojrfis_rec_l.sifra_greske,
         zmpojrfis_rec_l.opis_greske
    FROM dual;

  -- auriraj log LZMP_OJR_FIS
  UPDATE lzmp_ojr_fis
     SET id_poruke = zmpojrfis_rec_l.id_poruke,
         dat_obrade = SYSDATE,
         sifra_greske = zmpojrfis_rec_l.sifra_greske,
         opis_greske = zmpojrfis_rec_l.opis_greske
   WHERE id = zmpojrfis_rec_l.id;
  COMMIT;

EXCEPTION
  WHEN OTHERS THEN
    -- auriraj log LZMP_OJR_FIS
    zmpojrfis_rec_l.opis_greske := SUBSTR (SQLERRM, 1, 500);
    UPDATE lzmp_ojr_fis
       SET id_poruke = zmpojrfis_rec_l.id_poruke,
           dat_obrade = SYSDATE,
           sifra_greske = zmpojrfis_rec_l.sifra_greske,
           opis_greske = zmpojrfis_rec_l.opis_greske
     WHERE id = zmpojrfis_rec_l.id;
    COMMIT;
END;
PROCEDURE I3FISKAL_REC_RACUN_SI
 (RAC_ID_P IN t_racuni.id%TYPE
 )
 IS
-- dostavi podatke o REC GI raunu i3fiskal servisu
  rac_datum_l t_racuni.datum%TYPE;
  vapldok_oznaka_l s_vapldok.oznaka%TYPE;
  rac_jir_l t_racuni.jir%TYPE;
  rac_zki_l t_racuni.zki%TYPE;
  rac_qr_l CLOB;
  rac_qr_blob_l BLOB;
  OibOper_l s_vlasnik.oib%TYPE;
  pkaracfis_rec_l lpka_rac_fis%ROWTYPE;
  nebitno_l NUMBER;
  racblob_id_l t_racuni_blob.id%TYPE;
  paragon_l NUMBER(2);
BEGIN
  IF rac_id_p IS NULL THEN
    RETURN;
  END IF;

  SELECT rac.datum, vapldok.oznaka, rac.jir, rac.zki,
         DECODE (rac.paragon, NULL, 0, -1) +
           DECODE (rac.paragon_set, NULL, 0, -1) +
           DECODE (rac.paragon_serija, NULL, 0, -1)
    INTO rac_datum_l, vapldok_oznaka_l, rac_jir_l, rac_zki_l, paragon_l
    FROM t_racuni rac,
         s_vapldok vapldok
   WHERE rac.id = rac_id_p
     AND rac.vapldok_id = vapldok.id;
  IF vlas_u_fsus_si (rac_datum_l) = 0 -- vlasnik nije u fiskalnom sustavu SI ili je datum rauna manji od poetka primjene fiskalnog sustava
    OR vapldok_oznaka_l <> 'GI'
    OR rac_jir_l IS NOT NULL
  THEN
    RETURN;
  END IF;

  OibOper_l := pra_pka_i3fiskal.oib_test ('12345678'); -- IRN 3409

  data_m := NULL;

  -- upii u log LPKA_RAC_FIS
  pkaracfis_rec_l.id := pra_zmp_zaj.i3_sekvenca (NULL);
  INSERT INTO lpka_rac_fis (id, rac_id, dat_slanja) VALUES (pkaracfis_rec_l.id, rac_id_p, SYSDATE);
  COMMIT;

  SELECT 1 INTO nebitno_l FROM t_racuni WHERE id = rac_id_p AND jir IS NULL FOR UPDATE OF zki, jir NOWAIT;

  IF NOT (paragon_l = -3) THEN
    /*
    <fu:InvoiceRequest Id="test">
      <fu:Header>
        <fu:MessageID>4e64a93a-40fa-4c02-afb1-488534b85e4c</fu:MessageID>
        <fu:DateTime>2015-08-07T13:05:24</fu:DateTime>
      </fu:Header>
      <fu:Invoice>
        <fu:TaxNumber>99999862</fu:TaxNumber>
        <fu:IssueDateTime>2015-08-07T13:05:24</fu:IssueDateTime>
        <fu:NumberingStructure>B</fu:NumberingStructure>
        <fu:InvoiceIdentifier>
          <fu:BusinessPremiseID>TRGOVINA1</fu:BusinessPremiseID>
          <fu:ElectronicDeviceID>BLAG2</fu:ElectronicDeviceID>
          <fu:InvoiceNumber>145</fu:InvoiceNumber>
        </fu:InvoiceIdentifier>
        <fu:InvoiceAmount>66.71</fu:InvoiceAmount>
        <fu:PaymentAmount>1047.76</fu:PaymentAmount>
        <fu:TaxesPerSeller>
          <fu:VAT>
            <fu:TaxRate>22.00</fu:TaxRate>
            <fu:TaxableAmount>23.14</fu:TaxableAmount>
            <fu:TaxAmount>5.09</fu:TaxAmount>
          </fu:VAT>
          <fu:VAT>
            <fu:TaxRate>9.50</fu:TaxRate>
            <fu:TaxableAmount>35.14</fu:TaxableAmount>
            <fu:TaxAmount>3.34</fu:TaxAmount>
          </fu:VAT>
        </fu:TaxesPerSeller>
        <fu:OperatorTaxNumber>12345678</fu:OperatorTaxNumber>
        <fu:ProtectedID>34905bcff14b381039af2e9d7eee54bb</fu:ProtectedID>
      </fu:Invoice>
    </fu:InvoiceRequest>
    */
    SELECT
      xmlelement ("fu:InvoiceRequest",
        xmlattributes ('http://www.fu.gov.si/' AS "xmlns:fu",
          'test' AS "Id"),
        xmlelement ("fu:Header",
          xmlelement ("fu:DateTime", REPLACE (TO_CHAR (SYSDATE, 'RRRR-MM-DD HH24:MI:SS'), ' ', 'T')) -- GGGG-MM-DDTHH:MM:SS
          ),
        xmlelement ("fu:Invoice",
          xmlelement ("fu:TaxNumber", vlas.oib),
          xmlelement ("fu:IssueDateTime", TO_CHAR (rac.datum, 'RRRR-MM-DD') || 'T' || TO_CHAR (rac.unos_dat, 'HH24:MI:SS')),
          xmlelement ("fu:NumberingStructure", 'B'),
          xmlelement ("fu:InvoiceIdentifier",
            xmlelement ("fu:BusinessPremiseID", rac.oj_sifra),
            xmlelement ("fu:ElectronicDeviceID", rac.vdok_sifra2n),
            xmlelement ("fu:InvoiceNumber", TO_NUMBER (rac.rbr))), -- oznaka slijednosti brojeva rauna na razini naplatnog ureaja
          (SELECT DECODE (OibKupca, NULL, NULL, xmlelement ("fu:CustomerVATNumber", OibKupca))
             FROM (SELECT DECODE (zem.sifra_2a, pra_rec_zaj.vrijednost_parametra ('0002'), age.oib, age.br_porezni) OibKupca
                     FROM m_agencije age,
                          s_zemlje zem,
                          t_racuni rac
                    WHERE rac.id = rac_id_p
                      AND age.id = pra_rec2.agek_id (rac.age_id, rac.agep_id)
                      AND zem.id = age.zem_id
                    UNION
                   SELECT DECODE (zem.sifra_2a, pra_rec_zaj.vrijednost_parametra ('0002'), pkaadr.oib, pkaadr.br_porezni)
                     FROM mpka_adrese pkaadr,
                          s_zemlje zem,
                          t_racuni rac
                    WHERE rac.id = rac_id_p
                      AND pkaadr.id = rac.pkaadr_id
                      AND zem.id = pkaadr.zem_id)
          ),
          xmlelement ("fu:InvoiceAmount", TRIM (TO_CHAR (ROUND (pra_rec_s2.iznos_racuna_bruto (rac.id, rac.iznos, rac.izn_tecaja) * rac.izn_tecaja, 2), '999999999999990.00'))),
          -- xmlelement ("fu:ReturnsAmount", NULL), -- provizija, predujmovi?
          xmlelement ("fu:PaymentAmount", TRIM (TO_CHAR (ROUND (rac.iznos * rac.izn_tecaja, 2), '999999999999990.00'))),
          xmlelement ("fu:TaxesPerSeller",
            (
            SELECT CASE WHEN SUM (osnovica) IS NOT NULL THEN -- IRN 1899
              xmlagg (
                xmlelement ("fu:VAT",
                  xmlelement ("fu:TaxRate", TRIM (TO_CHAR (stopa, '990.00'))),
                  xmlelement ("fu:TaxableAmount", TRIM (TO_CHAR (osnovica, '999999999999990.00'))),
                  xmlelement ("fu:TaxAmount", TRIM (TO_CHAR (iznos, '999999999999990.00')))
                  )
              ) ELSE NULL END -- IRN 1899
            FROM
              (
              SELECT
                racpdv.stopa_pdv AS stopa,
                SUM (ROUND (racpdv.iznos, 2)) AS osnovica,
                SUM (racpdv.izn_domval - ROUND (racpdv.iznos, 2)) AS iznos
              FROM
                i_rac_pdv racpdv,
                s_vpisporukaz vpispz,
                szmp_spisporuka zmpspisp
              WHERE
                racpdv.rac_id = rac_id_p
                AND racpdv.vpispz_id = vpispz.id
                AND vpispz.zmpspisp_id = zmpspisp.id
                AND zmpspisp.sifra IN ('30', '40', '50', '60') -- oporezivo; IRN 2423
              GROUP BY
                racpdv.stopa_pdv
              )
            ),
           (
          SELECT DECODE (IznosOstalaDavanja, NULL, NULL, xmlelement ("fu:OtherTaxesAmount", TRIM (TO_CHAR (IznosOstalaDavanja, '999999999999990.00'))))
            FROM
              (
            SELECT
                SUM (ROUND (racpdv.iznos, 2)) AS IznosOstalaDavanja
              FROM
                i_rac_pdv racpdv,
                s_vpisporukaz vpispz,
                szmp_spisporuka zmpspisp
              WHERE
                racpdv.rac_id = rac_id_p
                AND racpdv.vpispz_id = vpispz.id
                AND vpispz.zmpspisp_id = zmpspisp.id
                AND zmpspisp.sifra IN ('10') -- ne podlijee, ostala davanja
              )
             ),
            (
            SELECT
              DECODE (IznosOslobPdv, NULL, NULL, xmlelement ("fu:ExemptVATTaxableAmount", TRIM (TO_CHAR (IznosOslobPdv, '999999999999990.00'))))
            FROM
              (
              SELECT
                SUM (ROUND (racpdv.iznos, 2)) AS IznosOslobPdv
              FROM
                i_rac_pdv racpdv,
                s_vpisporukaz vpispz,
                szmp_spisporuka zmpspisp
              WHERE
                racpdv.rac_id = rac_id_p
                AND racpdv.vpispz_id = vpispz.id
                AND vpispz.zmpspisp_id = zmpspisp.id
                AND zmpspisp.sifra IN ('11', '12', '13') -- osloboeno poreza
              )
            ),
            (
            SELECT
              DECODE (IznosNePodlOpor, NULL, NULL, xmlelement ("fu:NontaxableAmount", TRIM (TO_CHAR (IznosNePodlOpor, '999999999999990.00'))))
            FROM
              (
              SELECT
                SUM (ROUND (racpdv.iznos, 2)) AS IznosNePodlOpor
              FROM
                i_rac_pdv racpdv,
                s_vpisporukaz vpispz,
                szmp_spisporuka zmpspisp
              WHERE
                racpdv.rac_id = rac_id_p
                AND racpdv.vpispz_id = vpispz.id
                AND vpispz.zmpspisp_id = zmpspisp.id
                AND zmpspisp.sifra IN ('20') -- ne podlijee oporezivanju
              )
            )
          ),
          DECODE(NVL(TrebaOib, 0), 0, NULL, xmlelement ("fu:OperatorTaxNumber", NVL (OibOper, OibOper_l))),
          DECODE(NVL(TrebaOib, 0), 0, xmlelement ("fu:ForeignOperator", 'true')),
          xmlelement ("fu:ProtectedID", rac.zki),
          xmlelement ("fu:SubsequentSubmit", DECODE (rac.zki, NULL, '0', '1')),
          (SELECT DECODE (rac2.paragon,
                          NULL, xmlelement ("fu:ReferenceInvoice",
                                  xmlelement ("fu:ReferenceInvoiceIdentifier",
                                    xmlelement ("fu:BusinessPremiseID", rac2.oj_sifra),
                                    xmlelement ("fu:ElectronicDeviceID", rac2.vdok_sifra2n),
                                    xmlelement ("fu:InvoiceNumber", TO_NUMBER (rac2.rbr))
                                  ),
                                  xmlelement ("fu:ReferenceInvoiceIssueDT", TO_CHAR (rac2.datum, 'RRRR-MM-DD') || 'T' || TO_CHAR (rac2.unos_dat, 'HH24:MI:SS'))
                                ),
                          xmlelement ("fu:ReferenceSalesBook",
                            xmlelement ("fu:ReferenceSalesBookIdent",
                              xmlelement ("fu:InvoiceNumber", TO_NUMBER (rac2.paragon)),
                              xmlelement ("fu:SetNumber", rac2.paragon_set),
                              xmlelement ("fu:SerialNumber", rac2.paragon_serija)
                            ),
                            xmlelement ("fu:ReferenceSalesBookIssueDate", TO_CHAR (rac2.datum, 'RRRR-MM-DD'))
                          )
                  )
             FROM t_racuni rac2
            WHERE rac2.id = rac.rac_id
          )
          -- xmlelement ("fu:SpecialNotes", NULL),
        )
      ).extract('/*').getclobval()
    INTO
      data_m
    FROM
      t_racuni rac,
      s_vapldok vapldok,
      s_vlasnik vlas,
      (SELECT MAX (kor.sifra) AS OibOper,
              MAX (kor.ozn_ima_oib) AS TrebaOib
         FROM t_racuni rac,
              m_korisnici kor
        WHERE rac.id = rac_id_p
          AND rac.unos_korisnik = kor.naziv)
    WHERE
      rac.id = rac_id_p
      AND rac.jir IS NULL
      AND rac.vapldok_id = vapldok.id
      AND vapldok.oznaka IN ('GI');

  ELSE
    /*
    <fu:InvoiceRequest Id="test">
      <fu:Header>
        <fu:MessageID>ef60b025-3f8e-43f8-8a7a-905095dc225f</fu:MessageID>
        <fu:DateTime>2015-08-07T13:48:23</fu:DateTime>
      </fu:Header>
      <fu:SalesBookInvoice>
        <fu:TaxNumber>99999862</fu:TaxNumber>
        <fu:IssueDate>2016-04-10</fu:IssueDate>
        <fu:SalesBookIdentifier>
          <fu:InvoiceNumber>612</fu:InvoiceNumber>
          <fu:SetNumber>03</fu:SetNumber>
          <fu:SerialNumber>5001-0001018</fu:SerialNumber>
        </fu:SalesBookIdentifier>
        <fu:BusinessPremiseID>TRGOVINA1</fu:BusinessPremiseID>
        <fu:InvoiceAmount>1060.06</fu:InvoiceAmount>
        <fu:ReturnsAmount>12.30</fu:ReturnsAmount>
        <fu:PaymentAmount>1047.76</fu:PaymentAmount>
        <fu:TaxesPerSeller>
          <fu:VAT>
            <fu:TaxRate>22.00</fu:TaxRate>
            <fu:TaxableAmount>36.89</fu:TaxableAmount>
            <fu:TaxAmount>8.12</fu:TaxAmount>
          </fu:VAT>
          <fu:VAT>
            <fu:TaxRate>9.50</fu:TaxRate>
            <fu:TaxableAmount>56.53</fu:TaxableAmount>
            <fu:TaxAmount>5.37</fu:TaxAmount>
          </fu:VAT>
          <fu:OtherTaxesAmount>53.89</fu:OtherTaxesAmount>
          <fu:ExemptVATTaxebleAmount>142.87</fu:ExemptVATTaxebleAmount>
          <fu:ReverseVATTaxableAmount>67.34</fu:ReverseVATTaxableAmount>
          <fu:NontaxableAmount>43.87</fu:NontaxableAmount>
          <fu:SpecialTaxRulesAmount>87.23</fu:SpecialTaxRulesAmount>
        </fu:TaxesPerSeller>
        <fu:TaxesPerSeller>
          <fu:SellerTaxNumber>82730341</fu:SellerTaxNumber>
          <fu:VAT>
            <fu:TaxRate>22.00</fu:TaxRate>
            <fu:TaxableAmount>37.42</fu:TaxableAmount>
            <fu:TaxAmount>8.23</fu:TaxAmount>
          </fu:VAT>
          <fu:VAT>
            <fu:TaxRate>9.50</fu:TaxRate>
            <fu:TaxableAmount>88.99</fu:TaxableAmount>
            <fu:TaxAmount>8.45</fu:TaxAmount>
          </fu:VAT>
          <fu:OtherTaxesAmount>65.53</fu:OtherTaxesAmount>
          <fu:ExemptVATTaxebleAmount>45.38</fu:ExemptVATTaxebleAmount>
          <fu:ReverseVATTaxableAmount>54.83</fu:ReverseVATTaxableAmount>
          <fu:NontaxableAmount>245.14</fu:NontaxableAmount>
          <fu:SpecialTaxRulesAmount>3.98</fu:SpecialTaxRulesAmount>
        </fu:TaxesPerSeller>
      </fu:SalesBookInvoice>
    </fu:InvoiceRequest>
    */
    SELECT
      xmlelement ("fu:InvoiceRequest",
        xmlattributes ('http://www.fu.gov.si/' AS "xmlns:fu",
          'test' AS "Id"),
        xmlelement ("fu:Header",
          xmlelement ("fu:DateTime", REPLACE (TO_CHAR (SYSDATE, 'RRRR-MM-DD HH24:MI:SS'), ' ', 'T')) -- GGGG-MM-DDTHH:MM:SS
          ),
        xmlelement ("fu:SalesBookInvoice",
          xmlelement ("fu:TaxNumber", vlas.oib),
          xmlelement ("fu:IssueDate", TO_CHAR (rac.datum, 'RRRR-MM-DD')),
          xmlelement ("fu:SalesBookIdentifier",
            xmlelement ("fu:InvoiceNumber", TO_NUMBER (rac.paragon)),
            xmlelement ("fu:SetNumber", rac.paragon_set),
            xmlelement ("fu:SerialNumber", rac.paragon_serija)), -- oznaka slijednosti brojeva rauna na razini naplatnog ureaja
          xmlelement ("fu:BusinessPremiseID", rac.oj_sifra),
          (SELECT DECODE (OibKupca, NULL, NULL, xmlelement ("fu:CustomerVATNumber", OibKupca))
             FROM (SELECT DECODE (zem.sifra_2a, pra_rec_zaj.vrijednost_parametra ('0002'), age.oib, age.br_porezni) OibKupca
                     FROM m_agencije age,
                          s_zemlje zem,
                          t_racuni rac
                    WHERE rac.id = rac_id_p
                      AND age.id = pra_rec2.agek_id (rac.age_id, rac.agep_id)
                      AND zem.id = age.zem_id
                    UNION
                   SELECT DECODE (zem.sifra_2a, pra_rec_zaj.vrijednost_parametra ('0002'), pkaadr.oib, pkaadr.br_porezni)
                     FROM mpka_adrese pkaadr,
                          s_zemlje zem,
                          t_racuni rac
                    WHERE rac.id = rac_id_p
                      AND pkaadr.id = rac.pkaadr_id
                      AND zem.id = pkaadr.zem_id)
          ),
          xmlelement ("fu:InvoiceAmount", TRIM (TO_CHAR (ROUND (pra_rec_s2.iznos_racuna_bruto (rac.id, rac.iznos, rac.izn_tecaja) * rac.izn_tecaja, 2), '999999999999990.00'))),
          -- xmlelement ("fu:ReturnsAmount", NULL), -- provizija, predujmovi?
          xmlelement ("fu:PaymentAmount", TRIM (TO_CHAR (ROUND (rac.iznos * rac.izn_tecaja, 2), '999999999999990.00'))),
          xmlelement ("fu:TaxesPerSeller",
            (
            SELECT CASE WHEN SUM (osnovica) IS NOT NULL THEN -- IRN 1899
                xmlagg (
                  xmlelement ("fu:VAT",
                    xmlelement ("fu:TaxRate", TRIM (TO_CHAR (stopa, '990.00'))),
                    xmlelement ("fu:TaxableAmount", TRIM (TO_CHAR (osnovica, '999999999999990.00'))),
                    xmlelement ("fu:TaxAmount", TRIM (TO_CHAR (iznos, '999999999999990.00')))
                    )
                ) ELSE NULL END -- IRN 1899
            FROM
              (
              SELECT
                racpdv.stopa_pdv AS stopa,
                SUM (ROUND (racpdv.iznos, 2)) AS osnovica,
                SUM (racpdv.izn_domval - ROUND (racpdv.iznos, 2)) AS iznos
              FROM
                i_rac_pdv racpdv,
                s_vpisporukaz vpispz,
                szmp_spisporuka zmpspisp
              WHERE
                racpdv.rac_id = rac_id_p
                AND racpdv.vpispz_id = vpispz.id
                AND vpispz.zmpspisp_id = zmpspisp.id
                AND zmpspisp.sifra IN ('30', '40', '50', '60') -- oporezivo; IRN 2423
              GROUP BY
                racpdv.stopa_pdv
              )
            ),
            (
            SELECT DECODE (IznosOstalaDavanja, NULL, NULL, xmlelement ("fu:OtherTaxesAmount", TRIM (TO_CHAR (IznosOstalaDavanja, '999999999999990.00'))))
            FROM
              (
              SELECT
                SUM (ROUND (racpdv.iznos, 2)) AS IznosOstalaDavanja
              FROM
                i_rac_pdv racpdv,
                s_vpisporukaz vpispz,
                szmp_spisporuka zmpspisp
              WHERE
                racpdv.rac_id = rac_id_p
                AND racpdv.vpispz_id = vpispz.id
                AND vpispz.zmpspisp_id = zmpspisp.id
                AND zmpspisp.sifra IN ('10') -- ne podlijee, ostala davanja
              )
            ),
            (
            SELECT
              DECODE (IznosOslobPdv, NULL, NULL, xmlelement ("fu:ExemptVATTaxableAmount", TRIM (TO_CHAR (IznosOslobPdv, '999999999999990.00'))))
            FROM
              (
              SELECT
                SUM (ROUND (racpdv.iznos, 2)) AS IznosOslobPdv
              FROM
                i_rac_pdv racpdv,
                s_vpisporukaz vpispz,
                szmp_spisporuka zmpspisp
              WHERE
                racpdv.rac_id = rac_id_p
                AND racpdv.vpispz_id = vpispz.id
                AND vpispz.zmpspisp_id = zmpspisp.id
                AND zmpspisp.sifra IN ('11', '12', '13') -- osloboeno poreza
              )
            ),
            (
            SELECT
              DECODE (IznosNePodlOpor, NULL, NULL, xmlelement ("fu:NontaxableAmount", TRIM (TO_CHAR (IznosNePodlOpor, '999999999999990.00'))))
            FROM
              (
              SELECT
                SUM (ROUND (racpdv.iznos, 2)) AS IznosNePodlOpor
              FROM
                i_rac_pdv racpdv,
                s_vpisporukaz vpispz,
                szmp_spisporuka zmpspisp
              WHERE
                racpdv.rac_id = rac_id_p
                AND racpdv.vpispz_id = vpispz.id
                AND vpispz.zmpspisp_id = zmpspisp.id
                AND zmpspisp.sifra IN ('20') -- ne podlijee oporezivanju
              )
            )
          )
          -- xmlelement ("fu:SpecialNotes", NULL),
        )
      ).extract('/*').getclobval()
    INTO
      data_m
    FROM
      t_racuni rac,
      s_vapldok vapldok,
      s_vlasnik vlas
    WHERE
      rac.id = rac_id_p
      AND rac.jir IS NULL
      AND rac.vapldok_id = vapldok.id
      AND vapldok.oznaka IN ('GI');
  END IF;

  -- predugi naziv za xmltype
  --
  -- fu:ReferenceInvoiceIssueDT -> fu:ReferenceInvoiceIssueDateTime
  -- fu:ReferenceSalesBookIdent -> fu:ReferenceSalesBookIdentifier

  SELECT REPLACE (
           REPLACE (data_m, 'fu:ReferenceInvoiceIssueDT', 'fu:ReferenceInvoiceIssueDateTime'),
             'fu:ReferenceSalesBookIdent', 'fu:ReferenceSalesBookIdentifier')
    INTO data_m
    FROM dual;

  IF pra_pka_zaj.vrijednost_parametra ('1058') = 'da' THEN -- spremi zahtjeve i odgovore u bazu
    pra_pka2.clob_to_table (pra_pka2.pretty_print_xml (data_m), 'RecRacunZahtjev_' || pkaracfis_rec_l.id, rac_id_p, 'I3FISKAL'); -- IRN 2434
  END IF;

  zaj_post;

  IF pra_pka_zaj.vrijednost_parametra ('1058') = 'da' THEN -- spremi zahtjeve i odgovore u bazu
    pra_pka2.clob_to_table (pra_pka2.pretty_print_xml (odgovor_m), 'RecRacunOdgovor_' || pkaracfis_rec_l.id, rac_id_p, 'I3FISKAL'); -- IRN 2434
  END IF;

  -- obradi odgovor
  /*
  <?xml version="1.0" encoding="UTF-8"?>
  <Response>
     <ZastitniKod>41075982daaa252b72353737b2bf0fb8</ZastitniKod>
     <QRCode>R0lGODlhfQB9APAAAAAAAP///ywAAAAAfQB9AEAC/4yPqcvtD6OctNqLs26gA+x9R4iQY+iVaKeyl7nBwbq2oiHLtp2nJ+3DBTW6Sc/lAO4WRUlzA2UOn8+oVXEEoihKKXI2XAq/VdCUJgZrb+rtj81Dv+PfTBcb9rrH8Lkxj1cHRQWYkEXHtrbGQCh4NSjHd+iXVFj2UgjRqEimqBlpmMl1tkjZhsjIqVr6aDrauZoKm2hZ69iKm6u7y9vr+wscjLnKKUt7e9lGrBWVdXeqZ/w5izgZQ8rsavqc7AyaHLFcvI2d5i2+R4R+nF1ZQ04N33c9y/1ty74pHS2M+rZ5rh00PmnslHuwzFhAcwcJQooXSOAzhuuwTTRT8Z3Djf/K7kEcyEHUn3oe8+ELmFBeM4slCyJs2ArctIzWQFI0+XFcv508e/r8CTSo0KFEixr9RVNjqI8uIyadZ0FmxJv+JMF8BbUCyqvaOO7jqNMmRpzpaur7BzOsVHdka950y8+q0rUhb81surQsvrErn+ZMC9hv1qJwvR51SqyayI5/G7OLyZJVOFBU44Kkexft3JaWLxr+LHYY2bclCzPWS9KuL3tKq55m/bhrVMqyXZ91shjzS6Z6wtrmDJar6K91Y8tt68kyXq3CX0eGujWW5nRGYZvNvfeRYMeKudf+PnIwW4XJj3ejDZp5atSjez9PGVx1+O7GL6N3LnhX9PprTT//FI+bfMXRd5t9yGRHj1+VTSXPdZIdBmGEEk5IYYUWXohhhhpuyGGHHn4I4nQVEVcgeTT1pWBnCBb3FIp8qTTdbwISZ9CMKjq2EHgD/kcfXiXeiBxvw4nY3I8MxifRYpOt52B9pOEInDpMBuZkg1TC5iKRQhrIXmbmNadekFUi6Z+Vm9m4G4AkYncmdEoq9+JsW8roJpp5odgijEg+mRGeSS3IJZ8jUmiabiHuCJqhPg36pYBY6hmoduv0mGaTgCq6pnQBUgfppW/OpyWnbBVIKphx4tdeos/RKBumZrJX6KpwqmonoqcJKiutSa6X5XG48tpqeVy6KiWsJ70XZZm92lh37JRtAlqjqKHlFaud59U6k5HUFvnptMudeq0qJqYa6Z486gjftsCay26xrB45LLIPBovtrN5Cyqymd9obpo/CehYvOpQm6K9kAO+nlrDVlUall/tOmC9/bNapJlZ5tpuwd+P9d3G5qHrqaLe2YjVuxOFq2++QiBmssHsH1gtvxuTSyajH0Q4cMMUI/2sqqI1KvK6628G8pJggSzs0wL1+3Gma37p77s/QOq3jqTerjGqpW6JMMtbpHv3uveF1XC3QXYbq54lNY5xsy4e+DXfccs9Nd912H1YAADs=</QRCode>
     <IdPoruke>4e64a93a-40fa-4c02-afb1-488534b85e4c</IdPoruke>
     <Jir>963c9b32-fbd0-4f5e-9039-3d440db1a414</Jir>
  </Response>
  */
  SELECT extractvalue (xmltype (odgovor_m), '/Response/IdPoruke'),
         extractvalue (xmltype (odgovor_m), '/Response/SifraGreske'),
         extractvalue (xmltype (odgovor_m), '/Response/PorukaGreske'),
         extractvalue (xmltype (odgovor_m), '/Response/ZastitniKod'),
         extractvalue (xmltype (odgovor_m), '/Response/Jir'),
         extractvalue (xmltype (odgovor_m), '/Response/QRCode')
    INTO pkaracfis_rec_l.id_poruke,
         pkaracfis_rec_l.sifra_greske,
         pkaracfis_rec_l.opis_greske,
         rac_zki_l,
         rac_jir_l,
         rac_qr_l
    FROM dual;

  -- auriraj raun
  UPDATE t_racuni SET zki = NVL (zki, rac_zki_l), jir = rac_jir_l WHERE id = rac_id_p AND jir IS NULL;

  SELECT MAX (id)
    INTO racblob_id_l
    FROM t_racuni_blob
   WHERE rac_id = rac_id_p
     AND oznaka = 'gif';

  IF rac_qr_l IS NOT NULL THEN
    rac_qr_blob_l := base64decode (rac_qr_l);

    IF racblob_id_l IS NOT NULL THEN
      UPDATE t_racuni_blob
         SET datoteka = rac_qr_blob_l
       WHERE id = racblob_id_l;
    ELSE
      INSERT INTO t_racuni_blob (rac_id, datoteka, oznaka, status)
        VALUES (rac_id_p, rac_qr_blob_l, 'gif', 0);
    END IF;
  END IF;

  -- auriraj log LPKA_RAC_FIS
  UPDATE lpka_rac_fis
     SET id_poruke = pkaracfis_rec_l.id_poruke,
         dat_obrade = SYSDATE,
         sifra_greske = pkaracfis_rec_l.sifra_greske,
         opis_greske = pkaracfis_rec_l.opis_greske
   WHERE id = pkaracfis_rec_l.id;

  COMMIT;


EXCEPTION
  WHEN OTHERS THEN
    ROLLBACK; -- otkljuaj tablicu t_racuni

    -- auriraj log LPKA_RAC_FIS
    pkaracfis_rec_l.opis_greske := SUBSTR (SQLERRM, 1, 500);
    UPDATE lpka_rac_fis
       SET id_poruke = pkaracfis_rec_l.id_poruke,
           dat_obrade = SYSDATE,
           sifra_greske = pkaracfis_rec_l.sifra_greske,
           opis_greske = pkaracfis_rec_l.opis_greske
     WHERE id = pkaracfis_rec_l.id;
    COMMIT;
END;
PROCEDURE I3FISKAL_PKA_RACUN_SI
 (PKARAC_ID_P IN tpka_racuni.id%TYPE
 )
 IS
-- dostavi podatke o PKA GI ili GP racunu i3fiskal servisu
  pkarac_datum_l tpka_racuni.datum%TYPE;
  vapldok_oznaka_l s_vapldok.oznaka%TYPE;
  pkarac_jir_l tpka_racuni.jir%TYPE;
  pkarac_zki_l tpka_racuni.zki%TYPE;
  pkarac_qr_l CLOB;
  pkarac_qr_blob_l BLOB;
  OibOper_l s_vlasnik.oib%TYPE;
  pkaracfis_rec_l lpka_rac_fis%ROWTYPE;
  nebitno_l NUMBER;
  racblob_id_l t_racuni_blob.id%TYPE;
  paragon_l NUMBER(2);

  CURSOR vanjskisus_c (pkarac_id_k NUMBER) IS
    SELECT oib
      FROM s_vlasnik,
           tpka_racuni pkarac
     WHERE pkarac.id = pkarac_id_k
       AND pkarac.unos_korisnik IN ('SYNXIS', 'RIWEB', 'PHOBS');
BEGIN
  IF pkarac_id_p IS NULL THEN
    RETURN;
  END IF;

  SELECT pkarac.datum, vapldok.oznaka, pkarac.jir, pkarac.zki,
         DECODE (pkarac.paragon, NULL, 0, -1) +
           DECODE (pkarac.paragon_set, NULL, 0, -1) +
           DECODE (pkarac.paragon_serija, NULL, 0, -1)
    INTO pkarac_datum_l, vapldok_oznaka_l, pkarac_jir_l, pkarac_zki_l, paragon_l
    FROM tpka_racuni pkarac,
         s_vapldok vapldok
   WHERE pkarac.id = pkarac_id_p
     AND pkarac.vapldok_id = vapldok.id;

  IF vlas_u_fsus_si (pkarac_datum_l) = 0 -- vlasnik nije u fiskalnom sustavu HR ili je datum racuna manji od pocetka primjene fiskalnog sustava
    OR vapldok_oznaka_l NOT IN ('GI', 'GP')
    OR pkarac_jir_l IS NOT NULL
  THEN
    RETURN;
  END IF;

  OibOper_l := pra_pka_i3fiskal.oib_test ('12345678'); -- IRN 3409

  -- vanjski sustavi koji unose predujam
  OPEN vanjskisus_c (pkarac_id_p);
  FETCH vanjskisus_c INTO OibOper_l;
  CLOSE vanjskisus_c;

  data_m := NULL;

  -- upii u log LPKA_RAC_FIS
  pkaracfis_rec_l.id := pra_zmp_zaj.i3_sekvenca (NULL);
  INSERT INTO lpka_rac_fis (id, pkarac_id, dat_slanja) VALUES (pkaracfis_rec_l.id, pkarac_id_p, SYSDATE);
  COMMIT;

  SELECT 1 INTO nebitno_l FROM tpka_racuni WHERE id = pkarac_id_p AND jir IS NULL FOR UPDATE OF zki, jir NOWAIT;

  IF NOT (paragon_l = -3) THEN
    SELECT
      xmlelement ("fu:InvoiceRequest",
        xmlattributes ('http://www.fu.gov.si/' AS "xmlns:fu",
          'test' AS "Id"),
        xmlelement ("fu:Header",
          xmlelement ("fu:DateTime", REPLACE (TO_CHAR (SYSDATE, 'RRRR-MM-DD HH24:MI:SS'), ' ', 'T')) -- GGGG-MM-DDTHH:MM:SS
          ),
        xmlelement ("fu:Invoice",
          xmlelement ("fu:TaxNumber", vlas.oib),
          xmlelement ("fu:IssueDateTime", TO_CHAR (pkarac.datum, 'RRRR-MM-DD') || 'T' || TO_CHAR (pkarac.unos_dat, 'HH24:MI:SS')),
          xmlelement ("fu:NumberingStructure", 'B'),
          xmlelement ("fu:InvoiceIdentifier",
            xmlelement ("fu:BusinessPremiseID", pkarac.oj_sifra),
            xmlelement ("fu:ElectronicDeviceID", pkarac.vdok_sifra2n),
            xmlelement ("fu:InvoiceNumber", TO_NUMBER (pkarac.rbr))), -- oznaka slijednosti brojeva racuna na razini naplatnog uredaja
          (SELECT DECODE (OibKupca, NULL, NULL, xmlelement ("fu:CustomerVATNumber", OibKupca))
             FROM (SELECT DECODE (zem.sifra_2a, pra_pka_zaj.vrijednost_parametra ('0002'), gmpkom.oib, gmpkom.br_porezni) OibKupca
                     FROM mgmp_komitenti gmpkom,
                          s_zemlje zem,
                          tpka_racuni pkarac
                    WHERE pkarac.id = pkarac_id_p
                      AND gmpkom.id = pkarac.gmpkom_id
                      AND zem.id = gmpkom.zem_id
                    UNION
                   SELECT DECODE (zem.sifra_2a, pra_rec_zaj.vrijednost_parametra ('0002'), pkaadr.oib, pkaadr.br_porezni)
                     FROM mpka_adrese pkaadr,
                          s_zemlje zem,
                          tpka_racuni pkarac
                    WHERE pkarac.id = pkarac_id_p
                      AND pkaadr.id = pkarac.pkaadr_id
                      AND zem.id = pkaadr.zem_id)
          ),
          xmlelement ("fu:InvoiceAmount", TRIM (TO_CHAR (ROUND (pra_pka_s2.pkarac_iznos_bruto (pkarac.id, pkarac.iznos, pkarac.izn_tecaja) * pkarac.izn_tecaja, 2), '999999999999990.00'))),
          -- xmlelement ("fu:ReturnsAmount", NULL), -- provizija, predujmovi?
          xmlelement ("fu:PaymentAmount", TRIM (TO_CHAR (ROUND (pkarac.iznos * pkarac.izn_tecaja, 2), '999999999999990.00'))),
          xmlelement ("fu:TaxesPerSeller",
            (
            SELECT CASE WHEN SUM (osnovica) IS NOT NULL THEN -- IRN 1899
              xmlagg (
                xmlelement ("fu:VAT",
                  xmlelement ("fu:TaxRate", TRIM (TO_CHAR (stopa, '990.00'))),
                  xmlelement ("fu:TaxableAmount", TRIM (TO_CHAR (osnovica, '999999999999990.00'))),
                  xmlelement ("fu:TaxAmount", TRIM (TO_CHAR (iznos, '999999999999990.00')))
                  )
                )
              ELSE NULL END -- IRN 1899
            FROM
              (
              SELECT
                pkaracpdv.stopa_pdv AS stopa,
                SUM (ROUND (pkaracpdv.iznos, 2)) AS osnovica,
                SUM (pkaracpdv.izn_domval - ROUND (pkaracpdv.iznos, 2)) AS iznos
              FROM
                ipka_rac_pdv pkaracpdv,
                s_vpisporukaz vpispz,
                szmp_spisporuka zmpspisp
              WHERE
                pkaracpdv.pkarac_id = pkarac_id_p
                AND pkaracpdv.vpispz_id = vpispz.id
                AND vpispz.zmpspisp_id = zmpspisp.id
                AND zmpspisp.sifra IN ('30', '40', '50', '60') -- oporezivo; IRN 2423
              GROUP BY
                pkaracpdv.stopa_pdv
              )
            ),
            (
            SELECT DECODE (IznosOstalaDavanja, NULL, NULL, xmlelement ("fu:OtherTaxesAmount", TRIM (TO_CHAR (IznosOstalaDavanja, '999999999999990.00'))))
             FROM
              (
              SELECT
                SUM (ROUND (racpdv.iznos, 2)) AS IznosOstalaDavanja
              FROM
                ipka_rac_pdv racpdv,
                s_vpisporukaz vpispz,
                szmp_spisporuka zmpspisp
              WHERE
                racpdv.pkarac_id = pkarac_id_p
                AND racpdv.vpispz_id = vpispz.id
                AND vpispz.zmpspisp_id = zmpspisp.id
                AND zmpspisp.sifra IN ('10') -- ne podlijee, ostala davanja
              )
            ),
            (
            SELECT
              DECODE (IznosOslobPdv, NULL, NULL, xmlelement ("fu:ExemptVATTaxableAmount", TRIM (TO_CHAR (IznosOslobPdv, '999999999999990.00'))))
            FROM
              (
              SELECT
                SUM (ROUND (racpdv.iznos, 2)) AS IznosOslobPdv
              FROM
                ipka_rac_pdv racpdv,
                s_vpisporukaz vpispz,
                szmp_spisporuka zmpspisp
              WHERE
                racpdv.pkarac_id = pkarac_id_p
                AND racpdv.vpispz_id = vpispz.id
                AND vpispz.zmpspisp_id = zmpspisp.id
                AND zmpspisp.sifra IN ('11', '12', '13') -- oslobodeno poreza
              )
            ),
            (
            SELECT
              DECODE (IznosNePodlOpor, NULL, NULL, xmlelement ("fu:NontaxableAmount", TRIM (TO_CHAR (IznosNePodlOpor, '999999999999990.00'))))
            FROM
              (
              SELECT
                SUM (ROUND (racpdv.iznos, 2)) AS IznosNePodlOpor
              FROM
                ipka_rac_pdv racpdv,
                s_vpisporukaz vpispz,
                szmp_spisporuka zmpspisp
              WHERE
                racpdv.pkarac_id = pkarac_id_p
                AND racpdv.vpispz_id = vpispz.id
                AND vpispz.zmpspisp_id = zmpspisp.id
                AND zmpspisp.sifra IN ('20') -- ne podlijee oporezivanju
              )
            )
          ),
          DECODE (NVL (TrebaOib, 0), 0, NULL, xmlelement ("fu:OperatorTaxNumber", NVL (OibOper, OibOper_l))),
          DECODE (NVL (TrebaOib, 0), 0, xmlelement ("fu:ForeignOperator", 'true')),
          xmlelement ("fu:ProtectedID", pkarac.zki),
          xmlelement ("fu:SubsequentSubmit", DECODE (pkarac.zki, NULL, '0', '1')),
          (SELECT DECODE (pkarac2.paragon,
                          NULL, xmlelement ("fu:ReferenceInvoice",
                                  xmlelement ("fu:ReferenceInvoiceIdentifier",
                                    xmlelement ("fu:BusinessPremiseID", pkarac2.oj_sifra),
                                    xmlelement ("fu:ElectronicDeviceID", pkarac2.vdok_sifra2n),
                                    xmlelement ("fu:InvoiceNumber", TO_NUMBER (pkarac2.rbr))
                                  ),
                                  xmlelement ("fu:ReferenceInvoiceIssueDT", TO_CHAR (pkarac2.datum, 'RRRR-MM-DD') || 'T' || TO_CHAR (pkarac2.unos_dat, 'HH24:MI:SS'))
                                ),
                          xmlelement ("fu:ReferenceSalesBook",
                            xmlelement ("fu:ReferenceSalesBookIdent",
                              xmlelement ("fu:InvoiceNumber", TO_NUMBER (pkarac2.paragon)),
                              xmlelement ("fu:SetNumber", pkarac2.paragon_set),
                              xmlelement ("fu:SerialNumber", pkarac2.paragon_serija)
                            ),
                            xmlelement ("fu:ReferenceSalesBookIssueDate", TO_CHAR (pkarac2.datum, 'RRRR-MM-DD'))
                         )
                  )
             FROM tpka_racuni pkarac2
            WHERE pkarac2.id = pkarac.pkarac_id
          )
        -- xmlelement ("fu:SpecialNotes", NULL),
        )
      ).extract('/*').getclobval()
    INTO
      data_m
    FROM
      tpka_racuni pkarac,
      s_vapldok vapldok,
      s_vlasnik vlas,
      (SELECT MAX (kor.sifra) AS OibOper,
              MAX (kor.ozn_ima_oib) AS TrebaOib
         FROM tpka_racuni pkarac,
              m_korisnici kor
        WHERE pkarac.id = pkarac_id_p
          AND pkarac.unos_korisnik = kor.naziv)
    WHERE
      pkarac.id = pkarac_id_p
      AND pkarac.jir IS NULL
      AND pkarac.vapldok_id = vapldok.id
      AND vapldok.oznaka IN ('GI', 'GP');

  ELSE
    SELECT
      xmlelement ("fu:InvoiceRequest",
        xmlattributes ('http://www.fu.gov.si/' AS "xmlns:fu",
          'test' AS "Id"),
        xmlelement ("fu:Header",
          xmlelement ("fu:DateTime", REPLACE (TO_CHAR (SYSDATE, 'RRRR-MM-DD HH24:MI:SS'), ' ', 'T')) -- GGGG-MM-DDTHH:MM:SS
          ),
        xmlelement ("fu:SalesBookInvoice",
          xmlelement ("fu:TaxNumber", vlas.oib),
          xmlelement ("fu:IssueDate", TO_CHAR (pkarac.datum, 'RRRR-MM-DD')),
          xmlelement ("fu:SalesBookIdentifier",
            xmlelement ("fu:InvoiceNumber", pkarac.paragon),
            xmlelement ("fu:SetNumber", pkarac.paragon_set),
            xmlelement ("fu:SerialNumber", pkarac.paragon_serija)),
          xmlelement ("fu:BusinessPremiseID", pkarac.oj_sifra),
          (SELECT DECODE (OibKupca, NULL, NULL, xmlelement ("fu:CustomerVATNumber", OibKupca))
             FROM (SELECT DECODE (zem.sifra_2a, pra_pka_zaj.vrijednost_parametra ('0002'), gmpkom.oib, gmpkom.br_porezni) OibKupca
                     FROM mgmp_komitenti gmpkom,
                          s_zemlje zem,
                          tpka_racuni pkarac
                    WHERE pkarac.id = pkarac_id_p
                      AND gmpkom.id = pkarac.gmpkom_id
                      AND zem.id = gmpkom.zem_id
                    UNION
                   SELECT DECODE (zem.sifra_2a, pra_rec_zaj.vrijednost_parametra ('0002'), pkaadr.oib, pkaadr.br_porezni)
                     FROM mpka_adrese pkaadr,
                          s_zemlje zem,
                          tpka_racuni pkarac
                    WHERE pkarac.id = pkarac_id_p
                      AND pkaadr.id = pkarac.pkaadr_id
                      AND zem.id = pkaadr.zem_id)
          ),
          xmlelement ("fu:InvoiceAmount", TRIM (TO_CHAR (ROUND (pra_pka_s2.pkarac_iznos_bruto (pkarac.id, pkarac.iznos, pkarac.izn_tecaja) * pkarac.izn_tecaja, 2), '999999999999990.00'))),
          -- xmlelement ("fu:ReturnsAmount", NULL), -- provizija, predujmovi?
          xmlelement ("fu:PaymentAmount", TRIM (TO_CHAR (ROUND (pkarac.iznos * pkarac.izn_tecaja, 2), '999999999999990.00'))),
          xmlelement ("fu:TaxesPerSeller",
            (
            SELECT CASE WHEN SUM (osnovica) IS NOT NULL THEN -- IRN 1899
              xmlagg (
                xmlelement ("fu:VAT",
                  xmlelement ("fu:TaxRate", TRIM (TO_CHAR (stopa, '990.00'))),
                  xmlelement ("fu:TaxableAmount", TRIM (TO_CHAR (osnovica, '999999999999990.00'))),
                  xmlelement ("fu:TaxAmount", TRIM (TO_CHAR (iznos, '999999999999990.00')))
                  )
                ) ELSE NULL END -- IRN 1899
            FROM
              (
              SELECT
                pkaracpdv.stopa_pdv AS stopa,
                SUM (ROUND (pkaracpdv.iznos, 2)) AS osnovica,
                SUM (pkaracpdv.izn_domval - ROUND (pkaracpdv.iznos, 2)) AS iznos
              FROM
                ipka_rac_pdv pkaracpdv,
                s_vpisporukaz vpispz,
                szmp_spisporuka zmpspisp
              WHERE
                pkaracpdv.pkarac_id = pkarac_id_p
                AND pkaracpdv.vpispz_id = vpispz.id
                AND vpispz.zmpspisp_id = zmpspisp.id
                AND zmpspisp.sifra IN ('30', '40', '50', '60') -- oporezivo; IRN 2423
              GROUP BY
                pkaracpdv.stopa_pdv
              )
            ),
            (
            SELECT DECODE (IznosOstalaDavanja, NULL, NULL, xmlelement ("fu:OtherTaxesAmount", TRIM (TO_CHAR (IznosOstalaDavanja, '999999999999990.00'))))
             FROM
              (
              SELECT
                SUM (ROUND (racpdv.iznos, 2)) AS IznosOstalaDavanja
              FROM
                ipka_rac_pdv racpdv,
                s_vpisporukaz vpispz,
                szmp_spisporuka zmpspisp
              WHERE
                racpdv.pkarac_id = pkarac_id_p
                AND racpdv.vpispz_id = vpispz.id
                AND vpispz.zmpspisp_id = zmpspisp.id
                AND zmpspisp.sifra IN ('10') -- ne podlijee, ostala davanja
              )
            ),
            (
            SELECT
              DECODE (IznosOslobPdv, NULL, NULL, xmlelement ("fu:ExemptVATTaxableAmount", TRIM (TO_CHAR (IznosOslobPdv, '999999999999990.00'))))
            FROM
              (
              SELECT
                SUM (ROUND (racpdv.iznos, 2)) AS IznosOslobPdv
              FROM
                ipka_rac_pdv racpdv,
                s_vpisporukaz vpispz,
                szmp_spisporuka zmpspisp
              WHERE
                racpdv.pkarac_id = pkarac_id_p
                AND racpdv.vpispz_id = vpispz.id
                AND vpispz.zmpspisp_id = zmpspisp.id
                AND zmpspisp.sifra IN ('11', '12', '13') -- oslobodeno poreza
              )
            ),
            (
            SELECT
              DECODE (IznosNePodlOpor, NULL, NULL, xmlelement ("fu:NontaxableAmount", TRIM (TO_CHAR (IznosNePodlOpor, '999999999999990.00'))))
            FROM
              (
              SELECT
                SUM (ROUND (racpdv.iznos, 2)) AS IznosNePodlOpor
              FROM
                ipka_rac_pdv racpdv,
                s_vpisporukaz vpispz,
                szmp_spisporuka zmpspisp
              WHERE
                racpdv.pkarac_id = pkarac_id_p
                AND racpdv.vpispz_id = vpispz.id
                AND vpispz.zmpspisp_id = zmpspisp.id
                AND zmpspisp.sifra IN ('20') -- ne podlijee oporezivanju
              )
            )
          )
          -- xmlelement ("fu:SpecialNotes", NULL),
        )
      ).extract('/*').getclobval()
    INTO
      data_m
    FROM
      tpka_racuni pkarac,
      s_vapldok vapldok,
      s_vlasnik vlas
    WHERE
      pkarac.id = pkarac_id_p
      AND pkarac.jir IS NULL
      AND pkarac.vapldok_id = vapldok.id
      AND vapldok.oznaka IN ('GI', 'GP')
      ;
  END IF;

  -- predugi naziv za xmltype
  --
  -- fu:ReferenceInvoiceIssueDT -> fu:ReferenceInvoiceIssueDateTime
  -- fu:ReferenceSalesBookIdent -> fu:ReferenceSalesBookIdentifier

  SELECT REPLACE (
           REPLACE (data_m, 'fu:ReferenceInvoiceIssueDT', 'fu:ReferenceInvoiceIssueDateTime'),
             'fu:ReferenceSalesBookIdent', 'fu:ReferenceSalesBookIdentifier')
    INTO data_m
    FROM dual;

  IF pra_pka_zaj.vrijednost_parametra ('1058') = 'da' THEN -- spremi zahtjeve i odgovore u bazu
    pra_pka2.clob_to_table (pra_pka2.pretty_print_xml (data_m), 'PkaRacunZahtjev_' || pkaracfis_rec_l.id, pkarac_id_p, 'I3FISKAL'); -- IRN 2434
  END IF;

  zaj_post;

  IF pra_pka_zaj.vrijednost_parametra ('1058') = 'da' THEN -- spremi zahtjeve i odgovore u bazu
    pra_pka2.clob_to_table (pra_pka2.pretty_print_xml (odgovor_m), 'PkaRacunOdgovor_' || pkaracfis_rec_l.id, pkarac_id_p, 'I3FISKAL'); -- IRN 2434
  END IF;

  -- obradi odgovor
  SELECT extractvalue (xmltype (odgovor_m), '/Response/IdPoruke'),
         extractvalue (xmltype (odgovor_m), '/Response/SifraGreske'),
         extractvalue (xmltype (odgovor_m), '/Response/PorukaGreske'),
         extractvalue (xmltype (odgovor_m), '/Response/ZastitniKod'),
         extractvalue (xmltype (odgovor_m), '/Response/Jir'),
         extractvalue (xmltype (odgovor_m), '/Response/QRCode')
    INTO pkaracfis_rec_l.id_poruke,
         pkaracfis_rec_l.sifra_greske,
         pkaracfis_rec_l.opis_greske,
         pkarac_zki_l,
         pkarac_jir_l,
         pkarac_qr_l
    FROM dual;

  -- auriraj racun
  UPDATE tpka_racuni SET zki = NVL (zki, pkarac_zki_l), jir = pkarac_jir_l WHERE id = pkarac_id_p AND jir IS NULL;

  SELECT MAX (id)
    INTO racblob_id_l
    FROM t_racuni_blob
   WHERE pkarac_id = pkarac_id_p
     AND oznaka = 'gif';

  IF pkarac_qr_l IS NOT NULL THEN
    pkarac_qr_blob_l := base64decode (pkarac_qr_l);

    IF racblob_id_l IS NOT NULL THEN
      UPDATE t_racuni_blob
         SET datoteka = pkarac_qr_blob_l
       WHERE id = racblob_id_l;
    ELSE
      INSERT INTO t_racuni_blob (pkarac_id, datoteka, oznaka, status)
        VALUES (pkarac_id_p, pkarac_qr_blob_l, 'gif', 0);
    END IF;
  END IF;

  -- auriraj log LPKA_RAC_FIS
  UPDATE lpka_rac_fis
     SET id_poruke = pkaracfis_rec_l.id_poruke,
         dat_obrade = SYSDATE,
         sifra_greske = pkaracfis_rec_l.sifra_greske,
         opis_greske = pkaracfis_rec_l.opis_greske
   WHERE id = pkaracfis_rec_l.id;

  COMMIT;

EXCEPTION
  WHEN OTHERS THEN
    ROLLBACK; -- otkljucaj tablicu TPKA_RACUNI

    -- auriraj log LPKA_RAC_FIS
    pkaracfis_rec_l.opis_greske := SUBSTR (SQLERRM, 1, 500);
    UPDATE lpka_rac_fis
       SET id_poruke = pkaracfis_rec_l.id_poruke,
           dat_obrade = SYSDATE,
           sifra_greske = pkaracfis_rec_l.sifra_greske,
           opis_greske = pkaracfis_rec_l.opis_greske
     WHERE id = pkaracfis_rec_l.id;
    COMMIT;
END;
FUNCTION I3FISKAL_ECHO_SI
 RETURN VARCHAR2
 IS
--
  poruka_l VARCHAR2(2000);
  poruka_greske_l VARCHAR2(2000);
  timestamp_l VARCHAR(30);
BEGIN
  /*
    <fu:EchoRequest>test</fu:EchoRequest>
  */

  data_m := NULL;

  SELECT
    xmlelement ("fu:EchoRequest", xmlattributes ('http://www.fu.gov.si/' AS "xmlns:fu"), 'test').extract('/*').getclobval()
  INTO
    data_m
  FROM
    dual;

  IF pra_pka_zaj.vrijednost_parametra ('1058') = 'da' THEN -- spremi zahtjeve i odgovore u bazu
    timestamp_l := TO_CHAR (SYSDATE, 'ddmmrrrrhh24miss');
    pra_pka2.clob_to_table (pra_pka2.pretty_print_xml (data_m), 'Echo_' || timestamp_l, NULL, 'I3FISKAL'); -- IRN 2434
  END IF;

  zaj_post;

  IF pra_pka_zaj.vrijednost_parametra ('1058') = 'da' THEN -- spremi zahtjeve i odgovore u bazu
    pra_pka2.clob_to_table (pra_pka2.pretty_print_xml (odgovor_m), 'Echo_' || timestamp_l || '_R', NULL, 'I3FISKAL'); -- IRN 2434
  END IF;

  -- obradi odgovor
  /*
    <fu:EchoResponse>test</fu:EchoResponse>
  */

  SELECT extractvalue (xmltype (odgovor_m), '/Response/Echo')
    INTO poruka_l
    FROM dual;

  IF poruka_l IS NULL THEN
    -- Pogreka u komunikaciji (#0).
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20505);
  END IF;

  RETURN poruka_l;
END;
FUNCTION OIB_TEST
 (OIB_P IN s_vlasnik.oib%TYPE
 )
 RETURN s_vlasnik.oib%TYPE
 IS
-- IRN 3409; vraa OIB operatera za potrebe testiranja u IT
BEGIN
  IF oib_p IS NULL THEN
    RETURN (NULL);
  END IF;
  IF pra_pka_zaj.vrijednost_parametra ('1058') = 'da'
    AND user IN (
        'I3RAZVOJ', 'I3CENTAR', 'I3HOTEL', 'I3KAMP', 'I3TEST', 'I3TEST2',
        'PRECENTAR', 'PREHOTEL', 'PREKAMP', 'PREPODC', 'PREPODO',
        'ITRAZVOJ', 'IT8CENTAR', 'IT8OBJEKT')
  THEN
    RETURN (oib_p);
  ELSE
    RETURN (NULL);
  END IF;
END;
PROCEDURE SPREMI_PDF417CODE
 (VAL_SIFRA_3A_P IN s_valute.sifra_3a%TYPE
 ,IZNOS_P IN NUMBER
 ,PLATITELJ_NAZIV_P IN VARCHAR2
 ,PLATITELJ_ULICA_P IN VARCHAR2
 ,PLATITELJ_MJESTO_P IN VARCHAR2
 ,PRIMATELJ_NAZIV_P IN VARCHAR2
 ,PRIMATELJ_ULICA_P IN VARCHAR2
 ,PRIMATELJ_MJESTO_P IN VARCHAR2
 ,IBAN_P IN m_uracuni.iban%TYPE
 ,BR_MODELA_P IN VARCHAR2
 ,POZIV_NA_BROJ_P IN VARCHAR2
 ,OPIS_PLACANJA_P IN VARCHAR2
 ,NAZ_TABLICE_P IN tpka_prilozi.naz_tablice%TYPE
 ,ID_RETKA_P IN tpka_prilozi.id_retka%TYPE
 )
 IS
-- IRN 3645; sprema PDF417 2D bar kod po HUB-3 standardu u tablicu tpka_prilozi
  lf_l VARCHAR2(10) := '&#10;';
  pdf417code_clob_l CLOB;
  pdf417code_blob_l BLOB;
  pkapri_id_l   tpka_prilozi.id%TYPE;
  naz_priloga_l tpka_prilozi.naz_priloga%TYPE := 'HUB-3.gif';
BEGIN

  IF naz_tablice_p IS NULL
    OR id_retka_p IS NULL
    OR iznos_p IS NULL
    OR iban_p IS NULL
    OR poziv_na_broj_p IS NULL
    -- za sada se ne ispituju ostali ulazni parametri
  THEN
    RETURN;
  END IF;

  /*
  <?xml version="1.0" encoding="UTF-8" standalone="no"?>
  <tns:PDF417CodeRequest xmlns:tns="http://www.apis-it.hr/fin/2012/types/f73">
    <tns:Text>HRVHUB30&#10;EUR&#10;000000000295519&#10;VISOKA KOLA ZA MENADMENT I D&#10;MIKE TRIPALA 6&#10;21000 SPLIT&#10;Aminess d.d.&#10;Terre 2&#10;52466 NOVIGRAD&#10;HR3624020061100386974&#10;&#10;004524-865-001342&#10;COST&#10;Datum dospijea 12.04.2023</tns:Text>
    <tns:AspectRatio>6</tns:AspectRatio>
    <tns:ErrorCorrectionLevel>4</tns:ErrorCorrectionLevel>
    <tns:BitmapType>jpeg</tns:BitmapType>
  </tns:PDF417CodeRequest>
  */

  data_m := NULL;

  SELECT
    xmlelement ("tns:PDF417CodeRequest",
      xmlattributes ('http://www.apis-it.hr/fin/2012/types/f73' AS "xmlns:tns"),
      xmlelement (noentityescaping "tns:Text", x.text), -- noentityescaping dodan da ne promijeni lf_l
      xmlelement ("tns:AspectRatio", 6),
      xmlelement ("tns:ErrorCorrectionLevel", 4),
      xmlelement ("tns:BitmapType", 'gif') -- jpeg ili gif, kod promjene treba uskladiti naz_priloga_l
    ).extract('/*').getclobval()
  INTO
    data_m
  FROM
    (
    -- ifra namjene: GDSV - Kupoprodaja roba i usluga, SCVE - Kupoprodaja usluga ili COST - Trokovi
    -- regexp_replace sastavio Daniel
    -- NVL (br_modela_p, 'HR00') || lf_l ||
    SELECT
      'HRVHUB30' || lf_l ||
        val_sifra_3a_p || lf_l ||
        LPAD (iznos_p * 100, 15, '0') || lf_l ||
        SUBSTR (regexp_replace (platitelj_naziv_p,  '[^0-9a-z ,.:+?/()-]', '', 1, 0, 'mi'), 1, 30) || lf_l ||
        SUBSTR (regexp_replace (platitelj_ulica_p,  '[^0-9a-z ,.:+?/()-]', '', 1, 0, 'mi'), 1, 27) || lf_l ||
        SUBSTR (regexp_replace (platitelj_mjesto_p, '[^0-9a-z ,.:+?/()-]', '', 1, 0, 'mi'), 1, 27) || lf_l ||
        SUBSTR (regexp_replace (primatelj_naziv_p,  '[^0-9a-z ,.:+?/()-]', '', 1, 0, 'mi'), 1, 25) || lf_l ||
        SUBSTR (regexp_replace (primatelj_ulica_p,  '[^0-9a-z ,.:+?/()-]', '', 1, 0, 'mi'), 1, 25) || lf_l ||
        SUBSTR (regexp_replace (primatelj_mjesto_p, '[^0-9a-z ,.:+?/()-]', '', 1, 0, 'mi'), 1, 27) || lf_l ||
        REPLACE (iban_p, ' ', '') || lf_l ||
        NVL (br_modela_p, 'HR00') || lf_l ||
        poziv_na_broj_p || lf_l ||
        'GDSV' || lf_l ||
        SUBSTR (regexp_replace (opis_placanja_p, '[^0-9a-z ,.:+?/()-]', '', 1, 0, 'mi'), 1, 35) AS text
    FROM
      dual
    WHERE
      iznos_p > 0
    ) x;

  IF data_m IS NULL THEN
    RETURN; -- izlaz iz procedure
  END IF;

  IF pra_pka_zaj.vrijednost_parametra ('1058') = 'da' THEN
    pra_pka2.clob_to_table ('[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || ']' || CHR(10), poziv_na_broj_p, id_retka_p, 'PDF417Code');
    -- maknut pretty_print_xml jer izbaci &#10;
    pra_pka2.clob_to_table (REPLACE (data_m, '><', '>' || CHR(10) || '<') || CHR(10), poziv_na_broj_p, id_retka_p, 'PDF417Code');
  END IF;

  pra_pka_i3fiskal.zaj_post;

  IF pra_pka_zaj.vrijednost_parametra ('1058') = 'da' THEN
    pra_pka2.clob_to_table ('[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || ']' || CHR(10), poziv_na_broj_p, id_retka_p, 'PDF417Code');
    pra_pka2.clob_to_table (pra_pka2.pretty_print_xml (odgovor_m) || CHR(10), poziv_na_broj_p, id_retka_p, 'PDF417Code');
  END IF;

  -- obradi odgovor
  /*
  <?xml version="1.0" encoding="UTF-8" standalone="no"?>
  <Response>
    <PDF417Code>/9j/4AAQSkZJRgABAgAAAQABAAD/2wBDA...AgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0aHBwg</PDF417Code>
  </Response>
  */

  /*
  -- Komentirano jer javlja greku
  -- ORA-01706: user function result value was too large
  SELECT extractvalue (xmltype (odgovor_m), '/Response/PDF417Code')
    INTO pdf417code_clob_l
    FROM dual;
  */

  SELECT xml.vals
    INTO pdf417code_clob_l
    FROM XMLTable (
           '/Response/PDF417Code' -- ako je ovdje samo '/Response' onda na bazi 11g i 19c javi greku ORA-01403: no data found
           PASSING xmltype (odgovor_m)
           COLUMNS vals CLOB PATH '/PDF417Code') xml
   WHERE xml.vals IS NOT NULL;

  IF pdf417code_clob_l IS NOT NULL THEN
    pdf417code_blob_l := base64decode (pdf417code_clob_l);

    SELECT MAX (id)
      INTO pkapri_id_l
      FROM tpka_prilozi
     WHERE naz_tablice = naz_tablice_p
       AND id_retka = id_retka_p
       AND naz_priloga = naz_priloga_l;

    IF pkapri_id_l IS NOT NULL THEN
      UPDATE tpka_prilozi
         SET prilog = pdf417code_blob_l
       WHERE id = pkapri_id_l;
    ELSE
      INSERT INTO tpka_prilozi (naz_tablice, id_retka, naz_priloga, prilog)
        VALUES (naz_tablice_p, id_retka_p, naz_priloga_l, pdf417code_blob_l);
    END IF;
  END IF;

  COMMIT;

EXCEPTION
  WHEN OTHERS THEN
    -- Pogreka kod spremanja PDF417 2D bar koda
    pra_pka_iud.puni_pkapro ('PKA', '0012', SUBSTR (SQLCODE || ' ' || SQLERRM, 1, 2000), 0);
END;
END PRA_PKA_I3FISKAL;
/
SHOW ERROR

