PROMPT Creating Package Body 'PRA_PKA_FIN'
CREATE OR REPLACE PACKAGE BODY PRA_PKA_FIN IS

PROCEDURE LC_OBRADI_ODG_SCDOK
 (PKAPRIFIN_ID_P IN LPKA_PRIJEPISI_FIN.ID%TYPE
 );
PROCEDURE LC_OBRADI_ODG_KONTDOK
 (PKAPRIFIN_ID_P IN LPKA_PRIJEPISI_FIN.ID%TYPE
 );
PROCEDURE VIR2_IZVRSI_PRIJEPIS_JOB
 (BR_DANA_POC_P IN NUMBER
 ,BR_DANA_ZAV_P IN NUMBER
 );


PROCEDURE UPDATE_PKARAC_GP
 (ID_P IN TPKA_RACUNI.ID%TYPE
 ,OJ_ID_P IN TPKA_RACUNI.OJ_ID%TYPE
 ,FINPRED_ID_P IN TPKA_RACUNI.FINPRED_ID%TYPE
 ,FINPRED_UK_P IN TPKA_RACUNI.FINPRED_UK%TYPE
 ,ROWCOUNT_P OUT NUMBER
 )
 IS
-- upii finpred podatke u GP u tpka_racuni
  CURSOR ojr_c IS
    SELECT metcvor_sifra
      FROM mzmp_ojr ojr
    WHERE ojr.id = oj_id_p;
  metcvor_sifra_l VARCHAR2(41);
  naredba_l VARCHAR2(2000);
BEGIN
  IF id_p IS NULL OR oj_id_p IS NULL OR finpred_id_p IS NULL OR finpred_uk_p IS NULL THEN
    RETURN;
  END IF;
  OPEN ojr_c;
  FETCH ojr_c INTO metcvor_sifra_l;
  IF ojr_c%NOTFOUND THEN
    CLOSE ojr_c;
    -- Greka: Ne postoji #0 #1.
    pra_pka_zaj.vrati_poruku (-20204, pra_zmp_zaj.poruka ('ZMP', 'ZMP_ZMPOJR'), oj_id_p);
  END IF;
  CLOSE ojr_c;

  IF metcvor_sifra_l = pra_zmp_zaj.tekuci_cvor THEN
    metcvor_sifra_l := '';
  ELSE
    metcvor_sifra_l := '@' || metcvor_sifra_l;
  END IF;
  naredba_l :=
   'UPDATE tpka_racuni' || metcvor_sifra_l || '
       SET finpred_id = :finpred_id,
           finpred_uk = :finpred_uk
     WHERE id = :id
       AND oj_id = :oj_id
       AND id IN (SELECT id FROM v_tpka_gp' || metcvor_sifra_l || ')'
    ;
  EXECUTE IMMEDIATE naredba_l
    USING finpred_id_p, finpred_uk_p, id_p, oj_id_p;
  rowcount_p := SQL%ROWCOUNT;
END;
PROCEDURE LC_ZAJ_POST
 IS
--
  url_l      s_parametri_prijepisa.staza%TYPE; -- := 'http://npbcentar:7776/spi-sc-service_v30_test_npbrijuni/nacionalni_park_brijuni_test/sc';
  username_l VARCHAR2(50); -- := 'WSITECH';
  password_l VARCHAR2(50); -- := 'wsitech';

  wallet_staza_l    s_parametri_prijepisa.staza%TYPE;
  wallet_password_l s_vlasnik.wallet_password%TYPE;

  br_dana_l         szmp_parametri.vrijednost%TYPE;
  /*
  '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:v0="http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1">
     <soapenv:Header/>
     <soapenv:Body>
       <v0:dohvatiStavkeIzvadakaRequest>
         <v0:VsID>ISTRATECH_SC</v0:VsID>
         <v0:izvadci>
           <v0:IBAN>HR1625000091838000004</v0:IBAN>
           <v0:Datum>2016-10-31</v0:Datum>
         </v0:izvadci>
       </v0:dohvatiStavkeIzvadakaRequest>
     </soapenv:Body>
   </soapenv:Envelope>'
  */

  login_l VARCHAR2(1000);

  CURSOR vlas_c IS
    SELECT wallet_password
      FROM s_vlasnik;

  CURSOR parpri_c (sifra_k IN s_parametri_prijepisa.sifra%TYPE) IS
    SELECT staza
      FROM s_parametri_prijepisa
     WHERE sifra = sifra_k;

  CURSOR pkaparpri_c (sifra_k IN s_parametri_prijepisa.sifra%TYPE) IS
    SELECT staza
      FROM spka_parametri_prijepisa
     WHERE sifra = sifra_k;

  CURSOR auth_c IS
    SELECT sus_username, sus_password
      FROM mrec_auth_sus
     WHERE zmpsus_id IN (select id from szmp_sustavi where sifra = 'LIBUSOFT');

  req_l  UTL_HTTP.req;
  res_l  UTL_HTTP.resp;
  line_l CLOB;
BEGIN

  OPEN pkaparpri_c ('RACUNI');
  FETCH pkaparpri_c INTO url_l;
  CLOSE pkaparpri_c;

  OPEN vlas_c;
  FETCH vlas_c INTO wallet_password_l;
  CLOSE vlas_c;

  OPEN parpri_c ('WALLET');
  FETCH parpri_c INTO wallet_staza_l;
  CLOSE parpri_c;

  OPEN auth_c;
  FETCH auth_c INTO username_l, password_l;
  CLOSE auth_c;

  br_dana_l := pra_zmp_zaj.zmppar_vrijednost('LIBUSOFT', '1009');

  IF UPPER (br_dana_l) <> 'NEBITNO' THEN
    DELETE FROM lpka_clob
     WHERE oznaka = 'FINLC'
       AND TRUNC(SYSDATE) - TRUNC(unos_dat) >= TO_NUMBER(br_dana_l);
  END IF;

  IF log_filename_m IS NOT NULL THEN
    pra_pka2.clob_to_table ('[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' || url_l || CHR(10), log_filename_m, NULL, 'FINLC');
    pra_pka2.clob_to_table (pra_pka2.pretty_print_xml (data_m) || CHR(10), log_filename_m, NULL, 'FINLC');
  END IF;

  UTL_HTTP.set_detailed_excp_support (enable => true);

  UTL_HTTP.set_wallet ('file:' || wallet_staza_l || '/', wallet_password_l);

  req_l := UTL_HTTP.begin_request (url => url_l, method => 'POST', http_version => 'HTTP/1.1');
  UTL_HTTP.set_authentication(req_l, username_l, password_l);

  UTL_HTTP.set_header (req_l, 'Content-Type', 'text/xml; charset=utf-8');

  -- dbms_output.put_line (data_m);

  DECLARE
    req_length_l    BINARY_INTEGER;
    buffer_l        VARCHAR2(2000);
    amount_l        PLS_INTEGER := 2000;
    offset_l        PLS_INTEGER := 1;
  BEGIN
    req_length_l := pra_pka2.clob_length (data_m);

    IF req_length_l <= 32767 THEN
      UTL_HTTP.set_header (req_l, 'Content-Length', pra_pka2.clob_length (data_m));
      UTL_HTTP.write_text (req_l, data_m);

    ELSE
      UTL_HTTP.set_header (req_l, 'Transfer-Encoding', 'chunked');

      WHILE (offset_l < req_length_l) LOOP
        buffer_l := DBMS_LOB.SUBSTR (data_m, amount_l, offset_l);
        UTL_HTTP.write_text(req_l, buffer_l);
        -- dbms_output.put_line (buffer_l);
        offset_l := offset_l + amount_l;
      END LOOP;
    END IF;
  END;

  res_l := UTL_HTTP.get_response (req_l);

  BEGIN
    LOOP
      UTL_HTTP.read_text (res_l, line_l);
      -- dbms_output.put_line (line_l);
      odgovor_m := odgovor_m || line_l;
    END LOOP;
    UTL_HTTP.end_response (res_l);
  EXCEPTION
    WHEN UTL_HTTP.end_of_body THEN
      UTL_HTTP.end_response (res_l);
  END;

  br_dana_l := pra_zmp_zaj.zmppar_vrijednost ('LIBUSOFT', '1009');

  IF UPPER (br_dana_l) <> 'NEBITNO' THEN
    DELETE FROM lpka_clob
     WHERE oznaka = 'FINLC'
       AND TRUNC (SYSDATE) - TRUNC (unos_dat) >= TO_NUMBER (br_dana_l);
  END IF;

  IF log_filename_m IS NOT NULL THEN
    pra_pka2.clob_to_table (pra_pka2.pretty_print_xml (odgovor_m) || CHR(10), log_filename_m, NULL, 'FINLC');
  END IF;

EXCEPTION
  WHEN UTL_HTTP.transfer_timeout THEN -- IRN 2465
    pra_zmp_zaj.vrati_poruku (-20000, REPLACE (UTL_HTTP.get_detailed_sqlerrm, 'ORA', '')); -- ORA 'smeta' ON-ERROR u modulu

END;
PROCEDURE LC_SALJI_SCDOK
 (PKAPRIFIN_ID_P IN LPKA_PRIJEPISI_FIN.ID%TYPE
 ,DATUM_P IN T_RACUNI.DATUM%TYPE
 ,OZN_BI_P IN NUMBER
 ,OZN_GI_P IN NUMBER
 ,OZN_POS_P IN NUMBER
 ,OZN_PRED_P IN NUMBER
 ,OZN_OBR_P IN NUMBER
 )
 IS
/*
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:v0="http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1">
   <soapenv:Header/>
   <soapenv:Body>
      <v0:kreirajSCDokumenteRequest>
         <v0:VsID>?</v0:VsID>
         <!--Optional:-->
         <v0:DjelomicnaObrada>?</v0:DjelomicnaObrada>
         <v0:dokumenti>
            <!--1 or more repetitions:-->
            <v0:dokument>
               <v0:DokGUID>?</v0:DokGUID>
               <v0:DokVrsta>?</v0:DokVrsta>
               <!--Optional:-->
               <v0:DokGUIDVeza>?</v0:DokGUIDVeza>
               <!--Optional:-->
               <v0:TdSifra>?</v0:TdSifra>
               <!--Optional:-->
               <v0:SifraZaRasporedivanje>?</v0:SifraZaRasporedivanje>
               <!--Optional:-->
               <v0:DokOpis>?</v0:DokOpis>
               <v0:KDVrsta>?</v0:KDVrsta>
               <v0:DatDokumenta>?</v0:DatDokumenta>
               <v0:DatDospijeca>?</v0:DatDospijeca>
               <v0:DatKnjizenja>?</v0:DatKnjizenja>
               <!--Optional:-->
               <v0:DatIsporuke>?</v0:DatIsporuke>
               <!--Optional:-->
               <v0:DatPlacanja>?</v0:DatPlacanja>
               <!--Optional:-->
               <v0:DatOvjere>?</v0:DatOvjere>
               <v0:Valuta>?</v0:Valuta>
               <v0:ParSifra>?</v0:ParSifra>
               <!--Optional:-->
               <v0:PnboModel>?</v0:PnboModel>
               <!--Optional:-->
               <v0:PnboBroj>?</v0:PnboBroj>
               <!--Optional:-->
               <v0:PnbzModel>?</v0:PnbzModel>
               <!--Optional:-->
               <v0:PnbzBroj>?</v0:PnbzBroj>
               <!--Optional:-->
               <v0:RIznos>?</v0:RIznos>
               <!--Optional:-->
               <v0:RRabat>?</v0:RRabat>
               <!--Optional:-->
               <v0:RSconto>?</v0:RSconto>
               <!--Optional:-->
               <v0:RNeto>?</v0:RNeto>
               <!--Optional:-->
               <v0:RPorez>?</v0:RPorez>
               <!--Optional:-->
               <v0:RBruto>?</v0:RBruto>
               <!--Optional:-->
               <v0:UIznos>?</v0:UIznos>
               <!--Optional:-->
               <v0:URabat>?</v0:URabat>
               <!--Optional:-->
               <v0:USconto>?</v0:USconto>
               <!--Optional:-->
               <v0:UNeto>?</v0:UNeto>
               <!--Optional:-->
               <v0:UPorez>?</v0:UPorez>
               <!--Optional:-->
               <v0:UBruto>?</v0:UBruto>
               <v0:UkBruto>?</v0:UkBruto>
               <!--Optional:-->
               <v0:DevValuta>?</v0:DevValuta>
               <!--Optional:-->
               <v0:DevDatum>?</v0:DevDatum>
               <!--Optional:-->
               <v0:DevTecaj>?</v0:DevTecaj>
               <!--Optional:-->
               <v0:DevRIznos>?</v0:DevRIznos>
               <!--Optional:-->
               <v0:DevUIznos>?</v0:DevUIznos>
               <!--Optional:-->
               <v0:UcdBroj>?</v0:UcdBroj>
               <!--Optional:-->
               <v0:IcdBroj>?</v0:IcdBroj>
               <!--Optional:-->
               <v0:DokBrojRacuna>?</v0:DokBrojRacuna>
               <!--Optional:-->
               <v0:DokKnjiga>?</v0:DokKnjiga>
               <!--Optional:-->
               <v0:MtSifra>?</v0:MtSifra>
               <!--Optional:-->
               <v0:PoreznaOznaka>?</v0:PoreznaOznaka>
               <!--Optional:-->
               <v0:PlacNacin>?</v0:PlacNacin>
               <!--Optional:-->
               <v0:PlacIznos>?</v0:PlacIznos>
               <!--Optional:-->
               <v0:Zatvoren>?</v0:Zatvoren>
               <!--Optional:-->
               <v0:SifraNamjene>?</v0:SifraNamjene>
               <!--Optional:-->
               <v0:poreznastruktura>
                  <!--1 or more repetitions:-->
                  <v0:ps>
                     <v0:PsTip>?</v0:PsTip>
                     <v0:PsPorezPosto>?</v0:PsPorezPosto>
                     <v0:PsOsnovica>?</v0:PsOsnovica>
                     <v0:PsPorezIznos>?</v0:PsPorezIznos>
                     <v0:PsKategorija>?</v0:PsKategorija>
                     <!--Optional:-->
                     <v0:PsPnkIznos>?</v0:PsPnkIznos>
                  </v0:ps>
               </v0:poreznastruktura>
            </v0:dokument>
         </v0:dokumenti>
      </v0:kreirajSCDokumenteRequest>
   </soapenv:Body>
</soapenv:Envelope>
*/
  val_dom_sifra_l s_valute.sifra_3a%TYPE := pra_zmp_zaj.vrijednost_parametra ('0001');
  upit_l         XMLTYPE;
BEGIN

  data_m := NULL;
  odgovor_m := NULL;

  FOR rac_c IN (
    SELECT rac.id
      FROM lpka_rac_fin pkaracfin,
           t_racuni rac
     WHERE ozn_bi_p = -1
       AND pkaracfin.datum = datum_p
       AND pkaracfin.ozn_vracuna = 'RECBI'
       AND pkaracfin.pkaprifinsc_id IS NULL
       AND pkaracfin.findok_broj IS NULL
       AND rac.guid = pkaracfin.guid
     ORDER BY rac.id)
  LOOP
    SELECT xmlelement("soapenv:Envelope",
             xmlattributes('http://schemas.xmlsoap.org/soap/envelope/' "xmlns:soapenv",
                           'http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1' "xmlns:v0"),
             xmlelement("soapenv:Header", NULL),
             xmlelement("soapenv:Body",
               xmlelement("v0:kreirajSCDokumenteRequest",
                 xmlelement("v0:VsID",'ISTRATECH_SC'),
                 xmlelement("v0:DjelomicnaObrada", 'true'),
                 xmlelement("v0:dokumenti",
                   xmlconcat(
                     extract(upit_l, '/soapenv:Envelope/soapenv:Body/v0:kreirajSCDokumenteRequest/v0:dokumenti/v0:dokument',
                                     'xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:v0="http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1"'),
                     xmlelement("v0:dokument",
                       xmlelement("v0:DokGUID", guid),
                       xmlelement("v0:DokVrsta", oznaka),
                       DECODE(racp_guid,
                              NULL, NULL,
                              xmlelement("v0:DokGUIDVeza", racp_guid)),
                       xmlelement("v0:TdSifra", tip_dokumenta),
                       xmlelement("v0:SifraZaRasporedivanje", ojr_sifra),   -- ifra knjige rauna
                       -- xmlelement("v0:DokOpis", NULL),
                       xmlelement("v0:KDVrsta", 'K'),
                       xmlelement("v0:DatDokumenta", to_char(datum, 'rrrr-mm-dd') || 'T' || TO_CHAR(datum, 'hh:mm:ss')),
                       xmlelement("v0:DatDospijeca", to_char(dat_dospijeca, 'rrrr-mm-dd') || 'T' || TO_CHAR(dat_dospijeca, 'hh:mm:ss')),
                       xmlelement("v0:DatKnjizenja", to_char(dat_knjizenja, 'rrrr-mm-dd') || 'T' || TO_CHAR(dat_knjizenja, 'hh:mm:ss')),
                       -- xmlelement("v0:DatIsporuke", to_char(dat_nobveze, 'rrrr-mm-dd') || 'T' || TO_CHAR(dat_nobveze, 'hh:mm:ss')),
                       -- xmlelement("v0:DatPlacanja", NULL),
                       -- xmlelement("v0:DatOvjere", NULL),
                       xmlelement("v0:Valuta", val_dom_sifra_l),
                       xmlelement("v0:ParSifra", kd_sifra),
                       -- xmlelement("v0:PnboModel", NULL),
                       xmlelement("v0:PnboBroj", poziv_na_broj),
                       -- xmlelement("v0:PnbzModel", NULL),
                       -- xmlelement("v0:PnbzBroj", NULL),
                       -- xmlelement("v0:RIznos", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RRabat", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RSconto", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RNeto", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RPorez", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RBruto", TO_NUMBER (NULL)),
                       xmlelement("v0:UIznos", TRIM(TO_CHAR(izn_nodb_npdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       -- xmlelement("v0:URabat", TRIM(TO_CHAR(izn_odbitka_npdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       -- xmlelement("v0:USconto", TO_NUMBER (NULL)),
                       xmlelement("v0:UNeto", TRIM(TO_CHAR(izn_nodb_npdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       xmlelement("v0:UPorez", TRIM(TO_CHAR(izn_pdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       xmlelement("v0:UBruto", TRIM(TO_CHAR(izn_nodb_bpdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       xmlelement("v0:UkBruto", TRIM(TO_CHAR(izn_nodb_bpdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       DECODE(val_sifra_3a,
                              val_dom_sifra_l, NULL,
                              xmlelement("v0:DevValuta", val_sifra_3a)),
                       DECODE(val_sifra_3a,
                              val_dom_sifra_l, NULL,
                              xmlelement("v0:DevDatum", to_char(datum, 'rrrr-mm-dd'))),
                       DECODE(val_sifra_3a,
                              val_dom_sifra_l, NULL,
                              xmlelement("v0:DevTecaj", TRIM(TO_CHAR(izn_tecaja, '9999999990D99999999', 'NLS_NUMERIC_CHARACTERS=''.,''')))
                              ),
                       -- xmlelement("v0:DevRIznos", TO_NUMBER (NULL)),
                       DECODE(val_sifra_3a,
                              val_dom_sifra_l, NULL,
                              xmlelement("v0:DevUIznos", TRIM(TO_CHAR(iznos, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,''')))
                              ),
                       -- xmlelement("v0:UcdBroj", NULL),
                       -- xmlelement("v0:IcdBroj", NULL),
                       xmlelement("v0:DokBrojRacuna", broj_racuna),
                       xmlelement("v0:DokKnjiga", ozn_vapldok),
                       xmlelement("v0:MtSifra", oj_sifra),
                       xmlelement("v0:PoreznaOznaka", porezna_oznaka),
                       xmlelement("v0:PlacNacin", ozn_placanja),
                       xmlelement("v0:PlacIznos", 0),
                       -- xmlelement("v0:Zatvoren", NULL),
                       -- xmlelement("v0:SifraNamjene", NULL),
                       xmlelement("v0:poreznastruktura",
                        (SELECT xmlagg (
                                  xmlelement("v0:ps",
                                    xmlelement("v0:PsTip",'U'),
                                    xmlelement("v0:PsPorezPosto", porez.PsPorezPosto),
                                    xmlelement("v0:PsOsnovica", TRIM(TO_CHAR(ROUND (porez.PsOsnovica, 2), '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                                    xmlelement("v0:PsPorezIznos", TRIM(TO_CHAR(porez.PsPorezIznos, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                                    xmlelement("v0:PsKategorija", porez.PsKategorija)
                                  )
                                )
                           FROM (SELECT racpdv.stopa_pdv AS PsPorezPosto,
                                        SUM (ROUND (racpdv.iznos, 2)) AS PsOsnovica,
                                        SUM(ROUND (racpdv.iznos * (100 + racpdv.stopa_pdv) / 100,  2) - ROUND (racpdv.iznos, 2)) AS PsPorezIznos,
                                        CASE WHEN zmpspisp.sifra IN ('10', '20') THEN 'N' ELSE 'D' END PsKategorija
                                   FROM i_rac_pdv racpdv,
                                        s_vpisporukaz vpispz,
                                        szmp_spisporuka zmpspisp
                                  WHERE racpdv.rac_id = rac_c.id
                                    AND racpdv.vpispz_id = vpispz.id
                                    AND vpispz.zmpspisp_id = zmpspisp.id
                                  GROUP BY racpdv.stopa_pdv,
                                           CASE WHEN zmpspisp.sifra IN ('10', '20') THEN 'N' ELSE 'D' END
                                UNION ALL
                                 SELECT 0 AS PsPorezPosto,
                                        SUM (pra_t_racuni.ppot_iznos (rac_c.id)) AS PsOsnovica,
                                        0 AS PsPorezIznos,
                                        'N' AS PsKategorija
                                   FROM DUAL
                             	  WHERE NVL (pra_t_racuni.ppot_iznos (rac_c.id), 0) <> 0
                                  GROUP BY 0,0,'N'       -- da ne bismo dobili redak sa 0
                                 ) porez
                         )
                       )
                     )
                   )
                 )
               )
             )
           )
      INTO upit_l
      FROM -- dokumenti iz rec.t_racuni
           (SELECT ALL
                   rac.guid AS guid,
                   --CASE WHEN rac.oznaka IN ('N') THEN 'S' ELSE 'R' END AS oznaka,
                   CASE WHEN  (rac.iznos * rac.izn_tecaja + NVL (rac_pred.izn_predujma_domval,0)) >= 0 THEN 'R' ELSE 'S' END AS oznaka,  -- smatra se storno ako je iznos rauna negativan
                  --'BP' AS tip_dokumenta,
                   CASE WHEN vapldok.oznaka IN ('BI') THEN 'BP' ELSE 'OS' END AS tip_dokumenta, -- BI ili BV
                   racp.guid AS racp_guid,
                   rac.oj_sifra ojr_sifra,
                   rac.datum AS datum,
                   rac.dat_dospijeca AS dat_dospijeca,
                   rac.datum AS dat_knjizenja,
                   rac.dat_nobveze AS dat_nobveze,
                   age.sifra AS kd_sifra,
                   rac.poziv_na_broj,
                   ROUND (rac.iznos * rac.izn_tecaja, 2)
                       + NVL (rac_pred.izn_predujma_domval, 0)
                       - NVL (rac_pdv.izn_pdv, 0)
                      AS izn_nodb_npdv,
                    NVL (rac_pdv.izn_pdv, 0) AS izn_pdv,
                    ROUND (rac.iznos * rac.izn_tecaja, 2)
                       + NVL (rac_pred.izn_predujma_domval,0)
                      AS izn_nodb_bpdv,
                    val.sifra_3a AS val_sifra_3a,
                    rac.izn_tecaja,
                    rac.iznos + pra_rec_s2.izn_predujma_racval (rac.id, rac.izn_tecaja) --  -- iznos bruto u valuti rauna
                      AS iznos,
                    pra_pka_s.br_racuna_fsus (rac.oj_sifra,
                                              rac.vdok_sifra2n,
                                              rac.rbr,
                                              rac.datum)
                      AS broj_racuna,
                    --'R' AS ozn_vapldok,
                    CASE WHEN vapldok.oznaka IN ('BI') THEN 'R' ELSE 'O' END AS ozn_vapldok,  -- BI ili BV
                    oj.sifra AS oj_sifra,
                    -- 'PS' AS porezna_oznaka,
                    CASE WHEN vapldok.oznaka IN ('BI') THEN 'PS' ELSE 'PE' END AS porezna_oznaka, -- BI ili BV
                    'B' AS ozn_placanja
               FROM t_racuni rac,
                    t_racuni racp,
                    (SELECT id, oznaka FROM s_vapldok) vapldok,
                    m_agencije age,
                    s_valute val,
                    m_so so,
                    m_oj oj,
                    -- rac_pred
                    (  SELECT t_rac_pred.rac_id AS rac_id,
                              SUM(ROUND (
                                     t_rac_pred.iznos * t_rac_pred.izn_tecaja,
                                     2))
                                 AS izn_predujma_domval
                         FROM t_rac_pred
                     GROUP BY t_rac_pred.rac_id) rac_pred,
                    -- rac_pdv
                    (  SELECT i_rac_pdv.rac_id AS rac_id,
                              SUM (ROUND (i_rac_pdv.iznos, 2)) AS izn_osnovice,
                              SUM (ROUND (i_rac_pdv.iznos * (100 + i_rac_pdv.stopa_pdv) / 100, 2)  - ROUND (i_rac_pdv.iznos, 2))
                                 AS izn_pdv
                         FROM i_rac_pdv
                     GROUP BY i_rac_pdv.rac_id) rac_pdv
             WHERE rac.rac_id = racp.id (+)
               AND rac.vapldok_id = vapldok.id
               AND pra_rec2.agek_id (rac.age_id, rac.agep_id) = age.id
               AND rac.val_id = val.id
               AND rac.id = rac_pred.rac_id(+)
               AND rac.id = rac_pdv.rac_id(+)
               AND rac.so_id = so.id
               AND so.oj_id = oj.id
               AND rac.id = rac_c.id);

  END LOOP;

  -- REC GI (pozitivni, negativni)
  FOR rac_c IN (
    SELECT pkaracfin.ozn_uk ozn_uk,
           pkaracfin.datum datum,
           pkaracfin.ozn_vracuna ozn_vracuna,
           pkaracfin.guid guid,
           oj.id oj_id
      FROM lpka_rac_fin pkaracfin,
           m_oj oj
     WHERE ozn_gi_p = -1
       AND pkaracfin.datum = datum_p
       AND pkaracfin.ozn_vracuna IN ('RECGI', 'RECGIN')
       AND pkaracfin.pkaprifinsc_id IS NULL
       AND pkaracfin.findok_broj IS NULL
       AND oj.sifra = pkaracfin.ozn_uk)
  LOOP
    SELECT xmlelement("soapenv:Envelope",
             xmlattributes('http://schemas.xmlsoap.org/soap/envelope/' "xmlns:soapenv",
                           'http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1' "xmlns:v0"),
             xmlelement("soapenv:Header", NULL),
             xmlelement("soapenv:Body",
               xmlelement("v0:kreirajSCDokumenteRequest",
                 xmlelement("v0:VsID",'ISTRATECH_SC'),
                 xmlelement("v0:DjelomicnaObrada", 'true'),
                 xmlelement("v0:dokumenti",
                   xmlconcat(
                     extract(upit_l, '/soapenv:Envelope/soapenv:Body/v0:kreirajSCDokumenteRequest/v0:dokumenti/v0:dokument',
                                     'xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:v0="http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1"'),
                     xmlelement("v0:dokument",
                       xmlelement("v0:DokGUID", guid),
                       xmlelement("v0:DokVrsta", oznaka),
                       DECODE(racp_guid,
                              NULL, NULL,
                              xmlelement("v0:DokGUIDVeza", racp_guid)),
                       xmlelement("v0:TdSifra", tip_dokumenta),
                       xmlelement("v0:SifraZaRasporedivanje", rac_c.ozn_uk), -- ifra knjige rauna
                       --xmlelement("v0:DokOpis", NULL),
                       xmlelement("v0:KDVrsta", 'K'),
                       xmlelement("v0:DatDokumenta", to_char(datum, 'rrrr-mm-dd') || 'T' || TO_CHAR(datum, 'hh:mm:ss')),
                       xmlelement("v0:DatDospijeca", to_char(dat_dospijeca, 'rrrr-mm-dd') || 'T' || TO_CHAR(dat_dospijeca, 'hh:mm:ss')),
                       xmlelement("v0:DatKnjizenja", to_char(dat_knjizenja, 'rrrr-mm-dd') || 'T' || TO_CHAR(dat_knjizenja, 'hh:mm:ss')),
                       -- xmlelement("v0:DatIsporuke", to_char(dat_nobveze, 'rrrr-mm-dd') || 'T' || TO_CHAR(dat_nobveze, 'hh:mm:ss')),
                       -- xmlelement("v0:DatPlacanja", NULL),
                       -- xmlelement("v0:DatOvjere", NULL),
                       xmlelement("v0:Valuta", val_dom_sifra_l),
                       xmlelement("v0:ParSifra", kd_sifra),
                       --xmlelement("v0:PnboModel", NULL),
                       xmlelement("v0:PnboBroj", poziv_na_broj),
                       --xmlelement("v0:PnbzModel", NULL),
                       --xmlelement("v0:PnbzBroj", NULL),
                       -- xmlelement("v0:RIznos", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RRabat", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RSconto", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RNeto", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RPorez", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RBruto", TO_NUMBER (NULL)),
                       xmlelement("v0:UIznos", TRIM(TO_CHAR(izn_nodb_npdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       -- xmlelement("v0:URabat", TRIM(TO_CHAR(izn_odbitka_npdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       -- xmlelement("v0:USconto", TO_NUMBER (NULL)),
                       xmlelement("v0:UNeto", TRIM(TO_CHAR(izn_nodb_npdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       xmlelement("v0:UPorez", TRIM(TO_CHAR(izn_pdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       xmlelement("v0:UBruto", TRIM(TO_CHAR(izn_nodb_bpdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       xmlelement("v0:UkBruto", TRIM(TO_CHAR(izn_nodb_bpdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       -- xmlelement("v0:DevValuta", val_sifra_3a),
                       -- xmlelement("v0:DevDatum", datum),
                       -- xmlelement("v0:DevTecaj", TRIM(TO_CHAR(izn_tecaja, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       -- xmlelement("v0:DevRIznos", TO_NUMBER (NULL)),
                       -- xmlelement("v0:DevUIznos", TRIM(TO_CHAR(iznos, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       --xmlelement("v0:UcdBroj", NULL),
                       --xmlelement("v0:IcdBroj", NULL),
                       xmlelement("v0:DokBrojRacuna", broj_racuna),
                       xmlelement("v0:DokKnjiga", ozn_vapldok),
                       xmlelement("v0:MtSifra", oj_sifra),
                       xmlelement("v0:PoreznaOznaka", porezna_oznaka),
                       xmlelement("v0:PlacNacin", ozn_placanja),
                       xmlelement("v0:PlacIznos", 0),
                       -- xmlelement("v0:Zatvoren", NULL),
                       --xmlelement("v0:SifraNamjene", NULL),
                       xmlelement("v0:poreznastruktura",
                        (SELECT xmlagg (
                                  xmlelement("v0:ps",
                                    xmlelement("v0:PsTip",'U'),
                                    xmlelement("v0:PsPorezPosto", porez.PsPorezPosto),
									xmlelement("v0:PsOsnovica", TRIM(TO_CHAR(ROUND (porez.PsOsnovica, 2), '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                                    xmlelement("v0:PsPorezIznos", TRIM(TO_CHAR(porez.PsPorezIznos, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                                    xmlelement("v0:PsKategorija", porez.PsKategorija)
                                  )
                                )
                           FROM
							(SELECT
                               racpdv.stopa_pdv AS PsPorezPosto,
                               SUM (ROUND (racpdv.iznos, 2)) AS PsOsnovica,
                               SUM(ROUND (racpdv.iznos * (100 + racpdv.stopa_pdv) / 100,  2) - ROUND (racpdv.iznos, 2)) AS PsPorezIznos,
                               CASE WHEN zmpspisp.sifra IN ('10', '20') THEN 'N' ELSE 'D' END PsKategorija
                            FROM
                               i_rac_pdv racpdv,
                               (SELECT rac.id FROM t_racuni rac, s_vapldok vapldok
                                 WHERE rac.vapldok_id = vapldok.id AND vapldok.oznaka IN ('GI')
                                   AND rac.oj_id = rac_c.oj_id AND rac.datum = rac_c.datum
                                   AND (rac_c.ozn_vracuna = 'RECGI' AND rac.iznos * rac.izn_tecaja + pra_rec_s.izn_predujma (rac.id) >= 0
                                        OR rac_c.ozn_vracuna = 'RECGIN' AND rac.iznos * rac.izn_tecaja + pra_rec_s.izn_predujma (rac.id) < 0)
                                   ) rac,
                               s_vpisporukaz vpispz,
                               szmp_spisporuka zmpspisp
                              WHERE racpdv.rac_id = rac.id AND
                                  racpdv.vpispz_id = vpispz.id AND vpispz.zmpspisp_id = zmpspisp.id
                              GROUP BY
                               racpdv.stopa_pdv,
                               CASE WHEN zmpspisp.sifra IN ('10', '20') THEN 'N' ELSE 'D' END
                            UNION ALL
                              SELECT
                                 0 AS PsPorezPosto,
                                 SUM (pra_t_racuni.ppot_iznos (rac.id)) AS PsOsnovica,
                                 0 AS PsPorezIznos,
                                 'N' AS PsKategorija
                               FROM t_racuni rac, s_vapldok vapldok
                              WHERE rac.vapldok_id = vapldok.id AND vapldok.oznaka IN ('GI')
                                AND rac.oj_id = rac_c.oj_id AND rac.datum = rac_c.datum
                                AND (rac_c.ozn_vracuna = 'RECGI' AND rac.iznos * rac.izn_tecaja + pra_rec_s.izn_predujma (rac.id) >= 0
                                     OR rac_c.ozn_vracuna = 'RECGIN' AND rac.iznos * rac.izn_tecaja + pra_rec_s.izn_predujma (rac.id) < 0)
                                AND NVL (pra_t_racuni.ppot_iznos (rac.id), 0) <> 0
                               GROUP BY 0,0,'N'
                                 ) porez
						    )
                       )
                     )
                   )
                 )
               )
             )
           )
      INTO upit_l
      FROM -- dokumenti iz rec.t_racuni
           (SELECT ALL
                    rac_c.guid AS GUID,
                    --'R' AS oznaka,
                    CASE WHEN rac_c.ozn_vracuna = 'RECGI' THEN 'R' ELSE 'S' END AS oznaka,
                    'GK' AS tip_dokumenta,
                    NULL AS racp_guid,
                    rac_c.datum AS datum,
                    rac_c.datum AS dat_dospijeca,
                    rac_c.datum AS dat_knjizenja,
                    TO_DATE (NULL) AS dat_nobveze,
                    'PU' || rac_c.ozn_uk AS kd_sifra,
                    NULL AS poziv_na_broj,
                    SUM (ROUND (rac.iznos * rac.izn_tecaja, 2)
                       + NVL (rac_pred.izn_predujma_domval, 0)
                       - NVL (rac_pdv.izn_pdv, 0)
                      ) AS izn_nodb_npdv,
                    SUM (NVL (rac_pdv.izn_pdv, 0)) AS izn_pdv,
                    SUM (ROUND (rac.iznos * rac.izn_tecaja, 2)
                       + NVL (rac_pred.izn_predujma_domval,0)
                      ) AS izn_nodb_bpdv,
                    NULL AS val_sifra_3a,
                    TO_NUMBER (NULL) AS izn_tecaja,
                    TO_NUMBER (NULL) AS iznos,
                    rac_c.ozn_uk || '-' || TO_CHAR (TO_DATE (rac_c.datum), 'rrmmdd') AS broj_racuna,
                    'R' AS ozn_vapldok, --CASE WHEN vapldok.oznaka IN ('BV') THEN 'O' ELSE 'R' END AS ozn_vapldok,
                    NULL AS oj_sifra,
                    'PE' AS porezna_oznaka,
                    'G' AS ozn_placanja  --CASE WHEN vapldok.oznaka IN ('GI') THEN 'G' ELSE 'B' END AS ozn_placanja
                FROM t_racuni rac,
                    s_vapldok vapldok,
                    -- rac_pred
                    (  SELECT t_rac_pred.rac_id AS rac_id,
                              SUM(ROUND (
                                     t_rac_pred.iznos * t_rac_pred.izn_tecaja,
                                     2))
                                 AS izn_predujma_domval
                         FROM t_rac_pred
                     GROUP BY t_rac_pred.rac_id) rac_pred,
                    -- rac_pdv
                    (  SELECT i_rac_pdv.rac_id AS rac_id,
                              SUM (ROUND (i_rac_pdv.iznos, 2)) AS izn_osnovice,
                              SUM (ROUND (i_rac_pdv.iznos * (100 + i_rac_pdv.stopa_pdv) / 100, 2)  - ROUND (i_rac_pdv.iznos, 2))
                                 AS izn_pdv
                         FROM i_rac_pdv
                     GROUP BY i_rac_pdv.rac_id) rac_pdv
               WHERE rac.id = rac_pred.rac_id(+)
                    AND rac.id = rac_pdv.rac_id(+)
                    AND rac.vapldok_id = vapldok.id
                    AND vapldok.oznaka IN ('GI')
                    --AND rac.vdok_id = vdok.id
                    --AND vdok.ozn_fin = -1
                    AND rac.oj_id = rac_c.oj_id
                    AND rac.datum = rac_c.datum
                    AND (rac_c.ozn_vracuna = 'RECGI' AND rac.iznos * rac.izn_tecaja + pra_rec_s.izn_predujma (rac.id) >= 0
                         OR rac_c.ozn_vracuna = 'RECGIN' AND rac.iznos * rac.izn_tecaja + pra_rec_s.izn_predujma (rac.id) < 0)
               GROUP BY
                  CASE WHEN rac_c.ozn_vracuna = 'RECGI' THEN 'R' ELSE 'S' END
            );

  END LOOP;
  -- kraj REC GI

  -- GAS
  FOR rac_c IN (
    SELECT pkaracfin.ozn_uk ozn_uk,
           pkaracfin.datum datum,
           pkaracfin.guid guid,
           pkaracfin.ozn_vracuna
      FROM lpka_rac_fin pkaracfin
     WHERE ozn_pos_p = -1
       AND pkaracfin.datum = datum_p
       AND pkaracfin.ozn_vracuna IN ('POS', 'POSN')
       AND pkaracfin.pkaprifinsc_id IS NULL
       AND pkaracfin.findok_broj IS NULL )
  LOOP
    SELECT xmlelement("soapenv:Envelope",
             xmlattributes('http://schemas.xmlsoap.org/soap/envelope/' "xmlns:soapenv",
                           'http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1' "xmlns:v0"),
             xmlelement("soapenv:Header", NULL),
             xmlelement("soapenv:Body",
               xmlelement("v0:kreirajSCDokumenteRequest",
                 xmlelement("v0:VsID",'ISTRATECH_SC'),
                 xmlelement("v0:DjelomicnaObrada", 'true'),
                 xmlelement("v0:dokumenti",
                   xmlconcat(
                     extract(upit_l, '/soapenv:Envelope/soapenv:Body/v0:kreirajSCDokumenteRequest/v0:dokumenti/v0:dokument',
                                     'xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:v0="http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1"'),
                     xmlelement("v0:dokument",
                       xmlelement("v0:DokGUID", DokGUID),
                       xmlelement("v0:DokVrsta", DokVrsta),
				       -- xmlelement("v0:DokGUIDVeza", DokGUIDVeza),
                       xmlelement("v0:TdSifra", TdSifra),
                       xmlelement("v0:SifraZaRasporedivanje", SifraZaRasporedivanje),
                       -- xmlelement("v0:DokOpis", NULL),
                       xmlelement("v0:KDVrsta", KDVrsta),
                       xmlelement("v0:DatDokumenta", to_char(DatDokumenta, 'rrrr-mm-dd') || 'T' || TO_CHAR(DatDokumenta, 'hh:mm:ss')),
                       xmlelement("v0:DatDospijeca", to_char(DatDospijeca, 'rrrr-mm-dd') || 'T' || TO_CHAR(DatDospijeca, 'hh:mm:ss')),
                       xmlelement("v0:DatKnjizenja", to_char(DatKnjizenja, 'rrrr-mm-dd') || 'T' || TO_CHAR(DatKnjizenja, 'hh:mm:ss')),
                       -- xmlelement("v0:DatIsporuke", to_char(DatIsporuke, 'rrrr-mm-dd') || 'T' || TO_CHAR(DatIsporuke, 'hh:mm:ss')),
                       -- xmlelement("v0:DatPlacanja", NULL),
                       -- xmlelement("v0:DatOvjere", NULL),
                       xmlelement("v0:Valuta", val_dom_sifra_l),
                       xmlelement("v0:ParSifra", ParSifra),
                       -- xmlelement("v0:PnboModel", NULL),
                       -- xmlelement("v0:PnboBroj", NULL),
                       -- xmlelement("v0:PnbzModel", NULL),
                       -- xmlelement("v0:PnbzBroj", NULL),
                       -- xmlelement("v0:RIznos", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RRabat", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RSconto", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RNeto", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RPorez", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RBruto", TO_NUMBER (NULL)),
                       xmlelement("v0:UIznos", TRIM(TO_CHAR(UIznos, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       -- xmlelement("v0:URabat", TRIM(TO_CHAR(URabat, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       -- xmlelement("v0:USconto", TO_NUMBER (NULL)),
                       xmlelement("v0:UNeto", TRIM(TO_CHAR(UNeto, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       xmlelement("v0:UPorez", TRIM(TO_CHAR(UPorez, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       xmlelement("v0:UBruto", TRIM(TO_CHAR(UBruto, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       xmlelement("v0:UkBruto", TRIM(TO_CHAR(UkBruto, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       -- xmlelement("v0:DevValuta", NULL),
                       -- xmlelement("v0:DevDatum", NULL),
                       -- xmlelement("v0:DevTecaj", NULL),
                       -- xmlelement("v0:DevRIznos", TO_NUMBER (NULL)),
                       -- xmlelement("v0:DevUIznos", TO_NUMBER (NULL)),
                       -- xmlelement("v0:UcdBroj", NULL),
                       -- xmlelement("v0:IcdBroj", NULL),
                       xmlelement("v0:DokBrojRacuna", DokBrojRacuna),
                       xmlelement("v0:DokKnjiga", DokKnjiga),
                       xmlelement("v0:MtSifra", MtSifra),
                       xmlelement("v0:PoreznaOznaka", PoreznaOznaka),
                       xmlelement("v0:PlacNacin", PlacNacin),
                       xmlelement("v0:PlacIznos", 0),
                       -- xmlelement("v0:Zatvoren", NULL),
                       -- xmlelement("v0:SifraNamjene", NULL),
                       xmlelement("v0:poreznastruktura",
                        (SELECT xmlagg (
                                  xmlelement("v0:ps",
                                    xmlelement("v0:PsTip",'U'),
                                    xmlelement("v0:PsPorezPosto", porez.PsPorezPosto),
									xmlelement("v0:PsOsnovica", TRIM(TO_CHAR(ROUND (porez.PsOsnovica, 2), '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                                    xmlelement("v0:PsPorezIznos", TRIM(TO_CHAR(porez.PsPorezIznos, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                                    xmlelement("v0:PsKategorija", porez.PsKategorija)
                                  )
                                )
                           FROM
							  (SELECT 'U' AS PsTPsTip,
                                      rnpro.pdv AS PsPorezPosto,
                                      SUM(rnpro.iznos - rnpro.iznos_pdv - rnpro.iznos_ppot) AS PsOsnovica,
                                      SUM(rnpro.iznos_pdv) AS PsPorezIznos,
                                      DECODE (zmpspisp.sifra, '10', 'N', '20', 'N', 'D')  AS PsKategorija,
                                      TO_NUMBER (NULL) AS PsPnkIznos
                                 FROM /*t_rnkase rn,
                                      t_rnkase_pro rnpro,*/
                                      v_rnkase_pro_vpla rnpro,
                                      s_vplacanja vpla,
                                      s_vpplacanja vppla,
                                      mzmp_gmpkas_sus gmpkassus,
                                      szmp_sustavi sus,
                                      szmp_spisporuka zmpspisp,
                                      s_vpisporukaz zmpspispz,
                                      (SELECT rn_id, SUM(iznos) iznos FROM t_rnkase_pro GROUP BY rn_id) suma
                                WHERE /*rn.id = rnpro.rn_id
                                  AND*/ rnpro.datum  = rac_c.datum
                                  AND rnpro.vpla_id = vpla.id
                                  AND vpla.vppla_id = vppla.id
                                  AND rnpro.id = suma.rn_id
                                  AND (vppla.sifra <> 'X' OR  INSTR (pra_zmp_zaj.vrijednost_parametra ('0033'), vpla.sifra ) > 0)
                                  AND gmpkassus.zmpsus_id = sus.id
                                  AND gmpkassus.gmpkas_id = rnpro.kase_id
                                  AND sus.sifra = 'LIBUSOFT'
                                  AND gmpkassus.sifra = rac_c.ozn_uk
                                  AND rnpro.vpispz_id = zmpspispz.id
                                  AND zmpspispz.zmpspisp_id = zmpspisp.id
                                  AND (rac_c.ozn_vracuna = 'POS' AND suma.iznos >= 0
                                       OR rac_c.ozn_vracuna = 'POSN' AND suma.iznos < 0)
                                GROUP BY  'U', rnpro.pdv,  DECODE (zmpspisp.sifra, '10', 'N', '20', 'N', 'D')
                                UNION ALL
                               SELECT 'U' AS PsTPsTip,
                                      0 AS PsPorezPosto,
                                      SUM(rnpro.iznos_ppot) AS PsOsnovica,
                                      SUM(0) AS PsPorezIznos,
                                      'N' AS PsKategorija,
                                      TO_NUMBER (NULL) AS PsPnkIznos
                                 FROM /*t_rnkase rn,
                                      t_rnkase_pro rnpro,*/
                                      v_rnkase_pro_vpla rnpro,
                                      s_vplacanja vpla,
                                      s_vpplacanja vppla,
                                      mzmp_gmpkas_sus gmpkassus,
                                      szmp_sustavi sus,
                                      (SELECT rn_id, SUM(iznos) iznos FROM t_rnkase_pro GROUP BY rn_id) suma
                                WHERE /*rn.id = rnpro.rn_id
                                  AND*/ rnpro.datum  = rac_c.datum
                                  AND rnpro.vpla_id = vpla.id
                                  AND vpla.vppla_id = vppla.id
                                  AND rnpro.id = suma.rn_id
                                  AND (vppla.sifra <> 'X' OR  INSTR (pra_zmp_zaj.vrijednost_parametra ('0033'), vpla.sifra ) > 0)
                                  AND gmpkassus.zmpsus_id = sus.id
                                  AND gmpkassus.gmpkas_id = rnpro.kase_id
                                  AND sus.sifra = 'LIBUSOFT'
                                  AND gmpkassus.sifra = rac_c.ozn_uk
                                  AND rnpro.iznos_ppot <> 0
                                  AND (rac_c.ozn_vracuna = 'POS' AND suma.iznos >= 0
                                       OR rac_c.ozn_vracuna = 'POSN' AND suma.iznos < 0)
                                GROUP BY  'U', rnpro.ppot,  'N') porez
							  )
                                )
				                  )
                   )
                 )
               )
             )
           )
      INTO upit_l
      FROM
           (SELECT
         rac_c.guid     AS DokGUID,
         CASE WHEN rac_c.ozn_vracuna = 'POS' THEN 'R' ELSE 'S' END AS DokVrsta,
         NULL           AS DokGUIDVeza,
         'GK'           AS TdSifra,
         ojr.sifra      AS SifraZaRasporedivanje,
         NULL           AS DokOpis,
         'K'            AS KDVrsta,
         rnpro.datum       AS DatDokumenta,
         rnpro.datum       AS DatDospijeca,
         rnpro.datum       AS DatKnjizenja,
         rnpro.datum       AS DatIsporuke,
         TO_DATE (NULL) AS DatPlacanja,
         TO_DATE (NULL) AS DatOvjere,
        'PU' || gmpkassus.sifra AS ParSifra,
         NULL AS PnboModel,
         NULL AS PnboBroj,
         NULL AS PnbzModel,
         NULL AS PnbzBroj,
         TO_NUMBER (NULL) AS RIznos,
         TO_NUMBER (NULL) AS RRabat,
         TO_NUMBER (NULL) AS RSconto,
         TO_NUMBER (NULL) AS RNeto,
         TO_NUMBER (NULL) AS RPorez,
         TO_NUMBER (NULL) AS RBruto,
         SUM(rnpro.iznos - rnpro.iznos_pdv) AS UIznos,
         NULL AS URabat,
         TO_NUMBER (NULL) AS USconto,
         SUM(rnpro.iznos - rnpro.iznos_pdv) AS UNeto,       -- PPOT je ukljuen u UNeto
         SUM(rnpro.iznos_pdv) AS  UPorez,
         SUM(rnpro.iznos)  AS UBruto,
         SUM(rnpro.iznos) AS UkBruto,
         NULL AS DevValuta,
         NULL AS DevDatum,
         TO_NUMBER (NULL) AS DevTecaj,
         TO_NUMBER (NULL) AS DevRIznos,
         TO_NUMBER (NULL) AS DevUIznos,
         NULL AS UcdBroj,
         NULL AS IcdBroj,
         gmpkassus.sifra||'-'||to_char(rnpro.datum, 'rrmmdd') AS DokBrojRacuna,
        'R'   AS DokKnjiga,
         gmpkassus.sifra AS MtSifra,
        'PE'  AS PoreznaOznaka,
        'G'   AS PlacNacin,
         TO_NUMBER (NULL)  AS PlacIznos,
         NULL AS Zatvoren,
         NULL AS SifraNamjene
    FROM /*t_rnkase rn
         ,t_rnkase_pro rnpro*/
         v_rnkase_pro_vpla rnpro
         ,s_vplacanja vpla
         ,s_vpplacanja vppla
         ,mzmp_gmpkas_sus gmpkassus
         ,szmp_sustavi sus
         ,m_kase kase
         ,m_oj ojr
         , (SELECT rn_id, SUM(iznos) iznos FROM t_rnkase_pro GROUP BY rn_id) suma
    WHERE /*rn.id = rnpro.rn_id
      AND*/ rnpro.datum  = rac_c.datum
      AND rnpro.vpla_id = vpla.id
      AND rnpro.kase_id = kase.id
      AND kase.zmpojr_id = ojr.id
      AND rnpro.id = suma.rn_id
      AND vpla.vppla_id = vppla.id
      AND (vppla.sifra <> 'X' OR  INSTR (pra_zmp_zaj.vrijednost_parametra ('0033'), vpla.sifra ) > 0)
      AND gmpkassus.zmpsus_id = sus.id
      AND gmpkassus.gmpkas_id = rnpro.kase_id
      AND sus.sifra = 'LIBUSOFT'
      AND gmpkassus.sifra =rac_c.ozn_uk
      AND (rac_c.ozn_vracuna = 'POS' AND suma.iznos >= 0
           OR rac_c.ozn_vracuna = 'POSN' AND suma.iznos < 0)
    GROUP BY rac_c.guid , ojr.sifra, CASE WHEN rac_c.ozn_vracuna = 'POS' THEN 'R' ELSE 'S' END,
          'K', rnpro.datum, 'PU' || gmpkassus.sifra,
          gmpkassus.sifra||'-'||to_char(rnpro.datum, 'rrmmdd'), 'R', gmpkassus.sifra, 'PS', 'G');
  END LOOP;

   -- END GAS

  -- predujmovi, alju se pojedinano (BP, GP i Iskoriteni)
  FOR predujmovi_c IN (
    SELECT pkarac.id
      FROM lpka_rac_fin pkaracfin,
           tpka_racuni pkarac
     WHERE ozn_pred_p = -1
       AND pkaracfin.datum = datum_p
       AND pkaracfin.ozn_vracuna = 'PKAPRED'
       AND pkaracfin.pkaprifinsc_id IS NULL
       AND pkaracfin.findok_broj IS NULL
       AND pkarac.guid = pkaracfin.guid
     ORDER BY pkarac.id)
  LOOP
    SELECT xmlelement("soapenv:Envelope",
             xmlattributes('http://schemas.xmlsoap.org/soap/envelope/' "xmlns:soapenv",
                           'http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1' "xmlns:v0"),
             xmlelement("soapenv:Header", NULL),
             xmlelement("soapenv:Body",
               xmlelement("v0:kreirajSCDokumenteRequest",
                 xmlelement("v0:VsID",'ISTRATECH_SC'),
                 xmlelement("v0:DjelomicnaObrada", 'true'),
                 xmlelement("v0:dokumenti",
                   xmlconcat(
                     extract(upit_l, '/soapenv:Envelope/soapenv:Body/v0:kreirajSCDokumenteRequest/v0:dokumenti/v0:dokument',
                                     'xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:v0="http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1"'),
                     xmlelement("v0:dokument",
                       xmlelement("v0:DokGUID", guid),
                       xmlelement("v0:DokVrsta", oznaka),
                       DECODE(pkaracp_guid,
                              NULL, NULL,
                              xmlelement("v0:DokGUIDVeza", pkaracp_guid)),
                       xmlelement("v0:TdSifra", tip_dokumenta),
                       xmlelement("v0:SifraZaRasporedivanje", oj_sifra),     -- ifra knjige rauna = pkarac.oj_sifra
                       DECODE(adresa, NULL, NULL, xmlelement("v0:DokOpis", adresa)),
                       xmlelement("v0:KDVrsta", 'K'),
                       xmlelement("v0:DatDokumenta", to_char(datum, 'rrrr-mm-dd') || 'T' || TO_CHAR(datum, 'hh:mm:ss')),
                       xmlelement("v0:DatDospijeca", to_char(dat_dospijeca, 'rrrr-mm-dd') || 'T' || TO_CHAR(dat_dospijeca, 'hh:mm:ss')),
                       xmlelement("v0:DatKnjizenja", to_char(dat_knjizenja, 'rrrr-mm-dd') || 'T' || TO_CHAR(dat_knjizenja, 'hh:mm:ss')),
                       -- xmlelement("v0:DatIsporuke", to_char(dat_nobveze, 'rrrr-mm-dd') || 'T' || TO_CHAR(dat_nobveze, 'hh:mm:ss')),
                       -- xmlelement("v0:DatPlacanja", NULL),
                       -- xmlelement("v0:DatOvjere", NULL),
                       xmlelement("v0:Valuta", val_dom_sifra_l),
                       xmlelement("v0:ParSifra", kd_sifra),
                       -- xmlelement("v0:PnboModel", NULL),
                       -- xmlelement("v0:PnboBroj", poziv_na_broj),
                       -- xmlelement("v0:PnbzModel", NULL),
                       -- xmlelement("v0:PnbzBroj", NULL),
                       -- xmlelement("v0:RIznos", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RRabat", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RSconto", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RNeto", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RPorez", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RBruto", TO_NUMBER (NULL)),
                       xmlelement("v0:UIznos", TRIM(TO_CHAR(izn_nodb_npdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       -- xmlelement("v0:URabat", TRIM(TO_CHAR(izn_odbitka_npdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       -- xmlelement("v0:USconto", TO_NUMBER (NULL)),
                       xmlelement("v0:UNeto", TRIM(TO_CHAR(izn_nodb_npdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       xmlelement("v0:UPorez", TRIM(TO_CHAR(izn_pdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       xmlelement("v0:UBruto", TRIM(TO_CHAR(izn_nodb_bpdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       xmlelement("v0:UkBruto", TRIM(TO_CHAR(izn_nodb_bpdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       DECODE(val_sifra_3a,
                              val_dom_sifra_l, NULL,
                              xmlelement("v0:DevValuta", val_sifra_3a)),
                       DECODE(val_sifra_3a,
                              val_dom_sifra_l, NULL,
                              xmlelement("v0:DevDatum", to_char(datum, 'rrrr-mm-dd'))),
                       DECODE(val_sifra_3a,
                              val_dom_sifra_l, NULL,
                              xmlelement("v0:DevTecaj", TRIM(TO_CHAR(izn_tecaja, '9999999990D99999999', 'NLS_NUMERIC_CHARACTERS=''.,''')))
                              ),
                       -- xmlelement("v0:DevRIznos", TO_NUMBER (NULL)),
                       DECODE(val_sifra_3a,
                              val_dom_sifra_l, NULL,
                              xmlelement("v0:DevUIznos", TRIM(TO_CHAR(iznos, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,''')))
                              ),
                       -- xmlelement("v0:UcdBroj", NULL),
                       -- xmlelement("v0:IcdBroj", NULL),
                       xmlelement("v0:DokBrojRacuna", broj_racuna),
                       xmlelement("v0:DokKnjiga", ozn_vapldok),
                       xmlelement("v0:MtSifra", oj_sifra),
                       xmlelement("v0:PoreznaOznaka", porezna_oznaka),
                       xmlelement("v0:PlacNacin", ozn_placanja),
                       xmlelement("v0:PlacIznos", 0),
                       -- xmlelement("v0:Zatvoren", NULL),
                       -- xmlelement("v0:SifraNamjene", NULL),
                       xmlelement("v0:poreznastruktura",
                        (SELECT xmlagg (
                                  xmlelement("v0:ps",
                                    xmlelement("v0:PsTip",'U'),
                                    xmlelement("v0:PsPorezPosto", porez.PsPorezPosto),
                                    xmlelement("v0:PsOsnovica", TRIM(TO_CHAR(ROUND (porez.PsOsnovica, 2), '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                                    xmlelement("v0:PsPorezIznos", TRIM(TO_CHAR(porez.PsPorezIznos, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                                    xmlelement("v0:PsKategorija", porez.PsKategorija)
                                  )
                                )
                           FROM (SELECT pkaracpdv.stopa_pdv AS PsPorezPosto,
                                        SUM (ROUND (pkaracpdv.iznos, 2)) AS PsOsnovica,
                                        SUM(ROUND (pkaracpdv.iznos * (100 + pkaracpdv.stopa_pdv) / 100,  2) - ROUND (pkaracpdv.iznos, 2)) AS PsPorezIznos,
                                        CASE WHEN zmpspisp.sifra IN ('10', '20') THEN 'N' ELSE 'D' END PsKategorija
                                   FROM ipka_rac_pdv pkaracpdv,
                                        s_vpisporukaz vpispz,
                                        szmp_spisporuka zmpspisp
                                  WHERE pkaracpdv.pkarac_id = predujmovi_c.id
                                    AND pkaracpdv.vpispz_id = vpispz.id
                                    AND vpispz.zmpspisp_id = zmpspisp.id
                                  GROUP BY pkaracpdv.stopa_pdv,
                                           CASE WHEN zmpspisp.sifra IN ('10', '20') THEN 'N' ELSE 'D' END
                                 -- ppot nema u predujmovima
                                 ) porez
                         )
                       )
                     )
                   )
                 )
               )
             )
           )
      INTO upit_l
      FROM -- predujmovi iz pka.tpka_racuni
           (SELECT ALL
                   pkarac.guid AS guid,
                   /*
                   CASE
                     WHEN pkarac.pkarac_id IS NOT NULL THEN 'S' -- ponitava
                     WHEN pkarac.pkaracd_id IS NOT NULL THEN 'S' -- djelomino ponitava (ili iskoritava)
                     ELSE 'R'
                   END AS oznaka,
                   */
                   CASE
                     WHEN pkarac.iznos * pkarac.izn_tecaja >= 0 THEN 'R' -- raun
                     ELSE 'S' -- negativan iznos --> storno
                   END AS oznaka,
                   'PP' AS tip_dokumenta, --?
                   pkaracp.guid AS pkaracp_guid,
                   pkarac.datum AS datum,
                   pkarac.datum AS dat_dospijeca,
                   pkarac.datum AS dat_knjizenja,
                   pkarac.dat_nobveze AS dat_nobveze,
                   NVL (gmpkom.sifra, pra_zmp_zaj.zmppar_vrijednost ('LIBUSOFT', '1005')) AS kd_sifra,
                   --pkarac.poziv_na_broj,
                   ROUND (pkarac.iznos * pkarac.izn_tecaja, 2)
                       - NVL (pkarac_pdv.izn_pdv, 0)
                      AS izn_nodb_npdv,
                    NVL (pkarac_pdv.izn_pdv, 0) AS izn_pdv,
                    ROUND (pkarac.iznos * pkarac.izn_tecaja, 2)
                      AS izn_nodb_bpdv,
                    val.sifra_3a AS val_sifra_3a,
                    pkarac.izn_tecaja,
                    pkarac.iznos AS iznos,
                    pra_pka_s.br_racuna_fsus (pkarac.oj_sifra,
                                              pkarac.vdok_sifra2n,
                                              pkarac.rbr,
                                              pkarac.datum)
                      AS broj_racuna,
                    'P' AS ozn_vapldok, -- predujmovi
                    pkarac.oj_sifra AS oj_sifra,
                    'PE' AS porezna_oznaka,  -- kod predujmova je za BP i GP = PE
                    CASE WHEN vapldok.oznaka IN ('GP') THEN 'G' ELSE 'B' END AS ozn_placanja,
					CASE WHEN pkaadr.rbr IS NOT NULL THEN
					  SUBSTR (pkaadr.rbr || ' ' || DECODE (pkaadr.prezime, NULL, pkaadr.naz_poduzeca, pkaadr.prezime || ', ' || pkaadr.ime), 1, 40)
					  ELSE NULL
					END AS adresa
               FROM tpka_racuni pkarac,
                    tpka_racuni pkaracp,
                    --(select pkarac.*, x.guid from tpka_racuni pkarac, xmk_pkarac_guid x where pkarac.id = x.xmk_pkarac_id) pkarac, -- tpka_racuni pkarac,
                    --(select pkarac.*, x.guid from tpka_racuni pkarac, xmk_pkarac_guid x where pkarac.id = x.xmk_pkarac_id) pkaracp, -- tpka_racuni pkaracp,
                    (SELECT id, oznaka FROM s_vapldok) vapldok,
                    mgmp_komitenti gmpkom,
					mpka_adrese pkaadr,
                    s_valute val,
                    -- pkarac_pdv
                    (  SELECT ipka_rac_pdv.pkarac_id AS pkarac_id,
                              SUM (ROUND (ipka_rac_pdv.iznos, 2)) AS izn_osnovice,
                              SUM (ROUND (ipka_rac_pdv.iznos * (100 + ipka_rac_pdv.stopa_pdv) / 100, 2)  - ROUND (ipka_rac_pdv.iznos, 2))
                                 AS izn_pdv
                         FROM ipka_rac_pdv
                     GROUP BY ipka_rac_pdv.pkarac_id) pkarac_pdv
             WHERE NVL (pkarac.pkarac_id, pkarac.pkaracd_id) = pkaracp.id (+)
               AND pkarac.vapldok_id = vapldok.id
               AND pkarac.gmpkom_id = gmpkom.id (+)
               AND pkarac.pkaadr_id = pkaadr.id (+)
               AND pkarac.val_id = val.id
               AND pkarac.id = pkarac_pdv.pkarac_id(+)
               AND pkarac.id = predujmovi_c.id);

  END LOOP;
  -- kraj PREDUJMOVA

  -- OBRACUNI, alju se pojedinano
  FOR obracuni_c IN (
    SELECT pkaobr.id
      FROM lpka_rac_fin pkaracfin,
           tpka_obracuni pkaobr
     WHERE ozn_obr_p = -1
       AND pkaracfin.datum = datum_p
       AND pkaracfin.ozn_vracuna = 'PKAOBR'
       AND pkaracfin.pkaprifinsc_id IS NULL
       AND pkaracfin.findok_broj IS NULL
       AND pkaobr.datum = datum_p -- samo da se skrati tpka_obracuni
       AND pkaobr.guid = pkaracfin.guid
     ORDER BY pkaobr.id)
  LOOP
    SELECT xmlelement("soapenv:Envelope",
             xmlattributes('http://schemas.xmlsoap.org/soap/envelope/' "xmlns:soapenv",
                           'http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1' "xmlns:v0"),
             xmlelement("soapenv:Header", NULL),
             xmlelement("soapenv:Body",
               xmlelement("v0:kreirajSCDokumenteRequest",
                 xmlelement("v0:VsID",'ISTRATECH_SC'),
                 xmlelement("v0:DjelomicnaObrada", 'true'),
                 xmlelement("v0:dokumenti",
                   xmlconcat(
                     extract(upit_l, '/soapenv:Envelope/soapenv:Body/v0:kreirajSCDokumenteRequest/v0:dokumenti/v0:dokument',
                                     'xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:v0="http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1"'),
                     xmlelement("v0:dokument",
                       xmlelement("v0:DokGUID", guid),
                       xmlelement("v0:DokVrsta", oznaka),
                       DECODE(pkaobrp_guid,
                              NULL, NULL,
                              xmlelement("v0:DokGUIDVeza", pkaobrp_guid)),
                       xmlelement("v0:TdSifra", tip_dokumenta),
                       xmlelement("v0:SifraZaRasporedivanje", oj_sifra),   -- ifra knjige rauna = pkaobr.zmpojr_id
                       -- xmlelement("v0:DokOpis", NULL),
                       xmlelement("v0:KDVrsta", 'K'),
                       xmlelement("v0:DatDokumenta", to_char(datum, 'rrrr-mm-dd') || 'T' || TO_CHAR(datum, 'hh:mm:ss')),
                       xmlelement("v0:DatDospijeca", to_char(dat_dospijeca, 'rrrr-mm-dd') || 'T' || TO_CHAR(dat_dospijeca, 'hh:mm:ss')),
                       xmlelement("v0:DatKnjizenja", to_char(dat_knjizenja, 'rrrr-mm-dd') || 'T' || TO_CHAR(dat_knjizenja, 'hh:mm:ss')),
                       -- xmlelement("v0:DatIsporuke", to_char(dat_nobveze, 'rrrr-mm-dd') || 'T' || TO_CHAR(dat_nobveze, 'hh:mm:ss')),
                       -- xmlelement("v0:DatPlacanja", NULL),
                       -- xmlelement("v0:DatOvjere", NULL),
                       xmlelement("v0:Valuta", val_dom_sifra_l),
                       xmlelement("v0:ParSifra", kd_sifra),
                       -- xmlelement("v0:PnboModel", NULL),
                       xmlelement("v0:PnboBroj", poziv_na_broj),
                       -- xmlelement("v0:PnbzModel", NULL),
                       -- xmlelement("v0:PnbzBroj", NULL),
                       -- xmlelement("v0:RIznos", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RRabat", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RSconto", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RNeto", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RPorez", TO_NUMBER (NULL)),
                       -- xmlelement("v0:RBruto", TO_NUMBER (NULL)),
                       xmlelement("v0:UIznos", TRIM(TO_CHAR(izn_nodb_npdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       -- xmlelement("v0:URabat", TRIM(TO_CHAR(izn_odbitka_npdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       -- xmlelement("v0:USconto", TO_NUMBER (NULL)),
                       xmlelement("v0:UNeto", TRIM(TO_CHAR(izn_nodb_npdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       xmlelement("v0:UPorez", TRIM(TO_CHAR(izn_pdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       xmlelement("v0:UBruto", TRIM(TO_CHAR(izn_nodb_bpdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       xmlelement("v0:UkBruto", TRIM(TO_CHAR(izn_nodb_bpdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       -- xmlelement("v0:DevValuta", val_sifra_3a),
                       -- xmlelement("v0:DevDatum", datum),
                       -- xmlelement("v0:DevTecaj", TRIM(TO_CHAR(izn_tecaja, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       -- xmlelement("v0:DevRIznos", TO_NUMBER (NULL)),
                       -- xmlelement("v0:DevUIznos", TRIM(TO_CHAR(iznos, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       --xmlelement("v0:UcdBroj", NULL),
                       --xmlelement("v0:IcdBroj", NULL),
                       xmlelement("v0:DokBrojRacuna", broj_racuna),
                       xmlelement("v0:DokKnjiga", ozn_vapldok),
                       xmlelement("v0:MtSifra", oj_sifra),
                       xmlelement("v0:PoreznaOznaka", porezna_oznaka),
                       xmlelement("v0:PlacNacin", ozn_placanja),
                       xmlelement("v0:PlacIznos", 0)--,
                       -- xmlelement("v0:Zatvoren", NULL),
                       -- xmlelement("v0:SifraNamjene", NULL),
/*
                       xmlelement("v0:poreznastruktura",
                        (SELECT xmlagg (
                                  xmlelement("v0:ps",
                                    xmlelement("v0:PsTip",'U'),
                                    xmlelement("v0:PsPorezPosto", porez.PsPorezPosto),
                                    xmlelement("v0:PsOsnovica", TRIM(TO_CHAR(ROUND (porez.PsOsnovica, 2), '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                                    xmlelement("v0:PsPorezIznos", TRIM(TO_CHAR(porez.PsPorezIznos, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                                    xmlelement("v0:PsKategorija", porez.PsKategorija)
                                  )
                                )
                           FROM (SELECT pkaobrpdv.stopa_pdv AS PsPorezPosto,
                                        SUM (ROUND (pkaobrpdv.iznos, 2)) AS PsOsnovica,
                                        SUM(ROUND (pkaobrpdv.iznos * (100 + pkaobrpdv.stopa_pdv) / 100,  2) - ROUND (pkaobrpdv.iznos, 2)) AS PsPorezIznos,
                                        CASE WHEN zmpspisp.sifra IN ('10', '20') THEN 'N' ELSE 'D' END PsKategorija
                                   FROM ipka_rac_pdv pkaobrpdv,
                                        s_vpisporukaz vpispz,
                                        szmp_spisporuka zmpspisp
                                  WHERE pkaobrpdv.pkaobr_id = obracuni_c.id
                                    AND pkaobrpdv.vpispz_id = vpispz.id
                                    AND vpispz.zmpspisp_id = zmpspisp.id
                                  GROUP BY pkaobrpdv.stopa_pdv,
                                           CASE WHEN zmpspisp.sifra IN ('10', '20') THEN 'N' ELSE 'D' END
                                 -- ppot nema u predujmovima
                                 ) porez
                         )
                       )
*/
                     )
                   )
                 )
               )
             )
           )
      INTO upit_l
      FROM -- obracuni iz pka.tpka_obracuni
           (SELECT ALL
                   pkaobr.guid AS guid,
 --                  'T' AS oznaka, -- dodatno tereenje
                   CASE WHEN pkaobr.iznos * pkaobr.izn_tecaja >= 0 THEN 'T' -- raun
                     ELSE 'S' -- negativan iznos --> storno
                   END AS oznaka,
                   'OK' AS tip_dokumenta,
                   pkaobrp.guid AS pkaobrp_guid,
                   pkaobr.datum AS datum,
                   pkaobr.dat_dospijeca AS dat_dospijeca,
                   pkaobr.datum AS dat_knjizenja,
                   gmpkom.sifra AS kd_sifra,
                   pkaobr.poziv_na_broj,
                   ROUND (pkaobr.iznos * pkaobr.izn_tecaja, 2)
                      AS izn_nodb_npdv,
                    0 AS izn_pdv,
                    ROUND (pkaobr.iznos * pkaobr.izn_tecaja, 2)
                      AS izn_nodb_bpdv,
                    NULL AS val_sifra_3a,
                    TO_NUMBER (NULL) AS izn_tecaja,
                    TO_NUMBER (NULL) AS iznos,
                    pkaobr.rbr || '-' || oj.sifra || '-' || vdok.sifra2n
                      AS broj_racuna,
                    'R' AS ozn_vapldok, -- redovni
                    oj.sifra AS oj_sifra,
                    'SC' AS porezna_oznaka,  -- SC ? ne ulazi u obraun porez
                    'B' AS ozn_placanja
               FROM tpka_obracuni pkaobr,
                    tpka_obracuni pkaobrp,
                    (SELECT vdok_id FROM s_vapldok WHERE metapl_sifra = 'PKA' AND oznaka = 'OB') vapldok,
                   s_vdokumenata vdok,
                   m_oj oj,
				   mgmp_komitenti gmpkom
             WHERE pkaobr.pkaobr_id = pkaobrp.id (+)
               AND pkaobr.zmpojr_id = oj.id
               AND vapldok.vdok_id = vdok.id
               AND pkaobr.gmpkom_id = gmpkom.id
               AND pkaobr.id = obracuni_c.id);

  END LOOP;
  -- kraj OBRACUNA

  IF upit_l IS NOT NULL THEN

    data_m := upit_l.getClobVal();

    --dbms_output.put_line (data_m);

/*
    SELECT REPLACE(REPLACE(data_m,
                           '', ''),
                   '', '')
      INTO data_m
      FROM dual;
*/
    lc_zaj_post;

    lc_obradi_odg_scdok (pkaprifin_id_p);

  END IF;

END;
PROCEDURE LC_OBRADI_ODG_SCDOK
 (PKAPRIFIN_ID_P IN LPKA_PRIJEPISI_FIN.ID%TYPE
 )
 IS
/*
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:v0="http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1">
   <soapenv:Header/>
   <soapenv:Body>
      <v0:kreirajSCDokumenteResponse>
         <v0:VsID>?</v0:VsID>
         <!--You have a CHOICE of the next 2 items at this level-->
         <v0:dokumenti>
            <!--1 or more repetitions:-->
            <v0:dokument>
               <v0:DokGUID>?</v0:DokGUID>
               <!--Optional:-->
               <v0:KorSifra>?</v0:KorSifra>
               <!--Optional:-->
               <v0:NivSifra>?</v0:NivSifra>
               <!--Optional:-->
               <v0:DokVrsta>?</v0:DokVrsta>
               <!--Optional:-->
               <v0:BrojKnjige>?</v0:BrojKnjige>
               <v0:status>
                  <v0:Greska>?</v0:Greska>
                  <!--Optional:-->
                  <v0:OpisGreske>?</v0:OpisGreske>
               </v0:status>
            </v0:dokument>
         </v0:dokumenti>
         <v0:greska>
            <v0:Greska>?</v0:Greska>
            <!--Optional:-->
            <v0:OpisGreske>?</v0:OpisGreske>
         </v0:greska>
      </v0:kreirajSCDokumenteResponse>
   </soapenv:Body>
</soapenv:Envelope>
*/     
  faultstring_l    lpka_prifin_odg.odgovor%TYPE;
  greska_l    XMLTYPE;
  dokumenti_l XMLTYPE;
BEGIN

  SELECT extractValue(XMLType(odgovor_m),
                 '/soapenv:Envelope/soapenv:Body/soapenv:Fault/faultstring',
                 'xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"
                  xmlns:ns5="http://www.spi.hr/ws/razmjena/sc/v0.1"
                  xmlns:ns4="urn:iso:std:iso:20022:tech:xsd:camt.053.001.02"
                  xmlns:ns3="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"
                  xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1"') fault,
         extract(XMLType(odgovor_m),
                 '/soapenv:Envelope/soapenv:Body/ns2:kreirajSCDokumenteResponse/ns2:greska',
                 'xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"
                  xmlns:ns5="http://www.spi.hr/ws/razmjena/sc/v0.1"
                  xmlns:ns4="urn:iso:std:iso:20022:tech:xsd:camt.053.001.02"
                  xmlns:ns3="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"
                  xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1"') greska,
         extract(XMLType(odgovor_m),
                 '/soapenv:Envelope/soapenv:Body/ns2:kreirajSCDokumenteResponse/ns2:dokumenti',
                 'xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"
                  xmlns:ns5="http://www.spi.hr/ws/razmjena/sc/v0.1"
                  xmlns:ns4="urn:iso:std:iso:20022:tech:xsd:camt.053.001.02"
                  xmlns:ns3="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"
                  xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1"') dokumenti
    INTO faultstring_l,
         greska_l,
         dokumenti_l
    FROM dual;

  IF faultstring_l IS NOT NULL THEN
    INSERT INTO lpka_prifin_odg (pkaprifin_id, odgovor)
      VALUES (pkaprifin_id_p, faultstring_l);
    RETURN;
  END IF;

  IF greska_l IS NOT NULL THEN

    INSERT INTO lpka_prifin_odg (pkaprifin_id, odgovor)
      SELECT pkaprifin_id_p, ExtractValue(column_value, 
                                          '/ns2:OpisGreske', 
                                          'xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1')
        FROM TABLE(XMLSequence(extract(greska_l, 
                                       '/ns2:greska/ns2:OpisGreske', 
                                       'xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" 
                                        xmlns:ns5="http://www.spi.hr/ws/razmjena/sc/v0.1" 
                                        xmlns:ns4="urn:iso:std:iso:20022:tech:xsd:camt.053.001.02" 
                                        xmlns:ns3="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1" 
                                        xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1"')
                               )
                   );                 
       
    RETURN;
  END IF;
  
  FOR odg_c IN (
    SELECT ExtractValue(column_value,'/ns2:dokument/ns2:DokGUID', 
                                     'xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" 
                                      xmlns:ns5="http://www.spi.hr/ws/razmjena/sc/v0.1" 
                                      xmlns:ns4="urn:iso:std:iso:20022:tech:xsd:camt.053.001.02" 
                                      xmlns:ns3="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1" 
                                      xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1"') guid,
           ExtractValue(column_value,'/ns2:dokument/ns2:BrojKnjige', 
                                     'xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" 
                                      xmlns:ns5="http://www.spi.hr/ws/razmjena/sc/v0.1" 
                                      xmlns:ns4="urn:iso:std:iso:20022:tech:xsd:camt.053.001.02" 
                                      xmlns:ns3="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1" 
                                      xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1"') findok,
           ExtractValue(column_value,'/ns2:dokument/ns2:status/ns2:Greska', 
                                     'xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" 
                                      xmlns:ns5="http://www.spi.hr/ws/razmjena/sc/v0.1" 
                                      xmlns:ns4="urn:iso:std:iso:20022:tech:xsd:camt.053.001.02" 
                                      xmlns:ns3="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1" 
                                      xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1"') greska,
           ExtractValue(column_value,'/ns2:dokument/ns2:status/ns2:OpisGreske', 
                                     'xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" 
                                      xmlns:ns5="http://www.spi.hr/ws/razmjena/sc/v0.1" 
                                      xmlns:ns4="urn:iso:std:iso:20022:tech:xsd:camt.053.001.02" 
                                      xmlns:ns3="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1" 
                                      xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1"') opisGreske
      FROM TABLE(XMLSequence(extract(dokumenti_l, '/ns2:dokumenti/ns2:dokument', 
                                     'xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" 
                                      xmlns:ns5="http://www.spi.hr/ws/razmjena/sc/v0.1" 
                                      xmlns:ns4="urn:iso:std:iso:20022:tech:xsd:camt.053.001.02" 
                                      xmlns:ns3="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1" 
                                      xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1"')
                             )
                 ))
  LOOP
    UPDATE lpka_rac_fin -- t_racuni
       SET findok_broj = odg_c.findok,
           pkaprifinsc_id = pkaprifin_id_p
     WHERE guid = odg_c.guid
       AND odg_c.greska = 0;
    
    INSERT INTO lpka_prifin_odg (pkaprifin_id, pkaracfin_id, odgovor)
      SELECT pkaprifin_id_p, id, odg_c.opisGreske
        FROM lpka_rac_fin
       WHERE guid = odg_c.guid
         AND odg_c.greska <> 0;                 
       
  END LOOP;
END;
PROCEDURE LC_SALJI_KNJDOK
 (PKAPRIFIN_ID_P IN LPKA_PRIJEPISI_FIN.ID%TYPE
 ,DATUM_P IN T_RACUNI.DATUM%TYPE
 )
 IS
/*
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:v0="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1">
   <soapenv:Header/>
   <soapenv:Body>
      <v0:spremiStavkeKontiranjaDokumenataRequest>
         <v0:VsID>?</v0:VsID>
         <v0:Godina>?</v0:Godina>
         <v0:dokumenti>
            <!--1 or more repetitions:-->
            <v0:dokument>
               <v0:DokGUID>?</v0:DokGUID>
               <v0:kontiranja>
                  <!--1 or more repetitions:-->
                  <v0:kontiranje>
                     <v0:Rb>?</v0:Rb>
                     <v0:Datum>?</v0:Datum>
                     <!--Optional:-->
                     <v0:PozSifra>?</v0:PozSifra>
                     <v0:KonKonto>?</v0:KonKonto>
                     <!--Optional:-->
                     <v0:MtSifra>?</v0:MtSifra>
                     <v0:Duguje>?</v0:Duguje>
                     <v0:Potrazuje>?</v0:Potrazuje>
                     <!--Optional:-->
                     <v0:Opis>?</v0:Opis>
                  </v0:kontiranje>
               </v0:kontiranja>
            </v0:dokument>
         </v0:dokumenti>
      </v0:spremiStavkeKontiranjaDokumenataRequest>
   </soapenv:Body>
</soapenv:Envelope>
*/
  val_dom_sifra_l s_valute.sifra_3a%TYPE := pra_zmp_zaj.vrijednost_parametra ('0001');
  upit_l         XMLTYPE;
  br_redaka_l NUMBER;
BEGIN

  data_m := NULL;
  odgovor_m := NULL;

  FOR rac_c IN (
    SELECT pkaracfin.guid guid
      FROM lpka_rac_fin pkaracfin
     WHERE pkaracfin.datum = datum_p
       AND pkaracfin.pkaprifinsc_id IS NOT NULL
       AND pkaracfin.findok_broj IS NOT NULL
       AND pkaracfin.pkaprifink_id IS NULL
       AND pkaracfin.ozn_vracuna IN ('RECBI', 'RECGI', 'RECGIN', 'POS', 'POSN'))
  LOOP
/*
-- LC
VsID
Godina
--
DokGUID - opis2
--
Rb - opis3
Datum - datum1
PozSifra - opis4
KonKonto - opis5
MtSifra - opis6
Duguje - iznos1
Potrazuje - iznos2
Opis - opis7
*/
    SELECT COUNT (1) INTO br_redaka_l FROM prec_global2 WHERE opis2 = rac_c.guid;
    IF br_redaka_l > 0 THEN
      SELECT xmlelement("v0:dokumenti",
               xmlattributes('http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1' "xmlns:v0"),
               xmlconcat(
                 extract(upit_l, 'v0:dokumenti/v0:dokument',
                                 'xmlns:v0="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"'),
                 xmlelement("v0:dokument",
                 xmlelement("v0:DokGUID", opis2),
                 xmlelement("v0:kontiranja",
                   xmlagg(
                     xmlelement("v0:kontiranje",
                       xmlelement("v0:Rb", opis3),
                       xmlelement("v0:Datum", TO_CHAR(datum1, 'rrrr-mm-dd')), --  || 'T' || TO_CHAR(datum1, 'hh:mm:ss')
                       DECODE(opis4, NULL, NULL, xmlelement("v0:PozSifra", opis4)),
                       xmlelement("v0:KonKonto", opis5),
                       xmlelement("v0:MtSifra", opis6),
                       xmlelement("v0:Duguje", TRIM(TO_CHAR(NVL(iznos1, 0), '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       xmlelement("v0:Potrazuje", TRIM(TO_CHAR(NVL(iznos2, 0), '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       xmlelement("v0:Valuta", val_dom_sifra_l),                       
                       DECODE(opis7, NULL, NULL, xmlelement("v0:Opis", opis7))
                       )
                     )
                   )
                 )
               )
             )
        INTO upit_l
        FROM prec_global2
       WHERE opis2 = rac_c.guid
       GROUP BY opis2;
     END IF;
  END LOOP;

  IF upit_l IS NOT NULL THEN

    SELECT xmlelement("soapenv:Envelope",
             xmlattributes('http://schemas.xmlsoap.org/soap/envelope/' "xmlns:soapenv",
                           'http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1' "xmlns:v0"),
             xmlelement("soapenv:Header", NULL),
             xmlelement("soapenv:Body",
               xmlelement("v0:spremiStavkeKontDokReq",
                 xmlelement("v0:VsID",'ISTRATECH_SC'),
--                 xmlelement("v0:Godina", TO_CHAR(TRUNC (SYSDATE), 'rrrr')), -- MK IRN 2915
                 xmlelement("v0:Godina", TO_CHAR(TRUNC (datum_p), 'rrrr')), -- MK IRN 2915
                 upit_l
               )
             )
           )
      INTO upit_l
      FROM DUAL;

    data_m := upit_l.getClobVal();

    SELECT REPLACE(data_m,
                   'spremiStavkeKontDokReq', 'spremiStavkeKontiranjaDokumenataRequest')
      INTO data_m
      FROM dual;

    lc_zaj_post;

    lc_obradi_odg_kontdok (pkaprifin_id_p);

  END IF;

END;
PROCEDURE LC_OBRADI_ODG_KONTDOK
 (PKAPRIFIN_ID_P IN LPKA_PRIJEPISI_FIN.ID%TYPE
 )
 IS
/*
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:v0="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1">
   <soapenv:Header/>
   <soapenv:Body>
      <v0:spremiStavkeKontiranjaDokumenataResponse>
         <v0:VsID>?</v0:VsID>
         <v0:Godina>?</v0:Godina>
         <!--You have a CHOICE of the next 2 items at this level-->
         <v0:dokumenti>
            <!--1 or more repetitions:-->
            <v0:dokument>
               <v0:DokGUID>?</v0:DokGUID>
               <!--Optional:-->
               <v0:kontiranja>
                  <!--1 or more repetitions:-->
                  <v0:kontiranje>
                     <v0:Rb>?</v0:Rb>
                     <v0:Datum>?</v0:Datum>
                     <!--Optional:-->
                     <v0:PozSifra>?</v0:PozSifra>
                     <v0:KonKonto>?</v0:KonKonto>
                     <!--Optional:-->
                     <v0:MtSifra>?</v0:MtSifra>
                     <v0:Duguje>?</v0:Duguje>
                     <v0:Potrazuje>?</v0:Potrazuje>
                     <!--Optional:-->
                     <v0:Opis>?</v0:Opis>
                     <!--Optional:-->
                     <v0:greske>
                        <!--1 or more repetitions:-->
                        <v0:greska>
                           <v0:Greska>?</v0:Greska>
                           <v0:OpisGreske>?</v0:OpisGreske>
                        </v0:greska>
                     </v0:greske>
                  </v0:kontiranje>
               </v0:kontiranja>
               <!--Optional:-->
               <v0:greske>
                  <!--1 or more repetitions:-->
                  <v0:greska>
                     <v0:Greska>?</v0:Greska>
                     <v0:OpisGreske>?</v0:OpisGreske>
                  </v0:greska>
               </v0:greske>
            </v0:dokument>
         </v0:dokumenti>
         <v0:greska>
            <v0:Greska>?</v0:Greska>
            <v0:OpisGreske>?</v0:OpisGreske>
         </v0:greska>
      </v0:spremiStavkeKontiranjaDokumenataResponse>
   </soapenv:Body>
</soapenv:Envelope>
*/     
  faultstring_l lpka_prifin_odg.odgovor%TYPE;
  greska_l      XMLTYPE;
  dokumenti_l   XMLTYPE;   
  
  opis_greske_l lpka_prifin_odg.odgovor%type;
BEGIN

  BEGIN
    SELECT extractValue(XMLType(odgovor_m),
                 '/soapenv:Envelope/soapenv:Body/soapenv:Fault/faultstring',
                 'xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"')
      INTO faultstring_l
      FROM DUAL;

  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      NULL;
  END;

  IF faultstring_l IS NOT NULL THEN
    INSERT INTO lpka_prifin_odg (pkaprifin_id, odgovor)
      VALUES (pkaprifin_id_p, faultstring_l);
    RETURN;
  END IF;

/*  SELECT REPLACE(REPLACE(odgovor_m,
                         'spremiStavkeKontiranjaDokumenataResponse', 'spremiStavkeKontDokResp'),
                 '', '')
    INTO odgovor_m
    FROM dual;

  SELECT REPLACE(odgovor_m,
                 'ns3:', '')
    INTO odgovor_m
    FROM dual;

  SELECT SUBSTR(odgovor_m, INSTR(odgovor_m, '<spremiStavkeKontDokResp'), INSTR(odgovor_m, '</spremiStavkeKontDokResp>') + 26  - INSTR(odgovor_m, '<spremiStavkeKontDokResp'))
    INTO odgovor_m
    FROM dual;

  -- obrada odgovora za cijeli prijepis
  SELECT extract(XMLType(odgovor_m),
                 '/spremiStavkeKontDokResp/greska') greska,
         extract(XMLType(odgovor_m),
                 '/spremiStavkeKontDokResp/dokumenti') dokumenti
    INTO greska_l,
         dokumenti_l
    FROM dual;
*/
  SELECT extract(XMLType(odgovor_m),
                 '/soap:Envelope/soap:Body/ns2:spremiStavkeKontiranjaDokumenataResponse/ns2:greska',
                 'xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/"
                  xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"') greska,
              extract(XMLType(odgovor_m),
                 '/soap:Envelope/soap:Body/ns2:spremiStavkeKontiranjaDokumenataResponse/ns2:dokumenti',
                 'xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/"
                  xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"') dokumenti
    INTO greska_l,
         dokumenti_l
    FROM dual;

  /* greku upisujemo u odgovore bez veze na lpka_rac_fin
         ...
         </v0:dokumenti>
         <v0:greska>
            <v0:Greska>?</v0:Greska>
            <v0:OpisGreske>?</v0:OpisGreske>
         </v0:greska>
      </v0:spremiStavkeKontiranjaDokumenataResponse>
  */

  IF greska_l IS NOT NULL THEN

    INSERT INTO lpka_prifin_odg (pkaprifin_id, odgovor)
      SELECT pkaprifin_id_p, ExtractValue(column_value, '/ns2:OpisGreske', 'xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"')
        FROM TABLE(XMLSequence(extract(greska_l, '/ns2:greska/ns2:OpisGreske', 'xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"')
                               )
                   );
    RETURN;
  END IF;

  -- obrada odgovora za pojedini dokument
  FOR odg_c IN (
    SELECT ExtractValue(column_value, '/ns2:dokument/ns2:DokGUID', 'xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"') guid,
           extract(column_value, '/ns2:dokument/ns2:greske', 'xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"') greske,
           extract(column_value, '/ns2:dokument/ns2:kontiranja', 'xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"') kon
      FROM TABLE(XMLSequence(extract(dokumenti_l, '/ns2:dokumenti/ns2:dokument', 'xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"')
                             )
                 ))
  LOOP

    UPDATE lpka_rac_fin
       SET pkaprifink_id = pkaprifin_id_p
     WHERE guid = odg_c.guid
       AND odg_c.greske IS NULL;

    opis_greske_l := NULL;

    /* greke za dokument upisujemo u odgovore s vezom na lpka_rac_fin
              ...
               <!--Optional:-->
               <v0:greske>
                  <!--1 or more repetitions:-->
                  <v0:greska>
                     <v0:Greska>?</v0:Greska>
                     <v0:OpisGreske>?</v0:OpisGreske>
                  </v0:greska>
               </v0:greske>
            </v0:dokument>
    */
    FOR greske_c IN (
       SELECT ExtractValue(column_value, 'ns2:greska/ns2:Greska', 'xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"') greska,
              ExtractValue(column_value, 'ns2:greska/ns2:OpisGreske', 'xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"') opisGreske
         FROM TABLE(XMLSequence(extract(odg_c.greske, 'ns2:greske/ns2:greska', 'xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"')
                                )
                    ))
    LOOP
      IF opis_greske_l IS NULL THEN
        opis_greske_l := greske_c.greska || ': ' || greske_c.opisGreske || ';';
      ELSE
        opis_greske_l := opis_greske_l || chr(10) || greske_c.greska || ': ' || greske_c.opisGreske || ';';
      END IF;
    END LOOP;

    IF opis_greske_l IS NOT NULL THEN
      INSERT INTO lpka_prifin_odg (pkaprifin_id, pkaracfin_id, odgovor)
        SELECT pkaprifin_id_p, id, opis_greske_l
          FROM lpka_rac_fin
         WHERE guid = odg_c.guid;
    END IF;

    /*  greke u kontiranjima unutar pojedinog dokumenta
                     ...
                     <v0:greske>
                        <!--1 or more repetitions:-->
                        <v0:greska>
                           <v0:Greska>?</v0:Greska>
                           <v0:OpisGreske>?</v0:OpisGreske>
                        </v0:greska>
                     </v0:greske>
                  </v0:kontiranje>
               </v0:kontiranja>
    */

    FOR kont_greske_c IN (
       SELECT extract(column_value, '/ns2:kontiranje', 'xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"') kontiranje,
              extract(column_value, '/ns2:kontiranje/ns2:greske', 'xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"') greske
         FROM TABLE(XMLSequence(extract(odg_c.kon, 'ns2:kontiranja/ns2:kontiranje', 'xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"')
                                )
                    ))
    LOOP
      IF kont_greske_c.greske IS NOT NULL THEN
        INSERT INTO lpka_prifin_odg (pkaprifin_id, pkaracfin_id, odgovor)
          SELECT pkaprifin_id_p, id, kont_greske_c.kontiranje.getclobval()
            FROM lpka_rac_fin
           WHERE guid = odg_c.guid;
      END IF;
    END LOOP;

  END LOOP;
END;
PROCEDURE LC_IZVRSI_PRIJEPIS
 (DAT_POC_P IN DATE
 ,DAT_ZAV_P IN DATE
 ,OZN_BI_P IN NUMBER
 ,OZN_GI_P IN NUMBER
 ,OZN_POS_P IN NUMBER
 ,OZN_PRED_P IN NUMBER
 ,OZN_OBR_P IN NUMBER
 ,OZN_KONT_P IN NUMBER
 )
 IS
--
  CURSOR parpri_c (sifra_k IN s_parametri_prijepisa.sifra%TYPE) IS
    SELECT id
      FROM spka_parametri_prijepisa
     WHERE sifra = sifra_k;

  pkaparpri_id_l  spka_parametri_prijepisa.id%TYPE;
  pkaprifin_id_l  lpka_prijepisi_fin.id%TYPE;
  pkaparfin_rbr_l lpka_prijepisi_fin.rbr%TYPE;
  datum_l         DATE;
  god_poslovna_l  VARCHAR2(4) := pra_zmp_zaj.zmppar_vrijednost('PKA', '1005');
  napomena_l      VARCHAR2 (100);
BEGIN

  IF pra_zmp_s.oznaka ('P0015') = 0 THEN
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  -- Ne moe se izvriti prijepis za datum manji od poetnog datuma rada na aplikaciji (ZMP parametar 0036).
  pra_zmp_s.provjeri_dat_pocetni_0036 (dat_poc_p);

  OPEN parpri_c ('RACUNI');
  FETCH parpri_c INTO pkaparpri_id_l;
  CLOSE parpri_c;

  IF ozn_bi_p = -1 THEN napomena_l := napomena_l || ' ' || 'RECBI'; END IF;
  IF ozn_gi_p = -1 THEN napomena_l := napomena_l || ' ' || 'RECGI'; END IF;
  IF ozn_pos_p = -1 THEN napomena_l := napomena_l || ' ' || 'POS'; END IF;
  IF ozn_pred_p = -1 THEN napomena_l := napomena_l || ' ' || 'PKAPRED'; END IF;
  IF ozn_obr_p = -1 THEN napomena_l := napomena_l || ' ' || 'PKAOBR'; END IF;
  IF ozn_kont_p = -1 THEN napomena_l := napomena_l || ' ' || 'KONT'; END IF;

  INSERT INTO lpka_prijepisi_fin (pkaparpri_id, god_poslovna, dat_poc, dat_zav, napomena)
    VALUES (pkaparpri_id_l, god_poslovna_l, dat_poc_p, dat_zav_p, napomena_l)
    RETURNING id, rbr INTO pkaprifin_id_l, pkaparfin_rbr_l;

  log_filename_m := LOWER (zmp_zaj.current_schema()) || '_' || god_poslovna_l || '_' || pkaparfin_rbr_l || '.log';

  /*
  datum_l := dat_poc_p;

  WHILE datum_l <= dat_zav_p LOOP

    lc_pripremi_prijepis (datum_l, ozn_bi_p, ozn_gi_p, ozn_pos_p, ozn_pred_p, 0, 0, pkaprifin_id_l);
    lc_salji_scdok (pkaprifin_id_l, datum_l, ozn_bi_p, ozn_gi_p, ozn_pos_p, ozn_pred_p);

    IF ozn_kont_p = -1 THEN
      lc_pripremi_prijepis (datum_l, 0, 0, 0, 0, 0, ozn_kont_p, pkaprifin_id_l);
      lc_salji_knjdok (pkaprifin_id_l, datum_l);
    END IF;

    datum_l := datum_l + 1;

  END LOOP;
  */
  -- najprije se za svaki datum napravi priprema
  -- commit slanja ide za svaki datum da se ne desi uspjean upis u LC za prethodni datum
  -- a nikakav upis u MISH zbog greke na sljedeem datumu
  IF ozn_bi_p = -1 OR ozn_gi_p = -1 OR ozn_pos_p = -1 OR ozn_pred_p = -1 OR ozn_obr_p = -1 THEN
    datum_l := dat_poc_p;
    WHILE datum_l <= dat_zav_p LOOP
      lc_pripremi_prijepis (datum_l, ozn_bi_p, ozn_gi_p, ozn_pos_p, ozn_pred_p, ozn_obr_p, 0, 0, pkaprifin_id_l);
      datum_l := datum_l + 1;
    END LOOP;
  END IF;
  COMMIT;

  IF ozn_bi_p = -1 OR ozn_gi_p = -1 OR ozn_pos_p = -1 OR ozn_pred_p = -1 OR ozn_obr_p = -1 THEN
    datum_l := dat_poc_p;
    WHILE datum_l <= dat_zav_p LOOP
      lc_salji_scdok (pkaprifin_id_l, datum_l, ozn_bi_p, ozn_gi_p, ozn_pos_p, ozn_pred_p, ozn_obr_p);
      COMMIT;
      datum_l := datum_l + 1;
    END LOOP;
  END IF;

  IF ozn_kont_p = -1 THEN
    datum_l := dat_poc_p;
    WHILE datum_l <= dat_zav_p LOOP
      lc_pripremi_prijepis (datum_l, 0, 0, 0, 0, 0, 0, ozn_kont_p, pkaprifin_id_l);
      lc_salji_knjdok (pkaprifin_id_l, datum_l);
      COMMIT;
      datum_l := datum_l + 1;
    END LOOP;
  END IF;

  COMMIT;

END;
PROCEDURE LC_IZVRSI_PRIJEPIS_GAS
 (DAT_POC_P IN DATE
 ,DAT_ZAV_P IN DATE
 )
 IS
--
  CURSOR parpri_c (sifra_k IN s_parametri_prijepisa.sifra%TYPE) IS
    SELECT id
      FROM spka_parametri_prijepisa
     WHERE sifra = sifra_k;

  pkaparpri_id_l  spka_parametri_prijepisa.id%TYPE;
  pkaprifin_id_l  lpka_prijepisi_fin.id%TYPE;
  pkaparfin_rbr_l lpka_prijepisi_fin.rbr%TYPE;
  datum_l         DATE;
  god_poslovna_l  VARCHAR2(4) := TO_CHAR (dat_zav_p, 'YYYY');
BEGIN
  IF pra_zmp_s.oznaka ('P0015') = 0 THEN
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  IF dat_poc_p > dat_zav_p THEN
    RETURN;
  END IF;

  -- Ne moe se izvriti prijepis za datum manji od poetnog datuma rada na aplikaciji (ZMP parametar 0036).
  pra_zmp_s.provjeri_dat_pocetni_0036 (dat_poc_p);

  OPEN parpri_c ('GASTEM');
  FETCH parpri_c INTO pkaparpri_id_l;
  CLOSE parpri_c;

  INSERT INTO lpka_prijepisi_fin (pkaparpri_id, god_poslovna, dat_poc, dat_zav)
    VALUES (pkaparpri_id_l, god_poslovna_l, dat_poc_p, dat_zav_p)
    RETURNING id, rbr INTO pkaprifin_id_l, pkaparfin_rbr_l;

  log_filename_m := LOWER (zmp_zaj.current_schema()) || '_' || god_poslovna_l || '_' || pkaparfin_rbr_l || '.log';

  lc_pripremi_prijepis (dat_zav_p, 0, 0, 0, 0, 0, -1, 0, pkaprifin_id_l);
  lc_salji_gastem (pkaprifin_id_l, dat_zav_p);

  COMMIT;

END;
PROCEDURE LC_SALJI_GASTEM
 (PKAPRIFIN_ID_P IN LPKA_PRIJEPISI_FIN.ID%TYPE
 ,DATUM_P IN DATE
 )
 IS
/*
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:v0="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1">
   <soapenv:Header/>
   <soapenv:Body>
      <v0:spremiTemeljniceGKRequest>
         <v0:VsID>?</v0:VsID>
         <v0:Godina>?</v0:Godina>
         <v0:temeljnice>
            <!--1 or more repetitions:-->
            <v0:temeljnica>
               <v0:TemVsID>?</v0:TemVsID>
               <v0:VteSifra>?</v0:VteSifra>
               <v0:TemDatum>?</v0:TemDatum>
               <v0:TemOpis>?</v0:TemOpis>
               <v0:stavke>
                  <!--1 or more repetitions:-->
                  <v0:stavka>
                     <v0:Rb>?</v0:Rb>
                     <!--Optional:-->
                     <v0:PozSifra>?</v0:PozSifra>
                     <v0:KonKonto>?</v0:KonKonto>
                     <!--Optional:-->
                     <v0:MtSifra>?</v0:MtSifra>
                     <v0:Duguje>?</v0:Duguje>
                     <v0:Potrazuje>?</v0:Potrazuje>
                     <!--Optional:-->
                     <v0:Opis>?</v0:Opis>
                  </v0:stavka>
               </v0:stavke>
            </v0:temeljnica>
         </v0:temeljnica>
      </v0:spremiTemeljniceGKRequest>
   </soapenv:Body>
</soapenv:Envelope>
*/

  upit_l       XMLTYPE;
  rbr_l        NUMBER:= 0;
  temeljnica_l szmp_parametri.vrijednost%TYPE;
  temvsid_l    lpka_rac_fin.id%TYPE;
  val_dom_sifra_l s_valute.sifra_3a%TYPE := pra_zmp_zaj.vrijednost_parametra ('0001');
BEGIN
  data_m    := NULL;
  odgovor_m := NULL;

  temeljnica_l := pra_zmp_zaj.zmppar_vrijednost ('PKA', '1081');

  DELETE igas_knjizenje WHERE oznaka = 'T' AND NVL (duguje, 0) = 0 AND NVL (potrazuje, 0) = 0;

  /* saldiranje temeljnice */
  INSERT INTO igas_knjizenje (dat_poc, dat_zav, oj_sifra, gasoknj_sifra, oj_vlasnik, gasoknj_naziv, konto, duguje, potrazuje, oznaka, oznaka_knji)
    SELECT MIN (dat_poc), datum_p, oj_vlasnik, '0000', oj_vlasnik, 'saldiranje',  konto.sifra, SUM (potrazuje - duguje), 0, 'T', 'N'
      FROM igas_knjizenje,
          (SELECT pra_zmp_zaj.zmppar_vrijednost ('LIBUSOFT', '1007') sifra FROM dual) konto
     WHERE dat_zav = datum_p
       AND oznaka = 'T' -- samo trokovna strana
    HAVING SUM (NVL (potrazuje, 0) - NVL (duguje, 0)) <> 0
     GROUP BY datum_p, oj_vlasnik, '0000', oj_vlasnik, 'saldiranje', konto.sifra, 'T', 'N';


  FOR tem_tro_c IN (
    SELECT rowid
      FROM igas_knjizenje
     WHERE oznaka = 'T'
     ORDER BY oj_sifra, gasoknj_sifra
       FOR UPDATE OF dokapl_id NOWAIT)
  LOOP
    rbr_l := rbr_l + 1;
    UPDATE igas_knjizenje
       SET dokapl_id = rbr_l
     WHERE rowid = tem_tro_c.rowid;
  END LOOP;


  FOR gas_temc1 IN (
     SELECT datum, id
       FROM lpka_rac_fin
      WHERE datum = datum_p
        AND findok_broj IS NULL
        AND ozn_vracuna = 'GASTEM'
      )
  LOOP
    SELECT xmlelement ("v0:temeljnice",
             xmlattributes ('http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1' "xmlns:v0"),
             xmlconcat (
               extract (upit_l, 'v0:temeljnice/v0:temeljnice',
                                'xmlns:v0="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"'),
               xmlelement ("v0:temeljnica",
                 xmlelement ("v0:TemVsID", gas_temc1.id),
                 xmlelement ("v0:VteSifra", temeljnica_l),
                 xmlelement ("v0:TemDatum", TO_CHAR (TRUNC (gas_temc1.datum), 'rrrr-mm-dd')),
                 xmlelement ("v0:TemOpis", 'Temeljnica trokova'),
               xmlelement ("v0:stavke",
                 xmlagg (
                   xmlelement ("v0:stavka",
                     xmlelement ("v0:Rb", igasknji.dokapl_id),
                       DECODE (zmpkonpoz.pozicija, NULL, NULL, xmlelement ("v0:PozSifra", zmpkonpoz.pozicija)),
                       xmlelement ("v0:KonKonto", igasknji.konto),
                       xmlelement ("v0:MtSifra", igasknji.oj_sifra),
                       xmlelement ("v0:Duguje", TRIM (TO_CHAR (igasknji.duguje, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       xmlelement ("v0:Potrazuje", TRIM (TO_CHAR (igasknji.potrazuje, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       xmlelement ("v0:Valuta", val_dom_sifra_l),
                       xmlelement ("v0:Opis", igasknji.gasoknj_naziv)
                     )
                   )
                 )
               )
             )
           )
      INTO upit_l
      FROM igas_knjizenje igasknji,
           mzmp_konta zmpkon,
           mzmp_kon_poz zmpkonpoz
     WHERE igasknji.dat_zav = gas_temc1.datum
       AND igasknji.oznaka = 'T'
       AND igasknji.konto = zmpkon.sifra
       AND zmpkon.id = zmpkonpoz.zmpkon_id (+)
       AND TO_CHAR (TRUNC (gas_temc1.datum), 'rrrr') = NVL (zmpkonpoz.god_poslovna, TO_CHAR (TRUNC (gas_temc1.datum), 'rrrr'))
     ORDER BY dokapl_id; -- rbr;
    temvsid_l :=  gas_temc1.id;
  END LOOP;

  IF upit_l IS NOT NULL THEN

    SELECT xmlelement ("soapenv:Envelope",
             xmlattributes ('http://schemas.xmlsoap.org/soap/envelope/' "xmlns:soapenv",
                           'http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1' "xmlns:v0"),
             xmlelement ("soapenv:Header", NULL),
             xmlelement ("soapenv:Body",
               xmlelement ("v0:spremiTemeljniceGKReq",
                 xmlelement ("v0:VsID",'ISTRATECH_SC'),
                 -- xmlelement ("v0:Godina", TO_CHAR (TRUNC (SYSDATE), 'rrrr')), -- MK IRN 2915
                 xmlelement ("v0:Godina", TO_CHAR (TRUNC (datum_p), 'rrrr')),
                 upit_l
               )
             )
           )
      INTO upit_l
      FROM DUAL;
  END IF;


  IF upit_l IS NOT NULL THEN

    data_m := upit_l.getClobVal();

    SELECT REPLACE (data_m, 'spremiTemeljniceGKReq', 'spremiTemeljniceGKRequest')
      INTO data_m
      FROM dual;

    lc_zaj_post;

    lc_obradi_odg_gastem (pkaprifin_id_p, temvsid_l);

  END IF;

END;
PROCEDURE LC_OBRADI_ODG_GASTEM
 (PKAPRIFIN_ID_P IN LPKA_PRIJEPISI_FIN.ID%TYPE
 ,TEMVS_ID_P IN LPKA_RAC_FIN.ID%TYPE
 )
 IS
/*
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:v0="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1">
   <soapenv:Header/>
   <soapenv:Body>
      <v0:spremiTemeljniceGKResponse>
         <v0:VsID>?</v0:VsID>
         <v0:Godina>?</v0:Godina>
         <v0:temeljnice>
            <!--1 or more repetitions:-->
            <v0:temeljnica>
               <v0:TemVsID>?</v0:TemVsID>
               <v0:TemGUID>?</v0:TemGUID>
               <v0:greska>
                  <v0:Greska>?</v0:Greska>
                  <v0:OpisGreske>?</v0:OpisGreske>
                </v0:greska>
            </v0:temeljnica>
         </v0:temeljnice>
      </v0:spremiTemeljniceGKResponse>
   </soapenv:Body>
</soapenv:Envelope>
*/

/*
XML odgovora
<soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
   <soap:Body>
      <ns3:spremiTemeljniceGKResponse
         xmlns:ns5="http://www.spi.hr/ws/razmjena/sc/v0.1"
         xmlns:ns4="urn:iso:std:iso:20022:tech:xsd:camt.053.001.02"
         xmlns:ns3="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"
         xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1">
         <ns3:VsID>ISTRATECH_SC</ns3:VsID>
         <ns3:Godina>2018</ns3:Godina>
         <ns3:temeljnice>
            <ns3:temeljnica>
               <ns3:TemVsID>184541034</ns3:TemVsID>
               <ns3:TemGUID>8EF16826-3E85-E811-80EA-00155D007581</ns3:TemGUID>
               <ns3:stavke/>
            </ns3:temeljnica>
         </ns3:temeljnice>
      </ns3:spremiTemeljniceGKResponse>
*/
  faultstring_l lpka_prifin_odg.odgovor%TYPE;
  greska_l      XMLTYPE;
  temeljnice_l  XMLTYPE;
  opis_greske_l lpka_prifin_odg.odgovor%TYPE;
  temVsID_l     lpka_rac_fin.id%TYPE;
  guid_l        lpka_rac_fin.guid%TYPE;
BEGIN
  -- tehnika greka kod XML
  -- dbms_output.put_line (odgovor_m);

  BEGIN
    SELECT extractValue (XMLType (odgovor_m),
             '/soapenv:Envelope/soapenv:Body/soapenv:Fault/faultstring',
             'xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"')
      INTO faultstring_l
      FROM DUAL;

  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      NULL;
  END;

  IF faultstring_l IS NOT NULL THEN
    INSERT INTO lpka_prifin_odg (pkaprifin_id, pkaracfin_id, odgovor)
      VALUES (pkaprifin_id_p, temvs_id_p, faultstring_l);
   RETURN;

  END IF;

  -- kraj tehnika greka XML

  -- greka na nivou zahtjeva
  -- dbms_output.put_line (greska_l.getclobVal());
  SELECT extract (XMLType (odgovor_m),
           '/soapenv:Envelope/soapenv:Body/ns3:spremiTemeljniceGKResponse/ns3:temeljnice/ns3:temeljnica/ns3:greske/ns3:greska',
           'xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"
            xmlns:ns5="http://www.spi.hr/ws/razmjena/sc/v0.1"
            xmlns:ns4="urn:iso:std:iso:20022:tech:xsd:camt.053.001.02"
            xmlns:ns3="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"
            xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1"') greska,
         extract (XMLType (odgovor_m),
           '/soapenv:Envelope/soapenv:Body/ns3:spremiTemeljniceGKResponse/ns3:temeljnice/ns3:temeljnica',
           'xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"
            xmlns:ns5="http://www.spi.hr/ws/razmjena/sc/v0.1"
            xmlns:ns4="urn:iso:std:iso:20022:tech:xsd:camt.053.001.02"
            xmlns:ns3="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"
            xmlns:ns2="http://www.spi.hr/ws/razmjena/sc/razmjenasc/v0.1"') temeljnice
    INTO greska_l,
         temeljnice_l
    FROM dual;

  IF greska_l IS NOT NULL THEN

    INSERT INTO lpka_prifin_odg (pkaprifin_id, pkaracfin_id,  odgovor)
      SELECT pkaprifin_id_p, temvs_id_p,  ExtractValue (column_value, '/ns3:OpisGreske', 'xmlns:ns3="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"')
        FROM TABLE (XMLSequence (extract (greska_l, '/ns3:greska/ns3:OpisGreske', 'xmlns:ns3="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"')));

    RETURN;
  END IF;
  -- kraj greka na nivou zahtjeva

  FOR greske_c IN (
    SELECT ExtractValue (column_value, '/ns3:Greska', 'xmlns:ns3="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"') greska,
           ExtractValue (column_value, '/ns3:OpisGreske', 'xmlns:ns3="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"') opisGreske
      FROM TABLE (XMLSequence (extract (greska_l, 'greske/greska')))
    )
  LOOP
    IF opis_greske_l IS NULL THEN
      opis_greske_l := greske_c.greska || ': ' || greske_c.opisGreske || ';';
    ELSE
      opis_greske_l := opis_greske_l || chr(10) || greske_c.greska || ': ' || greske_c.opisGreske || ';';
    END IF;
  END LOOP;

  IF opis_greske_l IS NOT NULL THEN
    INSERT INTO lpka_prifin_odg (pkaprifin_id, pkaracfin_id, odgovor)
      VALUES (pkaprifin_id_p, temvs_id_p,  opis_greske_l );
    RETURN;

  END IF;

  -- dbms_output.put_line (temeljnice_l.getclobval());

  IF opis_greske_l IS NULL THEN

     SELECT ExtractValue (column_value,'/ns3:temeljnica/ns3:TemGUID', 'xmlns:ns3="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"')
       INTO guid_l
       FROM TABLE (XMLSequence (extract (temeljnice_l, '/ns3:temeljnica', 'xmlns:ns3="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"')));
     -- dbms_output.put_line (guid_l);

     UPDATE lpka_rac_fin
        SET findok_broj = guid_l
      WHERE id = temvs_id_p
        AND ozn_vracuna = 'GASTEM';
  END IF;


END;
PROCEDURE LC_PRIPREMI_PRIJEPIS
 (DATUM_P IN DATE
 ,OZN_BI_P IN NUMBER
 ,OZN_GI_P IN NUMBER
 ,OZN_POS_P IN NUMBER
 ,OZN_PRED_P IN NUMBER
 ,OZN_OBR_P IN NUMBER
 ,OZN_GASTEM_P IN NUMBER
 ,OZN_KONT_P IN NUMBER
 ,PKAPRIFIN_ID_P IN LPKA_PRIJEPISI_FIN.ID%TYPE
 )
 IS
--
  pripremljen_l  NUMBER;
  brojac_l       NUMBER;
BEGIN     
    
  -- REC BI rauni
  IF ozn_bi_p = -1 THEN
    FOR rac_bi_c IN (
      SELECT rac.guid guid
        FROM t_racuni rac,
             s_vapldok vapldok,
             s_vdokumenata vdok
       WHERE rac.datum = datum_p
         AND rac.vdok_id = vdok.id
         AND vdok.ozn_fin = -1
         AND rac.vapldok_id = vapldok.id
         AND vapldok.oznaka IN ('BI', 'BV')
         AND vapldok.metapl_sifra = 'REC') 
    LOOP
      SELECT COUNT(*)
        INTO pripremljen_l
        FROM lpka_rac_fin
       WHERE guid = rac_bi_c.guid;
       
      IF pripremljen_l = 0 THEN
        INSERT INTO lpka_rac_fin (ozn_uk, datum, ozn_vracuna, guid)
          VALUES (rac_bi_c.guid, datum_p, 'RECBI', rac_bi_c.guid);
      END IF;
    END LOOP;
  END IF;
  -- kraj REC BI rauni
  
    
  -- REC GI rauni
  IF ozn_gi_p = -1 THEN
    FOR rac_gi_c IN (
      SELECT DISTINCT rac.oj_sifra oj_sifra, 
           (CASE WHEN  rac.iznos * rac.izn_tecaja + pra_rec_s.izn_predujma (rac.id) >= 0 THEN 'RECGI'  -- pozitivni
                                             ELSE 'RECGIN'  -- negativni --> storno
             END) ozn_vracuna
        FROM t_racuni rac,
             s_vapldok vapldok,
             s_vdokumenata vdok
       WHERE rac.datum = datum_p
         AND rac.vdok_id = vdok.id
         AND vdok.ozn_fin = -1
         AND rac.vapldok_id = vapldok.id
         AND vapldok.oznaka IN ('GI')
         AND vapldok.metapl_sifra = 'REC'
         )
    LOOP

      SELECT COUNT(*)
        INTO pripremljen_l
        FROM lpka_rac_fin
       WHERE datum = datum_p
         AND ozn_vracuna = rac_gi_c.ozn_vracuna  -- 'RECGI' ili  'RECGIN' 
         AND ozn_uk = rac_gi_c.oj_sifra;

      IF pripremljen_l = 0 THEN
        INSERT INTO lpka_rac_fin (ozn_uk, datum, ozn_vracuna, guid)
          VALUES (rac_gi_c.oj_sifra, datum_p, rac_gi_c.ozn_vracuna, pra_zmp_zaj.formatted_guid(NULL));
      END IF;
    END LOOP;
  END IF;
  -- kraj REC GI rauni
  
  -- rauni sa kasa
  IF ozn_pos_p = -1 THEN   
    
     SELECT COUNT(*) 
       INTO brojac_l
       FROM t_rnkase rn
      WHERE datum  = datum_p
        AND kase_id NOT IN (SELECT gmpkas_id
                              FROM mzmp_gmpkas_sus 
                             WHERE zmpsus_id IN (SELECT id 
                                                   FROM szmp_sustavi 
                                                  WHERE sifra = 'LIBUSOFT'));
  
     IF brojac_l > 0 THEN
        raise_application_error(-20000, 'Postoje nepovezane kase za sustav LIBUSOFT');
     END IF;
  
     FOR rac_gas_c IN (
       SELECT DISTINCT(gmpkassus.sifra) ozn_uk,
              DECODE(SIGN(suma.iznos),-1,'POSN','POS') ozn_vracuna
         FROM /*t_rnkase rn,
              t_rnkase_pro rnpro,*/
              v_rnkase_pro_vpla rnpro,
              s_vplacanja vpla,
              mzmp_gmpkas_sus gmpkassus,
              szmp_sustavi sus,
              (SELECT rn_id, SUM(iznos) iznos FROM t_rnkase_pro GROUP BY rn_id) suma
        WHERE rnpro.datum = datum_p
          /*AND rn.id = rnpro.rn_id*/
          AND rnpro.vpla_id = vpla.id
          AND rnpro.id = suma.rn_id
          AND vpla.ozn_irn IS NULL   -- svi rauni koji nisu na REC ili PKA raunu
          AND vpla.ozn_rnk_r <> -1
          AND gmpkassus.zmpsus_id = sus.id
          AND gmpkassus.gmpkas_id = rnpro.kase_id
          AND sus.sifra = 'LIBUSOFT'
        GROUP BY gmpkassus.sifra,  DECODE(SIGN(suma.iznos),-1,'POSN','POS'))
    LOOP
        
      SELECT COUNT(*)
        INTO pripremljen_l
        FROM lpka_rac_fin
       WHERE datum = datum_p
         AND ozn_vracuna = rac_gas_c.ozn_vracuna -- POS, POSN
         AND ozn_uk = rac_gas_c.ozn_uk;    
       
      IF pripremljen_l = 0 THEN 
        INSERT INTO lpka_rac_fin (ozn_uk, datum, ozn_vracuna, guid)
          VALUES (rac_gas_c.ozn_uk, datum_p, rac_gas_c.ozn_vracuna, pra_zmp_zaj.formatted_guid(NULL));
      END IF; 
    END LOOP;
  END IF;
  -- kraj rauni sa kasa
  
  -- GASTRO temeljnica
  IF ozn_gastem_p = -1 THEN   
             
    FOR rac_gas_c IN (
      SELECT DISTINCT(oj_vlasnik) ozn_uk 
        FROM igas_knjizenje
       WHERE dat_zav = datum_p 
       GROUP BY oj_vlasnik)
    LOOP  
        
      SELECT COUNT(*)
        INTO pripremljen_l
        FROM lpka_rac_fin
       WHERE datum = datum_p
         AND ozn_vracuna = 'GASTEM'
         AND ozn_uk = rac_gas_c.ozn_uk;    
       
      IF pripremljen_l = 0 THEN 
        INSERT INTO lpka_rac_fin (ozn_uk, datum, ozn_vracuna, guid)
          VALUES (rac_gas_c.ozn_uk, datum_p, 'GASTEM', NULL);
      END IF; 
    END LOOP;
  END IF;
  -- kraj GASTRO temeljnica     
  
  -- kontiranje     
  IF ozn_kont_p = -1 THEN
    FOR kon_c IN (
      SELECT id, datum, ozn_uk, ozn_vracuna, guid
        FROM lpka_rac_fin
       WHERE datum = datum_p
         AND pkaprifinsc_id IS NOT NULL
         AND findok_broj IS NOT NULL
         AND pkaprifink_id IS NULL)
    LOOP                          
      IF kon_c.ozn_vracuna IN ('RECGI', 'RECGIN', 'RECBI') THEN
         lc_knj_recrac (kon_c.ozn_uk, kon_c.datum, kon_c.ozn_vracuna, kon_c.guid, pkaprifin_id_p, kon_c.id);
      END IF;
      IF kon_c.ozn_vracuna IN ('POS', 'POSN') THEN
         lc_knj_pos (kon_c.guid);
      END IF;
    END LOOP;
  END IF;
  -- kraj kontiranje      
  
    -- predujmovi (primljeni i iskoriteni)
  IF ozn_pred_p = -1 THEN
    FOR predujmovi_c IN (
      SELECT pkarac.guid guid
        FROM tpka_racuni pkarac,
             s_vapldok vapldok,
             s_vdokumenata vdok
       WHERE pkarac.datum = datum_p
         AND pkarac.vdok_id = vdok.id
         AND vdok.ozn_fin = -1
         AND pkarac.vapldok_id = vapldok.id
         AND vapldok.oznaka IN ('BP', 'GP')
         AND vapldok.metapl_sifra = 'PKA') 
    LOOP
      SELECT COUNT(*)
        INTO pripremljen_l
        FROM lpka_rac_fin
       WHERE guid = predujmovi_c.guid;
       
      IF pripremljen_l = 0 THEN
        INSERT INTO lpka_rac_fin (ozn_uk, datum, ozn_vracuna, guid)
          VALUES (predujmovi_c.guid, datum_p, 'PKAPRED', predujmovi_c.guid);
      END IF;
    END LOOP;
  END IF;
  -- kraj PKA PRED rauni

 -- Obrauni
  IF ozn_obr_p = -1 THEN
    FOR obracuni_c IN (
      SELECT pkaobr.guid guid
        FROM tpka_obracuni pkaobr,
             (SELECT vdok_id FROM s_vapldok WHERE metapl_sifra = 'PKA' AND oznaka = 'OB') vapldok,
             s_vdokumenata vdok
       WHERE pkaobr.datum = datum_p
         AND vapldok.vdok_id = vdok.id
         AND vdok.ozn_fin = -1)
    LOOP
      SELECT COUNT(*)
        INTO pripremljen_l
        FROM lpka_rac_fin
       WHERE guid = obracuni_c.guid;

      IF pripremljen_l = 0 THEN
        INSERT INTO lpka_rac_fin (ozn_uk, datum, ozn_vracuna, guid)
          VALUES (obracuni_c.guid, datum_p, 'PKAOBR', obracuni_c.guid);
      END IF;
    END LOOP;
  END IF;
  -- kraj PKAOBR  
END;
PROCEDURE LC_KNJ_RECRAC
 (OZN_UK_P IN LPKA_RAC_FIN.OZN_UK%TYPE
 ,DATUM_P IN LPKA_RAC_FIN.DATUM%TYPE
 ,OZN_VRACUNA_P IN LPKA_RAC_FIN.OZN_VRACUNA%TYPE
 ,GUID_P IN LPKA_RAC_FIN.GUID%TYPE
 ,PKAPRIFIN_ID_P IN LPKA_PRIJEPISI_FIN.ID%TYPE
 ,PKARACFIN_ID_P IN LPKA_RAC_FIN.ID%TYPE
 )
 IS
-- Knjienje REC rauna u LC; 
-- pkarnk naeni u gas se knjie preko pravila u GAS, 
-- pkarnk koji nisu pronaeni u gas se knjie na neka dogovorena konta na 'punkt'
 
/* prec_global2 - priprema temeljnice
-- mish oznaka 
ozn_izvora - opis1 (USL, RNKPKA, RNKGAS)
-- LC
VsID 
Godina 
--
DokGUID - opis2
--
Rb - opis3
Datum - datum1 
PozSifra - opis4
KonKonto - opis5
MtSifra - opis6
Duguje - iznos1
Potrazuje - iznos2
Opis - opis7
--
*/

/* prec_global - popis rnk
-- potrebni podaci
guid - opis1
god_poslovna - opis2
gmpkas_id - id1
rbr -opis3
-- dodatni podaci, izbacit ako se ne budu koristili
ozn_unosa - opis4
izn_placanja - iznos1  
faktor - iznos2 (1 ili -1, to je faktor sa kojim se mnoe iznosi u GAS sukladno vezi pkarnk na V ili P (=1) raun odnosno N raun (=-1)
dat_pkarnk - datum1 
ozn_ima_u_gas - id2 (-1 default = ima u gas, 0 - ako nije naen u GAS i knjiit e se na privremeni konto)
*/

  gas_cvor_l smet_cvorovi.sifra%TYPE := pra_pos_gas.vrati_gas_cvor; -- lokalni ili centralni GAS
    -- ako je gas lokalni ali se moe knjiiti sa drugih OJ bi te raune trebali traiti na tim drugim shemama (ili centru) preko ojr kase
    -- budui imaju brijuni centralni gas za sada idemo na centar
  naredba_l VARCHAR2 (4000); 
  rnk_nema_u_gas_l VARCHAR2 (2000);
  rbr_stavke_l INTEGER;
BEGIN
  IF ozn_uk_p IS NULL OR datum_p IS NULL 
    OR NVL (ozn_vracuna_p, 'X') NOT IN ('RECBI', 'RECGI', 'RECGIN') 
    OR guid_p IS NULL 
  THEN
    RETURN;
  END IF;
  
  DELETE FROM prec_global WHERE opis1 = guid_p;  
  DELETE FROM prec_global2 WHERE opis2 = guid_p;
  IF gas_cvor_l IS NOT NULL THEN
    naredba_l := 'DELETE FROM prec_global' || gas_cvor_l || ' WHERE opis1 = :guid_p';
    EXECUTE IMMEDIATE naredba_l USING guid_p;
    naredba_l := 'DELETE FROM prec_global2' || gas_cvor_l || ' WHERE opis2 = :guid_p';
    EXECUTE IMMEDIATE naredba_l USING guid_p;
  END IF;

  -- pripremiti USL podatke (REC usluge) za pripremljeni dokument u lpka_rac_fin
  pra_pka_fin.lc_knj_recrac_usl (ozn_uk_p, datum_p, ozn_vracuna_p, guid_p);
  
  -- priprema popisa RNK u prec_global
  FOR puni_recglo_c IN
     (SELECT pkarnk.god_poslovna, pkarnk.gmpkas_id, pkarnk.rbr, pkarnk.ozn_unosa, 
             pkarnk.izn_placanja * rac.faktor izn_placanja, 
             rac.faktor, pkarnk.datum dat_pkarnk
        FROM tpka_rnkasa pkarnk, 
                 (SELECT rac.id, DECODE (rac.oznaka, 'N', -1, 1) faktor 
                    FROM t_racuni rac, s_vapldok vapldok
                   WHERE rac.vapldok_id = vapldok.id
                     AND ((ozn_vracuna_p = 'RECBI' AND rac.guid = guid_p)
                           OR (ozn_vracuna_p = 'RECGI' AND vapldok.oznaka = 'GI' AND rac.oj_sifra = ozn_uk_p AND rac.datum = datum_p AND ROUND (rac.iznos * rac.izn_tecaja, 2) + pra_rec_s.izn_predujma (rac.id)>=0)
                           OR (ozn_vracuna_p = 'RECGIN' AND vapldok.oznaka = 'GI' AND rac.oj_sifra = ozn_uk_p AND rac.datum = datum_p AND ROUND (rac.iznos * rac.izn_tecaja, 2) + pra_rec_s.izn_predujma (rac.id)<0)
                         )
                  ) rac  
      WHERE pkarnk.rac_id = rac.id
     )
  LOOP
    naredba_l := 'INSERT INTO prec_global' || gas_cvor_l ||
     '      (opis1,' ||
     '        opis2,' ||
     '        id1,' ||
     '        opis3,' ||
     '        opis4,' ||
     '        iznos1,' ||
     '        iznos2,' ||
     '        datum1,' ||
     '        id2)' ||
     '    VALUES (:guid_p,' ||
     '        :god_poslovna,' ||
     '        :gmpkas_id,' ||
     '        :rbr,' ||
     '        :ozn_unosa,' ||
     '        :izn_placanja,' ||
     '        :faktor,' ||
     '        :dat_pkarnk,' ||
     '        -1)';  -- ozn_ima_u_gas
    EXECUTE IMMEDIATE naredba_l USING 
             guid_p,
             puni_recglo_c.god_poslovna,
             puni_recglo_c.gmpkas_id,
             puni_recglo_c.rbr,
             puni_recglo_c.ozn_unosa,
             puni_recglo_c.izn_placanja,
             puni_recglo_c.faktor,
             puni_recglo_c.dat_pkarnk;             
  END LOOP;
  -- provjeriti da su svi rnk upisani u gas, oni koji nisu e dobiti id2 = 0 i GAS e knjiiti samo te
  naredba_l := 'BEGIN pra_pka_fin.lc_knj_recrac_provjeri_rnk' || gas_cvor_l || '(:guid_p, :rnk_nema_u_gas_l); END;';
  EXECUTE IMMEDIATE naredba_l USING guid_p, OUT rnk_nema_u_gas_l;
  IF rnk_nema_u_gas_l IS NOT NULL THEN   
  -- rnk kojih nema u GAS knjiiti na neki poseban konto i upisati popis u ODGOVORE
    -- najprije preuzeti pripremjene podatke u vlastiti prec_global
    IF gas_cvor_l IS NOT NULL THEN
      naredba_l := 'INSERT INTO prec_global ' ||
      '                    SELECT * FROM prec_global' || gas_cvor_l ||
      '                     WHERE opis1 = :guid_p ' ||  
      '                          AND id2 <> -1';               -- ozn_ima_u_gas
      EXECUTE IMMEDIATE naredba_l USING guid_p;
    END IF;
    pra_pka_fin.lc_knj_recrac_rnkpka (datum_p,guid_p);
    -- upisati u ODGOVORE 'RNK koji nisu naeni u GAS: ' || rnk_nema_u_gas_l;  
    INSERT INTO lpka_prifin_odg (pkaprifin_id, pkaracfin_id, odgovor)
      VALUES (pkaprifin_id_p, pkaracfin_id_p, 'RNK koji nisu naeni u GAS (ifra kase i rbr): ' || rnk_nema_u_gas_l);
  END IF;
  -- za rnk koji jesu u GAS (id2 = -1) pripremiti knjienje iz gas u prec_global2
  naredba_l := 'BEGIN pra_pka_fin.lc_knj_recrac_rnkgas' || gas_cvor_l || ' (:guid_p); END;';
  EXECUTE IMMEDIATE naredba_l USING guid_p;  

  -- preuzeti pripremjene podatke u vlastiti prec_global2
  IF gas_cvor_l IS NOT NULL THEN
    naredba_l := 'INSERT INTO prec_global2 ' ||
    '                    SELECT * FROM prec_global2' || gas_cvor_l ||
    '                     WHERE opis1 = ''RNKGAS'' ' ||  -- ozn_izvora
    '                          AND opis2 = :guid_p';
    EXECUTE IMMEDIATE naredba_l USING guid_p;
  END IF;


  -- knjiiti naplatu za pripremljeni dokument u lpka_rac_fin ukljuujui saldiranje temeljnice
  pra_pka_fin.lc_knj_recrac_nap (ozn_uk_p, datum_p, ozn_vracuna_p, guid_p);

  -- sredi recglo2 prije punjenja xml 
  -- brisati ako ima stavaka sa oba iznosa = 0 (jer LC za takve javlja '<ns3:OpisGreske>Dolo je do greke.</ns3:OpisGreske>' )
  DELETE FROM  prec_global2 WHERE opis2 = guid_p AND NVL (iznos1, 0) = 0 AND NVL (iznos2, 0) = 0;
  -- dodati rbr stavke  
  rbr_stavke_l := 0;
  
  pra_pka_fin.lc_knj_recrac_preknjizavanje(guid_p,datum_p,ozn_vracuna_p);
  
  FOR recglo2_c IN
     (SELECT recglo2.rowid rid
        FROM prec_global2 recglo2
      WHERE recglo2.opis2 = guid_p 
      ORDER BY opis1, opis6, opis5
     FOR UPDATE OF recglo2.opis3 NOWAIT
      ) 
  LOOP
      rbr_stavke_l := rbr_stavke_l + 1;
      UPDATE prec_global2 SET opis3 = TO_CHAR (rbr_stavke_l), datum1 = datum_p
       WHERE rowid = recglo2_c.rid;
  END LOOP;        
END;
PROCEDURE LC_KNJ_RECRAC_USL
 (OZN_UK_P IN LPKA_RAC_FIN.OZN_UK%TYPE
 ,DATUM_P IN LPKA_RAC_FIN.DATUM%TYPE
 ,OZN_VRACUNA_P IN LPKA_RAC_FIN.OZN_VRACUNA%TYPE
 ,GUID_P IN LPKA_RAC_FIN.GUID%TYPE
 )
 IS
-- puni prec_globa2 sa knjienjem iz rec
  oj_knjizenja_param_l m_oj.sifra%TYPE; -- ako se eli knjienje pdv i ppot na poduzee se (za sada) ita ZMP param ZMP 0023
  CURSOR oj_param_c IS
    SELECT sifra FROM m_oj WHERE sifra = pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0023');
BEGIN

  /*
  prec_global2
  -- mish oznaka
  ozn_izvora - opis1 (usl, nap, rnkpka, rnkgas)
  -- LC
  VsID
  Godina
  --
  DokGUID - opis2
  --
  Rb - opis3        -- puni se na kraju u lc_knj_recrac
  Datum - datum1    -- puni se na kraju u lc_knj_recrac
  PozSifra - opis4
  KonKonto - opis5
  MtSifra - opis6
  Duguje - iznos1
  Potrazuje - iznos2
  Opis - opis7
  --
  */

  -- knjienje prema pravilima knjienja zur (mrec_pknjizenja_zur); ukljuuje i knjienje za PDV
  INSERT  INTO prec_global2 (
    opis1, opis2, opis3, opis4, opis5, iznos1, iznos2, opis6, opis7)
    SELECT
      'USL' AS opis1,
      guid_p AS opis2,
      NULL AS opis3,
      pozicija AS opis4,
      konto AS opis5,
      izn_duguje AS iznos1,
      izn_potrazuje AS iznos2,
      oj_knjizenja AS opis6,
      br_stavke AS opis7
    FROM (
      SELECT
        zmpkonpoz.pozicija pozicija,
        zmpkon.sifra konto,
        pknjzur.oj_knjizenja,
        pknjzur.br_stavke,
        SUM
          (
          CASE
            WHEN pknjzur.ozn_dp =  'D' THEN       -- duguje
            (
            CASE
              WHEN pknjzur.ozn_iznosa =  1 THEN   -- prihod
                raczurusl.izn_zprihoda_nodb_npdv
              WHEN pknjzur.ozn_iznosa =  2 THEN   -- pdv
                raczurusl.izn_zpdv_nodb
              WHEN pknjzur.ozn_iznosa =  3 THEN   -- odbici
               raczurusl.izn_zodbitka_npdv
            END
            )
          * (
            CASE
              WHEN pknjzur.ozn_zbrajanja = '+' THEN 1
              WHEN pknjzur.ozn_zbrajanja = '-' THEN -1
              ELSE 0
            END
            )
          ELSE NULL
        END
        ) izn_duguje,
        SUM
          (
          CASE
            WHEN pknjzur.ozn_dp =  'P' THEN       -- potrazuje
            (
            CASE
              WHEN pknjzur.ozn_iznosa =  1 THEN   -- prihod
                raczurusl.izn_zprihoda_nodb_npdv
              WHEN pknjzur.ozn_iznosa =  2 THEN   -- pdv
                raczurusl.izn_zpdv_nodb
              WHEN pknjzur.ozn_iznosa =  3 THEN   -- odbici
                raczurusl.izn_zodbitka_npdv
            END
            )
            * (
            CASE
              WHEN  pknjzur.ozn_zbrajanja = '+' THEN 1
              WHEN  pknjzur.ozn_zbrajanja = '-' THEN -1
              ELSE 0
            END)
            ELSE NULL
          END
          ) izn_potrazuje
        FROM (
          SELECT * FROM v_rac_zurusl raczurusl
          WHERE
            (ozn_vracuna_p = 'RECBI' AND raczurusl.rac_guid = guid_p)
            OR (ozn_vracuna_p = 'RECGI' AND raczurusl.vapldok_oznaka = 'GI' AND raczurusl.oj_sifra = ozn_uk_p AND raczurusl.datum = datum_p AND raczurusl.izn_racuna_uk >= 0)
            OR (ozn_vracuna_p = 'RECGIN' AND raczurusl.vapldok_oznaka = 'GI' AND raczurusl.oj_sifra = ozn_uk_p AND raczurusl.datum = datum_p AND raczurusl.izn_racuna_uk < 0)
          ) raczurusl,
          mrec_pknjizenja_zur pknjzur,
          mzmp_konta zmpkon,
          mzmp_kon_poz zmpkonpoz
        WHERE
          raczurusl.so_id = pknjzur.so_id
          AND raczurusl.szur_id = pknjzur.szur_id
          AND zmpkon.id = pknjzur.zmpkon_id
          AND zmpkon.id = zmpkonpoz.zmpkon_id (+)
          AND NVL (zmpkonpoz.god_poslovna, TO_CHAR (datum_p, 'RRRR')) = TO_CHAR (datum_p, 'RRRR')
          -- ako bi trebalo izbaciti knjienje PDV po pravilima u mrec_pknjizenja_zur nejjednostavnije rijesiti sa dodavanjem uvjeta
          -- AND pknjzur.ozn_iznosa IN (1, 3)
        GROUP BY
          zmpkonpoz.pozicija,
          zmpkon.sifra,
          pknjzur.oj_knjizenja,
          pknjzur.br_stavke
        );

  -- knjienje PDV prema pravilima knjienja PDV u s_vpisporukaz
  OPEN oj_param_c;
  FETCH oj_param_c INTO oj_knjizenja_param_l;
  CLOSE oj_param_c;

  INSERT INTO prec_global2 (opis1, opis2, opis3, opis4, opis5, iznos1, iznos2, opis6, opis7)
    SELECT
      'USL' AS opis1,
      guid_p AS opis2,
      NULL AS opis3,
      pozicija AS opis4,
      konto AS opis5,
      izn_duguje AS iznos1,
      izn_potrazuje AS iznos2,
      oj_knjizenja AS opis6,
      NULL AS opis7 -- br_stavke AS opis7
    FROM (
      SELECT
        zmpkonpoz.pozicija pozicija,
        zmpkon.sifra konto,
        NVL (oj_knjizenja_param_l, raczurusl.oj_sifra) oj_knjizenja,
        -- pknjzur.br_stavke,
        0 AS izn_duguje,
        SUM (raczurusl.izn_zpdv_nodb) AS izn_potrazuje -- pdv

      FROM (
        SELECT * FROM v_rac_zurusl raczurusl
        WHERE
          (ozn_vracuna_p = 'RECBI' AND raczurusl.rac_guid = guid_p)
          OR (ozn_vracuna_p = 'RECGI' AND raczurusl.vapldok_oznaka = 'GI' AND raczurusl.oj_sifra = ozn_uk_p AND raczurusl.datum = datum_p AND raczurusl.izn_racuna_uk >= 0)
          OR (ozn_vracuna_p = 'RECGIN' AND raczurusl.vapldok_oznaka = 'GI' AND raczurusl.oj_sifra = ozn_uk_p AND raczurusl.datum = datum_p AND raczurusl.izn_racuna_uk < 0)
        ) raczurusl,
        -- mrec_pknjizenja_zur pknjzur,
        s_vpisporukaz vpispz,
        mzmp_konta zmpkon,
        mzmp_kon_poz zmpkonpoz
      WHERE
        raczurusl.vpispz_id = vpispz.id
        AND zmpkon.id = vpispz.zmpkon_id
        AND zmpkon.id = zmpkonpoz.zmpkon_id (+)
        AND NVL (zmpkonpoz.god_poslovna, TO_CHAR (datum_p, 'RRRR')) = TO_CHAR (datum_p, 'RRRR')
      GROUP BY
        zmpkonpoz.pozicija,
        zmpkon.sifra,
        NVL (oj_knjizenja_param_l, raczurusl.oj_sifra)
      );
END;
PROCEDURE LC_KNJ_RECRAC_PROVJERI_RNK
 (GUID_P IN LPKA_RAC_FIN.GUID%TYPE
 ,RNK_NEMA_U_GAS_P OUT VARCHAR2
 )
 IS
-- provjeri da li rnk zapisani u prec_global postoje u GAS, ako nisu vrati popis i upii nulu u id2
  rnk_nema_u_gas_l VARCHAR2 (2000);
  gmpkas_sifra_l   mgmp_kase.sifra%TYPE;
  previse_rnk_l    BOOLEAN;
  /* MK IRN 2988
  BEGIN
    previse_rnk_l := FALSE;
    FOR recglo_c IN
       (SELECT recglo.rowid rid,recglo.*, rnk.rbr AS rnk_rbr, rnk.datum AS rnk_datum, rnkpro.iznos AS rnk_iznos
          FROM prec_global recglo,  t_rnkase rnk,
                    (SELECT rn_id, SUM (iznos) iznos FROM t_rnkase_pro GROUP BY rn_id) rnkpro
        WHERE nvl(recglo.opis1,'1') = NVL (guid_p, NVL(recglo.opis1,'1')) -- ako guid_p nije poslan provjerava sve zapise
            AND recglo.opis2 = rnk.godina (+) AND recglo.id1 = rnk.kase_id (+) AND recglo.opis3 = rnk.rbr (+)
            AND rnk.id = rnkpro.rn_id (+)
  */
  dat_rnk_min_l DATE;
  dat_rnk_max_l DATE;
BEGIN
  previse_rnk_l := FALSE;
  SELECT MIN (datum1), MAX (datum1) INTO dat_rnk_min_l, dat_rnk_max_l FROM prec_global;
  FOR recglo_c IN (
    SELECT
      recglo.rowid rid,
      recglo.*,
      rnk.rbr AS rnk_rbr,
      rnk.datum AS rnk_datum,
      rnk.izn_placanja + NVL (rnk.izn_placanja2, 0) AS rnk_iznos
    FROM
      prec_global recglo,
      (SELECT * FROM t_rnkase WHERE datum BETWEEN dat_rnk_min_l AND dat_rnk_max_l) rnk
    WHERE
      NVL (recglo.opis1, '1') = NVL (guid_p, NVL (recglo.opis1, '1')) -- ako guid_p nije poslan provjerava sve zapise
      AND recglo.opis2 = rnk.godina (+)
      AND recglo.id1 = rnk.kase_id (+)
      AND recglo.opis3 = rnk.rbr (+)
    -- kraj MK IRN 2988
    FOR UPDATE OF recglo.id2 NOWAIT
    )
  LOOP
    IF recglo_c.rnk_rbr IS NULL -- pkarnk nije naen u GAS po rbr ili su datum ili iznos razliiti
      OR recglo_c.datum1 <> recglo_c.rnk_datum
      OR recglo_c.iznos1 <> recglo_c.rnk_iznos
    THEN
      UPDATE prec_global SET id2 = 0 WHERE rowid = recglo_c.rid;
      IF NOT previse_rnk_l THEN
        SELECT sifra INTO gmpkas_sifra_l FROM mgmp_kase WHERE id = recglo_c.id1; -- mora postojati ako je recglo.id1 = pkarnk.gmpkas_id
        IF rnk_nema_u_gas_l IS NULL THEN
          rnk_nema_u_gas_l := gmpkas_sifra_l || ' ' || recglo_c.opis3;
        ELSE
          IF LENGTH (rnk_nema_u_gas_l) + LENGTH ('; ' || gmpkas_sifra_l || ' ' || recglo_c.opis3) > 2000 THEN
            rnk_nema_u_gas_l := rnk_nema_u_gas_l  || '...';
            previse_rnk_l  := TRUE;
          ELSE
            rnk_nema_u_gas_l:= rnk_nema_u_gas_l || '; ' || gmpkas_sifra_l || ' ' || recglo_c.opis3;
          END IF;
        END IF;
      END IF;
    END IF;
  END LOOP;
  rnk_nema_u_gas_p := rnk_nema_u_gas_l;
END;
PROCEDURE LC_KNJ_RECRAC_RNKGAS
 (GUID_P IN LPKA_RAC_FIN.GUID%TYPE
 )
 IS
-- puni prec_globa2 sa knjienjem iz rnkgas
  gmpkassus_sifra_l mzmp_gmpkas_sus.sifra%TYPE;
  god_poslovna_l VARCHAR2(4);

  CURSOR god_c IS
    SELECT DISTINCT opis2
     FROM prec_global
    WHERE opis1 = guid_p;
  rbr_stavke_l NUMBER:= 0;
BEGIN

  /*
  prec_global2
  -- mish oznaka
  ozn_izvora - opis1 (USL, RNKPKA, RNKGAS)
  -- LC
  VsID
  Godina
  --
  DokGUID - opis2
  --
  Rbr - opis3
  Datum - datum1
  PozSifra - opis4
  KonKonto - opis5
  MtSifra - opis6
  Duguje - iznos1
  Potrazuje - iznos2
  Opis - opis7
  --
  */

  /* prec_global - popis rnk
  -- potrebni podaci
  guid - opis1
  god_poslovna - opis2
  gmpkas_id - id1
  rbr -opis3
  -- dodatni podaci, izbacit ako se ne budu koristili
  ozn_unosa - opis4
  izn_placanja - iznos1
  faktor - iznos2 (1 ili -1, to je faktor sa kojim se mnoe iznosi u GAS sukladno vezi pkarnk na V ili P (=1) raun odnosno N raun (=-1)
  dat_pkarnk - datum1
  ozn_ima_u_gas - id2 (-1 default = ima u gas, 0 - ako nije naen u GAS i knjiit e se na privremeni konto)
  */

  OPEN god_c;
  FETCH god_c INTO  god_poslovna_l;
  IF god_c%NOTFOUND THEN
    CLOSE god_c;
    RETURN;
  END IF;
  CLOSE god_c;

  INSERT INTO prec_global2 (opis1, opis2, opis4, opis5, opis6, iznos1, iznos2, opis7)
    SELECT
      'RNKGAS',
      guid_p,
      zmpkonpoz.pozicija,
      zmpkon.sifra,
      oj.sifra,
      SUM (DECODE (gaspknj.dug_pot_1, 'D', gasknjpom.iznos * DECODE (gaspknj.predznak_1, '+', 1, -1), 0)) duguje,
      SUM (DECODE (gaspknj.dug_pot_1, 'P', gasknjpom.iznos * DECODE (gaspknj.predznak_1, '+', 1, -1), 0)) potrazuje,
      gaspknj.gasoknj_naziv AS gasoknj_naziv
    FROM (
      SELECT
        mt_id,
        opisi.id gasoknj_id,
        DECODE (opisi.sifra, '0010', gnac_id, NULL) gnac_id,
        DECODE (opisi.sifra, '0010', gknji_id, NULL) gknji_id,
        SUM (
          DECODE (opisi.sifra,
            '0010', (rnpro.iznos - rnpro.iznos_pdv - rnpro.iznos_ppot),
            '0111', rnpro.iznos_pdv,
            '0112', rnpro.iznos_pdv,
            '0113', rnpro.iznos_pdv,
            '0120', rnpro.iznos_ppot) * recrnk.iznos2) iznos,
        DECODE (opisi.sifra, '0010', mt.vrsta, 'H') vrsta,
        rnpro.godina
      FROM
        /*
        t_rnkase rn,
        t_rnkase_pro rnpro,
        */
        v_rnkase_pro_vpla rnpro,
        prec_global recrnk,
        sgas_opisi_knjizenja opisi,
        m_nacpot nac,
        m_mt mt
      WHERE
        rnpro.datum  = recrnk.datum1
        AND rnpro.kase_id =  recrnk.id1
        AND rnpro.rbr = SUBSTR (recrnk.opis3, 1, 6)
        AND rnpro.godina = SUBSTR (recrnk.opis2, 1, 4)
        /* AND rn.id = rnpro.rn_id */
        AND rnpro.nac_id = nac.id
        AND rnpro.mt_id = mt.id
        AND recrnk.id2 = -1
        AND recrnk.opis1 = guid_p
        AND (
            INSTR (opisi.naziv, DECODE (LENGTH (rnpro.pdv), 1, ' ' || rnpro.pdv, rnpro.pdv)) > 0
            AND opisi.sifra IN ('0111', '0112', '0113') OR opisi.sifra IN ('0010', '0120')
            )
      GROUP BY
        mt_id,
        opisi.id,
        DECODE(opisi.sifra, '0010', gnac_id, NULL),
        DECODE(opisi.sifra, '0010', gknji_id, NULL),
        DECODE(opisi.sifra, '0010', mt.vrsta, 'H'),
        rnpro.godina
      ) gasknjpom,
      v_mgas_pravila gaspknj,
      m_oj oj,
      mzmp_konta zmpkon,
      mzmp_kon_poz zmpkonpoz
    WHERE
      gasknjpom.iznos <> 0
      AND NVL (gaspknj.ojk_id, gasknjpom.mt_id)  = oj.id
      AND (gaspknj.vrsta_mt = 'H' OR gaspknj.vrsta_mt = gasknjpom.vrsta)
      AND gaspknj.gasoknj_id = gasknjpom.gasoknj_id
      AND zmpkon.id = gaspknj.zmpkon1_id
      AND NVL (gasknjpom.gknji_id, 0) =  NVL (gaspknj.gknji_id, 0)
      AND NVL (gasknjpom.gnac_id, 0)  =  NVL (gaspknj.gnac_id, 0)
      AND pra_zmp.oj_pripada_oj (gasknjpom.mt_id, gaspknj.oj_id) = -1
      AND zmpkon.id = zmpkonpoz.zmpkon_id (+)
      AND NVL (zmpkonpoz.god_poslovna, god_poslovna_l) = god_poslovna_l
    GROUP BY
      'RNKGAS', guid_p, zmpkonpoz.pozicija, zmpkon.sifra, oj.sifra, gaspknj.gasoknj_naziv
    UNION ALL
    SELECT
      'RNKGAS',
      guid_p,
      zmpkonpoz.pozicija,
      zmpkon.sifra,
      oj.sifra,
      SUM (DECODE (gaspknj.dug_pot_1, 'D', gasknjpom.iznos * DECODE (gaspknj.predznak_1, '+', 1, -1), 0)) duguje,
      SUM (DECODE (gaspknj.dug_pot_1, 'P', gasknjpom.iznos * DECODE (gaspknj.predznak_1, '+', 1, -1), 0)) potrazuje,
      gaspknj.gasoknj_naziv gasoknj_naziv
    FROM (
      SELECT
        mt_id,
        opisi.id gasoknj_id,
        DECODE (opisi.sifra, '0010', gnac_id, NULL) gnac_id,
        DECODE (opisi.sifra, '0010', gknji_id, NULL) gknji_id,
        SUM (
          DECODE (opisi.sifra,
            '0010', (rnpro.iznos - rnpro.iznos_pdv - rnpro.iznos_ppot),
            '0111', rnpro.iznos_pdv,
            '0112', rnpro.iznos_pdv,
            '0113', rnpro.iznos_pdv,
            '0120', rnpro.iznos_ppot)* recrnk.iznos2) iznos,
        mt.vrsta,
        rnpro.godina
      FROM
        /*
        t_rnkase rn,
        t_rnkase_pro rnpro,
        */
        v_rnkase_pro_vpla rnpro,
        prec_global recrnk,
        sgas_opisi_knjizenja opisi,
        m_nacpot nac,
        m_mt mt
      WHERE
        rnpro.datum  = recrnk.datum1
        AND rnpro.kase_id =  recrnk.id1
        AND rnpro.rbr = SUBSTR (recrnk.opis3, 1, 6)
        AND rnpro.godina = SUBSTR (recrnk.opis2, 1, 4)
        /* AND rn.id = rnpro.rn_id */
        AND rnpro.nac_id = nac.id
        AND rnpro.mt_id = mt.id
        AND recrnk.id2 = -1
        AND recrnk.opis1 = guid_p
        AND
          (
          INSTR (opisi.naziv, DECODE (LENGTH (rnpro.pdv), 1, ' ' || rnpro.pdv, rnpro.pdv)) > 0
          AND opisi.sifra IN ('0111', '0112', '0113') OR opisi.sifra IN ('0010', '0120')
          )
      GROUP BY
        mt_id,
        opisi.id,
        DECODE (opisi.sifra, '0010', gnac_id, NULL),
        DECODE (opisi.sifra, '0010', gknji_id, NULL),
        mt.vrsta,
        rnpro.godina
      ) gasknjpom,
      v_mgas_pravila gaspknj,
      m_oj oj,
      mzmp_konta zmpkon,
      mzmp_kon_poz zmpkonpoz
    WHERE
      gasknjpom.iznos <> 0
      AND gaspknj.zmpkon2_id IS NOT NULL
      AND zmpkon.id = gaspknj.zmpkon2_id
      AND (gaspknj.vrsta_mt = 'H' OR  gaspknj.vrsta_mt = gasknjpom.vrsta)
      AND gaspknj.gasoknj_id = gasknjpom.gasoknj_id
      AND NVL (gaspknj.ojk_id, gasknjpom.mt_id)  = oj.id
      AND NVL (gasknjpom.gknji_id, 0) =  NVL (gaspknj.gknji_id, 0)
      AND NVL (gasknjpom.gnac_id, 0)  =  NVL (gaspknj.gnac_id, 0)
      AND pra_zmp.oj_pripada_oj (gasknjpom.mt_id, gaspknj.oj_id) = -1
      AND zmpkon.id = zmpkonpoz.zmpkon_id (+)
      AND NVL(zmpkonpoz.god_poslovna,god_poslovna_l) = god_poslovna_l
    GROUP BY
      'RNKGAS', guid_p, zmpkonpoz.pozicija, zmpkon.sifra, oj.sifra, gaspknj.gasoknj_naziv;


  -- provjera salda temeljnice te korigiranje na potranoj strani (konto prihoda), oj najvia iz vlasnika.
  /* to se radi u lc_knj_recrac_nap nakon to je gotovo sve knjienje

  INSERT INTO prec_global2 (opis1, opis2, datum1, opis4, opis5, opis6, iznos1, iznos2, opis7)
  SELECT 'POS', guid_p, MIN(datum1) datum,  MIN(zmpkonpoz.pozicija), MIN(zmpkon.sifra), MIN (oj.sifra), 0, SUM(iznos1 - iznos2), 'saldiranje'
    FROM prec_global2,
         (SELECT pra_zmp_zaj.zmppar_vrijednost ('LIBUSOFT', '1006') sifra FROM dual) konto,
         mzmp_kon_poz zmpkonpoz,
         mzmp_konta zmpkon,
         sgas_vlasnik vlasnik,
         m_oj oj
   WHERE opis2 =  guid_p
     AND konto.sifra = zmpkon.sifra
     AND NVL (zmpkonpoz.god_poslovna, TO_CHAR (datum1,'RRRR')) = TO_CHAR (datum1, 'RRRR')
     AND oj.id = vlasnik.oj_id
   GROUP BY guid_p;
  */

  -- update rednog broja stavke
  /* to se ne radi ovdje ve u lc_knj_recrac nakon to je gotovo sve knjienje
  rbr_stavke_l := 0;
  FOR recglo2_c IN (
    SELECT recglo2.rowid rid
      FROM prec_global2 recglo2
     WHERE recglo2.opis2 = guid_p
     ORDER BY opis1, opis6, opis5
       FOR UPDATE OF recglo2.opis3 NOWAIT)
  LOOP
    rbr_stavke_l := rbr_stavke_l + 1;
    UPDATE prec_global2
       SET opis3 = TO_CHAR (rbr_stavke_l)
     WHERE rowid = recglo2_c.rid;
  END LOOP;
  */
END;
PROCEDURE LC_KNJ_RECRAC_RNKPKA
 (DATUM_P IN LPKA_RAC_FIN.DATUM%TYPE
 ,GUID_P IN LPKA_RAC_FIN.GUID%TYPE
 )
 IS
-- puni prec_globa2 sa knjienjem iz rnkpka (rnk kojih nema u GAS) 
  gmpkassus_sifra_l mzmp_gmpkas_sus.sifra%TYPE; -- za knjienje prihoda
  oj_knjizenja_l m_oj.sifra%TYPE; -- oj iz kase - za knjienje pdv i ppot
  oj_knjizenja_param_l m_oj.sifra%TYPE; -- ako se eli knjienje pdv i ppot na poduzee se (za sada) ita ZMP param ZMP 0023 
  konto_prihodn_rnk_l szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.zmppar_vrijednost ('LIBUSOFT', '1001');
  konto_pdv_rnk_l szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.zmppar_vrijednost ('LIBUSOFT', '1002');
  konto_ppot_rnk_l szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.zmppar_vrijednost ('LIBUSOFT', '1003');
  konto_prihodb_rnk_l szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.zmppar_vrijednost ('LIBUSOFT', '1004');
  konto_pdv_vpispz_l mzmp_konta.sifra%TYPE;
  
  CURSOR konta_c (sifra_k mzmp_konta.sifra%TYPE) IS
    SELECT zmpkon.id, zmpkonpoz.pozicija
      FROM mzmp_konta zmpkon, mzmp_kon_poz zmpkonpoz
      WHERE zmpkon.sifra = sifra_k
         AND zmpkon.id = zmpkonpoz.zmpkon_id (+)
         AND NVL(zmpkonpoz.god_poslovna,to_char(datum_p,'RRRR')) = to_char(datum_p,'RRRR');
  CURSOR konta_sifra_c (id_k mzmp_konta.id%TYPE) IS
    SELECT zmpkon.sifra, zmpkonpoz.pozicija
      FROM mzmp_konta zmpkon, mzmp_kon_poz zmpkonpoz
      WHERE zmpkon.id = id_k
         AND zmpkon.id = zmpkonpoz.zmpkon_id (+)
         AND NVL(zmpkonpoz.god_poslovna,to_char(datum_p,'RRRR')) = to_char(datum_p,'RRRR');
  CURSOR oj_param_c IS 
    SELECT sifra FROM m_oj WHERE sifra = pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0023');   
         
  zmpkon_id_l mzmp_konta.id%TYPE;
  pozicija_l mzmp_kon_poz.pozicija%TYPE;  
  
  nebitno_l NUMBER;
BEGIN

/*
prec_global2
-- mish oznaka 
ozn_izvora - opis1 (USL, RNKPKA, RNKGAS)
-- LC
VsID 
Godina 
--
DokGUID - opis2
--
Rb - opis3
Datum - datum1
PozSifra - opis4
KonKonto - opis5
MtSifra - opis6
Duguje - iznos1
Potrazuje - iznos2
Opis - opis7
--

*/
-- knjienje rnk kojih nema u GAS preko PKA parametara       
  OPEN oj_param_c;
  FETCH oj_param_c INTO oj_knjizenja_param_l;
  CLOSE oj_param_c;

  FOR rnk_c IN 
    (SELECT pkarnk.gmpkas_id gmpkas_id, 
            SUM (pkarnk.izn_placanja * recglo.iznos2) izn_prihoda, 
            SUM (pkarnk.izn_ppot * recglo.iznos2) izn_ppot, 
            SUM (pkarnkpdv.izn_pdv * recglo.iznos2) izn_pdv
       FROM prec_global recglo, tpka_rnkasa pkarnk,
            (SELECT pkarnk_id, SUM (izn_pdv) izn_pdv FROM ipka_rnk_pdv GROUP BY pkarnk_id) pkarnkpdv
      WHERE recglo.opis1 = guid_p AND recglo.id2 <> -1
        AND recglo.opis2 = pkarnk.god_poslovna_izvor AND recglo.id1 = pkarnk.gmpkas_id_izvor 
        AND recglo.opis3 = pkarnk.rbr_izvor
        AND pkarnk.id = pkarnkpdv.pkarnk_id
      GROUP BY pkarnk.gmpkas_id
    )  
  LOOP
    SELECT MIN (gmpkassus.sifra) INTO gmpkassus_sifra_l FROM mzmp_gmpkas_sus gmpkassus, szmp_sustavi zmpsus 
     WHERE gmpkassus.zmpsus_id = zmpsus.id AND gmpkas_id = rnk_c.gmpkas_id AND zmpsus.sifra = 'LIBUSOFT';
    SELECT oj.sifra INTO oj_knjizenja_l FROM m_oj oj, mgmp_kase gmpkas
     WHERE oj.id = gmpkas.zmpojr_id AND gmpkas.id = rnk_c.gmpkas_id;  
    OPEN konta_c (konto_prihodN_rnk_l);
    FETCH konta_c INTO zmpkon_id_l, pozicija_l;
    IF konta_c%FOUND THEN
      INSERT INTO prec_global2 
                  (opis1, opis2, 
                   opis3, opis4,
                   opis5, 
                   iznos1,
                   iznos2,
                   opis6, 
                   opis7) 
           VALUES ('RNKPKA', guid_p, 
                   NULL, 
                   pozicija_l,
                   konto_prihodN_rnk_l,  -- konto za neto prihod
                   0, --izn_duguje
                   rnk_c.izn_prihoda - rnk_c.izn_pdv - rnk_c.izn_ppot, -- izn_potrazuje
                   gmpkassus_sifra_l,
                   'PKA RNK za punkt ' || gmpkassus_sifra_l);
    END IF;
    CLOSE konta_c;
    -- ako su pravila za PDV po vpispz onda bi LIBUSOFT param za konto za PDV trebao biti 'nebitno' 
    OPEN konta_c (konto_pdv_rnk_l);
    FETCH konta_c INTO zmpkon_id_l, pozicija_l;
    IF konta_c%FOUND THEN
      INSERT INTO prec_global2 
                  (opis1, opis2, 
                   opis3, opis4,
                   opis5, 
                   iznos1,
                   iznos2,
                   opis6, 
                   opis7) 
           VALUES ('RNKPKA', guid_p, 
                   NULL, 
                   pozicija_l,
                   konto_pdv_rnk_l,
                   0, --izn_duguje
                   rnk_c.izn_pdv, -- izn_potrazuje
                   NVL (oj_knjizenja_param_l, oj_knjizenja_l), --gmpkassus_sifra_l 
                   'PKA RNK za punkt ' || gmpkassus_sifra_l);
    END IF;
    CLOSE konta_c;
    OPEN konta_c (konto_ppot_rnk_l);
    FETCH konta_c INTO zmpkon_id_l, pozicija_l;
    IF konta_c%FOUND THEN
      INSERT INTO prec_global2 
                  (opis1, opis2, 
                   opis3, opis4,
                   opis5, 
                   iznos1,
                   iznos2,
                   opis6, 
                   opis7) 
           VALUES ('RNKPKA', guid_p, 
                   NULL, 
                   pozicija_l,
                   konto_ppot_rnk_l,  -- konto ZA PPOT
                   0, --izn_duguje
                   rnk_c.izn_ppot, -- izn_potrazuje
                   NVL (oj_knjizenja_param_l, oj_knjizenja_l), --gmpkassus_sifra_l 
                   'PKA RNK za punkt ' || gmpkassus_sifra_l);
    END IF;
    CLOSE konta_c;
    OPEN konta_c (konto_prihodB_rnk_l);
    FETCH konta_c INTO zmpkon_id_l, pozicija_l;
    IF konta_c%FOUND THEN
      INSERT INTO prec_global2 
                  (opis1, opis2, 
                   opis3, opis4,
                   opis5, 
                   iznos1,
                   iznos2,
                   opis6, 
                   opis7) 
           VALUES ('RNKPKA', guid_p, 
                   NULL, 
                   pozicija_l,
                   konto_prihodB_rnk_l,  -- konto ZA BRUTO PRIHOD
                   rnk_c.izn_prihoda, --izn_duguje
                   0, -- izn_potrazuje
                   oj_knjizenja_l, --gmpkassus_sifra_l
                   'PKA RNK za punkt ' || gmpkassus_sifra_l);
    END IF;
    CLOSE konta_c;
  END LOOP;
  
  -- knjienje PDV za rnk kojih nema u GAS preko vpispz 
  FOR rnk_c IN 
    (SELECT pkarnk.gmpkas_id gmpkas_id, pkarnkpdv.vpispz_id, vpispz.zmpkon_id,
            SUM (pkarnkpdv.izn_pdv * recglo.iznos2) izn_pdv
       FROM prec_global recglo, tpka_rnkasa pkarnk,
            (SELECT pkarnk_id, vpispz_id, SUM (izn_pdv) izn_pdv FROM ipka_rnk_pdv GROUP BY pkarnk_id, vpispz_id) pkarnkpdv,
            s_vpisporukaz vpispz
      WHERE recglo.opis1 = guid_p AND recglo.id2 <> -1
        AND recglo.opis2 = pkarnk.god_poslovna_izvor AND recglo.id1 = pkarnk.gmpkas_id_izvor 
        AND recglo.opis3 = pkarnk.rbr_izvor
        AND pkarnk.id = pkarnkpdv.pkarnk_id
        AND pkarnkpdv.vpispz_id = vpispz.id (+)
      GROUP BY pkarnk.gmpkas_id, pkarnkpdv.vpispz_id, vpispz.zmpkon_id
    )  
  LOOP
    IF rnk_c.zmpkon_id IS NOT NULL THEN 
      SELECT oj.sifra INTO oj_knjizenja_l FROM m_oj oj, mgmp_kase gmpkas
       WHERE oj.id = gmpkas.zmpojr_id AND gmpkas.id = rnk_c.gmpkas_id;
      OPEN konta_sifra_c (rnk_c.zmpkon_id);  
      FETCH konta_sifra_c INTO konto_pdv_vpispz_l, pozicija_l;
      IF konta_sifra_c%FOUND THEN    -- to je samo zbog slinosti sa gore, inae je nepotrebno jer je zmpkon_id FK
        INSERT INTO prec_global2 
                  (opis1, opis2, 
                   opis3, opis4,
                   opis5, 
                   iznos1,
                   iznos2,
                   opis6, 
                   opis7) 
           VALUES ('RNKPKA', guid_p, 
                   NULL, 
                   pozicija_l,
                   konto_pdv_vpispz_l,  -- konto za PDV
                   0, --izn_duguje
                   rnk_c.izn_pdv, -- izn_potrazuje
                   NVL (oj_knjizenja_param_l, oj_knjizenja_l), --gmpkassus_sifra_l 
                   'PKA RNK za punkt ' || gmpkassus_sifra_l);
      END IF;
      CLOSE konta_sifra_c;
    END IF;
  END LOOP;  
  
END;
PROCEDURE LC_KNJ_RECRAC_NAP
 (OZN_UK_P IN LPKA_RAC_FIN.OZN_UK%TYPE
 ,DATUM_P IN LPKA_RAC_FIN.DATUM%TYPE
 ,OZN_VRACUNA_P IN LPKA_RAC_FIN.OZN_VRACUNA%TYPE
 ,GUID_P IN LPKA_RAC_FIN.GUID%TYPE
 )
 IS
-- puni prec_globa2 sa knjienjem za naplatu REC rauna
-- prema pravilima knjienja za vrste plaanja u MGAS_PRAVILA_VPLA
-- predujam se knjii preko vrste plaanja za iskoriteni predujam (pra_zmp_zaj.vrijednost_parametra('0061')

  CURSOR vpla_c IS
    SELECT id
      FROM s_vplacanja vpla
      WHERE vpla.sifra = pra_zmp_zaj.vrijednost_parametra('0061');

  konto_razlike_nap_l szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.zmppar_vrijednost ('LIBUSOFT', '1008');
  konto_saldiranje_l szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.zmppar_vrijednost ('LIBUSOFT', '1006');

  CURSOR konta_c (sifra_k mzmp_konta.sifra%TYPE) IS
    SELECT zmpkon.id, zmpkonpoz.pozicija
      FROM mzmp_konta zmpkon, mzmp_kon_poz zmpkonpoz
      WHERE zmpkon.sifra = sifra_k
         AND zmpkon.id = zmpkonpoz.zmpkon_id (+)
         AND NVL (zmpkonpoz.god_poslovna, TO_CHAR (datum_p, 'RRRR')) = TO_CHAR (datum_p, 'RRRR');
  zmpkon_id_l mzmp_konta.id%TYPE;
  pozicija_l mzmp_kon_poz.pozicija%TYPE;

  izn_predujma_l tpka_racuni.iznos%TYPE;
  izn_razlike_l t_racuni.iznos%TYPE;
  vpla_id_l s_vplacanja.id%TYPE;
  oj_knjizenja_l m_oj.sifra%TYPE;

  izn_saldiranje_l t_racuni.iznos%TYPE;
BEGIN

  /*
  prec_global2
  -- mish oznaka
  ozn_izvora - opis1 (usl, nap, rnkpka, rnkgas)
  -- LC
  VsID
  Godina
  --
  DokGUID - opis2
  --
  Rb - opis3        -- puni se na kraju u lc_knj_recrac
  Datum - datum1    -- puni se na kraju u lc_knj_recrac
  PozSifra - opis4
  KonKonto - opis5
  MtSifra - opis6
  Duguje - iznos1
  Potrazuje - iznos2
  Opis - opis7
  --
  */

  -- prema pravilima knjienja (mgas_pravila_vpla) za konto 1
  INSERT INTO prec_global2 (
      opis1, opis2, opis3, opis4, opis5, iznos1, iznos2, opis6, opis7)
    SELECT 'NAP' AS opis1, guid_p AS opis2, NULL AS opis3, pozicija AS opis4, konto AS opis5,
           izn_duguje AS iznos1, izn_potrazuje AS iznos2,
           oj_knjizenja AS opis6,
           NULL AS opis7
      FROM (
           SELECT zmpkonpoz.pozicija pozicija,
                  zmpkon.sifra konto,
                  rac.oj_sifra oj_knjizenja,
                  SUM
                     (CASE WHEN gaspravpla.dug_pot_1 = 'D' THEN         -- duguje
                            ROUND (racnap.izn_placanja * racnap.izn_tecaja, 2)
                             * (CASE WHEN gaspravpla.predznak_1 = '+' THEN 1
                                     WHEN gaspravpla.predznak_1 = '-' THEN -1
                                     ELSE 0
                                END)
                           ELSE NULL
                      END) izn_duguje,
                  SUM
                     (CASE WHEN gaspravpla.dug_pot_1 = 'P' THEN         -- duguje
                               ROUND (racnap.izn_placanja * racnap.izn_tecaja, 2)
                                * (CASE WHEN gaspravpla.predznak_1 = '+' THEN 1
                                        WHEN gaspravpla.predznak_1 = '-' THEN -1
                                        ELSE 0
                                   END)
                         ELSE NULL
                      END) izn_potrazuje
             FROM (
                  SELECT rac.id, oj.sifra oj_sifra
                    FROM t_racuni rac, m_oj oj, s_vapldok vapldok
                   WHERE rac.oj_id = oj.id AND rac.vapldok_id = vapldok.id
                     AND ((ozn_vracuna_p = 'RECBI' AND rac.guid = guid_p)
                         OR (ozn_vracuna_p = 'RECGI' AND vapldok.oznaka = 'GI' AND rac.oj_sifra = ozn_uk_p AND rac.datum = datum_p
                             AND ROUND (rac.iznos * rac.izn_tecaja, 2) + pra_rec_s.izn_predujma (rac.id) >= 0)
                         OR (ozn_vracuna_p = 'RECGIN' AND vapldok.oznaka = 'GI' AND rac.oj_sifra = ozn_uk_p AND rac.datum = datum_p
                             AND ROUND (rac.iznos * rac.izn_tecaja, 2) + pra_rec_s.izn_predujma (rac.id) < 0)
                        )
                  ) rac,
                  t_rac_nap racnap,
                  mgas_pravila_vpla gaspravpla,
                  mzmp_konta zmpkon,
                  mzmp_kon_poz zmpkonpoz
           WHERE rac.id = racnap.rac_id
             AND racnap.vpla_id = gaspravpla.vpla_id
             AND zmpkon.id = gaspravpla.zmpkon1_id
             AND zmpkon.id = zmpkonpoz.zmpkon_id (+)
             AND NVL (zmpkonpoz.god_poslovna, TO_CHAR (datum_p, 'RRRR')) = TO_CHAR (datum_p, 'RRRR')
           GROUP BY zmpkonpoz.pozicija,
                    zmpkon.sifra,
                    rac.oj_sifra
           );


  -- prema pravilima knjienja (mgas_pravila_vpla) za konto 2
  INSERT INTO prec_global2 (
      opis1, opis2, opis3, opis4, opis5, iznos1, iznos2, opis6, opis7)
    SELECT 'NAP' AS opis1, guid_p AS opis2, NULL AS opis3, pozicija AS opis4, konto AS opis5,
           izn_duguje AS iznos1, izn_potrazuje AS iznos2,
           oj_knjizenja AS opis6,
           NULL AS opis7
      FROM (
           SELECT zmpkonpoz.pozicija pozicija,
                  zmpkon.sifra konto,
                  rac.oj_sifra oj_knjizenja,
                  SUM
                    (CASE WHEN gaspravpla.dug_pot_2 = 'D' THEN         -- duguje?
                              ROUND (racnap.izn_placanja * racnap.izn_tecaja, 2)
                               * (CASE WHEN gaspravpla.predznak_2 = '+' THEN 1
                                       WHEN gaspravpla.predznak_2 = '-' THEN -1
                                       ELSE 0
                                  END)
                          ELSE NULL
                     END) izn_duguje,
                  SUM
                    (CASE WHEN gaspravpla.dug_pot_2 = 'P' THEN         -- duguje
                              ROUND (racnap.izn_placanja * racnap.izn_tecaja, 2)
                               * (CASE WHEN gaspravpla.predznak_2 = '+' THEN 1
                                       WHEN gaspravpla.predznak_2 = '-' THEN -1
                                       ELSE 0
                                  END)
                          ELSE NULL
                     END) izn_potrazuje
             FROM (
                  SELECT rac.id, oj.sifra oj_sifra
                    FROM t_racuni rac, m_oj oj, s_vapldok vapldok
                   WHERE rac.oj_id = oj.id AND rac.vapldok_id = vapldok.id
                     AND ((ozn_vracuna_p = 'RECBI' AND rac.guid = guid_p)
                         OR (ozn_vracuna_p = 'RECGI' AND vapldok.oznaka = 'GI' AND rac.oj_sifra = ozn_uk_p AND rac.datum = datum_p
                             AND ROUND (rac.iznos * rac.izn_tecaja, 2) + pra_rec_s.izn_predujma (rac.id) >= 0)
                         OR (ozn_vracuna_p = 'RECGIN' AND vapldok.oznaka = 'GI' AND rac.oj_sifra = ozn_uk_p AND rac.datum = datum_p
                             AND ROUND (rac.iznos * rac.izn_tecaja, 2) + pra_rec_s.izn_predujma (rac.id) < 0)
                        )
                  ) rac,
                  t_rac_nap racnap,
                  (SELECT * FROM mgas_pravila_vpla WHERE zmpkon2_id IS NOT NULL) gaspravpla,
                  mzmp_konta zmpkon,
                  mzmp_kon_poz zmpkonpoz
            WHERE rac.id = racnap.rac_id
              AND racnap.vpla_id = gaspravpla.vpla_id
              AND zmpkon.id = gaspravpla.zmpkon2_id
              AND zmpkon.id = zmpkonpoz.zmpkon_id (+)
              AND NVL (zmpkonpoz.god_poslovna, TO_CHAR (datum_p, 'RRRR')) = TO_CHAR (datum_p, 'RRRR')
            GROUP BY zmpkonpoz.pozicija,
                 zmpkon.sifra,
                 rac.oj_sifra
           );

  -- izraun iznosa predujma i razlike iznosa rauna i iznosa po vrstama plaanja.
  -- panja. 'provizija' nije obraena
  SELECT MIN (oj_sifra),  -- treba za insert u prec_global2 za BI i PRED (za koje je nemamo u ozn_uk)
         SUM (NVL (izn_predujma, 0)),
         SUM (izn_racuna - NVL (izn_placanja, 0)) izn_razlike
    INTO oj_knjizenja_l, izn_predujma_l, izn_razlike_l
    FROM
      -- rauni
      (SELECT rac.id, oj.sifra oj_sifra, ROUND (rac.iznos * rac.izn_tecaja, 2) izn_racuna, rac_nap.izn_placanja, rac_pred.izn_predujma
         FROM t_racuni rac,
              m_oj oj,
              s_vapldok vapldok,
              -- rac_nap
              (SELECT racnap.rac_id AS rac_id,
                      SUM (ROUND (racnap.izn_placanja * racnap.izn_tecaja, 2)) AS izn_placanja
                 FROM t_rac_nap racnap
                GROUP BY racnap.rac_id) rac_nap,
              -- rac_pred
              (SELECT racpred.rac_id AS rac_id,
                      SUM (ROUND (racpred.iznos * racpred.izn_tecaja, 2)) AS izn_predujma
                 FROM t_rac_pred racpred
                GROUP BY racpred.rac_id) rac_pred
        WHERE rac.oj_id = oj.id AND rac.vapldok_id = vapldok.id
          AND (ozn_vracuna_p = 'RECBI' AND rac.guid = guid_p
               OR ozn_vracuna_p = 'RECGI' AND vapldok.oznaka = 'GI' AND rac.oj_sifra = ozn_uk_p AND rac.datum = datum_p
                  AND rac.iznos * rac.izn_tecaja + NVL (rac_pred.izn_predujma, 0) >= 0
               OR ozn_vracuna_p = 'RECGIN' AND vapldok.oznaka = 'GI' AND rac.oj_sifra = ozn_uk_p AND rac.datum = datum_p
                  AND rac.iznos * rac.izn_tecaja + NVL (rac_pred.izn_predujma, 0) < 0
               )
           AND rac.id = rac_nap.rac_id (+)
           AND rac.id = rac_pred.rac_id (+)
        );

  -- knjienje predujma, preko vrste plaanja za iskoriteni predujam (pra_zmp_zaj.vrijednost_parametra ('0061')
  -- prema pravilima knjienja (mgas_pravila_vpla)
  -- predujmovi iskoriteni na BI raunima samo na konto 1,
  -- predujmovi iskoriteni na GI raunima samo na konto 2

  OPEN vpla_c;
  FETCH vpla_c INTO vpla_id_l;
  IF izn_predujma_l <> 0 AND vpla_c%FOUND AND ozn_vracuna_p = 'RECBI' THEN
    -- konto 1
    INSERT INTO prec_global2 (
        opis1, opis2, opis3, opis4, opis5, iznos1, iznos2, opis6, opis7)
      SELECT 'NAP' AS opis1, guid_p AS opis2, NULL AS opis3, pozicija AS opis4, konto AS opis5,
             izn_duguje AS iznos1, izn_potrazuje AS iznos2,
             oj_knjizenja_l AS opis6,
             NULL AS opis7
        FROM (
             SELECT zmpkonpoz.pozicija pozicija,
                    zmpkon.sifra konto,
                    SUM
                      (CASE WHEN gaspravpla.dug_pot_1 = 'D' THEN         -- duguje
                                 izn_predujma_l
                                 * (CASE WHEN gaspravpla.predznak_1 = '+' THEN 1
                                         WHEN gaspravpla.predznak_1 = '-' THEN -1
                                         ELSE 0
                                    END)
                            ELSE NULL
                       END) izn_duguje,
                    SUM
                      (CASE WHEN gaspravpla.dug_pot_1 = 'P' THEN         -- potrazuje
                                 izn_predujma_l
                                 * (CASE WHEN gaspravpla.predznak_1 = '+' THEN 1
                                         WHEN gaspravpla.predznak_1 = '-' THEN -1
                                         ELSE 0
                                    END)
                            ELSE NULL
                       END) izn_potrazuje
               FROM (SELECT * FROM mgas_pravila_vpla WHERE vpla_id = vpla_id_l) gaspravpla,
                    mzmp_konta zmpkon,
                    mzmp_kon_poz zmpkonpoz
              WHERE zmpkon.id = gaspravpla.zmpkon1_id
                AND zmpkon.id = zmpkonpoz.zmpkon_id (+)
                AND NVL (zmpkonpoz.god_poslovna, TO_CHAR (datum_p, 'RRRR')) = TO_CHAR (datum_p, 'RRRR')
              GROUP BY zmpkonpoz.pozicija,
                       zmpkon.sifra
             ) ;
  END IF;
  IF izn_predujma_l <> 0 AND vpla_c%FOUND AND ozn_vracuna_p IN ('RECGI', 'RECGIN') THEN
    -- konto 2
    INSERT INTO prec_global2 (
        opis1, opis2, opis3, opis4, opis5, iznos1, iznos2, opis6, opis7)
      SELECT 'NAP' AS opis1, guid_p AS opis2, NULL AS opis3, pozicija AS opis4, konto AS opis5,
             izn_duguje AS iznos1, izn_potrazuje AS iznos2,
             oj_knjizenja_l AS opis6,
             NULL AS opis7
        FROM (
             SELECT zmpkonpoz.pozicija pozicija,
                    zmpkon.sifra konto,
                    SUM
                      (CASE WHEN gaspravpla.dug_pot_2 = 'D' THEN         -- duguje
                                 izn_predujma_l
                                 * (CASE WHEN gaspravpla.predznak_2 = '+' THEN 1
                                         WHEN gaspravpla.predznak_2 = '-' THEN -1
                                         ELSE 0
                                    END)
                            ELSE NULL
                       END) izn_duguje,
                    SUM
                      (CASE WHEN gaspravpla.dug_pot_2 = 'P' THEN         -- duguje?
                                 izn_predujma_l
                                 * (CASE WHEN gaspravpla.predznak_2 = '+' THEN 1
                                         WHEN gaspravpla.predznak_2 = '-' THEN -1
                                         ELSE 0
                                    END)
                            ELSE NULL
                       END) izn_potrazuje
               FROM (SELECT * FROM mgas_pravila_vpla WHERE vpla_id = vpla_id_l AND
                    zmpkon2_id IS NOT NULL) gaspravpla,
                    mzmp_konta zmpkon,
                    mzmp_kon_poz zmpkonpoz
              WHERE zmpkon.id = gaspravpla.zmpkon2_id
                AND zmpkon.id = zmpkonpoz.zmpkon_id (+)
                AND NVL (zmpkonpoz.god_poslovna, TO_CHAR (datum_p, 'RRRR')) = TO_CHAR (datum_p, 'RRRR')
              GROUP BY zmpkonpoz.pozicija,
                       zmpkon.sifra
             ) ;
  END IF;

  -- knjienje iznosa razlika - na strani naplate
  OPEN konta_c (konto_razlike_nap_l);
  FETCH konta_c INTO zmpkon_id_l, pozicija_l;
  IF izn_razlike_l <> 0 AND konta_c%FOUND THEN
    INSERT INTO prec_global2 (
        opis1, opis2,
        opis3, opis4,
        opis5,
        iznos1,
        iznos2,
        opis6,
        opis7)
      VALUES (
        'NAP', guid_p,
        NULL, pozicija_l,
        konto_razlike_nap_l,  -- konto za iznos razlike zbog zaokruivanja na strani naplate
        izn_razlike_l, -- izn_duguje
        0, -- izn_potrazuje
        oj_knjizenja_l,
        'razlike zbog zaokruivanja na strani naplate');
  END IF;
  CLOSE konta_c;

  -- provjera salda temeljnice te korigiranje na potranoj strani (konto prihoda)
  SELECT SUM (NVL (iznos1, 0) - NVL (iznos2, 0)) INTO izn_saldiranje_l
    FROM prec_global2
   WHERE opis2 = guid_p;

  IF izn_saldiranje_l <> 0 THEN
    OPEN konta_c (konto_saldiranje_l);
    FETCH konta_c INTO zmpkon_id_l, pozicija_l;
    IF konta_c%FOUND THEN
      INSERT INTO prec_global2 (
          opis1, opis2,
          opis3, opis4,
          opis5,
          iznos1,
          iznos2,
          opis6,
          opis7)
        VALUES (
          'RECRAC', guid_p,
          NULL, pozicija_l,
          konto_saldiranje_l,  -- konto za iznos razlike D - P na temeljnici
          0, -- izn_duguje
          izn_saldiranje_l, -- izn_potrazuje
          oj_knjizenja_l,
          'saldiranje temeljnice');
    END IF;
    CLOSE konta_c;
  END IF;

END;
PROCEDURE IZV_KNJ_RAC
 (DAT_POC_P IN DATE
 ,DAT_ZAV_P IN DATE
 ,OJ_ID_P IN M_OJ.ID%TYPE
 ,OZN_BI_P IN NUMBER
 ,OZN_GI_P IN NUMBER
 ,OZN_POS_P IN NUMBER
 )
 IS
-- Izvjetaj za knjienje (REC) rauna u LC; 
-- izvjetaj se moe pokrenuti nezavisno o pripremi za knjienje, znai kada jo nemamo pkaracfin, niti guid iz pkaracfin
-- pkarnk naeni u gas se prikazuju kao gastro urnal (mt, gknji i knjigo_grupa), 
-- pkarnk koji nisu pronaeni u gas se prikazuju na razini kase
 
/* prec_global2 - priprema za izvjetaj
            datum1 -- datum
            opis1 -- oj_sifra
            opis2 -- ozn_izvora(USL, RNKPKA, RNKGAS)
            opis3 -- ozn_vracuna (RECBI, RECGI, POS)
            opis4 -- rac_rbr
            id1 -- so_id (usl) 
            id2 -- szur_id (usl) 
			id3 -- mt_id (rnkgas)
			id4 -- gknji_id (rnkgas) knjig. grupa
			id5 -- gnac_id (rnkgas) grupa naina potronje
			id6 -- gmpkas_id (rnkpka)      
			id7 -- vpispz_id 
            iznos1 -- izn_prihoda
            iznos2  -- izn_pdv
            iznos3  -- izn_ppot

prec_global - popis rnk
    -- opis1 - guid -- ne punimo, prec_global se najprije isprazni, pa napuni za jedan 'raun', treba pokupiti sve rnk iz nje (bez uvjeta)
    opis2 -- god_poslovna
    id1   -- gmpkas_id 
    opis3 -- rbr
    opis4 -- ozn_unosa
    iznos1 -- izn_placanja - iznos1  
    iznos2 -- faktor (1 ili -1, to je faktor sa kojim se mnoe iznosi u GAS sukladno vezi pkarnk na V ili P (=1) raun odnosno N raun (=-1)
    datum1 -- dat_pkarnk
    id2    -- ozn_ima_u_gas  (-1 default = ima u gas, 0 - ako nije naen u GAS i knjiit e se na privremeni konto)

*/

  gas_cvor_l smet_cvorovi.sifra%TYPE := pra_pos_gas.vrati_gas_cvor; -- lokalni ili centralni GAS
    -- ako je gas lokalni ali se moe knjiiti sa drugih OJ bi te raune trebali traiti na tim drugim shemama (ili centru) preko ojr kase
    -- budui imaju brijuni centralni gas za sada idemo na centar
  naredba_l VARCHAR2 (4000); 
  rnk_nema_u_gas_l VARCHAR2 (2000);
BEGIN
  IF (ozn_BI_p = 0 AND ozn_GI_p = 0 AND ozn_POS_p = 0)
    OR dat_poc_p IS NULL
    OR dat_zav_p IS NULL
  THEN
    RETURN;
  END IF;
  
  DELETE FROM prec_global;  
  DELETE FROM prec_global2;
  IF gas_cvor_l IS NOT NULL THEN
    naredba_l := 'DELETE FROM prec_global' || gas_cvor_l;
    EXECUTE IMMEDIATE naredba_l;
    naredba_l := 'DELETE FROM prec_global2' || gas_cvor_l;
    EXECUTE IMMEDIATE naredba_l;
  END IF;

  FOR rac_c IN (
      SELECT datum, oj_sifra, 'RECBI' AS ozn_vracuna, rbr AS rac_rbr, guid AS rac_guid
        FROM t_racuni rac,
             s_vapldok vapldok
       WHERE rac.vapldok_id = vapldok.id
         AND vapldok.oznaka IN ('BI', 'BV') AND ozn_BI_p = -1
         AND rac.datum BETWEEN dat_poc_p AND dat_zav_p
         AND rac.oj_id = NVL (oj_id_p, rac.oj_id)
       UNION ALL
      SELECT DISTINCT datum, oj_sifra, 
             (CASE WHEN  rac.iznos * rac.izn_tecaja + pra_rec_s.izn_predujma (rac.id) >= 0 THEN 'RECGI'  -- pozitivni
                                             ELSE 'RECGIN'  -- negativni --> storno
             END) ozn_vracuna,
             NULL AS rac_rbr, NULL AS rac_guid
        FROM t_racuni rac,
             s_vapldok vapldok
	   WHERE rac.vapldok_id = vapldok.id
         AND vapldok.oznaka = 'GI' AND ozn_GI_p = -1
         AND rac.datum BETWEEN dat_poc_p AND dat_zav_p
         AND rac.oj_id = NVL (oj_id_p, rac.oj_id)
	)	 
  LOOP
    -- pripremiti USL podatke (REC usluge) 
    INSERT INTO prec_global2 (
            datum1 -- datum
            ,opis1 -- oj_sifra
            ,opis2 -- ozn_izvora(USL, RNKPKA, RNKGAS)
            ,opis3 -- ozn_vracuna
            ,opis4 -- rac_rbr
            ,id1 -- so_id (usl) / mt_id (rnkgas) / gmpkas_id (rnkpka)
            ,id2 -- szur_id (usl) / knjigo_id (rnkgas) / null (rnkpka)    
            ,id7   -- vpispz_id 
            ,iznos1 -- izn_prihoda
            ,iznos2  -- izn_pdv
        )
    SELECT datum AS datum1, 
             oj_sifra AS opis1, 'USL' AS opis2, rac_c.ozn_vracuna AS opis3, rac_c.rac_rbr AS opis4, 
             so_id AS id1, szur_id AS id2, vpispz_id AS id7,  
             SUM (izn_zprihoda_nodb_npdv) AS iznos1, SUM (izn_zpdv_nodb) AS iznos2
        FROM v_rac_zurusl raczurusl
       WHERE raczurusl.datum = rac_c.datum
         AND raczurusl.oj_sifra = rac_c.oj_sifra
         AND (rac_c.ozn_vracuna = 'RECBI' AND raczurusl.vapldok_oznaka IN ('BI', 'BV') 
             OR rac_c.ozn_vracuna = 'RECGI' AND raczurusl.vapldok_oznaka = 'GI' AND raczurusl.izn_racuna_uk >= 0
             OR rac_c.ozn_vracuna = 'RECGIN' AND raczurusl.vapldok_oznaka = 'GI' AND raczurusl.izn_racuna_uk < 0
			 )
         AND raczurusl.rac_guid = NVL (rac_c.rac_guid, raczurusl.rac_guid)
       GROUP BY datum, oj_sifra, vapldok_oznaka, rac_rbr, so_id, szur_id, vpispz_id;
    -- KRAJ pripremiti USL podatke (REC usluge) 
    -- priprema popisa RNK u prec_global
    naredba_l := 'DELETE FROM prec_global' || gas_cvor_l;
    EXECUTE IMMEDIATE naredba_l;  
    FOR puni_recglo_c IN
        (SELECT pkarnk.god_poslovna, pkarnk.gmpkas_id, pkarnk.rbr, pkarnk.ozn_unosa, 
             pkarnk.izn_placanja * rac.faktor izn_placanja, 
             rac.faktor, pkarnk.datum dat_pkarnk
           FROM tpka_rnkasa pkarnk, 
                 (SELECT rac.id, DECODE (rac.oznaka, 'N', -1, 1) faktor 
                    FROM t_racuni rac, s_vapldok vapldok
                   WHERE rac.vapldok_id = vapldok.id
                     AND rac.datum = rac_c.datum
                     AND rac.oj_sifra = rac_c.oj_sifra
                   --AND 'REC' || vapldok.oznaka = rac_c.ozn_vracuna
                     AND (rac_c.ozn_vracuna = 'RECBI' AND vapldok.oznaka IN ('BI', 'BV') 
                         OR rac_c.ozn_vracuna = 'RECGI' AND vapldok.oznaka = 'GI' AND rac.iznos * rac.izn_tecaja + pra_rec_s.izn_predujma (rac.id) >= 0 
                         OR rac_c.ozn_vracuna = 'RECGIN' AND vapldok.oznaka = 'GI' AND rac.iznos * rac.izn_tecaja + pra_rec_s.izn_predujma (rac.id) < 0
                         )
                     AND rac.guid = NVL (rac_c.rac_guid, rac.guid)
                  ) rac  
         WHERE pkarnk.rac_id = rac.id
        )
    LOOP
      naredba_l := 'INSERT INTO prec_global' || gas_cvor_l ||
          '        (opis2,' ||
          '        id1,' ||
          '        opis3,' ||
          '        opis4,' ||
          '        iznos1,' ||
          '        iznos2,' ||
          '        datum1,' ||
          '        id2)' ||
          '    VALUES (' ||
          '        :god_poslovna,' ||
          '        :gmpkas_id,' ||
          '        :rbr,' ||
          '        :ozn_unosa,' ||
          '        :izn_placanja,' ||
          '        :faktor,' ||
          '        :dat_pkarnk,' ||
          '        -1)';  -- ozn_ima_u_gas    
      EXECUTE IMMEDIATE naredba_l USING 
                 puni_recglo_c.god_poslovna,
                 puni_recglo_c.gmpkas_id,
                 puni_recglo_c.rbr,
                 puni_recglo_c.ozn_unosa,
                 puni_recglo_c.izn_placanja,
                 puni_recglo_c.faktor,
                 puni_recglo_c.dat_pkarnk;             
    END LOOP;
    -- KRAJ priprema popisa RNK u prec_global
    -- provjeriti da su svi rnk upisani u gas, oni koji nisu e dobiti id2 = 0 i GAS e knjiiti samo te
    naredba_l := 'BEGIN pra_pka_fin.lc_knj_recrac_provjeri_rnk' || gas_cvor_l || '(NULL, :rnk_nema_u_gas_l); END;';
    EXECUTE IMMEDIATE naredba_l USING OUT rnk_nema_u_gas_l;
    IF rnk_nema_u_gas_l IS NOT NULL THEN   
    -- rnk kojih nema u GAS prikazati pod RNKPKA po kasama
      -- najprije preuzeti pripremjene podatke u vlastiti prec_global
      IF gas_cvor_l IS NOT NULL THEN
        DELETE FROM prec_global;
        naredba_l := 'INSERT INTO prec_global ' ||
              '                SELECT * FROM prec_global' || gas_cvor_l ||
              '                 WHERE id2 <> -1';               -- ozn_ima_u_gas
      EXECUTE IMMEDIATE naredba_l;
      END IF;                                                                      
      

      FOR rnk_c IN 
        (SELECT pkarnk.gmpkas_id gmpkas_id,
                pkarnkpdv.vpispz_id,
                SUM (pkarnk.izn_placanja * recglo.iznos2) -   SUM (pkarnkpdv.izn_pdv * recglo.iznos2) izn_prihoda,
                SUM (0) izn_ppot,
                SUM (pkarnkpdv.izn_pdv * recglo.iznos2) izn_pdv
           FROM prec_global recglo, tpka_rnkasa pkarnk,
                (SELECT pkarnk_id, vpispz_id, SUM (izn_pdv) izn_pdv FROM ipka_rnk_pdv GROUP BY pkarnk_id, vpispz_id) pkarnkpdv
          WHERE recglo.id2 <> -1
            AND recglo.opis2 = pkarnk.god_poslovna_izvor AND recglo.id1 = pkarnk.gmpkas_id_izvor
            AND recglo.opis3 = pkarnk.rbr_izvor
            AND pkarnk.id = pkarnkpdv.pkarnk_id
          GROUP BY pkarnk.gmpkas_id, pkarnkpdv.vpispz_id
          UNION ALL
          --samo PPOT
          SELECT pkarnk.gmpkas_id gmpkas_id,
                NULL  vpispz_id,
                SUM (pkarnk.izn_ppot * recglo.iznos2* -1) izn_prihoda,
                SUM (pkarnk.izn_ppot * recglo.iznos2) izn_ppot,
                SUM (0) izn_pdv
           FROM prec_global recglo, tpka_rnkasa pkarnk
          WHERE recglo.id2 <> -1
            AND recglo.opis2 = pkarnk.god_poslovna_izvor AND recglo.id1 = pkarnk.gmpkas_id_izvor
            AND recglo.opis3 = pkarnk.rbr_izvor
          GROUP BY pkarnk.gmpkas_id
        )
      LOOP
          INSERT INTO prec_global2 (
                datum1 -- datum
                ,opis1 -- oj_sifra
                ,opis2 -- ozn_izvora(USL, RNKPKA, RNKGAS)
                ,opis3 -- ozn_vracuna
                ,opis4 -- rac_rbr
                ,id6 -- so_id (usl) / mt_id (rnkgas) / gmpkas_id (rnkpka)  
                ,id7  -- vpispz_id
                ,id2 -- szur_id (usl) / knjigo_id (rnkgas) / null (rnkpka)
                ,iznos1 -- izn_prihoda
                ,iznos2  -- izn_pdv
                ,iznos3  -- izn_ppot
            )
            VALUES (
               rac_c.datum, rac_c.oj_sifra, 'RNKPKA', rac_c.ozn_vracuna, rac_c.rac_rbr,
               rnk_c.gmpkas_id, rnk_c.vpispz_id, NULL,
               rnk_c.izn_prihoda, rnk_c.izn_pdv, rnk_c.izn_ppot
            );
      
      END LOOP;
    END IF;
    -- KRAJ rnk kojih nema u GAS knjiiti prikazati pod RNKPKA po kasam	
   
    --- za rnk koji jesu u GAS (id2 = -1) 
    
    naredba_l := 'BEGIN pra_pka_fin.lc_knj_recrac_pripremi_rnk' ||gas_cvor_l||'(:oj_id_p,:rac_c.datum, :rac_c.ozn_vracuna, :rac_c.oj_sifra); END;';
    EXECUTE IMMEDIATE naredba_l USING oj_id_p, rac_c.datum, rac_c.ozn_vracuna, rac_c.oj_sifra;
    
     ---  KRAJ za rnk koji jesu u GAS (id2 = -1) 
 
  END LOOP; -- rac_c

  -- na kraju preuzeti pripremjene GAS podatke (za sve raune) u vlastiti prec_global2
  IF gas_cvor_l IS NOT NULL THEN
    naredba_l := 'INSERT INTO prec_global2 ' ||
    '                    SELECT * FROM prec_global2' || gas_cvor_l;
    EXECUTE IMMEDIATE naredba_l;
  END IF;
  
        INSERT INTO prec_global2  (datum1, opis1, opis2, opis3, opis4,  id3, id4, id5, id6, id7,  iznos1, iznos2, iznos3 )
           SELECT rnpro.datum,
                 NVL(gmpkassus.sifra,gmpkas.sifra),
                 'RNKGAS',
                 DECODE(SIGN(suma.iznos),-1,'POSN','POS'),
                 rnpro.rbr,
                 rnpro.mt_id,
                 rnpro.gknji_id,
                 nac.gnac_id,
                 rnpro.kase_id,
                 rnpro.vpispz_id,
                 SUM(rnpro.iznos - rnpro.iznos_pdv - rnpro.iznos_ppot) iznos,
                 SUM(rnpro.iznos_pdv ) iznos_pdv,
                 SUM(rnpro.iznos_ppot) iznos_ppot
            FROM /*t_rnkase rn,
                 t_rnkase_pro rnpro,*/
                 v_rnkase_pro_vpla rnpro,                 
                 m_nacpot nac,
                 m_mt mt,
                (SELECT rn_id, SUM(iznos) iznos
                   FROM t_rnkase_pro GROUP BY rn_id) suma,
                 mzmp_gmpkas_sus gmpkassus,
                 szmp_sustavi sus,
                 s_vplacanja vpla,
                 mgmp_kase gmpkas
           WHERE rnpro.datum  BETWEEN dat_poc_p AND dat_zav_p
             AND pra_zmp.oj_pripada_oj (rnpro.mt_id, NVL(oj_id_p,rnpro.mt_id)) = -1
            /* AND rn.id = rnpro.rn_id*/
             AND rnpro.nac_id = nac.id
             AND rnpro.mt_id = mt.id
             AND suma.rn_id = rnpro.id
             AND rnpro.vpla_id = vpla.id
             AND vpla.ozn_irn IS NULL   -- svi rauni koji nisu na REC ili PKA raunu
             AND vpla.ozn_rnk_r <> -1
             AND gmpkassus.zmpsus_id = sus.id(+)
             AND gmpkassus.gmpkas_id = rnpro.kase_id(+)
             AND (UPPER(sus.sifra) = UPPER(pra_zmp_zaj.zmppar_vrijednost('PKA', '1049'))
                  OR   pra_zmp_zaj.zmppar_vrijednost('PKA', '1049') = 'nebitno')
             AND rnpro.kase_id = gmpkas.id
             AND ozn_pos_p = -1
           GROUP BY rnpro.datum,
                     NVL(gmpkassus.sifra,gmpkas.sifra),
                    'RNKGAS',
                    DECODE(SIGN(suma.iznos),-1,'POSN','POS'),
                    rnpro.rbr,
                    rnpro.mt_id,
                    rnpro.gknji_id,
                    nac.gnac_id,
                    rnpro.kase_id,
                    rnpro.vpispz_id;

END;
PROCEDURE LC_KNJ_POS
 (GUID_P IN LPKA_RAC_FIN.GUID%TYPE
 )
 IS
--
  rbr_stavke_l NUMBER := 0;
BEGIN
 
  INSERT INTO prec_global2 (opis1, opis2, datum1, opis4, opis5, opis6, iznos1, iznos2, opis7) -- zc
       SELECT ozn_vracuna,
            guid_p,
            gasknjpom.datum,
            zmpkonpoz.pozicija,
            zmpkon.sifra,
            oj.sifra,
            SUM (DECODE (gaspknj.dug_pot_1, 'D', gasknjpom.iznos * DECODE(gaspknj.predznak_1,'+',1,-1), 0)) duguje,
            SUM (DECODE (gaspknj.dug_pot_1, 'P', gasknjpom.iznos * DECODE(gaspknj.predznak_1,'+',1,-1), 0)) potrazuje,
            gaspknj.gasoknj_naziv   gasoknj_naziv
       FROM (SELECT pkaracfin.ozn_vracuna ozn_vracuna, mt_id, opisi.id gasoknj_id,
                    DECODE(opisi.sifra, '0010', gnac_id, NULL) gnac_id,
                    DECODE(opisi.sifra, '0010', gknji_id, NULL) gknji_id,
                    SUM(DECODE(opisi.sifra, '0010', (rnpro.iznos - rnpro.iznos_pdv - rnpro.iznos_ppot),
                                            '0111', rnpro.iznos_pdv,
                                            '0112', rnpro.iznos_pdv,
                                            '0113', rnpro.iznos_pdv,
                                            '0120', rnpro.iznos_ppot)) iznos,
                    DECODE(opisi.sifra, '0010', mt.vrsta, 'H') vrsta,
                    rnpro.datum datum
               FROM /*t_rnkase rn,
                    t_rnkase_pro rnpro,*/
                    v_rnkase_pro_vpla rnpro,
                    (SELECT rn_id, SUM(iznos) iznos FROM t_rnkase_pro GROUP BY rn_id) suma,
                    s_vplacanja vpla,
                    s_vpplacanja vppla,
                    sgas_opisi_knjizenja opisi,
                    lpka_rac_fin pkaracfin,
                    mzmp_gmpkas_sus gmpkassus,
                    szmp_sustavi sus,
                    m_nacpot nac,
                    m_mt mt
              WHERE rnpro.datum  = pkaracfin.datum
                /*AND rn.id = rnpro.rn_id*/
                AND gmpkassus.zmpsus_id = sus.id
                AND gmpkassus.gmpkas_id = rnpro.kase_id
                AND pkaracfin.ozn_uk    = gmpkassus.sifra
                AND sus.sifra = 'LIBUSOFT'
                AND rnpro.mt_id = mt.id
                AND rnpro.id = suma.rn_id
                AND (pkaracfin.ozn_vracuna = 'POS' AND suma.iznos >= 0
                    OR pkaracfin.ozn_vracuna = 'POSN' AND suma.iznos < 0)
                AND rnpro.vpla_id = vpla.id
                AND vpla.vppla_id = vppla.id
                AND (vppla.sifra <> 'X' OR  INSTR (pra_zmp_zaj.vrijednost_parametra ('0033'), vpla.sifra ) > 0)
                AND rnpro.nac_id = nac.id
                AND rnpro.mt_id = mt.id
                AND pkaracfin.guid = guid_p
                AND (INSTR(opisi.naziv,DECODE(LENGTH(rnpro.pdv),1, ' '||rnpro.pdv, rnpro.pdv)) > 0 
                     AND opisi.sifra IN ('0111', '0112', '0113') OR opisi.sifra IN ('0010', '0120'))
              GROUP BY
                    pkaracfin.ozn_vracuna,
                    mt_id,
                    opisi.id,
                    DECODE(opisi.sifra, '0010', gnac_id, NULL),
                    DECODE(opisi.sifra, '0010', gknji_id, NULL),
                    DECODE(opisi.sifra, '0010', mt.vrsta, 'H'),
                    rnpro.datum)
            gasknjpom,
            v_mgas_pravila gaspknj,
            m_oj oj,
            mzmp_konta zmpkon,
            mzmp_kon_poz zmpkonpoz
      WHERE gasknjpom.iznos <> 0
        AND NVL (gaspknj.ojk_id, gasknjpom.mt_id)  = oj.id
        AND (gaspknj.vrsta_mt = 'H' OR  gaspknj.vrsta_mt = gasknjpom.vrsta)
        AND gaspknj.gasoknj_id = gasknjpom.gasoknj_id
        AND zmpkon.id = gaspknj.zmpkon1_id
        AND NVL (gasknjpom.gknji_id, 0) =  NVL (gaspknj.gknji_id, 0)
        AND NVL (gasknjpom.gnac_id, 0)  =  NVL (gaspknj.gnac_id, 0)
        AND pra_zmp.oj_pripada_oj (gasknjpom.mt_id, gaspknj.oj_id) = -1
        AND zmpkon.id = zmpkonpoz.zmpkon_id (+)
        AND NVL(zmpkonpoz.god_poslovna,to_char(gasknjpom.datum,'RRRR')) = to_char(gasknjpom.datum,'RRRR')
      GROUP BY ozn_vracuna,  guid_p,  gasknjpom.datum, zmpkonpoz.pozicija, zmpkon.sifra, oj.sifra, gaspknj.gasoknj_naziv
      UNION ALL
     SELECT ozn_vracuna,
            guid_p,
            gasknjpom.datum,
            zmpkonpoz.pozicija,
            zmpkon.sifra,
            oj.sifra,
            SUM (DECODE (gaspknj.dug_pot_1, 'D', gasknjpom.iznos * DECODE(gaspknj.predznak_1,'+',1,-1), 0)) duguje,
            SUM (DECODE (gaspknj.dug_pot_1, 'P', gasknjpom.iznos * DECODE(gaspknj.predznak_1,'+',1,-1), 0)) potrazuje,
            gaspknj.gasoknj_naziv   gasoknj_naziv
       FROM (SELECT pkaracfin.ozn_vracuna ozn_vracuna,
                    mt_id, opisi.id gasoknj_id,
                    DECODE(opisi.sifra, '0010', gnac_id, NULL) gnac_id,
                    DECODE(opisi.sifra, '0010', gknji_id, NULL) gknji_id,
                    SUM(DECODE(opisi.sifra, '0010', (rnpro.iznos - rnpro.iznos_pdv - rnpro.iznos_ppot),
                                            '0111', rnpro.iznos_pdv,
                                            '0112', rnpro.iznos_pdv,
                                            '0113', rnpro.iznos_pdv,
                                            '0120', rnpro.iznos_ppot)) iznos,
                    mt.vrsta,
                    rnpro.datum datum
               FROM /*t_rnkase rn,
                    t_rnkase_pro rnpro,*/
                    v_rnkase_pro_vpla rnpro,
                   (SELECT rn_id, SUM(iznos) iznos FROM t_rnkase_pro GROUP BY rn_id) suma,
                    s_vplacanja vpla,
                    s_vpplacanja vppla,
                    sgas_opisi_knjizenja opisi,
                    lpka_rac_fin pkaracfin,
                    mzmp_gmpkas_sus gmpkassus,
                    szmp_sustavi sus,
                    m_nacpot nac,
                    m_mt mt
              WHERE rnpro.datum  = pkaracfin.datum
             /*   AND rn.id = rnpro.rn_id*/
                AND rnpro.id = suma.rn_id
                AND gmpkassus.zmpsus_id = sus.id
                AND gmpkassus.gmpkas_id = rnpro.kase_id
                AND pkaracfin.ozn_uk    = gmpkassus.sifra
                AND sus.sifra = 'LIBUSOFT'
                AND rnpro.mt_id = mt.id
                AND rnpro.vpla_id = vpla.id
                AND vpla.vppla_id = vppla.id
                AND (vppla.sifra <> 'X' OR  INSTR (pra_zmp_zaj.vrijednost_parametra ('0033'), vpla.sifra ) > 0)
                AND (pkaracfin.ozn_vracuna = 'POS' AND suma.iznos >= 0   OR pkaracfin.ozn_vracuna = 'POSN' AND suma.iznos < 0)
                AND rnpro.nac_id = nac.id
                AND rnpro.mt_id = mt.id
                AND pkaracfin.guid = guid_p
                AND (INSTR(opisi.naziv,DECODE(LENGTH(rnpro.pdv),1, ' '||rnpro.pdv, rnpro.pdv)) > 0 
                     AND opisi.sifra IN ('0111', '0112', '0113') OR opisi.sifra IN ('0010', '0120'))
              GROUP BY
                    pkaracfin.ozn_vracuna,
                    mt_id,
                    opisi.id,
                    DECODE(opisi.sifra, '0010', gnac_id, NULL),
                    DECODE(opisi.sifra, '0010', gknji_id, NULL),
                    mt.vrsta,
                    rnpro.datum)
                gasknjpom,
                v_mgas_pravila gaspknj,
                m_oj oj,
                mzmp_konta zmpkon,
                mzmp_kon_poz zmpkonpoz
          WHERE gasknjpom.iznos <> 0
            AND gaspknj.zmpkon2_id IS NOT NULL
            AND zmpkon.id = gaspknj.zmpkon2_id
            AND (gaspknj.vrsta_mt = 'H' OR  gaspknj.vrsta_mt = gasknjpom.vrsta)
            AND gaspknj.gasoknj_id = gasknjpom.gasoknj_id
            AND NVL (gaspknj.ojk_id, gasknjpom.mt_id)  = oj.id
            AND NVL (gasknjpom.gknji_id, 0) =  NVL (gaspknj.gknji_id, 0)
            AND NVL (gasknjpom.gnac_id, 0)  =  NVL (gaspknj.gnac_id, 0)
            AND pra_zmp.oj_pripada_oj (gasknjpom.mt_id, gaspknj.oj_id) = -1
            AND zmpkon.id = zmpkonpoz.zmpkon_id (+)
            AND NVL(zmpkonpoz.god_poslovna,to_char(gasknjpom.datum,'RRRR')) = to_char(gasknjpom.datum,'RRRR')
      GROUP BY ozn_vracuna, guid_p,  gasknjpom.datum, zmpkonpoz.pozicija, zmpkon.sifra, oj.sifra, gaspknj.gasoknj_naziv
       UNION ALL
      SELECT ozn_vracuna,
            guid_p,
            gasknjpom.datum,
            zmpkonpoz.pozicija,
            zmpkon.sifra,
            gasknjpom.oj_sifra,
            SUM (DECODE (gaspknj.dug_pot_1, 'D', gasknjpom.iznos * DECODE(gaspknj.predznak_1,'+',1,-1), 0)) duguje,
            SUM (DECODE (gaspknj.dug_pot_1, 'P', gasknjpom.iznos * DECODE(gaspknj.predznak_1,'+',1,-1), 0)) potrazuje,
           'NAPLATA'  gasoknj_naziv
       FROM (SELECT pkaracfin.ozn_vracuna ozn_vracuna,
                    opisi.id gasoknj_id,
                    rnpro.vpla_id,
                    SUM(rnpro.iznos) iznos,
                    rnpro.datum datum,
                    gmpkassus.sifra oj_sifra
               FROM /*t_rnkase rn,
                    t_rnkase_pro rnpro,*/
                    v_rnkase_pro_vpla rnpro,
                    (SELECT rn_id, SUM(iznos) iznos FROM t_rnkase_pro GROUP BY rn_id) suma,
                    s_vplacanja vpla,
                    s_vpplacanja vppla,
                    sgas_opisi_knjizenja opisi,
                    lpka_rac_fin pkaracfin,
                    mzmp_gmpkas_sus gmpkassus,
                    szmp_sustavi sus
              WHERE rnpro.datum  = pkaracfin.datum
               /* AND rn.id = rnpro.rn_id*/
                AND gmpkassus.zmpsus_id = sus.id
                AND gmpkassus.gmpkas_id = rnpro.kase_id
                AND pkaracfin.ozn_uk    = gmpkassus.sifra
                AND sus.sifra = 'LIBUSOFT'
                AND rnpro.vpla_id = vpla.id
                AND vpla.vppla_id = vppla.id
                AND (vppla.sifra <> 'X' OR  INSTR (pra_zmp_zaj.vrijednost_parametra ('0033'), vpla.sifra ) > 0)
                AND rnpro.id = suma.rn_id
                AND (pkaracfin.ozn_vracuna = 'POS' AND suma.iznos >= 0
                  OR pkaracfin.ozn_vracuna = 'POSN' AND suma.iznos < 0)
                AND pkaracfin.guid = guid_p
                AND opisi.sifra IN ('0700')
              GROUP BY
                    pkaracfin.ozn_vracuna,
                    opisi.id,
                    rnpro.vpla_id,
                    rnpro.datum,
                    gmpkassus.sifra)
                gasknjpom,
                mgas_pravila_vpla gaspknj,
                mzmp_konta zmpkon,
                mzmp_kon_poz zmpkonpoz
          WHERE gasknjpom.iznos <> 0
            AND gaspknj.zmpkon1_id IS NOT NULL
            AND gaspknj.vpla_id = gasknjpom.vpla_id
            AND zmpkon.id = gaspknj.zmpkon1_id
            AND gaspknj.gasoknj_id = gasknjpom.gasoknj_id
            AND zmpkon.id = zmpkonpoz.zmpkon_id (+)
            AND NVL(zmpkonpoz.god_poslovna,to_char(gasknjpom.datum,'RRRR')) = to_char(gasknjpom.datum,'RRRR')
      GROUP BY ozn_vracuna, guid_p,  gasknjpom.datum, zmpkonpoz.pozicija, zmpkon.sifra,  gasknjpom.oj_sifra, 'NAPLATA'; 
   
      DELETE FROM  prec_global2 WHERE opis2 = guid_p AND NVL (iznos1, 0) = 0 AND NVL (iznos2, 0) = 0;
      
      /* provjera salda temeljnice te korigiranje na potranoj strani (konto prihoda), oj najvia iz vlasnika.
       */
      INSERT INTO prec_global2 (opis1, opis2, datum1, opis4, opis5, opis6, iznos1, iznos2, opis7) 
      SELECT 'POS', guid_p, MIN(datum1) datum,  MIN(zmpkonpoz.pozicija), MIN(zmpkon.sifra), MIN (oj.sifra), 0, SUM(iznos1 - iznos2), 'saldiranje'
        FROM prec_global2,
            (SELECT pra_zmp_zaj.zmppar_vrijednost ('LIBUSOFT', '1006') sifra FROM dual) konto,
             mzmp_kon_poz zmpkonpoz,
             mzmp_konta zmpkon,
             sgas_vlasnik vlasnik,
             m_oj oj 
       WHERE opis2 =  guid_p
         AND konto.sifra = zmpkon.sifra   
         AND NVL(zmpkonpoz.god_poslovna,to_char(datum1,'RRRR')) = to_char(datum1,'RRRR') 
         AND oj.id = vlasnik.oj_id 
      HAVING SUM(NVL(iznos1,0) - NVL(iznos2,0)) <> 0
       GROUP BY guid_p;

      pra_pka_fin.lc_knj_pos_preknjizavanje(guid_p);
      
      /* update rednog broja stavke */
      rbr_stavke_l := 0;
      FOR recglo2_c IN
         (SELECT recglo2.rowid rid
            FROM prec_global2 recglo2
           WHERE recglo2.opis2 = guid_p 
           ORDER BY opis1, opis6, opis5
             FOR UPDATE OF recglo2.opis3 NOWAIT) 
      LOOP
         rbr_stavke_l := rbr_stavke_l + 1;
         UPDATE prec_global2 
            SET opis3 = TO_CHAR (rbr_stavke_l) 
          WHERE rowid = recglo2_c.rid;
      END LOOP;         
  END;
PROCEDURE LC_KNJ_RECRAC_PRIPREMI_RNK
 (OJ_ID_P IN M_OJ.ID%TYPE
 ,DATUM_P IN TPKA_RNKASA.DATUM%TYPE
 ,OZN_VRACUNA_P IN LPKA_RAC_FIN.OZN_VRACUNA%TYPE
 ,OJ_SIFRA_P IN M_OJ.SIFRA%TYPE
 )
 IS
/* MK IRN 2988
BEGIN
  INSERT INTO prec_global2  (datum1, opis1, opis2, opis3, opis4, id3, id4, id5, id6, id7, iznos1, iznos2, iznos3)
    SELECT datum_p,
           oj_sifra_p,
           'RNKGAS',
           ozn_vracuna_p,
           rnpro.rbr,
           rnpro.mt_id,
           rnpro.gknji_id,
           nac.gnac_id,
           rnpro.kase_id,
           rnpro.vpispz_id,
           SUM((rnpro.iznos  - rnpro.iznos_pdv - rnpro.iznos_ppot)   * recrnk.iznos2) iznos,
           SUM(rnpro.iznos_pdv  * recrnk.iznos2) iznos_pdv,
           SUM(rnpro.iznos_ppot * recrnk.iznos2) iznos_ppot
      FROM --t_rnkase rn,
           --t_rnkase_pro rnpro,
           v_rnkase_pro_vpla rnpro,
           prec_global recrnk,
           m_nacpot nac
     WHERE rnpro.datum  = recrnk.datum1
           AND pra_zmp.oj_pripada_oj (rnpro.mt_id, NVL(oj_id_p,rnpro.mt_id)) = -1
           AND rnpro.kase_id =  recrnk.id1
           AND rnpro.rbr = SUBSTR(recrnk.opis3,1,6)
           AND rnpro.godina = SUBSTR(recrnk.opis2,1,4)
         --  AND rn.id = rnpro.rn_id
           AND rnpro.nac_id = nac.id
           AND recrnk.id2 = -1
     GROUP BY datum_p,
              oj_sifra_p,
              'RNKGAS',
              ozn_vracuna_p,
              rnpro.rbr,
              rnpro.mt_id,
              rnpro.gknji_id,
              nac.gnac_id,
              rnpro.kase_id,
              rnpro.vpispz_id;
END;
*/
  dat_rnk_min_l DATE;
  dat_rnk_max_l DATE;
BEGIN
  SELECT MIN (datum1), MAX (datum1) INTO dat_rnk_min_l, dat_rnk_max_l FROM prec_global;
  -- treba ograniiti select na v_rnkase_pro_vpla jer je inae presporo. Trai se razdoble RNK za taj raun i ograniava view na njega
  IF dat_rnk_min_l IS NOT NULL THEN
    INSERT INTO prec_global2 (datum1, opis1, opis2, opis3, opis4, id3, id4, id5, id6, id7, iznos1, iznos2, iznos3)
    SELECT datum_p,
           oj_sifra_p,
           'RNKGAS',
           ozn_vracuna_p,
           rnpro.rbr,
           rnpro.mt_id,
           rnpro.gknji_id,
           nac.gnac_id,
           rnpro.kase_id,
           rnpro.vpispz_id,
           SUM ((rnpro.iznos - rnpro.iznos_pdv - rnpro.iznos_ppot) * recrnk.iznos2) iznos,
           SUM (rnpro.iznos_pdv  * recrnk.iznos2) iznos_pdv,
           SUM (rnpro.iznos_ppot * recrnk.iznos2) iznos_ppot
      FROM -- t_rnkase rn,
           -- t_rnkase_pro rnpro,
           (SELECT * FROM v_rnkase_pro_vpla WHERE datum BETWEEN dat_rnk_min_l and dat_rnk_max_l) rnpro,
           prec_global recrnk,
           m_nacpot nac
     WHERE rnpro.datum = recrnk.datum1
           -- IRN 2988 - maknuta provjera mt-oj jer treba uzeti sav promet za RNK po RECRAC neoviso o MT
           -- AND pra_zmp.oj_pripada_oj (rnpro.mt_id, NVL (oj_id_p, rnpro.mt_id)) = -1
           AND rnpro.kase_id =  recrnk.id1
           AND rnpro.rbr = SUBSTR (recrnk.opis3, 1, 6)
           AND rnpro.godina = SUBSTR (recrnk.opis2, 1, 4)
           --  AND rn.id = rnpro.rn_id
           AND rnpro.nac_id = nac.id
           AND recrnk.id2 = -1
      GROUP BY datum_p,
               oj_sifra_p,
               'RNKGAS',
               ozn_vracuna_p,
               rnpro.rbr,
               rnpro.mt_id,
               rnpro.gknji_id,
               nac.gnac_id,
               rnpro.kase_id,
               rnpro.vpispz_id;
  END IF;
END;
PROCEDURE ZABRANI_IZMJENU_GASRNK
 (KASE_ID_P IN MGMP_KASE.ID%TYPE
 ,DATUM_P IN DATE
 )
 IS
--
  brojac_l NUMBER := 0;
BEGIN  
  SELECT COUNT(*) INTO brojac_l 
    FROM mzmp_gmpkas_sus gmpkassus,
         szmp_sustavi sus,
         lpka_rac_fin pkaracfin 
   WHERE gmpkassus.zmpsus_id = sus.id
     AND gmpkassus.gmpkas_id = kase_id_p
     AND pkaracfin.ozn_uk    = gmpkassus.sifra
     AND pkaracfin.datum = datum_p
     AND sus.sifra = 'LIBUSOFT';
  IF brojac_l > 0 THEN
    RAISE_APPLICATION_ERROR (-20000,  'Nije dozvoljeno auriranje prometa jer je napravljen prijepis rauna - LIBUSOFT');
  END IF;
END;
PROCEDURE LC_DOHVATI_STAVKE_KONTIRANJA
 (GUID_P IN LPKA_RAC_FIN.GUID%TYPE
 )
 IS
/*
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:v0="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1">
   <soapenv:Header/>
   <soapenv:Body>
      <v0:dohvatiStavkeKontiranjaDokumenataRequest>
         <v0:VsID>?</v0:VsID>
         <v0:Godina>?</v0:Godina>
         <v0:dokumenti>
            <v0:dokument>
               <v0:DokGUID>?</v0:DokGUID>
            </v0:dokument>
         </v0:dokumenti>
      </v0:dohvatiStavkeKontiranjaDokumenataRequest>
   </soapenv:Body>
</soapenv:Envelope>
*/
  upit_l         XMLTYPE;
BEGIN

  data_m := NULL;
  odgovor_m := NULL;

  SELECT xmlelement("v0:dokumenti",
           xmlattributes('http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1' "xmlns:v0"),
           xmlconcat(
             extract(upit_l, 'v0:dokumenti/v0:dokument',
                             'xmlns:v0="http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1"'),
             xmlelement("v0:dokument",
               xmlelement("v0:DokGUID", guid_p)
             )    
           )
         )
    INTO upit_l
    FROM DUAL;

  IF upit_l IS NOT NULL THEN

    SELECT xmlelement("soapenv:Envelope",
             xmlattributes('http://schemas.xmlsoap.org/soap/envelope/' "xmlns:soapenv",
                           'http://www.spi.hr/ws/razmjena/sc/razmjenarp/v0.1' "xmlns:v0"),
             xmlelement("soapenv:Header", NULL),
             xmlelement("soapenv:Body",
               xmlelement("v0:dohvatiStavkeKontDokReq",
                 xmlelement("v0:VsID",'ISTRATECH_SC'),
                 xmlelement("v0:Godina", TO_CHAR(TRUNC (SYSDATE), 'rrrr')),
                 upit_l
               )
             )
           )
      INTO upit_l
      FROM DUAL;

    data_m := upit_l.getClobVal();

    SELECT REPLACE(data_m,
                   'dohvatiStavkeKontDokReq', 'dohvatiStavkeKontiranjaDokumenataRequest')
      INTO data_m
      FROM dual;

    lc_zaj_post;

  END IF;

END;
PROCEDURE LC_KNJ_POS_PREKNJIZAVANJE
 (GUID_P IN LPKA_RAC_FIN.GUID%TYPE
 )
 IS
--
  konto_id_l NUMBER;
  konto2_id_l NUMBER;
  konto2_sifra_l mzmp_konta.sifra%TYPE;
BEGIN
  FOR prec_global2_c IN (SELECT * FROM prec_global2 WHERE opis2 = guid_p) LOOP
    konto_id_l := NULL;
    konto2_id_l := NULL;
    konto2_sifra_l := NULL;

    IF NVL (prec_global2_c.iznos2, 0) <> 0 THEN
      IF prec_global2_c.opis5 IS NOT NULL THEN -- konto
        SELECT id INTO konto_id_l FROM mzmp_konta WHERE sifra = prec_global2_c.opis5;
        BEGIN
          SELECT zmpkon2_id INTO konto2_id_l
            FROM mzmp_kon_poz
           WHERE zmpkon_id = konto_id_l
             AND god_poslovna = TO_CHAR (prec_global2_c.datum1, 'RRRR');
        EXCEPTION
          WHEN OTHERS THEN
            NULL;
        END;

        IF konto2_id_l IS NOT NULL THEN -- za konto je u zmpkonpoz upisan zmpkon2_id
          SELECT sifra INTO konto2_sifra_l FROM mzmp_konta WHERE id = konto2_id_l;

          -- kreira se redak za taj isti konto ali sa iznos1 = prethodnom iznos2, iznos2 = 0
          INSERT INTO prec_global2 (opis1, opis2, datum1, opis4, opis5, opis6, iznos1, iznos2, opis7)
            VALUES (prec_global2_c.opis1,
                    prec_global2_c.opis2,
                    prec_global2_c.datum1,
                    prec_global2_c.opis4,
                    prec_global2_c.opis5,
                    prec_global2_c.opis6,
                    prec_global2_c.iznos2,
                    0,
                    prec_global2_c.opis7);

          -- kreira se redak za konto2 sa iznos1 = 0 i iznos2 = prethodnom iznos2
          INSERT INTO prec_global2 (opis1, opis2, datum1, opis4, opis5, opis6, iznos1, iznos2, opis7)
            VALUES (prec_global2_c.opis1,
                    prec_global2_c.opis2,
                    prec_global2_c.datum1,
                    prec_global2_c.opis4,
                    konto2_sifra_l,
                    prec_global2_c.opis6,
                    0,
                    prec_global2_c.iznos2,
                    prec_global2_c.opis7);
        END IF;
      END IF;
    END IF;
  END LOOP;
END;
PROCEDURE LC_KNJ_RECRAC_PREKNJIZAVANJE
 (GUID_P IN LPKA_RAC_FIN.GUID%TYPE
 ,DATUM_P IN LPKA_RAC_FIN.DATUM%TYPE
 ,OZN_VRACUNA_P IN LPKA_RAC_FIN.OZN_VRACUNA%TYPE
 )
 IS
--
  oznaka_l s_vapldok.oznaka%type;
  konto_id_l NUMBER;
  konto2_id_l NUMBER;
  konto2_sifra_l mzmp_konta.sifra%type;
BEGIN
  IF ozn_vracuna_p = 'RECBI' THEN
    BEGIN
      SELECT vapldok.oznaka INTO oznaka_l
        FROM t_racuni rac, s_vapldok vapldok
       WHERE rac.vapldok_id = vapldok.id
         AND rac.guid = guid_p;
    EXCEPTION
      WHEN OTHERS THEN
        NULL;
    END;
  END IF;

  IF ozn_vracuna_p IN ('RECGI', 'RECGIN') OR (ozn_vracuna_p = 'RECBI' AND NVL (oznaka_l, 'XX') = 'BV') THEN
    NULL;    -- treba preknjiiti
  ELSE
    RETURN;  -- ne preknjiava se
  END IF;

  FOR prec_global2_c IN (SELECT * FROM prec_global2 WHERE opis2 = guid_p) LOOP
    konto_id_l := NULL;
    konto2_id_l := NULL;
    konto2_sifra_l := NULL;

    IF NVL (prec_global2_c.iznos2, 0) <> 0 THEN
      IF prec_global2_c.opis5 IS NOT NULL THEN -- konto
        SELECT id INTO konto_id_l FROM mzmp_konta WHERE sifra = prec_global2_c.opis5;
        BEGIN
          SELECT zmpkon2_id INTO konto2_id_l
            FROM mzmp_kon_poz
           WHERE zmpkon_id = konto_id_l
             AND god_poslovna = TO_CHAR (datum_p, 'RRRR');
        EXCEPTION
          WHEN OTHERS THEN
            NULL;
        END;
        IF konto2_id_l IS NOT NULL THEN -- za konto je u zmpkonpoz upisan zmpkon2_id
          SELECT sifra INTO konto2_sifra_l FROM mzmp_konta WHERE id = konto2_id_l;

          -- kreira se redak za taj isti konto ali sa iznos1 = prethodnom iznos2, iznos2 = 0
          INSERT INTO prec_global2 (opis1, opis2, opis3, opis4, opis5, opis6, iznos1, iznos2, opis7)
            VALUES (prec_global2_c.opis1,
                    prec_global2_c.opis2,
                    prec_global2_c.opis3,
                    prec_global2_c.opis4,
                    prec_global2_c.opis5,
                    prec_global2_c.opis6,
                    prec_global2_c.iznos2,
                    0,
                    prec_global2_c.opis7);

          -- kreira se redak za konto2 sa iznos1 = 0 i iznos2 = prethodnom iznos2
          INSERT INTO prec_global2 (opis1, opis2, opis3, opis4, opis5, opis6, iznos1, iznos2, opis7)
            VALUES (prec_global2_c.opis1,
                    prec_global2_c.opis2,
                    prec_global2_c.opis3,
                    prec_global2_c.opis4,
                    konto2_sifra_l,
                    prec_global2_c.opis6,
                    0,
                    prec_global2_c.iznos2,
                    prec_global2_c.opis7);

        END IF;
      END IF;
    END IF;
  END LOOP;
END;
PROCEDURE VIR2_PUNI_REPL_V_PSPP_RACUNI
 (DAT_POC_P IN LPKA_PRIJEPISI_FIN.DAT_POC%TYPE
 ,DAT_ZAV_P IN LPKA_PRIJEPISI_FIN.DAT_ZAV%TYPE
 )
 IS
--
  brojac_l NUMBER;
  naredba_l VARCHAR2 (4000);
  vlasnikpodatka_mish_l NUMBER;
  vlasnikpodatka_fin_l NUMBER;
BEGIN
  -- punjenje zone iz vlasnika mish u vlasnika fin
  -- ako nije multitenant za VP 234 izlazi
  IF SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') IS NULL
    OR SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') <> 234
  THEN
    RETURN;
  END IF;
  vlasnikpodatka_mish_l := 234; -- mpgrestoran
  vlasnikpodatka_fin_l := 210;  -- mpg
  FOR pspprac_c IN (
    SELECT *
      FROM v_pspp_racuni rac
     WHERE rac.datum BETWEEN dat_poc_p AND dat_zav_p
    )
  LOOP
    -- u zonu dolaze rauni sa shema koje nisu na virgi pa bi se teoretski mogli id-jevi preklopiti
    -- i treba u uvjetu staviti vlasnikapodatka
    naredba_l := 'SELECT COUNT(1) FROM zona.repl_v_pspp_racuni
                   WHERE id = :pspprac_c_id AND vlasnikpodatka = :vlasnikpodatka_fin_l';
    EXECUTE IMMEDIATE naredba_l INTO brojac_l USING pspprac_c.id, vlasnikpodatka_fin_l;

    IF brojac_l = 0 THEN
      naredba_l :=
      'INSERT INTO zona.repl_v_pspp_racuni (
          virgarepl_status
          , vlasnikpodatka
          , id
          , pod_sifra
          , oznaka
          , god_poslovna
          , oj_sifra
          , vapldok_oznaka
          , rbr
          , rac_id
          , datum
          , iznos
          , so_sifra
          , kd_sifra
          , posred_sifra
          , age_sifra
          , konto
          , stopa_zkamate
          , val_sifra
          , dat_dospijeca
          , dat_nobveze
          , izn_predujma
          , izn_odbitka
          , izn_tecaja
          , izn_domval
          , izn_bp
          , izn_osn_1
          , izn_osn_1_racval
          , izn_osn_2
          , izn_osn_2_racval
          , izn_osn_3
          , izn_osn_3_racval
          , izn_osn_4
          , izn_osn_4_racval
          , izn_osn_5
          , izn_osn_5_racval
          , izn_osn_ost
          , izn_osn_ost_racval
          , izn_pdv_3
          , izn_pdv_3_racval
          , izn_pdv_4
          , izn_pdv_4_racval
          , izn_pdv_5
          , izn_pdv_5_racval
          , izn_pdv_ost
          , izn_pdv_ost_racval
          , izn_ppot
          , izn_ppot_racval
          , poziv_na_broj
          , stopa_popusta1
          , izn_popusta1
          , stopa_popusta2
          , izn_popusta2
          , stopa_popusta3
          , izn_popusta3
          , stopa_popusta4
          , izn_popusta4
          , ugo_god_poslovna
          , ugo_so_sifra
          , ugo_rbr
          , ostalo
          , glavni_racun
          , broj_racuna
          , unos_dat
          )
        VALUES (
            :1    -- virgarepl_status
          , :2    -- vlasnikpodatka
          , :3    -- id
          , :4    -- pod_sifra
          , :5    -- oznaka
          , :6    -- god_poslovna
          , :7    -- oj_sifra
          , :8    -- vapldok_oznaka
          , :9    -- rbr
          , :10   -- rac_id
          , :11   -- datum
          , :12   -- iznos
          , :13   -- so_sifra
          , :14   -- kd_sifra
          , :15   -- posred_sifra
          , :16   -- age_sifra
          , :17   -- konto
          , :18   -- stopa_zkamate
          , :19   -- val_sifra
          , :20   -- dat_dospijeca
          , :21   -- dat_nobveze
          , :22   -- izn_predujma
          , :23   -- izn_odbitka
          , :24   -- izn_tecaja
          , :25   -- izn_domval
          , :26   -- izn_bp
          , :27   -- izn_osn_1
          , :28   -- izn_osn_1_racval
          , :29   -- izn_osn_2
          , :30   -- izn_osn_2_racval
          , :31   -- izn_osn_3
          , :32   -- izn_osn_3_racval
          , :33   -- izn_osn_4
          , :34   -- izn_osn_4_racval
          , :35   -- izn_osn_5
          , :36   -- izn_osn_5_racval
          , :37   -- izn_osn_ost
          , :38   -- izn_osn_ost_racval
          , :39   -- izn_pdv_3
          , :40   -- izn_pdv_3_racval
          , :41   -- izn_pdv_4
          , :42   -- izn_pdv_4_racval
          , :43   -- izn_pdv_5
          , :44   -- izn_pdv_5_racval
          , :45   -- izn_pdv_ost
          , :46   -- izn_pdv_ost_racval
          , :47   -- izn_ppot
          , :48   -- izn_ppot_racval
          , :49   -- poziv_na_broj
          , :50   -- stopa_popusta1
          , :51   -- izn_popusta1
          , :52   -- stopa_popusta2
          , :53   -- izn_popusta2
          , :54   -- stopa_popusta3
          , :55   -- izn_popusta3
          , :56   -- stopa_popusta4
          , :57   -- izn_popusta4
          , :58   -- ugo_god_poslovna
          , :59   -- ugo_so_sifra
          , :60   -- ugo_rbr
          , :62   -- ostalo
          , :63   -- glavni_racun
          , :64   -- broj_racuna
          , :65   -- unos_dat
          )';
      EXECUTE IMMEDIATE naredba_l USING
           'N'
          , vlasnikpodatka_fin_l
          , pspprac_c.id
          , pspprac_c.pod_sifra
          , pspprac_c.oznaka
          , pspprac_c.god_poslovna
          , pspprac_c.oj_sifra
          , pspprac_c.vapldok_oznaka
          , pspprac_c.rbr
          , pspprac_c.rac_id
          , pspprac_c.datum
          , pspprac_c.iznos
          , pspprac_c.so_sifra
          , pspprac_c.kd_sifra
          , pspprac_c.posred_sifra
          , pspprac_c.age_sifra
          , pspprac_c.konto
          , pspprac_c.stopa_zkamate
          , pspprac_c.val_sifra
          , pspprac_c.dat_dospijeca
          , pspprac_c.dat_nobveze
          , pspprac_c.izn_predujma
          , pspprac_c.izn_odbitka
          , pspprac_c.izn_tecaja
          , pspprac_c.izn_domval
          , pspprac_c.izn_bp
          , pspprac_c.izn_osn_1
          , pspprac_c.izn_osn_1_racval
          , pspprac_c.izn_osn_2
          , pspprac_c.izn_osn_2_racval
          , pspprac_c.izn_osn_3
          , pspprac_c.izn_osn_3_racval
          , pspprac_c.izn_osn_4
          , pspprac_c.izn_osn_4_racval
          , pspprac_c.izn_osn_5
          , pspprac_c.izn_osn_5_racval
          , pspprac_c.izn_osn_ost
          , pspprac_c.izn_osn_ost_racval
          , pspprac_c.izn_pdv_3
          , pspprac_c.izn_pdv_3_racval
          , pspprac_c.izn_pdv_4
          , pspprac_c.izn_pdv_4_racval
          , pspprac_c.izn_pdv_5
          , pspprac_c.izn_pdv_5_racval
          , pspprac_c.izn_pdv_ost
          , pspprac_c.izn_pdv_ost_racval
          , pspprac_c.izn_ppot
          , pspprac_c.izn_ppot_racval
          , pspprac_c.poziv_na_broj
          , pspprac_c.stopa_popusta1
          , pspprac_c.izn_popusta1
          , pspprac_c.stopa_popusta2
          , pspprac_c.izn_popusta2
          , pspprac_c.stopa_popusta3
          , pspprac_c.izn_popusta3
          , pspprac_c.stopa_popusta4
          , pspprac_c.izn_popusta4
          , pspprac_c.ugo_god_poslovna
          , pspprac_c.ugo_so_sifra
          , pspprac_c.ugo_rbr
          , pspprac_c.ostalo
          , pspprac_c.glavni_racun
          , pspprac_c.broj_racuna
          , pspprac_c.unos_dat -- IRN 4096
      ;
    END IF;
  END LOOP;
  -- upis u zonu moe mijenjati vlasnika podatka pa ga vraamo
  pra_zmp_context.set_vlasnikpodatka (vlasnikpodatka_mish_l);
END;
PROCEDURE VIR2_IZVRSI_PRIJEPIS
 (DAT_POC_P IN LPKA_PRIJEPISI_FIN.DAT_POC%TYPE
 ,DAT_ZAV_P IN LPKA_PRIJEPISI_FIN.DAT_ZAV%TYPE
 ,OPIS_P OUT VARCHAR2
 )
 IS
/*
IRN 3411 MK. VIRGA2
prijepis iz jednog MT vlasnika u drugog na virgaoci preko zone,
sada iskljuivo za punjenje FIN vlasnika 210 iz MISH vlasnika 234
*/
  pkaparpri_id_l spka_parametri_prijepisa.id%TYPE;
BEGIN
  IF SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = 234 THEN
    vir2_puni_repl_v_pspp_racuni (dat_poc_p, dat_zav_p);
    SELECT id INTO pkaparpri_id_l FROM spka_parametri_prijepisa WHERE sifra = 'RACUNI';
    INSERT INTO lpka_prijepisi_fin (pkaparpri_id, dat_poc, dat_zav)
      VALUES (pkaparpri_id_l, dat_poc_p, dat_zav_p) RETURNING rbr INTO opis_p;
    COMMIT;
  END IF;
END;
PROCEDURE VIR2_IZVRSI_PRIJEPIS_JOB
 (BR_DANA_POC_P IN NUMBER
 ,BR_DANA_ZAV_P IN NUMBER
 )
 IS
--
  dat_poc_l DATE;
  dat_zav_l DATE;
  email_prvi_l szmp_parametri.vrijednost%TYPE;
  email_drugi_l szmp_parametri.vrijednost%TYPE;
  sender_l    szmp_parametri.vrijednost%TYPE;
  sender_h_l s_poruke.tekst%TYPE;
  detalj_obrade_l VARCHAR2 (100);
  opis_l VARCHAR2(200);
BEGIN
  email_prvi_l := pra_pka_zaj.vrijednost_parametra ('1091');
  email_drugi_l := pra_pka_zaj.vrijednost_parametra ('1092');

  -- Ako je upisan broj dana onda se razdoblje odreuje prema njemu
  -- ako nije upisan broj dana onda je razdoblje za virga2 = sysdate - 31 do juer
  IF br_dana_poc_p IS NULL THEN
    dat_poc_l := TRUNC (SYSDATE) - 31;
  ELSE
    dat_poc_l := TRUNC (SYSDATE) - br_dana_poc_P;
  END IF;
  IF br_dana_zav_p IS NULL THEN
    dat_zav_l := TRUNC (SYSDATE) - 1;
  ELSE
    dat_zav_l := TRUNC (SYSDATE) - br_dana_zav_P;
  END IF;

  detalj_obrade_l := '(' || TO_CHAR (dat_poc_l, 'DD.MM.YYYY') || ' - ' || TO_CHAR (dat_zav_l, 'DD.MM.YYYY') || ')';

  vir2_izvrsi_prijepis (
    TRUNC (dat_poc_l),
    TRUNC (dat_zav_l),
    opis_l
    );

EXCEPTION
  WHEN OTHERS THEN
    IF UPPER (email_prvi_l) <> 'NEBITNO' OR UPPER (email_drugi_l) <> 'NEBITNO' THEN
      sender_l := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0905'); -- noreply
      sender_h_l := pra_zmp_zaj.poruka ('ZMP', 'III0192'); -- Baza
    END IF;

    IF UPPER (email_prvi_l) <> 'NEBITNO' THEN
      pra_pka2.salji_html_email (
        recipient_p   => email_prvi_l,
        recipient_h_p => NULL,
        sender_p      => sender_l,
        sender_h_p    => sender_h_l,
        bcc_p         => NULL,
        subject_p     => SYS_CONTEXT ('USERENV', 'CURRENT_SCHEMA') || ' - Prijepis rauna ' || detalj_obrade_l  || '- ' || pra_zmp_zaj.poruka ('REC', 'REC0190'), -- Greka!
        text_p        => SQLERRM);
    END IF;

    IF UPPER (email_drugi_l) <> 'NEBITNO' THEN
      pra_pka2.salji_html_email (
        recipient_p   => email_drugi_l,
        recipient_h_p => NULL,
        sender_p      => sender_l,
        sender_h_p    => sender_h_l,
        bcc_p         => NULL,
        subject_p     => SYS_CONTEXT ('USERENV', 'CURRENT_SCHEMA') || ' - Prijepis rauna ' || detalj_obrade_l  || '- ' || pra_zmp_zaj.poruka ('REC', 'REC0190'), -- Greka!
        text_p        => SQLERRM);
    END IF;
    RAISE;
END;
PROCEDURE IZVRSI_PRIJEPIS_JOB
 (BR_DANA_POC_P IN NUMBER
 ,BR_DANA_ZAV_P IN NUMBER
 )
 IS
--
  fin_aplikacija_l szmp_parametri.vrijednost%TYPE := pra_pka_zaj.vrijednost_parametra ('1049');
BEGIN
  IF fin_aplikacija_l = 'VIRGA2' THEN
    vir2_izvrsi_prijepis_job (
      br_dana_poc_p,
      br_dana_zav_p
      );
  ELSIF fin_aplikacija_l = 'FINORA' THEN
    pra_pka_finora.ora_izvrsi_prijepis_job;
  ELSIF fin_aplikacija_l = 'FINTETRA' THEN
    pra_pka_fintetra.tet_izvrsi_prep_job (
      br_dana_poc_p,
      br_dana_zav_p
      );
  END IF;
END;
PROCEDURE IZVRSI_PRIJEPIS_JOB_MULTI
 (VLASNIKPODATKA_P IN NUMBER := NULL
 ,BR_DANA_POC_P IN NUMBER
 ,BR_DANA_ZAV_P IN NUMBER
 )
 IS
BEGIN  
  pra_zmp_context.set_vlasnikpodatka (vlasnikpodatka_p);
  pra_pka_fin.izvrsi_prijepis_job (br_dana_poc_p, br_dana_zav_p);
EXCEPTION
  WHEN OTHERS THEN
    RAISE;
END;

END PRA_PKA_FIN;
/
SHOW ERROR

