-- C:\Radni\pra_pka_csv.pkb
--
-- Generated for Oracle 10g on Wed Jun 11  13:08:36 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'PRA_PKA_CSV'
CREATE OR REPLACE PACKAGE BODY PRA_PKA_CSV IS

/* IZRADI_CSV_DATOTEKU */
PROCEDURE IZRADI_CSV_DATOTEKU
 (METMODSTRD_ID_P TMET_MOD_VRIR.METMODSTRD_ID%TYPE
 ,METMOD_SIFRA_P SMET_MODULI.SIFRA%TYPE
 ,ODREDISTE_P TMET_MOD_SETR.ODREDISTE%TYPE
 ,NACIN_P TMET_MOD_SETR.NACIN%TYPE
 ,NAZIV_P IN TMET_MOD_SET.NAZIV%TYPE
 )
 IS
-- IRN 3643
  pkaclob_data_l         CLOB;
  pkablob_data_l         BLOB;
  pkaclob_id_l           NUMBER;
  pkaclob_opis_l         VARCHAR2(240);
  sender_l               szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0905'); -- noreply
  recvlas_naz_licence_l  srec_vlasnik.naz_licence%TYPE;
  num_char_l             VARCHAR2(64);
  num_char_new_l         VARCHAR2(64) := ',.';          
  naslov_l               VARCHAR2(200);     
  
  lang_ctx_l             INTEGER := DBMS_LOB.default_lang_ctx;
  warning_l              INTEGER;
  dest_offset_l          NUMBER := 1;
  src_offset_l           NUMBER := 1;
BEGIN
  IF metmodstrd_id_p IS NULL OR odrediste_p IS NULL OR nacin_p IS NULL OR NVL(nacin_p,'X') <>'EMAIL' THEN
    RETURN;
  END IF;

  SELECT value
    INTO num_char_l
    FROM nls_session_parameters
   WHERE parameter = 'NLS_NUMERIC_CHARACTERS';

  IF num_char_l <> num_char_new_l THEN
     EXECUTE IMMEDIATE ('ALTER SESSION SET NLS_NUMERIC_CHARACTERS ='''||num_char_new_l||'''');
  END IF;
  
  -- IRN 3955 
  IF UPPER(metmod_sifra_p) = 'REC5510' THEN
          izradi_rec5510_csv (metmodstrd_id_p, pkaclob_id_l);
          naslov_l := ' Pregled prognoze II';
  ELSIF UPPER(metmod_sifra_p) = 'REC5520' THEN
          izradi_rec5520_csv (metmodstrd_id_p, pkaclob_id_l);
          naslov_l := ' Stanje bookinga';
  END IF;

  IF pkaclob_id_l IS NULL THEN
    RETURN;
  END IF;

  SELECT data, opis INTO pkaclob_data_l, pkaclob_opis_l FROM lpka_clob WHERE id = pkaclob_id_l;
  
  SELECT naz_licence INTO recvlas_naz_licence_l FROM srec_vlasnik;

  DBMS_LOB.createtemporary (pkablob_data_l, FALSE);
  DBMS_LOB.converttoblob (pkablob_data_l, pkaclob_data_l, DBMS_LOB.lobmaxsize, dest_offset_l, src_offset_l, NLS_CHARSET_ID ('EE8MSWIN1250'), lang_ctx_l, warning_l);

  IF pkablob_data_l IS NOT NULL THEN
  
    -- posalji mail
    pra_pka2.salji_html_email (
      recipient_p   => odrediste_p,
      recipient_h_p => NULL,
      sender_p      => sender_l,
      sender_h_p    => 'MISH Baza',
      bcc_p         => NULL,
      subject_p     => recvlas_naz_licence_l||naslov_l||' '||naziv_p,
      text_p        => recvlas_naz_licence_l||naslov_l||' '||naziv_p,
      attach_name1_p => pkaclob_opis_l,
      attach_blob1_p => pkablob_data_l);
  END IF;

  DELETE FROM lpka_clob
  WHERE id = pkaclob_id_l;
  COMMIT;

  IF num_char_l <> num_char_new_l THEN
     EXECUTE IMMEDIATE ('ALTER SESSION SET NLS_NUMERIC_CHARACTERS ='''||num_char_l||'''');
  END IF;

END;
/* IZRADI_REC5510_CSV */
PROCEDURE IZRADI_REC5510_CSV
 (METMODSTRD_ID_P TMET_MOD_VRIR.METMODSTRD_ID%TYPE
 ,PKACLOB_ID_P OUT NUMBER
 )
 IS
-- IRN 3643 Pregled prognoze II (I) 
  dat_poc_l            DATE;
  dat_zav_l            DATE;
  stupanj_prodaje_l    VARCHAR2(2);
  stupanj_prodaje_opis_l VARCHAR2(240);
  dat_l                DATE;
  so_id_l              NUMBER;
  vsj_id_l             NUMBER;
  ms_id_l              NUMBER;
  vms_id_l             NUMBER;
  gms_id_l             NUMBER;

  auto_csv_l           NUMBER;
BEGIN
  FOR c IN (
    SELECT vrir.vrijednost vrijednost, mp.naziv naziv
          FROM tmet_mod_vrir vrir,
               smet_mod_par mp
         WHERE vrir.metmodstrd_id = metmodstrd_id_p
           AND mp.id = vrir.metmodpar_id)
   LOOP
       IF c.naziv = 'PF_STUPANJ_PRODAJE' THEN
         stupanj_prodaje_l := c.vrijednost;
       ELSIF c.naziv = 'PF_SO_ID' THEN
         so_id_l := c.vrijednost;
       ELSIF c.naziv = 'PF_VSJ_ID' THEN
         vsj_id_l := c.vrijednost;
       ELSIF c.naziv = 'PF_MS_ID' THEN
         ms_id_l := c.vrijednost;
       ELSIF c.naziv = 'PF_VMS_ID' THEN
         vms_id_l := c.vrijednost;
       ELSIF c.naziv = 'PF_GMS_ID' THEN
         gms_id_l := c.vrijednost;
       ELSIF c.naziv = 'PF_DAT_POC' THEN
         dat_poc_l := TO_DATE(c.vrijednost,'DD.MM.RRRR');
       ELSIF c.naziv = 'PF_DAT_ZAV' THEN
         dat_zav_l := TO_DATE(c.vrijednost,'DD.MM.RRRR');
       ELSIF c.naziv = 'PF_AUTO_CSV' THEN
         auto_csv_l := c.vrijednost;
       END IF;

   END LOOP;

     -- ako nije ukljucen csv, izadji van
  IF NVL(auto_csv_l,0) = 0 THEN
    RETURN;
  END IF;

  izradi_rec5510_csv2 (dat_poc_l, dat_zav_l, so_id_l, vsj_id_l, ms_id_l, vms_id_l, gms_id_l, stupanj_prodaje_l, pkaclob_id_p);
END;
/* IZRADI_REC5510_CSV2 */
PROCEDURE IZRADI_REC5510_CSV2
 (DAT_POC_P DATE
 ,DAT_ZAV_P DATE
 ,SO_ID_P M_SO.ID%TYPE
 ,VSJ_ID_P S_VSJ.ID%TYPE
 ,MS_ID_P M_MSEGMENTI.ID%TYPE
 ,VMS_ID_P M_MSEGMENTI.VMS_ID%TYPE
 ,GMS_ID_P M_MSEGMENTI.ZMPGMS_ID%TYPE
 ,STUPANJ_PRODAJE_P VARCHAR2
 ,PKACLOB_ID_P OUT NUMBER
 )
 IS
-- IRN 3643 Pregled prognoze II (I) 
dat_poc_l            DATE;
dat_zav_l            DATE;
stupanj_prodaje_l    VARCHAR2(2);
dat_l                DATE;
so_id_l              NUMBER;
vsj_id_l             NUMBER;
ms_id_l              NUMBER;
vms_id_l             NUMBER;
gms_id_l             NUMBER;
izabrani_datum_l     DATE;
broj_ms_l            NUMBER;
labele_desno_l       VARCHAR2(30000);
ms_desno_l           VARCHAR2(30000);
ms_sifra_l           VARCHAR2(200);

redak_l              VARCHAR2(32767);
privitak_clob_l      CLOB;
pkaclob_id_l        NUMBER;


  CURSOR lijeva_strana_cur is
         SELECT DISTINCT kalendar.datum datum,
              NVL(pra_rec_s.kapac_upotrebljivi_po_id (so_id_l, NULL, vsj_id_l, NULL, kalendar.datum, kalendar.datum, NULL),0) AS polje_kapacitet,
              NVL(pra_rec_s.kapac_upotrebljivi_po_id (so_id_l, NULL, vsj_id_l, NULL, kalendar.datum, kalendar.datum, 1),0) AS polje_kapacitet_postelja,
              SUM(NVL(primary.kol_sj,0)) kol_sj,
              SUM(NVL(primary.br_osoba,0)) br_osoba,
              SUM(NVL(primary.prihod_1,0)) prihod_1,
              SUM(NVL(primary.prihod_2,0)) prihod_2,
              SUM(NVL(primary.prihod_3,0)) prihod_3,
              SUM(NVL(primary.prihod_4,0)) prihod_ostalo,
              NVL((SUM(primary.prihod_1) + SUM(primary.prihod_2) + SUM(primary.prihod_3) + SUM(primary.prihod_4)),0) ukupan_prihod
           FROM (SELECT st.datum datum,
                        st.KOL_SJ kol_sj,
                        st.br_osoba br_osoba,
                        st.izn_prihodann_1 prihod_1,
                        st.izn_prihodann_2 prihod_2,
                        st.izn_prihodann_3 prihod_3,
                        st.izn_prihodann_4 prihod_4
                   FROM irec_prog_stavke st
                  WHERE ((st.datum BETWEEN dat_poc_l AND dat_zav_l))
                        AND (so_id_l IS NULL OR so_id_l IS NOT NULL AND st.so_id = so_id_l)
                        AND (vsj_id_l IS NULL OR vsj_id IS NOT NULL AND st.vsj_id = vsj_id_l)
                        AND (ms_id_l IS NULL OR ms_id_l IS NOT NULL AND st.ms_id = ms_id_l)
                        AND (vms_id_l IS NULL OR vms_id_l IS NOT NULL AND st.ms_id IN (SELECT ms.id FROM m_msegmenti ms WHERE ms.vms_id = vms_id_l))
                        AND (gms_id_l IS NULL OR gms_id_l IS NOT NULL AND st.ms_id IN (SELECT ms.id FROM m_msegmenti ms WHERE ms.zmpgms_id = gms_id_l))
                        AND ((st.ozn_sprodaje = 'O' AND stupanj_prodaje_l = 'O') OR
                            ((st.ozn_sprodaje IN ('O', 'F')) AND stupanj_prodaje_l = 'F') OR
                            ((st.ozn_sprodaje IN ('O', 'F', 'B', 'Z')) AND stupanj_prodaje_l = 'P') OR
                            ((st.ozn_sprodaje IN ('O', 'F', 'A', 'Z')) AND stupanj_prodaje_l = 'H') OR
                            ((st.ozn_sprodaje IN ('O', 'F', 'B', 'A', 'Z')) AND stupanj_prodaje_l = 'A')) ) primary,
                 (
              SELECT DISTINCT(kalendar.datum) datum
                FROM v_zmp_kalendar kalendar ) kalendar
 WHERE primary.datum (+) = kalendar.datum
 GROUP BY kalendar.datum
 ORDER BY kalendar.datum;

 CURSOR desna_strana_cur IS
        SELECT x.ms_id ms_id_alt,
               x.datum_kal ms_datum,
               SUM(NVL(x.kol_sj,0)) ms_kol_sj,
               SUM(NVL(x.iznos_1,0)) ms_prihod_1,
               SUM(NVL(x.iznos_2,0)) ms_prihod_2,
               SUM(NVL(x.iznos_3,0)) ms_prihod_3,
               SUM(NVL(x.iznos_4,0)) ms_prihod_ostalo,
               SUM(NVL(x.iznos_1,0) + NVL(x.iznos_2,0) + NVL(x.iznos_3,0) + NVL(x.iznos_4,0)) ms_prihod_ukupno
         FROM (SELECT datum datum_kal, ms_id, so_id, vsj_id, ozn_sprodaje,  iznos_1,  iznos_2,  iznos_3,  iznos_4, kol_sj
                 FROM ( SELECT datum, ms_id, so_id, vsj_id, ozn_sprodaje, st.izn_prihodann_1 iznos_1, st.izn_prihodann_2 iznos_2, st.izn_prihodann_3 iznos_3, st.izn_prihodann_4 iznos_4, st.kol_sj kol_sj
                          FROM irec_prog_stavke st
                         WHERE st.datum BETWEEN dat_poc_l AND dat_zav_l  AND
                               ((st.ozn_sprodaje = 'O' AND stupanj_prodaje_l = 'O') OR
                               ((st.ozn_sprodaje IN ('O', 'F')) AND stupanj_prodaje_l = 'F') OR
                               ((st.ozn_sprodaje IN ('O', 'F', 'B', 'Z')) AND stupanj_prodaje_l = 'P') OR
                               ((st.ozn_sprodaje IN ('O', 'F', 'A', 'Z')) AND stupanj_prodaje_l = 'H') OR
                               ((st.ozn_sprodaje IN ('O', 'F', 'B', 'A', 'Z')) AND stupanj_prodaje_l = 'A'))
                           AND (so_id_l IS NULL OR so_id_l IS NOT NULL AND st.so_id = so_id_l)
                           AND (vsj_id_l IS NULL OR vsj_id IS NOT NULL AND st.vsj_id = vsj_id_l)
                           AND (ms_id_l IS NULL OR ms_id_l IS NOT NULL AND st.ms_id = ms_id_l)
                           AND (vms_id_l IS NULL OR vms_id_l IS NOT NULL AND st.ms_id IN (SELECT ms.id FROM m_msegmenti ms WHERE ms.vms_id = vms_id_l))
                           AND (gms_id_l IS NULL OR gms_id_l IS NOT NULL AND st.ms_id IN (SELECT ms.id FROM m_msegmenti ms WHERE ms.zmpgms_id = gms_id_l))
              UNION
              SELECT datum_kal, ms_orig_id ms_id , so_id, -1, ozn_sprodaje, 0, 0, 0, 0, 0
                FROM ( SELECT distinct ms_id, so_id, -1, ozn_sprodaje
                         FROM irec_prog_stavke st
                        WHERE st.datum BETWEEN dat_poc_l AND dat_zav_l  AND
                              ((st.ozn_sprodaje = 'O' AND stupanj_prodaje_l = 'O') OR
                              ((st.ozn_sprodaje IN ('O', 'F')) AND stupanj_prodaje_l = 'F') OR
                              ((st.ozn_sprodaje IN ('O', 'F', 'B', 'Z')) AND stupanj_prodaje_l = 'P') OR
                              ((st.ozn_sprodaje IN ('O', 'F', 'A', 'Z')) AND stupanj_prodaje_l = 'H') OR
                              ((st.ozn_sprodaje IN ('O', 'F', 'B', 'A', 'Z')) AND stupanj_prodaje_l = 'A'))
                          AND (so_id_l IS NULL OR so_id_l IS NOT NULL AND st.so_id = so_id_l)
                          AND (vsj_id_l IS NULL OR vsj_id IS NOT NULL AND st.vsj_id = vsj_id_l)
                          AND (ms_id_l IS NULL OR ms_id_l IS NOT NULL AND st.ms_id = ms_id_l)
                          AND (vms_id_l IS NULL OR vms_id_l IS NOT NULL AND st.ms_id IN (SELECT ms.id FROM m_msegmenti ms WHERE ms.vms_id = vms_id_l))
                          AND (gms_id_l IS NULL OR gms_id_l IS NOT NULL AND st.ms_id IN (SELECT ms.id FROM m_msegmenti ms WHERE ms.zmpgms_id = gms_id_l))
                ),
            (SELECT kalendar.datum datum_kal FROM v_zmp_kalendar kalendar  ) kal,
            (SELECT id ms_orig_id FROM M_MSEGMENTI WHERE dat_ponisten IS NULL OR dat_ponisten > dat_poc_l ) ms ) ukupan_select ) x
     WHERE x.datum_kal = izabrani_datum_l
     GROUP BY x.ms_id , x.datum_kal
     ORDER BY x.ms_id , x.datum_kal;

  c_lijeva_strana_l lijeva_strana_cur%ROWTYPE;

PROCEDURE IZRADI_JEDAN_RED IS
kapacitet_l          NUMBER;
kapacitet_postelja_l NUMBER;
desni_string_l       VARCHAR2(32767);
BEGIN

  kapacitet_l := c_lijeva_strana_l.polje_kapacitet;
  kapacitet_postelja_l := c_lijeva_strana_l.polje_kapacitet_postelja;

  izabrani_datum_l := c_lijeva_strana_l.datum;

  FOR redak in desna_strana_cur LOOP
    IF desni_string_l IS NULL THEN
      desni_string_l := redak.ms_kol_sj|| ';' ||redak.ms_prihod_1|| ';' ||redak.ms_prihod_2|| ';' ||redak.ms_prihod_3|| ';' ||redak.ms_prihod_ostalo|| ';' ||redak.ms_prihod_ukupno;
    ELSE
      desni_string_l := desni_string_l|| ';' ||redak.ms_kol_sj|| ';' ||redak.ms_prihod_1|| ';' ||redak.ms_prihod_2|| ';' ||redak.ms_prihod_3|| ';' ||redak.ms_prihod_ostalo|| ';' ||redak.ms_prihod_ukupno;
    END IF;
  END LOOP;

  redak_l := TO_CHAR(c_lijeva_strana_l.datum,'DD.MM.RRRR') || ';' || -- IRN 4060
             kapacitet_l || ';' ||
             c_lijeva_strana_l.kol_sj || ';' ||
             kapacitet_postelja_l || ';' ||
             c_lijeva_strana_l.br_osoba || ';' ||
             c_lijeva_strana_l.prihod_1 || ';' ||
             c_lijeva_strana_l.prihod_2 || ';' ||
             c_lijeva_strana_l.prihod_3 || ';' ||
             c_lijeva_strana_l.prihod_ostalo || ';' ||
             c_lijeva_strana_l.ukupan_prihod || ';' ||
             desni_string_l|| ';'||CHR(10);

  privitak_clob_l := privitak_clob_l||TO_CLOB(redak_l);

END IZRADI_JEDAN_RED;
BEGIN
  dat_poc_l         := dat_poc_p;
  dat_zav_l         := dat_zav_p;
  stupanj_prodaje_l := stupanj_prodaje_p;
  so_id_l           := so_id_p;
  vsj_id_l          := vsj_id_p;
  ms_id_l           := ms_id_p;
  vms_id_l          := vms_id_p;
  gms_id_l          := gms_id_p;

  dat_l := zmp_zaj.set_dates (dat_poc_l, dat_zav_l);

  SELECT COUNT(id) broj
  INTO broj_ms_l
  FROM m_msegmenti
  WHERE dat_ponisten IS NULL OR dat_ponisten > dat_poc_l;

  OPEN lijeva_strana_cur;
  FETCH lijeva_strana_cur INTO c_lijeva_strana_l;

  -- prvi redak
  IF lijeva_strana_cur%FOUND THEN

    -- naziv marketinkih segmenata
    -- pozicioniraju se iznad labela sa desne strane
/*    IF broj_ms_l > 0 THEN
      FOR i IN 1..broj_ms_l LOOP
        ms_naziv_l := pra_rec_rm.ms_naziv(i, dat_poc_l);
        ms_naziv_l := REPLACE(ms_naziv_l,';',',');
        IF ms_desno_l IS NULL THEN
      ms_desno_l := ms_naziv_l|| ';' ||' '|| ';' ||' '|| ';' ||' '|| ';' ||' '|| ';' ||' ';
    ELSE
          ms_desno_l := ms_desno_l|| ';' ||ms_naziv_l|| ';' ||' '|| ';' ||' '|| ';' ||' '|| ';' ||' '|| ';' ||' ';
        END IF;
      END LOOP;
    END IF;

    redak_l := ' ' || ';' ||
               ' ' || ';' ||
               ' ' || ';' ||
               ' ' || ';' ||
               ' ' || ';' ||
               ' ' || ';' ||
               ' ' || ';' ||
               ' ' || ';' ||
               ' ' || ';' ||
               ' ' || ';' ||
               ms_desno_l|| ';'||CHR(10);
    privitak_clob_l := privitak_clob_l||TO_CLOB(redak_l);*/


    -- labele za marketinke segmente
    IF broj_ms_l > 0 THEN
      FOR i IN 1..broj_ms_l LOOP
        ms_sifra_l := pra_rec_rm.ms_sifra(i, dat_poc_l);
        ms_sifra_l := REPLACE(ms_sifra_l,';',',')||'-';
        IF labele_desno_l IS NULL THEN
          labele_desno_l := ms_sifra_l||'Koliina SJ'|| ';' ||ms_sifra_l||'Prihod smjetaj'|| ';' ||ms_sifra_l||'Prihod hrana'|| ';' ||ms_sifra_l||'Prihod pie'|| ';' ||ms_sifra_l||'Prihod ostalo'|| ';' ||ms_sifra_l||'Ukupan prihod';
        ELSE
          labele_desno_l := labele_desno_l  || ';' ||ms_sifra_l||'Koliina SJ'|| ';' ||ms_sifra_l||'Prihod smjetaj'|| ';' ||ms_sifra_l||'Prihod hrana'|| ';' ||ms_sifra_l||'Prihod pie'|| ';' ||ms_sifra_l||'Prihod ostalo'|| ';' ||ms_sifra_l||'Ukupan prihod';
        END IF;
      END LOOP;
    END IF;

    redak_l := 'Datum' || ';' ||
               'Kapacitet SJ' || ';' ||
               'Koliina SJ' || ';' ||
               'Kapacitet postelja' || ';' ||
               'Broj osoba' || ';' ||
               'Prihod smjetaj' || ';' ||
               'Prihod hrana' || ';' ||
               'Prihod pie' || ';' ||
               'Prihod ostalo' || ';' ||
               'Ukupan prihod' || ';' ||
               labele_desno_l|| ';'||CHR(10);

    privitak_clob_l := privitak_clob_l||TO_CLOB(redak_l);
  ELSE
    CLOSE lijeva_strana_cur;
  END IF;

  LOOP
    EXIT WHEN lijeva_strana_cur%NOTFOUND;
    izradi_jedan_red;
    FETCH lijeva_strana_cur INTO c_lijeva_strana_l;
  END LOOP;
  CLOSE lijeva_strana_cur;

  INSERT INTO lpka_clob (oznaka, data, opis)
  VALUES ('PROGNOZA', privitak_clob_l, 'rec5510_'||to_CHAR(SYSDATE,'DD_MM_RRRR')||'.csv')
  RETURNING id INTO pkaclob_id_l;
  COMMIT;

  pkaclob_id_p := pkaclob_id_l;
END;
/* IZRADI_REC5520_CSV */
PROCEDURE IZRADI_REC5520_CSV
 (METMODSTRD_ID_P IN TMET_MOD_VRIR.METMODSTRD_ID%TYPE
 ,PKACLOB_ID_P OUT NUMBER
 )
 IS
-- IRN 3788 Stanje bookinga (I)
  dat_poc_l            DATE;
  dat_zav_l            DATE;
  stupanj_prodaje_l    VARCHAR2(2);
  so_id_l              NUMBER;

  auto_csv_l           NUMBER;
BEGIN
  FOR c IN (
    SELECT vrir.vrijednost vrijednost, mp.naziv naziv
          FROM tmet_mod_vrir vrir,
               smet_mod_par mp
         WHERE vrir.metmodstrd_id = metmodstrd_id_p
           AND mp.id = vrir.metmodpar_id)
   LOOP
       IF c.naziv = 'PF_STUPANJ_PRODAJE' THEN
         stupanj_prodaje_l := c.vrijednost;
       ELSIF c.naziv = 'PF_SO_ID' THEN
         so_id_l := c.vrijednost;
       ELSIF c.naziv = 'PF_DAT_POC' THEN
         dat_poc_l := TO_DATE(c.vrijednost,'DD.MM.RRRR');
       ELSIF c.naziv = 'PF_DAT_ZAV' THEN
         dat_zav_l := TO_DATE(c.vrijednost,'DD.MM.RRRR');
       ELSIF c.naziv = 'PF_AUTO_CSV' THEN
         auto_csv_l := c.vrijednost;
       END IF;

   END LOOP;

     -- ako nije ukljucen csv, izadji van
  IF NVL(auto_csv_l,0) = 0 THEN
    RETURN;
  END IF;

  izradi_rec5520_csv2 (dat_poc_l, dat_zav_l, so_id_l, stupanj_prodaje_l, pkaclob_id_p);
END;
/* IZRADI_REC5520_CSV2 */
PROCEDURE IZRADI_REC5520_CSV2
 (DAT_POC_P IN DATE
 ,DAT_ZAV_P IN DATE
 ,SO_ID_P IN M_SO.ID%TYPE
 ,STUPANJ_PRODAJE_P IN VARCHAR2
 ,PKACLOB_ID_P OUT NUMBER
 )
 IS
-- IRN 3788 Stanje bookinga (I)
 dat_poc_l            DATE;
 dat_zav_l            DATE;
 stupanj_prodaje_l    VARCHAR2(2);
 so_id_l              NUMBER;
 dat_l                DATE;
 izabrana_vsj_l       NUMBER;
 labele_desno_l       VARCHAR2(30000);
 datumi_desno_l       VARCHAR2(30000);

 redak_l              VARCHAR2(32767);
 privitak_clob_l      CLOB;
 pkaclob_id_l        NUMBER;

  CURSOR lijeva_strana_cur is
         SELECT  y.id, y.sifra, y.naziv, y.kapacitet_dn,
                 DECODE(stupanj_prodaje_l,
                        '16', NVL(SUM(kapacitet_uk),0),
                        '15', NVL(SUM(kapacitet_uk),0) - NVL(SUM(iznos), 0),
                        '17', NVL(SUM(kapacitet_uk),0) - NVL(SUM(iznos), 0),
                        '20', NVL(SUM(kapacitet_uk),0) - NVL(SUM(iznos), 0),
                        NVL(SUM(iznos), 0)) iznos
FROM (
SELECT b.vsj_id id,  b.datum period,
                         SUM(DECODE(stupanj_prodaje_l,
                                    '04', DECODE(b.ozn_sprodaje, 'C', -1, 1),
                                    '21', DECODE(b.ozn_sprodaje, 'W', -1, 1),
                                    '06', DECODE(b.ozn_sprodaje, 'P', 1, -1),
                                    '07', DECODE(b.ozn_sprodaje, 'X', -1, 1),
                                    '09', DECODE(b.ozn_sprodaje, 'Y', -1, 1),
                                    '11', DECODE(b.ozn_sprodaje, 'W', -1, 'X', -1, 'Y', -1, 1),
                                    '17', DECODE(b.ozn_sprodaje, 'W', -1, 'X', -1, 'Y', -1, 1),
                                    '12', DECODE(b.ozn_sprodaje, 'C', -1, 'W', -1, 'X', -1, 'Y', -1, 1),
                                    '15', DECODE(b.ozn_sprodaje, 'C', -1, 'W', -1, 'X', -1, 'Y', -1, 1),
                                    '13', DECODE(b.ozn_sprodaje, 'Y', -1, 1),
                                    '14', DECODE(b.ozn_sprodaje, 'C', -1, 'B', -1, 'F', -1, 'O', -1, 1),
                                    '18', DECODE(b.ozn_sprodaje, 'C', -1, 'W', -1, 'Y', -1, 1),
                                    '20', DECODE(b.ozn_sprodaje, 'C', -1, 'W', -1, 'Y', -1, 1),
                                    '19', DECODE(b.ozn_sprodaje, 'C', -1, 'W', -1, 'X', -1, 'Y', -1, 1), 1)
                             *
                             b.kol_sj) iznos,
                             1 kol_sj
                    FROM v_i_booking b,
                         t_pon_so ponso,
                         t_pon_ojr ponojr,
                         t_ponude pon,
                         m_agencije age
                   WHERE b.datum BETWEEN dat_poc_l AND dat_zav_l
                     AND (so_id_l IS NULL OR so_id_l = b.so_id)
                     AND stupanj_prodaje_l NOT IN ('16')
                     AND (stupanj_prodaje_l NOT IN ('03', '19') OR
                          b.ozn_sprodaje <> 'P' OR
                          NVL(pon.ozn_book, 0) = 1)
                     AND b.age_id = age.id (+)
                     AND b.ponso_id = ponso.id (+)
                     AND ponso.ponojr_id = ponojr.id (+)
                     AND ponojr.pon_id = pon.id (+)
                     AND ((b.ozn_sprodaje = 'A' AND stupanj_prodaje_l IN ('04', '06', '12', '15', '14', '18', '20', '19')) OR
                          (b.ozn_sprodaje = 'B' AND stupanj_prodaje_l IN ('07', '11',  '17', '12', '15', '14', '19')) OR
                          (b.ozn_sprodaje = 'C' AND stupanj_prodaje_l IN ('04', '12', '15', '14', '18', '20', '19')) OR
                          (b.ozn_sprodaje = 'F' AND stupanj_prodaje_l IN ('09', '11', '17', '13', '12', '15', '14', '18', '20', '19')) OR
                          (b.ozn_sprodaje = 'G' AND stupanj_prodaje_l IN ('01')) OR
                          (b.ozn_sprodaje = 'K' AND stupanj_prodaje_l IN ('08')) OR
                          (b.ozn_sprodaje = 'O' AND stupanj_prodaje_l IN ('10', '11', '17', '13', '12', '15', '14', '18', '20', '19')) OR
                          (b.ozn_sprodaje = 'P' AND stupanj_prodaje_l IN ('02', '03', '06', '19')) OR
                          (b.ozn_sprodaje = 'U' AND stupanj_prodaje_l IN ('05', '06', '14')) OR
                          (b.ozn_sprodaje = 'W' AND stupanj_prodaje_l IN ('21', '11', '17', '12', '15', '18', '20', '19')) OR
                          (b.ozn_sprodaje = 'X' AND stupanj_prodaje_l IN ('07', '11', '17', '12', '15', '14', '19')) OR
                          (b.ozn_sprodaje = 'Y' AND stupanj_prodaje_l IN ('09', '11', '17', '13', '12', '15', '14', '18', '20', '19')) OR
                          (b.ozn_sprodaje = 'Z' AND stupanj_prodaje_l IN ('21', '06', '11', '17', '12', '15', '18', '20', '19')))
                     AND NVL (b.kol_sj, 0) <> 0
                 GROUP BY b.vsj_id, b.datum     ) x,
                (SELECT datum, id, sifra, naziv, sum(kapacitet_dnevni) kapacitet_dn, sum(kapacitet) kapacitet_uk FROM  (SELECT kal.datum, id , vsj.sifra, vsj.naziv,
                        pra_rec_s.kapac_upotrebljivi_po_id(so.so_id, null, vsj.id, null, dat_poc_l, dat_poc_l, 0) kapacitet_dnevni,
                        pra_rec_s.kapac_upotrebljivi_po_id(so.so_id, null, vsj.id, null, kal.datum, kal.datum, 0) kapacitet
                   FROM s_vsj vsj,
                (SELECT datum FROM v_zmp_kalendar) kal,
                (SELECT distinct sj.vsj_id vsj_id,
                        so.id so_id
                   FROM m_sj sj,
                        m_so so
                  WHERE sj.so_id = so.id
                    AND so.dat_valjan <= dat_zav_l
                    AND NVL(so.dat_ponisten, TO_DATE ('31.12.9999', 'dd.mm.yyyy')) > dat_poc_l
                        ) so
            WHERE (so_id_l IS NULL OR so_id_l = so.so_id)
              AND vsj.id = so.vsj_id
            ) GROUP BY datum, id, sifra, naziv) y
          WHERE x.id (+) = y.id
            AND x.period (+) = y.datum
       GROUP BY  y.id, y.sifra, y.naziv, y.kapacitet_dn
       ORDER BY y.sifra;


 CURSOR desna_strana_cur IS
        SELECT   y.id, y.datum,
                 DECODE(stupanj_prodaje_l,
                        '16', NVL(SUM(kapacitet),0),
                        '15', NVL(SUM(kapacitet),0) - NVL(SUM(iznos), 0),
                        '17', NVL(SUM(kapacitet),0) - NVL(SUM(iznos), 0),
                        '20', NVL(SUM(kapacitet),0) - NVL(SUM(iznos), 0),
                        NVL(SUM(iznos), 0)) iznos_dnevni
        FROM (
                  SELECT b.vsj_id id,  b.datum period,  b.so_id,
                         SUM(DECODE(stupanj_prodaje_l,
                                    '04', DECODE(b.ozn_sprodaje, 'C', -1, 1),
                                    '21', DECODE(b.ozn_sprodaje, 'W', -1, 1),
                                    '06', DECODE(b.ozn_sprodaje, 'P', 1, -1),
                                    '07', DECODE(b.ozn_sprodaje, 'X', -1, 1),
                                    '09', DECODE(b.ozn_sprodaje, 'Y', -1, 1),
                                    '11', DECODE(b.ozn_sprodaje, 'W', -1, 'X', -1, 'Y', -1, 1),
                                    '17', DECODE(b.ozn_sprodaje, 'W', -1, 'X', -1, 'Y', -1, 1),
                                    '12', DECODE(b.ozn_sprodaje, 'C', -1, 'W', -1, 'X', -1, 'Y', -1, 1),
                                    '15', DECODE(b.ozn_sprodaje, 'C', -1, 'W', -1, 'X', -1, 'Y', -1, 1),
                                    '13', DECODE(b.ozn_sprodaje, 'Y', -1, 1),
                                    '14', DECODE(b.ozn_sprodaje, 'C', -1, 'B', -1, 'F', -1, 'O', -1, 1),
                                    '18', DECODE(b.ozn_sprodaje, 'C', -1, 'W', -1, 'Y', -1, 1),
                                    '20', DECODE(b.ozn_sprodaje, 'C', -1, 'W', -1, 'Y', -1, 1),
                                    '19', DECODE(b.ozn_sprodaje, 'C', -1, 'W', -1, 'X', -1, 'Y', -1, 1), 1)
                             *
                             b.kol_sj) iznos,
                             1 kol_sj
                    FROM v_i_booking b,
                         t_pon_so ponso,
                         t_pon_ojr ponojr,
                         t_ponude pon,
                         m_agencije age
                   WHERE b.datum BETWEEN dat_poc_l AND dat_zav_l
                     AND (so_id_l IS NULL OR so_id_l = b.so_id)
                     AND stupanj_prodaje_l NOT IN ('16')
                     AND (stupanj_prodaje_l NOT IN ('03', '19') OR
                          b.ozn_sprodaje <> 'P' OR
                          NVL(pon.ozn_book, 0) = 1)
                     AND b.age_id = age.id (+)
                     AND b.ponso_id = ponso.id (+)
                     AND ponso.ponojr_id = ponojr.id (+)
                     AND ponojr.pon_id = pon.id (+)
                     AND ((b.ozn_sprodaje = 'A' AND stupanj_prodaje_l IN ('04', '06', '12', '15', '14', '18', '20', '19')) OR
                          (b.ozn_sprodaje = 'B' AND stupanj_prodaje_l IN ('07', '11',  '17', '12', '15', '14', '19')) OR
                          (b.ozn_sprodaje = 'C' AND stupanj_prodaje_l IN ('04', '12', '15', '14', '18', '20', '19')) OR
                          (b.ozn_sprodaje = 'F' AND stupanj_prodaje_l IN ('09', '11', '17', '13', '12', '15', '14', '18', '20', '19')) OR
                          (b.ozn_sprodaje = 'G' AND stupanj_prodaje_l IN ('01')) OR
                          (b.ozn_sprodaje = 'K' AND stupanj_prodaje_l IN ('08')) OR
                          (b.ozn_sprodaje = 'O' AND stupanj_prodaje_l IN ('10', '11', '17', '13', '12', '15', '14', '18', '20', '19')) OR
                          (b.ozn_sprodaje = 'P' AND stupanj_prodaje_l IN ('02', '03', '06', '19')) OR
                          (b.ozn_sprodaje = 'U' AND stupanj_prodaje_l IN ('05', '06', '14')) OR
                          (b.ozn_sprodaje = 'W' AND stupanj_prodaje_l IN ('21', '11', '17', '12', '15', '18', '20', '19')) OR
                          (b.ozn_sprodaje = 'X' AND stupanj_prodaje_l IN ('07', '11', '17', '12', '15', '14', '19')) OR
                          (b.ozn_sprodaje = 'Y' AND stupanj_prodaje_l IN ('09', '11', '17', '13', '12', '15', '14', '18', '20', '19')) OR
                          (b.ozn_sprodaje = 'Z' AND stupanj_prodaje_l IN ('21', '06', '11', '17', '12', '15', '18', '20', '19')))
                     AND NVL (b.kol_sj, 0) <> 0
                     AND b.vsj_id = izabrana_vsj_l
               GROUP BY b.vsj_id, b.datum, b.so_id) x,
               (SELECT kal.datum, id , vsj.sifra, vsj.naziv, so.so_id,
                       pra_rec_s.kapac_upotrebljivi_po_id(so.so_id, null, vsj.id, null, kal.datum, kal.datum, 0) kapacitet
                  FROM s_vsj vsj,
               (SELECT datum FROM v_zmp_kalendar) kal,
               (SELECT distinct sj.vsj_id vsj_id,
                       so.id so_id
                  FROM m_sj sj,
                       m_so so
                 WHERE sj.so_id = so.id
                   AND so.dat_valjan <= dat_zav_l
                   AND NVL(so.dat_ponisten, TO_DATE ('31.12.9999', 'dd.mm.yyyy')) > dat_poc_l
                 ) so
           WHERE (so_id_l IS NULL OR so_id_l IS NOT NULL AND so_id_l = so.so_id)
             AND vsj.id = so.vsj_id
             AND vsj.id = izabrana_vsj_l
              ) y
         WHERE x.id (+) = y.id
           AND x.so_id (+)  = y.so_id
           AND x.period  (+) = y.datum
      GROUP BY  y.id, y.datum
      ORDER by 2;
	 
  CURSOR kalendar_cur IS SELECT datum FROM v_zmp_kalendar ORDER BY datum;
  
  c_lijeva_strana_l lijeva_strana_cur%ROWTYPE;
  
PROCEDURE IZRADI_JEDAN_RED IS
kapacitet_l          NUMBER;
kapacitet_postelja_l NUMBER;
desni_string_l       VARCHAR2(32767);
BEGIN

  izabrana_vsj_l := c_lijeva_strana_l.id;

  FOR des_c in desna_strana_cur LOOP
    IF desni_string_l IS NULL THEN
      desni_string_l := des_c.iznos_dnevni;
    ELSE
      desni_string_l := desni_string_l|| ';' ||des_c.iznos_dnevni;
    END IF;
  END LOOP;

  redak_l := c_lijeva_strana_l.sifra || ';' ||
             c_lijeva_strana_l.naziv || ';' ||
             c_lijeva_strana_l.kapacitet_dn || ';' ||
             c_lijeva_strana_l.iznos || ';' ||
             desni_string_l|| ';'||CHR(10);

  privitak_clob_l := privitak_clob_l||TO_CLOB(redak_l);

END IZRADI_JEDAN_RED;
BEGIN
  dat_poc_l         := dat_poc_p;
  dat_zav_l         := dat_zav_p;
  stupanj_prodaje_l := stupanj_prodaje_p;
  so_id_l           := so_id_p;

  dat_l := zmp_zaj.set_dates (dat_poc_l, dat_zav_l);


  OPEN lijeva_strana_cur;
  FETCH lijeva_strana_cur INTO c_lijeva_strana_l;

  -- prvi redak
  IF lijeva_strana_cur%FOUND THEN
  
    FOR kal_c IN kalendar_cur LOOP
      IF datumi_desno_l IS NULL THEN
        datumi_desno_l := kal_c.datum;
      ELSE
        datumi_desno_l := datumi_desno_l|| ';' ||kal_c.datum;
      END IF;
	END LOOP;

    redak_l := 'ifra VSJ' || ';' ||
               'Naziv VSJ' || ';' ||
               'Kapacitet' || ';' ||
               'Ukupno' || ';' ||
               datumi_desno_l|| ';'||CHR(10);


    privitak_clob_l := privitak_clob_l||TO_CLOB(redak_l);
  ELSE
    CLOSE lijeva_strana_cur;
  END IF;

  LOOP
    EXIT WHEN lijeva_strana_cur%NOTFOUND;
    izradi_jedan_red;
    FETCH lijeva_strana_cur INTO c_lijeva_strana_l;
  END LOOP;
  CLOSE lijeva_strana_cur;

  INSERT INTO lpka_clob (oznaka, data, opis)
  VALUES ('BOOKING', privitak_clob_l, 'rec5520_'||to_CHAR(SYSDATE,'DD_MM_RRRR')||'.csv')
  RETURNING id INTO pkaclob_id_l;
  COMMIT;

  pkaclob_id_p := pkaclob_id_l;
END;
/* OBRISI_LPKA_CLOB */
PROCEDURE OBRISI_LPKA_CLOB
 (PKACLOB_ID_P LPKA_CLOB.ID%TYPE
 )
 IS
BEGIN
  DELETE FROM lpka_clob
   WHERE id = pkaclob_id_p;
  COMMIT;
END;
PROCEDURE IZRADI_REC5130_CSV2
 (DAT_POC_P IN DATE
 ,DAT_ZAV_P IN DATE
 ,OJ_ID_P IN M_SO.OJ_ID%TYPE
 ,OIB_OPERATERA_P IN M_KORISNICI.SIFRA%TYPE
 ,PKACLOB_ID_P OUT NUMBER
 )
 IS
-- IRN 4061
  dat_poc_l            DATE;
  dat_zav_l            DATE;
  oj_id_l              NUMBER;
  oib_operatera_l      VARCHAR2(60);
  
  redak_l              VARCHAR2(32767);
  privitak_clob_l      CLOB;
  pkaclob_id_l        NUMBER;

  CURSOR podaci_cur IS SELECT 'POS' AS vdok, 
                               rn.id AS id, 
                               rn.godina AS godina, 
                               rn.rbr AS rbr, 
                               NULL AS rbr_gi,
                               rn.datum AS datum, 
                               rn.datum_napojnice AS datum_napojnice, 
                               rnpro.iznos AS iznos, 
                               rn.izn_napojnice AS iznos_napojnice, 
                               kon.sifra ||' '|| kon.ime_prezime AS ime_operatera,
                               kon.oib AS oib_operatera,
                               kasa_gas.sifra AS blagajna
                         FROM t_rnkase rn, 
                              (SELECT rn_id, SUM (iznos) AS iznos
                                 FROM t_rnkase_pro
                              GROUP BY rn_id) rnpro,
                              s_vplacanja vpla,
                              s_vpplacanja vppla,
                              m_konobari kon,
                              mgmp_kase kasa_gas
                        WHERE rn.id = rnpro.rn_id
                          AND NVL (rn.izn_napojnice,0) <> 0
                          AND rn.vpla_napojnice_id = vpla.id
                          AND vpla.ozn_irn IS NULL
                          AND vppla.id = vpla.vppla_id
                          AND vppla.sifra <> 'X'
                          AND kon.id (+) = rn.kon_id
                          AND rn.kase_id = kasa_gas.id 
                          AND kasa_gas.zmpojr_id = oj_id_l
                          AND TRUNC (rn.datum_napojnice) BETWEEN dat_poc_l AND dat_zav_l
                          AND (oib_operatera_l IS NULL OR kon.oib = oib_operatera_l)
                    UNION ALL
                       SELECT 'POS (GI)' AS vdok, 
                              tpkarn.id AS id,  
                              tpkarn.god_poslovna AS godina, 
                              tpkarn.rbr AS rbr, 
                              rn.rbr AS rbr_gi, 
                              tpkarn.datum AS datum, 
                              rac_fis.dat_obrade AS datum_napojnice,
                              tpkarn.izn_placanja AS iznos, 
                              NVL (tpkarn.izn_napojnice, 0) AS iznos_napojnice, 
                              tpkarn.naz_operatera AS ime_operatera, 
                              tpkarn.oib_operatera AS oib_operatera,
                              kasa_gas.sifra AS blagajna
                         FROM tpka_rnkasa tpkarn,
                              t_racuni rn,
                              s_vapldok vapldok,
                              (SELECT rac_id, MAX (ozn_napojnice) ozn_napojnice
                                 FROM lpka_rac_fis
                                WHERE sifra_greske IS NULL AND opis_greske IS NULL
                                  AND ozn_napojnice IS NOT NULL
                              GROUP BY rac_id) max_rac_fis,
                              lpka_rac_fis rac_fis,
                              mgmp_kase kasa_gas
                        WHERE rn.oj_id = oj_id_l
                          AND rn.vapldok_id = vapldok.id
                          AND vapldok.oznaka = 'GI'
                          AND tpkarn.rac_id = rn.id
                          AND NVL (tpkarn.izn_napojnice, 0) <> 0
                          AND rn.id = max_rac_fis.rac_id
                          AND rn.id = rac_fis.rac_id 
                          AND rac_fis.ozn_napojnice = max_rac_fis.ozn_napojnice 
                          AND rac_fis.sifra_greske IS NULL AND rac_fis.opis_greske IS NULL
                          AND tpkarn.gmpkas_id = kasa_gas.id 
                          AND TRUNC (rac_fis.dat_obrade) BETWEEN dat_poc_l AND dat_zav_l
                          AND (oib_operatera_l IS NULL OR tpkarn.oib_operatera = oib_operatera_l)
                    UNION ALL
                       SELECT vapldok.oznaka AS vdok, 
                              rn.id AS id,  
                              rn.god_poslovna AS godina, 
                              rn.rbr AS rbr, 
                              NULL AS rbr_gi,
                              rn.datum AS datum, 
                              rac_fis.dat_obrade AS datum_napojnice,
                              ROUND (rn.iznos * rn.izn_tecaja + NVL (rac_pred.izn_predujma_domval, 0), 2) AS iznos,
                              DECODE (rac_fis.ozn_napojnice, '1', 0, NVL (rec_nap_racun.RecIznosNapojnice, 0)) AS iznos_napojnice, 
                              rn.unos_korisnik ||' '|| kor.napomena AS ime_operatera, 
                              kor.sifra AS oib_operatera,
                              NULL AS blagajna
                         FROM t_racuni rn,
                              s_vapldok vapldok,
                              (SELECT rac_id, SUM (ROUND (NVL (izn_napojnice, 0) * izn_tecaja, 2)) RecIznosNapojnice FROM t_rac_nap GROUP BY rac_id) rec_nap_racun,
                              (SELECT rac_id, MAX (ozn_napojnice) ozn_napojnice
                                 FROM lpka_rac_fis
                                WHERE sifra_greske IS NULL AND opis_greske IS NULL
                                  AND ozn_napojnice = 2
                              GROUP BY rac_id) max_rac_fis,
                              (SELECT rac_id, SUM (ROUND (iznos * izn_tecaja, 2)) AS izn_predujma_domval
                                 FROM t_rac_pred
                              GROUP BY rac_id) rac_pred,
                              lpka_rac_fis rac_fis,
                              m_korisnici kor
                        WHERE rn.oj_id = oj_id_l
                          AND rn.vapldok_id = vapldok.id
                          AND vapldok.oznaka = 'GI'
                          AND rn.id = rec_nap_racun.rac_id (+)
                          AND rac_pred.rac_id (+) = rn.id
                          AND (NVL (rec_nap_racun.RecIznosNapojnice, 0) <> 0 )
                          AND rn.id = max_rac_fis.rac_id
                          AND rn.id = rac_fis.rac_id 
                          AND rac_fis.ozn_napojnice = max_rac_fis.ozn_napojnice 
                          AND rac_fis.sifra_greske IS NULL 
                          AND rac_fis.opis_greske IS NULL
                          AND rn.unos_korisnik = kor.naziv
                          AND TRUNC (rac_fis.dat_obrade) BETWEEN dat_poc_l AND dat_zav_l
                          AND (oib_operatera_l IS NULL OR kor.sifra = oib_operatera_l)
                     ORDER BY ime_operatera, vdok, godina, rbr;

  c_podaci_l podaci_cur%ROWTYPE;
BEGIN
  IF dat_poc_p IS NULL OR dat_zav_p IS NULL OR oj_id_p IS NULL THEN
    RETURN;
  END IF;
  dat_poc_l := dat_poc_p;
  dat_zav_l := dat_zav_p;
  oj_id_l := oj_id_p;
  oib_operatera_l := oib_operatera_p;

  OPEN podaci_cur;
  FETCH podaci_cur INTO c_podaci_l;

  -- prvi redak (opisi kolona)
  IF podaci_cur%FOUND THEN
    redak_l := 'Operater' || ';' ||
               'OIB' || ';' ||
               'Vrsta dokumenta' || ';' ||
               'Godina' || ';' ||
               'Rbr' || ';' ||
               'Blagajna' || ';' ||
               'Datum' || ';' ||
               'Rbr (GI)' || ';' ||
               'Datum fiskalizacije' || ';' ||
               'Iznos rauna' || ';' ||
               'Iznos napojnice' || ';' ||CHR(10);

    privitak_clob_l := privitak_clob_l||TO_CLOB(redak_l);
  END IF;

  LOOP
    redak_l := c_podaci_l.ime_operatera || ';' ||
               c_podaci_l.oib_operatera || ';' ||
               c_podaci_l.vdok || ';' ||
               c_podaci_l.godina || ';' ||
               c_podaci_l.rbr || ';' ||
               c_podaci_l.blagajna || ';' ||
               TO_CHAR(c_podaci_l.datum, 'DD.MM.RRRR') || ';' ||
               c_podaci_l.rbr_gi || ';' ||
               TO_CHAR(c_podaci_l.datum_napojnice, 'DD.MM.RRRR') || ';' ||
               c_podaci_l.iznos || ';' ||
               c_podaci_l.iznos_napojnice || ';' ||CHR(10);
               
    privitak_clob_l := privitak_clob_l || TO_CLOB (redak_l);
    FETCH podaci_cur INTO c_podaci_l;
    EXIT WHEN podaci_cur%NOTFOUND;
  END LOOP;
  CLOSE podaci_cur;

  INSERT INTO lpka_clob (oznaka, data, opis)
  VALUES ('NAPOJNICE', privitak_clob_l, 'pka5130_' || to_CHAR (SYSDATE, 'DD_MM_RRRR') || '.csv')
  RETURNING id INTO pkaclob_id_l;
  COMMIT;
  pkaclob_id_p := pkaclob_id_l;
END;

END PRA_PKA_CSV;
/
SHOW ERROR

