PROMPT Creating Package Body 'PRA_PKA_API'
CREATE OR REPLACE PACKAGE BODY PRA_PKA_API IS

OPIS_M CLOB;
SQLERRM_M VARCHAR2(1024);


PROCEDURE AZURIRAJ_PAYCARD
 (BROJ_P IN tpka_kartice.broj%TYPE
 ,OZNAKA_P IN tpka_kartice.oznaka%TYPE := 'V'
 ,OZN_PREPAID_P IN tpka_kartice.ozn_prepaid%TYPE := -1
 ,OZN_JEDNOKRATNA_P IN tpka_kartice.ozn_jednokratna%TYPE := 0
 ,OJR_SIFRA_P IN m_oj.sifra%TYPE
 ,OZN_IZVAN_OJ_P IN tpka_kartice.ozn_izvan_oj%TYPE := -1
 ,PKAADR_RBR_P IN mpka_adrese.rbr%TYPE := NULL
 ,AGE_SIFRA_P IN m_agencije.sifra%TYPE := NULL
 ,NAC_SIFRA1_P IN m_nacpot.sifra%TYPE
 ,NAC_SIFRA2_P IN m_nacpot.sifra%TYPE := NULL
 ,DAT_POC_P IN tpka_kartice.dat_poc%TYPE := NULL
 ,DAT_ZAV_P IN tpka_kartice.dat_zav%TYPE := NULL
 ,IME_P IN tpka_kartice.ime%TYPE
 ,PREZIME_P IN tpka_kartice.prezime%TYPE
 ,SIFRA_P IN tpka_kartice.sifra%TYPE
 ,OJ_SIFRA_P IN m_oj.sifra%TYPE
 ,ODGOVOR_P OUT VARCHAR2
 )
 IS
-- IRN 2807
  opis_l lpka_promjene.opis%TYPE;
  log_file_name_l lpka_clob.opis%TYPE; -- IRN 3943
  cvor_l    VARCHAR2(41);
  naredba_l VARCHAR2(3000);
  rc_l      SYS_REFCURSOR; -- IRN 3943
  dat_zav_l tpka_kartice.dat_zav%TYPE; -- IRN 3405
  sifra_l   tpka_kartice.sifra%TYPE;   -- IRN 3701
BEGIN

  opis_l :=
    SUBSTR (
      'broj_p ' || broj_p ||
        ', oznaka_p ' || oznaka_p ||
        ', ozn_prepaid_p ' || ozn_prepaid_p ||
        ', ozn_jednokratna_p ' || ozn_jednokratna_p ||
        ', ojr_sifra_p ' || ojr_sifra_p ||
        ', ozn_izvan_oj_p ' || ozn_izvan_oj_p ||
        ', pkaadr_rbr_p ' || pkaadr_rbr_p ||
        ', age_sifra_p ' || age_sifra_p ||
        ', nac_sifra1_p ' || nac_sifra1_p ||
        ', nac_sifra2_p ' || nac_sifra2_p ||
        ', dat_poc_p ' || TO_CHAR (dat_poc_p, 'DD.MM.RRRR HH24:MI') ||
        ', dat_zav_p ' || TO_CHAR (dat_zav_p, 'DD.MM.RRRR HH24:MI') ||
        ', ime_p ' || ime_p ||
        ', prezime_p ' || prezime_p ||
        ', sifra_p ' || sifra_p ||
        ', oj_sifra_p ' || oj_sifra_p,
      1,
      2000);

  -- IRN 3943
  log_file_name_l := 'Pay-Card-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '.log';
  pra_pka2.clob_to_table ('[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' || CHR(10), log_file_name_l, NULL, 'PAYCARD');
  pra_pka2.clob_to_table (opis_l || CHR(10), log_file_name_l, NULL, 'PAYCARD');
  -- KRAJ IRN 3943

  -- Pogrena vrijednost ulaznog parametra (#0)!
  IF TRIM (broj_p) IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'broj_p');
  -- oznaka_p
  -- ozn_prepaid_p
  -- ozn_jednokratna_p
  ELSIF ojr_sifra_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'ojr_sifra_p');
  -- ozn_izvan_oj_p
  ELSIF pkaadr_rbr_p IS NULL AND age_sifra_p IS NULL THEN -- IRN 3371
    pra_zmp_zaj.vrati_poruku (-20099, 'pkaadr_rbr_p / age_sifra_p');
  ELSIF pkaadr_rbr_p IS NOT NULL AND age_sifra_p IS NOT NULL THEN -- IRN 3371
    pra_zmp_zaj.vrati_poruku (-20099, 'pkaadr_rbr_p / age_sifra_p');
  -- nac_sifra1_p
  -- nac_sifra2_p
  ELSIF dat_poc_p IS NULL THEN -- IRN 3943
    pra_zmp_zaj.vrati_poruku (-20099, 'dat_poc_p');
  ELSIF dat_zav_p IS NULL THEN -- IRN 3943
    pra_zmp_zaj.vrati_poruku (-20099, 'dat_zav_p');
  ELSIF ime_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'ime_p');
  ELSIF prezime_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'prezime_p');
  ELSIF sifra_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'sifra_p');
  ELSIF oj_sifra_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'oj_sifra_p');
  END IF;

  pkakar_row_g := NULL; -- IRN 3701

  SELECT MIN (id) INTO pkakar_row_g.zmpojr_id FROM m_oj WHERE sifra = ojr_sifra_p;
  IF pkakar_row_g.zmpojr_id IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'ojr_sifra_p');
  END IF;

  SELECT MIN (metcvor_sifra) INTO cvor_l FROM mzmp_ojr WHERE id = pkakar_row_g.zmpojr_id;
  -- dbms_output.put_line ('cvor_l ' || cvor_l);
  IF cvor_l IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'ojr_sifra_p');
  END IF;
  IF cvor_l = pra_zmp_zaj.tekuci_cvor THEN
    cvor_l := NULL;
  ELSE
    cvor_l := '@' || cvor_l;
  END IF;

  -- id        -- uitava se prije insert/update naredbe
  -- zmpojr_id -- ve uitano
  -- gost_id
  IF age_sifra_p IS NOT NULL THEN -- IRN 3371
    SELECT MIN (id) INTO pkakar_row_g.age_id FROM m_agencije WHERE sifra = age_sifra_p;
    IF pkakar_row_g.age_id IS NULL THEN
      -- Pogrena vrijednost ulaznog parametra (#0)!
      pra_zmp_zaj.vrati_poruku (-20099, 'age_sifra_p');
    END IF;
  ELSIF pkaadr_rbr_p IS NOT NULL THEN
    naredba_l := 'SELECT MIN (id) FROM mpka_adrese<CVOR> WHERE rbr = :pkaadr_rbr_p';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_l) INTO pkakar_row_g.pkaadr_id USING pkaadr_rbr_p;
    IF pkakar_row_g.pkaadr_id IS NULL THEN
      -- Pogrena vrijednost ulaznog parametra (#0)!
      pra_zmp_zaj.vrati_poruku (-20099, 'pkaadr_rbr_p');
    END IF;
  END IF;
  pkakar_row_g.broj := TRIM (broj_p); -- IRN 3943
  pkakar_row_g.oznaka := NVL (oznaka_p, 'V');
  pkakar_row_g.ozn_izvan_oj := NVL (ozn_izvan_oj_p, -1);
  pkakar_row_g.dat_poc := dat_poc_p;
  IF TO_CHAR (dat_zav_p, 'HH24:MI') = '00:00' THEN
    -- IRN 3701; zaposlenik ima pravo na TO i zadnji dan
    pkakar_row_g.dat_zav := TO_DATE (TO_CHAR (dat_zav_p, 'DD.MM.RRRR') || ' ' || '23:59', 'DD.MM.RRRR HH24:MI');
  ELSE
    pkakar_row_g.dat_zav := dat_zav_p;
  END IF;
  IF pkakar_row_g.dat_zav < pkakar_row_g.dat_poc THEN -- IRN 3943
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'dat_zav_p');
  END IF;
  pkakar_row_g.ime := SUBSTR (TRIM (ime_p), 1, 20);
  pkakar_row_g.prezime := SUBSTR (TRIM (prezime_p), 1, 40); -- IRN 3943
  -- pin
  -- izn_odobren
  -- izn_potrosen
  -- izmjena_korisnik, izmjena_dat
  pkakar_row_g.ozn_jednokratna := NVL (ozn_jednokratna_p, 0);
  IF nac_sifra1_p IS NOT NULL THEN
    SELECT MIN (id) INTO pkakar_row_g.nac_id FROM m_nacpot WHERE sifra = nac_sifra1_p;
    IF pkakar_row_g.nac_id IS NULL THEN
      -- Pogrena vrijednost ulaznog parametra (#0)!
      pra_zmp_zaj.vrati_poruku (-20099, 'nac_sifra1_p');
    END IF;
  END IF;
  -- stopa_popusta_pos1
  -- stopa_popusta_pos2
  -- kcsus_id
  pkakar_row_g.ozn_prepaid := NVL (ozn_prepaid_p, -1);
  IF nac_sifra2_p IS NOT NULL THEN
    SELECT MIN (id) INTO pkakar_row_g.nac2_id FROM m_nacpot WHERE sifra = nac_sifra2_p;
    IF pkakar_row_g.nac2_id IS NULL THEN
      -- Pogrena vrijednost ulaznog parametra (#0)!
      pra_zmp_zaj.vrati_poruku (-20099, 'nac_sifra2_p');
    END IF;
  END IF;
  pkakar_row_g.ozn_nfc := 0;
  pkakar_row_g.sifra := sifra_p;
  IF oj_sifra_p IS NOT NULL THEN
    SELECT MIN (id) INTO pkakar_row_g.oj_id FROM m_oj WHERE sifra = oj_sifra_p;
    IF pkakar_row_g.oj_id IS NULL THEN
      -- Pogrena vrijednost ulaznog parametra (#0)!
      pra_zmp_zaj.vrati_poruku (-20099, 'oj_sifra_p');
    END IF;
  END IF;

  -- Provjeri postoji li valjana kartica s jednakim brojem
  -- IRN 2999 dodan UPPER
  -- IRN 3701 dodan MIN (sifra)
  -- IRN 3943 umjesto SELECT --> OPEN rc_l ... ORDER BY
  OPEN rc_l FOR
    REPLACE (
      'SELECT id, dat_zav, sifra FROM tpka_kartice<CVOR> WHERE UPPER (broj) = UPPER (:broj_p) AND oznaka = ''V'' ORDER BY id DESC',
      '<CVOR>',
      cvor_l)
    USING broj_p;
  FETCH rc_l INTO pkakar_row_g.id, dat_zav_l, sifra_l;
  CLOSE rc_l;

  -- IRN 3405; Provjeri je li kartica istekla
  IF pkakar_row_g.id IS NOT NULL
    AND pkakar_row_g.oznaka = 'V' -- nova oznaka
    AND dat_zav_l IS NOT NULL
    AND dat_zav_l <= SYSDATE
    AND NVL (sifra_l, '') <> pkakar_row_g.sifra -- IRN 3701; naena kartica se odnosi na drugog zaposlenika
  THEN
    -- Poniti isteklu karticu
    naredba_l := 'BEGIN UPDATE tpka_kartice<CVOR> SET oznaka = ''P'' WHERE id = :id; END;';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_l) USING pkakar_row_g.id;
    -- IRN 3943; spremi u log 
    pra_pka2.clob_to_table ('UPDATED OLD (' || pkakar_row_g.id || ' | ' || dat_zav_l || ' | ' || sifra_l || ')' || CHR(10), log_file_name_l, NULL, 'PAYCARD');
    pkakar_row_g.id := NULL; -- postavi id na NULL da se odradi INSERT u nastavku
  END IF;
  -- KRAJ IRN 3405

  IF pkakar_row_g.id IS NULL THEN
    IF pkakar_row_g.oznaka = 'P' THEN
      -- Pogrena vrijednost ulaznog parametra (#0)!
      pra_zmp_zaj.vrati_poruku (-20099, 'oznaka_p');
    END IF;
    pkakar_row_g.dat_poc := GREATEST (pkakar_row_g.dat_poc, SYSDATE); -- IRN 3701; nove kartice vrijede od tekueg datuma
    IF pkakar_row_g.dat_zav < pkakar_row_g.dat_poc THEN
      -- Pogrena vrijednost ulaznog parametra (#0)!
      pra_zmp_zaj.vrati_poruku (-20099, 'dat_zav_p'); -- IRN 3701; jer nove kartice vrijede od tekueg datuma
    END IF;
    pkakar_row_g.unos_korisnik := zmp_zaj.korisnik (-1); -- IRN 3278
    pkakar_row_g.unos_dat := SYSDATE;                    -- IRN 3278
    naredba_l := 'BEGIN INSERT INTO tpka_kartice<CVOR> VALUES pra_pka_api.pkakar_row_g; END;';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_l);
    odgovor_p := 'INSERTED';
  ELSE
    -- IRN 3278
    -- IRN 3943 uklonjen update dat_poc
    naredba_l :=
      'BEGIN
         UPDATE tpka_kartice<CVOR>
            SET oznaka = :oznaka,
                ozn_jednokratna = :ozn_jednokratna,
                zmpojr_id = :zmpojr_id,
                ozn_izvan_oj = :ozn_izvan_oj,
                age_id = :age_id,
                pkaadr_id = :pkaadr_id,
                nac_id = :nac_id,
                nac2_id = :nac2_id,
                dat_zav = :dat_zav,
                ime = :ime,
                prezime = :prezime,
                sifra = :sifra,
                oj_id = :oj_id
          WHERE id = :id;
       END;';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', cvor_l)
      USING pkakar_row_g.oznaka,
            pkakar_row_g.ozn_jednokratna,
            pkakar_row_g.zmpojr_id,
            pkakar_row_g.ozn_izvan_oj,
            pkakar_row_g.age_id,
            pkakar_row_g.pkaadr_id,
            pkakar_row_g.nac_id,
            pkakar_row_g.nac2_id,
            pkakar_row_g.dat_zav,
            pkakar_row_g.ime,
            pkakar_row_g.prezime,
            pkakar_row_g.sifra,
            pkakar_row_g.oj_id,
            pkakar_row_g.id;
    odgovor_p := 'UPDATED';
  END IF;
  odgovor_p := 'OK (' || odgovor_p || ' ' || SQL%ROWCOUNT || ')';
  pra_pka2.clob_to_table (odgovor_p || CHR(10), log_file_name_l, NULL, 'PAYCARD');
EXCEPTION
  WHEN OTHERS THEN
    odgovor_p := 'ERROR: ' || SQLCODE || ' ' || SQLERRM;
    ROLLBACK; -- IRN 3943
    pra_pka2.clob_to_table (odgovor_p || CHR(10), log_file_name_l, NULL, 'PAYCARD');
    RAISE;
END;
FUNCTION GUESTS_BY_UNIT
 (PROPERTY_CODE_P IN m_so.sifra%TYPE
 ,UNIT_CODE_P IN m_sj.broj%TYPE
 ,INVOICE_DATE_P IN tpka_rnkasa.datum%TYPE := TRUNC (SYSDATE)
 ,POS_CODE_P IN mgmp_kase.sifra%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
-- MISH API -> API POS -> /pos/guests_by_unit
  opis_l           lpka_promjene.opis%TYPE; -- IRN 3348
  invoice_date_l   tpka_rnkasa.datum%TYPE;  -- IRN 3348.2
  odlazak_na_dan_l NUMBER := 0;
  curs_l           sys_refcursor;
BEGIN

  opis_l := -- IRN 3348
    SUBSTR (
      'property_code ' || property_code_p ||
        ', unit_code ' || unit_code_p ||
        ', invoice_date ' || TO_CHAR (invoice_date_p, 'DD.MM.RRRR') ||
        ', pos_code ' || pos_code_p,
      1,
      2000);

  IF pra_zmp_s.oznaka ('P0017') = 0 THEN
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  -- Pogrena vrijednost ulaznog parametra (#0)!
  IF property_code_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'property_code');
  ELSIF unit_code_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'unit_code');
  -- invoice_date
  ELSIF pos_code_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'pos_code');
  END IF;

  invoice_date_l := TRUNC (NVL (invoice_date_p, SYSDATE)); -- IRN 3348.2

  SELECT MIN (ozn_knjizenja) INTO odlazak_na_dan_l
    FROM mgmp_kase
   WHERE sifra = pos_code_p;
  IF odlazak_na_dan_l IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'pos_code');
  END IF;

  OPEN curs_l FOR
    SELECT
      gost.id AS guest_id,
      gost.ime || ' ' || gost.prezime AS guest_name,
      gost.ozn_platitelj AS payer_indicator,
      sj.id AS unit_id,
      sj.broj AS unit_code,
      SUBSTR (sj.opis, 1, 20) AS unit_description,
      so.id AS property_id,
      so.sifra AS property_code,
      so.naziv AS property_name
    FROM
      t_gosti gost,
      m_sj sj,
      m_so so
    WHERE
      gost.ozn_prisutnosti = 'P'
      AND NVL (gost.ozn_rnk, -1) = -1
      AND invoice_date_l BETWEEN gost.dat_dolaska AND gost.dat_odlaska - 1 - NVL (gost.ozn_rnk, odlazak_na_dan_l) -- IRN 3348.2
      AND gost.sj_id = sj.id
      AND sj.broj = unit_code_p
      AND sj.so_id = so.id
      AND so.sifra = DECODE (property_code_p, 'UNDEFINED', so.sifra, property_code_p) -- IRN 3335
    ORDER BY
      sj.broj, gost.ozn_platitelj, gost.rbr;

  RETURN curs_l;

EXCEPTION -- IRN 3348
  WHEN OTHERS THEN
    pra_pka_iud.puni_pkapro ('MISHAPI', '0001', SUBSTR (SQLERRM || ' | ' || opis_l, 1, 2000), 0);
    RAISE;
END;
PROCEDURE POST_CHARGE
 (PROPERTY_ID_P IN m_so.id%TYPE
 ,POS_CODE_P IN mgmp_kase.sifra%TYPE
 ,PAYMENT_TYPE_CODE_P IN s_vplacanja.sifra%TYPE
 ,GUEST_ID_P IN tpka_rnkasa.gost_id%TYPE
 ,PAYCARD_ID_P IN tpka_kartice.id%TYPE
 ,INVOICE_YEAR_P IN tpka_rnkasa.god_poslovna%TYPE
 ,INVOICE_NUMBER_P IN tpka_rnkasa.rbr%TYPE
 ,INVOICE_DATE_P IN tpka_rnkasa.datum%TYPE := TRUNC (SYSDATE)
 ,TOTAL_P IN tpka_rnkasa.izn_placanja%TYPE
 ,TAX_AMOUNT_P IN tpka_rnkasa.izn_ppot%TYPE
 ,TAX_RATE_P IN tpka_rnkasa.stopa_ppot%TYPE
 ,TAX_BASE_AMOUNT_P IN tpka_rnkasa.izn_osnovice_ppot%TYPE
 ,DISCOUNT_AMOUNT_P IN tpka_rnkasa.izn_popusta%TYPE
 ,CANCELED_INVOICE_YEAR_P IN tpka_rnkasa.god_poslovna%TYPE
 ,CANCELED_INVOICE_NUMBER_P IN tpka_rnkasa.rbr%TYPE
 ,INVOICE_ID_P OUT tpka_rnkasa.id%TYPE
 )
 IS
-- MISH API -> API POS -> /pos/post_charge
-- IRN 4110; brisani parametri pkapd_zki_p, pkapd_jir_p i pkapd_napomena_p

  opis_l         lpka_promjene.opis%TYPE; -- IRN 3348
  invoice_date_l tpka_rnkasa.datum%TYPE;  -- IRN 3348.2
  zmpojr_id_l    m_so.ojr_id%TYPE;
  gmpkase_id_l   mgmp_kase.id%TYPE;
  vpla_id_l      s_vplacanja.id%TYPE;
  invoice_id_l   tpka_rnkasa.id%TYPE;
BEGIN

  opis_l := -- IRN 3348
    SUBSTR (
      'property_id ' || property_id_p ||
        ', pos_code ' || pos_code_p ||
        ', payment_type_code ' || payment_type_code_p ||
        ', guest_id ' || guest_id_p ||
        ', paycard_id ' || paycard_id_p ||
        ', invoice_year ' || invoice_year_p ||
        ', invoice_number ' || invoice_number_p ||
        ', invoice_date ' || TO_CHAR (invoice_date_p, 'DD.MM.RRRR') ||
        ', total ' || total_p ||
        ', tax_amount ' || tax_amount_p ||
        ', tax_rate ' || tax_rate_p ||
        ', tax_base_amount ' || tax_base_amount_p ||
        ', discount_amount ' || discount_amount_p ||
        ', canceled_invoice_year ' || canceled_invoice_year_p ||
        ', canceled_invoice_number ' || canceled_invoice_number_p ||
        ', canceled_invoice_number ' || canceled_invoice_number_p,
      1,
      2000);

  IF pra_zmp_s.oznaka ('P0018') = 0 THEN
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  -- Pogrena vrijednost ulaznog parametra (#0)!
  IF property_id_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'property_id');
  ELSIF pos_code_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'pos_code');
  ELSIF payment_type_code_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'payment_type_code');
  ELSIF guest_id_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'guest_id');
  -- paycard_id_p
  ELSIF invoice_year_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'invoice_year');
  ELSIF invoice_number_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'invoice_number');
  -- invoice_date
  ELSIF total_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'total');
  -- tax_amount
  -- tax_rate
  -- tax_base_amount
  -- discount_amount
  -- canceled_invoice_year
  -- canceled_invoice_number
  END IF;

  invoice_date_l := TRUNC (NVL (invoice_date_p, SYSDATE)); -- IRN 3348.2

  SELECT MIN (ojr_id) INTO zmpojr_id_l FROM m_so WHERE id = property_id_p;
  IF zmpojr_id_l IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'property_id ' || property_id_p);
  END IF;

  SELECT MIN (id) INTO gmpkase_id_l FROM mgmp_kase WHERE sifra = pos_code_p;
  IF gmpkase_id_l IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'pos_code ' || pos_code_p);
  END IF;

  SELECT MIN (id) INTO vpla_id_l FROM s_vplacanja WHERE sifra = payment_type_code_p AND ozn_irn = '1';
  IF vpla_id_l IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'payment_type_code ' || payment_type_code_p);
  END IF;

  IF canceled_invoice_year_p IS NULL AND canceled_invoice_number_p IS NOT NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'canceled_invoice_year');
  ELSIF canceled_invoice_year_p IS NOT NULL AND canceled_invoice_number_p IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'canceled_invoice_number');
  END IF;

  pra_pos_pka.insert_racun_objekt (
    zmpojr_id_p         => zmpojr_id_l,
    gmpkas_id_p         => gmpkase_id_l,
    vpla_id_p           => vpla_id_l,
    gostp_id_p          => guest_id_p,
    agep_id_p           => NULL,
    pkaadrp_id_p        => NULL,
    god_poslovna_p      => invoice_year_p,
    rbr_p               => invoice_number_p,
    datum_p             => invoice_date_l, -- IRN 3348.2
    izn_placanja_p      => total_p,
    izn_ppot_p          => NVL (tax_amount_p, 0),
    opis1_p             => NULL,
    opis2_p             => NULL,
    recara_id_p         => NULL,
    vpdog_id_p          => NULL,
    nac_id_p            => NULL,
    stopa_ppot_p        => NVL (tax_rate_p, 0),
    izn_osnovice_ppot_p => NVL (tax_base_amount_p, 0),
    pkakar_id_p         => paycard_id_p, -- IRN 3348
    gost_id_p           => guest_id_p,
    age_id_p            => NULL,
    pkaadr_id_p         => NULL,
    izn_popusta_p       => discount_amount_p,
    god_poslovna_izv_p  => canceled_invoice_year_p,   -- IRN 2843
    rbr_izv_p           => canceled_invoice_number_p, -- IRN 2843
    pkarnk_id_p         => invoice_id_l);

  invoice_id_p := invoice_id_l;

EXCEPTION -- IRN 3348
  WHEN OTHERS THEN
    pra_pka_iud.puni_pkapro ('MISHAPI', '0001', SUBSTR (SQLERRM || ' | ' || opis_l, 1, 2000), 0);
    RAISE;
END;
PROCEDURE POST_CHARGE_VAT
 (INVOICE_ID_P IN tpka_rnkasa.id%TYPE
 ,VAT_BASE_AMOUNT_P IN ipka_rnk_pdv.izn_osnovice%TYPE
 ,VAT_RATE_P IN ipka_rnk_pdv.stopa_pdv%TYPE
 ,VAT_GROUP_CODE_P IN s_vpisporukaz.sifra%TYPE
 ,VAT_AMOUNT_P IN ipka_rnk_pdv.izn_pdv%TYPE
 )
 IS
-- MISH API -> API POS -> /pos/post_charge
  opis_l      lpka_promjene.opis%TYPE; -- IRN 3348
  vpispz_id_l s_vpisporukaz.id%TYPE;
BEGIN

  opis_l := -- IRN 3348
    SUBSTR (
      'invoice_id ' || invoice_id_p ||
        ', vat_base_amount ' || vat_base_amount_p ||
        ', vat_rate ' || vat_rate_p ||
        ', vat_group_code ' || vat_group_code_p ||
        ', vat_amount ' || vat_amount_p,
      1,
      2000);

  IF pra_zmp_s.oznaka ('P0018') = 0 THEN
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  -- Pogrena vrijednost ulaznog parametra (#0)!
  IF invoice_id_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'invoice_id');
  ELSIF vat_base_amount_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'vat_base_amount');
  ELSIF vat_rate_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'vat_rate');
  ELSIF vat_group_code_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'vat_group_code');
  ELSIF vat_amount_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'vat_amount');
  END IF;

  SELECT MIN (id) INTO vpispz_id_l FROM s_vpisporukaz WHERE sifra = vat_group_code_p;
  IF vpispz_id_l IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'vat_group_code ' || vat_group_code_p);
  END IF;

  pra_pos_pka.insert_porez_objekt (
    zmpojr_id_p    => NULL, -- procedura ne ita parametar zmpojr_id_p
    pkarnk_id_p    => invoice_id_p,
    izn_osnovice_p => vat_base_amount_p,
    stopa_pdv_p    => vat_rate_p,
    vpispz_id_p    => vpispz_id_l,
    izn_pdv_p      => vat_amount_p);

EXCEPTION -- IRN 3348
  WHEN OTHERS THEN
    pra_pka_iud.puni_pkapro ('MISHAPI', '0001', SUBSTR (SQLERRM || ' | ' || opis_l, 1, 2000), 0);
    RAISE;
END;
PROCEDURE POST_CHARGE_ITEM
 (INVOICE_ID_P IN tpka_rnkasa.id%TYPE
 ,ITEM_CODE_P IN tpka_rnk_isp.sifra%TYPE
 ,ITEM_NAME_P IN tpka_rnk_isp.naziv%TYPE
 ,MEASUREMENT_UNIT_P IN tpka_rnk_isp.jm%TYPE
 ,QUANTITY_P IN tpka_rnk_isp.kolicina%TYPE
 ,PRICE_P IN tpka_rnk_isp.cijena%TYPE
 ,DISCOUNT_RATE_P IN tpka_rnk_isp.stopa_popusta%TYPE
 ,VAT_GROUP_CODE_P IN s_vpisporukaz.sifra%TYPE
 ,TAX_AMOUNT_P IN tpka_rnk_isp.izn_ppot%TYPE
 ,VAT_RATE_P IN tpka_rnk_isp.stopa_pdv%TYPE
 ,VAT_AMOUNT_P IN tpka_rnk_isp.izn_pdv%TYPE
 ,KPD_CODE_P IN s_kpd.sifra%TYPE := NULL
 )
 IS
-- MISH API -> API POS -> /pos/post_charge
-- IRN 4110; dodan parametar kpd_code_p

  opis_l      lpka_promjene.opis%TYPE; -- IRN 3348
  vpispz_id_l s_vpisporukaz.id%TYPE;
BEGIN

  opis_l := -- IRN 3348
    SUBSTR (
      'invoice_id ' || invoice_id_p ||
        ', item_code ' || item_code_p ||
        ', item_name ' || item_name_p ||
        ', measurement_unit ' || measurement_unit_p ||
        ', quantity ' || quantity_p ||
        ', price ' || price_p ||
        ', discount_rate ' || discount_rate_p ||
        ', vat_group_code ' || vat_group_code_p ||
        ', tax_amount ' || tax_amount_p ||
        ', vat_rate ' || vat_rate_p ||
        ', vat_amount ' || vat_amount_p ||
        ', kpd_code ' || kpd_code_p,
      1,
      2000);

  IF pra_zmp_s.oznaka ('P0018') = 0 THEN
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  -- Pogrena vrijednost ulaznog parametra (#0)!
  IF invoice_id_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'invoice_id');
  ELSIF item_code_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'item_code');
  ELSIF item_name_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'item_name');
  -- measurement_unit_p
  ELSIF quantity_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'quantity');
  ELSIF price_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'price');
  -- discount_rate_p
  ELSIF vat_group_code_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'vat_group_code');
  -- tax_amount_p
  ELSIF vat_rate_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'vat_rate');
  ELSIF vat_amount_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'vat_amount');
  -- kpd_code_p
  END IF;

  SELECT MIN (id) INTO vpispz_id_l FROM s_vpisporukaz WHERE sifra = vat_group_code_p;
  IF vpispz_id_l IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'vat_group_code ' || vat_group_code_p);
  END IF;

  pra_pos_pka.insert_pkarnkisp_objekt (
    zmpojr_id_p     => NULL, -- procedura ne ita parametar zmpojr_id_p
    pkarnk_id_p     => invoice_id_p,
    sifra_p         => item_code_p,
    naziv_p         => item_name_p,
    jm_p            => measurement_unit_p,
    kolicina_p      => quantity_p,
    cijena_p        => price_p,
    stopa_popusta_p => discount_rate_p,
    vpispz_id_p     => vpispz_id_l,
    stopa_pdv_p     => vat_rate_p,
    izn_ppot_p      => tax_amount_p,
    izn_pdv_p       => vat_amount_p,
    kpd_sifra_p     => kpd_code_p); -- IRN 4110

EXCEPTION -- IRN 3348
  WHEN OTHERS THEN
    pra_pka_iud.puni_pkapro ('MISHAPI', '0001', SUBSTR (SQLERRM || ' | ' || opis_l, 1, 2000), 0);
    RAISE;
END;
FUNCTION GUESTS_BY_PAYCARD
 (PAYCARD_NUMBER_P IN tpka_kartice.broj%TYPE
 ,INVOICE_DATETIME_P IN tpka_kartice.dat_poc%TYPE := SYSDATE
 ,POS_CODE_P IN mgmp_kase.sifra%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
-- API POS - Posting charges to PMS/Guests/Get guests by paycard
  opis_l             lpka_promjene.opis%TYPE;   -- IRN 3348
  invoice_datetime_l tpka_kartice.dat_poc%TYPE; -- IRN 3348.2
  odlazak_na_dan_l   NUMBER := 0;
  curs_l             sys_refcursor;
BEGIN

  opis_l := -- IRN 3348
    SUBSTR (
      'paycard_number ' || paycard_number_p ||
        ', invoice_datetime ' || TO_CHAR (invoice_datetime_p, 'DD.MM.RRRR HH24:MI') ||
        ', pos_code ' || pos_code_p,
      1,
      2000);

  IF pra_zmp_s.oznaka ('P0017') = 0 THEN
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  -- Pogrena vrijednost ulaznog parametra (#0)!
  IF paycard_number_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'paycard_number');
  -- invoice_datetime
  ELSIF pos_code_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'pos_code');
  END IF;

  invoice_datetime_l := NVL (invoice_datetime_p, SYSDATE); -- IRN 3348.2

  SELECT MIN (ozn_knjizenja) INTO odlazak_na_dan_l
    FROM mgmp_kase
   WHERE sifra = pos_code_p;
  IF odlazak_na_dan_l IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'pos_code');
  END IF;
  
  OPEN curs_l FOR
    SELECT
      gost.id AS guest_id,
      gost.ime || ' ' || gost.prezime AS guest_name,
      gost.ozn_platitelj AS payer_indicator,
      sj.id AS unit_id,
      sj.broj AS unit_code,
      SUBSTR (sj.opis, 1, 20) AS unit_description,
      pkakar.id AS paycard_id,
      so.id AS property_id,
      so.sifra AS property_code,
      so.naziv AS property_name
    FROM
      tpka_kartice pkakar,
      t_gosti gost,
      m_sj sj,
      m_so so
    WHERE
      UPPER (pkakar.broj) = UPPER (paycard_number_p)
      AND pkakar.oznaka = 'V'
      AND invoice_datetime_l BETWEEN NVL (pkakar.dat_poc, invoice_datetime_l) AND NVL (pkakar.dat_zav, invoice_datetime_l) -- IRN 3348.2
      AND pkakar.gost_id = gost.id
      AND gost.ozn_prisutnosti = 'P'
      AND NVL (gost.ozn_rnk, -1) = -1
      AND TRUNC (invoice_datetime_l) BETWEEN gost.dat_dolaska AND gost.dat_odlaska - 1 - NVL (gost.ozn_rnk, odlazak_na_dan_l) -- IRN 3348.2
      AND gost.sj_id = sj.id
      AND sj.so_id = so.id
    ORDER BY
      sj.broj, gost.ozn_platitelj, gost.rbr;

  RETURN curs_l;

EXCEPTION -- IRN 3348
  WHEN OTHERS THEN
    pra_pka_iud.puni_pkapro ('MISHAPI', '0001', SUBSTR (SQLERRM || ' | ' || opis_l, 1, 2000), 0);
    RAISE;
END;
PROCEDURE PROVJERI_PKARNK_IZNOS
 (PKARNK_ID_P IN tpka_rnkasa.id%TYPE
 ,BODY_P IN CLOB
 )
 IS
-- IRN 3348; API POS - Posting charges to PMS/Charges/Post charge to PMS
BEGIN
  pra_pka.provjeri_pkarnkpdv (pkarnk_id_p);
  pra_pka.provjeri_pkarnkisp (pkarnk_id_p);
EXCEPTION
  WHEN OTHERS THEN
    pra_pka2.clob_to_table (
      clob_p     => TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || CHR(10) || SQLERRM || CHR(10) || pkarnk_id_p || CHR(10) || body_p || CHR(10),
      filename_p => 'apipos-' || TO_CHAR (SYSDATE, 'YYYY-MM-DD'),
      veza_p     => NULL,
      oznaka_p   => 'APIPOS');
    RAISE;
END;
PROCEDURE UPISI_PKAPOKSIZV
 (USALI_DATE_P IN tpka_pokazatelji.datum%TYPE
 ,ORGANIZATIONAL_UNIT_P IN m_oj.sifra%TYPE
 ,USALI_ITEM_CODE_P IN mzmp_sizvjestaja.sifra%TYPE
 ,AMOUNT_P IN tpka_pok_sizv.ostvareno%TYPE
 )
 IS
-- MISH API; API USAD / Posting USALI Data
-- upis stavke pokazatelja uspjenosti u PKA

  CURSOR pkapok_c (datum_k IN tpka_pokazatelji.datum%TYPE) IS
    SELECT id
      FROM tpka_pokazatelji
     WHERE datum = datum_k;

  CURSOR pkapoksizv_c (
    oj_id_k       IN tpka_pok_sizv.oj_id%TYPE,
    zmpsizv_id_k  IN tpka_pok_sizv.zmpsizv_id%TYPE,
    pkapok_id_k   IN tpka_pok_sizv.pkapok_id%TYPE)
  IS
    SELECT id
      FROM tpka_pok_sizv
     WHERE oj_id = oj_id_k
       AND zmpsizv_id = zmpsizv_id_k
       AND pkapok_id = pkapok_id_k;

  pkapok_id_l     tpka_pokazatelji.id%TYPE;
  pkapoksizv_id_l tpka_pok_sizv.id%TYPE;

  oj_id_l         m_oj.id%TYPE;
  zmpsizv_id_l    mzmp_sizvjestaja.id%TYPE;
  -- ozn_izvedena_l  mzmp_sizvjestaja.ozn_izvedena%TYPE;
  datum_l         tpka_pokazatelji.datum%TYPE  := usali_date_p;
  -- max_dat_l       tpka_pokazatelji.datum%TYPE;
  ostvareno_l     tpka_pok_sizv.ostvareno%TYPE := amount_p;
  opis_l          lpka_promjene.opis%TYPE;
BEGIN
  opis_l :=
    SUBSTR (
      'usali_date ' || usali_date_p ||
        ', organizational_unit ' || organizational_unit_p ||
        ', usali_item_code ' || usali_item_code_p ||
        ', amount ' || amount_p,
      1,
      2000);

  IF pra_zmp_s.oznaka ('P0044') = 0 THEN
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  -- IRN 3575; prelazak na EUR
  IF pra_pka_domval.pkaprod_gotova = -1 THEN
    NULL;
  ELSE
    RAISE_APPLICATION_ERROR (-20000, 'Konverzija podataka u EUR jo nije gotova!');
  END IF;

  -- Pogrena vrijednost ulaznog parametra (#0)!
  IF usali_date_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'usali_date');
  ELSIF organizational_unit_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'organizational_unit');
  ELSIF usali_item_code_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'usali_item_code');
  ELSIF amount_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'amount');
  END IF;

  -- SELECT NVL (MAX (datum), TRUNC (SYSDATE, 'RRRR')) INTO max_dat_l FROM ipka_izvjestaji WHERE ozn_ostvareno = -1;
  -- IRN 3523 upisati podatke iako je DI ve izraunat
  IF datum_l > TRUNC (SYSDATE)
    -- OR datum_l <= max_dat_l
  THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'usali_date ' || usali_date_p);
  END IF;

  SELECT MIN (id) INTO oj_id_l FROM m_oj WHERE sifra = organizational_unit_p;
  IF oj_id_l IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'organizational_unit ' || organizational_unit_p);
  END IF;

  SELECT MIN (id) INTO zmpsizv_id_l FROM mzmp_sizvjestaja WHERE sifra = usali_item_code_p AND ozn_izvedena = 0;
  IF zmpsizv_id_l IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'usali_item_code ' || usali_item_code_p);
  END IF;

  OPEN pkapok_c (datum_l);
  FETCH pkapok_c INTO pkapok_id_l;
  IF pkapok_c%NOTFOUND THEN
    CLOSE pkapok_c;
    pkapok_id_l := pra_zmp_zaj.i3_sekvenca (NULL);
    INSERT INTO tpka_pokazatelji (id, datum) VALUES (pkapok_id_l, datum_l);
  ELSE
    CLOSE pkapok_c;
  END IF;

  OPEN pkapoksizv_c (oj_id_l, zmpsizv_id_l, pkapok_id_l);
  FETCH pkapoksizv_c INTO pkapoksizv_id_l;
  IF pkapoksizv_c%FOUND THEN
    CLOSE pkapoksizv_c;
    -- Redak s takvim podacima ve postoji!
    pra_zmp_zaj.vrati_poruku_zaj ('REC', -20526);
  END IF;
  CLOSE pkapoksizv_c;
  INSERT INTO tpka_pok_sizv (
      pkapok_id, oj_id, zmpsizv_id, ostvareno)
    VALUES (
      pkapok_id_l, oj_id_l, zmpsizv_id_l, ostvareno_l);

  -- COMMIT u ORDS-u --

EXCEPTION
  WHEN OTHERS THEN
    pra_pka_iud.puni_pkapro ('MISHAPI', '0002', SUBSTR (SQLERRM || ' | ' || opis_l, 1, 2000), 0);
    RAISE;
END;
PROCEDURE HNB_VRATI_STANJE
 (PKAADR_RBR_P IN mpka_adrese.rbr%TYPE
 ,DATUM_P IN tpka_kar_rnk.datum%TYPE
 ,NAC_SIFRA_P IN m_nacpot.sifra%TYPE
 ,STANJE_SUBVENCIJE_P OUT tpka_kartice.izn_odobren%TYPE
 ,STANJE_SUBVENCIJE2_P OUT tpka_kar_rnk.izn_popusta2%TYPE
 ,STANJE_PREDUJMA_P OUT tpka_kartice.izn_odobren%TYPE
 )
 IS
/*
IRN 3623
MISH API GAS HNB - Provjera stanja
Procedura vraa za zaposlenika (pkaadr_rbr_p) i datum (datum_p):
- stanje_subvencije_p --> stanje subvencije (= doputeni iznos popusta)
- stanje_predujma_p   --> stanje predujma
IRN 4015
- stanje_subvencije2_p --> stanje oporezive neprenosive subvencije (= doputeni iznos popusta 2)
*/
  opis_l       lpka_promjene.opis%TYPE;
  pkaadr_id_l  mpka_adrese.id%TYPE;
  nac_id_l     tpka_kar_rnk.nac_id%TYPE;

  CURSOR pkakar_c IS
    SELECT dat_poc,
           dat_zav,
           NVL (izn_odobren, 0) - NVL (izn_potrosen, 0) AS stanje_predujma
      FROM tpka_kartice
     WHERE oznaka = 'V'
       AND pkaadr_id = pkaadr_id_l
       AND ozn_prepaid = -1
       AND (dat_poc IS NULL OR dat_poc <= datum_p)
       AND (dat_zav IS NULL OR dat_zav >= datum_p)
     ORDER BY id DESC; -- zadnje upisana
  pkakar_c_l pkakar_c%ROWTYPE;
BEGIN

  opis_l :=
    SUBSTR (
      'maticni_broj_zaposlenika ' || pkaadr_rbr_p ||
        ', datum_dostave ' || TO_CHAR (datum_p, 'DD.MM.RRRR') ||
        ', cjenik ' || nac_sifra_p,
      1,
      2000);

  SELECT MIN (id) INTO pkaadr_id_l
    FROM mpka_adrese
   WHERE rbr = LPAD (TRIM (pkaadr_rbr_p), 6, '0');
  IF pkaadr_id_l IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'maticni_broj_zaposlenika');
  END IF;

  IF datum_p IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'datum_dostave');
  END IF;

  SELECT MIN (id) INTO nac_id_l
    FROM m_nacpot
   WHERE sifra = nac_sifra_p;
  IF nac_id_l IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'cjenik');
  END IF;

  -- poetak i zavretak zaposlenja zaposlenika upisan je u Pay Card
  OPEN pkakar_c;
  FETCH pkakar_c INTO pkakar_c_l;
  IF pkakar_c%NOTFOUND THEN -- ne postoji valjana i vaea kartica zaposlenika
    CLOSE pkakar_c;
    RETURN; -- izlaz
  END IF;
  CLOSE pkakar_c;

  stanje_subvencije_p  := pra_pos_pka.stanje_subvencije (datum_p, pkakar_c_l.dat_poc, pkakar_c_l.dat_zav, pkaadr_id_l, nac_id_l);
  stanje_subvencije2_p := pra_pos_pka.stanje_subvencije2 (datum_p, pkaadr_id_l, nac_id_l); -- IRN 4015
  stanje_predujma_p    := pkakar_c_l.stanje_predujma;

EXCEPTION
  WHEN OTHERS THEN
    -- API GAS HNB - Provjera stanja
    pra_pka_iud.puni_pkapro ('MISHAPI', '0004', SUBSTR (SQLERRM || ' | ' || opis_l, 1, 2000), 0);
    RAISE;
END;
PROCEDURE HNB_INSERT_PKAKARRNK
 (PKAADR_RBR_P IN mpka_adrese.rbr%TYPE
 ,DATUM_P IN tpka_kar_rnk.datum%TYPE
 ,NAC_SIFRA_P IN m_nacpot.sifra%TYPE
 ,GMPKAS_SIFRA_P IN mgmp_kase.sifra%TYPE
 ,RBR_NAR_P IN tpka_kar_rnk.rbr_nar%TYPE
 ,IZN_POPUSTA_P IN tpka_kar_rnk.izn_popusta%TYPE
 ,IZN_POPUSTA2_P IN tpka_kar_rnk.izn_popusta2%TYPE
 ,IZNOS_P IN tpka_kar_rnk.iznos%TYPE
 ,ID_P OUT tpka_kar_rnk.id%TYPE
 )
 IS
/*
IRN 3623
MISH API GAS HNB - Rezervacija sredstava
*/
  opis_l      lpka_promjene.opis%TYPE;
  pkaadr_id_l mpka_adrese.id%TYPE;

  CURSOR pkakar_c IS
    SELECT id, dat_poc, dat_zav,
           NVL (izn_odobren, 0) - NVL (izn_potrosen, 0) AS stanje_predujma
      FROM tpka_kartice
     WHERE oznaka = 'V'
       AND pkaadr_id = pkaadr_id_l
       AND ozn_prepaid = -1
       AND (dat_poc IS NULL OR dat_poc <= datum_p)
       AND (dat_zav IS NULL OR dat_zav >= datum_p)
     ORDER BY id DESC; -- zadnje upisana
  pkakar_dat_poc_l     tpka_kartice.dat_poc%TYPE;
  pkakar_dat_zav_l     tpka_kartice.dat_zav%TYPE;
  pkakarrnk_row_l      tpka_kar_rnk%ROWTYPE;
  stanje_predujma_l    tpka_kartice.izn_odobren%TYPE;
  stanje_subvencije_l  tpka_kartice.izn_odobren%TYPE;
  stanje_subvencije2_l tpka_kar_rnk.izn_popusta2%TYPE; -- IRN 4015
BEGIN

  -- IRN 3715; rbr_p --> rbr_nar_p
  opis_l :=
    SUBSTR (
      '[POST] maticni_broj_zaposlenika ' || pkaadr_rbr_p ||
        ', datum_dostave ' || TO_CHAR (datum_p, 'DD.MM.RRRR') ||
        ', cjenik ' || nac_sifra_p ||
        ', blagajna ' || gmpkas_sifra_p ||
        ', redni_broj_narudzbe ' || rbr_nar_p ||
        ', iznos_subvencije ' || izn_popusta_p ||
        ', iznos_subvencije2 ' || izn_popusta2_p ||
        ', iznos_predujma ' || iznos_p,
      1,
      2000);

  pkakarrnk_row_l := NULL; -- IRN 3715

  -- Pogrena vrijednost ulaznog parametra (#0)!
  IF rbr_nar_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'redni_broj_narudzbe');
  ELSIF datum_p IS NULL OR datum_p < TRUNC (SYSDATE) THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'datum_dostave');
  END IF;

  SELECT MIN (id) INTO pkaadr_id_l
    FROM mpka_adrese
   WHERE rbr = LPAD (TRIM (pkaadr_rbr_p), 6, '0');
  IF pkaadr_id_l IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'maticni_broj_zaposlenika');
  END IF;

  OPEN pkakar_c;
  FETCH pkakar_c INTO pkakarrnk_row_l.pkakar_id, pkakar_dat_poc_l, pkakar_dat_zav_l, stanje_predujma_l;
  CLOSE pkakar_c;
  IF pkakarrnk_row_l.pkakar_id IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'maticni_broj_zaposlenika');
  END IF;

  SELECT MIN (id) INTO pkakarrnk_row_l.gmpkas_nar_id -- IRN 3771
    FROM mgmp_kase
   WHERE sifra = gmpkas_sifra_p;
  IF pkakarrnk_row_l.gmpkas_nar_id IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'blagajna');
  END IF;

  SELECT MIN (id) INTO pkakarrnk_row_l.nac_id
    FROM m_nacpot
   WHERE sifra = nac_sifra_p;
  IF pkakarrnk_row_l.nac_id IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'cjenik');
  END IF;

  IF NVL (izn_popusta_p, 0) < 0 THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'iznos_subvencije');
  ELSIF NVL (izn_popusta2_p, 0) < 0 THEN -- IRN 4015
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'iznos_subvencije2');
  ELSIF NVL (iznos_p, 0) < 0 THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'iznos_predujma');
  ELSIF NVL (izn_popusta_p, 0) > 0
    OR NVL (izn_popusta2_p, 0) > 0
    OR NVL (iznos_p, 0) > 0
  THEN
    -- Provjeri ima li dovoljno neoporezive subvencije
    stanje_subvencije_l :=
      pra_pos_pka.stanje_subvencije (
        datum_p, pkakar_dat_poc_l, pkakar_dat_zav_l, pkaadr_id_l, pkakarrnk_row_l.nac_id);
    IF NVL (stanje_subvencije_l, 0) - NVL (izn_popusta_p, 0) < 0 THEN
      -- Nema dovoljno sredstava (neoporezive subvencije).
      pra_pka_zaj.vrati_poruku (-20249);
    END IF;
    -- IRN 4015; Provjeri ima li dovoljno oporezive subvencije
    stanje_subvencije2_l := pra_pos_pka.stanje_subvencije2 (datum_p, pkaadr_id_l, pkakarrnk_row_l.nac_id);
    IF NVL (stanje_subvencije2_l, 0) - NVL (izn_popusta2_p, 0) < 0 THEN
      -- Nema dovoljno sredstava (oporezive subvencije).
      pra_pka_zaj.vrati_poruku (-20124);
    END IF;
    IF NVL (stanje_predujma_l, 0) - NVL (iznos_p, 0) < 0 THEN
      -- Nema dovoljno sredstava (predujma).
      pra_pka_zaj.vrati_poruku (-20250);
    END IF;
  END IF;

  pkakarrnk_row_l.id := pra_zmp_zaj.i3_sekvenca (NULL);
  -- pkakar_id        -- ve napunjeno
  -- gmpkas_id
  pkakarrnk_row_l.god_poslovna := TO_CHAR (datum_p, 'RRRR');
  pkakarrnk_row_l.rbr_nar := LPAD (TRIM (rbr_nar_p), 6, '0');
  pkakarrnk_row_l.datum := datum_p;
  pkakarrnk_row_l.iznos := NVL (iznos_p, 0);
  pkakarrnk_row_l.unos_korisnik := 'MISHAPI';
  pkakarrnk_row_l.unos_dat := SYSDATE;
  -- izmjena_korisnik -- puni BIR
  -- izmjena_dat      -- puni BIR
  pkakarrnk_row_l.oznaka := 2; -- koritenje
  -- nac_id           -- ve napunjeno
  pkakarrnk_row_l.izn_rnk := NVL (iznos_p, 0);
  pkakarrnk_row_l.izn_popusta := NVL (izn_popusta_p, 0);
  pkakarrnk_row_l.izn_popusta2 := NVL (izn_popusta2_p, 0); -- IRN 4015
  -- oj_id            -- puni BIR
  -- gmpkas_nar_id    -- ve napunjeno
  INSERT INTO tpka_kar_rnk VALUES pkakarrnk_row_l;

  id_p := pkakarrnk_row_l.id;

EXCEPTION
  WHEN OTHERS THEN
    -- API GAS HNB - Rezervacija sredstava
    pra_pka_iud.puni_pkapro ('MISHAPI', '0005', SUBSTR (SQLERRM || ' | ' || opis_l, 1, 2000), 0);
    RAISE;
END;
PROCEDURE HNB_UPDATE_PKAKARRNK
 (ID_P IN tpka_kar_rnk.id%TYPE
 ,DATUM_P IN tpka_kar_rnk.datum%TYPE
 ,IZN_POPUSTA_P IN tpka_kar_rnk.izn_popusta%TYPE
 ,IZN_POPUSTA2_P IN tpka_kar_rnk.izn_popusta2%TYPE
 ,IZNOS_P IN tpka_kar_rnk.iznos%TYPE
 ,ODGOVOR_P OUT VARCHAR2
 )
 IS
/*
IRN 3623
MISH API GAS HNB - Rezervacija sredstava
*/
  opis_l               lpka_promjene.opis%TYPE;

  CURSOR pkakarrnk_c IS
    SELECT pkakarrnk.god_poslovna, pkakarrnk.gmpkas_id, pkakarrnk.rbr,
           pkakar.dat_poc, pkakar.dat_zav, pkakar.pkaadr_id, pkakarrnk.nac_id
      FROM tpka_kar_rnk pkakarrnk,
           tpka_kartice pkakar
     WHERE pkakarrnk.id = id_p
       AND pkakarrnk.pkakar_id = pkakar.id;
  pkakarrnk_c_l        pkakarrnk_c%ROWTYPE;

  br_redaka_l          NUMBER;
  stanje_subvencije_l  tpka_kartice.izn_odobren%TYPE;
  stanje_subvencije2_l tpka_kar_rnk.izn_popusta2%TYPE; -- IRN 4015
  stanje_predujma_l    tpka_kartice.izn_odobren%TYPE;
BEGIN

  opis_l :=
    SUBSTR (
      '[PUT] rezervacija_id ' || id_p ||
        ', datum_dostave ' || TO_CHAR (datum_p, 'DD.MM.RRRR') ||
        ', iznos_subvencije ' || izn_popusta_p ||
        ', iznos_subvencije2 ' || izn_popusta2_p ||
        ', iznos_predujma ' || iznos_p,
      1,
      2000);

  -- Pogrena vrijednost ulaznog parametra (#0)!
  IF id_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'rezervacija_id');
  ELSIF datum_p IS NULL OR datum_p < TRUNC (SYSDATE) THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'datum_dostave');
  END IF;

  OPEN pkakarrnk_c;
  FETCH pkakarrnk_c INTO pkakarrnk_c_l;
  IF pkakarrnk_c%NOTFOUND THEN
    CLOSE pkakarrnk_c;
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'rezervacija_id');
  END IF;
  CLOSE pkakarrnk_c;

  IF pkakarrnk_c_l.pkaadr_id IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'rezervacija_id (maticni_broj_zaposlenika)');
  END IF;

  IF pkakarrnk_c_l.nac_id IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'rezervacija_id (cjenik)');
  END IF;

  IF pkakarrnk_c_l.god_poslovna <> TO_CHAR (datum_p, 'RRRR')
    OR (pkakarrnk_c_l.dat_poc IS NOT NULL AND datum_p < pkakarrnk_c_l.dat_poc)
    OR (pkakarrnk_c_l.dat_zav IS NOT NULL AND datum_p > pkakarrnk_c_l.dat_zav)
  THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'datum_dostave');
  END IF;

  IF NVL (izn_popusta_p, 0) < 0 THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'iznos_subvencije');
  ELSIF NVL (izn_popusta2_p, 0) < 0 THEN -- IRN 4015
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'iznos_subvencije2');
  ELSIF NVL (iznos_p, 0) < 0 THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'iznos_predujma');
  END IF;

  -- Provjeri je li za narudbu ve izdan raun
  SELECT COUNT (1) INTO br_redaka_l
    FROM t_rnkase
   WHERE godina = pkakarrnk_c_l.god_poslovna
     AND kase_id = pkakarrnk_c_l.gmpkas_id
     AND rbr = pkakarrnk_c_l.rbr;
  IF br_redaka_l > 0 THEN
    -- Za rezervaciju ve postoji raun. Rezervaciju nije doputeno mijenjati.
    pra_pka_zaj.vrati_poruku (-20251);
  END IF;

  -- Provjeru iznosa predujma obavit e PKAKAR_IZN_ODOBREN_POTROSEN_CK
  UPDATE tpka_kar_rnk
     SET datum = datum_p,
         izn_popusta = NVL (izn_popusta_p, 0),
         izn_popusta2 = NVL (izn_popusta2_p, 0), -- IRN 4015
         izn_rnk = NVL (iznos_p, 0),
         iznos = NVL (iznos_p, 0)
   WHERE id = id_p;

  IF NVL (izn_popusta_p, 0) > 0 THEN
    -- Provjeri ima li dovoljno neoporezive subvencije
    stanje_subvencije_l :=
      pra_pos_pka.stanje_subvencije (
        datum_p, pkakarrnk_c_l.dat_poc, pkakarrnk_c_l.dat_zav, pkakarrnk_c_l.pkaadr_id, pkakarrnk_c_l.nac_id);
    IF NVL (stanje_subvencije_l, 0) < 0 THEN
      -- Nema dovoljno sredstava (neoporezive subvencije).
      pra_pka_zaj.vrati_poruku (-20249);
    END IF;
  END IF;

  IF NVL (izn_popusta2_p, 0) > 0 THEN -- IRN 4015
    -- Provjeri ima li dovoljno oporezive subvencije
    stanje_subvencije2_l := pra_pos_pka.stanje_subvencije2 (datum_p, pkakarrnk_c_l.pkaadr_id, pkakarrnk_c_l.nac_id);
    IF NVL (stanje_subvencije2_l, 0) < 0 THEN
      -- Nema dovoljno sredstava (oporezive subvencije).
      pra_pka_zaj.vrati_poruku (-20124);
    END IF;
  END IF;

  odgovor_p := 'OK';

EXCEPTION
  WHEN OTHERS THEN
    -- API GAS HNB - Rezervacija sredstava
    pra_pka_iud.puni_pkapro ('MISHAPI', '0005', SUBSTR (SQLERRM || ' | ' || opis_l, 1, 2000), 0);
    RAISE;
END;
PROCEDURE HNB_DELETE_PKAKARRNK
 (ID_P IN tpka_kar_rnk.id%TYPE
 ,ODGOVOR_P OUT VARCHAR2
 )
 IS
/*
IRN 3623
MISH API GAS HNB - Rezervacija sredstava
*/
  opis_l              lpka_promjene.opis%TYPE;

  CURSOR pkakarrnk_c IS
    SELECT god_poslovna, gmpkas_id, rbr, datum
      FROM tpka_kar_rnk
     WHERE id = id_p;
  pkakarrnk_c_l       pkakarrnk_c%ROWTYPE;

  br_redaka_l         NUMBER;
BEGIN

  opis_l := '[DELETE] rezervacija_id ' || id_p;

  -- Pogrena vrijednost ulaznog parametra (#0)!
  IF id_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'rezervacija_id');
  END IF;

  OPEN pkakarrnk_c;
  FETCH pkakarrnk_c INTO pkakarrnk_c_l;
  IF pkakarrnk_c%NOTFOUND THEN
    CLOSE pkakarrnk_c;
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'rezervacija_id');
  END IF;
  CLOSE pkakarrnk_c;
  
  IF pkakarrnk_c_l.datum < TRUNC (SYSDATE) THEN 
    -- Datum rezervacije #0 manji je od tekueg datuma. Rezervaciju nije doputeno ponititi.
    pra_pka_zaj.vrati_poruku (-20252, TO_CHAR (pkakarrnk_c_l.datum, 'DD.MM.RRRR'));
  END IF;
  
  -- Provjeri je li za narudbu ve izdan raun
  SELECT COUNT (1) INTO br_redaka_l
    FROM t_rnkase
   WHERE godina = pkakarrnk_c_l.god_poslovna
     AND kase_id = pkakarrnk_c_l.gmpkas_id
     AND rbr = pkakarrnk_c_l.rbr;
  IF br_redaka_l > 0 THEN
    -- Za rezervaciju ve postoji raun. Rezervaciju nije doputeno ponititi.
    pra_pka_zaj.vrati_poruku (-20253);
  END IF;

  DELETE FROM tpka_kar_rnk WHERE id = id_p;

  odgovor_p := 'OK';

EXCEPTION
  WHEN OTHERS THEN
    -- API GAS HNB - Rezervacija sredstava
    pra_pka_iud.puni_pkapro ('MISHAPI', '0005', SUBSTR (SQLERRM || ' | ' || opis_l, 1, 2000), 0);
    RAISE;
END;
PROCEDURE HNB_PROVJERI_PKAKARRNK
 (DATUM_P IN tpka_kar_rnk.datum%TYPE
 ,GMPKAS_ID_P IN tpka_kar_rnk.gmpkas_id%TYPE
 ,RBR_P IN tpka_kar_rnk.rbr%TYPE
 ,IZNOS_P IN tpka_kar_rnk.iznos%TYPE
 ,IZN_POPUSTA_P IN tpka_kar_rnk.izn_popusta%TYPE
 ,IZN_POPUSTA2_P IN tpka_kar_rnk.izn_popusta2%TYPE := NULL
 )
 IS
-- IRN 3623
-- poziva se iz procedure pra_gas_api.hnb_storniraj_predujam

  CURSOR pkakarrnk_c IS
    SELECT datum, oznaka, iznos, izn_popusta, izn_popusta2
      FROM tpka_kar_rnk
     WHERE god_poslovna = TO_CHAR (datum_p, 'RRRR')
       AND gmpkas_id = gmpkas_id_p
       AND rbr = LPAD (TRIM (rbr_p), 6, '0');
  pkakarrnk_c_l pkakarrnk_c%ROWTYPE;
BEGIN

  OPEN pkakarrnk_c;
  FETCH pkakarrnk_c INTO pkakarrnk_c_l;
  IF pkakarrnk_c%NOTFOUND THEN
    CLOSE pkakarrnk_c;
    -- Ne postoji rezervacija sredstava za narudbu/raun broj #0.
    pra_pka_zaj.vrati_poruku (-20254, rbr_p);
  END IF;
  CLOSE pkakarrnk_c;

  IF pkakarrnk_c_l.datum <> datum_p THEN
    -- Datum rauna #0 nije jednak datumu dostave #1.
    pra_pka_zaj.vrati_poruku (-20255, TO_CHAR (datum_p, 'DD.MM.RRRR'), TO_CHAR (pkakarrnk_c_l.datum, 'DD.MM.RRRR'));
  ELSIF pkakarrnk_c_l.oznaka <> 2 THEN -- 2 = koritenje
    -- Pogrena oznaka rezervacije sredstava #0.
    pra_pka_zaj.vrati_poruku (-20256, pkakarrnk_c_l.oznaka);
  ELSIF pkakarrnk_c_l.iznos <> NVL (iznos_p, 0) THEN
    -- Iskoriteni iznos predujma #0 nije jednak rezerviranom #1.
    pra_pka_zaj.vrati_poruku (-20257, iznos_p, pkakarrnk_c_l.iznos);
  ELSIF NVL (pkakarrnk_c_l.izn_popusta, 0) <> NVL (izn_popusta_p, 0) THEN
    -- Iskoriteni iznos neoporezive subvencije #0 nije jednak rezerviranom #1.
    pra_pka_zaj.vrati_poruku (-20258, izn_popusta_p, pkakarrnk_c_l.izn_popusta);
  ELSIF NVL (pkakarrnk_c_l.izn_popusta2, 0) <> NVL (izn_popusta2_p, 0) THEN -- IRN 4015
    -- Iskoriteni iznos oporezive subvencije #0 nije jednak rezerviranom #1.
    pra_pka_zaj.vrati_poruku (-20125, izn_popusta2_p, pkakarrnk_c_l.izn_popusta2);
  END IF;

END;
FUNCTION CUSTOMER_BY_PAYCARD
 (PAYCARD_NUMBER_P IN tpka_kartice.broj%TYPE
 ,INVOICE_DATETIME_P IN tpka_kartice.dat_poc%TYPE := SYSDATE
 ,POS_CODE_P IN mgmp_kase.sifra%TYPE
 )
 RETURN SYS_REFCURSOR
 IS
-- IRN 3631
-- API POS - Get Customer by Pay Card
  opis_l             lpka_promjene.opis%TYPE;
  invoice_datetime_l tpka_kartice.dat_poc%TYPE;
  odlazak_na_dan_l   NUMBER := 0;
  curs_l             sys_refcursor;
BEGIN

  opis_l :=
    SUBSTR (
      'paycard_number ' || paycard_number_p ||
        ', invoice_datetime ' || TO_CHAR (invoice_datetime_p, 'DD.MM.RRRR HH24:MI') ||
        ', pos_code ' || pos_code_p,
      1,
      2000);

  IF pra_zmp_s.oznaka ('P0017') = 0 THEN
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  -- Pogrena vrijednost ulaznog parametra (#0)!
  IF paycard_number_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'paycard_number');
  -- invoice_datetime
  ELSIF pos_code_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'pos_code');
  END IF;

  invoice_datetime_l := NVL (invoice_datetime_p, SYSDATE);

  SELECT MIN (ozn_knjizenja) INTO odlazak_na_dan_l
    FROM mgmp_kase
   WHERE sifra = pos_code_p;
  IF odlazak_na_dan_l IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'pos_code');
  END IF;

  OPEN curs_l FOR
    SELECT
      customer_type,
      customer_code,
      customer_name,
      pkakar.id AS paycard_id,
      pkakar.zmpojr_id AS pc_id,
      zmpojr.sifra AS pc_code,
      zmpojr.naziv AS pc_name
    FROM
      tpka_kartice pkakar,
      m_oj zmpojr,
      (
      -- Gost
      SELECT
        'Guest' AS customer_type,
        gost.id AS customer_id,
        gost.god_poslovna || '-' || so.sifra || '-' || gost.rbr || ' (' || sj.broj || ')' AS customer_code,
        gost.ime || ' ' || gost.prezime AS customer_name
      FROM
        t_gosti gost,
        m_sj sj,
        m_so so
      WHERE
        gost.ozn_prisutnosti = 'P'
        AND NVL (gost.ozn_rnk, -1) = -1
        AND TRUNC (invoice_datetime_l) BETWEEN gost.dat_dolaska AND gost.dat_odlaska - 1 - NVL (gost.ozn_rnk, odlazak_na_dan_l)
        AND gost.sj_id = sj.id
        AND sj.so_id = so.id
      UNION
      -- Agencija
      SELECT
        'Agency' AS customer_type,
        id AS customer_id,
        sifra AS customer_code,
        naziv AS customer_name
      FROM
        m_agencije
      UNION
      -- Adresa
      SELECT
        'Address' AS customer_type,
        id AS customer_id,
        rbr AS customer_code,
        DECODE (prezime, NULL, naz_poduzeca, TRIM (ime || ' ' || prezime)) AS customer_name
      FROM
        mpka_adrese
      ) korisnik
    WHERE
      pkakar.zmpojr_id = zmpojr.id
      AND (pkakar.gost_id || pkakar.age_id || pkakar.pkaadr_id) = korisnik.customer_id
      AND UPPER (pkakar.broj) = UPPER (paycard_number_p)
      AND pkakar.oznaka = 'V'
      AND invoice_datetime_l BETWEEN NVL (pkakar.dat_poc, invoice_datetime_l) AND NVL (pkakar.dat_zav, invoice_datetime_l);

  RETURN curs_l;

EXCEPTION
  WHEN OTHERS THEN
    pra_pka_iud.puni_pkapro ('MISHAPI', '0001', SUBSTR (SQLERRM || ' | ' || opis_l, 1, 2000), 0);
    RAISE;
END;
PROCEDURE POST_CHARGE_PAYCARD
 (PC_ID_P IN tpka_kartice.zmpojr_id%TYPE
 ,POS_CODE_P IN mgmp_kase.sifra%TYPE
 ,PAYCARD_ID_P IN tpka_kartice.id%TYPE
 ,INVOICE_YEAR_P IN tpka_rnkasa.god_poslovna%TYPE
 ,INVOICE_NUMBER_P IN tpka_rnkasa.rbr%TYPE
 ,INVOICE_DATE_P IN tpka_rnkasa.datum%TYPE := TRUNC (SYSDATE)
 ,TOTAL_P IN tpka_rnkasa.izn_placanja%TYPE
 ,TAX_AMOUNT_P IN tpka_rnkasa.izn_ppot%TYPE
 ,TAX_RATE_P IN tpka_rnkasa.stopa_ppot%TYPE
 ,TAX_BASE_AMOUNT_P IN tpka_rnkasa.izn_osnovice_ppot%TYPE
 ,DISCOUNT_AMOUNT_P IN tpka_rnkasa.izn_popusta%TYPE
 ,CANCELED_INVOICE_YEAR_P IN tpka_rnkasa.god_poslovna%TYPE
 ,CANCELED_INVOICE_NUMBER_P IN tpka_rnkasa.rbr%TYPE
 ,INVOICE_ID_P OUT tpka_rnkasa.id%TYPE
 )
 IS
-- IRN 3631
-- API POS -> /pos/paycard/{paycard_id}/charge
-- IRN 4110; brisani parametri pkapd_zki_p, pkapd_jir_p i pkapd_napomena_p

  opis_l         lpka_promjene.opis%TYPE;
  invoice_date_l tpka_rnkasa.datum%TYPE;
  gmpkase_id_l   mgmp_kase.id%TYPE;

  CURSOR pkakar_c IS
    SELECT ozn_prepaid, gost_id, age_id, pkaadr_id
      FROM tpka_kartice
     WHERE id = paycard_id_p
       AND (canceled_invoice_number_p IS NOT NULL -- doputeno je knjiiti poniteni raun na ponitenu karticu
           OR
           (oznaka = 'V'
            AND invoice_date_l BETWEEN NVL (dat_poc, invoice_date_l) AND NVL (dat_zav, invoice_date_l))
           );
  pkakar_c_l     pkakar_c%ROWTYPE;

  ozn_irn_l      s_vplacanja.ozn_irn%TYPE;
  CURSOR vpla_c IS
    SELECT id
      FROM s_vplacanja
     WHERE ozn_irn = ozn_irn_l
     ORDER BY sifra;
  vpla_id_l      s_vplacanja.id%TYPE;

  invoice_id_l   tpka_rnkasa.id%TYPE;
BEGIN

  opis_l :=
    SUBSTR (
      'pc_id ' || pc_id_p ||
        ', pos_code ' || pos_code_p ||
        ', *paycard_id ' || paycard_id_p ||
        ', invoice_year ' || invoice_year_p ||
        ', invoice_number ' || invoice_number_p ||
        ', invoice_date ' || TO_CHAR (invoice_date_p, 'DD.MM.RRRR') ||
        ', total ' || total_p ||
        ', tax_amount ' || tax_amount_p ||
        ', tax_rate ' || tax_rate_p ||
        ', tax_base_amount ' || tax_base_amount_p ||
        ', discount_amount ' || discount_amount_p ||
        ', canceled_invoice_year ' || canceled_invoice_year_p ||
        ', canceled_invoice_number ' || canceled_invoice_number_p ||
        ', canceled_invoice_number ' || canceled_invoice_number_p,
      1,
      2000);

  IF pra_zmp_s.oznaka ('P0018') = 0 THEN
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  -- Pogrena vrijednost ulaznog parametra (#0)!
  IF pc_id_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'pc_id');
  ELSIF pos_code_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'pos_code');
  ELSIF paycard_id_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'paycard_id');
  ELSIF invoice_year_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'invoice_year');
  ELSIF invoice_number_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'invoice_number');
  -- invoice_date
  ELSIF total_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'total');
  -- tax_amount
  -- tax_rate
  -- tax_base_amount
  -- discount_amount
  -- canceled_invoice_year
  -- canceled_invoice_number
  END IF;

  invoice_date_l := TRUNC (NVL (invoice_date_p, SYSDATE));

  SELECT MIN (id) INTO gmpkase_id_l FROM mgmp_kase WHERE sifra = pos_code_p;
  IF gmpkase_id_l IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'pos_code ' || pos_code_p);
  END IF;

  IF canceled_invoice_year_p IS NULL AND canceled_invoice_number_p IS NOT NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'canceled_invoice_year');
  ELSIF canceled_invoice_year_p IS NOT NULL AND canceled_invoice_number_p IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'canceled_invoice_number');
  END IF;

  OPEN pkakar_c;
  FETCH pkakar_c INTO pkakar_c_l;
  IF pkakar_c%NOTFOUND THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'paycard_id ' || paycard_id_p);
  END IF;

  IF pkakar_c_l.gost_id IS NOT NULL THEN
    ozn_irn_l := '1';
  ELSIF pkakar_c_l.age_id IS NOT NULL THEN
    ozn_irn_l := '2';
  ELSIF pkakar_c_l.pkaadr_id IS NOT NULL THEN
    ozn_irn_l := '3';
  ELSE
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'paycard_id ' || paycard_id_p);
  END IF;

  OPEN vpla_c;
  FETCH vpla_c INTO vpla_id_l;
  CLOSE vpla_c;
  IF vpla_id_l IS NULL THEN
    -- Ne postoji vrsta plaanja s oznakom IRN = #0.
    pra_zmp_zaj.vrati_poruku (-20259, ozn_irn_l);
  END IF;

  pra_pos_pka.insert_racun_objekt (
    zmpojr_id_p         => pc_id_p,
    gmpkas_id_p         => gmpkase_id_l,
    vpla_id_p           => vpla_id_l,
    gostp_id_p          => pkakar_c_l.gost_id,
    agep_id_p           => pkakar_c_l.age_id,
    pkaadrp_id_p        => pkakar_c_l.pkaadr_id,
    god_poslovna_p      => invoice_year_p,
    rbr_p               => invoice_number_p,
    datum_p             => invoice_date_l,
    izn_placanja_p      => total_p,
    izn_ppot_p          => NVL (tax_amount_p, 0),
    opis1_p             => NULL,
    opis2_p             => NULL,
    recara_id_p         => NULL,
    vpdog_id_p          => NULL,
    nac_id_p            => NULL,
    stopa_ppot_p        => NVL (tax_rate_p, 0),
    izn_osnovice_ppot_p => NVL (tax_base_amount_p, 0),
    pkakar_id_p         => paycard_id_p,
    gost_id_p           => pkakar_c_l.gost_id,
    age_id_p            => pkakar_c_l.age_id,
    pkaadr_id_p         => pkakar_c_l.pkaadr_id,
    izn_popusta_p       => discount_amount_p,
    god_poslovna_izv_p  => canceled_invoice_year_p,
    rbr_izv_p           => canceled_invoice_number_p,
    pkarnk_id_p         => invoice_id_l);

  IF pkakar_c_l.ozn_prepaid = 0 THEN
    INSERT INTO tpka_kar_rnk (
      pkakar_id, gmpkas_id, god_poslovna, rbr, datum,
      iznos, oznaka,
      nac_id, izn_rnk, izn_popusta)
    VALUES (
      paycard_id_p, gmpkase_id_l, invoice_year_p, LPAD (invoice_number_p, 6, '0'), invoice_date_l,
      0, 2,
      NULL, total_p, discount_amount_p);
  END IF;

  invoice_id_p := invoice_id_l;

EXCEPTION
  WHEN OTHERS THEN
    pra_pka_iud.puni_pkapro ('MISHAPI', '0001', SUBSTR (SQLERRM || ' | ' || opis_l, 1, 2000), 0);
    RAISE;
END;
PROCEDURE KZ_ZAJ_PUNI_LOG
 IS
-- IRN 3771; puni log komunikacije u tablicu lpka_clob
  log_file_name_l VARCHAR2(100);
BEGIN
  -- KZ; Spremati komunikaciju u log: 1 = da ili 0 = ne.
  IF pra_zmp_zaj.zmppar_vrijednost ('MISHAPI', '1011') = 0
    AND sqlerrm_m IS NULL
  THEN
    RETURN;
  END IF;

  log_file_name_l := 'apikz-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '.log';
  pra_pka2.clob_to_table ('[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || ']' || CHR(10), log_file_name_l, NULL, 'APIKZ');

  IF sqlerrm_m IS NULL THEN
    -- upii opis u log
    pra_pka2.clob_to_table (opis_m || CHR(10), log_file_name_l, NULL, 'APIKZ');
  ELSE
    IF pra_zmp_zaj.zmppar_vrijednost ('MISHAPI', '1011') = 0 THEN
      -- upii i opis i pogreku u log
      pra_pka2.clob_to_table (opis_m || CHR(10), log_file_name_l, NULL, 'APIKZ');
      pra_pka2.clob_to_table (sqlerrm_m || CHR(10), log_file_name_l, NULL, 'APIKZ');
    ELSE
      -- upii pogreku u log
      pra_pka2.clob_to_table (sqlerrm_m || CHR(10), log_file_name_l, NULL, 'APIKZ');
    END IF;
  END IF;

  sqlerrm_m := NULL;

END;
PROCEDURE KZ_INSERT_PKAKAR
 (BROJ_P IN tpka_kartice.broj%TYPE
 ,VRIJEDI_DO_P IN tpka_kartice.dat_zav%TYPE
 ,IME_P IN tpka_kartice.ime%TYPE
 ,PREZIME_P IN tpka_kartice.prezime%TYPE
 ,SIFRA1_P IN tpka_kartice.sifra%TYPE
 ,SIFRA2_P IN tpka_kartice.sifra2%TYPE
 ,OJ1_P IN m_oj.sifra%TYPE
 ,OJ2_P IN m_oj.sifra%TYPE
 ,OPIS_P IN tpka_kartice.opis%TYPE
 ,OZN_IMA_REPREZENTACIJU_P IN NUMBER
 ,ID_P OUT tpka_kartice.id%TYPE
 )
 IS
-- IRN 3771; APIKZ; Upii podatke o kartici zaposlenika
  pkakar_row_l   tpka_kartice%ROWTYPE;
  cvor_l         VARCHAR2(41);
  zmppar_sifra_l szmp_parametri.sifra%TYPE;
BEGIN

  opis_m :=
    SUBSTR (
      '[KZ POST] broj ' || broj_p ||
        ', vrijedi_do ' || TO_CHAR (vrijedi_do_p, 'DD.MM.RRRR HH24:MI') ||
        ', ime ' || ime_p ||
        ', prezime ' || prezime_p ||
        ', sifra1 ' || sifra1_p ||
        ', sifra2 ' || sifra2_p ||
        ', oj1 ' || oj1_p ||
        ', oj2 ' || oj2_p ||
        ', opis ' || opis_p ||
        ', reprezentacija ' || ozn_ima_reprezentaciju_p,
      1,
      2000);

  pra_pka_api.kz_zaj_puni_log;

  -- Pogrena vrijednost ulaznog parametra (#0)!
  IF broj_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'broj');
  ELSIF vrijedi_do_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'vrijedi_do');
  ELSIF ime_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'ime');
  ELSIF prezime_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'prezime');
  ELSIF sifra1_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'sifra1');
  ELSIF sifra2_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'sifra2');
  ELSIF oj1_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'oj1_p');
  -- oj2
  -- opis
  ELSIF ozn_ima_reprezentaciju_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'reprezentacija');
  END IF;

  IF oj2_p IS NOT NULL AND oj2_p = oj1_p THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'oj2');
  END IF;

  pkakar_row_l := NULL;

  SELECT MIN (id) INTO pkakar_row_l.zmpojr_id
    FROM m_oj
   WHERE sifra = pra_zmp_zaj.zmppar_vrijednost ('MISHAPI', '1013'); -- KZ; ifra knjige rauna na koju treba povezati kartice zaposlenika ili nebitno.
  IF pkakar_row_l.zmpojr_id IS NULL THEN
    -- Provjerite vrijednost #0 parametra #1!
    pra_zmp_zaj.vrati_poruku (-20100, 'MISHAPI', '1013');
  END IF;

  -- ORDS skripta poziva proceduru kao <cvor>.pra_pka_api.kz_insert_pkakar
  SELECT MIN (metcvor_sifra) INTO cvor_l FROM mzmp_ojr WHERE id = pkakar_row_l.zmpojr_id;
  IF NVL (cvor_l, '') <> pra_zmp_zaj.tekuci_cvor THEN
    -- Provjerite vrijednost #0 parametra #1!
    pra_zmp_zaj.vrati_poruku (-20100, 'MISHAPI', '1013');
  END IF;

  -- id        -- RETURNING
  -- zmpojr_id -- ve uitano

  SELECT MIN (id) INTO pkakar_row_l.pkaadr_id
    FROM mpka_adrese
   WHERE rbr = pra_zmp_zaj.zmppar_vrijednost ('MISHAPI', '1012'); -- KZ; Rbr adrese korisnika kartice ili nebitno.
  IF pkakar_row_l.pkaadr_id IS NULL THEN
    -- Provjerite vrijednost #0 parametra #1!
    pra_zmp_zaj.vrati_poruku (-20100, 'MISHAPI', '1012');
  END IF;

  pkakar_row_l.broj := broj_p;
  pkakar_row_l.oznaka := 'V';
  pkakar_row_l.ozn_izvan_oj := -1;
  pkakar_row_l.dat_poc := SYSDATE; -- nove kartice vrijede od tekueg datuma
  pkakar_row_l.dat_zav := vrijedi_do_p;

  IF pkakar_row_l.dat_zav < pkakar_row_l.dat_poc THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'vrijedi_do'); -- jer nove kartice vrijede od tekueg datuma
  END IF;

  pkakar_row_l.ime := SUBSTR (ime_p, 1, 20);
  pkakar_row_l.prezime := SUBSTR (prezime_p, 1, 40);
  -- pin
  -- izn_odobren
  -- izn_potrosen
  pkakar_row_l.unos_korisnik := 'MISHAPI';
  pkakar_row_l.unos_dat := SYSDATE;
  -- izmjena_korisnik, izmjena_dat
  pkakar_row_l.ozn_jednokratna := 0;

  SELECT MIN (id) INTO pkakar_row_l.nac_id
    FROM m_nacpot
   WHERE sifra = pra_zmp_zaj.zmppar_vrijednost ('MISHAPI', '1014'); -- KZ; ifra naina potronje "Zaposlenici" ili nebitno.
  IF pkakar_row_l.nac_id IS NULL THEN
    -- Provjerite vrijednost #0 parametra #1!
    pra_zmp_zaj.vrati_poruku (-20100, 'MISHAPI', '1014');
  END IF;

  -- stopa_popusta_pos1
  -- stopa_popusta_pos2
  -- kcsus_id
  pkakar_row_l.ozn_prepaid := -1;

  IF ozn_ima_reprezentaciju_p = -1 THEN
    IF oj2_p IS NULL THEN
      zmppar_sifra_l := '1015'; -- KZ; ifra naina potronje "Reprezentacija" ili nebitno.
    ELSE
      zmppar_sifra_l := '1016'; -- KZ; ifra naina potronje "Reprezentacija izvan matinog drutva" ili nebitno.
    END IF;
    SELECT MIN (id) INTO pkakar_row_l.nac2_id
      FROM m_nacpot
     WHERE sifra = pra_zmp_zaj.zmppar_vrijednost ('MISHAPI', zmppar_sifra_l);
    IF pkakar_row_l.nac2_id IS NULL THEN
      -- Provjerite vrijednost #0 parametra #1!
      pra_zmp_zaj.vrati_poruku (-20100, 'MISHAPI', zmppar_sifra_l);
    END IF;
  END IF;

  pkakar_row_l.ozn_nfc := 0;
  pkakar_row_l.sifra := sifra1_p;

  SELECT MIN (id) INTO pkakar_row_l.oj_id FROM m_oj WHERE sifra = oj1_p;
  IF pkakar_row_l.oj_id IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'oj1');
  END IF;

  -- izn_limita2

  pkakar_row_l.oj_sifra_izv := oj2_p;
  pkakar_row_l.sifra2 := sifra2_p;
  pkakar_row_l.opis := opis_p;

  INSERT INTO tpka_kartice VALUES pkakar_row_l RETURNING id INTO id_p;

  opis_m := 'id ' || id_p || CHR(10);
  pra_pka_api.kz_zaj_puni_log;

EXCEPTION
  WHEN OTHERS THEN
    sqlerrm_m := SQLERRM || CHR(10);
    pra_pka_api.kz_zaj_puni_log;
    RAISE;
END;
PROCEDURE KZ_UPDATE_PKAKAR
 (BROJ_P IN tpka_kartice.broj%TYPE
 ,VRIJEDI_DO_P IN tpka_kartice.dat_zav%TYPE
 ,IME_P IN tpka_kartice.ime%TYPE
 ,PREZIME_P IN tpka_kartice.prezime%TYPE
 ,SIFRA1_P IN tpka_kartice.sifra%TYPE
 ,SIFRA2_P IN tpka_kartice.sifra2%TYPE
 ,OJ1_P IN m_oj.sifra%TYPE
 ,OJ2_P IN m_oj.sifra%TYPE
 ,OPIS_P IN tpka_kartice.opis%TYPE
 ,OZN_IMA_REPREZENTACIJU_P IN NUMBER
 ,ID_P OUT tpka_kartice.id%TYPE
 )
 IS
-- IRN 3771; APIKZ; Promijeni podatke o kartici zaposlenika
  pkakar_row_l   tpka_kartice%ROWTYPE;
  zmppar_sifra_l szmp_parametri.sifra%TYPE;
BEGIN

  opis_m :=
    SUBSTR (
      '[KZ PUT] broj ' || broj_p ||
        ', vrijedi_do ' || TO_CHAR (vrijedi_do_p, 'DD.MM.RRRR HH24:MI') ||
        ', ime ' || ime_p ||
        ', prezime ' || prezime_p ||
        ', sifra1 ' || sifra1_p ||
        ', sifra2 ' || sifra2_p ||
        ', oj1 ' || oj1_p ||
        ', oj2 ' || oj2_p ||
        ', opis ' || opis_p ||
        ', reprezentacija ' || ozn_ima_reprezentaciju_p,
      1,
      2000);

  pra_pka_api.kz_zaj_puni_log;

  -- Pogrena vrijednost ulaznog parametra (#0)!
  IF broj_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'broj');
  ELSIF vrijedi_do_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'vrijedi_do');
  ELSIF ime_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'ime');
  ELSIF prezime_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'prezime');
  ELSIF sifra1_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'sifra1');
  ELSIF sifra2_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'sifra2');
  ELSIF oj1_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'oj1');
  -- oj2
  -- opis
  ELSIF ozn_ima_reprezentaciju_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'reprezentacija');
  END IF;

  IF oj2_p IS NOT NULL AND oj2_p = oj1_p THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'oj2');
  END IF;

  pkakar_row_l := NULL;

  IF ozn_ima_reprezentaciju_p = -1 THEN
    IF oj2_p IS NULL THEN
      zmppar_sifra_l := '1015'; -- KZ; ifra naina potronje "Reprezentacija" ili nebitno.
    ELSE
      zmppar_sifra_l := '1016'; -- KZ; ifra naina potronje "Reprezentacija izvan matinog drutva" ili nebitno.
    END IF;
    SELECT MIN (id) INTO pkakar_row_l.nac2_id
      FROM m_nacpot
     WHERE sifra = pra_zmp_zaj.zmppar_vrijednost ('MISHAPI', zmppar_sifra_l);
    IF pkakar_row_l.nac2_id IS NULL THEN
      -- Provjerite vrijednost #0 parametra #1!
      pra_zmp_zaj.vrati_poruku (-20100, 'MISHAPI', zmppar_sifra_l);
    END IF;
  END IF;

  SELECT MIN (id) INTO pkakar_row_l.oj_id FROM m_oj WHERE sifra = oj1_p;
  IF pkakar_row_l.oj_id IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'oj1');
  END IF;

  UPDATE tpka_kartice
     SET nac2_id = pkakar_row_l.nac2_id,
         dat_zav = vrijedi_do_p,
         ime = SUBSTR (ime_p, 1, 20),
         prezime = SUBSTR (prezime_p, 1, 40),
         sifra = sifra1_p,
         oj_id = pkakar_row_l.oj_id,
         oj_sifra_izv = oj2_p,
         sifra2 = sifra2_p,
         opis = opis_p
   WHERE broj = broj_p
     AND oznaka = 'V'
   RETURNING id INTO id_p;

  opis_m := 'id ' || id_p || CHR(10);
  pra_pka_api.kz_zaj_puni_log;

EXCEPTION
  WHEN OTHERS THEN
    sqlerrm_m := SQLERRM || CHR(10);
    pra_pka_api.kz_zaj_puni_log;
    RAISE;
END;
PROCEDURE KZ_PONISTI_PKAKAR
 (BROJ_P IN tpka_kartice.broj%TYPE
 ,ID_P OUT tpka_kartice.id%TYPE
 )
 IS
-- IRN 3771; APIKZ; Poniti zapis o kartici zaposlenika
BEGIN

  opis_m :=
    SUBSTR (
      '[KZ DELETE] broj ' || broj_p,
      1,
      2000);

  pra_pka_api.kz_zaj_puni_log;

  -- Pogrena vrijednost ulaznog parametra (#0)!
  IF broj_p IS NULL THEN
    pra_zmp_zaj.vrati_poruku (-20099, 'broj');
  END IF;

  UPDATE tpka_kartice
     SET oznaka = 'P'
   WHERE broj = broj_p
     AND oznaka = 'V'
   RETURNING id INTO id_p;

  opis_m := 'id ' || id_p || CHR(10);
  pra_pka_api.kz_zaj_puni_log;

EXCEPTION
  WHEN OTHERS THEN
    sqlerrm_m := SQLERRM || CHR(10);
    pra_pka_api.kz_zaj_puni_log;
    RAISE;
END;

END PRA_PKA_API;
/
SHOW ERROR

