PROMPT Creating Package Body 'PRA_PKA2'
CREATE OR REPLACE PACKAGE BODY PRA_PKA2 IS

TENANCY_NAME_M CONSTANT VARCHAR2(50) := 'virgacloud';
COMPARTMENT_NAME_M CONSTANT VARCHAR2(50) := 'HR_Virga_MISH';
PASSWORD_M CONSTANT VARCHAR2(50) := 'M72mi9xBtFsgDC';


FUNCTION CLOB_LENGTH
 (CLOB_P IN CLOB
 )
 RETURN NUMBER
 IS
-- duljina clob_p kakva bi bila kada bi clob_p bio konvertiran u utf-8
  length_l NUMBER := NULL;
  bufsize_l NUMBER := 2000;
  no_of_pieces_l NUMBER := NULL;
  amount_l NUMBER := NULL;
  start_l NUMBER := 1;
  string_l VARCHAR2 (10000) := NULL;
  return_l NUMBER := 0;
BEGIN
  IF clob_p IS NULL THEN -- IRN 2436
    RETURN (return_l);
  END IF;
  length_l := DBMS_LOB.getlength (clob_p);
  no_of_pieces_l := TRUNC (length_l / bufsize_l) + SIGN (MOD (length_l, bufsize_l));

  FOR i IN 1 .. no_of_pieces_l LOOP
    amount_l := LEAST (bufsize_l, length_l - start_l + 1);
    string_l := DBMS_LOB.SUBSTR (clob_p, amount_l, start_l);

    FOR j IN 1 .. LENGTH (string_l) LOOP
      return_l := return_l + LENGTHB (CONVERT (SUBSTR (string_l, j, 1), 'UTF8'));
    END LOOP;

    start_l := start_l + bufsize_l;
  END LOOP;

  RETURN (return_l);
END;
PROCEDURE CLOB_TO_FILE
 (CLOB_P IN CLOB
 ,PARPRI_SIFRA_P IN s_parametri_prijepisa.sifra%TYPE
 ,FILE_NAME_P IN VARCHAR2
 ,OPEN_MODE_P IN VARCHAR2 := 'w'
 ,OZN_NCHAR_P IN NUMBER := 0
 ,OZN_DODAJ_BOM_P IN NUMBER := 0
 )
 IS
-- spremi clob u datoteku
  staza_l s_parametri_prijepisa.staza%TYPE;
  file_type_l UTL_FILE.file_type;
  amt_l NUMBER DEFAULT 32000;
  offset_l NUMBER DEFAULT 1;
  length_l NUMBER DEFAULT NVL (DBMS_LOB.getlength (clob_p), 0);
BEGIN
  IF file_name_p IS NULL
    OR parpri_sifra_p IS NULL
  THEN
    RETURN;
  END IF;

  SELECT MIN (staza) INTO staza_l FROM s_parametri_prijepisa WHERE sifra = parpri_sifra_p;
  IF staza_l IS NULL OR staza_l = 'nebitno' THEN
    RETURN;
  END IF;

  IF ozn_nchar_p = -1 THEN -- IRN 2436
    file_type_l := UTL_FILE.fopen_nchar (staza_l, file_name_p, open_mode_p, 32760);
  ELSE
    file_type_l := UTL_FILE.fopen (staza_l, file_name_p, open_mode_p, 32760);
  END IF;

  IF ozn_dodaj_bom_p = -1 THEN -- IRN 2436
    UTL_FILE.put_raw (file_type_l, HEXTORAW ('EFBBBF'), TRUE);
  END IF;

  length_l := NVL (DBMS_LOB.getlength (clob_p), 0);

  WHILE (offset_l < length_l) LOOP
    IF ozn_nchar_p = -1 THEN -- IRN 2436
      UTL_FILE.put_nchar (file_type_l, DBMS_LOB.SUBSTR (clob_p, amt_l, offset_l));
    ELSE
      UTL_FILE.put (file_type_l, DBMS_LOB.SUBSTR (clob_p, amt_l, offset_l));
    END IF;
    UTL_FILE.fflush (file_type_l);
    offset_l := offset_l + amt_l;
  END LOOP;

  UTL_FILE.new_line (file_type_l);
  UTL_FILE.fclose (file_type_l);
EXCEPTION
  WHEN OTHERS THEN
    IF UTL_FILE.is_open (file_type_l) THEN
      UTL_FILE.fclose (file_type_l);
    END IF;
END;
PROCEDURE CLOB_TO_TABLE
 (CLOB_P IN CLOB
 ,FILENAME_P IN VARCHAR2
 ,VEZA_P IN lpka_clob.veza%TYPE
 ,OZNAKA_P IN VARCHAR2
 )
 IS
-- IRN 2969
  PRAGMA AUTONOMOUS_TRANSACTION;

  CURSOR pkaclob_c IS
    SELECT data
      FROM lpka_clob
     WHERE opis = filename_p
       AND NVL (veza, 0) = NVL (veza_p, 0)
       FOR UPDATE NOWAIT;
  data_l CLOB;
BEGIN

  IF clob_p IS NULL
    OR NVL (DBMS_LOB.getlength (clob_p), 0) = 0
  THEN
    RETURN;
  END IF;

  OPEN pkaclob_c;
  FETCH pkaclob_c INTO data_l;
  IF pkaclob_c%FOUND THEN
    DBMS_LOB.append (data_l, clob_p);
    UPDATE lpka_clob
       SET data = data_l
     WHERE CURRENT OF pkaclob_c;
  ELSE
    INSERT INTO lpka_clob (data, opis, veza, oznaka) VALUES (clob_p, filename_p, veza_p, oznaka_p);
  END IF;
  CLOSE pkaclob_c;
  COMMIT;
EXCEPTION
  WHEN OTHERS THEN
    IF pkaclob_c%ISOPEN THEN
      CLOSE pkaclob_c;
    END IF;

    -- IRN 3991
    IF SQLCODE = -54 THEN -- resource busy and acquire with NOWAIT specified or timeout expired
      INSERT INTO lpka_clob (data, opis, veza, oznaka) VALUES (clob_p, filename_p, veza_p, oznaka_p);
      COMMIT;
    ELSE
      RAISE;
    END IF;
END;
PROCEDURE CLOB_TO_TABLE_VAR
 (VAR_P IN VARCHAR2
 ,NAZIV_P IN VARCHAR2
 ,VEZA_P IN lpka_clob.veza%TYPE
 ,OZNAKA_P IN VARCHAR2
 )
 IS
BEGIN
  clob_to_table (TO_CLOB(var_p), naziv_p, veza_p, oznaka_p);
END;
PROCEDURE SALJI_HTML_EMAIL
 (RECIPIENT_P IN VARCHAR2
 ,RECIPIENT_H_P IN VARCHAR2
 ,SENDER_P IN VARCHAR2
 ,SENDER_H_P IN VARCHAR2
 ,BCC_P IN VARCHAR2
 ,SUBJECT_P IN VARCHAR2
 ,TEXT_P IN VARCHAR2
 ,HOST_P IN VARCHAR2 := NULL
 ,PORT_P IN VARCHAR2 := NULL
 ,HTML_P IN CLOB := NULL
 ,ATTACH_NAME1_P IN VARCHAR2 := NULL
 ,ATTACH_MIME1_P IN VARCHAR2 := NULL
 ,ATTACH_BLOB1_P IN BLOB := NULL
 ,ATTACH_NAME2_P IN VARCHAR2 := NULL
 ,ATTACH_MIME2_P IN VARCHAR2 := NULL
 ,ATTACH_BLOB2_P IN BLOB := NULL
 ,ATTACH_NAME3_P IN VARCHAR2 := NULL
 ,ATTACH_MIME3_P IN VARCHAR2 := 'text/plain'
 ,ATTACH_STAZA3_P IN VARCHAR2 := NULL
 ,ATTACH_CLOB3_P IN CLOB := NULL
 )
 IS
-- IRN 2584; alji e-poruku s pdf dokumentom u privitku
-- IRN 2782; alji e-poruku s csv dokumentom u privitku
-- IRN 2930; UTF8 u zaglavlju i bcc
-- IRN 3628; attach_clob3_p
  conn_l     UTL_SMTP.connection;
  boundary_l VARCHAR2(20) := 'a1b2c3d4e3f2g1';
  step_l     PLS_INTEGER := 6000; -- make sure you set a multiple of 3
  sender_l   szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.vrijednost_parametra ('0993'); -- potrebno za AUTH LOGIN
  password_l szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.vrijednost_parametra ('0994'); -- potrebno za AUTH LOGIN
  charset_l  szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.vrijednost_parametra ('0071');
  host_l VARCHAR2(4000);
  port_l VARCHAR2(4000);

  ft_l UTL_FILE.file_type; -- IRN 2782
  line_l VARCHAR2(1024);   -- IRN 2782

  CURSOR ver_c IS SELECT banner FROM v$version; -- IRN 2930
  ver_c_l ver_c%ROWTYPE;
  redak_l VARCHAR2(4000);

  recipients_h_l VARCHAR2(1024); -- IRN 3991

  FUNCTION convert2utf8 (redak_p IN VARCHAR2) RETURN VARCHAR2 IS -- IRN 2930
  BEGIN
    IF redak_p IS NULL THEN
      RETURN (redak_p);
    END IF;
    -- baza 9i ne podrava UTL_ENCODE.text_encode zato se koristi EXECUTE IMMEDIATE
    EXECUTE IMMEDIATE 'SELECT REPLACE (UTL_ENCODE.text_encode (:redak_p, ''UTF8''), ''='' || CHR(13) || CHR(10)) FROM dual'
      INTO redak_l USING redak_p;
    RETURN (redak_l);
  END convert2utf8;

  PROCEDURE pisi_redak (redak_p IN VARCHAR2) IS
  BEGIN
    UTL_SMTP.write_raw_data (conn_l, UTL_RAW.cast_to_raw (redak_p));
    UTL_SMTP.write_data (conn_l, UTL_TCP.crlf);
  END pisi_redak;
BEGIN

  IF host_p IS NULL THEN
    host_l := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0069');
  ELSE
    host_l := host_p;
  END IF;

  IF port_p IS NULL THEN
    port_l := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0070');
  ELSE
    port_l := port_p;
  END IF;

  conn_l := UTL_SMTP.open_connection (host => host_l, port => port_l);
  IF sender_l = 'nebitno' OR password_l = 'nebitno' THEN
    UTL_SMTP.helo (conn_l, host_l);
  ELSE
    UTL_SMTP.ehlo (conn_l, host_l);
    UTL_SMTP.command (conn_l, 'AUTH LOGIN');
    UTL_SMTP.command (conn_l, UTL_RAW.cast_to_varchar2 (UTL_ENCODE.base64_encode (UTL_RAW.cast_to_raw (sender_l))));
    UTL_SMTP.command (conn_l, UTL_RAW.cast_to_varchar2 (UTL_ENCODE.base64_encode (UTL_RAW.cast_to_raw (password_l))));
  END IF;

  UTL_SMTP.mail (conn_l, sender_p);

  FOR mail_list_c IN (
    SELECT LEVEL AS id,
           REGEXP_SUBSTR (recipient_p, '[^;|^ |^,]+', 1, LEVEL) AS addss
      FROM dual
   CONNECT BY REGEXP_SUBSTR (recipient_p, '[^;|^ |^,]+', 1, LEVEL) IS NOT NULL)
  LOOP
    UTL_SMTP.rcpt (conn_l, mail_list_c.addss);
    -- IRN 3991
    IF recipients_h_l IS NOT NULL THEN
      recipients_h_l := recipients_h_l || ',';
    END IF;
    recipients_h_l := recipients_h_l || '<' || mail_list_c.addss || '>';
    -- KRAJ IRN 3991
  END LOOP;

  IF bcc_p IS NOT NULL THEN
    UTL_SMTP.rcpt (conn_l, bcc_p);
  END IF;

  UTL_SMTP.open_data (conn_l);

  UTL_SMTP.write_data (conn_l, 'Date: ' || TO_CHAR (SYSTIMESTAMP, 'Dy, dd Mon yyyy hh24:mi:ss tzhtzm', 'NLS_DATE_LANGUAGE = American') || UTL_TCP.crlf);

  OPEN ver_c;
  FETCH ver_c INTO ver_c_l;
  CLOSE ver_c;

  IF sender_h_p IS NULL THEN
    pisi_redak ('From: <' || sender_p || '>');
  ELSE
    pisi_redak ('From: =?UTF-8?Q?' || convert2utf8 (sender_h_p) || '?= <' || sender_p || '>');
  END IF;

  IF INSTR (recipient_p, ',') = 0 THEN -- IRN 3991
    IF recipient_h_p IS NULL THEN
      pisi_redak ('To: <' || recipient_p || '>');
    ELSE
      pisi_redak ('To: =?UTF-8?Q?' || convert2utf8 (recipient_h_p) || '?= <' || recipient_p || '>');
    END IF;
  ELSE
    pisi_redak ('To: ' || recipients_h_l); -- IRN 3991
  END IF;

  IF subject_p IS NOT NULL THEN
    pisi_redak ('Subject: =?UTF-8?Q?' || convert2utf8 (subject_p) || '?=');
  END IF;

  UTL_SMTP.write_data (conn_l, 'MIME-Version: 1.0' || UTL_TCP.crlf);
  UTL_SMTP.write_data (conn_l, 'Content-Type: multipart/mixed; boundary=' || CHR(34) || boundary_l || CHR(34) || UTL_TCP.crlf || UTL_TCP.crlf);

  IF text_p IS NOT NULL THEN
    UTL_SMTP.write_data (conn_l, '--' || boundary_l || UTL_TCP.crlf);
    IF INSTR (text_p, '<!DOCTYPE html>') > 0 THEN -- IRN 3284
      UTL_SMTP.write_data (conn_l, 'Content-Type: text/html; charset=' || charset_l || UTL_TCP.crlf || UTL_TCP.crlf);
    ELSE
      UTL_SMTP.write_data (conn_l, 'Content-Type: text/plain; charset=' || charset_l || UTL_TCP.crlf || UTL_TCP.crlf);
    END IF;

    UTL_SMTP.write_raw_data (conn_l, UTL_RAW.cast_to_raw (text_p));
    UTL_SMTP.write_data (conn_l, UTL_TCP.crlf || UTL_TCP.crlf);
  END IF;

  IF html_p IS NOT NULL THEN
    UTL_SMTP.write_data (conn_l, '--' || boundary_l || UTL_TCP.crlf);
    UTL_SMTP.write_data (conn_l, 'Content-Type: text/html; charset=' || charset_l || UTL_TCP.crlf || UTL_TCP.crlf);

    FOR i IN 0 .. TRUNC ((DBMS_LOB.getlength (html_p) - 1) / step_l) LOOP
      UTL_SMTP.write_raw_data (conn_l, UTL_RAW.cast_to_raw (DBMS_LOB.substr (html_p, step_l, i * step_l + 1)));
      -- UTL_SMTP.write_data (conn_l, DBMS_LOB.substr (html_p, step_l, i * step_l + 1));
    END LOOP;

    UTL_SMTP.write_data (conn_l, UTL_TCP.crlf || UTL_TCP.crlf);
  END IF;

  IF attach_name1_p IS NOT NULL THEN
    UTL_SMTP.write_data (conn_l, '--' || boundary_l || UTL_TCP.crlf);
    UTL_SMTP.write_data (conn_l, 'Content-Type: ' || attach_mime1_p || '; name="' || attach_name1_p || '"' || UTL_TCP.crlf);
    UTL_SMTP.write_data (conn_l, 'Content-Transfer-Encoding: base64' || UTL_TCP.crlf);
    UTL_SMTP.write_data (conn_l, 'Content-Disposition: attachment; filename="' || attach_name1_p || '"' || UTL_TCP.crlf || UTL_TCP.crlf);

    FOR i IN 0 .. TRUNC ((DBMS_LOB.getlength (attach_blob1_p) - 1) / step_l) LOOP
      UTL_SMTP.write_data (conn_l, UTL_RAW.cast_to_varchar2 (UTL_ENCODE.base64_encode (DBMS_LOB.substr (attach_blob1_p, step_l, i * step_l + 1))));
    END LOOP;

    UTL_SMTP.write_data (conn_l, UTL_TCP.crlf || UTL_TCP.crlf);
  END IF;

  IF attach_name2_p IS NOT NULL THEN
    UTL_SMTP.write_data (conn_l, '--' || boundary_l || UTL_TCP.crlf);
    UTL_SMTP.write_data (conn_l, 'Content-Type: ' || attach_mime2_p || '; name="' || attach_name2_p || '"' || UTL_TCP.crlf);
    UTL_SMTP.write_data (conn_l, 'Content-Transfer-Encoding: base64' || UTL_TCP.crlf);
    UTL_SMTP.write_data (conn_l, 'Content-Disposition: attachment; filename="' || attach_name2_p || '"' || UTL_TCP.crlf || UTL_TCP.crlf);

    FOR i IN 0 .. TRUNC ((DBMS_LOB.getlength (attach_blob2_p) - 1) / step_l) LOOP
      UTL_SMTP.write_data (conn_l, UTL_RAW.cast_to_varchar2 (UTL_ENCODE.base64_encode (DBMS_LOB.substr (attach_blob2_p, step_l, i * step_l + 1))));
    END LOOP;

    UTL_SMTP.write_data (conn_l, UTL_TCP.crlf || UTL_TCP.crlf);
  END IF;

  -- IRN 2782
  IF attach_name3_p IS NOT NULL THEN
    UTL_SMTP.write_data (conn_l, '--' || boundary_l || UTL_TCP.crlf);
    UTL_SMTP.write_data (conn_l, 'Content-Type: ' || attach_mime3_p || '; charset=' || charset_l || '; name="' || attach_name3_p || '"' || UTL_TCP.crlf);
    UTL_SMTP.write_data (conn_l, 'Content-Disposition: attachment; filename="' || attach_name3_p || '"' || UTL_TCP.crlf || UTL_TCP.crlf);

    -- IRN 3628
    IF attach_staza3_p IS NULL THEN
      FOR i IN 0 .. TRUNC ((DBMS_LOB.getlength (attach_clob3_p) - 1) / step_l) LOOP
        UTL_SMTP.write_raw_data (conn_l, UTL_RAW.cast_to_raw (DBMS_LOB.substr (attach_clob3_p, step_l, i * step_l + 1)));
      END LOOP;
    ELSE
      BEGIN
        ft_l := UTL_FILE.fopen_nchar (attach_staza3_p, attach_name3_p, 'R');
        LOOP
            BEGIN
              UTL_FILE.get_line_nchar (ft_l, line_l);
            EXCEPTION
              WHEN NO_DATA_FOUND THEN
                EXIT;
            END;
            line_l := line_l || CHR(10);
            UTL_SMTP.write_raw_data (conn_l, UTL_RAW.cast_to_raw (line_l));
        END LOOP;
        UTL_FILE.fclose (ft_l);
      EXCEPTION
        WHEN OTHERS THEN
          IF UTL_FILE.is_open (ft_l) THEN
            UTL_FILE.fclose (ft_l);
          END IF;
          RAISE;
      END;
    END IF;

    UTL_SMTP.write_data (conn_l, UTL_TCP.crlf || UTL_TCP.crlf);
  END IF;
  -- KRAJ IRN 2782

  UTL_SMTP.write_data (conn_l, '--' || boundary_l || '--' || UTL_TCP.crlf);
  UTL_SMTP.close_data (conn_l);

  UTL_SMTP.quit (conn_l);

EXCEPTION -- IRN 2974
  WHEN UTL_SMTP.transient_error OR UTL_SMTP.permanent_error THEN
    BEGIN
      UTL_SMTP.quit (conn_l);
    EXCEPTION
      WHEN UTL_SMTP.transient_error OR UTL_SMTP.permanent_error THEN
        /*
        When the SMTP server is down or unavailable,
        we don't have a connection to the server.
        The QUIT call raises an exception that we can ignore.
        */
        NULL;
    END;
    RAISE;
END;
FUNCTION CLOB_FROM_FILE
 (STAZA_P IN VARCHAR2
 ,FILE_NAME_P IN VARCHAR2
 ,NASTAVAK_P IN VARCHAR2 := 'html'
 ,JEZ_SIFRA_3A_P IN s_jezici.sifra_3a%TYPE := NULL
 ,OZN_NCHAR_P IN NUMBER := 0
 )
 RETURN CLOB
 IS
/*
uitaj datoteku u CLOB
file_name_p mora biti s nastavkom npr. cestitka.html
nastavak_p mora biti bez toke npr. html
*/
  file_name_l VARCHAR2(100);
  clob_l CLOB;
  file_l UTL_FILE.file_type;
  buffer_l VARCHAR2(32000);
BEGIN
  IF staza_p IS NULL
    OR file_name_p IS NULL
    OR nastavak_p IS NULL
  THEN
    RETURN (NULL);
  END IF;

  IF jez_sifra_3a_p IS NOT NULL THEN
    -- npr. cestitka_eng.html
    file_name_l := REPLACE (file_name_p, '.' || nastavak_p, '_' || jez_sifra_3a_p  || '.' || nastavak_p);
    IF file_postoji (staza_p, file_name_l) = 0 THEN
      file_name_l := file_name_p;
    END IF;
  ELSE
    file_name_l := file_name_p;
  END IF;
  IF file_postoji (staza_p, file_name_l) = 0 THEN
    RETURN (NULL);
  END IF;

  -- sadraj datoteke stavi u CLOB
  DBMS_LOB.createtemporary (clob_l, TRUE);
  IF ozn_nchar_p = -1 THEN
    file_l := UTL_FILE.fopen_nchar (staza_p, file_name_l, 'r');
  ELSE
    file_l := UTL_FILE.fopen (staza_p, file_name_l, 'r');
  END IF;
  BEGIN
    LOOP
      UTL_FILE.get_line (file_l, buffer_l);
      DBMS_LOB.writeappend (clob_l, DBMS_LOB.getlength (buffer_l), buffer_l);
    END LOOP;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      UTL_FILE.fclose (file_l);
  END;
  RETURN (clob_l);
EXCEPTION
  WHEN OTHERS THEN
    IF UTL_FILE.is_open (file_l) THEN
      UTL_FILE.fclose (file_l);
    END IF;
    RETURN (clob_l);
END;
FUNCTION BLOB_FROM_FILE
 (STAZA_P IN VARCHAR2
 ,FILE_NAME_P IN VARCHAR2
 ,NASTAVAK_P IN VARCHAR2 := 'pdf'
 ,JEZ_SIFRA_3A_P IN s_jezici.sifra_3a%TYPE := NULL
 )
 RETURN BLOB
 IS
/*
IRN 2584; uitaj datoteku u BLOB
file_name_p mora biti s nastavkom npr. privitak.pdf
nastavak_p mora biti bez toke npr. pdf
*/
  file_name_l VARCHAR2(100);
  data_l BLOB;
  file_l UTL_FILE.file_type;
  buff_l RAW(32767);
  CURSOR ver_c IS SELECT banner FROM v$version;
  ver_c_l ver_c%ROWTYPE;
BEGIN
  IF staza_p IS NULL
    OR file_name_p IS NULL
    OR nastavak_p IS NULL
  THEN
    RETURN (NULL);
  END IF;

  IF jez_sifra_3a_p IS NOT NULL THEN
    -- npr. privitak_eng.pdf
    file_name_l := REPLACE (file_name_p, '.' || nastavak_p, '_' || jez_sifra_3a_p  || '.' || nastavak_p);
    IF file_postoji (staza_p, file_name_l) = 0 THEN
      file_name_l := file_name_p;
    END IF;
  ELSE
    file_name_l := file_name_p;
  END IF;
  IF file_postoji (staza_p, file_name_l) = 0 THEN
    RETURN (NULL);
  END IF;

  OPEN ver_c;
  FETCH ver_c INTO ver_c_l;
  CLOSE ver_c;

  DBMS_LOB.createtemporary (lob_loc => data_l, cache => TRUE, dur => DBMS_LOB.call);
  IF SUBSTR (ver_c_l.banner, 1, 8) IN ('Oracle9i') THEN
    /*
    ako je open_mode = RB (= read byte mode) onda na Oracle9i javlja greku npr.
    ORA-29261: bad argument
    ORA-06512: at "SYS.UTL_ENCODE", line 132
    ORA-06512: at "SYS.UTL_ENCODE", line 132
    ORA-06512: at "I3RAZVOJ.PRA_PKA2", line 244
    a 244 redak je
    UTL_SMTP.write_data (conn_l, UTL_RAW.cast_to_varchar2 (UTL_ENCODE.base64_encode (DBMS_LOB.substr (attach_blob1_p, step_l, i * step_l + 1))));
    */
    file_l := UTL_FILE.fopen (staza_p, file_name_l, 'R', 32767); -- open_mode na bazi 9 mora biti 'R'
  ELSE
    file_l := UTL_FILE.fopen (staza_p, file_name_l, 'RB', 32767);
  END IF;
  LOOP
    BEGIN
      IF SUBSTR (ver_c_l.banner, 1, 8) IN ('Oracle9i') THEN
        UTL_FILE.get_raw (file_l, buff_l, 32767);
      ELSE
        UTL_FILE.get_raw (file_l, buff_l);
      END IF;
      EXIT WHEN buff_l IS NULL;
      DBMS_LOB.writeappend (data_l, UTL_RAW.length (buff_l), buff_l);
    EXCEPTION
      WHEN NO_DATA_FOUND THEN
        EXIT;
    END;
  END LOOP;

  UTL_FILE.fclose (file_l);

  RETURN (data_l);

EXCEPTION
  WHEN OTHERS THEN
    IF UTL_FILE.is_open (file_l) THEN
      UTL_FILE.fclose (file_l);
    END IF;
    RETURN (data_l);
END;
FUNCTION FILE_POSTOJI
 (STAZA_P IN VARCHAR2
 ,FILE_NAME_P IN VARCHAR2
 )
 RETURN NUMBER
 IS
-- IRN 2584; vraa -1 ako file postoji
  file_exists_l BOOLEAN := FALSE;
  file_length_l NUMBER;
  block_size_l  BINARY_INTEGER;
BEGIN
  IF staza_p IS NULL
    OR file_name_p IS NULL
  THEN
    RETURN (0);
  END IF;

  UTL_FILE.fgetattr (staza_p, file_name_p, file_exists_l, file_length_l, block_size_l);
  IF file_exists_l THEN
    RETURN (-1);
  END IF;

  RETURN (0);
END;
FUNCTION PKACLOB_DATA_PART
 (ID_P IN NUMBER
 ,LENGTH_P IN NUMBER
 ,START_P IN NUMBER
 ,AMOUNT_P IN NUMBER
 ,TABLENAME_P IN VARCHAR2 := 'lpka_clob'
 )
 RETURN VARCHAR2
 IS
-- IRN 2969
  data_l VARCHAR2(4000);
BEGIN
  IF (start_p + amount_p) <= length_p THEN
    EXECUTE IMMEDIATE
      'SELECT DBMS_LOB.substr (data, ' || TO_CHAR(amount_p) || ', ' || TO_CHAR(start_p) || ')
         FROM ' || tablename_p || '
        WHERE id = ' || id_p
      INTO data_l;
  ELSE
    EXECUTE IMMEDIATE 
    -- IRN 3107
    'SELECT DBMS_LOB.substr (data, ' ||  TO_CHAR(length_p - start_p + 1) || ', ' || TO_CHAR(start_p) || ')
      FROM ' || tablename_p || '
     WHERE id =  ' || id_p
     INTO data_l;
  END IF;
  RETURN TO_CHAR (data_l);
END;
FUNCTION PRETTY_PRINT_XML
 (CLOB_P IN CLOB
 )
 RETURN clob
 IS
--
  clob_l CLOB;
BEGIN
  -- IRN 3284, dodan EXECUTE IMMEDIATE jer TOAD ne prepoznaje INDENT SIZE = 2
  EXECUTE IMMEDIATE
    'SELECT xmlserialize (DOCUMENT xmltype (:clob_p) AS CLOB INDENT SIZE = 2) FROM dual'
    INTO clob_l USING clob_p;
  RETURN clob_l;
END;
PROCEDURE OCI_CREATE_SENDER
 (EMAIL_P IN VARCHAR2
 )
 IS
-- IRN 3238, kreiraj odobrenog poiljatelja e-pote

  email_l lpka_senders.email%TYPE;
  br_redaka_l NUMBER;
  ocid_l lpka_senders.ocid%TYPE;
BEGIN

  IF email_p IS NULL THEN
    RETURN;
  END IF;

  email_l := LOWER (email_p);

  SELECT COUNT(1) INTO br_redaka_l FROM lpka_senders WHERE email = email_l;
  IF br_redaka_l > 0 THEN
    RETURN;
  END IF;

  BEGIN
    EXECUTE IMMEDIATE
      'SELECT oci_rest_api.oci_rest_api_email.CreateSender ( ' ||
      '  p_tenancy_name     => :tenancy_name_m, ' ||
      '  p_compartment_name => :compartment_name_m, ' ||
      '  p_email_address    => :email_l, ' ||
      '  p_password         => :password_m) ' ||
      'FROM dual'
    INTO ocid_l
    USING tenancy_name_m, compartment_name_m, email_l, password_m;
  EXCEPTION
    WHEN OTHERS THEN
      RETURN;
  END;

  IF ocid_l IS NULL THEN
    RETURN;
  END IF;

  INSERT INTO lpka_senders (email, ocid) VALUES (email_l, ocid_l);

END;
PROCEDURE OCI_DELETE_SENDER
 (OCID_P IN lpka_senders.ocid%TYPE
 )
 IS
-- IRN 3238, brii odobrenog poiljatelja e-pote
BEGIN
  IF ocid_p IS NULL THEN
    RETURN;
  END IF;
  BEGIN
    EXECUTE IMMEDIATE
      'BEGIN' ||
      '  oci_rest_api.oci_rest_api_email.DeleteSender ( ' ||
      '    p_tenancy_name     => :tenancy_name_m, ' ||
      '    p_compartment_name => :compartment_name_m, ' ||
      '    p_emailsender_ocid => :ocid_p, ' ||
      '    p_password         => :password_m); ' ||
      'END;'
    USING tenancy_name_m, compartment_name_m, ocid_p, password_m;
  EXCEPTION
    WHEN OTHERS THEN
      RETURN;
  END;
  DELETE FROM lpka_senders WHERE ocid = ocid_p;
END;
FUNCTION OCI_GET_SENDER
 (OCID_P IN lpka_senders.ocid%TYPE
 )
 RETURN VARCHAR2
 IS
-- IRN 3238, dohvati odobrenog poiljatelja e-pote
  email_l lpka_senders.email%TYPE;
BEGIN
  IF ocid_p IS NULL THEN
    RETURN (NULL);
  END IF;
  BEGIN
    EXECUTE IMMEDIATE
      'SELECT ' ||
      '  JSON_VALUE (js, ''$.emailAddress'') email ' ||
      'FROM ( ' ||
      '  SELECT ' ||
      '    oci_rest_api.oci_rest_api_email.getSender ( ' ||
      '      p_tenancy_name     => :tenancy_name_m, ' ||
      '      p_compartment_name => :compartment_name_m, ' ||
      '      p_emailsender_ocid => :ocid_p, ' ||
      '      p_password         => :password_m) js ' ||
      '  FROM dual)'
    INTO email_l
    USING tenancy_name_m, compartment_name_m, ocid_p, password_m;
  EXCEPTION
    WHEN OTHERS THEN
      RETURN (NULL);
  END;
  RETURN (email_l);
END;
PROCEDURE SALJI_SMS
 (FROM_P IN VARCHAR2
 ,TO_P IN VARCHAR2
 ,TEXT_P IN VARCHAR2
 ,ODGOVOR_P OUT CLOB
 )
 IS
-- IRN 3284; alji SMS po notaciji Infobip API
  url_l      szmp_parametri.vrijednost%TYPE;
  username_l szmp_parametri.vrijednost%TYPE;
  password_l szmp_parametri.vrijednost%TYPE;
  timeout_l  szmp_parametri.vrijednost%TYPE;
  data_l     CLOB;
  odgovor_l  CLOB;
  --
  br_dana_l       szmp_parametri.vrijednost%TYPE;
  log_file_name_l VARCHAR2(100);
  --
  recipient1_l szmp_parametri.vrijednost%TYPE;
  recipient2_l szmp_parametri.vrijednost%TYPE;
  sender_l     szmp_parametri.vrijednost%TYPE;
  sqlerrm_l    VARCHAR2(4000);
  --
  req_l  UTL_HTTP.req;
  res_l  UTL_HTTP.resp;
  line_l CLOB;
BEGIN

  IF from_p IS NULL
    OR to_p IS NULL
    OR text_p IS NULL
  THEN
    RETURN;
  END IF;

  url_l := pra_zmp_zaj.zmppar_vrijednost ('SMS', '1001');
  IF url_l = 'nebitno' THEN
    RETURN;
  END IF;

  username_l := pra_zmp_zaj.zmppar_vrijednost ('SMS', '1002');
  IF username_l = 'nebitno' THEN
    RETURN;
  END IF;

  password_l := pra_zmp_zaj.zmppar_vrijednost ('SMS', '1003');
  IF password_l = 'nebitno' THEN
    RETURN;
  END IF;

  timeout_l := pra_zmp_zaj.zmppar_vrijednost ('SMS', '1004');
  IF timeout_l = 'nebitno' THEN
    RETURN;
  END IF;

  /*

  POST /sms/2/text/single HTTP/1.1
  Host: ywkwj.api.infobip.com
  Authorization: Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==
  Content-Type: application/json
  Accept: application/json

  {
     "from":"InfoSMS",
     "to":"41793026727",
     "text":"Test SMS."
  }

  */

  data_l :=
    '{' ||
    '  "from":"' || from_p || '",' ||
    '  "to":"' || to_p || '",' ||
    '  "text":"' || text_p || '"' ||
    '}';

  -- Broj dana koliko se uvaju zapisi u logu: 1, 2, ... ili nebitno = ne briu se.
  br_dana_l := pra_zmp_zaj.zmppar_vrijednost ('SMS', '1008');
  IF br_dana_l <> 'nebitno' THEN
    DELETE FROM lpka_clob
     WHERE oznaka = 'SMS'
       AND (TRUNC (unos_dat) + TO_NUMBER (br_dana_l)) < TRUNC (SYSDATE);
  END IF;

  -- Spremati komunikaciju u log: da ili ne.
  IF pra_zmp_zaj.zmppar_vrijednost ('SMS', '1007') = 'da' THEN
    log_file_name_l := 'sms-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '.log';
    pra_pka2.clob_to_table ('[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' || url_l || CHR(10), log_file_name_l, NULL, 'SMS');
    pra_pka2.clob_to_table (data_l || CHR(10), log_file_name_l, NULL, 'SMS');
  END IF;

  -- Puni parametre za slanje obavijesti o grekama
  sender_l := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0905'); -- noreply
  -- E-adresa (1.) za slanje obavijesti o grekama ili nebitno.
  recipient1_l := pra_zmp_zaj.zmppar_vrijednost ('SMS', '1005');
  -- E-adresa (2.) za slanje obavijesti o grekama ili nebitno.
  recipient2_l := pra_zmp_zaj.zmppar_vrijednost ('SMS', '1006');

  odgovor_l := 'false ';

  UTL_HTTP.set_detailed_excp_support (enable => true);
  UTL_HTTP.set_transfer_timeout (timeout => TO_NUMBER (timeout_l));
  UTL_HTTP.set_body_charset (charset => 'UTF-8');

  req_l := UTL_HTTP.begin_request (url => url_l, method => 'POST', http_version => 'HTTP/1.1');

  UTL_HTTP.set_header (r => req_l, name => 'Content-Type', value => 'application/json; charset=utf-8');
  UTL_HTTP.set_header (req_l, 'Authorization', 'Basic ' || UTL_RAW.cast_to_varchar2 (UTL_ENCODE.base64_encode (UTL_RAW.cast_to_raw (username_l || ':' || password_l))));
  UTL_HTTP.set_header (req_l, 'Content-Length', pra_pka2.clob_length (data_l));

  UTL_HTTP.write_text (req_l, data_l);

  res_l := UTL_HTTP.get_response (req_l);

  IF res_l.status_code = UTL_HTTP.HTTP_OK THEN
    odgovor_l := NULL;
  ELSE
    odgovor_l := '[' || res_l.status_code || ':' || res_l.reason_phrase || '] ';
  END IF;

  BEGIN
    LOOP
      UTL_HTTP.read_line (res_l, line_l);
      odgovor_l := odgovor_l || line_l;
    END LOOP;
    UTL_HTTP.end_response (res_l);
  EXCEPTION
    WHEN UTL_HTTP.end_of_body THEN
      UTL_HTTP.end_response (res_l);
  END;

  odgovor_p := odgovor_l;

  IF log_file_name_l IS NOT NULL THEN
    pra_pka2.clob_to_table ('[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] Response ' || odgovor_p || CHR(10), log_file_name_l, NULL, 'SMS');
  END IF;

EXCEPTION
  WHEN OTHERS THEN
    sqlerrm_l := SUBSTR (SQLERRM, 1, 4000);
    IF log_file_name_l IS NOT NULL THEN
      pra_pka2.clob_to_table ('[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] Error ' || sqlerrm_l || CHR(10), log_file_name_l, NULL, 'SMS');
    END IF;
    IF recipient1_l <> 'nebitno' THEN
      pra_pka2.salji_html_email (
        recipient_p   => recipient1_l,
        recipient_h_p => NULL,
        sender_p      => sender_l,
        sender_h_p    => NULL,
        bcc_p         => NULL,
        subject_p     => 'Error when sending SMS',
        text_p        => sqlerrm_l);
    END IF;
    IF recipient2_l <> 'nebitno' THEN
      pra_pka2.salji_html_email (
        recipient_p   => recipient2_l,
        recipient_h_p => NULL,
        sender_p      => sender_l,
        sender_h_p    => NULL,
        bcc_p         => NULL,
        subject_p     => 'Error when sending SMS',
        text_p        => sqlerrm_l);
    END IF;
    UTL_HTTP.end_request (req_l);
    UTL_HTTP.end_response (res_l);
END;
FUNCTION REPLACE_IN_CLOB
 (CLOB_P IN CLOB
 ,REPLACE_STR_P IN VARCHAR2 := UTL_TCP.CRLF
 ,REPLACE_WITH_P IN VARCHAR2 := NULL
 )
 RETURN CLOB
 IS
-- IRN 4096; poziva se iz blob2base64
  cBuffer_l  VARCHAR2 (32767);
  nBuffer_l  BINARY_INTEGER := 32767;
  nStart_l   PLS_INTEGER := 1;
  nLen_l     PLS_INTEGER;
  clob_out_l CLOB := EMPTY_CLOB;
BEGIN
  DBMS_LOB.CreateTemporary (clob_out_l, TRUE);
  nLen_l := DBMS_LOB.GetLength (clob_p);

  WHILE nStart_l < nLen_l LOOP
    DBMS_LOB.Read (clob_p, nBuffer_l, nStart_l, cBuffer_l);
    IF cBuffer_l IS NOT NULL THEN
      cBuffer_l := REPLACE (cBuffer_l, replace_str_p, replace_with_p);
      DBMS_LOB.WriteAppend (clob_out_l, LENGTH (cBuffer_l), cBuffer_l);
    END IF;
    nStart_l := nStart_l + nBuffer_l;
  END LOOP;
  RETURN clob_out_l;
END;
FUNCTION BLOB2BASE64
 (BLOB_P IN BLOB
 )
 RETURN CLOB
 IS
-- IRN 4096; poziva se iz pra_eracun2
  clob_l CLOB;
  step_l PLS_INTEGER := 12000; -- make sure you set a multiple of 3 not higher than 24573
BEGIN
  FOR i IN 0 .. TRUNC ((DBMS_LOB.getlength (blob_p) - 1) / step_l) LOOP
    clob_l := clob_l || UTL_RAW.cast_to_varchar2 (UTL_ENCODE.base64_encode (DBMS_LOB.substr (blob_p, step_l, i * step_l + 1)));
  END LOOP;
  clob_l := replace_in_clob (clob_l);
  RETURN clob_l;
END;

END PRA_PKA2;
/
SHOW ERROR

