PROMPT Creating Package Body 'PRA_PKA'
CREATE OR REPLACE PACKAGE BODY PRA_PKA IS

PROCEDURE IZRACUNAJ_IZN_TECAJA
 (VAL_ID_P IN s_valute.id%TYPE
 ,BAN_ID_P IN m_banke.id%TYPE
 ,VTEC_ID_P IN s_vtecajeva.id%TYPE
 ,DATUM_P IN TPKA_TECAJNICE.DATUM%TYPE
 ,IZN_TECAJA_P OUT t_racuni.izn_tecaja%TYPE
 )
 IS
--
  izn_tecaja_l t_racuni.izn_tecaja%TYPE;
  datum_l DATE;
  jedinica_l s_valute.jedinica%TYPE;
  val_id_l s_valute.id%TYPE;

  CURSOR pkatecval_c IS
    SELECT tpka_tec_val.izn_tecaja
      FROM tpka_tec_val, tpka_tecajnice
     WHERE tpka_tecajnice.datum = datum_l -- IRN 2225
       AND tpka_tec_val.val_id = val_id_p
       AND tpka_tecajnice.ban_id = ban_id_p
       AND tpka_tecajnice.vtec_id = vtec_id_p
       AND tpka_tec_val.pkatec_id = tpka_tecajnice.id
     ORDER BY tpka_tecajnice.datum DESC;
BEGIN
  SELECT MIN (id) INTO val_id_l
    FROM s_valute
   WHERE sifra_3a = pra_pka_zaj.vrijednost_parametra ('0001'); -- ifra domae valute.
  IF val_id_p = val_id_l THEN
    izn_tecaja_p := 1;
  ELSE
    SELECT /*+ index (TPKA_TEC_VAL PKATECVAL_UK) */ 
           MAX (tpka_tecajnice.datum) INTO datum_l
      FROM tpka_tec_val, tpka_tecajnice
     WHERE tpka_tecajnice.datum <= datum_p
       AND tpka_tec_val.val_id = val_id_p
       AND tpka_tecajnice.ban_id = ban_id_p
       AND tpka_tecajnice.vtec_id = vtec_id_p
       AND tpka_tec_val.pkatec_id = tpka_tecajnice.id;

    OPEN pkatecval_c;
    FETCH pkatecval_c INTO izn_tecaja_l;
    IF pkatecval_c%NOTFOUND THEN
      CLOSE pkatecval_c;
      -- Iznos teaja za zadane parametre nije upisan.
      pra_pka_zaj.vrati_poruku (-20033);
    END IF;
    CLOSE pkatecval_c;

    SELECT jedinica INTO jedinica_l
      FROM s_valute
     WHERE id = val_id_p;

    izn_tecaja_p := izn_tecaja_l / jedinica_l;

  END IF;
END;
PROCEDURE IZRACUNAJ_IZN_TECAJA_PARAMETRI
 (VAL_ID_P IN s_valute.id%TYPE
 ,DATUM_P IN tpka_tecajnice.datum%TYPE
 ,IZN_TECAJA_P OUT t_racuni.izn_tecaja%TYPE
 )
 IS
--
  ban_id_l m_banke.id%TYPE;
  vtec_id_l s_vtecajeva.id%TYPE;

  CURSOR ban_c IS
    SELECT id
      FROM m_banke
     WHERE sifra = pra_pka_zaj.vrijednost_parametra ('1002');
  CURSOR vtec_c IS
    SELECT id
      FROM s_vtecajeva
     WHERE sifra = pra_pka_zaj.vrijednost_parametra ('1001');
BEGIN
  OPEN ban_c;
  FETCH ban_c INTO ban_id_l;
  IF ban_c%NOTFOUND THEN
    CLOSE ban_c;
    pra_pka_zaj.vrati_poruku (-20031); -- Nedostaje parametar za banku.
  END IF;
  CLOSE ban_c;

  OPEN vtec_c;
  FETCH vtec_c INTO vtec_id_l;
  IF vtec_c%NOTFOUND THEN
    CLOSE vtec_c;
    pra_pka_zaj.vrati_poruku (-20032); -- Nedostaje parametar za vrstu teajeva.
  END IF;
  CLOSE vtec_c;

  izracunaj_izn_tecaja (val_id_p, ban_id_l, vtec_id_l, datum_p, izn_tecaja_p);
END;
FUNCTION IZN_TECAJA
 (VAL_ID_P s_valute.id%TYPE
 ,BAN_ID_P m_banke.id%TYPE
 ,VTEC_ID_P s_vtecajeva.id%TYPE
 ,DATUM_P tpka_tecajnice.datum%TYPE
 )
 RETURN t_racuni.izn_tecaja%TYPE
 IS
-- Za domau valutu funkcija vraa iznos 1

  val_id_l s_valute.id%TYPE;
  datum_l DATE;
  jedinica_l s_valute.jedinica%TYPE;
  izn_tecaja_l t_racuni.izn_tecaja%TYPE;

  CURSOR pkatecval_c IS
    SELECT tpka_tec_val.izn_tecaja
      FROM tpka_tec_val, tpka_tecajnice
     WHERE tpka_tecajnice.datum = datum_l -- IRN 2225
       AND tpka_tec_val.val_id = val_id_p
       AND tpka_tecajnice.ban_id = ban_id_p
       AND tpka_tecajnice.vtec_id = vtec_id_p
       AND tpka_tec_val.pkatec_id = tpka_tecajnice.id
     ORDER BY tpka_tecajnice.datum DESC;
BEGIN
  SELECT MIN (id) INTO val_id_l
    FROM s_valute
   WHERE sifra_3a = pra_pka_zaj.vrijednost_parametra ('0001');
  IF val_id_p = val_id_l THEN
    RETURN 1;
  END IF;

  SELECT /*+ index (TPKA_TEC_VAL PKATECVAL_UK) */ 
         MAX (tpka_tecajnice.datum) INTO datum_l
    FROM tpka_tec_val, tpka_tecajnice
   WHERE tpka_tecajnice.datum <= datum_p
     AND tpka_tec_val.val_id = val_id_p
     AND tpka_tecajnice.ban_id = ban_id_p
     AND tpka_tecajnice.vtec_id = vtec_id_p
     AND tpka_tec_val.pkatec_id = tpka_tecajnice.id;

  OPEN pkatecval_c;
  FETCH pkatecval_c INTO izn_tecaja_l;
  IF pkatecval_c%NOTFOUND THEN
    CLOSE pkatecval_c;
    RETURN (NULL);
  END IF;
  CLOSE pkatecval_c;

  SELECT jedinica INTO jedinica_l
    FROM s_valute
   WHERE id = val_id_p;

  RETURN izn_tecaja_l / jedinica_l;
END;
FUNCTION IZN_TECAJA_PARAMETRI
 (VAL_ID_P IN s_valute.id%TYPE
 ,DATUM_P IN tpka_tecajnice.datum%TYPE
 )
 RETURN t_racuni.izn_tecaja%TYPE
 IS
--
  ban_id_l m_banke.id%TYPE;
  vtec_id_l s_vtecajeva.id%TYPE;
  CURSOR ban_c IS 
    SELECT id
      FROM m_banke
     WHERE sifra = pra_pka_zaj.vrijednost_parametra ('1002');
  CURSOR vtec_c IS 
    SELECT id 
      FROM s_vtecajeva
     WHERE sifra = pra_pka_zaj.vrijednost_parametra ('1001');
BEGIN
  OPEN ban_c;
  FETCH ban_c INTO ban_id_l;
  CLOSE ban_c;

  OPEN vtec_c;
  FETCH vtec_c INTO vtec_id_l;
  CLOSE vtec_c;

  RETURN izn_tecaja (val_id_p, ban_id_l, vtec_id_l, datum_p);
END;
PROCEDURE IZRACUNAJ_REDNI_BROJ
 (NAZ_TABLICE_P IN SPKA_BROJACI.NAZ_TABLICE%TYPE
 ,GOD_POSLOVNA_P IN SPKA_BROJACI.GOD_POSLOVNA%TYPE
 ,OJ_ID_P IN SPKA_BROJACI.OJ_ID%TYPE
 ,OZN_VDOKUMENTA_P IN SPKA_BROJACI.OZN_VDOKUMENATA%TYPE
 ,OZN_DULJINE_P IN NUMBER
 ,RBR_P IN OUT SPKA_BROJACI.RBR%TYPE
 )
 IS
/*
Redni brojevi mogu biti razliite duljine, pa se
kao ulazni parametar proslijeuje duljina rbr.
Redni broj je zerofilan.
*/

  CURSOR bro_c IS
    SELECT rbr
      FROM spka_brojaci
     WHERE naz_tablice = naz_tablice_p
       AND NVL (god_poslovna, 0) = NVL (god_poslovna_p, 0)
       AND NVL (oj_id, 0) = NVL (oj_id_p, 0)
       AND NVL (ozn_vdokumenata, 0) = NVL (ozn_vdokumenta_p, 0)
    FOR UPDATE;
  rbr_l spka_brojaci.rbr%TYPE;
BEGIN
  OPEN bro_c;
  FETCH bro_c INTO rbr_l;
  IF bro_c%FOUND THEN
    rbr_l := LPAD (TO_CHAR (rbr_l + 1), ozn_duljine_p, '0');
    UPDATE spka_brojaci
       SET rbr = rbr_l
     WHERE CURRENT OF bro_c;
  ELSE
    rbr_l := LPAD (TO_CHAR (1), ozn_duljine_p, '0');
    INSERT INTO spka_brojaci (
        naz_tablice, god_poslovna, oj_id, ozn_vdokumenata, rbr)
      VALUES (
        naz_tablice_p, god_poslovna_p, oj_id_p, ozn_vdokumenta_p, rbr_l);
  END IF;
  CLOSE bro_c;
  rbr_p := rbr_l;
EXCEPTION
  WHEN OTHERS THEN
    IF bro_c%ISOPEN THEN -- IRN 2872
      CLOSE bro_c;
    END IF;
    RAISE;
END;
PROCEDURE ZABRANI_IZMJENU_DOKUMENTA
 (OZNAKA_P IN VARCHAR2
 )
 IS
/*
Poniteni dokument se ne moe mijenjati. Procedura se nalazi u paketu PRA_PKA 
jer se koristi u TPKA_OBRACUNI, TPKA_RNKASA i TPKA_UGOVORI
*/
BEGIN
  IF oznaka_p IS NULL THEN
    RETURN;
  END IF;
  IF oznaka_p IN ('P', 'N') THEN
    pra_pka_zaj.vrati_poruku (-20016);
  END IF;
END;
PROCEDURE PROVJERI_POSTU
 (POS_ID_P IN M_POSTE.ID%TYPE
 ,ZEM_ID_P IN S_ZEMLJE.ID%TYPE
 )
 IS
/*
Ako je upisana pota u adresar onda zemlja pote
mora biti jednaka zemlji u adresaru.
Ako je upisana pota komitenta onda zemlja pote
mora biti jednaka zemlji komitenta.
*/
  zem_id_l s_zemlje.id%TYPE;
BEGIN
  IF pos_id_p IS NULL OR zem_id_p IS NULL THEN
    RETURN;
  END IF;

  SELECT zem_id INTO zem_id_l
    FROM m_poste
   WHERE id = pos_id_p;

  IF zem_id_p <> zem_id_l THEN
    pra_pka_zaj.vrati_poruku (-20015);
  END IF;
END;
PROCEDURE PROVJERI_REGIJU
 (REG_ID_P IN M_REGIJE.ID%TYPE
 ,ZEM_ID_P IN S_ZEMLJE.ID%TYPE
 )
 IS
/*
Ako je upisana regija u adresar onda zemlja
regije mora biti jednaka zemlji u adresaru.
Ako je upisana regija komitenta onda zemlja
regije mora biti jednaka zemlji komitenta.
*/
  zem_id_l s_zemlje.id%TYPE;
BEGIN
  IF reg_id_p IS NULL OR zem_id_p IS NULL THEN
    RETURN;
  END IF;
  
  SELECT zem_id INTO zem_id_l
    FROM m_regije
   WHERE id = reg_id_p;

  IF zem_id_p <> zem_id_l THEN
    pra_pka_zaj.vrati_poruku (-20010);
  END IF;
END;
PROCEDURE PROVJERI_VAPLDOK
 (PKARAC_ID_P IN TPKA_RACUNI.ID%TYPE
 )
 IS
-- Raun za predujam ne moe imati stavke PKARNK niti PKARACPRED.
  br_redaka_l NUMBER;
BEGIN
  IF pkarac_id_p IS NULL THEN
    RETURN;
  END IF;
  SELECT COUNT (1) INTO br_redaka_l
    FROM tpka_racuni, s_vapldok
   WHERE tpka_racuni.id = pkarac_id_p
     AND tpka_racuni.vapldok_id = s_vapldok.id
     AND s_vapldok.oznaka IN ('BP', 'GP');
  IF br_redaka_l > 0 THEN
    pra_pka_zaj.vrati_poruku (-20044);
  END IF;
END;
FUNCTION IZN_PRIMLJENOG_PREDUJMA
 (PKARAC_ID_P IN tpka_racuni.id%TYPE
 )
 RETURN tpka_racuni.iznos%TYPE
 IS
-- IRN 1890
  iznos_l tpka_racuni.iznos%TYPE;
BEGIN
  IF pkarac_id_p IS NULL THEN
    RETURN 0;
  END IF;

  SELECT NVL (SUM (iznos), 0) INTO iznos_l
    FROM tpka_racuni
   WHERE id = pkarac_id_p;

  RETURN iznos_l;
END;
FUNCTION IZN_ISKORISTENOG_PREDUJMA
 (PKARACP_ID_P IN tpka_rac_pred.pkaracp_id%TYPE
 ,DATUM_P IN DATE := TO_DATE ('31.12.9999', 'DD.MM.RRRR')
 )
 RETURN NUMBER
 IS
-- IRN 1890
  izn_iskoristenog_predujma_l NUMBER;
BEGIN
  IF pkaracp_id_p IS NULL THEN
    RETURN 0;
  END IF;

  SELECT NVL (SUM (tpka_rac_pred.iznos), 0) INTO izn_iskoristenog_predujma_l
    FROM tpka_rac_pred,
         tpka_racuni
   WHERE tpka_rac_pred.pkaracp_id = pkaracp_id_p
     AND tpka_rac_pred.pkarac_id = tpka_racuni.id
     AND tpka_racuni.datum <= datum_p;

  RETURN izn_iskoristenog_predujma_l;
END;
FUNCTION PLATITELJ
 (OZNAKA_P IN VARCHAR2
 ,GMPKOM_ID_P IN MGMP_KOMITENTI.ID%TYPE
 ,PKAADR_ID_P IN MPKA_ADRESE.ID%TYPE
 )
 RETURN VARCHAR2
 IS
--
  CURSOR gmpkom_c IS
    SELECT DECODE (oznaka_p,
           '1', sifra,
           '2', naziv,
           '3', sifra || ' ' || naziv)
      FROM mgmp_komitenti
     WHERE id = gmpkom_id_p;
  CURSOR pkaadr_c IS
    SELECT DECODE (oznaka_p,
           '1', rbr,
           '2', DECODE (prezime, NULL, naz_poduzeca, prezime || ', ' || ime),
           '3', rbr || ' ' || DECODE (prezime, NULL, naz_poduzeca, prezime || ', ' || ime))
      FROM mpka_adrese
     WHERE id = pkaadr_id_p;
  platitelj_l VARCHAR2(60);
BEGIN
  IF oznaka_p IS NULL THEN
    platitelj_l := NULL;
    RETURN (platitelj_l);
  END IF;
  IF gmpkom_id_p IS NULL
    AND pkaadr_id_p IS NULL
  THEN
    platitelj_l := NULL;
    RETURN (platitelj_l);
  END IF;
  IF gmpkom_id_p IS NOT NULL THEN
    OPEN gmpkom_c;
    FETCH gmpkom_c INTO platitelj_l;
    IF gmpkom_c%NOTFOUND THEN
      CLOSE gmpkom_c;
      platitelj_l := NULL;
    END IF;
    CLOSE gmpkom_c;
    RETURN (platitelj_l);
  END IF;
  IF pkaadr_id_p IS NOT NULL THEN
    OPEN pkaadr_c;
    FETCH pkaadr_c INTO platitelj_l;
    IF pkaadr_c%NOTFOUND THEN
      CLOSE pkaadr_c;
      platitelj_l := NULL;
    END IF;
    CLOSE pkaadr_c;
    RETURN (platitelj_l);
  END IF;
END;
FUNCTION PKARNK_IZN_PDV
 (PKARNK_ID_P IN IPKA_RNK_PDV.PKARNK_ID%TYPE
 )
 RETURN ipka_rnk_pdv.iznos%TYPE
 IS
-- Ukupan iznos poreza po raunu sa kase
  CURSOR pkarnkpdv_c IS
    SELECT SUM (izn_pdv)
      FROM ipka_rnk_pdv
     WHERE pkarnk_id = pkarnk_id_p;
  izn_pdv_l ipka_rnk_pdv.iznos%TYPE;
BEGIN
  OPEN pkarnkpdv_c;
  FETCH pkarnkpdv_c INTO izn_pdv_l;
  IF pkarnkpdv_c%NOTFOUND THEN
    izn_pdv_l := 0;
  END IF;
  CLOSE pkarnkpdv_c;
  RETURN izn_pdv_l;
END;
PROCEDURE PISI_PKAVLAS
 (NAZIV_P OUT SPKA_VLASNIK.NAZIV%TYPE
 ,NAZ_LICENCE_P OUT SPKA_VLASNIK.NAZ_LICENCE%TYPE
 ,VERZIJA_P OUT SPKA_VLASNIK.VERZIJA%TYPE
 )
 IS
--
  CURSOR pkavlas_c IS
    SELECT naziv, naz_licence, verzija
      FROM spka_vlasnik;
BEGIN
  OPEN pkavlas_c;
  FETCH pkavlas_c INTO naziv_p, naz_licence_p, verzija_p;
  CLOSE pkavlas_c;
END;
FUNCTION DOBAR_DATUM_RNK
 (DATUM_P IN TPKA_RNKASA.DATUM%TYPE
 ,GMPKAS_ID_P IN TPKA_RNKASA.GMPKAS_ID%TYPE
 )
 RETURN NUMBER
 IS
/*
Funkcija vraa -1 ako se za taj datum moe unositi/mijenjati/brisati rnk.
Inae funkcija vraa 0.
Kontrola bi se treba obaviti preko datuma urnala PKA_OJ koji jo nije uveden
pa sada funkcija uvijek vraa -1.
*/
  dobar_datum_rnk_l NUMBER;
BEGIN

  dobar_datum_rnk_l := -1;

  /*
  06.04.2001. M.K.
  Privremena kontrola preko datuma urnala za SO ispod PKA OJ
  kojoj pripada ta kasa
  je problematina zbog povezanosti paketa i kompajliranja
  zato je skinuta.

  FOR oj IN (
    -- kasa bi trebala pripadati samo jednoj OJ na PKA
    SELECT id
      FROM mpka_oj
     WHERE pra_zmp.kasa_pripada_oj (gmpkas_id_p, mpka_oj.id) = -1)
  LOOP
    FOR so IN (
      SELECT id
        FROM m_so
       WHERE pra_rec2.so_pripada_oj (m_so.id, oj.id) = -1)
    LOOP
      IF TRUNC (datum_p) <= NVL (pra_rec.zadnji_zurnal (so.id), TO_DATE ('01.01.1999', 'DD.MM.RRRR'))
      THEN
        dobar_datum_rnk_l := 0;
      END IF;
    END LOOP;  -- SO
  END LOOP;  -- OJ
  */

  RETURN dobar_datum_rnk_l;

END;
FUNCTION NEISKORISTEN_RNK
 (ID_P IN TPKA_RNKASA.ID%TYPE
 )
 RETURN NUMBER
 IS
/*
Funkcija vraa -1 ako je rnk valjan nenaplaen na REC ili PKA raunu
i nevezan na valjani obraun (ili uope ne postoji);
inae vraa 0
*/
  neiskoristen_rnk_l NUMBER;
  br_redaka_l NUMBER;
  CURSOR pkarnk_c IS
    SELECT oznaka, rac_id, pkarac_id FROM tpka_rnkasa WHERE id = id_p;
  pkarnk_c_l pkarnk_c%ROWTYPE;
BEGIN
  neiskoristen_rnk_l := -1;
  IF id_p IS NOT NULL THEN
    SELECT COUNT (1)
      INTO br_redaka_l
      FROM tpka_obr_rac,
           tpka_obracuni
     WHERE tpka_obr_rac.pkarnk_id = id_p
       AND tpka_obr_rac.pkaobr_id = tpka_obracuni.id 
       AND tpka_obracuni.oznaka = 'V';
    OPEN pkarnk_c;
    FETCH pkarnk_c INTO pkarnk_c_l;
    IF pkarnk_c%FOUND THEN
      IF pkarnk_c_l.oznaka <> 'V'
        OR pkarnk_c_l.rac_id IS NOT NULL
        OR pkarnk_c_l.pkarac_id IS NOT NULL
        OR br_redaka_l > 0
      THEN
        neiskoristen_rnk_l := 0;
      END IF;
    END IF;
    CLOSE pkarnk_c;
  END IF;
  RETURN neiskoristen_rnk_l;
END;
PROCEDURE PUNI_PKARNKPDV
 (PKARNK_ID_P IN IPKA_RNK_PDV.PKARNK_ID%TYPE
 ,VPISPZ_ID_P IN ipka_rnk_pdv.vpispz_id%TYPE
 )
 IS
/*
Punjenje u tablicu ipka_rnk_pdv.
Koristi se u modulu REC2280 - Trokovi i rauni sa kasa.
Prebaeno iz paketa FM_REC2280.
*/
  vpispz_stopa_l s_vpisporukaz.stopa%TYPE; -- IRN 1869
  CURSOR pkarnk_c IS
    SELECT izn_placanja, izn_ppot
      FROM tpka_rnkasa
     WHERE id = pkarnk_id_p;
  pkarnk_c_l pkarnk_c%ROWTYPE;
  br_redaka_l NUMBER;
  izn_osnovice_l ipka_rnk_pdv.izn_osnovice%TYPE;
  izn_pdv_l ipka_rnk_pdv.izn_pdv%TYPE;
BEGIN
  IF pkarnk_id_p IS NULL THEN
    RETURN;
  END IF;

  SELECT stopa INTO vpispz_stopa_l FROM s_vpisporukaz WHERE id = vpispz_id_p; -- IRN 1869

  OPEN pkarnk_c;
  FETCH pkarnk_c INTO pkarnk_c_l;
  CLOSE pkarnk_c;
  /*
  MK 05.01.2011 IRN 01278 usklaivanje s izmjenom u POS
  izn_osnovice_l := (pkarnk_c_l.izn_placanja * pkarnk_c_l.izn_tecaja - pkarnk_c_l.izn_ppot) * 100 / (100 + vpispz_stopa_l);
  izn_pdv_l := izn_osnovice_l *  vpispz_stopa_l / 100;
  */
  -- IRN 3545 - maknuto mnozenje sa tecajem
  izn_pdv_l := ROUND ((pkarnk_c_l.izn_placanja - pkarnk_c_l.izn_ppot) * vpispz_stopa_l / (100 + vpispz_stopa_l), 2);
  izn_osnovice_l := (pkarnk_c_l.izn_placanja - pkarnk_c_l.izn_ppot) - izn_pdv_l;

  SELECT COUNT (1) INTO br_redaka_l
    FROM ipka_rnk_pdv
   WHERE pkarnk_id = pkarnk_id_p;
  IF br_redaka_l = 0 THEN
    INSERT INTO ipka_rnk_pdv (
        pkarnk_id, vpispz_id, stopa_pdv, izn_osnovice, izn_pdv)
      VALUES (
        pkarnk_id_p, vpispz_id_p, vpispz_stopa_l, izn_osnovice_l, izn_pdv_l);
  ELSIF br_redaka_l = 1 THEN
    UPDATE ipka_rnk_pdv
       SET vpispz_id = vpispz_id_p,
           stopa_pdv = vpispz_stopa_l,
           izn_osnovice = izn_osnovice_l,
           izn_pdv = izn_pdv_l
     WHERE pkarnk_id = pkarnk_id_p;
  ELSE
    -- Interni POS raun ima vie od jedne vrste zavrnih poreznih isporuka.
    pra_pka_zaj.vrati_poruku (-20097);
  END IF;
END;
PROCEDURE PROVJERI_PKARNKPDV
 (PKARNK_ID_P IN tpka_rnkasa.id%TYPE
 )
 IS
-- Provjeri je li zbroj iznosa po stavkama (ipka_rnk_pdv) jednak iznosu u zaglavlju (tpka_rnkasa)
-- IRN 3348; API POS - Posting charges to PMS/Charges/Post charge to PMS
  suma_iznos_l   tpka_rnkasa.izn_placanja%TYPE;
  izn_placanja_l tpka_rnkasa.izn_placanja%TYPE;
  izn_ppot_l     tpka_rnkasa.izn_ppot%TYPE;
  izn_pnaknade_l     tpka_rnkasa.izn_pnaknade%TYPE; --IRN 3784
BEGIN
  IF pkarnk_id_p IS NULL THEN
    RAISE NO_DATA_FOUND;
  END IF;

  -- MK 05.01.2011 IRN 01278 usklaivanje sa izmjenom u POS
  -- tu se pokualo spojiti provjeru iznosa i stope u pojedinim stavkama i iznosa u zaglavlju
  -- pa se pdv ponovo rauna umjesto da se uzme onaj iz tablice
  /*
  suma_iznos_l := 0;
  FOR i IN (SELECT * FROM ipka_rnk_pdv WHERE pkarnk_id = pkarnk_id_p)
  LOOP
    suma_iznos_l := ROUND (suma_iznos_l + i.izn_osnovice + ROUND (i.stopa_pdv * i.izn_osnovice / 100, 2), 2);
  END LOOP;
  */

  SELECT SUM (izn_osnovice + ROUND ((izn_osnovice + izn_pdv) * stopa_pdv / (100 + stopa_pdv), 2))
    INTO suma_iznos_l
    FROM ipka_rnk_pdv
   WHERE pkarnk_id = pkarnk_id_p;

  -- DM IRN 03545 - maknut iznos tecaja
  SELECT izn_placanja + NVL (izn_placanja2, 0), izn_ppot, izn_pnaknade -- IRN 2872, dodan izn_placanja2
    INTO izn_placanja_l, izn_ppot_l, izn_pnaknade_l
    FROM tpka_rnkasa
   WHERE id = pkarnk_id_p;

  IF ABS (ROUND ((izn_placanja_l - izn_ppot_l - izn_pnaknade_l), 2) - ROUND (suma_iznos_l, 2))
    > TO_NUMBER (pra_pka_zaj.vrijednost_parametra ('1008'), '99D99', 'NLS_NUMERIC_CHARACTERS = '',.'' ')
  THEN
    -- Zbroj iznosa po stavkama mora biti jednak iznosu u zaglavlju (razlika #0).
    pra_pka_zaj.vrati_poruku (-20089, TO_CHAR (ROUND ((izn_placanja_l - izn_ppot_l - izn_pnaknade_l), 2) - ROUND (suma_iznos_l, 2)));
  END IF;

END;
PROCEDURE PROVJERI_PKARNKISP
 (PKARNK_ID_P IN tpka_rnkasa.id%TYPE
 )
 IS
-- Provjeri je li zbroj iznosa po stavkama (tpka_rnk_isp) jednak iznosu u zaglavlju (tpka_rnkasa)
-- IRN 3348; API POS - Posting charges to PMS/Charges/Post charge to PMS
  brojac_l            NUMBER;
  suma_isp_pdv_l      tpka_rnkasa.izn_ppot%TYPE;
  suma_isp_iznos_l    tpka_rnkasa.izn_placanja%TYPE;
  suma_isp_ppot_l     tpka_rnkasa.izn_ppot%TYPE;
  iznos_l             tpka_rnkasa.izn_placanja%TYPE;
  izn_ppot_l          tpka_rnkasa.izn_ppot%TYPE;
  suma_pdv_l          tpka_rnkasa.izn_ppot%TYPE;
  izn_pnaknade_l      tpka_rnkasa.izn_pnaknade%TYPE; -- IRN 3784
  suma_izn_pnaknade_l tpka_rnkasa.izn_pnaknade%TYPE; -- IRN 3784
BEGIN
  IF pkarnk_id_p IS NULL THEN
    RAISE NO_DATA_FOUND;
  END IF;

  SELECT COUNT (1) INTO brojac_l FROM tpka_rnk_isp WHERE pkarnk_id = pkarnk_id_p;
  -- Ako nema stavaka i parametar 1006 = 'ne' onda ne treba kontrolirati
  -- PKA parametar 1006 -> POS blagajna upisuje stavke rauna (isporuke): da ili ne.
  IF brojac_l = 0 AND pra_pka_zaj.vrijednost_parametra ('1006') = 'ne' THEN
    RETURN;
  END IF;

  SELECT NVL (SUM (izn_pdv), 0),
         NVL (SUM (ROUND (cijena * kolicina, 2)), 0),
         NVL (SUM (izn_ppot), 0),
         NVL (SUM (izn_pnaknade), 0) -- IRN 3784
    INTO suma_isp_pdv_l, suma_isp_iznos_l, suma_isp_ppot_l, suma_izn_pnaknade_l
    FROM tpka_rnk_isp
   WHERE pkarnk_id = pkarnk_id_p;

  -- IRN 3348; dodan izn_popusta
  -- IRN 3784 izn_pnaknade
  -- IRN 4015; dodan izn_popusta2
  SELECT izn_placanja + NVL (izn_placanja2, 0) + NVL (izn_popusta, 0) + NVL (izn_popusta2, 0), izn_ppot, izn_pnaknade
    INTO iznos_l, izn_ppot_l, izn_pnaknade_l
    FROM tpka_rnkasa
   WHERE id = pkarnk_id_p;

  SELECT NVL (SUM (izn_pdv), 0)
    INTO suma_pdv_l
    FROM ipka_rnk_pdv
   WHERE pkarnk_id = pkarnk_id_p;

  IF iznos_l <> suma_isp_iznos_l THEN
    -- Zbroj iznosa po stavkama (#0) mora biti jednak iznosu u zaglavlju (#1).
    pra_pka_zaj.vrati_poruku (-20049, suma_isp_iznos_l, iznos_l);
  END IF;

  IF suma_isp_pdv_l <> suma_pdv_l THEN
    -- Zbroj iznosa poreza na dodanu vrijednost po stavkama (#0) mora biti jednak iznosu poreza na dodanu vrijednost u zaglavlju (#1).
    pra_pka_zaj.vrati_poruku (-20050, suma_isp_pdv_l, suma_pdv_l);
  END IF;

  IF suma_isp_ppot_l <> izn_ppot_l THEN
    -- Zbroj iznosa poreza na potronju po stavkama (#0) mora biti jednak iznosu poreza na potronju u zaglavlju (#1).
    pra_pka_zaj.vrati_poruku (-20051, suma_isp_ppot_l, izn_ppot_l);
  END IF;

  -- IRN 3784
  IF suma_izn_pnaknade_l <> izn_pnaknade_l THEN
    -- Zbroj iznosa povratne naknade po stavkama (#0) mora biti jednak iznosu povratne naknade u zaglavlju (#1).
    pra_pka_zaj.vrati_poruku (-20121, suma_izn_pnaknade_l, izn_pnaknade_l);
  END IF;

END;
PROCEDURE IZRADI_NEGATIVNI_PKARNK
 (ID_STARI_P IN tpka_rnkasa.id%TYPE
 ,GOD_POSLOVNA_NOVA_P IN tpka_rnkasa.god_poslovna%TYPE
 ,RBR_NOVI_P IN tpka_rnkasa.rbr%TYPE
 )
 IS
-- Izradi negativni RNK
  pkarnk_row_l tpka_rnkasa%ROWTYPE;
  -- IRN 1361
  pkarnk_n_row_l tpka_rnkasa%ROWTYPE;
  pkarnkpdv_n_row_l ipka_rnk_pdv%ROWTYPE;
  pkarnkisp_n_row_l tpka_rnk_isp%ROWTYPE;
BEGIN
  IF id_stari_p IS NULL THEN
    RETURN;
  END IF;

  SELECT * INTO pkarnk_row_l
    FROM tpka_rnkasa
   WHERE id = id_stari_p;

  /*
  moe se ponititi samo runo upisan valjan nezaraunat RNK
  koji nije vezan na valjani obraun
  istog dana kada je napravljen
  */
  IF pra_pka.neiskoristen_rnk (id_stari_p) <> -1
    OR pkarnk_row_l.ozn_unosa <> 'R'
  THEN
    -- Negativni raun moe se izraditi za nenaplaen runo unesen interni POS raun.
    pra_pka_zaj.vrati_poruku (-20055);
  END IF;

  -- Kreiraj RNK sa negativnim stavkama
  pkarnk_n_row_l := pkarnk_row_l;
  pkarnk_n_row_l.id := pra_pka_zaj.sekvenca (NULL);
  pkarnk_n_row_l.god_poslovna := god_poslovna_nova_p; -- poslovna godina
  pkarnk_n_row_l.rbr := rbr_novi_p; -- novi redni broj
  pkarnk_n_row_l.datum := SYSDATE;
  pkarnk_n_row_l.izn_placanja := pkarnk_row_l.izn_placanja * -1; -- mnoi se s -1
  pkarnk_n_row_l.izn_ppot := pkarnk_row_l.izn_ppot * -1; -- mnoi se s -1
  IF pkarnk_row_l.opis1 IS NULL THEN
    pkarnk_n_row_l.opis1 := pkarnk_row_l.opis2;
  ELSE
    pkarnk_n_row_l.opis1 := SUBSTR (pkarnk_row_l.opis1 || ', ' || pkarnk_row_l.opis2, 1, 40);
  END IF;
  pkarnk_n_row_l.opis2 := SUBSTR (pra_zmp_zaj.poruka ('PKA', 'PKA0146', pkarnk_row_l.rbr), 1, 40); -- Negativni raun za raun broj #0
  pkarnk_n_row_l.unos_korisnik := NULL;
  pkarnk_n_row_l.unos_dat := NULL;
  pkarnk_n_row_l.izmjena_korisnik := NULL;
  pkarnk_n_row_l.izmjena_dat := NULL;
  pkarnk_n_row_l.izn_osnovice_ppot := pkarnk_row_l.izn_osnovice_ppot * -1; -- IRN 1845
  pkarnk_n_row_l.izn_popusta := pkarnk_row_l.izn_popusta * -1;     -- IRN 2872, mnoi se s -1
  pkarnk_n_row_l.izn_placanja2 := pkarnk_row_l.izn_placanja2 * -1; -- IRN 2872, mnoi se s -1
  pkarnk_n_row_l.izn_pnaknade := pkarnk_row_l.izn_pnaknade * -1;   -- IRN 3784, mnoi se s -1
  pkarnk_n_row_l.izn_napojnice := pkarnk_row_l.izn_napojnice * -1; -- IRN 3784, mnoi se s -1
  pkarnk_n_row_l.izn_popusta2 := pkarnk_row_l.izn_popusta2 * -1;   -- IRN 4015, mnoi se s -1
  INSERT INTO tpka_rnkasa VALUES pkarnk_n_row_l;

  -- kreiraj stavke poreza za kreirani raun sa kase
  FOR pkarnkpdv_c IN (
    SELECT * FROM ipka_rnk_pdv WHERE pkarnk_id = id_stari_p)
  LOOP
    pkarnkpdv_n_row_l := pkarnkpdv_c;
    pkarnkpdv_n_row_l.id := NULL;
    pkarnkpdv_n_row_l.pkarnk_id := pkarnk_n_row_l.id; -- RNK za koji se kreiraju stavke
    pkarnkpdv_n_row_l.iznos := pkarnkpdv_c.iznos * -1; -- mnoi se s -1
    pkarnkpdv_n_row_l.izn_osnovice := pkarnkpdv_c.izn_osnovice * -1;
    pkarnkpdv_n_row_l.izn_pdv := pkarnkpdv_c.izn_pdv * -1;
    pkarnkpdv_n_row_l.unos_korisnik := NULL;
    pkarnkpdv_n_row_l.unos_dat := NULL;
    pkarnkpdv_n_row_l.izmjena_korisnik := NULL;
    pkarnkpdv_n_row_l.izmjena_dat := NULL;
    INSERT INTO ipka_rnk_pdv VALUES pkarnkpdv_n_row_l;
  END LOOP;

  -- kreiraj stavke isporuka za kreirani raun sa kase
  FOR pkarnkisp_c IN (
    SELECT * FROM tpka_rnk_isp WHERE pkarnk_id = id_stari_p)
  LOOP
    pkarnkisp_n_row_l := pkarnkisp_c;
    pkarnkisp_n_row_l.id := NULL;
    pkarnkisp_n_row_l.pkarnk_id := pkarnk_n_row_l.id; -- RNK za koji se kreiraju stavke
    pkarnkisp_n_row_l.kolicina := pkarnkisp_c.kolicina * -1; -- mnoi se s -1
    pkarnkisp_n_row_l.izn_pdv := pkarnkisp_c.izn_pdv * -1;
    pkarnkisp_n_row_l.izn_ppot := pkarnkisp_c.izn_ppot * -1;
    pkarnkisp_n_row_l.izn_pnaknade := pkarnkisp_c.izn_pnaknade * -1; -- IRN 3784, mnoi se s -1
    pkarnkisp_n_row_l.unos_korisnik := NULL;
    pkarnkisp_n_row_l.unos_dat := NULL;
    pkarnkisp_n_row_l.izmjena_korisnik := NULL;
    pkarnkisp_n_row_l.izmjena_dat := NULL;
    INSERT INTO tpka_rnk_isp VALUES pkarnkisp_n_row_l;
  END LOOP;

  COMMIT;

END;

END PRA_PKA;
/
SHOW ERROR

