PROMPT Creating Package Body 'PRA_MPKA_VEPORUKA'
CREATE OR REPLACE PACKAGE BODY PRA_MPKA_VEPORUKA IS

SUBJECT_M M_VNAPOMENA.NAPOMENA%TYPE;
BODY_TEXT_M VARCHAR2(3000);
HOST_M SZMP_PARAMETRI.VRIJEDNOST%TYPE := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0069');
PORT_M SZMP_PARAMETRI.VRIJEDNOST%TYPE := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0070');
BODY_HTML_M CLOB;
ATTACH_BLOB1_M BLOB;
ATTACH_MIME1_M VARCHAR2(50);
ATTACH_NAME1_M VARCHAR2(50);
ATTACH_BLOB2_M BLOB;
ATTACH_MIME2_M VARCHAR2(50);
ATTACH_NAME2_M VARCHAR2(50);
PKAVEPOR_ROW_M MPKA_VEPORUKA%ROWTYPE;
JEZ_SIFRA_3A_M S_JEZICI.SIFRA_3A%TYPE;
LPKAVEPOR_ROW_M LPKA_VEPORUKA%ROWTYPE;
-- Designer Private Declaration

-- IRN 3275
ime_m              t_rezervacije.ime%TYPE;           -- $FirstName$
prezime_m          t_rezervacije.prezime%TYPE;       -- $LastName$
email_m            t_rezervacije.email%TYPE;         -- $Email$
rez_rbr_m          t_rezervacije.rbr%TYPE;           -- $ReservationNumber$
rez_god_poslovna_m t_rezervacije.god_poslovna%TYPE;  -- $ReservationBusinessYear$
so_sifra_m         m_so.sifra%TYPE;                  -- $PropertyCode$
so_naziv_m         m_so.naziv%TYPE;                  -- $PropertyName$
dat_dolaska_m      VARCHAR2(10);                     -- $ArrivalDate$
dat_odlaska_m      VARCHAR2(10);                     -- $DepartureDate$
izn_predujma_m     VARCHAR2(20);                     -- $AdvancePaymentAmount$
val_sifra_3a_m     s_valute.sifra_3a%TYPE;           -- $CurrencyCode$
dat_opcije_m       VARCHAR2(10);                     -- $OptionDate$
pristupni_kod_m    t_rezervacije.pristupni_kod%TYPE; -- $AccessCode$
so_pos_naziv_m     m_poste.naziv%TYPE;               -- $PropertyPlaceName$
so_email_m         m_so.email%TYPE;                  -- $PropertyEmail$
rez_napomena_m     t_rezervacije.napomena%TYPE;      -- $ReservationNote$
so_naz_mjesta_m    m_so.naz_mjesta%TYPE;             -- $PropertySettlementName$
sc_param_1003_m    szmp_parametri.vrijednost%TYPE;   -- $Check-inTime$
loyvbod_kolicina_m VARCHAR2(4);                      -- $Quantity$
-- KRAJ IRN 3275

sj_broj1_m         m_sj.broj%TYPE;                   -- $UnitCode1$     -- IRN 3669

br_uputnice_m      t_rezervacije.br_uputnice%TYPE;   -- $ReservationID$ -- IRN 3869
ppord_url_m        tpp_orders.url%TYPE;              -- $PayPerURL$     -- IRN 3869

-- KRAJ Designer Private Declaration


PROCEDURE SALJI_TEST_EMAIL
 (EMAIL_BCC_P IN mpka_veporuka.email_bcc%TYPE
 ,EMAIL_FROM_P IN mpka_veporuka.email_from%TYPE
 ,NAZ_FROM_P IN mpka_veporuka.naz_from%TYPE
 ,SUBJECT_P IN m_vnapomena.napomena%TYPE
 ,BODY_P IN m_vnapomena.napomena%TYPE
 ,BODY_HTML_P IN mpka_veporuka.body_html%TYPE
 ,STAZA_P IN mpka_veporuka.staza%TYPE
 ,PRILOG1_P IN mpka_veporuka.prilog1%TYPE
 ,NASTAVAK1_P IN mpka_veporuka.nastavak1%TYPE
 ,PRILOG2_P IN mpka_veporuka.prilog2%TYPE
 ,NASTAVAK2_P IN mpka_veporuka.nastavak2%TYPE
 ,PKAVEPOR_ID_P IN mpka_veporuka.id%TYPE
 ,JEZ_ID_P IN mpka_veporuka.jez_id%TYPE
 )
 IS
-- IRN 2584; alji testnu e-poruku na adresu skrivenog primatelja
  body_l VARCHAR2(4000);
  html_l CLOB;
  -- IRN 3081
  CURSOR pkaveporje_c IS
    SELECT *
      FROM mpka_vepor_jez
     WHERE pkavepor_id = pkavepor_id_p
       AND jez_id = jez_id_p;
  pkaveporje_c_l pkaveporje_c%ROWTYPE;
  subject_l m_vnapomena.napomena%TYPE; -- IRN 3443
BEGIN
  -- IRN 3275
  host_m := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0069');
  port_m := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0070');
  attach_name1_m := NULL;
  attach_mime1_m := NULL;
  attach_blob1_m := NULL;
  attach_name2_m := NULL;
  attach_mime2_m := NULL;
  attach_blob2_m := NULL;
  -- KRAJ IRN 3275

  -- IRN 3443
  subject_l := REPLACE (subject_p, '$ReservationBusinessYear$', 'TestReservationBusinessYear');
  subject_l := REPLACE (subject_l, '$ReservationNumber$', 'TestReservationNumber');
  subject_l := REPLACE (subject_l, '$PropertyCode$', 'TestPropertyCode');
  -- KRAJ IRN 3443
  subject_l := REPLACE (subject_l, '$ReservationID$', 'TestReservationID'); -- IRN 3869

  IF body_p IS NOT NULL THEN
    body_l := REPLACE (body_p, '$FirstName$', 'TestFirstName');
    body_l := REPLACE (body_l, '$LastName$', 'TestLastName');
    body_l := REPLACE (body_l, '$Quantity$', 'TestQuantity');
    -- IRN 2908 (vidi IRN 2784)
    body_l := REPLACE (body_l, '$ReservationNumber$', 'TestReservationNumber');
    body_l := REPLACE (body_l, '$ReservationBusinessYear$', 'TestReservationBusinessYear');
    body_l := REPLACE (body_l, '$PropertyCode$', 'TestPropertyCode');
    body_l := REPLACE (body_l, '$PropertyName$', 'TestPropertyName');
    body_l := REPLACE (body_l, '$ArrivalDate$', 'TestArrivalDate');
    body_l := REPLACE (body_l, '$DepartureDate$', 'TestDepartureDate');
    body_l := REPLACE (body_l, '$AdvancePaymentAmount$', 'TestAdvancePaymentAmount');
    body_l := REPLACE (body_l, '$CurrencyCode$', 'TestCurrencyCode');
    body_l := REPLACE (body_l, '$OptionDate$', 'TestOptionDate');
    -- IRN 2908
    body_l := REPLACE (body_l, '$AccessCode$', 'TestAccessCode');
    -- IRN 3081
    body_l := REPLACE (body_l, '$Email$', 'TestEmail');
    body_l := REPLACE (body_l, '$PropertyPlaceName$', 'TestPropertyPlaceName');
    body_l := REPLACE (body_l, '$PropertyEmail$', 'TestPropertyEmail');
    body_l := REPLACE (body_l, '$ReservationNote$', 'TestReservationNote');
    body_l := REPLACE (body_l, '$ReservationAmount$', 'TestReservationAmount');
    body_l := REPLACE (body_l, '$ReservationCurrencyCode$', 'TestReservationCurrencyCode');
    -- KRAJ IRN 3081
    body_l := REPLACE (body_l, '$PropertySettlementName$', 'TestPropertySettlementName'); -- IRN 3134
    body_l := REPLACE (body_l, '$Check-inTime$', 'TestCheck-inTime'); -- IRN 3275
    -- IRN 3518
    body_l := REPLACE (body_l, '$ConvertedAmount$', 'TestConvertedAmount');
    body_l := REPLACE (body_l, '$ConversionCurrencyCode$', 'TestConversionCurrencyCode');
    body_l := REPLACE (body_l, '$FixedConversionRate$', 'TestFixedConversionRate');
    body_l := REPLACE (body_l, '$ConversionNote$', 'TestConversionNote');
    -- KRAJ IRN 3518
    body_l := REPLACE (body_l, '$UnitCode1$', 'TestUnitCode1'); -- IRN 3669
    body_l := REPLACE (body_l, '$ReservationID$', 'TestReservationID'); -- IRN 3869
    body_l := REPLACE (body_l, '$PayPerURL$', 'TestPayPerURL'); -- IRN 3869
  END IF;
  IF staza_p IS NOT NULL THEN
    IF staza_p IN ('nebitno', 'none') THEN -- IRN 3081
      OPEN pkaveporje_c;
      FETCH pkaveporje_c INTO pkaveporje_c_l;
      CLOSE pkaveporje_c;
    END IF;
    IF body_html_p IS NOT NULL THEN
      IF body_html_p IN ('nebitno', 'none') THEN -- IRN 3081
        html_l := blob2clob (pkaveporje_c_l.body_html);
      ELSE
        html_l := pra_pka2.clob_from_file (staza_p, body_html_p || '.html', 'html', NULL);
      END IF;
      html_l := REPLACE (html_l, '$FirstName$', 'TestFirstName');
      html_l := REPLACE (html_l, '$LastName$', 'TestLastName');
      html_l := REPLACE (html_l, '$Quantity$', 'TestQuantity');
      -- IRN 2908 (vidi IRN 2784)
      html_l := REPLACE (html_l, '$ReservationNumber$', 'TestReservationNumber');
      html_l := REPLACE (html_l, '$ReservationBusinessYear$', 'TestReservationBusinessYear');
      html_l := REPLACE (html_l, '$PropertyCode$', 'TestPropertyCode');
      html_l := REPLACE (html_l, '$PropertyName$', 'TestPropertyName');
      html_l := REPLACE (html_l, '$ArrivalDate$', 'TestArrivalDate');
      html_l := REPLACE (html_l, '$DepartureDate$', 'TestDepartureDate');
      html_l := REPLACE (html_l, '$AdvancePaymentAmount$', 'TestAdvancePaymentAmount');
      html_l := REPLACE (html_l, '$CurrencyCode$', 'TestCurrencyCode');
      html_l := REPLACE (html_l, '$OptionDate$', 'TestOptionDate');
      -- IRN 2908
      html_l := REPLACE (html_l, '$AccessCode$', 'TestAccessCode');
      -- IRN 3081
      html_l := REPLACE (html_l, '$Email$', 'TestEmail');
      html_l := REPLACE (html_l, '$PropertyPlaceName$', 'TestPropertyPlaceName');
      html_l := REPLACE (html_l, '$PropertyEmail$', 'TestPropertyEmail');
      html_l := REPLACE (html_l, '$ReservationNote$', 'TestReservationNote');
      html_l := REPLACE (html_l, '$ReservationAmount$', 'TestReservationAmount');
      html_l := REPLACE (html_l, '$ReservationCurrencyCode$', 'TestReservationCurrencyCode');
      -- KRAJ IRN 3081
      html_l := REPLACE (html_l, '$PropertySettlementName$', 'TestPropertySettlementName'); -- IRN 3134
      -- $ReservationUnits2$
      -- $ReservationServices2$
      -- $AccompanyingDocumentData$
      html_l := REPLACE (html_l, '$Check-inTime$', 'TestCheck-inTime'); -- IRN 3275
      -- IRN 3518
      html_l := REPLACE (html_l, '$ConvertedAmount$', 'TestConvertedAmount');
      html_l := REPLACE (html_l, '$ConversionCurrencyCode$', 'TestConversionCurrencyCode');
      html_l := REPLACE (html_l, '$FixedConversionRate$', 'TestFixedConversionRate');
      html_l := REPLACE (html_l, '$ConversionNote$', 'TestConversionNote');
      -- KRAJ IRN 3518
      html_l := REPLACE (html_l, '$UnitCode1$', 'TestUnitCode1'); -- IRN 3669
      html_l := REPLACE (html_l, '$ReservationID$', 'TestReservationID'); -- IRN 3869
      html_l := REPLACE (html_l, '$PayPerURL$', 'TestPayPerURL'); -- IRN 3869
    END IF;
    IF prilog1_p IS NOT NULL AND nastavak1_p IS NOT NULL THEN
      attach_name1_m := prilog1_p || '.' || nastavak1_p;
      attach_mime1_m := 'application/' || nastavak1_p;
      attach_blob1_m := pra_pka2.blob_from_file (staza_p, attach_name1_m, nastavak1_p, NULL);
    ELSIF pkaveporje_c_l.prilog1 IS NOT NULL AND pkaveporje_c_l.prilog1_naziv IS NOT NULL THEN -- IRN 3081
      attach_name1_m := pkaveporje_c_l.prilog1_naziv;
      attach_mime1_m := 'application/' || SUBSTR (pkaveporje_c_l.prilog1_naziv, INSTR (pkaveporje_c_l.prilog1_naziv, '.') + 1);
      attach_blob1_m := pkaveporje_c_l.prilog1;
    END IF;
    IF prilog2_p IS NOT NULL AND nastavak2_p IS NOT NULL THEN
      attach_name2_m := prilog2_p || '.' || nastavak2_p;
      attach_mime2_m := 'application/' || nastavak2_p;
      attach_blob2_m := pra_pka2.blob_from_file (staza_p, attach_name2_m, nastavak2_p, NULL);
    ELSIF pkaveporje_c_l.prilog2 IS NOT NULL AND pkaveporje_c_l.prilog2_naziv IS NOT NULL THEN -- IRN 3081
      attach_name2_m := pkaveporje_c_l.prilog2_naziv;
      attach_mime2_m := 'application/' || SUBSTR (pkaveporje_c_l.prilog2_naziv, INSTR (pkaveporje_c_l.prilog2_naziv, '.') + 1);
      attach_blob2_m := pkaveporje_c_l.prilog2;
    END IF;
  END IF;
  pra_pka2.salji_html_email (
    recipient_p    => email_bcc_p, -- adresa skrivenog primatelja
    recipient_h_p  => 'TestFirstName TestLastName',
    sender_p       => email_from_p,
    sender_h_p     => naz_from_p,
    bcc_p          => email_bcc_p,
    subject_p      => '[Test] ' || subject_l, -- IRN 3443
    text_p         => body_l,
    host_p         => host_m,
    port_p         => port_m,
    html_p         => html_l,
    attach_name1_p => attach_name1_m,
    attach_mime1_p => attach_mime1_m,
    attach_blob1_p => attach_blob1_m,
    attach_name2_p => attach_name2_m,
    attach_mime2_p => attach_mime2_m,
    attach_blob2_p => attach_blob2_m);
END;
PROCEDURE SALJI_EMAIL_JOB
 IS
-- IRN 2584; procedura se poziva iz joba
  dat_max_l DATE := TO_DATE ('31.12.9999', 'DD.MM.RRRR');
BEGIN

  host_m := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0069');
  port_m := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0070');

  IF host_m = 'nebitno' OR port_m = 'nebitno' THEN
    RETURN;
  END IF;

  FOR pkavepor_c IN (
    SELECT *
      FROM mpka_veporuka
     WHERE TRUNC (SYSDATE) BETWEEN dat_valjan AND (NVL (dat_ponisten, dat_max_l) - 1)
       /*
       obradi 20 (rezervacije - dolazak), 30 (gosti - odlazak) i 40 (rezervacije - neuplaeni predujmovi);
       obrada za 10 (lanovi programa vjernosti - roendan) je u pra_rec_loy.puni_loyula_23;
       obrada za 50 (ugovori o zakupu - pristupni kod) i 60 (rezervacije - pristupni kod) poziva se gumbom iz modula
       IRN 3212; obrada 60 (rezervacije - pristupni kod) dodana i u job
       IRN 3443; u job dodana obrada 90 (rezervacije - istekle opcije)
       */
       AND oznaka IN (20, 30, 40, 60, 90)
       AND ozn_sms = 0 -- IRN 3275
     ORDER BY sifra
    )
  LOOP
    pkavepor_row_m := pkavepor_c;
    SELECT MIN (sifra_3a) INTO jez_sifra_3a_m FROM s_jezici WHERE id = pkavepor_row_m.jez_id; -- IRN 3081
    IF pkavepor_row_m.oznaka = 20 THEN    -- rezervacije - dolazak
      obradi_20_rez_dolazak;
    ELSIF pkavepor_row_m.oznaka = 40 THEN -- rezervacije - neuplaeni predujmovi
      obradi_40_rez_predujam;
    ELSIF pkavepor_row_m.oznaka = 60 THEN -- IRN 3212; rezervacije - pristupni kod
      obradi_60_rez_pristupni_kod;
    ELSIF pkavepor_row_m.oznaka = 30 THEN -- gosti - odlazak
      obradi_30_gost_odlazak;
    ELSIF pkavepor_row_m.oznaka = 90 THEN -- IRN 3443; rezervacije - istekle opcije
      obradi_90_rez_istekle_opcije;
    END IF;
  END LOOP;
END;
PROCEDURE SALJI_EMAIL_JOB_MULTI
 (VLASNIKPODATKA_P IN NUMBER := NULL
 )
 IS
BEGIN
  pra_zmp_context.set_vlasnikpodatka (vlasnikpodatka_p);
  pra_mpka_veporuka.salji_email_job;
EXCEPTION
  WHEN OTHERS THEN
    RAISE;
END;
PROCEDURE OBRADI_20_REZ_DOLAZAK
 IS
--
  CURSOR rezsj_c (rez_id_k t_rezervacije.id%TYPE) IS -- IRN 3669
    SELECT sj.broj
      FROM t_rez_vsj rezvsj,
           m_sj sj
     WHERE rezvsj.sj_id = sj.id
       AND rezvsj.rez_id = rez_id_k
    UNION ALL
    SELECT sj.broj
      FROM trec_rez_sj recrezsj,
           m_sj sj,
           t_rez_vsj rezvsj
     WHERE recrezsj.sj_id = sj.id
       AND recrezsj.rezvsj_id = rezvsj.id
       AND rezvsj.rez_id = rez_id_k
     ORDER BY 1;
BEGIN
  FOR rez_c IN (
    SELECT rez.ime, rez.prezime, rez.email, rez.jez_id, jez.sifra_3a AS jez_sifra_3a, rez.id
      FROM t_rezervacije rez,
           s_jezici jez
     WHERE rez.jez_id = jez.id(+)
       AND rez.oznaka = 'V'
       AND rez.ozn_vstorna IS NULL
       AND rez.email IS NOT NULL
       AND rez.dat_dolaska = (TRUNC (SYSDATE) + pkavepor_row_m.br_dana)
       /*
       IRN 3443
       ako je danas ve poslana poruka te vrste za tu rezervaciju na taj email
       onda je nemoj slati ponovo
       */
       AND NOT EXISTS (
           SELECT NULL
             FROM lpka_veporuka l
            WHERE TRUNC (l.unos_dat) = TRUNC (SYSDATE)
              AND l.pkavepor_id = pkavepor_row_m.id
              AND l.rez_id = rez.id
              AND LOWER (l.email) = LOWER (rez.email)
           )
     ORDER BY rez.god_poslovna, rez.rbr)
  LOOP
    BEGIN
      ime_m     := rez_c.ime;
      prezime_m := rez_c.prezime;
      email_m   := rez_c.email;
      -- IRN 3669
      sj_broj1_m := NULL;
      OPEN rezsj_c (rez_c.id);
      FETCH rezsj_c INTO sj_broj1_m;
      CLOSE rezsj_c;
      -- KRAJ IRN 3669
      IF pkavepor_row_m.ozn_sms = 0 THEN -- IRN 3275
        pripremi_dijelove_poruke (rez_c.jez_id, rez_c.jez_sifra_3a);
        pra_pka2.salji_html_email (
          recipient_p    => rez_c.email,
          recipient_h_p  => INITCAP (rez_c.ime) || ' ' || INITCAP (rez_c.prezime),
          sender_p       => pkavepor_row_m.email_from,
          sender_h_p     => pkavepor_row_m.naz_from,
          bcc_p          => pkavepor_row_m.email_bcc,
          subject_p      => subject_m,
          text_p         => body_text_m,
          host_p         => host_m,
          port_p         => port_m,
          html_p         => body_html_m,
          attach_name1_p => attach_name1_m,
          attach_mime1_p => attach_mime1_m,
          attach_blob1_p => attach_blob1_m,
          attach_name2_p => attach_name2_m,
          attach_mime2_p => attach_mime2_m,
          attach_blob2_p => attach_blob2_m);
        -- IRN 3360
        lpkavepor_row_m := NULL;
        lpkavepor_row_m.pkavepor_id := pkavepor_row_m.id;
        lpkavepor_row_m.rez_id := rez_c.id;
        lpkavepor_row_m.email  := rez_c.email;
        pra_mpka_veporuka.puni_lpkavepor (lpkavepor_row_m);
      END IF;
    EXCEPTION
      WHEN OTHERS THEN
        -- Pogreka kod slanja e-poruke (email; prezime; ime; oznaka; greka)
        pra_pka_iud.puni_pkapro ('PKA', '0010', SUBSTR (rez_c.email || ' ' || rez_c.prezime || ' ' || rez_c.ime || ' ' || pkavepor_row_m.oznaka || ' ' || SQLERRM, 1, 2000), 0);
    END;
  END LOOP;
END;
PROCEDURE OBRADI_30_GOST_ODLAZAK
 IS
BEGIN
  FOR gost_c IN (
    SELECT gost.ime, gost.prezime, kgost.email, gost.jez_id, jez.sifra_3a AS jez_sifra_3a, gost.id
      FROM t_gosti gost,
           t_kgostiju kgost,
           s_jezici jez
     WHERE kgost.gost_id = gost.id
       AND kgost.oznaka = 'V'
       AND gost.jez_id = jez.id(+)
       AND gost.ozn_prisutnosti = 'O'
       AND NVL (gost.ozn_brisano, 0) = 0
       AND kgost.email IS NOT NULL
       AND gost.dat_odlaska = (TRUNC (SYSDATE) - pkavepor_row_m.br_dana)
       /*
       IRN 3443
       ako je danas ve poslana poruka te vrste za tog gosta na taj email
       onda je nemoj slati ponovo
       */
       AND NOT EXISTS (
           SELECT NULL
             FROM lpka_veporuka l
            WHERE TRUNC (l.unos_dat) = TRUNC (SYSDATE)
              AND l.pkavepor_id = pkavepor_row_m.id
              AND l.gost_id = gost.id
              AND LOWER (l.email) = LOWER (kgost.email)
           )
     ORDER BY gost.god_poslovna, gost.rbr)
  LOOP
    BEGIN
      ime_m     := gost_c.ime;
      prezime_m := gost_c.prezime;
      email_m   := gost_c.email;
      IF pkavepor_row_m.ozn_sms = 0 THEN -- IRN 3275
        pripremi_dijelove_poruke (gost_c.jez_id, gost_c.jez_sifra_3a);
        pra_pka2.salji_html_email (
          recipient_p    => gost_c.email,
          recipient_h_p  => INITCAP (gost_c.ime) || ' ' || INITCAP (gost_c.prezime),
          sender_p       => pkavepor_row_m.email_from,
          sender_h_p     => pkavepor_row_m.naz_from,
          bcc_p          => pkavepor_row_m.email_bcc,
          subject_p      => subject_m,
          text_p         => body_text_m,
          host_p         => host_m,
          port_p         => port_m,
          html_p         => body_html_m,
          attach_name1_p => attach_name1_m,
          attach_mime1_p => attach_mime1_m,
          attach_blob1_p => attach_blob1_m,
          attach_name2_p => attach_name2_m,
          attach_mime2_p => attach_mime2_m,
          attach_blob2_p => attach_blob2_m);
        -- IRN 3360
        lpkavepor_row_m := NULL;
        lpkavepor_row_m.pkavepor_id := pkavepor_row_m.id;
        lpkavepor_row_m.gost_id := gost_c.id;
        lpkavepor_row_m.email := gost_c.email;
        pra_mpka_veporuka.puni_lpkavepor (lpkavepor_row_m);
      END IF;
    EXCEPTION
      WHEN OTHERS THEN
        -- Pogreka kod slanja e-poruke (email; prezime; ime; oznaka; greka)
        pra_pka_iud.puni_pkapro ('PKA', '0010', SUBSTR (gost_c.email || ' ' || gost_c.prezime || ' ' || gost_c.ime || ' ' || pkavepor_row_m.oznaka || ' ' || SQLERRM, 1, 2000), 0);
    END;
  END LOOP;
END;
PROCEDURE OBRADI_40_REZ_PREDUJAM
 IS
--
  iznos_l szmp_parametri.vrijednost%TYPE; -- IRN 3443
BEGIN
  -- Doputeni iznos razlike izmeu traenog i primljenog predujma u rezervacijama (u domaoj valuti)
  iznos_l := pra_rec_zaj.vrijednost_parametra ('1197');

  FOR rez_c IN (
    SELECT
      rez.ime,
      rez.prezime,
      rez.email,
      rez.jez_id,
      jez.sifra_3a AS jez_sifra_3a,
      rez.rbr AS rez_rbr,
      rez.god_poslovna AS rez_god_poslovna,
      so.sifra AS so_sifra,
      so.naziv AS so_naziv,
      TO_CHAR (rez.dat_dolaska, 'DD.MM.RRRR') AS dat_dolaska,
      TO_CHAR (rez.dat_odlaska, 'DD.MM.RRRR') AS dat_odlaska,
      LTRIM (TO_CHAR (rez.izn_predujma, '9G999G999G990D00')) AS izn_predujma, -- IRN 2908; dodala LTRIM
      val.sifra_3a AS val_sifra_3a,
      TO_CHAR (rez.dat_opcije, 'DD.MM.RRRR') AS dat_opcije,
      rez.id
    FROM
      t_rezervacije rez,
      s_jezici jez,
      m_so so,
      s_valute val
    WHERE
      rez.jez_id = jez.id(+)
      AND rez.so_id = so.id
      AND rez.val_id = val.id(+)
      AND rez.oznaka = 'V'
      AND rez.ozn_vstorna IS NULL
      AND rez.dat_dolaska > TRUNC (SYSDATE)
      AND rez.email IS NOT NULL
      AND rez.izn_predujma IS NOT NULL
      AND NVL (rez.dat_opcije, (TRUNC (rez.unos_dat) + pkavepor_row_m.br_dana)) = TRUNC (SYSDATE)
      AND (rez.izn_predujma - pra_rec_s5.izn_rez_pred (rez.id, rez.val_id)) > (iznos_l / pra_pka.izn_tecaja_parametri (rez.val_id, TRUNC (SYSDATE)))
      /*
      IRN 3443
      ako je danas ve poslana poruka te vrste za tu rezervaciju na taj email
      onda je nemoj slati ponovo
      */
      AND NOT EXISTS (
          SELECT NULL
            FROM lpka_veporuka l
           WHERE TRUNC (l.unos_dat) = TRUNC (SYSDATE)
             AND l.pkavepor_id = pkavepor_row_m.id
             AND l.rez_id = rez.id
             AND LOWER (l.email) = LOWER (rez.email)
          )
    ORDER BY
      rez.god_poslovna, rez.rbr)
  LOOP
    BEGIN
      ime_m              := rez_c.ime;
      prezime_m          := rez_c.prezime;
      email_m            := rez_c.email;
      rez_rbr_m          := rez_c.rez_rbr;
      rez_god_poslovna_m := rez_c.rez_god_poslovna;
      so_sifra_m         := rez_c.so_sifra;
      so_naziv_m         := rez_c.so_naziv;
      dat_dolaska_m      := rez_c.dat_dolaska;
      dat_odlaska_m      := rez_c.dat_odlaska;
      izn_predujma_m     := rez_c.izn_predujma;
      val_sifra_3a_m     := rez_c.val_sifra_3a;
      dat_opcije_m       := rez_c.dat_opcije;
      IF pkavepor_row_m.ozn_sms = 0 THEN -- IRN 3275
        pripremi_dijelove_poruke (rez_c.jez_id, rez_c.jez_sifra_3a);
        pra_pka2.salji_html_email (
          recipient_p    => rez_c.email,
          recipient_h_p  => INITCAP (rez_c.ime) || ' ' || INITCAP (rez_c.prezime),
          sender_p       => pkavepor_row_m.email_from,
          sender_h_p     => pkavepor_row_m.naz_from,
          bcc_p          => pkavepor_row_m.email_bcc,
          subject_p      => subject_m,
          text_p         => body_text_m,
          host_p         => host_m,
          port_p         => port_m,
          html_p         => body_html_m,
          attach_name1_p => attach_name1_m,
          attach_mime1_p => attach_mime1_m,
          attach_blob1_p => attach_blob1_m,
          attach_name2_p => attach_name2_m,
          attach_mime2_p => attach_mime2_m,
          attach_blob2_p => attach_blob2_m);
        -- IRN 3360
        lpkavepor_row_m := NULL;
        lpkavepor_row_m.pkavepor_id := pkavepor_row_m.id;
        lpkavepor_row_m.rez_id := rez_c.id;
        lpkavepor_row_m.email  := rez_c.email;
        pra_mpka_veporuka.puni_lpkavepor (lpkavepor_row_m);
      END IF;
    EXCEPTION
      WHEN OTHERS THEN
        -- Pogreka kod slanja e-poruke (email; prezime; ime; oznaka; greka)
        pra_pka_iud.puni_pkapro ('PKA', '0010', SUBSTR (rez_c.email || ' ' || rez_c.prezime || ' ' || rez_c.ime || ' ' || pkavepor_row_m.oznaka || ' ' || SQLERRM, 1, 2000), 0);
    END;
  END LOOP;
END;
PROCEDURE OBRADI_60_REZ_PRISTUPNI_KOD
 IS
-- IRN 3212
  sc_param_1017_l szmp_parametri.vrijednost%TYPE; -- IRN 3329
  pristupni_kod_l t_rezervacije.pristupni_kod%TYPE;

  CURSOR rezsj_c (rez_id_k t_rezervacije.id%TYPE) IS -- IRN 3669
    SELECT sj.broj
      FROM t_rez_vsj rezvsj,
           m_sj sj
     WHERE rezvsj.sj_id = sj.id
       AND rezvsj.rez_id = rez_id_k
    UNION ALL
    SELECT sj.broj
      FROM trec_rez_sj recrezsj,
           m_sj sj,
           t_rez_vsj rezvsj
     WHERE recrezsj.sj_id = sj.id
       AND recrezsj.rezvsj_id = rezvsj.id
       AND rezvsj.rez_id = rez_id_k
     ORDER BY 1;
BEGIN

  -- ifre vrsta MS (odvojene zarezom) za ije se rezervacije pristupni kod generira i alje automatski ili nebitno.
  sc_param_1017_l := pra_zmp_zaj.zmppar_vrijednost ('SC', '1017'); -- IRN 3329
  IF sc_param_1017_l = 'nebitno' THEN
    RETURN;
  END IF;

  -- IRN 3275, Poetni sat prijave u obliku HH24 (npr. 14) ili nebitno.
  sc_param_1003_m := pra_zmp_zaj.zmppar_vrijednost ('SC', '1003');
  IF sc_param_1003_m = 'nebitno' THEN
    sc_param_1003_m := NULL;
  END IF;

  FOR rez_c IN (
    SELECT rez.id, rez.ime, rez.prezime, rez.email, rez.jez_id, jez.sifra_3a AS jez_sifra_3a,
           TO_CHAR (rez.dat_dolaska, 'DD.MM.RRRR') dat_dolaska,
           TO_CHAR (rez.dat_odlaska, 'DD.MM.RRRR') dat_odlaska
      FROM t_rezervacije rez,
           s_jezici jez
     WHERE rez.jez_id = jez.id(+)
       AND rez.oznaka = 'V'
       AND rez.ozn_vstorna IS NULL
       AND rez.email IS NOT NULL
       AND rez.dat_dolaska BETWEEN TRUNC (SYSDATE) AND (TRUNC (SYSDATE) + pkavepor_row_m.br_dana) -- IRN 3212 24.09.2020.
       AND rez.ms_id IN (
           SELECT id FROM m_msegmenti WHERE vms_id IN (
             SELECT id FROM s_vmsegmenata WHERE -1 = zmp_zaj.string_in_list (sifra, sc_param_1017_l)
             )
           )
       AND rez.pristupni_kod IS NULL
     ORDER BY rez.god_poslovna, rez.rbr)
  LOOP
    BEGIN

      -- generiraj pristupni kod
      pristupni_kod_l := pra_rec3.pristupni_kod (NULL, rez_c.id);
      UPDATE t_rezervacije
         SET pristupni_kod = pristupni_kod_l
       WHERE id = rez_c.id;
      COMMIT;

      ime_m           := rez_c.ime;
      prezime_m       := rez_c.prezime;
      email_m         := rez_c.email;
      pristupni_kod_m := pristupni_kod_l;
      dat_dolaska_m   := rez_c.dat_dolaska;
      dat_odlaska_m   := rez_c.dat_odlaska;
      -- IRN 3669
      sj_broj1_m := NULL;
      OPEN rezsj_c (rez_c.id);
      FETCH rezsj_c INTO sj_broj1_m;
      CLOSE rezsj_c;
      -- KRAJ IRN 3669
      IF pkavepor_row_m.ozn_sms = 0 THEN -- IRN 3275
        pripremi_dijelove_poruke (rez_c.jez_id, rez_c.jez_sifra_3a);
        -- poalji e-poruku s pristupnim kodom
        pra_pka2.salji_html_email (
          recipient_p    => rez_c.email,
          recipient_h_p  => INITCAP (rez_c.ime) || ' ' || INITCAP (rez_c.prezime),
          sender_p       => pkavepor_row_m.email_from,
          sender_h_p     => pkavepor_row_m.naz_from,
          bcc_p          => pkavepor_row_m.email_bcc,
          subject_p      => subject_m,
          text_p         => body_text_m,
          host_p         => host_m,
          port_p         => port_m,
          html_p         => body_html_m,
          attach_name1_p => attach_name1_m,
          attach_mime1_p => attach_mime1_m,
          attach_blob1_p => attach_blob1_m,
          attach_name2_p => attach_name2_m,
          attach_mime2_p => attach_mime2_m,
          attach_blob2_p => attach_blob2_m);
        -- IRN 3360
        lpkavepor_row_m := NULL;
        lpkavepor_row_m.pkavepor_id := pkavepor_row_m.id;
        lpkavepor_row_m.rez_id := rez_c.id;
        lpkavepor_row_m.email  := rez_c.email;
        pra_mpka_veporuka.puni_lpkavepor (lpkavepor_row_m);
      END IF;
    EXCEPTION
      WHEN OTHERS THEN
        -- IRN 3628
        UPDATE t_rezervacije
           SET pristupni_kod = NULL
         WHERE id = rez_c.id;
        COMMIT;
        /*
        UTL_TCP.close_all_connections dodan jer je UTL_SMTP.quit koji se poziva iz
        pra_pka2.salji_html_email prespor, pa se javlja greka "too many connections"
        */
        UTL_TCP.close_all_connections;
        -- KRAJ IRN 3628
        -- Pogreka kod slanja e-poruke (email; prezime; ime; oznaka; greka)
        pra_pka_iud.puni_pkapro ('PKA', '0010', SUBSTR (rez_c.email || ' ' || rez_c.prezime || ' ' || rez_c.ime || ' ' || pkavepor_row_m.oznaka || ' ' || SQLERRM, 1, 2000), 0);
    END;

    DBMS_LOCK.sleep (3); -- IRN 3628

  END LOOP;

  -- IRN 4031
  -- E-poruku s pristupnim kodom ponovo poslati (dan prije dolaska) gostima koji nisu obavili pretprijavu: da ili ne.
  IF pra_zmp_zaj.zmppar_vrijednost ('SC', '1020') = 'da' THEN
    NULL; -- IRN 4079
  ELSE
    RETURN;
  END IF;

  FOR rez2_c IN (
    SELECT rez.id, rez.ime, rez.prezime, rez.email, rez.jez_id, jez.sifra_3a AS jez_sifra_3a,
           TO_CHAR (rez.dat_dolaska, 'DD.MM.RRRR') dat_dolaska,
           TO_CHAR (rez.dat_odlaska, 'DD.MM.RRRR') dat_odlaska,
           rez.pristupni_kod
      FROM t_rezervacije rez,
           s_jezici jez
     WHERE pra_zmp_zaj.zmppar_vrijednost ('SC', '1020') = 'da'
       AND rez.jez_id = jez.id(+)
       AND rez.oznaka = 'V'
       AND rez.ozn_vstorna IS NULL
       AND rez.email IS NOT NULL
       AND rez.dat_dolaska = TRUNC (SYSDATE) + 1
       AND rez.pristupni_kod IS NOT NULL
       AND (SELECT NVL (SUM (br_osoba), 0) FROM t_rez_vsj WHERE rez_id = rez.id) -- rezervirano
           >
           (SELECT COUNT (1)
              FROM t_rez_gost rezgost, t_rez_vsj rezvsj
             WHERE rezgost.rezvsj_id = rezvsj.id
               AND rezvsj.rez_id = rez.id
               AND rezgost.sc_korisnik IS NOT NULL) -- pretprijavljeno
     ORDER BY rez.god_poslovna, rez.rbr)
  LOOP
    BEGIN

      ime_m           := rez2_c.ime;
      prezime_m       := rez2_c.prezime;
      email_m         := rez2_c.email;
      pristupni_kod_m := rez2_c.pristupni_kod;
      dat_dolaska_m   := rez2_c.dat_dolaska;
      dat_odlaska_m   := rez2_c.dat_odlaska;

      sj_broj1_m := NULL;
      OPEN rezsj_c (rez2_c.id);
      FETCH rezsj_c INTO sj_broj1_m;
      CLOSE rezsj_c;

      IF pkavepor_row_m.ozn_sms = 0 THEN
        pripremi_dijelove_poruke (rez2_c.jez_id, rez2_c.jez_sifra_3a);
        -- poalji e-poruku s pristupnim kodom
        pra_pka2.salji_html_email (
          recipient_p    => rez2_c.email,
          recipient_h_p  => INITCAP (rez2_c.ime) || ' ' || INITCAP (rez2_c.prezime),
          sender_p       => pkavepor_row_m.email_from,
          sender_h_p     => pkavepor_row_m.naz_from,
          bcc_p          => pkavepor_row_m.email_bcc,
          subject_p      => subject_m,
          text_p         => body_text_m,
          host_p         => host_m,
          port_p         => port_m,
          html_p         => body_html_m,
          attach_name1_p => attach_name1_m,
          attach_mime1_p => attach_mime1_m,
          attach_blob1_p => attach_blob1_m,
          attach_name2_p => attach_name2_m,
          attach_mime2_p => attach_mime2_m,
          attach_blob2_p => attach_blob2_m);

        lpkavepor_row_m := NULL;
        lpkavepor_row_m.pkavepor_id := pkavepor_row_m.id;
        lpkavepor_row_m.rez_id := rez2_c.id;
        lpkavepor_row_m.email  := rez2_c.email;
        pra_mpka_veporuka.puni_lpkavepor (lpkavepor_row_m);
      END IF;
    EXCEPTION
      WHEN OTHERS THEN
        UTL_TCP.close_all_connections;
        -- Pogreka kod slanja e-poruke (email; prezime; ime; oznaka; greka)
        pra_pka_iud.puni_pkapro ('PKA', '0010', SUBSTR (rez2_c.email || ' ' || rez2_c.prezime || ' ' || rez2_c.ime || ' ' || pkavepor_row_m.oznaka || ' (2) ' || SQLERRM, 1, 2000), 0);
    END;

    DBMS_LOCK.sleep (3);

  END LOOP;
  -- KRAJ IRN 4031

END;
PROCEDURE PRIPREMI_DIJELOVE_PORUKE
 (JEZ_ID_P IN NUMBER
 ,JEZ_SIFRA_3A_P IN VARCHAR2
 )
 IS
--
-- IRN 3275; parametri ime_p, prezime_p, ... zamijenjeni s ime_m, prezime_m, ...
  CURSOR vnap_c (vnap_id_k IN m_vnapomena.id%TYPE, jez_id_k IN mzmp_vnap_jez.jez_id%TYPE) IS
    SELECT NVL (zmpvnapjez.napomena, vnap.napomena) AS napomena
      FROM m_vnapomena vnap,
           (
           SELECT vnap_id, napomena
             FROM mzmp_vnap_jez
            WHERE jez_id = jez_id_k
              AND vnap_id = vnap_id_k
           ) zmpvnapjez
    WHERE vnap.id = vnap_id_k
      AND vnap.id = zmpvnapjez.vnap_id (+);

  CURSOR pkaveporje_c IS -- IRN 3081
    SELECT 1 AS poredak, mpka_vepor_jez.*
      FROM mpka_vepor_jez
     WHERE pkavepor_id = pkavepor_row_m.id
       AND jez_id = jez_id_p
    UNION ALL
    SELECT 2 AS poredak, mpka_vepor_jez.*
      FROM mpka_vepor_jez
     WHERE pkavepor_id = pkavepor_row_m.id
       AND jez_id = pkavepor_row_m.jez_id
    ORDER BY 1;
  pkaveporje_c_l pkaveporje_c%ROWTYPE;
BEGIN
  subject_m      := NULL;
  body_text_m    := NULL;
  body_html_m    := NULL;
  attach_name1_m := NULL;
  attach_mime1_m := NULL;
  attach_blob1_m := NULL;
  attach_name2_m := NULL;
  attach_mime2_m := NULL;
  attach_blob2_m := NULL;

  -- Predmet poruke
  OPEN vnap_c (pkavepor_row_m.vnap_subject_id, jez_id_p);
  FETCH vnap_c INTO subject_m;
  CLOSE vnap_c;

  subject_m := REPLACE (subject_m, '$ReservationBusinessYear$', rez_god_poslovna_m); -- IRN 3081
  subject_m := REPLACE (subject_m, '$ReservationNumber$', rez_rbr_m); -- IRN 3081
  subject_m := REPLACE (subject_m, '$PropertyCode$', so_sifra_m); -- IRN 3443
  subject_m := REPLACE (subject_m, '$ReservationID$', br_uputnice_m); -- IRN 3869

  -- Tijelo poruke (tekst)
  IF pkavepor_row_m.vnap_body_id IS NOT NULL THEN
    OPEN vnap_c (pkavepor_row_m.vnap_body_id, jez_id_p);
    FETCH vnap_c INTO body_text_m;
    CLOSE vnap_c;
  END IF;
  IF body_text_m IS NOT NULL THEN
    body_text_m := REPLACE (body_text_m, '$FirstName$', INITCAP (ime_m));
    body_text_m := REPLACE (body_text_m, '$LastName$', INITCAP (prezime_m));
    body_text_m := REPLACE (body_text_m, '$ReservationNumber$', rez_rbr_m);
    body_text_m := REPLACE (body_text_m, '$ReservationBusinessYear$', rez_god_poslovna_m);
    body_text_m := REPLACE (body_text_m, '$PropertyCode$', so_sifra_m);
    body_text_m := REPLACE (body_text_m, '$PropertyName$', so_naziv_m);
    body_text_m := REPLACE (body_text_m, '$ArrivalDate$', dat_dolaska_m);
    body_text_m := REPLACE (body_text_m, '$DepartureDate$', dat_odlaska_m);
    body_text_m := REPLACE (body_text_m, '$AdvancePaymentAmount$', izn_predujma_m);
    body_text_m := REPLACE (body_text_m, '$CurrencyCode$', val_sifra_3a_m);
    body_text_m := REPLACE (body_text_m, '$OptionDate$', dat_opcije_m);
    body_text_m := REPLACE (body_text_m, '$AccessCode$', pristupni_kod_m); -- IRN 2908
    -- IRN 3081
    body_text_m := REPLACE (body_text_m, '$Email$', LOWER (email_m));
    body_text_m := REPLACE (body_text_m, '$PropertyPlaceName$', INITCAP (so_pos_naziv_m));
    body_text_m := REPLACE (body_text_m, '$PropertyEmail$', so_email_m);
    body_text_m := REPLACE (body_text_m, '$ReservationNote$', rez_napomena_m);
    -- KRAJ IRN 3081
    body_text_m := REPLACE (body_text_m, '$PropertySettlementName$', INITCAP (so_naz_mjesta_m)); -- IRN 3134
    body_text_m := REPLACE (body_text_m, '$Check-inTime$', TO_CHAR (TO_DATE (sc_param_1003_m, 'HH24:MI'), 'HH24:MI')); -- IRN 3275
    body_text_m := REPLACE (body_text_m, '$Quantity$', loyvbod_kolicina_m); -- IRN 3360
    body_text_m := REPLACE (body_text_m, '$UnitCode1$', sj_broj1_m); -- IRN 3669
    body_text_m := REPLACE (body_text_m, '$ReservationID$', br_uputnice_m); -- IRN 3869
    body_text_m := REPLACE (body_text_m, '$PayPerURL$', ppord_url_m);       -- IRN 3869
  END IF;

  IF pkavepor_row_m.staza IS NOT NULL THEN
    IF pkavepor_row_m.staza IN ('nebitno', 'none') THEN -- IRN 3081
      OPEN pkaveporje_c;
      FETCH pkaveporje_c INTO pkaveporje_c_l;
      CLOSE pkaveporje_c;
    END IF;
    -- Tijelo poruke (HTML - CLOB)
    IF pkavepor_row_m.body_html IS NOT NULL THEN
      IF pkavepor_row_m.body_html IN ('nebitno', 'none') THEN -- IRN 3081
        body_html_m := blob2clob (pkaveporje_c_l.body_html);
      ELSE
        body_html_m := pra_pka2.clob_from_file (pkavepor_row_m.staza, pkavepor_row_m.body_html || '.html', 'html', jez_sifra_3a_p);
      END IF;
      -- KRAJ IRN 3081
      IF body_html_m IS NOT NULL THEN
        body_html_m := REPLACE (body_html_m, '$FirstName$', INITCAP (ime_m));
        body_html_m := REPLACE (body_html_m, '$LastName$', INITCAP (prezime_m));
        body_html_m := REPLACE (body_html_m, '$ReservationNumber$', rez_rbr_m);
        body_html_m := REPLACE (body_html_m, '$ReservationBusinessYear$', rez_god_poslovna_m);
        body_html_m := REPLACE (body_html_m, '$PropertyCode$', so_sifra_m);
        body_html_m := REPLACE (body_html_m, '$PropertyName$', so_naziv_m);
        body_html_m := REPLACE (body_html_m, '$ArrivalDate$', dat_dolaska_m);
        body_html_m := REPLACE (body_html_m, '$DepartureDate$', dat_odlaska_m);
        body_html_m := REPLACE (body_html_m, '$AdvancePaymentAmount$', izn_predujma_m);
        body_html_m := REPLACE (body_html_m, '$CurrencyCode$', val_sifra_3a_m);
        body_html_m := REPLACE (body_html_m, '$OptionDate$', dat_opcije_m);
        body_html_m := REPLACE (body_html_m, '$AccessCode$', pristupni_kod_m); -- IRN 2908
        -- IRN 3081
        body_html_m := REPLACE (body_html_m, '$Email$', LOWER (email_m));
        body_html_m := REPLACE (body_html_m, '$PropertyPlaceName$', INITCAP (so_pos_naziv_m));
        body_html_m := REPLACE (body_html_m, '$PropertyEmail$', so_email_m);
        body_html_m := REPLACE (body_html_m, '$ReservationNote$', rez_napomena_m);
        -- KRAJ IRN 3081
        body_html_m := REPLACE (body_html_m, '$PropertySettlementName$', INITCAP (so_naz_mjesta_m)); -- IRN 3134
        body_html_m := REPLACE (body_html_m, '$Check-inTime$', TO_CHAR (TO_DATE (sc_param_1003_m, 'HH24:MI'), 'HH24:MI')); -- IRN 3275
        body_html_m := REPLACE (body_html_m, '$Quantity$', loyvbod_kolicina_m); -- IRN 3360
        body_html_m := REPLACE (body_html_m, '$UnitCode1$', sj_broj1_m); -- IRN 3669
        body_html_m := REPLACE (body_html_m, '$ReservationID$', br_uputnice_m); -- IRN 3869
        body_html_m := REPLACE (body_html_m, '$PayPerURL$', ppord_url_m);       -- IRN 3869
      END IF;
    END IF;
    -- Privitak 1 (BLOB)
    IF pkavepor_row_m.prilog1 IS NOT NULL AND pkavepor_row_m.nastavak1 IS NOT NULL THEN
      attach_name1_m := pkavepor_row_m.prilog1 || '.' || pkavepor_row_m.nastavak1;
      attach_mime1_m := 'application/' || pkavepor_row_m.nastavak1;
      attach_blob1_m := pra_pka2.blob_from_file (pkavepor_row_m.staza, attach_name1_m, pkavepor_row_m.nastavak1, jez_sifra_3a_p);
    ELSIF pkaveporje_c_l.prilog1 IS NOT NULL AND pkaveporje_c_l.prilog1_naziv IS NOT NULL THEN -- IRN 3081
      attach_name1_m := pkaveporje_c_l.prilog1_naziv;
      attach_mime1_m := 'application/' || SUBSTR (pkaveporje_c_l.prilog1_naziv, INSTR (pkaveporje_c_l.prilog1_naziv, '.') + 1);
      attach_blob1_m := pkaveporje_c_l.prilog1;
    END IF;
    -- Privitak 2 (BLOB)
    IF pkavepor_row_m.prilog2 IS NOT NULL AND pkavepor_row_m.nastavak2 IS NOT NULL THEN
      attach_name2_m := pkavepor_row_m.prilog2 || '.' || pkavepor_row_m.nastavak2;
      attach_mime2_m := 'application/' || pkavepor_row_m.nastavak2;
      attach_blob2_m := pra_pka2.blob_from_file (pkavepor_row_m.staza, attach_name2_m, pkavepor_row_m.nastavak2, jez_sifra_3a_p);
    ELSIF pkaveporje_c_l.prilog2 IS NOT NULL AND pkaveporje_c_l.prilog2_naziv IS NOT NULL THEN -- IRN 3081
      attach_name2_m := pkaveporje_c_l.prilog2_naziv;
      attach_mime2_m := 'application/' || SUBSTR (pkaveporje_c_l.prilog2_naziv, INSTR (pkaveporje_c_l.prilog2_naziv, '.') + 1);
      attach_blob2_m := pkaveporje_c_l.prilog2;
    END IF;
  END IF;
END;
PROCEDURE SALJI_PRISTUPNI_KOD
 (OZN_VEPORUKA_P IN mpka_veporuka.oznaka%TYPE
 ,IME_P IN mpka_adrese.ime%TYPE
 ,PREZIME_P IN mpka_adrese.prezime%TYPE
 ,EMAIL_P IN mpka_adrese.email%TYPE
 ,JEZ_ID_P IN s_jezici.id%TYPE
 ,JEZ_SIFRA_3A_P IN s_jezici.sifra_3a%TYPE
 ,PRISTUPNI_KOD_P IN t_zakup.pristupni_kod%TYPE
 ,DAT_DOLASKA_P IN t_rezervacije.dat_dolaska%TYPE := NULL
 ,DAT_ODLASKA_P IN t_rezervacije.dat_odlaska%TYPE := NULL
 ,ZAK_ID_P IN t_zakup.id%TYPE := NULL
 ,REZ_ID_P IN t_rezervacije.id%TYPE := NULL
 ,REZGOST_ID_P IN t_rez_gost.id%TYPE := NULL
 ,OZN_POSLANO_P OUT NUMBER
 )
 IS
-- IRN 2908; poziva se iz modula REC2050 - Ugovori o zakupu i REC2120 - Rezervacije

  CURSOR pkavepor_c IS
    SELECT *
      FROM mpka_veporuka
     WHERE oznaka = ozn_veporuka_p
       AND TRUNC (SYSDATE) BETWEEN dat_valjan AND (NVL (dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) - 1)
       AND ozn_sms = 0 -- IRN 3275
     ORDER BY sifra;

  CURSOR rezgost_c (rezgost_id_k t_rez_gost.id%TYPE) IS -- IRN 3669
    SELECT 1 AS poredak, sj.broj
      FROM t_rez_gost rezgost,
           m_sj sj
     WHERE rezgost.sj_id = sj.id
       AND rezgost.id = rezgost_id_k
    UNION ALL
    SELECT 2, sj.broj
      FROM t_rez_gost rezgost,
           t_rez_vsj rezvsj,
           m_sj sj
     WHERE rezgost.rezvsj_id = rezvsj.id
       AND rezgost.id = rezgost_id_k
       AND rezvsj.sj_id = sj.id
    UNION ALL
    SELECT 3, sj.broj
      FROM t_rez_gost rezgost,
           trec_rez_sj recrezsj,
           m_sj sj
     WHERE rezgost.rezvsj_id = recrezsj.rezvsj_id
       AND rezgost.id = rezgost_id_k
       AND recrezsj.sj_id = sj.id
     ORDER BY 1, 2;

  poredak_l NUMBER;

  CURSOR rezsj_c (rez_id_k t_rezervacije.id%TYPE) IS -- IRN 3669
    SELECT sj.broj
      FROM t_rez_vsj rezvsj,
           m_sj sj
     WHERE rezvsj.sj_id = sj.id
       AND rezvsj.rez_id = rez_id_k
    UNION ALL
    SELECT sj.broj
      FROM trec_rez_sj recrezsj,
           m_sj sj,
           t_rez_vsj rezvsj
     WHERE recrezsj.sj_id = sj.id
       AND recrezsj.rezvsj_id = rezvsj.id
       AND rezvsj.rez_id = rez_id_k
     ORDER BY 1;
BEGIN

  host_m := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0069');
  port_m := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0070');

  IF host_m = 'nebitno' OR port_m = 'nebitno' THEN -- IRN 3081
    RETURN;
  END IF;

  OPEN pkavepor_c;
  FETCH pkavepor_c INTO pkavepor_row_m;
  IF pkavepor_c%NOTFOUND THEN
    CLOSE pkavepor_c;
    RETURN;
  END IF;
  CLOSE pkavepor_c;

  -- IRN 3275, Poetni sat prijave u obliku HH24 (npr. 14) ili nebitno.
  sc_param_1003_m := pra_zmp_zaj.zmppar_vrijednost ('SC', '1003');
  IF sc_param_1003_m = 'nebitno' THEN
    sc_param_1003_m := NULL;
  END IF;

  -- IRN 3275
  ime_m := ime_p;
  prezime_m := prezime_p;
  email_m := email_p;
  pristupni_kod_m := pristupni_kod_p;
  dat_dolaska_m := TO_CHAR (dat_dolaska_p, 'DD.MM.RRRR');
  dat_odlaska_m := TO_CHAR (dat_odlaska_p, 'DD.MM.RRRR');

  -- IRN 3669
  sj_broj1_m := NULL;
  IF rezgost_id_p IS NOT NULL THEN
    OPEN rezgost_c (rezgost_id_p);
    FETCH rezgost_c INTO poredak_l, sj_broj1_m;
    CLOSE rezgost_c;
  ELSIF rezgost_id_p IS NULL AND rez_id_p IS NOT NULL THEN
    OPEN rezsj_c (rez_id_p);
    FETCH rezsj_c INTO sj_broj1_m;
    CLOSE rezsj_c;
  END IF;
  -- KRAJ IRN 3669

  pripremi_dijelove_poruke (jez_id_p, jez_sifra_3a_p);
  -- KRAJ IRN 3275

  pra_pka2.salji_html_email (
    recipient_p    => email_p,
    recipient_h_p  => INITCAP (ime_p) || ' ' || INITCAP (prezime_p),
    sender_p       => pkavepor_row_m.email_from,
    sender_h_p     => pkavepor_row_m.naz_from,
    bcc_p          => pkavepor_row_m.email_bcc,
    subject_p      => subject_m,
    text_p         => body_text_m,
    host_p         => host_m,
    port_p         => port_m,
    html_p         => body_html_m,
    attach_name1_p => attach_name1_m,
    attach_mime1_p => attach_mime1_m,
    attach_blob1_p => attach_blob1_m,
    attach_name2_p => attach_name2_m,
    attach_mime2_p => attach_mime2_m,
    attach_blob2_p => attach_blob2_m);

  -- IRN 3360
  lpkavepor_row_m := NULL;
  lpkavepor_row_m.pkavepor_id := pkavepor_row_m.id;
  lpkavepor_row_m.zak_id := zak_id_p;
  lpkavepor_row_m.rez_id := rez_id_p;
  lpkavepor_row_m.rezgost_id := rezgost_id_p;
  lpkavepor_row_m.email := email_p;
  pra_mpka_veporuka.puni_lpkavepor (lpkavepor_row_m);

  ozn_poslano_p := -1;

END;
FUNCTION PORJEZ
 (SIFRA_METAPL_P IN s_poruke.sifra_metapl%TYPE
 ,SIFRA_P IN s_poruke.sifra%TYPE
 ,SIFRA_JEZ_P IN s_por_jez.sifra_jez%TYPE
 ,TEKST_P IN s_por_jez.tekst%TYPE
 ,VAR0_P IN VARCHAR2 := NULL
 ,VAR1_P IN VARCHAR2 := NULL
 ,VAR2_P IN VARCHAR2 := NULL
 ,VAR3_P IN VARCHAR2 := NULL
 ,VAR4_P IN VARCHAR2 := NULL
 ,VAR5_P IN VARCHAR2 := NULL
 ,VAR6_P IN VARCHAR2 := NULL
 ,VAR7_P IN VARCHAR2 := NULL
 ,VAR8_P IN VARCHAR2 := NULL
 ,VAR9_P IN VARCHAR2 := NULL
 )
 RETURN VARCHAR2
 IS
--
  tekst_l VARCHAR2 (1000);
  sifra_jez_l s_jezici.sifra_3a%TYPE;
BEGIN
  -- poruka na jeziku npr. rezervacije
  SELECT MIN (tekst) INTO tekst_l
    FROM s_por_jez
   WHERE sifra_metapl = UPPER (sifra_metapl_p)
     AND sifra_por    = UPPER (sifra_p)
     AND sifra_jez    = sifra_jez_p;
  IF tekst_l IS NULL THEN
    sifra_jez_l := NVL (jez_sifra_3a_m, pra_zmp_zaj.vrijednost_parametra ('0014'));
    -- poruka na jeziku vrste e-poruka ili domaem jeziku
    SELECT MIN (tekst) INTO tekst_l
      FROM s_por_jez
     WHERE sifra_metapl = UPPER (sifra_metapl_p)
       AND sifra_por    = UPPER (sifra_p)
       AND sifra_jez    = sifra_jez_l;
  END IF;
  IF tekst_l IS NULL THEN
    -- poruka
    SELECT MIN (tekst) INTO tekst_l
      FROM s_poruke
     WHERE sifra_metapl = UPPER (sifra_metapl_p)
       AND sifra        = UPPER (sifra_p);
  END IF;
  IF tekst_l IS NULL THEN
    -- poslani tekst
    tekst_l := tekst_p;
  END IF;

  tekst_l := REPLACE (tekst_l, '#0', var0_p);
  tekst_l := REPLACE (tekst_l, '#1', var1_p);
  tekst_l := REPLACE (tekst_l, '#2', var2_p);
  tekst_l := REPLACE (tekst_l, '#3', var3_p);
  tekst_l := REPLACE (tekst_l, '#4', var4_p);
  tekst_l := REPLACE (tekst_l, '#5', var5_p);
  tekst_l := REPLACE (tekst_l, '#6', var6_p);
  tekst_l := REPLACE (tekst_l, '#7', var7_p);
  tekst_l := REPLACE (tekst_l, '#8', var8_p);
  tekst_l := REPLACE (tekst_l, '#9', var9_p);

  RETURN tekst_l;
END;
FUNCTION BLOB2CLOB
 (BLOB_P IN BLOB
 )
 RETURN CLOB
 IS
--
  dest_lob_l     CLOB;
  dest_offset_l  NUMBER := 1;
  src_offset_l   NUMBER := 1;
  lang_context_l NUMBER := DBMS_LOB.default_lang_ctx;
  warning_l      NUMBER;
BEGIN
  IF blob_p IS NULL THEN
    -- da se ne javlja greka ORA-06502: PL/SQL: numeric or value error: invalid LOB specified
    RETURN (NULL);
  END IF;
  DBMS_LOB.createtemporary (dest_lob_l, TRUE);
  DBMS_LOB.converttoclob (
    dest_lob     => dest_lob_l,
    src_blob     => blob_p,
    amount       => DBMS_LOB.getlength (blob_p),
    dest_offset  => dest_offset_l,
    src_offset   => src_offset_l,
    blob_csid    => NLS_CHARSET_ID ('UTF8'),
    lang_context => lang_context_l,
    warning      => warning_l);
  RETURN (dest_lob_l);
END;
PROCEDURE SALJI_REZ_POTVRDA
 (OZN_VEPORUKA_P IN mpka_veporuka.oznaka%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE
 ,OZN_ISPISI_CIJENE_P IN NUMBER
 ,OZN_POSLANO_P OUT NUMBER
 )
 IS
-- poalji poruku vrste 70 "rezervacija ponuda" ili 80 "rezervacije potvrda"

  CURSOR pkavepor_c IS
    SELECT *
      FROM mpka_veporuka
     WHERE oznaka = ozn_veporuka_p
       AND TRUNC (SYSDATE) BETWEEN dat_valjan AND (NVL (dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) - 1)
       AND ozn_sms = 0 -- IRN 3275
     ORDER BY sifra;

  rez_row_l t_rezervacije%ROWTYPE;
  rez_jez_sifra_3a_l s_jezici.sifra_3a%TYPE;

  html_table_rezvsj_l CLOB;
  html_table_rezusl_l CLOB;
  html_table_pkapd_l CLOB; -- IRN 3134
  --
  recpon2_row_l trec_ponude2%ROWTYPE; -- IRN 3541
  --
  val_sifra_3a_l s_valute.sifra_3a%TYPE;
  knapomena_l VARCHAR2(480);
  /*
  Poruke - labele stupaca html tablica rezvsj i rezusl
  REC0404 - Unit Type
  REC0440 - Unit Number
  PKA0328 - Quantity
  REC0409 - Persons
  PKA0274 - Note
  REC0407 - Service
  III0168 - Period
  -- PKA0328 - Quantity
  PKA0329 - Price
  PKA0330 - Amount
  */
BEGIN

  host_m := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0069');
  port_m := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0070');

  IF rez_id_p IS NULL
    OR host_m = 'nebitno'
    OR port_m = 'nebitno'
  THEN
    RETURN;
  END IF;

  OPEN pkavepor_c;
  FETCH pkavepor_c INTO pkavepor_row_m;
  IF pkavepor_c%NOTFOUND THEN
    CLOSE pkavepor_c;
    RETURN;
  END IF;
  CLOSE pkavepor_c;

  SELECT MIN (sifra_3a) INTO jez_sifra_3a_m FROM s_jezici WHERE id = pkavepor_row_m.jez_id;

  FOR rez_c IN (
    SELECT
      rez.ime, rez.prezime, rez.email,
      rez.jez_id, jez.sifra_3a AS jez_sifra_3a,
      rez.rbr, rez.god_poslovna,
      rez.so_id, so.sifra AS so_sifra, so.naziv AS so_naziv, pos.naziv AS so_pos_naziv, so.email AS so_email,
      so.naz_mjesta AS so_naz_mjesta, -- IRN 3134
      rez.dat_dolaska, rez.dat_odlaska,
      rez.izn_predujma, val.sifra_3a AS val_sifra_3a, rez.dat_opcije,
      rez.pristupni_kod,
      rez.napomena,
      rez.datum, -- IRN 3134
      rez.age_id -- IRN 3541
    FROM
      t_rezervacije rez,
      m_so so,
      m_poste pos,
      s_valute val,
      s_jezici jez
    WHERE
      rez.id = rez_id_p
      AND rez.oznaka = 'V'
      AND rez.ozn_vstorna IS NULL
      AND rez.email IS NOT NULL
      AND (
          (rez.ozn_f = 0 AND ozn_veporuka_p = 70) -- ponuda
          OR
          (rez.ozn_f = -1 AND ozn_veporuka_p = 80) -- potvrda
          )
      AND rez.val_id = val.id(+)
      AND rez.so_id = so.id
      AND so.pos_id = pos.id(+)
      AND rez.jez_id = jez.id(+)
    )
  LOOP
    -- IRN 3275
    ime_m              := INITCAP (rez_c.ime);
    prezime_m          := INITCAP (rez_c.prezime);
    email_m            := LOWER (rez_c.email);
    rez_rbr_m          := rez_c.rbr;
    rez_god_poslovna_m := rez_c.god_poslovna;
    so_sifra_m         := rez_c.so_sifra;
    so_naziv_m         := INITCAP (rez_c.so_naziv);
    dat_dolaska_m      := TO_CHAR (rez_c.dat_dolaska, 'DD.MM.RRRR');
    dat_odlaska_m      := TO_CHAR (rez_c.dat_odlaska, 'DD.MM.RRRR');
    izn_predujma_m     := TRIM (TO_CHAR (rez_c.izn_predujma, '9G999G999G990D00'));
    val_sifra_3a_m     := rez_c.val_sifra_3a;
    dat_opcije_m       := TO_CHAR (rez_c.dat_opcije, 'DD.MM.RRRR');
    pristupni_kod_m    := rez_c.pristupni_kod;
    so_pos_naziv_m     := INITCAP (rez_c.so_pos_naziv);
    so_email_m         := rez_c.so_email;
    rez_napomena_m     := rez_c.napomena;
    so_naz_mjesta_m    := rez_c.so_naz_mjesta; -- IRN 3134
    pripremi_dijelove_poruke (rez_c.jez_id, rez_c.jez_sifra_3a);
    -- KRAJ IRN 3275
    --
    rez_row_l.jez_id   := rez_c.jez_id;
    rez_row_l.so_id    := rez_c.so_id;
    rez_jez_sifra_3a_l := rez_c.jez_sifra_3a;
    rez_row_l.datum    := rez_c.datum; -- IRN 3134
  END LOOP;

  -- ispii html tablicu rezerviranih vrsta SJ $ReservationUnits2$
  IF INSTR (body_html_m, '$ReservationUnits2$') > 0 THEN
    html_table_rezvsj_l := NULL;
    FOR rezvsj_c IN (
      SELECT
        NVL (NVL (vsjjez2.naziv, vsjjez3.naziv), vsjc.naziv) AS vsj_naziv,
        sj.broj AS sj_broj,
        rezvsj.kol_sj,
        rezvsj.br_osoba,
        NVL (NVL (recsovsjje2.opis, recsovsjje3.opis), recsovsj.opis) AS recsovsj_opis
      FROM
        t_rez_vsj rezvsj, s_vsj vsjc, m_sj sj,
        (
        SELECT
          vsj_id,
          naziv
        FROM
          s_vsj_jez
        WHERE
          jez_id = rez_row_l.jez_id
        ) vsjjez2,
        (
        SELECT
          vsj_id,
          naziv
        FROM
          s_vsj_jez
        WHERE
          jez_id = pkavepor_row_m.jez_id
        ) vsjjez3,
        (
        SELECT
          recsovsj_id,
          opis
        FROM
          mrec_sovsj_jez
        WHERE
          jez_id = rez_row_l.jez_id
        ) recsovsjje2,
        (
        SELECT
          recsovsj_id,
          opis
        FROM
          mrec_sovsj_jez
        WHERE
          jez_id = pkavepor_row_m.jez_id
        ) recsovsjje3,
        mrec_so_vsj recsovsj
      WHERE
        rezvsj.rez_id = rez_id_p
        AND rezvsj.vsjc_id = vsjc.id
        AND vsjjez2.vsj_id (+) = vsjc.id
        AND vsjjez3.vsj_id (+) = vsjc.id
        AND rezvsj.sj_id = sj.id (+)
        AND recsovsj.so_id (+) = rez_row_l.so_id
        AND recsovsj.vsj_id (+) = rezvsj.vsjc_id
        AND recsovsjje2.recsovsj_id (+) = recsovsj.id
        AND recsovsjje3.recsovsj_id (+) = recsovsj.id
      )
    LOOP
      html_table_rezvsj_l := html_table_rezvsj_l ||
        '<tr>' ||
        '<td>' || rezvsj_c.vsj_naziv || '</td>' ||
        '<td style="text-align: center;">' || NVL (rezvsj_c.sj_broj, '-') || '</td>' ||
        '<td style="text-align: center;">' || LTRIM (RTRIM (TO_CHAR (rezvsj_c.kol_sj, '9G999'))) || '</td>' ||
        '<td style="text-align: center;">' || LTRIM (RTRIM (TO_CHAR (rezvsj_c.br_osoba, '9G999'))) || '</td>' ||
        '<td>' || NVL (rezvsj_c.recsovsj_opis, '-') || '</td>' ||
        '</tr>';
    END LOOP;
    html_table_rezvsj_l :=
      '<table>' ||
      '<tr>' ||
      '<th>' || porjez ('REC', 'REC0404', rez_jez_sifra_3a_l, 'Unit Type') || '</th>' ||
      '<th style="text-align: center;">' || porjez ('REC', 'REC0440', rez_jez_sifra_3a_l, 'Unit Number') || '</th>' ||
      '<th style="text-align: center;">' || porjez ('PKA', 'PKA0328', rez_jez_sifra_3a_l, 'Quantity') || '</th>' ||
      '<th style="text-align: center;">' || porjez ('REC', 'REC0409', rez_jez_sifra_3a_l, 'Persons') || '</th>' ||
      '<th>' || porjez ('PKA', 'PKA0274', rez_jez_sifra_3a_l, 'Note') || '</th>' ||
      '</tr>' ||
      html_table_rezvsj_l ||
      '</table>';
    body_html_m := REPLACE (body_html_m, '$ReservationUnits2$', html_table_rezvsj_l);
  END IF;
  -- KRAJ ispii html tablicu $ReservationUnits2$

  -- ispii html tablicu rezerviranih usluga $ReservationServices2$
  IF INSTR (body_html_m, '$ReservationServices2$') > 0
    OR INSTR (body_html_m, '$ReservationAmount$') > 0
    OR INSTR (body_text_m, '$ReservationAmount$') > 0
  THEN

    recpon2_row_l.id := pra_zmp_zaj.i3_sekvenca (NULL);

    pra_rec_iud3.kopiraj_rez_recpon2 (
      recpon2_id_p => recpon2_row_l.id,
      rez_id_p => rez_id_p,
      val_id_p => NULL,
      stopa_predujma_p => NULL,
      ozn_platitelja_p => -1,
      nositelj_pred_p => NULL,
      ozn_samo_izracunaj_iznos_p => 0,
      ozn_komitiraj_p => 0,
      recpon2_row_p => recpon2_row_l -- IRN 3541
      );

    FOR usl_c IN (
      -- poetak, usluge koje se ispisuju unutar aranmana
      SELECT
        '00' || DECODE (vsj.sifra, NULL, '01', '00') || recara.sifra AS ara_vsj,
        MIN (usl.ozn_abc) AS usl_ozn_abc,
        recara.sifra AS recara_sifra,
        vsj.sifra AS vsj_sifra,
        recara.sifra AS usl_sifra,
        recara.naziv AS usl_naziv,
        MIN (recpon2usl.dat_poc) AS dat_poc,
        MAX (recpon2usl.dat_zav) AS dat_zav,
        NULL AS br_dana,
        NULL AS br_osoba,
        NULL AS kolicina,
        SUM (
          ROUND (DECODE (recpon2usl.usl_id1, NULL, recpon2usl.cijena, 0)
          * recpon2usl.izn_tecaja / recpon2_row_l.izn_tecaja * recpon2usl.stopa_placanja / 100, 2)
          * DECODE (recpon2usl.obr_po_danu, -1, (recpon2usl.dat_zav - recpon2usl.dat_poc - recpon2usl.obr_zdana), 1)
          ) AS cijena,
        NULL AS ozn_cijene0,
        SUM (
          ROUND (DECODE (recpon2usl.usl_id1, NULL, recpon2usl.cijena, 0)
            * recpon2usl.izn_tecaja / recpon2_row_l.izn_tecaja * recpon2usl.stopa_placanja / 100, 2)
            * DECODE (recpon2usl.obr_po_danu, -1, (recpon2usl.dat_zav - recpon2usl.dat_poc - recpon2usl.obr_zdana), 1)
            * recpon2usl.kolicina
          ) AS iznos,
        NULL AS zvjezdica
      FROM
        trec_pon2_usl recpon2usl,
        s_vsj vsj,
        (
        SELECT
          recara.id id,
          recara.sifra sifra,
          NVL (NVL (recarajez.recara_naziv, recarajez2.recara_naziv), recara.naziv) naziv
        FROM
          mrec_aranzmani recara,
          (
          SELECT
            recara_id,
            naziv recara_naziv
          FROM
            mrec_ara_jez
          WHERE
            jez_id = rez_row_l.jez_id
          ) recarajez,
          (
          SELECT
            recara_id,
            naziv recara_naziv
          FROM
            mrec_ara_jez
          WHERE
            jez_id = pkavepor_row_m.jez_id
          ) recarajez2
        WHERE
          recarajez.recara_id (+) = recara.id
          AND recarajez2.recara_id (+) = recara.id
        ) recara,
        s_usluge usl
      WHERE
        recpon2usl.recpon2_id = recpon2_row_l.id
        AND pra_rec_s4.recarausl_ozn_sum (recpon2usl.recara_id, recpon2usl.usl_id) = -1
        AND pra_rec_rm.vsj_recara_pon2 (recpon2usl.recpon2_id, recpon2usl.recara_id, recpon2usl.br_uputnice, -1) = vsj.id (+)
        AND recpon2usl.recara_id = recara.id
        AND recpon2usl.usl_id = usl.id
      GROUP BY
        vsj.sifra,
        recpon2usl.recara_id,
        recara.sifra,
        recara.naziv,
        recpon2usl.recpon2_id
      -- kraj, usluge koje se ispisuju unutar aranmana
      UNION ALL
      -- poetak, usluge koje se ispisuju izvan aranmana
      SELECT
        DECODE (recara.sifra, NULL, '01', '00') || DECODE (vsj2.sifra, NULL, '01', '00') || recara.sifra AS ara_vsj,
        usl.ozn_abc AS usl_ozn_abc,
        recara.sifra AS recara_sifra,
        vsj.sifra AS vsj_sifra,
        usl.sifra AS usl_sifra,
        usl.naziv AS usl_naziv,
        recpon2usl.dat_poc AS dat_poc,
        recpon2usl.dat_zav AS dat_zav,
        DECODE (recpon2usl.obr_po_danu, -1, (recpon2usl.dat_zav - recpon2usl.dat_poc - recpon2usl.obr_zdana), 1
          ) AS br_dana,
        recpon2usl.kolicina AS br_osoba,
        DECODE (recpon2usl.obr_po_danu, -1, (recpon2usl.dat_zav - recpon2usl.dat_poc - recpon2usl.obr_zdana), 1)
          * recpon2usl.kolicina AS kolicina,
        ROUND (DECODE (recpon2usl.usl_id1, NULL, recpon2usl.cijena, DECODE(usl.ozn_ispis_cijene1, -1, recpon2usl.cijena, 0))
          * recpon2usl.izn_tecaja / recpon2_row_l.izn_tecaja * recpon2usl.stopa_placanja / 100, 2
          ) AS cijena,
        DECODE (recpon2usl.usl_id1, NULL,
          DECODE (recpon2usl.cijena, 0,
            DECODE (usl.ozn_cijenasj, -1, '-', DECODE (usl.ozn_ispis_cijene0, 0, '-', NULL)),
            NULL),
          DECODE (usl.ozn_ispis_cijene1, -1,
            DECODE (recpon2usl.cijena, 0,
              DECODE (usl.ozn_cijenasj, -1, '-', DECODE (usl.ozn_ispis_cijene0, 0, '-', NULL)),
              NULL),
            '-')
          ) AS ozn_cijene0,
        ROUND (DECODE (recpon2usl.usl_id1, NULL, recpon2usl.cijena, DECODE (usl.ozn_ispis_cijene1, -1, recpon2usl.cijena, 0))
          * recpon2usl.izn_tecaja / recpon2_row_l.izn_tecaja * recpon2usl.stopa_placanja / 100, 2)
          * DECODE (recpon2usl.obr_po_danu, -1, (recpon2usl.dat_zav - recpon2usl.dat_poc - recpon2usl.obr_zdana), 1)
          * recpon2usl.kolicina AS iznos,
        DECODE (recpon2usl.usl_id1, NULL,
          NULL,
          DECODE (usl.ozn_ispis_cijene1, -1,
            DECODE (recpon2usl.cijena, 0,
              DECODE (usl.ozn_cijenasj, -1, NULL, DECODE (usl.ozn_ispis_cijene0, 0, NULL, '*')),
              '*'),
            NULL)
          ) AS zvjezdica
      FROM
        trec_pon2_usl recpon2usl,
        s_vsj vsj,
        s_vsj vsj2,
        mrec_aranzmani recara,
        (
        SELECT
          usl.id id,
          usl.sifra sifra,
          NVL (NVL (usljez.usl_naziv, usljez2.usl_naziv), usl.naziv) naziv,
          usl.ozn_cijenasj,
          usl.ozn_ispis_cijene0,
          usl.ozn_ispis_cijene1,
          usl.ozn_abc
        FROM
          s_usluge usl,
          (
          SELECT
            usl_id usl_id,
            naziv usl_naziv
          FROM
            s_usl_jez
          WHERE
            jez_id = rez_row_l.jez_id
          ) usljez,
          (
          SELECT
            usl_id usl_id,
            naziv usl_naziv
          FROM
            s_usl_jez
          WHERE
            jez_id = pkavepor_row_m.jez_id
          ) usljez2
          WHERE
            usljez.usl_id (+) = usl.id
            AND usljez2.usl_id (+) = usl.id
        ) usl
      WHERE
        recpon2usl.recpon2_id = recpon2_row_l.id
        AND pra_rec_s4.recarausl_ozn_sum (recpon2usl.recara_id, recpon2usl.usl_id) = 0
        AND recpon2usl.vsj_id = vsj.id (+)
        AND pra_rec_rm.vsj_recara_pon2 (recpon2usl.recpon2_id, recpon2usl.recara_id, recpon2usl.br_uputnice, -1) = vsj2.id (+)
        AND recpon2usl.usl_id = usl.id
        AND recara.id (+) = recpon2usl.recara_id
      ORDER BY
        1, -- ara_vsj
        2, -- usl_ozn_abc
        3, -- recara_sifra
        4, -- vsj_sifra
        7  -- dat_poc
      )
    LOOP
      html_table_rezusl_l := html_table_rezusl_l ||
        '<tr>' ||
        '<td>' || usl_c.zvjezdica || usl_c.usl_naziv || '</td>' ||
        '<td>' || TO_CHAR (usl_c.dat_poc, 'DD.MM.RRRR') || ' - ' || TO_CHAR (usl_c.dat_zav, 'DD.MM.RRRR') || '</td>' ||
        '<td style="text-align: right;">' || TRIM (TO_CHAR (usl_c.kolicina, '9G999')) || '</td>';
      IF ozn_ispisi_cijene_p = -1 AND usl_c.ozn_cijene0 IS NULL THEN
        html_table_rezusl_l := html_table_rezusl_l ||
          '<td style="text-align: right;">' || TRIM (TO_CHAR (usl_c.cijena, '9G999G999G990D00')) || '</td>' ||
          '<td style="text-align: right;">' || TRIM (TO_CHAR (usl_c.iznos, '9G999G999G990D00')) || '</td>';
      ELSE
        html_table_rezusl_l := html_table_rezusl_l ||
          '<td style="text-align: right;">' || '-' || '</td>' ||
          '<td style="text-align: right;">' || '-' || '</td>';
      END IF;
      html_table_rezusl_l := html_table_rezusl_l ||
        '</tr>';
    END LOOP;

    html_table_rezusl_l :=
      '<table>' ||
      '<tr>' ||
      '<th>' || porjez ('REC', 'REC0407', rez_jez_sifra_3a_l, 'Service') || '</th>' ||
      '<th>' || porjez ('ZMP', 'III0168', rez_jez_sifra_3a_l, 'Period') || '</th>' ||
      '<th style="text-align: right;">' || porjez ('PKA', 'PKA0328', rez_jez_sifra_3a_l, 'Quantity') || '</th>' ||
      '<th style="text-align: right;">' || porjez ('PKA', 'PKA0329', rez_jez_sifra_3a_l, 'Price') || '</th>' ||
      '<th style="text-align: right;">' || porjez ('PKA', 'PKA0330', rez_jez_sifra_3a_l, 'Amount') || '</th>' ||
      '</tr>' ||
      html_table_rezusl_l ||
      '</table>';

    ROLLBACK; -- ne sprema predraun

    body_html_m := REPLACE (body_html_m, '$ReservationServices2$', html_table_rezusl_l);
    IF ozn_ispisi_cijene_p = -1 THEN
      body_html_m := REPLACE (body_html_m, '$ReservationAmount$', TRIM (TO_CHAR (recpon2_row_l.iznos, '9G999G999G990D00')));
      SELECT MIN (sifra_3a) INTO val_sifra_3a_l FROM s_valute WHERE id = recpon2_row_l.val_id;
      body_html_m := REPLACE (body_html_m, '$ReservationCurrencyCode$', val_sifra_3a_l);
      --
      body_text_m := REPLACE (body_text_m, '$ReservationAmount$', TRIM (TO_CHAR (recpon2_row_l.iznos, '9G999G999G990D00')));
      body_text_m := REPLACE (body_text_m, '$ReservationCurrencyCode$', val_sifra_3a_l);

      -- IRN 3541; dvojno iskazivanje iznosa
      IF recpon2_row_l.iznos IS NOT NULL THEN
        -- SVEUKUPNO #0 #1 PO FIKSNOM TEAJU KONVERZIJE 1 EUR = 7,53450 HRK.
        knapomena_l :=
          pra_pka_s3.napomena_2val (
            ROUND (recpon2_row_l.iznos * recpon2_row_l.izn_tecaja, 2), -- iznos u domaoj valuti
            TRUNC (SYSDATE),
            rez_jez_sifra_3a_l);
        body_html_m := REPLACE (body_html_m, '$ConversionNote$', knapomena_l);
        --
        body_text_m := REPLACE (body_text_m, '$ConversionNote$', knapomena_l);
      END IF;
      -- KRAJ IRN 3518; dvojno iskazivanje iznosa

    END IF;
  END IF;
  -- zamijeni sve to je ostalo nezamijenjeno
  body_html_m := REPLACE (body_html_m, '$ReservationAmount$', '-');
  body_html_m := REPLACE (body_html_m, '$ReservationCurrencyCode$', '-');
  body_html_m := REPLACE (body_html_m, '$ConversionNote$', '-');
  --
  body_text_m := REPLACE (body_text_m, '$ReservationAmount$', '-');
  body_text_m := REPLACE (body_text_m, '$ReservationCurrencyCode$', '-');
  body_text_m := REPLACE (body_text_m, '$ConversionNote$', '-');
  -- KRAJ ispii html tablicu $ReservationServices2$

  -- IRN 3134; ispii podatke o prateem dokumentu $AccompanyingDocumentData$
  IF ozn_ispisi_cijene_p = -1 THEN
    html_table_pkapd_l := pkapd_data (rez_id_p, rez_row_l.datum, recpon2_row_l.val_id, recpon2_row_l.iznos, rez_jez_sifra_3a_l);
    body_text_m := REPLACE (body_text_m, '$AccompanyingDocumentData$', html_table_pkapd_l);
    body_html_m := REPLACE (body_html_m, '$AccompanyingDocumentData$', html_table_pkapd_l);
  ELSE
    body_text_m := REPLACE (body_text_m, '$AccompanyingDocumentData$', '-');
    body_html_m := REPLACE (body_html_m, '$AccompanyingDocumentData$', '-');
  END IF;
  -- KRAJ ispii podatke o prateem dokumentu

  pra_pka2.salji_html_email (
    recipient_p    => email_m,
    recipient_h_p  => INITCAP (ime_m) || ' ' || INITCAP (prezime_m),
    sender_p       => pkavepor_row_m.email_from,
    sender_h_p     => pkavepor_row_m.naz_from,
    bcc_p          => pkavepor_row_m.email_bcc,
    subject_p      => subject_m,
    text_p         => body_text_m,
    host_p         => host_m,
    port_p         => port_m,
    html_p         => body_html_m,
    attach_name1_p => attach_name1_m,
    attach_mime1_p => attach_mime1_m,
    attach_blob1_p => attach_blob1_m,
    attach_name2_p => attach_name2_m,
    attach_mime2_p => attach_mime2_m,
    attach_blob2_p => attach_blob2_m
    );

  -- IRN 3360
  lpkavepor_row_m := NULL;
  lpkavepor_row_m.pkavepor_id := pkavepor_row_m.id;
  lpkavepor_row_m.rez_id := rez_id_p;
  lpkavepor_row_m.email := email_m;
  pra_mpka_veporuka.puni_lpkavepor (lpkavepor_row_m);

  ozn_poslano_p := -1;

EXCEPTION
  WHEN OTHERS THEN
    ROLLBACK;
    ozn_poslano_p := 0;
END;
FUNCTION PKAPD_DATA
 (REZ_ID_P IN t_rezervacije.id%TYPE
 ,REZ_DATUM_P IN t_rezervacije.datum%TYPE
 ,VAL_ID_P IN t_rezervacije.val_id%TYPE
 ,REZ_IZNOS_P IN t_rezervacije.izn_rezervacije%TYPE
 ,JEZ_SIFRA_3A_P IN s_jezici.sifra_3a%TYPE
 )
 RETURN CLOB
 IS
-- IRN 3134; poziva se iz procedure salji_rez_potvrda
  CURSOR pkapd_c IS
    SELECT vlas.oib AS pd_oib,
           TO_NUMBER (rbr) || '-' || oj_sifra || '-' || vdok_sifra2n AS pd_broj,
           TO_CHAR (pkapd.datum, 'DD.MM.RRRR') || ' ' || TO_CHAR (pkapd.unos_dat, 'HH24:MI:SS') AS pd_datum,
           iznos,
           val_id,
           LTRIM (RTRIM (TO_CHAR (ROUND (pkapd.iznos * pkapd.izn_tecaja, 2), '9G999G999G990D00'))) AS pd_iznos,
           zki,
           jir
      FROM tpka_pdokumenti pkapd,
           s_vlasnik vlas
     WHERE pkapd.rez_id = rez_id_p
     ORDER BY pkapd.id DESC;
  pkapd_c_l pkapd_c%ROWTYPE;
  napomena_l VARCHAR2(4000);
  /*
  Poruke labele redaka html tablice
  REC1196 OIB
  PKA0157 Broj
  III0067 Datum
  PKA0330 Iznos
  PKA0335 ZKI
  PKA0336 JIR
  PKA0274 Napomena
  */
BEGIN
  IF rez_id_p IS NULL
    OR rez_datum_p IS NULL
    OR val_id_p IS NULL
    OR rez_iznos_p IS NULL
    OR pra_pka_i3fiskal.vlas_u_fsus_hr (rez_datum_p) = 0
  THEN
    RETURN '-';
  END IF;

  -- PKA parametar 1088 = ifra vrste napomena "Ovo nije fiskalizirani raun" ili nebitno.
  SELECT MIN (napomena) INTO napomena_l FROM m_vnapomena WHERE sifra = pra_pka_zaj.vrijednost_parametra ('1088');

  -- IRN 4079
  napomena_l :=
    '<tr>' ||
      '<td>' || porjez ('PKA', 'PKA0274', jez_sifra_3a_p, 'Napomena/Note') || '</td>' ||
      '<td>' || napomena_l || '</td>' ||
    '</tr>';

  IF TRUNC (SYSDATE) >= pra_zmp_s.dat_prestanka_pd THEN -- IRN 4079
    RETURN ('<table>' || napomena_l || '</table>');
  END IF;

  OPEN pkapd_c;
  FETCH pkapd_c INTO pkapd_c_l;
  IF pkapd_c%NOTFOUND THEN
    CLOSE pkapd_c;
    RETURN ('<table>' || napomena_l || '</table>');
  END IF;
  CLOSE pkapd_c;

  IF pkapd_c_l.val_id = val_id_p AND pkapd_c_l.iznos = rez_iznos_p THEN
    NULL;
  ELSE
    -- fiskalizirani iznos nije jednak iznosu rezervacije
    RETURN ('<table>' || napomena_l || '</table>');
  END IF;

  RETURN (
    '<table>' ||
      '<tr>' ||
        '<td>' || porjez ('REC', 'REC1196', jez_sifra_3a_p, 'OIB/VATIN') || '</td>' ||
        '<td>' || pkapd_c_l.pd_oib || '</td>' ||
      '</tr>' ||
      '<tr>' ||
        '<td>' || porjez ('PKA', 'PKA0157', jez_sifra_3a_p, 'Broj/Number') || '</td>' ||
        '<td>' || pkapd_c_l.pd_broj || '</td>' ||
      '</tr>' ||
      '<tr>' ||
        '<td>' || porjez ('ZMP', 'III0067', jez_sifra_3a_p, 'Datum/Date') || '</td>' ||
        '<td>' || pkapd_c_l.pd_datum || '</td>' ||
      '</tr>' ||
      '<tr>' ||
        '<td>' || porjez ('PKA', 'PKA0330', jez_sifra_3a_p, 'Iznos/Amount') || '</td>' ||
        '<td>' || pkapd_c_l.pd_iznos || ' ' || pra_zmp_zaj.vrijednost_parametra ('0001') || '</td>' ||
      '</tr>' ||
      '<tr>' ||
        '<td>' || porjez ('PKA', 'PKA0335', jez_sifra_3a_p, 'ZKI') || '</td>' ||
        '<td>' || pkapd_c_l.zki || '</td>' ||
      '</tr>' ||
      '<tr>' ||
        '<td>' || porjez ('PKA', 'PKA0336', jez_sifra_3a_p, 'JIR') || '</td>' ||
        '<td>' || pkapd_c_l.jir || '</td>' ||
      '</tr>' ||
      napomena_l ||
    '</table>');

END;
PROCEDURE PUNI_LPKAVEPOR
 (LPKAVEPOR_ROW_P IN lpka_veporuka%ROWTYPE
 )
 IS
-- IRN 3360; Upis u tablicu lpka_veporuka

  PRAGMA AUTONOMOUS_TRANSACTION;
BEGIN
  INSERT INTO lpka_veporuka VALUES lpkavepor_row_p;
  COMMIT;
END;
PROCEDURE SALJI_10_LOY_CESTITKA
 (IME_P IN trec_agostiju.ime%TYPE
 ,PREZIME_P IN trec_agostiju.prezime%TYPE
 ,EMAIL_P IN trec_agostiju.email%TYPE
 ,JEZ_ID_P IN s_jezici.id%TYPE
 ,JEZ_SIFRA_3A_P IN s_jezici.sifra_3a%TYPE
 ,LOYVBOD_KOLICINA_P IN mloy_vbodova.kolicina%TYPE
 ,RECAGOST_ID_P IN trec_agostiju.id%TYPE
 )
 IS
-- IRN 3360; poziva se iz procedure pra_rec_loy.puni_loyula_23

  CURSOR pkavepor_c IS
    SELECT *
      FROM mpka_veporuka
     WHERE oznaka = '10' -- lanovi programa vjernosti - roendan
       AND TRUNC (SYSDATE) BETWEEN dat_valjan AND (NVL (dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) - 1)
       AND ozn_sms = 0
     ORDER BY sifra;
BEGIN

  host_m := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0069');
  port_m := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0070');

  IF host_m = 'nebitno' OR port_m = 'nebitno' THEN
    RETURN;
  END IF;

  OPEN pkavepor_c;
  FETCH pkavepor_c INTO pkavepor_row_m;
  IF pkavepor_c%NOTFOUND THEN
    CLOSE pkavepor_c;
    RETURN;
  END IF;
  CLOSE pkavepor_c;

  ime_m := ime_p;
  prezime_m := prezime_p;
  email_m := email_p;
  loyvbod_kolicina_m := LTRIM (TO_CHAR (loyvbod_kolicina_p, '9990'));
  pripremi_dijelove_poruke (jez_id_p, jez_sifra_3a_p);

  pra_pka2.salji_html_email (
    recipient_p    => email_p,
    recipient_h_p  => INITCAP (ime_p) || ' ' || INITCAP (prezime_p),
    sender_p       => pkavepor_row_m.email_from,
    sender_h_p     => pkavepor_row_m.naz_from,
    bcc_p          => pkavepor_row_m.email_bcc,
    subject_p      => subject_m,
    text_p         => body_text_m,
    host_p         => host_m,
    port_p         => port_m,
    html_p         => body_html_m,
    attach_name1_p => attach_name1_m,
    attach_mime1_p => attach_mime1_m,
    attach_blob1_p => attach_blob1_m,
    attach_name2_p => attach_name2_m,
    attach_mime2_p => attach_mime2_m,
    attach_blob2_p => attach_blob2_m);

  -- upii u log lpka_veporuka
  lpkavepor_row_m := NULL;
  lpkavepor_row_m.pkavepor_id := pkavepor_row_m.id;
  lpkavepor_row_m.recagost_id := recagost_id_p;
  lpkavepor_row_m.email := email_p;
  pra_mpka_veporuka.puni_lpkavepor (lpkavepor_row_m);

EXCEPTION
  WHEN OTHERS THEN
    -- Pogreka kod slanja e-poruke (email; prezime; ime; oznaka; greka)
    pra_pka_iud.puni_pkapro ('PKA', '0010', SUBSTR (email_p || ' ' || prezime_p || ' ' || ime_p || ' ' || pkavepor_row_m.oznaka || ' ' || SQLERRM, 1, 2000), 0);
END;
PROCEDURE OBRADI_90_REZ_ISTEKLE_OPCIJE
 IS
-- IRN 3443
BEGIN

  FOR rez_c IN (
    SELECT
      rez.ime,
      rez.prezime,
      rez.email,
      rez.jez_id,
      jez.sifra_3a AS jez_sifra_3a,
      rez.rbr AS rez_rbr,
      rez.god_poslovna AS rez_god_poslovna,
      so.sifra AS so_sifra,
      so.naziv AS so_naziv,
      TO_CHAR (rez.dat_dolaska, 'DD.MM.RRRR') AS dat_dolaska,
      TO_CHAR (rez.dat_odlaska, 'DD.MM.RRRR') AS dat_odlaska,
      LTRIM (TO_CHAR (rez.izn_predujma, '9G999G999G990D00')) AS izn_predujma,
      val.sifra_3a AS val_sifra_3a,
      TO_CHAR (rez.dat_opcije, 'DD.MM.RRRR') AS dat_opcije,
      rez.id
    FROM
      t_rezervacije rez,
      s_jezici jez,
      m_so so,
      s_valute val
    WHERE
      rez.jez_id = jez.id(+)
      AND rez.so_id = so.id
      AND rez.val_id = val.id(+)
      AND rez.oznaka = 'V'
      AND rez.ozn_vstorna IS NULL
      AND rez.dat_dolaska > TRUNC (SYSDATE)
      AND rez.email IS NOT NULL
      AND rez.dat_opcije IS NOT NULL
      AND rez.ozn_f = 0 -- IRN 4027
      AND (rez.dat_opcije + pkavepor_row_m.br_dana) = TRUNC (SYSDATE)
    ORDER BY
      rez.god_poslovna, rez.rbr)
  LOOP

    BEGIN

      ime_m              := rez_c.ime;
      prezime_m          := rez_c.prezime;
      email_m            := rez_c.email;
      rez_rbr_m          := rez_c.rez_rbr;
      rez_god_poslovna_m := rez_c.rez_god_poslovna;
      so_sifra_m         := rez_c.so_sifra;
      so_naziv_m         := rez_c.so_naziv;
      dat_dolaska_m      := rez_c.dat_dolaska;
      dat_odlaska_m      := rez_c.dat_odlaska;
      izn_predujma_m     := rez_c.izn_predujma;
      val_sifra_3a_m     := rez_c.val_sifra_3a;
      dat_opcije_m       := rez_c.dat_opcije;

      -- poniti rezervaciju
      UPDATE t_rezervacije
         SET oznaka = 'P',
             ozn_vstorna = 2 -- nepotvreno (istekla opcija)
       WHERE id = rez_c.id;
      COMMIT;

      IF pkavepor_row_m.ozn_sms = 0 THEN
        pripremi_dijelove_poruke (rez_c.jez_id, rez_c.jez_sifra_3a);
        pra_pka2.salji_html_email (
          recipient_p    => rez_c.email,
          recipient_h_p  => INITCAP (rez_c.ime) || ' ' || INITCAP (rez_c.prezime),
          sender_p       => pkavepor_row_m.email_from,
          sender_h_p     => pkavepor_row_m.naz_from,
          bcc_p          => pkavepor_row_m.email_bcc,
          subject_p      => subject_m,
          text_p         => body_text_m,
          host_p         => host_m,
          port_p         => port_m,
          html_p         => body_html_m,
          attach_name1_p => attach_name1_m,
          attach_mime1_p => attach_mime1_m,
          attach_blob1_p => attach_blob1_m,
          attach_name2_p => attach_name2_m,
          attach_mime2_p => attach_mime2_m,
          attach_blob2_p => attach_blob2_m);
        lpkavepor_row_m := NULL;
        lpkavepor_row_m.pkavepor_id := pkavepor_row_m.id;
        lpkavepor_row_m.rez_id := rez_c.id;
        lpkavepor_row_m.email  := rez_c.email;
        pra_mpka_veporuka.puni_lpkavepor (lpkavepor_row_m);
      END IF;

    EXCEPTION
      WHEN OTHERS THEN
        -- Pogreka kod slanja e-poruke (email; prezime; ime; oznaka; greka)
        pra_pka_iud.puni_pkapro ('PKA', '0010', SUBSTR (rez_c.email || ' ' || rez_c.prezime || ' ' || rez_c.ime || ' ' || pkavepor_row_m.oznaka || ' ' || SQLERRM, 1, 2000), 0);
    END;

  END LOOP;

END;
PROCEDURE SALJI_REZ_PP
 (OZN_VEPORUKA_P IN mpka_veporuka.oznaka%TYPE
 ,IME_P IN t_rezervacije.ime%TYPE
 ,PREZIME_P IN t_rezervacije.prezime%TYPE
 ,EMAIL_P IN t_rezervacije.email%TYPE
 ,JEZ_ID_P IN t_rezervacije.jez_id%TYPE
 ,JEZ_SIFRA_3A_P IN s_jezici.sifra_3a%TYPE
 ,BR_UPUTNICE_P IN t_rezervacije.br_uputnice%TYPE
 ,PPORD_URL_P IN tpp_orders.url%TYPE
 ,REZ_ID_P IN t_rezervacije.id%TYPE := NULL
 ,OZN_POSLANO_P OUT NUMBER
 )
 IS
-- IRN 3869; poziva se iz modula REC2120 - Rezervacije i procedure pra_pka_payper.izradi_tkn_naloge

  CURSOR pkavepor_c IS
    SELECT *
      FROM mpka_veporuka
     WHERE oznaka = ozn_veporuka_p
       AND TRUNC (SYSDATE) BETWEEN dat_valjan AND (NVL (dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) - 1)
       AND ozn_sms = 0
     ORDER BY sifra;
BEGIN

  host_m := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0069');
  port_m := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0070');

  IF host_m = 'nebitno' OR port_m = 'nebitno' THEN
    RETURN;
  END IF;

  OPEN pkavepor_c;
  FETCH pkavepor_c INTO pkavepor_row_m;
  IF pkavepor_c%NOTFOUND THEN
    CLOSE pkavepor_c;
    RETURN;
  END IF;
  CLOSE pkavepor_c;

  ime_m := ime_p;
  prezime_m := prezime_p;
  email_m := email_p;
  br_uputnice_m := br_uputnice_p;
  ppord_url_m := ppord_url_p;

  pripremi_dijelove_poruke (jez_id_p, jez_sifra_3a_p);

  pra_pka2.salji_html_email (
    recipient_p    => email_p,
    recipient_h_p  => INITCAP (ime_p) || ' ' || INITCAP (prezime_p),
    sender_p       => pkavepor_row_m.email_from,
    sender_h_p     => pkavepor_row_m.naz_from,
    bcc_p          => pkavepor_row_m.email_bcc,
    subject_p      => subject_m,
    text_p         => body_text_m,
    host_p         => host_m,
    port_p         => port_m,
    html_p         => body_html_m,
    attach_name1_p => attach_name1_m,
    attach_mime1_p => attach_mime1_m,
    attach_blob1_p => attach_blob1_m,
    attach_name2_p => attach_name2_m,
    attach_mime2_p => attach_mime2_m,
    attach_blob2_p => attach_blob2_m);

  lpkavepor_row_m := NULL;
  lpkavepor_row_m.pkavepor_id := pkavepor_row_m.id;
  lpkavepor_row_m.rez_id := rez_id_p;
  lpkavepor_row_m.email := email_p;
  pra_mpka_veporuka.puni_lpkavepor (lpkavepor_row_m);

  ozn_poslano_p := -1;

END;

END PRA_MPKA_VEPORUKA;
/
SHOW ERROR

