-- C:\mish_cvs\misH_skripte\pra_gas_log.pkb
--
-- Generated for Oracle 10g on Wed Jan 07  12:50:26 2026 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'PRA_GAS_LOG'
CREATE OR REPLACE PACKAGE BODY PRA_GAS_LOG IS

PROCEDURE KONTROLA_TRNKASE_RBR
 (DATUM_OD_P IN DATE
 ,DATUM_DO_P IN DATE
 )
 IS
 CURSOR c_rn(datum1_l DATE, datum2_l DATE) IS
  SELECT t.godina,
         t.datum,
         t.kase_id,
         t.rbr,
        (SELECT MAX(tt.rbr)
           FROM t_rnkase tt
          WHERE tt.kase_id = t.kase_id
            AND tt.godina = t.godina
            AND tt.datum < t.datum) max_rbr
   FROM t_rnkase t, m_kase k
  WHERE t.datum BETWEEN datum1_l AND datum2_l
    AND k.id = t.kase_id
    AND k.metapl_sifra NOT IN ('GAS','MIC','PTV')
    AND NOT EXISTS (SELECT NULL FROM lgas_trnkase_log log
                      WHERE log.datum = t.datum
                        AND log.kase_id = t.kase_id
                        AND log.status = '1')
    AND SUBSTR(t.rbr, 1, 1) <> '-'  
   ORDER BY t.datum, t.kase_id, t.rbr;

  rn_v      c_rn%ROWTYPE;
  godina_l  t_rnkase.godina%TYPE;
  kase_id_l t_rnkase.kase_id%TYPE;
  rbr_l     t_rnkase.rbr%TYPE;
  datum_l   DATE;
  datum1_l  DATE;
  datum2_l  DATE;
  broj_l    NUMBER;
  broj1_l   NUMBER;
  log_id_l  NUMBER;
  greska_l  VARCHAR2(2000);
    
  PROCEDURE brisi IS
    BEGIN  
      DELETE lgas_trnkase_log log
       WHERE log.datum BETWEEN datum1_l AND datum2_l
         AND log.status = '0';
         
       COMMIT;
  END;
BEGIN
    datum1_l := datum_od_p;
    datum2_l := datum_do_p;
    -- brisanje loga za datum
    brisi;
    -- ita raune za datum od i datum do
    OPEN c_rn(datum1_l, datum2_l);
    FETCH c_rn
    INTO rn_v;
    WHILE c_rn%FOUND LOOP

      godina_l  := rn_v.godina;
      datum_l   := rn_v.datum;
      kase_id_l := rn_v.kase_id;
      rbr_l     := rn_v.rbr;
      broj_l    := 0;
      log_id_l  := NULL;

      WHILE c_rn%FOUND AND godina_l = rn_v.godina AND
                           kase_id_l = rn_v.kase_id AND datum_l = rn_v.datum LOOP
        broj_l := broj_l + 1;
        IF broj_l = 1 THEN
          -- kontrola 'minusa' u rednom broju za datum
          SELECT COUNT(1)
            INTO broj1_l
            FROM t_rnkase t
           WHERE SUBSTR(t.rbr, 1, 1) = '-'
             AND t.datum = datum_l
             AND t.kase_id = kase_id_l;
          IF broj1_l > 0 THEN
            -- Ima rauna sa minus u rbr.
            greska_l := pra_zmp_zaj.poruka('GAS',-20520) || CHR(10);
            INSERT INTO lgas_trnkase_log
              (datum, kase_id, opis_greske,status)
            VALUES
              (datum_l, kase_id_l, greska_l,'0')
            RETURNING id INTO log_id_l;
          END IF;
          -- provjerava prvi redni broj za datum i kasu sa rbr prethodnog dana/perioda
          -- (max rbr za datum i kasu manji od traenog datuma)
          IF rbr_l <> lpad(nvl(rn_v.max_rbr, 0) + 1, 6, '0') THEN
            -- Prethodni broj je: #0, a redni broj je: #1.
            greska_l := pra_zmp_zaj.poruka('GAS',-20521, nvl(rn_v.max_rbr, 0),  rn_v.rbr) || CHR(10);
            IF log_id_l IS NULL THEN
              INSERT INTO lgas_trnkase_log
                (datum, kase_id, opis_greske,status)
              VALUES
                (datum_l, kase_id_l, greska_l,'0')
              RETURNING id INTO log_id_l;
            ELSE
              UPDATE lgas_trnkase_log log
                 SET log.opis_greske = SUBSTR(log.opis_greske || greska_l,1,2000)
               WHERE log.id = log_id_l;
            END IF;
          END IF;
        ELSE
          -- kotrola redoslijeda rbr za datum i kasu
          WHILE rbr_l < rn_v.rbr 
          LOOP 
            --Nedostaje broj rauna: #0.
            greska_l := pra_zmp_zaj.poruka('GAS',-20522, rbr_l) || CHR(10);
            IF log_id_l IS NULL THEN
              INSERT INTO lgas_trnkase_log
                (datum, kase_id, opis_greske,status)
              VALUES
                (datum_l, kase_id_l, greska_l,'0')
              RETURNING id INTO log_id_l;
            ELSE
              UPDATE lgas_trnkase_log log
                 SET log.opis_greske = SUBSTR(log.opis_greske || greska_l,1,2000)
               WHERE log.id = log_id_l;
            END IF;
            rbr_l := lpad(rbr_l + 1, 6, '0');
          END LOOP;
        END IF;
        rbr_l := lpad(rn_v.rbr + 1, 6, '0');
        greska_l := NULL;

        FETCH c_rn
        INTO rn_v;
      END LOOP;
   END LOOP;
   COMMIT;
 END kontrola_trnkase_rbr;
PROCEDURE KONTROLA_TRNKASE_RBR_FISK
 (DATUM_OD_P IN DATE
 ,DATUM_DO_P IN DATE
 )
 IS
CURSOR c_rn(datum1_l DATE, datum2_l DATE) IS
  SELECT t.godina,
         t.datum,
         t.kase_id,
         t.rbr_fisk,
        (SELECT NVL(MAX(tt.rbr_fisk),MAX(tt.rbr))
           FROM t_rnkase tt
          WHERE tt.kase_id = t.kase_id
            AND tt.godina = t.godina
            AND tt.datum < t.datum) max_rbr_fisk
    FROM t_rnkase t, m_kase k
   WHERE t.datum BETWEEN datum1_l AND datum2_l
     AND k.id = t.kase_id
     AND k.metapl_sifra NOT IN ('GAS','MIC','PTV')
     AND NOT EXISTS (SELECT NULL FROM lgas_trnkase_log log
                      WHERE log.datum = t.datum
                        AND log.kase_id = t.kase_id
                        AND log.status = '1')
     AND SUBSTR(t.rbr_fisk, 1, 1) <> '-'
     AND t.rbr_fisk IS NOT NULL
   ORDER BY t.datum, t.kase_id, t.rbr_fisk;

  rn_v       c_rn%ROWTYPE;
  godina_l   t_rnkase.godina%TYPE;
  kase_id_l  t_rnkase.kase_id%TYPE;
  rbr_fisk_l t_rnkase.rbr_fisk%TYPE;
  datum_l    DATE;
  datum1_l   DATE;
  datum2_l   DATE;
  broj_l     NUMBER;
  broj1_l    NUMBER;
  log_id_l   NUMBER;
  greska_l   VARCHAR2(2000);

  PROCEDURE brisi IS
    BEGIN
      DELETE lgas_trnkase_log log
       WHERE log.datum BETWEEN datum1_l AND datum2_l
         AND log.status = '0'
         AND log.tip = 'F';

       COMMIT;
  END;
BEGIN
    datum1_l := datum_od_p;
    datum2_l := datum_do_p;
    -- brisanje loga za datum
    brisi;
    -- ita raune za datum od i datum do
    OPEN c_rn(datum1_l, datum2_l);
    FETCH c_rn
    INTO rn_v;
    WHILE c_rn%FOUND LOOP

      godina_l   := rn_v.godina;
      datum_l    := rn_v.datum;
      kase_id_l  := rn_v.kase_id;
      rbr_fisk_l := rn_v.rbr_fisk;
      broj_l     := 0;
      log_id_l   := NULL;

      WHILE c_rn%FOUND AND godina_l = rn_v.godina AND
                           kase_id_l = rn_v.kase_id AND datum_l = rn_v.datum LOOP
        broj_l := broj_l + 1;
        IF broj_l = 1 THEN
          -- kontrola 'minusa' u rednom broju za datum
          SELECT COUNT(1)
            INTO broj1_l
            FROM t_rnkase t
           WHERE SUBSTR(t.rbr_fisk, 1, 1) = '-'
             AND t.datum = datum_l
             AND t.kase_id = kase_id_l;
          IF broj1_l > 0 THEN
            -- Ima rauna sa minus u rbr.
            greska_l := pra_zmp_zaj.poruka('GAS',-20520) || '(fiskalni)'|| CHR(10);
            INSERT INTO lgas_trnkase_log
              (datum, kase_id, opis_greske,status,tip)
            VALUES
              (datum_l, kase_id_l, greska_l,'0','F')
            RETURNING id INTO log_id_l;
          END IF;
          -- provjerava prvi redni broj za datum i kasu sa rbr prethodnog dana/perioda
          -- (max rbr za datum i kasu manji od traenog datuma)
          IF rbr_fisk_l <> lpad(nvl(rn_v.max_rbr_fisk, 0) + 1, 6, '0') THEN
            -- Prethodni broj je: #0, a redni broj je: #1.
            greska_l := pra_zmp_zaj.poruka('GAS',-20521, nvl(rn_v.max_rbr_fisk, 0),  rn_v.rbr_fisk) || '(fiskalni)'|| CHR(10);
            IF log_id_l IS NULL THEN
              INSERT INTO lgas_trnkase_log
                (datum, kase_id, opis_greske,status,tip)
              VALUES
                (datum_l, kase_id_l, greska_l,'0','F')
              RETURNING id INTO log_id_l;
            ELSE
              UPDATE lgas_trnkase_log log
                 SET log.opis_greske = SUBSTR(log.opis_greske || greska_l,1,2000)
               WHERE log.id = log_id_l;
            END IF;
          END IF;
        ELSE
          -- kotrola redoslijeda rbr za datum i kasu
          WHILE rbr_fisk_l < rn_v.rbr_fisk
          LOOP
            --Nedostaje broj rauna: #0.
            greska_l := pra_zmp_zaj.poruka('GAS',-20522, rbr_fisk_l) || '(fiskalni)'|| CHR(10);
            IF log_id_l IS NULL THEN
              INSERT INTO lgas_trnkase_log
                (datum, kase_id, opis_greske,status,tip)
              VALUES
                (datum_l, kase_id_l, greska_l,'0','F')
              RETURNING id INTO log_id_l;
            ELSE
              UPDATE lgas_trnkase_log log
                 SET log.opis_greske = SUBSTR(log.opis_greske || greska_l,1,2000)
               WHERE log.id = log_id_l;
            END IF;
            rbr_fisk_l := lpad(rbr_fisk_l + 1, 6, '0');
          END LOOP;
        END IF;
        rbr_fisk_l := lpad(rn_v.rbr_fisk + 1, 6, '0');
        greska_l := NULL;

        FETCH c_rn
        INTO rn_v;
      END LOOP;
   END LOOP;
   COMMIT;
 END kontrola_trnkase_rbr_fisk;
FUNCTION POSTOJI_TRNKASE_LOG
 (DATUM_P IN DATE
 )
 RETURN BOOLEAN
 IS
brojac_l NUMBER;
BEGIN
   SELECT COUNT(1) 
     INTO brojac_l 
     FROM lgas_trnkase_log log 
    WHERE log.datum = datum_p
     AND log.status = '0';
   IF brojac_L = 0 THEN
      RETURN FALSE;
   ELSE
      RETURN TRUE;
   END IF;
END postoji_trnkase_log;

END PRA_GAS_LOG;
/
SHOW ERROR

