PROMPT Creating Package Body 'PRA_ERACUN'
CREATE OR REPLACE PACKAGE BODY PRA_ERACUN IS

DOMVAL_SIFRA_M CONSTANT SZMP_PARAMETRI.VRIJEDNOST%TYPE := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0001');
DOMZEM_SIFRA_M CONSTANT SZMP_PARAMETRI.VRIJEDNOST%TYPE := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0002');
JEDMJ_RASPOREDI_C CONSTANT NUMBER(3, 2) := 1 / 100;

DATA_M CLOB;
LOG_FILENAME_M VARCHAR2(100);
ODGOVOR_M CLOB;
URL_M S_PARAMETRI_PRIJEPISA.STAZA%TYPE;
CLOB_M CLOB;

FUNCTION REPLACEINCLOB
 (OPCLOB_P IN CLOB
 ,CPREPLACESTR_P IN VARCHAR2 := UTL_TCP.CRLF
 ,CPREPLACEWITH_P IN VARCHAR2 := NULL
 )
 RETURN CLOB;
PROCEDURE PRIPREMI_TAB_RUZ
 (RAC_ID_P IN t_racuni.id%TYPE
 ,RAC_IZN_TECAJA_P IN t_racuni.izn_tecaja%TYPE
 );
FUNCTION IZNOS_RASPOREDI_RUZ
 (VPISPZ_ID_P IN t_troskovi.vpispz_id%TYPE
 )
 RETURN NUMBER;
PROCEDURE MERAC_ZAJ_POST
 (RACBLOB_ID_P IN t_racuni_blob.id%TYPE
 );
PROCEDURE MERAC_OBRADI_ODGOVOR
 (METHOD_P IN VARCHAR2
 ,RACBLOB_ID_P IN t_racuni_blob.id%TYPE
 ,VANJSUS_POSTOJI_P OUT NUMBER
 );
PROCEDURE FINA_STAVKE_XML
 (RAC_ID_P IN t_racuni.id%TYPE
 ,STAVKEXML_P OUT XMLTYPE
 ,SUM_TAXABLE_RACVAL_P OUT t_racuni.iznos%TYPE
 );
PROCEDURE FINA_TAXES_XML
 (RAC_ID_P IN t_racuni.id%TYPE
 ,TAXSUBTOTALS_P OUT XMLTYPE
 ,SUM_TAX_DOMVAL_P OUT t_racuni.iznos%TYPE
 ,SUM_NETO_DOMVAL_P OUT t_racuni.iznos%TYPE
 ,CHARGE_PPOT_P OUT t_racuni.iznos%TYPE
 ,CHARGE_PNAKNADA_P OUT t_racuni.iznos%TYPE
 );
PROCEDURE FINA_CUSTOMER_XML
 (RAC_ID_P IN t_racuni.id%TYPE
 ,ACCOUNTINGCUSTOMERPARTY_P OUT XMLTYPE
 ,BUYERID_P OUT VARCHAR2
 );
PROCEDURE FINA_PKA_STAVKE_XML
 (PKARAC_ID_P IN tpka_racuni.id%TYPE
 ,STAVKEXML_P OUT XMLTYPE
 ,SUM_TAXABLE_RACVAL_P OUT tpka_racuni.iznos%TYPE
 );
PROCEDURE FINA_PKA_TAXES_XML
 (PKARAC_ID_P IN tpka_racuni.id%TYPE
 ,TAXSUBTOTALS_P OUT XMLTYPE
 ,SUM_TAX_DOMVAL_P OUT tpka_racuni.iznos%TYPE
 ,SUM_NETO_DOMVAL_P OUT tpka_racuni.iznos%TYPE
 ,CHARGE_PPOT_P OUT T_RACUNI.IZNOS%TYPE
 ,CHARGE_PNAKNADA_P OUT T_RACUNI.IZNOS%TYPE
 );
PROCEDURE FINA_PKA_CUSTOMER_XML
 (PKARAC_ID_P IN tpka_racuni.id%TYPE
 ,ACCOUNTINGCUSTOMERPARTY_P OUT XMLTYPE
 ,BUYERID_P OUT VARCHAR2
 );
FUNCTION FINA_PKA_INVOICE_XML
 (PKARAC_ID_P IN tpka_racuni.id%TYPE
 ,ZAH_PONUDA_P IN VARCHAR2 := NULL
 ,NARUDZBENICA_P IN VARCHAR2 := NULL
 ,UGOVOR_P IN VARCHAR2 := NULL
 ,PROJEKT_P IN VARCHAR2 := NULL
 ,NAPOMENA_P IN VARCHAR2 := NULL
 ,TIP_P IN VARCHAR2
 )
 RETURN XMLTYPE;
PROCEDURE FINA_ZAJ_POST;


FUNCTION REPLACEINCLOB
 (OPCLOB_P IN CLOB
 ,CPREPLACESTR_P IN VARCHAR2 := UTL_TCP.CRLF
 ,CPREPLACEWITH_P IN VARCHAR2 := NULL
 )
 RETURN CLOB
 IS
-- poziva se iz blob2base64 i post2merac
  cBuffer_l VARCHAR2 (32767);
  nBuffer_l BINARY_INTEGER := 32767;
  nStart_l  PLS_INTEGER := 1;
  nLen_l    PLS_INTEGER;
  oCRtn_l   CLOB := EMPTY_CLOB;
BEGIN
  DBMS_LOB.CreateTemporary (oCRtn_l, TRUE);
  nLen_l := DBMS_LOB.GetLength (opClob_p);

  WHILE nStart_l < nLen_l LOOP
    DBMS_LOB.Read (opClob_p, nBuffer_l, nStart_l, cBuffer_l);
    IF cBuffer_l IS NOT NULL THEN
      cBuffer_l := REPLACE (cBuffer_l, cpReplaceStr_p, cpReplaceWith_p);
      DBMS_LOB.WriteAppend (oCRtn_l, LENGTH (cBuffer_l), cBuffer_l);
    END IF;
    nStart_l := nStart_l + nBuffer_l;
  END LOOP;
  RETURN oCRtn_l;
END;
FUNCTION BLOB2BASE64
 (BLOB_P IN BLOB
 )
 RETURN clob
 IS
-- poziva se iz fina_invoice_xml, fina_pka_invoice_xml i fina_sendinvoice
  clob_l CLOB;
  step_l PLS_INTEGER := 12000; -- make sure you set a multiple of 3 not higher than 24573
BEGIN
  FOR i IN 0 .. TRUNC ((DBMS_LOB.getlength (blob_p) - 1) / step_l) LOOP
    clob_l := clob_l || UTL_RAW.cast_to_varchar2 (UTL_ENCODE.base64_encode (DBMS_LOB.substr (blob_p, step_l, i * step_l + 1)));
  END LOOP;
  clob_l := replaceInClob (clob_l);
  RETURN clob_l;
END;
FUNCTION POSTOJI_PDF
 (FILENAME_P IN VARCHAR2
 )
 RETURN NUMBER
 IS
-- poziva se iz modula pka2070.fmb - Rauni za predujam i rec2250.fmb - Rauni
BEGIN
  IF filename_p IS NULL THEN
    RETURN 0;
  END IF;

  IF DBMS_LOB.fileexists (BFILENAME ('ERACUNI_' || SYS_CONTEXT ('USERENV', 'CURRENT_SCHEMA'), filename_p || '.pdf')) = 1 THEN
    RETURN -1;
  ELSE
    RETURN 0;
  END IF;
END;
PROCEDURE POPRAVI_PDF_FILE
 (DB_DIRECTORY_P IN VARCHAR2
 ,FILENAME_P IN VARCHAR2
 )
 IS
-- poziva se iz spremi_file_u_blob
  bStari_l       BLOB;
  bNovi_l        BLOB;
  prviDio_l      VARCHAR2 (100);
  duljinaPrvog_l NUMBER := 90;

  bBuffer_l      RAW (32767);

  amount_l       BINARY_INTEGER := 32767;
  pos_l          INTEGER;
  blob_len_l     INTEGER;

  FUNCTION loadBlobFromFile RETURN BLOB IS
    dest_loc_l BLOB := empty_blob ();
    src_loc_l  BFILE := BFILENAME (db_directory_p, filename_p);
  BEGIN
    BEGIN
      -- Open source binary file from OS
      DBMS_LOB.open (src_loc_l, DBMS_LOB.lob_readonly);

      -- Create temporary LOB object
      DBMS_LOB.createtemporary (
        lob_loc => dest_loc_l,
        cache   => true,
        dur     => DBMS_LOB.session);

      -- Open temporary lob
      DBMS_LOB.open (dest_loc_l, DBMS_LOB.lob_readwrite);

      -- Load binary file into temporary LOB
      DBMS_LOB.loadfromfile (
        dest_lob => dest_loc_l,
        src_lob  => src_loc_l,
        amount   => DBMS_LOB.getLength (src_loc_l));

    EXCEPTION
      WHEN DBMS_LOB.operation_failed THEN
        DBMS_LOB.close (src_loc_l);
        RETURN empty_blob ();
      WHEN DBMS_LOB.invalid_argval THEN
        DBMS_LOB.close (dest_loc_l);
        DBMS_LOB.close (src_loc_l);
        RETURN empty_blob ();
    END;

    -- Close lob objects
    DBMS_LOB.close (dest_loc_l);
    DBMS_LOB.close (src_loc_l);

    -- Return temporary LOB object
    RETURN dest_loc_l;
  END loadBlobFromFile;
BEGIN
  -- "The old Oracle tools (Developer 2000) created PDFs with the malformed "/CreatorDate ( " line in the PDF."
  -- izvor: https://stackoverflow.com/questions/28358916/com-itextpdf-text-exceptions-invalidpdfexception-rebuild-failed-error-reading

  -- pretpostavlja se da je u bazi definiran DIRECTORY db_directory_p
  -- koji pokazuje na direktorij iz kojeg se ita file filename_p

  -- proitaj file u BLOB varijablu
  bStari_l := loadBlobFromFile ();
  blob_len_l := DBMS_LOB.getlength (bStari_l);

  -- prepii prvi dio BLOB varijable u VARCHAR2
  prviDio_l := UTL_RAW.cast_to_varchar2 (DBMS_LOB.substr (bStari_l, duljinaPrvog_l, 1));

  -- ispravi prvi dio ako treba
  IF INSTR (SUBSTR (prviDio_l,
                    INSTR (prviDio_l, '/CreatorDate'), -- poetak teksta "/CreatorDate"
                    INSTR (prviDio_l, '/Author') - INSTR (prviDio_l, '/CreatorDate') -- broj mjesta izmeu poetaka tekstova "/CreatorDate" i "/Author"
                   ),
            ')') = 0
  THEN
    prviDio_l := REPLACE (prviDio_l, '/CreatorDate (', '/CreatorDate ()');
  ELSE
    RETURN;
  END IF;

  -- ispravljeni dio VARCHAR2 zapii u novu BLOB varijablu
  DBMS_LOB.createtemporary (bNovi_l, TRUE);
  bNovi_l := UTL_RAW.cast_to_raw (prviDio_l);

  -- dodaj neizmijenjeni preostali dio stare BLOB varijable
  pos_l := duljinaPrvog_l + 1;
  WHILE pos_l < blob_len_l LOOP
    DBMS_LOB.read (bStari_l, amount_l, pos_l, bBuffer_l);
    DBMS_LOB.writeappend (bNovi_l, DBMS_LOB.getlength (bBuffer_l), bBuffer_l);
    pos_l := pos_l + amount_l;
  END LOOP;

  isporuci_blob_u_file (bNovi_l, filename_p);
END;
PROCEDURE SPREMI_FILE_U_BLOB
 (RAC_ID_P IN t_racuni_blob.rac_id%TYPE
 ,FILENAME_P IN VARCHAR2 := '40'
 ,EXT_P IN VARCHAR2
 ,OPIS_P IN VARCHAR2
 ,PKARAC_ID_P IN t_racuni_blob.pkarac_id%TYPE
 )
 IS
-- poziva se iz modula pka2070.fmb - Rauni za predujam i rec2250.fmb - Rauni
  dir_baze_l VARCHAR2 (200);
  bfile_l    BFILE;
  blob_l     BLOB;
  i          BINARY_INTEGER;
BEGIN
  IF rac_id_p IS NULL AND pkarac_id_p IS NULL THEN
    RETURN;
  END IF;

  -- pretpostavlja se da je u bazi definiran DIRECTORY 'eracuni_shema'
  -- koji pokazuje na direktorij iz kojeg se ita file filename_p

  dir_baze_l := 'ERACUNI_' || SYS_CONTEXT ('USERENV', 'CURRENT_SCHEMA');

  bfile_l := BFILENAME (dir_baze_l, filename_p);

  -- IRN 3606
  FOR j IN 1..3 LOOP
    EXIT WHEN DBMS_LOB.fileexists (bfile_l) = 1;
    DBMS_LOCK.sleep (1);
  END LOOP;

  IF DBMS_LOB.fileexists (bfile_l) = 0 THEN
    pra_pka_iud.puni_pkapro ('PKA', '0014', filename_p, 0);
    -- Datoteka #0 jo nije dostupna. Ponovite slanje e-rauna.
    pra_pka_zaj.vrati_poruku (-20248, filename_p);
  END IF;
  -- KRAJ IRN 3606

  popravi_pdf_file (dir_baze_l, filename_p);

  IF rac_id_p IS NOT NULL AND pkarac_id_p IS NULL THEN
    INSERT INTO t_racuni_blob (rac_id, datoteka, oznaka, opis)
      VALUES (rac_id_p, empty_blob (), ext_p, opis_p)
      RETURN datoteka INTO blob_l;
  ELSIF rac_id_p IS NULL AND pkarac_id_p IS NOT NULL THEN
    INSERT INTO t_racuni_blob (pkarac_id, datoteka, oznaka, opis)
      VALUES (pkarac_id_p, empty_blob (), ext_p, opis_p)
      RETURN datoteka INTO blob_l;
  END IF;

  i := 0;
  DBMS_LOB.fileopen (bfile_l, i);
  DBMS_LOB.loadfromfile (blob_l, bfile_l, DBMS_LOB.getlength (bfile_l));
  DBMS_LOB.fileclose (bfile_l);

  COMMIT;

  IF DBMS_LOB.fileexists (bfile_l) = 1 THEN
    UTL_FILE.fremove (dir_baze_l, filename_p);
  END IF;
END;
PROCEDURE ISPORUCI_BLOB_U_FILE
 (BLOB_P IN t_racuni_blob.datoteka%TYPE
 ,FILENAME_P IN VARCHAR2 := '40'
 ,DB_DIRECTORY_P IN VARCHAR2 := 'ERACUNI_' || SYS_CONTEXT ('USERENV', 'CURRENT_SCHEMA')
 )
 IS
-- poziva se iz popravi_pdf_file
  file_l     UTL_FILE.file_type;
  buffer_l   RAW (32767);
  amount_l   BINARY_INTEGER := 32767;
  pos_l      INTEGER := 1;
  blob_len_l INTEGER;
BEGIN
  blob_len_l := DBMS_LOB.getlength (blob_p);

  -- Open the destination file.
  file_l := UTL_FILE.fopen (db_directory_p, filename_p, 'WB', 32767);

  -- Read chunks of the BLOB and write them to the file until complete.
  WHILE pos_l < blob_len_l LOOP
    DBMS_LOB.read (blob_p, amount_l, pos_l, buffer_l);
    UTL_FILE.put_raw (file_l, buffer_l, TRUE);
    pos_l := pos_l + amount_l;
  END LOOP;

  -- Close the file.
  UTL_FILE.fclose (file_l);
EXCEPTION
  WHEN OTHERS THEN
    -- Close the file if something goes wrong.
    IF UTL_FILE.is_open (file_l) THEN
      UTL_FILE.fclose (file_l);
    END IF;
    RAISE;
END;
PROCEDURE PRIPREMI_TAB_RUZ
 (RAC_ID_P IN t_racuni.id%TYPE
 ,RAC_IZN_TECAJA_P IN t_racuni.izn_tecaja%TYPE
 )
 IS
-- puni pomonu tablicu s razlikama u zaokruivanju; poziva se iz fina_stavke_xml
-- IRN 3551; u valuti rauna
  div_l t_racuni.iznos%TYPE;
  mod_l t_racuni.iznos%TYPE;
BEGIN
  DELETE FROM prec_global2;

  FOR raz_c IN (
    SELECT
      racpdv.vpispz_id,
      (racpdv.iznos / rac_izn_tecaja_p) - SUM (stavke.osn_racval) razlika,
      SUM (stavke.br_stavaka) br_stavaka
    FROM
      i_rac_pdv racpdv,
      (
      -- usluge
      SELECT
        tro.vpispz_id,
        SUM (ROUND (
                 (
                   ROUND (tro.cijena_usluge * tro.stopa_placanja / 100 * tro.izn_tecaja / rac_izn_tecaja_p, 2)
                   * tro.kol_usluge
                   * DECODE (tro.obr_po_danu, -1, tro.dat_zav - tro.dat_poc - tro.obr_zdana, 1)
                   - tro.izn_odbitka
                 )
                 * 100 / (100 + tro.stopa_pdv),
               2)
          ) osn_racval,
        COUNT (tro.id) br_stavaka
      FROM
        t_troskovi tro
      WHERE
        tro.rac_id = rac_id_p
      GROUP BY
        tro.vpispz_id
      UNION ALL
      -- usluge ije je cijena ukljuena u cijenu druge usluge
      SELECT
        tro.vpispz_id1,
        SUM (ROUND (
                 (
                   ROUND (tro.cijena_usluge * tro.stopa_placanja / 100 * tro.izn_tecaja / rac_izn_tecaja_p, 2)
                   * tro.kol_usluge * (-1)
                   * DECODE (tro.obr_po_danu, -1, tro.dat_zav - tro.dat_poc - tro.obr_zdana, 1)
                   - tro.izn_odbitka
                 )
                 * 100 / (100 + tro.stopa_pdv1),
               2)
          ) osn_racval,
        COUNT (tro.id) br_stavaka
      FROM
        t_troskovi tro
      WHERE
        tro.rac_id = rac_id_p
      GROUP BY
        tro.vpispz_id1
      UNION ALL
      -- interni POS rauni
      SELECT
        rnkpdv.vpispz_id,
        SUM (ROUND (rnkpdv.izn_osnovice / rac_izn_tecaja_p, 2)),
        COUNT (rnkpdv.id) br_stavaka
      FROM
        ipka_rnk_pdv rnkpdv,
        tpka_rnkasa pkarnk
      WHERE
        pkarnk.rac_id = rac_id_p
        AND rnkpdv.pkarnk_id = pkarnk.id
      GROUP BY
        rnkpdv.vpispz_id,
        pkarnk.id
      ) stavke
    WHERE
      racpdv.rac_id = rac_id_p
      AND stavke.vpispz_id = racpdv.vpispz_id
    GROUP BY
      racpdv.vpispz_id, racpdv.iznos)
  LOOP
    /*
    ako je jedinina mjera za rasporeivanje 0.01 (1 lipa)
    i ako je razlika u zaokruivanju -0.343521
    i broj stavaka za rasporeivanje je 21,
    onda svakoj stavci dodajemo 1 jedinicu = FLOOR ((ABS (-0.34) / 0.01 / 21)) * SIGN (-0.34)
    i jo 13 stavaka dobiva po jednu jedinicu = FLOOR (MOD (ABS (-0.34) / 0.01, 21)) * SIGN (-0.34)
    */

    -- broj jedinica koje dodajemo svakoj stavci
    div_l := FLOOR (ABS (ROUND (raz_c.razlika, 2)) / jedmj_rasporedi_c / raz_c.br_stavaka);

    -- broj stavaka kojima dodajemo jednu jedinicu
    mod_l := FLOOR (MOD (ABS (ROUND (raz_c.razlika, 2)) / jedmj_rasporedi_c, raz_c.br_stavaka));

    INSERT INTO prec_global2
      (id1, iznos1, iznos2, iznos3, iznos4, iznos5)
      VALUES
      (raz_c.vpispz_id, div_l, mod_l, SIGN (raz_c.razlika), raz_c.razlika, raz_c.br_stavaka);
  END LOOP;
END;
FUNCTION IZNOS_RASPOREDI_RUZ
 (VPISPZ_ID_P IN t_troskovi.vpispz_id%TYPE
 )
 RETURN NUMBER
 IS
-- poziva se iz fina_stavke_xml
  CURSOR raz_c IS
    SELECT (iznos1 +           -- div
            DECODE (iznos2,    -- mod
                    0, 0,
                    1)) *
           iznos3 *            -- sign
           jedmj_rasporedi_c
      FROM prec_global2
     WHERE id1 = vpispz_id_p;

  div_l    t_racuni.iznos%TYPE;
  mod_l    t_racuni.iznos%TYPE;
  retval_l t_racuni.iznos%TYPE;
BEGIN
  OPEN raz_c;
  FETCH raz_c INTO retval_l;
  IF raz_c%NOTFOUND THEN
    RETURN 0;
  END IF;
  CLOSE raz_c;

  UPDATE prec_global2
     SET iznos2 = iznos2 - 1
   WHERE id1 = vpispz_id_p
     AND iznos2 > 0;

  RETURN retval_l;
END;
PROCEDURE PONISTI_ERACUN
 (RAC_ID_P IN t_racuni.id%TYPE
 ,PKARAC_ID_P IN tpka_racuni.id%TYPE
 )
 IS
-- poziva se iz modula pka2070.fmb - Rauni za predujam i rec2250.fmb - Rauni
BEGIN
  IF rac_id_p IS NOT NULL AND pkarac_id_p IS NULL THEN
    UPDATE t_racuni_blob
       SET status = -1
     WHERE rac_id = rac_id_p;

    COMMIT;
  ELSIF rac_id_p IS NULL AND pkarac_id_p IS NOT NULL THEN
    UPDATE t_racuni_blob
       SET status = -1
     WHERE pkarac_id = pkarac_id_p;

    COMMIT;
  END IF;
END;
PROCEDURE POST2MERAC
 (METHOD_P IN VARCHAR2
 ,FILENAME_P IN VARCHAR2
 ,RACBLOB_ID_P IN NUMBER := NULL
 ,DOCUMENTID_P IN NUMBER := NULL
 ,JEDINSTV_OZN_RAC_P IN VARCHAR2 := NULL
 ,STATUSID_P IN NUMBER := NULL
 ,STARTDATE_P IN DATE := NULL
 ,ENDDATE_P IN DATE := NULL
 ,VANJSUS_POSTOJI_P OUT NUMBER
 )
 IS
-- poziva se iz posalji_eracun
  CURSOR vla_c IS
    SELECT oib, erac_username, erac_password
      FROM s_vlasnik;
  oib_l      s_vlasnik.oib%TYPE;          -- OIB izdavatelja rauna
  username_l s_vlasnik.erac_username%TYPE; -- korisnicko ime Moj-eRaun
  pass_l     s_vlasnik.erac_password%TYPE; -- pass izdavatelja rauna u sustavu Moj-eRaun

  request_l XMLTYPE;

  FUNCTION ClobReplace (ainput_p      CLOB,
                        apattern_p    VARCHAR2,
                        asubstitute_p CLOB)
  RETURN CLOB IS
    fclob_l   CLOB := ainput_p;
    foffset_l INTEGER;
    fchunk_l  CLOB;
  BEGIN
    IF LENGTH (asubstitute_p) > 32000 THEN
      foffset_l := 1;
      fclob_l := REPLACE (fclob_l, apattern_p, '###clobreplace###');
      WHILE foffset_l <= LENGTH (asubstitute_p) LOOP
        fchunk_l := SUBSTR (asubstitute_p, foffset_l, 32000) || '###clobreplace###';
        fclob_l := REGEXP_REPLACE (fclob_l, '###clobreplace###', fchunk_l);
        foffset_l := foffset_l + 32000;
      END LOOP;
      fclob_l := REGEXP_REPLACE (fclob_l, '###clobreplace###', '');
    ELSE
      fclob_l := REPLACE (fclob_l, apattern_p, asubstitute_p);
    END IF;
    RETURN fclob_l;
  END;
BEGIN
  log_filename_m := filename_p;

  OPEN vla_c;
  FETCH vla_c INTO oib_l, username_l, pass_l;
  CLOSE vla_c;

  SELECT MIN (staza)
    INTO url_m
    FROM s_parametri_prijepisa
   WHERE sifra = 'ERACUN_URL';

  IF method_p = 'send' THEN
    url_m := url_m || '/apis/v2/send';

    SELECT xmlelement ("Request",
             xmlattributes (
               username_l "Username",
               pass_l "Password",
               oib_l "CompanyId",
               'MISH-001' "SoftwareId",
               '@@eracunxml@@' "File"))
      INTO request_l
      FROM DUAL;

  ELSIF method_p = 'query' THEN
    url_m := url_m || '/apis/v2/queryOutbox';

    SELECT xmlelement ("Request",
             xmlattributes (
               username_l "Username",
               pass_l "Password",
               oib_l "CompanyId",
               'MISH-001' "SoftwareId",
               DECODE (documentId_p, NULL, NULL, documentId_p) "ElectronicId",
               DECODE (jedinstv_ozn_rac_p, NULL, NULL, jedinstv_ozn_rac_p) "InvoiceNumber",
               DECODE (NVL (statusId_p, 0), 0, NULL, statusId_p) "StatusId",
               DECODE (startdate_p, NULL, NULL, TO_CHAR(startdate_p, 'yyyy-mm-dd') || 'T00:00:00') "From",
               DECODE (enddate_p, NULL, NULL, TO_CHAR(enddate_p, 'yyyy-mm-dd') || 'T00:00:00') "To"))
    INTO request_l
    FROM DUAL;

  ELSIF method_p IN ('resend', 'cancel') THEN
    url_m := url_m || '/apis/v2/documentAction';

    SELECT xmlelement ("Request",
             xmlattributes (
               username_l "Username",
               pass_l "Password",
               oib_l "CompanyId",
               'MISH-001' "SoftwareId",
               documentId_p "ElectronicId",
               method_p "Apply"))
      INTO request_l
      FROM DUAL;
  END IF;

  SELECT request_l.getClobval()
    INTO data_m
    FROM dual;

  IF data_m IS NULL THEN
    RETURN;
  END IF;

  data_m := REPLACE (data_m, '<Request ', '{"'); -- json poetak
  data_m := REPLACE (data_m, '="', '":"');  -- json separator i zavrni navodnik za naziv atributa
  data_m := REPLACE (data_m, '" ', '", "'); -- zarez i json poetni navodnik za naziv atributa
  data_m := REPLACE (data_m, '"null"', 'null'); -- "null"
  data_m := REPLACE (data_m, '/>', '} ');  -- json kraj Oracle 9i
  data_m := REPLACE (data_m, '></Request>', '} '); -- json kraj 11g

  data_m := ClobReplace (data_m, '@@eracunxml@@',
              ClobReplace (
                ClobReplace (clob_m, '\', ''),
                                 '"', '\"'));
  data_m := replaceInClob (data_m);

  merac_zaj_post (racblob_id_p);
  merac_obradi_odgovor (method_p, racblob_id_p, vanjsus_postoji_p);
END;
PROCEDURE MERAC_ZAJ_POST
 (RACBLOB_ID_P IN t_racuni_blob.id%TYPE
 )
 IS
-- poziva se iz post2merac
  req_l  UTL_HTTP.req;
  res_l  UTL_HTTP.resp;
  line_l CLOB;
BEGIN
  odgovor_m := NULL;

  IF log_filename_m IS NOT NULL THEN
    pra_pka2.clob_to_table (CHR(10) || '[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' || url_m || CHR(10), log_filename_m, racblob_id_p, 'ERACUN');
    pra_pka2.clob_to_table (data_m || CHR(10), log_filename_m, racblob_id_p, 'ERACUN');
  END IF;

  UTL_HTTP.set_detailed_excp_support (enable => true);
  -- UTL_HTTP.set_response_error_check (enable => true);
  UTL_HTTP.set_body_charset (charset => 'UTF-8');
  req_l := UTL_HTTP.begin_request (url => url_m, method => 'POST', http_version => 'HTTP/1.1');
  UTL_HTTP.set_header (req_l, 'Content-Type', 'application/json; charset=utf-8');

  DECLARE
    req_length_l BINARY_INTEGER;
    buffer_l     VARCHAR2(2000);
    amount_l     PLS_INTEGER := 2000;
    offset_l     PLS_INTEGER := 1;
  BEGIN
    req_length_l := pra_pka2.clob_length (data_m);
    UTL_HTTP.set_header (req_l, 'Content-Length', req_length_l);

    WHILE (offset_l < req_length_l) LOOP
      buffer_l := DBMS_LOB.substr (data_m, amount_l, offset_l);
      UTL_HTTP.write_text (req_l, buffer_l);
      offset_l := offset_l + amount_l;
    END LOOP;
  END;

  res_l := UTL_HTTP.get_response (req_l);

  IF log_filename_m IS NOT NULL THEN -- IRN 4027
    pra_pka2.clob_to_table (res_l.status_code || ' ' || res_l.reason_phrase || CHR(10), log_filename_m, racblob_id_p, 'ERACUN');
  END IF;

  BEGIN
    LOOP
      UTL_HTTP.read_line (res_l, line_l);
      odgovor_m := odgovor_m || line_l;
    END LOOP;
    UTL_HTTP.end_response (res_l);
  EXCEPTION
    WHEN UTL_HTTP.end_of_body THEN
      UTL_HTTP.end_response (res_l);
  END;

  IF log_filename_m IS NOT NULL THEN
    pra_pka2.clob_to_table (odgovor_m || CHR(10), log_filename_m, racblob_id_p, 'ERACUN');
  END IF;
EXCEPTION
  WHEN OTHERS THEN
    UTL_HTTP.end_response (res_l);
    IF log_filename_m IS NOT NULL THEN
      pra_pka2.clob_to_table ('[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' || SQLERRM || CHR(10), log_filename_m, racblob_id_p, 'ERACUN');
    END IF;
    RAISE;
END;
PROCEDURE MERAC_OBRADI_ODGOVOR
 (METHOD_P IN VARCHAR2
 ,RACBLOB_ID_P IN t_racuni_blob.id%TYPE
 ,VANJSUS_POSTOJI_P OUT NUMBER
 )
 IS
-- poziva se iz post2merac
  values_l      APEX_JSON.t_values;
  id_vanjsus_l  VARCHAR2(20);
  status_l      VARCHAR2(5);
  status_name_l VARCHAR2(120);

  pka_rac_id_l  NUMBER(32);

  path_l        VARCHAR2(128);
  br_zapisa_l   NUMBER;
  text_l        VARCHAR2(10000);
BEGIN
  /*
     [
        {
            "ElectronicId": 488897,
            "DocumentNr": "2016-000002-017-11",
            "DocumentTypeId": 1,
            "DocumentTypeName": "eInvoice",
            "StatusId": 10,
            "StatusName": "Processing",
            "RecipientBusinessNumber": "94114100359",
            "RecipientBusinessUnit": "",
            "RecipientBusinessName": "ISTRA TECH d.o.o.",
            "Created": "2016-07-01T14:37:26.847",
            "Updated": null,
            "Sent": null,
            "Delivered": null
        },
        {
            "ElectronicId": 488907,
            "DocumentNr": "2016-000003-013-11",
            "DocumentTypeId": 1,
            "DocumentTypeName": "eInvoice",
            "StatusId": 10,
            "StatusName": "Processing",
            "RecipientBusinessNumber": "54333789665",
            "RecipientBusinessUnit": "",
            "RecipientBusinessName": "Probni primatelj d.o.o.",
            "Created": "2016-07-14T12:14:14.83",
            "Updated": null,
            "Sent": null,
            "Delivered": null
        }
     ]
     --------------------
     {
        "Username": {
          "Value": "1808",
          "Messages": [
            "Username and password are not valid"
          ]
        }
     }
     --------------------
     {
        "CompanyId": {
          "Value": "35465465468",
          "Messages": [
            "User: \"1808\" is not authorized with company"
          ]
        }
     }
     --------------------
     {
        "SoftwareId": {
          "Value": "eRa-001",
          "Messages": [
            "SoftwareId is invalid."
          ]
        }
     }
     --------------------
     {
        "Apply": {
        "Value": "resend",
        "Messages": [
            "Action resend can be applied only on documents in status 30 (Sent) or 50 (Unsuccessful)."
            ]
        }
     }
     --------------------

     10 In preparation - Document is successfully uploaded, but pending validation and sending
     20 In validation - Document is successfully uploaded, pending recipient company data validation
     30 Sent - Document is successfully uploaded, digitally signed and time stamped. Notification email is sent to customer.
     40 Delivered - Customer accepted and downloaded digital invoice
     45 Canceled - Sender canceled digital invoicing process, as customer didn't accept invoice. Customer can no longer download document.
     50 Unsuccessful - Customer did not download invoice in 5 days ? from this point usual flow is to resend document
  */

  IF TRIM (odgovor_m) IS NULL OR odgovor_m = '[]' THEN
    RETURN;
  END IF;

  APEX_JSON.parse (values_l, odgovor_m);
  -- endpoint /queryOutbox u odgovoru vrati uglate zagrade
  id_vanjsus_l := APEX_JSON.get_varchar2 (p_path => '[%d].ElectronicId', p0 => 1, p_values => values_l);
  status_l := APEX_JSON.get_varchar2 (p_path => '[%d].StatusId', p0 => 1, p_values => values_l);
  status_name_l :=  APEX_JSON.get_varchar2 (p_path => '[%d].StatusName', p0 => 1, p_values => values_l);
  IF id_vanjsus_l IS NULL THEN
    -- endpoint /send u odgovoru ne vrati uglate zagrade
    id_vanjsus_l := APEX_JSON.get_varchar2 (p_path => 'ElectronicId', p_values => values_l);
    status_l := APEX_JSON.get_varchar2 (p_path => 'StatusId', p_values => values_l);
    status_name_l :=  APEX_JSON.get_varchar2 (p_path => 'StatusName', p_values => values_l);
  END IF;

  IF racblob_id_p IS NOT NULL AND id_vanjsus_l IS NOT NULL THEN
    UPDATE t_racuni_blob racblob
       SET id_vanjsus = id_vanjsus_l,
           status = DECODE (status_l,
                           '10', '1',
                           '20', '1',
                           '30', '1',
                           '40', '2',
                           '45', '-1',
                           '50', '4',
                           '1')
     WHERE racblob.id = racblob_id_p;

    -- poniti i pdf
    IF status_l = '45' THEN
      SELECT NVL (rac_id, pkarac_id)
        INTO pka_rac_id_l
        FROM t_racuni_blob
       WHERE id = racblob_id_p;

      UPDATE t_racuni_blob
         SET status = '-1'
       WHERE NVL (rac_id, pkarac_id) = pka_rac_id_l
         AND status <> '-1';
    END IF;
  ELSE
    BEGIN
      path_l := APEX_JSON.get_members (p_path => '.', p_values => values_l)(1) || '.Messages'; -- npr. Username.Messages
      br_zapisa_l := APEX_JSON.get_count (p_path => path_l, p_values => values_l);
      path_l := path_l || '[%d]'; -- npr. Username.Messages[%d]
      FOR i IN 1 .. NVL (br_zapisa_l, -1)
      LOOP
        IF text_l IS NOT NULL THEN
          text_l := text_l || CHR(10);
        END IF;
        text_l := text_l || APEX_JSON.get_varchar2 (p_path => path_l, p_values => values_l, p0 => i);
      END LOOP;
    EXCEPTION
      WHEN OTHERS THEN -- nije uspjelo uitavanje via APEX_JSON
        text_l := SUBSTR (odgovor_m, 1, 240); -- IRN 3606
    END;
  END IF;

  IF status_l IS NOT NULL THEN
    vanjsus_postoji_p := -1;
  ELSE
    vanjsus_postoji_p := 0;
  END IF;

  IF racblob_id_p IS NULL THEN
    RETURN;
  END IF;

  INSERT INTO t_racblob_log (racblob_id, status)
    VALUES (racblob_id_p, SUBSTR (INITCAP (method_p) || ' status ' || status_l || ': ' || DECODE (text_l, NULL, status_name_l, 'Error - ' || text_l), 1, 240));

  COMMIT;
END;
PROCEDURE FINA_STAVKE_XML
 (RAC_ID_P IN t_racuni.id%TYPE
 ,STAVKEXML_P OUT XMLTYPE
 ,SUM_TAXABLE_RACVAL_P OUT t_racuni.iznos%TYPE
 )
 IS
-- poziva se iz fina_invoice_xml
  InvoiceLines_l   XMLTYPE;

  rac_izn_tecaja_l t_racuni.izn_tecaja%TYPE;
  racval_sifra_l   s_valute.sifra_3a%TYPE;
  racval_id_l      t_racuni.val_id%TYPE;
  ruz_l            t_racuni.iznos%TYPE := 0;

  -- REC param 1037: Raune s iste POS blagajne ispisivati u jednom retku: da ili ne.
  rec_param_1037_l szmp_parametri.vrijednost%TYPE := UPPER (pra_rec_zaj.vrijednost_parametra ('1037'));

  i NUMBER (5) := 0;
BEGIN
  SELECT rac.izn_tecaja, val.sifra_3a, rac.val_id
    INTO rac_izn_tecaja_l, racval_sifra_l, racval_id_l
    FROM t_racuni rac,
         s_valute val
   WHERE rac.id = rac_id_p
     AND rac.val_id = val.id;

  pripremi_tab_ruz (rac_id_p, rac_izn_tecaja_l);

  FOR tro_c IN (
    SELECT tro.id AS id,
           tro.usl_id1 AS usl_id1,
           tro.kol_usluge AS kol_usluge,
           DECODE (tro.val_id, racval_id_l, tro.cijena_usluge,
             ROUND (tro.cijena_usluge * tro.izn_tecaja / rac_izn_tecaja_l, 2)
             ) AS cijena_usluge, -- u valuti rauna
           tro.obr_po_danu AS obr_po_danu,
           tro.obr_zdana AS obr_zdana,
           tro.dat_poc AS dat_poc,
           tro.dat_zav AS dat_zav,
           tro.izn_odbitka AS izn_odbitka,
           tro.br_uputnice AS br_uputnice,
           ROUND ((ROUND (tro.cijena_usluge * tro.stopa_placanja / 100 * tro.izn_tecaja / rac_izn_tecaja_l, 2)
                   * tro.kol_usluge
                   * DECODE (tro.obr_po_danu, -1, tro.dat_zav - tro.dat_poc - tro.obr_zdana, 1)
                   - tro.izn_odbitka
                  ) * 100 / (100 + tro.stopa_pdv), 2
             ) AS osn_pdv_racval,
           tro.stopa_pdv AS stopa_pdv,
           tro.vpispz_id AS vpispz_id,
           zmpspisp.sifra AS sk_sifra,
           usl.sifra AS usl_sifra,
           usl1.sifra AS usl1_sifra,
           usl.naziv AS usl_naziv,
           usl.ozn_cje_vsj AS usl_ozn_cje_vsj,
           vsj.sifra AS vsj_sifra,
           vsj.naziv AS vsj_naziv,
           val.sifra_3a AS val_sifra_3a,
           DECODE (tro.gost_id, NULL,
             DECODE (tro.age_id, NULL,
               DECODE (pkaadr.naz_poduzeca, NULL,
                 DECODE (pkaadr.prezime, NULL, pkaadr.ime, pkaadr.prezime || ', ' || pkaadr.ime), pkaadr.naz_poduzeca),
               age.naziv),
             gost.prezime || ', ' || gost.ime
             ) AS naziv,
           usl.ozn_abc AS usl_ozn_abc
      FROM t_troskovi tro,
           s_vpisporukaz vpispz,
           szmp_spisporuka zmpspisp,
           s_usluge usl,
           s_usluge usl1,
           s_vsj vsj,
           s_valute val,
           t_gosti gost,
           m_agencije age,
           mpka_adrese pkaadr
     WHERE tro.rac_id = rac_id_p
       AND vpispz.id = tro.vpispz_id
       AND zmpspisp.id = vpispz.zmpspisp_id
       AND usl.id = tro.usl_id
       AND val.id = tro.val_id
       AND usl1.id (+) = tro.usl_id1
       AND vsj.id (+) = tro.vsj_id
       AND gost.id (+) = tro.gost_id
       AND age.id (+) = tro.age_id
       AND pkaadr.id (+) = tro.pkaadr_id
    UNION
    SELECT tro.id AS id,
           tro.usl_id1 AS usl_id1,
           tro.kol_usluge * (-1) AS kol_usluge,
           DECODE (tro.val_id, racval_id_l, tro.cijena_usluge,
             ROUND (tro.cijena_usluge * tro.izn_tecaja / rac_izn_tecaja_l, 2)
             ) AS cijena_usluge, -- u valuti rauna
           tro.obr_po_danu AS obr_po_danu,
           tro.obr_zdana AS obr_zdana,
           tro.dat_poc AS dat_poc,
           tro.dat_zav AS dat_zav,
           tro.izn_odbitka AS izn_odbitka,
           tro.br_uputnice AS br_uputnice,
           ROUND ((ROUND (tro.cijena_usluge * tro.stopa_placanja / 100 * tro.izn_tecaja / rac_izn_tecaja_l, 2)
                   * tro.kol_usluge * (-1)
                   * DECODE (tro.obr_po_danu, -1, tro.dat_zav - tro.dat_poc - tro.obr_zdana, 1)
                   - tro.izn_odbitka
                  ) * 100 / (100 + tro.stopa_pdv1), 2
             ) AS osn_pdv_racval,
           tro.stopa_pdv1 AS stopa_pdv,
           tro.vpispz_id1 AS vpispz_id,
           zmpspisp.sifra AS sk_sifra,
           usl.sifra AS usl_sifra,
           NULL, -- usl1_sifra
           usl.naziv AS usl_naziv,
           usl.ozn_cje_vsj AS usl_ozn_cje_vsj,
           vsj.sifra AS vsj_sifra,
           vsj.naziv AS vsj_naziv,
           val.sifra_3a AS val_sifra_3a,
           DECODE (tro.gost_id, NULL,
             DECODE (tro.age_id, NULL,
               DECODE (pkaadr.naz_poduzeca, NULL,
                 DECODE (pkaadr.prezime, NULL, pkaadr.ime, pkaadr.prezime || ', ' || pkaadr.ime), pkaadr.naz_poduzeca),
               age.naziv),
             gost.prezime || ', ' || gost.ime
             ) AS naziv,
           usl.ozn_abc AS usl_ozn_abc
      FROM t_troskovi tro,
           s_vpisporukaz vpispz,
           szmp_spisporuka zmpspisp,
           s_usluge usl,
           s_vsj vsj,
           s_valute val,
           t_gosti gost,
           m_agencije age,
           mpka_adrese pkaadr
     WHERE tro.rac_id = rac_id_p
       AND vpispz.id = tro.vpispz_id1
       AND zmpspisp.id = vpispz.zmpspisp_id
       AND usl.id = tro.usl_id1
       AND val.id = tro.val_id
       AND vsj.id (+) = tro.vsj_id
       AND gost.id (+) = tro.gost_id
       AND age.id (+) = tro.age_id
       AND pkaadr.id (+) = tro.pkaadr_id
     ORDER BY usl_ozn_abc, usl_sifra, dat_poc, naziv, usl1_sifra NULLS LAST)
  LOOP
    -- rbr
    i := i + 1;

    ruz_l := iznos_rasporedi_ruz (tro_c.vpispz_id);

    -- InvoiceLines_l
    SELECT xmlagg (
             xmlconcat (InvoiceLines_l,
               xmlelement ("cac:InvoiceLine",
                 xmlelement ("cbc:ID", TO_CHAR(i)),
                 xmlelement ("cbc:InvoicedQuantity",
                   xmlattributes ('H87' "unitCode"),
                     tro_c.kol_usluge * DECODE (tro_c.obr_po_danu, -1, tro_c.dat_zav - tro_c.obr_zdana - tro_c.dat_poc, 1)
                 ),
                 xmlelement ("cbc:LineExtensionAmount",
                   xmlattributes (racval_sifra_l "currencyID"), TRIM (TO_CHAR (tro_c.osn_pdv_racval + ruz_l, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))
                 ),
                 xmlelement ("cac:Item",
                   xmlelement ("cbc:Description", tro_c.usl_naziv || DECODE (tro_c.usl_id1, NULL, NULL, ' (' || tro_c.usl1_sifra || ')') ||
                                                  DECODE (tro_c.usl_ozn_cje_vsj, -1, ' ' || tro_c.vsj_naziv) ||
                                                  ' ' || TO_CHAR (tro_c.dat_poc, 'DD.MM.RRRR') ||
                                                  DECODE (tro_c.obr_po_danu, -1, '-' || TO_CHAR (tro_c.dat_zav, 'DD.MM.RRRR')) ||
                                                  DECODE (tro_c.br_uputnice, NULL, NULL, ' ' || tro_c.br_uputnice) ||
                                                  ' ' || tro_c.naziv
                   ),
                   xmlelement ("cbc:Name", tro_c.usl_sifra || DECODE (tro_c.usl_id1, NULL, NULL, ' (' || tro_c.usl1_sifra || ')') ||
                                           DECODE (tro_c.usl_ozn_cje_vsj, -1, ' ' || tro_c.vsj_sifra) ||
                                           ' ' || TO_CHAR (tro_c.dat_poc, 'DD.MM.RRRR') ||
                                           DECODE (tro_c.obr_po_danu, -1, '-' || TO_CHAR (tro_c.dat_zav, 'DD.MM.RRRR'))
                   ),
                   xmlelement ("cac:ClassifiedTaxCategory",
                     xmlelement ("cbc:ID", DECODE (SUBSTR (tro_c.sk_sifra, 1, 1), '1', 'E', 'S')),
                     xmlelement ("cbc:Percent", TRIM (TO_CHAR (tro_c.stopa_pdv, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                     xmlelement ("cac:TaxScheme",
                       xmlelement ("cbc:ID", 'VAT')
                     )
                   )
                 ),
                 xmlelement ("cac:Price",
                   xmlelement ("cbc:PriceAmount",
                     xmlattributes (racval_sifra_l "currencyID"), TRIM (TO_CHAR (tro_c.cijena_usluge, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                   xmlelement ("cbc:BaseQuantity",
                     xmlattributes('H87' "unitCode"), '1.000')
                 )
               )
             )
           )
      INTO InvoiceLines_l
      FROM dual;

    sum_taxable_racval_p := NVL (sum_taxable_racval_p, 0) + tro_c.osn_pdv_racval + ruz_l;

  END LOOP;
  -- kraj stavke trokovi

  -- stavke internih POS rauna
  FOR gmpkas_c IN ( -- sve blagajne internih POS rauna povezanih na rac_id_p
    SELECT DISTINCT
           gmpkas.id AS gmpkas_id,
           gmpkas.naziv AS gmpkas_naziv
      FROM tpka_rnkasa pkarnk,
           mgmp_kase gmpkas
     WHERE pkarnk.rac_id = rac_id_p
       AND pkarnk.gmpkas_id = gmpkas.id)
  LOOP

    -- svaki interni POS raun (zbog REC parametra 1037 ili je jedini na toj blagajni)
    IF rec_param_1037_l = 'NE' OR rm_rec2250.br_redova_kase (rac_id_p, gmpkas_c.gmpkas_id) = 1 THEN

      FOR pkarnk_c IN (
        SELECT pkarnk.rbr || '/' || pkarnk.god_poslovna AS rnk,
               TO_CHAR (pkarnk.datum, 'DD.MM.RRRR') AS datum,
               DECODE (pkarnk.domval_id, racval_id_l, pkarnk.izn_placanja - pkarnk.izn_ppot,
                 ROUND ((pkarnk.izn_placanja - pkarnk.izn_ppot) / rac_izn_tecaja_l, 2)
                 ) AS iznos, -- u valuti rauna
               ROUND (rnkpdv.izn_osnovice / rac_izn_tecaja_l, 2) AS izn_osn_racval,
               rnkpdv.stopa_pdv AS stopa_porez,
               rnkpdv.vpispz_id AS vpispz_id
          FROM tpka_rnkasa pkarnk,
               ipka_rnk_pdv rnkpdv
         WHERE pkarnk.rac_id = rac_id_p
           AND pkarnk.gmpkas_id = gmpkas_c.gmpkas_id
           AND rnkpdv.pkarnk_id = pkarnk.id)
      LOOP

        -- rbr
        i := i + 1;

        ruz_l := iznos_rasporedi_ruz (pkarnk_c.vpispz_id);

        -- InvoiceLines_l
        SELECT xmlagg (
                 xmlconcat (InvoiceLines_l,
                   xmlelement ("cac:InvoiceLine",
                     xmlelement ("cbc:ID", TO_CHAR (i)),
                     xmlelement ("cbc:InvoicedQuantity",
                       xmlattributes ('H87' "unitCode"), '1' -- uvijek 1
                     ),
                     xmlelement ("cbc:LineExtensionAmount",
                       xmlattributes (racval_sifra_l "currencyID"),
                         TRIM (TO_CHAR (pkarnk_c.izn_osn_racval + ruz_l, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))
                     ),
                     xmlelement ("cac:Item",
                       xmlelement ("cbc:Description", gmpkas_c.gmpkas_naziv || ' - ' || pkarnk_c.rnk || ' (' || pkarnk_c.datum || ') - ' || pkarnk_c.stopa_porez || '%'
                       ),
                       xmlelement ("cbc:Name", gmpkas_c.gmpkas_naziv || ' - ' || pkarnk_c.rnk || ' ' || pkarnk_c.stopa_porez || '%'
                       ),
                       xmlelement ("cac:ClassifiedTaxCategory",
                         xmlelement ("cbc:ID", 'S'),
                         xmlelement ("cbc:Percent", TRIM (TO_CHAR (pkarnk_c.stopa_porez, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                         xmlelement ("cac:TaxScheme",
                           xmlelement ("cbc:ID", 'VAT')
                         )
                       )
                     ),
                     xmlelement ("cac:Price",
                       xmlelement ("cbc:PriceAmount",
                         xmlattributes (racval_sifra_l "currencyID"), TRIM (TO_CHAR (ABS (pkarnk_c.iznos), '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       xmlelement ("cbc:BaseQuantity",
                         xmlattributes ('H87' "unitCode"), '1.000')
                     )
                   )
                 )
               )
          INTO InvoiceLines_l
          FROM dual;

        sum_taxable_racval_p := NVL (sum_taxable_racval_p, 0) + pkarnk_c.izn_osn_racval + ruz_l;

      END LOOP;

    ELSE
      -- svi interni POS rauni jedne blagajne u jednom retku
      FOR pkarnk_c IN (
        SELECT COUNT (1) AS rnk,
               TO_CHAR (MIN (pkarnk.datum), 'DD.MM.RRRR') || ' - ' ||
                 TO_CHAR (MAX (pkarnk.datum), 'DD.MM.RRRR') AS datum,
               SUM (
                 DECODE (pkarnk.domval_id, racval_id_l, pkarnk.izn_placanja - pkarnk.izn_ppot,
                   ROUND ((pkarnk.izn_placanja - pkarnk.izn_ppot) / rac_izn_tecaja_l, 2))
                 ) AS iznos, -- u valuti rauna
               SUM (ROUND (rnkpdv.izn_osnovice / rac_izn_tecaja_l, 2)) AS izn_osn_racval,
               MIN (rnkpdv.stopa_pdv) AS stopa_porez,
               rnkpdv.vpispz_id AS vpispz_id
          FROM tpka_rnkasa pkarnk,
               ipka_rnk_pdv rnkpdv
         WHERE pkarnk.rac_id = rac_id_p
           AND pkarnk.gmpkas_id = gmpkas_c.gmpkas_id
           AND rnkpdv.pkarnk_id = pkarnk.id
         GROUP BY rnkpdv.vpispz_id, pkarnk.id)
      LOOP

        -- rbr
        i := i + 1;

        ruz_l := iznos_rasporedi_ruz (pkarnk_c.vpispz_id);

        -- InvoiceLines_l
        SELECT xmlagg (
                 xmlconcat (InvoiceLines_l,
                   xmlelement ("cac:InvoiceLine",
                     xmlelement ("cbc:ID", TO_CHAR (i)),
                     xmlelement ("cbc:InvoicedQuantity",
                       xmlattributes ('H87' "unitCode",
                                     'UN/ECE rec 20 8e' "unitCodeListID",
                                     '6' "unitCodeListAgencyID"), '1' -- uvijek 1
                     ),
                     xmlelement ("cbc:LineExtensionAmount",
                       xmlattributes (racval_sifra_l "currencyID"),
                         TRIM (TO_CHAR (pkarnk_c.izn_osn_racval + ruz_l, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))
                     ),
                     xmlelement ("cac:Item",
                       xmlelement ("cbc:Description", gmpkas_c.gmpkas_naziv || ' - ' || pkarnk_c.rnk || ' (' || pkarnk_c.datum || ') - ' || pkarnk_c.stopa_porez || '%'
                       ),
                       xmlelement ("cbc:Name", gmpkas_c.gmpkas_naziv || ' - ' || pkarnk_c.rnk || ' ' || pkarnk_c.stopa_porez || '%'
                       ),
                       xmlelement ("cac:ClassifiedTaxCategory",
                         xmlelement ("cbc:ID", 'S'),
                         xmlelement ("cbc:Percent", TRIM (TO_CHAR (pkarnk_c.stopa_porez, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                         xmlelement ("cac:TaxScheme",
                           xmlelement ("cbc:ID", 'VAT')
                         )
                       )
                     ),
                     xmlelement ("cac:Price",
                       xmlelement ("cbc:PriceAmount",
                         xmlattributes (racval_sifra_l "currencyID"), TRIM (TO_CHAR (ABS (pkarnk_c.iznos), '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       xmlelement ("cbc:BaseQuantity",
                         xmlattributes ('H87' "unitCode"), '1.000')
                     )
                   )
                 )
               )
          INTO InvoiceLines_l
          FROM dual;

        sum_taxable_racval_p := NVL (sum_taxable_racval_p, 0) + pkarnk_c.izn_osn_racval + ruz_l;

      END LOOP;
    END IF;

  END LOOP;
  -- kraj stavke internih POS rauna

  stavkexml_p := InvoiceLines_l;
END;
PROCEDURE FINA_TAXES_XML
 (RAC_ID_P IN t_racuni.id%TYPE
 ,TAXSUBTOTALS_P OUT XMLTYPE
 ,SUM_TAX_DOMVAL_P OUT t_racuni.iznos%TYPE
 ,SUM_NETO_DOMVAL_P OUT t_racuni.iznos%TYPE
 ,CHARGE_PPOT_P OUT t_racuni.iznos%TYPE
 ,CHARGE_PNAKNADA_P OUT t_racuni.iznos%TYPE
 )
 IS
-- poziva se iz fina_invoice_xml
  napomenaBP_l m_vnapomena.napomena%TYPE;
BEGIN

  SELECT vnap.napomena
    INTO napomenaBP_l
    FROM t_racuni rac,
         m_vnapomena vnap
   WHERE rac.id = rac_id_p
     AND vnap.id(+) = rac.vnap_id;

  SELECT
    xmlagg (
      xmlelement ("cac:TaxSubtotal",
        xmlelement ("cbc:TaxableAmount",
          xmlattributes (domval_sifra_m "currencyID"), TRIM (TO_CHAR (osnovica, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
        xmlelement ("cbc:TaxAmount",
          xmlattributes (domval_sifra_m "currencyID"), TRIM (TO_CHAR (porez, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
        xmlelement ("cac:TaxCategory",
          xmlelement ("cbc:ID", DECODE (sub_sk_sifra, '1', 'E', 'S')),
          xmlelement ("cbc:Percent", TRIM (TO_CHAR (stopa, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
          DECODE (sub_sk_sifra, '1', xmlelement ("cbc:TaxExemptionReason", napomenaBP_l), NULL),
          xmlelement ("cac:TaxScheme",
            xmlelement ("cbc:ID", 'VAT')  -- DECODE (sub_sk_sifra, '1', 'FRE', 'VAT'))
          )
        )
      )
    ),
    SUM (porez),
    SUM (osnovica),
    SUM (izn_ppot),
    SUM (izn_pnaknade)
  INTO
    TaxSubtotals_p,
    sum_tax_domval_p,
    sum_neto_domval_p,
    charge_ppot_p,
    charge_pnaknada_p
  FROM
    (
    SELECT
      stopa,
      SUBSTR (sk_sifra, 1, 1) AS sub_sk_sifra,
      SUM (neto) AS osnovica,
      SUM (pdv) AS porez,
      SUM (DECODE (ppot, 1, neto, 0)) AS izn_ppot,
      SUM (DECODE (povratna_naknada, 1, neto, 0)) AS izn_pnaknade
    FROM
      (
      SELECT
        zmpspisp.naziv AS naziv,
        zmpspisp.sifra AS sk_sifra,
        ROUND (rac_pdv.iznos, 2) AS neto,
        rac_pdv.stopa_pdv AS stopa,
        rac_pdv.izn_domval - ROUND (rac_pdv.iznos, 2) AS pdv,
        0 AS ppot,
        0 AS povratna_naknada
      FROM
        i_rac_pdv rac_pdv,
        s_vpisporukaz vpispz,
        szmp_spisporuka zmpspisp
      WHERE
        rac_pdv.vpispz_id = vpispz.id
        AND zmpspisp.id = vpispz.zmpspisp_id
        AND rac_pdv.rac_id = rac_id_p
      UNION ALL
      SELECT
         NULL,
        '10',
        SUM (izn_ppot),
        0,
        0,
        1,
        0 
      FROM
        tpka_rnkasa
      WHERE
        rac_id = rac_id_p
        AND NVL (stopa_ppot, 0) <> 0
      GROUP BY
        stopa_ppot
      UNION ALL  
      -- IRN 3818
      SELECT
        NULL,
        '10',
        SUM (izn_pnaknade),
        0,
        0,
        0,
        1 
      FROM
        tpka_rnkasa
      WHERE
        rac_id = rac_id_p
        AND NVL (izn_pnaknade, 0) <> 0
      HAVING SUM (izn_pnaknade) > 0
      )
    GROUP BY
      stopa, SUBSTR (sk_sifra, 1, 1)
    )
  ORDER BY stopa;
END;
PROCEDURE FINA_CUSTOMER_XML
 (RAC_ID_P IN t_racuni.id%TYPE
 ,ACCOUNTINGCUSTOMERPARTY_P OUT XMLTYPE
 ,BUYERID_P OUT VARCHAR2
 )
 IS
-- poziva se iz fina_invoice_xml
  kupac_id_l     t_racuni.age_id%TYPE;
  gmpkomad_id_l  t_racuni.gmpkomad_id%TYPE;

  email_niz_l    VARCHAR2(400);
BEGIN
  SELECT pra_rec2.agek_id (age_id, agep_id), gmpkomad_id
    INTO kupac_id_l, gmpkomad_id_l
    FROM t_racuni
   WHERE id = rac_id_p;

  FOR agegzem_c IN (
    SELECT email
      FROM m_age_gzem
     WHERE age_id = kupac_id_l
       AND LOWER (napomena) LIKE '%e-raun%')
  LOOP
    IF email_niz_l IS NOT NULL THEN
      email_niz_l := email_niz_l || ';';
    END IF;
    email_niz_l := email_niz_l || agegzem_c.email;
  END LOOP;

  SELECT
    xmlelement ("cac:AccountingCustomerParty",
      xmlelement ("cac:Party",
        xmlelement ("cbc:EndpointID", xmlattributes ('9934' "schemeID"), kupac.CompanyID),
        xmlelement ("cac:PartyIdentification",
          xmlelement ("cbc:ID", '9934:' || kupac.CompanyID || DECODE (kupac.pj_sifra, NULL, NULL, '::HR99:' || kupac.pj_sifra)
          )
        ),
        xmlelement ("cac:PartyName",
          xmlelement ("cbc:Name", kupac.naziv)
        ),
        xmlelement ("cac:PostalAddress",
          xmlelement ("cbc:StreetName", kupac.ulica),
          xmlelement ("cbc:CityName", kupac.mjesto),
          xmlelement ("cbc:PostalZone", kupac.posta),
          xmlelement ("cac:Country",
            xmlelement ("cbc:IdentificationCode", kupac.zem_sifra_2a)
          )
        ),
        xmlelement ("cac:PartyTaxScheme",
          xmlelement ("cbc:CompanyID", kupac.br_porezni),
          xmlelement ("cac:TaxScheme",
            xmlelement ("cbc:ID", 'VAT')
          )
        ),
        xmlelement ("cac:PartyLegalEntity",
          xmlelement ("cbc:RegistrationName", kupac.naziv),
          xmlelement ("cbc:CompanyID", kupac.CompanyID)
        ),
        xmlelement ("cac:Contact",
          xmlelement ("cbc:Name", kupac.odg_osoba),
          xmlelement ("cbc:ElectronicMail", kupac.email)
        )
      )
    ),
    '9934:' || kupac.CompanyID
  INTO
    AccountingCustomerParty_p,
    buyerid_p
  FROM (
    SELECT
      DECODE (gmpkomad_age.id, NULL, NVL (gmpkom.sifra_pj, age.sifra_pj), gmpkomad_age.sifra_pj) AS pj_sifra,
      DECODE (gmpkomad_age.id, NULL, age.naziv, gmpkomad_age.naziv) AS naziv,
      DECODE (gmpkomad_age.id, NULL, age.naz_ulice, gmpkomad_age.naz_ulice) AS ulica,
      DECODE (gmpkomad_age.id, NULL, pos.naziv, gmpkomad_age.pos_naziv) AS mjesto,
      DECODE (gmpkomad_age.id, NULL, pos.broj, gmpkomad_age.pos_broj) AS posta,
      DECODE (gmpkomad_age.id, NULL, zem.sifra_2a, gmpkomad_age.zem_sifra_2a) AS zem_sifra_2a,
      DECODE (zem.sifra_2a, domzem_sifra_m, domzem_sifra_m || age.oib, age.br_porezni) AS br_porezni,
      DECODE (zem.sifra_2a, domzem_sifra_m, age.oib, age.br_porezni) AS CompanyID, -- IRN 3606; bez prefiksa zemlje
      DECODE (gmpkomad_age.id, NULL, NVL (email_niz_l, age.email), gmpkomad_age.email) AS email,
      DECODE (gmpkomad_age.id, NULL, NVL (gmpkom.imep_osobeodg, age.imep_osobeodg), gmpkomad_age.odg_osoba) AS odg_osoba
    FROM
      m_agencije age,
      mgmp_komitenti gmpkom,
      s_zemlje zem,
      m_poste pos,
      (
      SELECT
        gmpkomad.id AS id,
        gmpkomad.gmpkom_id AS gmpkom_id,
        gmpkomad.sifra_pj AS sifra_pj,
        gmpkomad.naziv AS naziv,
        gmpkomad.email AS email,
        gmpkomad.naz_ulice AS naz_ulice,
        gmpkomad.imep_osobeodg AS odg_osoba,
        pos.broj AS pos_broj,
        pos.naziv AS pos_naziv,
        zem.sifra_2a AS zem_sifra_2a
      FROM
        mgmp_kom_adrese gmpkomad,
        s_zemlje zem,
        m_poste pos
      WHERE
        gmpkomad.id = gmpkomad_id_l
        AND zem.id = gmpkomad.zem_id
        AND pos.id (+) = gmpkomad.pos_id
      ) gmpkomad_age
    WHERE
      age.id = kupac_id_l
      AND zem.id = age.zem_id
      AND pos.id (+) = age.pos_id
      AND gmpkom.id (+) = age.gmpkom_id
      AND gmpkomad_age.gmpkom_id (+) = age.gmpkom_id
    ) kupac;
END;
FUNCTION FINA_INVOICE_XML
 (RAC_ID_P IN t_racuni.id%TYPE
 ,ZAH_PONUDA_P IN VARCHAR2 := NULL
 ,NARUDZBENICA_P IN VARCHAR2 := NULL
 ,UGOVOR_P IN VARCHAR2 := NULL
 ,PROJEKT_P IN VARCHAR2 := NULL
 ,NAPOMENA_P IN VARCHAR2 := NULL
 ,TIP_P IN VARCHAR2
 )
 RETURN XMLTYPE
 IS
-- poziva se iz izradi_eracun_blob
  OrderReference_l               XMLTYPE;
  BillingReference_l             XMLTYPE;
  DespatchDocumentReference_l    XMLTYPE;
  ReceiptDocumentReference_l     XMLTYPE;
  OriginatorDocumentReference_l  XMLTYPE;
  ContractDocumentReference_l    XMLTYPE;
  AdditionalDocumentReference_l  XMLTYPE;
  ProjectReference_l             XMLTYPE;
  AccountingSupplierParty_l      XMLTYPE;
  AccountingCustomerParty_l      XMLTYPE;
  PaymentMeans_l                 XMLTYPE;
  InvoiceAllowanceCharge_l       XMLTYPE;
  InvoiceAllowanceCharge2_l      XMLTYPE;
  InvoiceTaxTotal_l              XMLTYPE;
  LegalMonetaryTotal_l           XMLTYPE;
  EmbeddedDocumentBinaryObject_l XMLTYPE;

  Invoice_l                      XMLTYPE;
  InvoiceLines_l                 XMLTYPE;
  TaxSubtotals_l                 XMLTYPE;

  sum_taxable_racval_l           t_racuni.iznos%TYPE;

  sum_neto_domval_l              t_racuni.iznos%TYPE;
  sum_tax_domval_l               t_racuni.iznos%TYPE;

  racval_sifra_l                 s_valute.sifra_3a%TYPE;
  rac_izn_tecaja_l               t_racuni.izn_tecaja%TYPE;
  racbruto_racval_l              t_racuni.iznos%TYPE;
  predujam_racval_l              t_racuni.iznos%TYPE;
  rac_iznos_l                    t_racuni.iznos%TYPE;
  charge_ppot_l                  t_racuni.iznos%TYPE;
  charge_pnaknada_l              t_racuni.iznos%TYPE;

  supplierId_l                   VARCHAR2(30);
  buyerId_l                      VARCHAR2(30);

  jedinst_ozn_rac_l              VARCHAR2(30);
BEGIN
  -- https://prez.fina.hr/SendB2BOutgoingInvoicePKIWebService/services/SendB2BOutgoingInvoicePKIWebService

  IF rac_id_p IS NULL THEN
    RETURN NULL;
  END IF;

  SELECT xmlelement ("cac:AccountingSupplierParty",
           xmlelement ("cac:Party",
             xmlelement ("cbc:EndpointID", xmlattributes ('9934' "schemeID"), vla.oib),
             xmlelement ("cac:PartyIdentification",
               xmlelement ("cbc:ID", '9934:' || vla.oib)
             ),
             xmlelement ("cac:PartyName",
               xmlelement ("cbc:Name", vla.naziv)
             ),
             xmlelement ("cac:PostalAddress",
               xmlelement ("cbc:StreetName", so.naz_ulice),
               xmlelement ("cbc:CityName", pos.naziv),
               xmlelement ("cbc:PostalZone", pos.broj),
               xmlelement ("cac:Country",
                 xmlelement ("cbc:IdentificationCode", domzem_sifra_m)
               )
             ),
             xmlelement ("cac:PartyTaxScheme",
               xmlelement ("cbc:CompanyID", domzem_sifra_m || vla.oib),
               xmlelement ("cac:TaxScheme",
                 xmlelement ("cbc:ID", 'VAT')
               )
             ),
             xmlelement ("cac:PartyLegalEntity",
               xmlelement ("cbc:RegistrationName", vla.naziv),
               xmlelement ("cbc:CompanyID", vla.oib)
             ),
             xmlelement ("cac:Contact",      -- samo supplier party
               xmlelement ("cbc:Name", so.imep_sefarec),
               xmlelement ("cbc:ElectronicMail", so.email)
             )
           )
         ),
         xmlelement ("cac:PaymentMeans",
           xmlelement ("cbc:PaymentMeansCode", 30),
           /* Specifikacija, str. 67:
             10 - Gotovina
             30 - Kreditni transfer
             48 - Bankovna kartica
             49 - Izravno tereenje
           */
           DECODE (rac.poziv_na_broj, NULL, NULL, xmlelement ("cbc:PaymentID", 'HR99' || ' ' || rac.poziv_na_broj)),
           xmlelement ("cac:PayeeFinancialAccount",
             xmlelement ("cbc:ID", TRANSLATE (urac.iban, 'A' || chr(9) || chr(10) || chr(11) || chr(12) || chr(13) || chr(32), 'A'))
           )
         ),
         '9934:' || vla.oib,
         rac.god_poslovna || '-' || rac.rbr || '-' || rac.oj_sifra || '-' || rac.vdok_sifra2n,
         pra_rec_s2.iznos_racuna_bruto (rac.id, rac.iznos, rac.izn_tecaja), -- u valuti rauna
         pra_rec_s2.izn_predujma_racval (rac.id, rac.izn_tecaja), -- u valuti rauna
         rac.iznos,
         val.sifra_3a,
         rac.izn_tecaja
    INTO AccountingSupplierParty_l,
         PaymentMeans_l,
         supplierId_l, -- ne koristi se dalje
         jedinst_ozn_rac_l,
         racbruto_racval_l,
         predujam_racval_l,
         rac_iznos_l,
         racval_sifra_l,
         rac_izn_tecaja_l
    FROM s_vlasnik vla,
         m_so so,
         m_poste pos,
         t_racuni rac,
         m_uracuni urac,
         s_valute val
   WHERE rac.id = rac_id_p
     AND rac.so_id = so.id
     AND so.pos_id = pos.id
     AND rac.urac_id = urac.id (+)
     AND rac.val_id = val.id;

  fina_customer_xml (rac_id_p, AccountingCustomerParty_l, buyerId_l);
  -- rekapitulacija poreza u domaoj valuti
  fina_taxes_xml (rac_id_p, TaxSubtotals_l, sum_tax_domval_l, sum_neto_domval_l, charge_ppot_l, charge_pnaknada_l);
  -- stavke u valuti rauna
  fina_stavke_xml (rac_id_p, InvoiceLines_l, sum_taxable_racval_l);

  SELECT DECODE (narudzbenica_p,                        -- narudbenica
           NULL, NULL,
           xmlelement ("cac:OrderReference",
             xmlelement ("cbc:ID", narudzbenica_p))),
         xmlelement ("cac:BillingReference",            -- prethodni racun (u slucaju:
           xmlelement ("cac:InvoiceDocumentReference",  -- - ispravljen je prethodni racun
             xmlelement ("cbc:ID", '')                  -- - prethodni djelomicni racuni se referenciraju iz konacnog racuna
           )                                            -- - prethodni racuni za predujam se referenciraju iz konacnog racuna
         ),
         xmlelement ("cac:DespatchDocumentReference",   -- otpremnica
           xmlelement ("cbc:ID", '')),
         xmlelement ("cac:ReceiptDocumentReference",    -- primka
           xmlelement ("cbc:ID", '')),
         DECODE (zah_ponuda_p,                          -- zahtjev za ponudu
           NULL, NULL,
           xmlelement ("cac:OriginatorDocRef",
             xmlelement ("cbc:ID", zah_ponuda_p))),
         DECODE (ugovor_p,                              -- ugovor
           NULL, NULL,
           xmlelement ("cac:ContractDocumentReference",
             xmlelement ("cbc:ID", ugovor_p))),
         xmlelement ("cac:AdditionalDocRef",            -- identifikator fakturiranog objekta (pretplatnicki broj, telefonski broj, mjesto mjerenja, vozilo, osoba itd.)
           xmlelement ("cbc:ID", '')),
         DECODE (projekt_p,                             -- projekt
           NULL, NULL,
           xmlelement ("cac:ProjectReference",
             xmlelement ("cbc:ID", projekt_p))),
         DECODE (NVL (charge_ppot_l, 0),
                0, NULL,
                xmlelement ("cac:AllowanceCharge",
                  xmlelement ("cbc:ChargeIndicator", 'true'),
                  xmlelement ("cbc:AllowanceChargeReason", pra_zmp_zaj.poruka ('ZMP', 'III0083')), -- porez na potronju
                  xmlelement ("cbc:Amount", xmlattributes (domval_sifra_m "currencyID"), TRIM (TO_CHAR (charge_ppot_l, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                  xmlelement ("cac:TaxCategory",
                    xmlelement ("cbc:ID", 'E'),
                    xmlelement ("cbc:Percent", TRIM (TO_CHAR (0, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                    xmlelement ("cac:TaxScheme",
                      xmlelement ("cbc:ID", 'VAT')
                    )
                  )
                )),
         DECODE (NVL (charge_pnaknada_l, 0),
                0, NULL,
                xmlelement ("cac:AllowanceCharge",
                  xmlelement ("cbc:ChargeIndicator", 'true'),
                  xmlelement ("cbc:AllowanceChargeReason", 'Povratna naknada'), -- povratna naknada
                  xmlelement ("cbc:MultiplierFactorNumeric", '20'),
                  xmlelement ("cbc:Amount", xmlattributes (domval_sifra_m "currencyID"), TRIM (TO_CHAR (charge_pnaknada_l, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                  xmlelement ("cbc:BaseAmount", xmlattributes (domval_sifra_m "currencyID"), TRIM (TO_CHAR (sum_neto_domval_l, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                  xmlelement ("cac:TaxCategory",
                    xmlelement ("cbc:ID", 'E'),
                    xmlelement ("cbc:Percent", TRIM (TO_CHAR (0, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                    xmlelement ("cac:TaxScheme",
                      xmlelement ("cbc:ID", 'VAT')
                    )
                  )
                )),                
         xmlelement ("cac:TaxTotal",
           xmlelement ("cbc:TaxAmount", xmlattributes (domval_sifra_m "currencyID"), TRIM (TO_CHAR (sum_tax_domval_l, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
           TaxSubtotals_l
         ),
         xmlelement ("cac:LegalMonetaryTotal",
           xmlelement ("cbc:LineExtensionAmount", xmlattributes (racval_sifra_l "currencyID"),
             TRIM (TO_CHAR (sum_taxable_racval_l, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
           xmlelement ("cbc:TaxExclusiveAmount", xmlattributes (racval_sifra_l "currencyID"),
             TRIM (TO_CHAR (ROUND (sum_neto_domval_l / rac_izn_tecaja_l, 2), '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
           xmlelement ("cbc:TaxInclusiveAmount", xmlattributes (racval_sifra_l "currencyID"),
             TRIM (TO_CHAR (racbruto_racval_l, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
           xmlelement ("cbc:ChargeTotalAmount", xmlattributes (racval_sifra_l "currencyID"),
             TRIM (TO_CHAR (ROUND ((charge_ppot_l + charge_pnaknada_l)/ rac_izn_tecaja_l, 2), '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
           xmlelement ("cbc:PrepaidAmount", xmlattributes (racval_sifra_l "currencyID"),
             TRIM (TO_CHAR (predujam_racval_l, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
           xmlelement ("cbc:PayableAmount", xmlattributes (racval_sifra_l "currencyID"),
             TRIM (TO_CHAR (rac_iznos_l, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,''')))
         )
    INTO OrderReference_l,
         BillingReference_l,
         DespatchDocumentReference_l,
         ReceiptDocumentReference_l,
         OriginatorDocumentReference_l,
         ContractDocumentReference_l,
         AdditionalDocumentReference_l,
         ProjectReference_l,
         InvoiceAllowanceCharge_l,
         InvoiceAllowanceCharge2_l,
         InvoiceTaxTotal_l,
         LegalMonetaryTotal_l
    FROM DUAL;

  IF tip_p = '1' THEN
    SELECT xmlelement ("cac:AdditionalDocRef",
             xmlelement ("cbc:ID", racblob.rac_id),
             xmlelement ("cbc:DocumentType", 'VIZUALIZACIJA IZVORNIKA RAUNA'),
             xmlelement ("cac:Attachment",
               -- xmlelement ("cbc:EmbeddedDocumentBinaryObject",      -- naziv je predug, vidi proceduru izradi_eracun_blob
               xmlelement ("cbc:EmbeddedDocument",
                 xmlattributes('application/pdf' "mimeCode",
                               racblob.opis "filename"),
                 pra_eracun.blob2base64 (racblob.datoteka)
                 )
               )
             )
      INTO EmbeddedDocumentBinaryObject_l
      FROM t_racuni_blob racblob
     WHERE UPPER (racblob.oznaka) = 'PDF'
       AND racblob.rac_id = rac_id_p
       AND racblob.status >= 0;
  END IF;

  SELECT xmlelement ("Invoice",
           xmlattributes ('urn:oasis:names:specification:ubl:schema:xsd:Invoice-2' "xmlns",
                        'urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2' "xmlns:cac",
                        'urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2' "xmlns:cbc",
                        'urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2' "xmlns:ext",
                        'urn:oasis:names:specification:ubl:schema:xsd:SignatureAggregateComponents-2' "xmlns:sac",
                        'urn:oasis:names:specification:ubl:schema:xsd:CommonSignatureComponents-2' "xmlns:sig",
                        'urn:oasis:names:specification:ubl:schema:xsd:SignatureBasicComponents-2' "xmlns:sbc"),
           xmlelement ("ext:UBLExtensions", xmlelement ("ext:UBLExtension", xmlelement ("ext:ExtensionContent", xmlelement ("sig:UBLDocumentSignatures", xmlelement ("sac:SignatureInformation"))))),
           xmlelement ("cbc:CustomizationID", 'urn:cen.eu:en16931:2017'),
           xmlelement ("cbc:ProfileID", 'P1'),
           /* Specifikacija, str. 2: 3.2 Podrani zahtjevi poslovnog procesa
             --
             P1 - Fakturiranje isporuka dobara i usluga preko narudbi na temelju ugovora
             P2 - Periodicno fakturiranje isporuka na temelju ugovora
             P3 - Fakturiranje isporuka preko nepredvidene narudbe
             P4 - Placanje predujma (avansno placanje)
             P5 - Placanje na licu mjesta
             P6 - Placanje prije isporuke na temelju narudbe
             P7 - Racuni s referencom na otpremnicu
             P8 - Racuni s referencom na otpremnicu i primku
             P9 - Odobrenje ili negativno fakturiranje
             P10 - Korektivno fakturiranje
             P11 - Parcijalno i zavrno fakturiranje
             P12 - Samoizdavanje racuna
           */
           xmlelement ("cbc:ID", jedinst_ozn_rac_l),
           xmlelement ("cbc:IssueDate", TO_CHAR (rac.unos_dat, 'RRRR-MM-DD')),
           xmlelement ("cbc:DueDate", TO_CHAR (rac.dat_dospijeca, 'RRRR-MM-DD')),
           xmlelement ("cbc:InvoiceTypeCode", '380'),
           /* Specifikacija, str. 23: iz liste UNTDID 1001
             --
             82 - Racun za mjerene usluge
             325 - Predracun
             326 - Parcijalni racun
             380 - Komercijalni racun
             381 - Odobrenje
             383 - Terecenje
             384 - Korektivni racun
             386 - Racun za predujam
             394 - Racun za leasing
           */
           xmlelement ("cbc:Note", 'Oznaka operatera: ' || rac.unos_korisnik),
           xmlelement ("cbc:Note", 'Vrijeme izdavanja: ' || TO_CHAR (rac.unos_dat, 'HH24:MI:SS')),
           xmlelement ("cbc:Note", 'Odgovorna osoba: ' || so.imep_direktora),
           DECODE (rac.napomena, NULL, NULL, xmlelement ("cbc:Note", rac.napomena)),
           /* Specifikacija, str. 26:
             "
             Primjer koritenja:
             <cbc:Note>operater1#Oznaka operatera</cbc:Note>
             <cbc:Note>15:02:23#Vrijeme izdavanja</cbc:Note>
             <cbc:Note>Ime i prezime#Odgovorna osoba</cbc:Note>
             Vano!!!
             S obzirom da u osnovnom modelu ne postoje pojmovi koji su u Hrvatskoj obavezni za unos
             (vrijeme izdavanja racuna i oznaka operatera) koristi se oznacavanje pomocu ifre predmeta
             kako je prikazano u primjeru. Vrijeme se upisuje u formatu hh:mm:ss.
             "
           */
           xmlelement ("cbc:DocumentCurrencyCode", racval_sifra_l),
           /* Specifikacija, str. 19:
             "
             U racunu ce se koristiti samo jedna valuta, osim za ukupni iznos PDV u racunovodstvenoj valuti (BT-111)
             u skladu s clankom 230 Direktive 2006/112 / EZ o PDV-u.
             Popisi vaecih valuta su registrirani kod ISO 4217 Agencije za odravanje "Kodovi za prezentiranje valuta i sredstava".
             "
           */
           -- xmlelement ("cbc:AccountingCost", 'Zagreb'),    --  mjesto troka (BT-19)
           DECODE (napomena_p, -- neka vrijednost koju izdavatelj racuna upisuje na zahtjev i za potrebe kupca
             NULL, NULL,
             xmlelement ("cbc:BuyerReference", napomena_p)),
           OrderReference_l,
           OriginatorDocumentReference_l,
           ContractDocumentReference_l,
           EmbeddedDocumentBinaryObject_l,
           ProjectReference_l,
           AccountingSupplierParty_l,
           AccountingCustomerParty_l,
           xmlelement ("cac:Delivery",
             xmlelement ("cbc:ActualDeliveryDate", TO_CHAR (rac.dat_nobveze, 'RRRR-MM-DD'))),
           PaymentMeans_l,
           InvoiceAllowanceCharge_l,
           InvoiceAllowanceCharge2_l,
           InvoiceTaxTotal_l,
           LegalMonetaryTotal_l,
           Invoice_l,
           InvoiceLines_l)
    INTO Invoice_l
    FROM t_racuni rac,
         m_so so
   WHERE rac.id = rac_id_p
     AND rac.so_id = so.id;

  IF tip_p = '1' THEN -- moj eracun
    SELECT xmltype ('<?xml version="1.0" encoding="UTF-8"?>' || Invoice_l.getclobval())
      INTO Invoice_l
      FROM dual;
  ELSIF tip_p = '3' THEN -- FINA
    SELECT xmltype ('<?xml version="1.0" encoding="utf-8" standalone="yes"?>' || Invoice_l.getclobval())
      INTO Invoice_l
      FROM dual;
  END IF;

  RETURN Invoice_l;
END;
PROCEDURE FINA_PKA_STAVKE_XML
 (PKARAC_ID_P IN tpka_racuni.id%TYPE
 ,STAVKEXML_P OUT XMLTYPE
 ,SUM_TAXABLE_RACVAL_P OUT tpka_racuni.iznos%TYPE
 )
 IS
-- poziva se iz fina_pka_invoice_xml
  InvoiceLines_l   XMLTYPE;
  i                NUMBER (2) := 0;
  oznaka_l         s_vapldok.oznaka%TYPE;
  rec_param_1037_l szmp_parametri.vrijednost%TYPE := UPPER (pra_rec_zaj.vrijednost_parametra ('1037'));

  rac_izn_tecaja_l t_racuni.izn_tecaja%TYPE;
  racval_sifra_l   s_valute.sifra_3a%TYPE;
  racval_id_l      t_racuni.val_id%TYPE;

  ruz_l            t_racuni.iznos%TYPE := 0;
BEGIN

  SELECT vdok.oznaka
    INTO oznaka_l
    FROM tpka_racuni rac, s_vapldok vdok
   WHERE rac.id = pkarac_id_p AND
         rac.vapldok_id = vdok.id;

  SELECT rac.izn_tecaja, val.sifra_3a, rac.val_id
    INTO rac_izn_tecaja_l, racval_sifra_l, racval_id_l
    FROM tpka_racuni rac,
         s_valute val
   WHERE rac.id = pkarac_id_p
     AND rac.val_id = val.id;

  pripremi_pka_tab_ruz (pkarac_id_p, rac_izn_tecaja_l);


  FOR stavke_c IN (
    SELECT pkaracisp.id AS id,
           pkaracisp.kolicina AS kolicina,
           pkaracisp.cijena AS cijena,
           pkaracisp.naziv AS naziv,
           /*ROUND (pkaracisp.cijena * pkaracisp.kolicina * 100 / (100 + vpispz.stopa), 2) AS osnovica,*/
           ROUND ((pkaracisp.cijena * pkaracisp.kolicina * 100 / (100 + vpispz.stopa))/rac_izn_tecaja_l, 2) AS osnovica,
           vpispz.stopa AS vpispz_stopa,
           vpispz.id AS vpispz_id,
           zmpspisp.sifra AS sk_sifra,
           val.sifra_3a AS racval_sifra
      FROM tpka_racuni pkarac,
           tpka_rac_isp pkaracisp,
           s_vpisporukaz vpispz,
           szmp_spisporuka zmpspisp,
           s_valute val
     WHERE pkarac.id = pkarac_id_p
       AND pkaracisp.pkarac_id = pkarac.id
       AND pkaracisp.vpispz_id = vpispz.id
       AND vpispz.zmpspisp_id = zmpspisp.id
       AND pkarac.val_id = val.id
     ORDER BY 1)
  LOOP
    -- rbr
    i := i + 1;

    ruz_l := iznos_rasporedi_ruz (stavke_c.vpispz_id);
    -- InvoiceLines_l
    SELECT xmlagg (
             xmlconcat (InvoiceLines_l,
               xmlelement ("cac:InvoiceLine",
                 xmlelement ("cbc:ID", TO_CHAR (i)),
                 xmlelement ("cbc:InvoicedQuantity",
                   xmlattributes ('H87' "unitCode"), stavke_c.kolicina),
                 xmlelement ("cbc:LineExtensionAmount",
                   xmlattributes (stavke_c.racval_sifra "currencyID"), TRIM (TO_CHAR (stavke_c.osnovica + ruz_l, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))
                 ),
                 xmlelement ("cac:Item",
                   xmlelement ("cbc:Description", stavke_c.naziv),
                   xmlelement ("cbc:Name", stavke_c.naziv),
                   xmlelement ("cac:ClassifiedTaxCategory",
                     xmlelement ("cbc:ID", DECODE (SUBSTR (stavke_c.sk_sifra, 1, 1), '1', 'E', 'S')),
                     xmlelement ("cbc:Percent", TRIM (TO_CHAR (stavke_c.vpispz_stopa, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                     xmlelement ("cac:TaxScheme",
                       xmlelement ("cbc:ID", 'VAT')
                     )
                   )
                 ),
                 xmlelement ("cac:Price",
                   xmlelement ("cbc:PriceAmount",
                     xmlattributes (stavke_c.racval_sifra "currencyID"), TRIM (TO_CHAR (stavke_c.cijena, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                   xmlelement ("cbc:BaseQuantity",
                     xmlattributes('H87' "unitCode"), '1.000'
                   )
                 )
               )
             )
           )
      INTO InvoiceLines_l
      FROM dual;

    sum_taxable_racval_p := NVL (sum_taxable_racval_p, 0) + stavke_c.osnovica + ruz_l;

  END LOOP;
  -- kraj stavke

  IF oznaka_l ='BI' THEN
      -- stavke internih POS rauna
    FOR gmpkas_c IN ( -- sve blagajne internih POS rauna povezanih na rac_id_p
      SELECT DISTINCT
             gmpkas.id AS gmpkas_id,
             gmpkas.naziv AS gmpkas_naziv
        FROM tpka_rnkasa pkarnk,
             mgmp_kase gmpkas
       WHERE pkarnk.pkarac_id = pkarac_id_p
         AND pkarnk.gmpkas_id = gmpkas.id)
    LOOP

      -- svaki interni POS raun (zbog REC parametra 1037 ili je jedini na toj blagajni)
      IF rec_param_1037_l = 'NE' OR rm_rec2250.br_redova_kase (pkarac_id_p, gmpkas_c.gmpkas_id) = 1 THEN

        FOR pkarnk_c IN (
          SELECT pkarnk.rbr || '/' || pkarnk.god_poslovna AS rnk,
                 TO_CHAR (pkarnk.datum, 'DD.MM.RRRR') AS datum,
                 DECODE (pkarnk.domval_id, racval_id_l, pkarnk.izn_placanja - pkarnk.izn_ppot,
                   ROUND ((pkarnk.izn_placanja - pkarnk.izn_ppot) / rac_izn_tecaja_l, 2)
                   ) AS iznos, -- u valuti rauna
                 ROUND (rnkpdv.izn_osnovice / rac_izn_tecaja_l, 2) AS izn_osn_racval,
                 rnkpdv.stopa_pdv AS stopa_porez,
                 rnkpdv.vpispz_id AS vpispz_id
            FROM tpka_rnkasa pkarnk,
                 ipka_rnk_pdv rnkpdv
           WHERE pkarnk.pkarac_id = pkarac_id_p
             AND pkarnk.gmpkas_id = gmpkas_c.gmpkas_id
             AND rnkpdv.pkarnk_id = pkarnk.id)
        LOOP

          -- rbr
          i := i + 1;
          ruz_l := iznos_rasporedi_ruz (pkarnk_c.vpispz_id);

          -- InvoiceLines_l
          SELECT xmlagg (
                   xmlconcat (InvoiceLines_l,
                     xmlelement ("cac:InvoiceLine",
                       xmlelement ("cbc:ID", TO_CHAR (i)),
                       xmlelement ("cbc:InvoicedQuantity",
                         xmlattributes ('H87' "unitCode"), '1' -- uvijek 1
                       ),
                       xmlelement ("cbc:LineExtensionAmount",
                         xmlattributes (racval_sifra_l "currencyID"),
                           TRIM (TO_CHAR (pkarnk_c.izn_osn_racval + ruz_l, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))
                       ),
                       xmlelement ("cac:Item",
                         xmlelement ("cbc:Description", gmpkas_c.gmpkas_naziv || ' - ' || pkarnk_c.rnk || ' (' || pkarnk_c.datum || ') - ' || pkarnk_c.stopa_porez || '%'
                         ),
                         xmlelement ("cbc:Name", gmpkas_c.gmpkas_naziv || ' - ' || pkarnk_c.rnk || ' ' || pkarnk_c.stopa_porez || '%'
                         ),
                         xmlelement ("cac:ClassifiedTaxCategory",
                           xmlelement ("cbc:ID", 'S'),
                           xmlelement ("cbc:Percent", TRIM (TO_CHAR (pkarnk_c.stopa_porez, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                           xmlelement ("cac:TaxScheme",
                             xmlelement ("cbc:ID", 'VAT')
                           )
                         )
                       ),
                       xmlelement ("cac:Price",
                         xmlelement ("cbc:PriceAmount",
                           xmlattributes (racval_sifra_l "currencyID"), TRIM (TO_CHAR (ABS (pkarnk_c.iznos), '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                         xmlelement ("cbc:BaseQuantity",
                           xmlattributes ('H87' "unitCode"), '1.000')
                       )
                     )
                   )
                 )
            INTO InvoiceLines_l
            FROM dual;

          sum_taxable_racval_p := NVL (sum_taxable_racval_p, 0) + pkarnk_c.izn_osn_racval + ruz_l;

        END LOOP;

      ELSE
        -- svi interni POS rauni jedne blagajne u jednom retku
        FOR pkarnk_c IN (
          SELECT COUNT (1) AS rnk,
               TO_CHAR (MIN (pkarnk.datum), 'DD.MM.RRRR') || ' - ' ||
                   TO_CHAR (MAX (pkarnk.datum), 'DD.MM.RRRR') AS datum,
                 SUM (
                   DECODE (pkarnk.domval_id, racval_id_l, pkarnk.izn_placanja - pkarnk.izn_ppot,
                     ROUND ((pkarnk.izn_placanja - pkarnk.izn_ppot) / rac_izn_tecaja_l, 2))
                   ) AS iznos, -- u valuti rauna
                 SUM (ROUND (rnkpdv.izn_osnovice / rac_izn_tecaja_l, 2)) AS izn_osn_racval,
                 MIN (rnkpdv.stopa_pdv) AS stopa_porez,
                 rnkpdv.vpispz_id AS vpispz_id
            FROM tpka_rnkasa pkarnk,
                 ipka_rnk_pdv rnkpdv
           WHERE pkarnk.pkarac_id = pkarac_id_p
             AND pkarnk.gmpkas_id = gmpkas_c.gmpkas_id
             AND rnkpdv.pkarnk_id = pkarnk.id
           GROUP BY rnkpdv.vpispz_id, pkarnk.id)
        LOOP

          -- rbr
          i := i + 1;

          ruz_l := iznos_rasporedi_ruz (pkarnk_c.vpispz_id);

          -- InvoiceLines_l
          SELECT xmlagg (
                   xmlconcat (InvoiceLines_l,
                     xmlelement ("cac:InvoiceLine",
                       xmlelement ("cbc:ID", TO_CHAR (i)),
                       xmlelement ("cbc:InvoicedQuantity",
                         xmlattributes ('H87' "unitCode",
                                       'UN/ECE rec 20 8e' "unitCodeListID",
                                       '6' "unitCodeListAgencyID"), '1' -- uvijek 1
                       ),
                       xmlelement ("cbc:LineExtensionAmount",
                         xmlattributes (racval_sifra_l "currencyID"),
                           TRIM (TO_CHAR (pkarnk_c.izn_osn_racval /*+ ruz_l*/, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))
                       ),
                       xmlelement ("cac:Item",
                         xmlelement ("cbc:Description", gmpkas_c.gmpkas_naziv || ' - ' || pkarnk_c.rnk || ' (' || pkarnk_c.datum || ') - ' || pkarnk_c.stopa_porez || '%'
                       ),
                       xmlelement ("cbc:Name", gmpkas_c.gmpkas_naziv || ' - ' || pkarnk_c.rnk || ' ' || pkarnk_c.stopa_porez || '%'
                       ),
                       xmlelement ("cac:ClassifiedTaxCategory",
                         xmlelement ("cbc:ID", 'S'),
                         xmlelement ("cbc:Percent", TRIM (TO_CHAR (pkarnk_c.stopa_porez, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                         xmlelement ("cac:TaxScheme",
                           xmlelement ("cbc:ID", 'VAT')
                         )
                       )
                     ),
                     xmlelement ("cac:Price",
                       xmlelement ("cbc:PriceAmount",
                         xmlattributes (racval_sifra_l "currencyID"), TRIM (TO_CHAR (ABS (pkarnk_c.iznos), '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                       xmlelement ("cbc:BaseQuantity",
                         xmlattributes ('H87' "unitCode"), '1.000')
                     )
                   )
                 )
               )
          INTO InvoiceLines_l
          FROM dual;

        sum_taxable_racval_p := NVL (sum_taxable_racval_p, 0) + pkarnk_c.izn_osn_racval + ruz_l;

      END LOOP;
    END IF;

  END LOOP;
  -- kraj stavke internih POS rauna


  -- stavke otpremnice
  FOR stavke_otp_c IN (
    SELECT dokart.id AS id,
           dokart.kolicina AS kolicina,
           ROUND((dokart.PROD_CIJENA  -  ( dokart.PROD_CIJENA *dokart.RABAT/100 )),2) AS cijena,
           pro.naziv AS naziv,
           ROUND (dokart.prod_cijena * dokart.kolicina * (1 - dokart.rabat / 100) , 2) osnovica,
           vpispz.stopa AS vpispz_stopa,
           vpispz.id AS vpispz_id,
           zmpspisp.sifra AS sk_sifra,
           val.sifra_3a AS racval_sifra,
           rownum rn,
           count(*) over (partition by 1) as cnt
     FROM
           tgas_izlazdok dok,
           tgas_izlazdok_art dokart,
           tpka_racuni pkarac,
           tpka_rac_gasizldok racgasdok,
           s_vpisporukaz vpispz,
           szmp_spisporuka zmpspisp,
           m_proizvodi pro,
           s_valute val
     WHERE
           pkarac.id = pkarac_id_p AND
           pkarac.val_id = val.id AND
           racgasdok.pkarac_id = pkarac.id AND
           racgasdok.gasizldok_id = dok.id AND
           dokart.gasizldok_id = dok.id AND
           dokart.vpispz_id = vpispz.id AND
           vpispz.zmpspisp_id = zmpspisp.id AND
           dokart.pro_id = pro.id )
  LOOP
    -- rbr
    i := i + 1;

    ruz_l := iznos_rasporedi_ruz (stavke_otp_c.vpispz_id);
    -- InvoiceLines_l
    SELECT xmlagg (
             xmlconcat (InvoiceLines_l,
               xmlelement ("cac:InvoiceLine",
                 xmlelement ("cbc:ID", TO_CHAR (i)),
                 xmlelement ("cbc:InvoicedQuantity",
                   xmlattributes ('H87' "unitCode"), stavke_otp_c.kolicina),
                 xmlelement ("cbc:LineExtensionAmount",
                   xmlattributes (stavke_otp_c.racval_sifra "currencyID"), TRIM (TO_CHAR (stavke_otp_c.osnovica + ruz_l, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))
                 ),
                 xmlelement ("cac:Item",
                   xmlelement ("cbc:Description", stavke_otp_c.naziv),
                   xmlelement ("cbc:Name", stavke_otp_c.naziv),
                   xmlelement ("cac:ClassifiedTaxCategory",
                     xmlelement ("cbc:ID", DECODE (SUBSTR (stavke_otp_c.sk_sifra, 1, 1), '1', 'E', 'S')),
                     xmlelement ("cbc:Percent", TRIM (TO_CHAR (stavke_otp_c.vpispz_stopa, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                     xmlelement ("cac:TaxScheme",
                       xmlelement ("cbc:ID", 'VAT')
                     )
                   )
                 ),
                 xmlelement ("cac:Price",
                   xmlelement ("cbc:PriceAmount",
                     xmlattributes (stavke_otp_c.racval_sifra "currencyID"), TRIM (TO_CHAR (stavke_otp_c.cijena, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                   xmlelement ("cbc:BaseQuantity",
                     xmlattributes('H87' "unitCode"), '1.000'
                   )
                 )
               )
             )
           )
      INTO InvoiceLines_l
      FROM dual;

    sum_taxable_racval_p := NVL (sum_taxable_racval_p, 0) + stavke_otp_c.osnovica + ruz_l;

  END LOOP;
  -- kraj stavke otpremnice

  END IF;

  stavkexml_p := InvoiceLines_l;
END;
PROCEDURE FINA_PKA_TAXES_XML
 (PKARAC_ID_P IN tpka_racuni.id%TYPE
 ,TAXSUBTOTALS_P OUT XMLTYPE
 ,SUM_TAX_DOMVAL_P OUT tpka_racuni.iznos%TYPE
 ,SUM_NETO_DOMVAL_P OUT tpka_racuni.iznos%TYPE
 ,CHARGE_PPOT_P OUT T_RACUNI.IZNOS%TYPE
 ,CHARGE_PNAKNADA_P OUT T_RACUNI.IZNOS%TYPE
 )
 IS
-- poziva se iz fina_pka_invoice_xml
  TaxSubtotals_l XMLTYPE;
  napomenaBP_l   m_vnapomena.napomena%TYPE := 'ne podlijee oporezivanju';
  oznaka_l       s_vapldok.oznaka%TYPE;
BEGIN

  SELECT vdok.oznaka 
    INTO oznaka_l 
    FROM tpka_racuni rac, s_vapldok vdok
   WHERE rac.id = pkarac_id_p AND
         rac.vapldok_id = vdok.id;
  SELECT
    xmlagg (
      xmlelement ("cac:TaxSubtotal",
        xmlelement ("cbc:TaxableAmount",
          xmlattributes (domval_sifra_m "currencyID"), TRIM (TO_CHAR (osnovica, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
        xmlelement ("cbc:TaxAmount",
          xmlattributes (domval_sifra_m "currencyID"), TRIM (TO_CHAR (porez, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
        xmlelement ("cac:TaxCategory",
          xmlelement ("cbc:ID", DECODE (sub_sk_sifra, '1', 'E', 'S')),
          xmlelement ("cbc:Percent", TRIM (TO_CHAR (stopa, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
          DECODE (sub_sk_sifra, '1', xmlelement ("cbc:TaxExemptionReason", napomenaBP_l), NULL),
          xmlelement ("cac:TaxScheme",
            xmlelement ("cbc:ID", 'VAT')  -- DECODE (sub_sk_sifra, '1', 'FRE', 'VAT'))
          )
        )
      )
    ),
    SUM (porez),
    SUM (osnovica),
    SUM (izn_ppot),
    SUM (izn_pnaknade)
  INTO
    TaxSubtotals_p,
    sum_tax_domval_p,
    sum_neto_domval_p,
    charge_ppot_p,
    charge_pnaknada_p
  FROM
    (
    SELECT
      stopa,
      SUBSTR (sk_sifra, 1, 1) AS sub_sk_sifra,
      SUM (neto) AS osnovica,
      SUM (pdv) AS porez,
      SUM (DECODE (ppot, 1, neto, 0)) AS izn_ppot,
      SUM (DECODE (povratna_naknada, 1, neto, 0)) AS izn_pnaknade
    FROM
      (
      SELECT
        zmpspisp.naziv AS naziv,
        zmpspisp.sifra AS sk_sifra,
        ROUND (pkaracpdv.iznos, 2) AS neto,
        pkaracpdv.stopa_pdv AS stopa,
        pkaracpdv.izn_domval - ROUND (pkaracpdv.iznos, 2) AS pdv,
        0 AS ppot,
        0 AS povratna_naknada
      FROM
        ipka_rac_pdv pkaracpdv,
        s_vpisporukaz vpispz,
        szmp_spisporuka zmpspisp
      WHERE
        pkaracpdv.pkarac_id = pkarac_id_p
        AND vpispz.id = pkaracpdv.vpispz_id
        AND zmpspisp.id = vpispz.zmpspisp_id
      UNION ALL
      SELECT
         NULL,
        '10',
        SUM (izn_ppot),
        0,
        0,
        1,
        0
      FROM
        tpka_rnkasa
      WHERE
        oznaka_l = 'BI' AND
        pkarac_id = pkarac_id_p
        AND NVL (stopa_ppot, 0) <> 0
      HAVING SUM (izn_ppot) <> 0        
      GROUP BY
        stopa_ppot
      UNION ALL
      SELECT
        NULL,
        '10',
        SUM (izn_pnaknade),
        0,
        0,
        0,
        1
      FROM
        tpka_rnkasa
      WHERE
        oznaka_l = 'BI' AND
        pkarac_id = pkarac_id_p
        AND NVL (izn_pnaknade, 0) <> 0
      HAVING SUM (izn_pnaknade) <> 0        
      )
    GROUP BY stopa, SUBSTR (sk_sifra, 1, 1)
    )
  ORDER BY stopa;
END;
PROCEDURE FINA_PKA_CUSTOMER_XML
 (PKARAC_ID_P IN tpka_racuni.id%TYPE
 ,ACCOUNTINGCUSTOMERPARTY_P OUT XMLTYPE
 ,BUYERID_P OUT VARCHAR2
 )
 IS
-- Poziva se iz fina_pka_invoice_xml
BEGIN
  SELECT
    xmlelement ("cac:AccountingCustomerParty",
      xmlelement ("cac:Party",
        xmlelement ("cbc:EndpointID", xmlattributes ('9934' "schemeID"), gmpkom.CompanyID),
        xmlelement ("cac:PartyIdentification",
          xmlelement ("cbc:ID", '9934:' || gmpkom.CompanyID || DECODE (gmpkom.sifra_pj, NULL, NULL, '::HR99:' || gmpkom.sifra_pj)
          )
        ),
        xmlelement ("cac:PostalAddress",
          xmlelement ("cbc:StreetName", gmpkom.naz_ulice),
          xmlelement ("cbc:CityName", gmpkom.pos_naziv),
          xmlelement ("cbc:PostalZone", gmpkom.pos_broj),
          xmlelement ("cac:Country",
            xmlelement ("cbc:IdentificationCode", gmpkom.zem_sifra_2a)
          )
        ),
        xmlelement ("cac:PartyTaxScheme",
          xmlelement ("cbc:CompanyID", gmpkom.br_porezni),
          xmlelement ("cac:TaxScheme",
            xmlelement ("cbc:ID", 'VAT')
          )
        ),
        xmlelement ("cac:PartyLegalEntity",
          xmlelement ("cbc:RegistrationName", gmpkom.naziv),
          xmlelement ("cbc:CompanyID", gmpkom.CompanyID) -- IRN 3606
        ),
        xmlelement ("cac:Contact",
          xmlelement ("cbc:Name", gmpkom.imep_osobeodg), -- IRN 3606
          xmlelement ("cbc:ElectronicMail", gmpkom.email) -- IRN 3606
        )
      )
    ),
    '9934:' || gmpkom.br_porezni
  INTO
    AccountingCustomerParty_p,
    buyerid_p
  FROM
    tpka_racuni pkarac,
    (
    SELECT
      gmpkom2.id AS id,
      DECODE (zem.sifra_2a, domzem_sifra_m, domzem_sifra_m || gmpkom2.oib, gmpkom2.br_porezni) AS br_porezni,
      DECODE (zem.sifra_2a, domzem_sifra_m, gmpkom2.oib, gmpkom2.br_porezni) AS CompanyID, -- IRN 3606; bez prefiksa zemlje
      gmpkom2.sifra_pj AS sifra_pj,
      gmpkom2.naz_ulice AS naz_ulice,
      pos.naziv AS pos_naziv,
      pos.broj AS pos_broj,
      zem.sifra_2a AS zem_sifra_2a,
      gmpkom2.naziv AS naziv,
      gmpkom2.imep_osobeodg AS imep_osobeodg, -- IRN 3606
      gmpkom2.email AS email -- IRN 3606
    FROM
      mgmp_komitenti gmpkom2,
      s_zemlje zem,
      m_poste pos
    WHERE
      gmpkom2.zem_id = zem.id
      AND gmpkom2.pos_id = pos.id (+)
    ) gmpkom
  WHERE
    pkarac.id = pkarac_id_p
    AND pkarac.gmpkom_id = gmpkom.id;
END;
FUNCTION FINA_PKA_INVOICE_XML
 (PKARAC_ID_P IN tpka_racuni.id%TYPE
 ,ZAH_PONUDA_P IN VARCHAR2 := NULL
 ,NARUDZBENICA_P IN VARCHAR2 := NULL
 ,UGOVOR_P IN VARCHAR2 := NULL
 ,PROJEKT_P IN VARCHAR2 := NULL
 ,NAPOMENA_P IN VARCHAR2 := NULL
 ,TIP_P IN VARCHAR2
 )
 RETURN XMLTYPE
 IS
--
  OrderReference_l               XMLTYPE;
  BillingReference_l             XMLTYPE;
  DespatchDocumentReference_l    XMLTYPE;
  ReceiptDocumentReference_l     XMLTYPE;
  OriginatorDocumentReference_l  XMLTYPE;
  ContractDocumentReference_l    XMLTYPE;
  AdditionalDocumentReference_l  XMLTYPE;
  ProjectReference_l             XMLTYPE;
  AccountingSupplierParty_l      XMLTYPE;
  AccountingCustomerParty_l      XMLTYPE;
  PaymentMeans_l                 XMLTYPE;
  InvoiceTaxTotal_l              XMLTYPE;
  LegalMonetaryTotal_l           XMLTYPE;
  EmbeddedDocumentBinaryObject_l XMLTYPE;

  Invoice_l                      XMLTYPE;
  InvoiceLines_l                 XMLTYPE;
  TaxSubtotals_l                 XMLTYPE;
  InvoiceAllowanceCharge_l       XMLTYPE;
  InvoiceAllowanceCharge2_l      XMLTYPE;

  sum_taxable_racval_l           tpka_racuni.iznos%TYPE;

  sum_neto_domval_l              tpka_racuni.iznos%TYPE;
  sum_tax_domval_l               tpka_racuni.iznos%TYPE;
  predujam_racval_l              tpka_racuni.iznos%TYPE;


  charge_ppot_l                  tpka_racuni.iznos%TYPE;
  charge_pnak_l                  tpka_racuni.iznos%TYPE;

  rac_iznos_l                    tpka_racuni.iznos%TYPE;

  supplierId_l                   VARCHAR2(30);
  buyerId_l                      VARCHAR2(30);

  jedinst_ozn_rac_l              VARCHAR2(30);
  racval_sifra_l                 s_valute.sifra_3a%TYPE;
  rac_izn_tecaja_l               tpka_racuni.izn_tecaja%TYPE;

  -- IRN 3606
  urac_id_l                      m_uracuni.id%TYPE;
  poziv_na_broj_l                tpka_racuni.poziv_na_broj%TYPE;
  raci_id_l                      tpka_racuni.raci_id%TYPE;
  pkaraci_id_l                   tpka_racuni.pkaraci_id%TYPE;
  iban_l                         m_uracuni.iban%TYPE;
BEGIN
  -- https://prez.fina.hr/SendB2BOutgoingInvoicePKIWebService/services/SendB2BOutgoingInvoicePKIWebService

  IF pkarac_id_p IS NULL THEN
    RETURN NULL;
  END IF;

  SELECT xmlelement ("cac:AccountingSupplierParty",
           xmlelement ("cac:Party",
             xmlelement ("cbc:EndpointID", xmlattributes('9934' "schemeID"), vla.oib),
             xmlelement ("cac:PartyIdentification",
               xmlelement ("cbc:ID", '9934:' || vla.oib)
             ),
             xmlelement ("cac:PostalAddress",
               xmlelement ("cbc:StreetName", zmpojr.naz_ulice),
               xmlelement ("cbc:BuildingNumber", zmpojr.br_kucni),
               xmlelement ("cbc:CityName", pos.naziv),
               xmlelement ("cbc:PostalZone", pos.broj),
               xmlelement ("cac:Country",
                 xmlelement ("cbc:IdentificationCode", domzem_sifra_m)
               )
             ),
             xmlelement ("cac:PartyTaxScheme",
               xmlelement ("cbc:CompanyID", domzem_sifra_m || vla.oib),
               xmlelement ("cac:TaxScheme",
                 xmlelement ("cbc:ID", 'VAT')
               )
             ),
             xmlelement ("cac:PartyLegalEntity",
               xmlelement ("cbc:RegistrationName", vla.naziv)
             )
           )
         ),
         -- IRN 3606
         vapldok.urac_id,
         pkarac.poziv_na_broj,
         pkarac.raci_id,
         pkarac.pkaraci_id,
         -- KRAJ IRN 3606
         '9934:' || vla.oib,
         pkarac.god_poslovna || '-' || pkarac.rbr || '-' || pkarac.oj_sifra || '-' || pkarac.vdok_sifra2n,
         pkarac.iznos,
         val.sifra_3a,
         pkarac.izn_tecaja,
         SUM (ROUND (pkaracpred.iznos * pkaracpred.izn_tecaja / pkarac.izn_tecaja, 2)) AS pkaracpred_iznos
    INTO AccountingSupplierParty_l,
         urac_id_l,
         poziv_na_broj_l,
         raci_id_l,
         pkaraci_id_l,
         supplierId_l,
         jedinst_ozn_rac_l,
         rac_iznos_l,
         racval_sifra_l,
         rac_izn_tecaja_l,
         predujam_racval_l
    FROM tpka_racuni pkarac,
         s_vapldok vapldok,
         mzmp_ojr zmpojr,
         m_poste pos,
         s_vlasnik vla,
         s_valute val,
         tpka_rac_pred pkaracpred         
   WHERE pkarac.id = pkarac_id_p
     AND vapldok.id = pkarac.vapldok_id
     AND zmpojr.id = pkarac.oj_id
     AND pos.id = zmpojr.pos_id
     AND pkarac.val_id = val.id
     AND pkaracpred.pkarac_id (+) = pkarac.id
GROUP BY 
 vla.naziv, pos.naziv, pos.broj, zmpojr.br_kucni, zmpojr.naz_ulice, vla.oib,
         vapldok.urac_id,
         pkarac.poziv_na_broj,
         pkarac.raci_id,
         pkarac.pkaraci_id,
         -- KRAJ IRN 3606
         '9934:' || vla.oib,
         pkarac.god_poslovna || '-' || pkarac.rbr || '-' || pkarac.oj_sifra || '-' || pkarac.vdok_sifra2n,
         pkarac.iznos,
         val.sifra_3a,
         pkarac.izn_tecaja;
     

  /*
  IRN 3606
  Ako vrsta apl dokumenata BP nema upisan uplatni raun, onda se kod slanja e-rauna za iskoriteni predujam javlja greka
  [BR-50]-A Payment account identifier (BT-84) shall be present if Credit transfer (BG-17) information is provided in the Invoice.
  zato se uplatni raun ovdje ita iz povezanog rauna za isporuku
  */
  IF urac_id_l IS NULL AND (raci_id_l IS NOT NULL OR pkaraci_id_l IS NOT NULL) THEN

    SELECT MIN (urac_id)
      INTO urac_id_l
      FROM (
           SELECT urac_id FROM t_racuni WHERE id = raci_id_l
           UNION
           SELECT urac_id FROM tpka_racuni WHERE id = pkaraci_id_l
           );

  END IF;

  SELECT MIN (iban) INTO iban_l FROM m_uracuni WHERE id = urac_id_l;

  SELECT xmlelement ("cac:PaymentMeans",
           xmlelement ("cbc:PaymentMeansCode", 30),
             /* Specifikacija, str. 67:
               10 - Gotovina
               30 - Kreditni transfer
               48 - Bankovna kartica
               49 - Izravno tereenje
             */
             DECODE (poziv_na_broj_l, NULL, NULL, xmlelement ("cbc:PaymentID", 'HR99' || ' ' || poziv_na_broj_l)),
           xmlelement ("cac:PayeeFinancialAccount",
             xmlelement ("cbc:ID", TRANSLATE (iban_l, 'A' || chr(9) || chr(10) || chr(11) || chr(12) || chr(13) || chr(32), 'A'))
           )
         )
  INTO
    PaymentMeans_l
  FROM
    dual;

  fina_pka_customer_xml (pkarac_id_p, AccountingCustomerParty_l, buyerId_l);
  fina_pka_taxes_xml (pkarac_id_p, TaxSubtotals_l, sum_tax_domval_l, sum_neto_domval_l, charge_ppot_l, charge_pnak_l);
  fina_pka_stavke_xml (pkarac_id_p, InvoiceLines_l, sum_taxable_racval_l);

  SELECT DECODE (narudzbenica_p,                        -- narudbenica
           NULL, NULL,
           xmlelement ("cac:OrderReference",
             xmlelement ("cbc:ID", narudzbenica_p))),
         xmlelement ("cac:BillingReference",            -- prethodni racun (u slucaju:
           xmlelement ("cac:InvoiceDocumentReference",  -- - ispravljen je prethodni racun
             xmlelement ("cbc:ID", '')                  -- - prethodni djelomicni racuni se referenciraju iz konacnog racuna
           )                                            -- - prethodni racuni za predujam se referenciraju iz konacnog racuna
         ),
         xmlelement ("cac:DespatchDocumentReference",   -- otpremnica
           xmlelement ("cbc:ID", '')),
         xmlelement ("cac:ReceiptDocumentReference",    -- primka
           xmlelement ("cbc:ID", '')),
         DECODE (zah_ponuda_p,                          -- zahtjev za ponudu
           NULL, NULL,
           xmlelement ("cac:OriginatorDocRef",
             xmlelement ("cbc:ID", zah_ponuda_p))),
         DECODE (ugovor_p,                              -- ugovor
           NULL, NULL,
           xmlelement ("cac:ContractDocumentReference",
             xmlelement ("cbc:ID", ugovor_p))),
         xmlelement ("cac:AdditionalDocRef",            -- identifikator fakturiranog objekta (pretplatnicki broj, telefonski broj, mjesto mjerenja, vozilo, osoba itd.)
           xmlelement ("cbc:ID", '')),
         DECODE (projekt_p,                             -- projekt
           NULL, NULL,
           xmlelement ("cac:ProjectReference",
             xmlelement ("cbc:ID", projekt_p))),
         DECODE (NVL (charge_ppot_l, 0),
                0, NULL,
                xmlelement ("cac:AllowanceCharge",
                  xmlelement ("cbc:ChargeIndicator", 'true'),
                  xmlelement ("cbc:AllowanceChargeReason", pra_zmp_zaj.poruka ('ZMP', 'III0083')), -- porez na potronju
                  xmlelement ("cbc:Amount", xmlattributes (domval_sifra_m "currencyID"), TRIM (TO_CHAR (charge_ppot_l, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                  xmlelement ("cac:TaxCategory",
                    xmlelement ("cbc:ID", 'E'),
                    xmlelement ("cbc:Percent", TRIM (TO_CHAR (0, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                    xmlelement ("cac:TaxScheme",
                      xmlelement ("cbc:ID", 'VAT')
                    )
                  )
                )),
         DECODE (NVL (charge_pnak_l, 0),
                0, NULL,
                xmlelement ("cac:AllowanceCharge",
                  xmlelement ("cbc:ChargeIndicator", 'true'),
                  xmlelement ("cbc:AllowanceChargeReason", 'Povratna naknada'), -- povratna naknada
                  xmlelement ("cbc:MultiplierFactorNumeric", '20'),
                  xmlelement ("cbc:Amount", xmlattributes (domval_sifra_m "currencyID"), TRIM (TO_CHAR (charge_pnak_l, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                  xmlelement ("cbc:BaseAmount", xmlattributes (domval_sifra_m "currencyID"), TRIM (TO_CHAR (sum_neto_domval_l, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                  xmlelement ("cac:TaxCategory",
                    xmlelement ("cbc:ID", 'E'),
                    xmlelement ("cbc:Percent", TRIM (TO_CHAR (0, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
                    xmlelement ("cac:TaxScheme",
                      xmlelement ("cbc:ID", 'VAT')
                    )
                  )
                )),             
         xmlelement ("cac:TaxTotal",
           xmlelement ("cbc:TaxAmount", xmlattributes (domval_sifra_m "currencyID"), TRIM (TO_CHAR (sum_tax_domval_l, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
           TaxSubtotals_l
         ),
         xmlelement ("cac:LegalMonetaryTotal",
           xmlelement ("cbc:LineExtensionAmount", xmlattributes (racval_sifra_l "currencyID"),
             TRIM (TO_CHAR (sum_taxable_racval_l, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
           xmlelement ("cbc:TaxExclusiveAmount", xmlattributes (racval_sifra_l "currencyID"),
             TRIM (TO_CHAR (ROUND (sum_neto_domval_l / rac_izn_tecaja_l, 2), '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
           xmlelement ("cbc:TaxInclusiveAmount", xmlattributes (racval_sifra_l "currencyID"),
             TRIM (TO_CHAR (rac_iznos_l + NVL(predujam_racval_l,0), '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
           xmlelement ("cbc:ChargeTotalAmount", xmlattributes (racval_sifra_l "currencyID"),
             TRIM (TO_CHAR (ROUND ((charge_ppot_l + charge_pnak_l)/ rac_izn_tecaja_l, 2), '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,'''))),
           DECODE(NVL(predujam_racval_l,0), 0, NULL, xmlelement ("cbc:PrepaidAmount", xmlattributes (racval_sifra_l "currencyID"),
             TRIM (TO_CHAR (predujam_racval_l, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,''')))),
           xmlelement ("cbc:PayableAmount", xmlattributes (racval_sifra_l "currencyID"),
             TRIM (TO_CHAR (rac_iznos_l, '9999999999999990D99', 'NLS_NUMERIC_CHARACTERS=''.,''')))
         )
    INTO OrderReference_l,
         BillingReference_l,
         DespatchDocumentReference_l,
         ReceiptDocumentReference_l,
         OriginatorDocumentReference_l,
         ContractDocumentReference_l,
         AdditionalDocumentReference_l,
         ProjectReference_l,
         InvoiceAllowanceCharge_l,
         InvoiceAllowanceCharge2_l,
         InvoiceTaxTotal_l,
         LegalMonetaryTotal_l
    FROM DUAL;

  IF tip_p = '1' THEN
    SELECT xmlelement ("cac:AdditionalDocRef",
             xmlelement ("cbc:ID", racblob.pkarac_id),
             xmlelement ("cbc:DocumentType", 'VIZUALIZACIJA IZVORNIKA RAUNA'),
             xmlelement ("cac:Attachment",
               -- xmlelement ("cbc:EmbeddedDocumentBinaryObject",      -- naziv je predug, vidi proceduru izradi_eracun_blob
               xmlelement ("cbc:EmbeddedDocument",
                 xmlattributes('application/pdf' "mimeCode",
                               racblob.opis "filename"),
                 pra_eracun.blob2base64 (racblob.datoteka)
                 )
               )
             )
      INTO EmbeddedDocumentBinaryObject_l
      FROM t_racuni_blob racblob
     WHERE UPPER (racblob.oznaka) = 'PDF'
       AND racblob.pkarac_id = pkarac_id_p
       AND racblob.status >= 0;
  END IF;

  SELECT xmlelement ("Invoice",
           xmlattributes ('urn:oasis:names:specification:ubl:schema:xsd:Invoice-2' "xmlns",
                        'urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2' "xmlns:cac",
                        'urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2' "xmlns:cbc",
                        'urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2' "xmlns:ext",
                        'urn:oasis:names:specification:ubl:schema:xsd:SignatureAggregateComponents-2' "xmlns:sac",
                        'urn:oasis:names:specification:ubl:schema:xsd:CommonSignatureComponents-2' "xmlns:sig",
                        'urn:oasis:names:specification:ubl:schema:xsd:SignatureBasicComponents-2' "xmlns:sbc"),
           xmlelement ("cbc:CustomizationID", 'urn:cen.eu:en16931:2017'),
           xmlelement ("cbc:ProfileID", 'P4'),
           /* Specifikacija, str. 2: 3.2 Podrani zahtjevi poslovnog procesa
             --
             P1 - Fakturiranje isporuka dobara i usluga preko narudbi na temelju ugovora
             P2 - Periodicno fakturiranje isporuka na temelju ugovora
             P3 - Fakturiranje isporuka preko nepredvidene narudbe
             P4 - Placanje predujma (avansno placanje)
             P5 - Placanje na licu mjesta
             P6 - Placanje prije isporuke na temelju narudbe
             P7 - Racuni s referencom na otpremnicu
             P8 - Racuni s referencom na otpremnicu i primku
             P9 - Odobrenje ili negativno fakturiranje
             P10 - Korektivno fakturiranje
             P11 - Parcijalno i zavrno fakturiranje
             P12 - Samoizdavanje racuna
           */
           xmlelement ("cbc:ID", jedinst_ozn_rac_l),
           xmlelement ("cbc:IssueDate", TO_CHAR (pkarac.unos_dat, 'rrrr-mm-dd')),
           xmlelement ("cbc:DueDate", TO_CHAR (NVL (pkarac.dat_dospijeca, pkarac.datum), 'rrrr-mm-dd')),
           xmlelement ("cbc:InvoiceTypeCode", '380'),
           /* Specifikacija, str. 23: iz liste UNTDID 1001
             --
             82 - Racun za mjerene usluge
             325 - Predracun
             326 - Parcijalni racun
             380 - Komercijalni racun
             381 - Odobrenje
             383 - Terecenje
             384 - Korektivni racun
             386 - Racun za predujam
             394 - Racun za leasing
           */
           xmlelement ("cbc:Note", 'Oznaka operatera: ' || pkarac.unos_korisnik),
           xmlelement ("cbc:Note", 'Vrijeme izdavanja: ' || TO_CHAR(pkarac.unos_dat, 'HH24:MI:SS')),
           xmlelement ("cbc:Note", 'Odgovorna osoba: ' || zmpojr.imep_direktora),
           DECODE (pkarac.napomena, NULL, NULL, xmlelement ("cbc:Note", pkarac.napomena)),
           /* Specifikacija, str. 26:
             "
             Primjer koritenja:
             <cbc:Note>operater1#Oznaka operatera</cbc:Note>
             <cbc:Note>15:02:23#Vrijeme izdavanja</cbc:Note>
             <cbc:Note>Ime i prezime#Odgovorna osoba</cbc:Note>
             Vano!!!
             S obzirom da u osnovnom modelu ne postoje pojmovi koji su u Hrvatskoj obavezni za unos
             (vrijeme izdavanja racuna i oznaka operatera) koristi se oznacavanje pomocu ifre predmeta
             kako je prikazano u primjeru. Vrijeme se upisuje u formatu hh:mm:ss.
             "
           */
           xmlelement ("cbc:DocumentCurrencyCode", racval_sifra_l),
           /* Specifikacija, str. 19:
             "
             U racunu ce se koristiti samo jedna valuta, osim za ukupni iznos PDV u racunovodstvenoj valuti (BT-111)
             u skladu s clankom 230 Direktive 2006/112 / EZ o PDV-u.
             Popisi vaecih valuta su registrirani kod ISO 4217 Agencije za odravanje "Kodovi za prezentiranje valuta i sredstava".
             "
           */
           -- xmlelement ("cbc:AccountingCost", 'Zagreb'),    --  mjesto troka (BT-19)
           DECODE (napomena_p, -- neka vrijednost koju izdavatelj racuna upisuje na zahtjev i za potrebe kupca
             NULL, NULL,
             xmlelement ("cbc:BuyerReference", napomena_p)),
           OrderReference_l,
           OriginatorDocumentReference_l,
           ContractDocumentReference_l,
           EmbeddedDocumentBinaryObject_l,
           ProjectReference_l,
           AccountingSupplierParty_l,
           AccountingCustomerParty_l,
           xmlelement ("cac:Delivery",
             xmlelement ("cbc:ActualDeliveryDate", TO_CHAR (pkarac.dat_nobveze, 'RRRR-MM-DD'))),
           PaymentMeans_l,
           InvoiceAllowanceCharge_l,
           InvoiceAllowanceCharge2_l,
           InvoiceTaxTotal_l,
           LegalMonetaryTotal_l,
           Invoice_l,
           InvoiceLines_l)
    INTO Invoice_l
    FROM tpka_racuni pkarac,
         mzmp_ojr zmpojr
   WHERE pkarac.id = pkarac_id_p
     AND zmpojr.id (+) = pkarac.oj_id;

  IF tip_p = '1' THEN
    SELECT xmltype('<?xml version="1.0" encoding="UTF-8"?>' || Invoice_l.getclobval())
      INTO Invoice_l
      FROM dual;
  END IF;

  RETURN Invoice_l;
END;
PROCEDURE FINA_SENDINVOICE
 (RACBLOB_ID_P IN t_racuni_blob.id%TYPE
 )
 IS
-- poziva se iz posalji_eracun
  supplierId_l      VARCHAR2(30);
  buyerId_l         VARCHAR2(30);
  dodBuyerId_l      VARCHAR2(30);

  rac_id_l          t_racuni.id%TYPE;
  pkarac_id_l       tpka_racuni.id%TYPE;

  jedinst_ozn_rac_l VARCHAR2(30);

  messageId_l       lpka_clob.id%TYPE;

  ackStatus_l       VARCHAR2(30);
  ackStatusCode_l   NUMBER(2);
  ackStatusText_l   VARCHAR2(4000);
  id_vanjsus_l      t_racuni_blob.id_vanjsus%TYPE;

  errCode_l         VARCHAR2(20);
  errMessage_l      VARCHAR2(4000);

  oib_l             s_vlasnik.oib%TYPE;
BEGIN
  -- http://localhost:8888/ediRestCall

  /*
    {
       "okolina": "prez",
       "idPoruke": "test_mm",
       "idDobavljaca": "9934:85821130368",
       "idKupca": "9934:39884669514",
       "atributPoruke": "atributIntegracijeEDI_001",
       "idDokumentaDobavljaca": "1520",
       "xmlStandard": "UBL",
       "xmlDokumentaRacuna": ""
    }
  */

  messageId_l := pra_zmp_zaj.sekvenca (NULL);

  SELECT pra_eracun.blob2base64 (racblob.datoteka),
         '9934:' || vla.oib,
         vla.oib,
         rac_id,
         pkarac_id
    INTO data_m,
         supplierId_l,
         oib_l,
         rac_id_l,
         pkarac_id_l
    FROM t_racuni_blob racblob,
         s_vlasnik vla
   WHERE racblob.id = racblob_id_p;

  IF rac_id_l IS NOT NULL THEN
    SELECT rac.god_poslovna || '-' || rac.rbr || '-' || rac.oj_sifra || '-' || rac.vdok_sifra2n,
           '9934:' || age.oib,
           DECODE (gmpkomad.id, NULL,
             DECODE (NVL (gmpkom.sifra_pj, age.sifra_pj), NULL,
               NULL,
               'HR99:' || NVL (gmpkom.sifra_pj, age.sifra_pj)),
             DECODE (gmpkomad.sifra_pj, NULL, NULL, 'HR99:' || gmpkomad.sifra_pj))
      INTO jedinst_ozn_rac_l,
           buyerId_l,
           dodBuyerId_l
      FROM t_racuni_blob racblob,
           t_racuni rac,
           m_agencije age,
           mgmp_komitenti gmpkom,
           mgmp_kom_adrese gmpkomad
     WHERE racblob.id = racblob_id_p
       AND rac.id = racblob.rac_id
       AND age.id = pra_rec2.agek_id (rac.age_id, rac.agep_id)
       AND gmpkom.id (+) = age.gmpkom_id
       AND gmpkomad.id (+) = rac.gmpkomad_id;

  ELSIF pkarac_id_l IS NOT NULL THEN
    SELECT pkarac.god_poslovna || '-' || pkarac.rbr || '-' || pkarac.oj_sifra || '-' || pkarac.vdok_sifra2n,
           '9934:' || gmpkom.oib,
           DECODE (gmpkom.sifra_pj, NULL, NULL, 'HR99:' || gmpkom.sifra_pj)
      INTO jedinst_ozn_rac_l,
           buyerId_l,
           dodBuyerId_l
      FROM t_racuni_blob racblob,
           tpka_racuni pkarac,
           mgmp_komitenti gmpkom
     WHERE racblob.id = racblob_id_p
       AND pkarac.id = racblob.pkarac_id
       AND gmpkom.id = pkarac.gmpkom_id;
  END IF;

  APEX_JSON.initialize_clob_output;
  APEX_JSON.open_object(); -- {

  IF oib_l = '94114100359' THEN
    APEX_JSON.write ('okolina', 'prez');
  ELSE
    APEX_JSON.write ('okolina', 'prod');
  END IF;
  APEX_JSON.write ('idPoruke', messageId_l);
  APEX_JSON.write ('idDobavljaca', supplierId_l);
  APEX_JSON.write ('idKupca', buyerId_l);
  IF dodBuyerId_l IS NOT NULL THEN
    APEX_JSON.write ('dodatniIdKupca', dodBuyerId_l);
  END IF;
  APEX_JSON.write ('atributPoruke', 'atributIntegracijeEDI_001');
  APEX_JSON.write ('idDokumentaDobavljaca', jedinst_ozn_rac_l);
  APEX_JSON.write ('xmlStandard', 'UBL');
  APEX_JSON.write ('xmlDokumentaRacuna', data_m);

  APEX_JSON.close_object(); -- }
  data_m := APEX_JSON.get_clob_output;
  APEX_JSON.free_output;

  log_filename_m := 'eracun_' || jedinst_ozn_rac_l;

  url_m := '/ediRestCall';
  fina_zaj_post;
  APEX_JSON.parse (odgovor_m);

  -- obradi odgovor
  /*
    {
      "messageAck": {
        "messageID": "142891199",
        "messageAckID": "d9a67310-8875-405f-920e-ce608c8e3e8d",
        "messageType": 9002,
        "ackStatus": "MSG_NOT_VALID",
        "ackStatusCode": 90,
        "ackStatusText": "Broj rauna postoji za pretinac poiljatelja u tekuoj godini (ID = 13768938)"
      },
      "b2GOutgoingInvoiceEnvelope": null
    }
  ili
    {
        "messageAck": {
            "messageID": "142034415",
            "messageAckID": "8dc0fffb-5bf3-4703-88dc-ec45bed49833",
            "messageType": 9002,
            "ackStatus": "ACCEPTED",
            "ackStatusCode": 10,
            "ackStatusText": "Poruka zaprimljena!"
        },
        "b2GOutgoingInvoiceEnvelope": {
            "b2GOutgoingInvoiceProcessing": {
                "correctB2GOutgoingInvoice": {
                    "supplierInvoiceID": "2020-010066-100-11",
                    "invoiceID": 9532542,
                    "invoiceTimestamp": "24-04-2020"
                },
                "incorrectB2GOutgoingInvoice": null
            }
        }
    }
  ili
    {
      "messageAck": {
        "messageID": "142719978",
        "messageAckID": "2ade211a-d023-4bfc-ac02-122a4d3dc0f6",
        "messageType": 9002,
        "ackStatus": "ACCEPTED",
        "ackStatusCode": 10,
        "ackStatusText": "Ukupni iznos rauna s PDV-om (BT-112) = Ukupni iznos rauna bez PDV-a (BT-109) + Iznos ukupnog PDV-a rauna (BT-110)"
      },
      "b2GOutgoingInvoiceEnvelope": {
        "b2GOutgoingInvoiceProcessing": {
          "correctB2GOutgoingInvoice": null,
          "incorrectB2GOutgoingInvoice": {
            "supplierInvoiceID": "2020-010228-100-11",
            "errorCode": "BR-CO-15",
            "errorMessage": "Ukupni iznos rauna s PDV-om (BT-112) = Ukupni iznos rauna bez PDV-a (BT-109) + Iznos ukupnog PDV-a rauna (BT-110)"
          }
        }
      }
    }
  */

  ackStatus_l     := APEX_JSON.get_varchar2 (p_path => 'messageAck.ackStatus');
  ackStatusCode_l := APEX_JSON.get_number   (p_path => 'messageAck.ackStatusCode');
  ackStatusText_l := APEX_JSON.get_varchar2 (p_path => 'messageAck.ackStatusText');

  IF NVL (ackStatusText_l, 'X') = 'Primatelj rauna nije B2G poslovni subjekt' THEN
    url_m := '/sendB2BInvoiceCall';
    fina_zaj_post;
    APEX_JSON.parse (odgovor_m);

    ackStatus_l     := APEX_JSON.get_varchar2 (p_path => 'messageAck.ackStatus');
    ackStatusCode_l := APEX_JSON.get_number   (p_path => 'messageAck.ackStatusCode');
    ackStatusText_l := APEX_JSON.get_varchar2 (p_path => 'messageAck.ackStatusText');
  END IF;

  IF NVL (ackStatusCode_l, '0') <> '10' THEN
    INSERT INTO t_racblob_log (racblob_id, status)
      VALUES (racblob_id_p, SUBSTR (ackStatusCode_l || ' ' || ackStatusText_l, 1, 240));

    IF NVL (ackStatusCode_l, '0') = '90' THEN
      UPDATE t_racuni_blob
         SET id_vanjsus = SUBSTR (ackStatusText_l, INSTR (ackStatusText_l, '(ID = ') + 6, INSTR (ackStatusText_l, ')') - 6 - INSTR (ackStatusText_l, '(ID = ')),
             status = 1
       WHERE id = racblob_id_p;
    END IF;
  ELSE
    id_vanjsus_l := APEX_JSON.get_number (p_path => 'b2GOutgoingInvoiceEnvelope.b2GOutgoingInvoiceProcessing.correctB2GOutgoingInvoice.invoiceID');

    IF id_vanjsus_l IS NOT NULL THEN
      UPDATE t_racuni_blob
         SET id_vanjsus = id_vanjsus_l,
             status = 1
       WHERE id = racblob_id_p;

      INSERT INTO t_racblob_log (racblob_id, status)
        VALUES (racblob_id_p, SUBSTR(ackStatusCode_l || ' ' || ackStatusText_l, 1, 240));
    ELSE
      errCode_l := APEX_JSON.get_varchar2 (p_path => 'b2GOutgoingInvoiceEnvelope.b2GOutgoingInvoiceProcessing.incorrectB2GOutgoingInvoice.errorCode');
      errMessage_l := APEX_JSON.get_varchar2 (p_path => 'b2GOutgoingInvoiceEnvelope.b2GOutgoingInvoiceProcessing.incorrectB2GOutgoingInvoice.errorMessage');

      INSERT INTO t_racblob_log (racblob_id, status)
        VALUES (racblob_id_p, SUBSTR (errCode_l || ' ' || errMessage_l, 1, 240));
    END IF;
  END IF;

  COMMIT;
END;
PROCEDURE FINA_GETINVOICESTATUS
 (RACBLOB_ID_P IN t_racuni_blob.id%TYPE
 )
 IS
-- poziva se iz modula pka2070.fmb - Rauni za predujam i rec2250.fmb - Rauni
  supplierId_l      VARCHAR2(30);
  jedinst_ozn_rac_l VARCHAR2(30);
  godina_l          t_racuni.god_poslovna%TYPE;
  messageId_l       lpka_clob.id%TYPE;

  rac_id_l          t_racuni.id%TYPE;
  pkarac_id_l       tpka_racuni.id%TYPE;

  ackStatusCode_l   NUMBER(2);
  ackStatusText_l   VARCHAR2(4000);
  docStatusCode_l   VARCHAR2(30);
  docStatusText_l   VARCHAR2(30);
  docNote_l         VARCHAR2(80);

  id_vanjsus_l      t_racuni_blob.id_vanjsus%TYPE;
  rbr_status_l      NUMBER (3);

  oib_l             s_vlasnik.oib%TYPE;
BEGIN
  /*
    {
      "okolina": "prez",
      "idPoruke": "test_mm",
      "idDobavljaca": "9934:94114100359",
      "atributPoruke": "atributIntegracije001",
      "idDokumentaDobavljaca": "2019-000004-0123-11",
      "godina": "2019"
    }
  */

  IF racblob_id_p IS NULL THEN
    RETURN;
  END IF;

  data_m := NULL;
  messageId_l := pra_zmp_zaj.sekvenca (NULL);

  SELECT '9934:' || vla.oib,
         vla.oib,
         racblob.rac_id,
         racblob.pkarac_id
    INTO supplierId_l,
         oib_l,
         rac_id_l,
         pkarac_id_l
    FROM t_racuni_blob racblob,
         s_vlasnik vla
   WHERE racblob.id = racblob_id_p;

  IF rac_id_l IS NOT NULL THEN
    SELECT rac.god_poslovna || '-' || rac.rbr || '-' || rac.oj_sifra || '-' || rac.vdok_sifra2n,
           rac.god_poslovna
      INTO jedinst_ozn_rac_l,
           godina_l
      FROM t_racuni rac,
           t_racuni_blob racblob
     WHERE racblob.id = racblob_id_p
       AND rac.id = racblob.rac_id;
  ELSIF pkarac_id_l IS NOT NULL THEN
    SELECT pkarac.god_poslovna || '-' || pkarac.rbr || '-' || pkarac.oj_sifra || '-' || pkarac.vdok_sifra2n,
           pkarac.god_poslovna
      INTO jedinst_ozn_rac_l,
           godina_l
      FROM tpka_racuni pkarac,
           t_racuni_blob racblob
     WHERE racblob.id = racblob_id_p
       AND pkarac.id = racblob.pkarac_id;
  END IF;

  APEX_JSON.initialize_clob_output;
  APEX_JSON.open_object(); -- {

  IF oib_l = '94114100359' THEN
    APEX_JSON.write ('okolina', 'prez');
  ELSE
    APEX_JSON.write ('okolina', 'prod');
  END IF;
  APEX_JSON.write ('idPoruke', messageId_l);
  APEX_JSON.write ('idDobavljaca', supplierId_l);
  APEX_JSON.write ('atributPoruke', 'atributIntegracije001');
  APEX_JSON.write ('idDokumentaDobavljaca', jedinst_ozn_rac_l);
  APEX_JSON.write ('godina', godina_l);

  APEX_JSON.close_object(); -- }
  data_m := APEX_JSON.get_clob_output;
  APEX_JSON.free_output;

  url_m := '/getEDIOutgoingInvoiceStatus';
  log_filename_m := 'eracun_' || jedinst_ozn_rac_l;

  fina_zaj_post;

  -- obradi odgovor
  /*
    {
      "messageAck": {
        "messageID": "test_mm",
        "messageAckID": "99b01e51-8908-485e-9658-4581451f42f3",
        "messageType": 9012,
        "ackStatus": "ACCEPTED",
        "ackStatusCode": 10,
        "ackStatusText": "Poruka zaprimljena!"
      },
      "b2GOutgoingInvoiceStatus": {
        "supplierID": "9934:94114100359",
        "additionalSupplierID": null,
        "invoiceID": 78608,
        "supplierInvoiceID": "2019-000004-0123-11",
        "invoiceTimestamp": "26-11-2019",
        "documentStatus": [
          {
            "statusCode": "RECEIVED",
            "statusText": "Zaprimljen",
            "statusTimestamp": "26-11-2019",
            "note": null,
            "partialAmount": null
          }
        ]
      }
    }
  */

  APEX_JSON.parse (odgovor_m);

  ackStatusCode_l := APEX_JSON.get_number (p_path => 'messageAck.ackStatusCode');
  ackStatusText_l := APEX_JSON.get_varchar2 (p_path => 'messageAck.ackStatusText');

  IF NVL (ackStatusCode_l, '0') <> '10' THEN
    INSERT INTO t_racblob_log (racblob_id, status)
      VALUES (racblob_id_p, SUBSTR (ackStatusCode_l || ' ' || ackStatusText_l, 1, 240));
  ELSE
    id_vanjsus_l := APEX_JSON.get_number (p_path => 'b2GOutgoingInvoiceStatus.invoiceID');

    IF id_vanjsus_l IS NOT NULL THEN
      rbr_status_l := APEX_JSON.get_count (p_path => 'b2GOutgoingInvoiceStatus.documentStatus');

      docStatusCode_l := APEX_JSON.get_varchar2 (p_path => 'b2GOutgoingInvoiceStatus.documentStatus[%d].statusCode', p0 => rbr_status_l);
      docStatusText_l := APEX_JSON.get_varchar2 (p_path => 'b2GOutgoingInvoiceStatus.documentStatus[%d].statusText', p0 => rbr_status_l);
      docNote_l := APEX_JSON.get_varchar2 (p_path => 'b2GOutgoingInvoiceStatus.documentStatus[%d].note', p0 => rbr_status_l);

      UPDATE t_racuni_blob
         SET status = DECODE (docStatusCode_l,
                              'RECEIVED', 2,
                              'RECEIVING_CONFIRMED', 2,
                              'APPROVED', 2,
                              'PAYMENT_FULFILLED', 3,
                              'PAYMENT_PARTIALLY_FULFILLED', 3,
                              'REJECTED', 4,
                              1)
       WHERE id_vanjsus = id_vanjsus_l
         AND id = racblob_id_p;

      INSERT INTO t_racblob_log (racblob_id, status)
        VALUES (racblob_id_p, SUBSTR (docStatusCode_l || ' ' || docStatusText_l || ' ' || docNote_l, 1, 240));
    ELSE
      INSERT INTO t_racblob_log (racblob_id, status)
        VALUES (racblob_id_p, SUBSTR (ackStatusCode_l || ' ' || ackStatusText_l, 1, 240));
    END IF;
  END IF;

  COMMIT;
END;
PROCEDURE FINA_ZAJ_POST
 IS
-- poziva se iz fina_sendinvoice i fina_getinvoicestatus
  url_l VARCHAR2 (200);
  req_l UTL_HTTP.req;
  res_l UTL_HTTP.resp;
  text_l VARCHAR2 (32767);
  clob_l CLOB;
BEGIN
  SELECT MIN (staza)
    INTO url_l
    FROM s_parametri_prijepisa
   WHERE sifra = 'ERACUN_URL';

  IF data_m IS NULL OR NVL (url_l, '.') = '.' THEN
    RETURN;
  END IF;

  odgovor_m := NULL;

  IF log_filename_m IS NOT NULL THEN
    pra_pka2.clob_to_table (CHR(10) || '[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' || url_m || CHR(10), log_filename_m, NULL, 'ERACUN');
    pra_pka2.clob_to_table (data_m || CHR(10), log_filename_m, NULL, 'ERACUN');
  END IF;

  url_l := url_l || url_m;

  UTL_HTTP.set_response_error_check (enable => FALSE);
  UTL_HTTP.set_detailed_excp_support (enable => FALSE);
  -- UTL_HTTP.set_transfer_timeout (timeout => pra_pka_zaj.vrijednost_parametra ('1057'));
  req_l := UTL_HTTP.begin_request (url => url_l, method => 'POST');
  UTL_HTTP.set_header (r => req_l, name => 'Content-Type', value => 'application/json; charset=utf-8');
  UTL_HTTP.set_header (req_l, 'Content-Length', pra_pka2.clob_length (data_m)); -- IRN 2434
  UTL_HTTP.set_body_charset (charset => 'UTF-8');

  DECLARE
    req_length_l BINARY_INTEGER;
    buffer_l     VARCHAR2(2000);
    amount_l     PLS_INTEGER := 2000;
    offset_l     PLS_INTEGER := 1;
  BEGIN
    req_length_l := pra_pka2.clob_length (data_m);

    WHILE (offset_l < req_length_l) LOOP
      buffer_l := DBMS_LOB.substr (data_m, amount_l, offset_l);
      UTL_HTTP.write_text (req_l, buffer_l);
      offset_l := offset_l + amount_l;
    END LOOP;
  END;

  res_l := UTL_HTTP.get_response (req_l);
  UTL_HTTP.set_body_charset (res_l, charset => 'UTF-8');
  BEGIN
    DBMS_LOB.createtemporary (clob_l, TRUE);
    LOOP
      UTL_HTTP.read_text (res_l, text_l, 32767);
      DBMS_LOB.writeappend (clob_l, LENGTH(text_l), text_l);
    END LOOP;
  EXCEPTION
    WHEN UTL_HTTP.end_of_body THEN
      UTL_HTTP.end_response (res_l);
  END;

  odgovor_m := clob_l;

  IF log_filename_m IS NOT NULL THEN
    pra_pka2.clob_to_table (odgovor_m || CHR(10), log_filename_m, NULL, 'ERACUN');
  END IF;
EXCEPTION
  WHEN UTL_HTTP.end_of_body THEN
    UTL_HTTP.end_response (res_l);
END;
PROCEDURE IZRADI_ERACUN_BLOB
 (RAC_ID_P IN t_racuni.id%TYPE
 ,KUPAC_ID_P IN t_racuni.age_id%TYPE
 ,RACBLOB_ID_P OUT t_racuni_blob.id%TYPE
 ,FILENAME_P IN VARCHAR2
 ,PKARAC_ID_P IN tpka_racuni.id%TYPE
 ,ZAH_PONUDA_P IN VARCHAR2 := NULL
 ,NARUDZBENICA_P IN VARCHAR2 := NULL
 ,UGOVOR_P IN VARCHAR2 := NULL
 ,PROJEKT_P IN VARCHAR2 := NULL
 ,NAPOMENA_P IN VARCHAR2 := NULL
 )
 IS
-- poziva se iz modula pka2070.fmb - Rauni za predujam i rec2250.fmb - Rauni
  eracun_xml_l XMLTYPE;
  blob_l BLOB;
  clob_l CLOB;

  -- REC parametar 1175: Oznaka sustava za slanje e-rauna: 1 = Moj-eRaun, 3 = FINA, ili nebitno.
  tip_l VARCHAR2(1) := pra_zmp_zaj.zmppar_vrijednost ('REC', '1175');

  CURSOR racblob_c IS
    SELECT COUNT (1)
      FROM t_racuni_blob
     WHERE rac_id = rac_id_p
       AND status <> -1
       AND oznaka = 'xml';

  CURSOR racblob_pka_c IS
    SELECT COUNT (1)
      FROM t_racuni_blob
     WHERE pkarac_id = pkarac_id_p
       AND status <> -1
       AND oznaka = 'xml';

  postoji_racblob_l NUMBER(1);
  postoji_racblob_pka_l NUMBER(1);

  FUNCTION clob2blob (clob_p CLOB) RETURN BLOB IS
    -- ne prolazi na 9-ki
    blob2_l        BLOB;
    src_offset_l   NUMBER;
    dest_offset_l  NUMBER;
    amount_l       NUMBER;
    lang_context_l NUMBER := DBMS_LOB.default_lang_ctx;
    warning_l      NUMBER;
  BEGIN
    DBMS_LOB.createtemporary (blob2_l, TRUE);
    src_offset_l := 1;
    dest_offset_l := 1;
    amount_l := DBMS_LOB.getlength (clob_p);
    DBMS_LOB.converttoblob (
      blob2_l,
      clob_p,
      amount_l,
      src_offset_l,
      dest_offset_l,
      1,
      lang_context_l,
      warning_l);
    RETURN blob2_l;
  END;
BEGIN
  IF rac_id_p IS NOT NULL THEN
    OPEN racblob_c;
    FETCH racblob_c INTO postoji_racblob_l;
    CLOSE racblob_c;

    IF postoji_racblob_l > 0 THEN
      RETURN;
    END IF;
  END IF;

  IF pkarac_id_p IS NOT NULL THEN
    OPEN racblob_pka_c;
    FETCH racblob_pka_c INTO postoji_racblob_pka_l;
    CLOSE racblob_pka_c;

    IF postoji_racblob_pka_l > 0 THEN
      RETURN;
    END IF;
  END IF;

  IF tip_l IN ('1', '3') THEN  -- Moj-eRacun, FINA
    IF rac_id_p IS NOT NULL THEN
      eracun_xml_l := fina_invoice_xml (rac_id_p, zah_ponuda_p, narudzbenica_p, ugovor_p, projekt_p, napomena_p, tip_l);
      clob_l := eracun_xml_l.getclobval();
    ELSIF pkarac_id_p IS NOT NULL THEN
      eracun_xml_l := fina_pka_invoice_xml (pkarac_id_p, zah_ponuda_p, narudzbenica_p, ugovor_p, projekt_p, napomena_p, tip_l);
      clob_l := eracun_xml_l.getclobval();
    END IF;

    -- ispravi tagove koji su predugi za Oracle
    SELECT REPLACE (
             REPLACE (
               REPLACE (clob_l, 'cac:OriginatorDocRef', 'cac:OriginatorDocumentReference'),
                          'cac:AdditionalDocRef', 'cac:AdditionalDocumentReference'),
                          'cbc:EmbeddedDocument', 'cbc:EmbeddedDocumentBinaryObject')
      INTO clob_l
      FROM dual;
  ELSE
    RETURN;
  END IF;

  blob_l := clob2blob (clob_l);
  racblob_id_p := pra_rec_zaj.sekvenca (NULL);

  INSERT INTO t_racuni_blob (id, rac_id, pkarac_id, datoteka, oznaka, opis)
    VALUES (racblob_id_p, rac_id_p, pkarac_id_p, blob_l, 'xml', filename_p || '.xml');

  COMMIT;
END;
PROCEDURE POSALJI_ERACUN
 (RAC_ID_P IN t_racuni_blob.rac_id%TYPE
 ,FILENAME_P IN VARCHAR2
 ,RACBLOB_ID_P IN t_racuni_blob.id%TYPE
 ,PKARAC_ID_P IN t_racuni_blob.pkarac_id%TYPE
 )
 IS
-- poziva se iz modula pka2070.fmb - Rauni za predujam i rec2250.fmb - Rauni

  -- REC param 1175: Oznaka sustava za slanje e-rauna: 1 = Moj-eRaun, 3 = FINA, ili nebitno.
  tip_l  szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.zmppar_vrijednost ('REC', '1175');

  blob_l BLOB;

  CURSOR blobs_c IS
    SELECT id, datoteka, oznaka
      FROM t_racuni_blob
     WHERE rac_id = rac_id_p
       AND NVL (racblob_id_p, id) = id
     ORDER BY id DESC;

  CURSOR pka_blobs_c IS
    SELECT id, datoteka, oznaka
      FROM t_racuni_blob
     WHERE pkarac_id = pkarac_id_p
       AND NVL (racblob_id_p, id) = id
     ORDER BY id DESC;

  racblob_id_l t_racuni_blob.id%TYPE;
  oznaka_l     t_racuni_blob.oznaka%TYPE;
  i NUMBER:= 0;

  vanjsus_postoji_l NUMBER(2);

  FUNCTION blob_to_xmltype (blob_p IN BLOB) RETURN XMLTYPE IS
    clob_l CLOB;
    varchar_l VARCHAR2 (32767);
    start_l PLS_INTEGER := 1;
    buffer_l PLS_INTEGER := 32767;
  BEGIN
    DBMS_LOB.createtemporary (clob_l, TRUE);

    FOR i IN 1..CEIL (DBMS_LOB.getlength (blob_p) / buffer_l) LOOP
      varchar_l := UTL_RAW.cast_to_varchar2 (DBMS_LOB.substr (blob_p, buffer_l, start_l));
      DBMS_LOB.writeappend (clob_l, LENGTH (varchar_l), varchar_l);
      start_l := start_l + buffer_l;
    END LOOP;

    RETURN XMLTYPE (clob_l);
  END;
BEGIN
  OPEN blobs_c;
  FETCH blobs_c INTO racblob_id_l, blob_l, oznaka_l;

  WHILE blobs_c%FOUND LOOP
    IF tip_l = '1' THEN
      clob_m := blob_to_xmltype (blob_l).getclobval();
      post2merac ('send', filename_p, racblob_id_l, vanjsus_postoji_p => vanjsus_postoji_l);
    ELSIF tip_l = '3' THEN
      fina_sendinvoice (racblob_id_l);
    END IF;

    FETCH blobs_c INTO racblob_id_l, blob_l, oznaka_l;
  END LOOP;

  CLOSE blobs_c;

  OPEN pka_blobs_c;
  FETCH pka_blobs_c INTO racblob_id_l, blob_l, oznaka_l;

  WHILE pka_blobs_c%FOUND AND i < 2 LOOP
    IF tip_l = '1' THEN
      clob_m := blob_to_xmltype (blob_l).getclobval();
      post2merac ('send', filename_p, racblob_id_l, vanjsus_postoji_p => vanjsus_postoji_l);
    ELSIF tip_l = '3' THEN
      fina_sendinvoice (racblob_id_l);
    END IF;

    FETCH pka_blobs_c INTO racblob_id_l, blob_l, oznaka_l;
  END LOOP;

  CLOSE pka_blobs_c;
END;
PROCEDURE PKAPRI_GET_FILE
 (FILENAME_P IN VARCHAR2
 ,PKAPRI_ID_P IN tpka_prilozi.id%TYPE
 )
 IS
-- poziva se iz modula pka9010.fmb - Prilozi retku
  file_l     UTL_FILE.file_type;
  buffer_l   RAW(32767);
  amount_l   BINARY_INTEGER := 32767;
  position_l INTEGER := 1;
  blob_l     BLOB;
  length_l   NUMBER;
BEGIN
  -- get length of blob and blob
  SELECT DBMS_LOB.getlength (prilog), prilog
    INTO length_l, blob_l
    FROM tpka_prilozi
   WHERE id = pkapri_id_p;

  file_l := UTL_FILE.fopen ('ERACUNI_' || SYS_CONTEXT ('USERENV', 'CURRENT_SCHEMA'), filename_p, 'W', 32767);

  WHILE position_l < length_l LOOP
    DBMS_LOB.read (blob_l, amount_l, position_l, buffer_l);
    UTL_FILE.put_raw (file_l, buffer_l, TRUE);
    position_l := position_l + amount_l;
  END LOOP;

  UTL_FILE.fclose (file_l);
END;
PROCEDURE PKAPRI_STORE_FILE
 (FILENAME_P IN VARCHAR2
 ,NAZ_PRILOGA_P IN tpka_prilozi.naz_priloga%TYPE
 ,NAZ_TABLICE_P IN tpka_prilozi.naz_tablice%TYPE
 ,ID_RETKA_P IN tpka_prilozi.id_retka%TYPE
 )
 IS
-- poziva se iz modula pka9010.fmb - Prilozi retku
  pkapri_id_l  NUMBER;
  src_file_l   BFILE;
  dst_file_l   BLOB;
  lgh_file_l   BINARY_INTEGER;
BEGIN
 -- insert a NULL record to lock
  INSERT INTO tpka_prilozi (naz_tablice, id_retka, naz_priloga, prilog)
    VALUES (naz_tablice_p, id_retka_p, naz_priloga_p, EMPTY_BLOB())
    RETURNING id INTO pkapri_id_l;

  -- lock record
  SELECT prilog
    INTO dst_file_l
    FROM tpka_prilozi
   WHERE id = pkapri_id_l
     FOR UPDATE;

  src_file_l := BFILENAME ('ERACUNI_' || SYS_CONTEXT ('USERENV', 'CURRENT_SCHEMA'), filename_p);

  -- open the file
  DBMS_LOB.fileopen (src_file_l, 0);
  lgh_file_l := DBMS_LOB.getlength (src_file_l);
  -- read the file
  DBMS_LOB.loadfromfile (dst_file_l, src_file_l, lgh_file_l);

  UPDATE tpka_prilozi
     SET prilog = dst_file_l
   WHERE id = pkapri_id_l;

  COMMIT;
  -- close file
  DBMS_LOB.fileclose (src_file_l);

END;
/* PRIPREMI_PKA_TAB_RUZ */
PROCEDURE PRIPREMI_PKA_TAB_RUZ
 (PKARAC_ID_P IN TPKA_RACUNI.ID%TYPE
 ,RAC_IZN_TECAJA_P TPKA_RACUNI.IZN_TECAJA%TYPE
 )
 IS
-- puni pomonu tablicu s razlikama u zaokruivanju; poziva se iz fina_pka_stavke_xml
  div_l t_racuni.iznos%TYPE;
  mod_l t_racuni.iznos%TYPE;
BEGIN
  DELETE FROM prec_global2;

  FOR raz_c IN (
    SELECT
      pkapdv.vpispz_id,
      (pkapdv.iznos / rac_izn_tecaja_p) - SUM (stavke.osn_racval) razlika,
      SUM (stavke.br_stavaka) br_stavaka
    FROM
      ipka_rac_pdv pkapdv,
      (
      -- isporuke na raunu
      SELECT
        pkaracisp.vpispz_id,
        SUM (ROUND ((pkaracisp.cijena * pkaracisp.kolicina * 100 / (100 + vpispz.stopa))/rac_izn_tecaja_p, 2)) osn_racval,
        COUNT (pkaracisp.id) br_stavaka
      FROM
        tpka_rac_isp pkaracisp,
        s_vpisporukaz vpispz
      WHERE
        pkaracisp.pkarac_id = pkarac_id_p AND
        pkaracisp.vpispz_id = vpispz.id
      GROUP BY
        pkaracisp.vpispz_id      
	UNION ALL
      -- interni POS rauni
      SELECT
        rnkpdv.vpispz_id,
        SUM (ROUND (rnkpdv.izn_osnovice / rac_izn_tecaja_p, 2)),
        COUNT (rnkpdv.id) br_stavaka
      FROM
        ipka_rnk_pdv rnkpdv,
        tpka_rnkasa pkarnk
      WHERE
        pkarnk.pkarac_id = pkarac_id_p
        AND rnkpdv.pkarnk_id = pkarnk.id
      GROUP BY
        rnkpdv.vpispz_id,
        pkarnk.id
     UNION ALL
      SELECT
        dokart.vpispz_id,
        SUM (ROUND (dokart.prod_cijena * dokart.kolicina * (1 - dokart.rabat / 100) / rac_izn_tecaja_p, 2)),
        COUNT (dokart.id) br_stavaka
      FROM
        tgas_izlazdok dok,
        tgas_izlazdok_art dokart,
        tpka_racuni pkarac,
        tpka_rac_gasizldok racgasdok
      WHERE
        pkarac.id = pkarac_id_p AND
        racgasdok.pkarac_id = pkarac.id AND
        racgasdok.gasizldok_id = dok.id AND
        dokart.gasizldok_id = dok.id 
      GROUP BY
        dokart.vpispz_id,
        dokart.id
      ) stavke
    WHERE
      pkapdv.pkarac_id = pkarac_id_p
      AND stavke.vpispz_id = pkapdv.vpispz_id
    GROUP BY
      pkapdv.vpispz_id, pkapdv.iznos)
  LOOP
    /*
    ako je jedinina mjera za rasporeivanje 0.01 (1 lipa)
    i ako je razlika u zaokruivanju -0.343521
    i broj stavaka za rasporeivanje je 21,
    onda svakoj stavci dodajemo 1 jedinicu = FLOOR ((ABS (-0.34) / 0.01 / 21)) * SIGN (-0.34)
    i jo 13 stavaka dobiva po jednu jedinicu = FLOOR (MOD (ABS (-0.34) / 0.01, 21)) * SIGN (-0.34)
    */

    -- broj jedinica koje dodajemo svakoj stavci
    div_l := FLOOR (ABS (ROUND (raz_c.razlika, 2)) / jedmj_rasporedi_c / raz_c.br_stavaka);

    -- broj stavaka kojima dodajemo jednu jedinicu
    mod_l := FLOOR (MOD (ABS (ROUND (raz_c.razlika, 2)) / jedmj_rasporedi_c, raz_c.br_stavaka));

    INSERT INTO prec_global2
      (id1, iznos1, iznos2, iznos3, iznos4, iznos5)
      VALUES
      (raz_c.vpispz_id, div_l, mod_l, SIGN (raz_c.razlika), raz_c.razlika, raz_c.br_stavaka);
  END LOOP;
END;

END PRA_ERACUN;
/
SHOW ERROR

