-- C:\Radni\pra_dom_api.pkb
--
-- Generated for Oracle 10g on Wed May 14  08:48:33 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'PRA_DOM_API'
CREATE OR REPLACE PACKAGE BODY PRA_DOM_API IS
data_m          CLOB;
url_m           szmp_parametri.vrijednost%TYPE;
odgovor_m       CLOB;
opis_m          CLOB;
log_file_name_m VARCHAR2(100); -- IRN 3941
metcvor_rbr_m   smet_cvorovi.rbr%TYPE; -- IRN 3941

dom_param_1003_m szmp_parametri.vrijednost%TYPE;
dom_param_1006_m szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.zmppar_vrijednost ('DOM', '1006'); -- Endpoint za inicijalizaciju bookinga
dom_param_1007_m szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.zmppar_vrijednost ('DOM', '1007'); -- Endpoint za inicijalizaciju statusa S
dom_param_1008_m szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.zmppar_vrijednost ('DOM', '1008'); -- Endpoint za inicijalizaciju asortimana
dom_param_1009_m szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.zmppar_vrijednost ('DOM', '1009'); -- Endpoint za booking
dom_param_1010_m szmp_parametri.vrijednost%TYPE := pra_zmp_zaj.zmppar_vrijednost ('DOM', '1010'); -- Endpoint za statuse SJ
dom_param_1011_m szmp_parametri.vrijednost%TYPE;-- IRN 4030 (Najvea dob djeteta ili nebitno.)
dom_param_1012_m szmp_parametri.vrijednost%TYPE;-- IRN 4030 (Automatska obrada "Slanje podataka sustavu DOM" treba slati asortiman minibara: da ili ne.)

TYPE booking_rec_type IS RECORD (
  Property       m_so.sifra%TYPE, -- IRN 3941
  Room           m_sj.broj%TYPE,
  BookingId      VARCHAR2(100),
  ReservationId  VARCHAR2(100),
  Status         VARCHAR2(20), -- RESERVED, CANCELLED, NO SHOW, CHECKED IN, CHECKED OUT
  Arrival        VARCHAR2(16), -- YYYY-MM-DD 00:00
  Departure      VARCHAR2(16), -- YYYY-MM-DD 00:00
  Vip            t_rezervacije.ozn_vip%TYPE,
  CheckIn        VARCHAR2(16), -- YYYY-MM-DD 00:00
  CheckOut       VARCHAR2(16), -- YYYY-MM-DD 00:00
  --NoAdults       t_rezervacije.br_osoba1%TYPE,
  Adults         t_rezervacije.br_osoba1%TYPE, -- IRN 4030 (izmjena naziva elementa resourca Booking : iz NoAdults --> Adults)
  Message        t_rezervacije.napomena%TYPE,
  -- GuestId      VARCHAR2(100), IRN 3941
  FirstName      t_rezervacije.ime%TYPE,
  LastName       t_rezervacije.prezime%TYPE,
  BirthDate      VARCHAR2(10), -- YYYY-MM-DD
  Country        s_zemlje.sifra_2a%TYPE,
  Service        mzmp_usl_sus.sifra%TYPE, -- IRN 4030 ifra usluge
  Agency         m_agencije.naziv%TYPE, -- IRN 4030 Naziv agencije
  GuestGroup     t_ponude.naz_grupe%TYPE, -- IRN 4030 Naziv grupe gostiju
  Children       NUMBER, -- IRN 4030 Broj djece
  Sex            t_kgostiju.ozn_spola%TYPE, -- IRN 4030 Oznaka spola
  RegPlate       t_kgostiju.reg_vozila%TYPE, -- IRN 4030 Registracija vozila
  PayCard        tpka_kartice.broj%TYPE -- IRN 4030 Broj Pay Card
  );

booking_rec_m booking_rec_type;


FUNCTION DOM_DAT_RODJENJA
 (OZNAKE_P IN szmp_parametri.vrijednost%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE
 ,DAT_DOLASKA_P IN t_gosti.dat_dolaska%TYPE
 ,DAT_ODLASKA_P IN t_gosti.dat_odlaska%TYPE
 ,DAT_RODJENJA_P IN t_kgostiju.dat_rodjenja%TYPE := NULL
 )
 RETURN t_kgostiju.dat_rodjenja%TYPE
 IS
-- datum roenja; poziva se iz procedura dom_post_init_booking, dom_post_booking_gost i dom_post_booking_kgost
  dat_rodjenja_l t_kgostiju.dat_rodjenja%TYPE;
BEGIN

  IF INSTR (oznake_p, 'C') = 0    -- datum roenja
    AND INSTR (oznake_p, 'D') = 0 -- datum roenja (samo za roendane u vrijeme boravka)
  THEN
    RETURN (NULL);
  END IF;

  IF gost_id_p IS NULL
    OR dat_dolaska_p IS NULL
    OR dat_odlaska_p IS NULL
  THEN
    RETURN (NULL);
  END IF;

  IF dat_rodjenja_p IS NOT NULL THEN
    dat_rodjenja_l := dat_rodjenja_p;
  ELSE
    SELECT MIN (dat_rodjenja) INTO dat_rodjenja_l
      FROM t_kgostiju
     WHERE gost_id = gost_id_p
       AND oznaka = 'V';
    IF dat_rodjenja_l IS NULL THEN
      RETURN (NULL);
    END IF;
  END IF;
  IF INSTR (oznake_p, 'C') > 0 THEN
    RETURN (dat_rodjenja_l);
  END IF;

  IF ADD_MONTHS (dat_rodjenja_l, (pra_rec_s3.dob (dat_rodjenja_l, (dat_dolaska_p - 1)) + 1) * 12)
    BETWEEN dat_dolaska_p AND dat_odlaska_p
  THEN
    RETURN (dat_rodjenja_l);
  END IF;

  RETURN (NULL);
END;
PROCEDURE DOM_INSERT_RECIDOM
 (SO_SIFRA_P IN M_SO.SIFRA%TYPE
 ,SJ_ID_P IN M_SJ.ID%TYPE
 ,OZN_DOMACICE1_P IN TREC_IDOMACICE.OZN_DOMACICE1%TYPE
 ,UNOS_KORISNIK_P IN TREC_IDOMACICE.UNOS_KORISNIK%TYPE
 ,ODGOVOR_P OUT VARCHAR2
 )
 IS
-- poziva se iz procedure dom_post_room_cleanness
BEGIN
  IF pra_zmp_s.oznaka ('P0054', so_sifra_p) = 0 THEN
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  INSERT INTO trec_idomacice (sj_id, datum, ozn_domacice1, ozn_unosa, unos_korisnik, unos_dat)
    VALUES (sj_id_p, TRUNC (SYSDATE), ozn_domacice1_p, 'A', unos_korisnik_p, SYSDATE);

  odgovor_p := 'OK (INSERTED ' || SQL%ROWCOUNT || ')';
EXCEPTION -- IRN 4030
  WHEN OTHERS THEN
    odgovor_p := SUBSTR ('ERROR ' || SQLERRM, 1, 2000);
END;
PROCEDURE DOM_POST2DOM_JOB
 (VLASNIKPODATKA_P IN NUMBER := NULL
 )
 IS
-- proceduru poziva JOB
BEGIN
  pra_zmp_context.set_vlasnikpodatka (vlasnikpodatka_p);
  dom_param_1012_m := pra_zmp_zaj.zmppar_vrijednost ('DOM', '1012');
  
  dom_post_init_booking;
  dom_post_init_room_status;
  -- IRN 4030 (Automatska obrada "Slanje podataka sustavu DOM" treba slati asortiman minibara: da ili ne.)
  IF UPPER(dom_param_1012_m) = 'DA' THEN
    dom_post_init_asortiman;
  END IF;  
END;
PROCEDURE DOM_POST_BOOKING_GOST
 (ZAPIS_P IN tab_t_gosti.gost_rec_type
 )
 IS
-- Booking
-- proceduru pozivaju AIS_T_GOSTI i AUS_T_GOSTI
  CURSOR sj_c (sj_id_k m_sj.id%TYPE) IS
    SELECT so.sifra, sj.broj
      FROM m_sj sj, m_so so
     WHERE sj.id = sj_id_k
       AND sj.so_id = so.id;

  CURSOR rez_c (rezvsj_id_k t_rez_vsj.id%TYPE) IS
    SELECT so.sifra || '-' ||rez.god_poslovna || '-' || rez.rbr, rez.reg_vozila
      FROM t_rezervacije rez, t_rez_vsj rezvsj, m_so so
     WHERE rezvsj.id = rezvsj_id_k 
       AND rezvsj.rez_id = rez.id
       AND rez.so_id = so.id;

  so_sifra_old_l      m_so.sifra%TYPE; -- IRN 3941
  sj_broj_old_l       m_sj.broj%TYPE;  -- IRN 3941
  rez_reg_vozila_l    t_rezervacije.reg_vozila%TYPE;
  kgost_reg_vozila_l  t_rezervacije.reg_vozila%TYPE;
BEGIN

  IF pra_zmp_zaj.zmppar_vrijednost ('DOM', '1001') = 'nebitno' -- timeout
    OR zapis_p.sj_id_new IS NULL
  THEN
    RETURN;
  END IF;

  /*
  Oznake podataka koje MISH alje u DOM: A = ime, B = prezime, C = datum roenja, D = datum roenja (samo za roendane u vrijeme boravka), 
  E = dravljanstvo, F = spol, G = registracija vozila ili nebitno.
  */
  dom_param_1003_m := pra_zmp_zaj.zmppar_vrijednost ('DOM', '1003');
  
  -- IRN 3941
  log_file_name_m := 'dom-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '.log';
  opis_m := '[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] {Booking}';
  -- KRAJ IRN 3941

  opis_m := '[*** dom_post_booking_gost';
  IF INSERTING THEN
    opis_m := opis_m || ' | inserting | ';
    NULL;
  ELSIF UPDATING
      AND (
             zapis_p.sj_id_new <> zapis_p.sj_id_old
          OR zapis_p.ozn_prisutnosti_new <> zapis_p.ozn_prisutnosti_old
          OR zapis_p.dat_dolaska_new <> zapis_p.dat_dolaska_old
          OR zapis_p.dat_odlaska_new <> zapis_p.dat_odlaska_old
          OR (zapis_p.ime_new <> zapis_p.ime_old AND INSTR (dom_param_1003_m, 'A') > 0)
          OR (zapis_p.prezime_new <> zapis_p.prezime_old AND INSTR (dom_param_1003_m, 'B') > 0)
          OR (zapis_p.zem_id_new <> zapis_p.zem_id_old AND INSTR (dom_param_1003_m, 'E') > 0)
          OR NVL (zapis_p.ozn_vip_new, '') <> NVL (zapis_p.ozn_vip_old, '')
          )
  THEN
    opis_m := opis_m || ' | updating | ';
    NULL;
  ELSE
    RETURN;
  END IF;
  opis_m := opis_m || zmp_zaj.korisnik (-1) || ' | ' || zapis_p.ime_new || ' | ' || zapis_p.prezime_new || ']';

  -- IRN 3941
  metcvor_rbr_m := pra_zmp_zaj.tekuci_cvor_rbr;

  booking_rec_m := NULL;

  OPEN sj_c (zapis_p.sj_id_new);
  FETCH sj_c INTO booking_rec_m.Property, booking_rec_m.Room;
  CLOSE sj_c;
  
  IF booking_rec_m.Property IS NULL OR (INSERTING AND pra_zmp_s.oznaka ('P0054', booking_rec_m.Property) = 0)  -- IRN 3941
  THEN
    RETURN; -- podaci za promatrani SO ne alju se u MISH DOM
  END IF;
  
  -- IRN 4030 Dodano punjenje reg_vozila (RegPlate)
  IF zapis_p.rezvsj_id IS NOT NULL AND zapis_p.sj_id_new IS NOT NULL THEN
    OPEN rez_c (zapis_p.rezvsj_id);
    FETCH rez_c INTO booking_rec_m.ReservationId, rez_reg_vozila_l;
    CLOSE rez_c;
    booking_rec_m.RegPlate := NVL (pra_dom_api.dom_reg_vozila (zapis_p.rezvsj_id, zapis_p.sj_id_new , dom_param_1003_m), rez_reg_vozila_l);  ---- dodana registracija sa t_rezervacije ako je registracija prazna u T_REZ_GOSTI
  ELSE
    booking_rec_m.ReservationId := NULL;
    booking_rec_m.RegPlate := TO_CHAR (NULL);
  END IF;

  -- IRN 4030 Dodano punjenje naziva agencije (Agency)
  IF zapis_p.age_id_new IS NOT NULL THEN 
    SELECT naziv INTO booking_rec_m.Agency
	  FROM m_agencije 
	 WHERE id = zapis_p.age_id_new; 
  ELSE
    booking_rec_m.Agency := TO_CHAR (NULL);
  END IF;

  -- IRN 4030 Dodano punjenje naziva grupe sa ponude (GuestGroup)
  IF zapis_p.ponso_id_new IS NOT NULL THEN 
    SELECT pon.naz_grupe INTO booking_rec_m.GuestGroup
	  FROM t_pon_so ponso, 
           t_pon_ojr ponojr, 
           t_ponude pon
	 WHERE ponso.id = zapis_p.ponso_id_new
       AND ponso.ponojr_id = ponojr.id (+) 
       AND ponojr.pon_id = pon.id (+);
  ELSE
    booking_rec_m.GuestGroup := TO_CHAR (NULL);
  END IF;

  -- IRN 4030 Dodano punjenje broja kartice (PayCard)
  BEGIN
    SELECT broj INTO booking_rec_m.PayCard
	  FROM tpka_kartice
	 WHERE gost_id = zapis_p.gost_id;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      booking_rec_m.PayCard := TO_CHAR (NULL);
  END;

  -- IRN 4030 Dodano punjenje usluge sa trokova (Service)
  booking_rec_m.Service := pra_dom_api.dom_tro_sus_usl_sifra (zapis_p.gost_id);

  -- IRN 4030 Dodano punjenje reg_vozila i ozn_spola (RegPlate, Sex)
  BEGIN
    SELECT DECODE (INSTR (dom_param_1003_m, 'G'), 0, TO_CHAR (NULL), reg_vozila) AS reg_vozila, 	  
	       DECODE (INSTR (dom_param_1003_m, 'F'), 0, TO_CHAR (NULL), CASE WHEN ozn_spola = '' THEN 'F' WHEN ozn_spola = 'M' THEN 'M' ELSE NULL END) AS ozn_spola 
	  INTO kgost_reg_vozila_l, 
		   booking_rec_m.Sex
	  FROM t_kgostiju
	 WHERE gost_id = zapis_p.gost_id;
     
     IF booking_rec_m.RegPlate IS NULL THEN
       booking_rec_m.RegPlate := kgost_reg_vozila_l;
     END IF;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
	  booking_rec_m.RegPlate := TO_CHAR (NULL);
	  booking_rec_m.Sex := TO_CHAR (NULL);
  END;

  -- IRN 3941
  IF UPDATING THEN
    OPEN sj_c (zapis_p.sj_id_old);
    FETCH sj_c INTO so_sifra_old_l, sj_broj_old_l;
    CLOSE sj_c;
    IF so_sifra_old_l IS NULL
      OR (pra_zmp_s.oznaka ('P0054', so_sifra_old_l) = 0
          AND pra_zmp_s.oznaka ('P0054', booking_rec_m.Property) = 0)
    THEN
      RETURN; -- podaci za promatrane SO ne alju se u MISH DOM
    END IF;
  END IF;

  booking_rec_m.BookingId := metcvor_rbr_m || '-' || zapis_p.god_poslovna || '-' || zapis_p.rbr;

  IF UPDATING AND pra_zmp_s.oznaka ('P0054', booking_rec_m.Property) = 0 THEN -- IRN 3941
    -- odjavi gosta iz stare SJ jer seli u ne-MISH DOM SJ
    booking_rec_m.Property := so_sifra_old_l;
    booking_rec_m.Room := sj_broj_old_l;
    booking_rec_m.Status := 'CHECKED OUT';
    booking_rec_m.CheckOut := TO_CHAR (SYSDATE, 'YYYY-MM-DD HH24:MI');
    booking_rec_m.Departure := TO_CHAR (SYSDATE, 'YYYY-MM-DD') || ' 00:00';
  ELSE
    IF zapis_p.ozn_prisutnosti_new = 'P' THEN
      booking_rec_m.Status := 'CHECKED IN';
    ELSE
      booking_rec_m.Status := 'CHECKED OUT';
      booking_rec_m.CheckOut := TO_CHAR (zapis_p.sat_odjave, 'YYYY-MM-DD HH24:MI');
    END IF;
    booking_rec_m.Departure := TO_CHAR (zapis_p.dat_odlaska_new, 'YYYY-MM-DD') || ' 00:00';
  END IF;

  booking_rec_m.Arrival := TO_CHAR (zapis_p.dat_dolaska_new, 'YYYY-MM-DD') || ' 00:00';
  booking_rec_m.Vip := zapis_p.ozn_vip_new;
  booking_rec_m.CheckIn := TO_CHAR (zapis_p.unos_dat, 'YYYY-MM-DD HH24:MI');
  IF INSTR (dom_param_1003_m, 'A') > 0 THEN
    booking_rec_m.FirstName := TRIM (zapis_p.ime_new);
  END IF;
  IF INSTR (dom_param_1003_m, 'B') > 0 THEN
    booking_rec_m.LastName := TRIM (zapis_p.prezime_new);
  END IF;
  IF UPDATING THEN
    booking_rec_m.BirthDate := TO_CHAR (pra_dom_api.dom_dat_rodjenja (dom_param_1003_m, zapis_p.gost_id, zapis_p.dat_dolaska_new, zapis_p.dat_odlaska_new), 'YYYY-MM-DD');
  END IF;
  IF INSTR (dom_param_1003_m, 'E') > 0 THEN
    SELECT MIN (sifra_2a) INTO booking_rec_m.Country FROM s_zemlje WHERE id = zapis_p.zem_id_new;
  END IF;

  dom_post_booking_zaj (NULL);

EXCEPTION
  WHEN OTHERS THEN
    pra_pka2.clob_to_table (opis_m || CHR(10) || SQLERRM || CHR(10) || CHR(10), log_file_name_m, NULL, 'DOM'); -- IRN 3941
END;
PROCEDURE DOM_POST_BOOKING_KGOST
 (GOST_ID_NEW_P IN t_gosti.id%TYPE
 ,GOST_ID_OLD_P IN t_gosti.id%TYPE
 ,DAT_RODJENJA_NEW_P IN t_kgostiju.dat_rodjenja%TYPE
 ,DAT_RODJENJA_OLD_P IN t_kgostiju.dat_rodjenja%TYPE
 ,OZN_SPOLA_NEW_P IN T_KGOSTIJU.OZN_SPOLA%TYPE
 ,REG_VOZILA_P IN T_KGOSTIJU.REG_VOZILA%TYPE
 )
 IS
-- Booking
-- proceduru pozivaju AIS_T_KGOSTIJU i AUS_T_KGOSTIJU
     
  dat_null_l DATE := TO_DATE ('01.01.1800', 'DD.MM.RRRR');

  CURSOR gost_c (gost_id_k IN t_gosti.id%TYPE) IS
    SELECT dat_dolaska, dat_odlaska
      FROM t_gosti
     WHERE id = gost_id_k;

  dat_dolaska_l      t_gosti.dat_dolaska%TYPE;
  dat_odlaska_l      t_gosti.dat_odlaska%TYPE;
  rez_reg_vozila_l   t_rezervacije.reg_vozila%TYPE;
BEGIN

  IF pra_zmp_zaj.zmppar_vrijednost ('DOM', '1001') = 'nebitno' -- timeout
    OR gost_id_new_p IS NULL
  THEN
    RETURN;
  END IF;

  /*
  Oznake podataka koje MISH alje u DOM: A = ime, B = prezime, C = datum roenja, D = datum roenja (samo za roendane u vrijeme boravka), 
  E = dravljanstvo, F = spol, G = registracija vozila ili nebitno.
  */
  dom_param_1003_m := pra_zmp_zaj.zmppar_vrijednost ('DOM', '1003');
  IF INSTR (dom_param_1003_m, 'C') = 0 AND INSTR (dom_param_1003_m, 'D') = 0 THEN
    RETURN;
  END IF;

  -- IRN 3941
  log_file_name_m := 'dom-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '.log';
  opis_m := '[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] {Booking}';
  -- KRAJ IRN 3941

  opis_m := opis_m || ' [*** dom_post_booking_kgost';

  booking_rec_m := NULL;

  IF INSERTING THEN 
    opis_m := opis_m || ' | inserting | ';
	-- IRN 4030
    IF INSTR (dom_param_1003_m, 'D') > 0 THEN
      -- IRN 4030
      IF dat_rodjenja_new_p IS NULL THEN
        RETURN;
      END IF;
      OPEN gost_c (gost_id_new_p);
      FETCH gost_c INTO dat_dolaska_l, dat_odlaska_l;
      CLOSE gost_c;
      IF dat_dolaska_l IS NULL OR dat_odlaska_l IS NULL THEN
        RETURN;
      END IF;
      IF ADD_MONTHS (dat_rodjenja_new_p, (pra_rec_s3.dob (dat_rodjenja_new_p, (dat_dolaska_l - 1)) + 1) * 12)
        BETWEEN dat_dolaska_l AND dat_odlaska_l
      THEN
        NULL;
      ELSE
        RETURN;
      END IF;
    ELSE
      NULL;
    END IF;
  ELSIF UPDATING
    AND (
           gost_id_new_p <> gost_id_old_p
        OR NVL (dat_rodjenja_new_p, dat_null_l) <> NVL (dat_rodjenja_old_p, dat_null_l)
        )
  THEN
    opis_m := opis_m || ' | updating | ';
    NULL;
  ELSE
    RETURN;
  END IF;
  opis_m := opis_m || zmp_zaj.korisnik (-1) || ' | ' || TO_CHAR (dat_rodjenja_new_p, 'DD.MM.RRRR') || ' | ' || TO_CHAR (dat_rodjenja_old_p, 'DD.MM.RRRR') || ']';

  -- IRN 3941
  metcvor_rbr_m := pra_zmp_zaj.tekuci_cvor_rbr;

  FOR c IN ( -- izvede se samo jednom
    SELECT
      so.sifra AS so_sifra,
      sj.broj AS sj_broj,
      sj.id AS sj_id,
      metcvor_rbr_m || '-' || gost.god_poslovna || '-' || gost.rbr AS BookingId,
      CASE
      WHEN gost.rezvsj_id IS NOT NULL THEN so2.sifra || '-' ||rez.god_poslovna || '-' || rez.rbr
      ELSE NULL
      END AS ReservationId,
      DECODE (gost.ozn_prisutnosti, 'P', 'CHECKED IN', 'CHECKED OUT') AS Status,
      TO_CHAR (gost.dat_dolaska, 'YYYY-MM-DD') || ' 00:00' AS Arrival,
      TO_CHAR (gost.dat_odlaska, 'YYYY-MM-DD') || ' 00:00' AS Departure,
      gost.ozn_vip AS Vip,
      TO_CHAR (gost.unos_dat, 'YYYY-MM-DD HH24:MI') AS CheckIn,
      DECODE (gost.ozn_prisutnosti, 'P', NULL, TO_CHAR (gost.sat_odjave, 'YYYY-MM-DD HH24:MI')) AS CheckOut,
      DECODE (INSTR (dom_param_1003_m, 'A'), 0, NULL, TRIM (gost.ime)) AS FirstName,
      DECODE (INSTR (dom_param_1003_m, 'B'), 0, NULL, TRIM (gost.prezime)) AS LastName,
      TO_CHAR (pra_dom_api.dom_dat_rodjenja (dom_param_1003_m, gost_id_new_p, gost.dat_dolaska, gost.dat_odlaska, dat_rodjenja_new_p), 'YYYY-MM-DD') AS BirthDate,
      DECODE (INSTR (dom_param_1003_m, 'E'), 0, NULL, zem.sifra_2a) AS Country,
      age.naziv AS Agency, -- IRN 4030
      pon.naz_grupe AS GuestGroup, -- IRN 4030
      pkakar.broj AS PayCard, -- IRN 4030
      pra_dom_api.dom_tro_sus_usl_sifra (gost.id) Service, -- IRN 4030
	  DECODE (INSTR (dom_param_1003_m, 'F'), 0, TO_CHAR (NULL), CASE WHEN NVL (ozn_spola_new_p, '')  = '' THEN 'F' WHEN NVL (ozn_spola_new_p, '')  = 'M' THEN 'M' ELSE NULL END) AS Sex, -- IRN 4030	  
      rez.reg_vozila AS RegPlate, -- IRN 4030
      gost.rezvsj_id AS RezVsjId -- IRN 4030
    FROM
      t_gosti gost,
      m_sj sj,
      m_so so,
      s_zemlje zem ,
      t_rez_vsj rezvsj,
      t_rezervacije rez,
      m_so so2,
      m_agencije age, -- IRN 4030
      t_pon_so ponso, -- IRN 4030
      t_pon_ojr ponojr, -- IRN 4030
      t_ponude pon, -- IRN 4030
      tpka_kartice pkakar -- IRN4030
    WHERE
      gost.id = gost_id_new_p
      AND gost.sj_id = sj.id
      AND sj.so_id = so.id
      AND gost.zem_id = zem.id
      AND TRUNC (SYSDATE) BETWEEN gost.dat_dolaska AND gost.dat_odlaska
      AND gost.rezvsj_id = rezvsj.id (+)  
	  AND rezvsj.rez_id = rez.id (+) 
	  AND rez.so_id = so2.id (+)
      AND gost.age_id = age.id (+) -- IRN 4030
      AND gost.ponso_id = ponso.id (+) -- IRN 4030
      AND ponso.ponojr_id = ponojr.id (+) -- IRN 4030
      AND ponojr.pon_id = pon.id (+) -- IRN 4030
      AND gost.id = pkakar.gost_id (+) -- IRN 4030
      AND pra_zmp_s.oznaka ('P0054', so.sifra) = -1
    )
  LOOP
    booking_rec_m.Property      := c.so_sifra;
    booking_rec_m.Room          := c.sj_broj;
    booking_rec_m.BookingId     := c.BookingId;
    booking_rec_m.ReservationId := c.ReservationId;
    booking_rec_m.Status        := c.Status;
    booking_rec_m.Arrival       := c.Arrival;
    booking_rec_m.Departure     := c.Departure;
    booking_rec_m.Vip           := c.Vip;
    booking_rec_m.CheckIn       := c.CheckIn;
    booking_rec_m.CheckOut      := c.CheckOut;
    booking_rec_m.FirstName     := c.FirstName;
    booking_rec_m.LastName      := c.LastName;
    booking_rec_m.BirthDate     := c.BirthDate;
    booking_rec_m.Country       := c.Country;
	-- IRN 4030
    booking_rec_m.Service       := c.Service;
    booking_rec_m.Agency        := c.Agency;
    booking_rec_m.GuestGroup    := c.GuestGroup;
    booking_rec_m.Sex           := c.Sex;
    booking_rec_m.PayCard       := c.PayCard;    
    rez_reg_vozila_l            := c.RegPlate;
    
    -- IRN 4030 Dodano punjenje reg_vozila (RegPlate)
    IF c.RezVsjId IS NOT NULL AND c.sj_id IS NOT NULL AND reg_vozila_p IS NULL THEN
      booking_rec_m.RegPlate := NVL (pra_dom_api.dom_reg_vozila (c.RezVsjId, c.sj_id, dom_param_1003_m), rez_reg_vozila_l);  -- dodana registracija sa t_rezervacije ako je registracija prazna u T_REZ_GOSTI
    ELSE
      booking_rec_m.RegPlate := reg_vozila_p;
    END IF;
    dom_post_booking_zaj (NULL);
  END LOOP;

EXCEPTION
  WHEN OTHERS THEN
    pra_pka2.clob_to_table (opis_m || CHR(10) || SQLERRM || CHR(10) || CHR(10), log_file_name_m, NULL, 'DOM'); -- IRN 3941
END;
PROCEDURE DOM_POST_BOOKING_REZ
 (ZAPIS_P IN tab_t_rezervacije_dom.rez_rec_type
 )
 IS
-- poziva se iz AUS_T_REZERVACIJE
  BookingId_l VARCHAR2(200);
BEGIN

  IF pra_zmp_zaj.zmppar_vrijednost ('DOM', '1001') = 'nebitno'
     THEN -- timeout
    RETURN;
  END IF;

  booking_rec_m := NULL;

  SELECT MIN (sifra) INTO booking_rec_m.Property FROM m_so WHERE id = zapis_p.rez_row_new.so_id;
  IF booking_rec_m.Property IS NULL
    OR pra_zmp_s.oznaka ('P0054', booking_rec_m.Property) = 0
  THEN
    RETURN; -- podaci za promatrani SO ne alju se u MISH DOM
  END IF;

  IF zapis_p.rez_row_new.dat_dolaska < TRUNC (SYSDATE)
    AND zapis_p.rez_row_old.dat_dolaska < TRUNC (SYSDATE)
  THEN
    RETURN;
  END IF;

  -- IRN 3941
  metcvor_rbr_m := pra_zmp_zaj.tekuci_cvor_rbr;

  -- IRN 4030 (Najvea dob djeteta ili nebitno.)
  dom_param_1011_m := pra_dom_api.dom_max_dob_djeteta; 

  -- IRN 3941
  log_file_name_m := 'dom-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '.log';
  opis_m := '[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] {Booking}';
  -- KRAJ IRN 3941

  /*
  Oznake podataka koje MISH alje u DOM: A = ime, B = prezime, C = datum roenja, D = datum roenja (samo za roendane u vrijeme boravka), 
  E = dravljanstvo, F = spol, G = registracija vozila ili nebitno.
  */
  dom_param_1003_m := pra_zmp_zaj.zmppar_vrijednost ('DOM', '1003');

  IF zapis_p.rez_row_new.oznaka <> zapis_p.rez_row_old.oznaka
    OR NVL (zapis_p.rez_row_new.ozn_vstorna, 0) <> NVL (zapis_p.rez_row_old.ozn_vstorna, 0)
    OR zapis_p.rez_row_new.dat_dolaska <> zapis_p.rez_row_old.dat_dolaska
    OR zapis_p.rez_row_new.dat_odlaska <> zapis_p.rez_row_old.dat_odlaska
    OR (NVL (zapis_p.rez_row_new.ime, '') <> NVL (zapis_p.rez_row_old.ime, '') AND INSTR (dom_param_1003_m, 'A') > 0)
    OR (zapis_p.rez_row_new.prezime <> zapis_p.rez_row_old.prezime AND INSTR (dom_param_1003_m, 'B') > 0)
    OR (NVL (zapis_p.rez_row_new.zem_id, 0) <> NVL (zapis_p.rez_row_old.zem_id, 0) AND INSTR (dom_param_1003_m, 'E') > 0)
    OR (NVL (zapis_p.rez_row_new.zemd_id, 0) <> NVL (zapis_p.rez_row_old.zemd_id, 0) AND INSTR (dom_param_1003_m, 'E') > 0)
    OR NVL (zapis_p.rez_row_new.ozn_vip, '') <> NVL (zapis_p.rez_row_old.ozn_vip, '')
    OR NVL (zapis_p.rez_row_new.napomena, '') <> NVL (zapis_p.rez_row_old.napomena, '')
  THEN

    IF INSTR (dom_param_1003_m, 'A') > 0 THEN
      booking_rec_m.FirstName := TRIM (zapis_p.rez_row_new.ime);
    END IF;
    IF INSTR (dom_param_1003_m, 'B') > 0 THEN
      booking_rec_m.LastName := TRIM (zapis_p.rez_row_new.prezime);
    END IF;
    IF INSTR (dom_param_1003_m, 'E') > 0 THEN
      SELECT MIN (sifra_2a) INTO booking_rec_m.Country
        FROM s_zemlje
       WHERE id = NVL (zapis_p.rez_row_new.zem_id, zapis_p.rez_row_new.zemd_id);
    END IF;

    opis_m := opis_m || ' [*** dom_post_booking_rez' || ' | updating | ' || zmp_zaj.korisnik (-1) || ' | ' || zapis_p.rez_row_new.ime || ' | ' || zapis_p.rez_row_new.prezime || ']'; -- IRN 3941

    BookingId_l := metcvor_rbr_m || '-' || zapis_p.rez_row_new.god_poslovna || '-' || zapis_p.rez_row_new.rbr; -- IRN 3941
    booking_rec_m.ReservationId := booking_rec_m.Property || '-' || zapis_p.rez_row_new.god_poslovna || '-' || zapis_p.rez_row_new.rbr; -- IRN 3941
    IF zapis_p.rez_row_new.oznaka = 'V' AND zapis_p.rez_row_new.ozn_vstorna IS NULL THEN
      booking_rec_m.Status := 'RESERVED';
    ELSIF zapis_p.rez_row_new.oznaka = 'P'
      OR (zapis_p.rez_row_old.dat_dolaska >= TRUNC (SYSDATE) AND zapis_p.rez_row_new.dat_dolaska < TRUNC (SYSDATE))
    THEN
      booking_rec_m.Status := 'CANCELLED';
    ELSIF zapis_p.rez_row_new.ozn_vstorna = '3' THEN
      booking_rec_m.Status := 'NO SHOW';
    END IF;
    booking_rec_m.Arrival := TO_CHAR (zapis_p.rez_row_new.dat_dolaska, 'YYYY-MM-DD') || ' 00:00';
    booking_rec_m.Departure := TO_CHAR (zapis_p.rez_row_new.dat_odlaska, 'YYYY-MM-DD') || ' 00:00';
    booking_rec_m.Vip := zapis_p.rez_row_new.ozn_vip;
    booking_rec_m.Message := zapis_p.rez_row_new.napomena;

	-- IRN 4030 Dodano punjenje naziva agencije (Agency)
    IF zapis_p.rez_row_new.age_id IS NOT NULL THEN -- na razini rezervacije
	  SELECT naziv INTO booking_rec_m.Agency
	    FROM m_agencije  
	   WHERE id = zapis_p.rez_row_new.age_id; 
	ELSE
	  booking_rec_m.Agency := TO_CHAR (NULL);
	END IF;

	-- IRN 4030 Dodano punjenje naziva grupe sa ponude (GuestGroup)
    IF zapis_p.rez_row_new.ponso_id IS NOT NULL THEN -- na razini rezervacije
	  SELECT pon.naz_grupe INTO booking_rec_m.GuestGroup
	    FROM t_pon_so ponso, 
             t_pon_ojr ponojr, 
             t_ponude pon
	   WHERE ponso.id = zapis_p.rez_row_new.ponso_id 
         AND ponso.ponojr_id = ponojr.id (+) 
         AND ponojr.pon_id = pon.id (+);
	ELSE
	  booking_rec_m.GuestGroup := TO_CHAR (NULL);
	END IF;

	-- IRN 4030
    booking_rec_m.PayCard := TO_CHAR (NULL); -- na rezervaciji nema PayCarda    
    booking_rec_m.Service := pra_dom_api.dom_rez_sus_usl_sifra (zapis_p.rez_row_new.id); -- usluga za cijelu rezervaciju
	booking_rec_m.Sex := TO_CHAR (NULL); 

    FOR rezvsj_c IN (
      SELECT id, sj_id, br_osoba
        FROM t_rez_vsj
       WHERE rez_id = zapis_p.rez_row_new.id
         AND br_osobaz IS NULL)
    LOOP
      IF rezvsj_c.sj_id IS NOT NULL THEN
        booking_rec_m.BookingId := BookingId_l || '-' || rezvsj_c.id;		
	    -- IRN 4030  
        booking_rec_m.RegPlate := pra_dom_api.dom_reg_vozila (rezvsj_c.id, NULL, dom_param_1003_m); 
		IF booking_rec_m.Status = 'RESERVED' THEN -- IRN 4030 Children i Adults se popunjavaju u statusu RESERVED
          booking_rec_m.Children := pra_dom_api.dom_broj_djece(rezvsj_c.id , NULL, TO_NUMBER (dom_param_1011_m));
          booking_rec_m.Adults := rezvsj_c.br_osoba - booking_rec_m.Children ;
          booking_rec_m.Adults := rezvsj_c.br_osoba - booking_rec_m.Children ;  -- IRN 4030 (izmjena naziva elementa resourca Booking : iz NoAdults --> Adults)	
        END IF;        
        dom_post_booking_zaj (rezvsj_c.sj_id);
      END IF;

      FOR recrezsj_c IN (
        SELECT id, sj_id, br_osoba
          FROM trec_rez_sj
         WHERE rezvsj_id = rezvsj_c.id
           AND br_osobaz IS NULL)
      LOOP
        booking_rec_m.BookingId := BookingId_l || '-' || recrezsj_c.id;
        -- IRN 4030 
        booking_rec_m.RegPlate := pra_dom_api.dom_reg_vozila (rezvsj_c.id, recrezsj_c.sj_id, dom_param_1003_m); 
		IF booking_rec_m.Status = 'RESERVED' THEN -- IRN 4030 Children i Adults se popunjavaju u statusu RESERVED
          booking_rec_m.Children := pra_dom_api.dom_broj_djece(rezvsj_c.id, recrezsj_c.sj_id, TO_NUMBER (dom_param_1011_m));
		  booking_rec_m.Adults := recrezsj_c.br_osoba - booking_rec_m.Children;	 -- IRN 4030 	
        END IF;         
        dom_post_booking_zaj (recrezsj_c.sj_id);
      END LOOP;
    END LOOP;
  END IF;

EXCEPTION
  WHEN OTHERS THEN
    pra_pka2.clob_to_table (opis_m || CHR(10) || SQLERRM || CHR(10) || CHR(10), log_file_name_m, NULL, 'DOM'); -- IRN 3941
END;
PROCEDURE DOM_POST_BOOKING_REZSJ
 (ZAPIS_P IN rezsj_rec_type
 ,TABLICA_P IN VARCHAR2
 )
 IS
-- proceduru pozivaju AIS/AUS/ADS tablica T_REZ_VSJ i TREC_REZ_SJ
  opis_end_l           VARCHAR2(1000);
  rez_reg_vozila_l     t_rezervacije.reg_vozila%TYPE;
  rezvsj_id_l          t_rez_vsj.id%TYPE;
BEGIN

  IF pra_zmp_zaj.zmppar_vrijednost ('DOM', '1001') = 'nebitno'  THEN -- timeout
    RETURN;
  END IF;

  -- IRN 4030
  IF INSERTING AND zapis_p.sj_id_new IS NULL THEN -- ako smjetajna jedinica nije popunjena kod INSERTING, nemamo to slati
    RETURN;
  END IF;
  
  log_file_name_m := 'dom-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '.log';
  opis_m := '[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] {Booking}';

  booking_rec_m := NULL;

  SELECT MIN (sifra) INTO booking_rec_m.Property FROM m_so WHERE id = zapis_p.rez_row.so_id;
  IF booking_rec_m.Property IS NULL
    OR pra_zmp_s.oznaka ('P0054', booking_rec_m.Property) = 0
  THEN
    RETURN; -- podaci za promatrani SO ne alju se u MISH DOM
  END IF;
  
  IF zapis_p.rez_row.dat_dolaska < TRUNC (SYSDATE) THEN
    RETURN; -- podaci za dolaske prije tekueg datuma ne alju se u Domainstvo
  END IF;

  -- IRN 3941
  metcvor_rbr_m := pra_zmp_zaj.tekuci_cvor_rbr;

  -- IRN 4030 (Najvea dob djeteta ili nebitno.)
  dom_param_1011_m := pra_dom_api.dom_max_dob_djeteta;

  /*
  Oznake podataka koje MISH alje u DOM: A = ime, B = prezime, C = datum roenja, D = datum roenja (samo za roendane u vrijeme boravka), 
  E = dravljanstvo, F = spol, G = registracija vozila ili nebitno.
  */
  dom_param_1003_m := pra_zmp_zaj.zmppar_vrijednost ('DOM', '1003');
  IF INSTR (dom_param_1003_m, 'A') > 0 THEN
    booking_rec_m.FirstName := TRIM (zapis_p.rez_row.ime);
  END IF;
  IF INSTR (dom_param_1003_m, 'B') > 0 THEN
    booking_rec_m.LastName := TRIM (zapis_p.rez_row.prezime);
  END IF;
  IF INSTR (dom_param_1003_m, 'E') > 0 THEN
    SELECT MIN (sifra_2a) INTO booking_rec_m.Country
      FROM s_zemlje
     WHERE id = NVL (zapis_p.rez_row.zem_id, zapis_p.rez_row.zemd_id);
  END IF;

  opis_m := opis_m || ' [*** dom_post_booking_rezsj'; -- IRN 3941
  opis_end_l := zmp_zaj.korisnik (-1) || ' | ' || zapis_p.rez_row.ime || ' | ' || zapis_p.rez_row.prezime || ']';

  booking_rec_m.BookingId := metcvor_rbr_m || '-' || zapis_p.rez_row.god_poslovna || '-' || zapis_p.rez_row.rbr || '-' || zapis_p.id;  -- IRN 3941
  booking_rec_m.ReservationId := booking_rec_m.Property || '-' || zapis_p.rez_row.god_poslovna || '-' || zapis_p.rez_row.rbr; -- IRN 3941
  booking_rec_m.Arrival := TO_CHAR (zapis_p.rez_row.dat_dolaska, 'YYYY-MM-DD') || ' 00:00';
  booking_rec_m.Departure := TO_CHAR (zapis_p.rez_row.dat_odlaska, 'YYYY-MM-DD') || ' 00:00';
  booking_rec_m.Vip := zapis_p.rez_row.ozn_vip;
  booking_rec_m.Message := zapis_p.rez_row.napomena;
  -- IRN 4030 Dodano punjenje usluge sa rezervacije (Service)
  booking_rec_m.Service := pra_dom_api.dom_rez_sus_usl_sifra (zapis_p.rez_row.id); -- usluga za cijelu rezervaciju

  -- IRN 4030 Dodano punjenje naziva agencije (Agency)
  IF zapis_p.rez_row.age_id IS NOT NULL THEN -- na razini rezervacije
	SELECT naziv INTO booking_rec_m.Agency
	  FROM m_agencije  
	 WHERE id = zapis_p.rez_row.age_id; 
  ELSE
    booking_rec_m.Agency := TO_CHAR (NULL);
  END IF;

  -- IRN 4030
  IF tablica_p = 'TREC_REZ_SJ' THEN
    rezvsj_id_l := zapis_p.rezvsj_id; 
  ELSE 
    rezvsj_id_l := zapis_p.id;
  END IF;
  
  -- IRN 4030 Dodano punjenje naziva grupe na ponudi (GuestGroup)
  IF zapis_p.rez_row.ponso_id IS NOT NULL THEN -- na razini rezervacije
    SELECT pon.naz_grupe INTO booking_rec_m.GuestGroup
	  FROM t_pon_so ponso, 
           t_pon_ojr ponojr, 
           t_ponude pon
	 WHERE ponso.id = zapis_p.rez_row.ponso_id 
       AND ponso.ponojr_id = ponojr.id (+) 
       AND ponojr.pon_id = pon.id (+);
  ELSE
    booking_rec_m.GuestGroup := TO_CHAR (NULL);
  END IF;
 -- IRN 4030 ako je status RESERVED popuni RegPlate, Children, Adults 
  IF zapis_p.sj_id_new IS NOT NULL THEN -- kod INSERTING i UPDATING (status: RESERVED)
    booking_rec_m.RegPlate := pra_dom_api.dom_reg_vozila (rezvsj_id_l, zapis_p.sj_id_new, dom_param_1003_m);
	IF booking_rec_m.RegPlate IS NULL AND zapis_p.rez_row.id IS NOT NULL THEN
	  SELECT reg_vozila INTO rez_reg_vozila_l FROM t_rezervacije WHERE id = zapis_p.rez_row.id;
	  booking_rec_m.RegPlate := rez_reg_vozila_l;
	END IF;
    booking_rec_m.Children := pra_dom_api.dom_broj_djece(rezvsj_id_l, zapis_p.sj_id_new, TO_NUMBER (dom_param_1011_m));
    booking_rec_m.Adults := zapis_p.br_osoba - booking_rec_m.Children;
  END IF;
  
  -- IRN 4030 
  booking_rec_m.Sex := TO_CHAR (NULL); 
  booking_rec_m.PayCard := TO_CHAR (NULL); -- na rezervaciji nema PayCarda    

  IF INSERTING AND zapis_p.sj_id_new IS NOT NULL THEN
    opis_m := opis_m || ' | inserting | ' || opis_end_l;
    booking_rec_m.Status := 'RESERVED';
    dom_post_booking_zaj (zapis_p.sj_id_new);
  ELSIF UPDATING THEN
    -- BUR stvori zapis samo ako su se mijenjali sj_id ili br_osoba
    opis_m := opis_m || ' | updating | ' || opis_end_l;
    IF zapis_p.sj_id_old IS NOT NULL AND zapis_p.sj_id_new IS NULL THEN
      booking_rec_m.Status := 'CANCELLED';
      dom_post_booking_zaj (zapis_p.sj_id_old);
    END IF;
    IF zapis_p.sj_id_new IS NOT NULL THEN
      booking_rec_m.Status := 'RESERVED';
      dom_post_booking_zaj (zapis_p.sj_id_new);
    END IF;
  ELSIF DELETING AND zapis_p.sj_id_old IS NOT NULL THEN
    opis_m := opis_m || ' | deleting | ' || opis_end_l;
    booking_rec_m.Status := 'CANCELLED';
    dom_post_booking_zaj (zapis_p.sj_id_old);
  END IF;

EXCEPTION
  WHEN OTHERS THEN
    pra_pka2.clob_to_table (opis_m || CHR(10) || SQLERRM || CHR(10) || CHR(10), log_file_name_m, NULL, 'DOM'); -- IRN 3941
END;
PROCEDURE DOM_POST_BOOKING_ZAJ
 (SJ_ID_P IN m_sj.id%TYPE
 )
 IS
-- poziva se iz dom_post_booking_gost, dom_post_booking_kgost, dom_post_booking_rezsj i dom_post_booking_rez
BEGIN

  IF sj_id_p IS NOT NULL THEN
    SELECT MIN (broj) INTO booking_rec_m.Room FROM m_sj WHERE id = sj_id_p;
  END IF;

  APEX_JSON.initialize_clob_output;
  APEX_JSON.open_object; -- {

  APEX_JSON.write ('Property', booking_rec_m.Property);
  APEX_JSON.write ('Room', booking_rec_m.Room);
  APEX_JSON.write ('BookingId', booking_rec_m.BookingId);
  APEX_JSON.write ('ReservationId', booking_rec_m.ReservationId);
  APEX_JSON.write ('Status', booking_rec_m.Status);
  APEX_JSON.write ('Arrival', booking_rec_m.Arrival);
  APEX_JSON.write ('Departure', booking_rec_m.Departure);
  APEX_JSON.write ('Vip', booking_rec_m.Vip);
  APEX_JSON.write ('CheckIn', booking_rec_m.CheckIn);
  APEX_JSON.write ('CheckOut', booking_rec_m.CheckOut);
  APEX_JSON.write ('Adults', booking_rec_m.Adults); -- IRN 4030 (izmjena naziva elementa resourca Booking : iz NoAdults --> Adults)
  APEX_JSON.write ('Message', booking_rec_m.Message);
  -- APEX_JSON.write ('GuestId', booking_rec_m.GuestId); IRN 3941
  APEX_JSON.write ('FirstName', booking_rec_m.FirstName);
  APEX_JSON.write ('LastName', booking_rec_m.LastName);
  APEX_JSON.write ('BirthDate', booking_rec_m.BirthDate);
  APEX_JSON.write ('Country', booking_rec_m.Country);
  -- IRN 4030 dodani novi property u resource Booking
  APEX_JSON.write ('Service', booking_rec_m.Service);
  APEX_JSON.write ('Agency', booking_rec_m.Agency);
  APEX_JSON.write ('GuestGroup', booking_rec_m.GuestGroup);
  APEX_JSON.write ('Children', booking_rec_m.Children);
  APEX_JSON.write ('Sex', booking_rec_m.Sex);
  APEX_JSON.write ('RegPlate', booking_rec_m.RegPlate);
  APEX_JSON.write ('PayCard', booking_rec_m.PayCard);

  APEX_JSON.close_object; -- }

  data_m := APEX_JSON.get_clob_output;
  data_m := REPLACE (data_m, CHR(10), '');
  data_m := REPLACE (data_m, '},', '},' || CHR(10));
  APEX_JSON.free_output;

  IF data_m IS NULL THEN
    RETURN;
  END IF;

  odgovor_m := NULL;
  dom_zaj_post (dom_param_1009_m);

END;
PROCEDURE DOM_POST_INIT_ASORTIMAN
 (GMPKAS_ID_P IN MGMP_KASE.ID%TYPE := NULL
 )
 IS
-- Initialization asortimana
-- proceduru poziva procedura post2dom_job
BEGIN
  IF pra_zmp_s.oznaka ('P0054') = 0 THEN
    RETURN;
  END IF;

  -- IRN 3941
  log_file_name_m := 'dom-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '.log';
  opis_m := '[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] {InitAsortiman}';
  -- KRAJ IRN 3941

  APEX_JSON.initialize_clob_output;
  APEX_JSON.open_array; -- [
  -- IRN 4030 izmjenjen SQL
  FOR c IN (
    SELECT so.sifra   AS so_sifra,
           pro.sifra  AS pro_sifra,
           pro.naziv  AS pro_naziv,
           asokase.pc AS cijena
      FROM m_aso_kase asokase,
           mgmp_kase gmpkas,
           m_proizvodi pro,
           mgas_gpor_raz gporraz,
           m_so so
     WHERE asokase.kase_id = gmpkas.id
       AND gmpkas.metapl_sifra = 'GAS'
       AND gmpkas.ozn_kase = 'M'
       AND asokase.pro_id = pro.id
       AND pro.gpor_id = gporraz.gpor_id
       AND SYSDATE BETWEEN gporraz.dat_valjan AND NVL(gporraz.dat_ponisten, SYSDATE)
       AND (gmpkas.so_id = so.id
           OR (gmpkas.so_id IS NULL AND gmpkas.zmpojr_id = so.ojr_id))
       AND pra_zmp_s.oznaka ('P0054', so.sifra) = -1
       AND (gmpkas_id_p IS NULL OR gmpkas_id_p = gmpkas.id)
    ORDER BY so.sifra, pro.sifra 
    )
  LOOP
    APEX_JSON.open_object; -- {
    APEX_JSON.write ('Property', c.so_sifra);   -- IRN 3941 dodan Property element
    APEX_JSON.write ('ItemId', c.pro_sifra);
    APEX_JSON.write ('ItemName', c.pro_naziv);
    APEX_JSON.write ('Price', c.cijena);
    APEX_JSON.close_object; -- }
  END LOOP;

  APEX_JSON.close_array; -- ]

  data_m := APEX_JSON.get_clob_output;
  data_m := REPLACE (data_m, CHR(10), '');
  data_m := REPLACE (data_m, '},', '},' || CHR(10));
  APEX_JSON.free_output;

  IF data_m IS NULL THEN
    RETURN;
  END IF;

  odgovor_m := NULL;
  dom_zaj_post (dom_param_1008_m);

EXCEPTION
  WHEN OTHERS THEN
    pra_pka2.clob_to_table (opis_m || CHR(10) || SQLERRM || CHR(10) || CHR(10), log_file_name_m, NULL, 'DOM'); -- IRN 3941
END;
PROCEDURE DOM_POST_INIT_BOOKING
 IS
-- Initialization Booking
-- proceduru poziva procedura post2dom_job
i            NUMBER;
BEGIN
  IF pra_zmp_s.oznaka ('P0054') = 0 THEN
    RETURN;
  END IF;

   i := 0;
  /*
  Oznake podataka koje MISH alje u DOM: A = ime, B = prezime, C = datum roenja, D = datum roenja (samo za roendane u vrijeme boravka), 
  E = dravljanstvo, F = spol, G = registracija vozila ili nebitno.
  */
  dom_param_1003_m := pra_zmp_zaj.zmppar_vrijednost ('DOM', '1003');
  -- IRN 3941
  metcvor_rbr_m := pra_zmp_zaj.tekuci_cvor_rbr;

  -- IRN 4030 (Najvea dob djeteta ili nebitno.)
  dom_param_1011_m := pra_dom_api.dom_max_dob_djeteta;

  -- IRN 3941
  log_file_name_m := 'dom-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '.log';
  opis_m := '[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] {InitBooking}';
  -- KRAJ IRN 3941

  FOR c IN (
    -- rezervacije
    SELECT
      -- -1 AS ozn_rez, IRN 3941
      so.sifra AS so_sifra,
      sj.broj AS sj_broj,
      metcvor_rbr_m || '-' || rez.god_poslovna || '-' || rez.rbr || '-' || rezvsj.id  AS rbr,
      so.sifra || '-' || rez.god_poslovna || '-' || rez.rbr ReservationId, -- IRN 3941
      'RESERVED' AS status,
      TO_CHAR (rez.dat_dolaska, 'YYYY-MM-DD') || ' 00:00' AS dat_dolaska,
      TO_CHAR (rez.dat_odlaska, 'YYYY-MM-DD') || ' 00:00' AS dat_odlaska,
      TO_CHAR (NULL) AS unos_dat,
      TO_CHAR (NULL) AS sat_odjave,
      DECODE (INSTR (dom_param_1003_m, 'A'), 0, NULL, TRIM (rez.ime)) AS ime,
      DECODE (INSTR (dom_param_1003_m, 'B'), 0, NULL, TRIM (rez.prezime)) AS prezime,
      TO_CHAR (NULL) AS dat_rodjenja,
      DECODE (INSTR (dom_param_1003_m, 'E'), 0, NULL, zem.sifra_2a) AS zem_sifra_2a,
      rezvsj.br_osoba - NVL (rez_reg_broj_djece.broj_djece, 0) AS adults,  -- IRN 4030
      rez.ozn_vip AS ozn_vip,
      rez.napomena AS napomena,
      age.naziv AS agencija, -- IRN 4030
      pon.naz_grupe AS naziv_grupe, -- IRN 4030
      TO_CHAR (NULL) AS broj_kartice, -- IRN 4030
	  DECODE (INSTR (dom_param_1003_m, 'G'), 0, TO_CHAR (NULL), rez_reg_broj_djece.reg_vozila) AS reg_vozila, -- IRN 4030
      NVL (rez_reg_broj_djece.broj_djece, 0) AS broj_djece, -- IRN 4030
      pra_dom_api.dom_rez_sus_usl_sifra (rez.id) AS sus_usluga, -- IRN 4030
      TO_CHAR (NULL) AS ozn_spola -- IRN 4030
    FROM
      (
      SELECT id, rez_id, sj_id, br_osoba
        FROM t_rez_vsj
       WHERE sj_id IS NOT NULL
         AND kol_sjz IS NULL -- jo nije checked in
      UNION
      SELECT recrezsj.id, rezvsj2.rez_id, recrezsj.sj_id, recrezsj.br_osoba
        FROM trec_rez_sj recrezsj,
             t_rez_vsj rezvsj2
       WHERE recrezsj.rezvsj_id = rezvsj2.id
         AND recrezsj.br_osobaz IS NULL -- jo nije checked in
      ) rezvsj,
      (
      SELECT 
        rezvsj.id AS rezvsj_id, NVL (rezvsj.sj_id, rezgost.sj_id) rezvsj_sj_id,
        MAX(rezgost.reg_vozila) AS reg_vozila,
        COUNT(
         CASE 
           WHEN TO_NUMBER(dom_param_1011_m) <> 0
            AND (NVL(rezgost.dob, pra_rec_s3.dob(rezgost.dat_rodjenja, SYSDATE)) <= TO_NUMBER(dom_param_1011_m))
            AND (rezgost.dob IS NOT NULL OR rezgost.dat_rodjenja IS NOT NULL)
         THEN 1 
         ELSE NULL
         END
         ) AS broj_djece
      FROM 
        t_rez_gost rezgost,
        t_rez_vsj rezvsj
      WHERE rezgost.rezvsj_id = rezvsj.id 
        AND (rezvsj.sj_id IS NOT NULL OR rezgost.sj_id IS NOT NULL)
      GROUP BY 
        rezvsj.id, NVL (rezvsj.sj_id, rezgost.sj_id)) rez_reg_broj_djece, -- IRN 4030
      m_sj sj,
      t_rezervacije rez,
      m_so so,
      s_zemlje zem,
      m_agencije age, -- IRN 4030
      t_pon_so ponso, -- IRN 4030
      t_pon_ojr ponojr, -- IRN 4030
      t_ponude pon -- IRN 4030
    WHERE
      rezvsj.rez_id = rez.id
      AND rezvsj.sj_id = sj.id
      AND rez.so_id = so.id
      AND NVL (rez.zem_id, rez.zemd_id) = zem.id (+)
      AND rez.oznaka = 'V'
      AND rez.ozn_vstorna IS NULL
      AND rez.dat_dolaska >= TRUNC (SYSDATE)
      AND rez.age_id = age.id (+) -- IRN 4030
      AND rez.ponso_id = ponso.id (+) -- IRN 4030
      AND ponso.ponojr_id = ponojr.id (+) -- IRN 4030
      AND ponojr.pon_id = pon.id (+) -- IRN 4030
      AND rezvsj.id = rez_reg_broj_djece.rezvsj_id (+) -- IRN 4030
      AND rezvsj.sj_id = rez_reg_broj_djece.rezvsj_sj_id (+) -- IRN 4030
      AND pra_zmp_s.oznaka ('P0054', so.sifra) = -1
    UNION
     -- gosti
     SELECT
       so.sifra AS so_sifra,
       sj.broj AS sj_broj,
       metcvor_rbr_m || '-' || gost.god_poslovna || '-' || gost.rbr AS rbr,
       CASE
         WHEN gost.rezvsj_id IS NOT NULL THEN so2.sifra || '-' || rez.god_poslovna || '-' || rez.rbr
       ELSE NULL
       END AS ReservationId,
       DECODE (gost.ozn_prisutnosti, 'P', 'CHECKED IN', 'CHECKED OUT') AS status,
       TO_CHAR (gost.dat_dolaska, 'YYYY-MM-DD') || ' 00:00' AS dat_dolaska,
       TO_CHAR (gost.dat_odlaska, 'YYYY-MM-DD') || ' 00:00' AS dat_odlaska,
       TO_CHAR (gost.unos_dat, 'YYYY-MM-DD HH24:MI') AS unos_dat,
       DECODE (gost.ozn_prisutnosti, 'P', NULL, TO_CHAR (gost.sat_odjave, 'YYYY-MM-DD HH24:MI')) AS sat_odjave,
       DECODE (INSTR (dom_param_1003_m, 'A'), 0, NULL, TRIM (gost.ime)) AS ime,
       DECODE (INSTR (dom_param_1003_m, 'B'), 0, NULL, TRIM (gost.prezime)) AS prezime,
       TO_CHAR (pra_dom_api.dom_dat_rodjenja (dom_param_1003_m, gost.id, gost.dat_dolaska, gost.dat_odlaska), 'YYYY-MM-DD') AS dat_rodjenja,
       DECODE (INSTR (dom_param_1003_m, 'E'), 0, NULL, zem.sifra_2a) AS zem_sifra_2a,
       0 AS adults,  -- IRN 4030
       gost.ozn_vip AS ozn_vip,
       TO_CHAR (NULL) AS napomena,
       age.naziv AS agencija, -- IRN 4030
       pon.naz_grupe AS naziv_grupe, -- IRN 4030
       pkakar.broj AS broj_kartice, -- IRN 4030
       DECODE (INSTR (dom_param_1003_m, 'G'), 0, TO_CHAR (NULL), kgost.reg_vozila) AS reg_vozila, -- IRN 4030
       0 broj_djece, -- IRN 4030
       pra_dom_api.dom_tro_sus_usl_sifra (gost.id) sus_usluga, -- IRN 4030
       DECODE (INSTR (dom_param_1003_m, 'F'), 0, TO_CHAR (NULL), 
       CASE WHEN kgost.ozn_spola = '' THEN 'F'
            WHEN kgost.ozn_spola = 'M' THEN 'M'
            ELSE NULL
       END) AS ozn_spola -- IRN 4030
    FROM
      t_gosti gost,
      m_sj sj,
      m_so so,
      s_zemlje zem,
      t_rez_vsj rezvsj,
      t_rezervacije rez,
      m_so so2,
      m_agencije age, -- IRN 4030
      t_pon_so ponso, -- IRN 4030
      t_pon_ojr ponojr, -- IRN 4030
      t_ponude pon, -- IRN 4030
      tpka_kartice pkakar, -- IRN 4030
      t_kgostiju kgost -- IRN 4030
    WHERE TRUNC (SYSDATE) BETWEEN gost.dat_dolaska AND GREATEST (gost.dat_odlaska, NVL (TRUNC (gost.sat_odjave), gost.dat_odlaska))
      AND NVL (gost.ozn_brisano, 0) = 0
      AND gost.id NOT IN (SELECT id FROM trec_kplovila)
      AND gost.sj_id = sj.id
      AND sj.so_id = so.id
      AND gost.zem_id = zem.id
      AND gost.rezvsj_id = rezvsj.id (+)
      AND rezvsj.rez_id = rez.id (+)
      AND rez.so_id = so2.id (+)
      AND gost.age_id = age.id (+) -- IRN 4030
      AND gost.ponso_id = ponso.id (+) -- IRN 4030
      AND ponso.ponojr_id = ponojr.id (+) -- IRN 4030
      AND ponojr.pon_id = pon.id (+) -- IRN 4030
      AND gost.id = pkakar.gost_id (+) -- IRN 4030
      AND gost.id = kgost.gost_id (+) -- IRN 4030
      AND NVL (kgost.oznaka,'V') = 'V' -- IRN 4030
      AND pra_zmp_s.oznaka ('P0054', so.sifra) = -1
  ORDER BY 1, 2, 3, 4)
  LOOP
    IF i = 0 THEN
      APEX_JSON.initialize_clob_output;
      APEX_JSON.open_array; -- [
	END IF;
    APEX_JSON.open_object; -- {
    APEX_JSON.write ('Property', c.so_sifra);
    APEX_JSON.write ('Room', c.sj_broj);
    APEX_JSON.write ('BookingId', c.rbr);
    APEX_JSON.write ('ReservationId', c.ReservationId);
    APEX_JSON.write ('Status', c.status);
    APEX_JSON.write ('Arrival', c.dat_dolaska);
    APEX_JSON.write ('Departure', c.dat_odlaska);
    APEX_JSON.write ('Vip', c.ozn_vip, TRUE);
    APEX_JSON.write ('CheckIn', c.unos_dat, TRUE);
    APEX_JSON.write ('CheckOut', c.sat_odjave, TRUE);
    APEX_JSON.write ('Message', c.napomena);
    APEX_JSON.write ('FirstName', c.ime, TRUE);
    APEX_JSON.write ('LastName', c.prezime, TRUE);
    APEX_JSON.write ('BirthDate', c.dat_rodjenja, TRUE);
    APEX_JSON.write ('Country', c.zem_sifra_2a, TRUE);
    -- IRN 4030 Adults i Children se pune u statusu RESERVED
    IF c.status IN ('RESERVED') THEN
      APEX_JSON.write ('Adults', c.adults);
      APEX_JSON.write ('Children', c.broj_djece); 
    END IF;
    APEX_JSON.write ('Service', c.sus_usluga); 
    APEX_JSON.write ('Agency', c.agencija);
    APEX_JSON.write ('GuestGroup', c.naziv_grupe); 
    APEX_JSON.write ('Sex', c.ozn_spola); 
    APEX_JSON.write ('RegPlate', c.reg_vozila); 
    APEX_JSON.write ('PayCard', c.broj_kartice);

    APEX_JSON.close_object; -- }
	i := i+1;
    IF i = 100 THEN
	   i := 0;
       APEX_JSON.close_array; -- ]

       data_m := APEX_JSON.get_clob_output;
       data_m := REPLACE (data_m, CHR(10), ''); -- ukloni suvine CrLf
       data_m := REPLACE (data_m, '},', '},' || CHR(10)); -- jedan zapis u jedan redak
       APEX_JSON.free_output;

       IF data_m IS NULL THEN
         RETURN;
       END IF;

       odgovor_m := NULL;
       dom_zaj_post (dom_param_1006_m);
	END IF;
  END LOOP;

  IF i <> 0 THEN
    APEX_JSON.close_array; -- ]

    data_m := APEX_JSON.get_clob_output;
    data_m := REPLACE (data_m, CHR(10), ''); -- ukloni suvine CrLf
    data_m := REPLACE (data_m, '},', '},' || CHR(10)); -- jedan zapis u jedan redak
    APEX_JSON.free_output;

    IF data_m IS NULL THEN
      RETURN;
    END IF;

    odgovor_m := NULL;
    dom_zaj_post (dom_param_1006_m);
  END IF;

EXCEPTION
  WHEN OTHERS THEN
    pra_pka2.clob_to_table (opis_m || CHR(10) || SQLERRM || CHR(10) || CHR(10), log_file_name_m, NULL, 'DOM'); -- IRN 3941
END;
PROCEDURE DOM_POST_INIT_ROOM_STATUS
 IS
-- Initialization Room Status
-- proceduru poziva procedura post2dom_job
BEGIN
  IF pra_zmp_s.oznaka ('P0054') = 0 THEN
    RETURN;
  END IF;
  
  -- IRN 3941
  log_file_name_m := 'dom-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '.log';
  opis_m := '[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] {InitRoomStatus}';
  -- KRAJ IRN 3941

  APEX_JSON.initialize_clob_output;

  APEX_JSON.open_array; -- [

  FOR c IN (
    SELECT
      so.sifra AS so_sifra,
      sj.broj AS sj_broj,
      so.sifra || '-' || recodr.god_poslovna || '-' || recodr.rbr AS recodr_rbr,
      TO_CHAR (recodr.dat_poc, 'YYYY-MM-DD') AS recodr_dat_poc,
      TO_CHAR (recodr.dat_zav, 'YYYY-MM-DD') AS recodr_dat_zav,
      CASE -- 13.8.2018.
        WHEN recodr.dat_poc = recodr.dat_zav AND recodr.dat_zav <= TRUNC (SYSDATE) THEN
          TO_CHAR (recodr.dat_zav, 'YYYY-MM-DD')
        WHEN recodr.dat_poc < recodr.dat_zav AND (recodr.dat_zav - 1) <= TRUNC (SYSDATE) THEN
          TO_CHAR ((recodr.dat_zav - 1), 'YYYY-MM-DD')
        ELSE
          TO_CHAR (NULL)
      END AS completed,
      DECODE (recodr.ozn_i, 2, 'OOS', 3, 'OOO') AS status,
      TRIM (NVL (recodr.napomena, DECODE (recodr.ozn_i, 2, 'OOS', 3, 'OOO'))) AS recodr_napomena
    FROM
      trec_odrzavanje recodr,
      m_sj sj,
      m_so so
    WHERE recodr.oznaka = 'V'
      AND TRUNC (SYSDATE) BETWEEN recodr.dat_poc AND recodr.dat_zav
      AND recodr.sj_id = sj.id
      AND sj.so_id = so.id
      AND recodr.ozn_i IN (2, 3) -- u kvaru ili izvan upotrebe
      AND pra_zmp_s.oznaka ('P0054', so.sifra) = -1
    ORDER BY so.sifra, sj.broj
    )
  LOOP
    APEX_JSON.open_object; -- {
    APEX_JSON.write ('Property', c.so_sifra);
    APEX_JSON.write ('Room', c.sj_broj);
    APEX_JSON.write ('RoomStatusId', c.recodr_rbr);
    APEX_JSON.write ('Begin', c.recodr_dat_poc);
    APEX_JSON.write ('End',  c.recodr_dat_zav);
    APEX_JSON.write ('Completed', c.completed, TRUE);
    APEX_JSON.write ('Status', c.status);
    APEX_JSON.write ('Reason', c.recodr_napomena, TRUE);
    APEX_JSON.close_object; -- }
  END LOOP;

  APEX_JSON.close_array; -- ]

  data_m := APEX_JSON.get_clob_output;
  data_m := REPLACE (data_m, CHR(10), '');
  data_m := REPLACE (data_m, '},', '},' || CHR(10));
  APEX_JSON.free_output;

  IF data_m IS NULL THEN
    RETURN;
  END IF;

  odgovor_m := NULL;
  dom_zaj_post (dom_param_1007_m);

EXCEPTION
  WHEN OTHERS THEN
    pra_pka2.clob_to_table (opis_m || CHR(10) || SQLERRM || CHR(10) || CHR(10), log_file_name_m, NULL, 'DOM'); -- IRN 3941
END;
PROCEDURE DOM_POST_ROOM_CLEANNESS
 (PROPERTY_P IN m_so.sifra%TYPE
 ,ROOM_P IN m_sj.broj%TYPE
 ,CLEANNESS_P IN VARCHAR2
 ,ODGOVOR_P OUT VARCHAR2
 )
 IS
-- proceduru poziva ORDS
  recpro_opis_l lrec_promjene.opis%TYPE;
  CURSOR so_c IS
    SELECT id, metcvor_sifra
      FROM m_so
     WHERE sifra = property_p;
  so_c_l so_c%ROWTYPE;
  sj_id_l m_sj.id%TYPE;
  ozn_domacice1_l trec_idomacice.ozn_domacice1%TYPE;
  unos_korisnik_l trec_idomacice.unos_korisnik%TYPE := zmp_zaj.korisnik (-1);
  naredba_l VARCHAR2(1000);
BEGIN

  -- IRN 3941
  log_file_name_m := 'Room-Cleanness-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '.log'; -- IRN 4030 promjena naziva log filea iz dom- u Room-Cleanness-
  opis_m :=
    '[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' ||
    '{Room Cleanness} < ' || property_p || '; ' || room_p || '; ' || cleanness_p;
  -- KRAJ IRN 3941

  -- Nedostaje obvezan ulazni parametar (#0).
  IF property_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'Property');
  ELSIF room_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'Room');
  ELSIF cleanness_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'Cleanness');
  END IF;

  OPEN so_c;
  FETCH so_c INTO so_c_l;
  CLOSE so_c;
  IF so_c_l.id IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'Property ' || property_p);
  END IF;

  SELECT MIN(id) INTO sj_id_l FROM m_sj WHERE so_id = so_c_l.id AND broj = room_p;
  IF sj_id_l IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'Room ' || room_p);
  END IF;

  -- Cleanness status. Available: CL = cleaned, DI = dirty, IN = inspected (optional)
  IF    cleanness_p = 'CL' THEN ozn_domacice1_l := 2; -- ista
  ELSIF cleanness_p = 'DI' THEN ozn_domacice1_l := 5; -- prljava
  ELSIF cleanness_p = 'IN' THEN ozn_domacice1_l := 1; -- pregledana
  ELSE
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'Cleanness ' || cleanness_p);
  END IF;

  -- dodan parametar property_p
  IF so_c_l.metcvor_sifra = pra_zmp_zaj.tekuci_cvor THEN
    pra_dom_api.dom_insert_recidom (property_p, sj_id_l, ozn_domacice1_l, unos_korisnik_l, odgovor_p);
  ELSE
    -- radi samo ako se poziva sa centra
    naredba_l := 'BEGIN pra_dom_api.dom_insert_recidom<CVOR> (:property_p, :sj_id_l, :ozn_domacice1_l, :unos_korisnik_l, :odgovor_p); END;';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', '@' || so_c_l.metcvor_sifra)
      USING property_p, sj_id_l, ozn_domacice1_l, unos_korisnik_l, OUT odgovor_p;
  END IF;
  
  -- IRN 4030 -- ako je dogovor like ERROR
  IF odgovor_p IS NOT NULL AND UPPER(TRIM(odgovor_p)) LIKE 'ERROR%' THEN
      pra_pka2.clob_to_table(opis_m || CHR(10) || odgovor_p || CHR(10), log_file_name_m, NULL, 'DOM');
      odgovor_p := NULL;
      RETURN; -- izai van
  END IF;

EXCEPTION
  WHEN OTHERS THEN
    odgovor_p := SUBSTR ('ERROR ' || SQLERRM, 1, 2000);
    pra_pka2.clob_to_table (opis_m || CHR(10) || SQLERRM || CHR(10) || CHR(10), log_file_name_m, NULL, 'DOM'); -- 3941
END;
PROCEDURE DOM_POST_ROOM_MINIBAR
 (PROPERTY_P IN m_so.sifra%TYPE
 ,ROOM_P IN m_sj.broj%TYPE
 ,BOOKING_ID_P IN VARCHAR2
 ,ITEM_ID_P IN m_proizvodi.sif_proizvoda_kasa%TYPE
 ,QUANTITY_P IN t_rnkase_pro.kolicina%TYPE
 ,ODGOVOR_P OUT VARCHAR2
 )
 IS
-- proceduru poziva ORDS
  recpro_opis_l lrec_promjene.opis%TYPE;
  CURSOR so_c IS
    SELECT id, metcvor_sifra, ojr_id
      FROM m_so
     WHERE sifra = property_p;
  so_c_l so_c%ROWTYPE;
  sj_id_l m_sj.id%TYPE;
  CURSOR gmpkas_c IS
    SELECT id
      FROM mgmp_kase
     WHERE metapl_sifra = 'GAS'
       AND ozn_kase = 'M'
       AND zmpojr_id = so_c_l.ojr_id
       AND NVL (so_id, so_c_l.id) = so_c_l.id
       AND TRUNC (SYSDATE) BETWEEN dat_valjan AND (NVL (dat_ponisten, TO_DATE ('31.12.9999', 'DD.MM.RRRR')) - 1)
     ORDER BY sifra;
  gmpkas_id_l mgmp_kase.id%TYPE;
  pro_id_l m_proizvodi.id%TYPE;
  odgovor_l VARCHAR2(2000);
  naredba_l VARCHAR2(1000);
  booking_id_l VARCHAR2(20);
BEGIN

  -- IRN 3941
  log_file_name_m := 'Room-Minibar-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '.log'; -- IRN 4030 promjena naziva log filea iz dom- u Room-Minibar-
  opis_m :=
    '[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' ||
    '{Room Minibar} < ' || property_p || '; ' || room_p || '; ' || booking_id_p || '; ' || item_id_p || '; ' || quantity_p;
  -- KRAJ IRN 3941

  -- Nedostaje obvezan ulazni parametar (#0).
  IF property_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'Property');
  ELSIF room_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'Room');
  -- booking_id_p -- moe biti NULL
  ELSIF item_id_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'ItemId');
  ELSIF quantity_p IS NULL THEN
    pra_rec_zaj.vrati_poruku (-20422, 'Quantity');
  END IF;

  OPEN so_c;
  FETCH so_c INTO so_c_l;
  CLOSE so_c;
  IF so_c_l.id IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'Property ' || property_p);
  END IF;

  SELECT MIN(id) INTO sj_id_l FROM m_sj WHERE so_id = so_c_l.id AND broj = room_p;
  IF sj_id_l IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'Room ' || room_p);
  END IF;

  OPEN gmpkas_c;
  FETCH gmpkas_c INTO gmpkas_id_l;
  CLOSE gmpkas_c;
  IF gmpkas_id_l IS NULL THEN
    -- #0 #1 --> Ne postoji kasa vrste minibar.
    pra_zmp_zaj.vrati_poruku (-20000, 'GAS0632', pra_zmp_zaj.poruka ('GAS', 'GAS0632'));
  END IF;

  SELECT MIN (id) INTO pro_id_l FROM m_proizvodi WHERE sif_proizvoda_kasa = item_id_p;
  IF pro_id_l IS NULL THEN
    -- Pogrena vrijednost ulaznog parametra (#0)!
    pra_zmp_zaj.vrati_poruku (-20099, 'ItemId ' || item_id_p);
  END IF;

  -- ukloni ifru smjetajnog objekta iz booking_id npr. 801-2018-123456 u 2018-123456
  booking_id_l := SUBSTR (booking_id_p, INSTR (booking_id_p, '-') + 1);

  -- dodan parametar property_p
  IF so_c_l.metcvor_sifra = pra_zmp_zaj.tekuci_cvor THEN
    pra_dom_api.dom_upisi_racun (property_p, sj_id_l, pro_id_l, quantity_p, booking_id_l, gmpkas_id_l, odgovor_l);
  ELSE
    -- radi samo ako se poziva sa centra
    naredba_l := 'BEGIN pra_dom_api.dom_upisi_racun<CVOR> (:property_p, :sj_id_l, :pro_id_l, :quantity_p, :booking_id_l, :gmpkas_id_l, :odgovor_l); END;';
    EXECUTE IMMEDIATE REPLACE (naredba_l, '<CVOR>', '@' || so_c_l.metcvor_sifra)
      USING property_p, sj_id_l, pro_id_l, quantity_p, booking_id_l, gmpkas_id_l, OUT odgovor_l;
  END IF;

  IF odgovor_l = 'OK' THEN
    odgovor_p := odgovor_l;
  ELSE
    -- IRN 4030 ako odgovor nije OK logiraj greku
    pra_pka2.clob_to_table(opis_m || CHR(10) || odgovor_l || CHR(10), log_file_name_m, NULL, 'DOM');
    -- #0 #1
    pra_zmp_zaj.vrati_poruku (-20000, odgovor_l, '{Room Minibar}');
  END IF;

EXCEPTION
  WHEN OTHERS THEN
    odgovor_p := SUBSTR ('ERROR ' || SQLERRM, 1, 2000);
    pra_pka2.clob_to_table (opis_m || CHR(10) || SQLERRM || CHR(10) || CHR(10), log_file_name_m, NULL, 'DOM'); -- IRN 3941
END;
PROCEDURE DOM_POST_ROOM_STATUS
 (SJ_ID_P IN trec_odrzavanje.sj_id%TYPE
 ,GOD_POSLOVNA_P IN trec_odrzavanje.god_poslovna%TYPE
 ,RBR_P IN trec_odrzavanje.rbr%TYPE
 ,DAT_POC_P IN trec_odrzavanje.dat_poc%TYPE
 ,DAT_ZAV_P IN trec_odrzavanje.dat_zav%TYPE
 ,OZNAKA_P IN trec_odrzavanje.oznaka%TYPE
 ,OZN_I_P IN trec_odrzavanje.ozn_i%TYPE
 ,NAPOMENA_P IN trec_odrzavanje.napomena%TYPE
 )
 IS
-- Room Status
-- proceduru pozivaju AIS_TREC_ODRZAVANJE i AUS_TREC_ODRZAVANJE
  completed_l VARCHAR2(10);
BEGIN

  IF pra_zmp_zaj.zmppar_vrijednost ('DOM', '1001') = 'nebitno' -- timeout
  THEN
    RETURN;
  END IF;

  IF sj_id_p IS NULL
    OR god_poslovna_p IS NULL
    OR rbr_p IS NULL
    OR dat_poc_p IS NULL
    OR dat_zav_p IS NULL
    OR oznaka_p IS NULL
    OR ozn_i_p NOT IN (2, 3) -- u kvaru ili izvan upotrebe
    -- napomena_p
  THEN
    RETURN;
  END IF;

  -- IRN 3941
  log_file_name_m := 'dom-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '.log';
  opis_m := '[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] {RoomStatus}';
  -- KRAJ IRN 3941

  IF oznaka_p = 'V' THEN -- 13.08.2018.
    IF dat_poc_p = dat_zav_p AND dat_zav_p <= TRUNC (SYSDATE) THEN
      completed_l := TO_CHAR (dat_zav_p, 'YYYY-MM-DD');
    ELSIF dat_poc_p < dat_zav_p AND (dat_zav_p - 1) <= TRUNC (SYSDATE) THEN
      completed_l := TO_CHAR ((dat_zav_p - 1), 'YYYY-MM-DD');
    END IF;
  ELSE
    completed_l := TO_CHAR (SYSDATE, 'YYYY-MM-DD');
  END IF;

  APEX_JSON.initialize_clob_output;

  FOR c IN (
    SELECT
      so.sifra AS so_sifra,
      sj.broj AS Room,
      so.sifra || '-' || god_poslovna_p || '-' || rbr_p AS RoomStatusId,
      TO_CHAR (dat_poc_p, 'YYYY-MM-DD') AS dat_poc,
      TO_CHAR (dat_zav_p, 'YYYY-MM-DD') AS dat_zav,
      completed_l AS Completed, -- 13.08.2018.
      DECODE (ozn_i_p, 2, 'OOS', 3, 'OOO') AS Status,
      TRIM (napomena_p) AS Reason
    FROM
      m_sj sj,
      m_so so
    WHERE
      sj.id = sj_id_p
      AND sj.so_id = so.id
      AND pra_zmp_s.oznaka ('P0054', so.sifra) = -1
    )
  LOOP
    APEX_JSON.open_object; -- {
    APEX_JSON.write ('Property', c.so_sifra);
    APEX_JSON.write ('Room', c.Room);
    APEX_JSON.write ('RoomStatusId', c.RoomStatusId);
    APEX_JSON.write ('Begin', c.dat_poc);
    APEX_JSON.write ('End', c.dat_zav);
    APEX_JSON.write ('Completed', c.Completed, TRUE);
    APEX_JSON.write ('Status', c.Status);
    APEX_JSON.write ('Reason', c.Reason, TRUE);
    APEX_JSON.close_object; -- }
  END LOOP;

  data_m := APEX_JSON.get_clob_output;
  data_m := REPLACE (data_m, CHR(10), '');
  data_m := REPLACE (data_m, '},', '},' || CHR(10));
  APEX_JSON.free_output;

  IF data_m IS NULL THEN
    RETURN;
  END IF;

  odgovor_m := NULL;
  dom_zaj_post (dom_param_1010_m);

EXCEPTION
  WHEN OTHERS THEN
    pra_pka2.clob_to_table (opis_m || CHR(10) || SQLERRM || CHR(10) || CHR(10), log_file_name_m, NULL, 'DOM'); -- IRN 3941
END;
PROCEDURE DOM_UPISI_RACUN
 (SO_SIFRA_P IN M_SO.SIFRA%TYPE
 ,SJ_ID_P IN M_SJ.ID%TYPE
 ,PRO_ID_P IN M_PROIZVODI.ID%TYPE
 ,QUANTITY_P IN T_RNKASE_PRO.KOLICINA%TYPE
 ,BOOKING_ID_P IN VARCHAR2
 ,GMPKAS_ID_P IN MGMP_KASE.ID%TYPE
 ,ODGOVOR_P OUT VARCHAR2
 )
 IS
-- poziva se iz procedure dom_post_room_minibar
  CURSOR gost1_c IS
    SELECT id, ozn_rnk, ime, prezime
      FROM t_gosti
     WHERE sj_id = sj_id_p
       AND god_poslovna = SUBSTR (booking_id_p, 1, 4) -- booking_id_p npr. 2018-123456
       AND rbr = SUBSTR (booking_id_p, 6, 6);

  CURSOR gost2_c IS
    SELECT id, ozn_rnk, ime, prezime
      FROM t_gosti
     WHERE sj_id = sj_id_p
       AND TRUNC (SYSDATE) BETWEEN dat_dolaska AND dat_odlaska
       AND ozn_prisutnosti = 'P'
     ORDER BY ozn_platitelj, rbr;

  gost_c_l gost1_c%ROWTYPE; -- ili gost2_c%ROWTYPE

  CURSOR asokase_c IS
    SELECT asokase.pc, asokase.nac_id
      FROM m_aso_kase asokase,
           m_nac_vpla nacvpla,
           s_vplacanja vpla,
           m_nacpot nac
     WHERE asokase.kase_id = gmpkas_id_p
       AND asokase.pro_id = pro_id_p
       AND asokase.nac_id = nacvpla.nac_id
       AND nacvpla.nac_id = nac.id
       AND nacvpla.vpla_id = vpla.id
       AND vpla.ozn_irn = '1'
     ORDER BY vpla.sifra, nac.sifra;
  cijena_l m_aso_kase.pc%TYPE;
  nac_id_l m_aso_kase.nac_id%TYPE;

  odgovor_l VARCHAR2(500);
  rbr_l t_rnkase.rbr%TYPE;
BEGIN

  IF pra_zmp_s.oznaka ('P0054', so_sifra_p) = 0 THEN 
    -- Nedoputen pristup!
    pra_zmp_zaj.vrati_poruku (-20138);
  END IF;

  IF booking_id_p IS NOT NULL THEN -- npr. 2018-123456
    OPEN gost1_c;
    FETCH gost1_c INTO gost_c_l;
    CLOSE gost1_c;
    IF gost_c_l.id IS NULL THEN
      -- Pogrena vrijednost ulaznog parametra (#0)!
      pra_zmp_zaj.vrati_poruku (-20099, 'BookingId ' || booking_id_p);
    END IF;
    IF gost_c_l.ozn_rnk = 0 THEN
      -- Knjienje RNK na gosta #0 #1 nije doputeno!
      pra_pka_zaj.vrati_poruku (-20100, gost_c_l.ime, gost_c_l.prezime);
    END IF;
  ELSE
    OPEN gost2_c;
    FETCH gost2_c INTO gost_c_l;
    CLOSE gost2_c;
    IF gost_c_l.id IS NULL THEN
      -- Nedostaje podatak (#0)!
      pra_zmp_zaj.vrati_poruku (-20098, pra_zmp_zaj.poruka ('REC', 'REC_GOST'));
    END IF;
    IF gost_c_l.ozn_rnk = 0 THEN
      -- Knjienje RNK na gosta #0 #1 nije doputeno!
      pra_pka_zaj.vrati_poruku (-20100, gost_c_l.ime, gost_c_l.prezime);
    END IF;
  END IF;

  OPEN asokase_c;
  FETCH asokase_c INTO cijena_l, nac_id_l;
  CLOSE asokase_c;
  IF cijena_l IS NULL OR nac_id_l IS NULL THEN
    -- Nedostaje podatak (#0)!
    pra_zmp_zaj.vrati_poruku (-20098, pra_zmp_zaj.poruka ('GAS', 'GAS_ASOKASE'));
  END IF;

  odgovor_l := 'OK';

  pra_gas_pka.upisi_racun (
    datum_p     => TRUNC (SYSDATE),
    sj_id_p     => sj_id_p,
    pro_id_p    => pro_id_p,
    kolicina_p  => quantity_p,
    cijena_p    => cijena_l,
    gost_id_p   => gost_c_l.id,
    kase_id_p   => gmpkas_id_p,
    nac_id_p    => nac_id_l,
    pkaadr_id_p => NULL,
    age_id_p    => NULL,
    pkakar_id_p => NULL,
    poruka_p    => odgovor_l,
    rbr_p       => rbr_l);

  odgovor_p := odgovor_l;

END;
PROCEDURE DOM_ZAJ_POST
 (ENDPOINT_P IN VARCHAR2
 )
 IS
--
  timeout_l NUMBER;
  api_key_l szmp_parametri.vrijednost%TYPE;

  log_file_name_l VARCHAR2(100);

  req_l UTL_HTTP.req;
  res_l UTL_HTTP.resp;
  line_l CLOB;
BEGIN

  timeout_l := pra_zmp_zaj.zmppar_vrijednost ('DOM', '1001');
  api_key_l := pra_zmp_zaj.zmppar_vrijednost ('DOM', '1002');

  url_m := pra_zmp_zaj.zmppar_vrijednost ('DOM', '1005') || endpoint_p;

  -- Spremati komunikaciju sa servisom MISH DOM u log: da ili ne.
  IF pra_zmp_zaj.zmppar_vrijednost ('DOM', '1004') = 'da' THEN
    log_file_name_l := 'dom-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '.log';
    pra_pka2.clob_to_table ('[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' || opis_m || CHR(10), log_file_name_l, NULL, 'DOM');
    pra_pka2.clob_to_table (data_m || CHR(10), log_file_name_l, NULL, 'DOM');
  END IF;

  UTL_HTTP.set_detailed_excp_support (enable => true);
  UTL_HTTP.set_transfer_timeout (timeout => timeout_l);
  UTL_HTTP.set_body_charset (charset => 'UTF-8');
  req_l := UTL_HTTP.begin_request (url => url_m, method => 'POST', http_version => 'HTTP/1.1');
  UTL_HTTP.set_header (req_l, 'Content-Type', 'application/json; charset=utf-8');
  UTL_HTTP.set_header (req_l, 'Api-Key', api_key_l);


  DECLARE
    req_length_l BINARY_INTEGER;
    buffer_l     VARCHAR2(2000);
    amount_l     PLS_INTEGER := 2000;
    offset_l     PLS_INTEGER := 1;
  BEGIN
    req_length_l := pra_pka2.clob_length (data_m);

    IF req_length_l <= 32767 THEN
      UTL_HTTP.set_header (req_l, 'Content-Length', req_length_l);
      UTL_HTTP.write_text (req_l, data_m);

    ELSE
      UTL_HTTP.set_header (req_l, 'Transfer-Encoding', 'chunked');

      WHILE (offset_l < req_length_l) LOOP
        buffer_l := DBMS_LOB.substr (data_m, amount_l, offset_l);
        UTL_HTTP.write_text (req_l, buffer_l);
        offset_l := offset_l + amount_l;
      END LOOP;
    END IF;
  END;

  res_l := UTL_HTTP.get_response (req_l);

  BEGIN
    LOOP
      UTL_HTTP.read_line (res_l, line_l);
      odgovor_m := odgovor_m || line_l;
    END LOOP;
    UTL_HTTP.end_response (res_l);
  EXCEPTION
    WHEN UTL_HTTP.end_of_body THEN
      UTL_HTTP.end_response (res_l);
  END;

  IF log_file_name_l IS NOT NULL THEN
    pra_pka2.clob_to_table ('[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' || odgovor_m || CHR(10), log_file_name_l, NULL, 'DOM');
  END IF;

EXCEPTION
  WHEN OTHERS THEN
    IF log_file_name_l IS NOT NULL THEN
      pra_pka2.clob_to_table ('[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] ' || SQLERRM || CHR(10), log_file_name_l, NULL, 'DOM');
    END IF;
    UTL_HTTP.end_response (res_l);
    RAISE;
END;
FUNCTION DOM_BROJ_DJECE
 (REZVSJ_ID_P IN T_REZ_VSJ.ID%TYPE
 ,SJ_ID_P IN T_REZ_GOST.SJ_ID%TYPE
 ,MAX_DOB_P IN NUMBER
 )
 RETURN NUMBER
 IS
-- IRN 4030
  broj_djece_l NUMBER := 0;
BEGIN
  IF max_dob_p = 0 THEN
    RETURN 0;
  END IF;

  SELECT COUNT(1)
    INTO broj_djece_l
    FROM t_rez_gost
   WHERE rezvsj_id = rezvsj_id_p
     AND (sj_id_p IS NULL OR sj_id = sj_id_p)
     AND (dob IS NOT NULL OR dat_rodjenja IS NOT NULL)
     AND NVL(dob, pra_rec_s3.dob(dat_rodjenja, SYSDATE)) <= max_dob_p;

  RETURN broj_djece_l;
EXCEPTION
  WHEN NO_DATA_FOUND THEN
    RETURN 0;
END;
FUNCTION DOM_MAX_DOB_DJETETA
 RETURN NUMBER
 IS
-- IRN 4030
  dom_param_1011_l szmp_parametri.vrijednost%TYPE;
BEGIN
  dom_param_1011_l := pra_zmp_zaj.zmppar_vrijednost ('DOM', '1011');
  IF UPPER (dom_param_1011_l) ='NEBITNO' THEN
    dom_param_1011_l:= 0;
  END IF;  
  RETURN TO_NUMBER(dom_param_1011_l);
END;
PROCEDURE DOM_POST_BOOKING_REZGOST
 (ZAPIS_P IN tab_t_rez_gost.rezgost_rec_type
 )
 IS
-- IRN 4030
-- proceduru pozivaju triggeri AIS/AUS tablica T_REZ_GOST

  opis_end_l         VARCHAR2(100);  
  rez_id_l           t_rezervacije.id%TYPE;
  rez_so_id_l        t_rezervacije.so_id%TYPE;
  rez_dat_dolaska_l  t_rezervacije.dat_dolaska%TYPE;
  rez_ime_l          t_rezervacije.ime%TYPE;
  rez_prezime_l      t_rezervacije.prezime%TYPE;
  zem_sifra_2a_l     s_zemlje.sifra_2a%TYPE;
  rez_god_poslovna_l t_rezervacije.god_poslovna%TYPE;
  rez_rbr_l          t_rezervacije.rbr%TYPE;
  rez_oznaka_l       t_rezervacije.oznaka%TYPE;
  rez_ozn_vstorna_l  t_rezervacije.ozn_vstorna%TYPE;
  rez_dat_odlaska_l  t_rezervacije.dat_odlaska%TYPE;
  rez_ozn_vip_l      t_rezervacije.ozn_vip%TYPE;
  rez_napomena_l     t_rezervacije.napomena%TYPE;
  age_naziv_l        m_agencije.naziv%TYPE;
  pon_naziv_l        t_ponude.naz_grupe%TYPE;
  rezvsj_br_osoba_l  t_rez_vsj.br_osoba%TYPE;
  rez_reg_vozila_l   t_rezervacije.reg_vozila%TYPE;
  so_sifra_l         m_so.sifra%TYPE; 
  rezvsj_sj_id_l     t_rez_vsj.sj_id%TYPE;
  rezgost_sj_id_l    t_rez_gost.sj_id%TYPE;
  
  -- IRN 4030 
  CURSOR rez_c (sj_id_k t_rez_vsj.sj_id%TYPE) IS 
                SELECT rez.id, rez.so_id, rez.dat_dolaska, rez.ime, rez.prezime, zem.sifra_2a, rez.god_poslovna, rez.rbr, rez.reg_vozila,
                       rez.oznaka, rez.ozn_vstorna, rez.dat_odlaska, rez.ozn_vip, rez.napomena, age.naziv, pon.naz_grupe,
	  	               rezvsj.br_osoba, NVL (sj_id_k, rezvsj.sj_id) rezvsj_sj_id, so.sifra
                  FROM t_rezervacije rez,
	                   t_rez_vsj rezvsj,
		               s_zemlje zem,
		               m_agencije age,
		               t_pon_so ponso, 
                       t_pon_ojr ponojr, 
                       t_ponude pon,
                       (SELECT id, sifra
                          FROM m_so
                         WHERE pra_zmp_s.oznaka('P0054', sifra) = -1) so
                 WHERE zapis_p.rezvsj_id IS NOT NULL
                   AND rezvsj.id = zapis_p.rezvsj_id
                   AND rezvsj.rez_id = rez.id
                   AND zem.id (+) = NVL (rez.zem_id, rez.zemd_id)
                   AND rez.age_id = age.id (+)
	               AND rez.ponso_id = ponso.id (+)
                   AND ponso.ponojr_id = ponojr.id (+)
                   AND ponojr.pon_id = pon.id (+)
                   AND rez.so_id = so.id;
BEGIN
  IF pra_zmp_zaj.zmppar_vrijednost ('DOM', '1001') = 'nebitno'  THEN -- timeout
    RETURN;
  END IF;
  
  metcvor_rbr_m := pra_zmp_zaj.tekuci_cvor_rbr;

  -- (Najvea dob djeteta ili nebitno.)
  dom_param_1011_m := pra_dom_api.dom_max_dob_djeteta;
  
  log_file_name_m := 'dom-' || TO_CHAR (SYSDATE, 'RRRR-MM-DD') || '.log';
  opis_m := '[' || TO_CHAR (SYSDATE, 'DD.MM.RRRR HH24:MI:SS') || '] {Booking}';
  
  booking_rec_m := NULL;
  
  IF INSERTING OR UPDATING THEN
    rezgost_sj_id_l := zapis_p.sj_id_new;
    OPEN rez_c(zapis_p.sj_id_new);
  ELSIF DELETING THEN
    rezgost_sj_id_l := zapis_p.sj_id_old;
    OPEN rez_c(zapis_p.sj_id_old);
  END IF;  
  FETCH rez_c INTO rez_id_l, rez_so_id_l, rez_dat_dolaska_l, rez_ime_l, rez_prezime_l, zem_sifra_2a_l, rez_god_poslovna_l, rez_rbr_l, rez_reg_vozila_l,
                   rez_oznaka_l, rez_ozn_vstorna_l, rez_dat_odlaska_l, rez_ozn_vip_l, rez_napomena_l, age_naziv_l, pon_naziv_l,
                   rezvsj_br_osoba_l, rezvsj_sj_id_l, so_sifra_l;
  IF rez_c%NOTFOUND THEN
    CLOSE rez_c;
    RETURN; 
  END IF;
  CLOSE rez_c;
  
  IF rezvsj_sj_id_l IS NULL THEN
    RETURN;
  END IF;
  
  IF rez_dat_dolaska_l < TRUNC (SYSDATE) THEN
    RETURN; -- podaci za dolaske prije tekueg datuma ne alju se u Domainstvo
  END IF;
  
  opis_m := opis_m || '[*** dom_post_booking_rezgost';
  IF INSERTING THEN
    opis_m := opis_m || ' | inserting | ';
  ELSIF UPDATING 
      AND (
             NVL (zapis_p.dob_new, -1) <> NVL (zapis_p.dob_old, -1)  OR 
             NVL (zapis_p.dat_rodjenja_new, TO_DATE('01.01.3000.','DD.MM.RRRR.')) <> NVL (zapis_p.dat_rodjenja_old, TO_DATE('01.01.3000.','DD.MM.RRRR.'))  OR 
             NVL (zapis_p.sj_id_new, -1) <> NVL( zapis_p.sj_id_old, -1)
          )
  THEN
    opis_m := opis_m || ' | updating | ';
  ELSIF DELETING THEN
    opis_m := opis_m || ' | deleting | ';
  END IF;
  
  booking_rec_m.Property := so_sifra_l;

  /*
  Oznake podataka koje MISH alje u DOM: A = ime, B = prezime, C = datum roenja, D = datum roenja (samo za roendane u vrijeme boravka), 
  E = dravljanstvo, F = spol, G = registracija vozila ili nebitno.
  */
  dom_param_1003_m := pra_zmp_zaj.zmppar_vrijednost ('DOM', '1003');
  IF INSTR (dom_param_1003_m, 'A') > 0 THEN
    booking_rec_m.FirstName := TRIM (rez_ime_l);
  END IF;
  IF INSTR (dom_param_1003_m, 'B') > 0 THEN
    booking_rec_m.LastName := TRIM (rez_prezime_l);
  END IF;
  IF INSTR (dom_param_1003_m, 'E') > 0 THEN
    booking_rec_m.Country := zem_sifra_2a_l;
  END IF;

  opis_m := opis_m || ' [*** dom_post_booking_rezgost'; 
  opis_end_l := zmp_zaj.korisnik (-1) || ' | ' || rez_ime_l|| ' | ' || rez_prezime_l || ']'; 

  booking_rec_m.BookingId := metcvor_rbr_m || '-' || rez_god_poslovna_l || '-' || rez_rbr_l || '-' || zapis_p.rezvsj_id;
  booking_rec_m.ReservationId := booking_rec_m.Property || '-' || rez_god_poslovna_l || '-' || rez_rbr_l; 
  booking_rec_m.Arrival := TO_CHAR (rez_dat_dolaska_l, 'YYYY-MM-DD') || ' 00:00';
  booking_rec_m.Departure := TO_CHAR (rez_dat_odlaska_l, 'YYYY-MM-DD') || ' 00:00';
  booking_rec_m.Vip := rez_ozn_vip_l;
  booking_rec_m.Message := rez_napomena_l;  
  booking_rec_m.Service := pra_dom_api.dom_rez_sus_usl_sifra (rez_id_l); -- usluga za cijelu rezervaciju
  booking_rec_m.Agency := age_naziv_l;
  booking_rec_m.GuestGroup := pon_naziv_l;
  booking_rec_m.Status := 'RESERVED'; 
  booking_rec_m.RegPlate := NVL (pra_dom_api.dom_reg_vozila (zapis_p.rezvsj_id, rezgost_sj_id_l, dom_param_1003_m), rez_reg_vozila_l); -- dodana registracija vozila sa t_rezervacije ako je registracija NULL
  booking_rec_m.Children := pra_dom_api.dom_broj_djece(zapis_p.rezvsj_id , rezgost_sj_id_l, TO_NUMBER (dom_param_1011_m));
  booking_rec_m.Adults := rezvsj_br_osoba_l - booking_rec_m.Children; 
  booking_rec_m.Sex := TO_CHAR (NULL); 
  booking_rec_m.PayCard := TO_CHAR (NULL); -- na rezervaciji nema PayCarda       
  
  IF INSERTING THEN
    opis_m := opis_m || ' | inserting | ' || opis_end_l;
  ELSE
    opis_m := opis_m || ' | updating | ' || opis_end_l;
  END IF;
  
  dom_post_booking_zaj (rezvsj_sj_id_l);
EXCEPTION
  WHEN OTHERS THEN
    pra_pka2.clob_to_table (opis_m || CHR(10) || SQLERRM || CHR(10) || CHR(10), log_file_name_m, NULL, 'DOM'); -- IRN 3941
END;
FUNCTION DOM_REG_VOZILA
 (REZVSJ_ID_P IN T_REZ_GOST.REZVSJ_ID%TYPE
 ,SJ_ID_P IN T_REZ_GOST.SJ_ID%TYPE
 ,DOM_PARAM_P IN VARCHAR2
 )
 RETURN VARCHAR2
 IS
-- IRN 4030
  reg_vozila_l t_rez_gost.reg_vozila%TYPE;
BEGIN
  reg_vozila_l := NULL;

  IF INSTR(dom_param_p, 'G') > 0 THEN
    BEGIN
      SELECT MAX(reg_vozila)
        INTO reg_vozila_l
        FROM t_rez_gost
       WHERE reg_vozila IS NOT NULL
         AND rezvsj_id = rezvsj_id_p
         AND (sj_id_p IS NULL OR sj_id = sj_id_p);
    EXCEPTION
      WHEN NO_DATA_FOUND THEN
        reg_vozila_l := NULL;
    END;
  END IF;

  RETURN reg_vozila_l;
END;
FUNCTION DOM_REZ_SUS_USL_SIFRA
 (REZ_ID_P IN T_REZERVACIJE.ID%TYPE
 )
 RETURN mzmp_usl_sus.sifra%TYPE
 IS
-- IRN 4030
  -- Rezervirana usluga
  CURSOR rezsususl_c IS
    SELECT zmpuslsus.sifra
      FROM (
           SELECT rezusl.usl_id, NVL (rezusl.dat_poc, rez.dat_dolaska) dat_poc
             FROM t_rez_usl rezusl,
                  t_rezervacije rez
            WHERE rez.id = rez_id_p
              AND rezusl.rez_id = rez.id
           UNION ALL
           SELECT rezgusl.usl_id, NVL (rezgusl.dat_poc, rez.dat_dolaska) dat_poc
             FROM t_rez_gusl rezgusl,
                  t_rez_gost rezgost,
                  t_rez_vsj rezvsj,
                  t_rezervacije rez
            WHERE rez.id = rez_id_p
              AND rezvsj.rez_id = rez.id
              AND rezgost.rezvsj_id = rezvsj.id
              AND rezgusl.rezgost_id = rezgost.id              
           ) rezusl,
           s_usluge usl,
           szmp_sustavi zmpsus,
           mzmp_usl_sus zmpuslsus           
     WHERE rezusl.usl_id = usl.id
       AND zmpsus.sifra = 'DOM' -- vratiti e samo one usluge koje su definirane u sustavu DOM
       AND zmpsus.id = zmpuslsus.zmpsus_id
       AND zmpuslsus.usl_id = rezusl.usl_id
     ORDER BY rezusl.dat_poc, usl.ozn_osnovna, usl.ozn_abc, zmpuslsus.sifra;
  usl_sifra_l mzmp_usl_sus.sifra%TYPE;
BEGIN
  IF rez_id_p IS NULL THEN
    RETURN (NULL);
  END IF;
  OPEN rezsususl_c;
  FETCH rezsususl_c INTO usl_sifra_l;
  CLOSE rezsususl_c;
  RETURN (usl_sifra_l);
END;
FUNCTION DOM_TRO_SUS_USL_SIFRA
 (GOST_ID_P IN T_GOSTI.ID%TYPE
 )
 RETURN mzmp_usl_sus.sifra%TYPE
 IS
-- IRN 4030
 -- Usluga na trokovima
  CURSOR trosususl_c IS
    SELECT zmpuslsus.sifra
      FROM (
           SELECT tro.usl_id, NVL (tro.dat_poc, tro.dat_zav) dat_poc
             FROM t_troskovi tro
            WHERE tro.gost_id = gost_id_p  
              AND TRUNC(SYSDATE) BETWEEN tro.dat_poc AND tro.dat_zav --> usluga koja vrijedi na dananji dan
           ) trousl,
           s_usluge usl,
           szmp_sustavi zmpsus,
           mzmp_usl_sus zmpuslsus           
     WHERE trousl.usl_id = usl.id
       AND zmpsus.sifra = 'DOM' -- vratiti e samo one usluge koje su definirane u sustavu DOM
       AND zmpsus.id = zmpuslsus.zmpsus_id
       AND zmpuslsus.usl_id = trousl.usl_id
     ORDER BY trousl.dat_poc, usl.ozn_osnovna, usl.ozn_abc, zmpuslsus.sifra;
  usl_sifra_l mzmp_usl_sus.sifra%TYPE;
BEGIN
  IF gost_id_p IS NULL THEN
    RETURN (NULL);
  END IF;
  OPEN trosususl_c;
  FETCH trosususl_c INTO usl_sifra_l;
  CLOSE trosususl_c;
  RETURN (usl_sifra_l);
END;

END PRA_DOM_API;
/
SHOW ERROR

