PROMPT Creating Trigger 'AIS_MREC_GDGOSTIJU'
CREATE OR REPLACE TRIGGER AIS_MREC_GDGOSTIJU
 AFTER INSERT
 ON MREC_GDGOSTIJU
DECLARE

  zapis_l tab_mrec_gdgostiju.recgdgost_rec_type;
BEGIN
  tab_mrec_gdgostiju.postavi_iterator;
  WHILE tab_mrec_gdgostiju.ima_jos LOOP
    zapis_l := tab_mrec_gdgostiju.sljedeci_red;
    pra_rec_s2.provjeri_recgdgost_razdoblje (
      zapis_l.id,
      zapis_l.br_godina_poc,
      zapis_l.dat_valjan,
      zapis_l.dat_ponisten);
  END LOOP;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'AR_MREC_GDGOSTIJU'
CREATE OR REPLACE TRIGGER AR_MREC_GDGOSTIJU
 AFTER DELETE OR INSERT OR UPDATE
 ON MREC_GDGOSTIJU
 FOR EACH ROW
BEGIN
  replikacija.napuni_tab (:OLD.id, :NEW.id);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'AS_MREC_GDGOSTIJU'
CREATE OR REPLACE TRIGGER AS_MREC_GDGOSTIJU
 AFTER DELETE OR INSERT OR UPDATE
 ON MREC_GDGOSTIJU
BEGIN
  replikacija.azuriraj_retke (
    aplikacija_p => 'REC',
    tablica_p    => 'MREC_GDGOSTIJU');
END;
/
SHOW ERROR


PROMPT Creating Trigger 'AUS_MREC_GDGOSTIJU'
CREATE OR REPLACE TRIGGER AUS_MREC_GDGOSTIJU
 AFTER UPDATE
 ON MREC_GDGOSTIJU
DECLARE

  zapis_l tab_mrec_gdgostiju.recgdgost_rec_type;
BEGIN
  tab_mrec_gdgostiju.postavi_iterator;
  WHILE tab_mrec_gdgostiju.ima_jos LOOP
    zapis_l := tab_mrec_gdgostiju.sljedeci_red;
    pra_rec_s2.provjeri_recgdgost_razdoblje (
      zapis_l.id,
      zapis_l.br_godina_poc,
      zapis_l.dat_valjan,
      zapis_l.dat_ponisten);
  END LOOP;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIR_MREC_GDGOSTIJU'
CREATE OR REPLACE TRIGGER BIR_MREC_GDGOSTIJU
 BEFORE INSERT
 ON MREC_GDGOSTIJU
 FOR EACH ROW
DECLARE

  zapis_l tab_mrec_gdgostiju.recgdgost_rec_type;
BEGIN
  -- IRN 2888
  IF SYS_CONTEXT ('LOGINFO_CTX', 'SSOUSER') = 'ITNEW'
    AND SYS_CONTEXT ('LOGINFO_CTX', 'VLASNIKPODATKA') = pra_zmp_zaj.vrijednost_parametra ('0999')
  THEN
    RETURN; -- izlaz iz trigera
  END IF;

  :NEW.id := pra_zmp_zaj.i3_sekvenca (:NEW.id);
  pra_rec_zaj.oblikuj_podatak ('SIFRA', 'MREC_GDGOSTIJU', :NEW.sifra);
  :NEW.dat_valjan := TRUNC (:NEW.dat_valjan);
  :NEW.dat_ponisten := TRUNC (:NEW.dat_ponisten);

  -- IRN 4023; Provjeri preklapanje razdoblja
  zapis_l.id := :NEW.id;
  zapis_l.br_godina_poc := :NEW.br_godina_poc;
  zapis_l.dat_valjan := :NEW.dat_valjan;
  zapis_l.dat_ponisten := :NEW.dat_ponisten;
  tab_mrec_gdgostiju.puni_tablicu (zapis_l);

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BIS_MREC_GDGOSTIJU'
CREATE OR REPLACE TRIGGER BIS_MREC_GDGOSTIJU
 BEFORE INSERT
 ON MREC_GDGOSTIJU
BEGIN
  tab_mrec_gdgostiju.brisi_tablicu;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BS_MREC_GDGOSTIJU'
CREATE OR REPLACE TRIGGER BS_MREC_GDGOSTIJU
 BEFORE DELETE OR INSERT OR UPDATE
 ON MREC_GDGOSTIJU
BEGIN
  replikacija.brisi_tab;
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUR_MREC_GDGOSTIJU'
CREATE OR REPLACE TRIGGER BUR_MREC_GDGOSTIJU
 BEFORE UPDATE
 ON MREC_GDGOSTIJU
 FOR EACH ROW
DECLARE

  zapis_l tab_mrec_gdgostiju.recgdgost_rec_type;
BEGIN
  pra_rec_zaj.oblikuj_podatak ('SIFRA', 'MREC_GDGOSTIJU', :NEW.sifra);
  :NEW.dat_valjan := TRUNC (:NEW.dat_valjan);
  :NEW.dat_ponisten := TRUNC (:NEW.dat_ponisten);

  -- Provjeri preklapanje razdoblja
  zapis_l.id := :NEW.id;
  zapis_l.br_godina_poc := :NEW.br_godina_poc;
  zapis_l.dat_valjan := :NEW.dat_valjan;
  zapis_l.dat_ponisten := :NEW.dat_ponisten;
  tab_mrec_gdgostiju.puni_tablicu (zapis_l);

  pra_rec_zaj.upisi_audit (:NEW.unos_korisnik, :NEW.unos_dat, :NEW.izmjena_korisnik, :NEW.izmjena_dat);
END;
/
SHOW ERROR


PROMPT Creating Trigger 'BUS_MREC_GDGOSTIJU'
CREATE OR REPLACE TRIGGER BUS_MREC_GDGOSTIJU
 BEFORE UPDATE
 ON MREC_GDGOSTIJU
BEGIN
  tab_mrec_gdgostiju.brisi_tablicu;
END;
/
SHOW ERROR
