-- C:\mish_cvs\misH_skripte\fm_gas2021.pkb
--
-- Generated for Oracle 10g on Mon Aug 25  14:19:52 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'FM_GAS2021'
CREATE OR REPLACE PACKAGE BODY FM_GAS2021 IS

PROCEDURE IZRADI_IZ_MOBPRIJELAZA
 (MOBPRI_ID_P IN TMOB_PRIJELAZ.ID%TYPE
 )
 IS

  CURSOR mobpri_c IS
    SELECT TO_CHAR(SYSDATE, 'YYYY') godina,
           mobpri.mt_id_daje,
           oj.sifra oj_sifra_daje,
           mobpri.mt_id_prima,
           trunc(SYSDATE) datum,
           mobpri.opis,
           mobpri.opis80,
          'V'
      FROM tmob_prijelaz mobpri,
           m_oj oj
     WHERE mobpri.id = mobpri_id_p
       AND oj.id = mobpri.mt_id_daje;

  mobpri_l      mobpri_c%ROWTYPE;
  naredba_l     VARCHAR2(32000);
  id_l          NUMBER;
  sifra_cvora_l smet_cvorovi.sifra%TYPE;
BEGIN
  --  TMOB_PRIJELAZ
  OPEN mobpri_c;
  FETCH mobpri_c
   INTO mobpri_l;
  CLOSE mobpri_c;

  -- kontrola pristupa
  IF pra_zmp_s.oznaka1('P0055', mobpri_l.oj_sifra_daje) = 0 THEN
   -- Nedoputen pristup!
   pra_zmp_zaj.vrati_poruku(-20138);
  END IF;

  -- vri kontrolu i vraa vrijednost vora u sifra_cvora_l na bazi mjesta troka koji daje
  kontrola_cvora(mobpri_l.mt_id_daje, sifra_cvora_l);

  -- ako je vor ok dodaje @
  IF sifra_cvora_l IS NOT NULL THEN
   sifra_cvora_l := '@' || sifra_cvora_l;
  END IF;

  -- dodaje zaglavlje
  naredba_l := 'BEGIN
    :id := gas_zaj.sekvenca' || sifra_cvora_l || '(NULL);

    INSERT INTO t_prijelaz' || sifra_cvora_l || '
  (id,godina,mt_id_daje, mt_id_prima, datum, opis, opis80, ozn_valjanosti, ozn_replikacije )
    VALUES
  (:id, :godina, :mt_id_daje,:mt_id_prima, :datum, :opis, :opis80, ''V'', ''D'');

   END;';
  EXECUTE IMMEDIATE naredba_l
   USING IN OUT id_l, IN mobpri_l.godina, IN mobpri_l.mt_id_daje, IN mobpri_l.mt_id_prima, IN mobpri_l.datum, IN mobpri_l.opis, IN mobpri_l.opis80;

  -- dodaje stavke
  naredba_l := 'BEGIN

    INSERT INTO t_prijelaz_art ' || sifra_cvora_l || '
         (pri_id, sir_id, nam_id, pro_id, nam_pro_id, odnos_jm_b, odnos_jm_n, kolicina, nab_cijena)
    SELECT :id, mobpriart.sir_id, mobpriart.nam_id, mobpriart.pro_id, mobpriart.nam_pro_id,
           mobpriart.odnos_jm_b, mobpriart.odnos_jm_b, mobpriart.kolicina, mobpriart.nab_cijena
      FROM tmob_prijelaz_art mobpriart
     WHERE mobpriart.mobpri_id = :mobpri_id;
  END;';
  EXECUTE IMMEDIATE naredba_l
   USING IN id_l, mobpri_id_p;

  -- aurira status preuzimanja
  UPDATE tmob_prijelaz t
     SET t.ozn_preuzimanja = -1
   WHERE t.id = mobpri_id_p;

 END;
PROCEDURE KONTROLA_CVORA
 (MT_ID_P IN NUMBER
 ,SIFRA_CVORA_P OUT VARCHAR2
 )
 IS

  sifra_cvora_l smet_cvorovi.sifra%TYPE;
  brojac_l      NUMBER;
  ozn_u_mrezi_l smet_cvorovi.ozn_u_mrezi%TYPE;
  poruka_l      VARCHAR2(2000);
BEGIN
   /* Samo centar aurira po mrei */
   IF pra_zmp_zaj.centar = 0 THEN
     RETURN;
   END IF;

   sifra_cvora_l := possus_gas.cvor_za_mt(mt_id_p);

   IF sifra_cvora_l IS NULL THEN
      poruka_l := pra_zmp_zaj.poruka('GAS', 'GAS0330', sifra_cvora_l);
   END IF;

   /* Da li vor ima instalaciju GAS */
   SELECT COUNT(*)
        INTO brojac_l
      FROM smet_instalacije
    WHERE metapl_sifra = 'GAS'
         AND metcvor_sifra = sifra_cvora_l;

   IF brojac_l = 0 THEN
      poruka_l := pra_zmp_zaj.poruka('GAS', 'GAS0332', sifra_cvora_l);
   END IF;

   /* Da li je vor oznaen da je/nije u mrei */
   SELECT ozn_u_mrezi
        INTO ozn_u_mrezi_l
      FROM smet_cvorovi
   WHERE sifra = sifra_cvora_l;

   IF ozn_u_mrezi_l = 0 THEN
      poruka_l := pra_zmp_zaj.poruka('GAS', 'GAS0330', sifra_cvora_l);
   END IF;
   IF sifra_cvora_l <> pra_zmp_zaj.tekuci_cvor THEN
      sifra_cvora_p := sifra_cvora_l;
   END IF;

  END;
END FM_GAS2021;
/
SHOW ERROR

