-- C:\Users\rboric\Desktop\IRN\4088\fm_gas1250.pkb
--
-- Generated for Oracle 10g on Thu Sep 04  08:10:37 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'FM_GAS1250'
CREATE OR REPLACE PACKAGE BODY FM_GAS1250 IS

PROCEDURE PRIJEPIS_ASORTIMANA_GMT
 (MT_ID_P IN M_MT.ID%TYPE
 ,NAC_ID_P IN M_NACPOT.ID%TYPE
 ,OZN_BRISANJA_P IN NUMBER
 )
 IS
   gmt_id_l m_gmt.id%TYPE;
   brojac_l NUMBER;
BEGIN
   IF mt_id_p IS NULL OR nac_id_p IS NULL THEN
      RETURN;
   END IF;

   IF ozn_brisanja_p = -1 THEN
      DELETE m_aso_mt
       WHERE mt_id  = mt_id_p
         AND nac_id = nac_id_p;
   END IF;

   SELECT gmt_id 
     INTO gmt_id_l 
     FROM m_mt
    WHERE id = mt_id_p;

   FOR asogmt IN (
      SELECT pro_id,  pc1  pc
        FROM m_aso_gmt
       WHERE gmt_id = gmt_id_l
         AND nac_id = nac_id_p)
   LOOP
      SELECT COUNT (*) INTO brojac_l
        FROM m_aso_mt
       WHERE mt_id  = mt_id_p
         AND nac_id = nac_id_p
         AND pro_id = asogmt.pro_id;

      IF brojac_l = 0 THEN
         IF asogmt.pc <> 0 THEN
            INSERT INTO m_aso_mt (mt_id, nac_id, pro_id, pc)
            VALUES (mt_id_p, nac_id_p, asogmt.pro_id, asogmt.pc);
         END IF;
      ELSE
         IF asogmt.pc <> 0 THEN
            UPDATE m_aso_mt SET pc= asogmt.pc
             WHERE mt_id  = mt_id_p
               AND nac_id = nac_id_p
               AND pro_id = asogmt.pro_id;
         ELSE
            DELETE m_aso_mt
             WHERE mt_id  = mt_id_p
               AND nac_id = nac_id_p
               AND pro_id = asogmt.pro_id;
         END IF;
      END IF;

   END LOOP;

   COMMIT;
END;
PROCEDURE PRIJEPIS_ASORTIMANA_GMT_NP
 (MT_ID_P M_MT.ID%TYPE
 ,NAC_ID_P M_NACPOT.ID%TYPE
 ,IZ_GMT_ID_P M_GMT.ID%TYPE
 ,IZ_NAC_ID_P M_NACPOT.ID%TYPE
 ,POSTOTAK_POVECANJA_P NUMBER
 ,OZN_BRISANJA_P NUMBER
 )
 IS
   brojac_l NUMBER;
   faktor_povecanja_l NUMBER;
BEGIN
   IF     mt_id_p IS NULL OR    nac_id_p IS NULL OR
      iz_gmt_id_p IS NULL OR iz_nac_id_p IS NULL
   THEN
      RETURN;
   END IF;

   faktor_povecanja_l := (100 + NVL (postotak_povecanja_p, 0)) / 100;

   IF ozn_brisanja_p = -1 THEN
      /* Brie se asortiman MT za odreeni nain potronje */
      DELETE m_aso_mt
       WHERE mt_id  = mt_id_p
         AND nac_id = nac_id_p;
   END IF;
   
   /* Prijepis asortimana */
   FOR asogmt IN (
      SELECT pro_id, pc1 pc
        FROM m_aso_gmt
       WHERE gmt_id = iz_gmt_id_p
         AND nac_id = iz_nac_id_p)
   LOOP
      /* Proizvod se dodaje u asortiman samo ako ve ne postoji. */
      SELECT COUNT (1) INTO brojac_l
        FROM m_aso_mt
       WHERE mt_id  = mt_id_p
         AND nac_id = nac_id_p
         AND pro_id = asogmt.pro_id;

      IF brojac_l = 0 AND asogmt.pc <> 0 THEN
         INSERT INTO m_aso_mt (
            mt_id, nac_id, pro_id,
            pc)
           VALUES (
            mt_id_p, nac_id_p, asogmt.pro_id,
            ROUND (asogmt.pc * faktor_povecanja_l, 2));
      END IF;
   END LOOP;

   COMMIT;
END;
PROCEDURE BRISANJE_ASORTIMANA
 (MT_ID_P IN M_MT.ID%TYPE
 ,NAC_ID_P IN M_NACPOT.ID%TYPE
 )
 IS
BEGIN
   IF mt_id_p IS NULL OR nac_id_p IS NULL THEN
      RETURN;
   END IF;

   DELETE m_aso_mt
    WHERE mt_id  = mt_id_p
      AND nac_id = nac_id_p;

   COMMIT;
END;
FUNCTION POSTOJI_PC_PRO_ASOMT
 (MT_ID_P IN M_MT.ID%TYPE
 ,NAC_ID_P IN M_NACPOT.ID%TYPE
 ,PRO_ID_P IN M_PROIZVODI.ID%TYPE
 ,PC_P IN M_ASO_MT.PC%TYPE
 )
 RETURN VARCHAR2
 IS
nam_id_l  m_namirnice.id%TYPE;
vrsta_l m_mt.vrsta%TYPE;
sifra_l m_proizvodi.sifra%TYPE;
poruka_l s_poruke.tekst%TYPE;
brojac_l  number;
ne_postoji_sastav exception;
visak_sastava exception;
BEGIN
  SELECT vrsta INTO vrsta_l
    FROM m_mt
   WHERE id = mt_id_p;
  IF vrsta_l = 'U' THEN
     SELECT count(*) INTO brojac_l
       FROM m_sastav
      WHERE pro_id = pro_id_p;
	 IF brojac_l = 0 THEN
             SELECT sifra INTO sifra_l
               FROM m_proizvodi
              WHERE id = pro_id_p;
			  RAISE ne_postoji_sastav;
	 ELSIF brojac_l > 1 THEN
             SELECT sifra INTO sifra_l
               FROM m_proizvodi
              WHERE id = pro_id_p;
			  RAISE visak_sastava;	 
	 END IF;
     SELECT nam_id INTO nam_id_l
       FROM m_sastav
      WHERE pro_id = pro_id_p;
        FOR cijena IN (
            SELECT asomt.pc, sas.nam_id, asomt.pro_id
              FROM m_aso_mt asomt,
                   m_sastav sas
             WHERE sas.nam_id = nam_id_l
               AND sas.pro_id = asomt.pro_id
               AND asomt.mt_id  = mt_id_p
               AND asomt.nac_id = nac_id_p
               AND asomt.pro_id <> pro_id_p)
        LOOP
          IF pc_p <> cijena.pc THEN
             SELECT sifra INTO sifra_l
               FROM m_proizvodi
              WHERE id = cijena.pro_id;
             poruka_l :=   pra_zmp_zaj.poruka('GAS', 'GAS0521',  sifra_l, cijena.pc);
          END IF;
        END LOOP;
  END IF;
  RETURN poruka_l;
  EXCEPTION WHEN ne_postoji_sastav THEN
                 BEGIN
                 poruka_l :=   pra_zmp_zaj.poruka('NST', '-20042',  sifra_l);
				 RETURN poruka_l;
				 END;
            WHEN visak_sastava THEN
                 BEGIN
                 poruka_l :=   pra_zmp_zaj.poruka('NST', '-20043',  sifra_l);
				 RETURN poruka_l;
				 END;
END;
PROCEDURE PRIJEPIS_ASO_MT_NA_OBJEKT
 (MT_ID_P IN M_MT.ID%TYPE
 ,NAC_ID_P IN M_NACPOT.ID%TYPE
 )
 IS
  metcvor_sifra_l smet_cvorovi.sifra%TYPE;
  brojac_l        NUMBER;
  ozn_u_mrezi_l   smet_cvorovi.ozn_u_mrezi%TYPE;
  naredba_l       VARCHAR2 (32000);
BEGIN
   metcvor_sifra_l := possus_gas.cvor_za_mt (mt_id_p);

   IF metcvor_sifra_l IS NULL THEN
      -- ***NEMA VORA***
      pra_zmp_zaj.vrati_poruku (-20000, 'GAS0330', pra_zmp_zaj.poruka ('GAS', 'GAS0330'));
   END IF;

   IF metcvor_sifra_l = pra_zmp_zaj.tekuci_cvor THEN
      RETURN; -- ne javlja greku
   END IF;

   SELECT COUNT (*) INTO brojac_l
     FROM smet_instalacije
    WHERE metapl_sifra  = 'GAS'
      AND metcvor_sifra = metcvor_sifra_l;

   IF brojac_l = 0 THEN
      -- vor #0 nema instalaciju aplikacije GAS.
      pra_zmp_zaj.vrati_poruku (-20000, 'GAS0332', pra_zmp_zaj.poruka ('GAS', 'GAS0332', metcvor_sifra_l));
   END IF;

   SELECT ozn_u_mrezi INTO ozn_u_mrezi_l
     FROM smet_cvorovi
    WHERE sifra = metcvor_sifra_l;

   IF ozn_u_mrezi_l = 0 THEN
      -- vor #0 je oznaen da nije u mrei.
      pra_zmp_zaj.vrati_poruku (-20000, 'GAS0333', pra_zmp_zaj.poruka ('GAS', 'GAS0333', metcvor_sifra_l));
   END IF;

   BEGIN
      naredba_l :=
      'BEGIN
          DELETE m_aso_mt@' || metcvor_sifra_l || '
           WHERE mt_id  = :1
             AND nac_id = :2;

          INSERT INTO m_aso_mt@' || metcvor_sifra_l || '
                (mt_id,
                 nac_id,
                 pro_id,
                 pc,
                 unos_korisnik,
                 unos_dat,
                 izmjena_korisnik,
                 izmjena_dat,
                 popust_obavezni,
                 ozn_pso)
          SELECT mt_id,
                 nac_id,
                 pro_id,
                 pc,
                 unos_korisnik,
                 unos_dat,
                 izmjena_korisnik,
                 izmjena_dat,
                 popust_obavezni,
                 ozn_pso
            FROM m_aso_mt
           WHERE mt_id  = :1
             AND nac_id = :2;
       END;
      ';              
      
      EXECUTE IMMEDIATE naredba_l USING mt_id_p, nac_id_p;
      
      naredba_l :=
      'BEGIN
          DELETE m_aso_mt_grupe@' || metcvor_sifra_l || '
           WHERE mt_id  = :1
             AND nac_id = :2;

          INSERT INTO m_aso_mt_grupe@' || metcvor_sifra_l || '
                (nac_id,
                 sifgr_id,
                 mt_id,
                 pc,
                 unos_korisnik,
                 unos_dat,
                 izmjena_korisnik,
                 izmjena_dat,
                 popust_obavezni)
          SELECT nac_id,
                 sifgr_id,
                 mt_id,
                 pc,
                 unos_korisnik,
                 unos_dat,
                 izmjena_korisnik,
                 izmjena_dat,
                 popust_obavezni
            FROM m_aso_mt_grupe
           WHERE mt_id  = :1
             AND nac_id = :2;
       END;
      ';

      EXECUTE IMMEDIATE naredba_l USING mt_id_p, nac_id_p;

      COMMIT;
   EXCEPTION
      WHEN OTHERS THEN
         ROLLBACK; -- zbog -2055: distributed update operation failed; rollback required
         RAISE;
   END;
END;
FUNCTION POSTOJI_SASTAV
 (MT_ID_P IN M_MT.ID%TYPE
 ,NAC_ID_P M_NACPOT.ID%TYPE
 ,PRO_ID_P NUMBER
 )
 RETURN VARCHAR2
 IS
nam_id_l  m_namirnice.id%TYPE;
vrsta_l m_mt.vrsta%TYPE;
sifra_l m_proizvodi.sifra%TYPE;
poruka_l s_poruke.tekst%TYPE;
brojac_l  number;
BEGIN
  SELECT vrsta INTO vrsta_l
    FROM m_mt
   WHERE id = mt_id_p;
  IF vrsta_l = 'U' THEN
     SELECT count(*) INTO brojac_l
       FROM m_sastav
      WHERE pro_id = pro_id_p;
	 IF brojac_l = 0 THEN
             SELECT sifra INTO sifra_l
               FROM m_proizvodi
              WHERE id = pro_id_p;
              poruka_l :=   pra_zmp_zaj.poruka('NST', '-20042',  sifra_l);
	 END IF;
         ELSIF brojac_l > 1 THEN
             SELECT sifra INTO sifra_l
               FROM m_proizvodi
              WHERE id = pro_id_p;
              poruka_l :=   pra_zmp_zaj.poruka('NST', '-20043',  sifra_l);
  END IF;
  RETURN poruka_l;
END;
PROCEDURE PRIJEPIS_ASORTIMANA_MT_NP_PRO
 (MT_ID_P M_MT.ID%TYPE
 ,NAC_ID_P M_NACPOT.ID%TYPE
 ,IZ_MT_ID_P M_MT.ID%TYPE
 ,IZ_NAC_ID_P M_NACPOT.ID%TYPE
 ,PRO_ID_P M_PROIZVODI.ID%TYPE
 ,POSTOTAK_MARZE_P NUMBER := 0
 ,POSTOTAK_POVECANJA_P NUMBER := 0
 ,ZAOKRUZIVANJE_P NUMBER := 1
 )
 IS
   brojac_l NUMBER;
   faktor_povecanja_l NUMBER;
   vrijednost_l szmp_parametri.vrijednost%TYPE;
BEGIN          
    
   vrijednost_l := pra_zmp_zaj.zmppar_vrijednost ('GAS', '1048');  
   
   IF mt_id_p IS NULL OR nac_id_p IS NULL OR
      iz_mt_id_p IS NULL OR iz_nac_id_p IS NULL
   THEN
      RETURN;
   END IF;

   IF  postotak_marze_p <> 0 AND postotak_povecanja_p <> 0 THEN
      RETURN;
   ELSIF  postotak_marze_p = 0 AND postotak_povecanja_p = 0 THEN
      faktor_povecanja_l := 1;   -- prepisuje se po istoj PC
   ELSIF postotak_povecanja_p  <>  0 THEN
      faktor_povecanja_l := (100 + NVL (postotak_povecanja_p, 0)) / 100;
   END IF;

   /* Prijepis asortimana */
   FOR asomt IN (
      SELECT aso.pro_id, DECODE(postotak_marze_p, 0, aso.pc, DECODE(vrijednost_l,'1', pro.zad_nab_cijena, fm_gas1250.pnc_proizvoda (mt_id_p, pro_id ))) cijena,      
             vpispp.stopa pdv, gpor.ppot ppot
        FROM m_aso_mt aso,
             m_proizvodi pro,
             m_gporez gpor,
             mgas_gpor_raz  grazgpor,
             s_vpisporukap vpispp
       WHERE aso.mt_id  = iz_mt_id_p
         AND aso.nac_id = iz_nac_id_p
	     AND aso.pro_id = pro_id_p
         AND aso.pro_id = pro.id
         AND pro.gpor_id = gpor.id
         AND grazgpor.gpor_id = gpor.id
         AND SYSDATE BETWEEN grazgpor.dat_valjan AND NVL(grazgpor.dat_ponisten, sysdate)
         AND grazgpor.vpispp_id = vpispp.id)
 
   LOOP
      /* Proizvod se dodaje u asortiman samo ako ve ne postoji. */
      SELECT COUNT (1) INTO brojac_l
        FROM m_aso_mt
       WHERE mt_id  = mt_id_p
         AND nac_id = nac_id_p
         AND pro_id = asomt.pro_id;

      IF brojac_l = 0 THEN
         INSERT INTO m_aso_mt (
            mt_id, nac_id, pro_id,
            pc)
           VALUES (
             mt_id_p, nac_id_p, asomt.pro_id,
             DECODE(postotak_marze_p, 0,
             ROUND(asomt.cijena * faktor_povecanja_l,  zaokruzivanje_p), 
             ROUND(asomt.cijena * (1+ postotak_marze_p/100) * (1+ (asomt.pdv + asomt.ppot)/100),zaokruzivanje_p )));
      ELSE
	    UPDATE m_aso_mt
	       SET pc =  DECODE(postotak_marze_p, 0,
	                        ROUND(asomt.cijena * faktor_povecanja_l,  zaokruzivanje_p),ROUND(asomt.cijena * (1+ postotak_marze_p/100) * (1+ (asomt.pdv + asomt.ppot)/100),zaokruzivanje_p ))
         WHERE mt_id = mt_id_p
           AND nac_id = nac_id_p
           AND pro_id = asomt.pro_id;
      END IF;
   END LOOP;

   COMMIT;
END;
PROCEDURE ARHIVIRANJE_ASORTIMANA
 (MT_ID_P IN M_MT.ID%TYPE
 ,NAC_ID_P IN M_NACPOT.ID%TYPE
 ,DATUM_DO_P IN DATE
 ,DATUM_OD_P IN DATE
 )
 IS
BEGIN
  FOR maso IN (SELECT mt_id, nac_id, pro_id, pc, popust_obavezni
                 FROM m_aso_mt 
				WHERE mt_id = mt_id_p
				  AND nac_id = nac_id_p)
  LOOP
    IF datum_od_p IS NULL THEN
      INSERT INTO m_aso_mt_dat (dat_poc, dat_zav, mt_id, nac_id, pro_id, pc, popust_obavezni)
      VALUES ('01.01.2000', datum_do_p, maso.mt_id, maso.nac_id, maso.pro_id, maso.pc, maso.popust_obavezni);
    ELSE
      INSERT INTO m_aso_mt_dat (dat_poc, dat_zav, mt_id, nac_id, pro_id, pc, popust_obavezni)
      VALUES (datum_od_p, datum_do_p, maso.mt_id, maso.nac_id, maso.pro_id, maso.pc, maso.popust_obavezni);
	END IF;
  END LOOP;                  
  commit;
END;
PROCEDURE KOPIRANJE_ASORTIMANA
 (MT_ID_P IN M_MT.ID%TYPE
 ,NAC_ID_P IN M_NACPOT.ID%TYPE
 ,DATUM_DO_P IN DATE
 ,DATUM_OD_P IN DATE
 )
 IS
brojac_l NUMBER;
BEGIN
  SELECT COUNT(*) INTO brojac_l 
	 FROM m_aso_mt 
	WHERE mt_id = mt_id_p
	  AND nac_id = nac_id_p;
  IF brojac_l <> 0 THEN
	  DELETE m_aso_mt 
		WHERE mt_id = mt_id_p
		  AND nac_id = nac_id_p;
  END IF;				
  FOR maso IN (SELECT mt_id, nac_id, pro_id, pc, popust_obavezni
                 FROM m_aso_mt_dat 
				    WHERE mt_id = mt_id_p
				      AND nac_id = nac_id_p
				      AND dat_poc = datum_od_p
				      AND dat_zav = datum_do_p)
  LOOP
      INSERT INTO m_aso_mt (mt_id, nac_id, pro_id, pc, popust_obavezni)
      VALUES (maso.mt_id, maso.nac_id, maso.pro_id, maso.pc, maso.popust_obavezni);
  END LOOP;                  
  commit;
END;
PROCEDURE BRISANJE_IZ_ARHIVE_ASORTIMANA
 (MT_ID_P IN M_MT.ID%TYPE
 ,NAC_ID_P IN M_NACPOT.ID%TYPE
 ,DATUM_DO_P IN DATE
 ,DATUM_OD_P IN DATE
 )
 IS
brojac_l NUMBER;
BEGIN
   DELETE m_aso_mt_dat 
   WHERE mt_id = mt_id_p
         AND nac_id = nac_id_p
	 AND dat_poc = datum_od_p
	 AND dat_zav = datum_do_p;
  commit;
END;
FUNCTION PNC_PROIZVODA
 (MT_ID_P NUMBER
 ,PRO_ID_P NUMBER
 )
 RETURN NUMBER
 IS

pnc_proizvoda_L  m_proizvodi.zad_nab_cijena%TYPE:=0;
pnc_L            m_proizvodi.zad_nab_cijena%TYPE;
datum_l  DATE;
BEGIN
  FOR sas IN (
      SELECT nam_id, pro_id_poluproizvod, normativ
        FROM m_sastav
       WHERE pro_id = pro_id_p)
  LOOP
      IF sas.nam_id IS NOT NULL THEN
         pnc_l := 0;
        
         SELECT MAX (datum) INTO datum_L
           FROM i_dnev_ui
          WHERE nam_id = sas.nam_id
            AND mt_id = mt_id_p;
             
         IF datum_l IS NOT NULL THEN    
           SELECT pros_nab_cijena INTO pnc_L
             FROM i_dnev_ui
            WHERE nam_id = sas.nam_id
              AND mt_id = mt_id_p
              AND datum = datum_l;
         END IF;    
         IF pnc_l = 0 THEN
            SELECT zad_nab_cijena INTO pnc_l 
              FROM m_namirnice 
             WHERE id = sas.nam_id;
        END IF;
     ELSE
        SELECT pros_nab_cijena INTO pnc_L
          FROM m_proizvodi
         WHERE id = sas.pro_id_poluproizvod;
     END IF;           
     pnc_proizvoda_l := pnc_proizvoda_l + pnc_l * sas.normativ;
  END LOOP; 
  RETURN pnc_proizvoda_l;
END;
PROCEDURE PREPISI_SA_OBJEKTA
 IS
BEGIN
   /* Samo centar moe pokrenuti prikupljanje */
   IF pra_zmp_zaj.centar = 0 THEN
      RETURN;
   END IF;

   FOR metins IN (
      SELECT ins.metcvor_sifra
      FROM smet_instalacije ins, smet_cvorovi cvor
      WHERE ins.metapl_sifra = 'GAS'
         AND ins.metcvor_sifra <> pra_zmp_zaj.tekuci_cvor
         AND ins.metcvor_sifra = cvor.sifra
         AND cvor.ozn_u_mrezi = -1
      ORDER BY ins.metcvor_sifra
   ) LOOP
      DECLARE
         v_sql_stmt VARCHAR2(1000);
      BEGIN
         v_sql_stmt := 'INSERT INTO M_ASO_MT SELECT * FROM M_ASO_MT@' || metins.metcvor_sifra;
         EXECUTE IMMEDIATE v_sql_stmt;
      EXCEPTION
         WHEN OTHERS THEN
            DBMS_OUTPUT.put_line('Error executing statement for ' || metins.metcvor_sifra || ': ' || SQLERRM);
            -- Handle the exception or log the error as needed
      END;
      COMMIT;
   END LOOP;
END;

END FM_GAS1250;
/
SHOW ERROR

