PROMPT Creating Package Body 'BM_REC3010'
CREATE OR REPLACE PACKAGE BODY BM_REC3010 IS

METCVOR_SIFRA_CENTAR_M SMET_CVOROVI.SIFRA%TYPE;
METCVOR_SIFRA_PODCENTAR_M SMET_CVOROVI.SIFRA%TYPE;
METCVOR_SIFRA_TEKUCI_M SMET_CVOROVI.SIFRA%TYPE;


PROCEDURE IZR_NOCENJA_DOLAZAKA
 (SO_ID_P IN I_NOCENJA.SO_ID%TYPE
 ,DAT_POC_P IN I_NOCENJA.DATUM%TYPE
 ,DAT_ZAV_P IN I_NOCENJA.DATUM%TYPE
 )
 IS
--
  metcvor_sifra_x_l VARCHAR2(41); -- IRN 2291
  age_id_l i_nocenja.age_id%TYPE;
  datum_l i_nocenja.datum%TYPE;
  lokal_l NUMBER;
  ozn_u_mrezi_l smet_cvorovi.ozn_u_mrezi%TYPE;
  dana_l NUMBER;
  irec_nocenja_id_l irec_nocenja.id%TYPE;
  irec_nocenja_id_centar_l irec_nocenja.id%TYPE;
  naredba_l VARCHAR2(1000);
  recgdgost_id_l i_nocenja.recgdgost_id%TYPE;
  so_sifra_l m_so.sifra%TYPE;
BEGIN

  metcvor_sifra_centar_m := LOWER (pra_zmp_zaj.vrijednost_parametra ('0019'));
  metcvor_sifra_podcentar_m := LOWER (pra_zmp_zaj.vrijednost_parametra ('0018'));
  metcvor_sifra_tekuci_m := LOWER (pra_zmp_zaj.tekuci_cvor);

  IF pra_rec_zaj.vrijednost_parametra ('1168') = 'da' THEN
    -- iskljui _optim_peek_user_binds
    EXECUTE IMMEDIATE 'ALTER SESSION SET "_optim_peek_user_binds" = FALSE';
  END IF;

  IF so_id_p IS NULL
    OR dat_poc_p IS NULL
    OR dat_zav_p IS NULL
  THEN
    -- ifra smjetajnog objekta te poetni i zavrni datum za izraun su obvezni!
    pra_rec_zaj.vrati_poruku (-20225);
  END IF;
  IF dat_poc_p > dat_zav_p THEN
    -- Poetni datum mora biti manji ili jednak zavrnom!
    pra_rec_zaj.vrati_poruku (-20226);
  END IF;

  SELECT sifra INTO so_sifra_l FROM m_so WHERE id = so_id_p;

  -- Zabrani izraun za SO izvan tekueg vora ili za SO koji nije u mrei
  BEGIN
    SELECT DECODE (so.metcvor_sifra, pra_zmp_zaj.tekuci_cvor, -1, 0), ozn_u_mrezi
      INTO lokal_l, ozn_u_mrezi_l
      FROM m_so so, smet_cvorovi c
     WHERE so.id = so_id_p
       AND c.sifra = pra_zmp_zaj.tekuci_cvor;
  EXCEPTION
    WHEN OTHERS THEN
      lokal_l := 0;
      ozn_u_mrezi_l := 0;
  END;
  IF lokal_l = 0 THEN
    -- Smjetajni objekt ne pripada lokalnom serveru. Izraun statistike nije doputen!
    pra_rec_zaj.vrati_poruku (-20344);
  ELSE
    IF ozn_u_mrezi_l = 0 THEN
      -- Lokalni server nije umreen. Izraun statistike nije doputen!
      pra_rec_zaj.vrati_poruku (-20345);
    END IF;
  END IF;
  -- END Zabrani izraun za SO izvan tekueg vora ili za SO koji nije u mrei

  -- Provjeri ifru vora
  IF metcvor_sifra_podcentar_m IS NULL THEN
    -- Izraun statistike nije mogu jer nije definirana veza prema centralnom serveru!
    pra_rec_zaj.vrati_poruku (-20346);
  END IF;
  -- END Provjeri ifru vora

  -- Provjera ispravnosti veze prema centru
  IF metcvor_sifra_podcentar_m  <> 'nebitno'
    AND metcvor_sifra_podcentar_m <> metcvor_sifra_tekuci_m
  THEN
    metcvor_sifra_x_l := '@' || metcvor_sifra_podcentar_m; -- IRN 2291
    IF NOT pra_rec_s.centar_connected (metcvor_sifra_podcentar_m) THEN
      -- Veza prema centralnom serveru nije aktivna. Nastavak izrauna nije mogu!
      pra_rec_zaj.vrati_poruku (-20347);
    END IF;
  END IF;
  -- END Provjera ispravnosti veze prema centru

  -- Datum izrauna ne moe biti manji od poetnog datuma rada na aplikaciji (ZMP parametar 0036).
  pra_zmp_s.provjeri_dat_pocetni_0036 (dat_poc_p);

  -- brisanje, sve lokal i centar za sve dane - na kraju commit;

  dana_l := 0;
  LOOP
    EXIT WHEN (dat_zav_p - dana_l) < dat_poc_p;
    DELETE i_nocenja WHERE so_id = so_id_p AND datum = (dat_zav_p - dana_l);
    IF metcvor_sifra_x_l IS NOT NULL THEN
       EXECUTE IMMEDIATE 'DELETE i_nocenja' || metcvor_sifra_x_l || ' WHERE so_id = :so_id AND datum = :datum'
         USING so_id_p, dat_zav_p - dana_l;
    END IF;
    -- ima ili nema zaglavlja statistike za dan, za lokal i centar
    BEGIN
      SELECT id INTO irec_nocenja_id_l FROM irec_nocenja WHERE so_id = so_id_p AND datum = (dat_zav_p - dana_l);
    EXCEPTION
       WHEN NO_DATA_FOUND THEN
          irec_nocenja_id_l := NULL;
    END;
    IF metcvor_sifra_x_l IS NOT NULL THEN
      naredba_l := 'SELECT id FROM irec_nocenja' || metcvor_sifra_x_l || ' WHERE so_id = :so_id AND datum = :datum';
      BEGIN
        EXECUTE IMMEDIATE naredba_l INTO irec_nocenja_id_centar_l USING so_id_p, (dat_zav_p - dana_l);
      EXCEPTION
        WHEN NO_DATA_FOUND THEN
          irec_nocenja_id_centar_l := NULL;
      END;
    END IF;
    IF irec_nocenja_id_l IS NOT NULL THEN
      DELETE irec_noc_plo WHERE recnoc_id = irec_nocenja_id_l;
      DELETE irec_nocenja WHERE id = irec_nocenja_id_l;
    END IF;
    IF metcvor_sifra_x_l IS NOT NULL THEN
      IF irec_nocenja_id_centar_l IS NOT NULL THEN
        EXECUTE IMMEDIATE
          'DELETE irec_noc_plo' || metcvor_sifra_x_l || ' WHERE recnoc_id = :recnoc_id' USING irec_nocenja_id_centar_l;
        EXECUTE IMMEDIATE
          'DELETE irec_nocenja' || metcvor_sifra_x_l || ' WHERE id = :id' USING irec_nocenja_id_centar_l;
      END IF;
    END IF;
    bm_rec3050.brisi_recpok_sve (so_id_p, (dat_zav_p - dana_l), metcvor_sifra_podcentar_m);
    dana_l := dana_l + 1;
  END LOOP;
  COMMIT;
  -- kraj brisanje

  -- izraun --

  dana_l := (dat_zav_p - dat_poc_p);
  <<petlja_dana>>
  FOR dan IN 0..dana_l LOOP
    datum_l := dat_poc_p + dan;

    <<petlja_nocenja>>
    FOR izr IN
      (
      SELECT
        so_id,
        zem_id,
        ms_id,
        age_id,
        recvpro_id,
        vsj_id,
        ponso_id,
        recnrez_id,
        ozn_vloyalty,
        dob,
        SUM (br_nocenja) br_nocenja,
        SUM (br_dolazaka) br_dolazaka,
        SUM (br_odlazaka) br_odlazaka,
        SUM (kol_sjz) kol_sjz
      FROM
        (
        -- noenja, dolasci, zauzete SJ
        SELECT
          sj.so_id so_id,
          gost.zem_id zem_id,
          gost.ms_id,
          gost.age_id,
          gost.recvpro_id,
          sj.vsj_id vsj_id,
          gost.ponso_id,
          rez.recnrez_id,
          (
          CASE
            WHEN ms.ozn_loyalty = -1
                 AND recagost.oznaka = 'V'
                 -- IRN 2678 -- AND recagost.br_loy_kartice IS NOT NULL
                 AND pra_rec_loy.loykar_id (recagost.id, sj.so_id, datum_l) IS NOT NULL -- IRN 2678
            THEN 1 -- redovni
            WHEN ms.ozn_loyalty = -1
                 AND recagost.oznaka = 'V'
                 AND recagost.sifra IS NOT NULL
                 AND recagost.stopa_popusta IS NOT NULL
            THEN 2 -- s popustom
            ELSE NULL
          END) ozn_vloyalty,
          pra_rec_s3.dob_kgost (gost.id, gost.dat_dolaska) dob,
          -- fiktivni gost ne poveava noenja i dolazaka ali poveava kol_sjz
          CASE
            WHEN gost.ozn_fiktivni = 0 THEN 1
            ELSE 0
          END br_nocenja,
          CASE
            WHEN gost.dat_dolaska = datum_l AND gost.ozn_fiktivni = 0 THEN 1
            ELSE 0
          END br_dolazaka,
          0 br_odlazaka,
          DECODE (gost.id, min_gost_u_sj.gost_id, 1, 0) kol_sjz
        FROM
          t_gosti gost,
          m_sj sj,
          t_rez_vsj rezvsj,
          t_rezervacije rez,
          (
          SELECT sj.id AS sj_id,
                 MIN (gost.id) AS gost_id
            FROM t_gosti gost,
                 m_sj sj
           WHERE pra_rec_s2.sj_id_recgostbor (gost.id, datum_l) = sj.id
             AND sj.so_id = so_id_p
             AND datum_l BETWEEN gost.dat_dolaska AND (gost.dat_odlaska - 1)
             AND gost.id NOT IN (SELECT id FROM trec_kplovila)
           GROUP BY sj.id
          ) min_gost_u_sj,
          m_msegmenti ms,
          trec_agostiju recagost
        WHERE
          pra_rec_s2.sj_id_recgostbor (gost.id, datum_l) = sj.id
          AND sj.id = min_gost_u_sj.sj_id
          AND sj.so_id = so_id_p
          AND datum_l BETWEEN gost.dat_dolaska AND (gost.dat_odlaska - 1)
          AND gost.id NOT IN (SELECT id FROM trec_kplovila)
          AND gost.rezvsj_id = rezvsj.id (+)
          AND rezvsj.rez_id = rez.id (+)
          AND gost.ms_id = ms.id
          AND gost.recagost_id = recagost.id (+)
        UNION ALL
        -- zakupljene (ne)zauzete SJ
        SELECT
          sj.so_id so_id,
          NVL (pkaadr.zem_id, age.zem_id) zem_id,
          zak.ms_id,
          zak.age_id,
          NULL recvpro_id,
          sj.vsj_id,
          NULL ponso_id,
          NULL recnrez_id,
          NULL ozn_vloyalty,
          NULL dob,
          0 br_nocenja,
          0 br_dolazaka,
          0 br_odlazaka,
          1 kol_sjz
        FROM
          t_zakup zak,
          t_zak_sj zaksj,
          m_sj sj,
          (
          (SELECT sj_id
             FROM t_zakup zak, t_zak_sj zaksj, s_vzakupa vzak
            WHERE zak.id = zaksj.zak_id AND zak.so_id = so_id_p
              AND datum_l BETWEEN zak.dat_poc AND (zak.dat_zav - 1)
              AND zak.oznaka IN ('V')
              AND zak.vzak_id = vzak.id AND vzak.ozn_sj_zauzeta = -1) -- zakupljene SJ
           MINUS
          (SELECT pra_rec_s2.sj_id_recgostbor (gost.id, datum_l) sj_id
             FROM t_gosti gost, m_sj sj
            WHERE sj.so_id = so_id_p
              AND datum_l BETWEEN gost.dat_dolaska AND (gost.dat_odlaska - 1)
              AND sj.id = pra_rec_s2.sj_id_recgostbor (gost.id, datum_l)
              AND gost.id NOT IN (SELECT id FROM trec_kplovila))    -- pune SJ
          ) prazne_zakupljene_sj,
          m_agencije age,
          mpka_adrese pkaadr
        WHERE
          zak.id = zaksj.zak_id
          AND zak.oznaka IN ('V')
          AND zak.so_id = so_id_p
          AND zaksj.sj_id = prazne_zakupljene_sj.sj_id
          AND zaksj.sj_id = sj.id
          AND zak.age_id = age.id (+)
          AND zak.pkaadr_id = pkaadr.id (+)
          AND datum_l BETWEEN zak.dat_poc AND (zak.dat_zav - 1)
        UNION ALL
        -- odlasci
        SELECT
          sj.so_id so_id,
          gost.zem_id zem_id,
          gost.ms_id,
          gost.age_id,
          gost.recvpro_id,
          sj.vsj_id vsj_id,
          gost.ponso_id,
          rez.recnrez_id,
          (
          CASE
            WHEN ms.ozn_loyalty = -1
                 AND recagost.oznaka = 'V'
                 -- IRN 2678 -- AND recagost.br_loy_kartice IS NOT NULL
                 AND pra_rec_loy.loykar_id (recagost.id, sj.so_id, datum_l) IS NOT NULL -- IRN 2678
            THEN 1 -- redovni
            WHEN ms.ozn_loyalty = -1
                 AND recagost.oznaka = 'V'
                 AND recagost.sifra IS NOT NULL
                 AND recagost.stopa_popusta IS NOT NULL
            THEN 2 -- s popustom
            ELSE NULL
          END) ozn_vloyalty,
          pra_rec_s3.dob_kgost (gost.id, gost.dat_dolaska) dob,
          0 br_nocenja,
          0 br_dolazaka,
          1 br_odlazaka,  -- fiktivni gosti su izbaeni u where
          0 kol_sjz
        FROM
          t_gosti gost,
          m_sj sj,
          t_rez_vsj rezvsj,
          t_rezervacije rez,
          m_msegmenti ms,
          trec_agostiju recagost
        WHERE
          pra_rec_s2.sj_id_recgostbor (gost.id, datum_l-1) = sj.id
          AND sj.so_id = so_id_p
          AND gost.dat_dolaska < datum_l
          AND gost.dat_odlaska = datum_l
          AND gost.ozn_fiktivni = 0
          AND gost.id NOT IN (SELECT id FROM trec_kplovila)
          AND gost.rezvsj_id = rezvsj.id (+)
          AND rezvsj.rez_id = rez.id (+)
          AND gost.ms_id = ms.id
          AND gost.recagost_id = recagost.id (+)
        )
      GROUP BY
        so_id,
        zem_id,
        ms_id,
        age_id,
        recvpro_id,
        vsj_id,
        ponso_id,
        recnrez_id,
        ozn_vloyalty,
        dob
      )
    LOOP
      -- Ne kreiraju se slogovi kod kojih nema ni noenja ni dolazaka ni odlazaka ni zauzetih SJ
      IF izr.br_nocenja > 0 OR izr.br_dolazaka > 0 OR izr.br_odlazaka > 0 OR izr.kol_sjz > 0 THEN
        age_id_l := LTRIM (RTRIM (TO_CHAR (izr.age_id)));
        IF age_id_l IS NULL OR LENGTH (age_id_l) = 0 THEN
          age_id_l := NULL;
        END IF;
        recgdgost_id_l := pra_rec_s2.gdgost_id (NULL, NULL, izr.dob, datum_l); -- IRN 4023

        EXECUTE IMMEDIATE
          'INSERT INTO i_nocenja (' ||
          '  datum, so_id, zem_id, ms_id, age_id, vsj_id, recgdgost_id, recvpro_id, ' ||
          '  br_nocenja, br_dolazaka, br_odlazaka, kol_sjz, ponso_id, recnrez_id, ' ||
          '  ozn_vloyalty, dob) ' ||
          'VALUES (' ||
          '  :datum, :so_id, :zem_id, :ms_id, :age_id, :vsj_id, :recgdgost_id, :recvpro_id, ' ||
          '  :br_nocenja, :br_dolazaka, :br_odlazaka, :kol_sjz, :ponso_id, :recnrez_id, ' ||
          '  :ozn_vloyalty, :dob)'
          USING datum_l, izr.so_id, izr.zem_id, izr.ms_id, age_id_l, izr.vsj_id, recgdgost_id_l, izr.recvpro_id,
                izr.br_nocenja, izr.br_dolazaka, izr.br_odlazaka, izr.kol_sjz, izr.ponso_id, izr.recnrez_id,
                izr.ozn_vloyalty, izr.dob;
        IF metcvor_sifra_x_l IS NOT NULL THEN
          EXECUTE IMMEDIATE
            'INSERT INTO i_nocenja' || metcvor_sifra_x_l || ' (' ||
            '  datum, so_id, zem_id, ms_id, age_id, vsj_id, recgdgost_id, recvpro_id, ' ||
            '  br_nocenja, br_dolazaka, br_odlazaka, kol_sjz, ponso_id, recnrez_id, ' ||
            '  ozn_vloyalty, dob) ' ||
            'VALUES (' ||
            '  :datum, :so_id, :zem_id, :ms_id, :age_id, :vsj_id, :recgdgost_id, :recvpro_id, ' ||
            '  :br_nocenja, :br_dolazaka, :br_odlazaka, :kol_sjz, :ponso_id, :recnrez_id, ' ||
            '  :ozn_vloyalty, :dob)'
            USING datum_l, izr.so_id, izr.zem_id, izr.ms_id, age_id_l, izr.vsj_id, recgdgost_id_l, izr.recvpro_id,
                  izr.br_nocenja, izr.br_dolazaka, izr.br_odlazaka, izr.kol_sjz, izr.ponso_id, izr.recnrez_id,
                  izr.ozn_vloyalty, izr.dob;
        END IF;
      END IF;
    END LOOP petlja_nocenja;

    INSERT INTO irec_nocenja (datum, so_id) VALUES (datum_l, so_id_p) RETURNING id INTO irec_nocenja_id_l;

    IF metcvor_sifra_x_l IS NOT NULL THEN
      naredba_l := 'SELECT pra_zmp_zaj.i3_sekvenca' || metcvor_sifra_x_l || '(NULL) FROM dual';
      EXECUTE IMMEDIATE naredba_l INTO irec_nocenja_id_centar_l;
      naredba_l := 'INSERT INTO irec_nocenja' || metcvor_sifra_x_l || ' (id, datum, so_id) VALUES (:id, :datum, :so_id)';
      EXECUTE IMMEDIATE naredba_l USING irec_nocenja_id_centar_l, datum_l, so_id_p;
    END IF;

    <<petlja_plovila>>
    FOR izr IN
       (
       SELECT
         gost.zem_id,
         gost.ms_id,
         gost.age_id,
         sj.vsj_id,
         pra_rec_s2.zmpdplo_id (kplov.duljina) duljina_plovila,
         kplov.vrsta vrsta_plovila,
         DECODE (kplov.reczakplo_id, NULL, 1, 2) vrsta_veza,
         kplov.ozn_suhi_vez suhi_vez,
         COUNT (gost.id) br_nocenja,
         SUM (DECODE (gost.dat_dolaska, datum_l, 1, 0)) br_dolazaka
       FROM
         t_gosti gost,
         m_sj sj,
         trec_kplovila kplov
       WHERE
         pra_rec_s2.sj_id_recgostbor (gost.id, datum_l) = sj.id
         AND sj.so_id = so_id_p
         AND gost.dat_dolaska <= datum_l
         AND gost.dat_odlaska > datum_l
         AND gost.id = kplov.id
       GROUP BY
         gost.zem_id,
         gost.ms_id,
         gost.age_id,
         sj.vsj_id,
         pra_rec_s2.zmpdplo_id (kplov.duljina),
         kplov.vrsta,
         DECODE (kplov.reczakplo_id, NULL, 1, 2),
         kplov.ozn_suhi_vez
      )
    LOOP
      -- Ne kreiraju se slogovi kod kojih nema ni noenja ni dolazaka
      IF izr.br_nocenja > 0 OR izr.br_dolazaka > 0 THEN
        age_id_l := LTRIM (RTRIM (TO_CHAR (izr.age_id)));
        IF age_id_l IS NULL OR LENGTH (age_id_l) = 0 THEN
          age_id_l := NULL;
        END IF;

        EXECUTE IMMEDIATE
          'INSERT INTO irec_noc_plo (' ||
          '  recnoc_id, zem_id, ms_id, age_id, vsj_id, zmpdplo_id, vrsta_plovila, ' ||
          '  vrsta_veza, ozn_suhi_vez, br_dolazaka, br_nocenja) ' ||
          'VALUES (' ||
          '  :recnoc_id, :zem_id, :ms_id, :age_id, :vsj_id, :zmpdplo_id, :vrsta_plovila, ' ||
          '  :vrsta_veza, :ozn_suhi_vez, :br_dolazaka, :br_nocenja)'
          USING irec_nocenja_id_l, izr.zem_id, izr.ms_id, age_id_l, izr.vsj_id, izr.duljina_plovila, izr.vrsta_plovila,
                izr.vrsta_veza, izr.suhi_vez, izr.br_dolazaka, izr.br_nocenja;
        IF metcvor_sifra_x_l IS NOT NULL THEN
          EXECUTE IMMEDIATE
            'INSERT INTO irec_noc_plo' || metcvor_sifra_x_l || ' (' ||
            '  recnoc_id, zem_id, ms_id, age_id, vsj_id, zmpdplo_id, vrsta_plovila, ' ||
            '  vrsta_veza, ozn_suhi_vez, br_dolazaka, br_nocenja) ' ||
            'VALUES (' ||
            '  :recnoc_id, :zem_id, :ms_id, :age_id, :vsj_id, :zmpdplo_id, :vrsta_plovila, ' ||
            '  :vrsta_veza, :ozn_suhi_vez, :br_dolazaka, :br_nocenja)'
            USING irec_nocenja_id_centar_l, izr.zem_id, izr.ms_id, age_id_l, izr.vsj_id, izr.duljina_plovila, izr.vrsta_plovila,
                  izr.vrsta_veza, izr.suhi_vez, izr.br_dolazaka, izr.br_nocenja;
        END IF;
      END IF;
    END LOOP petlja_plovila;

    -- pokazatelji uspjenosti (izraun i kopiranje na centar)
    bm_rec3050.izracunaj_recpok_sve (so_id_p, datum_l, metcvor_sifra_podcentar_m);

    COMMIT;
  END LOOP petlja_dana;
  -- END izraun

  /*
  26.07.2011. G.J. IRN 1556
  Naknadno auriranje bodova programa vjernosti
  */
  bm_rec3010.azuriraj_loyulaizl;

  /*
  13.11.2009. G.J. IRN 1092
  Kopiraj podatke iz knjige gostiju u arhivu gostiju za odjavljene boravke gostiju iz arhive
  */
  bm_rec3010.azuriraj_recagost (so_id_p, dat_poc_p, dat_zav_p);

  /*
  19.01.2007. G.J.
  Puni arhivu gostiju
  */
  bm_rec3010.puni_recagost (so_id_p, dat_poc_p, dat_zav_p);

  /*
  20.12.2002. G.J.
  Puni boravke gostiju iz arhive gostiju
  */
  bm_rec3010.puni_recagostbo (so_id_p, dat_poc_p, dat_zav_p);

EXCEPTION
  WHEN OTHERS THEN
    pra_rec.puni_promjene ('0023', SUBSTR (pra_zmp_zaj.poruka ('REC', 'REC1500', so_sifra_l, TO_CHAR (dat_poc_p, 'DD.MM.RRRR'), TO_CHAR (dat_zav_p, 'DD.MM.RRRR')) || ' ' || SQLERRM, 1, 2000), 0);
    RAISE;
END;
PROCEDURE PUNI_RECAGOST
 (SO_ID_P IN IREC_NOCENJA.SO_ID%TYPE
 ,DAT_POC_P IN I_NOCENJA.DATUM%TYPE
 ,DAT_ZAV_P IN I_NOCENJA.DATUM%TYPE
 )
 IS
-- Puni u tablicu trec_agostiju na centru
  metcvor_sifra_x_l VARCHAR2(21);
  dat_max_c CONSTANT DATE := TO_DATE ('31.12.9999', 'DD.MM.RRRR'); -- IRN 2291
  naredba_l VARCHAR2(32000);
  /* -- IRN 2477
  Prilikom automatskog upisa u arhivu gostiju (parametar 1121) smiju se upisati podaci
  B = datum roenja,
  C = zemlja i mjesto roenja,
  D = oznaka VIP,
  E = o prebivalitu,
  F = o putnoj ispravi,
  G = vrsta plaanja BP
  */
  recparam1121_l szmp_parametri.vrijednost%TYPE := UPPER (pra_rec_zaj.vrijednost_parametra ('1121'));
  CURSOR gost_c (id_k t_gosti.id%TYPE) IS
    SELECT 1
      FROM t_gosti
     WHERE id = id_k
       FOR UPDATE OF recagost_id NOWAIT;
  nebitno_l NUMBER;
  recagost_rec_l trec_agostiju%ROWTYPE;
  br_redaka_log_l NUMBER := 0;
  so_sifra_l m_so.sifra%TYPE;
  loy_param_1017_l szmp_parametri.vrijednost%TYPE; -- IRN 3991
  br_redaka_l NUMBER; -- IRN 3991
BEGIN

  metcvor_sifra_centar_m := LOWER (pra_zmp_zaj.vrijednost_parametra ('0019'));
  metcvor_sifra_podcentar_m := LOWER (pra_zmp_zaj.vrijednost_parametra ('0018'));
  metcvor_sifra_tekuci_m := LOWER (pra_zmp_zaj.tekuci_cvor);

  IF so_id_p IS NULL
    OR dat_poc_p IS NULL
    OR dat_zav_p IS NULL
    OR metcvor_sifra_centar_m IS NULL -- IRN 2291
    OR metcvor_sifra_podcentar_m IS NULL
    OR metcvor_sifra_tekuci_m IS NULL
  THEN
    RETURN;
  END IF;

  metcvor_sifra_x_l := pra_trec_agostiju.metcvor_sifra_x ('trec_agostiju'); -- IRN 2291
  SELECT sifra INTO so_sifra_l FROM m_so WHERE id = so_id_p;

  -- IRN 3991
  -- Oznaka vrste programa vjernosti: IT (Istra tech), LIS (LoyaltyInSky) ili nebitno.  
  loy_param_1017_l := pra_zmp_zaj.zmppar_vrijednost ('LOY', '1017');

  FOR kgost_c IN (
    SELECT
      kgost.pos_id AS pos_id,
      kgost.reg_id AS reg_id,
      kgost.vplabp_id AS vplabp_id,
      kgost.zemr_id AS zemr_id,
      kgost.posr_id AS posr_id,
      gost.zem_id AS zemd_id,
      kgost.vpisp_id AS vpisp_id,
      kgost.gpri_id AS gpri_id,
      -- recagost_id
      -- rbr
      -- oznaka
      gost.titula AS titula,
      gost.ime AS ime,
      gost.prezime AS prezime,
      kgost.naz_ulice AS naz_ulice,
      -- zanimanje
      kgost.naz_poduzeca AS naz_poduzeca,
      kgost.dat_rodjenja AS dat_rodjenja,
      kgost.naz_mjrodj AS naz_mjrodj,
      kgost.ozn_spola AS ozn_spola,
      kgost.br_telefona AS br_telefona,
      kgost.br_telefaksa AS br_telefaksa,
      kgost.email AS email,
      kgost.www AS www,
      kgost.br_pisprave AS br_pisprave,
      kgost.naz_mjpisp AS naz_mjpisp,
      -- srodstvo
      kgost.unos_korisnik AS unos_korisnik,
      kgost.unos_dat AS unos_dat,
      -- izmjena_korisnik,
      -- izmjena_dat,
      NVL (kgost.zem_id, gost.zem_id) AS zem_id,
      gost.jez_id AS jez_id,
      -- recggost_id
      -- sifra,
      kgost.naz_mjesta AS naz_mjesta,
      kgost.naz_regije AS naz_regije,
      NVL (kgost.ozn_kontakt, 0) AS ozn_kontakt,
      NVL (kgost.ozn_kontakt_telefon, 0) AS ozn_kontakt_telefon,
      NVL (kgost.ozn_kontakt_telefaks, 0) AS ozn_kontakt_telefaks,
      NVL (kgost.ozn_kontakt_email, 0) AS ozn_kontakt_email,
      -- ozn_abc
      -- stopa_popusta
      -- lozinka
      gost.ozn_vip AS ozn_vip,
      gost.id AS gost_id
    FROM
      t_kgostiju kgost,
      t_gosti gost,
      m_sj sj
    WHERE
      kgost.gost_id = gost.id
      AND gost.sj_id = sj.id
      AND sj.so_id = so_id_p
      AND (
          gost.dat_odlaska BETWEEN dat_poc_p AND dat_zav_p
          OR
          TRUNC (gost.sat_odjave) BETWEEN dat_poc_p AND dat_zav_p -- IRN 1143
          )
      AND gost.recagost_id IS NULL
      AND gost.ozn_prisutnosti = 'O'
      AND gost.id NOT IN (SELECT id FROM trec_kplovila)
      AND NVL (gost.ozn_brisano, 0) = 0 -- IRN 3105, IRN 3130
      AND gost.ozn_fiktivni = 0 -- IRN 3105
      AND kgost.oznaka = 'V'
      AND kgost.ozn_recagost = -1 -- IRN 2477
      AND kgost.ozn_brisano = 0 -- IRN 2477
    ORDER BY gost.rbr) -- IRN 1810
  LOOP

    SELECT COUNT (id) INTO nebitno_l
      FROM trec_agostiju
     WHERE oznaka = 'V' -- IRN 2291
       AND UPPER (ime) = UPPER (kgost_c.ime)
       AND UPPER (prezime) = UPPER (kgost_c.prezime)
       AND NVL (dat_rodjenja, dat_max_c) = NVL (kgost_c.dat_rodjenja, dat_max_c) -- IRN 2291
       AND NVL (zemd_id, zem_id) = kgost_c.zemd_id; -- IRN 3105
    IF nebitno_l > 0 THEN
      -- u arhivi postoji valjani zapis s jednakim imenom, prezimenom, datumom roenja i dravljanstvom
      GOTO kraj_petlje; -- IRN 2291
    END IF;

    recagost_rec_l := NULL; -- IRN 2291
    naredba_l := 'SELECT pra_zmp_zaj.i3_sekvenca' || metcvor_sifra_x_l || ' (NULL) FROM dual';
    EXECUTE IMMEDIATE naredba_l INTO recagost_rec_l.id;

    -- recagost_id
    -- rbr
    recagost_rec_l.oznaka := 'V';
    recagost_rec_l.titula := kgost_c.titula;
    recagost_rec_l.ime := kgost_c.ime;
    recagost_rec_l.prezime := kgost_c.prezime;
    -- zanimanje
    recagost_rec_l.zemd_id := kgost_c.zemd_id;
    recagost_rec_l.naz_poduzeca := kgost_c.naz_poduzeca;

    IF INSTR (recparam1121_l, 'B') > 0 THEN -- IRN 2477
      recagost_rec_l.dat_rodjenja := kgost_c.dat_rodjenja;
    END IF;

    IF INSTR (recparam1121_l, 'C') > 0 THEN -- IRN 2477
      recagost_rec_l.zemr_id := kgost_c.zemr_id;
      recagost_rec_l.posr_id := kgost_c.posr_id;
      recagost_rec_l.naz_mjrodj := kgost_c.naz_mjrodj;
    END IF;

    IF INSTR (recparam1121_l, 'D') > 0 THEN -- IRN 2477
      recagost_rec_l.ozn_vip := kgost_c.ozn_vip;
    END IF;

    recagost_rec_l.zem_id := kgost_c.zem_id; -- obavezan podatak u trec_agostiju

    IF INSTR (recparam1121_l, 'E') > 0 THEN -- IRN 2477
      recagost_rec_l.naz_ulice := kgost_c.naz_ulice;
      recagost_rec_l.pos_id := kgost_c.pos_id;
      recagost_rec_l.reg_id := kgost_c.reg_id;
      recagost_rec_l.naz_mjesta := kgost_c.naz_mjesta;
      recagost_rec_l.naz_regije := kgost_c.naz_regije;
    END IF;

    IF INSTR (recparam1121_l, 'F') > 0 THEN -- IRN 2477
      recagost_rec_l.vpisp_id := kgost_c.vpisp_id;
      recagost_rec_l.br_pisprave := kgost_c.br_pisprave;
      recagost_rec_l.naz_mjpisp := kgost_c.naz_mjpisp;
      -- IRN 2477 recagost_rec_l.gpri_id := kgost_c.gpri_id;
    END IF;

    IF INSTR (recparam1121_l, 'G') > 0 THEN -- IRN 2477
      recagost_rec_l.vplabp_id := kgost_c.vplabp_id;
    END IF;

    recagost_rec_l.ozn_spola := kgost_c.ozn_spola;
    recagost_rec_l.br_telefona := kgost_c.br_telefona;
    recagost_rec_l.br_telefaksa := kgost_c.br_telefaksa;

    -- IRN 3385, IRN 3991
    br_redaka_l := 0;
    -- za vrstu programa vjernosti LIS provjeri postoji li valjani zapis s jednakom e-adresom
    IF loy_param_1017_l IN ('LIS', 'BECRM') -- IRN 4108
      AND kgost_c.email IS NOT NULL
    THEN
      SELECT COUNT (1) INTO br_redaka_l
        FROM trec_agostiju
       WHERE oznaka = 'V'
         AND email IS NOT NULL
         AND LOWER (email) = LOWER (kgost_c.email);
    END IF;
    IF br_redaka_l = 0 THEN
      recagost_rec_l.email := kgost_c.email;
    END IF;
    -- KRAJ IRN 3385, IRN 3991

    recagost_rec_l.www := kgost_c.www;
    -- srodstvo
    recagost_rec_l.unos_korisnik := kgost_c.unos_korisnik;
    recagost_rec_l.unos_dat := SYSDATE; -- IRN 2291; kgost_c.unos_dat;
    -- izmjena_korisnik
    -- izmjena_dat
    recagost_rec_l.jez_id := kgost_c.jez_id;
    -- recggost_id
    -- sifra
    recagost_rec_l.ozn_kontakt := kgost_c.ozn_kontakt;
    recagost_rec_l.ozn_kontakt_telefon := kgost_c.ozn_kontakt_telefon;
    recagost_rec_l.ozn_kontakt_telefon2 := 0;
    recagost_rec_l.ozn_kontakt_telefaks := kgost_c.ozn_kontakt_telefaks;
    recagost_rec_l.ozn_kontakt_email := kgost_c.ozn_kontakt_email;
    recagost_rec_l.guid := pra_zmp_zaj.formatted_guid (NULL); -- IRN 2710
    -- IRN 2291; funkcija pra_trec_agostiju.recagost_rec aurira i pra_trec_agostiju.ozn_azuriraj_podcentar_g
    pra_rec_iud2.insert_recagost_cvor (metcvor_sifra_x_l, pra_trec_agostiju.recagost_rec (recagost_rec_l)); -- IRN 2291

    OPEN gost_c (kgost_c.gost_id);
    FETCH gost_c INTO nebitno_l;
    IF gost_c%FOUND THEN
      UPDATE t_gosti
         SET recagost_id = recagost_rec_l.id
       WHERE CURRENT OF gost_c;
      br_redaka_log_l := br_redaka_log_l + 1; -- IRN 1810
    END IF;
    CLOSE gost_c;

    COMMIT;

    -- IRN 2291; auriraj stupce na podcentru
    IF pra_trec_agostiju.ozn_azuriraj_podcentar_g = -1 THEN -- oznaku aurira funkcija pra_trec_agostiju.recagost_rec
      SELECT rbr INTO recagost_rec_l.rbr FROM trec_agostiju WHERE id = recagost_rec_l.id;
      pra_trec_agostiju.update_recagost_podcentar (recagost_rec_l);
      COMMIT;
    END IF;

    <<kraj_petlje>> NULL; -- IRN 2291
  END LOOP;

EXCEPTION
  WHEN OTHERS THEN
    IF gost_c%ISOPEN THEN
      CLOSE gost_c;
    END IF;
    pra_rec.puni_promjene ('0023', SUBSTR ('(puni_recagost)' || ' ' || pra_zmp_zaj.poruka ('REC', 'REC1500', so_sifra_l, TO_CHAR (dat_poc_p, 'DD.MM.RRRR'), TO_CHAR (dat_zav_p, 'DD.MM.RRRR')) || ' ' || SQLERRM, 1, 2000), 0); -- IRN 1810
    RAISE;
END;
PROCEDURE PUNI_RECAGOSTBO
 (SO_ID_P IN M_SO.ID%TYPE
 ,DAT_POC_P IN I_NOCENJA.DATUM%TYPE
 ,DAT_ZAV_P IN I_NOCENJA.DATUM%TYPE
 ,GOST_ID_P IN t_gosti.id%TYPE := NULL
 )
 IS
--
  metcvor_sifra_x_l VARCHAR2(41);
  so_sifra_l m_so.sifra%TYPE;

  CURSOR tro_c (gost_id_k t_gosti.id%TYPE) IS
    SELECT tro.val_id AS val_id,
           usl.sifra AS usl_sifra,
           tro.cijena_usluge * tro.stopa_placanja / 100 AS cijena_usluge,
           rac.god_poslovna AS rac_god_poslovna,
           oj.sifra AS oj_sifra,
           vapldok.oznaka AS vapldok_oznaka,
           rac.rbr AS rac_rbr
      FROM t_troskovi tro,
           s_usluge usl,
           t_racuni rac,
           m_oj oj,
           s_vapldok vapldok
     WHERE tro.gost_id = gost_id_k
       AND tro.usl_id = usl.id
       AND tro.usl_id1 IS NULL
       AND usl.ozn_osnovna = -1
       AND tro.rac_id = rac.id (+)
       AND rac.oj_id = oj.id (+)
       AND rac.vapldok_id = vapldok.id (+)
       -- IRN 3032; AND NVL (rac.oznaka, 'V') = 'V'
       AND rac.oznaka (+) = 'V' -- IRN 3032
     ORDER BY usl.ozn_abc, tro.dat_poc;
  tro_c_l tro_c%ROWTYPE;

  recagostbo_rec_l irec_agost_boravci%ROWTYPE;
  br_redaka_log_l NUMBER := 0; -- IRN 1810
BEGIN

  metcvor_sifra_centar_m := LOWER (pra_zmp_zaj.vrijednost_parametra ('0019'));
  metcvor_sifra_podcentar_m := LOWER (pra_zmp_zaj.vrijednost_parametra ('0018'));
  metcvor_sifra_tekuci_m := LOWER (pra_zmp_zaj.tekuci_cvor);

  IF so_id_p IS NULL
    OR dat_poc_p IS NULL
    OR dat_zav_p IS NULL
    OR metcvor_sifra_centar_m IS NULL
    OR metcvor_sifra_podcentar_m IS NULL
    OR metcvor_sifra_tekuci_m IS NULL
  THEN
    RETURN;
  END IF;

  metcvor_sifra_x_l := pra_trec_agostiju.metcvor_sifra_x ('irec_agost_boravci'); -- IRN 2291
  SELECT sifra INTO so_sifra_l FROM m_so WHERE id = so_id_p;

  FOR gost_c IN (
    SELECT gost.recagost_id AS recagost_id,
           gost.id AS gost_id,
           gost.god_poslovna AS god_poslovna,
           so.sifra AS sifra_so,
           sj.broj AS br_sj,
           vsj.sifra AS sifra_vsj,
           gost.rbr AS rbr_gosta,
           gost.dat_dolaska AS dat_dolaska,
           gost.dat_odlaska AS dat_odlaska,
           /* od v116 idu ime i prezime u posebne stupce
           DECODE (gost.napomena, NULL,
             pra_zmp_zaj.poruka ('REC', 'REC0576') || ' ' ||
               LTRIM (RTRIM (gost.ime)) || ' ' ||
               LTRIM (RTRIM (gost.prezime)),
             SUBSTR (
               pra_zmp_zaj.poruka ('REC', 'REC0576') || ' ' ||
                 LTRIM (RTRIM (gost.ime)) || ' ' ||
                 LTRIM (RTRIM (gost.prezime)) || ', ' ||
                 LTRIM (RTRIM (gost.napomena)),
               1, 240)) AS napomena,
           */
           LTRIM (RTRIM (gost.napomena)) AS napomena,
           recagost.oznaka AS recagost_oznaka,
           gost.prezime AS prezime,
           gost.ime AS ime,
           so.naziv AS so_naziv,
           ms.sifra AS ms_sifra,
           age.sifra AS age_sifra,
           age.naziv AS age_naziv
      FROM t_gosti gost,
           m_sj sj,
           m_so so,
           s_vsj vsj,
           m_msegmenti ms,
           m_agencije age,
           trec_agostiju recagost
     WHERE gost.sj_id = sj.id
       AND sj.so_id = so.id
       AND sj.so_id = so_id_p
       AND (
           gost.dat_odlaska BETWEEN dat_poc_p AND dat_zav_p
           OR
           TRUNC (gost.sat_odjave) BETWEEN dat_poc_p AND dat_zav_p -- IRN 1143
           )
       AND sj.vsj_id = vsj.id
       AND gost.ms_id = ms.id
       AND gost.age_id = age.id (+)
       AND gost.ozn_prisutnosti = 'O'
       AND gost.recagost_id = recagost.id
       AND gost.id || metcvor_sifra_podcentar_m || so.sifra IN ( -- IRN 2291
           SELECT t_gosti.id || metcvor_sifra_podcentar_m || m_so.sifra
             FROM t_gosti,
                  m_sj,
                  m_so
            WHERE t_gosti.sj_id = m_sj.id
              AND m_sj.so_id = m_so.id
              AND t_gosti.ozn_prisutnosti = 'O'
              AND t_gosti.recagost_id IS NOT NULL
           MINUS
           SELECT gost_id || metcvor_sifra_podcentar_m || sifra_so
             FROM irec_agost_boravci
            WHERE gost_id IS NOT NULL)
       AND gost.id = NVL (gost_id_p, gost.id) -- IRN 2276
       AND NVL (gost.ozn_brisano, 0) = 0 -- IRN 3105, IRN 3130
       AND gost.ozn_fiktivni = 0 -- IRN 3105
     ORDER BY gost.rbr) -- IRN 1810
  LOOP
    IF gost_c.recagost_oznaka = 'V' THEN
      OPEN tro_c (gost_c.gost_id);
      FETCH tro_c INTO tro_c_l;
      IF tro_c%NOTFOUND THEN
        tro_c_l := NULL; -- inae bi se gostu upisala usluga prethodnog gosta
      END IF;
      CLOSE tro_c;

      recagostbo_rec_l.recagost_id := gost_c.recagost_id;
      recagostbo_rec_l.gost_id := gost_c.gost_id;
      recagostbo_rec_l.god_poslovna := gost_c.god_poslovna;
      recagostbo_rec_l.sifra_so := gost_c.sifra_so;
      recagostbo_rec_l.br_sj := gost_c.br_sj;
      recagostbo_rec_l.sifra_vsj := gost_c.sifra_vsj;
      recagostbo_rec_l.rbr_gosta := gost_c.rbr_gosta;
      recagostbo_rec_l.dat_dolaska := gost_c.dat_dolaska;
      recagostbo_rec_l.dat_odlaska := gost_c.dat_odlaska;
      recagostbo_rec_l.napomena := gost_c.napomena;
      recagostbo_rec_l.val_id:= tro_c_l.val_id;
      recagostbo_rec_l.usl_sifra := tro_c_l.usl_sifra;
      recagostbo_rec_l.cijena_usluge := tro_c_l.cijena_usluge;
      recagostbo_rec_l.rac_god_poslovna := tro_c_l.rac_god_poslovna;
      recagostbo_rec_l.oj_sifra := tro_c_l.oj_sifra;
      recagostbo_rec_l.vapldok_oznaka := tro_c_l.vapldok_oznaka;
      recagostbo_rec_l.rac_rbr := tro_c_l.rac_rbr;
      recagostbo_rec_l.metcvor_sifra := metcvor_sifra_podcentar_m; -- IRN 2291
      recagostbo_rec_l.so_naziv := gost_c.so_naziv;
      recagostbo_rec_l.ms_sifra := gost_c.ms_sifra;
      recagostbo_rec_l.age_sifra := gost_c.age_sifra;
      recagostbo_rec_l.age_naziv := gost_c.age_naziv;
      recagostbo_rec_l.ime := gost_c.ime;
      recagostbo_rec_l.prezime := gost_c.prezime;
      recagostbo_rec_l.unos_korisnik := zmp_zaj.korisnik (-1); -- IRN 1810
      recagostbo_rec_l.unos_dat := SYSDATE; -- IRN 1810
      pra_rec_iud2.insert_recagostbo_cvor (metcvor_sifra_x_l, recagostbo_rec_l);
      br_redaka_log_l := br_redaka_log_l + 1;
    ELSE
      pra_rec.puni_promjene (
        '0012',
        gost_c.god_poslovna || '; ' ||
          gost_c.rbr_gosta || '; ' ||
          gost_c.ime || '; ' ||
          gost_c.prezime || '; ' ||
          TO_CHAR (gost_c.dat_dolaska, 'DD.MM.RRRR') || '; ' ||
          TO_CHAR (gost_c.dat_odlaska, 'DD.MM.RRRR'),
        0);
    END IF;

    IF gost_id_p IS NULL THEN -- IRN 2276
      COMMIT;
    END IF;

  END LOOP;

EXCEPTION
  WHEN OTHERS THEN
    IF tro_c%ISOPEN THEN
      CLOSE tro_c;
    END IF;
    pra_rec.puni_promjene ('0023', SUBSTR ('(puni_recagostbo)' || ' ' || pra_zmp_zaj.poruka ('REC', 'REC1500', so_sifra_l, TO_CHAR (dat_poc_p, 'DD.MM.RRRR'), TO_CHAR (dat_zav_p, 'DD.MM.RRRR')) || ' ' || SQLERRM, 1, 2000), 0); -- IRN 1810
    RAISE;
END;
PROCEDURE AZURIRAJ_RECAGOST
 (SO_ID_P IN irec_nocenja.so_id%TYPE
 ,DAT_POC_P IN i_nocenja.datum%TYPE
 ,DAT_ZAV_P IN i_nocenja.datum%TYPE
 )
 IS
--
  metcvor_sifra_x_l VARCHAR2(21);

  /* -- IRN 2477, parametar 1139
  Automatsko auriranje arhive gostiju (slovo = podatak, oznaka = nain auriranja)
  A = ime i prezime,
  B = datum roenja,
  C = zemlja i mjesto roenja,
  D = oznaka VIP,
  E = o prebivalitu,
  F = o putnoj ispravi,
  G = vrsta plaanja BP
  X = ostali podaci
  nebitno = nita
  1 = neispun., 2 = svi. Npr B1G2X2.'
  */
  recparam1139_l szmp_parametri.vrijednost%TYPE := UPPER (pra_rec_zaj.vrijednost_parametra ('1139'));
  instr_recparam1139_A2_l NUMBER := INSTR(recparam1139_l, 'A2');
  instr_recparam1139_B1_l NUMBER := INSTR(recparam1139_l, 'B1');
  instr_recparam1139_B2_l NUMBER := INSTR(recparam1139_l, 'B2');
  instr_recparam1139_C1_l NUMBER := INSTR(recparam1139_l, 'C1');
  instr_recparam1139_C2_l NUMBER := INSTR(recparam1139_l, 'C2');
  instr_recparam1139_D1_l NUMBER := INSTR(recparam1139_l, 'D1');
  instr_recparam1139_D2_l NUMBER := INSTR(recparam1139_l, 'D2');
  instr_recparam1139_E1_l NUMBER := INSTR(recparam1139_l, 'E1');
  instr_recparam1139_E2_l NUMBER := INSTR(recparam1139_l, 'E2');
  instr_recparam1139_F1_l NUMBER := INSTR(recparam1139_l, 'F1');
  instr_recparam1139_F2_l NUMBER := INSTR(recparam1139_l, 'F2');
  instr_recparam1139_G1_l NUMBER := INSTR(recparam1139_l, 'G1');
  instr_recparam1139_G2_l NUMBER := INSTR(recparam1139_l, 'G2');
  instr_recparam1139_X1_l NUMBER := INSTR(recparam1139_l, 'X1');
  instr_recparam1139_X2_l NUMBER := INSTR(recparam1139_l, 'X2');

  loy_param_1017_l szmp_parametri.vrijednost%TYPE; -- IRN 3991

  recagost_rec_l trec_agostiju%ROWTYPE;
  ozn_update_l NUMBER := 0;
  dat_rodjenja_null_l DATE := TO_DATE ('01.01.1800', 'DD.MM.RRRR');
  datum_l DATE;
  br_redaka_l NUMBER;
  CURSOR loyvbod_c IS
    SELECT *
      FROM mloy_vbodova
     WHERE oznaka = 22 -- roendan u vrijeme boravka
     ORDER BY kolicina DESC, id;
  loyvbod_rec_l loyvbod_c%ROWTYPE;
  loyula_rec_l tloy_ulaz%ROWTYPE;
  so_sifra_l m_so.sifra%TYPE;
BEGIN

  metcvor_sifra_centar_m := LOWER (pra_zmp_zaj.vrijednost_parametra ('0019'));
  metcvor_sifra_podcentar_m := LOWER (pra_zmp_zaj.vrijednost_parametra ('0018'));
  metcvor_sifra_tekuci_m := LOWER (pra_zmp_zaj.tekuci_cvor);

  IF so_id_p IS NULL
    OR dat_poc_p IS NULL
    OR dat_zav_p IS NULL
    OR metcvor_sifra_centar_m IS NULL
    OR metcvor_sifra_podcentar_m IS NULL
    OR metcvor_sifra_tekuci_m IS NULL
  THEN
    RETURN;
  END IF;

  metcvor_sifra_x_l := pra_trec_agostiju.metcvor_sifra_x ('trec_agostiju'); -- IRN 2291
  SELECT sifra INTO so_sifra_l FROM m_so WHERE id = so_id_p;

  OPEN loyvbod_c;
  FETCH loyvbod_c INTO loyvbod_rec_l;
  CLOSE loyvbod_c;

  -- IRN 3991
  -- Oznaka vrste programa vjernosti: IT (Istra tech), LIS (LoyaltyInSky) ili nebitno.
  loy_param_1017_l := pra_zmp_zaj.zmppar_vrijednost ('LOY', '1017');

  FOR kgost_c IN (
    SELECT
      kgost.pos_id AS pos_id,
      kgost.reg_id AS reg_id,
      kgost.vplabp_id AS vplabp_id,
      kgost.zemr_id AS zemr_id,
      kgost.posr_id AS posr_id,
      gost.zem_id AS zemd_id,
      kgost.vpisp_id AS vpisp_id,
      kgost.gpri_id AS gpri_id,
      gost.recagost_id AS recagost_id,
      -- rbr
      -- oznaka
      gost.titula AS titula,
      gost.ime AS ime,
      gost.prezime AS prezime,
      kgost.naz_ulice AS naz_ulice,
      -- zanimanje
      kgost.naz_poduzeca AS naz_poduzeca,
      kgost.dat_rodjenja AS dat_rodjenja,
      kgost.naz_mjrodj AS naz_mjrodj,
      kgost.ozn_spola AS ozn_spola,
      kgost.br_telefona AS br_telefona,
      kgost.br_telefaksa AS br_telefaksa,
      kgost.email AS email,
      kgost.www AS www,
      kgost.br_pisprave AS br_pisprave,
      kgost.naz_mjpisp AS naz_mjpisp,
      -- srodstvo
      kgost.unos_korisnik AS unos_korisnik,
      kgost.unos_dat AS unos_dat,
      -- izmjena_korisnik,
      -- izmjena_dat,
      NVL (kgost.zem_id, gost.zem_id) AS zem_id,
      gost.jez_id AS jez_id,
      -- recggost_id
      -- sifra,
      kgost.naz_mjesta AS naz_mjesta,
      kgost.naz_regije AS naz_regije,
      NVL (kgost.ozn_kontakt, 0) AS ozn_kontakt,
      NVL (kgost.ozn_kontakt_telefon, 0) AS ozn_kontakt_telefon,
      NVL (kgost.ozn_kontakt_telefaks, 0) AS ozn_kontakt_telefaks,
      NVL (kgost.ozn_kontakt_email, 0) AS ozn_kontakt_email,
      -- ozn_abc
      -- stopa_popusta
      -- lozinka
      gost.ozn_vip AS ozn_vip,
      gost.id AS gost_id,
      gost.dat_dolaska AS dat_dolaska,
      gost.dat_odlaska AS dat_odlaska
    FROM
      t_kgostiju kgost,
      t_gosti gost,
      m_sj sj
    WHERE
      kgost.gost_id = gost.id
      AND gost.sj_id = sj.id
      AND sj.so_id = so_id_p
      AND (
          gost.dat_odlaska BETWEEN dat_poc_p AND dat_zav_p
          OR
          TRUNC (gost.sat_odjave) BETWEEN dat_poc_p AND dat_zav_p -- IRN 1143
          )
      AND gost.recagost_id IS NOT NULL
      AND gost.ozn_prisutnosti = 'O'
      AND gost.id NOT IN (SELECT id FROM trec_kplovila)
      AND kgost.oznaka = 'V'
      AND kgost.ozn_recagost = -1 -- IRN 2477
      AND kgost.ozn_brisano = 0 -- IRN 2477
      AND NVL (gost.ozn_brisano, 0) = 0 -- IRN 3105, IRN 3130
      AND gost.ozn_fiktivni = 0 -- IRN 3105
    )
  LOOP

    -- auriraj arhivu gostiju podacima iz knjige gostiju
    ozn_update_l := 0;
    SELECT * INTO recagost_rec_l FROM trec_agostiju WHERE id = kgost_c.recagost_id;

    IF recagost_rec_l.oznaka = 'V' AND recparam1139_l <> 'NEBITNO' THEN -- IRN 2477


      IF instr_recparam1139_A2_l > 0 AND
        recagost_rec_l.ime <> kgost_c.ime
      THEN
        recagost_rec_l.ime := kgost_c.ime;
        ozn_update_l := 1;
      END IF;

      IF instr_recparam1139_A2_l > 0 AND
        recagost_rec_l.prezime <> kgost_c.prezime
      THEN
        recagost_rec_l.prezime := kgost_c.prezime;
        ozn_update_l := 1;
      END IF;

      IF instr_recparam1139_B1_l > 0 AND  recagost_rec_l.dat_rodjenja IS NULL AND kgost_c.dat_rodjenja IS NOT NULL
        OR instr_recparam1139_B2_l > 0 AND NVL (recagost_rec_l.dat_rodjenja, dat_rodjenja_null_l) <> NVL (kgost_c.dat_rodjenja, dat_rodjenja_null_l)
      THEN
        recagost_rec_l.dat_rodjenja := kgost_c.dat_rodjenja;
        ozn_update_l := 1;
      END IF;

      IF instr_recparam1139_C1_l > 0
            AND (recagost_rec_l.zemr_id IS NULL AND kgost_c.zemr_id IS NOT NULL
                     OR recagost_rec_l.posr_id IS NULL AND kgost_c.posr_id IS NOT NULL
                     OR recagost_rec_l.naz_mjrodj IS NULL AND kgost_c.naz_mjrodj IS NOT NULL
                   )
         OR instr_recparam1139_C2_l > 0
            AND (NVL (recagost_rec_l.zemr_id, 0) <> NVL (kgost_c.zemr_id, 0)
                     OR NVL (recagost_rec_l.posr_id, 0) <> NVL (kgost_c.posr_id, 0)
                     OR NVL (recagost_rec_l.naz_mjrodj, '') <> NVL (kgost_c.naz_mjrodj, '')
                  )
      THEN
        -- zemr_id, posr_id i naz_mjrodj moraju biti u kompletu zbog pravila
        recagost_rec_l.zemr_id := kgost_c.zemr_id;
        recagost_rec_l.posr_id := kgost_c.posr_id;
        recagost_rec_l.naz_mjrodj := kgost_c.naz_mjrodj;
        ozn_update_l := 1;
      END IF;

      IF instr_recparam1139_D1_l > 0 AND recagost_rec_l.ozn_vip IS NULL AND kgost_c.ozn_vip IS NOT NULL
        OR instr_recparam1139_D2_l > 0 AND NVL (recagost_rec_l.ozn_vip, '') <> NVL (kgost_c.ozn_vip, '')
      THEN
        recagost_rec_l.ozn_vip := kgost_c.ozn_vip;
        ozn_update_l := 1;
      END IF;

      IF instr_recparam1139_E1_l > 0
           AND (recagost_rec_l.zem_id IS NULL AND kgost_c.zem_id IS NOT NULL
                   OR recagost_rec_l.reg_id IS NULL AND kgost_c.reg_id IS NOT NULL
                   OR recagost_rec_l.naz_regije IS NULL AND kgost_c.naz_regije IS NOT NULL
                   OR recagost_rec_l.pos_id IS NULL AND kgost_c.pos_id IS NOT NULL
                   OR recagost_rec_l.naz_mjesta IS NULL AND kgost_c.naz_mjesta IS NOT NULL
                 )
         OR instr_recparam1139_E2_l > 0
             AND (NVL (recagost_rec_l.zem_id, 0) <> NVL (kgost_c.zem_id, 0)
                   OR NVL (recagost_rec_l.reg_id, 0) <> NVL (kgost_c.reg_id, 0)
                   OR NVL (recagost_rec_l.naz_regije, 0) <> NVL (kgost_c.naz_regije, 0)
                   OR NVL (recagost_rec_l.pos_id, 0) <> NVL (kgost_c.pos_id, 0)
                   OR NVL (recagost_rec_l.naz_mjesta, '') <> NVL (kgost_c.naz_mjesta, '')
                  )
      THEN
        -- zem_id, reg_id, naz_regije, pos_id i naz_mjesta moraju biti u kompletu zbog pravila
        recagost_rec_l.zem_id := kgost_c.zem_id;
        recagost_rec_l.reg_id := kgost_c.reg_id;
        recagost_rec_l.naz_regije := kgost_c.naz_regije;
        recagost_rec_l.pos_id := kgost_c.pos_id;
        recagost_rec_l.naz_mjesta := kgost_c.naz_mjesta;
        ozn_update_l := 1;
      END IF;

      IF instr_recparam1139_E1_l > 0 AND recagost_rec_l.naz_ulice IS NULL AND kgost_c.naz_ulice IS NOT NULL
        OR instr_recparam1139_E2_l > 0 AND NVL (recagost_rec_l.naz_ulice, '') <> NVL (kgost_c.naz_ulice, '')
      THEN
        recagost_rec_l.naz_ulice := kgost_c.naz_ulice;
        ozn_update_l := 1;
      END IF;

      IF instr_recparam1139_F1_l > 0
          AND (recagost_rec_l.zemd_id IS NULL AND kgost_c.zemd_id IS NOT NULL
                OR recagost_rec_l.vpisp_id IS NULL AND kgost_c.vpisp_id IS NOT NULL)
        OR instr_recparam1139_F2_l > 0
          AND (NVL (recagost_rec_l.zemd_id, 0) <> NVL (kgost_c.zemd_id, 0)
                  OR NVL (recagost_rec_l.vpisp_id, 0) <> NVL (kgost_c.vpisp_id, 0)
                 )
      THEN
        -- zemd_id, vpisp_id moraju biti u kompletu zbog pravila
        recagost_rec_l.zemd_id := kgost_c.zemd_id;
        recagost_rec_l.vpisp_id := kgost_c.vpisp_id;
        ozn_update_l := 1;
      END IF;

      IF instr_recparam1139_F1_l > 0 AND recagost_rec_l.br_pisprave IS NULL AND kgost_c.br_pisprave IS NOT NULL
        OR instr_recparam1139_F2_l > 0 AND NVL (recagost_rec_l.br_pisprave, '') <> NVL (kgost_c.br_pisprave, '')
      THEN
        recagost_rec_l.br_pisprave := kgost_c.br_pisprave;
        ozn_update_l := 1;
      END IF;

      IF instr_recparam1139_F1_l > 0 AND recagost_rec_l.naz_mjpisp IS NULL AND kgost_c.naz_mjpisp IS NOT NULL
        OR instr_recparam1139_F2_l > 0 AND NVL (recagost_rec_l.naz_mjpisp, '') <> NVL (kgost_c.naz_mjpisp, '')
      THEN
        recagost_rec_l.naz_mjpisp := kgost_c.naz_mjpisp;
        ozn_update_l := 1;
      END IF;

      IF instr_recparam1139_G1_l > 0 AND recagost_rec_l.vplabp_id IS NULL AND kgost_c.vplabp_id IS NOT NULL
        OR instr_recparam1139_G2_l > 0 AND NVL (recagost_rec_l.vplabp_id, 0) <> NVL (kgost_c.vplabp_id, 0)
      THEN
        recagost_rec_l.vplabp_id := kgost_c.vplabp_id;
        ozn_update_l := 1;
      END IF;

      -- recagost_id,
      -- rbr,
      -- oznaka,

      IF instr_recparam1139_X1_l > 0 AND recagost_rec_l.titula IS NULL AND kgost_c.titula IS NOT NULL
        OR instr_recparam1139_X2_l > 0 AND NVL (recagost_rec_l.titula, '') <> NVL (kgost_c.titula, '')
      THEN
        recagost_rec_l.titula := kgost_c.titula;
        ozn_update_l := 1;
      END IF;

      -- zanimanje,

      IF instr_recparam1139_X1_l > 0 AND recagost_rec_l.naz_poduzeca IS NULL AND kgost_c.naz_poduzeca IS NOT NULL
        OR instr_recparam1139_X2_l > 0 AND NVL (recagost_rec_l.naz_poduzeca, '') <> NVL (kgost_c.naz_poduzeca, '')
      THEN
        recagost_rec_l.naz_poduzeca := kgost_c.naz_poduzeca;
        ozn_update_l := 1;
      END IF;

      IF instr_recparam1139_X1_l > 0 AND recagost_rec_l.ozn_spola IS NULL AND kgost_c.ozn_spola IS NOT NULL
        OR instr_recparam1139_X2_l > 0 AND NVL (recagost_rec_l.ozn_spola, '') <> NVL (kgost_c.ozn_spola, '')
      THEN
        recagost_rec_l.ozn_spola := kgost_c.ozn_spola;
        ozn_update_l := 1;
      END IF;

      IF instr_recparam1139_X1_l > 0 AND recagost_rec_l.br_telefona IS NULL AND kgost_c.br_telefona IS NOT NULL
        OR instr_recparam1139_X2_l > 0 AND NVL (recagost_rec_l.br_telefona, '') <> NVL (kgost_c.br_telefona, '')
      THEN
        recagost_rec_l.br_telefona := kgost_c.br_telefona;
        ozn_update_l := 1;
      END IF;

      IF instr_recparam1139_X1_l > 0 AND recagost_rec_l.br_telefaksa IS NULL AND kgost_c.br_telefaksa IS NOT NULL
        OR instr_recparam1139_X2_l > 0 AND NVL (recagost_rec_l.br_telefaksa, '') <> NVL (kgost_c.br_telefaksa, '')
      THEN
        recagost_rec_l.br_telefaksa := kgost_c.br_telefaksa;
        ozn_update_l := 1;
      END IF;

      IF instr_recparam1139_X1_l > 0 AND recagost_rec_l.email IS NULL AND kgost_c.email IS NOT NULL
        OR instr_recparam1139_X2_l > 0 AND NVL (recagost_rec_l.email, '') <> NVL (kgost_c.email, '') AND recagost_rec_l.lozinka IS NULL
        -- nije doputeno mijenjati email gdje postoji lozinka jer se taj email moda koristi kao "username" za IRS
      THEN
        -- IRN 3991
        br_redaka_l := 0;
        -- za vrstu programa vjernosti LIS i BECRM provjeri postoji li valjani zapis s jednakom e-adresom
        IF loy_param_1017_l IN ('LIS', 'BECRM') -- IRN 4108
          AND kgost_c.email IS NOT NULL
        THEN
          SELECT COUNT (1) INTO br_redaka_l
            FROM trec_agostiju
           WHERE oznaka = 'V'
             AND email IS NOT NULL
             AND LOWER (email) = LOWER (kgost_c.email);
        END IF;
        IF br_redaka_l = 0 THEN
          recagost_rec_l.email := kgost_c.email;
          ozn_update_l := 1;
        END IF;
        -- KRAJ IRN 3991
      END IF;

      IF instr_recparam1139_X1_l > 0 AND recagost_rec_l.www IS NULL AND kgost_c.www IS NOT NULL
        OR instr_recparam1139_X2_l > 0 AND NVL (recagost_rec_l.www, '') <> NVL (kgost_c.www, '')
      THEN
        recagost_rec_l.www := kgost_c.www;
        ozn_update_l := 1;
      END IF;

      -- srodstvo,
      -- unos_korisnik,
      -- unos_dat,
      -- izmjena_korisnik, -- G.J. mislim da bi to trebao biti onaj tko je upisao podatke u knjigu, a ne onaj tko je izraunao statistiku
      -- izmjena_dat

      IF instr_recparam1139_X1_l > 0 AND recagost_rec_l.jez_id IS NULL AND kgost_c.jez_id IS NOT NULL
        OR instr_recparam1139_X2_l > 0 AND NVL (recagost_rec_l.jez_id, 0) <> NVL (kgost_c.jez_id, 0)
      THEN
        recagost_rec_l.jez_id := kgost_c.jez_id;
        ozn_update_l := 1;
      END IF;

      -- recggost_id,
      -- sifra,

      IF instr_recparam1139_X2_l > 0 AND recagost_rec_l.ozn_kontakt <> kgost_c.ozn_kontakt
      THEN
        recagost_rec_l.ozn_kontakt := kgost_c.ozn_kontakt;
        ozn_update_l := 1;
      END IF;

      IF instr_recparam1139_X2_l > 0 AND recagost_rec_l.ozn_kontakt_telefon <> kgost_c.ozn_kontakt_telefon
      THEN
        recagost_rec_l.ozn_kontakt_telefon := kgost_c.ozn_kontakt_telefon;
        ozn_update_l := 1;
      END IF;

      IF instr_recparam1139_X2_l > 0 AND recagost_rec_l.ozn_kontakt_telefaks <> kgost_c.ozn_kontakt_telefaks
      THEN
        recagost_rec_l.ozn_kontakt_telefaks := kgost_c.ozn_kontakt_telefaks;
        ozn_update_l := 1;
      END IF;

      IF instr_recparam1139_X2_l > 0 AND recagost_rec_l.ozn_kontakt_email <> kgost_c.ozn_kontakt_email
      THEN
        recagost_rec_l.ozn_kontakt_email := kgost_c.ozn_kontakt_email;
        ozn_update_l := 1;
      END IF;

      IF ozn_update_l = 1 THEN
        -- IRN 2291; funkcija pra_trec_agostiju.recagost_rec aurira i pra_trec_agostiju.ozn_azuriraj_podcentar_g
        pra_rec_iud2.update_recagost_cvor (metcvor_sifra_x_l, pra_trec_agostiju.recagost_rec (recagost_rec_l)); -- IRN 2291
      END IF;

      COMMIT;

      -- IRN 2291; auriraj stupce na podcentru
      IF pra_trec_agostiju.ozn_azuriraj_podcentar_g = -1 THEN -- oznaku aurira funkcija pra_trec_agostiju.recagost_rec
        pra_trec_agostiju.update_recagost_podcentar (recagost_rec_l);
        COMMIT;
      END IF;

    END IF;
    -- KRAJ auriraj arhivu gostiju podacima iz knjige gostiju

    -- upii bodove programa vjernosti vrste 22 roendan u vrijeme boravka, IRN 1143
    IF recagost_rec_l.oznaka = 'V'
      AND recagost_rec_l.dat_rodjenja IS NOT NULL
      AND pra_rec_loy.loykar_id (recagost_rec_l.id, so_id_p, kgost_c.dat_dolaska) IS NOT NULL -- lan programa vjernosti -- IRN 2678, IRN 2861
      AND NVL (loyvbod_rec_l.kolicina, 0) > 0 -- postoji vrsta bodova programa vjernosti 22 roendan u vrijeme boravka
      AND pra_zmp_zaj.zmppar_vrijednost ('LOY', '1017') IN ('IT') -- IRN 3385; Oznaka vrste programa vjernosti
    THEN
      datum_l := ADD_MONTHS (recagost_rec_l.dat_rodjenja, (pra_rec_s3.dob (recagost_rec_l.dat_rodjenja, (kgost_c.dat_dolaska - 1)) + 1) * 12); -- IRN 2861
      IF datum_l BETWEEN kgost_c.dat_dolaska AND kgost_c.dat_odlaska THEN
        -- provjeri jesu li bodovi vrste 22 roendan u vrijeme boravka ve upisani za godinu
        SELECT COUNT (1) INTO br_redaka_l
          FROM tloy_ulaz loyula,
               mloy_vbodova loyvbod
         WHERE loyula.recagost_id = kgost_c.recagost_id
           AND TO_CHAR (loyula.datum, 'RRRR') = TO_CHAR (datum_l, 'RRRR') -- IRN 2861
           AND loyula.loyvbod_id = loyvbod.id
           AND loyvbod.oznaka = 22; -- roendan u vrijeme boravka
        IF br_redaka_l = 0 THEN
          -- bodovi jo nisu upisani (a mogu biti kod ponovnog izrauna statistike)
          loyula_rec_l.recagost_id := kgost_c.recagost_id;
          loyula_rec_l.loyvbod_id := loyvbod_rec_l.id;
          loyula_rec_l.datum := datum_l;
          loyula_rec_l.kolicina := loyvbod_rec_l.kolicina;
          IF loyvbod_rec_l.br_dana IS NOT NULL THEN
            loyula_rec_l.dat_valjan := kgost_c.dat_odlaska + NVL (loyvbod_rec_l.br_dana, 0);
          ELSE
            loyula_rec_l.dat_valjan := datum_l;
          END IF;
          IF loyvbod_rec_l.trajanje IS NOT NULL THEN
            loyula_rec_l.dat_ponisten := ADD_MONTHS (kgost_c.dat_odlaska, loyvbod_rec_l.trajanje);
          ELSE
            loyula_rec_l.dat_ponisten := NULL;
          END IF;
          loyula_rec_l.censo_id := so_id_p; -- IRN 1630
          loyula_rec_l.loykar_id := pra_rec_loy.loykar_id (recagost_rec_l.id, so_id_p, datum_l); -- IRN 2678

          pra_rec_loy.insert_loyula_cvor (
            metcvor_sifra_p => metcvor_sifra_x_l,
            loyula_rec_p => loyula_rec_l);
          COMMIT;

        END IF; -- IF br_redaka_l = 0
      END IF; -- IF datum_l BETWEEN kgost_c.dat_dolaska AND kgost_c.dat_odlaska
    END IF; -- IF recagost_rec_l.oznaka = 'V' ...
    -- KRAJ upii bodove programa vjernosti za roendan u vrijeme boravka

  END LOOP;

EXCEPTION
  WHEN OTHERS THEN
    pra_rec.puni_promjene ('0023', SUBSTR ('(azuriraj_recagost)' || ' ' || pra_zmp_zaj.poruka ('REC', 'REC1500', so_sifra_l, TO_CHAR (dat_poc_p, 'DD.MM.RRRR'), TO_CHAR (dat_zav_p, 'DD.MM.RRRR')) || ' ' || SQLERRM, 1, 2000), 0); -- IRN 1810
    RAISE;
END;
PROCEDURE AZURIRAJ_LOYULAIZL
 IS
/*
IRN 1556
naknadno auriranje bodova programa vjernosti
jer redovno auriranje nije uspjelo zbog toga to centar nije bio dostupan
*/
BEGIN
  FOR c IN (
    SELECT rac.id AS id,
           rac.oznaka AS oznaka,
           rac.datum AS datum,
           rac.god_poslovna AS god_poslovna,
           rac.oj_id AS oj_id,
           rac.vapldok_id AS vapldok_id,
           rac.rbr AS rbr
      FROM t_racuni rac,
           lloy_racuni loyrac
     WHERE loyrac.id = rac.id
       AND loyrac.oznaka = -1
     ORDER BY rac.id)
  LOOP
    IF c.oznaka = 'V' THEN
      pra_rec_loy.puni_loyula_11 (c.id);
      COMMIT;
    ELSIF c.oznaka = 'P' THEN
      pra_rec_loy.ponisti_bodove ( -- IRN 2678
        rac_id_p => c.id,
        rac_datum_p => c.datum,
        rac_god_poslovna_p => c.god_poslovna,
        oj_id_p => c.oj_id,
        vapldok_id_p => c.vapldok_id,
        rac_rbr_p => c.rbr);
      COMMIT;
    END IF;
  END LOOP;
EXCEPTION
  WHEN OTHERS THEN
    pra_rec.puni_promjene ('0023', SUBSTR ('azuriraj_loyulaizl' || ' ' || SQLERRM, 1, 2000), 0); -- IRN 1810
    RAISE;
END;
PROCEDURE STATISTIKA_JOB
 (BR_DANA_P IN NUMBER := 1
 )
 IS
--
  zad_l     irec_nocenja.datum%TYPE;
  nebitno_l irec_nocenja.datum%TYPE;
  dat_poc_l DATE;
  dat_zav_l DATE;
  found_l   BOOLEAN;
  email_prvi_l  szmp_parametri.vrijednost%TYPE;
  email_drugi_l szmp_parametri.vrijednost%TYPE;
  sender_l      szmp_parametri.vrijednost%TYPE;
  sender_h_l    s_poruke.tekst%TYPE;
  so_greska_l   VARCHAR2(100);
BEGIN
  IF br_dana_p <= 0 THEN
    RETURN;
  END IF;

  email_prvi_l := pra_rec_zaj.vrijednost_parametra ('1205');
  email_drugi_l := pra_rec_zaj.vrijednost_parametra ('1206');

  FOR so_c IN (
    SELECT id, sifra, naziv, dat_valjan, dat_ponisten
      FROM m_so
     WHERE metcvor_sifra = pra_zmp_zaj.tekuci_cvor
     ORDER BY sifra)
  LOOP
    so_greska_l := so_c.sifra || ' ' || so_c.naziv;
    dat_poc_l := GREATEST (so_c.dat_valjan, TRUNC (SYSDATE) - br_dana_p);
    dat_zav_l := LEAST (NVL (so_c.dat_ponisten, TRUNC (SYSDATE)), TRUNC (SYSDATE)) - 1;

    IF dat_poc_l <= dat_zav_l THEN -- ako SO nije poniten ranije od pred br_dana_p
      -- traim prvi datum bez izrauna
      found_l := TRUE;
      WHILE dat_poc_l <= dat_zav_l AND found_l LOOP
        BEGIN
          SELECT datum
            INTO nebitno_l
            FROM irec_nocenja
           WHERE so_id = so_c.id
             AND datum = dat_poc_l;
          dat_poc_l := dat_poc_l + 1;
        EXCEPTION
          WHEN NO_DATA_FOUND THEN
            found_l := FALSE;
        END;
      END LOOP;
      -- pokreem izraun od prvog datuma bez izrauna, ako je prvi datum bez izrauna dananji ponavljam za juer
      IF dat_poc_l = TRUNC (SYSDATE) THEN 
        dat_poc_l := dat_poc_l - 1;
      END IF;
      IF dat_poc_l <= dat_zav_l THEN              
        BEGIN
          bm_rec3010.izr_nocenja_dolazaka (so_c.id, dat_poc_l, dat_zav_l);
          EXCEPTION
            WHEN OTHERS THEN
              RAISE;
        END;
      END IF;
    END IF;
  END LOOP;
EXCEPTION
  WHEN OTHERS THEN
    IF UPPER (email_prvi_l) <> 'NEBITNO' OR UPPER (email_drugi_l) <> 'NEBITNO' THEN
      sender_l := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0905'); -- noreply
      sender_h_l := pra_zmp_zaj.poruka ('ZMP', 'III0192'); -- Baza
    END IF;
    IF UPPER (email_prvi_l) <> 'NEBITNO' THEN
      pra_pka2.salji_html_email (
        recipient_p   => email_prvi_l,
        recipient_h_p => NULL,
        sender_p      => sender_l,
        sender_h_p    => sender_h_l,
        bcc_p         => NULL,
        subject_p     => SYS_CONTEXT ('USERENV', 'CURRENT_SCHEMA') || ' - ' || pra_zmp_zaj.poruka ('REC', 'REC1501'), -- Izraun statistike - greka
        text_p        => pra_zmp_zaj.poruka ('REC', 'REC1500', so_greska_l, TO_CHAR (dat_poc_l, 'DD.MM.RRRR'), TO_CHAR (dat_zav_l, 'DD.MM.RRRR')) || ' ' || SQLERRM); -- SO #0 od #1 do #2
    END IF;
    IF UPPER (email_drugi_l) <> 'NEBITNO' THEN
      pra_pka2.salji_html_email (
        recipient_p   => email_drugi_l,
        recipient_h_p => NULL,
        sender_p      => sender_l,
        sender_h_p    => sender_h_l,
        bcc_p         => NULL,
        subject_p     => SYS_CONTEXT ('USERENV', 'CURRENT_SCHEMA') || ' - ' || pra_zmp_zaj.poruka ('REC', 'REC1501'),
        text_p        => pra_zmp_zaj.poruka ('REC', 'REC1500', so_greska_l, TO_CHAR (dat_poc_l, 'DD.MM.RRRR'), TO_CHAR (dat_zav_l, 'DD.MM.RRRR')) || ' ' || SQLERRM);
    END IF;
    RAISE;
END;
PROCEDURE STATISTIKA_JOB_MULTI
 (VLASNIKPODATKA_P IN NUMBER := NULL
 ,BR_DANA_P IN NUMBER := 1
 )
 IS
BEGIN
  pra_zmp_context.set_vlasnikpodatka (vlasnikpodatka_p);
  bm_rec3010.statistika_job (br_dana_p);
END;

END BM_REC3010;
/
SHOW ERROR

