-- D:\mish_CVS\misH_skripte\bm_gas3130.pkb
--
-- Generated for Oracle 10g on Thu Oct 30  10:45:27 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'BM_GAS3130'
CREATE OR REPLACE PACKAGE BODY BM_GAS3130 IS

PROCEDURE NEREPLICIRANI_DOKUMENTI
 (DAT_POC_P IN DATE
 ,DAT_ZAV_P IN DATE
 );
PROCEDURE KNJIZENJE_TRGO
 (POC_DATUM_P DATE
 ,ZAV_DATUM_P DATE
 );
PROCEDURE INSERT_SA_CVORA
 (METCVOR_SIFRA_P IN smet_cvorovi.sifra%TYPE
 ,POC_DATUM_P IN DATE
 ,ZAV_DATUM_P IN DATE
 );
PROCEDURE PROVJERI_DO_I_INV
 (POC_DATUM_P IN DATE
 ,ZAV_DATUM_P IN DATE
 );
PROCEDURE PROVJERI_OPISE_I_PRAVILA;


PROCEDURE START_CENTAR
 (POC_DATUM_P IN DATE
 ,ZAV_DATUM_P IN DATE
 )
 IS
   naredba_l    VARCHAR2(2000);
   pid_l        BINARY_INTEGER;
   br_jobova_l  BINARY_INTEGER := 0;
   alert_l      VARCHAR2 (30);
   poruka_l     VARCHAR2 (2000);
   status_l     NUMBER;
   poruka_za_gresku_l VARCHAR2 (2000);
   brojac_l                  NUMBER;
   broj_aplikacija_l         NUMBER;
   broj_obracuna_na_centru_l NUMBER;

   jobovima_isteklo_vrijeme EXCEPTION;
   puknuo_job               EXCEPTION;
   datum_do_l   DATE;
   datum_inv_l  DATE;
   datum_inv_dok_l  DATE;
  

   PROCEDURE remove_jobova IS
   BEGIN
      FOR job_c IN (
         SELECT job
           FROM user_jobs
          WHERE LOWER (what) LIKE '%bm_gas3130.start_objekt%')
      LOOP
         DBMS_JOB.REMOVE (job_c.job);
      END LOOP;
      COMMIT; -- nuan za REMOVE JOB-ova
   END;
BEGIN
   /* Samo centar moe pokrenuti knjienje */
   IF pra_zmp_zaj.centar = 0 THEN
      RETURN;
   END IF;
        
        
   /* Provjera da li su usklaeni opisi knjienja s obzirom na grupu naina potronje i knjigovodstvenu grupu */ 
   provjeri_opise_i_pravila;
  
        
   /* Da li postoje GAS aplikacije */
   SELECT COUNT (*)
     INTO broj_aplikacija_l
     FROM smet_instalacije
    WHERE metapl_sifra = 'GAS';

   IF broj_aplikacija_l = 0 THEN
      RETURN;
   END IF;

   /* Poetni datum mora biti manji ili jednak zavrnom datumu */
   IF poc_datum_p > zav_datum_p THEN
      RETURN;
   END IF;
 

   /* Brisanje podataka na centru */
   DELETE igas_knjizenje 
    WHERE oj_vlasnik IN (SELECT sifra FROM m_oj WHERE pra_zmp_s2.dopustena_oj (USER, id) =  -1);  
    
   DELETE igas_ira
    WHERE oj_sifra IN (SELECT sifra FROM m_oj WHERE pra_zmp_s2.dopustena_oj (USER, id) =  -1);
    

   /* Da li se GAS obrade rade (i) na centru */
   SELECT COUNT (*)
     INTO broj_obracuna_na_centru_l
     FROM l_obracun;

   IF broj_obracuna_na_centru_l > 0 THEN
      /* GAS obrade se rade (i) na centru */     
      
      /*provjera da li je napravljen dnevni obraun */
       SELECT MAX (datum) INTO datum_do_l
         FROM l_obracun 
        WHERE oznaka = '00' ;
        
       IF zav_datum_p > NVL(datum_do_l, zav_datum_p - 1)  THEN  
          /* Nije napravljen dnevni obraun ili obraun inventure: #0.*/
		  gas_zaj.vrati_poruku (-20229, NULL );
       ELSE  
            SELECT MAX (datum) INTO datum_inv_l
              FROM l_obracun
             WHERE oznaka = '40';
   
            SELECT MAX (zag.datum) INTO datum_inv_dok_l    
              FROM t_inventura zag,   
                   t_inventura_art sta 
             WHERE zag.id = sta.inv_id    
               AND zag.datum <= zav_datum_p;   

            IF datum_inv_dok_l > NVL(datum_inv_l, zav_datum_p - 1) THEN  
               /* Nije napravljen dnevni obraun ili obraun inventure: #0.*/ 
               gas_zaj.vrati_poruku (-20229, NULL );
            END IF;
       END IF;   
       
      start_objekt (poc_datum_p, zav_datum_p);
      insert_sa_cvora (NULL , poc_datum_p, zav_datum_p);

      IF UPPER (pra_zmp_zaj.zmppar_vrijednost ('GAS','1007')) = 'DA' THEN
         UPDATE mgas_razdoblja
            SET datum_poc = zav_datum_p
          WHERE oznaka = 'T'
            AND pra_zmp_s2.dopustena_oj (USER, oj_id) =  -1; 
      END IF;

      /* Ako, uz centar, ne postoje druge GAS aplikacije, skae na kraj */
      IF broj_aplikacija_l = 1 THEN
         GOTO komitiraj; -- skok na kraj
      END IF;
   END IF;

   /*
   Ako nije samostalni objekt/centralni gastro, onda se u nastavku
   koristi paralelno procesiranje po objektima - zbog brzine.
   */

   /* Provjera da li postoje nereplicirani dokumeti za razdoblje */ 
   bm_gas3130.nereplicirani_dokumenti (poc_datum_P, zav_datum_P);
   provjeri_do_i_inv (poc_datum_p, zav_datum_p);  
    
   /* REMOVE JOB-ova koji su moda zaostali ako program prethodno nije zavrio do kraja */
   remove_jobova;

   /*
   Pokretanje JOB-ova za (paralelno) auriranje tablice PGAS_KNJIZENJE po objektima.
   Parametar baze JOB_QUEUE_PROCESSES mora biti postavljen na odgovarajui broj > 1.
   */
   FOR metins IN (
      SELECT DISTINCT ins.metcvor_sifra
        FROM smet_instalacije ins,
             smet_cvorovi cvor,
             mzmp_ojr ojr
       WHERE ins.metapl_sifra = 'GAS'
         AND LOWER (ins.metcvor_sifra) <> LOWER (pra_zmp_zaj.tekuci_cvor)
         AND ins.metcvor_sifra = cvor.sifra
         AND ojr.metcvor_sifra_gas = ins.metcvor_sifra  
         AND pra_zmp_s2.dopustena_oj (USER, ojr.id) =  -1 
         AND cvor.ozn_u_mrezi  = -1
       ORDER BY ins.metcvor_sifra)
   LOOP
      IF replikacija.cvor_je_podcentar (metins.metcvor_sifra) = 0 THEN
         DBMS_ALERT.REGISTER (metins.metcvor_sifra);

         naredba_l :=
         'BEGIN ' ||
         '   bm_gas3130.start_objekt@' || metins.metcvor_sifra || '(''' || poc_datum_p || ''', ''' || zav_datum_p || ''');' ||
         '   DBMS_ALERT.SIGNAL (''' || metins.metcvor_sifra || ''', '' OK, '');' ||
         'EXCEPTION' ||
         '   WHEN OTHERS THEN' ||
         '      DECLARE' ||
         '         l_greska VARCHAR2 (20) := SUBSTR (SQLCODE, 1, 20);' ||
         '      BEGIN' ||
         '         ROLLBACK;' ||
         '         DBMS_ALERT.SIGNAL (''' || metins.metcvor_sifra || ''', l_greska);' ||
         '      END;' ||
         'END;';

         DBMS_JOB.SUBMIT (pid_l, naredba_l, SYSDATE, NULL, FALSE);
         br_jobova_l := br_jobova_l + 1;
      END IF;
   END LOOP;
   COMMIT; -- nuan za pokretanje JOB-ova

   /* eka na zavretak svih JOB-ova ili istek vremena (1800 sekundi) */
   FOR i IN 1..br_jobova_l LOOP
      DBMS_ALERT.WAITANY (alert_l, poruka_l, status_l, 3600);

      IF status_l = 1 THEN -- isteklo je vrijeme, a alert se nije okinuo
         RAISE jobovima_isteklo_vrijeme;
      END IF;

      IF poruka_l <> ' OK, ' THEN -- JOB je puknuo
         poruka_za_gresku_l := alert_l || ' - ' || poruka_l;
         RAISE puknuo_job;
      END IF;

      poruka_za_gresku_l := poruka_za_gresku_l || alert_l || poruka_l;
   END LOOP;

   DBMS_ALERT.REMOVEALL;

   /* INSERT sa svih objekata - serijski (ali radi brzo), kako bi bila jedna transakcija */
   FOR metins IN (
      SELECT DISTINCT ins.metcvor_sifra
        FROM smet_instalacije ins,
             smet_cvorovi cvor,
             mzmp_ojr ojr
       WHERE ins.metapl_sifra = 'GAS'
         AND LOWER (ins.metcvor_sifra) <> LOWER (pra_zmp_zaj.tekuci_cvor)
         AND ins.metcvor_sifra = cvor.sifra
         AND ojr.metcvor_sifra_gas = ins.metcvor_sifra
         AND pra_zmp_s2.dopustena_oj (USER, ojr.id) =  -1
         AND cvor.ozn_u_mrezi  = -1
       ORDER BY ins.metcvor_sifra)
   LOOP
      IF replikacija.cvor_je_podcentar (metins.metcvor_sifra) = 0 THEN
         insert_sa_cvora ('@' || metins.metcvor_sifra, poc_datum_p, zav_datum_p);
         /*
         Sljedee punjenje IGAS_IRA nije ukljueno u proceduru INSERT_SA_CVORA zato jer to nije potrebno
         kod samostalnog objekta/centralnog gastra (jer je tablica IGAS_IRA ve napunjena).
         */
         naredba_l :=
         'INSERT INTO igas_ira' ||
         '  SELECT * FROM igas_ira@' || metins.metcvor_sifra;
         EXECUTE IMMEDIATE naredba_l;
      END IF;
   END LOOP;

   IF pra_zmp_zaj.zmppar_vrijednost('GAS','1007') = 'da' THEN
      UPDATE mgas_razdoblja
         SET datum_poc = zav_datum_p
       WHERE pra_zmp_s2.dopustena_oj (USER, oj_id) =  -1; 
   END IF;
   <<komitiraj>> COMMIT; -- kraj transakcije
EXCEPTION
   WHEN jobovima_isteklo_vrijeme THEN
      DBMS_ALERT.REMOVEALL;
      /* REMOVE JOB-ova koji su pokrenuti ovim programom, a jo postoje */
      remove_jobova;
      /* Isteklo vrijeme job-ova BM_GAS3130. Prije greke uspjeli su objekti: #0 */
      gas_zaj.vrati_poruku (-20201, poruka_za_gresku_l);
   WHEN puknuo_job THEN
      DBMS_ALERT.REMOVEALL;
      /* REMOVE JOB-ova koji su pokrenuti ovim programom, a jo postoje */
      remove_jobova;
      /* Puknuo je job BM_GAS3130 na objektu #0 */
      gas_zaj.vrati_poruku (-20202, poruka_za_gresku_l);
END;
PROCEDURE NEREPLICIRANI_DOKUMENTI
 (DAT_POC_P IN DATE
 ,DAT_ZAV_P IN DATE
 )
 IS
brojac_L  NUMBER;
naredba_l VARCHAR2 (32000);
BEGIN
  SELECT COUNT(*) INTO brojac_L
    FROM possus_l_dokumenti  possdok,
         t_ulazdok ulaz,
         t_prijelaz pri
   WHERE possdok.id = ulaz.id (+)
     AND possdok.id = pri.id (+)
     AND (pri.datum BETWEEN dat_poc_P AND dat_zav_P
     OR  ulaz.datum BETWEEN dat_poc_P AND dat_zav_P)
     AND pra_zmp_s2.dopustena_oj (USER, NVL(ulaz.mt_id, pri.mt_id_daje)) =  -1; 

  IF brojac_L  > 0 THEN 
     /* Postoje neobraeni dokumenti za razdoblje #0 do #1. Potrebno je izvriti naknadno slanje dokumenata */
     gas_zaj.vrati_poruku (-20105, TO_CHAR(dat_poc_P,'DD.MM.YYYY'), TO_CHAR(dat_zav_P,'DD.MM.YYYY'));
  END IF;            
  
END;
PROCEDURE START_OBJEKT
 (POC_DATUM_P IN DATE
 ,ZAV_DATUM_P IN DATE
 )
 IS
 oj_id_l m_oj.id%TYPE;  
 obrada_gas_L nst_gas_obrada.obrada_gas%TYPE;
 brojac_l NUMBER;
datum_pdo_L DATE;
BEGIN 
    
 /* ako je bila izmjena dokumenata na SYSDATE (vage, minibar...) mogue je da nije napravljen DO */     
 datum_pdo_L := gas_zaj.mijenjani_dokumenti(zav_datum_p);
 IF datum_pdo_L IS NOT NULL THEN
      gas_zaj.vrati_poruku (-20431, TO_CHAR(datum_pdo_L,'DD.MM.YYYY'));
 END IF;      
 
 EXECUTE IMMEDIATE ('ALTER SESSION SET OPTIMIZER_MODE = ALL_ROWS');
 SELECT oj_id INTO oj_id_l FROM sgas_vlasnik;

 DELETE pgas_knjizenje; 
  
 -- kod samostalnog objekta/centralnog gastra nije nuno, jer je ve brisano na poetku, ali ne smeta 
 DELETE igas_ira
  WHERE oj_sifra IN (SELECT sifra FROM m_oj WHERE pra_zmp_s2.dopustena_oj (USER, id) =  -1);   

 FOR tem IN (
    SELECT DISTINCT(id) oj_id
      FROM mzmp_ojr
     WHERE metcvor_sifra_gas IS NOT NULL
       AND pra_zmp.oj_pripada_oj (id, oj_id_l) = -1
       AND dat_valjan <= poc_datum_p
       AND (dat_ponisten IS NULL OR dat_ponisten > zav_datum_p)
       AND pra_zmp_s2.dopustena_oj (USER, id) = -1
    --    
    UNION ALL   
    --  
    --  GAS 1018 ifre organizacijskih jedinica (knjiga rauna) za knjienje prihoda za mjesta troka za koja se prodaja odvija na
    --  vie ema a da mjesta troka ne pripadaju vlasniku (Laguna Novigrad)  
    --  moe funkcionirati samo prihode koji su vidljivi na centru
    --
    SELECT id oj_id FROM m_oj WHERE sifra IN
           (SELECT str FROM(
              WITH DATA AS
                   ( SELECT pra_zmp_zaj.zmppar_vrijednost ('GAS', '1018') str FROM dual)
                     SELECT trim(regexp_substr(str, '[^,]+', 1, LEVEL)) str
                       FROM DATA
                    CONNECT BY instr(str, ',', 1, LEVEL - 1) > 0))) 
 LOOP
 
   INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, iznos, gknji_id)
   --
   -- 0020 PRIHOD NETTO TRGOVAKE ROBE
   --
   SELECT mt.id, opisi.id,
          SUM (obr_realizacija - obr_pdv - obr_ppot - obr_pnaknade) prihod_netto,
		  NULL
     FROM v_igas_rn_promet promet,
          m_mt mt,
          sgas_opisi_knjizenja opisi
    WHERE promet.datum BETWEEN poc_datum_p AND zav_datum_p
      AND promet.mt_id = mt.id
      AND mt.vrsta IN ( 'U')
      AND mt.id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND opisi.sifra = '0020'
    GROUP BY mt.id, opisi.id
   --
    UNION ALL
   --
   -- 0030 DOBAVLJAI - OBVEZA za MT bez vrste 'U': za unos u sirovinama i namirnicama
   --  'mali' korisnici vode ambalau samo u namirnicama 
   --
         SELECT mt.id, opisi.id,
         SUM(ROUND(kolicina * ROUND(((nab_cijena * (1 - rabat / 100))),2),2)),
         DECODE(opisi.ozn_gknji, 'D', DECODE(sir_id,NULL, nam.gknji_id, bm_gas3130.sir_gknji_id (sir.id)))gknji_id
     FROM t_ulazdok ulaz,
          t_ulazdok_art ulazart,
          m_mt mt,
          m_sirovine sir,
          m_namirnice nam,
          sgas_opisi_knjizenja opisi
    WHERE  ulaz.datum BETWEEN  poc_datum_p AND zav_datum_p
      AND ulaz.mt_id = mt.id
      AND mt.vrsta NOT IN ('U')
      AND ulaz.id = ulazart.ulaz_id
      AND ulazart.sir_id = sir.id (+)
      AND ulazart.nam_id = nam.id (+)
      AND mt.id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND ulaz.id = ulazart.ulaz_id
      AND ulaz.dob_id IS NOT NULL
      AND opisi.sifra = '0030'
    GROUP BY
          mt.id, opisi.id,
          DECODE(opisi.ozn_gknji, 'D', DECODE(sir_id,NULL, nam.gknji_id, bm_gas3130.sir_gknji_id (sir.id)))	
   -- 
    UNION ALL
   --
   --
   -- 0033 DOBAVLJAI - VALAMAR, pripremnica VINE (ne ide preko POSSUS-a, u namirnicama)     
   -- ide za objekte ircentar-a i hfcentar-a
   -- id komitenta je zajedniki sa sve podcentre 
   -- 
   SELECT mt.id, opisi.id,
          SUM(ROUND(kolicina * ROUND(((nab_cijena * (1 - rabat / 100))),2),2)),
          DECODE (opisi.ozn_gknji, 'D', bm_gas3130.sir_gknji_id (nam.id), NULL) gknji_id
     FROM t_ulazdok ulaz,
          t_ulazdok_art ulazart,
          m_mt mt,
          m_namirnice nam,
          sgas_opisi_knjizenja opisi
    WHERE ulaz.datum BETWEEN  poc_datum_p AND zav_datum_p
      AND ulaz.mt_id = mt.id
      AND mt.vrsta NOT IN ('U')
      AND ulaz.id = ulazart.ulaz_id
      AND ulazart.nam_id = nam.id
      AND mt.id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND ulaz.id = ulazart.ulaz_id
      AND ulaz.dob_id IS NOT NULL
      AND opisi.sifra = '0033' 
      AND ulaz.dob_id = 332292  -- komitent Valamar     
    GROUP BY
          mt.id, opisi.id,
          DECODE (opisi.ozn_gknji, 'D', bm_gas3130.sir_gknji_id (nam.id), NULL)	       	  
   --
   -- 0030 DOBAVLJAI - OBVEZA za MT vrste 'U', bez aktivirane trgovine
   --
     UNION ALL
   --
   SELECT mt.id, opisi.id,
          SUM(ROUND(kolicina * ROUND(((nab_cijena * (1 - rabat / 100))),2),2)),
		  NULL
     FROM t_ulazdok ulaz,
          t_ulazdok_art ulazart,
          m_mt mt,
		  m_gknjigo gknji,
          nst_gas_obrada ob,
          sgas_opisi_knjizenja opisi
    WHERE ulaz.datum BETWEEN  poc_datum_p AND zav_datum_p
      AND ulaz.mt_id = mt.id
      AND mt.vrsta IN ('U') AND ob.obrada_gas = 'N'
      AND mt.id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND ulaz.id = ulazart.ulaz_id
      AND ulaz.dob_id IS NOT NULL
      AND opisi.sifra = '0030'
    GROUP BY  mt.id, opisi.id
   --
   -- 0031 DOBAVLJAI - OBVEZA za MT vrste 'U',  sa aktiviranom trgovinom
   -- 
    UNION ALL
   --
   SELECT mt.id, opisi.id,
          SUM(ROUND(kolicina * ROUND(((nab_cijena * (1 - rabat / 100))),2),2)),
		  NULL
     FROM t_ulazdok ulaz,
          t_ulazdok_art ulazart,
          m_mt mt,
          nst_gas_obrada ob,
          sgas_opisi_knjizenja opisi
    WHERE ulaz.datum BETWEEN  poc_datum_p AND zav_datum_p
      AND ulaz.mt_id = mt.id
      AND mt.vrsta IN ('U') AND ob.obrada_gas = 'D'
      AND mt.id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND ulaz.id = ulazart.ulaz_id
      AND ulaz.dob_id IS NOT NULL
      AND opisi.sifra = '0031'
    GROUP BY  mt.id, opisi.id
   --  
    UNION ALL
   --
   -- 0032 DOBAVLJAI - OBVEZA KOREKCIJA za MT vrste 'U',  sa aktiviranom trgovinom
   --
   SELECT mt_id, opisi.id,
          SUM(izn_korekcije),
		  NULL
     FROM t_ulazdok ulaz,
          sgas_opisi_knjizenja opisi
    WHERE ulaz.datum BETWEEN  poc_datum_p AND zav_datum_p
      AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND ulaz.dob_id IS NOT NULL
      AND opisi.sifra = '0032'
    GROUP BY  mt_id, opisi.id
   --
    UNION ALL
   --
   -- 0040  PRIHOD INTERNI  -  za mt davatelja po planskim/prodajnim  cijenama ili po % mare iz mt primatelja
   --                          (planske cijene nadjaavaju maru) 
   --
   SELECT mtdaje.id, opisi.id,
          SUM(DECODE(planska_cijena, 0,
              ROUND(kolicina * nab_cijena * (1 + mtprima.marza/100),2) - ROUND(kolicina * nab_cijena,2),
              ROUND((kolicina * planska_cijena ),2)- ROUND(kolicina * nab_cijena,2))) iznos,
		  NULL
     FROM t_prijelaz pri,
          t_prijelaz_art priart,
          m_mt mtdaje,
          m_mt mtprima,
          sgas_opisi_knjizenja opisi
    WHERE pri.datum  BETWEEN poc_datum_p AND zav_datum_p
      AND mtprima.vrsta NOT IN ('M', 'T', 'O')
      AND mtdaje.vrsta NOT IN ('M', 'T', 'O')
      AND pri.mt_id_daje  IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND pri.mt_id_daje = mtdaje.id
      AND pri.mt_id_prima = mtprima.id
      AND (priart.planska_cijena > 0 OR mtprima.marza <> 0)
      AND pri.id = priart.pri_id   
      AND mtdaje.naz_dodatni = 'PRIPREMNICA'
      AND opisi.sifra = '0040'
    GROUP BY mtdaje.id, opisi.id
   -- 
      UNION ALL
   --
   -- 0045  TROAK INTERNI  -  za mt primatelja po planskim/prodajnim  cijenama ili po % mare iz mt primatelja
   --                          (planske cijene nadjaavaju maru) 
   --
   SELECT mtprima.id, opisi.id,
          SUM(DECODE(planska_cijena, 0,
              ROUND(kolicina * nab_cijena * (1 + mtprima.marza/100),2)- ROUND(kolicina * nab_cijena,2), 
              ROUND((kolicina * planska_cijena ),2)- ROUND(kolicina * nab_cijena,2))) iznos,
		  NULL
     FROM t_prijelaz pri,
          t_prijelaz_art priart,
          m_mt mtdaje,
          m_mt mtprima,
          sgas_opisi_knjizenja opisi
    WHERE pri.datum  BETWEEN poc_datum_p AND zav_datum_p
      AND mtprima.vrsta NOT IN ('M', 'T', 'O')
      AND mtdaje.vrsta NOT IN ('M', 'T', 'O')
      AND pri.mt_id_prima  IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND pri.mt_id_daje = mtdaje.id
      AND pri.mt_id_prima = mtprima.id
      AND (priart.planska_cijena > 0 OR mtprima.marza <> 0)
      AND pri.id = priart.pri_id 
      AND mtdaje.naz_dodatni = 'PRIPREMNICA'
      AND opisi.sifra = '0045'
    GROUP BY mtprima.id, opisi.id;  
   --
   --
   --  0050 PRIHOD BRUTTO TRGOVAKE ROBE
   --  0060 UKALKULIRANI PDV TRGOVAKE ROBE 
   --      
   INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, iznos, gknji_id, dokapl_id)
   SELECT mt.id, opisi.id,
          SUM (DECODE(opisi.sifra, '0050', obr_realizacija, '0060', obr_pdv)) prihod_brutto,
	      NULL, 6  -- dokument promet kase
     FROM v_igas_rn_promet promet,
          m_mt mt,
          sgas_opisi_knjizenja opisi
    WHERE promet.datum BETWEEN poc_datum_p AND zav_datum_p
      AND promet.mt_id = mt.id
      AND mt.vrsta IN ( 'U')
      AND mt.id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND opisi.sifra IN ('0050', '0060')
    GROUP BY mt.id, opisi.id;
   
   --
   --
   -- 0070 MARA TRGOVAKE ROBE
   -- koristi se ako nije aktivan modul GAT
   -- 
   INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, iznos, gknji_id) 
   SELECT mt.id, opisi.id,
          SUM (rnkase.iznos - rnkase.kolicina * rnkase.pros_nab_cijena - rnkase.iznos_pdv - rnkase.iznos_ppot - rnkase.iznos_pnaknade) marza,
          NULL
     FROM t_rnkase rn,
          t_rnkase_pro rnkase,
          m_mt mt,
          sgas_opisi_knjizenja opisi
    WHERE rn.datum BETWEEN poc_datum_p AND zav_datum_p
      AND rn.id = rnkase.rn_id AND rnkase.mt_id = mt.id
      AND mt.id  IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))  
      AND pra_nst_zaj.vrati_akt_trg(mt.id, poc_datum_p) = 0
      AND mt.vrsta IN ( 'U')
      AND opisi.sifra = '0070'
    GROUP BY mt.id, opisi.id
   --
   UNION ALL
   --
   --  0080 NAPLATA TOPLI OBROK --0033 -- ifra vrste plaanja za topli obrok
   --
   SELECT tem.oj_id, opisi.id,
          SUM (iznos) po_topli_obrok,
		  NULL
     FROM v_igas_rn_naplata promet,
          s_vplacanja vpla,
          sgas_opisi_knjizenja opisi
    WHERE promet.datum BETWEEN poc_datum_p AND zav_datum_p
      AND promet.vpla_id = vpla.id
      AND INSTR (pra_zmp_zaj.vrijednost_parametra ('0033'), vpla.sifra ) > 0
      AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND opisi.sifra = '0080'
    GROUP BY tem.oj_id, opisi.id
   --
   UNION ALL
   --
   -- 0090 POTRAIVANJE TOPLI OBROK  --0033 -- ifra vrste plaanja za topli obrok
   --
   SELECT tem.oj_id, opisi.id,
          SUM (iznos) po_topli_obrok,
		  NULL
     FROM v_igas_rn_naplata promet,
          s_vplacanja vpla,
          sgas_opisi_knjizenja opisi
    WHERE promet.datum BETWEEN poc_datum_p AND zav_datum_p
      AND promet.vpla_id = vpla.id
      AND ((pra_zmp_zaj.tekuci_cvor = 'hnbgastro' AND vpla.sifra = '41') OR
           (pra_zmp_zaj.tekuci_cvor <> 'hnbgastro' AND INSTR (pra_zmp_zaj.vrijednost_parametra ('0033'), vpla.sifra ) > 0))
      AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND opisi.sifra = '0090'
    GROUP BY tem.oj_id, opisi.id;
   --
   --
   -- 0100 OJ PRIHOD BRUTTO 
   -- 0110 OJ PDV   -- sumarni pdv bez obzira ne stope PDV-a (u pravila teba biti upisano 0110 ili 0111, 0112, 0113), u v_igas_rn_promet su ukljuene i otpremnice
   -- 0120 OJ PPOT      
    
   INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, iznos, gknji_id)
      
     SELECT tem.oj_id, opisi.id,
            SUM (DECODE(opisi.sifra, '0100', obr_realizacija, '0120', obr_ppot)),
            NULL
       FROM v_igas_rn_promet promet,
            sgas_opisi_knjizenja opisi
      WHERE datum BETWEEN poc_datum_p AND zav_datum_p
        AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
        AND opisi.sifra IN ('0100',  '0120')
      GROUP BY tem.oj_id, opisi.id
      ---
     UNION ALL 
      ---                  
      --- STORNIRA se 0100 za proizvode tipa 3 (Prepaid uplata) i 4 (Prepiad iskoritenje) jer u prehodnom knjienju nema naina da se izdvoji iz ukupnog knjienja
      --- 
     SELECT tem.oj_id, opisi.id,
            SUM(DECODE(pra_zmp_zaj.zmppar_vrijednost ('GAS','1019'),
                      'da', rnpro.iznos  * DECODE (nac.ozn_obracuna_poreza, 'P', 0, 1),
                      'ne', 0)) * -1,                                                                              
            NULL
       FROM t_rnkase_pro rnpro,
            t_rnkase     rn,
            m_nacpot nac,
            m_mt mt,
            mgmp_kase kase,
            m_proizvodi pro,
            sgas_opisi_knjizenja opisi
      WHERE rn.id = rnpro.rn_id
        AND rn.nac_id = nac.id
        AND rnpro.mt_id = mt.id
        AND rn.kase_id =  kase.id     
        AND rnpro.pro_id = pro.id (+) 
        AND pro.ozn_proizvoda IN ('3','4')
        AND datum BETWEEN poc_datum_p AND zav_datum_p
        AND mt.id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
        AND opisi.sifra IN ('0100') 
      GROUP BY  tem.oj_id, opisi.id   
      --
      UNION ALL  
      --
      --  ovisno o  parametaru GAS 1019 'Kontira li se iznos PDV-a prepaid kartica na poseban konto: da ili ne'.                           
      --  izuzima se PVD na prepaid uplata i koritenju 
      --  u tim sluajevima se knjii na poseban konto                                                
      --
      SELECT tem.oj_id, opisi.id,
             SUM(DECODE(pra_zmp_zaj.zmppar_vrijednost ('GAS','1019'),
                       'ne', rnpro.iznos_pdv * DECODE (nac.ozn_obracuna_poreza, 'P', 0, 1),
                       'da', rnpro.iznos_pdv * DECODE (nac.ozn_obracuna_poreza, 'P', 0, 1) * DECODE(rnpro.pro_id, NULL, 1,(DECODE(pro.ozn_proizvoda,'1', 1 ,'2', 1, '3',0,'4',0,'5',1))))),                                                                             
             NULL
       FROM t_rnkase_pro rnpro,
            t_rnkase     rn,
            m_nacpot nac,
            m_mt mt,
            mgmp_kase kase,
            m_proizvodi pro,
            sgas_opisi_knjizenja opisi
      WHERE rn.id = rnpro.rn_id
        AND rn.nac_id = nac.id
        AND rnpro.mt_id = mt.id
        AND rn.kase_id =  kase.id     
        AND rnpro.pro_id = pro.id (+)
        AND datum BETWEEN poc_datum_p AND zav_datum_p
        AND mt.id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
        AND opisi.sifra IN ('0110') 
      GROUP BY  tem.oj_id, opisi.id;     
  
   --
   --
   INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, iznos, gknji_id)
   --
   -- 0111, 0112, 0113 OJ PDV -ako se iznos PDV-a eli knjiiti po stopi PDV, stopa je  naziv
   -- (u pravila teba biti upisano 0110 ili 0111, 0112, 0113)  
   -- izuzima se prepaid uplata i koritenje
   -- parametar GAS 1019 'Kontira li se iznos PDV-a prepaid kartica na poseban konto: da ili ne'.
   -- 
   SELECT tem.oj_id,
          opisi.id,
          SUM(DECODE(pra_zmp_zaj.zmppar_vrijednost ('GAS','1019'),
                    'ne', rnpro.iznos_pdv,
                    'da', rnpro.iznos_pdv *  DECODE(rnpro.pro_id, NULL,  1,DECODE(pro.ozn_proizvoda,'1', 1 ,'2', 1, '3',0,'4',0,'5',1))))  oj_obr_pdv,
          NULL
     FROM t_rnkase rn,
          t_rnkase_pro rnpro, 
          m_nacpot nac, 
          m_proizvodi pro,
          m_mt mt,
          sgas_opisi_knjizenja opisi,
          s_vplacanja vpla
    WHERE rn.datum  BETWEEN poc_datum_p AND zav_datum_p
      AND rn.id = rnpro.rn_id  
      AND rn.nac_id = nac.id
      AND rnpro.mt_id = mt.id 
      AND rn.vpla_id = vpla.id
      AND nac.ozn_obracuna_poreza = 'D' 
      AND rnpro.pro_id = pro.id(+)  
      AND ((pra_zmp_zaj.zmppar_vrijednost ('GAS','1064') = 'da' AND vpla.ozn_irn IS NULL) OR pra_zmp_zaj.zmppar_vrijednost ('GAS','1064') = 'ne')
      AND INSTR(opisi.naziv,DECODE(LENGTH(rnpro.pdv),1, ' '||rnpro.pdv, rnpro.pdv)) > 0
      AND rnpro.pdv <> 0 
      AND mt.id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND opisi.sifra  in ( '0111', '0112', '0113')
    GROUP BY tem.oj_id, opisi.id, rnpro.pdv   
   --      
    UNION 
   --    
   -- otpremnice, ovise o u GAS parametru  1064,
   -- ako je upisana vrsta plaanja u GAS parametar 1008 
   --
   SELECT tem.oj_id,
          opisi.id,
          SUM(ROUND(izldokart.kolicina * DECODE(izldokart.rabat,0, prod_cijena, izldokart.prod_cijena * (1 - izldokart.rabat/100))
                   *  (izldokart.pdv/100),2)),
          NULL
     FROM tgas_izlazdok izldok,
          tgas_izlazdok_art izldokart,
          s_vplacanja vpla,
          sgas_opisi_knjizenja opisi
    WHERE izldok.datum  BETWEEN poc_datum_p AND zav_datum_p
      AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND opisi.sifra  in ( '0111', '0112', '0113')
      AND izldok.id = izldokart.gasizldok_id  
      AND ((pra_zmp_zaj.zmppar_vrijednost ('GAS','1064') = 'da' AND vpla.ozn_irn IS NULL) OR pra_zmp_zaj.zmppar_vrijednost ('GAS','1064') = 'ne')
      AND pra_zmp_zaj.zmppar_vrijednost ('GAS', '1008') = vpla.sifra
      AND INSTR(opisi.naziv,DECODE(LENGTH(izldokart.pdv),1, ' '||izldokart.pdv,izldokart.pdv)) > 0
      AND izldokart.pdv <> 0
    GROUP BY tem.oj_id, opisi.id, izldokart.pdv    
   -- 
   UNION ALL
    --
   --  KNJIENJE PDV PO PREDUJMOVIMA - UPLATA i ISKORITENJE  PREPAIDA  (SAMO PROIZVODI OZNAKE 3 i 4)
   --  NETO IZNOS UPLATE SE KNJII PREKO KNJIGOVODSTVENE GRUPE,
   --  HNB KNJII PREKO BLAGAJNE i RAZDVAJA NA VLASTITE I USTUPLJENE DJELATNIKE
   --

   SELECT tem.oj_id,
          CASE WHEN pra_zmp_zaj.zmppar_vrijednost ('GAS','1073') = 'nebitno' THEN 67
               ELSE CASE WHEN SUBSTR(pkaadr.rbr,1,3) = pra_zmp_zaj.zmppar_vrijednost ('GAS','1073') THEN 68 ELSE 67 END
          END AS id,
          SUM(rnpro.iznos_pdv) oj_obr_pdv,
          NULL
     FROM t_rnkase rn,
          t_rnkase_pro rnpro,
          tpka_kar_rnk pkakarrnk,
          tpka_kartice pkakar,
          mpka_adrese pkaadr,
          m_mt mt,
          m_proizvodi pro
    WHERE rn.datum  BETWEEN  poc_datum_p AND zav_datum_p
      AND rn.kase_id = pkakarrnk.gmpkas_id
      AND rn.rbr =  pkakarrnk.rbr
      AND rn.godina = pkakarrnk.god_poslovna
      AND pkakarrnk.pkakar_id = pkakar.id
      AND pkakar.pkaadr_id = pkaadr.id
      AND rn.id = rnpro.rn_id
      AND rnpro.mt_id = mt.id
      AND rnpro.pro_id = pro.id
      AND pro.ozn_proizvoda IN (3,4)
      AND pra_zmp_zaj.zmppar_vrijednost ('GAS','1019')= 'da'
      AND mt.id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      --    AND opisi.sifra  IN ( '0115','0116')
    GROUP BY tem.oj_id,  CASE WHEN pra_zmp_zaj.zmppar_vrijednost ('GAS','1073') = 'nebitno' THEN 67
               ELSE CASE WHEN SUBSTR(pkaadr.rbr,1,3) = pra_zmp_zaj.zmppar_vrijednost ('GAS','1073') THEN 68 ELSE 67 END
          END, rnpro.pdv
   --   
   UNION ALL
   --
   --  STORNO OPISA '0100', '0110', '0120' do verzije 21.1 je bilo vezano samo specifino za licencu Uljanika
   --  od verzije 22.1 se koriste za prorainsko knjigovodstvo i koristi se rec parametar
   --  REC 1014 1104 (Knjiiti urnal: R = po realizaciji ili Z = zaraunato) ==> zaraunato znai da izdani rauni   
   --
   SELECT tem.oj_id, opisi.id, 
          SUM(DECODE(opisi.sifra, '0100', rnpro.iznos * -1 ,
                                  '0110', rnpro.iznos_pdv * -1, 
                                  '0120', rnpro.iznos_ppot * -1)),
          NULL
     FROM t_rnkase rn,
          t_rnkase_pro rnpro,
          s_vplacanja vpla,
          sgas_opisi_knjizenja opisi,
          sgas_vlasnik vlasnik
    WHERE rn.id = rnpro.rn_id
      AND rn.vpla_id = vpla.id  
      AND vpla.ozn_irn IS NOT NULL
      AND (pra_zmp_zaj.zmppar_vrijednost ('GAS','1064') = 'da' AND vpla.ozn_irn IS NOT NULL)  
    --  AND rn.vpla_id IN (SELECT id FROM s_vplacanja WHERE sifra IN ('53','57')) -- rauni za vlastitu potronju  
      AND rn.datum BETWEEN poc_datum_p AND zav_datum_p
      AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND opisi.sifra IN ('0100', '0110', '0120')  
    --  AND vlasnik.br_licence = 'GAS20197'
    --  AND pra_zmp_zaj.tekuci_cvor like 'mis%'  
    GROUP BY  tem.oj_id, opisi.id               -- samo za Uljanik
   --
   UNION ALL
   --
   -- 0135 TROAK PO INVENTURI
   -- Za Plavu Lagunu, na kraju mjeseca rade inventure, to se poklapa sa obraunskim razdobljima  
   --
  SELECT inv.mt_id, opisi.id,
         SUM(izn_zav_stanje) izn_zav_stanje,
         DECODE(opisi.ozn_gknji, 'D', nam.gknji_id, NULL)
    FROM i_inv_ui inv,
         m_namirnice nam,
         m_mt mt,
         sgas_opisi_knjizenja opisi
   WHERE datum BETWEEN poc_datum_p AND zav_datum_p
     AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
     AND inv.nam_id = nam.id
     AND inv.mt_id = mt.id 
     AND opisi.sifra = '0135'
   GROUP BY mt_id, opisi.id,   DECODE(opisi.ozn_gknji, 'D', nam.gknji_id, NULL)
   --
   UNION ALL
   --
   -- 0140 INVENTURNI VIAK
   --
   SELECT mt_id, opisi.id,
          SUM (DECODE (SIGN (kol_inv_razlika),  1, kol_inv_razlika, 0) * pros_nab_cijena) izn_inv_visak,
		  DECODE(opisi.ozn_gknji, 'D', nam.gknji_id, NULL)
     FROM i_dnev_ui dui,
	      m_namirnice nam,
          sgas_opisi_knjizenja opisi
    WHERE dui.datum BETWEEN poc_datum_p AND zav_datum_p
      AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
	  AND dui.nam_id = nam.id
      AND opisi.sifra = '0140'
    GROUP BY mt_id, opisi.id,  DECODE(opisi.ozn_gknji, 'D', nam.gknji_id, NULL)
   --
   UNION ALL
   --
   -- 0150 INVENTURNI MANJAK    
   -- Ako su upisana pravila 0151 i 0152 tada ne treba pravilo 0150
   --
   SELECT mt_id, opisi.id,
          SUM (DECODE (SIGN (kol_inv_razlika), -1, kol_inv_razlika, 0) * pros_nab_cijena * (-1)) izn_inv_manjak,
		  DECODE(opisi.ozn_gknji, 'D', nam.gknji_id, NULL)
     FROM i_dnev_ui dui,
	      m_namirnice nam,
	      m_mt mt,
          sgas_opisi_knjizenja opisi
    WHERE dui.datum BETWEEN poc_datum_p AND zav_datum_p
      AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
	  AND dui.nam_id = nam.id
	  AND dui.mt_id = mt.id
	  AND INSTR (pra_zmp_zaj.zmppar_vrijednost ('GAS', '1027'), mt.sifra ) = 0         --ne prikazuje se  manjak ==> ide kao  troak   po ineventuri
      AND opisi.sifra = '0150'
    GROUP BY mt_id, opisi.id,  DECODE(opisi.ozn_gknji, 'D', nam.gknji_id, NULL); 
   -- 
   --
   -- ako je trgovina upisuje se i dokument radi grupiranja na temeljnici gdje je saldo po vrsti dokumenta
   -- 
   -- 0151 MANJAK ODGOVORNA OSOBA
   --   
   INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, iznos, dokapl_id)  
   SELECT mt_id, opisi.id, SUM (invraz.kol_odg_osobe * invraz.pros_nab_cijena), DECODE(mt.vrsta, 'U', 11, NULL)
     FROM t_inv_razlike invraz,
          sgas_opisi_knjizenja opisi,
          m_mt mt
    WHERE invraz.datum BETWEEN poc_datum_p AND zav_datum_p
      AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1)) 
      AND mt_id = mt.id
      AND opisi.sifra = '0151'
      AND kol_odg_osobe > 0
    GROUP BY mt_id, opisi.id, DECODE(mt.vrsta, 'U', 11, NULL) 
   -- 
   UNION ALL
   --  
   -- 0091 POTRAIVANJE OD RADNIKA
   -- 
   --           
   SELECT mt_id, opisi.id, SUM (kol_odg_osobe * pc), DECODE(mt.vrsta, 'U', 11, NULL)
     FROM t_inv_razlike invraz, 
          sgas_opisi_knjizenja opisi,
          m_mt mt
    WHERE invraz.datum BETWEEN poc_datum_p AND zav_datum_p
      AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND opisi.sifra = '0091'
      AND mt.id = invraz.mt_id
      AND kol_odg_osobe > 0
    GROUP BY mt_id, opisi.id, DECODE(mt.vrsta, 'U', 11, NULL)  
   --
   UNION ALL
   --
   -- 0152 MANJAK (TOLERANCIJA + PC)
   --
   SELECT inv.mt_id, opisi.id, SUM (iznos), DECODE(mt.vrsta, 'U', 11, NULL)  
     FROM (SELECT invui.mt_id mt_id, invui.datum, invui.pdv, SUM((kol_tolerancije + kol_teret_pc) * invraz.pros_nab_cijena) iznos
             FROM t_inv_razlike invraz, i_inv_ui invui 
            WHERE invraz.datum  BETWEEN poc_datum_p AND zav_datum_p
              AND invraz.mt_id = invui.mt_id
              AND invraz.datum = invui.datum
              AND invraz.nam_id = invui.nam_id
              AND (kol_tolerancije + kol_teret_pc) > 0  
              AND invraz.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1)) 
            GROUP BY invui.mt_id, invui.datum, invui.nam_id, invui.pdv ) inv, 
            sgas_opisi_knjizenja opisi,
            m_mt mt 
    WHERE opisi.sifra = '0152'
      AND inv.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))   
      AND mt_id = mt.id    
    GROUP BY inv.mt_id, opisi.id, DECODE(mt.vrsta, 'U', 11, NULL)        
   -- 
   UNION ALL 
   --  
   -- 0118 PDV - MANJAK - TOLERANCIJA I NA TERET PC
   -- treba biti usklaeno sa iznosima u tablici IGAS_IRA ==> KASE_SIFRA = 'MANJAK PC'  
   --            
   SELECT  mt_id, opisi.id, SUM(iznos_pdv), DECODE(mt.vrsta, 'U', 11, NULL)
     FROM (SELECT invui.mt_id mt_id, invui.datum, invui.pdv,
              SUM (ROUND((invraz.kol_tolerancije + invraz.kol_teret_pc) * invraz.pros_nab_cijena * invraz.pdv/100,2)) iznos_pdv
             FROM t_inv_razlike invraz, i_inv_ui invui
            WHERE invraz.datum  BETWEEN poc_datum_p AND zav_datum_p
              AND invraz.mt_id = invui.mt_id
              AND invraz.datum = invui.datum
              AND invraz.nam_id = invui.nam_id 
              AND invraz.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
              AND (kol_tolerancije + kol_teret_pc) > 0
            GROUP BY invui.mt_id, invui.datum, invui.nam_id, invui.pdv ) inv, 
            sgas_opisi_knjizenja opisi,
            m_mt mt
    WHERE opisi.sifra = '0118'
      AND inv.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND inv.mt_id = mt.id
    GROUP BY  mt_id, opisi.id, DECODE(mt.vrsta, 'U', 11, NULL)
   --                        
    UNION ALL 
   --  
   -- 0119 PDV - ODGOVORNA OSOBA        
   -- PPOT se stavlja na 0 jer se obraunava samo na realizirani prihod
   -- treba biti usklaeno sa iznosima u tablici IGAS_IRA ==> KASE_SIFRA = 'MANJAK-OO'    
   --                
   SELECT mt_id, opisi.id, SUM(iznos_pdv), DECODE(mt.vrsta, 'U', 11, NULL)
     FROM (SELECT invraz.mt_id, invraz.datum, ROUND(SUM(zaj_obr.iznos_pdv (invraz.kol_odg_osobe * invraz.pc , invraz.pdv, 0)),2) iznos_pdv, NULL
             FROM t_inv_razlike invraz, i_inv_ui invui
            WHERE invraz.datum  BETWEEN poc_datum_p AND zav_datum_p   
              AND invraz.mt_id = invui.mt_id
              AND invraz.nam_id = invui.nam_id
              AND invraz.datum = invui.datum
              AND invraz.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
              AND invraz.kol_odg_osobe > 0
            GROUP BY invraz.mt_id, invraz.datum, invraz.pdv),  
          sgas_opisi_knjizenja opisi,
          m_mt mt
    WHERE opisi.sifra = '0119'    
      AND mt.id = mt_id
    GROUP BY mt_id, opisi.id, DECODE(mt.vrsta, 'U', 11, NULL);         
   --       
   --
   -- 0160 OTPIS
   -- 
   INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, iznos, gknji_id)
   SELECT mt.id, opisi.id,
          SUM (kol_dnev_otpis * pros_nab_cijena) izn_otpis,
		  DECODE(opisi.ozn_gknji, 'D', nam.gknji_id, NULL)
     FROM i_dnev_ui dui,
	      m_namirnice nam,
	      m_mt mt,
          sgas_opisi_knjizenja opisi
    WHERE dui.datum BETWEEN poc_datum_p AND zav_datum_p 
      AND dui.mt_id = mt.id
      AND mt.id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
	  AND dui.nam_id = nam.id   
	  AND pra_nst_zaj.vrati_akt_trg(mt.id, poc_datum_p) = 0
      AND opisi.sifra = '0160'
    GROUP BY mt.id, opisi.id,  DECODE(opisi.ozn_gknji, 'D', nam.gknji_id, NULL) 
   -- 
    UNION ALL
   --
   -- 0560 PDV NA POREZNO NEPRIZNAT OTPIS
   -- treba biti usklaeno sa iznosima u tablici IGAS_IRA ==> KASE_SIFRA = 'OTPIS'      
   --
 SELECT mt.id, opisi.id,
        SUM (iznos_poreza) izn_otpis, NULL
   FROM t_otpis otp,
	    t_otpis_art otpart,
	    m_mt mt,
        sgas_opisi_knjizenja opisi
  WHERE otp.datum BETWEEN poc_datum_p AND zav_datum_p
    AND otp.ozn_otpis = 'N'
    AND otp.id = otpart.otp_id
    AND otp.mt_id = mt.id
    AND mt.id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
    AND opisi.sifra = '0560'
    AND pra_nst_zaj.vrati_akt_trg(mt.id, poc_datum_p) = 0
  GROUP BY mt.id, opisi.id
   --  
   --
   UNION ALL
   --
   -- 0170 KOREKCIJA
   --
   SELECT mt_id, opisi.id,
          SUM (  izn_zav_stanje
               - izn_poc_stanje
               - izn_ulaz
               - izn_int_ulaz
               + izn_int_izlaz
               + IZLAZ
               - izn_inv_visak
               + izn_inv_manjak
               + izn_otpis)     korekcija,
          DECODE(opisi.ozn_gknji, 'D', gknji_id, NULL)
     FROM (SELECT mt_id,
                  gknji_id,
                  SUM (zaliha * pros_nab_cijena) izn_poc_stanje,
                  0 izn_ulaz,
                  0 izn_int_ulaz,
                  0 izn_int_izlaz,
                  0 izlaz,
                  0 izn_inv_visak,
                  0 izn_inv_manjak,
                  0 izn_otpis,
                  0 izn_zav_stanje
             FROM (SELECT dui.mt_id,
                          nam.gknji_id,
                          dui.zaliha,
                          dui.pros_nab_cijena,
                          dui.datum,
                          MAX(dui.datum) OVER (PARTITION BY dui.mt_id, dui.nam_id) max_datum
                     FROM i_dnev_ui dui,
                          m_mt mt,
                          m_namirnice nam
                    WHERE dui.mt_id = mt.id
                      AND mt.id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
                      AND dui.nam_id = nam.id
                      AND dui.datum  < poc_datum_p
                   )
            WHERE datum = max_datum
            GROUP BY mt_id, gknji_id
           --
           UNION ALL
           --
           SELECT mt.id mt_id, nam.gknji_id,
                  0 izn_poc_stanje,
                  SUM (izn_ulaz) izn_ulaz,
                  SUM (izn_int_ulaz) izn_int_ulaz,
                  SUM (izn_int_izlaz) izn_int_izlaz,
                  SUM ((kol_izlaz - kol_storno_izlaz_sup + kol_izlaz_sup)   * pros_nab_cijena) IZLAZ,
                  SUM (DECODE (SIGN (kol_inv_razlika),  1, kol_inv_razlika, 0) * pros_nab_cijena) izn_inv_visak,
                  SUM (DECODE (SIGN (kol_inv_razlika), -1, kol_inv_razlika, 0) * pros_nab_cijena * (-1)) izn_inv_manjak,
                  SUM (kol_dnev_otpis * pros_nab_cijena) izn_otpis,
                  0 izn_zav_stanje
             FROM i_dnev_ui dui,
                  m_namirnice nam,
                  m_mt mt
            WHERE dui.mt_id = mt.id
              AND dui.nam_id = nam.id
              AND mt.id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id,tem.oj_id) = -1))
              AND dui.datum BETWEEN poc_datum_p AND zav_datum_p
            GROUP BY mt.id, nam.gknji_id
           --
           UNION ALL
           --
           SELECT mt_id,
                  gknji_id,
                  0 izn_poc_stanje,
                  0 izn_ulaz,
                  0 izn_int_ulaz,
                  0 izn_int_izlaz,
                  0 IZLAZ,
                  0 izn_inv_visak,
                  0 izn_inv_manjak,
                  0 izn_inv_otpis,
                  SUM (zaliha * pros_nab_cijena) izn_zav_stanje
             FROM (SELECT dui.mt_id,
                          nam.gknji_id,
                          dui.zaliha,
                          dui.pros_nab_cijena,
                          dui.datum,
                          MAX(dui.datum) OVER (PARTITION BY dui.mt_id, dui.nam_id) max_datum
                     FROM i_dnev_ui dui,
                          m_mt mt,
                          m_namirnice nam
                    WHERE dui.mt_id = mt.id
                      AND mt.id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
                      AND dui.nam_id = nam.id
                      AND dui.datum  <= zav_datum_p
                   )
            WHERE datum = max_datum
            GROUP BY mt_id, gknji_id),
          sgas_opisi_knjizenja opisi
    WHERE opisi.sifra = '0170'
      AND zaj_obr.vanjsko_mjesto_troska(mt_id) = 0
    GROUP BY mt_id, opisi.id, DECODE(opisi.ozn_gknji, 'D', gknji_id, NULL)
   UNION ALL   
   --
   -- 0192 KOREKCIJA ULAZ INTERNI  (unutar objekta - sa trgovakih mjesta troka, modul GAT je aktivan)
   -- Ovo treba provjeriti moda se moe brisati   
   --
   SELECT mt_id_prima, opisi,
          NVL(SUM(trgo_iznos),0) - NVL(SUM(gas_iznos),0)  iznos,
          gknji_id
     FROM
     (
     SELECT pri.mt_id_prima mt_id_prima, opisi.id opisi,
          SUM (ROUND ((priart.kolicina * DECODE(planska_cijena, 0,nab_cijena, planska_cijena)), 2)) gas_iznos,
          NULL trgo_iznos,
          DECODE (opisi.ozn_gknji, 'D', NVL (pro.gknji_id, NVL (nam.gknji_id, bm_gas3130.sir_gknji_id (sir.id))), NULL) gknji_id
     FROM t_prijelaz pri,
          t_prijelaz_art priart,
          m_mt mtprima,
          m_mt mtdaje,
          m_sirovine sir,
          m_namirnice nam,
          m_proizvodi pro,
          sgas_opisi_knjizenja opisi,
          nst_gas_obrada ob
    WHERE pri.datum  BETWEEN poc_datum_p AND zav_datum_p
      AND mtprima.vrsta NOT IN ('M', 'T', 'O', 'U')
      AND mtdaje.vrsta  IN ( 'U')
      AND pri.mt_id_prima IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND pri.mt_id_daje  IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND pri.mt_id_prima = mtprima.id
      AND pri.mt_id_daje = mtdaje.id
      AND pri.id = priart.pri_id
      AND priart.sir_id = sir.id (+)
      AND priart.nam_id = nam.id (+)
      AND priart.pro_id = pro.id (+)
      AND ob.obrada_gas = 'D'
      AND opisi.sifra = '0192'
    GROUP BY
          pri.mt_id_prima, opisi.id, DECODE (opisi.ozn_gknji, 'D', NVL (pro.gknji_id, NVL (nam.gknji_id, bm_gas3130.sir_gknji_id (sir.id))), NULL)
    UNION ALL
       SELECT mtp.id mt_id_prima,opisi.id,
           NULL gas_iznos,
           SUM (vnsttrgo.ulaz_nab)*-1 trgo_iznos,
           DECODE (opisi.ozn_gknji, 'D',  nam.gknji_id, NULL) gknji_id
      FROM v_tnst_trgovina vnsttrgo,
           snst_dokapl nstdokapl,
           sgas_opisi_knjizenja opisi,
           tnst_prijelaz pri,
           m_namirnice nam,
           m_mt mtd,
           m_mt mtp
     WHERE vnsttrgo.mt_id = mtd.id
           AND vnsttrgo.dokapl_id = nstdokapl.id
           AND (nstdokapl.apl = 'T'
           AND (vnsttrgo.ozn_dp = 'D'
           AND nstdokapl.sifra IN ('503')))
           AND vnsttrgo.datum BETWEEN poc_datum_p AND zav_datum_p
           AND vnsttrgo.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
           AND vnsttrgo.vrsta_mt NOT IN ('U')
           AND vnsttrgo.id = pri.id
           AND mtp.id = pri.mtp_id
           AND opisi.sifra = '0192'
           AND vnsttrgo.nam_id = nam.id (+)
           GROUP BY mtp.id, opisi.id, DECODE (opisi.ozn_gknji, 'D',  nam.gknji_id, NULL))
   GROUP BY mt_id_prima, opisi, gknji_id
   --
   UNION ALL
   --
   -- 0230 OJ IZLAZ OSTALO (suma izlaza na negastro mjesta troka osim skladita (M))
   -- gas-ostalo 
   --
   SELECT tem.oj_id, opisi.id,
          SUM (ROUND ((priart.kolicina * nab_cijena ), 2)) iznos,
          DECODE (opisi.ozn_gknji, 'D', NVL (pro.gknji_id, NVL (nam.gknji_id, bm_gas3130.sir_gknji_id (sir.id))), NULL) gknji_id
     FROM t_prijelaz pri,
          t_prijelaz_art priart,
          m_mt mtprima,
          m_mt mtdaje,
          m_sirovine sir,
          m_namirnice nam,
          m_proizvodi pro,
          sgas_opisi_knjizenja opisi
    WHERE pri.datum BETWEEN poc_datum_p AND zav_datum_p
      AND mtprima.vrsta IN ( 'T', 'O')
      AND mtdaje.vrsta NOT IN ('U', 'T', 'O')
      AND pri.mt_id_daje IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND pri.mt_id_prima = mtprima.id
      AND pri.mt_id_daje  = mtdaje.id
      AND pri.id = priart.pri_id
      AND priart.sir_id = sir.id (+)
      AND priart.nam_id = nam.id (+)
      AND priart.pro_id = pro.id (+)
      AND opisi.sifra = '0230'
    GROUP BY
          tem.oj_id, opisi.id,
          DECODE (opisi.ozn_gknji, 'D', NVL (pro.gknji_id, NVL (nam.gknji_id, bm_gas3130.sir_gknji_id (sir.id))), NULL)
   --
   UNION ALL
   --
   -- 0240 OJ IZLAZ EKSTERNI (suma izlaza na  drugi objekt)    
   -- 0240 = 0200 - zatvara se ako se ne radi sa prijelaznim kontima ne pravilu 0200
   -- moe se i bez ovog pravila ako se radi sa prijelaznim kontima na pravilu 0200
   -- 
   SELECT tem.oj_id, opisi.id,
          SUM (ROUND ((priart.kolicina * nab_cijena ), 2)) iznos,
          DECODE (opisi.ozn_gknji, 'D', NVL (pro.gknji_id, NVL (nam.gknji_id, bm_gas3130.sir_gknji_id (sir.id))), NULL) gknji_id
     FROM t_prijelaz pri,
          t_prijelaz_art priart,
          m_mt mtprima,
          m_mt mtdaje,
          m_sirovine sir,
          m_namirnice nam,
          m_proizvodi pro,
          sgas_opisi_knjizenja opisi
    WHERE pri.datum BETWEEN poc_datum_p AND zav_datum_p
      AND mtprima.vrsta NOT IN ('M', 'T')
      AND mtdaje.vrsta  NOT IN ('M', 'T')
      AND pri.mt_id_prima NOT IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND pri.mt_id_daje      IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND pri.mt_id_daje  NOT IN (SELECT DISTINCT (mt_id) FROM tnst_kalk_gas WHERE datum < poc_datum_p)
      AND pri.mt_id_prima = mtprima.id
      AND pri.mt_id_daje = mtdaje.id
      AND pri.id = priart.pri_id
      AND priart.sir_id = sir.id (+)
      AND priart.nam_id = nam.id (+)
      AND priart.pro_id = pro.id (+)
      AND opisi.sifra = '0240'
    GROUP BY
          tem.oj_id, opisi.id,
          DECODE (opisi.ozn_gknji, 'D', NVL (pro.gknji_id, NVL (nam.gknji_id, bm_gas3130.sir_gknji_id (sir.id))), NULL)
   --
   UNION ALL
   --
   -- 0250 OJ ULAZ EKSTERNI (suma ulaza sa drugog objekta) 
   -- 0250 = 0210 - zatvara se ako se ne radi sa prijelaznim kontima ne pravilu 0210
   -- moe se i bez ovog pravila ako se radi sa prijelaznim kontima
   --  
   SELECT tem.oj_id, opisi.id,
          SUM (ROUND ((priart.kolicina * DECODE(planska_cijena, 0, nab_cijena, planska_cijena)), 2)) iznos,
          DECODE (opisi.ozn_gknji, 'D', NVL (pro.gknji_id, NVL (nam.gknji_id, bm_gas3130.sir_gknji_id (sir.id))), NULL) gknji_id
     FROM t_prijelaz pri,
          t_prijelaz_art priart,
          m_mt mtprima,
          m_mt mtdaje,
          m_sirovine sir,
          m_namirnice nam,
          m_proizvodi pro,
          sgas_opisi_knjizenja opisi
    WHERE pri.datum BETWEEN poc_datum_p AND zav_datum_p
      AND mtprima.vrsta NOT IN ('M', 'T')
      AND mtdaje.vrsta  NOT IN ('M', 'T')
      AND pri.mt_id_prima     IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND pri.mt_id_daje  NOT IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND pri.mt_id_prima NOT IN (SELECT DISTINCT (mt_id) FROM tnst_kalk_gas WHERE datum < poc_datum_p)
      AND pri.mt_id_prima  = mtprima.id
      AND pri.mt_id_daje   = mtdaje.id
      AND pri.id = priart.pri_id
      AND priart.sir_id = sir.id (+)
      AND priart.nam_id = nam.id (+)
      AND priart.pro_id = pro.id (+)
      AND opisi.sifra = '0250'
    GROUP BY
          tem.oj_id, opisi.id,
          DECODE (opisi.ozn_gknji, 'D', NVL (pro.gknji_id, NVL (nam.gknji_id, bm_gas3130.sir_gknji_id (sir.id))), NULL)
   --
   --  opisi 0211 i 0212 mogu zamijeniti opise 0180, 0190, 0200, 0210, 0220, 0230, 0240 i 0250 ako se knjienje
   --  radi na nain da je ulaz 3 D + a izlaz 3 D  
   --  saldo navednih knjienja mora biti 0  
   --  Arenaturist
   --
   UNION ALL
   -- 0211  MEUSKLADINICE - ULAZ
   --
   SELECT mt_id, opisi.id, SUM(izn_int_ulaz),
          DECODE (opisi.ozn_gknji, 'D',nam.gknji_id, NULL) gknji_id   
     FROM i_dnev_ui dui, 
          m_namirnice nam,
          sgas_opisi_knjizenja opisi
    WHERE datum BETWEEN poc_datum_p AND zav_datum_p
      AND dui.nam_id = nam.id
      AND dui.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND opisi.sifra = '0211'
    GROUP BY mt_id, opisi.id,   DECODE (opisi.ozn_gknji, 'D',nam.gknji_id, NULL)
   -- 
   UNION ALL
   --
   -- 0212  MEUSKLADINICE - IZLAZ
   -- 
  SELECT mt_id, opisi.id,  SUM(izn_int_izlaz),
         DECODE (opisi.ozn_gknji, 'D',nam.gknji_id, NULL) gknji_id   
    FROM i_dnev_ui dui,
         m_namirnice nam,
         sgas_opisi_knjizenja opisi
   WHERE datum BETWEEN poc_datum_p AND zav_datum_p
     AND dui.nam_id = nam.id
     AND dui.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
     AND opisi.sifra = '0212'
   GROUP BY mt_id, opisi.id,   DECODE (opisi.ozn_gknji, 'D',nam.gknji_id, NULL);  
   --
   -- GAT (samo nabavna vrijednost), GAS
   -- 0180  - IZLAZ INTERNI
   -- 0190  - ULAZ INTERNI
   -- 0200  - IZLAZ EKSETRNI
   -- 0210  - ULAZ EKSTERNI
   -- 0220  - IZLAZ U SKLADITE -- skladite je uvijek externo , bez obzira da li se nalazi na objektu
   -- 0230  - ULAZ U SKLADITE  -- skladite je uvijek externo , bez obzira da li se nalazi na objektu
   -- 0260  - IZLAZ U ADMINST.  -- administracija je uvijek externa , bez obzira da li se nalazi na objektu
   -- 0270  - ULAZ  U ADMINST.  -- administracija je uvijek externa , bez obzira da li se nalazi na objektu
   --                             
   -- za prijelaze se pgas_knjizenje insertira vrsta mjesta troka ( otkuda i na  koju vrstu je prijelaz)
   -- ovo radi za isti prijelazni konto, u protivnom bi trebalo u pravila knjienje dodati jo jednu vrstu mjesta troka
   -- u tablici v_tnst_trgovina (za potrebe GAT), ako je ozn_dp = 'D' onda je u stupac mt_id upisan id davaoca ,
   -- ako je ozn_dp = 'P' onda je u stupac mt_id upisan id primaoca
    
   INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, dokapl_id, iznos, gknji_id, vrsta)
   SELECT pri1.id, opisi.id, pri1.dokapl_id,  SUM(pri1.iznos) iznos,
          DECODE (opisi.ozn_gknji, 'D', gknji_id, NULL),
	      pri1.vrsta
     FROM
         (SELECT  pri.id,
                  DECODE (ui, 'U',
                      DECODE ( pri.vrsta, 'M', '0230', 'T', '0270', DECODE (pri.vrsta1,'T', '0270',DECODE ( daje_pripada, -1, '0190', '0210'))),
                      DECODE ( pri.vrsta, 'M', '0220', 'T', '0260', DECODE ( prima_pripada, -1, '0180', '0200')))  opis_knji,
		          pri.dokapl_id dokapl_id,
		          pri.gknji_id gknji_id,
                  pri.vrsta vrsta,
                  SUM (iznos) iznos
            FROM   (SELECT prima.id id,   -- GAS prima
                          'U' ui,
                           pra_zmp.oj_pripada_oj (pri.mt_id_prima, tem.oj_id) prima_pripada,
                           pra_zmp.oj_pripada_oj (pri.mt_id_daje, tem.oj_id ) daje_pripada,
                           DECODE (pra_zmp_zaj.zmppar_vrijednost ('GAS','1015'), '2',
                             DECODE(daje.vrsta,'M', 'M', 'T', 'T', 'U', 'U', 'O', 'O', 'G'), '1', DECODE(daje.vrsta,'M', 'M', 'T', 'T',NULL)) vrsta,
                           prima.vrsta vrsta1,
						   NVL (pro.gknji_id, NVL (nam.gknji_id, bm_gas3130.sir_gknji_id (sir.id))) gknji_id,
						   NULL dokapl_id,
                           SUM (DECODE(planska_cijena,0,ROUND ((priart.kolicina * nab_cijena),2),  ROUND ((priart.kolicina * planska_cijena),2))) iznos
                      FROM t_prijelaz pri,
                           t_prijelaz_art priart,
                           m_mt prima,
                           m_mt daje,
						   m_sirovine sir,
                           m_namirnice nam,
                           m_proizvodi pro
                     WHERE pri.mt_id_prima = prima.id
                       AND pri.mt_id_daje  = daje.id
                       AND pri.id = priart.pri_id
                       AND pri.datum  BETWEEN poc_datum_p AND zav_datum_p
                       AND (pra_zmp.oj_pripada_oj (pri.mt_id_prima, tem.oj_id) = -1 OR  prima.vrsta = 'T')
		               AND pra_nst_zaj.vrati_akt_trg(pri.mt_id_prima, pri.datum) = 0
					   AND pri.id = priart.pri_id
                       AND priart.sir_id = sir.id (+)
                       AND priart.nam_id = nam.id (+)
                       AND priart.pro_id = pro.id (+)
                     GROUP BY prima.id, pra_zmp.oj_pripada_oj (pri.mt_id_prima, tem.oj_id), pra_zmp.oj_pripada_oj (pri.mt_id_daje, tem.oj_id),
                              DECODE (pra_zmp_zaj.zmppar_vrijednost ('GAS','1015'), '2', DECODE(daje.vrsta,'M', 'M', 'T', 'T', 'U', 'U', 'O','O','G'), '1', DECODE(daje.vrsta,'M', 'M', 'T', 'T',NULL)),
                              prima.vrsta, NVL (pro.gknji_id, NVL (nam.gknji_id, bm_gas3130.sir_gknji_id (sir.id)))
                    UNION ALL
                    SELECT prima.id,   -- GAT prima
                          'U' ui,
		                   pra_zmp.oj_pripada_oj (vnsttrgo.mt_id, tem.oj_id) prima_pripada,
                           pra_zmp.oj_pripada_oj (vnsttrgo.mt_id1, tem.oj_id) daje_pripada,
	                       DECODE (pra_zmp_zaj.zmppar_vrijednost ('GAS','1015'), '2',
                                DECODE(daje.vrsta,'M', 'M', 'T', 'T', 'U', 'U', 'O', 'O','G'), '1',DECODE(daje.vrsta,'M', 'M', 'T', 'T',NULL)) vrsta,
						   prima.vrsta vrsta1,
						   nam.gknji_id gknji_id,
						   vnsttrgo.dokapl_id dokapl_id,
			               SUM (vnsttrgo.ulaz_nab) iznos
                      FROM v_tnst_trgovina vnsttrgo,
                           snst_dokapl nstdokapl,
                           m_mt daje,
                           m_mt prima,
						   m_namirnice nam
                     WHERE vnsttrgo.dokapl_id = nstdokapl.id
                       AND (nstdokapl.apl = 'T'
                       AND nstdokapl.sifra IN ('501','502','503')
                       AND vnsttrgo.ozn_dp = 'P')
                       AND vnsttrgo.mt_id = prima.id
                       AND vnsttrgo.mt_id1 =  daje.id
                       AND vnsttrgo.datum BETWEEN poc_datum_p AND zav_datum_p
		               AND pra_zmp.oj_pripada_oj (vnsttrgo.mt_id, tem.oj_id) = -1 
					   AND nam.id(+) = vnsttrgo.nam_id
                     GROUP BY  prima.id, pra_zmp.oj_pripada_oj (vnsttrgo.mt_id, tem.oj_id),
                           pra_zmp.oj_pripada_oj (vnsttrgo.mt_id1, tem.oj_id),
	                       DECODE (pra_zmp_zaj.zmppar_vrijednost ('GAS','1015'), '2', DECODE(daje.vrsta,'M', 'M', 'T', 'T', 'U', 'U','O','O',  'G'), '1',DECODE(daje.vrsta,'M', 'M', 'T', 'T',NULL)),
	                       prima.vrsta, vnsttrgo.dokapl_id, nam.gknji_id
	                UNION ALL
                    SELECT daje.id id,  -- GAS daje
                           'I' ui,
                           pra_zmp.oj_pripada_oj (pri.mt_id_prima, tem.oj_id) prima_pripada,
                           pra_zmp.oj_pripada_oj (pri.mt_id_daje, tem.oj_id) daje_pripada,
                           DECODE (pra_zmp_zaj.zmppar_vrijednost ('GAS','1015'), '2',
                              DECODE(prima.vrsta,'M', 'M', 'T', 'T', 'U', 'U', 'O','O', 'G'), '1', DECODE(prima.vrsta,'M', 'M', 'T', 'T',NULL)) vrsta,
						   daje.vrsta vrsta1,
						   NVL (pro.gknji_id, NVL (nam.gknji_id, bm_gas3130.sir_gknji_id (sir.id))) gknji_id,
						   NULL dokapl_id,
			               SUM (DECODE( planska_cijena,0, ROUND ((priart.kolicina * nab_cijena),2),  ROUND ((priart.kolicina * planska_cijena),2))) iznos
                      FROM t_prijelaz pri,
                           t_prijelaz_art priart,
                           m_mt prima,
                           m_mt daje,
					       m_sirovine sir,
                           m_namirnice nam,
                           m_proizvodi pro
                     WHERE pri.mt_id_prima = prima.id
                       AND pri.mt_id_daje  = daje.id
                       AND pri.id = priart.pri_id
                       AND pri.datum BETWEEN poc_datum_p AND zav_datum_p
                       AND pra_zmp.oj_pripada_oj (pri.mt_id_daje, tem.oj_id) = -1
		               AND pra_nst_zaj.vrati_akt_trg(pri.mt_id_daje, pri.datum) = 0
					   AND pri.id = priart.pri_id
                       AND priart.sir_id = sir.id (+)
                       AND priart.nam_id = nam.id (+)
                       AND priart.pro_id = pro.id (+)
                     GROUP BY  daje.id, pra_zmp.oj_pripada_oj (pri.mt_id_prima, tem.oj_id),
                           pra_zmp.oj_pripada_oj (pri.mt_id_daje, tem.oj_id),
                           DECODE (pra_zmp_zaj.zmppar_vrijednost ('GAS','1015'), '2',
                           DECODE(prima.vrsta,'M', 'M', 'T', 'T', 'U', 'U', 'O', 'O', 'G'), '1', DECODE(prima.vrsta,'M', 'M', 'T', 'T',NULL)),
						   daje.vrsta, NVL (pro.gknji_id, NVL (nam.gknji_id, bm_gas3130.sir_gknji_id (sir.id)))
				   UNION ALL
				    SELECT daje.id, -- GAT daje
                          'I' ui,
		                  pra_zmp.oj_pripada_oj (vnsttrgo.mt_id1, tem.oj_id) prima_pripada,
                          pra_zmp.oj_pripada_oj (vnsttrgo.mt_id, tem.oj_id) daje_pripada,
	                      DECODE (pra_zmp_zaj.zmppar_vrijednost ('GAS','1015'), '2',
                          DECODE(prima.vrsta,'M', 'M', 'T', 'T', 'U', 'U', 'O', 'O', 'G'), '1', DECODE(prima.vrsta,'M', 'M', 'T', 'T',NULL)) vrsta,
						  daje.vrsta vrsta1,
						  nam.gknji_id gknji_id,
						  vnsttrgo.dokapl_id dokapl_id,
			              SUM (vnsttrgo.ulaz_nab) iznos
                     FROM v_tnst_trgovina vnsttrgo,
                          snst_dokapl nstdokapl,
                          m_mt daje,
                          m_mt prima,
						  m_namirnice nam
                    WHERE vnsttrgo.dokapl_id = nstdokapl.id
                      AND (nstdokapl.apl = 'T'
                      AND nstdokapl.sifra IN ('501','502','503')
                      AND vnsttrgo.ozn_dp = 'D')
                      AND vnsttrgo.mt_id1 = prima.id
                      AND vnsttrgo.mt_id =  daje.id
                      AND vnsttrgo.datum BETWEEN poc_datum_p AND zav_datum_p
	                  AND pra_zmp.oj_pripada_oj (vnsttrgo.mt_id, tem.oj_id) = -1
					  AND nam.id(+) = vnsttrgo.nam_id
                    GROUP BY  daje.id, pra_zmp.oj_pripada_oj (vnsttrgo.mt_id, tem.oj_id),
                          pra_zmp.oj_pripada_oj (vnsttrgo.mt_id1, tem.oj_id),
	                      DECODE (pra_zmp_zaj.zmppar_vrijednost ('GAS','1015'), '2', DECODE(prima.vrsta,'M', 'M', 'T', 'T', 'U', 'U', 'O', 'O', 'G'), '1', DECODE(prima.vrsta,'M', 'M', 'T', 'T',NULL)),
						  daje.vrsta, vnsttrgo.dokapl_id, nam.gknji_id
			  ) pri,
              m_mt mt
        WHERE pri.id = mt.id
          AND mt.vrsta NOT IN ('M')  -- ne prikazuju se mjesta troka za koja se ne vodi ZALIHA
        GROUP BY pri.id,
              DECODE (ui, 'U',
                   DECODE ( pri.vrsta, 'M', '0230', 'T', '0270', DECODE (pri.vrsta1,'T', '0270',DECODE ( daje_pripada, -1, '0190', '0210'))),
                   DECODE ( pri.vrsta, 'M', '0220', 'T', '0260', DECODE ( prima_pripada, -1, '0180', '0200'))),
              pri.vrsta,
			  pri.gknji_id,
			  pri.dokapl_id
   			  ) pri1,
		      sgas_opisi_knjizenja opisi
    WHERE opisi.sifra = pri1.opis_knji  
      AND ((zaj_obr.vanjsko_mjesto_troska(pri1.id) = 0 AND pra_zmp_zaj.zmppar_vrijednost ('GAS','1068') = 'da') 
           OR pra_zmp_zaj.zmppar_vrijednost ('GAS','1068') = 'ne')    -- AM (da), VR(ne) 
    GROUP BY  pri1.id,
          opisi.id,
          DECODE (opisi.ozn_gknji, 'D', gknji_id, NULL),
		  pri1.dokapl_id,
		  pri1.vrsta;
   --
   -- knjienje naplate i reprezentacije         
   --
   INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, iznos, vpla_id)
   --
   -- 00700 NAPLATA   (ako se knjii naplata ne knjii se 0100 OJ PRIHOD BRUTTO
   --
   SELECT tem.oj_id, opisi.id,
          SUM (obr_realizacija) prihod_brutto, naplata.vpla_id
     FROM v_igas_usali_zurnal naplata,
          m_mt mt,
          sgas_opisi_knjizenja opisi,
	 	  m_nacpot nac,
	 	  s_vplacanja vpla 
    WHERE naplata.datum BETWEEN poc_datum_p AND zav_datum_p
      AND naplata.mt_id = mt.id
	  AND naplata.nac_id = nac.id 
	  AND naplata.vpla_id = vpla.id
      AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1)) 
      AND ((pra_zmp_zaj.zmppar_vrijednost ('GAS','1064') = 'da' AND vpla.ozn_irn IS NULL) OR pra_zmp_zaj.zmppar_vrijednost ('GAS','1064') = 'ne')
	  AND INSTR (pra_zmp_zaj.zmppar_vrijednost ('GAS','1036'), nac.sifra ) = 0    
	  AND INSTR (pra_zmp_zaj.zmppar_vrijednost ('GAS','1037'), nac.sifra ) = 0
      AND opisi.sifra = '0700'	   
    GROUP BY tem.oj_id, opisi.id, naplata.vpla_id 
    --
    --  
    --
    UNION ALL
    --  
    -- 0900 NAPOJNICA -- ne provjerava se radi li se o fiskalnoj vrsti planaja, ve samo datum fiskalizacije  
    -- knjii se na dva konta: naplata ili prijelazni konto koji se zatvara sa plaama
    --
    SELECT tem.oj_id, opisi.id, SUM(izn_napojnice) iznos, rn.vpla_napojnice_id 
      FROM t_rnkase rn, 
           m_kase kase,
           s_vplacanja vpla,
           sgas_opisi_knjizenja opisi 
     WHERE NVL(izn_napojnice,0) <> 0
       AND rn.kase_id = kase.id 
       AND rn.vpla_napojnice_id = vpla.id
       AND TRUNC(datum_napojnice)  BETWEEN poc_datum_p AND zav_datum_p
       AND pra_zmp.oj_pripada_oj (kase.zmpojr_id, tem.oj_id) = -1  
       AND opisi.sifra = '0900'	   
     GROUP BY tem.oj_id, opisi.id, rn.vpla_napojnice_id 
   -- 
   -- ovo dio koji je koristio samo LRH, provjeriti u  verziju 21.1 koriste li ostali korisnici  
   --
      UNION ALL       
   --   
   -- knjii se naine potreonje upisane u parametru GAS 1036
   -- 0710 REPREZENTACIJA - NETO
   -- 0711 REPREZENTACIJA - PDV
   --
   SELECT tem.oj_id, opisi.id,
          SUM(DECODE(opisi.sifra,'0710',(obr_realizacija - obr_pdv),
                                 '0711', obr_pdv)) iznos,
          NULL
     FROM v_igas_usali_zurnal naplata,
          m_mt mt,
          sgas_opisi_knjizenja opisi,
		  m_nacpot nac
    WHERE naplata.datum BETWEEN poc_datum_p AND zav_datum_p
      AND naplata.mt_id = mt.id
	  AND naplata.nac_id = nac.id
      AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
	  AND INSTR (pra_zmp_zaj.zmppar_vrijednost ('GAS','1036'), nac.sifra ) > 0
      AND opisi.sifra IN ( '0710', '0711')	   
    GROUP BY tem.oj_id, opisi.id 
   --   
     UNION ALL 
   --  
   -- knjienje naina potreonje upisanih u parametru GAS 1037
   -- 0712 REPREZENTACIJA - NETO -unutarnji
   -- 0713 REPREZENTACIJA - PDV - unutarnji
   --
   SELECT naplata.mt_id, opisi.id,
          SUM(DECODE(opisi.sifra,'0712',(obr_realizacija - obr_pdv),
                                 '0713', obr_pdv)) iznos,
          NULL
     FROM v_igas_usali_zurnal naplata,
          m_mt mt,
          sgas_opisi_knjizenja opisi,
		  m_nacpot nac
    WHERE naplata.datum BETWEEN poc_datum_p AND zav_datum_p
      AND naplata.mt_id = mt.id
	  AND naplata.nac_id = nac.id
      AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
	  AND INSTR (pra_zmp_zaj.zmppar_vrijednost ('GAS','1037'), nac.sifra ) > 0
      AND opisi.sifra IN ( '0712', '0713')
    GROUP BY naplata.mt_id, opisi.id;
   -- 
   -- knjienje porezno priznatih/nepriznatih rashoda trokova reprezentacije
   -- 0730 NEPRIZNATI TROKOVI REPREZENTACIJE 
   -- 0740 PRIZNATI TROKOVI REPREZENTACIJE            
   -- parametar: GAS, 1046 ifra naina potronje za priznavanje porezno priznatog rashoda reprezentacije ili nebitno.
   -- parametar: GAS, 1047 Postotak priznavanja porezno priznatog rashoda reprezentacije ili nebitno.
   -- 
   -- reprezentacija preko RNK
   --
   INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, iznos ) 
   SELECT mt.id,   
          opisi.id,
          SUM(DECODE(opisi.sifra, '0730', obr_realizacija * (1 - par.post),
                                  '0740', ROUND((obr_realizacija * (1 - par.post)),2))) iznos 
     FROM v_igas_usali_zurnal naplata,                       
          m_mt mt,
          sgas_opisi_knjizenja opisi,
          m_nacpot nac,
         (SELECT DECODE(pra_zmp_zaj.zmppar_vrijednost ('GAS','1047'), 'nebitno', 0, pra_zmp_zaj.zmppar_vrijednost ('GAS','1047')) / 100  post
            FROM dual) par
    WHERE naplata.datum BETWEEN poc_datum_p AND zav_datum_p
      AND naplata.mt_id = mt.id
      AND naplata.nac_id = nac.id
      AND naplata.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND INSTR (pra_zmp_zaj.zmppar_vrijednost ('GAS','1046'), nac.sifra ) > 0
      AND opisi.sifra IN ( '0730', '0740')
    GROUP BY mt.id, opisi.id 
    --
    UNION ALL
    -- reprezentacija preko prijelaza na mjesto troka vrste administracija
    --
    SELECT mt.id, 
           opisi.id,
           SUM(DECODE(opisi.sifra,'0730', ROUND (((priart.kolicina * nab_cijena) + NVL(iznos_pdv,0))* (1 - par.post),2),
                                  '0740', ROUND (((priart.kolicina * nab_cijena) + NVL(iznos_pdv,0))* (1 - par.post),2))) 
      FROM t_prijelaz pri,
           t_prijelaz_art priart,
           m_mt mt,
           m_sirovine sir,
           m_namirnice nam,
           m_proizvodi pro,
           sgas_opisi_knjizenja opisi,
          (SELECT DECODE(pra_zmp_zaj.zmppar_vrijednost ('GAS','1047'),'nebitno', 100, pra_zmp_zaj.zmppar_vrijednost ('GAS','1047')) / 100 post
             FROM dual) par
     WHERE pri.datum BETWEEN poc_datum_p AND zav_datum_p
       AND pri.id = priart.pri_id
       AND pri.mt_id_prima = mt.id
       AND priart.sir_id = sir.id (+)
       AND priart.nam_id = nam.id (+)
       AND priart.pro_id = pro.id (+)
       AND mt.vrsta = 'T' -- vrsta mjesta troka T - Administracija, ne alju se prijelaznice 
       AND mt_id_daje IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
       AND opisi.sifra IN ( '0730', '0740')
     GROUP BY mt.id, opisi.id; 
   -- 
   -- Knjienje PDV-a na darovane proizvode
   -- 0750, 0751, 0752 PDV - DAROVANJE 
   -- Primatelj je mjesto troka vrste administracija, pdv se knjii na MT  
   -- Za primatelja nije bitno pripada li tem.oj_id, darivanje moe ii drugim objektima (Aminess)  
   -- 
   --
    INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, iznos ) 
    SELECT mtprima.id, opisi.id,
           SUM(NVL(iznos_pdv,0))
      FROM t_prijelaz pri,
           t_prijelaz_art priart,
           m_mt mtprima,
           sgas_opisi_knjizenja opisi
     WHERE pri.datum BETWEEN poc_datum_p AND zav_datum_p
       AND mtprima.vrsta IN ( 'T')
       AND pri.mt_id_daje IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
       AND pri.mt_id_prima = mtprima.id
       AND pri.id = priart.pri_id 
       AND priart.vpispz_id IS NOT NULL
       AND INSTR(opisi.naziv,DECODE(LENGTH(priart.pdv),1, ' '||priart.pdv, priart.pdv)) > 0
       AND opisi.sifra  in ( '0750', '0751', '0752')
    GROUP BY
         mtprima.id, opisi.id;    
   -- 
   -- Opisi knjienja ('0010' i '0130') se mogu dobiti po nainima potronje i knjigovodstvenim grupama  
   -- 0010 PRIHOD NETTO
   -- 
     
   INSERT INTO pgas_knjizenje
         (oj_id, gasoknj_id, gnac_id, gknji_id, iznos)
   
     SELECT mt_id, opisi.id, DECODE (opisi.ozn_gnac, 'D', gnac_id, NULL),  DECODE(opisi.ozn_gknji, 'D', gknji_id, NULL),
            SUM (obr_realizacija - obr_pdv - obr_ppot - obr_pnaknade) prihod_netto
       FROM v_igas_rn_promet promet,
            sgas_opisi_knjizenja opisi,
            m_nacpot nac
      WHERE promet.datum BETWEEN poc_datum_p AND zav_datum_p
        AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
        AND promet.nac_id = nac.id
        AND opisi.sifra = '0010'
      GROUP BY mt_id, opisi.id, DECODE (opisi.ozn_gnac, 'D', gnac_id, NULL),  DECODE(opisi.ozn_gknji, 'D', gknji_id, NULL);
 
    --
    --              
    -- 
    -- STORNO OPISA '0010', do verzije 21.1 je bilo vezano samo specifino za licencu Uljanika
    --  od verzije 22.1 se koriste za prorainsko knjigovodstvo i koristi seG GAS parametra
    --  GAS  1064  Proraunsko knjienje prihoda: da ili ne.
    --   
      INSERT INTO pgas_knjizenje
         (oj_id, gasoknj_id, gnac_id, gknji_id, iznos)    
         
      SELECT mt_id, opisi.id,  DECODE (opisi.ozn_gnac,'D',nac.gnac_id, NULL), DECODE (opisi.ozn_gknji,'D', rnpro.gknji_id, NULL),
             SUM((rnpro.iznos - rnpro.iznos_pdv - rnpro.iznos_ppot - rnpro.iznos_pnaknade) * -1)
        FROM t_rnkase rn,
             t_rnkase_pro rnpro,
             s_vplacanja vpla,
             m_nacpot nac,
             sgas_opisi_knjizenja opisi,
             sgas_vlasnik vlasnik
       WHERE rn.id = rnpro.rn_id
         AND rn.vpla_id = vpla.id
         AND rn.nac_id = nac.id 
         AND vpla.ozn_irn IS NOT NULL
         AND (pra_zmp_zaj.zmppar_vrijednost ('GAS','1064') = 'da' AND vpla.ozn_irn IS NOT NULL)  
         AND rn.datum BETWEEN poc_datum_p AND zav_datum_p
         AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
         AND opisi.sifra  = '0010'
       GROUP BY rnpro.mt_id, opisi.id, DECODE (opisi.ozn_gnac,'D',nac.gnac_id, NULL), DECODE (opisi.ozn_gknji,'D', rnpro.gknji_id, NULL)
    --
      UNION ALL
    --
     SELECT izldok.mt_id, opisi.id,   DECODE (opisi.ozn_gnac,'D',nac.gnac_id, NULL), DECODE (opisi.ozn_gknji,'D', izldokart.gknji_id, NULL),
             SUM(DECODE (izldokart.rabat, 0, izldokart.kolicina * izldokart.prod_cijena,
             ROUND(izldokart.kolicina * (izldokart.prod_cijena * (1 - izldokart.rabat / 100)), 2))) * -1         
       FROM tgas_izlazdok izldok,
            tgas_izlazdok_art izldokart,
            s_vplacanja vpla,
            m_nacpot nac,
            sgas_opisi_knjizenja opisi               
      WHERE izldok.datum  BETWEEN poc_datum_p AND zav_datum_p
        AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
        AND izldok.id = izldokart.gasizldok_id  
        AND izldok.nac_id = nac.id
        AND pra_zmp_zaj.zmppar_vrijednost ('GAS', '1008') = vpla.sifra
        AND (pra_zmp_zaj.zmppar_vrijednost ('GAS','1064') = 'da' AND vpla.ozn_irn IS NOT NULL)  
        AND opisi.sifra  = '0010'
      GROUP BY  izldok.mt_id, opisi.id, DECODE (opisi.ozn_gnac,'D',nac.gnac_id, NULL), DECODE (opisi.ozn_gknji,'D', izldokart.gknji_id, NULL)
    --
       UNION ALL
    --
    -- 0130 IZLAZ
    --
      SELECT mt.id, opisi.id, DECODE (opisi.ozn_gnac, 'D', gnac_id, NULL),  DECODE(opisi.ozn_gknji, 'D', gknji_id, NULL),
             SUM ((kol_izlaz - kol_storno_izlaz_sup + kol_izlaz_sup) * pros_nab_cijena)
        FROM i_dnev_ui_nac duinac,
             m_mt mt,
             m_nacpot nac,
             sgas_opisi_knjizenja opisi
       WHERE duinac.datum BETWEEN poc_datum_p AND zav_datum_p
         AND duinac.mt_id = mt.id
         AND mt.vrsta NOT IN ( 'U')
         AND mt.id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
         AND duinac.nac_id = nac.id
         AND opisi.sifra = '0130'
       GROUP BY mt.id, opisi.id,  DECODE (opisi.ozn_gnac, 'D', gnac_id, NULL),  DECODE(opisi.ozn_gknji, 'D', gknji_id, NULL);
    --
    --
    -- 0131 PANSIONSKI IZLAZ - RASPODJELA TROKOVA, isti konto kao i pansionka hrana na 0130 (LRH)
    --   
      INSERT INTO pgas_knjizenje
          (oj_id, gasoknj_id, iznos)        
      SELECT DECODE(i.oznaka, 1, kuhinja.mt_id, trosak.mt_id),
             gasoknj.id, 
             SUM(trosak.pnc_obrok * brgost.kolicina * i.oznaka) trosak 
        FROM 
        /* broj gostiju za SO, SASTOJAK i DATUM
        */
            (SELECT DISTINCT(so_id), zursas.sas_id, zur.datum, SUM(kolicina_danas + kolicina_storno) kolicina 
               FROM irec_zur_sas zursas, i_zurnali zur,  ( SELECT id FROM  m_so WHERE metcvor_sifra = pra_zmp_zaj.tekuci_cvor) so     
              WHERE zursas.zur_id = zur.id
                AND zur.so_id = so.id
                AND zur.datum   BETWEEN  poc_datum_p AND zav_datum_p     
              GROUP BY so_id,  zursas.sas_id, zur.datum ) brgost, 
        /* cijena obroka za nain potronje, so i datum
        */
            (SELECT izl.mt_id mt_id, nac.sas_id, izl.nac_id,  izl.datum,  izl.priznanje, izl.pdv, izl.ppot, 
                    DECODE(SUM(br_gostiju_izlaz),0,0, t.iznos / SUM(br_gostiju_izlaz)) pnc_obrok
               FROM t_izlaz izl, 
                    m_nacpot nac, 
                   (SELECT duinac.mt_id, duinac.nac_id, duinac.datum,
                           SUM((kol_izlaz - kol_storno_izlaz_sup + kol_izlaz_sup) * pros_nab_cijena) iznos
                      FROM i_dnev_ui_nac duinac
                     WHERE  datum  BETWEEN  poc_datum_p AND zav_datum_p     
                     GROUP BY duinac.mt_id, duinac.nac_id, duinac.datum) t
               WHERE izl.datum  BETWEEN  poc_datum_p AND zav_datum_p     
                 AND izl.mt_id = t.mt_id
                 AND izl.nac_id = nac.id
                 AND izl.nac_id = t.nac_id
                 AND izl.datum = t.datum  
                 AND izl.sifgr_id IS NULL -- samo pansion 
                 AND nac.sas_id IS NOT NULL
               GROUP BY izl.mt_id, nac.sas_id, izl.nac_id,  izl.datum, t.iznos, izl.priznanje, izl.pdv, izl.ppot) trosak,    
        /* mjesta troka na koje se knjii rec prihod po priznanju
        */
            (SELECT DISTINCT(mt.id) mt_id, so.id so_id 
               FROM mrec_pknjizenja_zur recpknjzur, 
                    m_mt mt,
                   (SELECT id, sifra, oj_id  FROM m_so WHERE metcvor_sifra = pra_zmp_zaj.tekuci_cvor AND dat_ponisten IS NULL) so 
               WHERE recpknjzur.oj_knjizenja = mt.sifra
                 AND mt.vrsta = 'K'
                 AND recpknjzur.so_id = so.id) kuhinja,
             m_mt mt,
             m_nacpot nac,
             sgas_opisi_knjizenja gasoknj, 
            (SELECT -1 oznaka  FROM DUAL
             UNION  SELECT  1 oznaka FROM DUAL) i          
       WHERE brgost.so_id = kuhinja.so_id
         AND brgost.sas_id = trosak.sas_id
         AND brgost.datum = trosak.datum
         AND kuhinja.mt_id <> trosak.mt_id
         AND kuhinja.mt_id = mt.id
         AND nac.id = trosak.nac_id
         AND brgost.kolicina <> 0
         AND gasoknj.sifra = '0131'
       GROUP BY DECODE(i.oznaka, 1, kuhinja.mt_id, trosak.mt_id), 
             gasoknj.id;  
   --
   -- Dio knjienja samo za Operu/Valamar (nije potrebno mijenjati pravila knjienja)  
   --
   IF pra_zmp_zaj.zmppar_vrijednost ('GAS', '1004')  ='1' THEN  
      INSERT INTO pgas_knjizenje
         (oj_id, gasoknj_id, gnac_id, gknji_id, iznos, opera_rc_id )
   -- 
   -- 0131 PRIJENOS TROKOVA - storno MT
   --
      SELECT mt.id, opisi.id, DECODE (opisi.ozn_gnac, 'D', gnac_id, NULL),  DECODE(opisi.ozn_gknji, 'D', gknji_id, NULL),
         SUM ((kol_izlaz - kol_storno_izlaz_sup + kol_izlaz_sup) * pros_nab_cijena) * -1, NULL
        FROM i_dnev_ui_nac duinac,
             m_mt mt,
             m_nacpot nac,
             sgas_opisi_knjizenja opisi
       WHERE duinac.datum BETWEEN poc_datum_p AND zav_datum_p
         AND duinac.mt_id = mt.id
         AND mt.vrsta NOT IN ( 'U')
         AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
         AND duinac.nac_id = nac.id
         AND opisi.sifra =  '0131'
       GROUP BY mt.id, opisi.id,  DECODE (opisi.ozn_gnac, 'D', gnac_id, NULL),  DECODE(opisi.ozn_gknji, 'D', gknji_id, NULL)
   --
   -- 0131 PRIJENOS TROKOVA - RC
   --
       UNION ALL
   --
      SELECT mt.id, opisi.id, DECODE (opisi.ozn_gnac, 'D', gnac_id, NULL),  DECODE(opisi.ozn_gknji, 'D', gknji_id, NULL),
             SUM ((kol_izlaz - kol_storno_izlaz_sup + kol_izlaz_sup) * pros_nab_cijena), opera_rc_id
        FROM i_dnev_ui_nac_opera operaduinac,
             m_mt mt,
             m_nacpot nac,
             sgas_opisi_knjizenja opisi
       WHERE operaduinac.datum BETWEEN poc_datum_p AND zav_datum_p
         AND operaduinac.mt_id = mt.id
         AND mt.vrsta NOT IN ( 'U')
         AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
         AND operaduinac.nac_id = nac.id
         AND opisi.sifra =  '0131'
       GROUP BY mt.id, opisi.id,  DECODE (opisi.ozn_gnac, 'D', gnac_id, NULL),  DECODE(opisi.ozn_gknji, 'D', gknji_id, NULL), opera_rc_id; 
   END IF;
  
   -- 
   -- PRERASPODJELA ZAOKRUENJA IZMEU 0130 i 0131 == na stavku sa najveim iznosom
   --      
   BEGIN
     FOR i IN (
       SELECT oj_id, SUM(iznos) iznos
         FROM pgas_knjizenje 
        WHERE  gasoknj_id in (78)
        GROUP BY oj_id)
     LOOP
       IF i.iznos < 0.03 THEN    
         UPDATE pgas_knjizenje 
            SET iznos = iznos - i.iznos
          WHERE oj_id = i.oj_id 
            AND opera_rc_id IS NOT NULL
            AND gasoknj_id = 78
            AND iznos = (SELECT MAX(iznos)
                           FROM pgas_knjizenje 
                          WHERE oj_id = i.oj_id 
                            AND opera_rc_id IS NOT NULL
                            AND gasoknj_id = 78);
      END IF;
     END LOOP;     
    
   END;
   
   -- 
   -- 0132 TROKOVI PO KOMITENTIMA/OTPREMNICE Valamar samo za povezana drutva, vrijednost za komitenta 
   --  
   
   INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, iznos, gnac_id, gknji_id, gmpkom_id)   
   SELECT gasizldok.mt_id,
          opisi.id, 
          SUM(ROUND(gasizldokart.kolicina * gasizldokart.nab_cijena,2)) iznos,
          nac.gnac_id,
          pro.gknji_id,
          gasizldok.gmpkom_id
     FROM tgas_izlazdok gasizldok,
          tgas_izlazdok_art gasizldokart, 
          sgas_opisi_knjizenja opisi,
          m_proizvodi pro,
          m_nacpot nac
    WHERE gasizldokart.gasizldok_id = gasizldok.id
      AND gasizldok.ozn_vdokumenta <> 'R'
      AND gasizldok.nac_id = nac.id
      AND gasizldok.datum BETWEEN poc_datum_p AND zav_datum_p
      AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND opisi.sifra = '0132'
      AND gasizldokart.pro_id = pro.id
    GROUP BY gasizldok.mt_id, opisi.id, nac.gnac_id, pro.gknji_id, gasizldok.gmpkom_id;
   
   
   --
   -- 0010 - PRIHOD NETTO - ODGOVORNA OSOBA
   -- 
   
   -- Manjak na teret odgovorne osobe se tretira kao bilo koji drugi prihod  (0010)
   -- Treba ga proknjiiti na ispravan konto preko kombinacije: grupe mjesta troka, opisa, grupe naina potronje i knjigovodstvene grupe 
   -- Grupa naina potronje se uzima iz najmanje ifre ili ako ne postoji iz 0001 - A LA CARTE (najei)
   -- U stupac vrsta se upisuje harkodirano (X) da se kod upisa u tablicu IGAS_KNJIZENJE ova stavka prebacila u kategoriju troka  
   --
   INSERT INTO pgas_knjizenje
         (oj_id, gasoknj_id, gnac_id, gknji_id, iznos, vrsta)
   SELECT mt_id, opisi.id, gnac_id, nam.gknji_id, 
          SUM(invraz.kol_odg_osobe * invraz.pc - (zaj_obr.iznos_pdv (invraz.kol_odg_osobe * invraz.pc , invraz.pdv, 0))), 'X'
     FROM t_inv_razlike invraz,
          m_nacpot nac,
          m_namirnice nam,
          m_mt mt,
          sgas_opisi_knjizenja opisi
    WHERE invraz.datum BETWEEN poc_datum_p AND zav_datum_p
      AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND opisi.sifra = '0010'
      AND nac.sifra IN (SELECT NVL(min(sifra), '0001')
                          FROM m_mt_np mtnp,
                               m_nacpot nac
                         WHERE mtnp.nac_id = nac.id
                           AND mtnp.mt_id = invraz.mt_id)
      AND nam.id = invraz.nam_id     
      AND mt.id = invraz.mt_id
      AND mt.vrsta <> 'U' 
      AND kol_odg_osobe > 0
      
    GROUP BY mt_id, opisi.id, nac.gnac_id, nam.gknji_id, 'X';
   
   
   /*
   Punjenje lokalne tablice IGAS_IRA.
   Na nesamostalnim objektima je to pomona tablica iz koje se puni IGAS_IRA na centru,
   a na samostalnom objektu i centralnom gastru je to i konana tablica. 
   Dio PDV-a iz IGAS_IRA se kontira opisima knjienja koji na temeljnici troka.
   */
   INSERT INTO IGAS_IRA
      (oj_id, oj_sifra, datum, vpla_id,
       mt_id, mt_sifra, kase_id, kase_sifra,
       izn_osnovica, izn_pdv, izn_ppot, pdv_stopa, oznaka_knji)
    SELECT oj.id oj_id, oj.sifra oj_sifra, rn.datum datum, rn.vpla_id vpla_id,
           rnpro.mt_id mt_id, mt.sifra mt_sifra, rn.kase_id kase_id, kase.sifra kase_sifra,
           SUM ((rnpro.iznos - rnpro.iznos_pdv - rnpro.iznos_ppot-rnpro.iznos_pnaknade) * DECODE (nac.ozn_obracuna_poreza, 'P', 0, 1)) izn_osnovica,  
           SUM (rnpro.iznos_pdv * DECODE (nac.ozn_obracuna_poreza, 'P', 0, 1)) izn_pdv,
           SUM (rnpro.iznos_ppot) izn_ppot,
           rnpro.pdv pdv_stopa,
           'N'	oznaka_knji
      FROM t_rnkase rn,
           t_rnkase_pro rnpro,
           m_nacpot nac,
           mgmp_kase kase,
           m_mt mt,
           m_oj oj,
           s_vplacanja vpla
     WHERE rn.id = rnpro.rn_id
       AND rn.datum BETWEEN poc_datum_p AND zav_datum_p
       AND rn.nac_id   = nac.id
       AND rnpro.mt_id = mt.id
       AND rn.kase_id  = kase.id
       AND tem.oj_id = oj.id
       AND rn.vpla_id = vpla.id 
       AND ((pra_zmp_zaj.zmppar_vrijednost ('GAS','1064') = 'da' AND vpla.ozn_irn IS NULL) OR pra_zmp_zaj.zmppar_vrijednost ('GAS','1064') = 'ne')
       AND mt.id IN (SELECT id
                       FROM (SELECT ROWNUM, id
                               FROM m_mt
                              WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1
                                  )
                      )
     GROUP BY oj.id, oj.sifra, rn.datum, rn.vpla_id, rnpro.mt_id, mt.sifra, rn.kase_id, kase.sifra, rnpro.pdv, 'N'
   --  
     UNION ALL
   --
   -- PDV NA OTPIS    
   -- vrsta dokumenta porezno nepriznati otpis
   -- min kasa i vpla se koristi jer su polja u tablici IGAS_IRA NOT NULL
   --
   SELECT tem.oj_id, oj.sifra, otp.datum, vpla.id,
          otp.mt_id, mt.sifra, kase.id, 'OTPIS',
          SUM(DECODE(mt.vrsta,'U', DECODE(otpart.pdv, 0, 0, (iznos_poreza  * 100.00 / otpart.pdv)),(otpart.kolicina * otpart.pros_nab_cijena))) izn_osnovica,
          SUM(iznos_poreza) izn_pdv, 0, otpart.pdv, 'N'
     FROM t_otpis otp,
          t_otpis_art otpart,
          m_mt mt,
          m_oj oj,  
          (SELECT MAX(ID) id FROM s_vplacanja WHERE ozn_kag = -1) vpla,
          (SELECT MIN(ID) id  FROM m_kase) kase
    WHERE otp.id = otpart.otp_id
      AND otp.datum  BETWEEN poc_datum_p AND zav_datum_p
      AND mt.id IN (SELECT id
                            FROM (SELECT ROWNUM, id
                                    FROM m_mt
                                   WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1
                                 )
                         )
      AND otp.mt_id = mt.id
      AND oj.id = tem.oj_id     
      AND ozn_otpis = 'N' 
    GROUP BY  tem.oj_id, oj.sifra, otp.datum, vpla.id, otp.mt_id, mt.sifra, kase.id, 'OTPIS', otpart.pdv, 0, 'N'
   --
     UNION ALL
   --
   -- PDV NA INVENTURNI MANJAK: TOLERANCIJA, PODUZEE i ODGOVORNA OSOBA  
   -- MAX kasa i vpla se koristi jer su polja u tablici IGAS_IRA NOT NULL
   -- MANJAK-OO  jednak iznosu na pravilu 0119 osim za trgovaku robu
   --
   SELECT tem.oj_id, oj.sifra, inv.datum, vpla.id,
          inv.mt_id, mt.sifra, kase.id, 'MANJAK-OO',
          SUM(izn_osnovica) izn_osnovica,
          SUM(izn_pdv)  izn_pdv, 0, inv.pdv, 'N'
     FROM (SELECT invraz.mt_id mt_id, invraz.datum, invraz.nam_id, invraz.pdv pdv,
                  SUM(invraz.kol_odg_osobe * invraz.pc - zaj_obr.iznos_pdv (invraz.kol_odg_osobe * invraz.pc , invraz.pdv, 0)) izn_osnovica,
                  ROUND(SUM (zaj_obr.iznos_pdv (invraz.kol_odg_osobe * invraz.pc , invraz.pdv, 0) ),2)  izn_pdv 
             FROM t_inv_razlike invraz,
                  i_inv_ui invui
            WHERE invraz.datum  BETWEEN poc_datum_p AND zav_datum_p
              AND invraz.kol_odg_osobe > 0 
              AND invraz.mt_id = invui.mt_id
              AND invraz.datum = invui.datum
              AND invraz.nam_id = invui.nam_id 
            GROUP BY invraz.mt_id, invraz.datum, invraz.nam_id, invraz.pdv) inv,        
           m_mt mt,
           m_oj oj,
          (SELECT MAX(ID) id FROM s_vplacanja WHERE ozn_kag = -1) vpla,
          (SELECT MAX(ID) id FROM m_kase) kase
    WHERE mt.id IN (SELECT id FROM (SELECT ROWNUM, id
                                      FROM m_mt
                                     WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND oj.id = tem.oj_id                           
      AND inv.mt_id = mt.id     
    GROUP BY tem.oj_id, oj.sifra, inv.datum, vpla.id, inv.mt_id, mt.sifra, kase.id,  'MANJAK-OO', inv.pdv, 0, 'N'  
   -- 
   UNION ALL
   --
   -- MANJAK PC  jednak iznosu na pravilu 0118 osim za atrgovaku robu gdje na pravilu 0420
   --
   SELECT tem.oj_id, oj.sifra, inv.datum, vpla.id,
          inv.mt_id, mt.sifra, kase.id, 'MANJAK PC',
          SUM(izn_osnovica) izn_osnovica,
          SUM(izn_pdv)  izn_pdv, 0, inv.pdv, 'N'
     FROM (SELECT invraz.mt_id mt_id, invraz.datum, invraz.nam_id, invraz.pdv pdv,
                  SUM((invraz.kol_tolerancije + invraz.kol_teret_pc) * invraz.pros_nab_cijena) izn_osnovica,
                  SUM(ROUND((invraz.kol_tolerancije + invraz.kol_teret_pc) * invraz.pros_nab_cijena * invraz.pdv/100,2))  izn_pdv 
             FROM t_inv_razlike invraz,
                  i_inv_ui invui
            WHERE invraz.datum  BETWEEN poc_datum_p AND zav_datum_p
              AND (invraz.kol_tolerancije > 0 OR  invraz.kol_teret_pc > 0)
              AND invraz.mt_id = invui.mt_id
              AND invraz.datum = invui.datum
              AND invraz.nam_id = invui.nam_id 
            GROUP BY invraz.mt_id, invraz.datum, invraz.nam_id, invraz.pdv) inv,        
           m_mt mt,
           m_oj oj,
          (SELECT MAX(ID) id FROM s_vplacanja WHERE ozn_kag = -1) vpla,
          (SELECT MAX(ID) id FROM m_kase) kase
    WHERE mt.id IN (SELECT id FROM (SELECT ROWNUM, id
                                      FROM m_mt
                                     WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND oj.id = tem.oj_id                        
      AND inv.mt_id = mt.id     
    GROUP BY tem.oj_id, oj.sifra, inv.datum, vpla.id, inv.mt_id, mt.sifra, kase.id,  'MANJAK PC', inv.pdv, 0, 'N'     
   --
   UNION ALL
   --
   -- PDV po otpremnicama ulazu u sumu PDV-a po RNK na pravilima: 0110 ili 0111, 0112, 0113     
   -- provjerava se REC parametra je li izdanim ili ne
   --   
   --
   SELECT tem.oj_id, oj.sifra, izldok.datum, vpla.id,
          mt.id, mt.sifra, kase.id, 'OTPREMNICE',
          SUM(DECODE (izldokart.rabat, 0, izldokart.kolicina * izldokart.prod_cijena, 
              ROUND(izldokart.kolicina * (izldokart.prod_cijena * (1 - izldokart.rabat / 100)), 2))) osnovica, 
          SUM(ROUND(izldokart.kolicina * DECODE(izldokart.rabat,0, prod_cijena, izldokart.prod_cijena * (1 - izldokart.rabat/100))
                   *  (izldokart.pdv/100),2)), 0, izldokart.pdv,
          'N'
     FROM tgas_izlazdok izldok,
          tgas_izlazdok_art izldokart,
          s_vplacanja vpla,
          m_oj oj,
          m_mt mt,
          (SELECT MAX(ID) id FROM m_kase) kase
    WHERE izldok.datum  BETWEEN poc_datum_p AND zav_datum_p
      AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND oj.id = tem.oj_id
      AND izldok.mt_id = mt.id
      AND izldok.id = izldokart.gasizldok_id
      AND pra_zmp_zaj.zmppar_vrijednost ('GAS', '1008') = vpla.sifra
      AND pra_zmp_zaj.zmppar_vrijednost ('GAS', '1050') = 'da'
      AND ((pra_zmp_zaj.zmppar_vrijednost ('GAS','1064') = 'da' AND vpla.ozn_irn IS NULL) OR pra_zmp_zaj.zmppar_vrijednost ('GAS','1064') = 'ne')
      AND izldokart.pdv <> 0
    GROUP BY  tem.oj_id, oj.sifra, izldok.datum, vpla.id, mt.id, mt.sifra, kase.id, 'OTPREMNICE', izldokart.pdv 
   -- 
   UNION ALL
   --
   -- PDV po DAROVANIM proizvodima po pravilima:  0750, 0751, 0752 (AM)  i 0270 (VR)
   -- Za primatelja nije bitno pripada li tem.oj_id, darivanje moe ii drugim objektima (Aminess, Valamar)
   -- mjesto troka ADMIN moe pripadati nekoj knjizi rauna za koju postoji shema 
   -- ili pripadati fiktivnoj knjizi rauna koja uzima podatke sa vie ema  
   --   
   SELECT DECODE(pra_zmp_zaj.zmppar_vrijednost ('GAS','1068'), 'ne', pra_zmp_s.oj_zmpojr_id (mt_id_prima ,poc_datum_p, zav_datum_p, 'GAS'), tem.oj_id) , oj.sifra, pri.datum, vpla.id,
          pri.mt_id_prima, mtprima.sifra, kase.id, 'PDV DAR.',
          SUM (kolicina * nab_cijena) izn_osnovica,
          SUM(NVL(iznos_pdv,0)) izn_pdv,
          SUM(0) izn_ppot,
          priart.pdv, 
          'N'	oznaka_knji
     FROM t_prijelaz pri,
          t_prijelaz_art priart,
          m_mt mtprima, 
          (SELECT MAX(kase_id) id FROM t_rnkase) kase,  -- mogue je da sa vie shema ide prijelaz istog dana prema istom MT vrste Admin pa se razgrniava po kase sheme, kako se ne bi narutio UK 
          (SELECT MAX(ID) id FROM s_vplacanja WHERE ozn_kag = -1) vpla,
          m_oj oj 
    WHERE pri.datum BETWEEN poc_datum_p AND zav_datum_p
      AND mtprima.vrsta IN ( 'T')
      AND pri.mt_id_daje IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND pri.mt_id_prima = mtprima.id
      AND oj.id = pra_zmp_s.oj_zmpojr_id (mt_id_prima ,poc_datum_p, zav_datum_p, 'GAS')
      AND pri.id = priart.pri_id 
      AND priart.vpispz_id IS NOT NULL
    GROUP BY DECODE(pra_zmp_zaj.zmppar_vrijednost ('GAS','1068'), 'ne', pra_zmp_s.oj_zmpojr_id (mt_id_prima ,poc_datum_p, zav_datum_p, 'GAS'), tem.oj_id),
            oj.sifra, pri.datum, vpla.id, pri.mt_id_prima, mtprima.sifra, kase.id, 'PDV DAR.', priart.pdv; 
   
  --  
  --  PRIHOD NETO - SUMARNO  ==>  ako se prihod knjii preko prijelaznih konta GLAS
  --  
  INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, iznos)
   SELECT tem.oj_id, opisi.id, 
         SUM(rnpro.iznos - rnpro.iznos_pdv - rnpro.iznos_ppot - rnpro.iznos_pnaknade)  
    FROM t_rnkase rn,
         t_rnkase_pro rnpro,
         sgas_opisi_knjizenja opisi,
         s_vplacanja vpla
   WHERE rn.id = rnpro.rn_id
     AND rn.datum BETWEEN poc_datum_p AND zav_datum_p
     AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
     AND rn.vpla_id = vpla.id
     AND vpla.ozn_irn IS NULL
     AND opisi.sifra  = '0011'
   GROUP BY tem.oj_id, opisi.id
  UNION ALL 
    SELECT tem.oj_id, opisi.id, 
         SUM(rnpro.iznos - rnpro.iznos_pdv - rnpro.iznos_ppot - rnpro.iznos_pnaknade)  
    FROM t_rnkase rn,
         t_rnkase_pro rnpro,
         sgas_opisi_knjizenja opisi,
         s_vplacanja vpla
   WHERE rn.id = rnpro.rn_id
     AND rn.datum BETWEEN poc_datum_p AND zav_datum_p
     AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
     AND rn.vpla_id = vpla.id
     AND vpla.ozn_irn IS NOT NULL
     AND opisi.sifra  = '0012'
   GROUP BY tem.oj_id, opisi.id;  
  
  --  GLAS             
  /* specifino za knjienje ako je vanjski sustav GLAS radi se preko prijelaznih konta
    briu se IRN vrste palaanja, ovi bi se moglo odraditi preko pravila za naplatu ali ih REC koristi
    pa se ne mou brisati
    96 - '0700'  NAPLATA

    stronira se PDV i PPOT za IRN vrste placanja
  */
   IF UPPER (pra_pka_zaj.vrijednost_parametra ('1049')) = 'GLAS' THEN
      DELETE pgas_knjizenje
       WHERE gasoknj_id = 96
         AND vpla_id IN (SELECT id FROM s_vplacanja WHERE ozn_irn IS NOT NULL);

      INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, iznos)
        SELECT tem.oj_id,
               opisi.id,
               SUM(DECODE(ozn_obracuna_poreza,'D',rnpro.iznos_pdv * - 1, 0)) oj_obr_pdv
          FROM t_rnkase rn,
               t_rnkase_pro rnpro,
               m_nacpot nac,
               sgas_opisi_knjizenja opisi,             
               s_vplacanja vpla
         WHERE rn.datum  BETWEEN poc_datum_p AND zav_datum_p
           AND rn.id = rnpro.rn_id
           AND rn.vpla_id = vpla.id
           AND rn.nac_id = nac.id
           AND vpla.ozn_irn IS NOT NULL
           AND INSTR(opisi.naziv,DECODE(LENGTH(rnpro.pdv),1, ' '||rnpro.pdv, rnpro.pdv)) > 0
           AND rnpro.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
           AND opisi.sifra  in ( '0111', '0112', '0113')
         GROUP BY  tem.oj_id, opisi.id
         UNION ALL    
        SELECT tem.oj_id, opisi.id,
               SUM(rnpro.iznos_ppot * - 1) oj_obr_pdv
          FROM t_rnkase rn,
               t_rnkase_pro rnpro,     
               sgas_opisi_knjizenja opisi,             
               s_vplacanja vpla
         WHERE rn.datum  BETWEEN poc_datum_p AND zav_datum_p
           AND rn.id = rnpro.rn_id
           AND rn.vpla_id = vpla.id     
           AND vpla.ozn_irn IS NOT NULL
           AND rnpro.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
           AND opisi.sifra  in ( '0120')
         GROUP BY  tem.oj_id, opisi.id;  
   END IF;
 END LOOP;
 /* ako je aktivan  modul GAT  uzima se procedura knjizenje_trgo */
 SELECT obrada_gas INTO obrada_gas_L
   FROM nst_gas_obrada;

 IF obrada_gas_L = 'D' THEN
    SELECT count(*) INTO brojac_l
      FROM tnst_kalk_gas                   
     WHERE datum <= zav_datum_p;           
     
     /* trgovina je bila aktivna u razdoblju */
     IF brojac_l > 0 THEN 
        bm_gas3130.knjizenje_trgo(poc_datum_p,zav_datum_p);        
     END IF;

 END IF;
END;
PROCEDURE KNJIZENJE_TRGO
 (POC_DATUM_P DATE
 ,ZAV_DATUM_P DATE
 )
 IS
oj_id_l m_oj.id%TYPE;
BEGIN  
    
 EXECUTE IMMEDIATE ('ALTER SESSION SET OPTIMIZER_MODE = ALL_ROWS');
 SELECT oj_id INTO oj_id_l FROM sgas_vlasnik;

 FOR tem IN (
    SELECT DISTINCT(id) oj_id
      FROM mzmp_ojr
     WHERE metcvor_sifra_gas IS NOT NULL
       AND pra_zmp.oj_pripada_oj (id, oj_id_l) = -1
       AND (dat_ponisten IS NULL OR dat_ponisten > zav_datum_p))
 LOOP

    INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, dokapl_id, iznos)   
    
    --  
    -- 0450 KOREKCIJA OJ - PDV-a  u sluaju neispravne porezne grupe,   
    --
    SELECT tem.oj_id, gasoknj.id, dok,
           SUM (iznos_trgo - iznos_gastro) prihod_pdv
      FROM (SELECT mt.id mt, nstdokapl.id dok,
                   SUM (pra_nst_zaj.porez_iznos(
                          nstpromg.iznos_prodano - nstpromg.iznos_pnaknade,
                          nstkalkg.stopa_poreza))iznos_trgo,
                   0 iznos_gastro
              FROM tnst_promet nstprom,
                   tnst_promet_gas nstpromg,
                   tnst_kalk_gas nstkalkg,
                   snst_dokapl nstdokapl,
                   m_mt mt
             WHERE nstprom.mt_id = mt.id
               AND nstprom.id = nstpromg.nstprom_id
               AND nstpromg.nstkalkg_id = nstkalkg.id
               AND nstprom.nstdokapl_id = nstdokapl.id
               AND nstprom.gasulaz_id IS NULL
               AND nstdokapl.apl = 'T'
               AND nstdokapl.sifra = '301'
               AND nstprom.datum BETWEEN poc_datum_p AND zav_datum_p
               AND nstprom.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
             GROUP BY mt.id, nstdokapl.id
             --
             UNION ALL  
             --
            SELECT mt.id mt, nstdokapl.id dok,
                   0 iznos_trgo,
                   SUM (obr_pdv) iznos_gastro
              FROM v_igas_rn_promet vgrnpro,
                   snst_dokapl nstdokapl,
                   m_mt mt
             WHERE vgrnpro.mt_id = mt.id
               AND mt.vrsta IN ( 'P', 'U')
               AND (nstdokapl.sifra = '301'
               AND nstdokapl.apl = 'T')
               AND vgrnpro.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
               AND vgrnpro.datum BETWEEN poc_datum_p AND zav_datum_p
             GROUP BY mt.id, nstdokapl.id),
           sgas_opisi_knjizenja gasoknj
     WHERE gasoknj.sifra = '0450'
     GROUP BY   tem.oj_id, gasoknj.id, dok
    --
     UNION ALL 
    --
    --   0460 KOREKCIJA OJ - PPOT-a u sluaju neispravne porezne grupe    
    --
    SELECT tem.oj_id, gasoknj.id, nstdokapl.id,
           SUM (obr_ppot) oj_obr_ppot
      FROM v_igas_rn_promet vgrnpro,
           snst_dokapl nstdokapl,
           sgas_opisi_knjizenja gasoknj,
           m_mt mt
     WHERE vgrnpro.mt_id = mt.id
       AND mt.vrsta IN ( 'P', 'U')
       AND (nstdokapl.sifra = '301'
       AND nstdokapl.apl = 'T')
       AND gasoknj.sifra = '0460'
       AND vgrnpro.datum BETWEEN poc_datum_p AND zav_datum_p
       AND vgrnpro.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
     GROUP BY tem.oj_id, gasoknj.id, nstdokapl.id;
    --
    INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, dokapl_id,  gnac_id, gknji_id, iznos)
    
    --
    -- 0320 KOREKCIJA PRIHODA NETTO TRGOVAKE ROBE - korekcija iznosa za stavku 0020
    --
    SELECT mt, gasoknj.id, dok, DECODE (gasoknj.ozn_gnac, 'D', gnac_id, NULL) gnac_id, DECODE(gasoknj.ozn_gknji, 'D', gknji_id, NULL) gknji_id,
           SUM (iznos_trgo - iznos_gastro) prihod_netto
      FROM (
      SELECT mt.id mt, nstdokapl.id dok, nac.gnac_id gnac_id, pro.gknji_id gknji_id,
                   SUM (nstpromg.iznos_prodano - nstpromg.iznos_pnaknade) -
                   SUM (pra_nst_zaj.porez_iznos(
                           nstpromg.iznos_prodano - nstpromg.iznos_pnaknade,
                           nstkalkg.stopa_poreza)) iznos_trgo,
                   0 iznos_gastro
              FROM tnst_promet nstprom,
                   tnst_promet_gas nstpromg,
                   tnst_kalk_gas nstkalkg,
                   snst_dokapl nstdokapl,
                   m_proizvodi pro,
                   t_rnkase rn,
                   m_nacpot nac,
                   m_mt mt
             WHERE nstprom.mt_id = mt.id
               AND nstprom.id = nstpromg.nstprom_id
               AND nstpromg.nstkalkg_id = nstkalkg.id
               AND nstprom.nstdokapl_id = nstdokapl.id
               AND (nstdokapl.sifra = '301'
               AND nstdokapl.apl = 'T')
               AND nstprom.gasulaz_id IS NULL
               AND nstpromg.gasulaz_id =  rn.id
               AND nstprom.datum BETWEEN poc_datum_p AND zav_datum_p
               AND nstprom.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
               AND pro.id = nstpromg.pro_id
               AND rn.nac_id = nac.id
             GROUP BY mt.id, nstdokapl.id, nac.gnac_id, pro.gknji_id
             UNION ALL
            SELECT mt.id mt, nstdokapl.id dok, nac.gnac_id, vgrnpro.gknji_id,
                   0 iznos_trgo,
                   SUM (obr_realizacija - obr_pdv - obr_ppot - obr_pnaknade) iznos_gastro
              FROM v_igas_rn_promet vgrnpro,
                   snst_dokapl nstdokapl,
                   m_nacpot nac,
                   m_mt mt
             WHERE vgrnpro.mt_id = mt.id
               AND mt.vrsta IN ( 'P', 'U')
               AND (nstdokapl.apl = 'T'
               AND nstdokapl.sifra = '301')
               AND vgrnpro.datum BETWEEN poc_datum_p AND zav_datum_p
               AND vgrnpro.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
               AND vgrnpro.nac_id = nac.id
             GROUP BY mt.id , nstdokapl.id, nac.gnac_id, vgrnpro.gknji_id
             ),
           sgas_opisi_knjizenja gasoknj
     WHERE gasoknj.sifra = '0320'
     GROUP BY mt, gasoknj.id, dok, DECODE (gasoknj.ozn_gnac, 'D', gnac_id, NULL),  DECODE(gasoknj.ozn_gknji, 'D', gknji_id, NULL);
     --   
    INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, dokapl_id, iznos)
    
    --
    -- 0330  KOREKCIJA PRIHODA - UKALKULIRANI PDV TRGOVAKE ROBE  - korekcija za stavku '0060'
    --
    SELECT mt, gasoknj.id, dok,
           SUM (iznos_trgo - iznos_gastro) prihod_pdv
      FROM (SELECT mt.id mt, nstdokapl.id dok,
                   SUM (pra_nst_zaj.porez_iznos(
                           nstpromg.iznos_prodano - nstpromg.iznos_pnaknade,
                           nstkalkg.stopa_poreza))iznos_trgo,
                   0 iznos_gastro
              FROM tnst_promet nstprom,
                   tnst_promet_gas nstpromg,
                   tnst_kalk_gas nstkalkg,
                   snst_dokapl nstdokapl,
                   m_mt mt
             WHERE nstprom.mt_id = mt.id
               AND nstprom.id = nstpromg.nstprom_id
               AND nstpromg.nstkalkg_id = nstkalkg.id
               AND nstprom.nstdokapl_id = nstdokapl.id
               AND nstprom.gasulaz_id IS NULL
               AND (nstdokapl.apl = 'T'
               AND nstdokapl.sifra = '301')
               AND nstprom.datum BETWEEN poc_datum_p AND zav_datum_p
               AND nstprom.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
             GROUP BY mt.id, nstdokapl.id
             UNION ALL
            SELECT mt.id mt, nstdokapl.id dok,
                   0 iznos_trgo,
                   SUM (obr_pdv) iznos_gastro
              FROM v_igas_rn_promet vgrnpro,
                   snst_dokapl nstdokapl,
                   m_mt mt
             WHERE vgrnpro.mt_id = mt.id
               AND mt.vrsta IN ( 'P', 'U')
               AND (nstdokapl.apl = 'T'
               AND nstdokapl.sifra = '301')
               AND vgrnpro.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
               AND vgrnpro.datum BETWEEN poc_datum_p AND zav_datum_p
             GROUP BY mt.id, nstdokapl.id),
           sgas_opisi_knjizenja gasoknj
     WHERE gasoknj.sifra = '0330'
     GROUP BY mt, gasoknj.id, dok;
    --
    -- 0310 MARA U PRIHODU OD PRODAJE TRGOVAKE ROBE
    --
    INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, dokapl_id, iznos)
    
    SELECT vnsttrgo.mt_id, gasoknj.id, nstdokapl.id,
           SUM (vnsttrgo.izlaz_ruc) marza
      FROM v_tnst_trgovina vnsttrgo,
           snst_dokapl nstdokapl,
           sgas_opisi_knjizenja gasoknj
     WHERE vnsttrgo.dokapl_id = nstdokapl.id
       AND (nstdokapl.apl = 'T'
       AND nstdokapl.sifra = '301')
       AND vnsttrgo.datum BETWEEN poc_datum_p AND zav_datum_p
       AND vnsttrgo.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
       AND gasoknj.sifra = '0310'
     GROUP BY vnsttrgo.mt_id, gasoknj.id, nstdokapl.id  
     --
     UNION ALL 
     --
     -- 0075 NABAVNA VRIJEDNOST  - promet sa kasa, pojednostavljeno knjienje
     --
     SELECT vnsttrgo.mt_id, gasoknj.id, nstdokapl.id,
          SUM (vnsttrgo.izlaz_nab) nab
     FROM v_tnst_trgovina vnsttrgo,
          snst_dokapl nstdokapl,
          sgas_opisi_knjizenja gasoknj
    WHERE vnsttrgo.dokapl_id = nstdokapl.id
      AND (nstdokapl.apl = 'T'
      AND nstdokapl.sifra = '301')
      AND vnsttrgo.datum BETWEEN poc_datum_p AND zav_datum_p
      AND vnsttrgo.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
      AND gasoknj.sifra = '0075'
    GROUP BY vnsttrgo.mt_id, gasoknj.id, nstdokapl.id;
     
     
    --
    -- 0380 PRODAJNA VRIJEDNOST ULAZA TRGOVAKE ROBE (DOBAVLJA)
    -- 0380 PRODAJNA VRIJEDNOST ULAZA TRGOVAKE ROBE (POVRAT DOBAVLJAU)
    -- 0380 ISPRAVAK ZADUENJA PO PROMETU (KOREKCIJA PRODAJNE VRIJEDNOSTI)
    -- 0380 PRODAJNA VRIJEDNOST TRGOVAKE ROBE (PRIVREMENO ZADUENJE)
    -- 0380 INVENTURNI VIAK TRGOVAKE ROBE PRODAJNA VRIJEDNOST
    -- 0380 PRODAJNA VRIJEDNOST TRGOVAKE ROBE (OTPIS)
    -- 0380 PRODAJNA VRIJEDNOST TRGOVAKE ROBE (ZAMJENA ARTIKALA)
    -- 0380 PROMJENA CIJENA (ISPRAVAK PRODAJNE VRIJEDNOSTI)
    -- 0380 PROMJENA POREZNIH STOPA (ISPRAVAK PRODAJNE VRIJEDNOSTI)
    -- 0380 PRODAJNA VRIJEDNOST TRGOVAKE ROBE (INTERNA PRIMKA)
    -- 0380 PRODAJNA VRIJEDNOST TRGOVAKE ROBE (INTERNA IZDATNICA)
    -- 0380 PRODAJNA VRIJEDNOST TRGOVAKE ROBE (MEUSKLADINICA)
    --
    INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, dokapl_id, iznos)
    
    SELECT vnsttrgo.mt_id, gasoknj.id, nstdokapl.id,
           SUM (vnsttrgo.ulaz_mpc) ulaz
      FROM v_tnst_trgovina vnsttrgo,
           snst_dokapl nstdokapl,
           sgas_opisi_knjizenja gasoknj
     WHERE vnsttrgo.dokapl_id = nstdokapl.id
       AND (nstdokapl.apl = 'T'
       AND ((nstdokapl.sifra IN
           ('101','102','301','403','405','407','402','410','420','502'))
 	    OR (nstdokapl.sifra IN ('501')
       AND vnsttrgo.ozn_dp = 'P')
        OR (vnsttrgo.ozn_dp = 'D'
	   AND nstdokapl.sifra IN ('503'))))
       AND vnsttrgo.datum BETWEEN poc_datum_p AND zav_datum_p
       AND vnsttrgo.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
       AND gasoknj.sifra = '0380'
     GROUP BY vnsttrgo.mt_id, gasoknj.id, nstdokapl.id;
    --
    -- 0370 UKALKULIRANI PDV TRGOVAKE ROBE (DOBAVLJA)
    -- 0370 UKALKULIRANI PDV TRGOVAKE ROBE (POVRAT DOBAVLJAU)
    -- 0370 ISPRAVAK ZADUENJA PO PROMETU (KOREKCIJA PDV-a)
    -- 0370 IZNOS PDV-a TRGOVAKE ROBE (PRIVREMENO ZADUENJE)
    -- 0370 INVENTURNI VIAK TRGOVAKE ROBE PDV
    -- 0370 IZNOS PDV-a TRGOVAKE ROBE (ZAMJENA ARTIKALA)
    -- 0370 PROMJENA CIJENA (ISPRAVAK PDV-a)
    -- 0370 PROMJENA POREZNIH STOPA (ISPRAVAK PDV-a)
    -- 0370 PDV TRGOVAKE ROBE (INTERNA PRIMKA)
    -- 0370 PDV TRGOVAKE ROBE (INTERNA IZDATNICA)
    -- 0370 PDV TRGOVAKE ROBE (MEUSKLADINICA)
    --
    INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, dokapl_id, iznos)
    
    SELECT vnsttrgo.mt_id, gasoknj.id, nstdokapl.id,
           SUM (vnsttrgo.ulaz_porez) iznos_porez
      FROM v_tnst_trgovina vnsttrgo,
           snst_dokapl nstdokapl,
           sgas_opisi_knjizenja gasoknj
     WHERE vnsttrgo.dokapl_id = nstdokapl.id
       AND (nstdokapl.apl = 'T'
       AND ((nstdokapl.sifra IN
           ('101','102','301','403','405','402','410','420','502'))
	  OR (nstdokapl.sifra IN ('501')
       AND vnsttrgo.ozn_dp = 'P')
        OR (vnsttrgo.ozn_dp = 'D'
	 AND nstdokapl.sifra IN ('503'))))
       AND vnsttrgo.datum BETWEEN poc_datum_p AND zav_datum_p
       AND vnsttrgo.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
       AND gasoknj.sifra = '0370'
     GROUP BY vnsttrgo.mt_id, gasoknj.id, nstdokapl.id;
    --
    -- 0550 PDV trg.robe u otpisu-porezno dozvoljeni (OTPIS)
    -- 0560 PDV NA OTPIS - porezno nepriznat (OTPIS) 
    --
    INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, dokapl_id, iznos)
    
    SELECT vnsttrgo.mt_id, gasoknj.id, nstdokapl.id,
           SUM(DECODE(gasoknj.sifra, '0550', vnsttrgo.ulaz_porez, (DECODE(ozn_otpis, 'P', 0, vnsttrgo.ulaz_porez)))) iznos_porez
      FROM v_tnst_trgovina vnsttrgo,
           snst_dokapl nstdokapl,
           sgas_opisi_knjizenja gasoknj,
           t_otpis otp
     WHERE vnsttrgo.dokapl_id = nstdokapl.id
       AND (nstdokapl.apl = 'T'
       AND nstdokapl.sifra IN ('407'))
       AND vnsttrgo.datum BETWEEN poc_datum_p AND zav_datum_p 
       AND vnsttrgo.gasulaz_id = otp.id
       AND vnsttrgo.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
       AND gasoknj.sifra  IN  ('0550','0560') 
     GROUP BY vnsttrgo.mt_id, gasoknj.id, nstdokapl.id;
    
    --
    -- 0360 ISPRAVAK ZADUENJA PO PROMETU (KOREKCIJA RUC-a)
    -- 0360 INVENTURNI VIAK TRGOVAKE ROBE RUC
    -- 0360 IZNOS RUC-a TRGOVAKE ROBE (OTPIS)
    -- 0360 IZNOS RUC-a TRGOVAKE ROBE (ZAMJENA ARTIKALA)
    -- 0360 PROMJENA CIJENA (ISPRAVAK RUC-a)
    -- 0360 PROMJENA POREZNIH STOPA (ISPRAVAK RUC-a)
    -- 0360 RUC TRGOVAKE ROBE (INTERNA PRIMKA)
    -- 0360 RUC TRGOVAKE ROBE (INTERNA IZDATNICA)
    -- 0360 RUC TRGOVAKE ROBE (MEUSKLADINICA)
    --
    INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, dokapl_id, iznos)
    
    SELECT vnsttrgo.mt_id, gasoknj.id, nstdokapl.id,
           SUM (vnsttrgo.ulaz_ruc) iznos_ruc
      FROM v_tnst_trgovina vnsttrgo,
           snst_dokapl nstdokapl,
           sgas_opisi_knjizenja gasoknj
     WHERE vnsttrgo.dokapl_id = nstdokapl.id
       AND (nstdokapl.apl = 'T'
       AND ((nstdokapl.sifra IN
           ('101', '102', '301','405','407','402','410','420','502'))
	  OR (nstdokapl.sifra IN ('501')
       AND vnsttrgo.ozn_dp = 'P')
        OR (vnsttrgo.ozn_dp = 'D'
	 AND nstdokapl.sifra IN ('503'))))
       AND vnsttrgo.datum BETWEEN poc_datum_p AND zav_datum_p
       AND vnsttrgo.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
       AND gasoknj.sifra = '0360'
     GROUP BY vnsttrgo.mt_id, gasoknj.id, nstdokapl.id
    ---
    UNION ALL 
    ---
    --- 0360 KOREKCIJA RUCA TRGOVAKE ROBE (razlika primka i vrijednost primke po kalkulacijama)
    ---
    SELECT t.mt_id, gasoknj.id, t.dokapl_id,
       SUM (t.ulaz_korekcija * -1) 
      FROM v_tnst_trgovina t,
           sgas_opisi_knjizenja gasoknj,
           m_namirnice nam
     WHERE t.datum  BETWEEN poc_datum_p AND zav_datum_p
       AND gasoknj.sifra = '0360'
       AND t.nam_id = nam.id
       AND t.dokapl_id IN (3, 4)  -- primka ili povrat dobavaljau
       AND t.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1)) 
     GROUP BY t.mt_id, gasoknj.id, t.dokapl_id;
    --  
    --  0350 NABAVNA VRIJEDNOST ULAZA TRGOVAKE ROBE po orginalnim vrijednostima  iz kalkulacije 
    --
    INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, dokapl_id, gknji_id, iznos)
    
    SELECT nstulaz.mt_id, gasoknj.id, nstulaz.nstdokapl_id,
           DECODE (gasoknj.ozn_gknji, 'D',  nam.gknji_id, NULL) gknji_id,        
           SUM(nstkalkg.nab_cijena * nstulazg.kolicina)    iznos_nab
      FROM tnst_ulaz nstulaz,
           tnst_ulaz_gas nstulazg,
           tnst_kalk_gas nstkalkg,
           m_namirnice nam,
           sgas_opisi_knjizenja gasoknj
     WHERE nstulaz.id = nstulazg.nstulaz_id
       AND nstkalkg.mt_id = nstulaz.mt_id
       AND nstulazg.nstkalkg_id = nstkalkg.id
       AND nstulaz.nstdokapl_id IN (3, 4)  -- primka ili povrat dobavaljau
       AND nstulaz.datum BETWEEN poc_datum_p AND zav_datum_p
       AND nstulaz.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))    
       AND gasoknj.sifra = '0350'
       AND nam.id(+) = nstulazg.nam_id
     GROUP BY nstulaz.mt_id, gasoknj.id, nstulaz.nstdokapl_id, DECODE (gasoknj.ozn_gknji, 'D', nam.gknji_id,  NULL)
    -- 
       UNION ALL
    --
    --  0350 KOREKCIJA NABAVNE VRIJEDNOSTI ULAZA TRGOVAKE ROBE (razlika primka i vrijednost primke po kalkulacijama)
    --  
    --
    SELECT t.mt_id, gasoknj.id, t.dokapl_id,
           DECODE (gasoknj.ozn_gknji, 'D',  nam.gknji_id, NULL) gknji_id,
           SUM(t.ulaz_korekcija)
      FROM v_tnst_trgovina t,
           sgas_opisi_knjizenja gasoknj,
           m_namirnice nam
     WHERE t.datum  BETWEEN poc_datum_p AND zav_datum_p
       AND gasoknj.sifra = '0350'
       AND t.nam_id = nam.id
       AND t.dokapl_id IN (3, 4)  -- primka ili povrat dobavaljau
       AND t.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
     GROUP BY  t.mt_id, gasoknj.id, t.dokapl_id,  DECODE (gasoknj.ozn_gknji, 'D',  nam.gknji_id, NULL);                  
    --    
    --                  
    -- OBRADA ZAPISNIKA O PRIVREMENOM ZADUENJU  
    --
    INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, dokapl_id, iznos)
    
    --
    -- 0360 IZNOS RUC-a TRGOVAKE ROBE (PRIVREMENO ZADUENJE  - koliina > 0 i koliina < 0)
    --
    SELECT nstzap.mt_id, gasoknj.id, nstdokapl.id,
           SUM (pra_nst_zaj.ruc_iznos(
                    nstzapg.kolicina * DECODE(SIGN(nstzapg.kolicina), 1, nstkalkg.pros_cijena, nstkalkg.nab_cijena),
                    nstzapg.kolicina * nstkalkg.mal_cijena,
                    nstkalkg.stopa_poreza,
                    nstzapg.kolicina * nstkalkg.pnaknada)) iznos_ruc
      FROM tnst_zapisnici nstzap,
           tnst_zapisnici_gas nstzapg,
           tnst_kalk_gas nstkalkg,
           snst_dokapl nstdokapl,
           sgas_opisi_knjizenja gasoknj
     WHERE nstzap.id = nstzapg.nstzap_id
       AND nstzapg.nstkalkg_id = nstkalkg.id
       AND nstzap.nstdokapl_id = nstdokapl.id
       AND (nstdokapl.apl = 'T'
       AND nstdokapl.sifra = '403')
       AND nstzap.datum BETWEEN poc_datum_p AND zav_datum_p
       AND nstzap.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
       AND gasoknj.sifra = '0360'
     GROUP BY nstzap.mt_id, gasoknj.id, nstdokapl.id, SIGN(nstzapg.kolicina);

    --
    
    INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, dokapl_id, gknji_id, iznos)
    --
    -- 0470 NABAVNA VRIJEDNOST TRGOVAKE ROBE (PRIVREMENO ZADUENJE - grupirano po koliina >< 0
    --
    SELECT nstzap.mt_id, gasoknj.id, nstdokapl.id, DECODE (gasoknj.ozn_gknji, 'D', nam.gknji_id,  NULL) gknji_id,
           SUM (DECODE(SIGN(nstzapg.kolicina),1, nstkalkg.pros_cijena,nstkalkg.nab_cijena ) * nstzapg.kolicina ) iznos_nab
      FROM tnst_zapisnici nstzap,
           tnst_zapisnici_gas nstzapg,
           tnst_kalk_gas nstkalkg,
           snst_dokapl nstdokapl,
           m_namirnice nam,
           sgas_opisi_knjizenja gasoknj
     WHERE nstzap.id = nstzapg.nstzap_id
       AND nstzapg.nstkalkg_id = nstkalkg.id
       AND nstzap.nstdokapl_id = nstdokapl.id
       AND (nstdokapl.apl = 'T'
       AND nstdokapl.sifra = '403')
       AND nstzap.datum BETWEEN poc_datum_p AND zav_datum_p
       AND nstzap.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
       AND gasoknj.sifra = '0470'
       AND nam.id(+) = nstzapg.nam_id
     GROUP BY nstzap.mt_id, gasoknj.id, nstdokapl.id, DECODE (gasoknj.ozn_gknji, 'D', nam.gknji_id,  NULL), SIGN(nstzapg.kolicina);


    INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, dokapl_id, gknji_id, iznos)
    
    --
    -- 0390 INVENTURNI VIAK TRGOVAKE ROBE NABAVNA VRIJEDNOST (kao roba na putu)
    --
    SELECT vnsttrgo.mt_id, gasoknj.id, nstdokapl.id, DECODE (gasoknj.ozn_gknji, 'D', nam.gknji_id,  NULL) gknji_id,
           SUM (vnsttrgo.ulaz_nab) iznos_nab
      FROM v_tnst_trgovina vnsttrgo,
           snst_dokapl nstdokapl,
           m_namirnice nam,
           sgas_opisi_knjizenja gasoknj
     WHERE vnsttrgo.dokapl_id = nstdokapl.id
       AND (nstdokapl.apl = 'T'
       AND nstdokapl.sifra = '405')
       AND vnsttrgo.datum BETWEEN poc_datum_p AND zav_datum_p
       AND vnsttrgo.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
       AND gasoknj.sifra = '0390'
       AND nam.id(+) = vnsttrgo.nam_id
     GROUP BY vnsttrgo.mt_id, gasoknj.id, nstdokapl.id, DECODE (gasoknj.ozn_gknji, 'D', nam.gknji_id,  NULL)
    --
     UNION ALL 
    --     
    -- 0430 INVENTURNI MANJAK TRGOVAKE ROBE NA TERET ODGOVORNE OSOBE - PRODAJNA VRIJEDNOST   
    -- 0431 INVENTURNI MANJAK TRGOVAKE ROBE NA TERET PODUZEA - PRODAJNA VRIJEDNOST
    --
    SELECT vnsttrgo.mt_id, gasoknj.id, nstdokapl.id, NULL,
           SUM (vnsttrgo.izlaz_mpc) izlaz
      FROM v_tnst_trgovina vnsttrgo,
           snst_dokapl nstdokapl,
           t_inv_razlike invraz,
           sgas_opisi_knjizenja gasoknj
     WHERE vnsttrgo.dokapl_id = nstdokapl.id
       AND (nstdokapl.apl = 'T'
       AND nstdokapl.sifra = '404')
       AND vnsttrgo.mt_id = invraz.mt_id
       AND vnsttrgo.datum = invraz.datum
       AND vnsttrgo.nam_id = invraz.nam_id
       AND vnsttrgo.datum BETWEEN poc_datum_p AND zav_datum_p
       AND vnsttrgo.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
       AND DECODE(invraz.kol_teret_pc, 0, '0430', '0431') = gasoknj.sifra
     GROUP BY vnsttrgo.mt_id, gasoknj.id, nstdokapl.id
    --
     UNION ALL 
    --     
    -- 0420 INVENTURNI MANJAK TRGOVAKE ROBE NA TERET ODGOVORNE OSOBE - PDV
    -- 0421 INVENTURNI MANJAK TRGOVAKE ROBE NA TERET PODUZEA - PDV   
    --
    SELECT vnsttrgo.mt_id, gasoknj.id, nstdokapl.id, NULL,
           SUM (vnsttrgo.izlaz_porez) iznos_porezi
      FROM v_tnst_trgovina vnsttrgo,
           snst_dokapl nstdokapl, 
           t_inv_razlike invraz,
           sgas_opisi_knjizenja gasoknj
     WHERE vnsttrgo.dokapl_id = nstdokapl.id
       AND (nstdokapl.apl = 'T'
       AND nstdokapl.sifra = '404')
       AND vnsttrgo.mt_id = invraz.mt_id
       AND vnsttrgo.datum = invraz.datum
       AND vnsttrgo.nam_id = invraz.nam_id
       AND vnsttrgo.datum BETWEEN poc_datum_p AND zav_datum_p
       AND vnsttrgo.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
       AND DECODE(invraz.kol_teret_pc, 0, '0420', '0421') = gasoknj.sifra
     GROUP BY vnsttrgo.mt_id, gasoknj.id,  nstdokapl.id
    --
     UNION ALL
    --     
    -- 0410 INVENTURNI MANJAK TRGOVAKE ROBE NA TERET ODGOVORNE OSOBE - RUC 
    -- 0411 INVENTURNI MANJAK TRGOVAKE ROBE NA TERET PODUZEA - RUC 
    --
    SELECT vnsttrgo.mt_id, gasoknj.id, nstdokapl.id, NULL,
           SUM (vnsttrgo.izlaz_ruc) iznos_ruci
      FROM v_tnst_trgovina vnsttrgo,
           snst_dokapl nstdokapl,
           t_inv_razlike invraz,
           sgas_opisi_knjizenja gasoknj
     WHERE vnsttrgo.dokapl_id = nstdokapl.id
       AND (nstdokapl.apl = 'T'
       AND nstdokapl.sifra = '404')
       AND vnsttrgo.mt_id = invraz.mt_id
       AND vnsttrgo.datum = invraz.datum
       AND vnsttrgo.nam_id = invraz.nam_id
       AND vnsttrgo.datum BETWEEN poc_datum_p AND zav_datum_p
       AND vnsttrgo.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
       AND DECODE(invraz.kol_teret_pc, 0, '0410', '0411') = gasoknj.sifra
     GROUP BY vnsttrgo.mt_id, gasoknj.id, nstdokapl.id
    --
     UNION ALL
    --     
    -- 0400 INVENTURNI MANJAK TRGOVAKE ROBE NA TERET ODGOVORNE OSOBE - NABAVNA VRIJEDNOST 
    --
    SELECT vnsttrgo.mt_id, gasoknj.id, nstdokapl.id, DECODE (gasoknj.ozn_gknji, 'D', nam.gknji_id,  NULL) gknji_id,
           SUM(vnsttrgo.izlaz_nab) iznos_nabi
      FROM v_tnst_trgovina vnsttrgo,
           snst_dokapl nstdokapl,
           m_namirnice nam,
           sgas_opisi_knjizenja gasoknj
     WHERE vnsttrgo.dokapl_id = nstdokapl.id
       AND (nstdokapl.apl = 'T'
       AND nstdokapl.sifra = '404')
       AND vnsttrgo.datum BETWEEN poc_datum_p AND zav_datum_p
       AND vnsttrgo.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
       AND gasoknj.sifra = '0400'
       AND nam.id(+) = vnsttrgo.nam_id
     GROUP BY vnsttrgo.mt_id, gasoknj.id, nstdokapl.id, DECODE (gasoknj.ozn_gknji, 'D', nam.gknji_id,  NULL)
    --
     UNION ALL  
    --     
    -- 0430 NEDOZVOLJENI POPUST TRGOVAKE ROBE PRODAJNA VRIJEDNOST
    --
    SELECT vnsttrgo.mt_id, gasoknj.id, nstdokapl.id, NULL,
           SUM (vnsttrgo.izlaz_mpc) izlaz
      FROM v_tnst_trgovina vnsttrgo,
           snst_dokapl nstdokapl,
           sgas_opisi_knjizenja gasoknj
     WHERE vnsttrgo.dokapl_id = nstdokapl.id
       AND (nstdokapl.apl = 'T'
       AND nstdokapl.sifra = '406')
       AND vnsttrgo.datum BETWEEN poc_datum_p AND zav_datum_p
       AND vnsttrgo.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
       AND gasoknj.sifra = '0430'
     GROUP BY vnsttrgo.mt_id, gasoknj.id, nstdokapl.id
    --
     UNION ALL  
    --     
    -- 0420 NEDOZVOLJENI POPUST TRGOVAKE ROBE - PDV
    --
    SELECT vnsttrgo.mt_id, gasoknj.id, nstdokapl.id, NULL,
           SUM (vnsttrgo.izlaz_porez) iznos_porezi
      FROM v_tnst_trgovina vnsttrgo,
           snst_dokapl nstdokapl,
           sgas_opisi_knjizenja gasoknj
     WHERE vnsttrgo.dokapl_id = nstdokapl.id
       AND (nstdokapl.apl = 'T'
       AND nstdokapl.sifra = '406')
       AND vnsttrgo.datum BETWEEN poc_datum_p AND zav_datum_p
       AND vnsttrgo.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
       AND gasoknj.sifra = '0420'
     GROUP BY vnsttrgo.mt_id, gasoknj.id, nstdokapl.id
    --
     UNION ALL 
    --     
    -- 0410 NEDOZVOLJENI POPUST TRGOVAKE ROBE - RUC
    --
    SELECT vnsttrgo.mt_id, gasoknj.id, nstdokapl.id, NULL,
           SUM (vnsttrgo.izlaz_ruc) iznos_ruci
      FROM v_tnst_trgovina vnsttrgo,
           snst_dokapl nstdokapl,
           sgas_opisi_knjizenja gasoknj
     WHERE vnsttrgo.dokapl_id = nstdokapl.id
       AND (nstdokapl.apl = 'T'
       AND nstdokapl.sifra = '406')
       AND vnsttrgo.datum BETWEEN poc_datum_p AND zav_datum_p
       AND vnsttrgo.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
       AND gasoknj.sifra = '0410'
     GROUP BY vnsttrgo.mt_id, gasoknj.id, nstdokapl.id
    --
     UNION ALL 
    --     
    -- 0300 NABAVNA VRIJEDNOST TRGOVAKE ROBE (OTPIS)
    --
    SELECT vnsttrgo.mt_id, gasoknj.id, nstdokapl.id, DECODE (gasoknj.ozn_gknji, 'D', nam.gknji_id,  NULL) gknji_id,
           SUM (vnsttrgo.ulaz_nab) iznos_nab
      FROM v_tnst_trgovina vnsttrgo,
           snst_dokapl nstdokapl,
           m_namirnice nam,
           sgas_opisi_knjizenja gasoknj
     WHERE vnsttrgo.dokapl_id = nstdokapl.id
       AND (nstdokapl.apl = 'T'
       AND nstdokapl.sifra = '407')
       AND vnsttrgo.datum BETWEEN poc_datum_p AND zav_datum_p
       AND vnsttrgo.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
       AND gasoknj.sifra = '0300'
       AND nam.id(+) = vnsttrgo.nam_id
     GROUP BY vnsttrgo.mt_id, gasoknj.id, nstdokapl.id, DECODE (gasoknj.ozn_gknji, 'D', nam.gknji_id,  NULL)
    --
     UNION ALL
    --     
    -- 0480 NABAVNA VRIJEDNOST TRGOVAKE ROBE (ZAMJENA ARTIKALA)- knjii se kao RUC
    --
    SELECT vnsttrgo.mt_id, gasoknj.id, nstdokapl.id, DECODE (gasoknj.ozn_gknji, 'D', nam.gknji_id,  NULL) gknji_id,
           SUM (vnsttrgo.ulaz_nab) iznos_nab
      FROM v_tnst_trgovina vnsttrgo,
           snst_dokapl nstdokapl,
           m_namirnice nam,
           sgas_opisi_knjizenja gasoknj
     WHERE vnsttrgo.dokapl_id = nstdokapl.id
       AND (nstdokapl.apl = 'T'
       AND nstdokapl.sifra = '402')
       AND vnsttrgo.datum BETWEEN poc_datum_p AND zav_datum_p
       AND vnsttrgo.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
       AND gasoknj.sifra = '0480'
       AND nam.id(+) = vnsttrgo.nam_id
     GROUP BY vnsttrgo.mt_id, gasoknj.id, nstdokapl.id, DECODE (gasoknj.ozn_gknji, 'D', nam.gknji_id,  NULL);
      
    --
    INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, dokapl_id, gknji_id, iznos)
    --
    --  0340 NABAVNA VRIJEDNOST TRGOVAKE ROBE U PRIHODU
    --
     SELECT mt, gasoknj.id, dok,  DECODE(gasoknj.ozn_gknji, 'D', gknji_id, NULL) gknji_id,
           SUM(prihod_brutto-obr_pdv-prihod_pdv-marza) iznos_nab
      FROM (
            SELECT mt.id mt, NULL dok, vgrnpro.gknji_id,
                   SUM(obr_realizacija) prihod_brutto,
                   0                     obr_pdv,
                   0                     prihod_pdv,
                   0                     marza
              FROM v_igas_rn_promet vgrnpro,
                   m_mt mt,
                   nst_gas_obrada ob
             WHERE vgrnpro.datum BETWEEN poc_datum_p AND zav_datum_p
               AND vgrnpro.mt_id = mt.id
               AND ob.obrada_gas = 'N'
               AND mt.vrsta IN ( 'P', 'U')
               AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
             GROUP BY mt.id, vgrnpro.gknji_id
             UNION ALL
            SELECT mt.id mt, NULL dok, vgrnpro.gknji_id,
                   0                     prihod_brutto,
                   SUM (obr_pdv)         obr_pdv,
                   0                     prihod_pdv,
                   0                     marza
              FROM v_igas_rn_promet vgrnpro,
                   m_mt mt,
                   nst_gas_obrada ob
             WHERE vgrnpro.datum BETWEEN poc_datum_p AND zav_datum_p
               AND vgrnpro.mt_id = mt.id
               AND ob.obrada_gas = 'N'
               AND mt.vrsta IN ( 'P', 'U')
               AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
             GROUP BY mt.id, NULL, vgrnpro.gknji_id
             UNION ALL
            SELECT mt, dok, gknji_id,
                   0                     prihod_brutto,
                   0                     obr_pdv,
                   SUM (iznos_trgo - iznos_gastro) prihod_pdv,
                   0                     marza
              FROM (SELECT mt.id mt, nstdokapl.id dok, nam.gknji_id,
                           SUM (vnsttrgo.izlaz_porez) iznos_trgo,
                           0 iznos_gastro
                      FROM v_tnst_trgovina vnsttrgo,
                           m_namirnice nam,
                           snst_dokapl nstdokapl,
                           m_mt mt
                     WHERE vnsttrgo.mt_id = mt.id
                       AND vnsttrgo.dokapl_id = nstdokapl.id
                       AND (nstdokapl.apl = 'T'
                       AND nstdokapl.sifra = '301')
                       AND nam.id = vnsttrgo.nam_id
                       AND vnsttrgo.datum BETWEEN poc_datum_p AND zav_datum_p
                       AND vnsttrgo.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
                     GROUP BY mt.id, nstdokapl.id, nam.gknji_id
                     UNION ALL
                    SELECT mt.id mt, nstdokapl.id dok, vgrnpro.gknji_id,
                           0 iznos_trgo,
                           SUM (obr_pdv) iznos_gastro
                      FROM v_igas_rn_promet vgrnpro,
                           snst_dokapl nstdokapl,
                           m_mt mt
                     WHERE vgrnpro.mt_id = mt.id
                       AND mt.vrsta IN ( 'P', 'U')
                       AND (nstdokapl.apl = 'T'
                       AND nstdokapl.sifra = '301')
                       AND vgrnpro.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
                       AND vgrnpro.datum BETWEEN poc_datum_p AND zav_datum_p
                     GROUP BY mt.id, nstdokapl.id, vgrnpro.gknji_id)
             GROUP BY mt, dok, gknji_id
             UNION ALL
            SELECT mt.id mt, nstdokapl.id dok, nam.gknji_id,
                   0                     prihod_brutto,
                   0                     obr_pdv,
                   0                     prihod_pdv,
                   SUM (vnsttrgo.izlaz_ruc) marza
              FROM v_tnst_trgovina vnsttrgo,
                   snst_dokapl nstdokapl,
                   m_namirnice  nam,
                   m_mt mt
             WHERE vnsttrgo.mt_id = mt.id
               AND vnsttrgo.dokapl_id = nstdokapl.id
               AND (nstdokapl.apl = 'T'
               AND nstdokapl.sifra = '301')
               AND vnsttrgo.datum BETWEEN poc_datum_p AND zav_datum_p
               AND nam.id = vnsttrgo.nam_id
               AND vnsttrgo.mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
             GROUP BY mt.id, nstdokapl.id, nam.gknji_id),
                   sgas_opisi_knjizenja gasoknj
             WHERE gasoknj.sifra = '0340'
     GROUP BY mt, gasoknj.id, dok,  DECODE(gasoknj.ozn_gknji, 'D', gknji_id, NULL);

    --
    -- usklaenje salda KP sa iznosom poetnog stanja za sljedeu godinu, 
    -- harkodirano na zavrni datum kalendarske godine  
    -- rauna se kao razlika vrijednosti zalihe iskazane po zadnjoj kalkulaciji i salda po KP unutar kalendarske godine    
    -- knjii se isti nain kao  dokument poetnog stanja, vrijednosti mogu biti i pozitivne i negativne
    -- uobiajeno je da su vrijednosti iskazane na strani RUC i nabavne vrijednosti zbog zaokruivanja 
    -- da bi se koristili ova knjienja pretpostavka je da stanje u FIN jednako stanju u KP
    -- 0510 NABAVNA VRIJEDNOST   
    -- 0520 RUC TRGOVAKE ROBE  
    -- 0530 PDV TRGOVAKE ROBE  
    -- 0540 MALOPRODAJNA VRIJEDNOST TRGOVAKE ROBE 
    -- 
    INSERT INTO pgas_knjizenje (oj_id,  gasoknj_id, iznos)
    
    SELECT mt.id, gasoknj.id,  
           SUM(DECODE(gasoknj.sifra,'0510',a.ulaz_nab   - b.ulaz_nab, 
                                    '0520',a.ulaz_ruc   - b.ulaz_ruc,
                                    '0530',a.ulaz_porez - b.ulaz_porez,                
                                    '0540',a.ulaz_mpc   - b.ulaz_mpc))  iznos
      FROM ( -- zaliha po zadnjoj kalkulaciji
           SELECT mt_id, nam_id, 
                  SUM(pra_nst_zaj.ruc_iznos(
                        pros_cijena,
                        mal_cijena ,
                        stopa_poreza,
                        pnaknada)* kolicina) ulaz_ruc,
                  SUM (kolicina * pros_cijena) ulaz_nab,
                  SUM (pra_nst_zaj.porez_iznos(
                         mal_cijena - pnaknada,
                         stopa_poreza) * kolicina) ulaz_porez,
                  SUM (kolicina * mal_cijena) ulaz_mpc
             FROM (
                   SELECT t.mt_id,
                          t.nam_id,
                          kalk.pros_cijena,
                          kalk.mal_cijena,
                          kalk.stopa_poreza,
                          kalk.pnaknada,
                          SUM(t.kolicina) kolicina
                     FROM tnst_kalk_gas kalk,
                          v_tnst_trgovina t
                    WHERE t.godina = TO_CHAR(TO_DATE(zav_datum_p), 'YYYY')
                      AND t.godina = kalk.godina 
                      AND t.dokapl_id NOT IN (13, 15,16)  -- nedozvoljeni popust na kasi, zapisnik o promjeni poreza i cijena (nisu 'koliinski' dokumenti)
                      AND zaj_obr.vanjsko_mjesto_troska(t.mt_id) = 0
                      AND kalk.mt_id =  t.mt_id
                      AND kalk.nam_id = t.nam_id
                      AND kalk.id = (SELECT MAX(id)
                                       FROM tnst_kalk_gas
                                      WHERE mt_id  = t.mt_id
                                        AND nam_id = t.nam_id
                                        AND godina = t.godina
                                        AND datum <= zav_datum_p
                                        GROUP BY mt_id, nam_id, godina)   -- dodano po prijavi 68456 (rimarina ORA-03113: end-of-file on communication channel) 
                    GROUP BY t.mt_id,
                             t.nam_id,
                             kalk.pros_cijena,
                             kalk.mal_cijena,
                             kalk.stopa_poreza,
                             kalk.pnaknada)
            GROUP BY mt_id,
                     nam_id) a,  
                                                      
          ( -- saldo KP unutar kalendarske godine
          SELECT SUM(t.ulaz_ruc   - t.izlaz_ruc)     ulaz_ruc,
                 SUM(t.ulaz_nab   - t.izlaz_nab)     ulaz_nab,
                 SUM(t.ulaz_porez - t.izlaz_porez) ulaz_porez,
                 SUM(t.ulaz_mpc   - t.izlaz_mpc)     ulaz_mpc,
                 t.mt_id,
                 t.nam_id
            FROM v_tnst_trgovina t
           WHERE t.godina = TO_CHAR(TO_DATE(zav_datum_p), 'YYYY')
           GROUP BY t.mt_id,
                    t.nam_id) b,                 
           m_mt mt,
           sgas_opisi_knjizenja gasoknj
     WHERE mt.id = a.mt_id
       AND a.mt_id = b.mt_id
       and a.nam_id = b.nam_id
       AND TO_CHAR (TO_DATE(zav_datum_p), 'DDMM') =  '3112'
       AND mt.id IN (SELECT ID FROM (SELECT ROWNUM, ID FROM m_mt WHERE pra_zmp.oj_pripada_oj (ID, tem.oj_id) = -1))
       AND gasoknj.sifra IN ('0510', '0520', '0530', '0540')
     GROUP BY mt.id, gasoknj.id; 
    --       
    -- knjienje povratne naknade   
    -- 0800 -- POVRATNA NAKNADA - ULAZ
    --
    INSERT INTO pgas_knjizenje (oj_id, gasoknj_id, dokapl_id, iznos)       
    
    SELECT mt_id, opisi.id, dokapl_id, SUM(NVL(iznos_pnaknade,0))
      FROM v_tnst_trgovina gat, 
           sgas_opisi_knjizenja opisi          
     WHERE gat.datum BETWEEN poc_datum_p AND zav_datum_p
       AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
       AND opisi.sifra  =   '0800' 
       AND dokapl_id NOT IN (6,8,11,15,16 )  -- promet kase, poetno stanjem, inventurni manjak, promjena cijena i promjena poreza
     GROUP BY gat.mt_id, opisi.id, dokapl_id    
    --
     UNION ALL     
    --
    -- 0801 -- POVRATNA NAKNADA - IZLAZ 
    --
    /* povratna naknada po knjizi popisa
    SELECT mt_id, opisi.id, dokapl_id, SUM(NVL(iznos_pnaknade,0))
      FROM v_tnst_trgovina gat, 
           sgas_opisi_knjizenja opisi          
     WHERE gat.datum BETWEEN poc_datum_p AND zav_datum_p
       AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
       AND opisi.sifra  =   '0801'  
       AND dokapl_id IN (6)   -- promet kase  
     GROUP BY gat.mt_id, opisi.id, dokapl_id 
    */                                  
    
    /* povratna naknada po prometu sa kase, mogue je da je zaboravljena oznaka 'P' u dodatnom nazivu pa
       e nastupiti razlika po prometu i po KP
    */
    SELECT mt_id, opisi.id, 6, SUM(NVL(iznos_pnaknade,0))
      FROM t_rnkase rn, 
           t_rnkase_pro rnpro, 
           sgas_opisi_knjizenja opisi          
     WHERE rn.datum BETWEEN poc_datum_p AND zav_datum_p
       AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
       AND rn.id = rnpro.rn_id
       AND opisi.sifra  =   '0801'  
     GROUP BY rnpro.mt_id, opisi.id   
    --
     UNION ALL          
    --
    -- 0802 -- POVRATNA NAKNADA - INV. MANJAK -- knjii se na dva konta jer nema realizacije prihoda
    --    
    SELECT mt_id, opisi.id, dokapl_id, SUM(NVL(iznos_pnaknade,0))
      FROM v_tnst_trgovina gat, 
           sgas_opisi_knjizenja opisi          
     WHERE gat.datum BETWEEN poc_datum_p AND zav_datum_p
       AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
       AND opisi.sifra  =   '0802'  
       AND dokapl_id IN (11)   -- inventurni manjak 
     GROUP BY gat.mt_id, opisi.id, dokapl_id 
    --
     UNION ALL
    -- 
    -- STORNO OPISA '0801' za raune za vlastitu potronju - specifino samo Uljanik, vezano uz licencu
    --
    SELECT mt_id, opisi.id, 8, SUM( rnpro.iznos_pnaknade) * -1
      FROM t_rnkase rn,
           t_rnkase_pro rnpro,
           s_vplacanja vpla,
           sgas_opisi_knjizenja opisi,
           sgas_vlasnik vlasnik
     WHERE rn.id = rnpro.rn_id
       AND rn.vpla_id = vpla.id
       AND rn.datum BETWEEN poc_datum_p AND zav_datum_p
       AND rn.vpla_id IN (SELECT id FROM s_vplacanja WHERE sifra IN ('53','57'))
       AND mt_id IN (SELECT id FROM (SELECT ROWNUM, id FROM m_mt WHERE pra_zmp.oj_pripada_oj (id, tem.oj_id) = -1))
       AND opisi.sifra  = '0801'
       AND vlasnik.br_licence = 'GAS20197'
     GROUP BY rnpro.mt_id, opisi.id,8;
  END LOOP;
END KNJIZENJE_TRGO;
PROCEDURE INSERT_SA_CVORA
 (METCVOR_SIFRA_P IN smet_cvorovi.sifra%TYPE
 ,POC_DATUM_P IN DATE
 ,ZAV_DATUM_P IN DATE
 )
 IS
   oj_vlasnik_l    m_mt.sifra%TYPE;
   naredba_l       VARCHAR2(32000);
   br_licence_l    sgas_vlasnik.br_licence%TYPE;
BEGIN     
  /* Za isti opis knjienja ne moe istodobno biti popunjenja vrsta_MT i vpla_id.
     Vrsta MT se opcionalno koristi kod prijelaza, a vrsta plaanja za knjienje  napalte */         
  /* Zadnja dva SQL upita slue za knjienje na RC (Opera), a 3. i 4.imaju uvjet   AND gasknjpom.opera_rc_id IS  NULL */    

    naredba_l :=
    'INSERT INTO igas_knjizenje (
       dat_poc, dat_zav, oj_sifra, gasoknj_sifra, oj_vlasnik,
       gasoknj_naziv, konto, duguje, potrazuje, oznaka, oznaka_knji, dokapl_id)
     SELECT :1,
            :2,
            oj.sifra,
            gasoknj_sifra,
            oj1.sifra,
            SUBSTR(DECODE (dok, NULL, gasoknj_naziv||DECODE(vrsta,''U'',''-T'',''G'',''-G'',''O'',''-O'', NULL),
					     substr (gasoknj_naziv||DECODE(vrsta,''U'',''-T'',''G'',''-G'',''O'',''-O'', NULL), 1, 16) || '' - '' || dokapl.naziv_knjizenje),1,40),
            NVL(zmpkon.sifra,''----------''),
            duguje,
            potrazuje,
            DECODE(vrsta,''X'', ''T'', oznaka),
            ''N'',
            dok
       FROM (
       --
       -- openita i specifina pravila, konto1, H-objekt
       --
             SELECT NVL(gaspknj.ojk_id, gasknjpom.oj_id) oj_id, gaspknj.oj_id vlasnik,
                    gasknjpom.dokapl_id dok, gaspknj.zmpkon1_id konto, gaspknj.gasoknj_id gasoknj_id,
                    gaspknj.gasoknj_sifra gasoknj_sifra, gaspknj.gasoknj_naziv, 
                    gaspknj.gasoknj_oznaka oznaka, gasknjpom.vrsta vrsta,
                    SUM (DECODE (gaspknj.dug_pot_1, ''D'', gasknjpom.iznos * DECODE(gaspknj.predznak_1,''+'',1,-1), 0)) duguje,
                    SUM (DECODE (gaspknj.dug_pot_1, ''P'', gasknjpom.iznos * DECODE(gaspknj.predznak_1,''+'',1,-1), 0)) potrazuje
               FROM pgas_knjizenje' || metcvor_sifra_p || ' gasknjpom,
                    v_mgas_pravila gaspknj
              WHERE gasknjpom.iznos <> 0
                AND gaspknj.vrsta_mt = ''H''
                AND gaspknj.gasoknj_id = gasknjpom.gasoknj_id
                AND gaspknj.vpla_id IS NULL
                AND gaspknj.gmpkom_id IS NULL
                AND NVL (gasknjpom.gknji_id, 0) =  NVL (gaspknj.gknji_id, 0)
                AND NVL (gasknjpom.gnac_id, 0)  =  NVL (gaspknj.gnac_id, 0)
                AND NVL (gasknjpom.vpla_id, 0)  =  NVL (gaspknj.vpla_id, 0)
                AND pra_zmp.oj_pripada_oj (gasknjpom.oj_id, gaspknj.oj_id) = -1
              GROUP BY
                    NVL (gaspknj.ojk_id, gasknjpom.oj_id), gaspknj.oj_id,
                    gasknjpom.dokapl_id, gaspknj.zmpkon1_id, gaspknj.gasoknj_id,
                    gaspknj.gasoknj_sifra,  gaspknj.gasoknj_naziv, gaspknj.gasoknj_oznaka, gasknjpom.vrsta
             --
             UNION ALL
             --
             -- openita i specifina pravila, konto2, H-objekt
             --
             SELECT NVL (gaspknj.ojk_id, gasknjpom.oj_id) oj_id, gaspknj.oj_id vlasnik,
                    gasknjpom.dokapl_id dok, gaspknj.zmpkon2_id konto, gaspknj.gasoknj_id gasoknj_id,
                    gaspknj.gasoknj_sifra gasoknj_sifra, gaspknj.gasoknj_naziv,  
                    gaspknj.gasoknj_oznaka oznaka, gasknjpom.vrsta vrsta,
                    SUM (DECODE (gaspknj.dug_pot_2,''D'', gasknjpom.iznos *  DECODE(gaspknj.predznak_2,''+'',1,-1), 0)) duguje,
                    SUM (DECODE (gaspknj.dug_pot_2,''P'', gasknjpom.iznos *  DECODE(gaspknj.predznak_2,''+'',1,-1), 0)) potrazuje
               FROM pgas_knjizenje'|| metcvor_sifra_p || ' gasknjpom,
                    v_mgas_pravila gaspknj             
              WHERE gasknjpom.iznos <> 0
                AND gaspknj.zmpkon2_id IS NOT NULL
                AND gaspknj.vrsta_mt = ''H''
                AND gaspknj.gasoknj_id = gasknjpom.gasoknj_id
                AND gaspknj.vpla_id IS NULL
                AND gaspknj.gmpkom_id IS NULL
                AND NVL (gasknjpom.gknji_id, 0) =  NVL (gaspknj.gknji_id, 0)
                AND NVL (gasknjpom.gnac_id, 0)  =  NVL (gaspknj.gnac_id, 0)
                AND NVL (gasknjpom.vpla_id, 0)  =  NVL (gaspknj.vpla_id, 0)
                AND pra_zmp.oj_pripada_oj (gasknjpom.oj_id, gaspknj.oj_id) = -1
              GROUP BY
                    NVL (gaspknj.ojk_id, gasknjpom.oj_id), gaspknj.oj_id,
                    gasknjpom.dokapl_id, gaspknj.zmpkon2_id, gaspknj.gasoknj_id,
                    gaspknj.gasoknj_sifra, gaspknj.gasoknj_naziv, gaspknj.gasoknj_oznaka, gasknjpom.vrsta
             --
             UNION ALL
             --
             -- pravila komitenti, konto1, H-objekt
             -- 
             SELECT NVL (gaspknj.ojk_id, gasknjpom.oj_id) oj_id, gaspknj.oj_id vlasnik,
                    gasknjpom.dokapl_id dok, gaspknj.zmpkon1_id konto, gaspknj.gasoknj_id gasoknj_id,
                    gaspknj.gasoknj_sifra gasoknj_sifra, gaspknj.gasoknj_naziv ||''-''||SUBSTR(gmpkom.naziv,1,29) gasoknj_naziv,
                    gaspknj.gasoknj_oznaka oznaka, gasknjpom.vrsta vrsta,
                    SUM (DECODE (gaspknj.dug_pot_1, ''D'', gasknjpom.iznos * DECODE(gaspknj.predznak_1,''+'',1,-1), 0)) duguje,
                    SUM (DECODE (gaspknj.dug_pot_1, ''P'', gasknjpom.iznos * DECODE(gaspknj.predznak_1,''+'',1,-1), 0)) potrazuje
               FROM pgas_knjizenje' || metcvor_sifra_p || ' gasknjpom,
                    v_mgas_pravila gaspknj,
                    mgmp_komitenti gmpkom
              WHERE gasknjpom.iznos <> 0
                AND gaspknj.vrsta_mt = ''H''
                AND gaspknj.gasoknj_id = gasknjpom.gasoknj_id
                AND gasknjpom.gmpkom_id = gmpkom.id
                AND gasknjpom.gmpkom_id = gaspknj.gmpkom_id
                AND NVL (gasknjpom.gknji_id, 0) =  NVL (gaspknj.gknji_id, 0)
                AND NVL (gasknjpom.gnac_id, 0)  =  NVL (gaspknj.gnac_id, 0)
                AND NVL (gasknjpom.vpla_id, 0)  =  NVL (gaspknj.vpla_id, 0)
                AND pra_zmp.oj_pripada_oj (gasknjpom.oj_id, gaspknj.oj_id) = -1
              GROUP BY
                    NVL (gaspknj.ojk_id, gasknjpom.oj_id), gaspknj.oj_id,
                    gasknjpom.dokapl_id, gaspknj.zmpkon1_id, gaspknj.gasoknj_id,
                    gaspknj.gasoknj_sifra,  gaspknj.gasoknj_naziv ||''-''||SUBSTR(gmpkom.naziv,1,29), 
                    gaspknj.gasoknj_oznaka, gasknjpom.vrsta
             --
             UNION ALL
             --
             -- pravila komitenti, konto2, H-objekt
             --
             SELECT NVL (gaspknj.ojk_id, gasknjpom.oj_id) oj_id, gaspknj.oj_id vlasnik,
                    gasknjpom.dokapl_id dok, gaspknj.zmpkon2_id konto, gaspknj.gasoknj_id gasoknj_id,
                    gaspknj.gasoknj_sifra gasoknj_sifra,  gaspknj.gasoknj_naziv ||''-''||SUBSTR(gmpkom.naziv,1,29),  
                    gaspknj.gasoknj_oznaka oznaka, gasknjpom.vrsta vrsta,
                    SUM (DECODE (gaspknj.dug_pot_2,''D'', gasknjpom.iznos *  DECODE(gaspknj.predznak_2,''+'',1,-1), 0)) duguje,
                    SUM (DECODE (gaspknj.dug_pot_2,''P'', gasknjpom.iznos *  DECODE(gaspknj.predznak_2,''+'',1,-1), 0)) potrazuje
               FROM pgas_knjizenje'|| metcvor_sifra_p || ' gasknjpom,
                    v_mgas_pravila gaspknj,
                    mgmp_komitenti gmpkom
              WHERE gasknjpom.iznos <> 0
                AND gaspknj.zmpkon2_id IS NOT NULL
                AND gaspknj.vrsta_mt = ''H''
                AND gaspknj.gasoknj_id = gasknjpom.gasoknj_id
                AND gasknjpom.gmpkom_id = gmpkom.id
                AND gasknjpom.gmpkom_id = gaspknj.gmpkom_id
                AND NVL (gasknjpom.gknji_id, 0) =  NVL (gaspknj.gknji_id, 0)
                AND NVL (gasknjpom.gnac_id, 0)  =  NVL (gaspknj.gnac_id, 0)
                AND NVL (gasknjpom.vpla_id, 0)  =  NVL (gaspknj.vpla_id, 0)
                AND pra_zmp.oj_pripada_oj (gasknjpom.oj_id, gaspknj.oj_id) = -1
              GROUP BY
                    NVL (gaspknj.ojk_id, gasknjpom.oj_id), gaspknj.oj_id,
                    gasknjpom.dokapl_id, gaspknj.zmpkon2_id, gaspknj.gasoknj_id,
                    gaspknj.gasoknj_sifra,  gaspknj.gasoknj_naziv ||''-''||SUBSTR(gmpkom.naziv,1,29), gaspknj.gasoknj_oznaka, gasknjpom.vrsta
             --
             UNION ALL
             --
             -- pravila vrsta plaanja, konto1, H-objekt
             --
            SELECT NVL (gaspknj.ojk_id, gasknjpom.oj_id) oj_id, gaspknj.oj_id vlasnik,
                    gasknjpom.dokapl_id dok, gaspknj.zmpkon1_id konto, gaspknj.gasoknj_id gasoknj_id,
                    gaspknj.gasoknj_sifra gasoknj_sifra, gaspknj.gasoknj_naziv ||''-''||SUBSTR(vpla.naziv,1,29) gasoknj_naziv,
                    gaspknj.gasoknj_oznaka oznaka, gasknjpom.vrsta vrsta,
                    SUM (DECODE (gaspknj.dug_pot_1, ''D'', gasknjpom.iznos * DECODE(gaspknj.predznak_1,''+'',1,-1), 0)) duguje,
                    SUM (DECODE (gaspknj.dug_pot_1, ''P'', gasknjpom.iznos * DECODE(gaspknj.predznak_1,''+'',1,-1), 0)) potrazuje
               FROM pgas_knjizenje' || metcvor_sifra_p || ' gasknjpom,
                    v_mgas_pravila gaspknj,
                    s_vplacanja vpla
              WHERE gasknjpom.iznos <> 0
                AND gaspknj.vrsta_mt = ''H''
                AND gaspknj.gasoknj_id = gasknjpom.gasoknj_id
                AND vpla.id =  gasknjpom.vpla_id
                AND NVL (gasknjpom.gknji_id, 0) =  NVL (gaspknj.gknji_id, 0)
                AND NVL (gasknjpom.gnac_id, 0)  =  NVL (gaspknj.gnac_id, 0)
                AND NVL (gasknjpom.vpla_id, 0)  =  NVL (gaspknj.vpla_id, 0)
                AND pra_zmp.oj_pripada_oj (gasknjpom.oj_id, gaspknj.oj_id) = -1
              GROUP BY
                    NVL (gaspknj.ojk_id, gasknjpom.oj_id), gaspknj.oj_id,
                    gasknjpom.dokapl_id, gaspknj.zmpkon1_id, gaspknj.gasoknj_id,
                    gaspknj.gasoknj_sifra, gaspknj.gasoknj_naziv ||''-''||SUBSTR(vpla.naziv,1,29),
                    gaspknj.gasoknj_oznaka, gasknjpom.vrsta
             --
             UNION ALL
             --
             -- pravila vrsta plaanja, konto2, H-objekt
             --
             SELECT NVL (gaspknj.ojk_id, gasknjpom.oj_id) oj_id, gaspknj.oj_id vlasnik,
                    gasknjpom.dokapl_id dok, gaspknj.zmpkon2_id konto, gaspknj.gasoknj_id gasoknj_id,
                    gaspknj.gasoknj_sifra gasoknj_sifra,DECODE(vpla.naziv, NULL, gaspknj.gasoknj_naziv, gaspknj.gasoknj_naziv ||''-''||SUBSTR(vpla.naziv,1,29)) gasoknj_naziv,
                    gaspknj.gasoknj_oznaka oznaka, gasknjpom.vrsta vrsta,
                    SUM (DECODE (gaspknj.dug_pot_2,''D'', gasknjpom.iznos *  DECODE(gaspknj.predznak_2,''+'',1,-1), 0)) duguje,
                    SUM (DECODE (gaspknj.dug_pot_2,''P'', gasknjpom.iznos *  DECODE(gaspknj.predznak_2,''+'',1,-1), 0)) potrazuje
               FROM pgas_knjizenje'|| metcvor_sifra_p || ' gasknjpom,
                    v_mgas_pravila gaspknj,
                    s_vplacanja vpla
              WHERE gasknjpom.iznos <> 0
                AND gaspknj.zmpkon2_id IS NOT NULL
                AND gaspknj.vrsta_mt = ''H''
                AND gaspknj.gasoknj_id = gasknjpom.gasoknj_id
                AND vpla.id   =  gasknjpom.vpla_id
                AND NVL (gasknjpom.gknji_id, 0) =  NVL (gaspknj.gknji_id, 0)
                AND NVL (gasknjpom.gnac_id, 0)  =  NVL (gaspknj.gnac_id, 0)
                AND NVL (gasknjpom.vpla_id, 0)  =  NVL (gaspknj.vpla_id, 0)
                AND pra_zmp.oj_pripada_oj (gasknjpom.oj_id, gaspknj.oj_id) = -1
              GROUP BY
                    NVL (gaspknj.ojk_id, gasknjpom.oj_id), gaspknj.oj_id,
                    gasknjpom.dokapl_id, gaspknj.zmpkon2_id, gaspknj.gasoknj_id,
                    gaspknj.gasoknj_sifra,DECODE(vpla.naziv, NULL, gaspknj.gasoknj_naziv, gaspknj.gasoknj_naziv ||''-''||SUBSTR(vpla.naziv,1,29)),
                    gaspknj.gasoknj_oznaka, gasknjpom.vrsta
             --
             UNION ALL
             --
             --
             --  openita i specifina pravila, konto1, bez RC, vrsta mjesta troka (<>H)
             --
             SELECT NVL (gaspknj.ojk_id, gasknjpom.oj_id) oj_id,
                    gaspknj.oj_id vlasnik, gasknjpom.dokapl_id dok, gaspknj.zmpkon1_id konto, gaspknj.gasoknj_id gasoknj_id,
                    gaspknj.gasoknj_sifra gasoknj_sifra, gaspknj.gasoknj_naziv gasoknj_naziv,
                    gaspknj.gasoknj_oznaka oznaka, gasknjpom.vrsta vrsta,
                    SUM (DECODE (gaspknj.dug_pot_1, ''D'',
                         DECODE (gaspknj.gasoknj_sifra, ''0170'',
                            DECODE (SIGN (gasknjpom.iznos), 0, gasknjpom.iznos * DECODE(gaspknj.predznak_1,''+'',1,-1) * -1,
                                    gasknjpom.iznos * DECODE(gaspknj.predznak_1,''+'',1,-1)),
                            gasknjpom.iznos * DECODE(gaspknj.predznak_1,''+'',1,-1)),
                         0)) duguje,
                    SUM (DECODE (gaspknj.dug_pot_1, ''P'',
                         DECODE (gaspknj.gasoknj_sifra, ''0170'',
                            DECODE (SIGN (gasknjpom.iznos), 0, gasknjpom.iznos *  DECODE(gaspknj.predznak_1,''+'',1,-1) * -1,
                                    gasknjpom.iznos * DECODE(gaspknj.predznak_1,''+'',1,-1)),
                            gasknjpom.iznos * DECODE(gaspknj.predznak_1,''+'',1,-1)),
                       0)) potrazuje
               FROM pgas_knjizenje' || metcvor_sifra_p || ' gasknjpom,
                    v_mgas_pravila  gaspknj,
                    m_mt mt
              WHERE gasknjpom.iznos <> 0
                AND gaspknj.vrsta_mt <> ''H''
                AND mt.id = gasknjpom.oj_id
                AND gaspknj.vrsta_mt = mt.vrsta
                AND gasknjpom.opera_rc_id IS  NULL
                AND gaspknj.gasoknj_id = gasknjpom.gasoknj_id
                AND NVL(gasknjpom.gknji_id, 0) =  NVL (gaspknj.gknji_id, 0)
                AND NVL(gasknjpom.gnac_id, 0)  =  NVL (gaspknj.gnac_id, 0)
                AND NVL(gasknjpom.vpla_id, 0)  =  NVL (gaspknj.vpla_id, 0)
                AND pra_zmp.oj_pripada_oj (gasknjpom.oj_id, gaspknj.oj_id) = -1
              GROUP BY
                    NVL (gaspknj.ojk_id, gasknjpom.oj_id),
                    gaspknj.oj_id, gasknjpom.dokapl_id, gaspknj.zmpkon1_id, gaspknj.gasoknj_id,
                    gaspknj.gasoknj_sifra, gaspknj.gasoknj_naziv,
                    gaspknj.gasoknj_oznaka, gasknjpom.vrsta
             --
             UNION ALL
             --
             --  openita i specifina pravila, konto2, bez RC, vrsta mjesta troka (<> H-objekt)
             --
             --
             SELECT NVL (gaspknj.ojk_id, gasknjpom.oj_id) oj_id,
                    gaspknj.oj_id vlasnik, gasknjpom.dokapl_id dok, gaspknj.zmpkon2_id konto, gaspknj.gasoknj_id gasoknj_id,
                    gaspknj.gasoknj_sifra gasoknj_sifra, gaspknj.gasoknj_naziv gasoknj_naziv,
                    gaspknj.gasoknj_oznaka oznaka, gasknjpom.vrsta vrsta,
                    SUM (DECODE (gaspknj.dug_pot_2, ''D'',
                            DECODE (gaspknj.gasoknj_sifra, ''0170'',
                              DECODE (SIGN (gasknjpom.iznos), 0, gasknjpom.iznos * DECODE(gaspknj.predznak_2,''+'',1,-1) * -1,
                                   gasknjpom.iznos * DECODE(gaspknj.predznak_2,''+'',1,-1)),
                           gasknjpom.iznos * DECODE(gaspknj.predznak_2,''+'',1,-1)),
                       0)) duguje,
                    SUM (DECODE (gaspknj.dug_pot_2, ''P'',
                          DECODE (gaspknj.gasoknj_sifra, ''0170'',
                            DECODE (SIGN (gasknjpom.iznos),0, gasknjpom.iznos * DECODE(gaspknj.predznak_2,''+'',1,-1) * -1,
                                  gasknjpom.iznos * DECODE(gaspknj.predznak_2,''+'',1,-1)),
                             gasknjpom.iznos * DECODE(gaspknj.predznak_2,''+'',1,-1)),
                       0)) potrazuje
               FROM pgas_knjizenje' || metcvor_sifra_p || ' gasknjpom,
                    v_mgas_pravila gaspknj,
                    m_mt mt                
              WHERE gasknjpom.iznos <> 0
                AND gaspknj.zmpkon2_id IS NOT NULL
                AND gaspknj.vrsta_mt <> ''H''
                AND mt.id = gasknjpom.oj_id
                AND gaspknj.vrsta_mt = mt.vrsta
                AND gasknjpom.opera_rc_id IS NULL
                AND gaspknj.gasoknj_id = gasknjpom.gasoknj_id
                AND NVL(gasknjpom.gknji_id, 0) =  NVL (gaspknj.gknji_id, 0)
                AND NVL(gasknjpom.gnac_id, 0)  =  NVL (gaspknj.gnac_id, 0)
                AND NVL(gasknjpom.vpla_id, 0)  =  NVL (gaspknj.vpla_id, 0)
                AND pra_zmp.oj_pripada_oj (gasknjpom.oj_id, gaspknj.oj_id) = -1
              GROUP BY
                    NVL (gaspknj.ojk_id, gasknjpom.oj_id), gaspknj.oj_id,
                    gasknjpom.dokapl_id, gaspknj.zmpkon2_id, gaspknj.gasoknj_id,
                    gaspknj.gasoknj_sifra, gaspknj.gasoknj_naziv,
                    gaspknj.gasoknj_oznaka, gasknjpom.vrsta
             UNION ALL
             --
             --  openita i specifina pravila, konto1, sa RC, vrsta mjesta troka (<> H-objekt)
             --
             SELECT NVL (gaspknj.ojk_id, gasknjpom.opera_rc_id) oj_id,
                    gaspknj.oj_id vlasnik, gasknjpom.dokapl_id dok, gaspknj.zmpkon1_id konto, gaspknj.gasoknj_id gasoknj_id,
                    gaspknj.gasoknj_sifra gasoknj_sifra, gaspknj.gasoknj_naziv gasoknj_naziv,
                    gaspknj.gasoknj_oznaka oznaka, gasknjpom.vrsta vrsta,
                    SUM (DECODE (gaspknj.dug_pot_1, ''D'',
                         DECODE (gaspknj.gasoknj_sifra, ''0170'',
                            DECODE (SIGN (gasknjpom.iznos), 0, gasknjpom.iznos * DECODE(gaspknj.predznak_1,''+'',1,-1) * -1,
                                    gasknjpom.iznos * DECODE(gaspknj.predznak_1,''+'',1,-1)),
                            gasknjpom.iznos * DECODE(gaspknj.predznak_1,''+'',1,-1)),
                         0)) duguje,
                    SUM (DECODE (gaspknj.dug_pot_1, ''P'',
                         DECODE (gaspknj.gasoknj_sifra, ''0170'',
                            DECODE (SIGN (gasknjpom.iznos), 0, gasknjpom.iznos *  DECODE(gaspknj.predznak_1,''+'',1,-1) * -1,
                                    gasknjpom.iznos * DECODE(gaspknj.predznak_1,''+'',1,-1)),
                            gasknjpom.iznos * DECODE(gaspknj.predznak_1,''+'',1,-1)),
                       0)) potrazuje
               FROM pgas_knjizenje' || metcvor_sifra_p || ' gasknjpom,
                    v_mgas_pravila  gaspknj,
                    m_mt mt
              WHERE gasknjpom.iznos <> 0
                AND gaspknj.vrsta_mt <> ''H''
                AND mt.id = gasknjpom.oj_id
                AND gaspknj.vrsta_mt = mt.vrsta
                AND gaspknj.gasoknj_id = gasknjpom.gasoknj_id
                AND gasknjpom.opera_rc_id IS NOT NULL
                AND NVL(gasknjpom.gknji_id, 0) =  NVL (gaspknj.gknji_id, 0)
                AND NVL(gasknjpom.gnac_id, 0)  =  NVL (gaspknj.gnac_id, 0)
                AND NVL(gasknjpom.vpla_id, 0)  =  NVL (gaspknj.vpla_id, 0)
                AND pra_zmp.oj_pripada_oj (gasknjpom.oj_id, gaspknj.oj_id) = -1
              GROUP BY
                    NVL (gaspknj.ojk_id, gasknjpom.opera_rc_id),
                    gaspknj.oj_id, gasknjpom.dokapl_id, gaspknj.zmpkon1_id, gaspknj.gasoknj_id,
                    gaspknj.gasoknj_sifra, gaspknj.gasoknj_naziv,
                    gaspknj.gasoknj_oznaka, gasknjpom.vrsta
             --
             UNION ALL
             --
             -- openita i specifina pravila, konto2, sa RC, vrsta mjesta troka (<> H-objekt)
             --
             SELECT  NVL (gaspknj.ojk_id, gasknjpom.opera_rc_id) oj_id,
                    gaspknj.oj_id vlasnik, gasknjpom.dokapl_id dok, gaspknj.zmpkon2_id konto, gaspknj.gasoknj_id gasoknj_id,
                    gaspknj.gasoknj_sifra gasoknj_sifra, gaspknj.gasoknj_naziv gasoknj_naziv,
                    gaspknj.gasoknj_oznaka oznaka, gasknjpom.vrsta vrsta,
                    SUM (DECODE (gaspknj.dug_pot_2, ''D'',
                            DECODE (gaspknj.gasoknj_sifra, ''0170'',
                              DECODE (SIGN (gasknjpom.iznos), 0, gasknjpom.iznos * DECODE(gaspknj.predznak_2,''+'',1,-1) * -1,
                                   gasknjpom.iznos * DECODE(gaspknj.predznak_2,''+'',1,-1)),
                           gasknjpom.iznos * DECODE(gaspknj.predznak_2,''+'',1,-1)),
                       0)) duguje,
                    SUM (DECODE (gaspknj.dug_pot_2, ''P'',
                          DECODE (gaspknj.gasoknj_sifra, ''0170'',
                            DECODE (SIGN (gasknjpom.iznos),0, gasknjpom.iznos * DECODE(gaspknj.predznak_2,''+'',1,-1) * -1,
                                  gasknjpom.iznos * DECODE(gaspknj.predznak_2,''+'',1,-1)),
                             gasknjpom.iznos * DECODE(gaspknj.predznak_2,''+'',1,-1)),
                       0)) potrazuje
               FROM pgas_knjizenje' || metcvor_sifra_p || ' gasknjpom,
                    v_mgas_pravila gaspknj,
                    m_mt mt
              WHERE gasknjpom.iznos <> 0
                AND gaspknj.zmpkon2_id IS NOT NULL
                AND gaspknj.vrsta_mt <> ''H''
                AND mt.id = gasknjpom.oj_id
                AND gaspknj.vrsta_mt = mt.vrsta
                AND gaspknj.gasoknj_id = gasknjpom.gasoknj_id
                AND gasknjpom.opera_rc_id IS NOT NULL
                AND NVL(gasknjpom.gknji_id, 0) =  NVL (gaspknj.gknji_id, 0)
                AND NVL(gasknjpom.gnac_id, 0)  =  NVL (gaspknj.gnac_id, 0)
                AND NVL(gasknjpom.vpla_id, 0)  =  NVL (gaspknj.vpla_id, 0)
                AND pra_zmp.oj_pripada_oj (gasknjpom.oj_id, gaspknj.oj_id) = -1
              GROUP BY
                    NVL (gaspknj.ojk_id, gasknjpom.opera_rc_id), gaspknj.oj_id,
                    gasknjpom.dokapl_id, gaspknj.zmpkon2_id, gaspknj.gasoknj_id,
                    gaspknj.gasoknj_sifra, gaspknj.gasoknj_naziv,
                    gaspknj.gasoknj_oznaka, gasknjpom.vrsta 
            --
            UNION ALL        
            --
            --     za prihode(1) i trokove(9) ako ne postoje pravila postavlja se za konto ''--------''
            --  
            SELECT gasknjpom.oj_id                           oj_id,
                   pra_zmp_s.oj_zmpojr_id (gasknjpom.oj_id, :3, :4, ''GAS'') vlasnik,
                   gasknjpom.dokapl_id                       dok,
                   NULL                                      konto,
                   gasknjpom.gasoknj_id                      gasoknj_id,
                   opisi.sifra                               gasoknj_sifra,
                   opisi.naziv                               gasoknj_naziv,
                   opisi.oznaka                              oznaka,
                   gasknjpom.vrsta                           vrsta,
                   SUM(DECODE(opisi.id,1,0,gasknjpom.iznos)) duguje,
                   SUM(gasknjpom.iznos)                      potrazuje
              FROM pgas_knjizenje ' || metcvor_sifra_p || '  gasknjpom,
                   m_mt           mt,
                   sgas_opisi_knjizenja opisi
             WHERE gasknjpom.iznos <> 0
               AND gasknjpom.gasoknj_id IN (1, 9) -- za prihode i trokove
               AND gasknjpom.gasoknj_id = opisi.id
               AND mt.id = gasknjpom.oj_id
               AND gasknjpom.opera_rc_id IS NULL
               AND NOT EXISTS
                   (SELECT NULL
                      FROM v_mgas_pravila gaspknj
                     WHERE gaspknj.vrsta_mt = mt.vrsta   
                       AND gaspknj.gasoknj_id = gasknjpom.gasoknj_id
                       AND NVL(gasknjpom.gknji_id, 0) = NVL(gaspknj.gknji_id, 0)
                       AND NVL(gasknjpom.gnac_id, 0) = NVL(gaspknj.gnac_id, 0))
             GROUP BY 
                   gasknjpom.oj_id,
                   gasknjpom.oj_id,
                   gasknjpom.dokapl_id,
                   gasknjpom.vrsta,
                   gasknjpom.gasoknj_id, 
                   opisi.sifra,
                   opisi.naziv,
                   opisi.oznaka
            ) unija,
            snst_dokapl dokapl,
            m_oj oj,
            m_oj oj1,
            mzmp_konta zmpkon
      WHERE oj.id = unija.oj_id
        AND zmpkon.id (+) = unija.konto   -- za prihode i trokove iako nema pravila za konto stavljamo --------
        AND oj1.id = unija.vlasnik
        AND dokapl.id (+) = unija.dok';   -- nemaju svi dogaaji dokumente
   EXECUTE IMMEDIATE naredba_l USING poc_datum_p, zav_datum_p, poc_datum_p, zav_datum_p;
                                                                   
                                                                   
                                                                   
   /* specifino za DVS, radi se alociranje trokova na drugu oj */ 
   SELECT br_licence INTO br_licence_l FROM sgas_vlasnik;
   
   IF br_licence_l = 'GAS-C0038' THEN
      UPDATE igas_knjizenje 
         SET oj_sifra = SUBSTR(oj_sifra,1, 4)
       WHERE SUBSTR(konto,1,1) IN ('4', '7');
   END IF;
  
    
   /* specifino za: HNB jer su MT proglaena kao knjige raune, pa se javlja kao da nije proknjien konto   
       AHG - ne knjie sve iz GASTRA, prihodi iz Opere
   */
   IF UPPER (pra_zmp_zaj.tekuci_cvor) IN ( 'HNBGASTRO', 'ATCENTAR') THEN 
      DELETE igas_knjizenje 
      WHERE konto = '----------';
   END IF;
    
   /* specifino za Hotel Lovran, knjienje radi LRH
      knjienje ulaza  grupirano po datumu i komitentu
   */ 
   br_licence_l := UPPER (pra_pka_zaj.vrijednost_parametra ('1049'));
  
   IF br_licence_l <> 'GLAS' THEN
      RETURN;
   END IF;

   DELETE igas_knjizenje WHERE gasoknj_sifra = '0030';
   
   INSERT INTO igas_knjizenje (
       dat_poc, dat_zav, oj_sifra, gasoknj_sifra,
       oj_vlasnik, gasoknj_naziv,
       konto, duguje, potrazuje, oznaka, oznaka_knji)
   SELECT poc_datum_p, zav_datum_p, mt.sifra,
         '0030', gaspknj.oj_sifra, gasknjpom.naziv,
          zmpkon1_sifra konto,
          SUM (DECODE (gaspknj.dug_pot_1, 'D', gasknjpom.iznos * DECODE(gaspknj.predznak_1,'+',1,-1), 0)) duguje,
          SUM (DECODE (gaspknj.dug_pot_1, 'P', gasknjpom.iznos * DECODE(gaspknj.predznak_1,'+',1,-1), 0)) potrazuje, 'T', 'N'
     FROM (
            SELECT ulaz.mt_id oj_id,  60 gasoknj_id,
                  SUM(ROUND(kolicina * ROUND(((nab_cijena * (1 - rabat / 100))),2),2)) iznos,
                  DECODE(opisi.ozn_gknji, 'D', DECODE(sir_id,NULL, nam.gknji_id, bm_gas3130.sir_gknji_id (sir.id))) gknji_id,   
                  rbr||'-'|| TO_CHAR(ulaz.datum,'DD.MM.YY') ||' - '||gmpkom.sifra naziv
             FROM t_ulazdok ulaz,
                  t_ulazdok_art ulazart,
                  m_sirovine sir,
                  m_namirnice nam,
                  sgas_opisi_knjizenja opisi,
                  mgmp_komitenti gmpkom
             WHERE ulaz.datum BETWEEN  poc_datum_p AND zav_datum_p
               AND ulaz.id = ulazart.ulaz_id
               AND ulazart.sir_id = sir.id(+)
               AND ulazart.nam_id = nam.id(+)
               AND ulaz.dob_id = gmpkom.id
               AND ulaz.id = ulazart.ulaz_id
               AND ulaz.dob_id IS NOT NULL
               AND opisi.sifra = '0030'
             GROUP BY ulaz.mt_id,  60,
                  DECODE(opisi.ozn_gknji, 'D', DECODE(sir_id,NULL, nam.gknji_id, bm_gas3130.sir_gknji_id (sir.id))),
                      rbr||'-'|| TO_CHAR(ulaz.datum,'DD.MM.YY') ||' - '||gmpkom.sifra
                    )
           gasknjpom,
           v_mgas_pravila  gaspknj,
           m_mt mt
    WHERE gasknjpom.iznos <> 0
      AND gaspknj.vrsta_mt <> 'H'
      AND mt.id = gasknjpom.oj_id
      AND gaspknj.zmpkon1_id IS NOT NULL
      AND gaspknj.vrsta_mt = mt.vrsta
      AND gaspknj.gasoknj_id = gasknjpom.gasoknj_id
      AND NVL(gasknjpom.gknji_id, 0) =  NVL (gaspknj.gknji_id, 0)
      AND pra_zmp.oj_pripada_oj (gasknjpom.oj_id, gaspknj.oj_id) = -1
    GROUP BY poc_datum_p, zav_datum_p, mt.sifra, '0030',
          gaspknj.oj_sifra, gasknjpom.naziv, zmpkon1_sifra, 'T', 'N'
       --
    UNION ALL
       --
   SELECT poc_datum_p, zav_datum_p, mt.sifra, '0030',
          gaspknj.oj_sifra, gasknjpom.naziv,
          zmpkon2_sifra konto,
          SUM (DECODE (gaspknj.dug_pot_2, 'D', gasknjpom.iznos * DECODE(gaspknj.predznak_2,'+',1,-1), 0)) duguje,
          SUM (DECODE (gaspknj.dug_pot_2, 'P', gasknjpom.iznos * DECODE(gaspknj.predznak_2,'+',1,-1), 0)) potrazuje, 'T', 'N'
     FROM (
            SELECT ulaz.mt_id oj_id, 60 gasoknj_id,
                  SUM(ROUND(kolicina * ROUND(((nab_cijena * (1 - rabat / 100))),2),2)) iznos,
                  DECODE(opisi.ozn_gknji, 'D', DECODE(sir_id,NULL, nam.gknji_id, bm_gas3130.sir_gknji_id (sir.id))) gknji_id,
                  rbr||'-'|| TO_CHAR(ulaz.datum,'DD.MM.YY') ||' - '||gmpkom.sifra  naziv
             FROM t_ulazdok ulaz,
                  t_ulazdok_art ulazart,
                  m_sirovine sir,  
                  m_namirnice nam,
                  sgas_opisi_knjizenja opisi,
                  mgmp_komitenti gmpkom
         WHERE ulaz.datum BETWEEN  poc_datum_p AND zav_datum_p
               AND ulaz.id = ulazart.ulaz_id
               AND ulazart.sir_id = sir.id(+) 
               AND ulazart.nam_id = nam.id(+)
               AND ulaz.dob_id = gmpkom.id
               AND ulaz.id = ulazart.ulaz_id
               AND ulaz.dob_id IS NOT NULL
               AND opisi.sifra = '0030'
            GROUP BY ulaz.mt_id, opisi.id,
                    DECODE(opisi.ozn_gknji, 'D', DECODE(sir_id,NULL, nam.gknji_id, bm_gas3130.sir_gknji_id (sir.id))),
                     rbr||'-'|| TO_CHAR(ulaz.datum,'DD.MM.YY') ||' - '||gmpkom.sifra
                      )
             gasknjpom,
             v_mgas_pravila gaspknj,
             m_mt mt
    WHERE gasknjpom.iznos <> 0
      AND gaspknj.zmpkon2_id IS NOT NULL
      AND gaspknj.vrsta_mt <> 'H'
      AND mt.id = gasknjpom.oj_id
      AND gaspknj.vrsta_mt = mt.vrsta
      AND gaspknj.gasoknj_id = gasknjpom.gasoknj_id
      AND NVL(gasknjpom.gknji_id, 0) =  NVL (gaspknj.gknji_id, 0)
      AND pra_zmp.oj_pripada_oj (gasknjpom.oj_id, gaspknj.oj_id) = -1
    GROUP BY poc_datum_p, zav_datum_p, mt.sifra, '0030',
          gaspknj.oj_sifra, gasknjpom.naziv, zmpkon2_sifra, 'T', 'N'
    ORDER BY 2;               
END;
PROCEDURE PROVJERI_DO_I_INV
 (POC_DATUM_P IN DATE
 ,ZAV_DATUM_P IN DATE
 )
 IS
naredba_l VARCHAR2 (2000);
poruka_za_gresku_1_L    VARCHAR2 (2000);
datum_do_l   DATE;
datum_inv_l   DATE;
datum_inv_dok_l DATE;
BEGIN     
   /* Provjera da li je napravljen dnevni obraun */
   FOR metins IN (
     SELECT ins.metcvor_sifra
       FROM smet_instalacije ins,
            smet_cvorovi cvor,
            mzmp_ojr ojr
      WHERE ins.metapl_sifra = 'GAS'
        AND LOWER (ins.metcvor_sifra) <> LOWER (pra_zmp_zaj.tekuci_cvor)
        AND ins.metcvor_sifra = cvor.sifra
        AND ojr.metcvor_sifra_gas = ins.metcvor_sifra  
        AND pra_zmp_s2.dopustena_oj (USER, ojr.id) =  -1 
        AND cvor.ozn_u_mrezi  = -1 
      ORDER BY ins.metcvor_sifra)
   LOOP
      IF replikacija.cvor_je_podcentar (metins.metcvor_sifra) = 0 THEN
         naredba_l :=
         '  SELECT MAX (datum)'  ||
         '    FROM l_obracun' || '@' || metins.metcvor_sifra ||
         '   WHERE oznaka = ''00'' ';      
		
         EXECUTE IMMEDIATE naredba_l INTO datum_do_l;

         IF zav_datum_p > NVL (datum_do_l, zav_datum_p - 1)  THEN
            poruka_za_gresku_1_l := poruka_za_gresku_1_l || ' ' || metins.metcvor_sifra;
         ELSE  
            naredba_l := 
            ' SELECT MAX (datum)'   ||
            '   FROM l_obracun' || '@' || metins.metcvor_sifra ||
            '  WHERE oznaka = ''40'' ';      
            EXECUTE IMMEDIATE naredba_l INTO datum_inv_l; 
         
            naredba_l := 
            ' SELECT MAX (datum)'     ||
            '   FROM t_inventura'     || '@' || metins.metcvor_sifra ||' inv,'||   
            '        t_inventura_art' || '@' || metins.metcvor_sifra || 
            '  WHERE inv.id = inv_id'     ||
            '    AND datum <=  :zav_datum_p';      
            EXECUTE IMMEDIATE naredba_l INTO datum_inv_dok_l USING zav_datum_p;
            IF datum_inv_dok_l > NVL(datum_inv_l, zav_datum_p - 1) THEN
               poruka_za_gresku_1_l := poruka_za_gresku_1_l || ' ' || metins.metcvor_sifra;
            END IF;
         END IF;
     END IF;
   END LOOP;

   IF poruka_za_gresku_1_l IS NOT NULL THEN
      /* Nije napravljen dnevni obraun ili obraun inventure: #0.*/
      gas_zaj.vrati_poruku (-20229, poruka_za_gresku_1_l);
   END IF; 
END;
PROCEDURE PROVJERI_OPISE_I_PRAVILA
 IS
 brojac_l NUMBER;
BEGIN
  /* Provjerva se usklaenost opisa knjienja (ozn_gnac i ozn_gknji) sa podacima u
     mgas_pravila_knjizenja i mgas_pravila_knjiz_oj */
   FOR opisi IN
      (SELECT id, sifra, naziv, ozn_gknji, ozn_gnac
         FROM sgas_opisi_knjizenja)
   LOOP
      SELECT COUNT(*) INTO brojac_l
        FROM mgas_pravila_knjizenja gasknj
       WHERE opisi.id = gasknj.gasoknj_id
         AND ((opisi.ozn_gnac  = 'D' AND gasknj.gnac_id  IS NULL)
	      OR  (opisi.ozn_gnac  = 'N' AND gasknj.gnac_id  IS NOT NULL)
	      OR  (opisi.ozn_gknji = 'D' AND gasknj.gknji_id IS NULL)
          OR  (opisi.ozn_gknji = 'N' AND gasknj.gknji_id IS NOT NULL));
     IF brojac_l > 0  THEN 
         /* Nisu usklaeni opisi knjienja i pravila knjienja (grupe naina potronje i knjigovodstvene grupe).*/
         gas_zaj.vrati_poruku (-20337);
     END IF;
   END LOOP;
   FOR opisi IN
      (SELECT id, sifra, naziv, ozn_gknji, ozn_gnac
         FROM sgas_opisi_knjizenja)
   LOOP
      SELECT COUNT(*) INTO brojac_l
        FROM mgas_pravila_knjiz_oj gasknj
       WHERE opisi.id = gasknj.gasoknj_id
         AND ((opisi.ozn_gnac  = 'D' AND gasknj.gnac_id  IS NULL)
	      OR  (opisi.ozn_gnac  = 'N' AND gasknj.gnac_id  IS NOT NULL)
	      OR  (opisi.ozn_gknji = 'D' AND gasknj.gknji_id IS NULL)
          OR  (opisi.ozn_gknji = 'N' AND gasknj.gknji_id IS NOT NULL));
     IF brojac_l > 0  THEN   
         /* Nisu usklaeni opisi knjienja i pravila knjienja (grupe naina potronje i knjigovodstvene grupe).*/
         gas_zaj.vrati_poruku (-20337);
     END IF;
   END LOOP;
 END;
FUNCTION SIR_GKNJI_ID
 (SIR_ID_P IN NUMBER
 )
 RETURN NUMBER
 IS
sir_gknji_id_l NUMBER;
BEGIN
    SELECT MAX (nam.gknji_id)
      INTO sir_gknji_id_l
      FROM m_rastav ras,
           m_namirnice nam
     WHERE ras.sir_id = sir_id_p
       AND ras.nam_id = nam.id;

    RETURN sir_gknji_id_l;
 END;
PROCEDURE PRIJEPIS_HNB
 (VRSTA_PRIJEPISA_P IN VARCHAR2
 )
 IS
   dat_poc_l DATE;
   DAT_ZAV_L DATE;
   brojac_l  NUMBER;
   naredba_l   VARCHAR2(20000);
BEGIN
 SELECT count(*) INTO brojac_l
   FROM igas_knjizenje                                            
  WHERE oznaka_knji = 'N';                                        
  
   IF brojac_l = 0 THEN
      raise_application_error (-20000, '         Nema podataka za prijepis');
   END IF;
  
   SELECT MIN(dat_poc), MIN(dat_zav)
     INTO dat_poc_l, dat_zav_l
     FROM igas_knjizenje;
      
      
   -- knjiga IRA  
   -- HNB nema PPOT
   IF vrsta_prijepisa_p IS NULL or vrsta_prijepisa_p = 'P'  THEN  -- za tip temeljnice trokovi se ne prepisuje knjiga IRA     
    naredba_l := 
     'INSERT INTO hnbrkr
      SELECT  ''HNB''                                                           -- poduzece
              ,TO_CHAR (tem.datum2, ''YYYY'')                                   -- godina
              ,''015'' broj_knjige_ira                                          -- broj_knjige_ira
              ,mt.sifra                                                         -- poslovni_partner
              ,tem.datum2                                                       -- datum_fakture
              ,MIN(rbr)||'' ''||MAX(rbr)                                        -- racun
              ,SUM(rnpro.iznos)                                                 -- iznos_ukupno
              ,ROUND(SUM(DECODE(pdv, 13, 100 * (iznos_pdv)/(pdv),0)),2)         -- iznos_osnovica_10
              ,ROUND(SUM(DECODE(pdv, 5,  100 * (iznos_pdv)/(pdv),0)),2)         -- iznos_osnovica_22
              ,ROUND(SUM(DECODE(pdv, 25, 100 * (iznos_pdv)/(pdv),0)),2)         -- iznos_osnovica_23
              ,SUM(DECODE(pdv, 13,iznos_pdv, 0))                                -- iznos_porez_10
              ,SUM(DECODE(pdv, 5, iznos_pdv,(DECODE(pdv, 23, iznos_pdv,0))))    -- iznos_porez_22
              ,SUM(DECODE(pdv, 25,iznos_pdv,0))                                 -- iznos_porez_23
              ,SUM(0)                                                           -- iznos_osl_o
              ,SUM(0)                                                           -- iznos_osl_izvoz
              ,SUM(0)                                                           -- iznos_osl_ostalo,
              ,SUM(DECODE(pdv, 0,iznos,0))                                      -- iznos_osl_stopa_0,
              ,SUM(0)                                                           -- iznos_osl_poseb_isp
              ,SUM(0)                                                           -- iznos_oslo_prol_st
              ,''1''                                                            -- oznaka_maloprod
              ,''POS RAUNI''||'' ''||mt.naziv                                  -- naziv diokumenta
              ,0                                                                -- status
        FROM  t_rnkase rn,
              t_rnkase_pro rnpro, 
              m_mt mt,
              m_proizvodi pro,
              (SELECT MIN(dat_poc) datum1,
                      MIN(dat_zav) datum2
                 FROM igas_knjizenje
                WHERE oznaka_knji = ''N'') tem
        WHERE rn.id = rnpro.rn_id
          AND rn.datum BETWEEN tem.datum1 AND tem.datum2
          AND rnpro.mt_id = mt.id
          AND rnpro.pro_id = pro.id(+)
        GROUP BY  ''   '',
              TO_CHAR (tem.datum2, ''YYYY''),
              mt.sifra,
              tem.datum2,
              ''POS RAUNI''||'' ''||mt.naziv,
              DECODE(pro_id, NULL, 1, DECODE(pro.ozn_proizvoda, ''1'', 1, ''2'', 1, ''3'', 2, ''4'', 2))';
              
          EXECUTE IMMEDIATE naredba_l;
   END IF;
   -- temeljnica    
   naredba_l :=
   'INSERT INTO hnbrfin
   SELECT   konto                                       -- konto
           ,DECODE (duguje, 0, ''P'', ''D'')            -- ozn
           ,DECODE (duguje, 0, potrazuje, duguje)       -- iznos
           ,NULL                                        -- valuta
           ,0                                           -- iznos_dev
           ,NULL                                        -- pp
           ,rnal                                        -- rnal
           ,radnik                                      -- radnik
           ,oj                                          -- oj
           ,mj_tros                                     -- mj_tros
           ,objekt                                      -- objekt
           ,NULL                                        -- skl
           ,NULL                                        -- racun
           ,NULL                                        -- re
           ,TO_CHAR((SELECT  distinct(dat_zav)  FROM igas_knjizenje),''DDMMYYYY'') -- dat_rac
           ,''* ''                                      -- uvj_pla
           ,opis                                        -- opis
           ,naz_dok                                     -- naziv dokumenta
           ,0                                           -- status
           ,radnik_reprez                               -- radnik_reprez
     FROM
        /* Knjienje direktnog troka 0130 -izlaz, 0170 - korekcija, 0160 otpis */
          (SELECT gasoknj_naziv naz_dok,
                  konto,
                  SUM (duguje) duguje,
                  SUM (potrazuje) potrazuje,
                  ''.'' rnal,
                  NULL radnik,
                  ''015'' oj,
                  NULL mj_tros,
                  NULL objekt,
                  SUBSTR (TO_CHAR (a.dat_poc,''MMYYYY'') ||'' '' ||oj.naziv,1,20) opis,
                  NULL radnik_reprez
             FROM igas_knjizenje a,
                  m_oj oj
            WHERE gasoknj_sifra IN (''0130'', ''0160'',''0170'')
              AND (:vrsta_prijepisa_p IS NULL or :vrsta_prijepisa_p = ''T'')
              AND oj.sifra = a.oj_sifra
              AND oznaka_knji = ''N''
            GROUP BY gasoknj_naziv , konto, ''.'', NULL, ''015'', oj.sifra,    SUBSTR (TO_CHAR (a.dat_poc,''MMYYYY'') ||'' '' ||oj.naziv,1,20)
           ---
            UNION
           ---
             -- Knjienje  prihoda, pdv (0010, 0100, 0110, 0111, 0112, 0113, 0115, 0116
             SELECT (TO_CHAR (a.dat_poc,''MMYYYY'') ||'' '' ||''PRIHODI''||'' '' ||oj.naziv )   naz_dok,
                    konto,
                    SUM (duguje) duguje,
                    SUM (potrazuje) potrazuje,
                    ''.'' rnal,
                    NULL radnik,
                    NULL oj,
                    NULL mj_tros,
                    NULL objekt,
                    SUBSTR (TO_CHAR (a.dat_poc,''MMYYYY'') ||'' '' ||oj.naziv,1,20) opis,
                    NULL radnik_reprez
               FROM igas_knjizenje a,
                    m_oj oj
              WHERE gasoknj_sifra IN (''0010'', ''0100'', ''0110'', ''0111'',''0112'', ''0113'', ''0115'', ''0116'')
                AND (:vrsta_prijepisa_p IS NULL or :vrsta_prijepisa_p = ''P'')
                AND oj.sifra = a.oj_sifra
                AND oznaka_knji = ''N''
              GROUP BY  (TO_CHAR (a.dat_poc,''MMYYYY'') ||'' '' ||''PRIHODI''||'' '' ||oj.naziv ),konto,  NULL, NULL, NULL, NULL,  SUBSTR (TO_CHAR (a.dat_poc,''MMYYYY'') ||'' '' ||oj.naziv,1,20)
           ---
              UNION
           ---
            /* Potrana strana  reprezentacije i vode razlika je samo u objektu   */
            SELECT a.gasoknj_naziv naz_dok,
                   konto,
                   SUM (duguje) duguje,
                   SUM (potrazuje) potrazuje,
                   ''.'' rnal,
                   NULL radnik,
                   NULL oj,
                   ''.'' mj_tros,
                   DECODE(gasoknj_sifra, ''0080'',''311'',''522'') objekt,
                   SUBSTR (TO_CHAR (a.dat_poc,''MMYYYY'') ||'' '' ||oj.naziv,1,20)  opis,
                   NULL radnik_reprez
              FROM igas_knjizenje a,
                   m_oj oj
             WHERE gasoknj_sifra IN (''0080'', ''0090'')
               AND potrazuje <> 0
               AND (:vrsta_prijepisa_p IS NULL or :vrsta_prijepisa_p = ''P'' )
               AND oj.sifra = a.oj_sifra
               AND oznaka_knji = ''N''
             GROUP BY gasoknj_naziv, konto,  ''.'', oj_vlasnik, NULL, SUBSTR (TO_CHAR (a.dat_poc,''MMYYYY'') ||'' '' ||oj.naziv,1,20) , ''.'', DECODE(gasoknj_sifra, ''0080'',''311'',''522'') 
           ---
              UNION
           ---                   
          
            /* Napitci za savjet  */
            SELECT a.gasoknj_naziv naz_dok,
                   konto,
                   SUM (duguje) duguje,
                   SUM (potrazuje) potrazuje,
                   ''.'' rnal,
                   NULL radnik,
                   NULL oj,
                   ''.'' mj_tros,
                   NULL objekt,
                   SUBSTR (TO_CHAR (a.dat_poc,''MMYYYY'') ||'' '' ||oj.naziv,1,20)  opis,
                   NULL radnik_reprez
              FROM igas_knjizenje a,
                   m_oj oj
             WHERE gasoknj_sifra IN (''0700'')
               AND (:vrsta_prijepisa_p IS NULL or :vrsta_prijepisa_p = ''P'' )
               AND oj.sifra = a.oj_sifra
               AND oznaka_knji = ''N''
             GROUP BY gasoknj_naziv, konto,  ''.'', oj_vlasnik, NULL, SUBSTR (TO_CHAR (a.dat_poc,''MMYYYY'') ||'' '' ||oj.naziv,1,20) , ''.'',  ''522''   
          ---
             UNION
          ---
            /*Knjienje troka  reprezentacije i troka vode po osobama */
            SELECT a.gasoknj_naziv naz_dok,
                   konto,
                   SUM (b.iznos) duguje,
                   SUM (0) potrazuje,
                   ''.'' rnal,
                   b.pkaadr_sifra radnik,
                   b.oj,
                   ''.'' mj_tros,
                   DECODE(a.gasoknj_sifra,''0080'',''311'',''0090'',''522'', null) objekt,
                   ime opis,
                   b.pkaadr_sifra1 radnik_reprez   -- radnik reprezentacija
               FROM igas_knjizenje a,
                    (SELECT SUBSTR(pkaadr.ime  ||'' '' ||pkaadr.prezime,1,20) ime,
                            SUBSTR(pkaadr.rbr,3,4) pkaadr_sifra,
                            SUBSTR(pkaadr.rbr,1,2) pkaadr_sifra1,
                            pkaadr.oib oj,
                            oj.sifra oj_sifra,
                            SUM (iznos) iznos,
                            DECODE (vpla.sifra,''24'', ''0080'',''0090'') gasoknj_sifra
                       FROM tpka_rnkasa pkarn,
                            t_rnkase rn,
                            t_rnkase_pro rnpro,
                            mpka_adrese pkaadr,
                            s_vplacanja vpla,
                            m_oj oj
                      WHERE pkarn.rbr  = rn.rbr
                        AND pkarn.gmpkas_id  = rn.kase_id
                        AND pkarn.god_poslovna   = rn.godina
                        AND pkarn.datum  = rn.datum
                        AND rn.id = rnpro.rn_id
                        AND rn.vpla_id = vpla.id
                        AND rnpro.mt_id = oj.id
                        AND vpla.sifra IN  (''24'', ''41'')
                        AND rn.datum BETWEEN :dat_poc_l   AND  :dat_zav_l
                        AND pkarn.pkaadr_id = pkaadr.id
                      GROUP BY SUBSTR(pkaadr.ime  ||'' '' ||pkaadr.prezime,1,20) , SUBSTR(pkaadr.rbr,3,4),SUBSTR(pkaadr.rbr,1,2), pkaadr.oib,
                            oj.sifra,DECODE (vpla.sifra,''24'', ''0080'',''0090'')) b
              WHERE a.oj_vlasnik = b.oj_sifra
                AND a.duguje <> 0
                AND a.gasoknj_sifra IN (''0080'', ''0090'')
                AND a.gasoknj_sifra = b.gasoknj_sifra
                AND (:vrsta_prijepisa_p IS NULL or :vrsta_prijepisa_p = ''P'')
                AND oznaka_knji = ''N''
                AND b.iznos <> 0
              GROUP BY  a.gasoknj_naziv,
                        konto,
                        ''.'',
                        b.pkaadr_sifra,
                        b.oj,
                        ''.'',
                        DECODE(a.gasoknj_sifra,''0080'',''311'',''0090'',''522'', null),
                        ime,
                        b.pkaadr_sifra1)';
      EXECUTE IMMEDIATE naredba_l USING vrsta_prijepisa_p, vrsta_prijepisa_p, vrsta_prijepisa_p, vrsta_prijepisa_p, vrsta_prijepisa_p, vrsta_prijepisa_p,
                        vrsta_prijepisa_p, vrsta_prijepisa_p, dat_poc_l, dat_zav_l, vrsta_prijepisa_p, vrsta_prijepisa_p;
      UPDATE igas_knjizenje
         SET oznaka_knji = 'D'
       WHERE oznaka = NVL(vrsta_prijepisa_p, oznaka);
COMMIT;
END;
PROCEDURE PRIJEPIS_PLACA_HNB
 (P_DATUM_1 IN IGAS_KNJIZENJE.DAT_POC%TYPE
 ,P_DATUM_2 IN IGAS_KNJIZENJE.DAT_POC%TYPE
 )
 IS
naredba_l   VARCHAR2(20000);
   gas_param_1073_l szmp_parametri.vrijednost%TYPE;
BEGIN
  naredba_l := 'DELETE hnbpla';
  EXECUTE IMMEDIATE naredba_l;
  
  IF pra_zmp_zaj.zmppar_vrijednost ('GAS','1073') <> 'nebitno' THEN
     gas_param_1073_l := pra_zmp_zaj.zmppar_vrijednost ('GAS','1073');
     gas_param_1073_l := ' AND adr.rbr NOT LIKE ''' || gas_param_1073_l || '%''';
  END IF; 
  
  /* Ako zaboravi kartica i korisnik zna  svoju ifru ==> tpka_rnkasa */
  /* Ako ide preko PREPAID kartice                    ==> tpka_kar_rnk */
  
  naredba_l :=
  'INSERT INTO hnbpla
   SELECT sifra,
         ''189'',
         SUM (iznos_popusta) iznos_popusta
    FROM
     (SELECT SUBSTR(adr.rbr,3,4) sifra,
             SUM (iznos_popust) iznos_popusta
        FROM tpka_rnkasa pkarn,
             t_rnkase rn,
             t_rnkase_pro rnpro,
             mpka_adrese adr
       WHERE pkarn.rbr  = rn.rbr
         AND pkarn.gmpkas_id= rn.kase_id
         AND pkarn.god_poslovna  = rn.godina
         AND rnpro.iznos_popust <> 0
         AND rn.id = rnpro.rn_id
         AND pkarn.pkaadr_id = adr.id 
         '||  gas_param_1073_l  ||'
         AND rn.datum BETWEEN :p_datum1 AND :p_datum2
         AND rn.id  NOT IN  (SELECT rn1.id
                               FROM t_rnkase rn1, t_rnkase_pro rnpro1, m_proizvodi pro
                              WHERE rn1.datum  BETWEEN :p_datum_1 AND :p_datum_2
                                AND rn1.id = rnpro1.rn_id
                                AND rnpro1.pro_id = pro.id (+)
                                AND ozn_proizvoda IN (''3'',''4''))
         AND (ozn_izvorni = -1 or ozn_izvorni IS NULL)
       GROUP BY
         SUBSTR(adr.rbr,3,4)
     UNION ALL
      SELECT SUBSTR(adr.rbr,3,4) sifra,
             SUM (iznos_popust) iznos_popusta
        FROM tpka_kar_rnk  pkarn,
             tpka_kartice pkakar,
             t_rnkase rn,
             t_rnkase_pro rnpro,
             m_proizvodi pro,
             mpka_adrese adr
       WHERE pkarn.rbr  = rn.rbr
         AND pkarn.gmpkas_id = rn.kase_id
         AND pkarn.god_poslovna  = rn.godina
         AND pkarn.pkakar_id = pkakar.id
         AND rnpro.iznos_popust <> 0
         AND rn.id = rnpro.rn_id
         AND pkakar.pkaadr_id = adr.id  
         '||  gas_param_1073_l  ||'
         AND rn.datum BETWEEN :p_datum_1 AND :p_datum_2
         AND rnpro.pro_id = pro.id (+)
         AND pro.ozn_proizvoda NOT IN (''3'',''4'')
         AND pkakar.ozn_prepaid = -1
       GROUP BY
         SUBSTR(adr.rbr,3,4))
  GROUP BY
        SIFRA,
        ''189''
  ORDER BY 1
  ';
     EXECUTE IMMEDIATE naredba_l USING  p_datum_1, p_datum_2 ,p_datum_1, p_datum_2, p_datum_1, p_datum_2;    
     
   naredba_l :=
  'INSERT INTO hnbpla
   SELECT sifra,
         ''178'',
         SUM (iznos_popusta) iznos_popusta
    FROM
     (SELECT SUBSTR(adr.rbr,3,4) sifra,
             SUM (iznos_popust2) iznos_popusta
        FROM tpka_rnkasa pkarn,
             t_rnkase rn,
             t_rnkase_pro rnpro,
             mpka_adrese adr
       WHERE pkarn.rbr  = rn.rbr
         AND pkarn.gmpkas_id= rn.kase_id
         AND pkarn.god_poslovna  = rn.godina
         AND rnpro.iznos_popust2 <> 0
         AND rn.id = rnpro.rn_id
         AND pkarn.pkaadr_id = adr.id 
         '||  gas_param_1073_l  ||'
         AND rn.datum BETWEEN :p_datum1 AND :p_datum2
         AND rn.id  NOT IN  (SELECT rn1.id
                               FROM t_rnkase rn1, t_rnkase_pro rnpro1, m_proizvodi pro
                              WHERE rn1.datum  BETWEEN :p_datum_1 AND :p_datum_2
                                AND rn1.id = rnpro1.rn_id
                                AND rnpro1.pro_id = pro.id (+)
                                AND ozn_proizvoda IN (''3'',''4''))
         AND (ozn_izvorni = -1 or ozn_izvorni IS NULL)
       GROUP BY
         SUBSTR(adr.rbr,3,4)
     UNION ALL
      SELECT SUBSTR(adr.rbr,3,4) sifra,
             SUM (iznos_popust2) iznos_popusta
        FROM tpka_kar_rnk  pkarn,
             tpka_kartice pkakar,
             t_rnkase rn,
             t_rnkase_pro rnpro,
             m_proizvodi pro,
             mpka_adrese adr
       WHERE pkarn.rbr  = rn.rbr
         AND pkarn.gmpkas_id = rn.kase_id
         AND pkarn.god_poslovna  = rn.godina
         AND pkarn.pkakar_id = pkakar.id
         AND rnpro.iznos_popust2 <> 0
         AND rn.id = rnpro.rn_id
         AND pkakar.pkaadr_id = adr.id  
         '||  gas_param_1073_l  ||'
         AND rn.datum BETWEEN :p_datum_1 AND :p_datum_2
         AND rnpro.pro_id = pro.id (+)
         AND pro.ozn_proizvoda NOT IN (''3'',''4'')
         AND pkakar.ozn_prepaid = -1
       GROUP BY
         SUBSTR(adr.rbr,3,4))
  GROUP BY
        SIFRA,
        ''178''
  ORDER BY 1
  ';
     EXECUTE IMMEDIATE naredba_l USING  p_datum_1, p_datum_2 ,p_datum_1, p_datum_2, p_datum_1, p_datum_2;    
     
     COMMIT;
END;

END BM_GAS3130;
/
SHOW ERROR

