-- D:\mish_CVS\misH_skripte\bm_gas3050.pkb
--
-- Generated for Oracle 10g on Fri Oct 24  09:50:32 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'BM_GAS3050'
CREATE OR REPLACE PACKAGE BODY BM_GAS3050 IS
 

DATUM_M DATE;
OBRADA_U_TOKU_M BOOLEAN := FALSE;

PROCEDURE PRIJEPIS_STARE_INVENTURE
 (MT_ID_P NUMBER
 ,OZN_INVENTURE_P IN VARCHAR
 );
PROCEDURE OBRADA_ULAZA_IZLAZA
 (MT_ID_P NUMBER
 );
PROCEDURE PRERACUN_INV_STANJA
 (MT_ID_P NUMBER
 ,ID_P NUMBER
 );
PROCEDURE PRERACUN_SIROVINE
 (MT_ID_P NUMBER
 ,SIR_ID_P NUMBER
 ,KOL_INVENTURA_P NUMBER
 ,ODNOS_JM_B_P NUMBER
 ,ODNOS_JM_N_P NUMBER
 );
PROCEDURE PRERACUN_PROIZVODA
 (MT_ID_P NUMBER
 ,PRO_ID_P NUMBER
 ,KOL_INVENTURA_P NUMBER
 );
PROCEDURE PRERACUN_NAMIRNICE
 (MT_ID_P NUMBER
 ,NAM_ID_P NUMBER
 ,KOL_INVENTURA_P NUMBER
 );
PROCEDURE IZRACUN_INVENTURNIH_RAZLIKA
 (MT_ID_P NUMBER
 );
PROCEDURE IZRACUN_ZALIHA;
PROCEDURE IZRACUNAJ_INVENTURU_TRGOVINE
 (DATUM_P DATE
 );
PROCEDURE RAZRADA_INV_RAZLIKA
 (MT_ID_P IN M_MT.ID%TYPE
 );
FUNCTION PC_NAMIRNICE
 (MT_ID_P IN NUMBER
 ,NAM_ID_P IN NUMBER
 )
 RETURN NUMBER;


PROCEDURE PRIJEPIS_STARE_INVENTURE
 (MT_ID_P NUMBER
 ,OZN_INVENTURE_P IN VARCHAR
 )
 IS

   dat_zadnji_oiart_L DATE;
BEGIN
   /* trai datum zadnje inventure */
   SELECT MAX (datum) INTO dat_zadnji_oiart_L
     FROM i_inv_ui
    WHERE mt_id = mt_id_P
      AND datum < datum_M;

   IF dat_zadnji_oiart_L IS NOT NULL THEN
      /* kreiraj retke nove inventure na temelju redaka zadnje inventure */
      FOR inv IN (
         SELECT nam_id, kol_zav_stanje, izn_zav_stanje
           FROM i_inv_ui
          WHERE mt_id = mt_id_P
            AND datum = dat_zadnji_oiart_L)
      LOOP
         INSERT INTO i_inv_ui (
            mt_id, nam_id, datum,
            kol_poc_stanje,
            kol_ulaz, kol_izlaz,
            kol_int_ulaz, kol_int_izlaz,
            kol_storno_izlaz_sup, kol_izlaz_sup,
            kol_dnev_otpis, kol_inv_razlika, kol_zav_stanje,
            izn_poc_stanje,
            izn_ulaz, izn_izlaz,
            izn_int_ulaz, izn_int_izlaz,
            izn_storno_izlaz_sup, izn_izlaz_sup,
            izn_dnev_otpis, izn_zav_stanje,
            zad_nab_cijena, pros_nab_cijena, pc,
            post_otpisa, gpor_id, pdv, ppot, ozn_inventure)
           VALUES (
            mt_id_P, inv.nam_id, datum_M,
            inv.kol_zav_stanje,
            0, 0,
            0, 0,
            0, 0,
            0, 0, 0,
            inv.izn_zav_stanje,
            0, 0,
            0, 0,
            0, 0,
            0, 0,
            0, 0, 0,
            0, NULL, 0, 0, ozn_inventure_p);
      END LOOP;
   END IF;
END PRIJEPIS_STARE_INVENTURE;
PROCEDURE OBRADA_ULAZA_IZLAZA
 (MT_ID_P NUMBER
 )
 IS

   brojac_L           NUMBER;
   dat_zadnji_oiart_L DATE;
   ozn_inventure_l  t_inventura.ozn_inventure%TYPE;
BEGIN
   /* trai datum prethodne inventure */
   SELECT MAX (datum) INTO dat_zadnji_oiart_L
     FROM i_inv_ui
    WHERE mt_id = mt_id_P
      AND datum < datum_M;               
   
   
   SELECT ozn_inventure INTO ozn_inventure_l
     FROM t_inventura
    WHERE mt_id = mt_id_P
      AND datum = datum_M;               
   

   /*
   Ako je ovo prva inventura za MT,
   stavlja se "umjetan" datum prethodne inventure
   */
   IF dat_zadnji_oiart_L IS NULL THEN
      /*
      Stavljena funkcija TO_DATE zato to Designer generira
      lo format datuma u PRE-FORM okidau
      */
      dat_zadnji_oiart_L := TO_DATE ('01.01.1990', 'DD.MM.RRRR');
   END IF;

   FOR dui IN (
      SELECT mt_id,
             nam_id,
             SUM (kol_ulaz)                               kol_ulaz,
             SUM (kol_izlaz)                              kol_izlaz,
             SUM (kol_int_ulaz)                           kol_int_ulaz,
             SUM (kol_int_izlaz)                          kol_int_izlaz,
             SUM (kol_storno_izlaz_sup)                   kol_storno_izlaz_sup,
             SUM (kol_izlaz_sup)                          kol_izlaz_sup,
             SUM (kol_dnev_otpis)                         kol_dnev_otpis,
             SUM (izn_ulaz)                               izn_ulaz,
             SUM (kol_izlaz * pros_nab_cijena)            izn_izlaz,
             SUM (izn_int_ulaz)                           izn_int_ulaz,
             SUM (izn_int_izlaz)                          izn_int_izlaz,
             SUM (kol_storno_izlaz_sup * pros_nab_cijena) izn_storno_izlaz_sup,
             SUM (kol_izlaz_sup * pros_nab_cijena)        izn_izlaz_sup,
             SUM (kol_dnev_otpis * pros_nab_cijena)       izn_dnev_otpis
        FROM i_dnev_ui
       WHERE mt_id =  mt_id_P
         AND datum >  dat_zadnji_oiart_L
         AND datum <= datum_M
       GROUP BY
             mt_id,
             nam_id)
   LOOP
      SELECT COUNT (1) INTO brojac_L
        FROM i_inv_ui
       WHERE mt_id  = mt_id_P
         AND datum  = datum_M
         AND nam_id = dui.nam_id;

      IF brojac_L = 0 THEN
         INSERT INTO i_inv_ui (
            mt_id, nam_id, datum,
            kol_poc_stanje, kol_ulaz, kol_izlaz,
            kol_int_ulaz, kol_int_izlaz,
            kol_storno_izlaz_sup, kol_izlaz_sup,
            kol_dnev_otpis, kol_inv_razlika, kol_zav_stanje, -- prazno
            izn_poc_stanje, izn_ulaz, izn_izlaz,
            izn_int_ulaz, izn_int_izlaz,
            izn_storno_izlaz_sup, izn_izlaz_sup,
            izn_dnev_otpis, izn_zav_stanje,
            zad_nab_cijena, pros_nab_cijena, pc,
            post_otpisa, gpor_id, pdv, ppot, ozn_inventure)
           VALUES (
            mt_id_P, dui.nam_id, datum_M,
            0, dui.kol_ulaz, dui.kol_izlaz,
            dui.kol_int_ulaz, dui.kol_int_izlaz,
            dui.kol_storno_izlaz_sup, dui.kol_izlaz_sup,
            dui.kol_dnev_otpis, 0, 0,  -- prazno u dui, osim kad je inventura
            0, dui.izn_ulaz, dui.izn_izlaz,
            dui.izn_int_ulaz, dui.izn_int_izlaz,
            dui.izn_storno_izlaz_sup, dui.izn_izlaz_sup,
            dui.izn_dnev_otpis, 0,
            0, 0, 0,
            0, NULL, 0, 0, ozn_inventure_l);
      ELSE
         UPDATE i_inv_ui
            SET kol_ulaz             = dui.kol_ulaz,
                kol_izlaz            = dui.kol_izlaz,
                kol_int_ulaz         = dui.kol_int_ulaz,
                kol_int_izlaz        = dui.kol_int_izlaz,
                kol_storno_izlaz_sup = dui.kol_storno_izlaz_sup,
                kol_izlaz_sup        = dui.kol_izlaz_sup,
                kol_dnev_otpis       = dui.kol_dnev_otpis,
                izn_ulaz             = dui.izn_ulaz,
                izn_izlaz            = dui.izn_izlaz,
                izn_int_ulaz         = dui.izn_int_ulaz,
                izn_int_izlaz        = dui.izn_int_izlaz,
                izn_storno_izlaz_sup = dui.izn_storno_izlaz_sup,
                izn_izlaz_sup        = dui.izn_izlaz_sup,
                izn_dnev_otpis       = dui.izn_dnev_otpis
         WHERE mt_id  = mt_id_P
           AND datum  = datum_M
           AND nam_id = dui.nam_id;
      END IF;
   END LOOP;
END OBRADA_ULAZA_IZLAZA;
PROCEDURE PRERACUN_INV_STANJA
 (MT_ID_P NUMBER
 ,ID_P NUMBER
 )
 IS

   odnos_jm_b_l NUMBER;
   odnos_jm_n_l NUMBER;
BEGIN
   FOR invart IN (
      SELECT ROWID, sir_id, nam_id, pro_id, 
             kol_inventura
        FROM t_inventura_art
       WHERE inv_id = id_P)
   LOOP
      IF invart.sir_id IS NOT NULL THEN
         SELECT odnos_jm_b, odnos_jm_n
           INTO odnos_jm_b_l, odnos_jm_n_l
           FROM m_sirovine
          WHERE id = invart.sir_id;

         UPDATE t_inventura_art
            SET odnos_jm_b = odnos_jm_b_l,
                odnos_jm_n = odnos_jm_n_l
          WHERE ROWID = invart.ROWID;

         preracun_sirovine (
            mt_id_P,
            invart.sir_id,
            invart.kol_inventura,
            odnos_jm_b_l,
            odnos_jm_n_l);
      ELSIF invart.pro_id IS NOT NULL THEN
         preracun_proizvoda (
            mt_id_P,
            invart.pro_id,
            invart.kol_inventura);
      ELSE
         preracun_namirnice (
            mt_id_P,
            invart.nam_id,
            invart.kol_inventura);
      END IF;
   END LOOP;

   zaj_obr.rastavljanje_proizvoda;

   FOR pom IN (
      SELECT mt_id, nam_id, kolicina
        FROM p_planpot)
   LOOP
      preracun_namirnice(
         pom.mt_id,
         pom.nam_id,
         pom.kolicina);
   END LOOP;

   DELETE p_planpot;
END PRERACUN_INV_STANJA;
PROCEDURE PRERACUN_SIROVINE
 (MT_ID_P NUMBER
 ,SIR_ID_P NUMBER
 ,KOL_INVENTURA_P NUMBER
 ,ODNOS_JM_B_P NUMBER
 ,ODNOS_JM_N_P NUMBER
 )
 IS

   kalo_obrade_L        NUMBER;
   kalo_odmrzavanja_L   NUMBER;
   korigirana_kol_nam_L NUMBER;
   korigirana_kol_sir_L NUMBER;
   pom_br_rastava_L     NUMBER;
BEGIN
   SELECT kalo_obrade, kalo_odmrzavanja
     INTO kalo_obrade_L, kalo_odmrzavanja_L
     FROM m_sirovine
    WHERE id = sir_id_P;

   korigirana_kol_sir_L :=
      zaj_obr.korigirana_kol_sirovine (
         kol_inventura_P,
         odnos_jm_b_P,
         odnos_jm_n_P,
         kalo_odmrzavanja_L,
         kalo_obrade_L);

   FOR ras IN (
      SELECT nam_id, udio_namirnice
        FROM m_rastav
       WHERE sir_id = sir_id_P)
   LOOP
      korigirana_kol_nam_L :=
         zaj_obr.korigirana_kol_namirnice (
            korigirana_kol_sir_L,
            ras.udio_namirnice);

      preracun_namirnice (
         mt_id_P,
         ras.nam_id,
         korigirana_kol_nam_L);
   END LOOP;
END PRERACUN_SIROVINE;
PROCEDURE PRERACUN_PROIZVODA
 (MT_ID_P NUMBER
 ,PRO_ID_P NUMBER
 ,KOL_INVENTURA_P NUMBER
 )
 IS

   kol_recepture_L     NUMBER;
   kolicina_normativ_L NUMBER;
   razina_L            NUMBER;
   brojac_L            NUMBER;
BEGIN
   SELECT kol_recepture INTO kol_recepture_L
     FROM m_proizvodi
    WHERE id = pro_id_P;

   FOR sas IN (
      SELECT nam_id, pro_id_poluproizvod, normativ
        FROM m_sastav
       WHERE pro_id = pro_id_P)
   LOOP
      kolicina_normativ_L :=
         zaj_obr.kolicina_normativ (
            kol_inventura_P,
            sas.normativ,
            kol_recepture_L);

      IF sas.nam_id IS NOT NULL THEN
         preracun_namirnice (
            mt_id_P,
            sas.nam_id,
            kolicina_normativ_L);
      ELSE
         SELECT COUNT (1) INTO brojac_L
           FROM p_planpot
          WHERE mt_id = mt_id_P
            AND nac_id IS NULL
            AND nam_id IS NULL
            AND pro_id = sas.pro_id_poluproizvod;

         IF brojac_L = 0  THEN
            SELECT razina INTO razina_L
              FROM m_proizvodi
             WHERE id = sas.pro_id_poluproizvod;

            INSERT INTO p_planpot (
               mt_id, nac_id, nam_id, pro_id,
               kolicina, razina_proizvoda)
               VALUES (
               mt_id_P, NULL, NULL, sas.pro_id_poluproizvod,
               kolicina_normativ_L, razina_L);
         ELSE
            UPDATE p_planpot
               SET kolicina = kolicina + kolicina_normativ_L
             WHERE mt_id = mt_id_P
               AND nac_id IS NULL
               AND nam_id IS NULL
               AND pro_id = sas.pro_id_poluproizvod;
         END IF;
      END IF;
   END LOOP;
END PRERACUN_PROIZVODA;
PROCEDURE PRERACUN_NAMIRNICE
 (MT_ID_P NUMBER
 ,NAM_ID_P NUMBER
 ,KOL_INVENTURA_P NUMBER
 )
 IS

   brojac_L NUMBER;
BEGIN
   SELECT COUNT (1) INTO brojac_L
     FROM i_inv_ui
    WHERE mt_id  = mt_id_P
      AND datum  = datum_M
      AND nam_id = nam_id_P;

   IF brojac_L = 0 THEN
      INSERT INTO i_inv_ui (
         mt_id, nam_id, datum,
         kol_poc_stanje, kol_ulaz, kol_izlaz,
         kol_int_ulaz, kol_int_izlaz,
         kol_storno_izlaz_sup, kol_izlaz_sup,
         kol_dnev_otpis, kol_inv_razlika, kol_zav_stanje,
         izn_poc_stanje, izn_ulaz, izn_izlaz,
         izn_int_ulaz, izn_int_izlaz,
         izn_storno_izlaz_sup, izn_izlaz_sup,
         izn_dnev_otpis, izn_zav_stanje,
         zad_nab_cijena, pros_nab_cijena, pc,
         post_otpisa, gpor_id, pdv, ppot, ozn_inventure)
        VALUES (
         mt_id_P, nam_id_P, datum_M,
         0, 0, 0,
         0, 0,
         0, 0,
         0, 0, kol_inventura_P,
         0, 0, 0,
         0, 0,
         0, 0,
         0, 0,
         0, 0, 0,
         0, NULL, 0, 0, 'C');
   ELSE
      UPDATE i_inv_ui
         SET kol_zav_stanje = kol_zav_stanje + kol_inventura_P,
             ozn_inventure = 'C'
       WHERE mt_id  = mt_id_P
         AND datum  = datum_M
         AND nam_id = nam_id_P;
   END IF;
END PRERACUN_NAMIRNICE;
PROCEDURE IZRACUN_INVENTURNIH_RAZLIKA
 (MT_ID_P NUMBER
 )
 IS

 
   zaliha_namirnica_l NUMBER;
   kol_inv_razlika_l  NUMBER;
   datum_l            DATE;
   pros_nab_cijena_l  NUMBER;
   zad_nab_cijena_l   NUMBER;
   pc_l               NUMBER;
   post_otpisa_l      NUMBER;
   gpor_id_l          NUMBER;
   pdv_l              NUMBER;
   ppot_l             NUMBER;
   brojac_l NUMBER;
   gmt_id_l NUMBER;
BEGIN
   FOR invui IN (
      SELECT ROWID, nam_id,
             kol_poc_stanje, kol_ulaz, kol_izlaz, kol_int_izlaz,
             kol_int_ulaz, kol_storno_izlaz_sup,
             kol_izlaz_sup, kol_dnev_otpis, kol_zav_stanje, ozn_inventure
        FROM i_inv_ui
       WHERE mt_id = mt_id_P
         AND datum = datum_M)
   LOOP 
     zaliha_namirnica_L :=
           zaj_obr.zaliha_namirnica (
              invui.kol_poc_stanje,
              invui.kol_ulaz,
              invui.kol_izlaz,
              invui.kol_int_ulaz,
              invui.kol_int_izlaz,
              invui.kol_storno_izlaz_sup,
              invui.kol_izlaz_sup,
              invui.kol_dnev_otpis);
      
      /* Ako po djelominoj inventuri (D) nije popisano stanje zaliha ostaje ista i nema inventurnih razlika */        
      IF invui.ozn_inventure = 'D' THEN
         UPDATE i_inv_ui 
            SET kol_zav_stanje = zaliha_namirnica_l
          WHERE ROWID = invui.ROWID; 
         kol_inv_razlika_l  := 0;
      ELSE
         kol_inv_razlika_L := invui.kol_zav_stanje - zaliha_namirnica_L;
      END IF;
      
      SELECT MAX (datum) INTO datum_l
        FROM i_dnev_ui
       WHERE mt_id  = mt_id_p
         AND nam_id = invui.nam_id;

      IF datum_l IS NOT NULL THEN
         SELECT pros_nab_cijena
           INTO pros_nab_cijena_l
           FROM i_dnev_ui
          WHERE mt_id  = mt_id_p
            AND nam_id = invui.nam_id
            AND datum  = datum_l;
      ELSE
         pros_nab_cijena_l := 0;
      END IF;
                                            
      SELECT nam.zad_nab_cijena,
             nam.post_otpisa,
             nam.gpor_id,
             vpispz.stopa,
             gpor.ppot
        INTO zad_nab_cijena_l,   
             post_otpisa_l,
             gpor_id_l,
             pdv_l,
             ppot_l
        FROM m_namirnice nam,
             m_gporez gpor,
             mgas_gpor_raz gporraz,
             s_vpisporukap  vpispp,
             s_vpisporukaz  vpispz
       WHERE nam.id = invui.nam_id
         AND gpor.id = nam.gpor_id
         AND gporraz.gpor_id = nam.gpor_id
         AND datum_M BETWEEN gporraz.dat_valjan AND NVL(gporraz.dat_ponisten, SYSDATE)
         AND vpispp.id = gporraz.vpispp_id
         AND vpispp.vpispz_id = vpispz.id;               
                   
                   
      pc_l := pc_namirnice (mt_id_p, invui.nam_id); 
                
      /* Osim to se aurira inventurna razlika, pune se i drugi stupci */
      UPDATE i_inv_ui
         SET kol_inv_razlika = kol_inv_razlika_l,
             zad_nab_cijena  = zad_nab_cijena_l,
             pros_nab_cijena = pros_nab_cijena_l,
             pc              = pc_l,
             post_otpisa     = post_otpisa_l,
             gpor_id         = gpor_id_l,
             pdv             = pdv_l,
             ppot            = ppot_l,
             izn_zav_stanje  = kol_zav_stanje * pros_nab_cijena_l
       WHERE ROWID = invui.ROWID;
   END LOOP;
END IZRACUN_INVENTURNIH_RAZLIKA;
PROCEDURE IZRACUN_ZALIHA
 IS

   brojac_L NUMBER;
BEGIN
   FOR invui IN (
      SELECT mt_id, nam_id,
             kol_inv_razlika, kol_zav_stanje,
             zad_nab_cijena, pros_nab_cijena
        FROM i_inv_ui
       WHERE datum = datum_M)
   LOOP
      IF invui.kol_inv_razlika <> 0 THEN
         /* Aurira se i_zaliha */
         SELECT COUNT (1) INTO brojac_L
           FROM i_zaliha
          WHERE mt_id  = invui.mt_id
            AND nam_id = invui.nam_id;

         IF brojac_L = 0 THEN
            INSERT INTO i_zaliha (
               mt_id, nam_id, zaliha,
               zad_nab_cijena, pros_nab_cijena)
               VALUES (
               invui.mt_id, invui.nam_id, invui.kol_inv_razlika,
               invui.zad_nab_cijena, invui.pros_nab_cijena);
         ELSE
            UPDATE i_zaliha
               SET zaliha = zaliha + invui.kol_inv_razlika
             WHERE mt_id  = invui.mt_id
               AND nam_id = invui.nam_id;
         END IF;

         /* Aurira se i_dnev_ui_det za inventurne razlike */
         SELECT COUNT (1) INTO brojac_L
           FROM i_dnev_ui_det
          WHERE mt_id  = invui.mt_id
            AND nam_id = invui.nam_id
            AND datum  = datum_M
            AND sir_id IS NULL
            AND pro_id IS NULL
            AND nam_id_supstitut IS NULL
            AND pro_id_supstitut IS NULL;

         IF brojac_L = 0 THEN
            INSERT INTO i_dnev_ui_det (
               mt_id, nam_id, datum, sir_id, pro_id,
               nam_id_supstitut, pro_id_supstitut, kol_ulaz, kol_izlaz,
               kol_int_ulaz, kol_int_izlaz, kol_storno_izlaz_sup,
               kol_izlaz_sup, kol_dnev_otpis,
               kol_inv_razlika, zaliha, izn_ulaz, izn_int_ulaz,
               izn_int_izlaz, pros_nab_cijena, zad_nab_cijena)
               VALUES (
               invui.mt_id, invui.nam_id, datum_M, NULL, NULL,
               NULL, NULL, 0, 0,
               0, 0, 0,
               0, 0,
               invui.kol_inv_razlika, invui.kol_zav_stanje, 0, 0,
               0, invui.pros_nab_cijena, invui.zad_nab_cijena);
         ELSE
            /*
            Nije toan stari komentar:
            "Ovaj UPDATE se moe desiti samo ako je inventura prethodno ponitena,
            jer samo inventura kreira redak koji ima NULL u sva 4 polja: sir_id, pro_id, nam_id_supstitut, pro_id_supstitut"
            zato jer (direktan) ulaz namirnice, prijelaz namirnice i dr. isto upisuje NULL u navedena 4 polja.
            */
            UPDATE i_dnev_ui_det
               SET kol_inv_razlika = invui.kol_inv_razlika,
                   zaliha          = invui.kol_zav_stanje,
                   pros_nab_cijena = invui.pros_nab_cijena,
                   zad_nab_cijena  = invui.zad_nab_cijena
             WHERE mt_id  = invui.mt_id
               AND nam_id = invui.nam_id
               AND datum  = datum_M
               AND sir_id IS NULL
               AND pro_id IS NULL
               AND nam_id_supstitut IS NULL
               AND pro_id_supstitut IS NULL;
         END IF;

         /* Aurira se i_dnev_ui za inventurne razlike */
         SELECT COUNT (1) INTO brojac_L
           FROM i_dnev_ui
          WHERE mt_id  = invui.mt_id
            AND nam_id = invui.nam_id
            AND datum  = datum_M;

         IF brojac_L = 0 THEN
            INSERT INTO i_dnev_ui (
               mt_id, nam_id, datum, kol_ulaz, kol_izlaz,
               kol_int_ulaz, kol_int_izlaz, kol_storno_izlaz_sup,
               kol_izlaz_sup, kol_dnev_otpis,
               kol_inv_razlika, zaliha, izn_ulaz, izn_int_ulaz,
               izn_int_izlaz, pros_nab_cijena, zad_nab_cijena)
               VALUES (
               invui.mt_id, invui.nam_id, datum_M, 0, 0,
               0, 0, 0,
               0, 0,
               invui.kol_inv_razlika, invui.kol_zav_stanje, 0, 0,
               0, invui.pros_nab_cijena, invui.zad_nab_cijena);
         ELSE
            UPDATE i_dnev_ui
               SET kol_inv_razlika = invui.kol_inv_razlika,
                   zaliha          = invui.kol_zav_stanje,
                   pros_nab_cijena = invui.pros_nab_cijena,
                   zad_nab_cijena  = invui.zad_nab_cijena
             WHERE mt_id  = invui.mt_id
               AND nam_id = invui.nam_id
               AND datum  = datum_M;
         END IF;
      END IF;
   END LOOP;

   /* auriranje zaliha na razini instalacije u namirnicama */
   zaj_obr.izracun_zaliha_instalacije;
END IZRACUN_ZALIHA;
PROCEDURE IZRACUNAJ_INVENTURU_TRGOVINE
 (DATUM_P DATE
 )
 IS
   obrada_gas_l nst_gas_obrada.obrada_gas%TYPE;
BEGIN
  SELECT obrada_gas 
    INTO obrada_gas_L
    FROM nst_gas_obrada;
    
  IF obrada_gas_L = 'N' THEN
     RETURN;
  END IF; 
  
  pra_nst_gas.inventura (datum_p);
  
  
END IZRACUNAJ_INVENTURU_TRGOVINE;
FUNCTION DAT_ZADNJEG_OIART
 RETURN DATE
 IS

   dat_zadnji_oiart_L DATE;
BEGIN
   SELECT MAX (datum) INTO dat_zadnji_oiart_L
     FROM l_obracun
    WHERE oznaka = '40';

   RETURN dat_zadnji_oiart_L;
END DAT_ZADNJEG_OIART;
PROCEDURE PROVJERA_DATUMA
 (DATUM_P DATE
 )
 IS

   dat_zadnji_oiart_L DATE;
   dat_zadnji_do_L DATE;
   brojac_L NUMBER;
BEGIN
   /* obraun inventure ne smije biti ve napravljen */
   dat_zadnji_oiart_L := dat_zadnjeg_oiart;
   IF dat_zadnji_oiart_L IS NOT NULL
      AND datum_P = dat_zadnji_oiart_L
   THEN
      gas_zaj.vrati_poruku (-20052);
   END IF;

   /* mora biti napravljen dnevni obraun */
   SELECT MAX (datum) INTO dat_zadnji_do_L
     FROM l_obracun
    WHERE oznaka = '00';

   IF dat_zadnji_do_L IS NULL THEN
      gas_zaj.vrati_poruku (-20057);
   ELSIF datum_P <> dat_zadnji_do_L THEN
      gas_zaj.vrati_poruku (-20059);
   END IF;

   /* mora postojati barem jedan dokument inventure */
   SELECT COUNT (1) INTO brojac_L
     FROM t_inventura
    WHERE datum = datum_P;

   IF brojac_L = 0 THEN
      gas_zaj.vrati_poruku (-20053);
   END IF;
END PROVJERA_DATUMA;
PROCEDURE START_OBRACUNA_INVENTURE
 (DATUM_P DATE
 )
 IS

   brojac_L NUMBER;
   obrada_gas_l VARCHAR2(1);
   datum_pinv_L DATE;
BEGIN
   /* lock in exclusive mode */
   gas_zaj.zakljucaj_obracun;
   /* zbog AUR replikacijskog okidaa namirnica */
   obrada_u_toku_M := TRUE;

   provjera_datuma (datum_P); 
 
   datum_M := TRUNC (datum_P); -- TRUNC vjerojatno ne treba

   FOR inv IN (
      SELECT id, datum, mt_id, ozn_inventure
        FROM t_inventura
       WHERE datum = datum_M)
   LOOP
      /* inventura se ne radi ako dokument nema barem jednu stavku */
      SELECT COUNT (1) INTO brojac_L
        FROM t_inventura_art
       WHERE inv_id = inv.id;

      IF brojac_L <> 0 THEN 
         /* brisanje pomone tablice ineventure  */
         DELETE FROM i_inv_ui_zam WHERE datum = datum_M;
         prijepis_stare_inventure (inv.mt_id, inv.ozn_inventure);
         obrada_ulaza_izlaza (inv.mt_id );
         preracun_inv_stanja (inv.mt_id, inv.id);
         izracun_inventurnih_razlika (inv.mt_id);                 
         
         /* Knjii li se PDV-a na otpise i inventurne manjkove: da ili ne.*/
         IF pra_zmp_zaj.zmppar_vrijednost ('GAS', '1045') = 'da'  THEN
            razrada_inv_razlika (inv.mt_id); 
         END IF;
         
      END IF;
   END LOOP;

   izracun_zaliha; -- procedura radi za sva MT

   izracunaj_inventuru_trgovine(datum_p);  
   
   IF  TO_CHAR(TO_DATE(datum_M), 'DDMM') =  '3112' THEN  
    
     SELECT obrada_gas 
       INTO obrada_gas_L
       FROM nst_gas_obrada;
    
     IF obrada_gas_L = 'D' THEN  
      /* za sluaj ako je poetno stanje napravljeno sa DO potrebno je brisanje */
         pra_nst_gas.ponisti_pocetno_stanje (datum_m + 1);
         pra_nst_gas.pocetno_stanje (datum_m +1);
     END IF;
   END IF;
  
      
   INSERT INTO l_obracun
      (datum, oznaka)
      VALUES
      (datum_M, '40');

   COMMIT;
END START_OBRACUNA_INVENTURE;
FUNCTION OBRADA_U_TOKU
 RETURN BOOLEAN
 IS
BEGIN
   RETURN obrada_u_toku_M;
END;
PROCEDURE RAZRADA_INV_RAZLIKA
 (MT_ID_P IN M_MT.ID%TYPE
 )
 IS
brojac_l  NUMBER;
opis_l  t_inventura.opis80%TYPE;
sifra_l  m_namirnice.sifra%TYPE;
naziv_l  m_namirnice.naziv%TYPE;
jm_l     m_namirnice.jm%TYPE;
mt_naziv_l  t_inventura.opis80%TYPE;
vrijednost_l szmp_parametri.vrijednost%TYPE;
stara_kol_inv_razlika_l i_inv_ui.kol_inv_razlika%TYPE;
BEGIN 
  /* dobivena inventurna razlika prepisuje se u tablicu t_inv_razlika radi daljne razrade,
     takoer se pamti i kol_tolerancije koja je kao apsolutni iznos zapisana u m_namirnice,
     ili kao % prometa izraunata u odnosu na promet zadnje inventure.
     (kol_inv_tolerancije se ne pamti u i_invu_ui)
  */
  
   SELECT sifra ||' '||naziv 
     INTO mt_naziv_l
     FROM m_mt
    WHERE id = mt_id_p;
     
   SELECT opis80
     INTO opis_l
     FROM t_inventura
    WHERE mt_id = mt_id_p
      AND datum = datum_M;
        
  IF NVL(opis_l,'1') NOT LIKE 'ZAKLJ%' THEN
     /* Ako inventura nije oznaena da je zakljuna, tada se
        prethodna inventura razrada brie 
     */
     DELETE t_inv_razlike WHERE mt_id = mt_id_p AND datum = datum_M;
                 
     INSERT INTO t_inv_razlike (
        mt_id, nam_id, datum,
        kol_inv_razlika,
        kol_tolerancije,
        kol_teret_pc,
        zad_nab_cijena, pros_nab_cijena, pc, pdv, ppot,
        kol_inv_visak)
        --- kol_inv_razlike aljemo sa round 3
        SELECT
          invui.mt_id, invui.nam_id, invui.datum,
          DECODE(SIGN(ROUND(invui.kol_inv_razlika,3)),-1,ROUND(invui.kol_inv_razlika * -1, 3),0), -- za viak se stavlja 0 jer je polje naknadno dodano u tablicu i postoje CK
          DECODE(SIGN(ROUND(invui.kol_inv_razlika,3)),-1, tolerancija(invui.mt_id, invui.nam_id, ROUND(invui.kol_inv_razlika,3)),0), -- kol_tolerancije
          DECODE (SIGN(invui.kol_inv_razlika),-1,
                ROUND(DECODE(SIGN(tolerancija(invui.mt_id, invui.nam_id, ROUND(invui.kol_inv_razlika,3)) + invui.kol_inv_razlika),
                               -1, (tolerancija(invui.mt_id, invui.nam_id, ROUND(invui.kol_inv_razlika,3)) + invui.kol_inv_razlika) * -1,  1, 0, 0, 0),3),
                 0),-- kol_teret_pc
               invui.zad_nab_cijena, invui.pros_nab_cijena, invui.pc, invui.pdv, invui.ppot,
               DECODE(SIGN(ROUND(invui.kol_inv_razlika, 3)),-1,0,ROUND(invui.kol_inv_razlika, 3))
          FROM i_inv_ui invui,
               m_namirnice nam
         WHERE invui.datum = datum_M
           AND invui.mt_id = mt_id_p
           AND invui.nam_id = nam.id
           AND ROUND(invui.kol_inv_razlika, 3) <> 0;
        
  ELSE  
     /* Ako je prethodna obrada inventura(za isto MT i datum)  NVL(tinvraz.kol_inv_razlika,0) <> oznaena kao ZAKLJUNA, tada se inventurne razlike tekue inventure
        usporeuje sa razradom inventure (koja je oznaena kao ZAKLJUNA), ako postoji razlika koliina i PNC javlja se poruka.
        Prodajna cijena se ne usporeuje jer se moe izmijeniti (MGAS_GMT_PRO)
     */
     FOR i IN (
       SELECT invui.nam_id inam_id,  invui.datum, tinvraz.nam_id tnam_id,
              NVL(ROUND(invui.kol_inv_razlika,3),0)  irazlika, 
              NVL(tinvraz.kol_inv_razlika,0)         trazlika,
              invui.pros_nab_cijena                  ipros_nab_cijena,
              tinvraz.pros_nab_cijena                tpros_nab_cijena,
              tinvraz.kol_inv_visak                  tkol_inv_visak
         FROM i_inv_ui invui,
              t_inv_razlike tinvraz
        WHERE invui.mt_id(+) = mt_id_p
          AND invui.datum    = datum_M
          AND mt_id_p        = tinvraz.mt_id(+)
          AND invui.nam_id   = tinvraz.nam_id(+)
          AND invui.datum    = tinvraz.datum(+)
          AND ((ROUND(invui.kol_inv_razlika,3)) <> 0 OR  
               tinvraz.kol_inv_razlika <> 0 OR 
               tinvraz.kol_inv_visak   <> 0 ))
     LOOP
       SELECT sifra, naziv, jm
         INTO sifra_l, naziv_l, jm_l
         FROM m_namirnice
        WHERE id = i.inam_id;

       IF i.tkol_inv_visak > 0  THEN
          stara_kol_inv_razlika_l := i.tkol_inv_visak;
       ELSE
          stara_kol_inv_razlika_l := i.trazlika;
       END IF;
   
       /* Na mjestu troka #0 za namirnicu #1 po ovoj obradi inventurna razlika je #2, a po zakljunoj  inventuri je #3. */
       IF (i.irazlika < 0 AND  ABS(i.irazlika) <> i.trazlika ) OR
          (i.irazlika > 0 AND  i.irazlika  <> i.tkol_inv_visak)
           THEN
           gas_zaj.vrati_poruku (-20432, mt_naziv_l, sifra_l||' '||naziv_l, TO_CHAR(i.irazlika, '9990.000')||' '||jm_l,  TO_CHAR(stara_kol_inv_razlika_l,'9990.000')  ||' '||jm_l);
       END IF;
         
       /* Na mjestu troka #0 za namirnicu #1 po ovoj obradi PNC je #2, po zakljunoj obradi PNC je #3.*/
       IF i.ipros_nab_cijena <> i.tpros_nab_cijena THEN
          gas_zaj.vrati_poruku (-20514, mt_naziv_l, sifra_l||' '||naziv_l, TO_CHAR(i.ipros_nab_cijena,'9990.00'), TO_CHAR(i.tpros_nab_cijena, '9990.00'));
       END IF;       
     END LOOP;
     
  END IF;   
END;
FUNCTION PC_NAMIRNICE
 (MT_ID_P IN NUMBER
 ,NAM_ID_P IN NUMBER
 )
 RETURN NUMBER
 IS
brojac_l NUMBER:=0;
  pc_l m_proizvodi.pc1%TYPE:=0;
  mt_vrsta_l m_mt.vrsta%TYPE;
BEGIN

  SELECT vrsta INTO mt_vrsta_l
    FROM m_mt
   WHERE id = mt_id_p;
    
  SELECT count(*)
    INTO brojac_l
    FROM (SELECT sas.pro_id, count(*)
            FROM m_sastav sas, m_sastav sas1
           WHERE sas.pro_id = sas1.pro_id
             AND sas1.nam_id = nam_id_p
          HAVING count(*) > 1
           GROUP BY  sas.pro_id);

   /* Ako je jedina namirnica rauna se PC iz asortimana kase
    */
   IF brojac_l  =  0 THEN
      SELECT NVL(MAX(asokase.pc * pro.kol_recepture/sas.normativ),pc_l)
        INTO pc_l
        FROM m_sastav sas, m_aso_kase asokase, m_proizvodi pro
       WHERE sas.pro_id = asokase.pro_id
         AND sas.nam_id = nam_id_p
         AND sas.pro_id = pro.id
         AND asokase.mt_id = mt_id_p;
   END IF;
   /* Za trgovaku robu se uzima iz kalkulacija
   */
   IF mt_vrsta_l = 'U' THEN
      SELECT count(*) INTO brojac_l
        FROM tnst_brkalk_gas
       WHERE godina = TO_CHAR(datum_M, 'YYYY')
         AND mt_id = mt_id_p
         AND nam_id = nam_id_p
         AND mal_cijena > 0;

      IF brojac_l > 0 THEN
         SELECT mal_cijena INTO pc_l
           FROM tnst_brkalk_gas
          WHERE godina = TO_CHAR(datum_M, 'YYYY')
            AND mt_id = mt_id_p
            AND nam_id = nam_id_p
            AND mal_cijena > 0;
                 
      END IF;
   END IF; 
      
   /* Ako je cijena upisana kao PC namirnice tada nadjaava izraun i kalkulacije
   */
   SELECT count(*) INTO brojac_l
     FROM mgas_gmt_nam gmtnam,
          m_mt mt
    WHERE gmtnam.nam_id = nam_id_p
      AND mt.gmt_id = gmtnam.gmt_id
      AND mt.id = mt_id_p;
        
    IF brojac_l = 1 THEN
       SELECT pc INTO pc_l
         FROM mgas_gmt_nam gmtnam,
              m_mt mt
        WHERE gmtnam.nam_id = nam_id_p
          AND mt.gmt_id = gmtnam.gmt_id
          AND mt.id = mt_id_p;
    END IF;
    
   RETURN pc_l;

   END;
FUNCTION TOLERANCIJA
 (MT_ID_P IN NUMBER
 ,NAM_ID_P IN NUMBER
 ,KOL_MANJAK_P i_inv_ui.kol_inv_razlika%TYPE
 )
 RETURN NUMBER
 IS
vrijednost_L            szmp_parametri.vrijednost%TYPE;
  kol_tolerancije_L       t_inv_razlike.kol_tolerancije%TYPE;
  stopa_inv_tolerancije_L m_namirnice.stopa_inv_tolerancije%TYPE;
  datum_inv_L             t_inventura.datum%TYPE; 
  nam_jm_l                m_namirnice.jm%TYPE;
BEGIN
  /* Nain izrauna inventurne tolerancije manjka (na teret poduzea): 1= apsolutni iznos, 2 = prema % prodaje ili nebitno.
  */
  vrijednost_L := pra_zmp_zaj.zmppar_vrijednost ('GAS', '1072');

  IF vrijednost_L NOT IN ('nebitno', '1', '2') THEN -- nema tolerancije
     /* Nisu postavljeni parametri aplikacije */
     gas_zaj.vrati_poruku ('-20027');
  END IF;

  IF vrijednost_L = 'nebitno' THEN
     kol_tolerancije_l:= 0;                                 
  ELSIF vrijednost_l = '1' THEN   -- koliina
     SELECT ABS(DECODE(SIGN(nam.kol_inv_tolerancije + kol_manjak_P), 
                          1, ABS(kol_manjak_P),
                         -1, nam.kol_inv_tolerancije, 
                          0, nam.kol_inv_tolerancije)),
            jm              
       INTO kol_tolerancije_L, nam_jm_l
       FROM m_namirnice nam
      WHERE id = nam_id_P;
      
  ELSIF vrijednost_L = '2' THEN   -- postotak prometa 
     SELECT stopa_inv_tolerancije, jm
       INTO stopa_inv_tolerancije_L, nam_jm_l
       FROM m_namirnice 
      WHERE id = nam_id_P;
      
      IF nam_jm_l IN ('KOM') THEN
         kol_tolerancije_l := ROUND(kol_tolerancije_l,0);
      END IF;
      
     IF stopa_inv_tolerancije_L = 0 THEN
        kol_tolerancije_L := 0;
     ELSE
        SELECT MAX(datum)
          INTO datum_inv_L
          FROM i_inv_ui
         WHERE mt_id  = mt_id_P
           AND nam_id = nam_id_P
           AND datum  < datum_M
           AND ozn_inventure = 'C';

        IF datum_inv_l IS NULL THEN
            /* Ako namirnica nije popisana na prethodnim inventuri tada se uzima ukupan izlaz od pojave te namirnice u prometu
            */
           SELECT SUM(dui.kol_izlaz - dui.kol_storno_izlaz_sup + dui.kol_izlaz_sup) * stopa_inv_tolerancije_L/100.00
             INTO kol_tolerancije_L
             FROM i_dnev_ui dui
            WHERE mt_id  = mt_id_P 
              AND nam_id = nam_id_P   
              AND datum <= datum_M;            
        ELSE   
            /* Uzima se promet od zadnje inventure na kojoj je napravljen popis
            */
           SELECT SUM(dui.kol_izlaz - dui.kol_storno_izlaz_sup + dui.kol_izlaz_sup) * stopa_inv_tolerancije_L/100.00
             INTO kol_tolerancije_L
             FROM i_dnev_ui dui
            WHERE mt_id  = mt_id_P
              AND nam_id = nam_id_P
              AND datum  BETWEEN datum_inv_L AND datum_M;
           /* Tolerancije ne moe biti vea od manjka 
           */
           IF kol_tolerancije_L >= ABS(kol_manjak_P) THEN
              kol_tolerancije_L := ABS(kol_manjak_P);            
           END IF;
        END IF; -- izraun prometa
     END IF; -- izraun pomou postotka  
  END IF; -- nain odreivanja tolerancije
   
  
  RETURN ROUND(kol_tolerancije_l,3);         
  
 END;
END BM_GAS3050;
/
SHOW ERROR

